/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/Device','sap/ui/core/Control','sap/ui/core/Element','sap/ui/core/IconPool','sap/ui/core/IntervalTrigger','sap/ui/core/library','sap/ui/core/Popup','sap/ui/core/ResizeHandler','sap/ui/core/ScrollBar','sap/ui/core/delegate/ItemNavigation','sap/ui/core/theming/Parameters','sap/ui/model/ChangeReason','sap/ui/model/Context','sap/ui/model/Filter','sap/ui/model/SelectionModel','sap/ui/model/Sorter','./Column','./Row','./library','./TableUtils','./TableExtension','./TableAccExtension','./TableKeyboardExtension','./TablePointerExtension','jquery.sap.dom','jquery.sap.trace'],function(q,D,C,E,I,a,c,P,R,S,b,d,e,f,F,g,h,k,m,n,T,o,p,r,s){"use strict";var G=n.GroupEventType,N=n.NavigationMode,t=n.SelectionBehavior,u=n.SelectionMode,v=n.SharedDomRef,w=n.SortOrder,V=n.VisibleRowCountMode;var M,x;var y=C.extend("sap.ui.table.Table",{metadata:{library:"sap.ui.table",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'auto'},rowHeight:{type:"int",group:"Appearance",defaultValue:null},columnHeaderHeight:{type:"int",group:"Appearance",defaultValue:null},columnHeaderVisible:{type:"boolean",group:"Appearance",defaultValue:true},visibleRowCount:{type:"int",group:"Appearance",defaultValue:10},firstVisibleRow:{type:"int",group:"Appearance",defaultValue:0},selectionMode:{type:"sap.ui.table.SelectionMode",group:"Behavior",defaultValue:u.MultiToggle},selectionBehavior:{type:"sap.ui.table.SelectionBehavior",group:"Behavior",defaultValue:t.RowSelector},selectedIndex:{type:"int",group:"Appearance",defaultValue:-1},editable:{type:"boolean",group:"Behavior",defaultValue:true},navigationMode:{type:"sap.ui.table.NavigationMode",group:"Behavior",defaultValue:N.Scrollbar},threshold:{type:"int",group:"Appearance",defaultValue:100},enableColumnReordering:{type:"boolean",group:"Behavior",defaultValue:true},enableGrouping:{type:"boolean",group:"Behavior",defaultValue:false},showColumnVisibilityMenu:{type:"boolean",group:"Appearance",defaultValue:false},showNoData:{type:"boolean",group:"Appearance",defaultValue:true},visibleRowCountMode:{type:"sap.ui.table.VisibleRowCountMode",group:"Appearance",defaultValue:V.Fixed},minAutoRowCount:{type:"int",group:"Appearance",defaultValue:5},fixedColumnCount:{type:"int",group:"Appearance",defaultValue:0},fixedRowCount:{type:"int",group:"Appearance",defaultValue:0},fixedBottomRowCount:{type:"int",group:"Appearance",defaultValue:0},enableColumnFreeze:{type:"boolean",group:"Behavior",defaultValue:false},enableCellFilter:{type:"boolean",group:"Behavior",defaultValue:false},showOverlay:{type:"boolean",group:"Appearance",defaultValue:false},enableSelectAll:{type:"boolean",group:"Behavior",defaultValue:true},enableCustomFilter:{type:"boolean",group:"Behavior",defaultValue:false},enableBusyIndicator:{type:"boolean",group:"Behavior",defaultValue:false}},defaultAggregation:"columns",aggregations:{title:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false},footer:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false},toolbar:{type:"sap.ui.core.Toolbar",multiple:false},extension:{type:"sap.ui.core.Control",multiple:true,singularName:"extension"},columns:{type:"sap.ui.table.Column",multiple:true,singularName:"column",bindable:"bindable"},rows:{type:"sap.ui.table.Row",multiple:true,singularName:"row",bindable:"bindable"},noData:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false}},associations:{groupBy:{type:"sap.ui.table.Column",multiple:false},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{rowSelectionChange:{parameters:{rowIndex:{type:"int"},rowContext:{type:"object"},rowIndices:{type:"int[]"},selectAll:{type:"boolean"},userInteraction:{type:"boolean"}}},columnSelect:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"}}},columnResize:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},width:{type:"sap.ui.core.CSSSize"}}},columnMove:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},newPos:{type:"int"}}},sort:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},sortOrder:{type:"sap.ui.table.SortOrder"},columnAdded:{type:"boolean"}}},filter:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},value:{type:"string"}}},group:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"}}},columnVisibility:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},visible:{type:"boolean"}}},cellClick:{allowPreventDefault:true,parameters:{cellControl:{type:"sap.ui.core.Control"},cellDomRef:{type:"Object"},rowIndex:{type:"int"},columnIndex:{type:"int"},columnId:{type:"string"},rowBindingContext:{type:"sap.ui.model.Context"}}},cellContextmenu:{allowPreventDefault:true,parameters:{cellControl:{type:"sap.ui.core.Control"},cellDomRef:{type:"Object"},rowIndex:{type:"int"},columnIndex:{type:"int"},columnId:{type:"string"},rowBindingContext:{type:"sap.ui.model.Context"}}},columnFreeze:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"}}},customFilter:{column:{type:"sap.ui.table.Column"},value:{type:"string"}},firstVisibleRowChanged:{firstVisibleRow:{type:"int"}},busyStateChanged:{busy:{type:"boolean"}}},designTime:true}});I.insertFontFaceStyle();y.prototype.init=function(){this._iBaseFontSize=parseFloat(q("body").css("font-size"))||16;this._oResBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.table");this._bRtlMode=sap.ui.getCore().getConfiguration().getRTL();this._attachExtensions();this._bBindingLengthChanged=false;this._mTimeouts={};this.setNoDataText=function(j){if(!(this.getNoData()instanceof C)){this.setNoData(j);}q.sap.log.error("Function setNoDataText of control sap.ui.table.Table must not be used!");return this;};this._lastCalledUpdateRows=0;this._iBindingTimerDelay=50;var i=this;this._performUpdateRows=function(j){if(!i.bIsDestroyed){i._lastCalledUpdateRows=Date.now();i._updateBindingContexts(undefined,undefined,j);if(!i._bInvalid){if(i._updateTableContent){i._updateTableContent();}i._getAccExtension().updateAccForCurrentCell(false);i._updateSelection();i._updateGroupHeader();var l=i._collectTableSizes();i._updateRowHeader(l.tableRowHeights);i._syncColumnHeaders(l);if(T.isVariableRowHeightEnabled(i)){i._adjustTablePosition();}if(i._bBindingLengthChanged||T.isVariableRowHeightEnabled(i)){i._updateVSb(l);}}i._mTimeouts.bindingTimer=undefined;i.fireEvent("_rowsUpdated");}i._bBindingLengthChanged=false;};this._initSelectionModel(g.MULTI_SELECTION);this._iColMinWidth=20;if('ontouchstart'in document){this._iColMinWidth=88;}this._aTableHeaders=[];this._aIdxCols2Cells=[];this._aVisibleColumns=[];this._iLastFixedColIndex=-1;this._bInheritEditableToControls=false;this._bAllowColumnHeaderTextSelection=false;this._bjQueryLess18=q.sap.Version(q.fn.jquery).compareTo("1.8")<0;this._iDataRequestedCounter=0;this._iBindingLength=0;this._iTableRowContentHeight=0;this._bFirstRendering=true;this._bInvalid=true;this._bIsScrollVertical=null;};y.prototype._attachExtensions=function(){if(this._bExtensionsInitialized){return;}o.enrich(this,s);o.enrich(this,r);o.enrich(this,p);this._bExtensionsInitialized=true;};y.prototype.exit=function(){this._bExitCalled=true;if(this._oPaginator){this._oPaginator.destroy();}this._resetRowTemplate();this._detachExtensions();this._cleanUpTimers();this._detachEvents();};y.prototype._detachExtensions=function(){if(!this._bExtensionsInitialized){return;}this._getPointerExtension().destroy();this._getKeyboardExtension().destroy();this._getAccExtension().destroy();delete this._bExtensionsInitialized;};y.prototype.onThemeChanged=function(){if(this.getDomRef()){this.invalidate();}};y.prototype._collectRowHeights=function(){var j=this.getDomRef();if(!j){return[];}var l=j.querySelectorAll(".sapUiTableCtrlFixed > tbody > tr");var z=j.querySelectorAll(".sapUiTableCtrlScroll > tbody > tr");var A=[];for(var i=0;i<z.length;i++){var B=0;if(l[i]){var H=l[i].getBoundingClientRect();B=H.bottom-H.top;}var J=z[i].getBoundingClientRect();var K=J.bottom-J.top;A.push(Math.max(B,K));}return A;};y.prototype._resetRowHeights=function(){var j=this.getRowHeight();var l="";if(j){l=j+"px";}var z=this.getDomRef();if(z){var A=z.querySelectorAll(".sapUiTableCtrlFixed > tbody > tr, .sapUiTableCtrlScroll > tbody > tr");for(var i=0;i<A.length;i++){A[i].style.height=l;}}};y.prototype._determineAvailableSpace=function(){var i=this.getDomRef();if(i&&i.parentNode){var j=i.querySelector(".sapUiTableCCnt");if(j){var U=i.scrollHeight-j.clientHeight;return q(i.parentNode).height()-U;}}return 0;};y.prototype._collectTableSizes=function(j){var l={tableCtrlScrollWidth:0,tableRowHdrScrWidth:0,tableCtrlRowScrollTop:0,tableCtrlRowScrollHeight:0,tableCtrlScrWidth:0,tableHSbScrollLeft:0,tableCtrlFixedWidth:0,tableCntHeight:0,tableCntWidth:0,columnRowHeight:0,columnRowOuterHeight:0,invisibleColWidth:0};var z=this.getDomRef();if(!z){return l;}var A=z.querySelector(".sapUiTableCnt");if(A){l.tableCntHeight=A.clientHeight;l.tableCntWidth=A.clientWidth;}var B=z.querySelector(".sapUiTableCtrlScroll");if(B){l.tableCtrlScrollWidth=B.clientWidth;}var H=z.querySelector(".sapUiTableRowHdrScr");if(H){l.tableRowHdrScrWidth=H.clientWidth;}var J=z.querySelector(".sapUiTableCtrl.sapUiTableCtrlRowScroll.sapUiTableCtrlScroll");if(J){l.tableCtrlRowScrollTop=J.offsetTop;l.tableCtrlRowScrollHeight=J.offsetHeight;}var K=z.querySelector(".sapUiTableCtrlScr");if(K){l.tableCtrlScrWidth=K.clientWidth;}var L=this.getDomRef(v.HorizontalScrollBar);if(L){l.tableHSbScrollLeft=L.scrollLeft;}var O=z.querySelector(".sapUiTableCtrlFixed");if(O){l.tableCtrlFixedWidth=O.clientWidth;}var Q=this.getProperty("fixedColumnCount");var U=[];var W=0;var X=z.querySelectorAll(".sapUiTableCtrlFirstCol > th:not(.sapUiTableColSel)");if(X){for(var i=0;i<X.length;i++){var Y=X[i].getBoundingClientRect();var Z=Y.right-Y.left;U.push(Z);if(i<Q){W+=Z;}}}if(Q>0){var $=0;var _=this.getDomRef("sapUiTableRowHdrScr");if(_){$+=_.clientWidth;}var a1=this.getDomRef("vsb");if(a1){$+=a1.offsetWidth;}var b1=(z.clientWidth-$<W);if(this._bIgnoreFixedColumnCount!=b1){this._bIgnoreFixedColumnCount=b1;this.invalidate();}}l.headerWidths=U;if(this.getSelectionMode()!==u.None&&this.getSelectionBehavior()!==t.RowOnly){var c1=z.querySelector(".sapUiTableCtrlFirstCol > th:first-child");if(c1){l.invisibleColWidth=c1.clientWidth;}}function d1(e1){l.columnRowHeight=Math.max(e1.clientHeight||0,l.columnRowHeight);l.columnRowOuterHeight=Math.max(e1.offsetHeight||0,l.columnRowOuterHeight);}Array.prototype.forEach.call(z.querySelectorAll(".sapUiTableCol"),d1);if(!j){l.tableRowHeights=this._collectRowHeights();}else{l.tableRowHeights=j;}return l;};y.prototype._updateRowHeader=function(j){var l=this.getDomRef();if(!l){return;}var z=l.querySelectorAll(".sapUiTableRowHdr");var A=l.querySelectorAll(".sapUiTableCtrlFixed > tbody > tr");var B=l.querySelectorAll(".sapUiTableCtrlScroll > tbody > tr");var L=Math.max(z.length,B.length,0);for(var i=0;i<L;i++){var H=j[i];if(H){if(z[i]){z[i].style.height=H+"px";}if(A[i]){A[i].style.height=H+"px";}if(B[i]){B[i].style.height=H+"px";}}}};y.prototype.onBeforeRendering=function(i){if(i&&i.isMarked("insertTableRows")){return;}if(this._mTimeouts.bindingTimer){this._updateBindingContexts();}this._cleanUpTimers();this._detachEvents();var j=this.getVisibleRowCountMode();if(T.isVariableRowHeightEnabled(this)){var l=this.getDomRef(v.VerticalScrollBar);if(l){this._iOldScrollTop=l.scrollTop;}}var z=this.getRows();if(j==V.Interactive||j==V.Fixed||(j==V.Auto&&this._iTableRowContentHeight&&z.length==0)){if(this.getBinding("rows")){this._adjustRows(this._calculateRowsToDisplay());}else{var A=this;this._mTimeouts.onBeforeRenderingAdjustRows=this._mTimeouts.onBeforeRenderingAdjustRows||window.setTimeout(function(){A._adjustRows(A._calculateRowsToDisplay());A._mTimeouts.onBeforeRenderingAdjustRows=undefined;},0);}}else if(!this._oRowTemplate&&z.length>0){this._adjustRows(z.length);}};y.prototype.onAfterRendering=function(j){if(j&&j.isMarked("insertTableRows")){return;}this._iDefaultRowHeight=undefined;this._bInvalid=false;this._bOnAfterRendering=true;var $=this.$();this._attachEvents();this._initRowDomRefs();var z=this.getColumns();for(var i=0,l=z.length;i<l;i++){if(z[i].getVisible()){z[i]._restoreIcons();}}if(!this._bAllowColumnHeaderTextSelection){this._disableTextSelection($.find(".sapUiTableColHdrCnt"));}this._bOnAfterRendering=false;this._getKeyboardExtension().invalidateItemNavigation();if(this._bFirstRendering&&this.getVisibleRowCountMode()==V.Auto){this._bFirstRendering=false;Promise.resolve().then(this._updateTableSizes.bind(this,true));}else if(!this._mTimeouts.onAfterRenderingUpdateTableSizes){this._updateTableSizes();}if(T.isVariableRowHeightEnabled(this)){var A=this.getDomRef(v.VerticalScrollBar);if(A){A.scrollTop=Math.max(A.scrollTop,this._iOldScrollTop);}}this._updateGroupHeader();if(this._updateTableContent){this._updateTableContent();}if(this.getBinding("rows")){this.fireEvent("_rowsUpdated");}};y.prototype.invalidate=function(){if(!this._ignoreInvalidateOfChildControls){this._bInvalid=true;var i=C.prototype.invalidate.call(this);}return i;};y.prototype._initRowDomRefs=function(){var j=this.getRows();for(var i=0;i<j.length;i++){j[i].initDomRefs();}};y.prototype._updateTableSizes=function(i,j){this._mTimeouts.onAfterRenderingUpdateTableSizes=undefined;var l=this.getDomRef();if(this._bInvalid||!l){return;}this._resetRowHeights();var z=this._collectRowHeights();this._getDefaultRowHeight(z);var A=0;if(!j&&this.getVisibleRowCountMode()==V.Auto){A=this._determineAvailableSpace();if(this._handleRowCountModeAuto(A)&&!i){return;}}T.deregisterResizeHandler(this,"");this._toggleVSb();var B=this._collectTableSizes(z);if(this._mTimeouts.afterUpdateTableSizes){window.clearTimeout(this._mTimeouts.afterUpdateTableSizes);}if(B.tableCntHeight==0&&B.tableCntWidth==0){T.registerResizeHandler(this,"",this._onTableResize.bind(this),true);return;}this._updateRowHeader(B.tableRowHeights);this._syncColumnHeaders(B);this._determineVisibleCols(B);if(!j){this._setRowContentHeight(A);}this._updateHSb(B);this._updateVSb(B);this.$().find(".sapUiTableNoOpacity").addBack().removeClass("sapUiTableNoOpacity");if(this._mTimeouts.afterUpdateTableSizes){window.clearTimeout(this._mTimeouts.afterUpdateTableSizes);}var H=this;this._mTimeouts.afterUpdateTableSizes=window.setTimeout(function(){T.registerResizeHandler(H,"",H._onTableResize.bind(H),true);},0);};y.prototype.setShowOverlay=function(i){i=!!i;this.setProperty("showOverlay",i,true);if(this.getDomRef()){var j=document.activeElement;this.$().toggleClass("sapUiTableOverlay",i);this._getAccExtension().updateAriaStateForOverlayAndNoData();this._getKeyboardExtension().updateNoDataAndOverlayFocus(j);}return this;};y.prototype._updateGroupHeader=function(){var i=this;if(this._modifyRow){q.each(this.getRows(),function(j,l){i._modifyRow(j+i.getFirstVisibleRow(),l.$());i._modifyRow(j+i.getFirstVisibleRow(),l.$("fixed"));});}};y.prototype._updateFixedBottomRows=function(){var j=this.getFixedBottomRowCount();var l=this.getDomRef();if(l&&j>0){var $=q(l).find(".sapUiTableFixedPreBottomRow");$.removeClass("sapUiTableFixedPreBottomRow");var B=this.getBinding("rows");if(B){var z=this.getVisibleRowCount();var A=false;var H=this.getRows();var J=this._getSanitizedFirstVisibleRow();for(var i=0;i<H.length;i++){var K=H[i].getDomRefs(true);if(this._iBindingLength>=z){A=(i==z-j-1);}else{A=(J+i)==(this._iBindingLength-j-1)&&(J+i)<this._iBindingLength;}K.row.toggleClass("sapUiTableFixedPreBottomRow",A);}}}};y.prototype.getFocusInfo=function(){var i=this.$().find(":focus").attr("id");if(i){return{customId:i};}else{return E.prototype.getFocusInfo.apply(this,arguments);}};y.prototype.applyFocusInfo=function(i){if(i&&i.customId){this.$().find("#"+i.customId).focus();}else{E.prototype.getFocusInfo.apply(this,arguments);}return this;};y.prototype.setTitle=function(i){var j=i;if(typeof(i)==="string"||i instanceof String){j=n.TableHelper.createTextView({text:i,width:"100%"});j.addStyleClass("sapUiTableHdrTitle");}this.setAggregation("title",j);return this;};y.prototype.setFooter=function(i){var j=i;if(typeof(i)==="string"||i instanceof String){j=n.TableHelper.createTextView({text:i,width:"100%"});}this.setAggregation("footer",j);return this;};y.prototype.setSelectionMode=function(i){this.clearSelection();if(i===u.Single){this._oSelection.setSelectionMode(g.SINGLE_SELECTION);}else{this._oSelection.setSelectionMode(g.MULTI_SELECTION);}if(i===u.Multi){i=u.MultiToggle;q.sap.log.warning("The selection mode 'Multi' is deprecated and must not be used anymore. Your setting was defaulted to selection mode 'MultiToggle'");}this.setProperty("selectionMode",i);return this;};y.prototype._adjustTablePosition=function(){var i=this.getDomRef(v.VerticalScrollBar).scrollTop;var j=this._getDefaultRowHeight();var l=i%j;var z=this.$().find(".sapUiTableCtrlRowScroll, .sapUiTableRowHdrScr");if(this._iBindingLength<=this.getVisibleRowCount()){z.css({"transform":"translate3d(0px, "+(-i)+"px, 0px)"});}else{var A=this._calculateRowCorrection(j,l,i);z.css({"transform":"translate3d(0px, "+(-A)+"px, 0px)"});}};y.prototype._calculateRowCorrection=function(i,j,l){var z=this.getFirstVisibleRow();var A=this._iBindingLength-this.getVisibleRowCount();if(z<A){var B=T.getRowHeightByIndex(this,0)-i;return Math.floor(j*(B/i))+j;}else if(z==A){return l-(this._iBindingLength*i)+this.getDomRef("tableCCnt").clientHeight;}};y.prototype.setFirstVisibleRow=function(i,O,j){if(this.getNavigationMode()==sap.ui.table.NavigationMode.Paginator){var l=this.getVisibleRowCount();var z=this._paginatorCalculateTargetPage(i,l);var A=(z-1)*l;if(i!=A){i=A;z=this._paginatorCalculateTargetPage(i,l);}this._paginatorUpdate(z);}var B=this.getFirstVisibleRow()!=i;this.setProperty("firstVisibleRow",i,true);if(T.isVariableRowHeightEnabled(this)&&this.getBinding("rows")&&!this._bRefreshing&&!B){this._adjustTablePosition();}if(B&&this.getBinding("rows")&&!this._bRefreshing){this.updateRows();if(this.getNavigationMode()==N.Scrollbar){if(!O){var H=this.getDomRef(v.VerticalScrollBar);if(H){H.scrollTop=i*(this._getDefaultRowHeight()||28);}}}}if(B&&!j){this.fireFirstVisibleRowChanged({firstVisibleRow:i});}return this;};y.getMetadata().getAggregation("rows")._doesNotRequireFactory=true;y.prototype.bindRows=function(B,i,j,l){if(typeof B==="string"&&(i instanceof h||q.isArray(j)&&j[0]instanceof F)){l=j;j=i;i=undefined;}return this.bindAggregation("rows",B,i,j,l);};y.prototype._bindAggregation=function(i,j,l,z,A){E.prototype._bindAggregation.apply(this,arguments);var B=this.getBinding("rows");if(i==="rows"&&B){B.attachChange(this._onBindingChange,this);}this._initSelectionModel(g.MULTI_SELECTION);if(B&&this.isTreeBinding("rows")&&!B.hasListeners("selectionChanged")){B.attachSelectionChanged(this._onSelectionChanged,this);}return this;};y.prototype._initSelectionModel=function(i){if(this._oSelection){this._oSelection.detachSelectionChanged(this._onSelectionChanged,this);}this._oSelection=new g(i);this._oSelection.attachSelectionChanged(this._onSelectionChanged,this);return this;};y.prototype._onBindingChange=function(i){var j=typeof(i)==="object"?i.getParameter("reason"):i;if(j==="sort"||j==="filter"){this.clearSelection();this.setFirstVisibleRow(0);}};y.prototype.unbindAggregation=function(i,j){var B=this.getBinding("rows");if(i==="rows"&&this.isBound("rows")){j=true;}var l=E.prototype.unbindAggregation.apply(this,[i,j]);if(i==="rows"&&B){this._restoreAppDefaultsColumnHeaderSortFilter();this._invalidateColumnMenus();this._updateBindingLength();this.updateRows("unbindAggregation");}return l;};y.prototype.setVisibleRowCount=function(i){if(i!=null&&!isFinite(i)){return this;}var j=this.getVisibleRowCountMode();if(j==V.Auto){q.sap.log.error("VisibleRowCount will be ignored since VisibleRowCountMode is set to Auto",this);return this;}var l=this.getFixedRowCount()+this.getFixedBottomRowCount();if(i<=l&&l>0){q.sap.log.error("Table: "+this.getId()+" visibleRowCount('"+i+"') must be bigger than number of fixed rows('"+(this.getFixedRowCount()+this.getFixedBottomRowCount())+"')",this);return this;}i=this.validateProperty("visibleRowCount",i);if(this.getBinding("rows")&&this.getBinding("rows").getLength()<=i){this.setProperty("firstVisibleRow",0);}this.setProperty("visibleRowCount",i);this._setRowContentHeight(i*this._getDefaultRowHeight());return this;};y.prototype.setTooltip=function(i){q.sap.log.warning("The aggregation tooltip is not supported for sap.ui.table.Table");return this.setAggregation("tooltip",i,true);};y.prototype.setNavigationMode=function(){this.setProperty("navigationMode",N.Scrollbar,true);q.sap.log.error("The navigationMode property is deprecated and must not be used anymore. Your setting was defaulted to 'Scrollbar'",this);};y.prototype._getFixedBottomRowContexts=function(i,B){var j=this.getBinding("rows");var l=[];if(!j){return l;}i=i||this.getFixedBottomRowCount();B=B||j.getLength();var z=this.getVisibleRowCount();if(i>0&&(z-i)<B){l=this._getContexts(B-i,i,1);}return l;};y.prototype._getFixedRowContexts=function(i){i=i||this.getFixedRowCount();if(i>0){return this._getContexts(0,i);}else{return[];}};y.prototype._getContexts=function(i,l,j){var B=this.getBinding("rows");if(B){return B.getContexts(i,l,j);}else{return[];}};y.prototype._getRowContexts=function(j,l,z){var A=false;var B=[];var H=this.getBinding("rows");var J=j||this.getRows().length;if(!H||J<=0){return[];}var K=this.getFirstVisibleRow();var L=this.getFixedRowCount();var O=this.getFixedBottomRowCount();var Q=0;var U;var W=J-O;var X=0;var Y=W;var Z=this.getThreshold();Z=Z?Math.max(J,Z):0;var $=K;var _=function(e1,f1,$){for(var i=0;i<f1.length;i++){e1[$+i]=f1[i];}};if(L>0&&K>0){$=K+L;W-=L;X=L;U=this._getFixedRowContexts(L);Q+=U.length;B=B.concat(U);}U=this._getContexts($,W,Z);var a1=this._updateBindingLength(z);A=U.length<Math.min(W,a1-O);if(this.getNavigationMode===N.Paginator){var b1=Math.min(W,(Math.max(a1-K-O,0)));if(b1<W){W=b1;U=U.slice(0,W);}}Q+=U.length;_(B,U,X);Y=Math.min(Y,Math.max(a1-O,0));if(O>0){U=this._getFixedBottomRowContexts(O,a1);Q+=U.length;_(B,U,Y);}if(A&&!l){var c1=this._getSanitizedFirstVisibleRow(true);if(K!=c1){B=this._getRowContexts(J,true);Q=B.length;}}if(!l){var d1=this;if(this._mTimeouts.getContextsSetBusy){window.clearTimeout(this._mTimeouts.getContextsSetBusy);}this._mTimeouts.getContextsSetBusy=window.setTimeout(function(){d1._setBusy({requestedLength:L+W+O,receivedLength:Q,contexts:B,reason:z});},0);}return B;};y.prototype._getSanitizedFirstVisibleRow=function(U){var i=this.getNavigationMode();var j=this.getVisibleRowCount();var l=this.getFirstVisibleRow();l=Math.max(l,0);if(i===N.Scrollbar&&this._iBindingLength>0&&!T.isVariableRowHeightEnabled(this)){l=Math.min(l,Math.max(this._iBindingLength-j,0));}else if(i===N.Paginator&&this._oPaginator){var z=this._paginatorCalculateTargetPage(l,j);l=(z-1)*j;if(U){this._paginatorUpdate(z);}}if(U){this.setProperty("firstVisibleRow",l,true);}return l;};y.prototype._paginatorCalculateTargetPage=function(i,j){if(this._oPaginator){var l=1;if(i<this._iBindingLength){l=Math.ceil((i+1)/j);}return l;}};y.prototype._paginatorUpdate=function(i){if(this._oPaginator&&i!==this._oPaginator.getCurrentPage()){this._oPaginator.setCurrentPage(i);if(this._oPaginator.getDomRef()){this._oPaginator.rerender();}}};y.prototype._updateBindingLength=function(i){var B=this.getBinding("rows");var j=0;if(B){j=B.getLength();}if(j!=this._iBindingLength){this._iBindingLength=j;this._onBindingLengthChange(i);}return j;};y.prototype._onBindingLengthChange=function(i){this._updateFixedBottomRows();this._toggleVSb();this._bBindingLengthChanged=true;if(i!="skipNoDataUpdate"){this._updateNoData();}};y.prototype.refreshRows=function(i){var B=this.getBinding("rows");if(!B){q.sap.log.error("RefreshRows must not be called without a binding",this);return;}var j=this;var l=typeof(i)==="object"?i.getParameter("reason"):i;if(l==e.Refresh){this._attachBindingListener();}this._bBusyIndicatorAllowed=true;var z=this.getVisibleRowCountMode();if((this.bOutput&&z===V.Auto)||z!==V.Auto){var A=this._calculateRowsToDisplay();if(this.bOutput){this.getBinding("rows").attachEventOnce("dataRequested",function(){if(j._mTimeouts.refreshRowsAdjustRows){window.clearTimeout(j._mTimeouts.refreshRowsAdjustRows);}j._mTimeouts.refreshRowsAdjustRows=window.setTimeout(function(){j._adjustRows(A,true);},0);});}var U;if(l==e.Filter||l==e.Sort){U="skipNoDataUpdate";this.setFirstVisibleRow(0);}this._updateBindingContexts(true,A,U);}};y.prototype.updateRows=function(i){if(this._bExitCalled){return;}this._setBusy(i?{changeReason:i}:false);if(this._bBindingLengthChanged){this._updateNoData();}var j=this.getVisibleRowCountMode();if((this.getRows().length<=0||!this._oRowTemplate)&&((j==V.Auto&&this.bOutput)||j!=V.Auto)){if(this._iTableRowContentHeight){this._adjustRows(this._calculateRowsToDisplay());}}if(!this.bIsDestroyed){var B=(i==e.Change||(!this._mTimeouts.bindingTimer&&Date.now()-this._lastCalledUpdateRows>this._iBindingTimerDelay)||i=="unbindAggregation"?0:this._iBindingTimerDelay);var l=this;if(B==0&&i){Promise.resolve().then(function(){l._performUpdateRows(i);});}else{this._mTimeouts.bindingTimer=this._mTimeouts.bindingTimer||window.setTimeout(function(){l._performUpdateRows(i);},B);}}};y.prototype.insertRow=function(){q.sap.log.error("The control manages the rows aggregation. The method \"insertRow\" cannot be used programmatically!",this);};y.prototype.addRow=function(){q.sap.log.error("The control manages the rows aggregation. The method \"addRow\" cannot be used programmatically!",this);};y.prototype.removeRow=function(){q.sap.log.error("The control manages the rows aggregation. The method \"removeRow\" cannot be used programmatically!",this);};y.prototype.removeAllRows=function(){q.sap.log.error("The control manages the rows aggregation. The method \"removeAllRows\" cannot be used programmatically!",this);};y.prototype.destroyRows=function(){q.sap.log.error("The control manages the rows aggregation. The method \"destroyRows\" cannot be used programmatically!",this);};y.prototype.autoResizeColumn=function(i){this._getPointerExtension().doAutoResizeColumn(i);};y.prototype._attachEvents=function(){var $=this.$();$.find(".sapUiTableColHdrScr").scroll(q.proxy(this._oncolscroll,this));$.find(".sapUiTableCtrlScr").scroll(q.proxy(this._oncntscroll,this));$.find(".sapUiTableCtrlScrFixed").scroll(q.proxy(this._oncntscroll,this));$.find(".sapUiTableCtrlScrFixed, .sapUiTableColHdrFixed").on("scroll.sapUiTablePreventFixedAreaScroll",function(l){l.target.scrollLeft=0;});if(T.isVariableRowHeightEnabled(this)){$.find(".sapUiTableCCnt").on("scroll.sapUiTablePreventCCntScroll",function(l){l.target.scrollTop=0;});}$.find(".sapUiTableRowHdr").hover(function(){q(this).addClass("sapUiTableRowHvr");var l=$.find(".sapUiTableRowHdr").index(this);$.find(".sapUiTableCtrlFixed > tbody > tr").filter(":eq("+l+")").addClass("sapUiTableRowHvr");$.find(".sapUiTableCtrlScroll > tbody > tr").filter(":eq("+l+")").addClass("sapUiTableRowHvr");},function(){q(this).removeClass("sapUiTableRowHvr");$.find(".sapUiTableCtrlFixed > tbody > tr").removeClass("sapUiTableRowHvr");$.find(".sapUiTableCtrlScroll > tbody > tr").removeClass("sapUiTableRowHvr");});$.find(".sapUiTableCtrlFixed > tbody > tr").hover(function(){q(this).addClass("sapUiTableRowHvr");var l=$.find(".sapUiTableCtrlFixed > tbody > tr").index(this);$.find(".sapUiTableRowHdr").filter(":eq("+(l)+")").addClass("sapUiTableRowHvr");$.find(".sapUiTableCtrlScroll > tbody > tr").filter(":eq("+l+")").addClass("sapUiTableRowHvr");},function(){q(this).removeClass("sapUiTableRowHvr");$.find(".sapUiTableRowHdr").removeClass("sapUiTableRowHvr");$.find(".sapUiTableCtrlScroll > tbody > tr").removeClass("sapUiTableRowHvr");});$.find(".sapUiTableCtrlScroll > tbody > tr").hover(function(){q(this).addClass("sapUiTableRowHvr");var l=$.find(".sapUiTableCtrlScroll > tbody > tr").index(this);$.find(".sapUiTableRowHdr").filter(":eq("+l+")").addClass("sapUiTableRowHvr");$.find(".sapUiTableCtrlFixed > tbody > tr").filter(":eq("+l+")").addClass("sapUiTableRowHvr");},function(){q(this).removeClass("sapUiTableRowHvr");$.find(".sapUiTableRowHdr").removeClass("sapUiTableRowHvr");$.find(".sapUiTableCtrlFixed > tbody > tr").removeClass("sapUiTableRowHvr");});this._getPointerExtension().initColumnResizeEvents();var i=q(this.getDomRef(v.VerticalScrollBar));var j=q(this.getDomRef(v.HorizontalScrollBar));i.bind("scroll.sapUiTableVScroll",this.onvscroll.bind(this));j.bind("scroll.sapUiTableHScroll",this.onhscroll.bind(this));j.bind("mousedown.sapUiTableHScroll",function(l){l.preventDefault();});i.bind("mousedown.sapUiTableVScroll",function(l){l.preventDefault();});if(D.browser.firefox){this._getScrollTargets().bind("MozMousePixelScroll.sapUiTableMouseWheel",this._onMouseWheel.bind(this));}else{this._getScrollTargets().bind("wheel.sapUiTableMouseWheel",this._onMouseWheel.bind(this));}if(sap.ui.getCore().getConfiguration().getAnimation()){q("body").bind('webkitTransitionEnd transitionend',q.proxy(function(l){if(q(l.target).has($).length>0){this._iDefaultRowHeight=undefined;this._updateTableSizes();}},this));}};y.prototype._detachEvents=function(){var $=this.$();$.find(".sapUiTableRowHdrScr").unbind();$.find(".sapUiTableCtrl > tbody > tr").unbind();$.find(".sapUiTableRowHdr").unbind();this._getPointerExtension().cleanupColumnResizeEvents();$.find(".sapUiTableCtrlScrFixed, .sapUiTableColHdrFixed").unbind("scroll.sapUiTablePreventFixedAreaScroll");if(T.isVariableRowHeightEnabled(this)){$.find(".sapUiTableCCnt").unbind("scroll.sapUiTablePreventCCntScroll");}var i=q(this.getDomRef(v.VerticalScrollBar));i.unbind("scroll.sapUiTableVScroll");i.unbind("mousedown.sapUiTableVScroll");var j=q(this.getDomRef(v.HorizontalScrollBar));j.unbind("scroll.sapUiTableHScroll");j.unbind("mousedown.sapUiTableHScroll");var l=this._getScrollTargets();l.unbind("MozMousePixelScroll.sapUiTableMouseWheel");l.unbind("wheel.sapUiTableMouseWheel");var z=q(document.body);z.unbind('webkitTransitionEnd transitionend');T.deregisterResizeHandler(this);};y.prototype._getScrollTargets=function(){var $=q(this.getDomRef("sapUiTableCtrlScr"));var i=q(this.getDomRef("rsz"));var j=q(this.getDomRef("sapUiTableCtrlScrFixed"));var l=q(this.getDomRef("sapUiTableRowHdrScr"));return $.add(j).add(l).add(i);};y.prototype._cleanUpTimers=function(){for(var K in this._mTimeouts){if(this._mTimeouts[K]){clearTimeout(this._mTimeouts[K]);this._mTimeouts[K]=undefined;}}};y.prototype._updateHSb=function(i){var $=this.$();var j=i.tableCtrlScrollWidth;if(!!D.browser.safari){j=Math.max(j,this._getColumnsWidth(this.getFixedColumnCount()));}if(j>i.tableCtrlScrWidth){if(!$.hasClass("sapUiTableHScr")){$.addClass("sapUiTableHScr");if(!!D.browser.safari){var l=$.find(".sapUiTableCtrlScroll, .sapUiTableColHdrScr > .sapUiTableColHdr");if(this._bjQueryLess18){l.width(j);}else{l.outerWidth(j);}}}var z=i.tableCtrlFixedWidth;if($.find(".sapUiTableRowHdrScr").length>0){z+=i.tableRowHdrScrWidth;}if(this.getRows().length>0){var A=$.find(".sapUiTableHSb");if(this._bRtlMode){A.css('margin-right',z+'px');}else{A.css('margin-left',z+'px');}}var H=this.getDomRef("hsb-content");if(H){H.style.width=j+"px";}}else{if($.hasClass("sapUiTableHScr")){$.removeClass("sapUiTableHScr");if(!!D.browser.safari){$.find(".sapUiTableCtrlScroll, .sapUiTableColHdr").css("width","");}}}};y.prototype._updateVSb=function(i){var j=this.getDomRef(v.VerticalScrollBar);if(!j){return;}var l=this.getFixedRowCount();var z=this.getFixedBottomRowCount();if(l>0||z>0){var $=q(j);if(l>0){$.css('top',(i.tableCtrlRowScrollTop-1)+'px');}if(z>0){$.css('height',i.tableCtrlRowScrollHeight+'px');}}var A=this._getDefaultRowHeight();var B=(this._iBindingLength-l-z)*A;if(T.isVariableRowHeightEnabled(this)){var H=0;var J=this.getDomRef("tableCCnt");if(J){H=J.clientHeight;}var K=0;var L=this.getDomRef("table");if(L){K=L.clientHeight;}this._iRowHeightsDelta=K-H-T.getRowHeightByIndex(this,this.getRows().length-1);if(this._iBindingLength<=this.getVisibleRowCount()){B=this._iRowHeightsDelta+(this.getVisibleRowCount()*A);}else{B=this._iRowHeightsDelta+B;}this._toggleVSb();}this.getDomRef("vsb-content").style.height=B+"px";if(!T.isVariableRowHeightEnabled(this)){j.scrollTop=this._getSanitizedFirstVisibleRow()*A;}};y.prototype._toggleVSb=function(){var $=this.$();var B=this.getBinding("rows");if(this._oPaginator&&this.getNavigationMode()===N.Paginator){var i=0;var j=0;if(B){var l=this.getVisibleRowCount();i=Math.ceil((this._iBindingLength||0)/l);var z=Math.min(i,Math.ceil((this.getFirstVisibleRow()+1)/l));this.setProperty("firstVisibleRow",(Math.max(z,1)-1)*l,true);j=z;}this._oPaginator.setNumberOfPages(i);this._oPaginator.setCurrentPage(j);if(this._oPaginator.getDomRef()){this._oPaginator.rerender();}if(this.getDomRef()){$.removeClass("sapUiTableVScr");}}else if(this.getDomRef()){$.toggleClass("sapUiTableVScr",this._isVSbRequired());}};y.prototype._isVSbRequired=function(){if(this.getNavigationMode()===N.Scrollbar){if(T.isVariableRowHeightEnabled(this)&&this._iRowHeightsDelta>0){return true;}if(this.getBinding("rows")&&this._iBindingLength>this.getVisibleRowCount()){return true;}}return false;};y.prototype._updateBindingContexts=function(i,j,l){var z=this.getRows(),B=this.getBinding("rows"),A=this.mBindingInfos["rows"],H;if(B){H=this._getRowContexts(j,false,l);}if(!i){var J=this.getFirstVisibleRow();var K=typeof this._updateTableCell==="function";this._resetRowHeights();for(var L=z.length-1;L>=0;L--){var O=H?H[L]:undefined;var Q=z[L];if(Q){var U=J+L;this._updateRowBindingContext(Q,O,A&&A.model,U,K,B);}}}};y.prototype._updateRowBindingContext=function(j,z,A,B,H,J){j.setRowBindingContext(z,A,J);if(H){var K=j.getCells();for(var i=0,l=K.length;i<l;i++){if(K[i]){this._updateTableCell(K[i],z,K[i].$().closest("td"),B);}}}};y.prototype._updateNoData=function(){if(!this.getDomRef()){return;}var i=document.activeElement;this.$().toggleClass("sapUiTableEmpty",T.isNoDataVisible(this));this._getAccExtension().updateAriaStateForOverlayAndNoData();this._getKeyboardExtension().updateNoDataAndOverlayFocus(i);};y.prototype._determineVisibleCols=function(j){var $=this.$();if($.hasClass("sapUiTableHScr")){var z=this._bRtlMode;var A=j.tableHSbScrollLeft;var B=j.tableCtrlScrollWidth;var H=j.tableCtrlScrWidth;if(z&&D.browser.firefox&&A<0){A=A*-1;}var J=A+H;if(this._iOldScrollLeft!==A||this._iOldScrollRight!==J||this._bForceVisibleColCalc){var L=z?B:0;if((D.browser.internet_explorer||D.browser.firefox)&&z){L=0;}this._aVisibleColumns=[];for(var i=0,l=this.getFixedColumnCount();i<l;i++){this._aVisibleColumns.push(i);}var K=j.headerWidths;for(var i=0;i<K.length;i++){var O=K[i];if(z&&D.browser.chrome){L-=O;}if(L+O>=A&&L<=J){this._aVisibleColumns.push(i);}if(!z||(D.browser.internet_explorer||D.browser.firefox)){L+=O;}}this._iOldScrollLeft=A;this._iOldScrollRight=J;this._bForceVisibleColCalc=false;}}else{this._aVisibleColumns=[];var Q=this.getColumns();for(var i=0,l=Q.length;i<l;i++){if(Q[i].shouldRender()){this._aVisibleColumns.push(i);}}}};y.prototype.removeColumn=function(i,j){var l=this.removeAggregation('columns',i,j);this._bDetermineVisibleCols=true;if(typeof i==="number"&&i>-1){i=this.getColumns()[i];}var z=q.inArray(i,this._aSortedColumns);if(this._iNewColPos===undefined&&z>=0){this._aSortedColumns.splice(z,1);}this._resetRowTemplate();return l;};y.prototype.removeAllColumns=function(){var i=this.removeAllAggregation('columns');this._aSortedColumns=[];this._resetRowTemplate();return i;};y.prototype.destroyColumns=function(){var i=this.destroyAggregation('columns');this._aSortedColumns=[];this._resetRowTemplate();return i;};y.prototype.addColumn=function(i,j){var l=this;this.addAggregation('columns',i,j);i.attachEvent('_widthChanged',function(z){l._bForceVisibleColCalc=true;});this._bDetermineVisibleCols=true;this._resetRowTemplate();return this;};y.prototype.insertColumn=function(i,j,l){var z=this;this.insertAggregation('columns',i,j,l);i.attachEvent('_widthChanged',function(){z._bForceVisibleColCalc=true;});this._bDetermineVisibleCols=true;this._resetRowTemplate();return this;};y.prototype._getRowCount=function(){return this._iBindingLength;};y.prototype._getSelectableRowCount=function(){return this._iBindingLength;};y.prototype._getFirstVisibleRowByScrollTop=function(i){var j=this.getDomRef(v.VerticalScrollBar);if(j){i=(typeof i==="undefined")?j.scrollTop:i;if(T.isVariableRowHeightEnabled(this)){if(this.getVisibleRowCount()>=this._iBindingLength){return 0;}else{return Math.min(this._iBindingLength-this.getVisibleRowCount(),Math.floor(i/this._getDefaultRowHeight()));}}else{return Math.ceil(i/this._getDefaultRowHeight());}}else{if(this.getNavigationMode()===N.Paginator){return(((this._oPaginator.getCurrentPage()||1)-1)*this.getVisibleRowCount());}else{return 0;}}};y.prototype._getVisibleColumns=function(){var j=[];var z=this.getColumns();for(var i=0,l=z.length;i<l;i++){if(z[i].shouldRender()){j.push(z[i]);}}return j;};y.prototype._getColumnsWidth=function(j,z){var A=this.getColumns();var B=0;if(j!==0&&!j){j=0;}if(z!==0&&!z){z=A.length;}for(var i=j,l=z;i<l;i++){if(A[i]&&A[i].shouldRender()){B+=this._CSSSizeToPixel(A[i].getWidth());}}return B;};y.prototype._CSSSizeToPixel=function(i,j){var l=this._iColMinWidth;if(i){if(q.sap.endsWith(i,"px")){l=parseInt(i,10);}else if(q.sap.endsWith(i,"em")||q.sap.endsWith(i,"rem")){l=Math.ceil(parseFloat(i)*this._getBaseFontSize());}}if(j){return l+"px";}else{return parseInt(l,10);}};y.prototype._getBaseFontSize=function(){return this._iBaseFontSize;};y.prototype._onTableResize=function(){if(this._bInvalid||!this.getDomRef()){return;}this._updateTableSizes();};y.prototype._handleRowCountModeAuto=function(i){var B=this.getBinding("rows");if(B&&this.getRows().length>0){return this._executeAdjustRows(i);}else{var j=this;var l=!this._mTimeouts.handleRowCountModeAutoAdjustRows;var z=j.getBusyIndicatorDelay();var A=this.getEnableBusyIndicator();if(B&&A){j.setBusyIndicatorDelay(0);j.setBusy(true);}if(i){this._setRowContentHeight(i);}this._mTimeouts.handleRowCountModeAutoAdjustRows=this._mTimeouts.handleRowCountModeAutoAdjustRows||window.setTimeout(function(){if(!j._executeAdjustRows()){j._updateTableSizes(false,true);}j._mTimeouts.handleRowCountModeAutoAdjustRows=undefined;if(A){j.setBusy(false);j.setBusyIndicatorDelay(z);}},0);return l;}};y.prototype._executeAdjustRows=function(i){i=i||this._determineAvailableSpace();var j=this._calculateRowsToDisplay(i);if(j==this._determineMinAutoRowCount()){this.$().height("auto");}else{this.$().height("0px");}return this._adjustRows(j);};y.prototype._syncColumnHeaders=function(l){var z=this.getDomRef();if(!z){return;}var $=this.$();var H=l.headerWidths;var A=this.getFixedColumnCount();var B=this._getVisibleColumns();if(B.length==0){return;}var J=$.find(".sapUiTableColHdr");var K=$.find(".sapUiTableColHdrScr");var L=J.find(".sapUiTableCol");var O=$.find(".sapUiTableCtrlFirstCol > th:not(.sapUiTableColSel)");this._aTableHeaders=O;var Q={};O.each(function(Y,Z){var _=Z.getAttribute("data-sap-ui-headcolindex");var a1=H[Y];var b1;var c1=B[Y];if(c1){b1=a1;}if(Y==0||Y==A){b1+=Math.max(0,l.invisibleColWidth);}var d1=B[Y]?B[Y].getHeaderSpan():1,e1=[],f1;if(d1){if(!q.isArray(d1)){d1=[d1];}q.each(d1,function(h1,i1){d1[h1]=Math.max(i1,1);});f1=d1;}else{f1=[1];}for(var i=0;i<f1.length;i++){e1[i]={width:b1,span:1};for(var j=1;j<f1[i];j++){var g1=O[Y+j];if(g1){e1[i].width+=H[Y+j];e1[i].span=f1[i];}}}if(c1){Q[_]={domRefColumnTh:Z,domRefColumnDivs:[],aHeaderData:e1};}});var U=this;L.each(function(i,j){var Y=parseInt(j.getAttribute("data-sap-ui-colindex"),10);var Z=Q[Y];if(Z){Z.domRefColumnDivs.push(j);}else{q.sap.log.error("Inconsistent DOM / Control Tree combination",U);}});q.each(Q,function(j,Y){for(var i=0;i<Y.domRefColumnDivs.length;i++){var Z=Y.aHeaderData[0];if(Y.aHeaderData[i]){Z=Y.aHeaderData[i];}if(Y.domRefColumnDivs[i]){Y.domRefColumnDivs[i].style.width=Z.width+"px";Y.domRefColumnDivs[i].setAttribute("data-sap-ui-colspan",Z.span);}else{q.sap.log.error("Inconsistent DOM / Control Tree combination",U);}}});var W=this.getColumnHeaderHeight()>0;if(!W){L.each(function(i,j){j.style.height=l.columnRowOuterHeight+"px";});var X=z.querySelector(".sapUiTableColHdrCnt");if(X){X.style.height=Math.floor(l.columnRowHeight*T.getHeaderRowCount(this))+"px";}}K.each(function(i,j){j.style.width=l.tableCtrlScrWidth+"px";});};y.prototype._disableTextSelection=function(i){q(i||document.body).attr("unselectable","on").css({"-moz-user-select":"none","-webkit-user-select":"none","user-select":"none"}).bind("selectstart",function(j){j.preventDefault();return false;});};y.prototype._enableTextSelection=function(i){q(i||document.body).attr("unselectable","off").css({"-moz-user-select":"","-webkit-user-select":"","user-select":""}).unbind("selectstart");};y.prototype._clearTextSelection=function(){if(window.getSelection){if(window.getSelection().empty){window.getSelection().empty();}else if(window.getSelection().removeAllRanges){window.getSelection().removeAllRanges();}}else if(document.selection&&document.selection.empty){try{document.selection.empty();}catch(i){}}};y.prototype.onvscroll=function(i){var j=this;q.sap.interaction.notifyScrollEvent&&q.sap.interaction.notifyScrollEvent(i);this._getKeyboardExtension().setActionMode(false);if(this._bLargeDataScrolling&&!this._bIsScrolledByWheel){window.clearTimeout(this._mTimeouts.scrollUpdateTimerId);this._mTimeouts.scrollUpdateTimerId=window.setTimeout(function(){j.setFirstVisibleRow(j._getFirstVisibleRowByScrollTop(),true);j._mTimeouts._sScrollUpdateTimerId=null;},300);}else{this.setFirstVisibleRow(this._getFirstVisibleRowByScrollTop(),true);}this._bIsScrolledByWheel=false;};y.prototype.onpscroll=function(i){q.sap.interaction.notifyScrollEvent&&q.sap.interaction.notifyScrollEvent(i);this._getKeyboardExtension().setActionMode(false);var j=0;if(this.getNavigationMode()===N.Paginator){j=(((this._oPaginator.getCurrentPage()||1)-1)*this.getVisibleRowCount());}this.setFirstVisibleRow(j,true);};y.prototype._onMouseWheel=function(i){var O=i.originalEvent;var j=O.shiftKey;var l=0;if(D.browser.firefox){l=O.detail;}else{if(j){l=O.deltaX;}else{l=O.deltaY;}}if(j){var H=this.getDomRef(v.HorizontalScrollBar);if(H){H.scrollLeft=H.scrollLeft+l;}}else{var z=this.getDomRef(v.VerticalScrollBar);if(z){this._bIsScrolledByWheel=true;z.scrollTop=z.scrollTop+l;}}i.preventDefault();i.stopPropagation();};y.prototype._syncHeaderAndContent=function(i){if(!this._bSyncScrollLeft){this._bSyncScrollLeft=true;var $=this.$();var H=i.tableHSbScrollLeft;$.find(".sapUiTableColHdrScr").scrollLeft(H);$.find(".sapUiTableCtrlScr").scrollLeft(H);this._bSyncScrollLeft=false;}};y.prototype.onhscroll=function(i){q.sap.interaction.notifyScrollEvent&&q.sap.interaction.notifyScrollEvent(i);if(!this._bOnAfterRendering){if(this._mTimeouts.hScrollUpdateTimer){window.clearTimeout(this._mTimeouts.hScrollUpdateTimer);}this._mTimeouts.hScrollUpdateTimer=window.setTimeout(function(){var j=this._collectTableSizes();this._syncHeaderAndContent(j);this._determineVisibleCols(j);}.bind(this),50);}};y.prototype._oncolscroll=function(){if(!this._bSyncScrollLeft){var H=this.getDomRef(v.HorizontalScrollBar);if(H){var i=this.getDomRef().querySelector(".sapUiTableColHdrScr");var j=0;if(i){j=i.scrollLeft;}H.scrollLeft=j;}}};y.prototype._oncntscroll=function(){if(!this._bSyncScrollLeft){var H=this.getDomRef(v.HorizontalScrollBar);if(H){var i=this.getDomRef().querySelector(".sapUiTableCtrlScr");H.scrollLeft=i.scrollLeft;}}};y.prototype.onmousedown=function(i){var l=i.button===0;var j=this._isTouchMode(i);if(l){var $=q(i.target);var z=$.closest(".sapUiTableCol");if(z.length===1&&i.target!=this.getDomRef("sb")){this._bShowMenu=true;this._mTimeouts.delayedMenuTimer=q.sap.delayedCall(200,this,function(){this._bShowMenu=false;});var A=this._isTouchMode(i)&&($.hasClass("sapUiTableColDropDown")||$.hasClass("sapUiTableColResizer"));if(this.getEnableColumnReordering()&&!A){var B=parseInt(z.attr("data-sap-ui-colindex"),10);if(B>this._iLastFixedColIndex){var H=this.getColumns()[B];this._mTimeouts.delayedActionTimer=q.sap.delayedCall(200,this,function(){this._onColumnMoveStart(H,j);});}}}var J=!!(i.metaKey||i.ctrlKey);if(!!D.browser.firefox&&J){i.preventDefault();}}};y.prototype.oncontextmenu=function(i){var $=q(i.target);var H=$.closest('.sapUiTableCol');if(H.length>0){var j=sap.ui.getCore().byId(H.attr("data-sap-ui-colid"));if(j){j._openMenu(H[0],false);}i.preventDefault();}else{if(this._findAndfireCellEvent(this.fireCellContextmenu,i,this._oncellcontextmenu)){i.preventDefault();}}};y.prototype._oncellcontextmenu=function(i){if(this.getEnableCellFilter()){if(!this._oContextMenu){if(!M){M=sap.ui.requireSync("sap/ui/unified/Menu");x=sap.ui.requireSync("sap/ui/unified/MenuItem");}this._oContextMenu=new M(this.getId()+"-contextmenu");this.addDependent(this._oContextMenu);}var j=sap.ui.getCore().byId(i.columnId);var l=j.getFilterProperty();if(j&&j.isFilterableByMenu()&&i.rowBindingContext){this._oContextMenu.destroyItems();this._oContextMenu.addItem(new x({text:this._oResBundle.getText("TBL_FILTER"),select:[function(){var A=this.getContextByIndex(i.rowIndex);var B=A.getProperty(l);if(this.getEnableCustomFilter()){this.fireCustomFilter({column:j,value:B});}else{this.filter(j,B);}},this]}));var z=P.Dock;this._oContextMenu.open(false,i.cellDomRef,z.BeginTop,z.BeginBottom,i.cellDomRef,"none none");return true;}}};y.prototype._findAndfireCellEvent=function(i,j,l){var $=q(j.target);var z=$.closest("td[role='gridcell']");var A=z.attr("id");var B=/.*-row(\d*)-col(\d*)/i.exec(A);var H=false;if(B){var J=B[1];var K=B[2];var L=this.getRows()[J];var O=L&&L.getCells()[K];var Q=L&&L.getIndex();var U=O.data("sap-ui-colid");var W;if(this.getBindingInfo("rows")){W=L.getBindingContext(this.getBindingInfo("rows").model);}var X={rowIndex:Q,columnIndex:K,columnId:U,cellControl:O,rowBindingContext:W,cellDomRef:z.get(0)};H=!i.call(this,X);if(!H&&typeof l==="function"){X.cellDomRef=z[0];H=l.call(this,X);}}return H;};y.prototype.getFocusDomRef=function(){this._getKeyboardExtension().initItemNavigation();return T.getFocusedItemInfo(this).domRef||C.prototype.getFocusDomRef.apply(this,arguments);};y.prototype.onfocusin=function(i){var $;var j=q(i.target);if(j.parent('.sapUiTableTr').length>0){$=q(this.getDomRef("sapUiTableCtrlScr"));}else if(j.parent('.sapUiTableColHdr').length>0){$=q(this.getDomRef("sapUiTableColHdrScr"));}if((D.browser.firefox||D.browser.chrome)&&$&&$.length>0){var l=$.scrollLeft();var z=$.width();var A=j.position().left;var B=A+j.width();var O=A-l;var H=B-z-l;var J=this.getDomRef(v.HorizontalScrollBar);if(H>0){J.scrollLeft=J.scrollLeft+H+2;}else if(O<0){J.scrollLeft=J.scrollLeft+O-1;}}};y.prototype._getAbsoluteRowIndex=function(i){var j=0;var l=this.getFirstVisibleRow();var z=this.getFixedBottomRowCount();var A=this.getVisibleRowCount();var B=A-z;if(z>0&&i>=B){j=this.getBinding().getLength()-A+i;}else{j=l+i;}return j;};y.prototype._onSelect=function(i){var $=q(i.target);var j=i.shiftKey;var l=!!(i.metaKey||i.ctrlKey);var z=$.closest(".sapUiTableCol");if(this._bShowMenu&&z.length===1){var A=parseInt(z.attr("data-sap-ui-colindex"),10);var B=this.getColumns()[A];if($.hasClass("sapUiTableColDropDown")){var H=this.fireColumnSelect({column:B});if(H){B._openMenu(z[0],i.type=="keyup");}}else{this._onColumnSelect(B,z[0],this._isTouchMode(i),i.type=="keyup");}return;}var J=$.closest(".sapUiTableRowHdr");if(J.length===1){var A=parseInt(J.attr("data-sap-ui-rowindex"),10);this._onRowSelect(this._getAbsoluteRowIndex(A),j,l);return;}var K;if(i.target){var L=q(i.target).closest("td");if(L.length>0){K=L[0];}}if(K&&(K.getAttribute("role")=="gridcell"||q(K).hasClass("sapUiTableTDDummy"))&&(this.getSelectionBehavior()===t.Row||this.getSelectionBehavior()===t.RowOnly)){var J=$.closest(".sapUiTableCtrl > tbody > tr");if(J.length===1){var A=parseInt(J.attr("data-sap-ui-rowindex"),10);this._onRowSelect(this._getAbsoluteRowIndex(A),j,l);return;}}if(q.sap.containsOrEquals(this.getDomRef("selall"),i.target)){this._toggleSelectAll();return;}};y.prototype._isRowSelectable=function(i){return true;};y.prototype._onRowSelect=function(i,j,l){if(!!D.browser.internet_explorer&&j){this._clearTextSelection();}var B=this.getBinding("rows");if(!B){return;}if(i<0||i>=(B.getLength()||0)){return;}if(!this._isRowSelectable(i)){return;}this._iSourceRowIndex=i;var z=this.getSelectionMode();if(z!==u.None){if(z===u.Single){if(!this.isIndexSelected(i)){this.setSelectedIndex(i);}else{this.clearSelection();}}else{if(z===u.MultiToggle){l=true;}if(j){var A=this.getSelectedIndex();if(A>=0){this.addSelectionInterval(A,i);}else{this.setSelectedIndex(i);}}else{if(!this.isIndexSelected(i)){if(l){this.addSelectionInterval(i,i);}else{this.setSelectedIndex(i);}}else{if(l){this.removeSelectionInterval(i,i);}else{if(this._getSelectedIndicesCount()===1){this.clearSelection();}else{this.setSelectedIndex(i);}}}}}}this._iSourceRowIndex=undefined;};y.prototype._onColumnSelect=function(i,j,l,W){if(l&&(i.getResizable()||i._menuHasItems())){var $=q(j);var z=$.find(".sapUiTableColCell");if($.find(".sapUiTableColCellMenu").length<1){z.hide();var A="";if(i._menuHasItems()){A="<div class='sapUiTableColDropDown'></div>";}var B="";if(i.getResizable()){B="<div class='sapUiTableColResizer''></div>";}var H=q("<div class='sapUiTableColCellMenu'>"+A+B+"</div>");$.append(H);$.bind("focusout",function(){this.cell.show();this.menu.remove();this.self.unbind("focusout");}.bind({cell:z,menu:H,self:$}));}return;}var J=this.fireColumnSelect({column:i});if(J){i._openMenu(j,W);}};y.prototype.ontouchstart=function(i){if('ontouchstart'in document){this._aTouchStartPosition=null;this._bIsScrollVertical=null;var $=this._getScrollTargets();var j=q(i.target).closest($).length>0;if(j){var l=i.targetTouches[0];this._aTouchStartPosition=[l.pageX,l.pageY];var z=this.getDomRef(v.VerticalScrollBar);if(z){this._iTouchScrollTop=z.scrollTop;}var H=this.getDomRef(v.HorizontalScrollBar);if(H){this._iTouchScrollLeft=H.scrollLeft;}}}};y.prototype.ontouchmove=function(i){if('ontouchstart'in document&&this._aTouchStartPosition){var j=i.targetTouches[0];var l=(j.pageX-this._aTouchStartPosition[0]);var z=(j.pageY-this._aTouchStartPosition[1]);if(this._bIsScrollVertical==null){this._bIsScrollVertical=Math.abs(z)>Math.abs(l);}if(this._bIsScrollVertical){var A=this.getDomRef(v.VerticalScrollBar);if(A){var B=this._iTouchScrollTop-z;if(B>0&&B<(this.getDomRef("vsb-content").clientHeight-A.clientHeight)-1){i.preventDefault();i.stopPropagation();}A.scrollTop=B;}}else{var H=this.getDomRef(v.HorizontalScrollBar);if(H){var J=this._iTouchScrollLeft-l;if(J>0&&J<(this.getDomRef("hsb-content").clientWidth-H.clientWidth)-1){i.preventDefault();i.stopPropagation();}H.scrollLeft=J;}}}};y.prototype._onColumnMoveStart=function(i,j){this._disableTextSelection();var $=i.$();var l=parseInt($.attr("data-sap-ui-colindex"),10);if(l<this.getFixedColumnCount()){return;}this.$().addClass("sapUiTableDragDrop");this._$colGhost=$.clone().removeAttr("id");$.css({"opacity":".25"});this._$colGhost.addClass("sapUiTableColGhost").css({"left":-10000,"top":-10000,"position":"absolute","z-index":this.$().zIndex()+10});this.$().find(".sapUiTableCol").each(function(A,B){var $=q(this);$.css({position:"relative"});$.data("pos",{left:$.position().left,center:$.position().left+$.outerWidth()/2,right:$.position().left+$.outerWidth()});});this._$colGhost.appendTo(document.body);var z=q(document.body);if(j){z.bind("touchmove.sapUiColumnMove",q.proxy(this._onColumnMove,this));z.bind("touchend.sapUiColumnMove",q.proxy(this._onColumnMoved,this));}else{z.bind("mousemove.sapUiColumnMove",q.proxy(this._onColumnMove,this));z.bind("mouseup.sapUiColumnMove",q.proxy(this._onColumnMoved,this));}};y.prototype._onColumnMove=function(i){var $=this.$();var l=i.pageX;var L=i.pageY;if(i&&this._isTouchMode(i)){l=i.targetTouches[0].pageX;L=i.targetTouches[0].pageY;i.stopPropagation();i.preventDefault();}var j=this._bRtlMode;var z=l-$.offset().left;var A=parseInt(this._$colGhost.attr("data-sap-ui-colindex"),10);var B=this.getColumns()[A].$();var O=this._iNewColPos;this._iNewColPos=A;var H=this;$.find(".sapUiTableCol").each(function(J,K){var Q=q(K);var U=parseInt(Q.attr("data-sap-ui-colindex"),10);var W=sap.ui.getCore().byId(Q.attr("data-sap-ui-colid")).getHeaderSpan();var X;if(W){if(q.isArray(W)){X=W[0];}else{X=W;}}else{X=1;}if(Q.get(0)!==B.get(0)){var Y=Q.data("pos");var Z=z>=Y.left&&z<=Y.center;var _=z>=Y.center&&z<=Y.right;if(!j){if(Z){H._iNewColPos=U;}else if(_){H._iNewColPos=U+X;}else{H._iNewColPos=H._iNewColPos;}}else{if(_){H._iNewColPos=U;}else if(Z){H._iNewColPos=U+X;}else{H._iNewColPos=H._iNewColPos;}}if((Z||_)&&U>A){H._iNewColPos--;}}});if(this._iNewColPos<=this._iLastFixedColIndex){this._iNewColPos=O;}if(this._iNewColPos<this.getFixedColumnCount()){this._iNewColPos=O;}this._animateColumnMove(A,O,this._iNewColPos);this._$colGhost.css({"left":l+5,"top":L+5});};y.prototype._animateColumnMove=function(j,O,z){var A=this._bRtlMode;var $=this.getColumns()[j].$();if(O!==z){for(var i=Math.min(O,z),l=Math.max(O,z);i<=l;i++){var B=this.getColumns()[i];if(i!==j&&B.getVisible()){B.$().stop(true,true).animate({left:"0px"});}}var H=0;if(z<j){for(var i=z;i<j;i++){var B=this.getColumns()[i];if(B.getVisible()){var J=B.$();H-=J.outerWidth();J.stop(true,true).animate({left:$.outerWidth()*(A?-1:1)+"px"});}}}else{for(var i=j+1,l=z+1;i<l;i++){var B=this.getColumns()[i];if(B.getVisible()){var J=B.$();H+=J.outerWidth();J.stop(true,true).animate({left:$.outerWidth()*(A?1:-1)+"px"});}}}$.stop(true,true).animate({left:H*(A?-1:1)+"px"});}};y.prototype._onColumnMoved=function(j){var l=this;this.$().removeClass("sapUiTableDragDrop");var z=parseInt(this._$colGhost.attr("data-sap-ui-colindex"),10);var A=this.getColumns()[z];var $=q(document.body);$.unbind("touchmove.sapUiColumnMove");$.unbind("touchend.sapUiColumnMove");$.unbind("mousemove.sapUiColumnMove");$.unbind("mouseup.sapUiColumnMove");this._$colGhost.remove();this._$colGhost=undefined;this._enableTextSelection();var B=this.fireColumnMove({column:A,newPos:this._iNewColPos});var H=z<this._iNewColPos;if(B&&this._iNewColPos!==undefined&&this._iNewColPos!==z){this.removeColumn(A);this.insertColumn(A,this._iNewColPos);var J=A.getHeaderSpan(),K;if(J){if(q.isArray(J)){K=J[0];}else{K=J;}}else{K=1;}if(K>1){if(!H){this._iNewColPos++;}for(var i=1;i<K;i++){var L=this.getColumns()[H?z:z+i];this.removeColumn(L);this.insertColumn(L,this._iNewColPos);this.fireColumnMove({column:L,newPos:this._iNewColPos});if(!H){this._iNewColPos++;}}}}else{this._animateColumnMove(z,this._iNewColPos,z);A.$().css({"backgroundColor":"","backgroundImage":"","opacity":""});}if(this._mTimeouts.reApplyFocusTimer){window.clearTimeout(this._mTimeouts.reApplyFocusTimer);}this._mTimeouts.reApplyFocusTimer=window.setTimeout(function(){var O=T.getFocusedItemInfo(l).cell;T.focusItem(l,0,j);T.focusItem(l,O,j);},0);delete this._iNewColPos;};y.prototype._resizeDependentColumns=function(j,W){var l=this;if(this._checkPercentageColumnWidth()){var z=this._getVisibleColumns();var A;q.each(z,function(b1,c1){if(j===c1){A=b1;}});var O=0;var L=z.length-1;var B;if(A===undefined){B=0;}else{B=parseInt(W,10);}var H=0;var J=[];q.each(z,function(b1,c1){var d1=l._getColumnPercentageWidth(c1);if((((A===L&&b1<A)||((A!==L)&&b1>A))&&c1.getFlexible())||A===undefined){O+=c1.$().outerWidth();H+=d1;J.push(c1);}else if(b1!==A){B+=d1;}});var K=B;q.each(J,function(b1,c1){var d1=l._getColumnPercentageWidth(c1);var a1=Math.round((100-K)/H*d1);if(b1===J.length-1){a1=100-B;}else{B+=a1;}l._updateColumnWidth(c1,a1+"%");});}else if(!this._hasOnlyFixColumnWidths()){var z=this._getVisibleColumns(),Q=this.$().find(".sapUiTableCtrl").width(),A,U=0,X=0,Y=0,Z=0;q.each(z,function(b1,c1){if(!q.sap.endsWith(c1.getWidth(),"px")&&!q.sap.endsWith(c1.getWidth(),"em")&&!q.sap.endsWith(c1.getWidth(),"rem")){Z++;return false;}if(A!=undefined){Y+=l._CSSSizeToPixel(c1.getWidth());U++;}else if(j!==c1){X+=l._CSSSizeToPixel(c1.getWidth());}if(j===c1){A=b1;X+=l._CSSSizeToPixel(W);}});if(Z>0||(X+Y>Q)){return;}Q-=X;for(var i=A+1;i<z.length;i++){var j=z[i],$=this._CSSSizeToPixel(j.getWidth()),_=$/Y*100,a1=Q/100*_;this._updateColumnWidth(j,Math.round(a1)+'px');}}};y.prototype._getColumnPercentageWidth=function(i){var j=i.getWidth();var l=parseInt(i.getWidth(),10);var z=this.$().find(".sapUiTableCtrl").width();if(q.sap.endsWith(j,"px")||q.sap.endsWith(j,"em")||q.sap.endsWith(j,"rem")){l=Math.round(100/z*l);}else if(!q.sap.endsWith(j,"%")){l=Math.round(100/z*i.$().width());}return l;};y.prototype._updateColumnWidth=function(i,W,j){var l=true;if(j){l=this.fireColumnResize({column:i,width:W});}if(l){i.setProperty("width",W,true);this.$().find('th[data-sap-ui-colid="'+i.getId()+'"]').css('width',W);}return l;};y.prototype._checkPercentageColumnWidth=function(){var i=this.getColumns();var H=false;q.each(i,function(j,l){if(q.sap.endsWith(l.getWidth(),"%")){H=true;return false;}});return H;};y.prototype._hasOnlyFixColumnWidths=function(){var O=true;q.each(this.getColumns(),function(i,j){var W=j.getWidth();if(j.getFlexible()||!W||W.substr(-2)!=="px"){O=false;return false;}});return O;};y.prototype.pushSortedColumn=function(i,A){if(!A){this._aSortedColumns=[];}this._aSortedColumns.push(i);};y.prototype.getSortedColumns=function(){return this._aSortedColumns;};y.prototype.sort=function(i,j,A){if(q.inArray(i,this.getColumns())>=0){i.sort(j===w.Descending,A);}};y.prototype.filter=function(i,j){if(q.inArray(i,this.getColumns())>=0){i.filter(j);}};y.prototype._getSelectOnCellsAllowed=function(){var i=this.getSelectionBehavior();var j=this.getSelectionMode();return j!==u.None&&(i===t.Row||i===t.RowOnly);};y.prototype._updateSelection=function(){if(this.getSelectionMode()===u.None){return;}var j=this._getAccExtension().getAriaTextsForSelectionMode(true);var l=this._getSelectOnCellsAllowed();var z=this.getRows();for(var i=0;i<z.length;i++){var A=z[i];A._updateSelection(this,j,l);}this.setProperty("selectedIndex",this.getSelectedIndex(),true);};y.prototype._onSelectionChanged=function(i){var j=i.getParameter("rowIndices");var l=i.getParameter("selectAll");var z=this._iSourceRowIndex!==undefined?this._iSourceRowIndex:this.getSelectedIndex();this._updateSelection();var A=this.getSelectionMode();if(A==="Multi"||A==="MultiToggle"){this.$("selall").attr('title',this._oResBundle.getText("TBL_SELECT_ALL")).addClass("sapUiTableSelAll");}this.fireRowSelectionChange({rowIndex:z,rowContext:this.getContextByIndex(z),rowIndices:j,selectAll:l,userInteraction:this._iSourceRowIndex!==undefined});};y.prototype.getContextByIndex=function(i){var B=this.getBinding("rows");return i>=0&&B?B.getContexts(i,1)[0]:null;};y.prototype.getSelectedIndex=function(){return this._oSelection.getLeadSelectedIndex();};y.prototype.setSelectedIndex=function(i){if(i===-1){this.clearSelection();}else{this._oSelection.setSelectionInterval(i,i);}return this;};y.prototype.clearSelection=function(){this._oSelection.clearSelection();return this;};y.prototype.selectAll=function(){var i=this.getSelectionMode();if(!this.getEnableSelectAll()||(i!="Multi"&&i!="MultiToggle")){return this;}var B=this.getBinding("rows");if(B){this._oSelection.selectAll((B.getLength()||0)-1);this.$("selall").attr('title',this._oResBundle.getText("TBL_DESELECT_ALL")).removeClass("sapUiTableSelAll");}return this;};y.prototype.getSelectedIndices=function(){return this._oSelection.getSelectedIndices();};y.prototype.addSelectionInterval=function(i,j){this._oSelection.addSelectionInterval(i,j);return this;};y.prototype.setSelectionInterval=function(i,j){this._oSelection.setSelectionInterval(i,j);return this;};y.prototype.removeSelectionInterval=function(i,j){this._oSelection.removeSelectionInterval(i,j);return this;};y.prototype.isIndexSelected=function(i){return this._oSelection.isSelectedIndex(i);};y.prototype.setGroupBy=function(i){var j=i;if(typeof j==="string"){j=sap.ui.getCore().byId(j);}var l=false;if(j&&j instanceof k){if(q.inArray(j,this.getColumns())===-1){throw new Error("Column has to be part of the columns aggregation!");}var z=this.fireGroup({column:j,groupedColumns:[j.getId()],type:G.group});var O=sap.ui.getCore().byId(this.getGroupBy());if(O){O.setGrouped(false);l=true;}if(z&&j instanceof k){j.setGrouped(true);}}if(!j||l){var B=this.getBindingInfo("rows");delete B.binding;this._bindAggregation("rows",B);}return this.setAssociation("groupBy",j);};y.prototype.getBinding=function(j){j=j||"rows";var B=E.prototype.getBinding.call(this,j);if(this.getEnableGrouping()){var l=sap.ui.requireSync("sap/ui/model/ClientListBinding");var z=sap.ui.getCore().byId(this.getGroupBy());var A=z&&z.getGrouped()&&j==="rows"&&B&&B instanceof l;if(A&&!B._modified){B._modified=true;this._modifyRow=function(W,$){this.$().find(".sapUiTableRowHdrScr").css("display","block");var X=this.$().find("div[data-sap-ui-rowindex='"+$.attr("data-sap-ui-rowindex")+"']");if(B.isGroupHeader(W)){$.addClass("sapUiTableGroupHeader sapUiTableRowHidden");var Y=B.isExpanded(W)?"sapUiTableGroupIconOpen":"sapUiTableGroupIconClosed";X.html("<div class=\"sapUiTableGroupIcon "+Y+"\" tabindex=\"-1\">"+B.getTitle(W)+"</div>");X.addClass("sapUiTableGroupHeader").removeAttr("title");}else{$.removeClass("sapUiTableGroupHeader");X.html("");X.removeClass("sapUiTableGroupHeader");}};var H=z.getSortProperty();B.sort(new h(H));var L=B.getLength(),J=B.getContexts(0,L);var K;var O=0;for(var i=L-1;i>=0;i--){var Q=J[i].getProperty(H);if(!K){K=Q;}if(K!==Q){var U=J[i+1].getModel().getContext("/sap.ui.table.GroupInfo"+i);U.__groupInfo={oContext:J[i+1],name:K,count:O,groupHeader:true,expanded:true};J.splice(i+1,0,U);K=Q;O=0;}O++;}var U=J[0].getModel().getContext("/sap.ui.table.GroupInfo");U.__groupInfo={oContext:J[0],name:K,count:O,groupHeader:true,expanded:true};J.splice(0,0,U);q.extend(B,{getLength:function(){return J.length;},getContexts:function(W,L){return J.slice(W,W+L);},isGroupHeader:function(W){var X=J[W];return X&&X.__groupInfo&&X.__groupInfo.groupHeader;},getTitle:function(W){var X=J[W];return X&&X.__groupInfo&&X.__groupInfo.name+" - "+X.__groupInfo.count;},isExpanded:function(W){var X=J[W];return this.isGroupHeader(W)&&X.__groupInfo&&X.__groupInfo.expanded;},expand:function(W){if(this.isGroupHeader(W)&&!J[W].__groupInfo.expanded){for(var i=0;i<J[W].__childs.length;i++){J.splice(W+1+i,0,J[W].__childs[i]);}delete J[W].__childs;J[W].__groupInfo.expanded=true;this._fireChange();}},collapse:function(W){if(this.isGroupHeader(W)&&J[W].__groupInfo.expanded){J[W].__childs=J.splice(W+1,J[W].__groupInfo.count);J[W].__groupInfo.expanded=false;this._fireChange();}},toggleIndex:function(W){if(this.isExpanded(W)){this.collapse(W);}else{this.expand(W);}}});this._mTimeouts.groupingFireBindingChange=this._mTimeouts.groupingFireBindingChange||window.setTimeout(function(){B._fireChange();},0);}}return B;};y.prototype.resetGrouping=function(){var B=this.getBinding("rows");if(B&&B._modified){this.$().find(".sapUiTableRowHdrScr").css("display","");this._modifyRow=undefined;var i=this.getBindingInfo("rows");this.unbindRows();this.bindRows(i);}};y.prototype.setEnableGrouping=function(i){this.setProperty("enableGrouping",i);if(!i){this.resetGrouping();}this._invalidateColumnMenus();return this;};y.prototype.setEnableCustomFilter=function(i){this.setProperty("enableCustomFilter",i);this._invalidateColumnMenus();return this;};y.prototype.setEnableColumnFreeze=function(i){this.setProperty("enableColumnFreeze",i);this._invalidateColumnMenus();return this;};y.prototype.setShowColumnVisibilityMenu=function(i){this.setProperty("showColumnVisibilityMenu",i);this._invalidateColumnMenus();return this;};y.prototype.getFixedColumnCount=function(){if(this._bIgnoreFixedColumnCount){return 0;}else{return this.getProperty("fixedColumnCount");}};y.prototype.setFixedColumnCount=function(j,l){var z=this._getVisibleColumns();var H=z[j-1]&&z[j-1].getHeaderSpan();if(H){var A;if(q.isArray(H)){A=parseInt(H[0],10);}else{A=parseInt(H,10);}j+=A-1;}var $=this.$().find(".sapUiTableCtrlFirstCol > th");for(var i=0;i<j;i++){var B=z[i];if(B){var J=q.inArray(B,this.getColumns());if(!B.getWidth()){B.setWidth($.filter("[data-sap-ui-headcolindex='"+J+"']").width()+"px");}}}this.setProperty("fixedColumnCount",j,l);this._collectTableSizes();this._invalidateColumnMenus();return this;};y.prototype.setFixedRowCount=function(i){if(!(parseInt(i,10)>=0)){q.sap.log.error("Number of fixed rows must be greater or equal 0",this);return this;}if((i+this.getFixedBottomRowCount())<this.getVisibleRowCount()){this.setProperty("fixedRowCount",i);this._updateBindingContexts();}else{q.sap.log.error("Table '"+this.getId()+"' fixed rows('"+(i+this.getFixedBottomRowCount())+"') must be smaller than numberOfVisibleRows('"+this.getVisibleRowCount()+"')",this);}return this;};y.prototype.setFixedBottomRowCount=function(i){if(!(parseInt(i,10)>=0)){q.sap.log.error("Number of fixed bottom rows must be greater or equal 0",this);return this;}if((i+this.getFixedRowCount())<this.getVisibleRowCount()){this.setProperty("fixedBottomRowCount",i);this._updateBindingContexts();}else{q.sap.log.error("Table '"+this.getId()+"' fixed rows('"+(i+this.getFixedRowCount())+"') must be smaller than numberOfVisibleRows('"+this.getVisibleRowCount()+"')",this);}return this;};y.prototype.setThreshold=function(i){this.setProperty("threshold",i,true);};y.prototype._invalidateColumnMenus=function(){var j=this.getColumns();for(var i=0,l=j.length;i<l;i++){j[i].invalidateMenu();}};y.prototype._isTouchMode=function(i){return!!i.originalEvent["touches"];};y.prototype._determineParent=function(){var i=this.getParent();if(i){var j;if(i.getDomRef){j=i.getDomRef();}else if(i.getRootNode){j=i.getRootNode();}if(j){return q(j);}}return q();};y.prototype._getRowTemplate=function(){if(!this._oRowTemplate){this._oRowTemplate=new m(this.getId()+"-rows");var j=this.getColumns();for(var i=0,l=j.length;i<l;i++){if(j[i].getVisible()){var z=j[i].getTemplate();if(z){var A=z.clone("col"+i);A.data("sap-ui-colindex",i);A.data("sap-ui-colid",j[i].getId());this._oRowTemplate.addCell(A);}}}}return this._oRowTemplate;};y.prototype._getDummyRow=function(){if(!this._oDummyRow){this._oDummyRow=this._getRowTemplate().clone("dummy");this._oDummyRow._bDummyRow=true;this._oDummyRow._bHidden=true;}return this._oDummyRow;};y.prototype._resetRowTemplate=function(){if(this._oRowTemplate){this._oRowTemplate.destroy();this._oRowTemplate=undefined;}if(this._oDummyRow){this._oDummyRow.destroy();this._oDummyRow=undefined;}};y.prototype._adjustRows=function(j,l){if(isNaN(j)){return false;}if(T.isVariableRowHeightEnabled(this)){j=j+1;}var i;var z=this.getRows();if(!this._oRowTemplate&&z.length>0){this.destroyAggregation("rows",true);z=[];}if(j==z.length){return false;}for(i=z.length-1;i>=j;i--){this.removeAggregation("rows",i,true).destroy();}if(T.isVariableRowHeightEnabled(this)){this.setProperty("visibleRowCount",j-1,true);}else{this.setProperty("visibleRowCount",j,true);}this._ignoreInvalidateOfChildControls=true;var A;var B=this.getFirstVisibleRow();var H=0;var J=false;var K;var L=this.getBinding("rows");if(!l){K=this.getBindingInfo("rows");J=typeof this._updateTableCell==="function";A=this._getRowContexts(j);for(i=0;i<z.length;i++){H=B+i;this._updateRowBindingContext(z[i],A[i],K&&K.model,H,J,L);}}if(z.length<j){var O=this._getRowTemplate();for(i=z.length;i<j;i++){var Q=O.clone("row"+i);if(!l){H=B+i;this._updateRowBindingContext(Q,A[i],K&&K.model,H,J,L);}this.addAggregation("rows",Q,true);}}this._ignoreInvalidateOfChildControls=false;z=this.getRows();l=l||A.length==0;return this._insertTableRows(z,l);};y.prototype._insertTableRows=function(j,z){var A=false;if(!this._bInvalid){this._detachEvents();var B=this.getDomRef("tableCCnt");j=j||this.getRows();if(!j.length||!B){return;}if(this.getVisibleRowCountMode()==V.Auto){var H=this.getDomRef();if(H){H.style.height="0px";}}var J=q.Event("BeforeRendering");J.setMarked("insertTableRows");J.srcControl=this;this._handleEvent(J);var K=new sap.ui.getCore().createRenderManager(),L=this.getRenderer();this._iDefaultRowHeight=undefined;L.renderTableCCnt(K,this);K.flush(B,false,false);K.destroy();J=q.Event("AfterRendering");J.setMarked("insertTableRows");J.srcControl=this;this._handleEvent(J);this._initRowDomRefs();this._getKeyboardExtension().invalidateItemNavigation();var O=this.getColumns();for(var i=0,l=O.length;i<l;i++){if(O[i].getVisible()){O[i]._restoreIcons();}}this._updateTableSizes();this._updateGroupHeader();A=true;if(this._updateTableContent){this._updateTableContent();}this._attachEvents();}if(!z&&!this._bInvalid&&this.getBinding("rows")){var Q=this;if(this._mTimeouts._rowsUpdated){window.clearTimeout(this._mTimeouts._rowsUpdated);}this._mTimeouts._rowsUpdated=window.setTimeout(function(){Q.fireEvent("_rowsUpdated");},0);}return A;};y.prototype._getDefaultRowHeight=function(i){if(T.isVariableRowHeightEnabled(this)){this._iDefaultRowHeight=this.getRowHeight()||28;}else{if(!this._iDefaultRowHeight&&this.getDomRef()){i=i||this._collectRowHeights();if(i&&i.length>0){this._iDefaultRowHeight=i[0];}}if(!this._iDefaultRowHeight){this._iDefaultRowHeight=28;}}return this._iDefaultRowHeight;};y.prototype._setRowContentHeight=function(H){H=H||0;var i=this.getVisibleRowCountMode();var j=this.getVisibleRowCount();var l=this.getMinAutoRowCount();var z;var A=this._getDefaultRowHeight();if(i==V.Interactive||i==V.Fixed){if(this._iTableRowContentHeight&&i==V.Interactive){z=l*A;if(!H){H=this._iTableRowContentHeight;}}else{z=j*A;H=z;}}else if(i==V.Auto){z=l*A;}var B=Math.max(H,z);if((i==V.Fixed&&this.getRows().length==0)||i!=V.Fixed){this._iTableRowContentHeight=Math.floor(B/A)*A;}else{this._iTableRowContentHeight=undefined;}if(T.isVariableRowHeightEnabled(this)){var $=q(this.getDomRef("tableCCnt"));if(i==V.Fixed||i==V.Interactive){$.css("height",this._getDefaultRowHeight()*this.getVisibleRowCount()+"px");}else if(i==V.Auto){$.css("height",this._iTableRowContentHeight+"px");}}else{if((i==V.Fixed||i==V.Interactive)&&this.getRows().length>0){q(this.getDomRef("tableCtrlCnt")).css("height","auto");}else{q(this.getDomRef("tableCtrlCnt")).css("height",this._iTableRowContentHeight+"px");}}};y.prototype._determineMinAutoRowCount=function(){var i=this.getVisibleRowCount();var j=this.getMinAutoRowCount();var l=j||i||5;if(this.getVisibleRowCountMode()==V.Interactive&&!this.bOutput){l=i||j||5;}return l;};y.prototype._calculateRowsToDisplay=function(i){i=i||this._iTableRowContentHeight;var j=this.getVisibleRowCountMode();var l=0;if(j==V.Fixed){l=this.getVisibleRowCount()||0;}else if(j==V.Interactive||j==V.Auto){var z=this._determineMinAutoRowCount();var A=this._getDefaultRowHeight();if(!A||!i){l=z;}else{var B=Math.min(i,50000);var H=Math.floor(B/A);l=Math.max((this.getFixedRowCount()+this.getFixedBottomRowCount()+1),Math.max(z,H));}}return Math.max(l,0);};y.prototype.setShowNoData=function(i){this.setProperty('showNoData',i,true);this._updateNoData();return this;};y.prototype.exportData=function(j){var z=sap.ui.requireSync("sap/ui/core/util/Export");j=j||{};if(!j.rows){var B=this.getBinding("rows"),A=this.getBindingInfo("rows");var H=B.aFilters.concat(B.aApplicationFilters);j.rows={path:A.path,model:A.model,sorter:B.aSorters,filters:H,parameters:A.parameters};}if(!j.exportType){var J=sap.ui.requireSync("sap/ui/core/util/ExportTypeCSV");j.exportType=new J();}var K=j.rows.model;if(!K){var L=j.rows.path;var O=L.indexOf(">");if(O>0){K=L.substr(0,O);}}if(!j.columns){j.columns=[];var Q=this.getColumns();for(var i=0,l=Q.length;i<l;i++){var U=Q[i];if(U.getSortProperty()){j.columns.push({name:U.getLabel().getText(),template:{content:{path:U.getSortProperty(),model:K}}});}}}var W=new z(j);this.addDependent(W);return W;};y.prototype._onPersoApplied=function(){var j=this.getColumns();var z=[];for(var i=0,l=j.length;i<l;i++){var A=j[i];if(A.getSorted()){z.push(new h(A.getSortProperty(),A.getSortOrder()===w.Descending));}}var B=this.getBinding("rows");if(B){if(z.length>0){B.sort(z);}this.refreshRows();}};y.prototype._toggleSelectAll=function(){if(!this.$("selall").hasClass("sapUiTableSelAll")){this._iSourceRowIndex=-1;this.clearSelection();}else{this._iSourceRowIndex=0;this.selectAll();}if(!!D.browser.internet_explorer){this.$("selall").focus();}this._iSourceRowIndex=undefined;};y.prototype._restoreAppDefaultsColumnHeaderSortFilter=function(){var i=this.getColumns();q.each(i,function(j,l){l._restoreAppDefaults();});};y.prototype._setBusy=function(j){var B,i,l;if(!this.getEnableBusyIndicator()||!this._bBusyIndicatorAllowed){return;}B=this.getBinding("rows");if(!B){return;}this.setBusy(false);if(j&&this._iDataRequestedCounter>0){var z=j.reason;if(j.contexts&&j.contexts.length!==undefined){l=false;for(i=0;i<j.contexts.length;i++){if(j.contexts[i]===undefined){l=true;break;}}}else if(j.changeReason===e.Expand){this.setBusy(true);}var L=B.getLength();if((z==e.Expand&&this._iDataRequestedCounter!==0)||l||(B.isInitial())||(j.receivedLength===0&&this._iDataRequestedCounter!==0)||(j.receivedLength<j.requestedLength&&j.receivedLength!==L&&j.receivedLength!==L-this.getFirstVisibleRow())){this.setBusy(true);}}};y.prototype.setBusy=function(B,i){var j=this.getBusy()!=B;i="sapUiTableCnt";var l=C.prototype.setBusy.call(this,B,i);if(j){this.fireBusyStateChanged({busy:B});}return l;};y.prototype.setEnableBusyIndicator=function(i){this.setProperty("enableBusyIndicator",i,true);};y.prototype._attachDataRequestedListeners=function(){var B=this.getBinding("rows");if(B){B.detachDataRequested(this._onBindingDataRequestedListener,this);B.detachDataReceived(this._onBindingDataReceivedListener,this);this._iDataRequestedCounter=0;B.attachDataRequested(this._onBindingDataRequestedListener,this);B.attachDataReceived(this._onBindingDataReceivedListener,this);}};y.prototype._onBindingDataRequestedListener=function(i){if(i.getSource()==this.getBinding("rows")&&!i.getParameter("__simulateAsyncAnalyticalBinding")){this._iDataRequestedCounter++;}};y.prototype._onBindingDataReceivedListener=function(i){if(i.getSource()==this.getBinding("rows")&&!i.getParameter("__simulateAsyncAnalyticalBinding")){this._iDataRequestedCounter--;}};y.prototype._attachBindingListener=function(){this._attachDataRequestedListeners();};y.prototype._setLargeDataScrolling=function(l){this._bLargeDataScrolling=!!l;};y.prototype._getSelectedIndicesCount=function(){return this.getSelectedIndices().length;};return y;});
