/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./BarInPageEnabler','./library','sap/ui/core/Control'],function(q,B,l,C){"use strict";var a=C.extend("sap.m.Bar",{metadata:{interfaces:["sap.m.IBar"],library:"sap.m",properties:{enableFlexBox:{type:"boolean",group:"Misc",defaultValue:false,deprecated:true},translucent:{type:"boolean",group:"Appearance",defaultValue:false,deprecated:true},design:{type:"sap.m.BarDesign",group:"Appearance",defaultValue:sap.m.BarDesign.Auto}},aggregations:{contentLeft:{type:"sap.ui.core.Control",multiple:true,singularName:"contentLeft"},contentMiddle:{type:"sap.ui.core.Control",multiple:true,singularName:"contentMiddle"},contentRight:{type:"sap.ui.core.Control",multiple:true,singularName:"contentRight"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},designTime:true}});a.prototype.onBeforeRendering=function(){this._removeAllListeners();};a.prototype.onAfterRendering=function(){this._handleResize();};a.prototype.init=function(){this.data("sap-ui-fastnavgroup","true",true);};a.prototype.exit=function(){this._removeAllListeners();if(this._oflexBox){this._oflexBox.destroy();this._oflexBox=null;}this._$MidBarPlaceHolder=null;this._$RightBar=null;this._$LeftBar=null;};a._aResizeHandlers=["_sResizeListenerId","_sResizeListenerIdMid","_sResizeListenerIdRight","_sResizeListenerIdLeft"];a.prototype._removeAllListeners=function(){var t=this;a._aResizeHandlers.forEach(function(i){t._removeListenerFailsave(i);});};a.prototype._removeListenerFailsave=function(L){if(this[L]){sap.ui.core.ResizeHandler.deregister(this[L]);this[L]=null;}};a.prototype._handleResize=function(){this._removeAllListeners();var c=!!this.getContentLeft().length,d=!!this.getContentMiddle().length,e=!!this.getContentRight().length;if(!this.getVisible()){return;}if(!c&&!d&&!e){return;}this._$LeftBar=this.$("BarLeft");this._$RightBar=this.$("BarRight");this._$MidBarPlaceHolder=this.$("BarPH");this._updatePosition(c,d,e);this._sResizeListenerId=sap.ui.core.ResizeHandler.register(this.getDomRef(),q.proxy(this._handleResize,this));if(this.getEnableFlexBox()){return;}if(c){this._sResizeListenerIdLeft=sap.ui.core.ResizeHandler.register(this._$LeftBar[0],q.proxy(this._handleResize,this));}if(d){this._sResizeListenerIdMid=sap.ui.core.ResizeHandler.register(this._$MidBarPlaceHolder[0],q.proxy(this._handleResize,this));}if(e){this._sResizeListenerIdRight=sap.ui.core.ResizeHandler.register(this._$RightBar[0],q.proxy(this._handleResize,this));}};a.prototype._updatePosition=function(c,d,e){if(!c&&!e&&d){return;}if(c&&!d&&!e){return;}if(!c&&!d&&e){return;}var i=this.$().outerWidth(true);this._$RightBar.css({width:""});this._$LeftBar.css({width:""});this._$MidBarPlaceHolder.css({position:"",width:"",visibility:'hidden'});var r=this._$RightBar.outerWidth(true);if(r>i){if(c){this._$LeftBar.css({width:"0px"});}if(d){this._$MidBarPlaceHolder.css({width:"0px"});}this._$RightBar.css({width:i+"px"});return;}var L=this._getBarContainerWidth(this._$LeftBar);if(i<(L+r)){L=i-r;this._$LeftBar.css({width:L+"px"});this._$MidBarPlaceHolder.css({width:"0px"});return;}this._$MidBarPlaceHolder.css(this._getMidBarCss(r,i,L));};a.prototype._getMidBarCss=function(r,i,L){var m=this._$MidBarPlaceHolder.outerWidth(true),R=sap.ui.getCore().getConfiguration().getRTL(),s=R?"right":"left",M={visibility:""};if(this.getEnableFlexBox()){m=i-L-r-parseInt(this._$MidBarPlaceHolder.css('margin-left'),10)-parseInt(this._$MidBarPlaceHolder.css('margin-right'),10);M.position="absolute";M.width=m+"px";M[s]=L;return M;}var S=i-L-r,c=(i/2)-(m/2),d=L>c,e=(i/2)+(m/2),f=(i-r)<e;if(S>0&&(d||f)){M.position="absolute";M.width=S+"px";M.left=R?r:L;}return M;};a.prototype._getBarContainerWidth=function(c){var i,d=0,e=c.children(),f=0;if(sap.ui.Device.browser.webkit||sap.ui.Device.browser.firefox||sap.ui.Device.browser.edge){for(i=0;i<e.length;i++){f+=q(e[i]).outerWidth(true);}d=c.outerWidth(true);}else{var o;for(i=0;i<e.length;i++){o=window.getComputedStyle(e[i]);if(o.width=="auto"){f+=q(e[i]).width()+1;}else{f+=parseFloat(o.width);}f+=parseFloat(o.marginLeft);f+=parseFloat(o.marginRight);f+=parseFloat(o.paddingLeft);f+=parseFloat(o.paddingRight);}var g=window.getComputedStyle(c[0]);d+=parseFloat(g.width);d+=parseFloat(g.marginLeft);d+=parseFloat(g.marginRight);d+=parseFloat(g.paddingLeft);d+=parseFloat(g.paddingRight);}if(d<f){d=f;}return d;};var b=B.extend("sap.m.BarInAnyContentEnabler",{});b.mContexts={dialogFooter:{contextClass:"sapMFooter-CTX",tag:"Footer",internalAriaLabel:"BAR_ARIA_DESCRIPTION_FOOTER"}};b.prototype.getContext=function(){var p=B.prototype.getContext.call();for(var k in b.mContexts){p[k]=b.mContexts[k];}return p;};a.prototype.getContext=b.prototype.getContext;a.prototype.isContextSensitive=b.prototype.isContextSensitive;a.prototype.setHTMLTag=b.prototype.setHTMLTag;a.prototype.getHTMLTag=b.prototype.getHTMLTag;a.prototype.applyTagAndContextClassFor=b.prototype.applyTagAndContextClassFor;a.prototype._setLandmarkInfo=b.prototype._setLandmarkInfo;a.prototype._writeLandmarkInfo=b.prototype._writeLandmarkInfo;return a;},true);
