/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./library','sap/ui/core/Control','sap/ui/thirdparty/mobify-carousel'],function(q,l,C,m){"use strict";var a=C.extend("sap.m.Carousel",{metadata:{library:"sap.m",properties:{height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'100%'},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'100%'},loop:{type:"boolean",group:"Misc",defaultValue:false},showPageIndicator:{type:"boolean",group:"Appearance",defaultValue:true},pageIndicatorPlacement:{type:"sap.m.PlacementType",group:"Appearance",defaultValue:sap.m.PlacementType.Bottom},showBusyIndicator:{type:"boolean",group:"Appearance",defaultValue:true,deprecated:true},busyIndicatorSize:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'6em',deprecated:true}},defaultAggregation:"pages",aggregations:{pages:{type:"sap.ui.core.Control",multiple:true,singularName:"page"}},associations:{activePage:{type:"sap.ui.core.Control",multiple:false}},events:{loadPage:{deprecated:true,parameters:{pageId:{type:"string"}}},unloadPage:{deprecated:true,parameters:{pageId:{type:"string"}}},pageChanged:{parameters:{oldActivePageId:{type:"string"},newActivePageId:{type:"string"}}}}}});a._INNER_SELECTOR=".sapMCrslInner";a._PAGE_INDICATOR_SELECTOR=".sapMCrslBulleted";a._HUD_SELECTOR=".sapMCrslHud";a._ITEM_SELECTOR=".sapMCrslItem";a._LEFTMOST_CLASS="sapMCrslLeftmost";a._RIGHTMOST_CLASS="sapMCrslRightmost";a._LATERAL_CLASSES="sapMCrslLeftmost sapMCrslRightmost";a._bIE9=(sap.ui.Device.browser.internet_explorer&&sap.ui.Device.browser.version<10);a._MODIFIERNUMBERFORKEYBOARDHANDLING=10;a.prototype.init=function(){this._aScrollContainers=[];this._fnAdjustAfterResize=q.proxy(function(){var $=this.$().find(a._INNER_SELECTOR);this._oMobifyCarousel.resize($);},this);this.data("sap-ui-fastnavgroup","true",true);};a.prototype.exit=function(){if(this._oMobifyCarousel){this._oMobifyCarousel.destroy();delete this._oMobifyCarousel;}if(this._oArrowLeft){this._oArrowLeft.destroy();delete this._oArrowLeft;}if(this._oArrowRight){this._oArrowRight.destroy();delete this._oArrowRight;}if(this._sResizeListenerId){sap.ui.core.ResizeHandler.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}this.$().off('afterSlide');this._cleanUpScrollContainer();this._fnAdjustAfterResize=null;this._aScrollContainers=null;this._$InnerDiv=null;};a.prototype._cleanUpScrollContainer=function(){var s;while(this.length>0){s=this._aScrollContainers.pop();s.removeAllContent();if(s&&typeof s.destroy==='function'){s.destroy();}}};a.prototype.ontouchstart=function(e){if(this._oMobifyCarousel){this._oMobifyCarousel.touchstart(e);}};a.prototype.ontouchmove=function(e){if(this._oMobifyCarousel){this._oMobifyCarousel.touchmove(e);}};a.prototype.ontouchend=function(e){if(this._oMobifyCarousel){this._oMobifyCarousel.touchend(e);}};a.prototype.onBeforeRendering=function(){var A=this.getActivePage();if(!A&&this.getPages().length>0){this.setAssociation("activePage",this.getPages()[0].getId(),true);}if(this._sResizeListenerId){sap.ui.core.ResizeHandler.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}return this;};a.prototype.onAfterRendering=function(){if(this._oMobifyCarousel){this._oMobifyCarousel.unbind();}this.$().carousel();this._oMobifyCarousel=this.getDomRef()._carousel;this._oMobifyCarousel.setLoop(this.getLoop());this._oMobifyCarousel.setRTL(sap.ui.getCore().getConfiguration().getRTL());var A=this.getActivePage();if(A){var i=this._getPageNumber(A);if(isNaN(i)||i==0){if(this.getPages().length>0){this.setAssociation("activePage",this.getPages()[0].getId(),true);this._adjustHUDVisibility(1);}}else{var c=sap.ui.getCore();if(c.isThemeApplied()){this._moveToPage(i+1);}else{c.attachThemeChanged(this._handleThemeLoad,this);}if(sap.zen&&sap.zen.commons&&this.getParent()instanceof sap.zen.commons.layout.PositionContainer){if(this._isCarouselUsedWithCommonsLayout===undefined){q.sap.delayedCall(0,this,"invalidate");this._isCarouselUsedWithCommonsLayout=true;}}}}this.$().on('afterSlide',q.proxy(function(e,P,n){if(e.target!==this.getDomRef()){return;}if(n>0){this._changePage(n);}},this));this._$InnerDiv=this.$().find(a._INNER_SELECTOR)[0];this._sResizeListenerId=sap.ui.core.ResizeHandler.register(this._$InnerDiv,this._fnAdjustAfterResize);this.$().find('.sapMCrslItemTableCell').focus(function(e){e.preventDefault();q(e.target).parents('.sapMCrsl').focus();return false;});var s='sap.m.IconTabBar';var p=this.getParent();while(p){if(p.getMetadata().getName()==s){var t=this;p.attachExpand(function(e){var E=e.getParameter('expand');if(E&&i>0){t._moveToPage(i+1);}});break;}p=p.getParent();}};a.prototype._handleThemeLoad=function(){var c,A=this.getActivePage();if(A){var i=this._getPageNumber(A);if(i>0){this._moveToPage(i+1);}}c=sap.ui.getCore();c.detachThemeChanged(this._handleThemeLoad,this);};a.prototype._moveToPage=function(i){this._oMobifyCarousel.changeAnimation('sapMCrslNoTransition');this._oMobifyCarousel.move(i);this._changePage(i);};a.prototype._changePage=function(n){this._adjustHUDVisibility(n);var o=this.getActivePage();var N=this.getPages()[n-1].getId();this.setAssociation("activePage",N,true);q.sap.log.debug("sap.m.Carousel: firing pageChanged event: old page: "+o+", new page: "+N);this.firePageChanged({oldActivePageId:o,newActivePageId:N});};a.prototype._adjustHUDVisibility=function(n){if(sap.ui.Device.system.desktop&&!this.getLoop()&&this.getPages().length>1){var h=this.$().find(a._HUD_SELECTOR);h.removeClass(a._LATERAL_CLASSES);if(n===1){h.addClass(a._LEFTMOST_CLASS);}else if(n===this.getPages().length){h.addClass(a._RIGHTMOST_CLASS);}}};a.prototype.setActivePage=function(p){var P=null;if(typeof(p)=='string'){P=p;}else if(p instanceof C){P=p.getId();}if(P){if(P===this.getActivePage()){return this;}var i=this._getPageNumber(P);if(!isNaN(i)){if(this._oMobifyCarousel){this._oMobifyCarousel.move(i+1);}}}this.setAssociation("activePage",P,true);return this;};a.prototype.setHeight=function(h){this.setProperty("height",h,true);this.$().css("height",h);return this;};a.prototype.setWidth=function(w){this.setProperty("width",w,true);this.$().css("width",w);return this;};a.prototype.setPageIndicatorPlacement=function(p){if(sap.m.PlacementType.Top!=p&&sap.m.PlacementType.Bottom!=p){p=sap.m.PlacementType.Bottom;}this.setProperty("pageIndicatorPlacement",p,true);var P=this.$().find(a._PAGE_INDICATOR_SELECTOR);if(sap.m.PlacementType.Top===p){this.$().prepend(P);P.removeClass('sapMCrslBottomOffset').addClass('sapMCrslTopOffset');this.$().find(a._ITEM_SELECTOR).removeClass('sapMCrslBottomOffset').addClass('sapMCrslTopOffset');}else{this.$().append(P);P.addClass('sapMCrslBottomOffset').removeClass('sapMCrslTopOffset');this.$().find(a._ITEM_SELECTOR).addClass('sapMCrslBottomOffset').removeClass('sapMCrslTopOffset');}return this;};a.prototype.setShowPageIndicator=function(s){var p=this.$().find(a._PAGE_INDICATOR_SELECTOR);s?p.show():p.hide();this.setProperty("showPageIndicator",s,true);return this;};a.prototype.setLoop=function(L){this.setProperty("loop",L,true);if(this._oMobifyCarousel){this._oMobifyCarousel.setLoop(L);}return this;};a.prototype._getNavigationArrow=function(n){q.sap.require("sap.ui.core.IconPool");var p={src:"sap-icon://navigation-"+n+"-arrow",useIconTooltip:false};if(n==="left"){if(!this._oArrowLeft){this._oArrowLeft=sap.m.ImageHelper.getImageControl(this.getId()+"-arrowScrollLeft",this._oArrowLeft,this,p);}return this._oArrowLeft;}else if(n==="right"){if(!this._oArrowRight){this._oArrowRight=sap.m.ImageHelper.getImageControl(this.getId()+"-arrowScrollRight",this._oArrowRight,this,p);}return this._oArrowRight;}};a.prototype._createScrollContainer=function(p){var c=p instanceof sap.m.Image?"sapMCrslItemTableCell sapMCrslImg":"sapMCrslItemTableCell",o=new sap.ui.core.HTML({content:"<div class='sapMCrslItemTable'>"+"<div class='"+c+"'></div>"+"</div>",afterRendering:function(e){var r=sap.ui.getCore().createRenderManager();r.render(p,this.getDomRef().firstChild);r.destroy();}});var s=new sap.m.ScrollContainer({horizontal:false,vertical:false,content:[o],width:'100%',height:'100%'});s.setParent(this,null,true);this._aScrollContainers.push(s);return s;};a.prototype.previous=function(){if(this._oMobifyCarousel){this._oMobifyCarousel.prev();}else{q.sap.log.warning("Unable to execute sap.m.Carousel.previous: carousel must be rendered first.");}return this;};a.prototype.next=function(){if(this._oMobifyCarousel){this._oMobifyCarousel.next();}else{q.sap.log.warning("Unable to execute sap.m.Carousel.next: carousel must be rendered first.");}return this;};a.prototype._getPageNumber=function(p){var i,r;for(i=0;i<this.getPages().length;i++){if(this.getPages()[i].getId()==p){r=i;break;}}return r;};a.prototype.onsaptabprevious=function(e){this._bDirection=false;this._fnOnTabPress(e);};a.prototype.onsaptabnext=function(e){this._bDirection=true;this._fnOnTabPress(e);};a.prototype.onfocusin=function(e){this.saveLastFocusReference(e);this._bDirection=undefined;};a.prototype.onsapskipforward=function(e){e.preventDefault();this._handleGroupNavigation(e,false);};a.prototype.onsapskipback=function(e){e.preventDefault();this._handleGroupNavigation(e,true);};a.prototype.onkeydown=function(e){if(e.keyCode==q.sap.KeyCodes.F7){this._handleF7Key(e);return;}if(e.target!=this.getDomRef()){return;}switch(e.keyCode){case 189:case q.sap.KeyCodes.NUMPAD_MINUS:this._fnSkipToIndex(e,-1);break;case q.sap.KeyCodes.PLUS:case q.sap.KeyCodes.NUMPAD_PLUS:this._fnSkipToIndex(e,1);break;}};a.prototype.onsapescape=function(e){var b;if(e.target===this.$()[0]&&this._lastActivePageNumber){b=this._lastActivePageNumber+1;this._oMobifyCarousel.move(b);this._changePage(b);}};a.prototype.onsapright=function(e){this._fnSkipToIndex(e,1);};a.prototype.onsapup=function(e){this._fnSkipToIndex(e,1);};a.prototype.onsapleft=function(e){this._fnSkipToIndex(e,-1);};a.prototype.onsapdown=function(e){this._fnSkipToIndex(e,-1);};a.prototype.onsaphome=function(e){this._fnSkipToIndex(e,0);};a.prototype.onsapend=function(e){this._fnSkipToIndex(e,this.getPages().length);};a.prototype.onsaprightmodifiers=function(e){if(e.ctrlKey){this._fnSkipToIndex(e,a._MODIFIERNUMBERFORKEYBOARDHANDLING);}};a.prototype.onsapupmodifiers=function(e){if(e.ctrlKey){this._fnSkipToIndex(e,a._MODIFIERNUMBERFORKEYBOARDHANDLING);}};a.prototype.onsappageup=function(e){this._fnSkipToIndex(e,a._MODIFIERNUMBERFORKEYBOARDHANDLING);};a.prototype.onsapleftmodifiers=function(e){if(e.ctrlKey){this._fnSkipToIndex(e,-a._MODIFIERNUMBERFORKEYBOARDHANDLING);}};a.prototype.onsapdownmodifiers=function(e){if(e.ctrlKey){this._fnSkipToIndex(e,-a._MODIFIERNUMBERFORKEYBOARDHANDLING);}};a.prototype.onsappagedown=function(e){this._fnSkipToIndex(e,-a._MODIFIERNUMBERFORKEYBOARDHANDLING);};a.prototype._fnOnTabPress=function(e){if(e.target===this.$()[0]){this._lastActivePageNumber=this._getPageNumber(this.getActivePage());}};a.prototype._handleGroupNavigation=function(e,s){var E=q.Event("keydown");e.preventDefault();this.$().focus();E.target=e.target;E.keyCode=q.sap.KeyCodes.F6;E.shiftKey=s;q.sap.handleF6GroupNavigation(E);};a.prototype.saveLastFocusReference=function(e){if(this._bDirection===undefined){return;}if(this._lastFocusablePageElement===undefined){this._lastFocusablePageElement={};}this._lastFocusablePageElement[this.getActivePage()]=e.target;};a.prototype._getActivePageLastFocusedElement=function(){if(this._lastFocusablePageElement){return this._lastFocusablePageElement[this.getActivePage()];}};a.prototype._fnSkipToIndex=function(e,n){var b=n;if(e.target!==this.getDomRef()){return;}e.preventDefault();if(n!==0){b=this._getPageNumber(this.getActivePage())+1+n;}this._oMobifyCarousel.move(b);};a.prototype._handleF7Key=function(e){var A;e.preventDefault();A=this._getActivePageLastFocusedElement();if(e.target===this.$()[0]&&A){A.focus();}else{this.$().focus();}};a.prototype.setShowBusyIndicator=function(){q.sap.log.warning("sap.m.Carousel: Deprecated function 'setShowBusyIndicator' called. Does nothing.");return this;};a.prototype.getShowBusyIndicator=function(){q.sap.log.warning("sap.m.Carousel: Deprecated function 'getShowBusyIndicator' called. Does nothing.");return false;};a.prototype.setBusyIndicatorSize=function(){q.sap.log.warning("sap.m.Carousel: Deprecated function 'setBusyIndicatorSize' called. Does nothing.");return this;};a.prototype.getBusyIndicatorSize=function(){q.sap.log.warning("sap.m.Carousel: Deprecated function 'getBusyIndicatorSize' called. Does nothing.");return"";};return a;},true);
