/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./DatePicker','./library'],function(q,D,l){"use strict";var a=D.extend("sap.m.DateRangeSelection",{metadata:{library:"sap.m",properties:{delimiter:{type:"string",group:"Misc",defaultValue:'-'},secondDateValue:{type:"object",group:"Data",defaultValue:null},from:{type:"object",group:"Misc",defaultValue:null,deprecated:true},to:{type:"object",group:"Misc",defaultValue:null,deprecated:true}}}});a.prototype.init=function(){D.prototype.init.apply(this,arguments);this._bIntervalSelection=true;};a.prototype.onkeypress=function(e){if(!e.charCode||e.metaKey||e.ctrlKey){return;}var f=d.call(this);var s=c.call(this);var A=f.sAllowedCharacters+s+" ";var C=String.fromCharCode(e.charCode);if(C&&f.sAllowedCharacters&&A.indexOf(C)<0){e.preventDefault();}};a.prototype._getPlaceholder=function(){var p=this.getPlaceholder();if(!p){p=this.getDisplayFormat();if(!p){p="medium";}if(this._checkStyle(p)){var L=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale();var o=sap.ui.core.LocaleData.getInstance(L);p=o.getDatePattern(p);}var s=c.call(this);if(s&&s!==""){p=p+" "+s+" "+p;}}return p;};a.prototype.setValue=function(v){if(v!==this.getValue()){this._lastValue=v;}else{return this;}this.setProperty("value",v,true);this._bValid=true;var e=[undefined,undefined];if(v){e=this._parseValue(v);this._oWantedDate=e[0];this._oWantedSecondDate=e[1];e=b.call(this,e[0],e[1]);if(!e[0]){this._bValid=false;q.sap.log.warning("Value can not be converted to a valid dates",this);}}if(this._bValid){this.setProperty("dateValue",e[0],true);this.setProperty("secondDateValue",e[1],true);this._oWantedDate=undefined;this._oWantedSecondDate=undefined;}if(this.getDomRef()){var o=this._formatValue(e[0],e[1]);if(this._$input.val()!==o){this._$input.val(o);this._setLabelVisibility();this._curpos=this._$input.cursorPos();}}return this;};a.prototype.setValueFormat=function(v){this.setProperty("valueFormat",v,true);q.sap.log.warning("Property valueFormat is not supported in sap.m.DateRangeSelection control.",this);return this;};a.prototype.setDisplayFormat=function(s){this.setProperty("displayFormat",s,true);var o=this._formatValue(this.getDateValue(),this.getSecondDateValue());this.setProperty("value",o,true);if(this.getDomRef()&&(this._$input.val()!==o)){this._$input.val(o);this._curpos=this._$input.cursorPos();}return this;};a.prototype.setFrom=function(f){this.setDateValue(f);return this;};a.prototype.getFrom=function(){return this.getDateValue();};a.prototype.setTo=function(t){this.setSecondDateValue(t);return this;};a.prototype.getTo=function(){return this.getSecondDateValue();};a.prototype.setDateValue=function(o){if(o&&!(o instanceof Date)){throw new Error("Date must be a JavaScript date object; "+this);}if(q.sap.equal(this.getDateValue(),o)){return this;}if(o&&(o.getTime()<this._oMinDate.getTime()||o.getTime()>this._oMaxDate.getTime())){this._bValid=false;this._oWantedDate=o;o=undefined;}else{this._bValid=true;this.setProperty("dateValue",o,true);this._oWantedDate=undefined;}var s=this.getSecondDateValue();var v=this._formatValue(o,s);if(v!==this.getValue()){this._lastValue=v;}this.setProperty("value",v,true);if(this.getDomRef()){var O=this._formatValue(o,s);if(this._$input.val()!==O){this._$input.val(O);this._setLabelVisibility();this._curpos=this._$input.cursorPos();}}return this;};a.prototype.setSecondDateValue=function(s){if(s&&!(s instanceof Date)){throw new Error("Date must be a JavaScript date object; "+this);}if(q.sap.equal(this.getSecondDateValue(),s)){return this;}if(s&&(s.getTime()<this._oMinDate.getTime()||s.getTime()>this._oMaxDate.getTime())){this._bValid=false;this._oWantedSecondDate=s;s=undefined;}else{this._bValid=true;this.setProperty("secondDateValue",s,true);this._oWantedSecondDate=undefined;}var o=this.getDateValue();var v=this._formatValue(o,s);if(v!==this.getValue()){this._lastValue=v;}this.setProperty("value",v,true);if(this.getDomRef()){var O=this._formatValue(o,s);if(this._$input.val()!==O){this._$input.val(O);this._setLabelVisibility();this._curpos=this._$input.cursorPos();}}return this;};a.prototype.setMinDate=function(o){D.prototype.setMinDate.apply(this,arguments);if(o){var s=this.getSecondDateValue();if(s&&s.getTime()<this._oMinDate.getTime()){q.sap.log.warning("SecondDateValue not in valid date -> changed to minDate",this);this.setSecondDateValue(new Date(this._oMinDate.getTime()));}}return this;};a.prototype.setMaxDate=function(o){D.prototype.setMaxDate.apply(this,arguments);if(o){var s=this.getSecondDateValue();if(s&&s.getTime()>this._oMaxDate.getTime()){q.sap.log.warning("SecondDateValue not in valid date -> changed to maxDate",this);this.setSecondDateValue(new Date(this._oMaxDate.getTime()));}}return this;};a.prototype._checkMinMaxDate=function(){D.prototype._checkMinMaxDate.apply(this,arguments);if(this._oWantedSecondDate&&this._oWantedSecondDate.getTime()>=this._oMinDate.getTime()&&this._oWantedSecondDate.getTime()<=this._oMaxDate.getTime()){this.setSecondDateValue(this._oWantedSecondDate);}};a.prototype._parseValue=function(v){var f;var e=[];var o,g;var s=c.call(this);if((s&&s!=="")&&v){e=v.split(s);if(e.length===2){if(e[0].slice(e[0].length-1,e[0].length)==" "){e[0]=e[0].slice(0,e[0].length-1);}if(e[1].slice(0,1)==" "){e[1]=e[1].slice(1);}}else{e=v.split(" "+s+" ");}if(e.length<2){var h=v.split(" ");if(h.length===2){e=h;}}}if(v&&e.length<=2){f=d.call(this);if((!s||s==="")||e.length===1){o=f.parse(v);}else if(e.length===2){o=f.parse(e[0]);g=f.parse(e[1]);if(!o||!g){o=undefined;g=undefined;}}}return[o,g];};a.prototype._formatValue=function(o,s){var v="";var e=c.call(this);if(o){var f;f=d.call(this);if(e&&e!==""&&s){v=f.format(o)+" "+e+" "+f.format(s);}else{v=f.format(o);}}return v;};a.prototype.onChange=function(){if(!this.getEditable()||!this.getEnabled()){return;}var v=this._$input.val();var e=[undefined,undefined];this._oWantedDate=undefined;this._oWantedSecondDate=undefined;this._bValid=true;if(v!=""){e=this._parseValue(v);e=b.call(this,e[0],e[1]);if(e[0]){v=this._formatValue(e[0],e[1]);}else{this._bValid=false;}}if(v!==this._lastValue){if(this.getDomRef()&&(this._$input.val()!==v)){this._$input.val(v);this._curpos=this._$input.cursorPos();}this._lastValue=v;this.setProperty("value",v,true);if(this._bValid){this.setProperty("dateValue",e[0],true);this.setProperty("secondDateValue",e[1],true);}this._setLabelVisibility();if(this._oPopup&&this._oPopup.isOpen()){var s=this.getDateValue();if(s){if(!this._oDateRange.getStartDate()||this._oDateRange.getStartDate().getTime()!==s.getTime()){this._oDateRange.setStartDate(new Date(s.getTime()));this._oCalendar.focusDate(s);}}else{if(this._oDateRange.getStartDate()){this._oDateRange.setStartDate(undefined);}}var E=this.getSecondDateValue();if(E){if(!this._oDateRange.getEndDate()||this._oDateRange.getEndDate().getTime()!==E.getTime()){this._oDateRange.setEndDate(new Date(E.getTime()));this._oCalendar.focusDate(E);}}else{if(this._oDateRange.getEndDate()){this._oDateRange.setEndDate(undefined);}}}_.call(this,this._bValid);}};a.prototype._getInputValue=function(v){v=(typeof v=="undefined")?this._$input.val():v.toString();var e=this._parseValue(v);v=this._formatValue(e[0],e[1]);return v;};a.prototype.updateDomValue=function(v){this._bCheckDomValue=true;v=(typeof v=="undefined")?this._$input.val():v.toString();this._curpos=this._$input.cursorPos();var e=this._parseValue(v);v=this._formatValue(e[0],e[1]);if(this.isActive()&&(this._$input.val()!==v)){this._$input.val(v);this._$input.cursorPos(this._curpos);}this._setLabelVisibility();return this;};a.prototype.onsappageup=function(){};a.prototype.onsappageupmodifiers=function(){};a.prototype.onsappagedown=function(){};a.prototype.onsappagedownmodifiers=function(){};a.prototype._fillDateRange=function(){D.prototype._fillDateRange.apply(this,arguments);var e=this.getSecondDateValue();if(e){if(!this._oDateRange.getEndDate()||this._oDateRange.getEndDate().getTime()!==e.getTime()){this._oDateRange.setEndDate(new Date(e.getTime()));}}else{if(this._oDateRange.getEndDate()){this._oDateRange.setEndDate(undefined);}}};a.prototype._selectDate=function(e){var s=this._oCalendar.getSelectedDates();if(s.length>0){var o=s[0].getStartDate();var f=s[0].getEndDate();if(o&&f){var g=this.getDateValue();var h=this.getSecondDateValue();this._oPopup.close();this._bFocusNoPopup=true;this.focus();var v;if(!q.sap.equal(o,g)||!q.sap.equal(f,h)){if(q.sap.equal(f,h)){this.setDateValue(o);}else{this.setProperty("dateValue",o,true);this.setSecondDateValue(f);}v=this.getValue();_.call(this,true);this._curpos=v.length;this._$input.cursorPos(this._curpos);}else if(!this._bValid){v=this._formatValue(o,f);if(v!=this._$input.val()){this._bValid=true;if(this.getDomRef()){this._$input.val(v);}_.call(this,true);}}if(sap.ui.Device.browser.mobile){window.document.activeElement.blur();}}}};a.prototype.getAccessibilityInfo=function(){var r=this.getRenderer();var i=D.prototype.getAccessibilityInfo.apply(this,arguments);var v=this.getValue()||"";if(this._bValid){var o=this.getDateValue();if(o){v=this._formatValue(o,this.getSecondDateValue());}}i.description=[v,r.getLabelledByAnnouncement(this),r.getDescribedByAnnouncement(this)].join(" ").trim();return i;};function _(v){this.fireChangeEvent(this.getValue(),{from:this.getDateValue(),to:this.getSecondDateValue(),valid:v});}function b(o,s){if(o&&s&&o.getTime()>s.getTime()){var t=o;o=s;s=t;}if((o&&(o.getTime()<this._oMinDate.getTime()||o.getTime()>this._oMaxDate.getTime()))||(s&&(s.getTime()<this._oMinDate.getTime()||s.getTime()>this._oMaxDate.getTime()))){return[undefined,undefined];}else{return[o,s];}}function c(){var s=this.getDelimiter();if(!s){if(!this._sLocaleDelimiter){var L=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale();var o=sap.ui.core.LocaleData.getInstance(L);var p=o.getIntervalPattern();var i=p.indexOf("{0}")+3;var I=p.indexOf("{1}");s=p.slice(i,I);if(s.length>1){if(s.slice(0,1)==" "){s=s.slice(1);}if(s.slice(s.length-1,s.length)==" "){s=s.slice(0,s.length-1);}}this._sLocaleDelimiter=s;}else{s=this._sLocaleDelimiter;}}return s;}function d(){var p=(this.getDisplayFormat()||"medium");var f;var C=this.getDisplayFormatType();if(p==this._sUsedDisplayPattern&&C==this._sUsedDisplayCalendarType){f=this._oDisplayFormat;}else{if(this._checkStyle(p)){f=sap.ui.core.format.DateFormat.getInstance({style:p,strictParsing:true,calendarType:C});}else{f=sap.ui.core.format.DateFormat.getInstance({pattern:p,strictParsing:true,calendarType:C});}this._sUsedDisplayPattern=p;this._sUsedDisplayCalendarType=C;this._oDisplayFormat=f;}return f;}return a;},true);
