/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["jquery.sap.global","./library","sap/ui/core/Control","sap/ui/core/ScrollBar","sap/ui/core/ResizeHandler","sap/ui/Device"],function(q,l,C,S,R,D){"use strict";var a=C.extend("sap.m.DynamicPage",{metadata:{library:"sap.m",properties:{headerScrollable:{type:"boolean",group:"Behaviour",defaultValue:true},headerExpanded:{type:"boolean",group:"Behaviour",defaultValue:true},showFooter:{type:"boolean",group:"Behaviour",defaultValue:false}},aggregations:{title:{type:"sap.m.DynamicPageTitle",multiple:false},header:{type:"sap.m.ISnappable",multiple:false},content:{type:"sap.ui.core.Control",multiple:false},footer:{type:"sap.m.IBar",multiple:false},_scrollBar:{type:"sap.ui.core.ScrollBar",multiple:false,visibility:"hidden"}}}});function e(o){if(arguments.length===1){return Array.isArray(o)?o.length>0:!!o;}return Array.prototype.slice.call(arguments).every(function(O){return e(O);});}var u=sap.ui.getCore().getConfiguration().getAnimation();a.HEADER_MAX_ALLOWED_PINNED_PERCENTAGE=0.6;a.HEADER_MAX_ALLOWED_NON_SROLLABLE_PERCENTAGE=0.6;a.FOOTER_ANIMATION_DURATION=350;a.BREAK_POINTS={TABLET:1024,PHONE:600};a.EVENTS={TITLE_PRESS:"_titlePress",PIN_UNPIN_PRESS:"_pinUnpinPress"};a.MEDIA={INVISIBLE:"sapUiHidden",PHONE:"sapMDynamicPage-Std-Phone",TABLET:"sapMDynamicPage-Std-Tablet",DESKTOP:"sapMDynamicPage-Std-Desktop"};a.prototype.init=function(){this._bPinned=false;this._bHeaderInTitleArea=false;this._bExpandingWithAClick=false;this._headerBiggerThanAllowedHeight=false;};a.prototype.onBeforeRendering=function(){if(this._allowScroll()){this._attachPinPressHandler();}this._attachTitlePressHandler();this._detachScrollHandler();};a.prototype.onAfterRendering=function(){var h=this._allowScroll();if(!h&&e(this.getHeader())){this.getHeader()._setShowPinBtn(false);}this._cacheDomElements();this._detachResizeHandlers();this._attachResizeHandlers();this._updateMedia(this._getWidth(this));if(h){this._attachScrollHandler();this._updateScrollBar();this._attachPageChildrenAfterRenderingDelegates();}else{q.sap.delayedCall(0,this,this._overrideHeaderNotScrollableRule);}};a.prototype.exit=function(){this._detachResizeHandlers();};a.prototype.setShowFooter=function(s){var r=this.setProperty("showFooter",s,true);this._toggleFooter(s);return r;};a.prototype.setHeaderExpanded=function(h){if(this.getHeaderExpanded()===h){return this;}this._titleExpandCollapseWhenAllowed();return this;};a.prototype._overrideHeaderNotScrollableRule=function(){var h=this._allowScroll();if(!D.system.desktop&&this._headerBiggerThanAllowedToBeFixed()&&!h){this._headerBiggerThanAllowedHeight=true;this.invalidate();return true;}else{this._headerBiggerThanAllowedHeight=false;return false;}};a.prototype._toggleFooter=function(s){var f=this.getFooter();if(!e(f)){return;}f.toggleStyleClass("sapMDynamicPageActualFooterControlShow",s);f.toggleStyleClass("sapMDynamicPageActualFooterControlHide",!s);this.toggleStyleClass("sapMDynamicPageFooterSpacer",s);if(u){if(!s){q.sap.delayedCall(a.FOOTER_ANIMATION_DURATION,this,function(){this.$footerWrapper.toggleClass("sapUiHidden",!this.getShowFooter());});}else{this.$footerWrapper.toggleClass("sapUiHidden",!this.getShowFooter());}q.sap.delayedCall(a.FOOTER_ANIMATION_DURATION,this,function(){f.removeStyleClass("sapMDynamicPageActualFooterControlShow");});}};a.prototype._toggleHeader=function(){if(this._shouldSnap()){this._snapHeader(true);this._updateHeaderARIAState(false);}else if(this._shouldExpand()){this._expandHeader();this._updateHeaderARIAState(true);}else if(!this._bPinned&&this._bHeaderInTitleArea){this._moveHeaderToContentArea();}};a.prototype._snapHeader=function(A){var d=this.getTitle();if(this._bPinned){q.sap.log.debug("DynamicPage :: aborted snapping, header is pinned",this);return;}q.sap.log.debug("DynamicPage :: snapped header",this);if(e(d)){if(e(d.getExpandedContent())){d._setShowExpandContent(false);}if(e(d.getSnappedContent())){d._setShowSnapContent(true);}if(A){this._moveHeaderToContentArea();}}if(!e(this.$titleArea)){q.sap.log.warning("DynamicPage :: couldn't snap header. There's no title.",this);return;}this.setProperty("headerExpanded",false,true);this.$titleArea.addClass("sapMDynamicPageTitleSnapped");};a.prototype._expandHeader=function(A){var d=this.getTitle();q.sap.log.debug("DynamicPage :: expand header",this);if(e(d)){if(e(d.getExpandedContent())){d._setShowExpandContent(true);}if(e(d.getSnappedContent())){d._setShowSnapContent(false);}if(A){this._moveHeaderToTitleArea();}}if(!e(this.$titleArea)){q.sap.log.warning("DynamicPage :: couldn't expand header. There's no title.",this);return;}this.setProperty("headerExpanded",true,true);this.$titleArea.removeClass("sapMDynamicPageTitleSnapped");};a.prototype._toggleHeaderVisibility=function(s){var d=this.getHeader();if(e(d)){d.$().toggleClass("sapMDynamicPageHeaderHidden",!s);}};a.prototype._moveHeaderToContentArea=function(){var d=this.getHeader();if(e(d)){d.$().prependTo(this.$wrapper);this._bHeaderInTitleArea=false;}};a.prototype._moveHeaderToTitleArea=function(){var d=this.getHeader();if(e(d)){d.$().appendTo(this.$titleArea);this._bHeaderInTitleArea=true;}};a.prototype._scrollToSnapHeader=function(){var n=this._getSnappingHeight()+1;this.$wrapper&&this.$wrapper.scrollTop(n);D.system.desktop&&this._getScrollBar().setScrollPosition(n);};a.prototype._pin=function(){if(!this._bPinned){this._bPinned=true;this._moveHeaderToTitleArea();this.getHeader()._updateARIAPinButtonState(this._bPinned);}};a.prototype._unPin=function(){if(this._bPinned){this._bPinned=false;this.getHeader()._updateARIAPinButtonState(this._bPinned);}};a.prototype._restorePinButtonFocus=function(){this.getHeader()._focusPinButton();};a.prototype._getScrollPosition=function(){if(D.system.desktop){return this._getScrollBar().getScrollPosition();}else{return this.$wrapper.scrollTop();}};a.prototype._shouldSnap=function(){return this._allowScroll()&&this._getScrollPosition()>this._getSnappingHeight()&&this.getHeaderExpanded()&&!this._bPinned;};a.prototype._shouldExpand=function(){return this._allowScroll()&&this._getScrollPosition()<this._getSnappingHeight()&&!this.getHeaderExpanded()&&!this._bPinned;};a.prototype._headerScrolledOut=function(){return this._getScrollPosition()>this._getSnappingHeight();};a.prototype._headerSnapAllowed=function(){return this._allowScroll()&&this.getHeaderExpanded()&&!this._bPinned;};a.prototype._canSnap=function(){return this._getSnappingHeight()?this.$wrapper[0].scrollHeight>this._getSnappingHeight()&&this._allowScroll():false;};a.prototype._getSnappingHeight=function(){return this._getHeaderHeight()||this._getTitleHeight();};a.prototype._needsVerticalScrollBar=function(){var $;if(e(this.$wrapper)){$=this.$wrapper[0];return $.scrollHeight>Math.ceil($.getBoundingClientRect().height);}else{return false;}};a.prototype._getOwnHeight=function(){return this._getHeight(this);};a.prototype._getEntireHeaderHeight=function(){var t=0,h=0,d=this.getTitle(),o=this.getHeader();if(e(d)){t=d.$().outerHeight();}if(e(o)){h=o.$().outerHeight();}return t+h;};a.prototype._headerBiggerThanAllowedToExpandWithACommand=function(){return this._getEntireHeaderHeight()>this._getOwnHeight();};a.prototype._headerBiggerThanAllowedToPin=function(c){if(!(typeof c==="number"&&!isNaN(parseInt(c,10)))){c=this._getOwnHeight();}return this._getEntireHeaderHeight()>a.HEADER_MAX_ALLOWED_PINNED_PERCENTAGE*c;};a.prototype._headerBiggerThanAllowedToBeFixed=function(){var c=this._getOwnHeight();return this._getEntireHeaderHeight()>a.HEADER_MAX_ALLOWED_NON_SROLLABLE_PERCENTAGE*c;};a.prototype._measureOffsetHeight=function(){var h=0,s=!this.getHeaderExpanded();if(!this._allowScroll()||this._bPinned){h=this._getTitleHeight()+this._getHeaderHeight();q.sap.log.debug("DynamicPage :: always show header :: title height + header height"+h,this);return h;}if(s||!e(this.getTitle())||!this._canSnap()){h=this._getTitleHeight();q.sap.log.debug("DynamicPage :: snapped mode :: title height "+h,this);return h;}this._snapHeader(true);h=this._getTitleHeight();if(this._shouldExpand()&&!s){this._expandHeader();}q.sap.log.debug("DynamicPage :: snapped mode :: title height "+h,this);return h;};a.prototype._updateScrollBar=function(){var s;if(D.system.desktop&&this._allowScroll()){s=this._getScrollBar();s.setContentSize(this._measureOffsetHeight()+this.$wrapper[0].scrollHeight+"px");s.toggleStyleClass("sapUiHidden",!this._needsVerticalScrollBar());this.toggleStyleClass("sapMDynamicPageWithScroll",this._needsVerticalScrollBar());}q.sap.delayedCall(0,this,this._updateScrollBarOffset);};a.prototype._updateScrollBarOffset=function(){var s=sap.ui.getCore().getConfiguration().getRTL()?"left":"right",o=this._needsVerticalScrollBar()?q.position.scrollbarWidth()+"px":0,f=this.getFooter();this.$titleArea.css("padding-"+s,o);if(e(f)){f.$().css(s,o);}};a.prototype._updateHeaderARIAState=function(E){var d=this.getHeader();if(e(d)){d._updateARIAState(E);}};a.prototype._updateMedia=function(w){if(w===0){this._updateMediaStyle(a.MEDIA.INVISIBLE);}else if(w<=a.BREAK_POINTS.PHONE){this._updateMediaStyle(a.MEDIA.PHONE);}else if(w<=a.BREAK_POINTS.TABLET){this._updateMediaStyle(a.MEDIA.TABLET);}else{this._updateMediaStyle(a.MEDIA.DESKTOP);}};a.prototype._updateMediaStyle=function(c){Object.keys(a.MEDIA).forEach(function(m){var E=c===a.MEDIA[m];this.toggleStyleClass(a.MEDIA[m],E);},this);};a.prototype._updateSnappedExpandedContent=function(){var d=this.getTitle();if(e(d)){d._setShowSnapContent(d._getShowSnapContent());d._setShowExpandContent(d._getShowExpandContent());}};a.prototype._getHeight=function(c){return!(c instanceof C)?0:c.$().outerHeight()||0;};a.prototype._getWidth=function(c){return!(c instanceof C)?0:c.$().outerWidth()||0;};a.prototype._getTitleHeight=function(){return this._getHeight(this.getTitle());};a.prototype._getHeaderHeight=function(){return this._getHeight(this.getHeader());};a.prototype._allowScroll=function(){return this._headerBiggerThanAllowedHeight||this.getHeaderScrollable();};a.prototype._getScrollBar=function(){if(!e(this.getAggregation("_scrollBar"))){var v=new S(this.getId()+"-vertSB",{vertical:true,size:"100%",scrollPosition:0,scroll:this._onScrollBarScroll.bind(this)});this.setAggregation("_scrollBar",v,true);}return this.getAggregation("_scrollBar");};a.prototype._cacheDomElements=function(){var t=this.getTitle(),f=this.getFooter();if(e(t)){this.$title=t.$();}if(e(f)){this.$footer=f.$();this.$footerWrapper=this.$("footerWrapper");}this.$titleArea=this.$("header");this.$wrapper=this.$("contentWrapper");this.$content=this.$("content");};a.prototype.ontouchmove=function(E){E.setMarked();};a.prototype._onChildControlsAfterRendering=function(){this._updateSnappedExpandedContent();q.sap.delayedCall(0,this,this._updateScrollBar);};a.prototype._onChildControlsHeightChange=function(E){if(E.size.height!==E.oldSize.height&&!this._bExpandingWithAClick){this._updateScrollBar();}this._bExpandingWithAClick=false;};a.prototype._onResize=function(E){var d=this.getHeader();if(this._allowScroll()&&d){if(this._headerBiggerThanAllowedToPin(E.size.height)||D.system.phone){this._unPin();d._setShowPinBtn(false);d._togglePinButton(false);}else{d._setShowPinBtn(true);}}this._updateScrollBar();this._updateMedia(E.size.width);};a.prototype._onWrapperScroll=function(E){if(!D.system.desktop||!this._bExpandingWithAClick){this._toggleHeader();}if(D.system.desktop&&this._allowScroll()){if(this.allowCustomScroll===true&&E.target.scrollTop>0){this.allowCustomScroll=false;return;}this.allowInnerDiv=true;this._getScrollBar().setScrollPosition(E.target.scrollTop);this.toggleStyleClass("sapMDynamicPageWithScroll",this._needsVerticalScrollBar());}};a.prototype._onScrollBarScroll=function(){this._toggleHeader();if(this.allowInnerDiv===true){this.allowInnerDiv=false;return;}this.allowCustomScroll=true;this.$wrapper.scrollTop(this._getScrollBar().getScrollPosition());};a.prototype._titleExpandCollapseWhenAllowed=function(){if(this._headerBiggerThanAllowedToExpandWithACommand()){q.sap.log.warning("DynamicPage :: couldn't expand header. There isn't enough space for it to fit on the screen",this);return;}if(!this._allowScroll()||!this._needsVerticalScrollBar()){if(!this.getHeaderExpanded()){this._toggleHeaderVisibility(true);this._expandHeader(false);}else{this._toggleHeaderVisibility(false);this._snapHeader(false);}}else if(!this.getHeaderExpanded()){this._bExpandingWithAClick=true;this._expandHeader(true);}else if(this._headerSnapAllowed()){if(this._headerScrolledOut()){this._snapHeader(true);}else{this._scrollToSnapHeader();}}};a.prototype._onPinUnpinButtonPress=function(E){if(this._bPinned){this._unPin(E);}else{this._pin(E);this._restorePinButtonFocus();}};a.prototype._attachResizeHandlers=function(){var c=this._onChildControlsHeightChange.bind(this);if(!this._sResizeHandlerId){this._sResizeHandlerId=R.register(this,this._onResize.bind(this));}if(!this._sTitleResizeHandlerId&&e(this.$title)){this._sTitleResizeHandlerId=R.register(this.$title[0],c);}if(!this._sContentResizeHandlerId&&e(this.$content)){this._sContentResizeHandlerId=R.register(this.$content[0],c);}};a.prototype._detachResizeHandlers=function(){this._deRegisterHandler("_sResizeHandlerId");this._deRegisterHandler("_sTitleResizeHandlerId");this._deRegisterHandler("_sContentResizeHandlerId");};a.prototype._deRegisterHandler=function(h){if(this[h]){R.deregister(this[h]);this[h]=null;}};a.prototype._attachPageChildrenAfterRenderingDelegates=function(){var t=this.getTitle(),c=this.getContent(),o={onAfterRendering:this._onChildControlsAfterRendering.bind(this)};if(e(t)){t.addEventDelegate(o);}if(e(c)){c.addEventDelegate(o);}};a.prototype._attachTitlePressHandler=function(){var t=this.getTitle();if(e(t)&&!this._bAlreadyAttachedTitlePressHandler){t.attachEvent(a.EVENTS.TITLE_PRESS,this._titleExpandCollapseWhenAllowed,this);this._bAlreadyAttachedTitlePressHandler=true;}};a.prototype._attachPinPressHandler=function(){var h=this.getHeader();if(e(h)&&!this._bAlreadyAttachedPinPressHandler){h.attachEvent(a.EVENTS.PIN_UNPIN_PRESS,this._onPinUnpinButtonPress,this);this._bAlreadyAttachedPinPressHandler=true;}};a.prototype._attachScrollHandler=function(){this.$wrapper.on("scroll",this._onWrapperScroll.bind(this));};a.prototype._detachScrollHandler=function(){if(this.$wrapper){this.$wrapper.unbind("scroll");}};return a;},false);
