/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./library','sap/ui/core/Control','sap/ui/core/EnabledPropagator','sap/ui/core/IconPool','sap/ui/core/Popup','./delegate/ValueStateMessage'],function(q,l,C,E,I,P,V){"use strict";var a=C.extend("sap.m.InputBase",{metadata:{library:"sap.m",properties:{value:{type:"string",group:"Data",defaultValue:null,bindable:"bindable"},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},enabled:{type:"boolean",group:"Behavior",defaultValue:true},valueState:{type:"sap.ui.core.ValueState",group:"Appearance",defaultValue:sap.ui.core.ValueState.None},name:{type:"string",group:"Misc",defaultValue:null},placeholder:{type:"string",group:"Misc",defaultValue:null},editable:{type:"boolean",group:"Behavior",defaultValue:true},valueStateText:{type:"string",group:"Misc",defaultValue:null},showValueStateMessage:{type:"boolean",group:"Misc",defaultValue:true},textAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:sap.ui.core.TextAlign.Initial},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:sap.ui.core.TextDirection.Inherit},required:{type:"boolean",group:"Misc",defaultValue:false}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{change:{parameters:{value:{type:"string"}}}}}});E.call(a.prototype);I.insertFontFaceStyle();a.prototype.bShowLabelAsPlaceholder=!sap.ui.Device.support.input.placeholder;a.prototype._getPlaceholder=function(){return this.getPlaceholder();};a.prototype._setLabelVisibility=function(){if(!this.bShowLabelAsPlaceholder){return;}var v=this.$("inner").val();this.$("placeholder").css("display",v?"none":"inline");};a.prototype._getInputValue=function(v){v=(v===undefined)?this.$("inner").val()||"":v.toString();if(this.getMaxLength&&this.getMaxLength()>0){v=v.substring(0,this.getMaxLength());}return v;};a.prototype._triggerInputEvent=function(p){p=p||{};var e=new q.Event("input",p);e.originalEvent=p;e.setMark("synthetic",true);q.sap.delayedCall(0,this,function(){this.$("inner").trigger(e);});};a.prototype._getInputElementTagName=function(){if(!this._sInputTagElementName){this._sInputTagElementName=this._$input&&this._$input.get(0)&&this._$input.get(0).tagName;}return this._sInputTagElementName;};a.prototype.init=function(){this._lastValue="";this.bRenderingPhase=false;this.bFocusoutDueRendering=false;this._oValueStateMessage=new V(this);};a.prototype.onBeforeRendering=function(){if(this._bCheckDomValue&&!this.bRenderingPhase){this._sDomValue=this._getInputValue();}this.bRenderingPhase=true;};a.prototype.onAfterRendering=function(){if(this._bCheckDomValue&&this._sDomValue!==this._getInputValue()){this.$("inner").val(this._sDomValue);}this._bCheckDomValue=false;this._setLabelVisibility();this.bRenderingPhase=false;};a.prototype.exit=function(){if(this._oValueStateMessage){this._oValueStateMessage.destroy();}this._oValueStateMessage=null;};a.prototype.ontouchstart=function(e){e.setMarked();};a.prototype.onfocusin=function(e){this._bIgnoreNextInput=!this.bShowLabelAsPlaceholder&&sap.ui.Device.browser.msie&&sap.ui.Device.browser.version>9&&!!this.getPlaceholder()&&!this._getInputValue()&&this._getInputElementTagName()==="INPUT";this.$().toggleClass("sapMFocus",true);if(this.shouldValueStateMessageBeOpened()){this.openValueStateMessage();}};a.prototype.onfocusout=function(e){this.bFocusoutDueRendering=this.bRenderingPhase;this.$().toggleClass("sapMFocus",false);if(this.bRenderingPhase){return;}this.closeValueStateMessage();};a.prototype.onsapfocusleave=function(e){if(this.bFocusoutDueRendering){return;}this.onChange(e);};a.prototype.ontap=function(e){if(this.getEnabled()&&this.getEditable()&&this.bShowLabelAsPlaceholder&&e.target.id===this.getId()+"-placeholder"){this.focus();}};a.prototype.onChange=function(e){if(!this.getEditable()||!this.getEnabled()){return;}var v=this._getInputValue();if(v!==this._lastValue){this.setValue(v);v=this.getValue();this._lastValue=v;this.fireChangeEvent(v);return true;}};a.prototype.fireChangeEvent=function(v,p){var c=q.extend({value:v,newValue:v},p);this.fireChange(c);};a.prototype.onValueRevertedByEscape=function(v){this.fireEvent("liveChange",{value:v,newValue:v});};a.prototype.onsapenter=function(e){this.onChange(e);};a.prototype.onsapescape=function(e){var v=this._getInputValue();if(v!==this._lastValue){e.setMarked();e.preventDefault();this.updateDomValue(this._lastValue);this.onValueRevertedByEscape(this._lastValue);}};a.prototype.oninput=function(e){if(this._bIgnoreNextInput){this._bIgnoreNextInput=false;e.setMarked("invalid");return;}if(!this.getEditable()){e.setMarked("invalid");return;}if(document.activeElement!==e.target){e.setMarked("invalid");return;}this._bCheckDomValue=true;this._setLabelVisibility();};a.prototype.onkeydown=function(e){var k=q.sap.KeyCodes;var b=sap.ui.Device.browser;if((b.msie&&b.version<10)&&(e.which===k.DELETE||e.which===k.BACKSPACE)){this._triggerInputEvent();}};a.prototype.oncut=function(e){var b=sap.ui.Device.browser;if(b.msie&&b.version<10){this._triggerInputEvent();}};a.prototype.selectText=function(s,S){this.$("inner").selectText(s,S);return this;};a.prototype.getSelectedText=function(){return this.$("inner").getSelectedText();};a.prototype.setProperty=function(p,v,s){if(p=="value"){this._bCheckDomValue=false;}return C.prototype.setProperty.apply(this,arguments);};a.prototype.getFocusInfo=function(){var f=C.prototype.getFocusInfo.call(this),F=this.getFocusDomRef();q.extend(f,{cursorPos:0,selectionStart:0,selectionEnd:0});if(F){f.cursorPos=q(F).cursorPos();try{f.selectionStart=F.selectionStart;f.selectionEnd=F.selectionEnd;}catch(e){}}return f;};a.prototype.applyFocusInfo=function(f){C.prototype.applyFocusInfo.call(this,f);this.$("inner").cursorPos(f.cursorPos);this.selectText(f.selectionStart,f.selectionEnd);return this;};a.prototype.bindToInputEvent=function(c){if(this._oInputEventDelegate){this.removeEventDelegate(this._oInputEventDelegate);}this._oInputEventDelegate={oninput:c};return this.addEventDelegate(this._oInputEventDelegate);};a.prototype.updateDomValue=function(v){if(!this.isActive()){return this;}v=this._getInputValue(v);if(this._getInputValue()!==v){this.$("inner").val(v);this._bCheckDomValue=true;}this._setLabelVisibility();return this;};a.prototype.closeValueStateMessage=function(){if(this._oValueStateMessage){this._oValueStateMessage.close();}};a.prototype.getDomRefForValueStateMessage=function(){return this.getFocusDomRef();};a.prototype.iOpenMessagePopupDuration=0;a.prototype.getValueStateMessageId=function(){return this.getId()+"-message";};a.prototype.openValueStateMessage=function(){if(this._oValueStateMessage){this._oValueStateMessage.open();}};a.prototype.updateValueStateClasses=function(v,o){var t=this.$(),i=this.$("inner"),m=sap.ui.core.ValueState;if(o!==m.None){t.removeClass("sapMInputBaseState sapMInputBase"+o);i.removeClass("sapMInputBaseStateInner sapMInputBase"+o+"Inner");}if(v!==m.None){t.addClass("sapMInputBaseState sapMInputBase"+v);i.addClass("sapMInputBaseStateInner sapMInputBase"+v+"Inner");}};a.prototype.shouldValueStateMessageBeOpened=function(){return((this.getValueState()!==sap.ui.core.ValueState.None)&&this.getEditable()&&this.getEnabled()&&this.getShowValueStateMessage());};a.prototype.setValueState=function(v){var o=this.getValueState();this.setProperty("valueState",v,true);v=this.getValueState();if(v===o){return this;}var d=this.getDomRef();if(!d){return this;}var i=this.$("inner"),m=sap.ui.core.ValueState;if(v===m.Error){i.attr("aria-invalid","true");}else{i.removeAttr("aria-invalid");}this.updateValueStateClasses(v,o);if(i[0]===document.activeElement){if(v===m.None){this.closeValueStateMessage();}else if(this.shouldValueStateMessageBeOpened()){this.openValueStateMessage();}}return this;};a.prototype.setValueStateText=function(t){this.setProperty("valueStateText",t,true);this.$("message").text(this.getValueStateText());return this;};a.prototype.setValue=function(v){v=this.validateProperty("value",v);v=this._getInputValue(v);this.updateDomValue(v);if(v!==this.getProperty("value")){this._lastValue=v;}this.setProperty("value",v,true);return this;};a.prototype.getFocusDomRef=function(){return this.getDomRef("inner");};a.prototype.getIdForLabel=function(){return this.getId()+"-inner";};a.prototype.propagateMessages=function(n,m){if(m&&m.length>0){this.setValueState(m[0].type);this.setValueStateText(m[0].message);}else{this.setValueState(sap.ui.core.ValueState.None);this.setValueStateText('');}};a.prototype.setTooltip=function(t){var d=this.getDomRef();this._refreshTooltipBaseDelegate(t);this.setAggregation("tooltip",t,true);if(!d){return this;}var T=this.getTooltip_AsString();if(T){d.setAttribute("title",T);}else{d.removeAttribute("title");}if(sap.ui.getCore().getConfiguration().getAccessibility()){var D=this.getDomRef("describedby"),A=this.getRenderer().getDescribedByAnnouncement(this),s=this.getId()+"-describedby",b="aria-describedby",f=this.getFocusDomRef(),c=f.getAttribute(b);if(!D&&A){D=document.createElement("span");D.id=s;D.setAttribute("aria-hidden","true");D.className="sapUiInvisibleText";if(this.getAriaDescribedBy){f.setAttribute(b,(this.getAriaDescribedBy().join(" ")+" "+s).trim());}else{f.setAttribute(b,s);}d.appendChild(D);}else if(D&&!A){d.removeChild(D);var e=D.id;if(c&&e){f.setAttribute(b,c.replace(e,"").trim());}}if(D){D.textContent=A;}}return this;};a.prototype.refreshDataState=function(n,d){if(d.getChanges().messages){this.propagateMessages(n,d.getMessages());}};a.prototype.getAccessibilityInfo=function(){var r=this.getRenderer();return{role:r.getAriaRole(this),type:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("ACC_CTR_TYPE_INPUT"),description:[this.getValue()||"",r.getLabelledByAnnouncement(this),r.getDescribedByAnnouncement(this)].join(" ").trim(),focusable:this.getEnabled(),enabled:this.getEnabled(),editable:this.getEnabled()&&this.getEditable()};};Object.defineProperty(a.prototype,"_$input",{get:function(){return this.$("inner");}});return a;},true);
