/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Renderer","./SliderRenderer"],function(R,S){"use strict";var a=R.extend(S);a.renderHandles=function(r,c){this.renderHandle(r,c,{id:c.getId()+"-handle1",position:"start"});this.renderHandle(r,c,{id:c.getId()+"-handle2",position:"end"});this.renderTooltips(r,c);r.renderControl(c._mHandleTooltip.start.label);r.renderControl(c._mHandleTooltip.end.label);r.renderControl(c._oRangeLabel);};a.renderTooltips=function(r,c){r.write("<div");r.writeAttribute("id",c.getId()+"-TooltipsContainer");r.addClass(S.CSS_CLASS+"TooltipContainer");r.addStyle("left","0%");r.addStyle("right","0%");r.addStyle("min-width","0%");r.writeClasses();r.writeStyles();r.write(">");this.renderTooltip(r,c,c.getInputsAsTooltips(),"Left");this.renderTooltip(r,c,c.getInputsAsTooltips(),"Right");r.write("</div>");};a.renderTooltip=function(r,c,i,p){if(i){if(p==="Left"){r.renderControl(c._mHandleTooltip.start.tooltip);}else{r.renderControl(c._mHandleTooltip.end.tooltip);}}else{r.write("<span");r.addClass(S.CSS_CLASS+"HandleTooltip");r.addStyle("width",c._iLongestRangeTextWidth+"px");r.writeAttribute("id",c.getId()+"-"+p+"Tooltip");r.writeClasses();r.writeStyles();r.write(">");r.write("</span>");}};a.renderHandle=function(r,c,o){var v,b=c.getRange(),e=c.getEnabled(),d=sap.ui.getCore().getConfiguration().getRTL();r.write("<span");if(o&&(o.id!==undefined)){r.writeAttributeEscaped("id",o.id);}if(o&&(o.position!==undefined)){v=b[o.position==="start"?0:1];r.writeAttribute("data-range-val",o.position);r.writeAttribute("aria-labelledby",c._mHandleTooltip[o.position].label.getId());if(c.getInputsAsTooltips()){r.writeAttribute("aria-controls",c._mHandleTooltip[o.position].tooltip.getId());}}if(c.getShowHandleTooltip()){this.writeHandleTooltip(r,c);}r.addClass(S.CSS_CLASS+"Handle");if(o&&(o.id!==undefined)&&o.id===(c.getId()+"-handle1")){r.addStyle(d?"right":"left",b[0]);}if(o&&(o.id!==undefined)&&o.id===(c.getId()+"-handle2")){r.addStyle(d?"right":"left",b[1]);}this.writeAccessibilityState(r,c,v);r.writeClasses();r.writeStyles();if(e){r.writeAttribute("tabindex","0");}r.write("></span>");};a.writeAccessibilityState=function(r,s,v){r.writeAccessibilityState(s,{role:"slider",orientation:"horizontal",valuemin:s.toFixed(s.getMin()),valuemax:s.toFixed(s.getMax()),valuenow:v});};a.renderStartLabel=function(r,c){r.write("<div");r.addClass(S.CSS_CLASS+"Label");r.writeClasses();r.write(">");r.write(c.getMin());r.write("</div>");};a.renderEndLabel=function(r,c){r.write("<div");r.addClass(S.CSS_CLASS+"Label");r.writeClasses();r.write(">");r.write(c.getMax());r.write("</div>");};a.renderLabels=function(r,c){r.write("<div");r.addClass();r.addClass(S.CSS_CLASS+"Labels");r.writeClasses();r.write(">");this.renderStartLabel(r,c);this.renderEndLabel(r,c);r.write("</div>");};a.renderProgressIndicator=function(r,s){var b=s.getRange();r.write("<div");r.writeAttribute("id",s.getId()+"-progress");if(s.getEnabled()){r.writeAttribute("tabindex","0");}this.addProgressIndicatorClass(r,s);r.addStyle("width",s._sProgressValue);r.writeClasses();r.writeStyles();r.writeAccessibilityState(s,{role:"slider",orientation:"horizontal",valuemin:s.toFixed(s.getMin()),valuemax:s.toFixed(s.getMax()),valuenow:b.join("-"),valuetext:s._oResourceBundle.getText('RANGE_SLIDER_RANGE_ANNOUNCEMENT',b),labelledby:s._oRangeLabel.getId()});r.write('></div>');};return a;},true);
