/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/model/TreeBinding','sap/ui/model/ChangeReason','sap/ui/model/Filter','sap/ui/model/FilterOperator','sap/ui/model/FilterType','sap/ui/model/Sorter','sap/ui/model/odata/CountMode','./odata4analytics','./BatchResponseCollector','./AnalyticalVersionInfo'],function(Q,T,C,F,a,b,S,c,d,B,A){"use strict";var f=T.extend("sap.ui.model.analytics.AnalyticalBinding",{constructor:function(m,p,o,s,e,P){T.call(this,m,p,o,e,P);this.sEntitySetName=(P&&P.entitySet)?P.entitySet:undefined;this.bArtificalRootContext=false;this.aApplicationFilter=this._convertDeprecatedFilterObjects(e);this.aControlFilter=undefined;this.aSorter=s?s:[];this.aMaxAggregationLevel=[];this.aAggregationLevel=[];this.oPendingRequests={};this.oPendingRequestHandle=[];this.oGroupedRequests={};this.bUseBatchRequests=(P&&P.useBatchRequests===true)?true:false;this.bProvideTotalSize=(P&&P.provideTotalResultSize===false)?false:true;this.bProvideGrandTotals=(P&&P.provideGrandTotals===false)?false:true;this.bReloadSingleUnitMeasures=(P&&P.reloadSingleUnitMeasures===false)?false:true;this.bUseAcceleratedAutoExpand=(P&&P.useAcceleratedAutoExpand===false)?false:true;this.bNoPaging=(P&&P.noPaging===true)?true:false;this.iTotalSize=-1;this.mServiceKey={};this.mServiceLength={};this.mServiceFinalLength={};this.mKeyIndex={};this.mFinalLength=this.mServiceFinalLength;this.mLength={};this.mMultiUnitKey={};this.aMultiUnitLoadFactor={};this.bNeedsUpdate=false;this.mEntityKey={};this.sCustomParams=this.oModel.createCustomParams({custom:this.mParameters.custom});this.oAnalyticalQueryResult=null;this.aAnalyticalInfo=[];this.mAnalyticalInfoByProperty={};this.aBatchRequestQueue=[];if(P&&P.countMode==c.None){Q.sap.log.fatal("requested count mode is ignored; OData requests will include $inlinecout options");}else if(P&&(P.countMode==c.Request||P.countMode==c.Both)){Q.sap.log.warning("default count mode is ignored; OData requests will include $inlinecout options");}else if(this.oModel.sDefaultCountMode==c.Request){Q.sap.log.warning("default count mode is ignored; OData requests will include $inlinecout options");}this.iModelVersion=A.getVersion(this.oModel);if(this.iModelVersion===null){Q.sap.log.error("The AnalyticalBinding does not support Models other than sap.ui.model.odata.ODataModel version 1 or 2.");return;}this.aAllDimensionSortedByName=null;this.aInitialAnalyticalInfo=(P==undefined?[]:P.analyticalInfo);this.bInitial=true;}});f.prototype.setContext=function(o){if(this.oContext!==o){this.oContext=o;this.oDataState=null;if(this.isRelative()){if(!this.bInitial){this.refresh();}}}};f.prototype.initialize=function(){if(this.oModel.oMetadata&&this.oModel.oMetadata.isLoaded()&&this.bInitial){this.bInitial=false;this.oAnalyticalQueryResult=this.oModel.getAnalyticalExtensions().findQueryResultByName(this._getEntitySet());if(!this.oAnalyticalQueryResult){throw("Error in AnalyticalBinding - The QueryResult '"+this._getEntitySet()+"' could not be retrieved. Please check your service definition.");}this.updateAnalyticalInfo(this.aInitialAnalyticalInfo);this.aAllDimensionSortedByName=this.oAnalyticalQueryResult.getAllDimensionNames().concat([]).sort();this._fireRefresh({reason:C.Refresh});}return this;};f.prototype.getRootContexts=function(p){if(this.bInitial){return[];}var i=(p&&p.numberOfExpandedLevels?p.numberOfExpandedLevels+1:1);var r=null;var R=this._getRequestId(f._requestType.groupMembersQuery,{groupId:null});if(this.bArtificalRootContext&&!this._cleanupGroupingForCompletedRequest(R)){return r;}r=this._getContextsForParentContext(null);if(r.length==1){return r;}if(i<=1){if(i==1){this._considerRequestGrouping([R,this._getRequestId(f._requestType.groupMembersQuery,{groupId:"/"})]);this.getNodeContexts(this.getModel().getContext("/"),{startIndex:p.startIndex,length:p.length,threshold:p.threshold,level:0,numberOfExpandedLevels:0});}}else{var e=this._prepareGroupMembersAutoExpansionRequestIds("/",p.numberOfExpandedLevels);e.push(R);this._considerRequestGrouping(e);this.getNodeContexts(this.getModel().getContext("/"),{startIndex:p.startIndex,length:p.length,threshold:p.threshold,level:0,numberOfExpandedLevels:p.numberOfExpandedLevels});}if(r.length>1){Q.sap.log.fatal("assertion failed: grand total represented by a single entry");}return r;};f.prototype.getNodeContexts=function(o,p){if(this.bInitial){return[];}var s,l,t,L,n,e;if(typeof p=="object"){s=p.startIndex;l=p.length;t=p.threshold;L=p.level;n=p.numberOfExpandedLevels;e=p.supressRequest;}else{s=arguments[1];l=arguments[2];t=arguments[3];L=arguments[4];n=arguments[5];e=arguments[6];}var g=this._getContextsForParentContext(o,s,l,t,L,n,e);return g;};f.prototype.ContextsAvailabilityStatus={ALL:2,SOME:1,NONE:0};f.prototype.hasAvailableNodeContexts=function(o,l){var g=this._getGroupIdFromContext(o,l);if(this._getKeys(g)!=undefined){if(this.mFinalLength[g]==true){return f.prototype.ContextsAvailabilityStatus.ALL;}else{return f.prototype.ContextsAvailabilityStatus.SOME;}}else{return f.prototype.ContextsAvailabilityStatus.NONE;}};f.prototype.getGroupSize=function(o,l){if(o===undefined){return 0;}var g=this._getGroupIdFromContext(o,l);return this.mFinalLength[g]?this.mLength[g]:-1;};f.prototype.getTotalSize=function(){if(!this.bProvideTotalSize){Q.sap.log.fatal("total size of result explicitly turned off, but getter invoked");}return+this.iTotalSize;};f.prototype.hasChildren=function(o,p){if(o===undefined){return false;}if(o==null){return true;}var i=p.level;if(i==0){return true;}if(this.aAggregationLevel.length<i){return false;}return Q.inArray(this.aAggregationLevel[i-1],this.aMaxAggregationLevel)<this.aMaxAggregationLevel.length-1;};f.prototype.hasMeasures=function(){var h=false;for(var p in this.oMeasureDetailsSet){if(this.oMeasureDetailsSet.hasOwnProperty(p)){h=true;break;}}return h;};f.prototype.getDimensionDetails=function(){return this.oDimensionDetailsSet;};f.prototype.getMeasureDetails=function(){return this.oMeasureDetailsSet;};f.prototype.providesGrandTotal=function(){return this.bProvideGrandTotals;};f.prototype.getProperty=function(p){if(this.bInitial){return{};}return this.oAnalyticalQueryResult.getEntityType().findPropertyByName(p);};f.prototype.getFilterablePropertyNames=function(){if(this.bInitial){return[];}return this.oAnalyticalQueryResult.getEntityType().getFilterablePropertyNames();};f.prototype.getSortablePropertyNames=function(){if(this.bInitial){return[];}return this.oAnalyticalQueryResult.getEntityType().getSortablePropertyNames();};f.prototype.getPropertyLabel=function(p){if(this.bInitial){return"";}return this.oAnalyticalQueryResult.getEntityType().getLabelOfProperty(p);};f.prototype.getPropertyHeading=function(p){if(this.bInitial){return"";}return this.oAnalyticalQueryResult.getEntityType().getHeadingOfProperty(p);};f.prototype.getPropertyQuickInfo=function(p){if(this.bInitial){return"";}return this.oAnalyticalQueryResult.getEntityType().getQuickInfoOfProperty(p);};f.prototype.isMeasure=function(p){return Q.inArray(p,this.aMeasureName)!==-1;};f.prototype.filter=function(e,s){if(!e){e=[];}if(e instanceof F){e=[e];}e=this._convertDeprecatedFilterObjects(e);if(s==b.Application){this.aApplicationFilter=e;}else{this.aControlFilter=e;}this.iTotalSize=-1;this._abortAllPendingRequests();this.resetData();this._fireRefresh({reason:C.Filter});return this;};f.prototype.sort=function(s){if(s instanceof S){s=[s];}this.aSorter=s?s:[];this._abortAllPendingRequests();this.resetData(undefined,{reason:C.Sort});this._fireRefresh({reason:C.Sort});return this;};f.prototype.getGroupName=function(o,l){if(o===undefined){return"";}var g=this.aAggregationLevel[l-1],D=this.oAnalyticalQueryResult.findDimensionByPropertyName(g),v=this.mAnalyticalInfoByProperty[g].formatter,p=o.getProperty(g),t,s,G;if(D&&this.oDimensionDetailsSet[g].textPropertyName){t=D.getTextProperty();}var e,h,i;if(t){e=D.getTextProperty().name;i=this.mAnalyticalInfoByProperty[e].formatter;h=o.getProperty(e);}if(!t){s=v?v(p):p;G=((D.getLabelText())?D.getLabelText()+': ':'')+s;}else{s=v?v(p,h):p;G=((D.getLabelText())?D.getLabelText()+': ':'')+s;var j=i?i(h,p):h;if(j){G+=' - '+j;}}return G;};f.prototype.updateAnalyticalInfo=function(e,g){if(!this.oModel.oMetadata||!this.oModel.oMetadata.isLoaded()||this.bInitial){this.aInitialAnalyticalInfo=e;return;}if(Q.sap.equal(this._aLastChangedAnalyticalInfo,e)){if(g){this._fireChange({reason:C.Change});}return;}this._aLastChangedAnalyticalInfo=[];for(var j=0;j<e.length;j++){this._aLastChangedAnalyticalInfo[j]=Q.extend({},e[j]);}var p=this.oDimensionDetailsSet;this.mAnalyticalInfoByProperty={};this.aMaxAggregationLevel=[];this.aAggregationLevel=[];this.aMeasureName=[];if(this.iAnalyticalInfoVersionNumber==undefined){this.iAnalyticalInfoVersionNumber=1;}else if(this.iAnalyticalInfoVersionNumber>999){this.iAnalyticalInfoVersionNumber=1;}else{this.iAnalyticalInfoVersionNumber=this.iAnalyticalInfoVersionNumber+1;}this.oMeasureDetailsSet={};this.oDimensionDetailsSet={};for(var i=0;i<e.length;i++){var D=this.oAnalyticalQueryResult.findDimensionByPropertyName(e[i].name);if(D&&(e[i].inResult==true||e[i].visible==true)){e[i].dimensionPropertyName=D.getName();var o=this.oDimensionDetailsSet[D.getName()];if(!o){o={};o.name=D.getName();o.aAttributeName=[];o.grouped=false;this.oDimensionDetailsSet[D.getName()]=o;this.aMaxAggregationLevel.push(o.name);if(e[i].grouped==true){this.aAggregationLevel.push(o.name);}}if(e[i].grouped==true){if(Q.inArray(D.getName(),this.getSortablePropertyNames())==-1){Q.sap.log.fatal("property "+D.getName()+" must be sortable in order to be used as grouped dimension");}o.grouped=true;}if(D.getName()==e[i].name){o.keyPropertyName=e[i].name;}var t=D.getTextProperty();if(t&&t.name==e[i].name){o.textPropertyName=e[i].name;}if(D.findAttributeByName(e[i].name)){o.aAttributeName.push(e[i].name);}o.analyticalInfo=e[i];}var m=this.oAnalyticalQueryResult.findMeasureByPropertyName(e[i].name);if(m&&(e[i].inResult==true||e[i].visible==true)){e[i].measurePropertyName=m.getName();var M=this.oMeasureDetailsSet[m.getName()];if(!M){M={};M.name=m.getName();this.oMeasureDetailsSet[m.getName()]=M;this.aMeasureName.push(M.name);}if(m.getRawValueProperty().name==e[i].name){M.rawValuePropertyName=e[i].name;}var h=m.getFormattedValueProperty();if(h&&h.name==e[i].name){M.formattedValuePropertyName=e[i].name;}M.analyticalInfo=e[i];}this.mAnalyticalInfoByProperty[e[i].name]=e[i];}for(var k in this.oMeasureDetailsSet){var u=this.oAnalyticalQueryResult.findMeasureByName(k).getUnitProperty();if(u){this.oMeasureDetailsSet[k].unitPropertyName=u.name;}}var l=function(n){var N=[];for(var q in n){N.push(q.name);}return N.sort().join(";");};if(l(p)!=l(this.oDimensionDetailsSet)){this.iTotalSize=-1;}this.aAnalyticalInfo=e;this.resetData();this.bNeedsUpdate=false;if(g){this._fireChange({reason:C.Change});}};f.prototype.getAnalyticalInfoForColumn=function(s){return this.mAnalyticalInfoByProperty[s];};f.prototype.loadGroups=function(g){var G=[];for(var s in g){G.push(s);this._resetData(s);var e=g[s];for(var i=0;i<e.length;i++){var o=e[i];this._getContextsForParentGroupId(s,o.startIndex,o.length,o.threshold);}var r=[];for(var j=-1,h;(h=G[++j])!==undefined;){r.push(this._getRequestId(f._requestType.groupMembersQuery,{groupId:h}));}this._considerRequestGrouping(r);}};f.prototype.getAnalyticalQueryResult=function(){return this.oAnalyticalQueryResult;};f._requestType={groupMembersQuery:1,totalSizeQuery:2,groupMembersAutoExpansionQuery:3,levelMembersQuery:4,reloadMeasuresQuery:5};f._artificialRootContextGroupId="artificialRootContext";f.prototype._getContextsForParentContext=function(p,s,l,t,L,n,e){if(p===undefined){return[];}if(p&&p.getPath()=="/"+f._artificialRootContextGroupId){p=this.getModel().getContext("/");}var P=this._getGroupIdFromContext(p,L);return this._getContextsForParentGroupId(P,s,l,t,n,e);};f.prototype._getContextsForParentGroupId=function(p,s,l,t,n,e){if(p===undefined){return[];}if(!s){s=0;}if(!l){l=this.oModel.iSizeLimit;}if(this.mFinalLength[p]&&this.mLength[p]<s+l){l=this.mLength[p]-s;if(l<0){Q.sap.log.fatal("invalid start index greater than total group length passed");}}if(!t){t=0;}if(!n){n=0;}if(p==null){if(n>0){Q.sap.log.fatal("invalid request to determine nodes of root context");return null;}}else{if(this._getGroupIdLevel(p)>=this.aAggregationLevel.length&&n>0){Q.sap.log.fatal("invalid request to determine nodes of context with group ID "+p);return null;}if(this._getGroupIdLevel(p)+n>this.aAggregationLevel.length){n=this.aAggregationLevel.length-this._getGroupIdLevel(p)-1;}}var g=[],L,G,o,m;var h=p==null?0:this._getGroupIdLevel(p)+1;if(!this.aMultiUnitLoadFactor[h]){this.aMultiUnitLoadFactor[h]=1;}var k=n>0&&p!=null;if(k){var M=this._getGroupIdLevel(p);var q=M+n;var D=true;if(!e){o=this._calculateRequiredGroupExpansion(p,q,s,l+t);D=o.groupId_Missing==null;D=D||o.groupId_Missing.length<p.length||o.groupId_Missing.substring(0,p.length)!=p;}if(D){g=this._getLoadedContextsForGroup(p,s,l);}else{m=l+t;}L=!D;m=Math.ceil(m*this.aMultiUnitLoadFactor[h]);}else{g=this._getLoadedContextsForGroup(p,s,l,e);L=false;if(!e){G=this._calculateRequiredGroupSection(p,s,l,t,g);var P=G.length>0&&l<G.length;L=(g.length!=l&&!(this.mFinalLength[p]&&g.length>=this.mLength[p]-s))||P;G.length=Math.ceil(G.length*this.aMultiUnitLoadFactor[h]);}}if(!L){this._cleanupGroupingForCompletedRequest(this._getRequestId(f._requestType.groupMembersQuery,{groupId:p}));}var E=false;if(this.oModel.getServiceMetadata()){if(L){var N=this.bProvideTotalSize&&this.iTotalSize==-1&&!this._isRequestPending(this._getRequestId(f._requestType.totalSizeQuery));E=true;var r;if(this.bUseBatchRequests){if(k){r=this._prepareGroupMembersAutoExpansionRequestIds(p,n);for(var i=-1,R;(R=r[++i])!==undefined;){if(this._isRequestPending(R)){E=false;break;}}if(E){this.aBatchRequestQueue.push([f._requestType.groupMembersAutoExpansionQuery,p,o,m,n]);}}else{E=!this._isRequestPending(this._getRequestId(f._requestType.groupMembersQuery,{groupId:p}));if(E){this.aBatchRequestQueue.push([f._requestType.groupMembersQuery,p,G.startIndex,G.length]);r=[this._getRequestId(f._requestType.groupMembersQuery,{groupId:p})];}}if(E&&N){r.push(this._getRequestId(f._requestType.totalSizeQuery));this._considerRequestGrouping(r);this.aBatchRequestQueue.push([f._requestType.totalSizeQuery]);}if(E){if(p==null){this._abortAllPendingRequests();}Promise.resolve().then(f.prototype._processRequestQueue.bind(this));}}else{var u;if(k){r=this._prepareGroupMembersAutoExpansionRequestIds(p,n);for(var j=-1,v;(v=r[++j])!==undefined;){if(this._isRequestPending(v)){E=false;break;}}if(E){u=this._prepareGroupMembersAutoExpansionQueryRequest(f._requestType.groupMembersAutoExpansionQuery,p,o,m,n);}}else{E=!this._isRequestPending(this._getRequestId(f._requestType.groupMembersQuery,{groupId:p}));if(E){u=this._prepareGroupMembersQueryRequest(f._requestType.groupMembersQuery,p,G.startIndex,G.length);r=[u.sRequestId];}}if(E){if(p==null){this._abortAllPendingRequests();}this._executeQueryRequest(u);if(N&&!u.bIsFlatListRequest){r.push(this._getRequestId(f._requestType.totalSizeQuery));this._considerRequestGrouping(r);this._executeQueryRequest(this._prepareTotalSizeQueryRequest(f._requestType.totalSizeQuery));}}}}}return g;};f.prototype._processRequestQueue=function(r){if(r===undefined||r===null){r=this.aBatchRequestQueue||[];}if(r.length==0){return;}var R=[];var e=false;var i,o,g;for(i=-1;(g=r[++i])!==undefined;){if(g[0]==f._requestType.groupMembersQuery){o=f.prototype._prepareGroupMembersQueryRequest.apply(this,g);e=e||o.bIsFlatListRequest;R.push(o);}}for(i=-1;(g=r[++i])!==undefined;){o=null;switch(g[0]){case f._requestType.groupMembersQuery:continue;case f._requestType.totalSizeQuery:if(!e){o=f.prototype._prepareTotalSizeQueryRequest.apply(this,g);R.push(o);}break;case f._requestType.groupMembersAutoExpansionQuery:o=f.prototype._prepareGroupMembersAutoExpansionQueryRequest.apply(this,g);for(var j=-1,l;(l=o.aGroupMembersAutoExpansionRequestDetails[++j])!==undefined;){R.push(l);}break;case f._requestType.reloadMeasuresQuery:{var h=g[1];for(var k=-1,m;(m=h[++k])!==undefined;){R.push(m);}break;}default:Q.sap.log.fatal("unhandled request type "+r[i][0]);continue;}}if(R.length>1){this._executeBatchRequest(R);}else{this._executeQueryRequest(R[0]);}if(r===this.aBatchRequestQueue){this.aBatchRequestQueue=[];}};f.prototype._prepareGroupMembersQueryRequest=function(r,g,s,L){var G=[];var o=new d.QueryResultRequest(this.oAnalyticalQueryResult);o.setResourcePath(this._getResourcePath());o.getSortExpression().clear();var e=0,h=-1;if(g){G=this._getGroupIdComponents(g);e=h=G.length;var u=0;for(var j=0,p=0;j<e;p++){if(this.oDimensionDetailsSet[this.aMaxAggregationLevel[p]].grouped==false){++u;}else{++j;}}e=h=e+u;if(this.aMaxAggregationLevel.length>0){while(this.oDimensionDetailsSet[this.aMaxAggregationLevel[h]].grouped==false){if(++h==this.aMaxAggregationLevel.length){break;}}}}var I=h>=this.aMaxAggregationLevel.length-1;var q=this.aMaxAggregationLevel.slice(0,h+1);o.setAggregationLevel(q);for(var i=0;i<q.length;i++){var D=this.oDimensionDetailsSet[q[i]];var t=(D.textPropertyName!=undefined);o.includeDimensionKeyTextAttributes(D.name,true,t,D.aAttributeName);if(D.grouped){o.getSortExpression().addSorter(q[i],d.SortOrder.Ascending);}}var v=o.getFilterExpression();v.clear();if(this.aApplicationFilter){v.addUI5FilterConditions(this.aApplicationFilter);}if(this.aControlFilter){v.addUI5FilterConditions(this.aControlFilter);}if(e>=1){for(var k=0,l=G.length;k<l;k++){v.removeConditions(this.aAggregationLevel[k]);v.addCondition(this.aAggregationLevel[k],a.EQ,G[k]);}}var w;var x;var y;var M;var z=[];if(g!=null||this.bProvideGrandTotals){o.setMeasures(this.aMeasureName);for(var E in this.oMeasureDetailsSet){M=this.oMeasureDetailsSet[E];if(!I&&this.mAnalyticalInfoByProperty[E].total==false){w=false;x=false;y=false;}else{w=(M.rawValuePropertyName!=undefined);x=(M.formattedValuePropertyName!=undefined);y=(M.unitPropertyName!=undefined);if(y){if(Q.inArray(M.unitPropertyName,z)==-1){z.push(M.unitPropertyName);}}}o.includeMeasureRawFormattedValueUnit(M.name,w,x,y);}for(var n in q){var H;if((H=Q.inArray(q[n],z))!=-1){z.splice(H,1);}}}var J=o.getSortExpression();for(var m=0;m<this.aSorter.length;m++){if(this.aSorter[m]){J.addSorter(this.aSorter[m].sPath,this.aSorter[m].bDescending?d.SortOrder.Descending:d.SortOrder.Ascending);}}if(L==0){Q.sap.log.fatal("unhandled case: load 0 entities of sub group");}var K=this._getKeyIndexMapping(g,s);if(!this.bNoPaging){o.setResultPageBoundaries(K.iServiceKeyIndex+1,K.iServiceKeyIndex+L);}o.setRequestOptions(null,!this.mFinalLength[g]);return{iRequestType:r,sRequestId:this._getRequestId(f._requestType.groupMembersQuery,{groupId:g}),oAnalyticalQueryRequest:o,sGroupId:g,aSelectedUnitPropertyName:z,aAggregationLevel:q,bIsFlatListRequest:I&&e==0,bIsLeafGroupsRequest:I,iStartIndex:s,iLength:L,oKeyIndexMapping:K};};f.prototype._prepareTotalSizeQueryRequest=function(r){var o=new d.QueryResultRequest(this.oAnalyticalQueryResult);o.setResourcePath(this._getResourcePath());o.setAggregationLevel(this.aMaxAggregationLevel);o.setMeasures([]);var e=o.getFilterExpression();e.clear();if(this.aApplicationFilter){e.addUI5FilterConditions(this.aApplicationFilter);}if(this.aControlFilter){e.addUI5FilterConditions(this.aControlFilter);}o.setRequestOptions(null,null,true);o.setRequestOptions(null,true);return{iRequestType:r,sRequestId:this._getRequestId(f._requestType.totalSizeQuery),oAnalyticalQueryRequest:o};};f.prototype._prepareGroupMembersAutoExpansionQueryRequest=function(r,g,G,L,n){var t=this;var p=function(G,m){var s=[];if(G.groupId_Missing==null){Q.sap.log.fatal("missing group Id not present");return s;}var o=t._getGroupIdComponents(G.groupId_Missing);var q=o.length;if(q>m){Q.sap.log.fatal("the given group ID is too deep for requested level for auto expansion");return s;}var k=[];for(var i=0;i<q;i++){var l=t.aAggregationLevel[i];var V=o[i];var J=t._getFilterOperatorMatchingPropertySortOrder(l);k[i]=new F(l,J,V);}var K=null;if(G.startIndex_Missing>0){var M=t._getKey(G.groupId_Missing,G.startIndex_Missing-1);var N=t.oModel.getObject("/"+M);var O=t.aAggregationLevel[q];var P=N[O];K=new F(O,t._getFilterOperatorMatchingPropertySortOrder(O,false),P);}for(var v=0;v<m;v++){var U=[];var W=Math.min(q,v+1);for(var X=0;X<W;X++){var Y=[];var Z=Math.min(q,X+1);var $=G.startIndex_Missing>0;for(var _=0;_<Z;_++){var a1=new F("x",a.EQ,"x");a1=Q.extend(true,a1,k[_]);if(Z>1&&_<Z-1){a1.sOperator=a.EQ;}if(_==q-1&&v>q-1&&!$){if(a1.sOperator==a.GT){a1.sOperator=a.GE;}else{a1.sOperator=a.LE;}}Y.push(a1);}if(Y.length>0){U.push(new F(Y,true));if(v>q-1&&X==q-1&&$){var b1=[];for(var j=0;j<Y.length;j++){var c1=new F("x",a.EQ,"x");c1=Q.extend(true,c1,Y[j]);b1.push(c1);}b1[q-1].sOperator=a.EQ;b1.push(K);U.push(new F(b1,true));break;}}}if(U.length>0){s[v]=new F(U,false);}else{s[v]=null;}}return s;};var e=function(r,g,v,J,w,L,K,U){var M=new d.QueryResultRequest(t.oAnalyticalQueryResult);M.setResourcePath(t._getResourcePath());M.getSortExpression().clear();var N=0,O=-1;N=O=v-1;var P=0;for(var i=0,V=0;i<N;V++){if(t.oDimensionDetailsSet[t.aMaxAggregationLevel[V]].grouped==false){++P;}else{++i;}}N=O=N+P;if(t.aMaxAggregationLevel.length>0){while(t.oDimensionDetailsSet[t.aMaxAggregationLevel[O]].grouped==false){if(++O==t.aMaxAggregationLevel.length){break;}}}var W=O>=t.aMaxAggregationLevel.length-1;var X=t.aMaxAggregationLevel.slice(0,O+1);M.setAggregationLevel(X);for(var l=0;l<X.length;l++){var Y=t.oDimensionDetailsSet[X[l]];var Z=(Y.textPropertyName!=undefined);M.includeDimensionKeyTextAttributes(Y.name,true,Z,Y.aAttributeName);if(Y.grouped){M.getSortExpression().addSorter(X[l],d.SortOrder.Ascending);}}var $=M.getFilterExpression();$.clear();if(t.aApplicationFilter){$.addUI5FilterConditions(t.aApplicationFilter);}if(t.aControlFilter){$.addUI5FilterConditions(t.aControlFilter);}if(J){$.addUI5FilterConditions([J]);}var _;var a1;var b1;var c1;var d1=[];M.setMeasures(t.aMeasureName);for(var e1 in t.oMeasureDetailsSet){c1=t.oMeasureDetailsSet[e1];if(!W&&t.mAnalyticalInfoByProperty[e1].total==false){_=false;a1=false;b1=false;}else{_=(c1.rawValuePropertyName!=undefined);a1=(c1.formattedValuePropertyName!=undefined);b1=(c1.unitPropertyName!=undefined);if(b1){if(Q.inArray(c1.unitPropertyName,d1)==-1){d1.push(c1.unitPropertyName);}}}M.includeMeasureRawFormattedValueUnit(c1.name,_,a1,b1);}for(var j in X){var f1;if((f1=Q.inArray(X[j],d1))!=-1){d1.splice(f1,1);}}var g1=M.getSortExpression();for(var k=0;k<t.aSorter.length;k++){if(t.aSorter[k]){g1.addSorter(t.aSorter[k].sPath,t.aSorter[k].bDescending?d.SortOrder.Descending:d.SortOrder.Ascending);}}if(L==0){Q.sap.log.fatal("unhandled case: load 0 entities of sub group");}var h1=w;if(!U){h1=0;}else{var i1=0;for(var j1 in t.mServiceKey){if(j1.split("/").length===v+1){i1+=t.mServiceKey[j1].length;}}h1=Math.max(h1,i1);}if(!t.bNoPaging){M.setResultPageBoundaries(h1+1,L);}return{iRequestType:r,sRequestId:null,oAnalyticalQueryRequest:M,iLevel:v,aSelectedUnitPropertyName:d1,aAggregationLevel:X,bIsFlatListRequest:W,bIsLeafGroupsRequest:W,iStartIndex:w,iLength:L,bAvoidLengthUpdate:K};};var h=[];var R=[];if(!G){Q.sap.log.fatal("no first missing group member specified");}var m=this._getGroupIdLevel(g)+n+1;var o=t._getGroupIdComponents(G.groupId_Missing);var q=o.length;var s=p(G,m);var u;for(var v=1;v<=m;v++){var w;if(v>=q+2){w=0;u=undefined;}else if(v==q+1){w=G.startIndex_Missing;u=G.groupId_Missing;}else if(q>0){if(v==q){u=G.groupId_Missing;}else{u=this._getGroupIdAncestors(G.groupId_Missing,-(q-v))[0];}var x=this._getGroupIdAncestors(G.groupId_Missing,-(q-v+1))[0];if(!x){Q.sap.log.fatal("failed to determine group id at parent level; group ID = "+g+", level = "+v);}w=this._findKeyIndex(x,this.mEntityKey[u]);if(w==-1){Q.sap.log.fatal("failed to determine position of value "+u+" in group "+x);}u=x;w++;}var y=L>v?Math.ceil((L-v)/(m-v+1)):L;var z=s[v-1];if(this.bUseAcceleratedAutoExpand){var D=e(f._requestType.levelMembersQuery,g,v,z,w,y,false,z==null?true:false);D.sGroupId_Missing_AtLevel=u;D.sRequestId=this._getRequestId(f._requestType.levelMembersQuery,{groupId:g,level:v});h.push(D);R.push(D.sRequestId);}else if(z&&z.aFilters.length>0){if(!z._bMultiFilter||z.bAnd){Q.sap.log.fatal("level filter in wrong shape; cannot break it up");}for(var i=0;i<z.aFilters.length;i++){var E=z.aFilters[i];var H=e(f._requestType.levelMembersQuery,g,v,E,w,y,false,z==null?true:false);H.sGroupId_Missing_AtLevel=u;H.sRequestId=this._getRequestId(f._requestType.levelMembersQuery,{groupId:g,level:v,tupleIndex:i});h.push(H);R.push(H.sRequestId);}}else{var I=e(f._requestType.levelMembersQuery,g,v,null,w,y,false,z==null?true:false);I.sGroupId_Missing_AtLevel=u;I.sRequestId=this._getRequestId(f._requestType.levelMembersQuery,{groupId:g,level:v});h.push(I);R.push(I.sRequestId);}}return{iRequestType:r,aRequestId:R,aGroupMembersAutoExpansionRequestDetails:h,sGroupId:g,iLength:L};};f.prototype._prepareReloadMeasurePropertiesQueryRequest=function(r,g,m){var o=new d.QueryResultRequest(this.oAnalyticalQueryResult);o.setResourcePath(this._getResourcePath());o.getSortExpression().clear();var e=g.aAggregationLevel;o.setAggregationLevel(e);var I=g.bIsLeafGroupsRequest;var h=o.getFilterExpression();h.clear();if(this.aApplicationFilter){h.addUI5FilterConditions(this.aApplicationFilter);}if(this.aControlFilter){h.addUI5FilterConditions(this.aControlFilter);}var k=[];for(var i=0;i<e.length;i++){var l=new F(e[i],a.EQ,m.oEntry[e[i]]);k.push(l);}h.addUI5FilterConditions(k);var n;var p;var q;var M;var s=[];o.setMeasures(m.aReloadMeasurePropertyName);for(var t in this.oMeasureDetailsSet){M=this.oMeasureDetailsSet[t];if(Q.inArray(M.name,m.aReloadMeasurePropertyName)==-1){continue;}if(!I&&this.mAnalyticalInfoByProperty[t].total==false){n=false;p=false;q=false;}else{n=(M.rawValuePropertyName!=undefined);p=(M.formattedValuePropertyName!=undefined);q=(M.unitPropertyName!=undefined);if(q){if(Q.inArray(M.unitPropertyName,s)==-1){s.push(M.unitPropertyName);}}}o.includeMeasureRawFormattedValueUnit(M.name,n,p,q);}for(var j in e){var u;if((u=Q.inArray(e[j],s))!=-1){s.splice(u,1);}}return{iRequestType:r,sRequestId:this._getRequestId(f._requestType.reloadMeasuresQuery,{multiUnitEntryKey:this.oModel.getKey(m.oEntry)}),oAnalyticalQueryRequest:o,aSelectedUnitPropertyName:s,aAggregationLevel:e,oMultiUnitRepresentative:m};};f.prototype._prepareGroupMembersAutoExpansionRequestIds=function(g,n){var m=this._getGroupIdLevel(g)+1;var i=m+n;var r=[];for(var l=m;l<=i;l++){r.push(this._getRequestId(f._requestType.levelMembersQuery,{groupId:g,level:l}));}return r;};f.prototype._getQueryODataRequestOptions=function(o,p){p=p||{};try{o.getFilterExpression().checkValidity();}catch(e){Q.sap.log.fatal("filter expression is not valid",e.toString());return undefined;}var s=o.getURIQueryOptionValue("$select");var g=o.getURIQueryOptionValue("$filter");var O=o.getURIQueryOptionValue("$orderby");var h=o.getURIQueryOptionValue("$skip");var t=o.getURIQueryOptionValue("$top");var I=o.getURIQueryOptionValue("$inlinecount");if(this.mParameters&&this.mParameters["filter"]){g+="and ("+this.mParameters["filter"]+")";}var P=[];if(s!==null){P.push("$select="+s);}if(g!==null){P.push("$filter="+g);}if(O!==null){P.push("$orderby="+O);}if(h!==null){P.push("$skip="+h);}if(t!==null){P.push("$top="+t);}if(I!==null){P.push("$inlinecount="+I);}if(p.encode===true){for(var i=0;i<P.length;i++){P[i]=P[i].replace(/\ /g,"%20");}}return P;};f.prototype._executeBatchRequest=function(r){var e=this.iAnalyticalInfoVersionNumber;var t=this;var g=[],E=[];function h(){t.fireDataReceived({__simulateAsyncAnalyticalBinding:true});}var R=new B();function s(D,j){R.success(j);}function l(D,j){R.error(j||D);}for(var i=-1,o;(o=r[++i])!==undefined;){var m=o.oAnalyticalQueryRequest,G=o.sGroupId;if(m.getURIQueryOptionValue("$select")==null){this.fireDataRequested({__simulateAsyncAnalyticalBinding:true});G=null;this.mServiceLength[G]=this.mLength[G]=1;this.mServiceFinalLength[G]=true;this._setServiceKey(this._getKeyIndexMapping(G,0),f._artificialRootContextGroupId);this.bNeedsUpdate=true;setTimeout(h);this.bArtificalRootContext=true;continue;}var p=m.getURIToQueryResultEntries();if(!this.oContext&&p[0]!=="/"){p="/"+p;}if(!this._isRequestPending(o.sRequestId)){this._registerNewRequest(o.sRequestId);if(this.iModelVersion===A.V1){g.push(this.oModel.createBatchOperation(p.replace(/\ /g,"%20"),"GET"));}else if(this.iModelVersion===A.V2){var u=this._getQueryODataRequestOptions(m,{encode:true});if(this.sCustomParams){u.push(this.sCustomParams);}var n=this.oModel.read(p.replace(/\ /g,"%20"),{success:s,error:l,context:this.oContext,urlParameters:u});g.push(n);}E.push(o);}}if(g.length>0){Q.sap.log.debug("AnalyticalBinding: executing batch request with "+E.length+" operations");var q;var v=this._getIdForNewRequestHandle();this.fireDataRequested();if(this.iModelVersion===A.V1){this.oModel.addBatchReadOperations(g);q=this.oModel.submitBatch(w,x,true,true);this.oModel.fireRequestSent({url:this.oModel.sServiceUrl+"/$batch",type:"POST",async:true,info:"",infoObject:{}});}else{q={abort:function(){for(var j=0;j<g.length;j++){g[j].abort();}}};R.setup({executedRequests:E,binding:this,success:w,error:x});}this._registerNewRequestHandle(v,q);}function w(D,y){t._deregisterHandleOfCompletedRequest(v);if(E.length!=D.__batchResponses.length){Q.sap.log.fatal("assertion failed: received "+D.__batchResponses.length+" responses for "+E.length+" read operations in the batch request");}if(e!=t.iAnalyticalInfoVersionNumber){for(var j=0;j<E.length;j++){var z=E[j].sRequestId;if(z!==undefined){t._deregisterCompletedRequest(z);t._cleanupGroupingForCompletedRequest(z);}}t.fireDataReceived({data:[]});return;}var H=0;for(var k=0;k<D.__batchResponses.length;k++){if(D.__batchResponses[k].data!=undefined){if(D.__batchResponses[k].data.results.length==0){H++;}switch(E[k].iRequestType){case f._requestType.groupMembersQuery:t._processGroupMembersQueryResponse(E[k],D.__batchResponses[k].data);break;case f._requestType.totalSizeQuery:t._processTotalSizeQueryResponse(E[k],D.__batchResponses[k].data);break;case f._requestType.levelMembersQuery:t._processLevelMembersQueryResponse(E[k],D.__batchResponses[k].data);break;case f._requestType.reloadMeasuresQuery:t._processReloadMeasurePropertiesQueryResponse(E[k],D.__batchResponses[k].data);break;default:Q.sap.log.fatal("invalid request type "+E[k].iRequestType);continue;}}t._deregisterCompletedRequest(E[k].sRequestId);t._cleanupGroupingForCompletedRequest(E[k].sRequestId);}if(t.mParameters&&t.mParameters.numberOfExpandedLevels>0){if(H==D.__batchResponses.length){t.mLength["/"]=0;t.mFinalLength["/"]=true;}}var O=true;var I;t.fireDataReceived({data:D});var V={};if(t.iModelVersion===A.V1){I=t.oModel._getBatchErrors(D);if(I.length>0){O=false;V=t.oModel._handleError(I[0]);}t.oModel.fireRequestCompleted({url:y.requestUri,type:"POST",async:true,info:"",infoObject:{},success:O,errorobject:O?{}:V});if(O){t.oModel.checkUpdate();}}}function x(k){if(k&&k.statusText!="abort"){t._deregisterHandleOfCompletedRequest(v);for(var j=-1,y;(y=E[++j])!==undefined;){t._deregisterCompletedRequest(y.sRequestId);t._cleanupGroupingForCompletedRequest(y.sRequestId);}}if(e!=t.iAnalyticalInfoVersionNumber){return;}var V=k;if(t.iModelVersion===A.V1){V=t.oModel._handleError(k);}t.oModel.fireRequestCompleted({url:"",type:"POST",async:true,info:"",infoObject:{},success:false,errorobject:V});if(t.iModelVersion===A.V1){t.oModel.fireRequestFailed(V);}t.fireDataReceived();}};f.prototype._executeQueryRequest=function(r){if(r.iRequestType==f._requestType.groupMembersAutoExpansionQuery){for(var i=-1,o;(o=r.aGroupMembersAutoExpansionRequestDetails[++i])!==undefined;){this._executeQueryRequest(o);}return;}var e=this.iAnalyticalInfoVersionNumber;var g=r.oAnalyticalQueryRequest,G=r.sGroupId;var p=g.getURIToQueryResultEntitySet();var P=this._getQueryODataRequestOptions(g);if(!P){return;}var t=this;if(g.getURIQueryOptionValue("$select")==null){this.fireDataRequested({__simulateAsyncAnalyticalBinding:true});G=null;this.mServiceLength[G]=this.mLength[G]=1;this.mServiceFinalLength[G]=true;this._setServiceKey(this._getKeyIndexMapping(G,0),f._artificialRootContextGroupId);this.bNeedsUpdate=true;setTimeout(function(){if(t._cleanupGroupingForCompletedRequest(r.sRequestId)){t.fireDataReceived({__simulateAsyncAnalyticalBinding:true});}});this.bArtificalRootContext=true;return;}this._registerNewRequest(r.sRequestId);this.fireDataRequested();for(var j=0;j<P.length;j++){P[j]=P[j].replace(/\ /g,"%20");}Q.sap.log.debug("AnalyticalBinding: executing query request");var R=this._getIdForNewRequestHandle();if(this.iModelVersion===A.V1){this.oModel._loadData(p,P,s,E,false,u,k);}else{if(this.sCustomParams){P.push(this.sCustomParams);}var h=this.oModel.read(p,{success:s,error:E,context:this.oContext,urlParameters:P});t._registerNewRequestHandle(R,h);}function s(D){t._deregisterHandleOfCompletedRequest(R);if(e!=t.iAnalyticalInfoVersionNumber){t._deregisterCompletedRequest(r.sRequestId);return;}switch(r.iRequestType){case f._requestType.groupMembersQuery:t._processGroupMembersQueryResponse(r,D);break;case f._requestType.totalSizeQuery:t._processTotalSizeQueryResponse(r,D);break;case f._requestType.levelMembersQuery:t._processLevelMembersQueryResponse(r,D);break;case f._requestType.reloadMeasuresQuery:t._processReloadMeasurePropertiesQueryResponse(r,D);break;default:Q.sap.log.fatal("invalid request type "+r.iRequestType);break;}t._deregisterCompletedRequest(r.sRequestId);if(t.iModelVersion===A.V2){k(D);}}function k(D){if(e!=t.iAnalyticalInfoVersionNumber){return;}if(t._cleanupGroupingForCompletedRequest(r.sRequestId)){t.fireDataReceived({data:D});}}function E(l){if(l&&l.statusText=="abort"){t.fireDataReceived();return;}t._deregisterHandleOfCompletedRequest(R);t._deregisterCompletedRequest(r.sRequestId);t._cleanupGroupingForCompletedRequest(r.sRequestId);if(e!=t.iAnalyticalInfoVersionNumber){return;}t.fireDataReceived();}function u(h){t._registerNewRequestHandle(R,h);}};f.prototype._abortAllPendingRequests=function(){this._abortAllPendingRequestsByHandle();this._clearAllPendingRequests();};f.prototype._processGroupMembersQueryResponse=function(R,D){var G=R.sGroupId,s=R.aSelectedUnitPropertyName,e=R.aAggregationLevel,n=R.oKeyIndexMapping.iIndex,t=R.oKeyIndexMapping.iServiceKeyIndex,L=R.iLength,K=R.oKeyIndexMapping,u=G==null?0:this._getGroupIdLevel(G)+1;var U=(s.length>0);var P,v;var w;var x=0;var y;var z,E=[];var O=D.results.length;var H=this._getServiceKeys(G,K.iIndex-1);P=undefined;if(H&&H.length>0){for(var i=0,I=H.length;i<I;i++){D.results[i-I]=this.oModel.getObject("/"+H[i]);}var J=D.results[-H.length];P="";for(var j=0;j<e.length;j++){P+=J[e[j]]+"|";}}y=H&&H.length==1;for(var h=0;h<O;h++){var M=D.results[h];if(U){v="";for(var g=0;g<e.length;g++){v+=M[e[g]]+"|";}if(P==v){if(w===undefined){if(h==0){w=-H.length;K.iServiceKeyIndex-=H.length-1;}else{w=h-1;}}var N=-1,V=D.results[h-1];for(var k=0;k<s.length;k++){if(V[s[k]]!=M[s[k]]){N=k;break;}}if(N==-1){Q.sap.log.fatal("assertion failed: no deviating units found for result entries "+(h-1)+" and "+h);}}if((P!=v||h==O-1)&&w!==undefined){var W=[];for(var l=w;l<h;l++){W.push(D.results[l]);}if(P==v){W.push(D.results[h]);}var X=[];for(var m=0;m<s.length;m++){var Y=s[m];for(var o=1;o<W.length;o++){if(W[o-1][Y]!=W[o][Y]){X.push(Y);break;}}}var Z=this._createMultiUnitRepresentativeEntry(G,D.results[w],s,X,R.bIsFlatListRequest);if(Z.aReloadMeasurePropertyName.length>0){z=this._prepareReloadMeasurePropertiesQueryRequest(f._requestType.reloadMeasuresQuery,R,Z);if(z.oAnalyticalQueryRequest&&z.oAnalyticalQueryRequest.getURIQueryOptionValue("$select")!=null){E.push(z);}}var $=this._setAdjacentMultiUnitKeys(K,Z,W);var _;if(Z.bIsNewEntry){_=W.length-1;}else{_=$;}if(y){y=false;}if(_<0){Q.sap.log.fatal("assertion failed: iDiscardedEntriesCount must be non-negative");}x+=_;var a1=this.oModel._getKey(Z.oEntry);var b1=this.oModel.getContext('/'+a1);this._getGroupIdFromContext(b1,u);this.mEntityKey[d1]=a1;w=undefined;if(P!=v){y=this._setServiceKey(K,this.oModel._getKey(M));}}else if(P!=v){y=this._setServiceKey(K,this.oModel._getKey(M));}P=v;}else{this._setServiceKey(K,this.oModel._getKey(M));}if(!R.bIsLeafGroupsRequest){var c1=this._getKey(G,K.iIndex-1),d1=this._getGroupIdFromContext(this.oModel.getContext('/'+c1),u);this.mEntityKey[d1]=c1;}}var e1=[];if(this.bReloadSingleUnitMeasures&&E.length>0){if(this.bUseBatchRequests){this.aBatchRequestQueue.push([f._requestType.reloadMeasuresQuery,E]);Promise.resolve().then(f.prototype._processRequestQueue.bind(this));}else{for(var q=0;q<E.length;q++){var f1=E[q];this._executeQueryRequest(f1);}}for(var p=0;p<E.length;p++){var g1=E[p];e1.push(g1.sRequestId);}this._considerRequestGrouping(e1);}if(H&&H.length>0){for(var r=0,h1=H.length;r<h1;r++){delete D.results[r-h1];}}if(U){x+=this._mergeLoadedKeyIndexWithSubsequentIndexes(K,e,s,R.bIsFlatListRequest);}if(!R.bAvoidLengthUpdate){var i1=false;if(D.__count){this.mServiceLength[G]=parseInt(D.__count,10);this.mLength[G]=this.mServiceLength[G]-x;this.mFinalLength[G]=true;if(R.bIsFlatListRequest){this.iTotalSize=D.__count;}i1=true;}if(this.mServiceLength[G]<t+O){this.mServiceLength[G]=t+O;this.mLength[G]=n+O-x;this.mFinalLength[G]=false;}if(O<L||L===undefined){this.mServiceLength[G]=t+O;this.mLength[G]=n+K.iIndex-n;this.mFinalLength[G]=true;i1=true;}if(O==0){this.mLength[G]=this.mServiceLength[G]=0;this.mFinalLength[G]=true;i1=true;}if(!i1&&this.mLength[G]!==undefined&&x>0){this.mLength[G]-=x;}}this.bNeedsUpdate=true;if(x>0){if(D.results.length-x>0){this.aMultiUnitLoadFactor[e.length]=D.results.length/(D.results.length-x);}if(this.aMultiUnitLoadFactor[e.length]<1.5){this.aMultiUnitLoadFactor[e.length]=2;}}Q.sap.log.info("MultiUnit Situation in Group ("+G+"), discarded: "+x+", load-factor is now: "+this.aMultiUnitLoadFactor[e.length]);};f.prototype._processTotalSizeQueryResponse=function(r,D){if(D.__count==undefined){Q.sap.log.fatal("missing entity count in query result");return;}this.iTotalSize=D.__count;};f.prototype._processLevelMembersQueryResponse=function(r,D){var t=this;var p,P;var e=function(g,I){var G={iRequestType:f._requestType.groupMembersQuery,sRequestId:t._getRequestId(f._requestType.groupMembersQuery,{groupId:p}),oAnalyticalQueryRequest:r.oAnalyticalQueryRequest,sGroupId:p,aSelectedUnitPropertyName:r.aSelectedUnitPropertyName,aAggregationLevel:r.aAggregationLevel,bIsFlatListRequest:r.bIsFlatListRequest,bIsLeafGroupsRequest:r.bIsLeafGroupsRequest,iStartIndex:g?r.iStartIndex:0,iLength:r.iLength,bAvoidLengthUpdate:r.bAvoidLengthUpdate};if(g&&r.iStartIndex>0&&(r.sGroupId_Missing_AtLevel!=G.sGroupId||t._getKeys(G.sGroupId)===undefined)){var s=t._getParentGroupId(G.sGroupId);var h=t._findKeyIndex(s,t.mEntityKey[G.sGroupId]);if(h==-1){Q.sap.log.fatal("assertion failed: failed to determine position of "+G.sGroupId+" in group "+s);}if(h>0&&t._getKey(s,h-1)!==undefined){var j=t._getKey(s,h-1);var k=t._getGroupIdFromContext(t.oModel.getContext('/'+j),t._getGroupIdLevel(G.sGroupId));t.mFinalLength[k]=true;G.iStartIndex=0;}}if(I){G.iLength=P.length;}G.oKeyIndexMapping=t._getKeyIndexMapping(G.sGroupId,G.iStartIndex);var l=Q.extend(true,{},D);l.results=P;t._processGroupMembersQueryResponse(G,l);};if(D.results.length==0){return;}p=this._getGroupIdFromContext(this.oModel.getContext("/"+this.oModel._getKey(D.results[0])),r.iLevel-1);P=[];var g=true;for(var i=0;i<D.results.length;i++){var E=D.results[i];var o=this.oModel.getContext("/"+this.oModel._getKey(D.results[i]));var s=this._getGroupIdFromContext(o,r.iLevel-1);if(p==s){P.push(E);if(i<D.results.length-1){continue;}}e(g,D.results.length==r.iLength&&i==D.results.length-1);g=false;if(p!=s){P=[E];}p=s;}if(D.results.length>1&&P.length==1){e(g,D.results.length==r.iLength);}};f.prototype._processReloadMeasurePropertiesQueryResponse=function(r,D){var m=r.oMultiUnitRepresentative;var M=this.oModel.getKey(m.oEntry);if(D.results.length!=1){Q.sap.log.fatal("assertion failed: more than one entity for reloaded measure properties of entity with key "+M);return;}var R=D.results[0];var o=this.oModel.getObject("/"+M);if(!o){Q.sap.log.fatal("assertion failed: no entity found with key "+M);return;}var e=m.aReloadMeasurePropertyName;for(var i=0;i<e.length;i++){o[e[i]]=R[e[i]];}};f.prototype._getLoadedContextsForGroup=function(g,s,l,e){var h=[],o,k=this._getKeys(g),K;if(!k){return h;}if(!s){s=0;}if(!l){l=this.oModel.iSizeLimit;if(this.mFinalLength[g]){l=this.mLength[g];}}if(e){i=s||0;K=k(i);while(K){o=this.oModel.getContext('/'+K);h.push(o);i++;K=k(i);}return h;}for(var i=s;i<s+l;i++){K=k(i);if(!K){break;}o=this.oModel.getContext('/'+K);h.push(o);}return h;};f.prototype._calculateRequiredGroupSection=function(g,s,l,t,e){var h,k,p,P,r,o={},K=this._getKeys(g),m;k=s;h=0;if(!K){P=s;p=s+l;}else{for(var i=s-1;i>=Math.max(s-t,0);i--){m=K(i);if(!m){P=i+1;break;}}for(var j=s+l;j<s+l+t;j++){m=K(j);if(!m){p=j;break;}}}r=s-P;if(P&&s>t&&r<t){if(e.length!==l){k=s-t;}else{k=P-t;}h=t;}k=Math.max(k,0);if(k===s){k+=e.length;}if(e.length!==l){h+=l-e.length;}r=p-s-l;if(r==0){h+=t;}if(p&&r<t&&r>0){if(k>s){k=p;h+=t;}}if(this.mFinalLength[g]&&this.mLength[g]<(h+k)){h=this.mLength[g]-k;}o.startIndex=k;o.length=h;return o;};f.prototype._calculateRequiredGroupExpansion=function(g,e,s,l){var n={groupId_Missing:null,length_Missing:0};var t=this;var h=function(g,e,s,l){var L=t._getGroupIdLevel(g);if(L==e){var r=t._getLoadedContextsForGroup(g,s,l);var u=s+r.length-1;if(r.length>=l){return n;}else if(t.mFinalLength[g]){if(r.length>=t.mLength[g]){return{groupId_Missing:null,length_Missing:l-r.length};}else{return{groupId_Missing:g,startIndex_Missing:u+1,length_Missing:l-r.length};}}else{return{groupId_Missing:g,startIndex_Missing:u+1,length_Missing:l-r.length};}}var v=t._getLoadedContextsForGroup(g,s,l);var j=l,w=s+v.length-1;for(var i=-1,x;(x=v[++i])!==undefined;){j--;var G=h(t._getGroupIdFromContext(x,L+1),e,0,j);if(G.groupId_Missing==null){if(G.length_Missing==0){return G;}else{j=G.length_Missing;}}else{return G;}if(j==0){break;}}if(t.mFinalLength[g]||j==0){return{groupId_Missing:null,length_Missing:j};}else{return{groupId_Missing:g,startIndex_Missing:w+1,length_Missing:j};}};var L=this._getGroupIdLevel(g);if(L==e+1){g=this._getParentGroupId(g);--L;}if(g==null||L>e){return n;}var j=l,k=s;while(g!=null){var G=h(g,e,k,j);if(G.groupId_Missing!=null){return G;}else if(G.length_Missing==0){return G;}else{var m=false;while(!m){var p=this._getParentGroupId(g);if(p==null){g=p;--L;break;}var o=this.mEntityKey[g];if(!o){return n;}var q=this._findKeyIndex(p,o);if(q==-1){return n;}if(q==this._getKeyCount(p)-1){if(this.mFinalLength[p]){g=p;--L;continue;}else{return{groupId_Missing:p,startIndex_Missing:q+1,length_Missing:j};}}else{o=this._getKey(p,q+1);g=this._getGroupIdFromContext(this.oModel.getContext('/'+o),L);m=true;}}k=0;j=G.length_Missing;}}return{groupId_Missing:null,length_Missing:j};};f.prototype._getResourcePath=function(){return this.isRelative()?this.oModel.resolve(this.sPath,this.getContext()):this.sPath;};f.prototype._getEntitySet=function(){var e=this.sEntitySetName;if(!e){e=this.sPath.split("/")[1];if(e.indexOf("(")!=-1){e=e.split("(")[0]+"Results";}}return e;};f.prototype._getEffectiveSortOrder=function(p){for(var i=0;i<this.aSorter.length;i++){if(this.aSorter[i]&&this.aSorter[i].sPath==p){return this.aSorter[i].bDescending?d.SortOrder.Descending:d.SortOrder.Ascending;}}return null;};f.prototype._getFilterOperatorMatchingPropertySortOrder=function(p,w){var s;switch(this._getEffectiveSortOrder(p)){case d.SortOrder.Ascending:if(w){s=a.GE;}else{s=a.GT;}break;case d.SortOrder.Descending:if(w){s=a.LE;}else{s=a.LT;}break;default:s=a.GT;}return s;};f.prototype._convertDeprecatedFilterObjects=function(e){if(!e){return e;}var O=sap.ui.require("sap/ui/model/odata/Filter");if(typeof O==='function'){for(var i=0,l=e.length;i<l;i++){if(e[i]instanceof O){e[i]=e[i].convert();}}}return e;};f.prototype._getGroupIdFromContext=function(o,l){if(!o){return null;}var g="/";var D=null;if(l>this.aAggregationLevel.length){Q.sap.log.fatal("assertion failed: aggregation level deeper than number of current aggregation levels");}for(var i=0;i<l;i++){D=o.getProperty(this.aAggregationLevel[i]);if(D!=null){g+=encodeURIComponent(D)+"/";}else{g+="@/";}}return g;};f.prototype._getGroupIdLevel=function(g){if(g==null){Q.sap.log.fatal("assertion failed: no need to determine level of group ID = null");return-1;}return g.split("/").length-2;};f.prototype._getGroupIdComponents=function(g){if(g==null){return null;}var G=g.split("/");var D=[];for(var i=1;i<G.length-1;i++){if(G[i]=="@"){D[i-1]=null;}else{D[i-1]=decodeURIComponent(G[i]);}}return D;};f.prototype._getGroupIdAncestors=function(g,n){if(!n){return[];}if(g==null){Q.sap.log.fatal("group ID null does not have ancestors");return[];}if(g=="/"){if(Math.abs(n)==1){return[null];}else{Q.sap.log.fatal("invalid level count "+n+" for ancestors of groupId "+g);return[];}}var G=g.split("/");var e=[],s="";var h=0,t=G.length-3;if(n>0){if(n-1>t){Q.sap.log.fatal("invalid level count "+n+" for ancestors of groupId "+g);}else{t=n-1;}}else if(-(n+1)>t){Q.sap.log.fatal("invalid level count "+n+" for ancestors of groupId "+g);}else{h=t+1+n;for(var i=0;i<h;i++){s+=G[i]+"/";}}for(var j=h;j<=t;j++){s+=G[j]+"/";e.push(s);}return e;};f.prototype._getParentGroupId=function(g){return this._getGroupIdAncestors(g,-1)[0];};f.prototype._removeDuplicatesFromStringArray=function(e){var t={};for(var i=0;i<e.length;i++){t[e[i]]=true;}var u=[];for(var s in t){u.push(s);}return u;};f.prototype._getIdForNewRequestHandle=function(){if(this.oPendingRequestHandle===undefined){this.oPendingRequestHandle=[];}for(var i=0;i<this.oPendingRequestHandle.length;i++){if(this.oPendingRequestHandle[i]===undefined){return i;}}this.oPendingRequestHandle[this.oPendingRequestHandle.length]=undefined;return this.oPendingRequestHandle.length-1;};f.prototype._registerNewRequestHandle=function(r,R){if(this.oPendingRequestHandle[r]!==undefined){Q.sap.log.fatal("request handle ID already in use");}this.oPendingRequestHandle[r]=R;};f.prototype._deregisterHandleOfCompletedRequest=function(r){if(Q.isEmptyObject(this.oPendingRequestHandle)){Q.sap.log.warning("No request handles to be cleared. Previous abort/resetData?");return;}if(this.oPendingRequestHandle[r]===undefined){Q.sap.log.fatal("no handle found for this request ID");}this.oPendingRequestHandle[r]=undefined;};f.prototype._abortAllPendingRequestsByHandle=function(){for(var i=0;i<this.oPendingRequestHandle.length;i++){if(this.oPendingRequestHandle[i]){if(this.oPendingRequestHandle[i]!==undefined){this.oPendingRequestHandle[i].abort();}}}this.oPendingRequestHandle=[];};f.prototype._getRequestId=function(r,p){switch(r){case f._requestType.groupMembersQuery:if(p.groupId===undefined){Q.sap.log.fatal("missing group ID");}return f._requestType.groupMembersQuery+(p.groupId==null?"":p.groupId);case f._requestType.levelMembersQuery:if(p.level===undefined){Q.sap.log.fatal("missing level");}if(p.groupId===undefined){Q.sap.log.fatal("missing groupId");}return""+f._requestType.levelMembersQuery+p.level+(p.tupleIndex?"-"+p.tupleIndex:"");case f._requestType.totalSizeQuery:return f._requestType.totalSizeQuery;case f._requestType.reloadMeasuresQuery:if(!p.multiUnitEntryKey){Q.sap.log.fatal("missing multi unit entry key");}return f._requestType.reloadMeasuresQuery+p.multiUnitEntryKey;default:Q.sap.log.fatal("invalid request type "+r);return-1;}};f.prototype._registerNewRequest=function(r){if(r==undefined||r==""){Q.sap.log.fatal("missing request ID");return;}if(!this.oPendingRequests[r]){this.oPendingRequests[r]=1;}else{++this.oPendingRequests[r];}};f.prototype._considerRequestGrouping=function(r){for(var i=-1,R;(R=r[++i])!==undefined;){if(this.oGroupedRequests[R]===undefined){this.oGroupedRequests[R]={};}var g=this.oGroupedRequests[R];for(var j=0;j<r.length;j++){g[r[j]]=true;}}};f.prototype._isRequestPending=function(r){return this.oPendingRequests[r]!=undefined&&this.oPendingRequests[r]>0;};f.prototype._deregisterCompletedRequest=function(r){if(Q.isEmptyObject(this.oPendingRequests)){Q.sap.log.warning("There are no pending requests which could be set to 'completed'.");return;}if(!this.oPendingRequests[r]){Q.sap.log.fatal("assertion failed: there is no pending request ID "+r);}if(this.oPendingRequests[r]==1){delete this.oPendingRequests[r];}else{--this.oPendingRequests[r];}};f.prototype._cleanupGroupingForCompletedRequest=function(r){if(this._isRequestPending(r)){return false;}var g=true;if(this.oGroupedRequests[r]!=undefined){for(var o in this.oGroupedRequests[r]){if(this.oPendingRequests[o]){g=false;break;}}}if(g){var R=this.oGroupedRequests[r];delete this.oGroupedRequests[r];for(var O in R){if(O!=r){this._cleanupGroupingForCompletedRequest(O);}}}return g;};f.prototype._getKeyIndexMapping=function(g,s){var k=this.mKeyIndex[g];var e=this.mServiceKey[g];var i=s;if(k!==undefined){var l=s;if(l>0){while(--l>0){if(k[l]!==undefined){break;}}}var L;if(l==0){L=0;}else{if(k[l]>=0){L=k[l];}else if(k[l+1]===undefined){L=k[l]=="ZERO"?0:-k[l];while(e[L+1]!==undefined){++L;}}else{L=Math.abs(k[l+1])-1;}if(e[L]===undefined){Q.sap.log.fatal("assertion failed: no service key at iLastOccupiedServiceKeyIndex = "+L);}}var D=s-l;i=L+D;}var K={sGroupId:g,iIndex:s,iServiceKeyIndex:i};return K;};f.prototype._moveKeyIndexMapping=function(k,i){return this._getKeyIndexMapping(k.sGroupId,k.iIndex+i);};f.prototype._getKey=function(g,i){var s=this.mKeyIndex[g][i];if(s===undefined){return undefined;}if(s>=0){return this.mServiceKey[g][s];}if(this.mMultiUnitKey[g]===undefined){Q.sap.log.fatal("assertion failed: missing expected multi currency key for group with ID "+g);return null;}var k=this.mMultiUnitKey[g][i];if(k===undefined){Q.sap.log.fatal("assertion failed: missing expected multi currency key for group with ID "+g+" at pos "+i);return null;}return k;};f.prototype._getKeys=function(g){if(this.mKeyIndex[g]===undefined){return undefined;}var t=this;return function(i){return t._getKey(g,i);};};f.prototype._getServiceKeys=function(g,I){var k=this.mKeyIndex[g];if(k===undefined){return undefined;}var s=this.mServiceKey[g],e=k[I];if(e===undefined){return undefined;}if(e>=0){return[s[e]];}var G=[];if(k[I+1]===undefined){e=k[I]=="ZERO"?0:-k[I];while(s[e]!==undefined){G.push(s[e++]);}}else{e=k[I]=="ZERO"?0:-k[I];for(var i=e,n=Math.abs(k[I+1]);i<n;i++){G.push(s[i]);}}return G;};f.prototype._getKeyCount=function(g){if(this.mKeyIndex[g]===undefined){return undefined;}return this.mKeyIndex[g].length;};f.prototype._findKeyIndex=function(g,k){var K=this.mKeyIndex[g];var s=this.mServiceKey[g];var m=this.mMultiUnitKey[g];for(var i=0;i<this.mLength[g];i++){if(K[i]<0){if(m[i]==k){return i;}}else if(s[K[i]]==k){return i;}}return-1;};f.prototype._setServiceKey=function(k,s){if(!this.mServiceKey[k.sGroupId]){this.mServiceKey[k.sGroupId]=[];}if(!this.mKeyIndex[k.sGroupId]){this.mKeyIndex[k.sGroupId]=[];}var n=this.mServiceKey[k.sGroupId][k.iServiceKeyIndex]===undefined;this.mServiceKey[k.sGroupId][k.iServiceKeyIndex++]=s;this.mKeyIndex[k.sGroupId][k.iIndex++]=k.iServiceKeyIndex-1;return n;};f.prototype._setAdjacentMultiUnitKeys=function(k,m,M){if(!this.mServiceKey[k.sGroupId]){this.mServiceKey[k.sGroupId]=[];}if(!this.mKeyIndex[k.sGroupId]){this.mKeyIndex[k.sGroupId]=[];}if(!this.mMultiUnitKey[k.sGroupId]){this.mMultiUnitKey[k.sGroupId]=[];}--k.iIndex;--k.iServiceKeyIndex;this.mMultiUnitKey[k.sGroupId][k.iIndex]=this.oModel._getKey(m.oEntry);this.mKeyIndex[k.sGroupId][k.iIndex++]=k.iServiceKeyIndex>0?-k.iServiceKeyIndex:"ZERO";var n=0;for(var i=0;i<M.length;i++){if(!this.mServiceKey[k.sGroupId][k.iServiceKeyIndex]){++n;}this.mServiceKey[k.sGroupId][k.iServiceKeyIndex++]=this.oModel._getKey(M[i]);}return n;};f.prototype._mergeLoadedKeyIndexWithSubsequentIndexes=function(k,e,s,I){var K=this.mKeyIndex[k.sGroupId],g=this.mServiceKey[k.sGroupId],m=this.mMultiUnitKey[k.sGroupId],D=0,n=k.iServiceKeyIndex,h=k.iIndex;var M,o;if(K===undefined){return D;}var N=false;var p=g[n-1],j=g[n];if(j===undefined){return D;}if(p===undefined){Q.sap.log.fatal("assertion failed: missing expected entry before given key index");return D;}var P=this.oModel.getObject("/"+p);var l=this.oModel.getObject("/"+j);var q="",r="";for(var i=0;i<e.length;i++){q+=P[e[i]]+"|";r+=l[e[i]]+"|";}N=q==r;var t=h;if(t>=this.mLength[k.sGroupId]){Q.sap.log.fatal("assertion failed: service key exists,but no corresponding key index found");return D;}while(K[t]===undefined||Math.abs(K[t])<n){++t;}if(N){if(Math.abs(K[t])==n&&K[t]<0){if(t>h){if(K[h-1]<0){m[t]=undefined;K.splice(h,t-h+1);m.splice(h,t-h+1);}else{K[h-1]=-K[h-1];m[h-1]=m[t];m[t]=undefined;K.splice(h,t-h+1);m.splice(h,t-h+1);D=1;}}}else if(Math.abs(K[t])>n){var u=t-1;if(K[u]>0){M=this._createMultiUnitRepresentativeEntry(k.sGroupId,P,s,undefined,I);o=this.oModel._getKey(M.oEntry);K[u]=-K[u];m[u]=o;if(u>h){K.splice(h,u-h);m.splice(h,u-h);}if(M.bIsNewEntry){D=1;}else{D=0;}}else if(K[h-1]<0){if(t>h){m[u]=undefined;K.splice(h,u-h+1);m.splice(h,u-h+1);}}else{K[h-1]=-K[h-1];m[h-1]=m[u];m[u]=undefined;K.splice(h,u-h+1);m.splice(h,u-h+1);}}else if(K[t]==n){if(t>h){if(K[h-1]<0){K.splice(h,t-h+1);m.splice(h,t-h+1);D=1;}else{M=this._createMultiUnitRepresentativeEntry(k.sGroupId,P,s,undefined,I);o=this.oModel._getKey(M.oEntry);if(!M.bIsNewEntry){Q.sap.log.fatal("assertion failed: multi-unit entry already existed before");}K[h-1]=-K[h-1];m[h-1]=o;K.splice(h,t-h+1);m.splice(h,t-h+1);D=1;}}}else{Q.sap.log.fatal("assertion failed: uncovered case detected");return D;}}else if(K[t]>n){Q.sap.log.fatal("unstable query result for group ID "+k.sGroupId+": entries have been removed or added. Complete reload required");}else if(t-h>0){K.splice(h,t-h);m.splice(h,t-h);}return D;};f.prototype._createMultiUnitRepresentativeEntry=function(g,r,s,D,i){var m=Q.extend(true,{},r);var R=[];for(var M in this.oMeasureDetailsSet){var o=this.oMeasureDetailsSet[M];if(!i&&!this.mAnalyticalInfoByProperty[M].total){if(o.rawValuePropertyName!=undefined){m[o.rawValuePropertyName]=undefined;}if(o.formattedValuePropertyName!=undefined){m[o.formattedValuePropertyName]=undefined;}}else{if(o.rawValuePropertyName!=undefined){m[o.rawValuePropertyName]=null;}if(o.formattedValuePropertyName!=undefined){m[o.formattedValuePropertyName]="*";}}if(D){if(!o.unitPropertyName||Q.inArray(o.unitPropertyName,D)==-1){R.push(o.rawValuePropertyName);}}}for(var k=0;k<s.length;k++){if(Q.inArray(s[k],D)!=-1){m[s[k]]="*";}}var e="";for(var l=0;l<this.aAllDimensionSortedByName.length;l++){var h=m[this.aAllDimensionSortedByName[l]];e+=(h===undefined?"":h)+",";}e+="-multiple-units-not-dereferencable";var j;if(this.mMultiUnitKey[g]&&(j=Q.inArray(e,this.mMultiUnitKey[g]))!=-1){return{oEntry:this.oModel.getObject("/"+e),bIsNewEntry:false,iIndex:j,aReloadMeasurePropertyName:R};}m.__metadata.uri=e;delete m.__metadata["self"];delete m.__metadata["self_link_extensions"];m["^~volatile"]=true;this.oModel._importData(m,{});var n=this.oModel._getKey(m);this.oModel.getContext('/'+n)["_volatile"]=true;return{oEntry:m,bIsNewEntry:true,aReloadMeasurePropertyName:R};};f.prototype._clearAllPendingRequests=function(){this.oPendingRequests={};this.oGroupedRequests={};};f.prototype.resetData=function(o){var g=o?o.getPath():undefined;this._resetData(g);};f.prototype._resetData=function(g){if(g){delete this.mServiceKey[g];delete this.mServiceLength[g];delete this.mServiceFinalLength[g];delete this.mKeyIndex[g];delete this.mLength[g];delete this.mMultiUnitKey[g];delete this.mEntityKey[g];}else{this.mServiceKey={};this.mServiceLength={};this.mServiceFinalLength={};this.mFinalLength=this.mServiceFinalLength;this.mKeyIndex={};this.mLength={};this.mMultiUnitKey={};this.mEntityKey={};}};f.prototype.refresh=function(e){f.prototype._refresh.apply(this,arguments);};f.prototype._refresh=function(e,m,E){var g=false;if(!e){if(E){var r=this.oModel.resolve(this.sPath,this.oContext);var o=this.oModel.oMetadata._getEntityTypeByPath(r);if(o&&(o.entityType in E)){g=true;}}if(m&&!g){Q.each(this.mServiceKey,function(i,n){Q.each(n,function(i,k){if(k in m){g=true;return false;}});if(g){return false;}});}if(!m&&!E){g=true;}}if(e||g){this._abortAllPendingRequests();this.resetData();this.bNeedsUpdate=false;this._fireRefresh({reason:C.Refresh});}};f.prototype.checkUpdate=function(e,m){var g=false;if(!e){if(this.bNeedsUpdate||!m){g=true;}else{Q.each(this.mServiceKey,function(i,n){Q.each(n,function(i,k){if(k in m){g=true;return false;}});if(g){return false;}});}}if(e||g){this.bNeedsUpdate=false;this._fireChange({reason:C.Change});}};f.prototype.getDownloadUrl=function(s){var o=new d.QueryResultRequest(this.oAnalyticalQueryResult);o.setResourcePath(this._getResourcePath());var e=[];var g=[];for(var D in this.oDimensionDetailsSet){e.push(D);}o.setAggregationLevel(e);for(var h in this.oDimensionDetailsSet){var n=this.oDimensionDetailsSet[h];var I=(n.textPropertyName!=undefined);o.includeDimensionKeyTextAttributes(n.name,true,I,n.aAttributeName);}for(var M in this.oMeasureDetailsSet){g.push(M);}o.setMeasures(g);for(var p in this.oMeasureDetailsSet){var q=this.oMeasureDetailsSet[p];var r=(q.rawValuePropertyName!=undefined);var t=(q.formattedValuePropertyName!=undefined);var u=(q.unitPropertyName!=undefined);o.includeMeasureRawFormattedValueUnit(q.name,r,t,u);}var v=o.getSortExpression();v.clear();for(var i=0;i<this.aSorter.length;i++){if(this.aSorter[i]){v.addSorter(this.aSorter[i].sPath,this.aSorter[i].bDescending?d.SortOrder.Descending:d.SortOrder.Ascending);}}var w=o.getFilterExpression();w.clear();if(this.aApplicationFilter){w.addUI5FilterConditions(this.aApplicationFilter);}if(this.aControlFilter){w.addUI5FilterConditions(this.aControlFilter);}var P=o.getURIToQueryResultEntitySet();var x=this._getQueryODataRequestOptions(o);if(!x){return undefined;}var E=[];for(var k=0,m=this.aAnalyticalInfo.length;k<m;k++){var y=this.aAnalyticalInfo[k];if((y.visible||y.inResult)&&y.name!==""){E.push(y.name);if(this.oMeasureDetailsSet[y.name]!=undefined&&this.oMeasureDetailsSet[y.name].unitPropertyName!=undefined){E.push(this.oMeasureDetailsSet[y.name].unitPropertyName);}}}for(var j=0,l=x.length;j<l;j++){if(/^\$select/i.test(x[j])){x[j]="$select="+E.join(",");break;}}if(s){x.splice(0,0,"$format="+encodeURIComponent(s));}if(this.sCustomParams){x.push(this.sCustomParams);}if(P){return this.oModel._createRequestUrl(P,null,x);}};return f;});
