/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine('sap/ui/table/AnalyticalColumn',['jquery.sap.global','./Column','./library','sap/ui/core/Element','sap/ui/model/type/Boolean','sap/ui/model/type/DateTime','sap/ui/model/type/Float','sap/ui/model/type/Integer','sap/ui/model/type/Time','./TableUtils'],function(q,C,l,E,B,D,F,I,T,a){"use strict";
function i(c){return a.isInstanceOf(c,"sap/ui/table/AnalyticalTable");}
var A=C.extend("sap.ui.table.AnalyticalColumn",{metadata:{library:"sap.ui.table",properties:{leadingProperty:{type:"string",group:"Misc",defaultValue:null},summed:{type:"boolean",group:"Misc",defaultValue:false},inResult:{type:"boolean",group:"Misc",defaultValue:false},showIfGrouped:{type:"boolean",group:"Appearance",defaultValue:false},groupHeaderFormatter:{type:"any",group:"Behavior",defaultValue:null}}}});
A.prototype.init=function(){C.prototype.init.apply(this,arguments);this._bSkipUpdateAI=false;};
A._DEFAULT_FILTERTYPES={"Time":new T({UTC:true}),"DateTime":new D({UTC:true}),"Float":new F(),"Integer":new I(),"Boolean":new Boolean()};
A.prototype._createMenu=function(){var b=sap.ui.requireSync("sap/ui/table/AnalyticalColumnMenu");return new b(this.getId()+"-menu");};
A.prototype.setGrouped=function(g,s){var p=this.getParent();var t=this;if(i(p)){if(g){p._addGroupedColumn(this.getId());}else{p._aGroupedColumns=q.grep(p._aGroupedColumns,function(v){return v!=t.getId();});}}var r=this.setProperty("grouped",g,s);this._updateColumns(true);return r;};
A.prototype.setSummed=function(s){var r=this.setProperty("summed",s,true);this._updateTableAnalyticalInfo();return r;};
A.prototype.setVisible=function(v,s){this.setProperty("visible",v,s);this._updateColumns();return this;};
A.prototype.getLabel=function(){var L=this.getAggregation("label");if(!L){if(!this._oBindingLabel){var p=this.getParent();if(i(p)){var b=p.getBinding("rows");if(b){this._oBindingLabel=l.TableHelper.createLabel();var m=b.getModel();if(m.oMetadata&&m.oMetadata.isLoaded()){this._oBindingLabel.setText(b.getPropertyLabel(this.getLeadingProperty()));}else{var t=this;m.attachMetadataLoaded(function(){t._oBindingLabel.setText(b.getPropertyLabel(t.getLeadingProperty()));});}}}}L=this._oBindingLabel;}return L;};
A.prototype.getFilterProperty=function(){var p=this.getProperty("filterProperty");if(!p){var P=this.getParent();if(i(P)){var b=P.getBinding("rows");var L=this.getLeadingProperty();if(b&&q.inArray(L,b.getFilterablePropertyNames())>-1){p=L;}}}return p;};
A.prototype.getSortProperty=function(){var p=this.getProperty("sortProperty");if(!p){var P=this.getParent();if(i(P)){var b=P.getBinding("rows");var L=this.getLeadingProperty();if(b&&q.inArray(L,b.getSortablePropertyNames())>-1){p=L;}}}return p;};
A.prototype.getFilterType=function(){var f=this.getProperty("filterType");if(!f){var p=this.getParent();if(i(p)){var b=p.getBinding("rows");var L=this.getLeadingProperty(),P=b&&b.getProperty(L);if(P){switch(P.type){case"Edm.Time":f=A._DEFAULT_FILTERTYPES["Time"];break;case"Edm.DateTime":case"Edm.DateTimeOffset":f=A._DEFAULT_FILTERTYPES["DateTime"];break;case"Edm.Single":case"Edm.Double":case"Edm.Decimal":f=A._DEFAULT_FILTERTYPES["Float"];break;case"Edm.SByte":case"Edm.Int16":case"Edm.Int32":case"Edm.Int64":f=A._DEFAULT_FILTERTYPES["Integer"];break;case"Edm.Boolean":f=A._DEFAULT_FILTERTYPES["Boolean"];break;}}}}return f;};
A.prototype._afterSort=function(){this._updateTableAnalyticalInfo();};
A.prototype._updateColumns=function(s,f){if(this._bSkipUpdateAI){return;}var p=this.getParent();if(i(p)){p._updateColumns(s,f);}};
A.prototype._updateTableAnalyticalInfo=function(s){if(this._bSkipUpdateAI){return;}var p=this.getParent();if(p&&i(p)&&!p._bSuspendUpdateAnalyticalInfo){p.updateAnalyticalInfo(s);}};
A.prototype._updateTableColumnDetails=function(){if(this._bSkipUpdateAI){return;}var p=this.getParent();if(p&&i(p)&&!p._bSuspendUpdateAnalyticalInfo){p._updateTableColumnDetails();}};
A.prototype.shouldRender=function(){if(!this.getVisible()){return false;}return(!this.getGrouped()||this._bLastGroupAndGrouped||this.getShowIfGrouped())&&(!this._bDependendGrouped||this._bLastGroupAndGrouped);};
A.prototype.getTooltip_AsString=function(){var t=E.prototype.getTooltip_AsString.apply(this);var p=this.getParent();if(!t&&i(p)){var b=p.getBinding("rows");if(b&&this.getLeadingProperty()){t=b.getPropertyQuickInfo(this.getLeadingProperty());}}return t;};
A.prototype._menuHasItems=function(){var m=function(){var t=this.getParent();var b=t.getBinding("rows");var r=b&&b.getAnalyticalQueryResult();return(t&&r&&r.findMeasureByPropertyName(this.getLeadingProperty()));}.bind(this);return C.prototype._menuHasItems.apply(this)||m();};
A.prototype.isFilterableByMenu=function(){var f=this.getFilterProperty();if(!f||!this.getShowFilterMenuEntry()){return false;}var p=this.getParent();if(i(p)){var b=p.getBinding("rows");if(b){if(q.inArray(f,b.getFilterablePropertyNames())>-1&&!b.isMeasure(f)&&b.getProperty(f)){return true;}}}return false;};
A.prototype.isGroupableByMenu=function(){var p=this.getParent();if(i(p)){var b=p.getBinding("rows");if(b){var r=b.getAnalyticalQueryResult();if(r&&r.findDimensionByPropertyName(this.getLeadingProperty())&&q.inArray(this.getLeadingProperty(),b.getSortablePropertyNames())>-1&&q.inArray(this.getLeadingProperty(),b.getFilterablePropertyNames())>-1){return true;}}}return false;};
return A;});
sap.ui.predefine('sap/ui/table/AnalyticalColumnMenu',['jquery.sap.global','./ColumnMenu','./library'],function(q,C,l){"use strict";var G=l.GroupEventType;
var A=C.extend("sap.ui.table.AnalyticalColumnMenu",{metadata:{library:"sap.ui.table"}});
A.prototype.init=function(){C.prototype.init.apply(this);};
A.prototype._addMenuItems=function(){C.prototype._addMenuItems.apply(this);if(this._oColumn){this._addSumMenuItem();}};
A.prototype._addGroupMenuItem=function(){var c=this._oColumn,t=this._oTable;if(c.isGroupableByMenu()){this._oGroupIcon=this._createMenuItem("group","TBL_GROUP",c.getGrouped()?"accept":null,q.proxy(function(e){var m=e.getSource(),g=c.getGrouped();c.setGrouped(!g);t.fireGroup({column:c,groupedColumns:t._aGroupedColumns,type:G.group});m.setIcon(!g?"sap-icon://accept":null);t._getRowContexts();},this));this.addItem(this._oGroupIcon);}};
A.prototype._addSumMenuItem=function(){var c=this._oColumn,t=this._oTable,b=t.getBinding("rows"),r=b&&b.getAnalyticalQueryResult();if(t&&r&&r.findMeasureByPropertyName(c.getLeadingProperty())){this._oSumItem=this._createMenuItem("total","TBL_TOTAL",c.getSummed()?"accept":null,q.proxy(function(e){var m=e.getSource(),s=c.getSummed();c.setSummed(!s);m.setIcon(!s?"sap-icon://accept":null);t._getRowContexts();},this));this.addItem(this._oSumItem);}};
A.prototype.open=function(){C.prototype.open.apply(this,arguments);var c=this._oColumn;this._oSumItem&&this._oSumItem.setIcon(c.getSummed()?"sap-icon://accept":null);this._oGroupIcon&&this._oGroupIcon.setIcon(c.getGrouped()?"sap-icon://accept":null);};
return A;});
sap.ui.predefine('sap/ui/table/AnalyticalColumnMenuRenderer',['jquery.sap.global','sap/ui/core/Renderer','./ColumnMenuRenderer'],function(q,R,C){"use strict";var A=R.extend(C);return A;},true);
sap.ui.predefine('sap/ui/table/AnalyticalTable.designtime',[],function(){"use strict";return{aggregations:{columns:{domRef:".sapUiTableColHdrScr"},hScroll:{ignore:false,domRef:function(){return this.$("hsb").get(0);}},vScroll:{ignore:false,domRef:function(){return this.$("vsb").get(0);}}}};},false);
sap.ui.predefine('sap/ui/table/AnalyticalTable',['jquery.sap.global','./AnalyticalColumn','./Table','./TreeTable','./library','sap/ui/model/analytics/ODataModelAdapter','sap/ui/model/SelectionModel','sap/ui/model/Sorter','sap/ui/base/ManagedObject','sap/ui/core/Popup','sap/ui/unified/Menu','sap/ui/unified/MenuItem','./TableUtils'],function(q,A,T,a,b,O,S,c,M,P,d,e,f){"use strict";var G=b.GroupEventType,g=b.SelectionBehavior,h=b.SelectionMode,k=b.SortOrder;
var m=T.extend("sap.ui.table.AnalyticalTable",{
metadata:{library:"sap.ui.table",properties:{sumOnTop:{type:"boolean",group:"Appearance",defaultValue:false},numberOfExpandedLevels:{type:"int",group:"Misc",defaultValue:0},autoExpandMode:{type:"string",group:"Misc",defaultValue:"Bundled"},columnVisibilityMenuSorter:{type:"any",group:"Appearance",defaultValue:null},collapseRecursive:{type:"boolean",defaultValue:true},dirty:{type:"boolean",group:"Appearance",defaultValue:null,deprecated:true}},designTime:true},
renderer:"sap.ui.table.TableRenderer"
});
m.prototype._getFixedBottomRowContexts=function(){var B=this.getBinding("rows");if(B){return[B.getGrandTotalNode()];}};
m.prototype._getContexts=a.prototype._getContexts;
m.prototype.init=function(){T.prototype.init.apply(this,arguments);this.addStyleClass("sapUiAnalyticalTable");this.attachBrowserEvent("contextmenu",this._onContextMenu);this.setSelectionMode(h.MultiToggle);this.setShowColumnVisibilityMenu(true);this.setEnableColumnFreeze(true);this.setEnableCellFilter(true);this._aGroupedColumns=[];this._bSuspendUpdateAnalyticalInfo=false;f.Grouping.setGroupMode(this);};
m.prototype.setFixedRowCount=function(){q.sap.log.error("The property fixedRowCount is not supported by the AnalyticalTable and must not be set!");return this;};
m.prototype.setFixedBottomRowCount=function(){q.sap.log.error("The property fixedBottomRowCount is managed by the AnalyticalTable and must not be set!");return this;};
m.prototype.setDirty=function(D){q.sap.log.error("The property \"dirty\" is deprecated. Please use \"showOverlay\".");this.setProperty("dirty",D,true);this.setShowOverlay(this.getDirty());return this;};
m.prototype.getModel=function(n){var o=T.prototype.getModel.apply(this,arguments);var r=this.getBindingInfo("rows");if(o&&r&&r.model==n){O.apply(o);}return o;};
m.prototype._onBindingChange=function(E){T.prototype._onBindingChange.apply(this,arguments);var r=typeof(E)==="object"?E.getParameter("reason"):E;if(r!=="sort"){this._invalidateColumnMenus();}};
m.prototype.bindRows=function(B){var o=this._sanitizeBindingInfo.apply(this,arguments);var r=this.bindAggregation("rows",o);this._updateTotalRow(true);return r;};
m.prototype._bindAggregation=function(n,p,t,s,F){if(n==="rows"){this.setProperty("firstVisibleRow",0,true);this._sanitizeBindingInfo.call(this,p,t,s,F);}return T.prototype._bindAggregation.apply(this,arguments);};
m.prototype._initSelectionModel=function(s){this._oSelection=new S(s);return this;};
m.prototype.setSelectionMode=function(s){if(s===h.None){q.sap.log.fatal("SelectionMode 'None' is not supported by the AnalyticalTable.");return this;}var B=this.getBinding("rows");if(B&&B.clearSelection){B.clearSelection();}this.setProperty("selectionMode",s);return this;};
m.prototype.setSelectionBehavior=function(B){if(B===g.RowOnly){q.sap.log.fatal("SelectionBehavior 'RowOnly' is not supported by the AnalyticalTable.");return this;}else{return T.prototype.setSelectionBehavior.apply(this,arguments);}};
m.prototype._sanitizeBindingInfo=function(B){var p,t,s,F;if(typeof B=="string"){p=arguments[0];t=arguments[1];s=arguments[2];F=arguments[3];B={path:p,sorter:s,filters:F};if(t instanceof M){B.template=t;}else if(typeof t==="function"){B.factory=t;}}var C=this.getColumns();for(var i=0,l=C.length;i<l;i++){if(C[i].getSorted()){B.sorter=B.sorter||[];B.sorter.push(new c(C[i].getSortProperty()||C[i].getLeadingProperty(),C[i].getSortOrder()===k.Descending));}}B.parameters=B.parameters||{};B.parameters.analyticalInfo=this._getColumnInformation();B.parameters.sumOnTop=this.getSumOnTop();B.parameters.numberOfExpandedLevels=this.getNumberOfExpandedLevels();B.parameters.autoExpandMode=this.getAutoExpandMode();var o=this.getModel(B.model);if(o){O.apply(o);}return B;};
m.prototype._setSuppressRefresh=function(s){this._bSupressRefresh=s;return this;};
m.prototype._attachBindingListener=function(){var B=this.getBinding("rows");if(B&&!B.hasListeners("selectionChanged")){B.attachSelectionChanged(this._onSelectionChanged,this);}T.prototype._attachDataRequestedListeners.apply(this);};
m.prototype._getColumnInformation=function(){var C=[],t=this.getColumns();for(var i=0;i<this._aGroupedColumns.length;i++){var o=sap.ui.getCore().byId(this._aGroupedColumns[i]);if(!o){continue;}C.push({name:o.getLeadingProperty(),visible:o.getVisible(),grouped:o.getGrouped(),total:o.getSummed(),sorted:o.getSorted(),sortOrder:o.getSortOrder(),inResult:o.getInResult(),formatter:o.getGroupHeaderFormatter()});}for(var i=0;i<t.length;i++){var o=t[i];if(q.inArray(o.getId(),this._aGroupedColumns)>-1){continue;}if(!o instanceof A){q.sap.log.error("You have to use AnalyticalColumns for the Analytical table");}C.push({name:o.getLeadingProperty(),visible:o.getVisible(),grouped:o.getGrouped(),total:o.getSummed(),sorted:o.getSorted(),sortOrder:o.getSortOrder(),inResult:o.getInResult(),formatter:o.getGroupHeaderFormatter()});}return C;};
m.prototype._updateTableContent=function(){var B=this.getBinding("rows"),F=this.getFirstVisibleRow(),j=this.getFixedBottomRowCount(),C=this.getVisibleRowCount(),n=this.getColumns();var r=this.getRows();if(!B){for(var i=0;i<r.length;i++){f.Grouping.cleanupTableRowForGrouping(this,r[i]);}return;}for(var R=0,l=Math.min(C,r.length);R<l;R++){var I=R>(C-j-1)&&B.getLength()>C,o=I?(B.getLength()-1-(C-1-R)):F+R,p=r[R],$=p.$(),s=this.$().find("div[data-sap-ui-rowindex="+$.attr("data-sap-ui-rowindex")+"]");var t;if(I&&B.bProvideGrandTotals){t=B.getGrandTotalContextInfo();}else{t=this.getContextInfoByIndex(o);}var L=t?t.level:0;if(!t||!t.context){f.Grouping.cleanupTableRowForGrouping(this,p);if(t&&!t.context){$.addClass("sapUiAnalyticalTableDummy");s.addClass("sapUiAnalyticalTableDummy");}continue;}if(B.nodeHasChildren&&B.nodeHasChildren(t)){f.Grouping.updateTableRowForGrouping(this,p,true,t.nodeState.expanded,t.nodeState.expanded&&!this.getSumOnTop(),false,L,B.getGroupName(t.context,t.level));}else{f.Grouping.updateTableRowForGrouping(this,p,false,false,false,t.nodeState.sum,L,t.nodeState.sum&&t.level>0?B.getGroupName(t.context,t.level):null);}var u=p.getCells();for(var i=0,v=u.length;i<v;i++){var w=u[i].data("sap-ui-colindex");var x=n[w];var y=q(u[i].$().closest("td"));if(B.isMeasure(x.getLeadingProperty())){y.addClass("sapUiTableMeasureCell");y.toggleClass("sapUiTableCellHidden",t.nodeState.sum&&!x.getSummed());}else{y.removeClass("sapUiTableMeasureCell");}}}};
m.prototype._onContextMenu=function(E){if(q(E.target).closest('tr').hasClass('sapUiTableGroupHeader')||q(E.target).closest('.sapUiTableRowHdr.sapUiTableGroupHeader').length>0){this._iGroupedLevel=q(E.target).closest('[data-sap-ui-level]').data('sap-ui-level');var o=this._getGroupHeaderMenu();var i=P.Dock;var l=E.pageX||E.clientX;var L=E.pageY||E.clientY;o.open(false,E.target,i.LeftTop,i.LeftTop,document,(l-2)+" "+(L-2));E.preventDefault();E.stopPropagation();return;}return true;};
m.prototype._getGroupHeaderMenu=function(){var t=this;function j(){var i=t._iGroupedLevel-1;if(t._aGroupedColumns[i]){var l=t.getColumns().filter(function(C){if(t._aGroupedColumns[i]==C.getId()){return true;}})[0];return{column:l,index:i};}else{return undefined;}}if(!this._oGroupHeaderMenu){this._oGroupHeaderMenu=new d();this._oGroupHeaderMenuVisibilityItem=new e({text:this._oResBundle.getText("TBL_SHOW_COLUMN"),select:function(){var o=j();if(o){var C=o.column,s=C.getShowIfGrouped();C.setShowIfGrouped(!s);t.fireGroup({column:C,groupedColumns:C.getParent()._aGroupedColumns,type:(!s?G.showGroupedColumn:G.hideGroupedColumn)});}}});this._oGroupHeaderMenu.addItem(this._oGroupHeaderMenuVisibilityItem);this._oGroupHeaderMenu.addItem(new e({text:this._oResBundle.getText("TBL_UNGROUP"),select:function(){var l=t.getColumns(),F=0,L=-1,u=-1,C;for(var i=0;i<l.length;i++){C=l[i];if(C.getGrouped()){F++;if(F==t._iGroupedLevel){C._bSkipUpdateAI=true;var B=t.getBinding("rows");B.setNumberOfExpandedLevels(0);C.setGrouped(false);C._bSkipUpdateAI=false;u=i;t.fireGroup({column:C,groupedColumns:C.getParent()._aGroupedColumns,type:G.ungroup});}else{L=i;}}}if(L>-1&&u>-1&&u<L){var U=l[u];var H=U.getHeaderSpan();if(q.isArray(H)){H=H[0];}var r=[];for(var i=u;i<u+H;i++){r.push(l[i]);}q.each(r,function(I,C){t.removeColumn(C);t.insertColumn(C,L);});}t._updateColumns();t._getRowContexts();}}));this._oGroupHeaderMenu.addItem(new e({text:this._oResBundle.getText("TBL_UNGROUP_ALL"),select:function(){var l=t.getColumns();for(var i=0;i<l.length;i++){l[i]._bSkipUpdateAI=true;var B=t.getBinding("rows");B.setNumberOfExpandedLevels(0);l[i].setGrouped(false);l[i]._bSkipUpdateAI=false;}t._bSupressRefresh=true;t._updateColumns();t._getRowContexts();t._bSupressRefresh=false;t.fireGroup({column:undefined,groupedColumns:[],type:G.ungroupAll});}}));this._oGroupHeaderMoveUpItem=new e({text:this._oResBundle.getText("TBL_MOVE_UP"),select:function(){var o=j();if(o){var C=o.column;var i=q.inArray(C.getId(),t._aGroupedColumns);if(i>0){t._aGroupedColumns[i]=t._aGroupedColumns.splice(i-1,1,t._aGroupedColumns[i])[0];t.updateAnalyticalInfo();t.fireGroup({column:C,groupedColumns:C.getParent()._aGroupedColumns,type:G.moveUp});}}},icon:"sap-icon://arrow-top"});this._oGroupHeaderMenu.addItem(this._oGroupHeaderMoveUpItem);this._oGroupHeaderMoveDownItem=new e({text:this._oResBundle.getText("TBL_MOVE_DOWN"),select:function(){var o=j();if(o){var C=o.column;var i=q.inArray(C.getId(),t._aGroupedColumns);if(i<t._aGroupedColumns.length){t._aGroupedColumns[i]=t._aGroupedColumns.splice(i+1,1,t._aGroupedColumns[i])[0];t.updateAnalyticalInfo();t.fireGroup({column:C,groupedColumns:C.getParent()._aGroupedColumns,type:G.moveDown});}}},icon:"sap-icon://arrow-bottom"});this._oGroupHeaderMenu.addItem(this._oGroupHeaderMoveDownItem);this._oGroupHeaderMenu.addItem(new e({text:this._oResBundle.getText("TBL_SORT_ASC"),select:function(){var o=j();if(o){var C=o.column;C.sort(false);}},icon:"sap-icon://up"}));this._oGroupHeaderMenu.addItem(new e({text:this._oResBundle.getText("TBL_SORT_DESC"),select:function(){var o=j();if(o){var C=o.column;C.sort(true);}},icon:"sap-icon://down"}));this._oGroupHeaderMenu.addItem(new e({text:this._oResBundle.getText("TBL_COLLAPSE_LEVEL"),select:function(){t.getBinding("rows").collapseToLevel(t._iGroupedLevel-1);t.setFirstVisibleRow(0);t.clearSelection();}}));this._oGroupHeaderMenu.addItem(new e({text:this._oResBundle.getText("TBL_COLLAPSE_ALL"),select:function(){t.getBinding("rows").collapseToLevel(0);t.setFirstVisibleRow(0);t.clearSelection();}}));}var o=j();if(o){var C=o.column;if(C.getShowIfGrouped()){this._oGroupHeaderMenuVisibilityItem.setText(this._oResBundle.getText("TBL_HIDE_COLUMN"));}else{this._oGroupHeaderMenuVisibilityItem.setText(this._oResBundle.getText("TBL_SHOW_COLUMN"));}this._oGroupHeaderMoveUpItem.setEnabled(o.index>0);this._oGroupHeaderMoveDownItem.setEnabled(o.index<this._aGroupedColumns.length-1);}else{this._oGroupHeaderMoveUpItem.setEnabled(true);this._oGroupHeaderMoveDownItem.setEnabled(true);}return this._oGroupHeaderMenu;};
m.prototype.expand=function(r){var B=this.getBinding("rows");if(B){B.expand(r);}};
m.prototype.collapse=function(r){var B=this.getBinding("rows");if(B){B.collapse(r);}};
m.prototype.collapseAll=function(){var B=this.getBinding("rows");if(B){B.collapseToLevel(0);this.setFirstVisibleRow(0);}return this;};
m.prototype.isExpanded=function(r){var B=this.getBinding("rows");if(B){return B.isExpanded(r);}return false;};
m.prototype.getContextByIndex=function(i){var B=this.getBinding("rows");return i>=0&&B?B.getContextByIndex(i):null;};
m.prototype.getContextInfoByIndex=function(i){var B=this.getBinding("rows");return i>=0&&B?B.getNodeByIndex(i):null;};
m.prototype._onColumnMoved=function(E){T.prototype._onColumnMoved.apply(this,arguments);this.updateAnalyticalInfo(true,true);};
m.prototype.suspendUpdateAnalyticalInfo=function(){this._bSuspendUpdateAnalyticalInfo=true;};
m.prototype.resumeUpdateAnalyticalInfo=function(s,F){this._bSuspendUpdateAnalyticalInfo=false;this._updateColumns(s,(F===false?false:true));};
m.prototype.addColumn=function(C,s){var o=this._getColumn(C);if(o.getGrouped()){this._addGroupedColumn(o.getId());}T.prototype.addColumn.call(this,o,s);this._updateColumns(s);return this;};
m.prototype.insertColumn=function(C,i,s){var o=this._getColumn(C);if(o.getGrouped()){this._addGroupedColumn(o.getId());}T.prototype.insertColumn.call(this,o,i,s);this._updateColumns(s);return this;};
m.prototype.removeColumn=function(C,s){var r=T.prototype.removeColumn.apply(this,arguments);if(!this._iNewColPos){this._aGroupedColumns=q.grep(this._aGroupedColumns,function(v){if(C.getId){return v!=C.getId();}else{return v==C;}});}this.updateAnalyticalInfo(s);return r;};
m.prototype.removeAllColumns=function(s){this._aGroupedColumns=[];var r=T.prototype.removeAllColumns.apply(this,arguments);this._updateColumns(s);return r;};
m.prototype._getColumn=function(C){if(typeof C==="string"){var o=new A({leadingProperty:C,template:C,managed:true});return o;}else if(C instanceof A){return C;}else{throw new Error("Wrong column type. You need to define a string (property) or pass an AnalyticalColumnObject");}};
m.prototype._updateColumns=function(s,F){if(!this._bSuspendUpdateAnalyticalInfo){this._updateTableColumnDetails();this.updateAnalyticalInfo(s,F);}};
m.prototype.updateAnalyticalInfo=function(s,F){if(this._bSuspendUpdateAnalyticalInfo){return;}var B=this.getBinding("rows");if(B){var C=this._getColumnInformation();B.updateAnalyticalInfo(C,F);this._updateTotalRow(s);if(F&&this._bBusyIndicatorAllowed&&this.getEnableBusyIndicator()==true){this.setBusy(true);}}};
m.prototype.refreshRows=function(){sap.ui.table.Table.prototype.refreshRows.apply(this,arguments);this._updateTotalRow();};
m.prototype._updateTotalRow=function(s){var B=this.getBinding("rows");var F=this.getFixedBottomRowCount();if(B&&(B.providesGrandTotal()&&B.hasTotaledMeasures())){if(F!==1){this.setProperty("fixedBottomRowCount",1,s);}}else{if(F!==0){this.setProperty("fixedBottomRowCount",0,s);}}};
m.prototype._updateTableColumnDetails=function(){if(this._bSuspendUpdateAnalyticalInfo){return;}var B=this.getBinding("rows"),r=B&&B.getAnalyticalQueryResult();if(r){var C=this.getColumns(),l=[],u=[],D=[],n={},p,t;for(var i=0;i<C.length;i++){p=C[i];p._isLastGroupableLeft=false;p._bLastGroupAndGrouped=false;p._bDependendGrouped=false;if(!p.getVisible()){continue;}var L=p.getLeadingProperty();t=r.findDimensionByPropertyName(L);if(t){var v=t.getName();if(!n[v]){n[v]={dimension:t,columns:[p]};}else{n[v].columns.push(p);}if(p.getGrouped()&&q.inArray(v,l)==-1){l.push(v);}if(q.inArray(v,D)==-1){D.push(v);}}}u=q.grep(D,function(s){return(q.inArray(s,l)==-1);});if(l.length>0){q.each(l,function(i,s){q.each(n[s].columns,function(j,o){if(!o.getGrouped()){o._bDependendGrouped=true;}});});if(l.length==D.length){t=r.findDimensionByPropertyName(sap.ui.getCore().byId(this._aGroupedColumns[this._aGroupedColumns.length-1]).getLeadingProperty());var w=n[t.getName()].columns;q.each(w,function(i,o){o._bLastGroupAndGrouped=true;});}}if(u.length==1){q.each(n[u[0]].columns,function(j,o){o._isLastGroupableLeft=true;});}}};
m.prototype._getFirstMeasureColumnIndex=function(){var B=this.getBinding("rows"),r=B&&B.getAnalyticalQueryResult(),C=this._getVisibleColumns();if(!r){return-1;}for(var i=0;i<C.length;i++){var o=C[i],l=o.getLeadingProperty();if(r.findMeasureByName(l)||r.findMeasureByPropertyName(l)){return i;}}};
m.prototype.getTotalSize=function(){var B=this.getBinding("rows");if(B){return B.getTotalSize();}return 0;};
m.prototype._onPersoApplied=function(){T.prototype._onPersoApplied.apply(this,arguments);this._aGroupedColumns=[];var C=this.getColumns();for(var i=0,l=C.length;i<l;i++){if(C[i].getGrouped()){this._addGroupedColumn(C[i].getId());}}this._updateColumns();};
m.prototype._addGroupedColumn=function(C){if(q.inArray(C,this._aGroupedColumns)<0){this._aGroupedColumns.push(C);}};
m.prototype.getGroupedColumns=function(){return this._aGroupedColumns;};
m.prototype.setCollapseRecursive=function(C){var B=this.getBinding("rows");if(B){if(B.setCollapseRecursive){B.setCollapseRecursive(C);}}this.setProperty("collapseRecursive",!!C,true);return this;};
m.prototype._getSelectableRowCount=function(){var B=this.getBinding("rows");if(B){var r=B.getGrandTotalContextInfo();return r?r.numberOfLeafs:0;}};
m.prototype.isIndexSelected=function(r){return a.prototype.isIndexSelected.call(this,r);};
m.prototype.setSelectedIndex=function(r){return a.prototype.setSelectedIndex.call(this,r);};
m.prototype.getSelectedIndices=function(){return a.prototype.getSelectedIndices.call(this);};
m.prototype.setSelectionInterval=function(F,t){return a.prototype.setSelectionInterval.call(this,F,t);};
m.prototype.addSelectionInterval=function(F,t){return a.prototype.addSelectionInterval.call(this,F,t);};
m.prototype.removeSelectionInterval=function(F,t){return a.prototype.removeSelectionInterval.call(this,F,t);};
m.prototype.selectAll=function(){return a.prototype.selectAll.call(this);};
m.prototype.getSelectedIndex=function(){return a.prototype.getSelectedIndex.call(this);};
m.prototype.clearSelection=function(){return a.prototype.clearSelection.call(this);};
m.prototype._isRowSelectable=function(r){var B=this.getBinding("rows");if(B){return B.isIndexSelectable(r);}else{return false;}};
m.prototype._getSelectedIndicesCount=a.prototype._getSelectedIndicesCount;
m.prototype.setEnableGrouping=function(E){q.sap.log.warning("The property enableGrouping is not supported by control sap.ui.table.AnalyticalTable");return this;};
return m;});
sap.ui.predefine('sap/ui/table/AnalyticalTableRenderer',['sap/ui/table/AnalyticalTable'],function(T){"use strict";return T.getMetadata().getRenderer();},true);
sap.ui.predefine('sap/ui/table/Column',['jquery.sap.global','sap/ui/core/Element','sap/ui/core/library','sap/ui/core/Popup','sap/ui/core/RenderManager','sap/ui/model/Filter','sap/ui/model/FilterOperator','sap/ui/model/FilterType','sap/ui/model/Sorter','sap/ui/model/Type','sap/ui/model/type/String','./library'],function(q,E,c,P,R,F,a,b,S,T,d,f){"use strict";var H=c.HorizontalAlign,g=f.SortOrder,V=c.ValueState;
var C=E.extend("sap.ui.table.Column",{metadata:{library:"sap.ui.table",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},flexible:{type:"boolean",group:"Behavior",defaultValue:true},resizable:{type:"boolean",group:"Behavior",defaultValue:true},hAlign:{type:"sap.ui.core.HorizontalAlign",group:"Appearance",defaultValue:H.Begin},sorted:{type:"boolean",group:"Appearance",defaultValue:false},sortOrder:{type:"sap.ui.table.SortOrder",group:"Appearance",defaultValue:g.Ascending},sortProperty:{type:"string",group:"Behavior",defaultValue:null},filtered:{type:"boolean",group:"Appearance",defaultValue:false},filterProperty:{type:"string",group:"Behavior",defaultValue:null},filterValue:{type:"string",group:"Behavior",defaultValue:null},filterOperator:{type:"string",group:"Behavior",defaultValue:null},defaultFilterOperator:{type:"string",group:"Behavior",defaultValue:null},filterType:{type:"any",group:"Misc",defaultValue:null},grouped:{type:"boolean",group:"Appearance",defaultValue:false},visible:{type:"boolean",group:"Appearance",defaultValue:true},name:{type:"string",group:"Appearance",defaultValue:null},showFilterMenuEntry:{type:"boolean",group:"Appearance",defaultValue:true},showSortMenuEntry:{type:"boolean",group:"Appearance",defaultValue:true},headerSpan:{type:"any",group:"Behavior",defaultValue:1},autoResizable:{type:"boolean",group:"Behavior",defaultValue:false}},defaultAggregation:"label",aggregations:{label:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false},multiLabels:{type:"sap.ui.core.Control",multiple:true,singularName:"multiLabel"},template:{type:"sap.ui.core.Control",multiple:false},menu:{type:"sap.ui.unified.Menu",multiple:false}},events:{columnMenuOpen:{allowPreventDefault:true,parameters:{menu:{type:"sap.ui.unified.Menu"}}}}}});
C._DEFAULT_FILTER_TYPE=new d();
C.prototype.init=function(){this.oResBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.table");this._oSorter=null;this.mSkipPropagation={template:true};};
C.prototype.setParent=function(p,A,s){E.prototype.setParent.apply(this,arguments);var m=this.getAggregation("menu");if(m&&typeof m._updateReferences==="function"){m._updateReferences(this);}};
C.prototype.invalidate=function(o){var e=sap.ui.require("sap/ui/table/ColumnMenu");if(o!==this.getTemplate()&&!(e&&o instanceof e)){E.prototype.invalidate.apply(this,arguments);}};
C.prototype.setLabel=function(l){var L=l;if(typeof(l)==="string"){L=f.TableHelper.createLabel({text:l});}this.setAggregation("label",L);return this;};
C.prototype.setTemplate=function(t){var o=t;if(typeof(t)==="string"){o=f.TableHelper.createTextView().bindProperty("text",t);}this.setAggregation("template",o);this.invalidate();var e=this.getParent();if(e&&e._resetRowTemplate){e._resetRowTemplate();}return this;};
C.prototype.getMenu=function(){var m=this.getAggregation("menu");if(!m){m=this._createMenu();this.setMenu(m);}return m;};
C.prototype.invalidateMenu=function(){var m=this.getAggregation("menu");if(m&&m._invalidate){m._invalidate();}};
C.prototype._menuHasItems=function(){var m=this.getAggregation("menu");var t=this.getParent();var M=function(){return(this.isSortableByMenu()||this.isFilterableByMenu()||this.isGroupableByMenu()||(t&&t.getEnableColumnFreeze())||(t&&t.getShowColumnVisibilityMenu()));}.bind(this);return!!((m&&m.getItems().length>0)||M());};
C.prototype.isFilterableByMenu=function(){return!!(this.getFilterProperty()&&this.getShowFilterMenuEntry());};
C.prototype.isSortableByMenu=function(){return!!(this.getSortProperty()&&this.getShowSortMenuEntry());};
C.prototype.isGroupableByMenu=function(){var t=this.getParent();return!!(t&&t.getEnableGrouping&&t.getEnableGrouping()&&this.getSortProperty());};
C.prototype.setMenu=function(m){this.setAggregation("menu",m,true);return this;};
C.prototype._createMenu=function(){var e=sap.ui.requireSync("sap/ui/table/ColumnMenu");if(!this._defaultMenu){this._defaultMenu=new e(this.getId()+"-menu",{ariaLabelledBy:this});}return this._defaultMenu;};
C.prototype._setAppDefault=function(p,v){if(!this._appDefaults){this._appDefaults={};}if(p=="sorted"){this._appDefaults.sorted=v;}else if(p=="sortOrder"){this._appDefaults.sortOrder=v;}else if(p=="filtered"){this._appDefaults.filtered=v;}else if(p=="filterValue"){this._appDefaults.filterValue=v;}else if(p=="filterOperator"){this._appDefaults.filterOperator=v;}};
C.prototype._restoreAppDefaults=function(){if(this._appDefaults){this.setProperty("sorted",this._appDefaults.sorted,true);this.setProperty("sortOrder",this._appDefaults.sortOrder,true);this.setProperty("filtered",this._appDefaults.filtered,true);this.setProperty("filterValue",this._appDefaults.filterValue,true);this.setProperty("filterOperator",this._appDefaults.filterOperator,true);this._updateIcons();}};
C.prototype.setSorted=function(e){this.setProperty("sorted",e,true);this._setAppDefault("sorted",e);this._updateIcons();return this;};
C.prototype.setSortOrder=function(t){this.setProperty("sortOrder",t,true);this._setAppDefault("sortOrder",t);this._updateIcons();return this;};
C.prototype.setFiltered=function(e){this.setProperty("filtered",e,true);this._setAppDefault("filtered",e);this._updateIcons();return this;};
C.prototype.setFilterValue=function(v){this.setProperty("filterValue",v,true);this._setAppDefault("filterValue",v);var m=this.getMenu();var e=sap.ui.require("sap/ui/table/ColumnMenu");if(m&&e&&m instanceof e){m._setFilterValue(v);}return this;};
C.prototype.setFilterOperator=function(v){this.setProperty("filterOperator",v,true);this._setAppDefault("filterOperator",v);return this;};
C.prototype.onmousedown=function(e){var m=this.getAggregation("menu");this._bSkipOpen=m&&m.bOpen;};
C.prototype.onmouseout=function(e){if(this._bSkipOpen&&q.sap.checkMouseEnterOrLeave(e,this.getDomRef())){this._bSkipOpen=false;}};
C.prototype._openMenu=function(D,w){if(this._bSkipOpen){this._bSkipOpen=false;return;}var m=this.getMenu();var e=this.fireColumnMenuOpen({menu:m});if(e){var h=P.Dock;var o=D;if(!D){D=this.getDomRef();o=this.getFocusDomRef();}m.open(!!w,o,h.BeginTop,h.BeginBottom,D,"none none");}};
C.prototype.toggleSort=function(){this.sort(this.getSorted()&&this.getSortOrder()===g.Ascending);};
C.prototype.sort=function(D,A){var t=this.getParent();if(t){t.pushSortedColumn(this,A);var n=D?g.Descending:g.Ascending;var e=t.fireSort({column:this,sortOrder:n,columnAdded:A});if(e){var s=t.getSortedColumns();var h=t.getColumns();for(var i=0,l=h.length;i<l;i++){if(q.inArray(h[i],s)<0){h[i].setProperty("sorted",false,true);h[i].setProperty("sortOrder",g.Ascending,true);h[i]._updateIcons();delete h[i]._oSorter;}}this.setProperty("sorted",true,true);this.setProperty("sortOrder",n,true);this._oSorter=new S(this.getSortProperty(),this.getSortOrder()===g.Descending);var j=[];for(var i=0,l=s.length;i<l;i++){s[i]._updateIcons();j.push(s[i]._oSorter);}if(t.isBound("rows")){t.getBinding("rows").sort(j);if(this._afterSort){this._afterSort();}}}}return this;};
C.prototype._updateIcons=function(){var t=this.getParent(),s=this.getSorted(),e=this.getFiltered();if(!t||!t.getDomRef()){return;}this.$().find(".sapUiTableColCell").toggleClass("sapUiTableColSF",s||e).toggleClass("sapUiTableColFiltered",e).toggleClass("sapUiTableColSorted",s).toggleClass("sapUiTableColSortedD",s&&this.getSortOrder()===g.Descending);t._getAccExtension().updateAriaStateOfColumn(this);};
C.prototype._renderSortIcon=function(){this._updateIcons();};
C.prototype._getFilter=function(){var o,p=this.getFilterProperty(),v=this.getFilterValue(),O=this.getFilterOperator(),s,e,t=this.getFilterType()||C._DEFAULT_FILTER_TYPE,i=t instanceof d,B;if(v){if(!O){B=v.match(/(.*)\s*\.\.\s*(.*)/);if(v.indexOf("=")==0){O=a.EQ;s=v.substr(1);}else if(v.indexOf("!=")==0){O=a.NE;s=v.substr(2);}else if(v.indexOf("<=")==0){O=a.LE;s=v.substr(2);}else if(v.indexOf("<")==0){O=a.LT;s=v.substr(1);}else if(v.indexOf(">=")==0){O=a.GE;s=v.substr(2);}else if(v.indexOf(">")==0){O=a.GT;s=v.substr(1);}else if(B){if(B[1]&&B[2]){O=a.BT;s=B[1];e=B[2];}else if(B[1]&&!B[2]){O=a.GE;s=B[1];}else{O=a.LE;s=B[2];}}else if(i&&v.indexOf("*")==0&&v.lastIndexOf("*")==v.length-1){O=a.Contains;s=v.substr(1,v.length-2);}else if(i&&v.indexOf("*")==0){O=a.EndsWith;s=v.substr(1);}else if(i&&v.lastIndexOf("*")==v.length-1){O=a.StartsWith;s=v.substr(0,v.length-1);}else{if(this.getDefaultFilterOperator()){O=this.getDefaultFilterOperator();}else{if(i){O=a.Contains;}else{O=a.EQ;}}s=v.substr(0);}if(!e){o=new F(p,O,this._parseFilterValue(s));}else{o=new F(p,O,this._parseFilterValue(s),this._parseFilterValue(e));}}else{o=new F(p,O,this._parseFilterValue(v));}}return o;};
C.prototype.filter=function(v){var t=this.getParent();if(t&&t.isBound("rows")){var h=t.fireFilter({column:this,value:v});if(h){this.setProperty("filtered",!!v,true);this.setProperty("filterValue",v,true);var m=this.getMenu();var j=sap.ui.require("sap/ui/table/ColumnMenu");if(m&&j&&m instanceof j){m._setFilterValue(v);}var k=[];var n=t.getColumns();for(var i=0,l=n.length;i<l;i++){var o=n[i],p;m=o.getMenu();try{p=o._getFilter();if(m&&j&&m instanceof j){m._setFilterState(V.None);}}catch(e){if(m&&j&&m instanceof j){m._setFilterState(V.Error);}continue;}if(p){k.push(p);}}t.getBinding("rows").filter(k,b.Control);this._updateIcons();}}return this;};
C.prototype._parseFilterValue=function(v){var o=this.getFilterType();if(o){if(q.isFunction(o)){v=o(v);}else{v=o.parseValue(v,"string");}}return v;};
C.prototype._restoreIcons=function(){this._updateIcons();};
C.prototype.shouldRender=function(){return this.getVisible()&&!this.getGrouped();};
C.PROPERTIES_FOR_ROW_INVALIDATION={visible:true,flexible:true,headerSpan:true};
C.prototype.setProperty=function(n,v){var t=this.getParent();if(t&&t._resetRowTemplate&&this.getProperty(n)!=v&&C.PROPERTIES_FOR_ROW_INVALIDATION[n]){t._resetRowTemplate();}return E.prototype.setProperty.apply(this,arguments);};
C.prototype.setFilterType=function(t){var o=t;if(typeof(t)==="string"){try{var m=q.sap.parseJS(t);if(typeof(m.type)==="string"){var e=q.sap.getObject(m.type);o=e&&new e(m.formatOptions,m.constraints);}}catch(h){var e=q.sap.getObject(t);o=e&&new e();}if(!(o instanceof T)){q.sap.log.error("The filter type is not an instance of sap.ui.model.Type! Ignoring the filter type!");o=undefined;}}this.setProperty("filterType",o,true);return this;};
C.prototype.getIndex=function(){var t=this.getParent();if(t){return t.indexOfColumn(this);}else{return-1;}};
return C;});
sap.ui.predefine('sap/ui/table/ColumnMenu',['jquery.sap.global','sap/ui/core/RenderManager','./library','sap/ui/unified/Menu','sap/ui/unified/MenuItem','sap/ui/Device','./TableUtils'],function(q,R,a,M,b,D,T){"use strict";
var C=M.extend("sap.ui.table.ColumnMenu",{metadata:{library:"sap.ui.table"}});
C.prototype.init=function(){if(M.prototype.init){M.prototype.init.apply(this,arguments);}this.addStyleClass("sapUiTableColumnMenu");this.oResBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.table");this._bInvalidated=true;this._iPopupClosedTimeoutId=null;this._oColumn=null;this._oTable=null;this._attachPopupClosed();};
C.prototype.exit=function(){if(M.prototype.exit){M.prototype.exit.apply(this,arguments);}window.clearTimeout(this._iPopupClosedTimeoutId);this._detachEvents();this._oColumn=this._oTable=null;};
C.prototype.onThemeChanged=function(){if(this.getDomRef()){this._invalidate();}};
C.prototype.setParent=function(p){this._detachEvents();this._invalidate();this._updateReferences(p);this._attachEvents();return M.prototype.setParent.apply(this,arguments);};
C.prototype._updateReferences=function(p){this._oColumn=p;if(p){this._oTable=this._oColumn.getParent();if(this._oTable){}}};
C.prototype._attachEvents=function(){if(this._oTable){this._oTable.attachColumnVisibility(this._invalidate,this);this._oTable.attachColumnMove(this._invalidate,this);}};
C.prototype._detachEvents=function(){if(this._oTable){this._oTable.detachColumnVisibility(this._invalidate,this);this._oTable.detachColumnMove(this._invalidate,this);}};
C.prototype._invalidate=function(){this._bInvalidated=true;};
C.prototype._attachPopupClosed=function(){var t=this;if(!D.support.touch){this.getPopup().attachClosed(function(){t._iPopupClosedTimeoutId=window.setTimeout(function(){if(t._oColumn){if(t._lastFocusedDomRef){t._lastFocusedDomRef.focus();}else{t._oColumn.focus();}}},0);});}};
C.prototype.open=function(){if(this._bInvalidated){this._bInvalidated=false;this.destroyItems();this._addMenuItems();}if(this.getItems().length>0){this._lastFocusedDomRef=arguments[4];M.prototype.open.apply(this,arguments);}};
C.prototype._addMenuItems=function(){if(this._oColumn){this._addSortMenuItem(false);this._addSortMenuItem(true);this._addFilterMenuItem();this._addGroupMenuItem();this._addFreezeMenuItem();this._addColumnVisibilityMenuItem();}};
C.prototype._addSortMenuItem=function(d){var o=this._oColumn;if(o.isSortableByMenu()){var s=d?"desc":"asc";var i=d?"sort-descending":"sort-ascending";if(o.getSortProperty()&&o.getShowSortMenuEntry()){this.addItem(this._createMenuItem(s,"TBL_SORT_"+s.toUpperCase(),i,function(e){o.sort(d,e.getParameter("ctrlKey")===true);}));}}};
C.prototype._addFilterMenuItem=function(){var o=this._oColumn;var t=o.getParent();var e=false;if(t){e=t.getEnableCustomFilter();}if(o.isFilterableByMenu()){if(e){this.addItem(this._createMenuItem("filter","TBL_FILTER_ITEM","filter",function(){t.fireCustomFilter({column:o});}));}else{this.addItem(this._createMenuTextFieldItem("filter","TBL_FILTER","filter",o.getFilterValue(),function(){o.filter(this.getValue());}));}}};
C.prototype._addGroupMenuItem=function(){var o=this._oColumn;var t=this._oTable;if(o.isGroupableByMenu()){if(t&&t.getEnableGrouping()&&o.getSortProperty()){this.addItem(this._createMenuItem("group","TBL_GROUP",null,q.proxy(function(){t.setGroupBy(o);},this)));}}};
C.prototype._addFreezeMenuItem=function(){var o=this._oColumn;var t=this._oTable;if(t&&t.getEnableColumnFreeze()){var i=q.inArray(o,t.getColumns());var I=i+1==t.getFixedColumnCount();this.addItem(this._createMenuItem("freeze",I?"TBL_UNFREEZE":"TBL_FREEZE",null,function(){var e=t.fireColumnFreeze({column:o});if(e){if(I){t.setFixedColumnCount(0);}else{t.setFixedColumnCount(i+1);}}}));}};
C.prototype._addColumnVisibilityMenuItem=function(){var t=this._oTable;if(t&&t.getShowColumnVisibilityMenu()){var o=this._createMenuItem("column-visibilty","TBL_COLUMNS");this.addItem(o);var d=new M(o.getId()+"-menu");d.addStyleClass("sapUiTableColumnVisibilityMenu");o.setSubmenu(d);var e=t.getColumns();if(t.getColumnVisibilityMenuSorter&&typeof t.getColumnVisibilityMenuSorter==="function"){var s=t.getColumnVisibilityMenuSorter();if(typeof s==="function"){e=e.sort(s);}}var B=t.getBinding();var A=c(B,"sap/ui/model/analytics/AnalyticalBinding");for(var i=0,l=e.length;i<l;i++){var f=e[i];if(A&&c(f,"sap/ui/table/AnalyticalColumn")){var Q=B.getAnalyticalQueryResult();var E=Q.getEntityType();var m=B.getModel().getProperty("/#"+E.getTypeDescription().name+"/"+f.getLeadingProperty()+"/sap:visible");if(m&&(m.value==="false"||m.value===false)){continue;}}var g=this._createColumnVisibilityMenuItem(d.getId()+"-item-"+i,f);d.addItem(g);}}};
C.prototype._createColumnVisibilityMenuItem=function(i,o){var t=o.getName()||(o.getLabel()&&o.getLabel().getText?o.getLabel().getText():null);return new b(i,{text:t,icon:o.getVisible()?"sap-icon://accept":null,select:q.proxy(function(e){var m=e.getSource();var v=!o.getVisible();if(v||T.getVisibleColumnCount(this._oTable)>1){var d=o.getParent();var E=true;if(d&&c(d,"sap/ui/table/Table")){E=d.fireColumnVisibility({column:o,newVisible:v});}if(E){o.setVisible(v);}m.setIcon(v?"sap-icon://accept":null);}},this)});};
C.prototype._createMenuItem=function(i,t,I,h){return new b(this.getId()+"-"+i,{text:this.oResBundle.getText(t),icon:I?"sap-icon://"+I:null,select:h||function(){}});};
C.prototype._createMenuTextFieldItem=function(i,t,I,v,h){var d=sap.ui.requireSync("sap/ui/unified/MenuTextFieldItem");h=h||function(){};return new d(this.getId()+"-"+i,{label:this.oResBundle.getText(t),icon:I?"sap-icon://"+I:null,value:v,select:h||function(){}});};
C.prototype._setFilterValue=function(v){var o=this.getParent();var t=(o?o.getParent():undefined);var f=sap.ui.getCore().byId(this.getId()+"-filter");if(f&&(t&&!t.getEnableCustomFilter())){f.setValue(v);}return this;};
C.prototype._setFilterState=function(f){var o=this.getParent();var t=(o?o.getParent():undefined);var F=sap.ui.getCore().byId(this.getId()+"-filter");if(F&&(t&&!t.getEnableCustomFilter())){F.setValueState(f);}return this;};
function c(o,m){var F=sap.ui.require(m);return typeof F==='function'&&(o instanceof F);}
return C;});
sap.ui.predefine('sap/ui/table/ColumnMenuRenderer',['jquery.sap.global','sap/ui/core/Renderer','sap/ui/unified/MenuRenderer'],function(q,R,M){"use strict";var C=R.extend(M);return C;},true);
sap.ui.predefine('sap/ui/table/Row',['jquery.sap.global','sap/ui/core/Element','sap/ui/model/Context','./library'],function(q,E,C,l){"use strict";
var R=E.extend("sap.ui.table.Row",{metadata:{library:"sap.ui.table",defaultAggregation:"cells",aggregations:{cells:{type:"sap.ui.core.Control",multiple:true,singularName:"cell"}}}});
R.prototype.init=function(){this.initDomRefs();};
R.prototype.exit=function(){this.initDomRefs();};
R.prototype.initDomRefs=function(){this._mDomRefs={};};
R.prototype.getIndex=function(){var t=this.getParent();if(t){var r=t.indexOfRow(this);var n=t.getFixedRowCount();if(n>0&&r<n){return r;}var N=t.getFixedBottomRowCount();var v=t.getVisibleRowCount();if(N>0&&r>=v-N){var b=t.getBinding("rows");if(b&&b.getLength()>=v){return b.getLength()-(v-r);}else{return r;}}var f=t.getFirstVisibleRow();return f+r;}return-1;};
R.prototype.getDomRefs=function(j){var a;var k;if(j===true){a=q.sap.byId;k="jQuery";}else{a=q.sap.domById;k="dom";}if(!this._mDomRefs[k]){this._mDomRefs[k]={};var t=this.getParent();if(t){var r=t.indexOfRow(this);this._mDomRefs[k].rowSelector=a(t.getId()+"-rowsel"+r);}this._mDomRefs[k].rowScrollPart=a(this.getId());this._mDomRefs[k].rowFixedPart=a(this.getId()+"-fixed");this._mDomRefs[k].rowSelectorText=a(this.getId()+"-rowselecttext");if(j===true){this._mDomRefs[k].row=this._mDomRefs[k].rowScrollPart;if(this._mDomRefs[k].rowFixedPart.length>0){this._mDomRefs[k].row=this._mDomRefs[k].row.add(this._mDomRefs[k].rowFixedPart);}else{this._mDomRefs[k].rowFixedPart=undefined;}if(this._mDomRefs[k].rowSelector&&this._mDomRefs[k].rowSelector.length>0){this._mDomRefs[k].row=this._mDomRefs[k].row.add(this._mDomRefs[k].rowSelector);}else{this._mDomRefs[k].rowSelector=undefined;}}}return this._mDomRefs[k];};
R.prototype._updateSelection=function(t,T,s){var i=t.isIndexSelected(this.getIndex());var d=this.getDomRefs(true);var S="rowSelect";if(i){S="rowDeselect";}if(d.rowSelector){d.rowSelector.attr("title",T.mouse[S]);}if(d.rowSelectorText){var a="";if(!(this._oNodeState&&this._oNodeState.sum)&&!this._bHasChildren){a=T.keyboard[S];}d.rowSelectorText.text(a);}var r=d.rowScrollPart;if(d.rowFixedPart){r=r.add(d.rowFixedPart);}if(s){r.attr("title",T.mouse[S]);}else{r.removeAttr("title");}if(d.row){d.row.toggleClass("sapUiTableRowSel",i);t._getAccExtension().updateAriaStateOfRow(this,d,i);}};
R.prototype.setRowBindingContext=function(c,m,b){var n;if(c&&!(c instanceof C)){n=c;c=c.context;}var $=this.getDomRefs(true).row;this._bHidden=!c;$.toggleClass("sapUiTableRowHidden",this._bHidden);this._collectRenderingInformation(c,n,b);this.setBindingContext(c,m);};
R.prototype.setBindingContext=function(c,m){var r=E.prototype.setBindingContext.call(this,c||null,m);this._updateTableCells(c);return r;};
R.prototype._updateTableCells=function(c){var a=this.getCells();var A=this.getIndex();for(var i=0;i<a.length;i++){var o=a[i];if(o._updateTableCell){o._updateTableCell(o,c,o.$().closest("td"),A);}}};
R.prototype._collectRenderingInformation=function(c,n,b){this._oNodeState=undefined;this._iLevel=0;this._bIsExpanded=false;this._bHasChildren=false;this._sTreeIconClass="";if(n){this._oNodeState=n.nodeState;this._iLevel=n.level;this._bIsExpanded=false;this._bHasChildren=false;this._sTreeIconClass="sapUiTableTreeIconLeaf";this._sGroupIconClass="";if(b){if(b.getLevel){this._bIsExpanded=b.isExpanded(this.getIndex());}else if(b.findNode){this._bIsExpanded=this&&this._oNodeState?this._oNodeState.expanded:false;}if(b.nodeHasChildren){if(this._oNodeState){this._bHasChildren=b.nodeHasChildren(n);}}else if(b.hasChildren){this._bHasChildren=b.hasChildren(c);}if(this._bHasChildren){this._sTreeIconClass=this._bIsExpanded?"sapUiTableTreeIconNodeOpen":"sapUiTableTreeIconNodeClosed";this._sGroupIconClass=this._bIsExpanded?"sapUiTableGroupIconOpen":"sapUiTableGroupIconClosed";}}}};
return R;});
sap.ui.predefine('sap/ui/table/Table.designtime',[],function(){"use strict";return{aggregations:{columns:{domRef:".sapUiTableColHdrScr"},hScroll:{ignore:false,domRef:function(){return this.$("hsb").get(0);}},vScroll:{ignore:false,domRef:function(){return this.$("vsb").get(0);}}}};},false);
sap.ui.predefine('sap/ui/table/Table',['jquery.sap.global','sap/ui/Device','sap/ui/core/Control','sap/ui/core/Element','sap/ui/core/IconPool','sap/ui/core/IntervalTrigger','sap/ui/core/library','sap/ui/core/Popup','sap/ui/core/ResizeHandler','sap/ui/core/ScrollBar','sap/ui/core/delegate/ItemNavigation','sap/ui/core/theming/Parameters','sap/ui/model/ChangeReason','sap/ui/model/Context','sap/ui/model/Filter','sap/ui/model/SelectionModel','sap/ui/model/Sorter','./Column','./Row','./library','./TableUtils','./TableExtension','./TableAccExtension','./TableKeyboardExtension','./TablePointerExtension','jquery.sap.dom','jquery.sap.trace'],function(q,D,C,E,I,a,c,P,R,S,b,d,e,f,F,g,h,k,m,n,T,o,p,r,s){"use strict";var G=n.GroupEventType,N=n.NavigationMode,t=n.SelectionMode,u=n.SelectionBehavior,v=n.SharedDomRef,w=n.SortOrder,V=n.VisibleRowCountMode;var M,x;
var y=C.extend("sap.ui.table.Table",{metadata:{library:"sap.ui.table",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'auto'},rowHeight:{type:"int",group:"Appearance",defaultValue:null},columnHeaderHeight:{type:"int",group:"Appearance",defaultValue:null},columnHeaderVisible:{type:"boolean",group:"Appearance",defaultValue:true},visibleRowCount:{type:"int",group:"Appearance",defaultValue:10},firstVisibleRow:{type:"int",group:"Appearance",defaultValue:0},selectionMode:{type:"sap.ui.table.SelectionMode",group:"Behavior",defaultValue:t.MultiToggle},selectionBehavior:{type:"sap.ui.table.SelectionBehavior",group:"Behavior",defaultValue:u.RowSelector},selectedIndex:{type:"int",group:"Appearance",defaultValue:-1},editable:{type:"boolean",group:"Behavior",defaultValue:true},navigationMode:{type:"sap.ui.table.NavigationMode",group:"Behavior",defaultValue:N.Scrollbar},threshold:{type:"int",group:"Appearance",defaultValue:100},enableColumnReordering:{type:"boolean",group:"Behavior",defaultValue:true},enableGrouping:{type:"boolean",group:"Behavior",defaultValue:false},showColumnVisibilityMenu:{type:"boolean",group:"Appearance",defaultValue:false},showNoData:{type:"boolean",group:"Appearance",defaultValue:true},visibleRowCountMode:{type:"sap.ui.table.VisibleRowCountMode",group:"Appearance",defaultValue:V.Fixed},minAutoRowCount:{type:"int",group:"Appearance",defaultValue:5},fixedColumnCount:{type:"int",group:"Appearance",defaultValue:0},fixedRowCount:{type:"int",group:"Appearance",defaultValue:0},fixedBottomRowCount:{type:"int",group:"Appearance",defaultValue:0},enableColumnFreeze:{type:"boolean",group:"Behavior",defaultValue:false},enableCellFilter:{type:"boolean",group:"Behavior",defaultValue:false},showOverlay:{type:"boolean",group:"Appearance",defaultValue:false},enableSelectAll:{type:"boolean",group:"Behavior",defaultValue:true},enableCustomFilter:{type:"boolean",group:"Behavior",defaultValue:false},enableBusyIndicator:{type:"boolean",group:"Behavior",defaultValue:false}},defaultAggregation:"columns",aggregations:{title:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false},footer:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false},toolbar:{type:"sap.ui.core.Toolbar",multiple:false},extension:{type:"sap.ui.core.Control",multiple:true,singularName:"extension"},columns:{type:"sap.ui.table.Column",multiple:true,singularName:"column",bindable:"bindable"},rows:{type:"sap.ui.table.Row",multiple:true,singularName:"row",bindable:"bindable"},noData:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false}},associations:{groupBy:{type:"sap.ui.table.Column",multiple:false},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{rowSelectionChange:{parameters:{rowIndex:{type:"int"},rowContext:{type:"object"},rowIndices:{type:"int[]"},selectAll:{type:"boolean"},userInteraction:{type:"boolean"}}},columnSelect:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"}}},columnResize:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},width:{type:"sap.ui.core.CSSSize"}}},columnMove:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},newPos:{type:"int"}}},sort:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},sortOrder:{type:"sap.ui.table.SortOrder"},columnAdded:{type:"boolean"}}},filter:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},value:{type:"string"}}},group:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"}}},columnVisibility:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},visible:{type:"boolean"}}},cellClick:{allowPreventDefault:true,parameters:{cellControl:{type:"sap.ui.core.Control"},cellDomRef:{type:"Object"},rowIndex:{type:"int"},columnIndex:{type:"int"},columnId:{type:"string"},rowBindingContext:{type:"sap.ui.model.Context"}}},cellContextmenu:{allowPreventDefault:true,parameters:{cellControl:{type:"sap.ui.core.Control"},cellDomRef:{type:"Object"},rowIndex:{type:"int"},columnIndex:{type:"int"},columnId:{type:"string"},rowBindingContext:{type:"sap.ui.model.Context"}}},columnFreeze:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"}}},customFilter:{column:{type:"sap.ui.table.Column"},value:{type:"string"}},firstVisibleRowChanged:{firstVisibleRow:{type:"int"}},busyStateChanged:{busy:{type:"boolean"}}},designTime:true}});
I.insertFontFaceStyle();
y.prototype.init=function(){this._iBaseFontSize=parseFloat(q("body").css("font-size"))||16;this._oResBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.table");this._bRtlMode=sap.ui.getCore().getConfiguration().getRTL();this._attachExtensions();this._bBindingLengthChanged=false;this._mTimeouts={};this._lastCalledUpdateRows=0;this._iBindingTimerDelay=50;var i=this;this._performUpdateRows=function(j){if(!i.bIsDestroyed){i._lastCalledUpdateRows=Date.now();i._updateBindingContexts(undefined,undefined,j);if(!i._bInvalid){i._updateTableContent();i._getAccExtension().updateAccForCurrentCell(false);i._updateSelection();var l=i._collectTableSizes();i._updateRowHeader(l.tableRowHeights);i._syncColumnHeaders(l);if(T.isVariableRowHeightEnabled(i)){i._adjustTablePosition();}if(i._bBindingLengthChanged||T.isVariableRowHeightEnabled(i)){i._updateVSb(l);}}i._mTimeouts.bindingTimer=undefined;i.fireEvent("_rowsUpdated");}i._bBindingLengthChanged=false;};this._initSelectionModel(g.MULTI_SELECTION);this._iColMinWidth=20;if('ontouchstart'in document){this._iColMinWidth=88;}this._aTableHeaders=[];this._aIdxCols2Cells=[];this._aVisibleColumns=[];this._iLastFixedColIndex=-1;this._bInheritEditableToControls=false;this._bAllowColumnHeaderTextSelection=false;this._bjQueryLess18=q.sap.Version(q.fn.jquery).compareTo("1.8")<0;this._iDataRequestedCounter=0;this._iBindingLength=0;this._iTableRowContentHeight=0;this._bFirstRendering=true;this._bInvalid=true;this._bIsScrollVertical=null;};
y.prototype._attachExtensions=function(){if(this._bExtensionsInitialized){return;}o.enrich(this,s);o.enrich(this,r);o.enrich(this,p);this._bExtensionsInitialized=true;};
y.prototype.exit=function(){this._bExitCalled=true;if(this._oPaginator){this._oPaginator.destroy();}this._resetRowTemplate();this._detachExtensions();this._cleanUpTimers();this._detachEvents();};
y.prototype._detachExtensions=function(){if(!this._bExtensionsInitialized){return;}this._getPointerExtension().destroy();this._getKeyboardExtension().destroy();this._getAccExtension().destroy();delete this._bExtensionsInitialized;};
y.prototype.onThemeChanged=function(){if(this.getDomRef()){this.invalidate();}};
y.prototype._collectRowHeights=function(){var j=this.getDomRef();if(!j){return[];}var l=j.querySelectorAll(".sapUiTableCtrlFixed > tbody > tr");var z=j.querySelectorAll(".sapUiTableCtrlScroll > tbody > tr");var A=[];for(var i=0;i<z.length;i++){var B=0;if(l[i]){var H=l[i].getBoundingClientRect();B=H.bottom-H.top;}var J=z[i].getBoundingClientRect();var K=J.bottom-J.top;A.push(Math.max(B,K));}return A;};
y.prototype._resetRowHeights=function(){var j=this.getRowHeight();var l="";if(j){l=j+"px";}var z=this.getDomRef();if(z){var A=z.querySelectorAll(".sapUiTableCtrlFixed > tbody > tr, .sapUiTableCtrlScroll > tbody > tr");for(var i=0;i<A.length;i++){A[i].style.height=l;}}};
y.prototype._determineAvailableSpace=function(){var i=this.getDomRef();if(i&&i.parentNode){var j=i.querySelector(".sapUiTableCCnt");if(j){var U=i.scrollHeight-j.clientHeight;return q(i.parentNode).height()-U;}}return 0;};
y.prototype._collectTableSizes=function(j){var l={tableCtrlScrollWidth:0,tableRowHdrScrWidth:0,tableCtrlRowScrollTop:0,tableCtrlRowScrollHeight:0,tableCtrlScrWidth:0,tableHSbScrollLeft:0,tableCtrlFixedWidth:0,tableCntHeight:0,tableCntWidth:0,columnRowHeight:0,columnRowOuterHeight:0,invisibleColWidth:0};var z=this.getDomRef();if(!z){return l;}var A=z.querySelector(".sapUiTableCnt");if(A){l.tableCntHeight=A.clientHeight;l.tableCntWidth=A.clientWidth;}var B=z.querySelector(".sapUiTableCtrlScroll");if(B){l.tableCtrlScrollWidth=B.clientWidth;}var H=z.querySelector(".sapUiTableRowHdrScr");if(H){l.tableRowHdrScrWidth=H.clientWidth;}var J=z.querySelector(".sapUiTableCtrl.sapUiTableCtrlRowScroll.sapUiTableCtrlScroll");if(J){l.tableCtrlRowScrollTop=J.offsetTop;l.tableCtrlRowScrollHeight=J.offsetHeight;}var K=z.querySelector(".sapUiTableCtrlScr");if(K){l.tableCtrlScrWidth=K.clientWidth;}var L=this.getDomRef(v.HorizontalScrollBar);if(L){l.tableHSbScrollLeft=L.scrollLeft;}var O=z.querySelector(".sapUiTableCtrlFixed");if(O){l.tableCtrlFixedWidth=O.clientWidth;}var Q=this.getProperty("fixedColumnCount");var U=[];var W=0;var X=z.querySelectorAll(".sapUiTableCtrlFirstCol > th:not(.sapUiTableColSel)");if(X){for(var i=0;i<X.length;i++){var Y=X[i].getBoundingClientRect();var Z=Y.right-Y.left;U.push(Z);if(!this.getColumns()[i].getVisible()){Q--;}if(i<Q){W+=Z;}}}if(Q>0){var $=0;var _=this.getDomRef("sapUiTableRowHdrScr");if(_){$+=_.clientWidth;}var a1=this.getDomRef("vsb");if(a1){$+=a1.offsetWidth;}var b1=(z.clientWidth-$<W);if(this._bIgnoreFixedColumnCount!=b1){this._bIgnoreFixedColumnCount=b1;this.invalidate();}}l.headerWidths=U;if(T.hasRowHeader(this)){var c1=z.querySelector(".sapUiTableCtrlFirstCol > th:first-child");if(c1){l.invisibleColWidth=c1.clientWidth;}}function d1(e1){l.columnRowHeight=Math.max(e1.clientHeight||0,l.columnRowHeight);l.columnRowOuterHeight=Math.max(e1.offsetHeight||0,l.columnRowOuterHeight);}Array.prototype.forEach.call(z.querySelectorAll(".sapUiTableCol"),d1);if(!j){l.tableRowHeights=this._collectRowHeights();}else{l.tableRowHeights=j;}return l;};
y.prototype._updateRowHeader=function(j){var l=this.getDomRef();if(!l){return;}var z=l.querySelectorAll(".sapUiTableRowHdr");var A=l.querySelectorAll(".sapUiTableCtrlFixed > tbody > tr");var B=l.querySelectorAll(".sapUiTableCtrlScroll > tbody > tr");var L=Math.max(z.length,B.length,0);for(var i=0;i<L;i++){var H=j[i];if(H){if(z[i]){z[i].style.height=H+"px";}if(A[i]){A[i].style.height=H+"px";}if(B[i]){B[i].style.height=H+"px";}}}};
y.prototype.onBeforeRendering=function(i){if(i&&i.isMarked("insertTableRows")){return;}if(this._mTimeouts.bindingTimer){this._updateBindingContexts();}this._cleanUpTimers();this._detachEvents();var j=this.getVisibleRowCountMode();if(T.isVariableRowHeightEnabled(this)){var l=this.getDomRef(v.VerticalScrollBar);if(l){this._iOldScrollTop=l.scrollTop;}}var z=this.getRows();if(j==V.Interactive||j==V.Fixed||(j==V.Auto&&this._iTableRowContentHeight&&z.length==0)){if(this.getBinding("rows")){this._adjustRows(this._calculateRowsToDisplay());}else{var A=this;this._mTimeouts.onBeforeRenderingAdjustRows=this._mTimeouts.onBeforeRenderingAdjustRows||window.setTimeout(function(){A._adjustRows(A._calculateRowsToDisplay());A._mTimeouts.onBeforeRenderingAdjustRows=undefined;},0);}}else if(!this._oRowTemplate&&z.length>0){this._adjustRows(z.length);}};
y.prototype.onAfterRendering=function(j){if(j&&j.isMarked("insertTableRows")){return;}this._iDefaultRowHeight=undefined;this._bInvalid=false;this._bOnAfterRendering=true;var $=this.$();this._attachEvents();this._initRowDomRefs();var z=this.getColumns();for(var i=0,l=z.length;i<l;i++){if(z[i].getVisible()){z[i]._restoreIcons();}}if(!this._bAllowColumnHeaderTextSelection){this._disableTextSelection($.find(".sapUiTableColHdrCnt"));}this._bOnAfterRendering=false;this._getKeyboardExtension().invalidateItemNavigation();if(this._bFirstRendering&&this.getVisibleRowCountMode()==V.Auto){this._bFirstRendering=false;Promise.resolve().then(this._updateTableSizes.bind(this,true));}else if(!this._mTimeouts.onAfterRenderingUpdateTableSizes){this._updateTableSizes();}if(T.isVariableRowHeightEnabled(this)){var A=this.getDomRef(v.VerticalScrollBar);if(A){A.scrollTop=Math.max(A.scrollTop,this._iOldScrollTop);}}this._updateTableContent();if(this.getBinding("rows")){this.fireEvent("_rowsUpdated");}};
y.prototype.invalidate=function(){if(!this._ignoreInvalidateOfChildControls){this._bInvalid=true;var i=C.prototype.invalidate.call(this);}return i;};
y.prototype._initRowDomRefs=function(){var j=this.getRows();for(var i=0;i<j.length;i++){j[i].initDomRefs();}};
y.prototype._updateTableSizes=function(i,j){this._mTimeouts.onAfterRenderingUpdateTableSizes=undefined;var l=this.getDomRef();if(this._bInvalid||!l){return;}this._resetRowHeights();var z=this._collectRowHeights();this._getDefaultRowHeight(z);var A=0;if(!j&&this.getVisibleRowCountMode()==V.Auto){A=this._determineAvailableSpace();if(this._handleRowCountModeAuto(A)&&!i){return;}}T.deregisterResizeHandler(this,"");this._toggleVSb();var B=this._collectTableSizes(z);if(this._mTimeouts.afterUpdateTableSizes){window.clearTimeout(this._mTimeouts.afterUpdateTableSizes);}if(B.tableCntHeight==0&&B.tableCntWidth==0){T.registerResizeHandler(this,"",this._onTableResize.bind(this),true);return;}this._updateRowHeader(B.tableRowHeights);this._syncColumnHeaders(B);this._determineVisibleCols(B);if(!j){this._setRowContentHeight(A);}this._updateHSb(B);this._updateVSb(B);this.$().find(".sapUiTableNoOpacity").addBack().removeClass("sapUiTableNoOpacity");if(this._mTimeouts.afterUpdateTableSizes){window.clearTimeout(this._mTimeouts.afterUpdateTableSizes);}var H=this;this._mTimeouts.afterUpdateTableSizes=window.setTimeout(function(){T.registerResizeHandler(H,"",H._onTableResize.bind(H),true);},0);};
y.prototype.setShowOverlay=function(i){i=!!i;this.setProperty("showOverlay",i,true);if(this.getDomRef()){var j=document.activeElement;this.$().toggleClass("sapUiTableOverlay",i);this._getAccExtension().updateAriaStateForOverlayAndNoData();this._getKeyboardExtension().updateNoDataAndOverlayFocus(j);}return this;};
y.prototype._updateFixedBottomRows=function(){var j=this.getFixedBottomRowCount();var l=this.getDomRef();if(l&&j>0){var $=q(l).find(".sapUiTableFixedPreBottomRow");$.removeClass("sapUiTableFixedPreBottomRow");var B=this.getBinding("rows");if(B){var z=this.getVisibleRowCount();var A=false;var H=this.getRows();var J=this._getSanitizedFirstVisibleRow();for(var i=0;i<H.length;i++){var K=H[i].getDomRefs(true);if(this._iBindingLength>=z){A=(i==z-j-1);}else{A=(J+i)==(this._iBindingLength-j-1)&&(J+i)<this._iBindingLength;}K.row.toggleClass("sapUiTableFixedPreBottomRow",A);}}}};
y.prototype.getFocusInfo=function(){var i=this.$().find(":focus").attr("id");if(i){return{customId:i};}else{return E.prototype.getFocusInfo.apply(this,arguments);}};
y.prototype.applyFocusInfo=function(i){if(i&&i.customId){this.$().find("#"+i.customId).focus();}else{E.prototype.getFocusInfo.apply(this,arguments);}return this;};
y.prototype.setTitle=function(i){var j=i;if(typeof(i)==="string"||i instanceof String){j=n.TableHelper.createTextView({text:i,width:"100%"});j.addStyleClass("sapUiTableHdrTitle");}this.setAggregation("title",j);return this;};
y.prototype.setFooter=function(i){var j=i;if(typeof(i)==="string"||i instanceof String){j=n.TableHelper.createTextView({text:i,width:"100%"});}this.setAggregation("footer",j);return this;};
y.prototype.setSelectionMode=function(i){this.clearSelection();if(i===t.Single){this._oSelection.setSelectionMode(g.SINGLE_SELECTION);}else{this._oSelection.setSelectionMode(g.MULTI_SELECTION);}if(i===t.Multi){i=t.MultiToggle;q.sap.log.warning("The selection mode 'Multi' is deprecated and must not be used anymore. Your setting was defaulted to selection mode 'MultiToggle'");}this.setProperty("selectionMode",i);return this;};
y.prototype._adjustTablePosition=function(){var i=this.getDomRef(v.VerticalScrollBar).scrollTop;var j=this._getDefaultRowHeight();var l=i%j;var z=this.$().find(".sapUiTableCtrlRowScroll, .sapUiTableRowHdrScr");if(this._iBindingLength<=this.getVisibleRowCount()){z.css({"transform":"translate3d(0px, "+(-i)+"px, 0px)"});}else{var A=this._calculateRowCorrection(j,l,i);z.css({"transform":"translate3d(0px, "+(-A)+"px, 0px)"});}};
y.prototype._calculateRowCorrection=function(i,j,l){var z=this.getFirstVisibleRow();var A=this._iBindingLength-this.getVisibleRowCount();if(z<A){var B=T.getRowHeightByIndex(this,0)-i;return Math.floor(j*(B/i))+j;}else if(z==A){return l-(this._iBindingLength*i)+this.getDomRef("tableCCnt").clientHeight;}};
y.prototype.setFirstVisibleRow=function(i,O,j){if(this.getNavigationMode()==sap.ui.table.NavigationMode.Paginator){var l=this.getVisibleRowCount();var z=this._paginatorCalculateTargetPage(i,l);var A=(z-1)*l;if(i!=A){i=A;z=this._paginatorCalculateTargetPage(i,l);}this._paginatorUpdate(z);}var B=this.getFirstVisibleRow()!=i;this.setProperty("firstVisibleRow",i,true);if(T.isVariableRowHeightEnabled(this)&&this.getBinding("rows")&&!this._bRefreshing&&!B){this._adjustTablePosition();}if(B&&this.getBinding("rows")&&!this._bRefreshing){this.updateRows();if(this.getNavigationMode()==N.Scrollbar){if(!O){var H=this.getDomRef(v.VerticalScrollBar);if(H){H.scrollTop=i*(this._getDefaultRowHeight()||28);}}}}if(B&&!j){this.fireFirstVisibleRowChanged({firstVisibleRow:i});}return this;};
y.getMetadata().getAggregation("rows")._doesNotRequireFactory=true;
y.prototype.bindRows=function(B,i,j,l){if(typeof B==="string"&&(i instanceof h||q.isArray(j)&&j[0]instanceof F)){l=j;j=i;i=undefined;}return this.bindAggregation("rows",B,i,j,l);};
y.prototype._bindAggregation=function(i,j,l,z,A){E.prototype._bindAggregation.apply(this,arguments);var B=this.getBinding("rows");if(i==="rows"&&B){B.attachChange(this._onBindingChange,this);}this._initSelectionModel(g.MULTI_SELECTION);if(B&&this.isTreeBinding("rows")&&!B.hasListeners("selectionChanged")){B.attachSelectionChanged(this._onSelectionChanged,this);}return this;};
y.prototype._initSelectionModel=function(i){if(this._oSelection){this._oSelection.detachSelectionChanged(this._onSelectionChanged,this);}this._oSelection=new g(i);this._oSelection.attachSelectionChanged(this._onSelectionChanged,this);return this;};
y.prototype._onBindingChange=function(i){var j=typeof(i)==="object"?i.getParameter("reason"):i;if(j==="sort"||j==="filter"){this.clearSelection();this.setFirstVisibleRow(0);}};
y.prototype.unbindAggregation=function(i,j){var B=this.getBinding("rows");if(i==="rows"&&this.isBound("rows")){j=true;}var l=E.prototype.unbindAggregation.apply(this,[i,j]);if(i==="rows"&&B){this._restoreAppDefaultsColumnHeaderSortFilter();this._invalidateColumnMenus();this._updateBindingLength();this.updateRows("unbindAggregation");}return l;};
y.prototype.setVisibleRowCount=function(i){if(i!=null&&!isFinite(i)){return this;}var j=this.getVisibleRowCountMode();if(j==V.Auto){q.sap.log.error("VisibleRowCount will be ignored since VisibleRowCountMode is set to Auto",this);return this;}var l=this.getFixedRowCount()+this.getFixedBottomRowCount();if(i<=l&&l>0){q.sap.log.error("Table: "+this.getId()+" visibleRowCount('"+i+"') must be bigger than number of fixed rows('"+(this.getFixedRowCount()+this.getFixedBottomRowCount())+"')",this);return this;}i=this.validateProperty("visibleRowCount",i);if(this.getBinding("rows")&&this.getBinding("rows").getLength()<=i){this.setProperty("firstVisibleRow",0);}this.setProperty("visibleRowCount",i);this._setRowContentHeight(i*this._getDefaultRowHeight());return this;};
y.prototype.setTooltip=function(i){q.sap.log.warning("The aggregation tooltip is not supported for sap.ui.table.Table");return this.setAggregation("tooltip",i,true);};
y.prototype.setNavigationMode=function(){this.setProperty("navigationMode",N.Scrollbar,true);q.sap.log.error("The navigationMode property is deprecated and must not be used anymore. Your setting was defaulted to 'Scrollbar'",this);};
y.prototype._getFixedBottomRowContexts=function(i,B){var j=this.getBinding("rows");var l=[];if(!j){return l;}i=i||this.getFixedBottomRowCount();B=B||j.getLength();var z=this.getVisibleRowCount();if(i>0&&(z-i)<B){l=this._getContexts(B-i,i,1);}return l;};
y.prototype._getFixedRowContexts=function(i){i=i||this.getFixedRowCount();if(i>0){return this._getContexts(0,i);}else{return[];}};
y.prototype._getContexts=function(i,l,j){var B=this.getBinding("rows");if(B){return B.getContexts(i,l,j);}else{return[];}};
y.prototype._getRowContexts=function(j,l,z){var A=false;var B=[];var H=this.getBinding("rows");var J=j||this.getRows().length;if(!H||J<=0){return[];}var K=this.getFirstVisibleRow();var L=this.getFixedRowCount();var O=this.getFixedBottomRowCount();var Q=0;var U;var W=J-O;var X=0;var Y=W;var Z=this.getThreshold();Z=Z?Math.max(J,Z):0;var $=K;var _=function(e1,f1,$){for(var i=0;i<f1.length;i++){e1[$+i]=f1[i];}};if(L>0&&K>0){$=K+L;W-=L;X=L;U=this._getFixedRowContexts(L);Q+=U.length;B=B.concat(U);}U=this._getContexts($,W,Z);var a1=this._updateBindingLength(z);A=U.length<Math.min(W,a1-O);if(this.getNavigationMode===N.Paginator){var b1=Math.min(W,(Math.max(a1-K-O,0)));if(b1<W){W=b1;U=U.slice(0,W);}}Q+=U.length;_(B,U,X);Y=Math.min(Y,Math.max(a1-O,0));if(O>0){U=this._getFixedBottomRowContexts(O,a1);Q+=U.length;_(B,U,Y);}if(A&&!l){var c1=this._getSanitizedFirstVisibleRow(true);if(K!=c1){B=this._getRowContexts(J,true);Q=B.length;}}if(!l){var d1=this;if(this._mTimeouts.getContextsSetBusy){window.clearTimeout(this._mTimeouts.getContextsSetBusy);}this._mTimeouts.getContextsSetBusy=window.setTimeout(function(){d1._setBusy({requestedLength:L+W+O,receivedLength:Q,contexts:B,reason:z});},0);}return B;};
y.prototype._getSanitizedFirstVisibleRow=function(U){var i=this.getNavigationMode();var j=this.getVisibleRowCount();var l=this.getFirstVisibleRow();l=Math.max(l,0);if(i===N.Scrollbar&&this._iBindingLength>0&&!T.isVariableRowHeightEnabled(this)){l=Math.min(l,Math.max(this._iBindingLength-j,0));}else if(i===N.Paginator&&this._oPaginator){var z=this._paginatorCalculateTargetPage(l,j);l=(z-1)*j;if(U){this._paginatorUpdate(z);}}if(U){this.setProperty("firstVisibleRow",l,true);}return l;};
y.prototype._paginatorCalculateTargetPage=function(i,j){var l=1;if(this._oPaginator){if(i<this._iBindingLength){l=Math.ceil((i+1)/j);}}return l;};
y.prototype._paginatorUpdate=function(i){if(this._oPaginator&&i!==this._oPaginator.getCurrentPage()){this._oPaginator.setCurrentPage(i);if(this._oPaginator.getDomRef()){this._oPaginator.rerender();}}};
y.prototype._updateBindingLength=function(i){var B=this.getBinding("rows");var j=0;if(B){j=B.getLength();}if(j!=this._iBindingLength){this._iBindingLength=j;this._onBindingLengthChange(i);}return j;};
y.prototype._onBindingLengthChange=function(i){this._updateFixedBottomRows();this._toggleVSb();this._bBindingLengthChanged=true;if(i!="skipNoDataUpdate"){this._updateNoData();}};
y.prototype.refreshRows=function(i){var B=this.getBinding("rows");if(!B){q.sap.log.error("RefreshRows must not be called without a binding",this);return;}var j=this;var l=typeof(i)==="object"?i.getParameter("reason"):i;if(l==e.Refresh){this._attachBindingListener();}this._bBusyIndicatorAllowed=true;var z=this.getVisibleRowCountMode();if((this.bOutput&&z===V.Auto)||z!==V.Auto){var A=this._calculateRowsToDisplay();if(this.bOutput){B.attachEventOnce("dataRequested",function(){if(j._mTimeouts.refreshRowsAdjustRows){window.clearTimeout(j._mTimeouts.refreshRowsAdjustRows);}j._mTimeouts.refreshRowsAdjustRows=window.setTimeout(function(){j._adjustRows(A,true);},0);});}var U;if(l==e.Filter||l==e.Sort){U="skipNoDataUpdate";this.setFirstVisibleRow(0);}this._updateBindingContexts(true,A,U);}};
y.prototype.updateRows=function(i){if(this._bExitCalled){return;}this._setBusy(i?{changeReason:i}:false);if(this._bBindingLengthChanged){this._updateNoData();}var j=this.getVisibleRowCountMode();if((this.getRows().length<=0||!this._oRowTemplate)&&((j==V.Auto&&this.bOutput)||j!=V.Auto)){if(this._iTableRowContentHeight){this._adjustRows(this._calculateRowsToDisplay());}}if(!this.bIsDestroyed){var B=(i==e.Change||(!this._mTimeouts.bindingTimer&&Date.now()-this._lastCalledUpdateRows>this._iBindingTimerDelay)||i=="unbindAggregation"?0:this._iBindingTimerDelay);var l=this;if(B==0&&i){Promise.resolve().then(function(){l._performUpdateRows(i);});}else{this._mTimeouts.bindingTimer=this._mTimeouts.bindingTimer||window.setTimeout(function(){l._performUpdateRows(i);},B);}}};
y.prototype.insertRow=function(){q.sap.log.error("The control manages the rows aggregation. The method \"insertRow\" cannot be used programmatically!",this);};
y.prototype.addRow=function(){q.sap.log.error("The control manages the rows aggregation. The method \"addRow\" cannot be used programmatically!",this);};
y.prototype.removeRow=function(){q.sap.log.error("The control manages the rows aggregation. The method \"removeRow\" cannot be used programmatically!",this);};
y.prototype.removeAllRows=function(){q.sap.log.error("The control manages the rows aggregation. The method \"removeAllRows\" cannot be used programmatically!",this);};
y.prototype.destroyRows=function(){q.sap.log.error("The control manages the rows aggregation. The method \"destroyRows\" cannot be used programmatically!",this);};
y.prototype.autoResizeColumn=function(i){this._getPointerExtension().doAutoResizeColumn(i);};
y.prototype._attachEvents=function(){var $=this.$();$.find(".sapUiTableColHdrScr").scroll(q.proxy(this._oncolscroll,this));$.find(".sapUiTableCtrlScr").scroll(q.proxy(this._oncntscroll,this));$.find(".sapUiTableCtrlScrFixed").scroll(q.proxy(this._oncntscroll,this));$.find(".sapUiTableCtrlScrFixed, .sapUiTableColHdrFixed").on("scroll.sapUiTablePreventFixedAreaScroll",function(l){l.target.scrollLeft=0;});if(T.isVariableRowHeightEnabled(this)){$.find(".sapUiTableCCnt").on("scroll.sapUiTablePreventCCntScroll",function(l){l.target.scrollTop=0;});}$.find(".sapUiTableRowHdr").hover(function(){q(this).addClass("sapUiTableRowHvr");var l=$.find(".sapUiTableRowHdr").index(this);$.find(".sapUiTableCtrlFixed > tbody > tr").filter(":eq("+l+")").addClass("sapUiTableRowHvr");$.find(".sapUiTableCtrlScroll > tbody > tr").filter(":eq("+l+")").addClass("sapUiTableRowHvr");},function(){q(this).removeClass("sapUiTableRowHvr");$.find(".sapUiTableCtrlFixed > tbody > tr").removeClass("sapUiTableRowHvr");$.find(".sapUiTableCtrlScroll > tbody > tr").removeClass("sapUiTableRowHvr");});$.find(".sapUiTableCtrlFixed > tbody > tr").hover(function(){q(this).addClass("sapUiTableRowHvr");var l=$.find(".sapUiTableCtrlFixed > tbody > tr").index(this);$.find(".sapUiTableRowHdr").filter(":eq("+(l)+")").addClass("sapUiTableRowHvr");$.find(".sapUiTableCtrlScroll > tbody > tr").filter(":eq("+l+")").addClass("sapUiTableRowHvr");},function(){q(this).removeClass("sapUiTableRowHvr");$.find(".sapUiTableRowHdr").removeClass("sapUiTableRowHvr");$.find(".sapUiTableCtrlScroll > tbody > tr").removeClass("sapUiTableRowHvr");});$.find(".sapUiTableCtrlScroll > tbody > tr").hover(function(){q(this).addClass("sapUiTableRowHvr");var l=$.find(".sapUiTableCtrlScroll > tbody > tr").index(this);$.find(".sapUiTableRowHdr").filter(":eq("+l+")").addClass("sapUiTableRowHvr");$.find(".sapUiTableCtrlFixed > tbody > tr").filter(":eq("+l+")").addClass("sapUiTableRowHvr");},function(){q(this).removeClass("sapUiTableRowHvr");$.find(".sapUiTableRowHdr").removeClass("sapUiTableRowHvr");$.find(".sapUiTableCtrlFixed > tbody > tr").removeClass("sapUiTableRowHvr");});this._getPointerExtension().initColumnResizeEvents();var i=q(this.getDomRef(v.VerticalScrollBar));var j=q(this.getDomRef(v.HorizontalScrollBar));i.bind("scroll.sapUiTableVScroll",this.onvscroll.bind(this));j.bind("scroll.sapUiTableHScroll",this.onhscroll.bind(this));j.bind("mousedown.sapUiTableHScroll",function(l){l.preventDefault();});i.bind("mousedown.sapUiTableVScroll",function(l){l.preventDefault();});if(D.browser.firefox){this._getScrollTargets().bind("MozMousePixelScroll.sapUiTableMouseWheel",this._onMouseWheel.bind(this));}else{this._getScrollTargets().bind("wheel.sapUiTableMouseWheel",this._onMouseWheel.bind(this));}if(sap.ui.getCore().getConfiguration().getAnimation()){q("body").bind('webkitTransitionEnd transitionend',q.proxy(function(l){if(q(l.target).has($).length>0){this._iDefaultRowHeight=undefined;this._updateTableSizes();}},this));}};
y.prototype._detachEvents=function(){var $=this.$();$.find(".sapUiTableRowHdrScr").unbind();$.find(".sapUiTableCtrl > tbody > tr").unbind();$.find(".sapUiTableRowHdr").unbind();this._getPointerExtension().cleanupColumnResizeEvents();$.find(".sapUiTableCtrlScrFixed, .sapUiTableColHdrFixed").unbind("scroll.sapUiTablePreventFixedAreaScroll");if(T.isVariableRowHeightEnabled(this)){$.find(".sapUiTableCCnt").unbind("scroll.sapUiTablePreventCCntScroll");}var i=q(this.getDomRef(v.VerticalScrollBar));i.unbind("scroll.sapUiTableVScroll");i.unbind("mousedown.sapUiTableVScroll");var j=q(this.getDomRef(v.HorizontalScrollBar));j.unbind("scroll.sapUiTableHScroll");j.unbind("mousedown.sapUiTableHScroll");var l=this._getScrollTargets();l.unbind("MozMousePixelScroll.sapUiTableMouseWheel");l.unbind("wheel.sapUiTableMouseWheel");var z=q(document.body);z.unbind('webkitTransitionEnd transitionend');T.deregisterResizeHandler(this);};
y.prototype._getScrollTargets=function(){var $=q(this.getDomRef("sapUiTableCtrlScr"));var i=q(this.getDomRef("rsz"));var j=q(this.getDomRef("sapUiTableCtrlScrFixed"));var l=q(this.getDomRef("sapUiTableRowHdrScr"));return $.add(j).add(l).add(i);};
y.prototype._cleanUpTimers=function(){for(var K in this._mTimeouts){if(this._mTimeouts[K]){clearTimeout(this._mTimeouts[K]);this._mTimeouts[K]=undefined;}}};
y.prototype._updateHSb=function(i){var $=this.$();var j=i.tableCtrlScrollWidth;if(!!D.browser.safari){j=Math.max(j,this._getColumnsWidth(this.getFixedColumnCount()));}if(j>i.tableCtrlScrWidth){if(!$.hasClass("sapUiTableHScr")){$.addClass("sapUiTableHScr");if(!!D.browser.safari){var l=$.find(".sapUiTableCtrlScroll, .sapUiTableColHdrScr > .sapUiTableColHdr");if(this._bjQueryLess18){l.width(j);}else{l.outerWidth(j);}}}var z=i.tableCtrlFixedWidth;if($.find(".sapUiTableRowHdrScr").length>0){z+=i.tableRowHdrScrWidth;}if(this.getRows().length>0){var A=$.find(".sapUiTableHSb");if(this._bRtlMode){A.css('margin-right',z+'px');}else{A.css('margin-left',z+'px');}}var H=this.getDomRef("hsb-content");if(H){H.style.width=j+"px";}}else{if($.hasClass("sapUiTableHScr")){$.removeClass("sapUiTableHScr");if(!!D.browser.safari){$.find(".sapUiTableCtrlScroll, .sapUiTableColHdr").css("width","");}}}};
y.prototype._updateVSb=function(i){var j=this.getDomRef(v.VerticalScrollBar);if(!j){return;}var l=this.getFixedRowCount();var z=this.getFixedBottomRowCount();if(l>0||z>0){var $=q(j);if(l>0){$.css('top',(i.tableCtrlRowScrollTop-1)+'px');}if(z>0){$.css('height',i.tableCtrlRowScrollHeight+'px');}}var A=this._getDefaultRowHeight();var B=(this._iBindingLength-l-z)*A;if(T.isVariableRowHeightEnabled(this)){var H=0;var J=this.getDomRef("tableCCnt");if(J){H=J.clientHeight;}var K=0;var L=this.getDomRef("table");if(L){K=L.clientHeight;}this._iRowHeightsDelta=K-H-T.getRowHeightByIndex(this,this.getRows().length-1);if(this._iBindingLength<=this.getVisibleRowCount()){B=this._iRowHeightsDelta+(this.getVisibleRowCount()*A);}else{B=this._iRowHeightsDelta+B;}this._toggleVSb();}this.getDomRef("vsb").style.maxHeight=(this.getVisibleRowCount()*A)+"px";this.getDomRef("vsb-content").style.height=B+"px";if(!T.isVariableRowHeightEnabled(this)){j.scrollTop=this._getSanitizedFirstVisibleRow()*A;}};
y.prototype._toggleVSb=function(){var $=this.$();var B=this.getBinding("rows");if(this._oPaginator&&this.getNavigationMode()===N.Paginator){var i=0;var j=0;if(B){var l=this.getVisibleRowCount();i=Math.ceil((this._iBindingLength||0)/l);var z=Math.min(i,Math.ceil((this.getFirstVisibleRow()+1)/l));this.setProperty("firstVisibleRow",(Math.max(z,1)-1)*l,true);j=z;}this._oPaginator.setNumberOfPages(i);this._oPaginator.setCurrentPage(j);if(this._oPaginator.getDomRef()){this._oPaginator.rerender();}if(this.getDomRef()){$.removeClass("sapUiTableVScr");}}else if(this.getDomRef()){$.toggleClass("sapUiTableVScr",this._isVSbRequired());}};
y.prototype._isVSbRequired=function(){if(this.getNavigationMode()===N.Scrollbar){if(T.isVariableRowHeightEnabled(this)&&this._iRowHeightsDelta>0){return true;}if(this.getBinding("rows")&&this._iBindingLength>this.getVisibleRowCount()){return true;}}return false;};
y.prototype._updateBindingContexts=function(i,j,l){var z=this.getRows(),B=this.getBinding("rows"),A=this.mBindingInfos["rows"],H;if(B){H=this._getRowContexts(j,false,l);}if(!i){var J=this.getFirstVisibleRow();var K=typeof this._updateTableCell==="function";this._resetRowHeights();for(var L=z.length-1;L>=0;L--){var O=H?H[L]:undefined;var Q=z[L];if(Q){var U=J+L;this._updateRowBindingContext(Q,O,A&&A.model,U,K,B);}}}};
y.prototype._updateRowBindingContext=function(j,z,A,B,H,J){j.setRowBindingContext(z,A,J);if(H){var K=j.getCells();for(var i=0,l=K.length;i<l;i++){if(K[i]){this._updateTableCell(K[i],z,K[i].$().closest("td"),B);}}}};
y.prototype._updateNoData=function(){if(!this.getDomRef()){return;}var i=document.activeElement;this.$().toggleClass("sapUiTableEmpty",T.isNoDataVisible(this));this._getAccExtension().updateAriaStateForOverlayAndNoData();this._getKeyboardExtension().updateNoDataAndOverlayFocus(i);};
y.prototype._determineVisibleCols=function(j){var l=[];this.getColumns().forEach(function(z,i){if(z.shouldRender()){l.push(i);}});};
y.prototype.removeColumn=function(i,j){var l=this.removeAggregation('columns',i,j);if(typeof i==="number"&&i>-1){i=this.getColumns()[i];}var z=q.inArray(i,this._aSortedColumns);if(this._iNewColPos===undefined&&z>=0){this._aSortedColumns.splice(z,1);}this._resetRowTemplate();return l;};
y.prototype.removeAllColumns=function(){var i=this.removeAllAggregation('columns');this._aSortedColumns=[];this._resetRowTemplate();return i;};
y.prototype.destroyColumns=function(){var i=this.destroyAggregation('columns');this._aSortedColumns=[];this._resetRowTemplate();return i;};
y.prototype.addColumn=function(i,j){this.addAggregation('columns',i,j);this._resetRowTemplate();return this;};
y.prototype.insertColumn=function(i,j,l){this.insertAggregation('columns',i,j,l);this._resetRowTemplate();return this;};
y.prototype._getRowCount=function(){return this._iBindingLength;};
y.prototype._getSelectableRowCount=function(){return this._iBindingLength;};
y.prototype._getFirstVisibleRowByScrollTop=function(i){var j=this.getDomRef(v.VerticalScrollBar);if(j){i=(typeof i==="undefined")?j.scrollTop:i;if(T.isVariableRowHeightEnabled(this)){if(this.getVisibleRowCount()>=this._iBindingLength){return 0;}else{return Math.min(this._iBindingLength-this.getVisibleRowCount(),Math.floor(i/this._getDefaultRowHeight()));}}else{return Math.ceil(i/this._getDefaultRowHeight());}}else{if(this.getNavigationMode()===N.Paginator){return(((this._oPaginator.getCurrentPage()||1)-1)*this.getVisibleRowCount());}else{return 0;}}};
y.prototype._getVisibleColumns=function(){var j=[];var z=this.getColumns();for(var i=0,l=z.length;i<l;i++){if(z[i].shouldRender()){j.push(z[i]);}}return j;};
y.prototype._getColumnsWidth=function(j,z){var A=this.getColumns();var B=0;if(j!==0&&!j){j=0;}if(z!==0&&!z){z=A.length;}for(var i=j,l=z;i<l;i++){if(A[i]&&A[i].shouldRender()){B+=this._CSSSizeToPixel(A[i].getWidth());}}return B;};
y.prototype._CSSSizeToPixel=function(i,j){var l=this._iColMinWidth;if(i){if(q.sap.endsWith(i,"px")){l=parseInt(i,10);}else if(q.sap.endsWith(i,"em")||q.sap.endsWith(i,"rem")){l=Math.ceil(parseFloat(i)*this._getBaseFontSize());}}if(j){return l+"px";}else{return parseInt(l,10);}};
y.prototype._getBaseFontSize=function(){return this._iBaseFontSize;};
y.prototype._onTableResize=function(){if(this._bInvalid||!this.getDomRef()){return;}this._updateTableSizes();};
y.prototype._handleRowCountModeAuto=function(i){var B=this.getBinding("rows");if(B&&this.getRows().length>0){return this._executeAdjustRows(i);}else{var j=this;var l=!this._mTimeouts.handleRowCountModeAutoAdjustRows;var z=j.getBusyIndicatorDelay();var A=this.getEnableBusyIndicator();if(B&&A){j.setBusyIndicatorDelay(0);j.setBusy(true);}if(i){this._setRowContentHeight(i);}this._mTimeouts.handleRowCountModeAutoAdjustRows=this._mTimeouts.handleRowCountModeAutoAdjustRows||window.setTimeout(function(){if(!j._executeAdjustRows()){j._updateTableSizes(false,true);}j._mTimeouts.handleRowCountModeAutoAdjustRows=undefined;if(A){j.setBusy(false);j.setBusyIndicatorDelay(z);}},0);return l;}};
y.prototype._executeAdjustRows=function(i){i=i||this._determineAvailableSpace();var j=this._calculateRowsToDisplay(i);if(j==this._determineMinAutoRowCount()){this.$().height("auto");}else{this.$().height("0px");}return this._adjustRows(j);};
y.prototype._syncColumnHeaders=function(l){var z=this.getDomRef();if(!z){return;}var $=this.$();var H=l.headerWidths;var A=this.getFixedColumnCount();var B=this._getVisibleColumns();if(B.length==0){return;}var J=$.find(".sapUiTableColHdr");var K=$.find(".sapUiTableColHdrScr");var L=J.find(".sapUiTableCol");var O=$.find(".sapUiTableCtrlFirstCol > th:not(.sapUiTableColSel)");this._aTableHeaders=O;var Q={};O.each(function(Y,Z){var _=Z.getAttribute("data-sap-ui-headcolindex");var a1=H[Y];var b1;var c1=B[Y];if(c1){b1=a1;}if(Y==0||Y==A){b1+=Math.max(0,l.invisibleColWidth);}var d1=B[Y]?B[Y].getHeaderSpan():1,e1=[],f1;if(d1){if(!q.isArray(d1)){d1=[d1];}q.each(d1,function(h1,i1){d1[h1]=Math.max(i1,1);});f1=d1;}else{f1=[1];}for(var i=0;i<f1.length;i++){e1[i]={width:b1,span:1};for(var j=1;j<f1[i];j++){var g1=O[Y+j];if(g1){e1[i].width+=H[Y+j];e1[i].span=f1[i];}}}if(c1){Q[_]={domRefColumnTh:Z,domRefColumnDivs:[],aHeaderData:e1};}});var U=this;L.each(function(i,j){var Y=parseInt(j.getAttribute("data-sap-ui-colindex"),10);var Z=Q[Y];if(Z){Z.domRefColumnDivs.push(j);}else{q.sap.log.error("Inconsistent DOM / Control Tree combination",U);}});q.each(Q,function(j,Y){for(var i=0;i<Y.domRefColumnDivs.length;i++){var Z=Y.aHeaderData[0];if(Y.aHeaderData[i]){Z=Y.aHeaderData[i];}if(Y.domRefColumnDivs[i]){Y.domRefColumnDivs[i].style.width=Z.width+"px";Y.domRefColumnDivs[i].setAttribute("data-sap-ui-colspan",Z.span);}else{q.sap.log.error("Inconsistent DOM / Control Tree combination",U);}}});var W=this.getColumnHeaderHeight()>0;if(!W){L.each(function(i,j){j.style.height=l.columnRowOuterHeight+"px";});var X=z.querySelector(".sapUiTableColHdrCnt");if(X){X.style.height=Math.floor(l.columnRowHeight*T.getHeaderRowCount(this))+"px";}}K.each(function(i,j){j.style.width=l.tableCtrlScrWidth+"px";});};
y.prototype._disableTextSelection=function(i){q(i||document.body).attr("unselectable","on").css({"-moz-user-select":"none","-webkit-user-select":"none","user-select":"none"}).bind("selectstart",function(j){j.preventDefault();return false;});};
y.prototype._enableTextSelection=function(i){q(i||document.body).attr("unselectable","off").css({"-moz-user-select":"","-webkit-user-select":"","user-select":""}).unbind("selectstart");};
y.prototype._clearTextSelection=function(){if(window.getSelection){if(window.getSelection().empty){window.getSelection().empty();}else if(window.getSelection().removeAllRanges){window.getSelection().removeAllRanges();}}else if(document.selection&&document.selection.empty){try{document.selection.empty();}catch(i){}}};
y.prototype.onvscroll=function(i){var j=this;q.sap.interaction.notifyScrollEvent&&q.sap.interaction.notifyScrollEvent(i);this._getKeyboardExtension().setActionMode(false);if(this._bLargeDataScrolling&&!this._bIsScrolledByWheel){window.clearTimeout(this._mTimeouts.scrollUpdateTimerId);this._mTimeouts.scrollUpdateTimerId=window.setTimeout(function(){j.setFirstVisibleRow(j._getFirstVisibleRowByScrollTop(),true);j._mTimeouts._sScrollUpdateTimerId=null;},300);}else{this.setFirstVisibleRow(this._getFirstVisibleRowByScrollTop(),true);}this._bIsScrolledByWheel=false;};
y.prototype.onpscroll=function(i){q.sap.interaction.notifyScrollEvent&&q.sap.interaction.notifyScrollEvent(i);this._getKeyboardExtension().setActionMode(false);var j=0;if(this.getNavigationMode()===N.Paginator){j=(((this._oPaginator.getCurrentPage()||1)-1)*this.getVisibleRowCount());}this.setFirstVisibleRow(j,true);};
y.prototype._onMouseWheel=function(i){var O=i.originalEvent;var j=O.shiftKey;var l=0;if(D.browser.firefox){l=O.detail;}else{if(j){l=O.deltaX;}else{l=O.deltaY;}}if(j){var H=this.getDomRef(v.HorizontalScrollBar);if(H){H.scrollLeft=H.scrollLeft+l;}}else{var z=this.getDomRef(v.VerticalScrollBar);if(z){this._bIsScrolledByWheel=true;z.scrollTop=z.scrollTop+l;}}i.preventDefault();i.stopPropagation();};
y.prototype._syncHeaderAndContent=function(i){if(!this._bSyncScrollLeft){this._bSyncScrollLeft=true;var $=this.$();var H=i.tableHSbScrollLeft;$.find(".sapUiTableColHdrScr").scrollLeft(H);$.find(".sapUiTableCtrlScr").scrollLeft(H);this._bSyncScrollLeft=false;}};
y.prototype.onhscroll=function(i){q.sap.interaction.notifyScrollEvent&&q.sap.interaction.notifyScrollEvent(i);if(!this._bOnAfterRendering){if(this._mTimeouts.hScrollUpdateTimer){window.clearTimeout(this._mTimeouts.hScrollUpdateTimer);}this._mTimeouts.hScrollUpdateTimer=window.setTimeout(function(){var j=this._collectTableSizes();this._syncHeaderAndContent(j);this._determineVisibleCols(j);}.bind(this),50);}};
y.prototype._oncolscroll=function(){if(!this._bSyncScrollLeft){var H=this.getDomRef(v.HorizontalScrollBar);if(H){var i=this.getDomRef().querySelector(".sapUiTableColHdrScr");var j=0;if(i){j=i.scrollLeft;}H.scrollLeft=j;}}};
y.prototype._oncntscroll=function(){if(!this._bSyncScrollLeft){var H=this.getDomRef(v.HorizontalScrollBar);if(H){var i=this.getDomRef().querySelector(".sapUiTableCtrlScr");H.scrollLeft=i.scrollLeft;}}};
y.prototype.onmousedown=function(i){var l=i.button===0;var j=this._isTouchMode(i);if(l){var $=q(i.target);var z=$.closest(".sapUiTableCol");if(z.length===1&&i.target!=this.getDomRef("sb")){this._bShowMenu=true;this._mTimeouts.delayedMenuTimer=q.sap.delayedCall(200,this,function(){this._bShowMenu=false;});var A=this._isTouchMode(i)&&($.hasClass("sapUiTableColDropDown")||$.hasClass("sapUiTableColResizer"));if(this.getEnableColumnReordering()&&!A){var B=parseInt(z.attr("data-sap-ui-colindex"),10);if(B>this._iLastFixedColIndex){var H=this.getColumns()[B];this._mTimeouts.delayedActionTimer=q.sap.delayedCall(200,this,function(){this._onColumnMoveStart(H,j);});}}}var J=!!(i.metaKey||i.ctrlKey);if(!!D.browser.firefox&&J){i.preventDefault();}}};
y.prototype.oncontextmenu=function(i){var $=q(i.target);var H=$.closest('.sapUiTableCol');if(H.length>0){var j=sap.ui.getCore().byId(H.attr("data-sap-ui-colid"));if(j){j._openMenu(H[0],false);}i.preventDefault();}else{if(this._findAndfireCellEvent(this.fireCellContextmenu,i,this._oncellcontextmenu)){i.preventDefault();}}};
y.prototype._oncellcontextmenu=function(i){if(this.getEnableCellFilter()){if(!this._oContextMenu){if(!M){M=sap.ui.requireSync("sap/ui/unified/Menu");x=sap.ui.requireSync("sap/ui/unified/MenuItem");}this._oContextMenu=new M(this.getId()+"-contextmenu");this.addDependent(this._oContextMenu);}var j=sap.ui.getCore().byId(i.columnId);var l=j.getFilterProperty();if(j&&j.isFilterableByMenu()&&i.rowBindingContext){this._oContextMenu.destroyItems();this._oContextMenu.addItem(new x({text:this._oResBundle.getText("TBL_FILTER"),select:[function(){var A=this.getContextByIndex(i.rowIndex);var B=A.getProperty(l);if(this.getEnableCustomFilter()){this.fireCustomFilter({column:j,value:B});}else{this.filter(j,B);}},this]}));var z=P.Dock;this._oContextMenu.open(false,i.cellDomRef,z.BeginTop,z.BeginBottom,i.cellDomRef,"none none");return true;}}};
y.prototype._findAndfireCellEvent=function(i,j,l){var $=q(j.target);var z=$.closest("td[role='gridcell']");var A=z.attr("id");var B=/.*-row(\d*)-col(\d*)/i.exec(A);var H=false;if(B){var J=B[1];var K=B[2];var L=this.getRows()[J];var O=L&&L.getCells()[K];var Q=L&&L.getIndex();var U=O.data("sap-ui-colid");var W;if(this.getBindingInfo("rows")){W=L.getBindingContext(this.getBindingInfo("rows").model);}var X={rowIndex:Q,columnIndex:K,columnId:U,cellControl:O,rowBindingContext:W,cellDomRef:z.get(0)};H=!i.call(this,X);if(!H&&typeof l==="function"){X.cellDomRef=z[0];H=l.call(this,X);}}return H;};
y.prototype.getFocusDomRef=function(){this._getKeyboardExtension().initItemNavigation();return T.getFocusedItemInfo(this).domRef||C.prototype.getFocusDomRef.apply(this,arguments);};
y.prototype.onfocusin=function(i){var $;var j=q(i.target);if(j.parent('.sapUiTableTr').length>0){$=q(this.getDomRef("sapUiTableCtrlScr"));}else if(j.parent('.sapUiTableColHdr').length>0){$=q(this.getDomRef("sapUiTableColHdrScr"));}if((D.browser.firefox||D.browser.chrome)&&$&&$.length>0){var l=$.scrollLeft();var z=$.width();var A=j.position().left;var B=A+j.width();var O=A-l;var H=B-z-l;var J=this.getDomRef(v.HorizontalScrollBar);if(H>0){J.scrollLeft=J.scrollLeft+H+2;}else if(O<0){J.scrollLeft=J.scrollLeft+O-1;}}};
y.prototype._getAbsoluteRowIndex=function(i){var j=0;var l=this.getFirstVisibleRow();var z=this.getFixedBottomRowCount();var A=this.getVisibleRowCount();var B=A-z;if(z>0&&i>=B){j=this.getBinding().getLength()-A+i;}else{j=l+i;}return j;};
y.prototype._onSelect=function(i){var $=q(i.target);var j=i.shiftKey;var l=!!(i.metaKey||i.ctrlKey);var z=$.closest(".sapUiTableCol");if(this._bShowMenu&&z.length===1){var A=parseInt(z.attr("data-sap-ui-colindex"),10);var B=this.getColumns()[A];if($.hasClass("sapUiTableColDropDown")){var H=this.fireColumnSelect({column:B});if(H){B._openMenu(z[0],i.type=="keyup");}}else{this._onColumnSelect(B,z[0],this._isTouchMode(i),i.type=="keyup");}return;}var J=$.closest(".sapUiTableRowHdr");if(J.length===1){var A=parseInt(J.attr("data-sap-ui-rowindex"),10);this._onRowSelect(this._getAbsoluteRowIndex(A),j,l);return;}var K;if(i.target){var L=q(i.target).closest("td");if(L.length>0){K=L[0];}}if(K&&(K.getAttribute("role")=="gridcell"||q(K).hasClass("sapUiTableTDDummy"))&&T.isRowSelectionAllowed(this)){var J=$.closest(".sapUiTableCtrl > tbody > tr");if(J.length===1){var A=parseInt(J.attr("data-sap-ui-rowindex"),10);this._onRowSelect(this._getAbsoluteRowIndex(A),j,l);return;}}if(q.sap.containsOrEquals(this.getDomRef("selall"),i.target)){this._toggleSelectAll();return;}};
y.prototype._isRowSelectable=function(i){return true;};
y.prototype._onRowSelect=function(i,j,l){if(!!D.browser.internet_explorer&&j){this._clearTextSelection();}var B=this.getBinding("rows");if(!B){return;}if(i<0||i>=(B.getLength()||0)){return;}if(!this._isRowSelectable(i)){return;}this._iSourceRowIndex=i;var z=this.getSelectionMode();if(z!==t.None){if(z===t.Single){if(!this.isIndexSelected(i)){this.setSelectedIndex(i);}else{this.clearSelection();}}else{if(z===t.MultiToggle){l=true;}if(j){var A=this.getSelectedIndex();if(A>=0){this.addSelectionInterval(A,i);}else{this.setSelectedIndex(i);}}else{if(!this.isIndexSelected(i)){if(l){this.addSelectionInterval(i,i);}else{this.setSelectedIndex(i);}}else{if(l){this.removeSelectionInterval(i,i);}else{if(this._getSelectedIndicesCount()===1){this.clearSelection();}else{this.setSelectedIndex(i);}}}}}}this._iSourceRowIndex=undefined;};
y.prototype._onColumnSelect=function(i,j,l,W){if(l&&(i.getResizable()||i._menuHasItems())){var $=q(j);var z=$.find(".sapUiTableColCell");if($.find(".sapUiTableColCellMenu").length<1){z.hide();var A="";if(i._menuHasItems()){A="<div class='sapUiTableColDropDown'></div>";}var B="";if(i.getResizable()){B="<div class='sapUiTableColResizer''></div>";}var H=q("<div class='sapUiTableColCellMenu'>"+A+B+"</div>");$.append(H);$.bind("focusout",function(){this.cell.show();this.menu.remove();this.self.unbind("focusout");}.bind({cell:z,menu:H,self:$}));}return;}var J=this.fireColumnSelect({column:i});if(J){i._openMenu(j,W);}};
y.prototype.ontouchstart=function(i){if('ontouchstart'in document){this._aTouchStartPosition=null;this._bIsScrollVertical=null;var $=this._getScrollTargets();var j=q(i.target).closest($).length>0;if(j){var l=i.targetTouches[0];this._aTouchStartPosition=[l.pageX,l.pageY];var z=this.getDomRef(v.VerticalScrollBar);if(z){this._iTouchScrollTop=z.scrollTop;}var H=this.getDomRef(v.HorizontalScrollBar);if(H){this._iTouchScrollLeft=H.scrollLeft;}}}};
y.prototype.ontouchmove=function(i){if('ontouchstart'in document&&this._aTouchStartPosition){var j=i.targetTouches[0];var l=(j.pageX-this._aTouchStartPosition[0]);var z=(j.pageY-this._aTouchStartPosition[1]);if(this._bIsScrollVertical==null){this._bIsScrollVertical=Math.abs(z)>Math.abs(l);}if(this._bIsScrollVertical){var A=this.getDomRef(v.VerticalScrollBar);if(A){var B=this._iTouchScrollTop-z;if(B>0&&B<(this.getDomRef("vsb-content").clientHeight-A.clientHeight)-1){i.preventDefault();i.stopPropagation();}A.scrollTop=B;}}else{var H=this.getDomRef(v.HorizontalScrollBar);if(H){var J=this._iTouchScrollLeft-l;if(J>0&&J<(this.getDomRef("hsb-content").clientWidth-H.clientWidth)-1){i.preventDefault();i.stopPropagation();}H.scrollLeft=J;}}}};
y.prototype._onColumnMoveStart=function(i,j){this._disableTextSelection();var $=i.$();var l=parseInt($.attr("data-sap-ui-colindex"),10);if(l<this.getFixedColumnCount()){return;}this.$().addClass("sapUiTableDragDrop");this._$colGhost=$.clone().removeAttr("id");$.css({"opacity":".25"});this._$colGhost.addClass("sapUiTableColGhost").css({"left":-10000,"top":-10000,"position":"absolute","z-index":this.$().zIndex()+10});this.$().find(".sapUiTableCol").each(function(A,B){var $=q(this);$.css({position:"relative"});$.data("pos",{left:$.position().left,center:$.position().left+$.outerWidth()/2,right:$.position().left+$.outerWidth()});});this._$colGhost.appendTo(document.body);var z=q(document.body);if(j){z.bind("touchmove.sapUiColumnMove",q.proxy(this._onColumnMove,this));z.bind("touchend.sapUiColumnMove",q.proxy(this._onColumnMoved,this));}else{z.bind("mousemove.sapUiColumnMove",q.proxy(this._onColumnMove,this));z.bind("mouseup.sapUiColumnMove",q.proxy(this._onColumnMoved,this));}};
y.prototype._onColumnMove=function(i){var $=this.$();var l=i.pageX;var L=i.pageY;if(i&&this._isTouchMode(i)){l=i.targetTouches[0].pageX;L=i.targetTouches[0].pageY;i.stopPropagation();i.preventDefault();}var j=this._bRtlMode;var z=l-$.offset().left;var A=parseInt(this._$colGhost.attr("data-sap-ui-colindex"),10);var B=this.getColumns()[A].$();var O=this._iNewColPos;this._iNewColPos=A;var H=this;$.find(".sapUiTableCol").each(function(J,K){var Q=q(K);var U=parseInt(Q.attr("data-sap-ui-colindex"),10);var W=sap.ui.getCore().byId(Q.attr("data-sap-ui-colid")).getHeaderSpan();var X;if(W){if(q.isArray(W)){X=W[0];}else{X=W;}}else{X=1;}if(Q.get(0)!==B.get(0)){var Y=Q.data("pos");var Z=z>=Y.left&&z<=Y.center;var _=z>=Y.center&&z<=Y.right;if(!j){if(Z){H._iNewColPos=U;}else if(_){H._iNewColPos=U+X;}else{H._iNewColPos=H._iNewColPos;}}else{if(_){H._iNewColPos=U;}else if(Z){H._iNewColPos=U+X;}else{H._iNewColPos=H._iNewColPos;}}if((Z||_)&&U>A){H._iNewColPos--;}}});if(this._iNewColPos<=this._iLastFixedColIndex){this._iNewColPos=O;}if(this._iNewColPos<this.getFixedColumnCount()){this._iNewColPos=O;}this._animateColumnMove(A,O,this._iNewColPos);this._$colGhost.css({"left":l+5,"top":L+5});};
y.prototype._animateColumnMove=function(j,O,z){var A=this._bRtlMode;var $=this.getColumns()[j].$();if(O!==z){for(var i=Math.min(O,z),l=Math.max(O,z);i<=l;i++){var B=this.getColumns()[i];if(i!==j&&B.getVisible()){B.$().stop(true,true).animate({left:"0px"});}}var H=0;if(z<j){for(var i=z;i<j;i++){var B=this.getColumns()[i];if(B.getVisible()){var J=B.$();H-=J.outerWidth();J.stop(true,true).animate({left:$.outerWidth()*(A?-1:1)+"px"});}}}else{for(var i=j+1,l=z+1;i<l;i++){var B=this.getColumns()[i];if(B.getVisible()){var J=B.$();H+=J.outerWidth();J.stop(true,true).animate({left:$.outerWidth()*(A?1:-1)+"px"});}}}$.stop(true,true).animate({left:H*(A?-1:1)+"px"});}};
y.prototype._onColumnMoved=function(j){var l=this;this.$().removeClass("sapUiTableDragDrop");var z=parseInt(this._$colGhost.attr("data-sap-ui-colindex"),10);var A=this.getColumns()[z];var $=q(document.body);$.unbind("touchmove.sapUiColumnMove");$.unbind("touchend.sapUiColumnMove");$.unbind("mousemove.sapUiColumnMove");$.unbind("mouseup.sapUiColumnMove");this._$colGhost.remove();this._$colGhost=undefined;this._enableTextSelection();var B=this.fireColumnMove({column:A,newPos:this._iNewColPos});var H=z<this._iNewColPos;if(B&&this._iNewColPos!==undefined&&this._iNewColPos!==z){this.removeColumn(A);this.insertColumn(A,this._iNewColPos);var J=A.getHeaderSpan(),K;if(J){if(q.isArray(J)){K=J[0];}else{K=J;}}else{K=1;}if(K>1){if(!H){this._iNewColPos++;}for(var i=1;i<K;i++){var L=this.getColumns()[H?z:z+i];this.removeColumn(L);this.insertColumn(L,this._iNewColPos);this.fireColumnMove({column:L,newPos:this._iNewColPos});if(!H){this._iNewColPos++;}}}}else{this._animateColumnMove(z,this._iNewColPos,z);A.$().css({"backgroundColor":"","backgroundImage":"","opacity":""});}if(this._mTimeouts.reApplyFocusTimer){window.clearTimeout(this._mTimeouts.reApplyFocusTimer);}this._mTimeouts.reApplyFocusTimer=window.setTimeout(function(){var O=T.getFocusedItemInfo(l).cell;T.focusItem(l,0,j);T.focusItem(l,O,j);},0);delete this._iNewColPos;};
y.prototype._resizeDependentColumns=function(j,W){var l=this;if(this._checkPercentageColumnWidth()){var z=this._getVisibleColumns();var A;q.each(z,function(b1,c1){if(j===c1){A=b1;}});var O=0;var L=z.length-1;var B;if(A===undefined){B=0;}else{B=parseInt(W,10);}var H=0;var J=[];q.each(z,function(b1,c1){var d1=l._getColumnPercentageWidth(c1);if((((A===L&&b1<A)||((A!==L)&&b1>A))&&c1.getFlexible())||A===undefined){O+=c1.$().outerWidth();H+=d1;J.push(c1);}else if(b1!==A){B+=d1;}});var K=B;q.each(J,function(b1,c1){var d1=l._getColumnPercentageWidth(c1);var a1=Math.round((100-K)/H*d1);if(b1===J.length-1){a1=100-B;}else{B+=a1;}l._updateColumnWidth(c1,a1+"%");});}else if(!this._hasOnlyFixColumnWidths()){var z=this._getVisibleColumns(),Q=this.$().find(".sapUiTableCtrl").width(),A,U=0,X=0,Y=0,Z=0;q.each(z,function(b1,c1){if(!q.sap.endsWith(c1.getWidth(),"px")&&!q.sap.endsWith(c1.getWidth(),"em")&&!q.sap.endsWith(c1.getWidth(),"rem")){Z++;return false;}if(A!=undefined){Y+=l._CSSSizeToPixel(c1.getWidth());U++;}else if(j!==c1){X+=l._CSSSizeToPixel(c1.getWidth());}if(j===c1){A=b1;X+=l._CSSSizeToPixel(W);}});if(Z>0||(X+Y>Q)){return;}Q-=X;for(var i=A+1;i<z.length;i++){var j=z[i],$=this._CSSSizeToPixel(j.getWidth()),_=$/Y*100,a1=Q/100*_;this._updateColumnWidth(j,Math.round(a1)+'px');}}};
y.prototype._getColumnPercentageWidth=function(i){var j=i.getWidth();var l=parseInt(i.getWidth(),10);var z=this.$().find(".sapUiTableCtrl").width();if(q.sap.endsWith(j,"px")||q.sap.endsWith(j,"em")||q.sap.endsWith(j,"rem")){l=Math.round(100/z*l);}else if(!q.sap.endsWith(j,"%")){l=Math.round(100/z*i.$().width());}return l;};
y.prototype._updateColumnWidth=function(i,W,j){var l=true;if(j){l=this.fireColumnResize({column:i,width:W});}if(l){i.setProperty("width",W,true);this.$().find('th[data-sap-ui-colid="'+i.getId()+'"]').css('width',W);}return l;};
y.prototype._checkPercentageColumnWidth=function(){var i=this.getColumns();var H=false;q.each(i,function(j,l){if(q.sap.endsWith(l.getWidth(),"%")){H=true;return false;}});return H;};
y.prototype._hasOnlyFixColumnWidths=function(){var O=true;q.each(this.getColumns(),function(i,j){var W=j.getWidth();if(j.getFlexible()||!W||W.substr(-2)!=="px"){O=false;return false;}});return O;};
y.prototype.pushSortedColumn=function(i,A){if(!A){this._aSortedColumns=[];}this._aSortedColumns.push(i);};
y.prototype.getSortedColumns=function(){return this._aSortedColumns;};
y.prototype.sort=function(i,j,A){if(q.inArray(i,this.getColumns())>=0){i.sort(j===w.Descending,A);}};
y.prototype.filter=function(i,j){if(q.inArray(i,this.getColumns())>=0){i.filter(j);}};
y.prototype._updateSelection=function(){if(this.getSelectionMode()===t.None){return;}var j=this._getAccExtension().getAriaTextsForSelectionMode(true);var l=T.isRowSelectionAllowed(this);var z=this.getRows();for(var i=0;i<z.length;i++){var A=z[i];A._updateSelection(this,j,l);}this.setProperty("selectedIndex",this.getSelectedIndex(),true);};
y.prototype._onSelectionChanged=function(i){var j=i.getParameter("rowIndices");var l=i.getParameter("selectAll");var z=this._iSourceRowIndex!==undefined?this._iSourceRowIndex:this.getSelectedIndex();this._updateSelection();var A=this.getSelectionMode();if(A==="Multi"||A==="MultiToggle"){this.$("selall").attr('title',this._oResBundle.getText("TBL_SELECT_ALL")).addClass("sapUiTableSelAll");}this.fireRowSelectionChange({rowIndex:z,rowContext:this.getContextByIndex(z),rowIndices:j,selectAll:l,userInteraction:this._iSourceRowIndex!==undefined});};
y.prototype.getContextByIndex=function(i){var B=this.getBinding("rows");return i>=0&&B?B.getContexts(i,1)[0]:null;};
y.prototype.getSelectedIndex=function(){return this._oSelection.getLeadSelectedIndex();};
y.prototype.setSelectedIndex=function(i){if(i===-1){this.clearSelection();}else{this._oSelection.setSelectionInterval(i,i);}return this;};
y.prototype.clearSelection=function(){this._oSelection.clearSelection();return this;};
y.prototype.selectAll=function(){var i=this.getSelectionMode();if(!this.getEnableSelectAll()||(i!="Multi"&&i!="MultiToggle")){return this;}var B=this.getBinding("rows");if(B){this._oSelection.selectAll((B.getLength()||0)-1);this.$("selall").attr('title',this._oResBundle.getText("TBL_DESELECT_ALL")).removeClass("sapUiTableSelAll");}return this;};
y.prototype.getSelectedIndices=function(){return this._oSelection.getSelectedIndices();};
y.prototype.addSelectionInterval=function(i,j){this._oSelection.addSelectionInterval(i,j);return this;};
y.prototype.setSelectionInterval=function(i,j){this._oSelection.setSelectionInterval(i,j);return this;};
y.prototype.removeSelectionInterval=function(i,j){this._oSelection.removeSelectionInterval(i,j);return this;};
y.prototype.isIndexSelected=function(i){return this._oSelection.isSelectedIndex(i);};
y.prototype.setGroupBy=function(i){var j=i;if(typeof j==="string"){j=sap.ui.getCore().byId(j);}var l=false;if(j&&j instanceof k){if(q.inArray(j,this.getColumns())===-1){throw new Error("Column has to be part of the columns aggregation!");}var z=this.fireGroup({column:j,groupedColumns:[j.getId()],type:G.group});var O=sap.ui.getCore().byId(this.getGroupBy());if(O){O.setGrouped(false);l=true;}if(z&&j instanceof k){j.setGrouped(true);}}if(!j||l){var B=this.getBindingInfo("rows");delete B.binding;this._bindAggregation("rows",B);}return this.setAssociation("groupBy",j);};
y.prototype.getBinding=function(i){T.Grouping.setupExperimentalGrouping(this);return E.prototype.getBinding.call(this,[i||"rows"]);};
y.prototype.setEnableGrouping=function(i){this.setProperty("enableGrouping",i);if(!i){T.Grouping.resetExperimentalGrouping(this);}this._invalidateColumnMenus();return this;};
y.prototype.setEnableCustomFilter=function(i){this.setProperty("enableCustomFilter",i);this._invalidateColumnMenus();return this;};
y.prototype.setEnableColumnFreeze=function(i){this.setProperty("enableColumnFreeze",i);this._invalidateColumnMenus();return this;};
y.prototype.setShowColumnVisibilityMenu=function(i){this.setProperty("showColumnVisibilityMenu",i);this._invalidateColumnMenus();return this;};
y.prototype.getFixedColumnCount=function(){if(this._bIgnoreFixedColumnCount){return 0;}else{return this.getProperty("fixedColumnCount");}};
y.prototype.setFixedColumnCount=function(j,l){var z=this._getVisibleColumns();var H=z[j-1]&&z[j-1].getHeaderSpan();if(H){var A;if(q.isArray(H)){A=parseInt(H[0],10);}else{A=parseInt(H,10);}j+=A-1;}var $=this.$().find(".sapUiTableCtrlFirstCol > th");for(var i=0;i<j;i++){var B=z[i];if(B){var J=q.inArray(B,this.getColumns());if(!B.getWidth()){B.setWidth($.filter("[data-sap-ui-headcolindex='"+J+"']").width()+"px");}}}this.setProperty("fixedColumnCount",j,l);this._collectTableSizes();this._invalidateColumnMenus();return this;};
y.prototype.setFixedRowCount=function(i){if(!(parseInt(i,10)>=0)){q.sap.log.error("Number of fixed rows must be greater or equal 0",this);return this;}if((i+this.getFixedBottomRowCount())<this.getVisibleRowCount()){this.setProperty("fixedRowCount",i);this._updateBindingContexts();}else{q.sap.log.error("Table '"+this.getId()+"' fixed rows('"+(i+this.getFixedBottomRowCount())+"') must be smaller than numberOfVisibleRows('"+this.getVisibleRowCount()+"')",this);}return this;};
y.prototype.setFixedBottomRowCount=function(i){if(!(parseInt(i,10)>=0)){q.sap.log.error("Number of fixed bottom rows must be greater or equal 0",this);return this;}if((i+this.getFixedRowCount())<this.getVisibleRowCount()){this.setProperty("fixedBottomRowCount",i);this._updateBindingContexts();}else{q.sap.log.error("Table '"+this.getId()+"' fixed rows('"+(i+this.getFixedRowCount())+"') must be smaller than numberOfVisibleRows('"+this.getVisibleRowCount()+"')",this);}return this;};
y.prototype.setThreshold=function(i){this.setProperty("threshold",i,true);};
y.prototype._invalidateColumnMenus=function(){var j=this.getColumns();for(var i=0,l=j.length;i<l;i++){j[i].invalidateMenu();}};
y.prototype._isTouchMode=function(i){return!!i.originalEvent["touches"];};
y.prototype._determineParent=function(){var i=this.getParent();if(i){var j;if(i.getDomRef){j=i.getDomRef();}else if(i.getRootNode){j=i.getRootNode();}if(j){return q(j);}}return q();};
y.prototype._getRowTemplate=function(){if(!this._oRowTemplate){this._oRowTemplate=new m(this.getId()+"-rows");var j=this.getColumns();for(var i=0,l=j.length;i<l;i++){if(j[i].getVisible()){var z=j[i].getTemplate();if(z){var A=z.clone("col"+i);A.data("sap-ui-colindex",i);A.data("sap-ui-colid",j[i].getId());this._oRowTemplate.addCell(A);}}}}return this._oRowTemplate;};
y.prototype._getDummyRow=function(){if(!this._oDummyRow){this._oDummyRow=this._getRowTemplate().clone("dummy");this._oDummyRow._bDummyRow=true;this._oDummyRow._bHidden=true;}return this._oDummyRow;};
y.prototype._resetRowTemplate=function(){if(this._oRowTemplate){this._oRowTemplate.destroy();this._oRowTemplate=undefined;}if(this._oDummyRow){this._oDummyRow.destroy();this._oDummyRow=undefined;}};
y.prototype._adjustRows=function(j,l){if(isNaN(j)){return false;}if(T.isVariableRowHeightEnabled(this)){j=j+1;}var i;var z=this.getRows();if(!this._oRowTemplate&&z.length>0){this.destroyAggregation("rows",true);z=[];}if(j==z.length){return false;}for(i=z.length-1;i>=j;i--){this.removeAggregation("rows",i,true).destroy();}if(T.isVariableRowHeightEnabled(this)){this.setProperty("visibleRowCount",j-1,true);}else{this.setProperty("visibleRowCount",j,true);}this._ignoreInvalidateOfChildControls=true;var A;var B=this.getFirstVisibleRow();var H=0;var J=false;var K;var L=this.getBinding("rows");if(!l){K=this.getBindingInfo("rows");J=typeof this._updateTableCell==="function";A=this._getRowContexts(j);for(i=0;i<z.length;i++){H=B+i;this._updateRowBindingContext(z[i],A[i],K&&K.model,H,J,L);}}if(z.length<j){var O=this._getRowTemplate();for(i=z.length;i<j;i++){var Q=O.clone("row"+i);if(!l){H=B+i;this._updateRowBindingContext(Q,A[i],K&&K.model,H,J,L);}this.addAggregation("rows",Q,true);}}this._ignoreInvalidateOfChildControls=false;z=this.getRows();l=l||A.length==0;return this._insertTableRows(z,l);};
y.prototype._insertTableRows=function(j,z){var A=false;if(!this._bInvalid){this._detachEvents();var B=this.getDomRef("tableCCnt");j=j||this.getRows();if(!j.length||!B){return;}if(this.getVisibleRowCountMode()==V.Auto){var H=this.getDomRef();if(H){H.style.height="0px";}}var J=q.Event("BeforeRendering");J.setMarked("insertTableRows");J.srcControl=this;this._handleEvent(J);var K=new sap.ui.getCore().createRenderManager(),L=this.getRenderer();this._iDefaultRowHeight=undefined;L.renderTableCCnt(K,this);K.flush(B,false,false);K.destroy();J=q.Event("AfterRendering");J.setMarked("insertTableRows");J.srcControl=this;this._handleEvent(J);this._initRowDomRefs();this._getKeyboardExtension().invalidateItemNavigation();var O=this.getColumns();for(var i=0,l=O.length;i<l;i++){if(O[i].getVisible()){O[i]._restoreIcons();}}this._updateTableSizes();A=true;this._updateTableContent();this._attachEvents();}if(!z&&!this._bInvalid&&this.getBinding("rows")){var Q=this;if(this._mTimeouts._rowsUpdated){window.clearTimeout(this._mTimeouts._rowsUpdated);}this._mTimeouts._rowsUpdated=window.setTimeout(function(){Q.fireEvent("_rowsUpdated");},0);}return A;};
y.prototype._getDefaultRowHeight=function(i){if(T.isVariableRowHeightEnabled(this)){this._iDefaultRowHeight=this.getRowHeight()||28;}else{if(!this._iDefaultRowHeight&&this.getDomRef()){i=i||this._collectRowHeights();if(i&&i.length>0){this._iDefaultRowHeight=i[0];}}if(!this._iDefaultRowHeight){this._iDefaultRowHeight=28;}}return this._iDefaultRowHeight;};
y.prototype._setRowContentHeight=function(H){H=H||0;var i=this.getVisibleRowCountMode();var j=this.getVisibleRowCount();var l=this.getMinAutoRowCount();var z;var A=this._getDefaultRowHeight();if(i==V.Interactive||i==V.Fixed){if(this._iTableRowContentHeight&&i==V.Interactive){z=l*A;if(!H){H=this._iTableRowContentHeight;}}else{z=j*A;H=z;}}else if(i==V.Auto){z=l*A;}var B=Math.max(H,z);if((i==V.Fixed&&this.getRows().length==0)||i!=V.Fixed){this._iTableRowContentHeight=Math.floor(B/A)*A;}else{this._iTableRowContentHeight=undefined;}if(T.isVariableRowHeightEnabled(this)){var $=q(this.getDomRef("tableCCnt"));if(i==V.Fixed||i==V.Interactive){$.css("height",this._getDefaultRowHeight()*this.getVisibleRowCount()+"px");}else if(i==V.Auto){$.css("height",this._iTableRowContentHeight+"px");}}else{if((i==V.Fixed||i==V.Interactive)&&this.getRows().length>0){q(this.getDomRef("tableCtrlCnt")).css("height","auto");}else{q(this.getDomRef("tableCtrlCnt")).css("height",this._iTableRowContentHeight+"px");}}};
y.prototype._determineMinAutoRowCount=function(){var i=this.getVisibleRowCount();var j=this.getMinAutoRowCount();var l=j||i||5;if(this.getVisibleRowCountMode()==V.Interactive&&!this.bOutput){l=i||j||5;}return l;};
y.prototype._calculateRowsToDisplay=function(i){i=i||this._iTableRowContentHeight;var j=this.getVisibleRowCountMode();var l=0;if(j==V.Fixed){l=this.getVisibleRowCount()||0;}else if(j==V.Interactive||j==V.Auto){var z=this._determineMinAutoRowCount();var A=this._getDefaultRowHeight();if(!A||!i){l=z;}else{var B=Math.min(i,50000);var H=Math.floor(B/A);l=Math.max((this.getFixedRowCount()+this.getFixedBottomRowCount()+1),Math.max(z,H));}}return Math.max(l,0);};
y.prototype.setShowNoData=function(i){this.setProperty('showNoData',i,true);this._updateNoData();return this;};
y.prototype.exportData=function(j){var z=sap.ui.requireSync("sap/ui/core/util/Export");j=j||{};if(!j.rows){var B=this.getBinding("rows"),A=this.getBindingInfo("rows");var H=B.aFilters.concat(B.aApplicationFilters);j.rows={path:A.path,model:A.model,sorter:B.aSorters,filters:H,parameters:A.parameters};}if(!j.exportType){var J=sap.ui.requireSync("sap/ui/core/util/ExportTypeCSV");j.exportType=new J();}var K=j.rows.model;if(!K){var L=j.rows.path;var O=L.indexOf(">");if(O>0){K=L.substr(0,O);}}if(!j.columns){j.columns=[];var Q=this.getColumns();for(var i=0,l=Q.length;i<l;i++){var U=Q[i];if(U.getSortProperty()){j.columns.push({name:U.getLabel().getText(),template:{content:{path:U.getSortProperty(),model:K}}});}}}var W=new z(j);this.addDependent(W);return W;};
y.prototype._onPersoApplied=function(){var j=this.getColumns();var z=[];for(var i=0,l=j.length;i<l;i++){var A=j[i];if(A.getSorted()){z.push(new h(A.getSortProperty(),A.getSortOrder()===w.Descending));}}var B=this.getBinding("rows");if(B){if(z.length>0){B.sort(z);}this.refreshRows();}};
y.prototype._toggleSelectAll=function(){if(!this.$("selall").hasClass("sapUiTableSelAll")){this._iSourceRowIndex=-1;this.clearSelection();}else{this._iSourceRowIndex=0;this.selectAll();}if(!!D.browser.internet_explorer){this.$("selall").focus();}this._iSourceRowIndex=undefined;};
y.prototype._restoreAppDefaultsColumnHeaderSortFilter=function(){var i=this.getColumns();q.each(i,function(j,l){l._restoreAppDefaults();});};
y.prototype._setBusy=function(j){var B,i,l;if(!this.getEnableBusyIndicator()||!this._bBusyIndicatorAllowed){return;}B=this.getBinding("rows");if(!B){return;}this.setBusy(false);if(j&&this._iDataRequestedCounter>0){var z=j.reason;if(j.contexts&&j.contexts.length!==undefined){l=false;for(i=0;i<j.contexts.length;i++){if(j.contexts[i]===undefined){l=true;break;}}}else if(j.changeReason===e.Expand){this.setBusy(true);}var L=B.getLength();if((z==e.Expand&&this._iDataRequestedCounter!==0)||l||(B.isInitial())||(j.receivedLength===0&&this._iDataRequestedCounter!==0)||(j.receivedLength<j.requestedLength&&j.receivedLength!==L&&j.receivedLength!==L-this.getFirstVisibleRow())){this.setBusy(true);}}};
y.prototype.setBusy=function(B,i){var j=this.getBusy()!=B;i="sapUiTableCnt";var l=C.prototype.setBusy.call(this,B,i);if(j){this.fireBusyStateChanged({busy:B});}return l;};
y.prototype.setEnableBusyIndicator=function(i){this.setProperty("enableBusyIndicator",i,true);};
y.prototype._attachDataRequestedListeners=function(){var B=this.getBinding("rows");if(B){B.detachDataRequested(this._onBindingDataRequestedListener,this);B.detachDataReceived(this._onBindingDataReceivedListener,this);this._iDataRequestedCounter=0;B.attachDataRequested(this._onBindingDataRequestedListener,this);B.attachDataReceived(this._onBindingDataReceivedListener,this);}};
y.prototype._onBindingDataRequestedListener=function(i){if(i.getSource()==this.getBinding("rows")&&!i.getParameter("__simulateAsyncAnalyticalBinding")){this._iDataRequestedCounter++;}};
y.prototype._onBindingDataReceivedListener=function(i){if(i.getSource()==this.getBinding("rows")&&!i.getParameter("__simulateAsyncAnalyticalBinding")){this._iDataRequestedCounter--;}};
y.prototype._attachBindingListener=function(){this._attachDataRequestedListeners();};
y.prototype._setLargeDataScrolling=function(l){this._bLargeDataScrolling=!!l;};
y.prototype._getSelectedIndicesCount=function(){return this.getSelectedIndices().length;};
y.prototype._updateTableContent=function(){if(T.Grouping.isGroupMode(this)){var B=this.getBinding("rows"),i=this.getRows(),j=i.length;if(B){var l,z,A,H;for(var J=0;J<j;J++){l=i[J];A=J+this.getFirstVisibleRow();H=!!B.isGroupHeader(A);z=H?B.getTitle(A):"";T.Grouping.updateTableRowForGrouping(this,l,H,H?!!B.isExpanded(A):false,H,false,H?0:1,z);}}else{for(var J=0;J<j;J++){T.Grouping.cleanupTableRowForGrouping(this,i[J]);}}}};
return y;});
sap.ui.predefine('sap/ui/table/TableAccExtension',['jquery.sap.global','sap/ui/core/Control','./library','./TableExtension','./TableAccRenderExtension','./TableUtils'],function(q,C,l,T,a,b){"use strict";var S=l.SelectionMode;var A={getAccInfoOfControl:function(o,B){if(o&&typeof o.getAccessibilityInfo==="function"){if(typeof o.getVisible==="function"&&!o.getVisible()){return A._normalize({});}var s=o.getAccessibilityInfo();if(s){var t={};A._flatten(s,t,B);return t;}}return null;},_normalize:function(i){if(!i){return null;}if(i._normalized){return i;}i.role=i.role||"";i.type=i.type||"";i.description=i.description||"";i.focusable=!!i.focusable;i.enabled=(i.enabled===true||i.enabled===false)?i.enabled:null;i.editable=(i.editable===true||i.editable===false)?i.editable:null;i.children=i.children||[];i._normalized=true;return i;},_flatten:function(s,t,B,L){L=L?L:0;A._normalize(s);if(L==0){A._normalize(t);t._descriptions=[];}t.focusable=t.focusable||s.focusable;t._descriptions.push(A._getFullDescription(s,B));for(var i=0;i<s.children.length;i++){if(s.children[i]){A._flatten(s.children[i],t,B,L+1);}}if(L==0){t.description=t._descriptions.join(" ").trim();t._descriptions=undefined;}},_getFullDescription:function(i,B){var d=i.type+" "+i.description;if(i.enabled!=null&&!i.enabled){d=d+" "+B.getText("TBL_CTRL_STATE_DISABLED");}else if(i.editable!=null&&!i.editable){d=d+" "+B.getText("TBL_CTRL_STATE_READONLY");}return d.trim();}};var E={getInfoOfFocusedCell:function(e){var t=e.getTable();var i=t._getItemNavigation();var o=t.getDomRef();if(!e.getAccMode()||!o||!i){return null;}var d=i.getFocusedDomRef();if(!d||d!==document.activeElement){return null;}return b.getCellInfo(d);},isHiddenCell:function($){return $.parent().hasClass("sapUiTableRowHidden")||$.hasClass("sapUiTableCellHidden")||(b.isInGroupingRow($)&&$.hasClass("sapUiTableTdFirst")&&!$.hasClass("sapUiTableMeasureCell"));},isTreeColumnCell:function(e,$){return b.Grouping.isTreeMode(e.getTable())&&$.hasClass("sapUiTableTdFirst");},getColumnTooltip:function(o){if(!o){return null;}var t=o.getTooltip_AsString();if(t){return t;}var L=o.getLabel();if(L instanceof C){t=L.getTooltip_AsString();}if(t){return t;}return null;},updateRowColCount:function(e){var t=e.getTable(),i=t._getItemNavigation(),I=false,d=false,f=false;if(i){var g=b.getColumnIndexOfFocusedCell(t)+1;var r=b.getRowIndexOfFocusedCell(t)+t.getFirstVisibleRow()+1;var h=b.getVisibleColumnCount(t);var R=b.isNoDataVisible(t)?0:b.getTotalRowCount(t,true);I=e._iLastRowNumber!=r||(e._iLastRowNumber==r&&e._iLastColumnNumber==g);d=e._iLastColumnNumber!=g;f=!e._iLastRowNumber&&!e._iLastColumnNumber;t.$("rownumberofrows").text(I?t._oResBundle.getText("TBL_ROW_ROWCOUNT",[r,R]):" ");t.$("colnumberofcols").text(d?t._oResBundle.getText("TBL_COL_COLCOUNT",[g,h]):" ");t.$("ariacount").text(f?t._oResBundle.getText("TBL_DATA_ROWS_COLS",[R,h]):" ");e._iLastRowNumber=r;e._iLastColumnNumber=g;}return{rowChange:I,colChange:d,initial:f};},cleanupCellModifications:function(e){if(e._cleanupInfo){e._cleanupInfo.cell.attr(e._cleanupInfo.attr);e._cleanupInfo=null;}},storeDefaultsBeforeCellModifications:function(e,$,d,D){e._cleanupInfo={cell:$,attr:{"aria-labelledby":d&&d.length?d.join(" "):null,"aria-describedby":D&&D.length?D.join(" "):null}};},performCellModifications:function(e,$,d,D,L,f,t,g){E.storeDefaultsBeforeCellModifications(e,$,d,D);var o=E.updateRowColCount(e);e.getTable().$("cellacc").text(t||" ");if(g){g(L,f,o.rowChange,o.colChange,o.initial);}var s="";if(o.initial){var h=e.getTable();s=h.getAriaLabelledBy().join(" ")+" "+h.getId()+"-ariadesc "+h.getId()+"-ariacount";}if(L&&L.length){s=s+" "+L.join(" ");}$.attr({"aria-labelledby":s?s:null,"aria-describedby":f&&f.length?f.join(" "):null});},modifyAccOfDATACELL:function($,o){var t=this.getTable(),s=t.getId(),i=t._getItemNavigation();if(!i){return;}var r=b.getRowIndexOfFocusedCell(t),d=b.getColumnIndexOfFocusedCell(t),e=b.getRowColCell(t,r,d),I=null,h=E.isHiddenCell($),f=E.isTreeColumnCell(this,$),D=E.getAriaAttributesFor(this,c.ELEMENTTYPES.DATACELL,{index:d,column:e.column,fixed:b.isFixedColumn(t,d)})["aria-labelledby"]||[],g=[],L=[s+"-rownumberofrows",s+"-colnumberofcols"];if(b.isInGroupingRow($)){L.push(s+"-ariarowgrouplabel");L.push(s+"-rows-row"+r+"-groupHeader");}if(b.isInSumRow($)){var j=$.parent().data("sap-ui-level");if(j==0){L.push(s+"-ariagrandtotallabel");}else if(j>0){L.push(s+"-ariagrouptotallabel");L.push(s+"-rows-row"+r+"-groupHeader");}}L=L.concat(D);if(!h){I=A.getAccInfoOfControl(e.cell,t._oResBundle);L.push(I?(s+"-cellacc"):e.cell.getId());if(((!I||I.focusable)&&!this._readonly)||(f&&e.row&&e.row._bHasChildren)){g.push(s+"-toggleedit");}}var k=I?I.description:" ";if(f&&!h){var m=E.getAriaAttributesFor(this,c.ELEMENTTYPES.TREEICON,{row:e.row});if(m&&m["aria-label"]){k=m["aria-label"]+" "+k;}}E.performCellModifications(this,$,D,null,L,g,k,function(L,g,R,n,p){if(!h&&b.isRowSelectionAllowed(t)&&R){g.push(e.row.getId()+"-rowselecttext");}});},modifyAccOfROWHEADER:function($,o){var t=this.getTable(),s=t.getId(),g=b.isInGroupingRow($),d=b.isInSumRow($),r=t.getRows()[$.attr("data-sap-ui-rowindex")],D=E.getAriaAttributesFor(this,c.ELEMENTTYPES.ROWHEADER)["aria-labelledby"]||[],L=D.concat([s+"-rownumberofrows"]);if(!d&&!g){if($.attr("aria-selected")=="true"){L.push(s+"-ariarowselected");}if(!$.hasClass("sapUiTableRowHidden")){L.push(r.getId()+"-rowselecttext");}}if(g){L.push(s+"-ariarowgrouplabel");}if(d){var i=$.data("sap-ui-level");if(i==0){L.push(s+"-ariagrandtotallabel");}else if(i>0){L.push(s+"-ariagrouptotallabel");}}E.performCellModifications(this,$,D,null,L,null,null);},modifyAccOfCOLUMNHEADER:function($,o){var t=this.getTable(),d=sap.ui.getCore().byId($.attr("data-sap-ui-colid")),m=E.getAriaAttributesFor(this,c.ELEMENTTYPES.COLUMNHEADER,{headerId:$.attr("id"),column:d,index:$.attr("data-sap-ui-colindex")}),s=E.getColumnTooltip(d),L=[t.getId()+"-colnumberofcols"].concat(m["aria-labelledby"]);if(s){L.push(t.getId()+"-cellacc");}E.performCellModifications(this,$,m["aria-labelledby"],m["aria-describedby"],L,m["aria-describedby"],s);},modifyAccOfCOLUMNROWHEADER:function($,o){var m=E.getAriaAttributesFor(this,c.ELEMENTTYPES.COLUMNROWHEADER,{enabled:$.hasClass("sapUiTableSelAllEnabled")});E.performCellModifications(this,$,m["aria-labelledby"],m["aria-describedby"],m["aria-labelledby"],m["aria-describedby"],null);},getAriaAttributesFor:function(e,t,p){var m={},o=e.getTable(),s=o.getId();function d(o,r,O,u){var v="";if(O&&u){v="overlay,nodata";}else if(O&&!u){v="overlay";}else if(!O&&u){v="nodata";}var w=false;if(O&&o.getShowOverlay()||u&&b.isNoDataVisible(o)){w=true;}if(w){m["aria-hidden"]="true";}if(v){m["data-sap-ui-table-acc-covered"]=v;}}switch(t){case c.ELEMENTTYPES.COLUMNROWHEADER:m["aria-labelledby"]=[s+"-ariacolrowheaderlabel"];m["role"]=["columnheader"];if(p&&p.enabled){m["aria-labelledby"].push(s+"-ariaselectall");}break;case c.ELEMENTTYPES.ROWHEADER:m["aria-labelledby"]=[s+"-ariarowheaderlabel"];if(!b.Grouping.isTreeMode(o)){m["role"]=["rowheader"];}if(o.getSelectionMode()!==S.None){var f=p&&p.rowSelected;m["aria-selected"]=""+f;var g=e.getAriaTextsForSelectionMode(true);m["title"]=g.mouse[f?"rowDeselect":"rowSelect"];}break;case c.ELEMENTTYPES.COLUMNHEADER:var h=p&&p.column;var I=h&&h.getId()===p.headerId;m["role"]="columnheader";m["aria-labelledby"]=p&&p.headerId?[p.headerId]:[];if(h&&h._menuHasItems()){m["aria-haspopup"]="true";m["aria-describedby"]=[s+"-ariacolmenu"];}if(p&&(p.index<o.getFixedColumnCount())){m["aria-labelledby"].push(s+"-ariafixedcolumn");}if(I&&h.getSorted()){m["aria-sort"]=h.getSortOrder()==="Ascending"?"ascending":"descending";m["aria-labelledby"].push(s+(h.getSortOrder()==="Ascending"?"-ariacolsortedasc":"-ariacolsorteddes"));}if(I&&h.getFiltered()){m["aria-labelledby"].push(s+"-ariacolfiltered");}break;case c.ELEMENTTYPES.DATACELL:m["role"]="gridcell";if(p&&typeof p.index==="number"){m["headers"]=s+"_col"+p.index;}var L=[],h=p&&p.column?p.column:null;if(h){var M=h.getMultiLabels();var j=M.length;if(o.getColumnHeaderVisible()){var k=h.getId();L.push(k);if(j>1){for(var i=1;i<j;i++){L.push(k+"_"+i);}}}else{var n;if(j==0){n=h.getLabel();if(n){L.push(n.getId());}}else{for(var i=0;i<j;i++){n=M[i];if(n){L.push(n.getId());}}}}if(p&&p.fixed){L.push(s+"-ariafixedcolumn");}}m["aria-labelledby"]=L;if(b.Grouping.isTreeMode(o)&&p&&p.firstCol&&p.row){var B=o.mBindingInfos["rows"];if(p.row.getBindingContext(B&&B.model)){m["aria-level"]=p.row._iLevel+1;m["aria-expanded"]=""+p.row._bIsExpanded;}}break;case c.ELEMENTTYPES.ROOT:break;case c.ELEMENTTYPES.TABLE:m["role"]="presentation";d(o,m,true,true);break;case c.ELEMENTTYPES.CONTENT:m["role"]=b.Grouping.isGroupMode(o)||b.Grouping.isTreeMode(o)?"treegrid":"grid";m["aria-labelledby"]=[].concat(o.getAriaLabelledBy());if(o.getTitle()){m["aria-labelledby"].push(o.getTitle().getId());}if(o.getSelectionMode()===S.Multi||o.getSelectionMode()===S.MultiToggle){m["aria-multiselectable"]="true";}break;case c.ELEMENTTYPES.TABLEHEADER:m["role"]="heading";d(o,m,true,false);break;case c.ELEMENTTYPES.COLUMNHEADER_ROW:if(!b.hasRowHeader(o)){m["role"]="row";}d(o,m,true,false);break;case c.ELEMENTTYPES.ROWHEADER_COL:d(o,m,true,true);break;case c.ELEMENTTYPES.TH:var H=o.getFixedColumnCount()>0;m["role"]=H?"columnheader":"presentation";m["scope"]="col";if(H){if(p&&p.column){m["aria-owns"]=p.column.getId();m["aria-labelledby"]=[p.column.getId()];}}else{m["aria-hidden"]="true";}break;case c.ELEMENTTYPES.ROWHEADER_TD:m["role"]="rowheader";m["aria-labelledby"]=[s+"-ariarowheaderlabel"];m["headers"]=s+"-colsel";if(p&&typeof p.index==="number"){m["aria-owns"]=s+"-rowsel"+p.index;}if(o.getSelectionMode()!==S.None){var f=p&&p.rowSelected;m["aria-selected"]=""+f;}break;case c.ELEMENTTYPES.TR:m["role"]="row";var f=false;if(p&&typeof p.index==="number"&&o.getSelectionMode()!==S.None&&o.isIndexSelected(p.index)){m["aria-selected"]="true";f=true;}if(b.isRowSelectionAllowed(o)){var g=e.getAriaTextsForSelectionMode(true);m["title"]=g.mouse[f?"rowDeselect":"rowSelect"];}break;case c.ELEMENTTYPES.TREEICON:if(b.Grouping.isTreeMode(o)){m={"aria-label":"","title":"","role":""};if(o.getBinding("rows")){m["role"]="button";if(p&&p.row){if(p.row._bHasChildren){m["title"]=o._oResBundle.getText(p.row._bIsExpanded?"TBL_COLLAPSE":"TBL_EXPAND");}else{m["aria-label"]=o._oResBundle.getText("TBL_LEAF");}}}}break;case c.ELEMENTTYPES.NODATA:m["role"]="gridcell";var N=o.getNoData();m["aria-labelledby"]=[N instanceof C?N.getId():(s+"-noDataMsg")];d(o,m,true,false);break;case c.ELEMENTTYPES.OVERLAY:m["role"]="region";m["aria-labelledby"]=[].concat(o.getAriaLabelledBy());if(o.getTitle()){m["aria-labelledby"].push(o.getTitle().getId());}m["aria-labelledby"].push(s+"-ariainvalid");break;case c.ELEMENTTYPES.TABLEFOOTER:case c.ELEMENTTYPES.TABLESUBHEADER:d(o,m,true,false);break;}return m;}};
var c=T.extend("sap.ui.table.TableAccExtension",{
_init:function(t,s,m){this._accMode=sap.ui.getCore().getConfiguration().getAccessibility();this._readonly=s==T.TABLETYPES.ANALYTICAL?true:false;t.addEventDelegate(this);T.enrich(t,a);return"AccExtension";},
destroy:function(){this.getTable().removeEventDelegate(this);this._readonly=false;T.prototype.destroy.apply(this,arguments);},
_getAriaAttributesFor:function(t,p){return E.getAriaAttributesFor(this,t,p);},
onfocusin:function(e){var t=this.getTable();if(!t||!b.getCellInfo(e.target)){return;}if(t._mTimeouts._cleanupACCExtension){q.sap.clearDelayedCall(t._mTimeouts._cleanupACCExtension);t._mTimeouts._cleanupACCExtension=null;}this.updateAccForCurrentCell(true);},
onfocusout:function(e){var t=this.getTable();if(!t){return;}t._mTimeouts._cleanupACCExtension=q.sap.delayedCall(100,this,function(){var t=this.getTable();if(!t){return;}this._iLastRowNumber=null;this._iLastColumnNumber=null;E.cleanupCellModifications(this);t._mTimeouts._cleanupACCExtension=null;});}
});
c.ELEMENTTYPES={DATACELL:b.CELLTYPES.DATACELL,COLUMNHEADER:b.CELLTYPES.COLUMNHEADER,ROWHEADER:b.CELLTYPES.ROWHEADER,COLUMNROWHEADER:b.CELLTYPES.COLUMNROWHEADER,ROOT:"ROOT",CONTENT:"CONTENT",TABLE:"TABLE",TABLEHEADER:"TABLEHEADER",TABLEFOOTER:"TABLEFOOTER",TABLESUBHEADER:"TABLESUBHEADER",COLUMNHEADER_ROW:"COLUMNHEADER_ROW",ROWHEADER_COL:"ROWHEADER_COL",TH:"TH",ROWHEADER_TD:"ROWHEADER_TD",TR:"TR",TREEICON:"TREEICON",NODATA:"NODATA",OVERLAY:"OVERLAY"};
c.prototype.getAccMode=function(){return this._accMode;};
c.prototype.updateAccForCurrentCell=function(o){if(!this._accMode||!this.getTable()._getItemNavigation()){return;}var t=this.getTable();if(t._mTimeouts._cleanupACCFocusRefresh){q.sap.clearDelayedCall(t._mTimeouts._cleanupACCFocusRefresh);t._mTimeouts._cleanupACCFocusRefresh=null;}if(o){E.cleanupCellModifications(this);}var i=E.getInfoOfFocusedCell(this);if(!i||!i.cell||!i.type||!E["modifyAccOf"+i.type]){return;}if(!o){if(i.type===b.CELLTYPES.DATACELL||b.CELLTYPES.ROWHEADER){t._mTimeouts._cleanupACCFocusRefresh=q.sap.delayedCall(100,this,function($){var t=this.getTable();if(!t){return;}var i=E.getInfoOfFocusedCell(this);if(i&&i.cell&&i.type&&i.cell.get(0)&&$.get(0)===i.cell.get(0)){i.cell.blur().focus();}t._mTimeouts._cleanupACCFocusRefresh=null;},[i.cell]);}return;}E["modifyAccOf"+i.type].apply(this,[i.cell,o]);};
c.prototype.updateAriaStateOfColumn=function(o,r){if(!this._accMode){return;}var m=E.getAriaAttributesFor(this,c.ELEMENTTYPES.COLUMNHEADER,{headerId:o.getId(),column:o,index:this.getTable().indexOfColumn(o)});r=r?r:o.$();r.attr({"aria-sort":m["aria-sort"]||null,"aria-labelledby":m["aria-labelledby"]?m["aria-labelledby"].join(" "):null});};
c.prototype.updateAriaStateOfRow=function(r,R,i){if(!this._accMode){return;}if(!R){R=r.getDomRefs(true);}if(R.row){R.row.children("td").add(R.row).attr("aria-selected",i?"true":null);}};
c.prototype.updateAriaExpandAndLevelState=function(r,s,R,f,g,e,L,t){if(!this._accMode){return;}var d=null,o=this.getTable(),h=[s,s.children(),R,f,f?f.children():null],j=!!t,B=o.getBinding("rows");if(!g&&R&&!j){var I=R.attr("data-sap-ui-rowindex");var m=E.getAriaAttributesFor(this,c.ELEMENTTYPES.ROWHEADER,{rowSelected:!r._bHidden&&o.isIndexSelected(I)});d=m["title"]||null;}if(R&&!j){R.attr({"aria-haspopup":g?"true":null,"title":d});}if(B&&B.hasTotaledMeasures&&L>0&&(!B.bProvideGrandTotals||!B.hasTotaledMeasures())){L=L-1;}for(var i=0;i<h.length;i++){if(h[i]){h[i].attr({"aria-expanded":g?e+"":null,"aria-level":L<0?null:(L+1)});}}if(j){t.attr(E.getAriaAttributesFor(this,c.ELEMENTTYPES.TREEICON,{row:r}));}};
c.prototype.updateAriaStateForOverlayAndNoData=function(){var t=this.getTable();if(!t||!t.getDomRef()||!this._accMode){return;}if(t.getShowOverlay()){t.$().find("[data-sap-ui-table-acc-covered*='overlay']").attr("aria-hidden","true");}else{t.$().find("[data-sap-ui-table-acc-covered*='overlay']").removeAttr("aria-hidden");if(b.isNoDataVisible(t)){t.$().find("[data-sap-ui-table-acc-covered*='nodata']").attr("aria-hidden","true");}else{t.$().find("[data-sap-ui-table-acc-covered*='nodata']").removeAttr("aria-hidden");}}};
c.prototype.getAriaTextsForSelectionMode=function(d,s){var t=this.getTable();if(!s){s=t.getSelectionMode();}var r=t._oResBundle;var m={mouse:{rowSelect:"",rowDeselect:""},keyboard:{rowSelect:"",rowDeselect:""}};var i=t._getSelectedIndicesCount();if(s===S.Single){m.mouse.rowSelect=r.getText("TBL_ROW_SELECT");m.mouse.rowDeselect=r.getText("TBL_ROW_DESELECT");m.keyboard.rowSelect=r.getText("TBL_ROW_SELECT_KEY");m.keyboard.rowDeselect=r.getText("TBL_ROW_DESELECT_KEY");}else if(s===S.Multi){m.mouse.rowSelect=r.getText("TBL_ROW_SELECT_MULTI");m.mouse.rowDeselect=r.getText("TBL_ROW_DESELECT_MULTI");m.keyboard.rowSelect=r.getText("TBL_ROW_SELECT_MULTI_KEY");m.keyboard.rowDeselect=r.getText("TBL_ROW_DESELECT_MULTI_KEY");if(d===true){if(i===1){m.mouse.rowDeselect=r.getText("TBL_ROW_DESELECT");m.keyboard.rowDeselect=r.getText("TBL_ROW_DESELECT_KEY");}else if(i===0){m.mouse.rowSelect=r.getText("TBL_ROW_SELECT");m.keyboard.rowSelect=r.getText("TBL_ROW_SELECT_KEY");}}}else if(s===S.MultiToggle){m.mouse.rowSelect=r.getText("TBL_ROW_SELECT_MULTI_TOGGLE");m.mouse.rowDeselect=r.getText("TBL_ROW_DESELECT");m.keyboard.rowSelect=r.getText("TBL_ROW_SELECT_MULTI_TOGGLE_KEY");m.keyboard.rowDeselect=r.getText("TBL_ROW_DESELECT_KEY");if(d===true&&i===0){m.mouse.rowSelect=r.getText("TBL_ROW_SELECT");m.keyboard.rowSelect=r.getText("TBL_ROW_SELECT_KEY");}}return m;};
return c;});
sap.ui.predefine('sap/ui/table/TableAccRenderExtension',['jquery.sap.global','./TableExtension'],function(q,T){"use strict";var _=function(r,p,i,t,c){c=c||[];c.push("sapUiInvisibleText");r.write("<span");r.writeAttribute("id",p+"-"+i);r.writeAttribute("class",c.join(" "));r.writeAttribute("aria-hidden","true");r.write(">");if(t){r.writeEscaped(t);}r.write("</span>");};
var A=T.extend("sap.ui.table.TableAccRenderExtension",{
_init:function(t,s,S){return"AccRenderExtension";},
writeHiddenAccTexts:function(r,t){if(!t._getAccExtension().getAccMode()){return;}var b=t._oResBundle,s=t.getId();r.write("<div class='sapUiTableHiddenTexts' style='display:none;' aria-hidden='true'>");var d=t.getTitle()&&t.getTitle().getText&&t.getTitle().getText()!=""?t.getTitle().getText():"";_(r,s,"ariadesc",d);_(r,s,"ariacount");_(r,s,"toggleedit",b.getText("TBL_TOGGLE_EDIT_KEY"));_(r,s,"ariaselectall",b.getText("TBL_SELECT_ALL_KEY"));_(r,s,"ariarowheaderlabel",b.getText("TBL_ROW_HEADER_LABEL"));_(r,s,"ariarowgrouplabel",b.getText("TBL_ROW_GROUP_LABEL"));_(r,s,"ariagrandtotallabel",b.getText("TBL_GRAND_TOTAL_ROW"));_(r,s,"ariagrouptotallabel",b.getText("TBL_GROUP_TOTAL_ROW"));_(r,s,"ariacolrowheaderlabel",b.getText("TBL_ROW_COL_HEADER_LABEL"));_(r,s,"rownumberofrows");_(r,s,"colnumberofcols");_(r,s,"cellacc");_(r,s,"ariarowselected",b.getText("TBL_ROW_DESC_SELECTED"));_(r,s,"ariacolmenu",b.getText("TBL_COL_DESC_MENU"));_(r,s,"ariacolfiltered",b.getText("TBL_COL_DESC_FILTERED"));_(r,s,"ariacolsortedasc",b.getText("TBL_COL_DESC_SORTED_ASC"));_(r,s,"ariacolsorteddes",b.getText("TBL_COL_DESC_SORTED_DES"));_(r,s,"ariainvalid",b.getText("TBL_TABLE_INVALID"));if(t.getFixedColumnCount()>0){_(r,s,"ariafixedcolumn",b.getText("TBL_FIXED_COLUMN"));}r.write("</div>");},
writeAriaAttributesFor:function(r,t,s,p){var e=t._getAccExtension();if(!e.getAccMode()){return;}var a=e._getAriaAttributesFor(s,p);var v,k;for(k in a){v=a[k];if(q.isArray(v)){v=v.join(" ");}if(v){r.writeAttributeEscaped(k,v);}}},
writeAccRowSelectorText:function(r,t,R,i){if(!t._getAccExtension().getAccMode()){return"";}var I=t.isIndexSelected(i);var m=t._getAccExtension().getAriaTextsForSelectionMode(true);var s=m.keyboard[I?"rowDeselect":"rowSelect"];_(r,R.getId(),"rowselecttext",s,["sapUiTableAriaRowSel"]);}
});
return A;});
sap.ui.predefine('sap/ui/table/TableExtension',['jquery.sap.global','sap/ui/base/Object','./TableUtils'],function(q,B,T){"use strict";
var a=B.extend("sap.ui.table.TableExtension",{
constructor:function(t,s){B.call(this);this._table=t;this._settings=s||{};this._type=a.TABLETYPES.STANDARD;if(T.isInstanceOf(t,"sap/ui/table/TreeTable")){this._type=a.TABLETYPES.TREE;}else if(T.isInstanceOf(t,"sap/ui/table/AnalyticalTable")){this._type=a.TABLETYPES.ANALYTICAL;}var n=this._init(this._table,this._type,this._settings);if(n){var b=this;t["_get"+n]=function(){return b;};}},
destroy:function(){this._table=null;this._type=null;B.prototype.destroy.apply(this,arguments);},
getInterface:function(){return this;}
});
a.TABLETYPES={TREE:"TREE",ANALYTICAL:"ANALYTICAL",STANDARD:"STANDARD"};
a.prototype.getTable=function(){return this._table;};
a.prototype._init=function(t,s,S){return null;};
a.enrich=function(t,e,s){if(!e||!(e.prototype instanceof a)){return null;}var E=new e(t,s);return E;};
return a;});
sap.ui.predefine('sap/ui/table/TableGrouping',['jquery.sap.global','sap/ui/core/Element','sap/ui/model/Sorter','sap/ui/Device','./library'],function(q,E,S,D,l){"use strict";var T={TableUtils:null,clearMode:function(t){t._mode=null;},setGroupMode:function(t){t._mode="Group";},isGroupMode:function(t){return t._mode=="Group";},setTreeMode:function(t){t._mode="Tree";},isTreeMode:function(t){return t._mode=="Tree";},getModeCssClass:function(t){if(t._mode){return"sapUiTable"+t._mode+"Mode";}return null;},showGroupMenuButton:function(t){if(t._bShowGroupMenuButton===true||t._bShowGroupMenuButton===false){return t._bShowGroupMenuButton;}if(D.support.touch&&T.TableUtils.isInstanceOf(t,"sap/ui/table/AnalyticalTable")){t._bShowGroupMenuButton=true;}else{t._bShowGroupMenuButton=false;}return t._bShowGroupMenuButton;},toggleGroupHeader:function(t,r,e){var b=t.getBinding("rows");if(b){var i=b.isExpanded(r);if(e===true&&!i){b.expand(r);}else if(e===false&&i){b.collapse(r);}else if(e!==true&&e!==false){b.toggleIndex(r);}else{return null;}return!i;}return null;},_calcGroupIndent:function(t,L,c){if(T.TableUtils.isInstanceOf(t,"sap/ui/table/TreeTable")){var I=0;for(var i=0;i<L;i++){I=I+(i<2?12:8);}return I;}else if(T.TableUtils.isInstanceOf(t,"sap/ui/table/AnalyticalTable")){var I=0;L=L-1;L=!c?L-1:L;L=Math.max(L,0);for(var i=0;i<L;i++){if(I==0){I=12;}I=I+(i<2?12:8);}return I;}else{var I=0;L=!c?L-1:L;L=Math.max(L,0);for(var i=0;i<L;i++){I=I+(i<2?12:8);}return I;}},updateTableRowForGrouping:function(t,r,c,e,h,s,L,g){var d=r.getDomRefs(true),R=d.row,$=d.rowScrollPart,f=d.rowFixedPart,a=d.rowSelector;R.attr({"data-sap-ui-level":L});R.data("sap-ui-level",L);if(T.isGroupMode(t)){R.toggleClass("sapUiAnalyticalTableSum",!c&&s).toggleClass("sapUiAnalyticalTableDummy",false).toggleClass("sapUiTableGroupHeader",c).toggleClass("sapUiTableRowHidden",c&&h||r._bHidden);q.sap.byId(r.getId()+"-groupHeader").toggleClass("sapUiTableGroupIconOpen",c&&e).toggleClass("sapUiTableGroupIconClosed",c&&!e).attr("title",g||null).text(g||"");var i=T._calcGroupIndent(t,L,c);a.css(t._bRtlMode?"right":"left",i+"px");var F=R.find("td.sapUiTableTdFirst > .sapUiTableCell");F.css(t._bRtlMode?"padding-right":"padding-left",(i+8)+"px");}var b=null;if(T.isTreeMode(t)){b=R.find(".sapUiTableTreeIcon");b.css(t._bRtlMode?"margin-right":"margin-left",(L*17)+"px").toggleClass("sapUiTableTreeIconLeaf",!c).toggleClass("sapUiTableTreeIconNodeOpen",c&&e).toggleClass("sapUiTableTreeIconNodeClosed",c&&!e);}if(T.showGroupMenuButton(t)){var j=0;var k=t.$();if(k.hasClass("sapUiTableVScr")){j+=k.find('.sapUiTableVSb').width();}var G=a.find(".sapUiTableGroupMenuButton");if(t._bRtlMode){G.css("right",(k.width()-G.width()+a.position().left-j)+"px");}else{G.css("left",(k.width()-G.width()-a.position().left-j)+"px");}}t._getAccExtension().updateAriaExpandAndLevelState(r,$,a,f,c,e,L,b);},cleanupTableRowForGrouping:function(t,r){var d=r.getDomRefs(true);d.row.removeAttr("data-sap-ui-level");d.row.removeData("sap-ui-level");if(T.isGroupMode(t)){d.row.removeClass("sapUiTableGroupHeader sapUiAnalyticalTableSum sapUiAnalyticalTableDummy");d.rowSelector.css(t._bRtlMode?"right":"left","");var f=d.row.find("td.sapUiTableTdFirst > .sapUiTableCell");f.css(t._bRtlMode?"padding-right":"padding-left","");}var $=null;if(T.isTreeMode(t)){$=d.row.find(".sapUiTableTreeIcon");$.removeClass("sapUiTableTreeIconLeaf").removeClass("sapUiTableTreeIconNodeOpen").removeClass("sapUiTableTreeIconNodeClosed").css(this._bRtlMode?"margin-right":"margin-left","");}t._getAccExtension().updateAriaExpandAndLevelState(r,d.rowScrollPart,d.rowSelector,d.rowFixedPart,false,false,-1,$);},setupExperimentalGrouping:function(t){if(!t.getEnableGrouping()){return;}var b=E.prototype.getBinding.call(t,"rows");var g=sap.ui.getCore().byId(t.getGroupBy());var I=g&&g.getGrouped()&&b&&T.TableUtils.isInstanceOf(b,"sap/ui/model/ClientListBinding");if(!I||b._modified){return;}b._modified=true;T.setGroupMode(t);var p=g.getSortProperty();b.sort(new S(p));var L=b.getLength(),c=b.getContexts(0,L);var k;var C=0;for(var i=L-1;i>=0;i--){var n=c[i].getProperty(p);if(!k){k=n;}if(k!==n){var G=c[i+1].getModel().getContext("/sap.ui.table.GroupInfo"+i);G.__groupInfo={oContext:c[i+1],name:k,count:C,groupHeader:true,expanded:true};c.splice(i+1,0,G);k=n;C=0;}C++;}var G=c[0].getModel().getContext("/sap.ui.table.GroupInfo");G.__groupInfo={oContext:c[0],name:k,count:C,groupHeader:true,expanded:true};c.splice(0,0,G);q.extend(b,{getLength:function(){return c.length;},getContexts:function(s,L){return c.slice(s,s+L);},isGroupHeader:function(a){var o=c[a];return o&&o.__groupInfo&&o.__groupInfo.groupHeader;},getTitle:function(a){var o=c[a];return o&&o.__groupInfo&&o.__groupInfo.name+" - "+o.__groupInfo.count;},isExpanded:function(a){var o=c[a];return this.isGroupHeader(a)&&o.__groupInfo&&o.__groupInfo.expanded;},expand:function(a){if(this.isGroupHeader(a)&&!c[a].__groupInfo.expanded){for(var i=0;i<c[a].__childs.length;i++){c.splice(a+1+i,0,c[a].__childs[i]);}delete c[a].__childs;c[a].__groupInfo.expanded=true;this._fireChange();}},collapse:function(a){if(this.isGroupHeader(a)&&c[a].__groupInfo.expanded){c[a].__childs=c.splice(a+1,c[a].__groupInfo.count);c[a].__groupInfo.expanded=false;this._fireChange();}},toggleIndex:function(a){if(this.isExpanded(a)){this.collapse(a);}else{this.expand(a);}}});t._mTimeouts.groupingFireBindingChange=t._mTimeouts.groupingFireBindingChange||window.setTimeout(function(){b._fireChange();},0);},resetExperimentalGrouping:function(t){var b=t.getBinding("rows");if(b&&b._modified){T.clearMode(t);var B=t.getBindingInfo("rows");t.unbindRows();t.bindRows(B);}}};return T;},true);
sap.ui.predefine('sap/ui/table/TableKeyboardDelegate',['jquery.sap.global','sap/ui/base/Object','./library','./Row','./TableExtension','./TableUtils'],function(q,B,l,R,T,a){"use strict";var S=l.SelectionBehavior;
var b=B.extend("sap.ui.table.TableKeyboardDelegate",{
constructor:function(t){B.call(this);if(t===T.TABLETYPES.ANALYTICAL){this.onsapselect=function(e){if(q(e.target).hasClass("sapUiAnalyticalTableSum")){e.preventDefault();return;}else{if(b.prototype.onsapselect){b.prototype.onsapselect.apply(this,arguments);}}};}else if(t===T.TABLETYPES.TREE){this.onkeydown=function(e){b.prototype.onkeydown.apply(this,arguments);var $=q(e.target),c=$.closest('td');if(e.keyCode==q.sap.KeyCodes.TAB&&this._getKeyboardExtension().isInActionMode()&&c.find('.sapUiTableTreeIcon').length>0){if($.hasClass('sapUiTableTreeIcon')){if(!$.hasClass("sapUiTableTreeIconLeaf")){c.find(':sapFocusable:not(.sapUiTableTreeIcon)').first().focus();}}else{c.find('.sapUiTableTreeIcon:not(.sapUiTableTreeIconLeaf)').focus();}e.preventDefault();}};}},
destroy:function(){B.prototype.destroy.apply(this,arguments);},
getInterface:function(){return this;}
});
b._restoreFocusOnLastFocusedDataCell=function(t,e){var i=a.getFocusedItemInfo(t);var L=t._getKeyboardExtension()._getLastFocusedCellInfo();a.focusItem(t,i.cellInRow+(i.columnCount*L.row),e);};
b._getFocusedRowIndex=function(t){var i=a.getFocusedItemInfo(t);var f=i.cell;var c=i.columnCount;var s=i.cellInRow;var d=t.getFirstVisibleRow()+(f-s)/c;if(!t.getColumnHeaderVisible()){d++;}return d-1;};
b._isFocusedRowSelected=function(t){var s=b._getFocusedRowIndex(t);var i=t.isIndexSelected(s);var I=a.getFocusedItemInfo(t).columnCount==0;if(I){return i;}else{if(a.hasRowHeader(t)){return null;}else{return i;}}};
b.prototype.enterActionMode=function(A){var f=A.$Dom;var e=false;if(f.length>0){var t=f.filter(":sapTabbable");var E=this._getKeyboardExtension();if(t.length>0){e=true;var i=this._getItemNavigation();E._suspendItemNavigation();q(i.getFocusedDomRef()).attr("tabindex","-1");t.eq(0).focus();}if(E._getTableType()===T.TABLETYPES.TREE){var $=f.eq(0);if($.hasClass("sapUiTableTreeIcon")&&!$.hasClass("sapUiTableTreeIconLeaf")){e=true;$.attr("tabindex",0).focus();}}}return e;};
b.prototype.leaveActionMode=function(A){var e=A.event;var E=this._getKeyboardExtension();var i=this._getItemNavigation();E._resumeItemNavigation();q(i.getFocusedDomRef()).attr("tabindex","0");if(e){if(q(e.target).closest("td[tabindex='-1']").length>0){var I=q(i.aItemDomRefs).index(q(e.target).closest("td[tabindex='-1']").get(0));a.focusItem(this,I,null);}else{if(q.sap.containsOrEquals(this.$().find(".sapUiTableCCnt").get(0),e.target)){a.focusItem(this,i.getFocusedIndex(),null);}}}else{a.focusItem(this,i.getFocusedIndex(),null);}if(E._getTableType()===T.TABLETYPES.TREE){this.$().find(".sapUiTableTreeIcon").attr("tabindex",-1);}};
b.prototype.onmouseup=function(e){if(e.isMarked()){return;}var d=this.$().find(".sapUiTableCtrl td :focus");this._getKeyboardExtension().setActionMode(d.length>0,{$Dom:d,event:e});};
b.prototype.onfocusin=function(e){if(e.isMarked("sapUiTableIgnoreFocusIn")){return;}var $=q(e.target);if($.hasClass("sapUiTableOuterBefore")||$.hasClass("sapUiTableOuterAfter")||(e.target!=this.getDomRef("overlay")&&this.getShowOverlay())){this._getKeyboardExtension().setActionMode(false);this.$("overlay").focus();return;}else if($.hasClass("sapUiTableCtrlBefore")){this._getKeyboardExtension().setActionMode(false);var n=a.isNoDataVisible(this);if(!n||(n&&e.isMarked("sapUiTableInitItemNavigation")&&this.getColumnHeaderVisible())){var i=a.getFocusedItemInfo(this);a.focusItem(this,i.cellInRow,e);}else if(n){this._getKeyboardExtension()._setSilentFocus(this.$("noDataCnt"));}if(!n){e.preventDefault();}}else if($.hasClass("sapUiTableCtrlAfter")){this._getKeyboardExtension().setActionMode(false);b._restoreFocusOnLastFocusedDataCell(this,e);}};
b.prototype.onkeyup=function(e){if(!this._bEventSapSelect===true){return;}this._bEventSapSelect=false;if(e.keyCode!==q.sap.KeyCodes.ENTER&&e.keyCode!==q.sap.KeyCodes.SPACE&&e.keyCode!==q.sap.KeyCodes.F4||e.srcControl!==this&&q.inArray(e.srcControl,this.getRows())===-1&&q.inArray(e.srcControl,this.getColumns())===-1){return;}if(a.toggleGroupHeader(this,e.target)){e.preventDefault();return;}this._bShowMenu=true;this._onSelect(e);this._bShowMenu=false;e.preventDefault();};
b.prototype.onsapselect=function(){this._bEventSapSelect=true;};
b.prototype.onsapselectmodifiers=function(){this._bEventSapSelect=true;};
b.prototype.onsapspace=function(e){var $=q(e.target);if((a.isRowSelectionAllowed(this)&&e.srcControl instanceof R)||$.hasClass("sapUiTableRowHdr")||$.hasClass("sapUiTableColRowHdr")||$.hasClass("sapUiTableCol")){e.preventDefault();}};
b.prototype.onkeydown=function(e){var $=this.$();var A=this._getKeyboardExtension().isInActionMode();if(!A&&e.keyCode==q.sap.KeyCodes.F2||e.keyCode==q.sap.KeyCodes.ENTER){if($.find(".sapUiTableCtrl td:focus").length>0){this._getKeyboardExtension().setActionMode(true,{$Dom:$.find(".sapUiTableCtrl td:focus").find(":sapFocusable")});e.preventDefault();e.stopPropagation();}}else if(A&&e.keyCode==q.sap.KeyCodes.F2){this._getKeyboardExtension().setActionMode(false);}else if(e.keyCode==q.sap.KeyCodes.TAB&&A){if(this.getFixedColumnCount()>0){var c=q(e.target);if(c.is("td[role=gridcell]")==false){c=c.parents("td[role=gridcell]");}var d=c.parent("tr[data-sap-ui-rowindex]");var f=d.closest(".sapUiTableCtrl");var r=parseInt(d.attr("data-sap-ui-rowindex"),10);var g=d.find("td[role=gridcell]");var C=g.index(c);var t=g.length;if(C===(t-1)){var h;if(f.hasClass("sapUiTableCtrlFixed")){h=$.find(".sapUiTableCtrl.sapUiTableCtrlScroll");}else{h=$.find(".sapUiTableCtrl.sapUiTableCtrlFixed");r++;if(r==this.getVisibleRowCount()){r=0;}}var i=h.find("tr[data-sap-ui-rowindex='"+r+"']");var j=i.find("td :sapFocusable[tabindex='0']").first();if(j.length>0){j.focus();e.preventDefault();}}}}else if(e.keyCode==q.sap.KeyCodes.A&&(e.metaKey||e.ctrlKey)){var I=a.getFocusedItemInfo(this);this._toggleSelectAll();a.focusItem(this,I.cell,e);e.preventDefault();e.stopImmediatePropagation(true);}else if(e.keyCode===q.sap.KeyCodes.F10&&(e.shiftKey)){this.oncontextmenu(e);}else if(e.keyCode===q.sap.KeyCodes.NUMPAD_PLUS){a.toggleGroupHeader(this,e.target,true);}else if(e.keyCode===q.sap.KeyCodes.NUMPAD_MINUS){a.toggleGroupHeader(this,e.target,false);}};
b.prototype.onsapescape=function(e){this._getKeyboardExtension().setActionMode(false,{event:e});};
b.prototype.onsaptabprevious=function(e){var $=this.$();if(this._getKeyboardExtension().isInActionMode()){this._getKeyboardExtension().setActionMode(false);e.preventDefault();}else{if(e.target===this.getDomRef("overlay")){this._getKeyboardExtension()._setSilentFocus($.find(".sapUiTableOuterBefore"));return;}var i=a.getFocusedItemInfo(this);var n=a.isNoDataVisible(this);var s=$.find('.sapUiTableCCnt')[0];var f=q.contains(s,e.target);if(f&&this.getColumnHeaderVisible()){a.focusItem(this,i.cellInRow,e);e.preventDefault();}else if(i.domRef===e.target&&q.sap.containsOrEquals(s,e.target)||(!this.getColumnHeaderVisible()&&n&&f)){this._getKeyboardExtension()._setSilentFocus($.find(".sapUiTableCtrlBefore"));}}};
b.prototype.onsaptabnext=function(e){var $=this.$();if(this._getKeyboardExtension().isInActionMode()){this._getKeyboardExtension().setActionMode(false);e.preventDefault();}else{if(e.target===this.getDomRef("overlay")){this._getKeyboardExtension()._setSilentFocus($.find(".sapUiTableOuterAfter"));return;}var i=a.getFocusedItemInfo(this);var c=q.contains($.find('.sapUiTableColHdrCnt')[0],e.target);var n=a.isNoDataVisible(this);if(c&&!n){b._restoreFocusOnLastFocusedDataCell(this,e);e.preventDefault();}else if(i.domRef===e.target||(n&&c)){this._getKeyboardExtension()._setSilentFocus($.find(".sapUiTableCtrlAfter"));}}};
b.prototype.onsapdown=function(e){if(!this._getKeyboardExtension().isInActionMode()&&a.isLastScrollableRow(this,e.target)){if(this.getFirstVisibleRow()!=this._getRowCount()-this.getVisibleRowCount()){e.stopImmediatePropagation(true);a.scroll(this,true,false);}}e.preventDefault();if(a.isNoDataVisible(this)){var i=a.getCellInfo(e.target);if(i&&(i.type===a.CELLTYPES.COLUMNHEADER||i.type===a.CELLTYPES.COLUMNROWHEADER)){i=a.getFocusedItemInfo(this);if(i.row-a.getHeaderRowCount(this)<=1){e.setMarked("sapUiTableSkipItemNavigation");}}}};
b.prototype.onsapdownmodifiers=function(e){if(e.shiftKey){var f=b._getFocusedRowIndex(this);var i=b._isFocusedRowSelected(this);if(i===true){this.addSelectionInterval(f+1,f+1);}else if(i===false){this.removeSelectionInterval(f+1,f+1);}if(a.isLastScrollableRow(this,e.target)){a.scroll(this,true,false);}}else if(e.altKey){if(a.toggleGroupHeader(this,e.target)){e.preventDefault();e.setMarked("sapUiTableSkipItemNavigation");}}};
b.prototype.onsapupmodifiers=function(e){if(e.shiftKey){var f=b._getFocusedRowIndex(this);var i=b._isFocusedRowSelected(this);if(i===true){this.addSelectionInterval(f-1,f-1);}else if(i===false){this.removeSelectionInterval(f-1,f-1);}if(a.isFirstScrollableRow(this,e.target)){if(this.getFirstVisibleRow()!=0){e.stopImmediatePropagation(true);}a.scroll(this,false,false);}}else if(e.altKey){if(a.toggleGroupHeader(this,e.target)){e.preventDefault();e.setMarked("sapUiTableSkipItemNavigation");}}};
b.prototype.onsapup=function(e){if(!this._getKeyboardExtension().isInActionMode()&&a.isFirstScrollableRow(this,e.target)){if(this.getFirstVisibleRow()!=0){e.stopImmediatePropagation(true);}a.scroll(this,false,false);}e.preventDefault();};
b.prototype.onsappagedown=function(e){if(!this._getKeyboardExtension().isInActionMode()){var $=this.$();var i=a.getFocusedItemInfo(this);var r=(this.getSelectionBehavior()!==S.RowOnly);var h=$.find(".sapUiTableColHdrScr>.sapUiTableColHdr").length;if(this.getColumnHeaderVisible()&&i.cell<(i.columnCount*h)){var c=i.cellInRow;if((i.cell<=(i.columnCount*h)&&i.cell>=(i.columnCount*h)-i.columnCount)||(c===0&&r)){this.setFirstVisibleRow(0);a.focusItem(this,i.columnCount*h+c,e);}else{a.focusItem(this,i.columnCount*h-i.columnCount+c,e);}e.stopImmediatePropagation(true);}else{if(a.isLastScrollableRow(this,e.target)){a.scroll(this,true,true);}var f=this.getFixedBottomRowCount();if(this.getFirstVisibleRow()===this._getRowCount()-this.getVisibleRowCount()){f=0;}var d=(i.cellCount/i.columnCount)-f;var c=i.cell%i.columnCount;var I=(d-1)*i.columnCount+c;a.focusItem(this,I,e);e.stopImmediatePropagation(true);}e.preventDefault();}};
b.prototype.onsappagedownmodifiers=function(e){if(!this._getKeyboardExtension().isInActionMode()&&e.altKey){var i=a.getFocusedItemInfo(this);var r=(this.getSelectionBehavior()!==S.RowOnly);var c=i.columnCount;var n;if(c==0&&r){n=1;}else{var v=this._aVisibleColumns.length;var m=this._getVisibleColumns().length;if(!r){m--;}if(v===0){n=m;}else{n=Math.min(m,c+v);}}a.focusItem(this,i.cell-(c-n),e);e.stopImmediatePropagation(true);e.preventDefault();}};
b.prototype.onsappageup=function(e){if(!this._getKeyboardExtension().isInActionMode()){var $=this.$();var i=a.getFocusedItemInfo(this);var r=(this.getSelectionBehavior()!==S.RowOnly);var h=$.find(".sapUiTableColHdrScr>.sapUiTableColHdr").length;var c=i.cellInRow;if(this.getColumnHeaderVisible()&&i.cell<(i.columnCount*h)){if(i.cell>i.columnCount){a.focusItem(this,c,e);}e.stopImmediatePropagation(true);}else{if(this.getColumnHeaderVisible()&&this.getFirstVisibleRow()==0&&a.isFirstScrollableRow(this,e.target)){if(r&&c===0){a.focusItem(this,c,e);}else{a.focusItem(this,i.columnCount*h-i.columnCount+c,e);}e.stopImmediatePropagation(true);}else{var I=this.getColumnHeaderVisible()?i.columnCount*h:0;a.focusItem(this,I+c,e);e.stopImmediatePropagation(true);if(a.isFirstScrollableRow(this,e.target)){a.scroll(this,false,true);}}}e.preventDefault();}};
b.prototype.onsappageupmodifiers=function(e){if(!this._getKeyboardExtension().isInActionMode()&&e.altKey){var i=a.getFocusedItemInfo(this);var r=(this.getSelectionBehavior()!==S.RowOnly);var c=i.columnCount;if(c>0){var n;if(c==1&&r){n=0;}else{var v=this._aVisibleColumns.length;if(v===0){if(r){n=1;}else{n=0;}}else{var m=1;if(!r){m=0;}n=Math.max(m,c-v);}}a.focusItem(this,i.cell-(c-n),e);}e.stopImmediatePropagation(true);e.preventDefault();}};
b.prototype.onsaphome=function(e){var i=(this.getSelectionBehavior()==S.RowOnly);var I=q(e.target).parents(".sapUiTableGroupHeader").length>0;if(I){e.stopImmediatePropagation(true);return;}var o=a.getFocusedItemInfo(this);var f=o.cell;var s=o.cellInRow;var c=0;if(!i){c=1;}if(s>this.getFixedColumnCount()+c){e.stopImmediatePropagation(true);a.focusItem(this,f-s+this.getFixedColumnCount()+c,null);}else if(!i){if(s>1){e.stopImmediatePropagation(true);a.focusItem(this,f-s+1,null);}else if(s==1){e.stopImmediatePropagation(true);a.focusItem(this,f-1,null);}else{e.stopImmediatePropagation(true);}}};
b.prototype.onsapend=function(e){var i=q(e.target).parents(".sapUiTableGroupHeader").length>0;if(i){e.stopImmediatePropagation(true);return;}var I=a.getFocusedItemInfo(this);var f=I.cell;var s=I.cellInRow;var c=(this.getSelectionBehavior()!==S.RowOnly);var o=0;if(!c){o=1;}if(s===0&&c){e.stopImmediatePropagation(true);a.focusItem(this,f+1,null);}else if(s<this.getFixedColumnCount()-o){e.stopImmediatePropagation(true);a.focusItem(this,f-s+this.getFixedColumnCount()-o,null);}};
b.prototype.onsaphomemodifiers=function(e){if(e.metaKey||e.ctrlKey){var $=this.$();var t=$.find(".sapUiTableColHdrCnt")[0];var i=q.contains(t,e.target);if(i){e.stopImmediatePropagation(true);return;}var I=a.getFocusedItemInfo(this);var f=I.cell;var s=I.cellInRow;var c=I.columnCount;var d=Math.ceil(f/c)-1;if(this.getColumnHeaderVisible()){if(d==1){e.stopImmediatePropagation(true);a.focusItem(this,s,e);}else if(d>1){e.stopImmediatePropagation(true);this.setFirstVisibleRow(0);var g=s+c;a.focusItem(this,g,e);}}else{e.stopImmediatePropagation(true);this.setFirstVisibleRow(0);var g=f-d*c;a.focusItem(this,g,e);}}};
b.prototype.onsapendmodifiers=function(e){if(e.metaKey||e.ctrlKey){var $=this.$();var t=$.find(".sapUiTableColHdrCnt")[0];var i=q.contains(t,e.target);var I=a.getFocusedItemInfo(this);var f=I.cell;var c=I.columnCount;var s=I.cellInRow;e.stopImmediatePropagation(true);if(i){a.focusItem(this,f+c,e);}else{this.setFirstVisibleRow(this._getRowCount()-this.getVisibleRowCount());var d=I.cellCount-(c-s);a.focusItem(this,d,e);}}};
b.prototype.onsapleftmodifiers=function(e){var t=q(e.target);if(t.hasClass('sapUiTableCol')){var c=parseInt(t.attr('data-sap-ui-colindex'),10),v=this._getVisibleColumns(),C=v[this._aVisibleColumns.indexOf(c)];if(e.shiftKey){var n=parseInt(C.getWidth(),10)-16;C.setWidth((n>20?n:20)+"px");e.preventDefault();e.stopImmediatePropagation();}else if(e.ctrlKey||e.metaKey){if(c-1>=0){var N=0;for(var p=this._aVisibleColumns.indexOf(c)-1;p>=0;p--){N=this._aVisibleColumns[p];if(v[p].$().css("display")!=="none"){break;}}this.removeColumn(C);this.insertColumn(C,N);var h=C.getHeaderSpan();if(h>1){for(var i=1;i<h;i++){C=v[c+i];this.removeColumn(C);this.insertColumn(C,N+i);}}}e.preventDefault();e.stopImmediatePropagation();}}};
b.prototype.onsaprightmodifiers=function(e){var t=q(e.target);if(t.hasClass('sapUiTableCol')){var c=parseInt(t.attr('data-sap-ui-colindex'),10);var v=this._getVisibleColumns();var p=this._aVisibleColumns.indexOf(c);var C=v[p];if(e.shiftKey){C.setWidth(parseInt(C.getWidth(),10)+16+"px");e.preventDefault();e.stopImmediatePropagation();}else if(e.ctrlKey||e.metaKey){var h=C.getHeaderSpan();if(p<v.length-h){var n=v[p+1].getHeaderSpan(),N=this._aVisibleColumns[p+n];for(var i=h-1;i>=0;i--){C=v[p+i];this.removeColumn(C);this.insertColumn(C,N+i);}}e.preventDefault();e.stopImmediatePropagation();}}};
return b;},true);
sap.ui.predefine('sap/ui/table/TableKeyboardDelegate2',['jquery.sap.global','sap/ui/base/Object','./library','./TableExtension','./TableUtils'],function(q,B,l,T,a){"use strict";
var b=B.extend("sap.ui.table.TableKeyboardDelegate2",{
constructor:function(t){B.call(this);},
destroy:function(){B.prototype.destroy.apply(this,arguments);},
getInterface:function(){return this;}
});
b._restoreFocusOnLastFocusedDataCell=function(t,e){var i=a.getFocusedItemInfo(t);var L=t._getKeyboardExtension()._getLastFocusedCellInfo();a.focusItem(t,i.cellInRow+(i.columnCount*L.row),e);};
b._setFocusOnColumnHeaderOfLastFocusedDataCell=function(t,e){var i=a.getFocusedItemInfo(t);a.focusItem(t,i.cellInRow,e);};
b._forwardFocusToTabDummy=function(t,s){t._getKeyboardExtension()._setSilentFocus(t.$().find("."+s));};
b.prototype.onfocusin=function(e){if(e.isMarked("sapUiTableIgnoreFocusIn")){return;}var t=q(e.target);if(t.hasClass("sapUiTableCtrlBefore")){b._setFocusOnColumnHeaderOfLastFocusedDataCell(this,e);}else if(t.hasClass("sapUiTableCtrlAfter")){b._restoreFocusOnLastFocusedDataCell(this,e);}};
b.prototype.onsaptabnext=function(e){var i=a.getCellInfo(e.target)||{};if(i.type===a.CELLTYPES.COLUMNHEADER||i.type===a.CELLTYPES.COLUMNROWHEADER){b._restoreFocusOnLastFocusedDataCell(this,e);e.preventDefault();}else if(i.type===a.CELLTYPES.DATACELL||i.type===a.CELLTYPES.ROWHEADER){b._forwardFocusToTabDummy(this,"sapUiTableCtrlAfter");}};
b.prototype.onsaptabprevious=function(e){var i=a.getCellInfo(e.target)||{};if(i.type===a.CELLTYPES.DATACELL||i.type===a.CELLTYPES.ROWHEADER){if(this.getColumnHeaderVisible()){b._setFocusOnColumnHeaderOfLastFocusedDataCell(this,e);e.preventDefault();}else{b._forwardFocusToTabDummy(this,"sapUiTableCtrlBefore");}}};
b.prototype.onsapdown=function(e){var i=a.getCellInfo(e.target)||{};if(i.type===a.CELLTYPES.DATACELL||i.type===a.CELLTYPES.ROWHEADER){if(a.isLastScrollableRow(this,e.target)){var s=a.scroll(this,true,false);if(s){e.setMarked("sapUiTableSkipItemNavigation");}}}else if(i.type===a.CELLTYPES.COLUMNROWHEADER){if(this.getColumnHeaderVisible()&&this._getHeaderRowCount()>1){e.setMarked("sapUiTableSkipItemNavigation");a.focusItem(this,this._getHeaderRowCount()*(a.getVisibleColumnCount(this)+1),e);}}};
b.prototype.onsapup=function(e){var i=a.getCellInfo(e.target)||{};if(i.type===a.CELLTYPES.DATACELL||i.type===a.CELLTYPES.ROWHEADER){if(a.isFirstScrollableRow(this,e.target)){var s=a.scroll(this,false,false);if(s){e.setMarked("sapUiTableSkipItemNavigation");}}}};
return b;});
sap.ui.predefine('sap/ui/table/TableKeyboardExtension',['jquery.sap.global','./TableExtension','sap/ui/core/delegate/ItemNavigation','./TableUtils','./TableKeyboardDelegate'],function(q,T,I,a,b){"use strict";var c={_forward:function(t,o){var i=t._getItemNavigation();if(i&&!t._getKeyboardExtension()._itemNavigationSuspended&&!o.isMarked("sapUiTableSkipItemNavigation")){i["on"+o.type](o);}},onfocusin:function(o){c._forward(this,o);},onsapfocusleave:function(o){c._forward(this,o);},onmousedown:function(o){c._forward(this,o);},onsapnext:function(o){c._forward(this,o);},onsapnextmodifiers:function(o){c._forward(this,o);},onsapprevious:function(o){c._forward(this,o);},onsappreviousmodifiers:function(o){c._forward(this,o);},onsappageup:function(o){c._forward(this,o);},onsappagedown:function(o){c._forward(this,o);},onsaphome:function(o){c._forward(this,o);},onsaphomemodifiers:function(o){c._forward(this,o);},onsapend:function(o){c._forward(this,o);},onsapendmodifiers:function(o){c._forward(this,o);},onsapkeyup:function(o){c._forward(this,o);}};var E={onfocusin:function(o){var f=this._getKeyboardExtension();if(!f._bIgnoreFocusIn){f.initItemNavigation();if(d.isItemNavigationInvalid(this)){o.setMarked("sapUiTableInitItemNavigation");}}else{o.setMarked("sapUiTableIgnoreFocusIn");}if(o.target&&o.target.id===this.getId()+"-rsz"){o.preventDefault();o.setMarked("sapUiTableSkipItemNavigation");}}};var d={_initItemNavigation:function(o){var t=o.getTable();var $=t.$();var C=a.getVisibleColumnCount(t);var f=C;var h=a.hasRowHeader(t);var g=[];if(t.getFixedColumnCount()==0){g=$.find(".sapUiTableCtrl td[tabindex]").get();}else{var j=$.find('.sapUiTableCtrlFixed.sapUiTableCtrlRowFixed');var k=$.find('.sapUiTableCtrlScroll.sapUiTableCtrlRowFixed');var l=$.find('.sapUiTableCtrlFixed.sapUiTableCtrlRowScroll');var m=$.find('.sapUiTableCtrlScroll.sapUiTableCtrlRowScroll');var n=$.find('.sapUiTableCtrlFixed.sapUiTableCtrlRowFixedBottom');var p=$.find('.sapUiTableCtrlScroll.sapUiTableCtrlRowFixedBottom');for(var i=0;i<t.getVisibleRowCount();i++){g=g.concat(j.find('tr[data-sap-ui-rowindex="'+i+'"]').find('td[tabindex]').get());g=g.concat(k.find('tr[data-sap-ui-rowindex="'+i+'"]').find('td[tabindex]').get());g=g.concat(l.find('tr[data-sap-ui-rowindex="'+i+'"]').find('td[tabindex]').get());g=g.concat(m.find('tr[data-sap-ui-rowindex="'+i+'"]').find('td[tabindex]').get());g=g.concat(n.find('tr[data-sap-ui-rowindex="'+i+'"]').find('td[tabindex]').get());g=g.concat(p.find('tr[data-sap-ui-rowindex="'+i+'"]').find('td[tabindex]').get());}}var r=g.length;if(h){var R=$.find(".sapUiTableRowHdr").get();for(var i=R.length-1;i>=0;i--){g.splice(i*C,0,R[i]);r++;}r--;f++;}if(t.getColumnHeaderVisible()){var H=[];var F=$.find(".sapUiTableColHdrFixed").children();var s=$.find(".sapUiTableColHdrScr").children();for(var i=0;i<a.getHeaderRowCount(t);i++){if(h){H.push(t.getDomRef("selall"));}if(F.length){H=H.concat(q(F.get(i)).find(".sapUiTableCol").get());}if(s.length){H=H.concat(q(s.get(i)).find(".sapUiTableCol").get());}}g=H.concat(g);}if(!o._itemNavigation){o._itemNavigation=new I();o._itemNavigation.setTableMode(true);o._itemNavigation.attachEvent(I.Events.AfterFocus,function(u){var v=a.getFocusedItemInfo(t);v.header=a.getHeaderRowCount(t);v.domRef=null;if(v.row>=v.header){o._oLastFocusedCellInfo=v;}},t);}o._itemNavigation.setColumns(f);o._itemNavigation.setRootDomRef($.find(".sapUiTableCnt").get(0));o._itemNavigation.setItemDomRefs(g);o._itemNavigation.setFocusedIndex(d.getInitialItemNavigationIndex(o));o._itemNavigationInvalidated=false;},getInitialItemNavigationIndex:function(o){return a.hasRowHeader(o.getTable())?1:0;},isItemNavigationInvalid:function(o){return!o._itemNavigation||o._itemNavigationInvalidated;}};
var e=T.extend("sap.ui.table.TableKeyboardExtension",{
_init:function(t,s,S){this._itemNavigation=null;this._itemNavigationInvalidated=false;this._itemNavigationSuspended=false;this._type=s;this._delegate=new b(s);this._actionMode=false;t.addEventDelegate(E,t);t.addEventDelegate(this._delegate,t);t.addEventDelegate(c,t);var f=this;t._getItemNavigation=function(){return f._itemNavigation;};return"KeyboardExtension";},
destroy:function(){var t=this.getTable();if(t){t.removeEventDelegate(E);t.removeEventDelegate(this._delegate);t.removeEventDelegate(c);}if(this._itemNavigation){this._itemNavigation.destroy();this._itemNavigation=null;}if(this._delegate){this._delegate.destroy();this._delegate=null;}T.prototype.destroy.apply(this,arguments);}
});
e.prototype.initItemNavigation=function(){if(d.isItemNavigationInvalid(this)){d._initItemNavigation(this);}};
e.prototype.invalidateItemNavigation=function(){this._itemNavigationInvalidated=true;};
e.prototype.setActionMode=function(A,o){if(A&&!this._actionMode&&this._delegate.enterActionMode){this._actionMode=!!this._delegate.enterActionMode.apply(this.getTable(),[o||{}]);}else if(!A&&this._actionMode&&this._delegate.leaveActionMode){this._actionMode=false;this._delegate.leaveActionMode.apply(this.getTable(),[o||{}]);}};
e.prototype.isInActionMode=function(){return this._actionMode;};
e.prototype.updateNoDataAndOverlayFocus=function(p){var t=this.getTable();if(!t||!t.getDomRef()){return;}if(t.getShowOverlay()){if(q.sap.containsOrEquals(t.getDomRef(),p)){t.$("overlay").focus();}}else if(a.isNoDataVisible(t)){if(q.sap.containsOrEquals(t.getDomRef("sapUiTableCnt"),p)){t.$("noDataCnt").focus();}}else if(q.sap.containsOrEquals(t.getDomRef("noDataCnt"),p)||q.sap.containsOrEquals(t.getDomRef("overlay"),p)){a.focusItem(t,d.getInitialItemNavigationIndex(this));}};
e.prototype._suspendItemNavigation=function(){this._itemNavigationSuspended=true;};
e.prototype._resumeItemNavigation=function(){this._itemNavigationSuspended=false;};
e.prototype._getLastFocusedCellInfo=function(){var h=a.getHeaderRowCount(this.getTable());if(!this._oLastFocusedCellInfo||this._oLastFocusedCellInfo.header!=h){var i=a.getFocusedItemInfo(this.getTable());var D=d.getInitialItemNavigationIndex(this);return{cellInRow:D,row:h,header:h,cellCount:i.cellCount,columnCount:i.columnCount,cell:i.columnCount*h+D};}return this._oLastFocusedCellInfo;};
e.prototype._setSilentFocus=function(r){this._bIgnoreFocusIn=true;r.focus();this._bIgnoreFocusIn=false;};
e.prototype._getTableType=function(){return this._type;};
return e;},true);
sap.ui.predefine('sap/ui/table/TablePersoController',['jquery.sap.global','sap/ui/base/ManagedObject'],function(q,M){"use strict";
var T=M.extend("sap.ui.table.TablePersoController",{
constructor:function(i,s){M.apply(this,arguments);},
metadata:{properties:{"autoSave":{type:"boolean",defaultValue:true},"persoService":{type:"any"},"customDataKey":{type:"string",defaultValue:"persoKey"}},associations:{"table":{type:"sap.ui.table.Table",multiple:false}},library:"sap.ui.table"}
});
T.prototype.init=function(){this._schemaProperty="_persoSchemaVersion";this._schemaVersion="1.0";this._oInitialPersoData=null;this._aTableEvents=["columnResize","columnMove","columnVisibility","sort","filter","group"];this._aColumnProperties=["visible","width","sorted","sortOrder","grouped","summed"];this._bSaveFilters=false;if(this._bSaveFilters){this._aTableEvents.push("filter");this._aColumnProperties.push("filtered");this._aColumnProperties.push("filterValue");}};
T.prototype.exit=function(){var t=this._getTable();if(t){this._manageTableEventHandlers(t,false);}delete this._schemaProperty;delete this._schemaVersion;delete this._oInitialPersoData;delete this._oDialog;};
T.prototype.setPersoService=function(s){s=this.validateProperty("persoService",s);if(s&&(!q.isFunction(s.getPersData)||!q.isFunction(s.setPersData)||!q.isFunction(s.delPersData))){throw new Error("Value of property \"persoService\" needs to be null/undefined or an object that has the methods "+"\"getPersData\", \"setPersData\" and \"delPersData\".");}var o=this.getPersoService();this.setProperty("persoService",s,true);var n=this.getPersoService();if(n&&n!==o&&this._getTable()&&(this.getAutoSave()||!o)){this.refresh();}return this;};
T.prototype.setAutoSave=function(a){var o=this.getAutoSave();this.setProperty("autoSave",a,true);var n=this.getAutoSave();if(n&&!o){this.savePersonalizations();}return this;};
T.prototype.setTable=function(t){var o=this._getTable();if(o){o._oPersoController=undefined;}this.setAssociation("table",t,true);var n=this._getTable();if(n){n._oPersoController=this;}if(o){this._manageTableEventHandlers(o,false);}if(n&&n!==o){this._oInitialPersoData=this._getCurrentTablePersoData(true);this._manageTableEventHandlers(n,true);if(this.getPersoService()&&(this.getAutoSave()||!o)){this.refresh();}}else if(!n){this._oInitialPersoData=null;}return this;};
T.prototype.setCustomDataKey=function(c){var o=this.getCustomDataKey();this.setProperty("customDataKey",c,true);var n=this.getCustomDataKey();if(o!==n&&this.getAutoSave()){this.savePersonalizations();}return this;};
T.prototype._manageTableEventHandlers=function(t,a){for(var i=0,l=this._aTableEvents.length;i<l;i++){var f=t[(a?"attachEvent":"detachEvent")];f.apply(t,[this._aTableEvents[i],this._tableEventHandler,this]);}};
T.prototype.refresh=function(){var t=this;var s=this.getPersoService();if(s){return s.getPersData().done(function(S){var D=(S&&q.isArray(S.aColumns))?S:t._oInitialPersoData;t._adjustTable(D);}).fail(function(){q.sap.log.error("Problem reading persisted personalization data.");});}else{q.sap.log.error("The Personalization Service is not available!");var d=q.Deferred();d.reject();return d.promise();}};
T.prototype.savePersonalizations=function(){var s=this.getPersoService();if(s){var d=this._getCurrentTablePersoData();d[this._schemaProperty]=this._schemaVersion;return s.setPersData(d).fail(function(){q.sap.log.error("Problem persisting personalization data.");});}else{q.sap.log.error("The Personalization Service is not available!");var D=q.Deferred();D.reject();return D.promise();}};
T.prototype._adjustTable=function(d){var t=this._getTable();if(!t||!d||!q.isArray(d.aColumns)){return;}var c={},C=t.getColumns();for(var i=0,l=C.length;i<l;i++){c[this._getColumnPersoKey(C[i])]=C[i];}var a=d.aColumns;for(var i=0,l=a.length;i<l;i++){var o=a[i];var b=c[o.id];if(b){if(t.indexOfColumn(b)!==o.order){t.removeColumn(b);t.insertColumn(b,o.order);}var m=b.getMetadata();for(var j=0,e=this._aColumnProperties.length;j<e;j++){var p=this._aColumnProperties[j];if(o[p]!==undefined){try{if(m.hasProperty(p)&&b.getProperty(p)!=o[p]){b.setProperty(p,o[p]);}}catch(f){q.sap.log.error("sap.ui.table.TablePersoController: failed to apply the value \""+b[p]+"\" for the property + \""+p+"\".");}}}}}if(typeof t._onPersoApplied==="function"){t._onPersoApplied();}};
T.prototype._tableEventHandler=function(e){if(this.getAutoSave()&&!this._iTriggerSaveTimeout){var t=this;this._iTriggerSaveTimeout=setTimeout(function(){t.savePersonalizations();t._iTriggerSaveTimeout=null;},0);}};
T.prototype._getCurrentTablePersoData=function(f){var t=this._getTable(),c=t.getColumns();var d={aColumns:[]};for(var i=0,l=c.length;i<l;i++){var C=c[i];var p=this._getColumnPersoKey(C);var o={id:p,order:i};var m=C.getMetadata();for(var j=0,a=this._aColumnProperties.length;j<a;j++){var P=this._aColumnProperties[j];if(m.hasProperty(P)){o[P]=C.getProperty(P);}}if(f){o.text=C.getLabel()&&C.getLabel().getText()||p;}d.aColumns.push(o);}return d;};
T.prototype._getTable=function(){return sap.ui.getCore().byId(this.getTable());};
T.prototype._getColumnPersoKey=function(c){return this._getPersoKey(this._getTable())+"-"+this._getPersoKey(c);};
T.prototype._getPersoKey=function(c){var p=c.data(this.getCustomDataKey());if(!p){p=c.getId();if(p.indexOf(sap.ui.getCore().getConfiguration().getUIDPrefix())===0){q.sap.log.warning("Generated IDs should not be used as personalization keys! The stability cannot be ensured! (Control: \""+c.getId()+"\")");}}return p;};
T.prototype.openDialog=function(s){sap.ui.getCore().loadLibrary("sap.m");var a=sap.ui.requireSync("sap/m/TablePersoDialog");if(!this._oDialog){var t=this;this._oDialog=new a({persoService:this.getPersoService(),showSelectAll:true,showResetAll:true,grouping:false,contentWidth:s&&s.contentWidth,contentHeight:s&&s.contentHeight||"20rem",initialColumnState:this._oInitialPersoData.aColumns,columnInfoCallback:function(o,p,P){return t._getCurrentTablePersoData(true).aColumns;},confirm:function(){t._adjustTable(this.retrievePersonalizations());if(t.getAutoSave()){t.savePersonalizations();}}});this._oDialog._oDialog.removeStyleClass("sapUiPopupWithPadding");q.sap.syncStyleClass("sapUiSizeCompact",this._getTable(),this._oDialog._oDialog);}this._oDialog.open();};
return T;});
sap.ui.predefine('sap/ui/table/TablePointerExtension',['jquery.sap.global','./TableExtension','./TableUtils','sap/ui/Device'],function(q,T,a,D){"use strict";var C={initColumnResizing:function(t,e){if(t._bIsColumnResizerMoving){return;}t._bIsColumnResizerMoving=true;t.$().toggleClass("sapUiTableResizing",true);var d=q(document),c=t._isTouchMode(e);t._$colResize=t.$("rsz");t._iColumnResizeStart=C._getX(e,t);d.bind((c?"touchend":"mouseup")+".sapUiTableColumnResize",C.exitColumnResizing.bind(t));d.bind((c?"touchmove":"mousemove")+".sapUiTableColumnResize",C.onMouseMoveWhileColumnResizing.bind(t));t._disableTextSelection();},exitColumnResizing:function(e){C._resizeColumn(this,this._iLastHoveredColumnIndex);},onMouseMoveWhileColumnResizing:function(e){var l=C._getX(e,this);if(this._iColumnResizeStart&&l<this._iColumnResizeStart+3&&l>this._iColumnResizeStart-3){return;}if(this._isTouchMode(e)){e.stopPropagation();e.preventDefault();}this._$colResize.toggleClass("sapUiTableColRszActive",true);var c=this._getVisibleColumns()[this._iLastHoveredColumnIndex];var d=l-this._iColumnResizeStart;var w=Math.max(c.$().width()+d*(this._bRtlMode?-1:1),this._iColMinWidth);var r=this.$().find(".sapUiTableCnt").offset().left;var R=Math.floor((l-r)-(this._$colResize.width()/2));this._$colResize.css("left",R+"px");c._iNewWidth=w;},_cleanupColumResizing:function(t){if(t._$colResize){t._$colResize.toggleClass("sapUiTableColRszActive",false);t._$colResize=null;}t._iColumnResizeStart=null;t._bIsColumnResizerMoving=false;t.$().toggleClass("sapUiTableResizing",false);t._enableTextSelection();var d=q(document);d.unbind("touchmove.sapUiTableColumnResize");d.unbind("touchend.sapUiTableColumnResize");d.unbind("mousemove.sapUiTableColumnResize");d.unbind("mouseup.sapUiTableColumnResize");},_resizeColumn:function(t,c){var v=t._getVisibleColumns(),o,r=false;if(c>=0&&c<v.length){o=v[c];if(o._iNewWidth){var w;var A=t.$().find(".sapUiTableCtrl").width();if(!t._checkPercentageColumnWidth()){w=o._iNewWidth+"px";}else{var i=Math.round(100/A*o._iNewWidth);w=i+"%";}if(t._updateColumnWidth(o,w,true)){t._resizeDependentColumns(o,w);}delete o._iNewWidth;r=true;}}C._cleanupColumResizing(t);o.focus();if(r){t.invalidate();}},_getX:function(e,t){if(t._isTouchMode(e)){return e.targetTouches?e.targetTouches[0].pageX:e.originalEvent.targetTouches[0].pageX;}else{return e.pageX;}},doAutoResizeColumn:function(t,c){var v=t._getVisibleColumns(),o;if(c>=0&&c<v.length){o=v[c];if(!o.getAutoResizable()||!o.getResizable()){return;}var n=C._calculateAutomaticColumnWidth.apply(t,[o,c]);if(n){o._iNewWidth=n;C._resizeColumn(t,c);}}},_calculateAutomaticColumnWidth:function(c,d){function e(p){var t=["sap/m/Text","sap/m/Label","sap/m/Link","sap/m/Input","sap/ui/commons/TextView","sap/ui/commons/Label","sap/ui/commons/Link","sap/ui/commons/TextField"];var j=false;for(var i=0;i<t.length;i++){j=j||a.isInstanceOf(p,t[i]);}if(!j&&typeof b._fnCheckTextBasedControl==="function"&&b._fnCheckTextBasedControl(p)){j=true;}return j;}var $=this.$();var h=0;var f=$.find('td[headers=\"'+this.getId()+'_col'+d+'\"]').children("div");var H=c.getHeaderSpan();var o=c.getLabel();var g=c.getTemplate();var j=e(g);var k=document.createElement("div");document.body.appendChild(k);q(k).addClass("sapUiTableHiddenSizeDetector");var l=c.getMultiLabels();if(l.length==0&&!!o){l=[o];}if(l.length>0){q.each(l,function(p,L){var r;if(!!L.getText()){q(k).text(L.getText());h=k.scrollWidth;}else{h=L.$().scrollWidth;}h=h+$.find("#"+c.getId()+"-icons").first().width();$.find(".sapUiTableColIcons#"+c.getId()+"_"+p+"-icons").first().width();if(H instanceof Array&&H[p]>1){r=H[p];}else if(H>1){r=H;}if(!!r){var i=r-1;while(i>d){h=h-(this._getVisibleColumns()[d+i].$().width()||0);i-=1;}}});}var m=Math.max.apply(null,f.map(function(){var _=q(this);return parseInt(_.css('padding-left'),10)+parseInt(_.css('padding-right'),10)+parseInt(_.css('margin-left'),10)+parseInt(_.css('margin-right'),10);}).get());var n=Math.max.apply(null,f.children().map(function(){var w=0,W=0;var _=q(this);var s=_.text()||_.val();if(j){q(k).text(s);W=k.scrollWidth;}else{W=this.scrollWidth;}if(h>W){W=h;}w=W+parseInt(_.css('margin-left'),10)+parseInt(_.css('margin-right'),10)+m+1;return w;}).get());q(k).remove();return Math.max(n,this._iColMinWidth);},initColumnTracking:function(t){t.$().find(".sapUiTableCtrlScr, .sapUiTableCtrlScrFixed, .sapUiTableColHdrScr, .sapUiTableColHdrFixed").mousemove(function(e){var d=this.getDomRef();if(!d||this._bIsColumnResizerMoving){return;}var p=e.clientX,c=d.getBoundingClientRect(),l=0,r=this._bRtlMode?10000:-10000;for(var i=0;i<this._aTableHeaders.length;i++){var o=this._aTableHeaders[i].getBoundingClientRect();if(this._bRtlMode){if(p<o.right-5){l=i;r=o.left-c.left;}}else{if(p>o.left+5){l=i;r=o.right-c.left;}}}var f=this._getVisibleColumns()[l];if(f&&f.getResizable()){this.$("rsz").css("left",r+"px");this._iLastHoveredColumnIndex=l;}}.bind(t));}};var I={initInteractiveResizing:function(t,e){var B=q(document.body),s=t.$("sb"),d=q(document),o=s.offset(),h=s.height(),w=s.width(),c=t._isTouchMode(e);B.bind("selectstart",I.onSelectStartWhileInteractiveResizing);B.append("<div id=\""+t.getId()+"-ghost\" class=\"sapUiTableInteractiveResizerGhost\" style =\" height:"+h+"px; width:"+w+"px; left:"+o.left+"px; top:"+o.top+"px\" ></div>");s.append("<div id=\""+t.getId()+"-rzoverlay\" style =\"left: 0px; right: 0px; bottom: 0px; top: 0px; position:absolute\" ></div>");d.bind((c?"touchend":"mouseup")+".sapUiTableInteractiveResize",I.exitInteractiveResizing.bind(t));d.bind((c?"touchmove":"mousemove")+".sapUiTableInteractiveResize",I.onMouseMoveWhileInteractiveResizing.bind(t));t._disableTextSelection();},exitInteractiveResizing:function(e){var B=q(document.body),d=q(document),t=this.$(),g=this.$("ghost"),l=I._getY(e,this);var n=l-t.find(".sapUiTableCCnt").offset().top-g.height()-t.find(".sapUiTableFtr").height();this._setRowContentHeight(n);this._adjustRows(this._calculateRowsToDisplay(n));g.remove();this.$("rzoverlay").remove();B.unbind("selectstart",I.onSelectStartWhileInteractiveResizing);d.unbind("touchend.sapUiTableInteractiveResize");d.unbind("touchmove.sapUiTableInteractiveResize");d.unbind("mouseup.sapUiTableInteractiveResize");d.unbind("mousemove.sapUiTableInteractiveResize");this._enableTextSelection();},onSelectStartWhileInteractiveResizing:function(e){e.preventDefault();e.stopPropagation();return false;},onMouseMoveWhileInteractiveResizing:function(e){var l=I._getY(e,this);var m=this.$().offset().top;if(l>m){this.$("ghost").css("top",l+"px");}},_getY:function(e,t){if(t._isTouchMode(e)){return e.targetTouches?e.targetTouches[0].pageY:e.originalEvent.targetTouches[0].pageY;}else{return e.pageY;}}};var E={onmousedown:function(e){this._getKeyboardExtension().initItemNavigation();if(e.button===0){if(e.target===this.getDomRef("sb")){I.initInteractiveResizing(this,e);}else if(e.target===this.getDomRef("rsz")){C.initColumnResizing(this,e);}else if(q(e.target).hasClass("sapUiTableColResizer")){var c=q(e.target).closest(".sapUiTableCol").attr("data-sap-ui-colindex");this._iLastHoveredColumnIndex=parseInt(c,10);C.initColumnResizing(this,e);}}},onmouseup:function(e){q.sap.clearDelayedCall(this._mTimeouts.delayedActionTimer);},ondblclick:function(e){if(D.system.desktop&&e.target===this.getDomRef("rsz")){e.preventDefault();C.doAutoResizeColumn(this,this._iLastHoveredColumnIndex);}},onclick:function(e){q.sap.clearDelayedCall(this._mTimeouts.delayedActionTimer);if(e.isMarked()){return;}var t=q(e.target);if(t.hasClass("sapUiAnalyticalTableSum")){e.preventDefault();return;}else if(t.hasClass("sapUiTableGroupMenuButton")){this._onContextMenu(e);e.preventDefault();return;}else if(t.hasClass("sapUiTableGroupIcon")||t.hasClass("sapUiTableTreeIcon")){if(a.toggleGroupHeader(this,e.target)){return;}}if(!this._findAndfireCellEvent(this.fireCellClick,e)){this._onSelect(e);}else{e.preventDefault();}}};
var b=T.extend("sap.ui.table.TablePointerExtension",{
_init:function(t,s,S){this._type=s;this._delegate=E;t.addEventDelegate(this._delegate,t);t._iLastHoveredColumnIndex=0;t._bIsColumnResizerMoving=false;return"PointerExtension";},
destroy:function(){var t=this.getTable();if(t){t.removeEventDelegate(this._delegate);}this._delegate=null;T.prototype.destroy.apply(this,arguments);},
doAutoResizeColumn:function(c){var t=this.getTable();if(t){C.doAutoResizeColumn(t,c);}},
initColumnResizeEvents:function(){var t=this.getTable();if(t){C.initColumnTracking(t);}},
cleanupColumnResizeEvents:function(){var t=this.getTable();if(t){t.$().find(".sapUiTableCtrlScr, .sapUiTableCtrlScrFixed, .sapUiTableColHdrScr, .sapUiTableColHdrFixed").unbind();}}
});
return b;},true);
sap.ui.predefine('sap/ui/table/TableRenderer',['jquery.sap.global','sap/ui/core/Control','sap/ui/core/library','sap/ui/core/theming/Parameters','sap/ui/Device','./library','./TableUtils','sap/ui/core/Renderer','sap/ui/core/IconPool'],function(q,C,c,P,D,a,T,R,I){"use strict";var N=a.NavigationMode,S=a.SelectionMode,V=a.VisibleRowCountMode;var b={};
b.render=function(r,t){r.write("<div");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"ROOT");r.writeControlData(t);r.addClass("sapUiTable");if('ontouchstart'in document){r.addClass("sapUiTableTouch");}r.addClass("sapUiTableSelMode"+t.getSelectionMode());if(t.getColumnHeaderVisible()){r.addClass("sapUiTableCHdr");}if(T.hasRowHeader(t)){r.addClass("sapUiTableRSel");}var s=a.TableHelper.addTableClass();if(s){r.addClass(s);}if(t._isVSbRequired()){r.addClass("sapUiTableVScr");}if(t.getEditable()){r.addClass("sapUiTableEdt");}if(T.isNoDataVisible(t)){r.addClass("sapUiTableEmpty");}if(t.getShowOverlay()){r.addClass("sapUiTableOverlay");}var m=T.Grouping.getModeCssClass(t);if(m){r.addClass(m);}if(t.getWidth()){r.addStyle("width",t.getWidth());}if(t.getVisibleRowCountMode()==V.Auto){r.addStyle("height","0px");if(t._bFirstRendering){r.addClass("sapUiTableNoOpacity");}}r.writeClasses();r.writeStyles();r.write(">");this.renderTabElement(r,"sapUiTableOuterBefore");if(t.getTitle()){this.renderHeader(r,t,t.getTitle());}if(t.getToolbar()){this.renderToolbar(r,t,t.getToolbar());}if(t.getExtension()&&t.getExtension().length>0){this.renderExtensions(r,t,t.getExtension());}r.write("<div");r.writeAttribute("id",t.getId()+"-sapUiTableCnt");r.addClass("sapUiTableCnt");r.writeClasses();t._getAccRenderExtension().writeAriaAttributesFor(r,t,"CONTENT");r.writeAttribute("data-sap-ui-fastnavgroup","true");r.write(">");this.renderColRsz(r,t);this.renderColHdr(r,t);this.renderTable(r,t);t._getAccRenderExtension().writeHiddenAccTexts(r,t);r.write("<div");r.addClass("sapUiTableOverlayArea");r.writeClasses();r.writeAttribute("tabindex","0");r.writeAttribute("id",t.getId()+"-overlay");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"OVERLAY");r.write("></div>");r.write("</div>");if(t.getNavigationMode()===N.Paginator){r.write("<div");r.addClass("sapUiTablePaginator");r.writeClasses();r.write(">");if(!t._oPaginator){var d=sap.ui.requireSync("sap/ui/commons/Paginator");t._oPaginator=new d(t.getId()+"-paginator");t._oPaginator.attachPage(q.proxy(t.onpscroll,t));}r.renderControl(t._oPaginator);r.write("</div>");}if(t.getFooter()){this.renderFooter(r,t,t.getFooter());}if(t.getVisibleRowCountMode()==V.Interactive){this.renderVariableHeight(r,t);}this.renderTabElement(r,"sapUiTableOuterAfter");r.write("</div>");};
b.renderHeader=function(r,t,o){r.write("<div");r.addClass("sapUiTableHdr");r.writeClasses();t._getAccRenderExtension().writeAriaAttributesFor(r,t,"TABLEHEADER");r.write(">");r.renderControl(o);r.write("</div>");};
b.renderToolbar=function(r,t,o){r.write("<div");r.addClass("sapUiTableTbr");if(typeof o.getStandalone!=="function"){r.addClass("sapUiTableMTbr");}r.writeClasses();t._getAccRenderExtension().writeAriaAttributesFor(r,t,"TABLESUBHEADER");r.write(">");if(typeof o.getStandalone==="function"&&o.getStandalone()){o.setStandalone(false);}var d=sap.ui.require("sap/m/Toolbar");if(d&&o instanceof d){o.setDesign(P.get("sapUiTableToolbarDesign"),true);}r.renderControl(o);r.write("</div>");};
b.renderExtensions=function(r,t,e){for(var i=0,l=e.length;i<l;i++){this.renderExtension(r,t,e[i]);}};
b.renderExtension=function(r,t,e){r.write("<div");r.addClass("sapUiTableExt");r.writeClasses();t._getAccRenderExtension().writeAriaAttributesFor(r,t,"TABLESUBHEADER");r.write(">");r.renderControl(e);r.write("</div>");};
b.renderTable=function(r,t){r.write("<div");r.writeAttribute("id",t.getId()+"-tableCCnt");r.addClass("sapUiTableCCnt");r.writeClasses();r.write(">");this.renderTableCCnt(r,t);r.write("</div>");this.renderHSb(r,t);};
b.renderTableCCnt=function(r,t){this.renderTabElement(r,"sapUiTableCtrlBefore");this.renderTableCtrl(r,t);this.renderRowHdr(r,t);this.renderVSb(r,t);this.renderTabElement(r,"sapUiTableCtrlAfter");r.write("<div");r.addClass("sapUiTableCtrlEmpty");r.writeClasses();r.writeAttribute("tabindex","0");r.writeAttribute("id",t.getId()+"-noDataCnt");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"NODATA");r.write(">");if(t.getNoData()instanceof C){r.renderControl(t.getNoData());}else{r.write("<span");r.writeAttribute("id",t.getId()+"-noDataMsg");r.addClass("sapUiTableCtrlEmptyMsg");r.writeClasses();r.write(">");r.writeEscaped(T.getNoDataText(t));r.write("</span>");}r.write("</div>");};
b.renderFooter=function(r,t,f){r.write("<div");r.addClass("sapUiTableFtr");r.writeClasses();t._getAccRenderExtension().writeAriaAttributesFor(r,t,"TABLEFOOTER");r.write(">");r.renderControl(f);r.write("</div>");};
b.renderVariableHeight=function(r,t){r.write('<div id="'+t.getId()+'-sb" tabIndex="-1"');r.addClass("sapUiTableHeightResizer");r.addStyle("height","5px");r.writeClasses();r.writeStyles();r.write(">");r.write("</div>");};
b.renderColHdr=function(r,t){r.write("<div");r.addClass("sapUiTableColHdrCnt");r.writeClasses();if(t.getColumnHeaderHeight()>0){r.addStyle("height",(t.getColumnHeaderHeight()*T.getHeaderRowCount(t))+"px");}t._getAccRenderExtension().writeAriaAttributesFor(r,t,"COLUMNHEADER_ROW");r.writeStyles();r.write(">");this.renderColRowHdr(r,t);var d=t.getColumns();var f=t.getFixedColumnCount();var F=t._getColumnsWidth(0,f);if(f>0){r.write("<div");r.addClass("sapUiTableColHdrFixed");r.addClass("sapUiTableNoOpacity");r.writeClasses();r.write(">");for(var h=0;h<T.getHeaderRowCount(t);h++){r.write("<div");r.addClass("sapUiTableColHdr");r.addClass("sapUiTableNoOpacity");r.writeClasses();r.addStyle("min-width",F+"px");r.writeStyles();r.write(">");var s=1;for(var i=0,l=t.getFixedColumnCount();i<l;i++){if(d[i]&&d[i].shouldRender()){if(s<=1){this.renderCol(r,t,d[i],i,h);var H=d[i].getHeaderSpan();if(q.isArray(H)){s=d[i].getHeaderSpan()[h]+1;}else{s=parseInt(d[i].getHeaderSpan(),10)+1;}}else{this.renderCol(r,t,d[i],i,h,true);}s--;}}r.write("</div>");}r.write("</div>");}r.write("<div");r.writeAttribute("id",t.getId()+"-sapUiTableColHdrScr");r.addClass("sapUiTableColHdrScr");if(d.length==0){r.addClass("sapUiTableHasNoColumns");}r.writeClasses();if(t.getFixedColumnCount()>0){if(t._bRtlMode){r.addStyle("margin-right","0");}else{r.addStyle("margin-left","0");}r.writeStyles();}r.write(">");for(var h=0;h<T.getHeaderRowCount(t);h++){r.write("<div");r.addClass("sapUiTableColHdr");r.addClass("sapUiTableNoOpacity");r.writeClasses();r.write(">");var s=1;for(var i=f,l=d.length;i<l;i++){if(d[i].shouldRender()){if(s<=1){this.renderCol(r,t,d[i],i,h);var H=d[i].getHeaderSpan();if(q.isArray(H)){s=d[i].getHeaderSpan()[h]+1;}else{s=parseInt(d[i].getHeaderSpan(),10)+1;}}else{this.renderCol(r,t,d[i],i,h,true);}s--;}}r.write("</div>");}r.write("</div>");r.write("</div>");};
b.renderColRowHdr=function(r,t){r.write("<div");r.writeAttribute("id",t.getId()+"-selall");var s=t.getSelectionMode();var e=false;if((s=="Multi"||s=="MultiToggle")&&t.getEnableSelectAll()){r.writeAttributeEscaped("title",t._oResBundle.getText("TBL_SELECT_ALL"));if(t._getSelectableRowCount()==0||t._getSelectableRowCount()!==t.getSelectedIndices().length){r.addClass("sapUiTableSelAll");}r.addClass("sapUiTableSelAllEnabled");e=true;}else{r.addClass("sapUiTableSelAllDisabled");}r.addClass("sapUiTableColRowHdr");r.writeClasses();r.writeAttribute("tabindex","-1");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"COLUMNROWHEADER",{enabled:e});r.write(">");if(t.getSelectionMode()!==S.Single){r.write("<div");r.addClass("sapUiTableColRowHdrIco");r.writeClasses();if(t.getColumnHeaderHeight()>0){r.addStyle("height",t.getColumnHeaderHeight()+"px");}r.write(">");r.write("</div>");}r.write("</div>");};
b.renderCol=function(r,t,o,i,h,d){var l;if(o.getMultiLabels().length>0){l=o.getMultiLabels()[h];}else if(h==0){l=o.getLabel();}r.write("<div");var H=o.getId();if(h===0){r.writeElementData(o);}else{H=H+"_"+h;r.writeAttribute('id',H);}r.writeAttribute('data-sap-ui-colid',o.getId());r.writeAttribute("data-sap-ui-colindex",i);r.writeAttribute("tabindex","-1");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"COLUMNHEADER",{column:o,headerId:H,index:i});r.addClass("sapUiTableCol");if(t.getFixedColumnCount()===i+1){r.addClass("sapUiTableColLastFixed");}r.writeClasses();r.addStyle("width",o.getWidth());if(t.getColumnHeaderHeight()>0){r.addStyle("height",t.getColumnHeaderHeight()+"px");}if(d){r.addStyle("display","none");}r.writeStyles();var s=o.getTooltip_AsString();if(s){r.writeAttributeEscaped("title",s);}r.write("><div");r.addClass("sapUiTableColCell");r.writeClasses();var e=R.getTextAlign(o.getHAlign(),l&&l.getTextDirection&&l.getTextDirection());if(e){r.addStyle("text-align",e);}r.writeStyles();r.write(">");if(l){r.renderControl(l);}r.write("</div></div>");};
b.renderColRsz=function(r,t){r.write("<div");r.writeAttribute("id",t.getId()+"-rsz");r.writeAttribute("tabindex","-1");r.addClass("sapUiTableColRsz");r.writeClasses();r.write("></div>");};
b.renderRowHdr=function(r,t){r.write("<div");r.writeAttribute("id",t.getId()+"-sapUiTableRowHdrScr");r.addClass("sapUiTableRowHdrScr");r.addClass("sapUiTableNoOpacity");r.writeClasses();t._getAccRenderExtension().writeAriaAttributesFor(r,t,"ROWHEADER_COL");r.write(">");for(var d=0,e=t.getRows().length;d<e;d++){this.renderRowHdrRow(r,t,t.getRows()[d],d);}r.write("</div>");};
b._addFixedRowCSSClasses=function(r,t,i){var f=t.getFixedRowCount();var F=t.getFixedBottomRowCount();var v=t.getVisibleRowCount();var d=t.getFirstVisibleRow();if(f>0){if(i<f){r.addClass("sapUiTableFixedTopRow");}if(i==f-1){r.addClass("sapUiTableFixedLastTopRow");}}if(F>0){var e=false;var B=t.getBinding("rows");if(B){if(t._iBindingLength>=v){e=(i==v-F-1);}else{e=(d+i)==(t._iBindingLength-F-1)&&(t.getFirstVisibleRow()+i)<t._iBindingLength;}}if(e){r.addClass("sapUiTableFixedPreBottomRow");}}};
b.renderRowHdrRow=function(r,t,o,i){r.write("<div");r.writeAttribute("id",t.getId()+"-rowsel"+i);r.writeAttribute("data-sap-ui-rowindex",i);r.addClass("sapUiTableRowHdr");this._addFixedRowCSSClasses(r,t,i);var d=false;if(o._bHidden){r.addClass("sapUiTableRowHidden");}else{if(t.isIndexSelected(t._getAbsoluteRowIndex(i))){r.addClass("sapUiTableRowSel");d=true;}}r.writeClasses();if(t.getRowHeight()>0){r.addStyle("height",t.getRowHeight()+"px");}r.writeAttribute("tabindex","-1");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"ROWHEADER",{rowSelected:d});var e=[];q.each(o.getCells(),function(f,g){e.push(o.getId()+"-col"+f);});r.writeStyles();r.write(">");this.writeRowSelectorContent(r,t,o,i);r.write("</div>");};
b.renderTableCtrl=function(r,t){if(t.getFixedColumnCount()>0){r.write("<div");r.writeAttribute("id",t.getId()+"-sapUiTableCtrlScrFixed");r.addClass("sapUiTableCtrlScrFixed");r.writeClasses();r.write(">");this.renderTableControl(r,t,true);r.write("</div>");}r.write("<div");r.writeAttribute("id",t.getId()+"-sapUiTableCtrlScr");r.addClass("sapUiTableCtrlScr");r.writeClasses();if(t.getFixedColumnCount()>0){if(t._bRtlMode){r.addStyle("margin-right","0");}else{r.addStyle("margin-left","0");}r.writeStyles();}r.write(">");r.write("<div");r.writeAttribute("id",t.getId()+"-tableCtrlCnt");r.addClass("sapUiTableCtrlCnt");r.writeClasses();var v=t.getVisibleRowCountMode();if(t._iTableRowContentHeight&&(v==V.Fixed||v==V.Interactive)){var s="height";if(t.getVisibleRowCountMode()==V.Fixed){s="min-height";}r.addStyle(s,t._iTableRowContentHeight+"px");r.writeStyles();}r.write(">");this.renderTableControl(r,t,false);r.write("</div></div>");};
b.renderTableControl=function(r,t,f){var s,e;if(f){s=0;e=t.getFixedColumnCount();}else{s=t.getFixedColumnCount();e=t.getColumns().length;}var F=t.getFixedRowCount();var i=t.getFixedBottomRowCount();var d=t.getRows();if(F>0){this.renderTableControlCnt(r,t,f,s,e,true,false,0,F);}this.renderTableControlCnt(r,t,f,s,e,false,false,F,d.length-i);if(i>0&&d.length>0){this.renderTableControlCnt(r,t,f,s,e,false,true,d.length-i,d.length);}};
b.renderTableControlCnt=function(r,t,f,s,e,F,d,i,E){r.write("<table");var g=t.getId()+"-table";if(f){g+="-fixed";r.addClass("sapUiTableCtrlFixed");}else{r.addClass("sapUiTableCtrlScroll");}if(F){g+="-fixrow";r.addClass("sapUiTableCtrlRowFixed");}else if(d){g+="-fixrow-bottom";r.addClass("sapUiTableCtrlRowFixedBottom");}else{r.addClass("sapUiTableCtrlRowScroll");}r.writeAttribute("id",g);t._getAccRenderExtension().writeAriaAttributesFor(r,t,"TABLE");r.addClass("sapUiTableCtrl");r.writeClasses();r.addStyle("min-width",t._getColumnsWidth(s,e)+"px");if(f&&(!!D.browser.firefox||!!D.browser.chrome||!!D.browser.safari)){r.addStyle("width",t._getColumnsWidth(s,e)+"px");}r.writeStyles();r.write(">");r.write("<thead>");r.write("<tr");r.addClass("sapUiTableCtrlCol");if(i==0){r.addClass("sapUiTableCtrlFirstCol");}r.writeClasses();r.write(">");var h=t.getColumns();if(T.hasRowHeader(t)){r.write("<th");r.addStyle("width","0px");r.writeStyles();if(i==0){t._getAccRenderExtension().writeAriaAttributesFor(r,t,"TH");r.writeAttribute("id",t.getId()+"-colsel");r.addClass("sapUiTableColSel");r.writeClasses();}r.write("></th>");}else{if(h.length===0){r.write("<th></th>");}}for(var j=s,k=e;j<k;j++){var o=h[j];if(o&&o.shouldRender()){r.write("<th");r.addStyle("width",o.getWidth());r.writeStyles();if(i==0){t._getAccRenderExtension().writeAriaAttributesFor(r,t,"TH",{column:o});r.writeAttribute("id",t.getId()+"_col"+j);}r.writeAttribute("data-sap-ui-headcolindex",j);r.writeAttribute("data-sap-ui-colid",o.getId());r.write(">");if(i==0&&T.getHeaderRowCount(t)==0){if(o.getMultiLabels().length>0){r.renderControl(o.getMultiLabels()[0]);}else{r.renderControl(o.getLabel());}}r.write("</th>");}}if(!f&&t._hasOnlyFixColumnWidths()&&h.length>0){r.write("<th></th>");}r.write("</tr>");r.write("</thead>");r.write("<tbody>");var v=t._getVisibleColumns();var H=t._hasOnlyFixColumnWidths();var l=t.getRows();if(l.length==0){l=[t._getDummyRow()];E=1;}var m=t._getAccExtension().getAriaTextsForSelectionMode(true);var n=T.isRowSelectionAllowed(t);for(var p=i,k=E;p<k;p++){this.renderTableRow(r,t,l[p],p,f,s,e,false,v,H,m,n);}r.write("</tbody>");r.write("</table>");};
b.addTrClasses=function(r,t,o,i){return;};
b.writeRowSelectorContent=function(r,t,o,i){t._getAccRenderExtension().writeAccRowSelectorText(r,t,o,i);if(T.Grouping.isGroupMode(t)){r.write("<div");r.writeAttribute("id",o.getId()+"-groupHeader");r.writeAttribute("class","sapUiTableGroupIcon");r.write("></div>");if(T.Grouping.showGroupMenuButton(t)){var d=I.getIconInfo("sap-icon://drop-down-list");r.write("<div class='sapUiTableGroupMenuButton'>");r.writeEscaped(d.content);r.write("</div>");}}};
b.renderTableRow=function(r,t,o,i,f,s,e,F,v,h,m,d){r.write("<tr");if(o._bDummyRow){r.addStyle("opacity","0");}r.addClass("sapUiTableTr");if(f){r.writeAttribute("id",o.getId()+"-fixed");}else{r.writeElementData(o);}if(o._bHidden){r.addClass("sapUiTableRowHidden");}else{if(t.isIndexSelected(t._getAbsoluteRowIndex(i))){r.addClass("sapUiTableRowSel");}this.addTrClasses(r,t,o,i);}if(i%2===0){r.addClass("sapUiTableRowEven");}else{r.addClass("sapUiTableRowOdd");}this._addFixedRowCSSClasses(r,t,i);r.writeClasses();r.writeAttribute("data-sap-ui-rowindex",i);var g=t.getRowHeight();if(g>0){r.addStyle("height",g+"px");}r.writeStyles();t._getAccRenderExtension().writeAriaAttributesFor(r,t,"TR",{index:i});r.write(">");var j=o.getCells();if(T.hasRowHeader(t)||j.length===0){r.write("<td");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"ROWHEADER_TD",{rowSelected:!o._bHidden&&t.isIndexSelected(t._getAbsoluteRowIndex(i)),index:i});r.write("></td>");}for(var k=0,l=j.length;k<l;k++){this.renderTableCell(r,t,o,j[k],k,f,s,e,v);}if(!f&&h&&j.length>0){r.write("<td");r.addClass("sapUiTableTDDummy");r.writeClasses();r.write(">");r.write("</td>");}r.write("</tr>");};
b.renderTableCell=function(r,t,o,d,i,f,s,e,v){var g=d.data("sap-ui-colindex");var h=t.getColumns()[g];if(h.shouldRender()&&s<=g&&e>g){r.write("<td");var j=o.getId()+"-col"+i;r.writeAttribute("id",j);r.writeAttribute("tabindex","-1");var k=v.length>0&&v[0]===h;t._getAccRenderExtension().writeAriaAttributesFor(r,t,"DATACELL",{index:g,column:h,row:o,fixed:f,firstCol:k});var H=R.getTextAlign(h.getHAlign(),d&&d.getTextDirection&&d.getTextDirection());if(H){r.addStyle("text-align",H);}r.writeStyles();r.addClass("sapUiTableTd");if(k){r.addClass("sapUiTableTdFirst");}if(h.getGrouped()){r.addClass("sapUiTableTdGroup");}var B=t.getBinding("rows");if(B&&h.getLeadingProperty&&B.isMeasure(h.getLeadingProperty())){r.addClass("sapUiTableMeasureCell");}r.writeClasses();r.write("><div");r.addClass("sapUiTableCell");r.writeClasses();if(t.getRowHeight()&&t.getVisibleRowCountMode()==V.Auto){r.addStyle("max-height",t.getRowHeight()+"px");}r.writeStyles();r.write(">");this.renderTableCellControl(r,t,d,k);r.write("</div></td>");}};
b.renderTableCellControl=function(r,t,o,i){if(T.Grouping.isTreeMode(t)&&i){r.write("<span class='sapUiTableTreeIcon' tabindex='-1'");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"TREEICON",{row:o.getParent()});r.write(">&nbsp;</span>");}r.renderControl(o);};
b.renderVSb=function(r,t){r.write("<div");r.addClass("sapUiTableVSb");r.writeClasses();r.writeAttribute("id",t.getId()+"-vsb");r.write(">");r.write("<div");r.writeAttribute("id",t.getId()+"-vsb-content");r.addClass("sapUiTableVSbContent");r.writeClasses();r.write(">");r.write("</div>");r.write("</div>");};
b.renderHSb=function(r,t){r.write("<div");r.addClass("sapUiTableHSb");r.writeClasses();r.writeAttribute("id",t.getId()+"-hsb");r.writeAttribute("tabindex","-1");r.write(">");r.write("<div");r.writeAttribute("id",t.getId()+"-hsb-content");r.addClass("sapUiTableHSbContent");r.writeClasses();r.write(">");r.write("</div>");r.write("</div>");};
b.renderTabElement=function(r,s){r.write("<div");if(s){r.addClass(s);r.writeClasses();}r.writeAttribute("tabindex","0");r.write("></div>");};
return b;},true);
sap.ui.predefine('sap/ui/table/TableUtils',['jquery.sap.global','sap/ui/core/Control','sap/ui/core/ResizeHandler','./TableGrouping','./library'],function(q,C,R,T,l){"use strict";var S=l.SelectionBehavior,N=l.NavigationMode,a=l.SelectionMode;var b={Grouping:T,CELLTYPES:{DATACELL:"DATACELL",COLUMNHEADER:"COLUMNHEADER",ROWHEADER:"ROWHEADER",COLUMNROWHEADER:"COLUMNROWHEADER"},hasRowHeader:function(t){return(t.getSelectionMode()!==a.None&&t.getSelectionBehavior()!==S.RowOnly)||T.isGroupMode(t);},isRowSelectionAllowed:function(t){return t.getSelectionMode()!==a.None&&(t.getSelectionBehavior()===S.Row||t.getSelectionBehavior()===S.RowOnly);},isRowSelectorSelectionAllowed:function(t){return t.getSelectionMode()!==a.None&&b.hasRowHeader(t);},isNoDataVisible:function(t){if(!t.getShowNoData()){return false;}var B=t.getBinding("rows"),i=t._getRowCount(),h=B?!!i:false;if(B&&B.providesGrandTotal){var H=B.providesGrandTotal()&&B.hasTotaledMeasures();h=(H&&i<2)||(!H&&i===0)?false:true;}return!h;},isInstanceOf:function(o,t){if(!o||!t){return false;}var c=sap.ui.require(t);return!!(c&&(o instanceof c));},toggleGroupHeader:function(t,r,e){var $=q(r),g;if($.hasClass("sapUiTableTreeIcon")){g=$.closest("tr");}else{g=$.closest(".sapUiTableGroupHeader");}var B=t.getBinding("rows");if(g.length>0&&B){var i=t.getFirstVisibleRow()+parseInt(g.attr("data-sap-ui-rowindex"),10);var I=T.toggleGroupHeader(t,i,e);var c=I===true||I===false;if(c&&t._onGroupHeaderChanged){t._onGroupHeaderChanged(i,I);}return c;}return false;},getNoDataText:function(t){var n=t.getNoData();if(n instanceof C){return null;}else{if(typeof n==="string"||t.getNoData()instanceof String){return n;}else{return t._oResBundle.getText("TBL_NO_DATA");}}},getVisibleColumnCount:function(t){return t._getVisibleColumns().length;},getHeaderRowCount:function(t){if(!t.getColumnHeaderVisible()){return 0;}var h=0;q.each(t._getVisibleColumns(),function(i,c){h=Math.max(h,c.getMultiLabels().length);});return h>0?h:1;},getRowHeightByIndex:function(t,r){var i=0;if(t){var c=t.getRows();if(c&&c.length&&r>-1&&r<c.length){var d=c[r].getDomRefs();if(d){if(d.rowScrollPart&&d.rowFixedPart){i=Math.max(d.rowScrollPart.clientHeight,d.rowFixedPart.clientHeight);}else if(!d.rowFixedPart){i=d.rowScrollPart.clientHeight;}}}}return i;},isVariableRowHeightEnabled:function(t){return t._bVariableRowHeightEnabled&&t.getNavigationMode()===N.Scrollbar&&t.getFixedRowCount()<=0&&t.getFixedBottomRowCount()<=0;},getTotalRowCount:function(t,i){var r=t._getRowCount();if(i){r=Math.max(r,t.getVisibleRowCount());}return r;},getNonEmptyVisibleRowCount:function(t){return Math.min(t.getVisibleRowCount(),t._getRowCount());},getFocusedItemInfo:function(t){var i=t._getItemNavigation();if(!i){return null;}return{cell:i.getFocusedIndex(),columnCount:i.iColumns,cellInRow:i.getFocusedIndex()%i.iColumns,row:Math.floor(i.getFocusedIndex()/i.iColumns),cellCount:i.getItemDomRefs().length,domRef:i.getFocusedDomRef()};},getColumnIndexOfFocusedCell:function(t){var i=b.getFocusedItemInfo(t);return i.cellInRow-(b.hasRowHeader(t)?1:0);},getRowIndexOfFocusedCell:function(t){var i=b.getFocusedItemInfo(t);return i.row-b.getHeaderRowCount(t);},isInGroupingRow:function(c){var i=b.getCellInfo(c);if(i&&i.type===b.CELLTYPES.DATACELL){return i.cell.parent().hasClass("sapUiTableGroupHeader");}else if(i&&i.type===b.CELLTYPES.ROWHEADER){return i.cell.hasClass("sapUiTableGroupHeader");}return false;},isInSumRow:function(c){var i=b.getCellInfo(c);if(i&&i.type===b.CELLTYPES.DATACELL){return i.cell.parent().hasClass("sapUiAnalyticalTableSum");}else if(i&&i.type===b.CELLTYPES.ROWHEADER){return i.cell.hasClass("sapUiAnalyticalTableSum");}return false;},isFixedColumn:function(t,c){return c<t.getFixedColumnCount();},hasFixedColumns:function(t){return t.getFixedColumnCount()>0;},focusItem:function(t,i,e){var I=t._getItemNavigation();if(I){I.focusItem(i,e);}},getCellInfo:function(c){if(!c){return null;}var $=q(c);if($.hasClass("sapUiTableTd")){return{type:b.CELLTYPES.DATACELL,cell:$};}else if($.hasClass("sapUiTableCol")){return{type:b.CELLTYPES.COLUMNHEADER,cell:$};}else if($.hasClass("sapUiTableRowHdr")){return{type:b.CELLTYPES.ROWHEADER,cell:$};}else if($.hasClass("sapUiTableColRowHdr")){return{type:b.CELLTYPES.COLUMNROWHEADER,cell:$};}return null;},getRowColCell:function(t,r,c){var o=t.getRows()[r];var d=t._getVisibleColumns()[c];var e=o&&o.getCells()[c];if(e&&e.data("sap-ui-colid")!=d.getId()){var f=o.getCells();for(var i=0;i<f.length;i++){if(f[i].data("sap-ui-colid")===d.getId()){e=f[i];break;}}}return{row:o,column:d,cell:e};},registerResizeHandler:function(t,i,h,r){var d;if(typeof i=="string"){d=t.getDomRef(i);}else{q.sap.log.error("sIdSuffix must be a string",t);return;}if(typeof h!=="function"){q.sap.log.error("fnHandler must be a function",t);return;}this.deregisterResizeHandler(t,i);if(!t._mResizeHandlerIds){t._mResizeHandlerIds={};}if(r&&d){d=d.parentNode;}if(d){t._mResizeHandlerIds[i]=R.register(d,h);}return t._mResizeHandlerIds[i];},deregisterResizeHandler:function(t,I){var c;if(!t._mResizeHandlerIds){return;}if(typeof I=="string"){c=[I];}else if(I===undefined){c=[];for(var k in t._mResizeHandlerIds){if(typeof k=="string"&&t._mResizeHandlerIds.hasOwnProperty(k)){c.push(k);}}}else if(q.isArray(I)){c=I;}for(var i=0;i<c.length;i++){var s=c[i];if(t._mResizeHandlerIds[s]){R.deregister(t._mResizeHandlerIds[s]);t._mResizeHandlerIds[s]=undefined;}}},scroll:function(t,d,p){var p=t.getNavigationMode()===N.Scrollbar?p:true;var s=false;var r=t._getRowCount();var v=t.getVisibleRowCount();var i=v-t.getFixedRowCount()-t.getFixedBottomRowCount();var f=t._getSanitizedFirstVisibleRow();var c=p?i:1;if(d){if(f+v<r){t.setFirstVisibleRow(Math.min(f+c,r-v));s=true;}}else{if(f>0){t.setFirstVisibleRow(Math.max(f-c,0));s=true;}}return s;},scrollMax:function(t,d){var s=false;var f=t._getSanitizedFirstVisibleRow();if(d){var F=t._getRowCount()-this.getNonEmptyVisibleRowCount(t);if(f<F){t.setFirstVisibleRow(F);s=true;}}else{if(f>0){t.setFirstVisibleRow(0);s=true;}}return s;},isFirstScrollableRow:function(t,r){var $=q(r);var i=parseInt($.add($.parent()).filter("[data-sap-ui-rowindex]").attr("data-sap-ui-rowindex"),10);var f=t.getFixedRowCount()||0;return i==f;},isLastScrollableRow:function(t,r){var $=q(r);var i=parseInt($.add($.parent()).filter("[data-sap-ui-rowindex]").attr("data-sap-ui-rowindex"),10);var f=t.getFixedBottomRowCount()||0;return i==t.getVisibleRowCount()-f-1;},getContentDensity:function(c){var s;var d=["sapUiSizeCompact","sapUiSizeCondensed","sapUiSizeCozy"];var g=function(f,o){if(!o[f]){return;}for(var i=0;i<d.length;i++){if(o[f](d[i])){return d[i];}}};var D=c.$();if(D.length>0){s=g("hasClass",D);}else{s=g("hasStyleClass",c);}if(s){return s;}var p=null;var P=c.getParent();if(P){do{s=g("hasStyleClass",P);if(s){return s;}if(P.getDomRef){p=P.getDomRef();}else if(P.getRootNode){p=P.getRootNode();}if(!p&&P.getParent){P=P.getParent();}else{P=null;}}while(P&&!p)}D=q(p||document.body);s=g("hasClass",D.closest("."+d.join(",.")));return s;}};T.TableUtils=b;return b;},true);
sap.ui.predefine('sap/ui/table/TreeAutoExpandMode',['jquery.sap.global'],function(q){"use strict";var T={Sequential:"Sequential",Bundled:"Bundled"};return T;},true);
sap.ui.predefine('sap/ui/table/TreeTable',['jquery.sap.global','./Table','sap/ui/model/odata/ODataTreeBindingAdapter','sap/ui/model/ClientTreeBindingAdapter','sap/ui/model/TreeBindingCompatibilityAdapter','./library','sap/ui/core/Element','./TableUtils'],function(q,T,O,C,a,l,E,b){"use strict";
var c=T.extend("sap.ui.table.TreeTable",{
metadata:{library:"sap.ui.table",properties:{expandFirstLevel:{type:"boolean",defaultValue:false},useGroupMode:{type:"boolean",group:"Appearance",defaultValue:false},groupHeaderProperty:{type:"string",group:"Data",defaultValue:null},collapseRecursive:{type:"boolean",defaultValue:true},rootLevel:{type:"int",group:"Data",defaultValue:0}},events:{toggleOpenState:{parameters:{rowIndex:{type:"int"},rowContext:{type:"object"},expanded:{type:"boolean"}}}}},
renderer:"sap.ui.table.TableRenderer"
});
c.prototype.init=function(){T.prototype.init.apply(this,arguments);this._iLastFixedColIndex=0;b.Grouping.setTreeMode(this);};
c.prototype.bindRows=function(B,t,s,f){var p,o,s,f;if(typeof B=="string"){p=arguments[0];o=arguments[1];s=arguments[2];f=arguments[3];B={path:p,sorter:s,filters:f,template:o};}if(typeof B==="object"){B.parameters=B.parameters||{};B.parameters.rootLevel=this.getRootLevel();B.parameters.collapseRecursive=this.getCollapseRecursive();B.parameters.numberOfExpandedLevels=B.parameters.numberOfExpandedLevels||(this.getExpandFirstLevel()?1:0);B.parameters.rootNodeID=B.parameters.rootNodeID;}return this.bindAggregation("rows",B);};
c.prototype.setSelectionMode=function(s){var B=this.getBinding("rows");if(B&&B.clearSelection){B.clearSelection();this.setProperty("selectionMode",s);}else{T.prototype.setSelectionMode.call(this,s);}return this;};
c.prototype.refreshRows=function(r){T.prototype.refreshRows.apply(this,arguments);var B=this.getBinding("rows");if(B&&this.isTreeBinding("rows")&&!B.hasListeners("selectionChanged")){B.attachSelectionChanged(this._onSelectionChanged,this);}};
c.prototype.setFixedRowCount=function(r){q.sap.log.warning("TreeTable: the property \"fixedRowCount\" is not supported and will be ignored!");return this;};
c.prototype.isTreeBinding=function(n){n=n||"rows";if(n==="rows"){return true;}return E.prototype.isTreeBinding.apply(this,arguments);};
c.prototype.getBinding=function(n){n=n||"rows";var B=E.prototype.getBinding.call(this,n);if(B&&n==="rows"&&!B.getLength){var d=sap.ui.require("sap/ui/model/odata/ODataTreeBinding");var V=sap.ui.require("sap/ui/model/odata/v2/ODataTreeBinding");var e=sap.ui.require("sap/ui/model/ClientTreeBinding");if(d&&B instanceof d){a(B,this);}else if(V&&B instanceof V){B.applyAdapterInterface();}else if(e&&B instanceof e){C.apply(B);}else{q.sap.log.error("Binding not supported by sap.ui.table.TreeTable");}}return B;};
c.prototype._updateTableContent=function(){var B=this.getBinding("rows"),r=this.getRows(),i=r.length;if(B){var R=this.getBindingInfo("rows"),m=R&&R.model,o,g;for(var d=0;d<i;d++){o=r[d];g=b.Grouping.isGroupMode(this)&&this.getGroupHeaderProperty()?this.getModel(m).getProperty(this.getGroupHeaderProperty(),o.getBindingContext(m)):"";b.Grouping.updateTableRowForGrouping(this,o,o._bHasChildren,o._bIsExpanded,o._bHasChildren,false,o._iLevel,g);}}else{for(var d=0;d<i;d++){b.Grouping.cleanupTableRowForGrouping(this,r[d]);}}};
c.prototype._updateTableCell=function(){return true;};
c.prototype._getContexts=function(s,L,t){var B=this.getBinding("rows");if(B){return B.getNodes(s,L,t);}else{return[];}};
c.prototype._onGroupHeaderChanged=function(r,e){this.fireToggleOpenState({rowIndex:r,rowContext:this.getContextByIndex(r),expanded:e});};
c.prototype.expand=function(r){var B=this.getBinding("rows");if(B&&r>=0){B.expand(r);}return this;};
c.prototype.collapse=function(r){var B=this.getBinding("rows");if(B&&r>=0){B.collapse(r);}return this;};
c.prototype.collapseAll=function(){var B=this.getBinding("rows");if(B){B.collapseToLevel(0);this.setFirstVisibleRow(0);}return this;};
c.prototype.expandToLevel=function(L){var B=this.getBinding("rows");if(B&&B.expandToLevel){B.expandToLevel(L);}return this;};
c.prototype.isExpanded=function(r){var B=this.getBinding("rows");if(B){return B.isExpanded(r);}return false;};
c.prototype.isIndexSelected=function(r){var B=this.getBinding("rows");if(B&&B.isIndexSelected){return B.isIndexSelected(r);}else{return T.prototype.isIndexSelected.call(this,r);}};
c.prototype.setSelectedIndex=function(r){if(r===-1){this.clearSelection();}var B=this.getBinding("rows");if(B&&B.findNode&&B.setNodeSelection){B.setSelectedIndex(r);}else{T.prototype.setSelectedIndex.call(this,r);}return this;};
c.prototype.getSelectedIndices=function(){var B=this.getBinding("rows");if(B&&B.findNode&&B.getSelectedIndices){return B.getSelectedIndices();}else{return T.prototype.getSelectedIndices.call(this);}};
c.prototype.setSelectionInterval=function(f,t){var B=this.getBinding("rows");if(B&&B.findNode&&B.setSelectionInterval){B.setSelectionInterval(f,t);}else{T.prototype.setSelectionInterval.call(this,f,t);}return this;};
c.prototype.addSelectionInterval=function(f,t){var B=this.getBinding("rows");if(B&&B.findNode&&B.addSelectionInterval){B.addSelectionInterval(f,t);}else{T.prototype.addSelectionInterval.call(this,f,t);}return this;};
c.prototype.removeSelectionInterval=function(f,t){var B=this.getBinding("rows");if(B&&B.findNode&&B.removeSelectionInterval){B.removeSelectionInterval(f,t);}else{T.prototype.removeSelectionInterval.call(this,f,t);}return this;};
c.prototype.selectAll=function(){var s=this.getSelectionMode();if(!this.getEnableSelectAll()||(s!="Multi"&&s!="MultiToggle")||!this._getSelectableRowCount()){return this;}var B=this.getBinding("rows");if(B.selectAll){B.selectAll();this.$("selall").attr('title',this._oResBundle.getText("TBL_DESELECT_ALL")).removeClass("sapUiTableSelAll");}else{T.prototype.selectAll.call(this);}return this;};
c.prototype.getSelectedIndex=function(){var B=this.getBinding("rows");if(B&&B.findNode){return B.getSelectedIndex();}else{return T.prototype.getSelectedIndex.call(this);}};
c.prototype.clearSelection=function(){var B=this.getBinding("rows");if(B&&B.clearSelection){B.clearSelection();}else{T.prototype.clearSelection.call(this);}return this;};
c.prototype.getContextByIndex=function(r){var B=this.getBinding("rows");if(B){return B.getContextByIndex(r);}};
c.prototype.setRootLevel=function(r){this.setFirstVisibleRow(0);var B=this.getBinding("rows");if(B){if(B.setRootLevel){B.setRootLevel(r);}}this.setProperty("rootLevel",r,true);return this;};
c.prototype.setCollapseRecursive=function(d){var B=this.getBinding("rows");if(B){if(B.setCollapseRecursive){B.setCollapseRecursive(d);}}this.setProperty("collapseRecursive",!!d,true);return this;};
c.prototype._getSelectedIndicesCount=function(){var s;var B=this.getBinding("rows");if(B&&B.findNode&&B.getSelectedNodesCount){return B.getSelectedNodesCount();}else{return T.prototype.getSelectedIndices.call(this);}return s;};
c.prototype.setUseGroupMode=function(g){this.setProperty("useGroupMode",!!g);if(!!g){b.Grouping.setGroupMode(this);}else{b.Grouping.setTreeMode(this);}return this;};
c.prototype.setEnableGrouping=function(e){q.sap.log.warning("The property enableGrouping is not supported by control sap.ui.table.TreeTable");return this;};
return c;});
sap.ui.predefine('sap/ui/table/TreeTableRenderer',['sap/ui/table/TreeTable'],function(T){"use strict";return T.getMetadata().getRenderer();},true);
sap.ui.predefine('sap/ui/table/library',['jquery.sap.global','sap/ui/core/Core','sap/ui/core/library','sap/ui/unified/library'],function(q,C){"use strict";sap.ui.getCore().initLibrary({name:"sap.ui.table",version:"1.40.6",dependencies:["sap.ui.core","sap.ui.unified"],types:["sap.ui.table.NavigationMode","sap.ui.table.SelectionBehavior","sap.ui.table.SelectionMode","sap.ui.table.SortOrder","sap.ui.table.VisibleRowCountMode","sap.ui.table.SharedDomRef"],interfaces:[],controls:["sap.ui.table.AnalyticalColumnMenu","sap.ui.table.AnalyticalTable","sap.ui.table.ColumnMenu","sap.ui.table.Table","sap.ui.table.TreeTable"],elements:["sap.ui.table.AnalyticalColumn","sap.ui.table.Column","sap.ui.table.Row"],extensions:{flChangeHandlers:{"sap.ui.table.Column":{"propertyChange":"default"},"sap.ui.table.Table":{"moveElements":"default"},"sap.ui.table.AnalyticalTable":{"moveElements":"default"}}}});var t=sap.ui.table;t.NavigationMode={Scrollbar:"Scrollbar",Paginator:"Paginator"};t.SelectionBehavior={Row:"Row",RowSelector:"RowSelector",RowOnly:"RowOnly"};t.SelectionMode={MultiToggle:"MultiToggle",Multi:"Multi",Single:"Single",None:"None"};t.SortOrder={Ascending:"Ascending",Descending:"Descending"};t.VisibleRowCountMode={Fixed:"Fixed",Interactive:"Interactive",Auto:"Auto"};t.SharedDomRef={HorizontalScrollBar:"hsb",VerticalScrollBar:"vsb"};t.GroupEventType={group:"group",ungroup:"ungroup",ungroupAll:"ungroupAll",moveUp:"moveUp",moveDown:"moveDown",showGroupedColumn:"showGroupedColumn",hideGroupedColumn:"hideGroupedColumn"};t.ColumnHeader=t.Column;if(!t.TableHelper){t.TableHelper={createLabel:function(c){throw new Error("no Label control available!");},createTextView:function(c){throw new Error("no TextView control available!");},createTextField:function(c){throw new Error("no TextField control available!");},createImage:function(c){throw new Error("no Image control available!");},bFinal:false};}return t;});
jQuery.sap.registerPreloadedModules({
"name":"sap/ui/table/library-preload",
"version":"2.0",
"modules":{
	"sap/ui/table/manifest.json":'{\n  "_version": "1.2.0",\n  "sap.app": {\n    "_version": "1.2.0",\n    "id": "sap.ui.table",\n    "type": "library",\n    "embeds": [],\n    "applicationVersion": {\n      "version": "1.40.6"\n    },\n    "title": "Table-like controls, mainly for desktop scenarios.",\n    "description": "Table-like controls, mainly for desktop scenarios.",\n    "ach": "CA-UI5-CTR-WDF",\n    "resources": "resources.json",\n    "offline": true\n  },\n  "sap.ui": {\n    "_version": "1.1.0",\n    "technology": "UI5",\n    "supportedThemes": [\n      "base",\n      "sap_hcb"\n    ]\n  },\n  "sap.ui5": {\n    "_version": "1.1.0",\n    "dependencies": {\n      "minUI5Version": "1.40",\n      "libs": {\n        "sap.ui.core": {\n          "minVersion": "1.40.6"\n        },\n        "sap.ui.unified": {\n          "minVersion": "1.40.6"\n        }\n      }\n    }\n  }\n}'
}});
