/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./Dialog','./ComboBoxTextField','./Toolbar','./Button','./Bar','./Title','./SelectList','./Popover','sap/ui/core/IconPool','./library'],function(q,D,C,T,B,a,b,S,P,I,l){"use strict";var c=C.extend("sap.m.ComboBoxBase",{metadata:{library:"sap.m",defaultAggregation:"items",aggregations:{items:{type:"sap.ui.core.Item",multiple:true,singularName:"item",bindable:"bindable"},picker:{type:"sap.ui.core.PopupInterface",multiple:false,visibility:"hidden"}},events:{loadItems:{}}}});c.prototype.updateItems=function(r){this.bItemsUpdated=false;this.destroyItems();this.updateAggregation("items");this.bItemsUpdated=true;if(this.hasLoadItemsEventListeners()){this.onItemsLoaded();}};c.prototype.refreshItems=function(){this.bItemsUpdated=false;this.refreshAggregation("items");};c.prototype.getList=function(){if(this.bIsDestroyed){return null;}return this._oList;};c.prototype.loadItems=function(f,o){var d=typeof f==="function";if(this.hasLoadItemsEventListeners()&&(this.getItems().length===0)){this._bOnItemsLoadedScheduled=false;if(d){o=q.extend({action:f,busyIndicator:true,busyIndicatorDelay:300},o);this.aMessageQueue.push(o);if((this.iLoadItemsEventInitialProcessingTimeoutID===-1)&&(o.busyIndicator)){this.iLoadItemsEventInitialProcessingTimeoutID=setTimeout(function onItemsNotLoadedAfterDelay(){this.setInternalBusyIndicatorDelay(0);this.setInternalBusyIndicator(true);}.bind(this),o.busyIndicatorDelay);}}if(!this.bProcessingLoadItemsEvent){this.bProcessingLoadItemsEvent=true;this.fireLoadItems();}}else if(d){f.call(this);}};c.prototype.onItemsLoaded=function(){this.bProcessingLoadItemsEvent=false;clearTimeout(this.iLoadItemsEventInitialProcessingTimeoutID);if(this.bInitialBusyIndicatorState!==this.getBusy()){this.setInternalBusyIndicator(this.bInitialBusyIndicatorState);}if(this.iInitialBusyIndicatorDelay!==this.getBusyIndicatorDelay()){this.setInternalBusyIndicatorDelay(this.iInitialBusyIndicatorDelay);}for(var i=0,m,n,d;i<this.aMessageQueue.length;i++){m=this.aMessageQueue.shift();i--;d=(i+1)===this.aMessageQueue.length;n=d?null:this.aMessageQueue[i+1];if(typeof m.action==="function"){if((m.name==="input")&&!d&&(n.name==="input")){continue;}m.action.call(this);}}};c.prototype.hasLoadItemsEventListeners=function(){return this.hasListeners("loadItems");};c.prototype._scheduleOnItemsLoadedOnce=function(){if(!this._bOnItemsLoadedScheduled&&!this.isBound("items")&&this.hasLoadItemsEventListeners()&&this.bProcessingLoadItemsEvent){this._bOnItemsLoadedScheduled=true;setTimeout(this.onItemsLoaded.bind(this),0);}};c.prototype.init=function(){C.prototype.init.apply(this,arguments);this.setPickerType(sap.ui.Device.system.phone?"Dialog":"Dropdown");if(sap.ui.Device.system.phone){this.attachEvent("_change",this.onPropertyChange,this);}this.createPicker(this.getPickerType());this.bItemsUpdated=false;this.bOpenedByKeyboardOrButton=false;this.bProcessingLoadItemsEvent=false;this.iLoadItemsEventInitialProcessingTimeoutID=-1;this.aMessageQueue=[];this.bInitialBusyIndicatorState=this.getBusy();this.iInitialBusyIndicatorDelay=this.getBusyIndicatorDelay();this._bOnItemsLoadedScheduled=false;this._bDoTypeAhead=true;};c.prototype.exit=function(){C.prototype.exit.apply(this,arguments);if(this.getList()){this.getList().destroy();this._oList=null;}clearTimeout(this.iLoadItemsEventInitialProcessingTimeoutID);this.aMessageQueue=null;};c.prototype.ontouchstart=function(e){if(!this.getEnabled()||!this.getEditable()){return;}e.setMarked();if(this.isOpenArea(e.target)){this.addStyleClass(this.getRenderer().CSS_CLASS_COMBOBOXBASE+"Pressed");}};c.prototype.ontouchend=function(e){if(!this.getEnabled()||!this.getEditable()){return;}e.setMarked();if(!this.isOpen()&&this.isOpenArea(e.target)){this.removeStyleClass(this.getRenderer().CSS_CLASS_COMBOBOXBASE+"Pressed");}};c.prototype.ontap=function(e){C.prototype.ontap.apply(this,arguments);var d=this.getRenderer().CSS_CLASS_COMBOBOXBASE,o=e.srcControl;if(!this.getEnabled()||!this.getEditable()){return;}e.setMarked();if(o.isOpenArea&&o.isOpenArea(e.target)){if(this.isOpen()){this.close();this.removeStyleClass(d+"Pressed");return;}this.bOpenedByKeyboardOrButton=true;this.loadItems();this.open();}if(this.isOpen()){this.addStyleClass(d+"Pressed");}};c.prototype.onsapshow=function(e){if(!this.getEnabled()||!this.getEditable()){return;}e.setMarked();if(e.keyCode===q.sap.KeyCodes.F4){e.preventDefault();}if(this.isOpen()){this.close();return;}this.selectText(0,this.getValue().length);this.loadItems();this.bOpenedByKeyboardOrButton=true;this.open();};c.prototype.onsapescape=function(e){if(this.getEnabled()&&this.getEditable()&&this.isOpen()){e.setMarked();e.preventDefault();this.close();}else{C.prototype.onsapescape.apply(this,arguments);}};c.prototype.onsaphide=c.prototype.onsapshow;c.prototype.onsapfocusleave=function(e){if(!e.relatedControlId){C.prototype.onsapfocusleave.apply(this,arguments);return;}var r=sap.ui.getCore().byId(e.relatedControlId);if(r===this){return;}var p=this.getAggregation("picker"),f=r&&r.getFocusDomRef();if(p&&q.sap.containsOrEquals(p.getFocusDomRef(),f)){return;}C.prototype.onsapfocusleave.apply(this,arguments);};c.prototype.getPopupAnchorDomRef=function(){return this.getDomRef();};c.prototype.addContent=function(p){};c.prototype.setPickerType=function(p){this._sPickerType=p;};c.prototype.getPickerType=function(){return this._sPickerType;};c.prototype.isPickerDialog=function(){return this.getPickerType()==="Dialog";};c.prototype.createPicker=function(p){};c.prototype.onBeforeClose=function(){this.bOpenedByKeyboardOrButton=false;};c.prototype.getPicker=function(){if(this.bIsDestroyed){return null;}return this.createPicker(this.getPickerType());};c.prototype.getPickerTextField=function(){var p=this.getPicker(),s=p.getSubHeader();return s&&s.getContent()[0]||null;};c.prototype.getPickerTitle=function(){var p=this.getPicker(),h=p&&p.getCustomHeader();if(this.isPickerDialog()&&h){return h.getContentMiddle()[0];}return null;};c.prototype.createDialog=function(){var t=this,o=this.createPickerTextField(),d=o._handleEvent;o._handleEvent=function(e){d.apply(this,arguments);if(/keydown|sapdown|sapup|saphome|sapend|sappagedown|sappageup|input/.test(e.type)){t._handleEvent(e);}};return new D({stretch:true,customHeader:t.createPickerHeader(),buttons:this.createPickerCloseButton(),subHeader:new T({content:o}),beforeOpen:function(){t.updatePickerHeaderTitle();}});};c.prototype.createPickerHeader=function(){var t=this,i=I.getIconURI("decline");return new a({contentMiddle:new b(),contentRight:new B({icon:i,press:function(){t.close();t.revertSelection();}})});};c.prototype.revertSelection=function(){};c.prototype.updatePickerHeaderTitle=function(){var p=this.getPicker(),r=sap.ui.getCore().getLibraryResourceBundle("sap.m"),L,d;if(!p){return;}d=this.getLabels();if(d.length){L=d[0];if(L&&(typeof L.getText==="function")){this.getPickerTitle().setText(L.getText());}}else{this.getPickerTitle().setText(r.getText("COMBOBOX_PICKER_TITLE"));}};c.prototype.createPickerCloseButton=function(){var t=this,o,r=sap.ui.getCore().getLibraryResourceBundle("sap.m");return new B({text:r.getText("COMBOBOX_CLOSE_BUTTON"),press:function(){o=t.getPickerTextField();t.updateDomValue(o.getValue());t.onChange();t.close();}});};c.prototype.hasContent=function(){return this.getItems().length>0;};c.prototype.findFirstEnabledItem=function(i){var L=this.getList();return L?L.findFirstEnabledItem(i):null;};c.prototype.findLastEnabledItem=function(i){var L=this.getList();return L?L.findLastEnabledItem(i):null;};c.prototype.open=function(){var p=this.getPicker();if(p){p.open();}return this;};c.prototype.getVisibleItems=function(){var L=this.getList();return L?L.getVisibleItems():[];};c.prototype.isItemSelected=function(){};c.prototype.getKeys=function(d){d=d||this.getItems();for(var i=0,k=[];i<d.length;i++){k[i]=d[i].getKey();}return k;};c.prototype.getSelectableItems=function(){var L=this.getList();return L?L.getSelectableItems():[];};c.prototype.findItem=function(p,v){var L=this.getList();return L?L.findItem(p,v):null;};c.prototype.getItemByText=function(t){return this.findItem("text",t);};c.prototype.scrollToItem=function(i){var p=this.getPicker(),o=p.getDomRef("cont"),d=i&&i.getDomRef();if(!p||!o||!d){return;}var e=o.scrollTop,f=d.offsetTop,g=o.clientHeight,h=d.offsetHeight;if(e>f){o.scrollTop=f;}else if((f+h)>(e+g)){o.scrollTop=Math.ceil(f+h-g);}};c.prototype.clearFilter=function(){for(var i=0,d=this.getItems();i<d.length;i++){d[i].bVisible=true;}};c.prototype.onItemChange=function(o){};c.prototype.clearSelection=function(){};c.prototype.setInternalBusyIndicator=function(d){this.bInitialBusyIndicatorState=this.getBusy();return this.setBusy.apply(this,arguments);};c.prototype.setInternalBusyIndicatorDelay=function(d){this.iInitialBusyIndicatorDelay=this.getBusyIndicatorDelay();return this.setBusyIndicatorDelay.apply(this,arguments);};c.prototype.addItem=function(i){this.addAggregation("items",i);if(i){i.attachEvent("_change",this.onItemChange,this);}this._scheduleOnItemsLoadedOnce();return this;};c.prototype.insertItem=function(i,d){this.insertAggregation("items",i,d,true);if(i){i.attachEvent("_change",this.onItemChange,this);}this._scheduleOnItemsLoadedOnce();return this;};c.prototype.getItemAt=function(i){return this.getItems()[+i]||null;};c.prototype.getFirstItem=function(){return this.getItems()[0]||null;};c.prototype.getLastItem=function(){var i=this.getItems();return i[i.length-1]||null;};c.prototype.getEnabledItems=function(i){var L=this.getList();return L?L.getEnabledItems(i):[];};c.prototype.getItemByKey=function(k){var L=this.getList();return L?L.getItemByKey(k):null;};c.prototype.isOpen=function(){var p=this.getAggregation("picker");return!!(p&&p.isOpen());};c.prototype.close=function(){var p=this.getAggregation("picker");if(p){p.close();}return this;};c.prototype.removeItem=function(i){var L=this.getList();i=L?L.removeItem(i):null;if(i){i.detachEvent("_change",this.onItemChange,this);}return i;};c.prototype.removeAllItems=function(){var L=this.getList(),d=L?L.removeAllItems():[];this.clearSelection();for(var i=0;i<d.length;i++){d[i].detachEvent("_change",this.onItemChange,this);}return d;};c.prototype.destroyItems=function(){var L=this.getList();if(L){L.destroyItems();}return this;};return c;},true);
