/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/base/Metadata','./OverflowToolbarButton','./ToggleButton','./Button'],function(q,M,O,T,B){"use strict";var a=M.createClass("sap.m._overflowToolbarHelpers.OverflowToolbarAssociativePopoverControls",{constructor:function(){this._mControlsCache={};}});a.prototype._preProcessSapMButton=function(c){var b=c.getType();this._mControlsCache[c.getId()]={buttonType:b};if(b===sap.m.ButtonType.Default){c.setProperty("type",sap.m.ButtonType.Transparent,true);}if(c.getIcon()){c.addStyleClass("sapMOTAPButtonWithIcon");}else{c.addStyleClass("sapMOTAPButtonNoIcon");}c.attachEvent("_change",this._onSapMButtonUpdated,this);};a.prototype._postProcessSapMButton=function(c){var p=this._mControlsCache[c.getId()];if(c.getType()!==p.buttonType){c.setProperty("type",p.buttonType,true);}c.removeStyleClass("sapMOTAPButtonNoIcon");c.removeStyleClass("sapMOTAPButtonWithIcon");c.detachEvent("_change",this._onSapMButtonUpdated,this);};a.prototype._onSapMButtonUpdated=function(e){var p=e.getParameter("name"),b=e.getSource(),s=b.getId();if(typeof this._mControlsCache[s]==="undefined"){return;}if(p==="type"){this._mControlsCache[s]["buttonType"]=b.getType();}};a.prototype._preProcessSapMOverflowToolbarButton=function(c){this._preProcessSapMButton(c);c._bInOverflow=true;};a.prototype._postProcessSapMOverflowToolbarButton=function(c){delete c._bInOverflow;this._postProcessSapMButton(c);};a.prototype._preProcessSapMToggleButton=function(c){this._preProcessSapMButton(c);};a.prototype._postProcessSapMToggleButton=function(c){this._postProcessSapMButton(c);};a.prototype._preProcessSapMSegmentedButton=function(c){c._toSelectMode();};a.prototype._postProcessSapMSegmentedButton=function(c){c._toNormalMode();};a.prototype._preProcessSapMSelect=function(c){this._mControlsCache[c.getId()]={selectType:c.getType()};if(c.getType()!==sap.m.SelectType.Default){c.setProperty("type",sap.m.SelectType.Default,true);}};a.prototype._postProcessSapMSelect=function(c){var p=this._mControlsCache[c.getId()];if(c.getType()!==p.selectType){c.setProperty("type",p.selectType,true);}};a._mSupportedControls={"sap.m.Button":{canOverflow:true,listenForEvents:["press"],noInvalidationProps:["enabled","type"]},"sap.m.OverflowToolbarButton":{canOverflow:true,listenForEvents:["press"],noInvalidationProps:["enabled","type"]},"sap.m.CheckBox":{canOverflow:true,listenForEvents:["select"],noInvalidationProps:["enabled","selected"]},"sap.m.ToggleButton":{canOverflow:true,listenForEvents:["press"],noInvalidationProps:["enabled","pressed"]},"sap.m.Select":{canOverflow:true,listenForEvents:["change"],noInvalidationProps:["enabled","selectedItemId","selectedKey"]},"sap.m.ComboBox":{canOverflow:true,listenForEvents:[],noInvalidationProps:["enabled","value","selectedItemId","selectedKey"]},"sap.m.SearchField":{canOverflow:true,listenForEvents:["search"],noInvalidationProps:["enabled","value","selectOnFocus"]},"sap.m.SegmentedButton":{canOverflow:true,listenForEvents:["select"],noInvalidationProps:["enabled","selectedKey"]},"sap.m.Input":{canOverflow:true,listenForEvents:[],noInvalidationProps:["enabled","value"]},"sap.m.DateTimeInput":{canOverflow:true,listenForEvents:["change"],noInvalidationProps:["enabled","value","dateValue"]},"sap.m.DatePicker":{canOverflow:true,listenForEvents:["change"],noInvalidationProps:["enabled","value","dateValue","displayFormat","valueFormat","displayFormatType","secondaryCalendarType","minDate","maxDate"]},"sap.m.DateTimePicker":{canOverflow:true,listenForEvents:["change"],noInvalidationProps:["enabled","value","dateValue","displayFormat","valueFormat","displayFormatType","secondaryCalendarType","minDate","maxDate"]},"sap.m.TimePicker":{canOverflow:true,listenForEvents:["change"],noInvalidationProps:["enabled","value","dateValue","displayFormat","valueFormat"]},"sap.m.RadioButton":{canOverflow:false,listenForEvents:[],noInvalidationProps:["enabled","selected"]},"sap.m.Slider":{canOverflow:false,listenForEvents:[],noInvalidationProps:["enabled","value"]},"sap.ui.comp.smartfield.SmartField":{canOverflow:true,listenForEvents:["change"],noInvalidationProps:["enabled","value","valueState","showValueHelp","contextEditable","clientSideMandatoryCheck","mandatory","name","placeholder","showSuggestion","tooltipLabel"]},"sap.ui.comp.smartfield.SmartLabel":{canOverflow:true,listenForEvents:[],noInvalidationProps:["enabled"]}};a.getControlConfig=function(c){var C=a.getControlClass(c);return a._mSupportedControls[C];};a.supportsControl=function(c){var C=a.getControlClass(c);var o=a._mSupportedControls[C];return typeof o!=="undefined"&&o.canOverflow;};a.getControlClass=function(c){if(c instanceof O){return"sap.m.OverflowToolbarButton";}else if(c instanceof T){return"sap.m.ToggleButton";}else if(c instanceof B){return"sap.m.Button";}return c.getMetadata().getName();};return a;},false);
