/*!
* UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.define(['jquery.sap.global','./library','sap/ui/core/Control','sap/ui/core/IconPool','./Toolbar','./CheckBox','./SearchField'],function(q,l,C,I,T,a,S){"use strict";var L="-list-item";var V=C.extend("sap.m.ViewSettingsDialog",{metadata:{library:"sap.m",properties:{title:{type:"string",group:"Behavior",defaultValue:null},sortDescending:{type:"boolean",group:"Behavior",defaultValue:false},groupDescending:{type:"boolean",group:"Behavior",defaultValue:false},filterSearchOperator:{type:"sap.m.StringFilterOperator",group:"Behavior",defaultValue:sap.m.StringFilterOperator.StartsWith}},aggregations:{sortItems:{type:"sap.m.ViewSettingsItem",multiple:true,singularName:"sortItem",bindable:"bindable"},groupItems:{type:"sap.m.ViewSettingsItem",multiple:true,singularName:"groupItem",bindable:"bindable"},filterItems:{type:"sap.m.ViewSettingsItem",multiple:true,singularName:"filterItem",bindable:"bindable"},presetFilterItems:{type:"sap.m.ViewSettingsItem",multiple:true,singularName:"presetFilterItem",bindable:"bindable"},customTabs:{type:"sap.m.ViewSettingsCustomTab",multiple:true,singularName:"customTab",bindable:"bindable"}},associations:{selectedSortItem:{type:"sap.m.ViewSettingsItem",multiple:false},selectedGroupItem:{type:"sap.m.ViewSettingsItem",multiple:false},selectedPresetFilterItem:{type:"sap.m.ViewSettingsItem",multiple:false}},events:{confirm:{parameters:{sortItem:{type:"sap.m.ViewSettingsItem"},sortDescending:{type:"boolean"},groupItem:{type:"sap.m.ViewSettingsItem"},groupDescending:{type:"boolean"},presetFilterItem:{type:"sap.m.ViewSettingsItem"},filterItems:{type:"sap.m.ViewSettingsItem[]"},filterKeys:{type:"object",deprecated:true},filterCompoundKeys:{type:"object"},filterString:{type:"string"}}},cancel:{},resetFilters:{},filterDetailPageOpened:{parameters:{parentFilterItem:{type:"sap.m.ViewSettingsFilterItem"}}}}}});V.prototype.init=function(){this._rb=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._sDialogWidth="350px";this._sDialogHeight="434px";this._bAppendedToUIArea=false;this._showSubHeader=false;this._filterDetailList=undefined;this._vContentPage=-1;this._oContentItem=null;this._oPreviousState={};this._sCustomTabsButtonsIdPrefix='-custom-button-';};V.prototype.exit=function(){this._rb=null;this._sDialogWidth=null;this._sDialogHeight=null;this._bAppendedToUIArea=null;this._showSubHeader=null;this._vContentPage=null;this._oContentItem=null;this._oPreviousState=null;this._sortContent=null;this._groupContent=null;this._filterContent=null;this._sCustomTabsButtonsIdPrefix=null;this._fnFilterSearchCallback=null;if(this._bAppendedToUIArea){var o=sap.ui.getCore().getStaticAreaRef();o=sap.ui.getCore().getUIArea(o);o.removeContent(this,true);}if(this._dialog){this._dialog.destroy();this._dialog=null;}if(this._navContainer){this._navContainer.destroy();this._navContainer=null;}if(this._titleLabel){this._titleLabel.destroy();this._titleLabel=null;}if(this._page1){this._page1.destroy();this._page1=null;}if(this._header){this._header.destroy();this._header=null;}if(this._resetButton){this._resetButton.destroy();this._resetButton=null;}if(this._subHeader){this._subHeader.destroy();this._subHeader=null;}if(this._segmentedButton){this._segmentedButton.destroy();this._segmentedButton=null;}if(this._sortButton){this._sortButton.destroy();this._sortButton=null;}if(this._groupButton){this._groupButton.destroy();this._groupButton=null;}if(this._filterButton){this._filterButton.destroy();this._filterButton=null;}if(this._sortList){this._sortList.destroy();this._sortList=null;this._ariaSortListInvisibleText.destroy();this._ariaSortListInvisibleText=null;}if(this._sortOrderList){this._sortOrderList.destroy();this._sortOrderList=null;this._ariaSortOrderInvisibleText.destroy();this._ariaSortOrderInvisibleText=null;}if(this._oGroupingNoneItem){this._oGroupingNoneItem.destroy();this._oGroupingNoneItem=null;}if(this._groupList){this._groupList.destroy();this._groupList=null;this._ariaGroupListInvisibleText.destroy();this._ariaGroupListInvisibleText=null;}if(this._groupOrderList){this._groupOrderList.destroy();this._groupOrderList=null;this._ariaGroupOrderInvisibleText.destroy();this._ariaGroupOrderInvisibleText=null;}if(this._presetFilterList){this._presetFilterList.destroy();this._presetFilterList=null;}if(this._filterList){this._filterList.destroy();this._filterList=null;}if(this._page2){this._page2.destroy();this._page2=null;}if(this._detailTitleLabel){this._detailTitleLabel.destroy();this._detailTitleLabel=null;}if(this._filterDetailList){this._filterDetailList.destroy();this._filterDetailList=null;}if(this._oStringFilter){this._oStringFilter=null;}};V.prototype.addCustomTab=function(o){var i=o.getId();if(i==='sort'||i==='filter'||i==='group'){throw'Id "'+i+'" is reserved and cannot be used as custom tab id.';}this.addAggregation('customTabs',o);return this;};V.prototype.invalidate=function(){if(this._dialog&&(!arguments[0]||arguments[0]&&arguments[0].getId()!==this.getId()+"-dialog")){this._dialog.invalidate(arguments);}else{C.prototype.invalidate.apply(this,arguments);}};V.prototype.addStyleClass=function(){var D=this._getDialog();D.addStyleClass.apply(D,arguments);return this;};V.prototype.removeStyleClass=function(){var D=this._getDialog();D.removeStyleClass.apply(D,arguments);return this;};V.prototype.toggleStyleClass=function(){var D=this._getDialog();D.toggleStyleClass.apply(D,arguments);return this;};V.prototype.hasStyleClass=function(){var D=this._getDialog();return D.hasStyleClass.apply(D,arguments);};V.prototype.getDomRef=function(){if(this._dialog){return this._dialog.getDomRef.apply(this._dialog,arguments);}else{return null;}};V.prototype.setTitle=function(t){this._getTitleLabel().setText(t);this.setProperty("title",t,true);return this;};V.prototype.addAggregation=function(i,o,j){sap.ui.base.ManagedObject.prototype.addAggregation.apply(this,arguments);return this._attachItemEventHandlers(i,o);};V.prototype.insertAggregation=function(i,o,j,k){sap.ui.base.ManagedObject.prototype.insertAggregation.apply(this,arguments);return this._attachItemEventHandlers(i,o);};V.prototype._attachItemEventHandlers=function(i,o){if(i!=='sortItems'&&i!=='groupItems'&&i!=='filterItems'){return this;}var t=i.replace('Items','');t=t.charAt(0).toUpperCase()+t.slice(1);o.attachEvent('itemPropertyChanged',function(i,E){if(i==='filterItems'&&E.getParameter('changedItem').getParent().getMetadata().getName()==='sap.m.ViewSettingsFilterItem'){if(E.getParameter('propertyKey')!=='selected'){if(this._vContentPage===3&&this._oContentItem){this._setFilterDetailTitle(this._oContentItem);this._initFilterDetailItems(this._oContentItem);}}else{if(this._filterDetailList){var j=this._filterDetailList.getItems();j.forEach(function(k){if(k.data('item').getId()===E.getParameter('changedItem').getId()){k.setSelected(E.getParameter('propertyValue'));}});this._updateSelectAllCheckBoxState();}}}else{if(typeof this['_init'+t+'Content']==='function'){this['_init'+t+'Content']();}if(typeof this['_init'+t+'Items']==='function'){this['_init'+t+'Items']();}}}.bind(this,i));o.attachEvent('filterDetailItemsAggregationChange',function(E){if(this._vContentPage===3&&this._oContentItem){this._setFilterDetailTitle(this._oContentItem);this._initFilterDetailItems(this._oContentItem);}}.bind(this));return this;};V.prototype._setFilterDetailTitle=function(i){this._getDetailTitleLabel().setText(this._rb.getText("VIEWSETTINGS_TITLE_FILTERBY")+" "+i.getText());};V.prototype.updateAggregation=function(i){sap.ui.base.ManagedObject.prototype.updateAggregation.apply(this,arguments);if(i!=='sortItems'&&i!=='groupItems'&&i!=='filterItems'){return this;}var t=i.replace('Items','');t=t.charAt(0).toUpperCase()+t.slice(1);if(typeof this['_init'+t+'Content']==='function'){this['_init'+t+'Content']();}if(typeof this['_init'+t+'Items']==='function'){this['_init'+t+'Items']();}};V.prototype.addSortItem=function(i){this.addAggregation("sortItems",i);if(i.getSelected()){this.setSelectedSortItem(i);}return this;};V.prototype.addGroupItem=function(i){this.addAggregation("groupItems",i);if(i.getSelected()){this.setSelectedGroupItem(i);}return this;};V.prototype.addPresetFilterItem=function(i){this.addAggregation("presetFilterItems",i);if(i.getSelected()){this.setSelectedPresetFilterItem(i);}return this;};V.prototype.setSelectedSortItem=function(j){var k=this.getSortItems(),i=0,o=f(j,k,"Could not set selected sort item. Item is not found: '"+j+"'");if(v(o)){for(i=0;i<k.length;i++){if(k[i].getId()!==o.getId()){k[i].setProperty('selected',false,true);}}if(o.getProperty('selected')!==true){o.setProperty('selected',true,true);}if(this._getDialog().isOpen()){this._updateListSelection(this._sortList,o);}this.setAssociation("selectedSortItem",o,true);}return this;};V.prototype.setSelectedGroupItem=function(j){var k=this.getGroupItems(),i=0,o=f(j,k,"Could not set selected group item. Item is not found: '"+j+"'");if(v(o)){for(i=0;i<k.length;i++){k[i].setProperty('selected',false,true);}o.setProperty('selected',true,true);if(this._getDialog().isOpen()){this._updateListSelection(this._groupList,o);}this.setAssociation("selectedGroupItem",o,true);}return this;};V.prototype.setSelectedPresetFilterItem=function(j){var k=this.getPresetFilterItems(),i=0,o=f(j,k,"Could not set selected preset filter item. Item is not found: '"+j+"'");if(v(o)){for(i=0;i<k.length;i++){k[i].setProperty('selected',false,true);}o.setProperty('selected',true,true);this._clearSelectedFilters();this.setAssociation("selectedPresetFilterItem",o,true);}return this;};V.prototype.open=function(p){if(!this.getParent()&&!this._bAppendedToUIArea){var o=sap.ui.getCore().getStaticAreaRef();o=sap.ui.getCore().getUIArea(o);o.addContent(this,true);this._bAppendedToUIArea=true;}if(p&&this._vContentPage===3){q.sap.delayedCall(0,this._getNavContainer(),"to",[this._getPage1().getId(),"show"]);}this._initDialogContent(p);this._oPreviousState={sortItem:sap.ui.getCore().byId(this.getSelectedSortItem()),sortDescending:this.getSortDescending(),groupItem:sap.ui.getCore().byId(this.getSelectedGroupItem()),groupDescending:this.getGroupDescending(),presetFilterItem:sap.ui.getCore().byId(this.getSelectedPresetFilterItem()),filterKeys:this.getSelectedFilterKeys(),filterCompoundKeys:this.getSelectedFilterCompoundKeys(),navPage:this._getNavContainer().getCurrentPage(),contentPage:this._vContentPage,contentItem:this._oContentItem};if(sap.ui.Device.system.desktop){this._getDialog().attachEventOnce("afterOpen",function(){var i=this._getNavContainer().getCurrentPage(),$;if(i){$=i.$("cont").firstFocusableDomRef();if($){if(q($).hasClass('sapMListUl')){var j=q($).find('.sapMLIB');j.length&&j[0].focus();return;}$.focus();}}},this);}this._getDialog().open();return this;};V.prototype.getSelectedFilterItems=function(){var k=[],F=this.getFilterItems(),m,M=true,i=0,j;for(;i<F.length;i++){if(F[i]instanceof sap.m.ViewSettingsCustomItem){if(F[i].getSelected()){k.push(F[i]);}}else if(F[i]instanceof sap.m.ViewSettingsFilterItem){m=F[i].getItems();M=F[i].getMultiSelect();for(j=0;j<m.length;j++){if(m[j].getSelected()){k.push(m[j]);if(!M){break;}}}}}return k;};V.prototype.getSelectedFilterString=function(){var F="",k,p=this.getSelectedPresetFilterItem(),m=this.getFilterItems(),n,M=true,i=0,j;if(p){F=this._rb.getText("VIEWSETTINGS_FILTERTEXT").concat(" "+sap.ui.getCore().byId(p).getText());}else{for(;i<m.length;i++){if(m[i]instanceof sap.m.ViewSettingsCustomItem){if(m[i].getSelected()){F+=m[i].getText()+", ";}}else if(m[i]instanceof sap.m.ViewSettingsFilterItem){n=m[i].getItems();M=m[i].getMultiSelect();k="";for(j=0;j<n.length;j++){if(n[j].getSelected()){k+=n[j].getText()+", ";if(!M){break;}}}k=k.substring(0,k.length-2);if(k){k=" ("+k+")";F+=m[i].getText()+k+", ";}}}F=F.substring(0,F.length-2);if(F){F=this._rb.getText("VIEWSETTINGS_FILTERTEXT").concat(" "+F);}}return F;};V.prototype.getSelectedFilterKeys=function(){var o={},j=this.getSelectedFilterItems(),i=0;for(;i<j.length;i++){o[j[i].getKey()]=j[i].getSelected();}return o;};V.prototype.getSelectedFilterCompoundKeys=function(){var o={},j=this.getSelectedFilterItems(),i,k,p,F;for(i=0;i<j.length;i++){F=j[i];if(F instanceof sap.m.ViewSettingsCustomItem){k=F.getKey();o[k]=F.getSelected();}else{k=F.getKey();p=F.getParent().getKey();if(!o[p]){o[p]={};}o[p][k]=F.getSelected();}}return o;};V.prototype.setSelectedFilterKeys=function(o){var F=this.getFilterItems(),m={},n,M,i,j,k;if(Object.keys(o).length){this._clearPresetFilter();}for(var K in o){n=null;if(o.hasOwnProperty(K)){for(i=0;i<F.length;i++){if(F[i]instanceof sap.m.ViewSettingsCustomItem){if(F[i].getKey()===K){n=F[i];F[i].setProperty('selected',o[K],true);}}else if(F[i]instanceof sap.m.ViewSettingsFilterItem){m=F[i].getItems();M=F[i].getMultiSelect();for(j=0;j<m.length;j++){if(m[j].getKey()===K){n=m[j];if(!M){for(k=0;k<m.length;k++){m[k].setProperty('selected',false,true);}}break;}}}if(n){break;}}if(n===null){q.sap.log.warning('Cannot set state for key "'+K+'" because there is no filter with these keys');continue;}n.setProperty('selected',o[K],true);}}return this;};V.prototype.setSelectedFilterCompoundKeys=function(o){var F=this.getFilterItems();var G=function(F,t,k){if(!t.hasOwnProperty(k)){return;}var n=g(F,k);return n;};if(Object.keys(o).length){this._clearPresetFilter();}for(var p in o){var P=G(F,o,p);if(!P){q.sap.log.warning('No filter with key "'+p);continue;}if(P instanceof sap.m.ViewSettingsCustomItem){P.setProperty('selected',o[p],true);}else if(P instanceof sap.m.ViewSettingsFilterItem){var i=o[p];var j=P.getItems();var m=P.getMultiSelect();for(var k in i){var n=G(j,i,k);if(!n){q.sap.log.warning('No filter with key "'+k);continue;}if(!m){j.forEach(function(t){t.setProperty('selected',false,true);});}n.setProperty('selected',i[k],true);}}}return this;};V.prototype._getDialog=function(){var t=this;if(this._dialog===undefined){this._dialog=new sap.m.Dialog(this.getId()+"-dialog",{showHeader:false,stretch:sap.ui.Device.system.phone,verticalScrolling:true,horizontalScrolling:false,contentWidth:this._sDialogWidth,contentHeight:this._sDialogHeight,content:this._getNavContainer(),beginButton:new sap.m.Button(this.getId()+"-acceptbutton",{text:this._rb.getText("VIEWSETTINGS_ACCEPT")}).attachPress(this._onConfirm,this),endButton:new sap.m.Button(this.getId()+"-cancelbutton",{text:this._rb.getText("VIEWSETTINGS_CANCEL")}).attachPress(this._onCancel,this)}).addStyleClass("sapMVSD");this.addDependent(this._dialog);var D=this._dialog.onsapescape;this._dialog.onsapescape=function(E){if(D){D.call(t._dialog,E);}t._onCancel();};this._dialog.onsapentermodifiers=function(E){if(E.shiftKey&&!E.ctrlKey&&!E.altKey){t._pressBackButton();}};}return this._dialog;};V.prototype._getNavContainer=function(){if(this._navContainer===undefined){this._navContainer=new sap.m.NavContainer(this.getId()+'-navcontainer',{pages:[]});}return this._navContainer;};V.prototype._getTitleLabel=function(){if(this._titleLabel===undefined){this._titleLabel=new sap.m.Label(this.getId()+"-title",{text:this._rb.getText("VIEWSETTINGS_TITLE")}).addStyleClass("sapMVSDTitle");}return this._titleLabel;};V.prototype._getResetButton=function(){var t=this;if(this._resetButton===undefined){this._resetButton=new sap.m.Button(this.getId()+"-resetbutton",{icon:I.getIconURI("refresh"),press:function(){t._onClearFilters();},tooltip:this._rb.getText("VIEWSETTINGS_CLEAR_FILTER_TOOLTIP")});}return this._resetButton;};V.prototype._getDetailTitleLabel=function(){if(this._detailTitleLabel===undefined){this._detailTitleLabel=new sap.m.Label(this.getId()+"-detailtitle",{text:this._rb.getText("VIEWSETTINGS_TITLE_FILTERBY")}).addStyleClass("sapMVSDTitle");}return this._detailTitleLabel;};V.prototype._getHeader=function(){if(this._header===undefined){this._header=new sap.m.Bar({contentMiddle:[this._getTitleLabel()]}).addStyleClass("sapMVSDBar");}return this._header;};V.prototype._getSubHeader=function(){if(this._subHeader===undefined){this._subHeader=new sap.m.Bar({contentLeft:[this._getSegmentedButton()]}).addStyleClass("sapMVSDBar");}return this._subHeader;};V.prototype._getSegmentedButton=function(){var t=this,j=this.getCustomTabs(),k=j.length,i=0;if(this._segmentedButton===undefined){this._segmentedButton=new sap.m.SegmentedButton({select:function(E){var m=E.getParameter('id');if(m===t.getId()+"-sortbutton"){t._switchToPage(0);}else if(m===t.getId()+"-groupbutton"){t._switchToPage(1);}else if(m===t.getId()+"-filterbutton"){t._switchToPage(2);}else{for(i=0;i<k;i++){var o=j[i];if(!t._isEmptyTab(o)&&m===o.getTabButton().getId()){t._switchToPage(o.getId());break;}}}q.sap.log.info('press event segmented: '+E.getParameter('id'));}}).addStyleClass("sapMVSDSeg");this._segmentedButton._bPreventWidthRecalculationOnAfterRendering=true;}return this._segmentedButton;};V.prototype._getSortButton=function(){if(this._sortButton===undefined){this._sortButton=new sap.m.Button(this.getId()+"-sortbutton",{icon:I.getIconURI("sort"),tooltip:this._rb.getText("VIEWSETTINGS_TITLE_SORT")});}return this._sortButton;};V.prototype._getGroupButton=function(){if(this._groupButton===undefined){this._groupButton=new sap.m.Button(this.getId()+"-groupbutton",{icon:I.getIconURI("group-2"),tooltip:this._rb.getText("VIEWSETTINGS_TITLE_GROUP")});}return this._groupButton;};V.prototype._getFilterButton=function(){if(this._filterButton===undefined){this._filterButton=new sap.m.Button(this.getId()+"-filterbutton",{icon:I.getIconURI("filter"),tooltip:this._rb.getText("VIEWSETTINGS_TITLE_FILTER")});}return this._filterButton;};V.prototype._getPage1=function(i){if(this._page1===undefined&&!i){this._page1=new sap.m.Page(this.getId()+'-page1',{title:this._rb.getText("VIEWSETTINGS_TITLE"),customHeader:this._getHeader()});this._getNavContainer().addPage(this._page1);}return this._page1;};V.prototype._getPage2=function(){var t=this,D,B,o;if(this._page2===undefined){B=new sap.m.Button(this.getId()+"-backbutton",{icon:I.getIconURI("nav-back"),press:[this._pressBackButton,this]});o=new sap.m.Button(this.getId()+"-detailresetbutton",{icon:I.getIconURI("refresh"),press:function(){t._onClearFilters();},tooltip:this._rb.getText("VIEWSETTINGS_CLEAR_FILTER_TOOLTIP")});D=new sap.m.Bar({contentLeft:[B],contentMiddle:[this._getDetailTitleLabel()],contentRight:[o]}).addStyleClass("sapMVSDBar");this._page2=new sap.m.Page(this.getId()+'-page2',{title:this._rb.getText("VIEWSETTINGS_TITLE_FILTERBY"),customHeader:D});this._getNavContainer().addPage(this._page2);}return this._page2;};V.prototype._initFilterDetailItems=function(o){var k;var m=o.getMultiSelect();var n=o.getItems();var t=this;if(this._filterDetailList){this._filterDetailList.destroy();}this._getPage2().removeAllAggregation('content');this._filterDetailList=new sap.m.List({mode:(m?sap.m.ListMode.MultiSelect:sap.m.ListMode.SingleSelectLeft),includeItemInSelection:true,selectionChange:function(E){var p,u=E.getParameter("listItems"),w,i=0,N;t._clearPresetFilter();if(m){this._updateSelectAllCheckBoxState();}if(u.length>1&&m){w=o.getItems();for(;i<w.length;i++){for(var j=0;j<u.length;j++){if(w[i].getKey()===u[j].getCustomData()[0].getValue().getKey()){w[i].setProperty('selected',u[j].getSelected(),true);}}}}else{p=E.getParameter("listItem").data("item");if(!o.getMultiSelect()){w=o.getItems();for(;i<w.length;i++){if(w[i].getId()!==p.getId()){w[i].setProperty('selected',false,true);}}}N=E.getParameter("listItem").getSelected();if(p.getProperty('selected')!==N){p.setProperty('selected',N,true);}}}.bind(this)});for(var i=0;i<n.length;i++){k=new sap.m.StandardListItem({title:n[i].getText(),type:sap.m.ListType.Active,selected:n[i].getSelected()}).data("item",n[i]);this._filterDetailList.addItem(k);}if(m){this._filterSearchField=this._getFilterSearchField(this._filterDetailList);this._selectAllCheckBox=this._createSelectAllCheckbox(n,this._filterDetailList);this._getPage2().addContent(this._filterSearchField.addStyleClass('sapMVSDFilterSearchField'));this._getPage2().getCustomHeader().addStyleClass('sapMVSDBarWithSearch');this._filterDetailList.setHeaderToolbar(new T({content:[this._selectAllCheckBox]}).addStyleClass('sapMVSDFilterHeaderToolbar'));}this._getPage2().addContent(this._filterDetailList);};V.prototype._initSortItems=function(){var i,o;this._sortList.destroyItems();i=this.getSortItems();if(i.length){i.forEach(function(j){o=new sap.m.StandardListItem({id:j.getId()+L,title:j.getText(),type:sap.m.ListType.Active,selected:j.getSelected()}).data("item",j);this._sortList.addItem(o);},this);}};V.prototype._initSortContent=function(){var t=this;if(this._sortContent){return;}this._vContentPage=-1;this._ariaSortOrderInvisibleText=new sap.ui.core.InvisibleText(this.getId()+"-sortOrderLabel",{text:this._rb.getText("VIEWSETTINGS_SORT_DIRECTION").concat(":")});this._sortOrderList=new sap.m.List(this.getId()+"-sortorderlist",{mode:sap.m.ListMode.SingleSelectLeft,includeItemInSelection:true,selectionChange:function(E){t.setProperty('sortDescending',E.getParameter("listItem").data("item"),true);},ariaLabelledBy:this._ariaSortOrderInvisibleText}).addStyleClass("sapMVSDUpperList");this._sortOrderList.addItem(new sap.m.StandardListItem({title:this._rb.getText("VIEWSETTINGS_ASCENDING_ITEM")}).data("item",false).setSelected(true));this._sortOrderList.addItem(new sap.m.StandardListItem({title:this._rb.getText("VIEWSETTINGS_DESCENDING_ITEM")}).data("item",true));this._ariaSortListInvisibleText=new sap.ui.core.InvisibleText(this.getId()+"-sortListLabel",{text:this._rb.getText("VIEWSETTINGS_TITLE_SORT").concat(":")});this._sortList=new sap.m.List(this.getId()+"-sortlist",{mode:sap.m.ListMode.SingleSelectLeft,includeItemInSelection:true,selectionChange:function(E){var o=sap.ui.getCore().byId(t.getSelectedSortItem());var i=E.getParameter("listItem").data("item");if(i){if(o){o.setSelected(!E.getParameter("listItem").getSelected());}i.setProperty('selected',E.getParameter("listItem").getSelected(),true);}t.setAssociation("selectedSortItem",i,true);},ariaLabelledBy:this._ariaSortListInvisibleText});this._sortContent=[this._ariaSortOrderInvisibleText,this._sortOrderList,this._ariaSortListInvisibleText,this._sortList];};V.prototype._initGroupItems=function(){var o,H,G=this.getGroupItems();this._groupList.destroyItems();if(!!G.length){G.forEach(function(i){o=new sap.m.StandardListItem({id:i.getId()+L,title:i.getText(),type:sap.m.ListType.Active,selected:i.getSelected()}).data("item",i);this._groupList.addItem(o);},this);if(!this._oGroupingNoneItem||this._oGroupingNoneItem.bIsDestroyed){H=!!this.getSelectedGroupItem();this._oGroupingNoneItem=new sap.m.ViewSettingsItem({text:this._rb.getText("VIEWSETTINGS_NONE_ITEM"),selected:!H,itemPropertyChanged:function(){this._initGroupContent();this._initGroupItems();}.bind(this)});!H&&this.setAssociation("selectedGroupItem",this._oGroupingNoneItem,true);}o=new sap.m.StandardListItem({id:this._oGroupingNoneItem.getId()+L,title:this._oGroupingNoneItem.getText(),type:sap.m.ListType.Active,selected:this._oGroupingNoneItem.getSelected()}).data("item",this._oGroupingNoneItem);this._groupList.addItem(o);}};V.prototype._initGroupContent=function(){var t=this;if(this._groupContent){return;}this._vContentPage=-1;this._ariaGroupOrderInvisibleText=new sap.ui.core.InvisibleText(this.getId()+"-groupOrderLabel",{text:this._rb.getText("VIEWSETTINGS_GROUP_DIRECTION").concat(":")});this._groupOrderList=new sap.m.List(this.getId()+"-grouporderlist",{mode:sap.m.ListMode.SingleSelectLeft,includeItemInSelection:true,selectionChange:function(E){t.setProperty('groupDescending',E.getParameter("listItem").data("item"),true);},ariaLabelledBy:this._ariaGroupOrderInvisibleText}).addStyleClass("sapMVSDUpperList");this._groupOrderList.addItem(new sap.m.StandardListItem({title:this._rb.getText("VIEWSETTINGS_ASCENDING_ITEM")}).data("item",false).setSelected(true));this._groupOrderList.addItem(new sap.m.StandardListItem({title:this._rb.getText("VIEWSETTINGS_DESCENDING_ITEM")}).data("item",true));this._ariaGroupListInvisibleText=new sap.ui.core.InvisibleText(this.getId()+"-groupListLabel",{text:this._rb.getText("VIEWSETTINGS_TITLE_GROUP").concat(":")});this._groupList=new sap.m.List(this.getId()+"-grouplist",{mode:sap.m.ListMode.SingleSelectLeft,includeItemInSelection:true,selectionChange:function(E){var i=E.getParameter("listItem").data("item");t.setSelectedGroupItem(i);},ariaLabelledBy:this._ariaGroupListInvisibleText});this._groupContent=[this._ariaGroupOrderInvisibleText,this._groupOrderList,this._ariaGroupListInvisibleText,this._groupList];};V.prototype._initFilterItems=function(){var p,F,o,t=this;this._presetFilterList.destroyItems();p=this.getPresetFilterItems();if(p.length){p.forEach(function(i){o=new sap.m.StandardListItem({id:i.getId()+L,title:i.getText(),type:sap.m.ListType.Active,selected:i.getSelected()}).data("item",i);this._presetFilterList.addItem(o);},this);}if(p.length){o=new sap.m.StandardListItem({id:"none"+L,title:this._rb.getText("VIEWSETTINGS_NONE_ITEM"),selected:!!this.getSelectedPresetFilterItem()});this._presetFilterList.addItem(o);}this._filterList.destroyItems();F=this.getFilterItems();if(F.length){F.forEach(function(i){o=new sap.m.StandardListItem({id:i.getId()+L,title:i.getText(),type:sap.m.ListType.Active,press:(function(i){return function(E){if(t._navContainer.getCurrentPage().getId()!==t.getId()+'-page2'){t._switchToPage(3,i);t._prevSelectedFilterItem=this;q.sap.delayedCall(0,t._navContainer,"to",[t.getId()+'-page2',"slide"]);}if(sap.ui.Device.system.desktop&&t._filterDetailList&&t._filterDetailList.getItems()[0]){t._getNavContainer().attachEventOnce("afterNavigate",function(){t._filterDetailList.getItems()[0].focus();});}};}(i))}).data("item",i);this._filterList.addItem(o);},this);}};V.prototype._initFilterContent=function(){var t=this;if(this._filterContent){return;}this._vContentPage=-1;this._presetFilterList=new sap.m.List(this.getId()+"-predefinedfilterlist",{mode:sap.m.ListMode.SingleSelectLeft,includeItemInSelection:true,selectionChange:function(E){var i=E.getParameter("listItem").data("item");if(i){i.setProperty('selected',E.getParameter("listItem").getSelected(),true);}t.setAssociation("selectedPresetFilterItem",i,true);t._clearSelectedFilters();}}).addStyleClass("sapMVSDUpperList");this._filterList=new sap.m.List(this.getId()+"-filterlist",{});this._filterContent=[this._presetFilterList,this._filterList];};V.prototype._initDialogContent=function(p){var i=!!this.getSortItems().length,G=!!this.getGroupItems().length,P=!!this.getPresetFilterItems().length,F=!!this.getFilterItems().length;if(i){this._initSortContent();this._initSortItems();}if(G){this._initGroupContent();this._initGroupItems();}if(P||F){this._initFilterContent();this._initFilterItems();}this._updateDialogState(p);this._updateListSelections();};V.prototype._updateDialogState=function(p){var i=!!this.getSortItems().length,G=!!this.getGroupItems().length,P=!!this.getPresetFilterItems().length,F=!!this.getFilterItems().length,j=!!this.getCustomTabs().length,o=this._getSegmentedButton(),k=null,m=false,D={"sort":0,"group":1,"filter":2};o.removeAllButtons();if(this._filterContent){this._presetFilterList.setVisible(true);this._filterList.setVisible(true);}if(i){o.addButton(this._getSortButton());}if(P||F){o.addButton(this._getFilterButton());if(!P){this._presetFilterList.setVisible(false);this._presetFilterList.addStyleClass("sapMVSDUpperList");}if(!F){this._filterList.setVisible(false);this._presetFilterList.removeStyleClass("sapMVSDUpperList");}}if(G){o.addButton(this._getGroupButton());}if(j){this.getCustomTabs().forEach(function(t){if(!this._isEmptyTab(t)){var B=t.getTabButton({'idPrefix':this.getId()+this._sCustomTabsButtonsIdPrefix});o.addButton(B);}}.bind(this));}this._showSubHeader=this._hasSubHeader();if(p===undefined&&this._vContentPage!==-1){p=this._vContentPage;switch(p){case 0:p='sort';break;case 1:p='group';break;case 2:p='filter';break;}}if(p===this._vContentPage&&this._vContentPage===3){this._vContentPage=-1;this._switchToPage(3,this._oContentItem);}else{p=this._determineValidPageId(p);for(var n in D){if(p===n){m=true;k=this.getId()+'-'+p+'button';p=D[n];break;}}if(!m){k=this.getId()+this._sCustomTabsButtonsIdPrefix+p;}this._getSegmentedButton().setSelectedButton(k);this._switchToPage(p);if(this._getNavContainer().getCurrentPage()!==this._getPage1()){this._getNavContainer().to(this._getPage1().getId());}}};V.prototype._determineValidPageId=function(p){var D='sort',H=false,i=[];i=this._fetchValidPagesIds();if(i.length){D=i[0];}else{q.sap.log.warning('No available pages to load - missing items.');}if(!p){p=D;}else{i.filter(function(j){if(j===p){H=true;return false;}return true;});if(!H){p=D;}}return p;};V.prototype._fetchValidPagesIds=function(){var i,j=this.getCustomTabs(),k=j.length,m=[];var p=['sort','filter','group'];p.forEach(function(P){if(this._isValidPredefinedPageId(P)){m.push(P);}},this);for(i=0;i<k;i++){var o=j[i];if(!this._isEmptyTab(o)){m.push(o.getId());}}return m;};V.prototype._isEmptyTab=function(o){return!(o.getContent().length||this._vContentPage===o.getId()&&this._getPage1().getContent().length);};V.prototype._isValidPredefinedPageId=function(n){if(!n){q.sap.log.warning('Missing mandatory parameter.');return false;}var H=false;switch(n){case'sort':H=!!this.getSortItems().length;break;case'filter':H=!!this.getFilterItems().length||!!this.getPresetFilterItems().length;break;case'group':H=!!this.getGroupItems().length;break;}return H;};sap.m.ViewSettingsDialog.prototype._pressBackButton=function(){var t=this;if(this._vContentPage===3){this._updateFilterCounters();this._getNavContainer().attachEvent("afterNavigate",function(){if(t._prevSelectedFilterItem){t._prevSelectedFilterItem.focus();}});q.sap.delayedCall(0,this._getNavContainer(),'back');this._switchToPage(2);this._segmentedButton.setSelectedButton(this._filterButton);}};V.prototype.setModel=function(m,n){if(this._vContentPage===3&&this._oContentItem){r.call(this);}return sap.ui.base.ManagedObject.prototype.setModel.call(this,m,n);};V.prototype.removeFilterItem=function(F){var i="";if(this._vContentPage===3&&this._oContentItem){if(typeof(F)==="object"){i=F.getId();}else if(typeof(F)==="string"){i=F;}else if(typeof(F)==="number"){i=this.getFilterItems()[F].getId();}if(this._oContentItem.getId()===i){r.call(this);}}return this.removeAggregation('filterItems',F);};V.prototype.removeAllFilterItems=function(){if(this._vContentPage===3&&this._oContentItem){r.call(this);}return this.removeAllAggregation('filterItems');};V.prototype.setFilterSearchCallback=function(t){this._fnFilterSearchCallback=t;return this;};V.prototype._switchToPage=function(w,o){var i=0,t=this._getTitleLabel(),R=this._getResetButton(),H=this._getHeader(),j=this._getSubHeader();if(this._vContentPage===w&&w!==3){if(H.getContentRight().length===0&&j.getContentRight().length===0){this._addResetButtonToPage1();}return false;}this._getPage2().getCustomHeader().removeStyleClass('sapMVSDBarWithSearch');if(c.call(this)){b.call(this);}H.removeAllContentRight();j.removeAllContentRight();this._vContentPage=w;this._oContentItem=o;if(w!==3){this._getPage1().removeAllAggregation("content",true);this._addResetButtonToPage1();}else if(w===3){this._getPage2().removeAllAggregation("content",true);}if(this.getTitle()){t.setText(this.getTitle());}else{t.setText(this._rb.getText("VIEWSETTINGS_TITLE"));}switch(w){case 1:R.setVisible(false);if(!this._showSubHeader&&!this.getTitle()){t.setText(this._rb.getText("VIEWSETTINGS_TITLE_GROUP"));}for(;i<this._groupContent.length;i++){this._getPage1().addContent(this._groupContent[i]);}break;case 2:R.setVisible(!!this.getFilterItems().length);if(!this._showSubHeader&&!this.getTitle()){t.setText(this._rb.getText("VIEWSETTINGS_TITLE_FILTER"));}this._updateListSelection(this._presetFilterList,sap.ui.getCore().byId(this.getSelectedPresetFilterItem()));this._updateFilterCounters();for(;i<this._filterContent.length;i++){this._getPage1().addContent(this._filterContent[i]);}break;case 3:this._setFilterDetailTitle(o);if(o instanceof sap.m.ViewSettingsCustomItem&&o.getCustomControl()){this._clearPresetFilter();this._getPage2().addContent(o.getCustomControl());}else if(o instanceof sap.m.ViewSettingsFilterItem&&o.getItems()){this._initFilterDetailItems(o);}break;case 0:R.setVisible(false);if(!this._getPage1().getSubHeader()&&!this.getTitle()){t.setText(this._rb.getText("VIEWSETTINGS_TITLE_SORT"));}if(this._sortContent){for(;i<this._sortContent.length;i++){this._getPage1().addContent(this._sortContent[i]);}}break;default:R.setVisible(false);this._getPage1().removeAllAggregation("content",true);var k="VIEWSETTINGS_TITLE";var m=this.getCustomTabs();if(m.length<2){k=m[0].getTitle();}if(!this._getPage1().getSubHeader()&&!this.getTitle()){t.setText(k);}m.forEach(function(n){if(n.getId()===w){n.getContent().forEach(function(p){this._getPage1().addContent(p);},this);}},this);break;}if(w===3){this.fireFilterDetailPageOpened({parentFilterItem:o});}};V.prototype._createSelectAllCheckbox=function(F,o){var i=false;if(F&&F.length!==0){i=F.every(function(k){return k.getSelected();});}var j=new a({text:this._rb.getText("COLUMNSPANEL_SELECT_ALL"),selected:i,select:function(E){var k=E.getParameter('selected');o.getItems().filter(function(m){return m.getVisible();}).forEach(function(m){var n=m.data("item");n.setSelected(k);});}});return j;};V.prototype._updateSelectAllCheckBoxState=function(){var i=false,j=this._filterDetailList.getItems(),k=[];if(!this._selectAllCheckBox){return;}if(j&&j.length!==0){k=j.filter(function(o){return o.getVisible();});}if(k.length!==0){i=k.every(function(o){return o.getSelected();});}this._selectAllCheckBox.setSelected(i);};V.prototype._getFilterSearchField=function(F){var t=this,o=new S({liveChange:function(E){var Q=E.getParameter('newValue'),i=t._getStringFilter();F.getItems().forEach(function(j){var k=i(Q,j.getTitle());j.setVisible(k);});t._updateSelectAllCheckBoxState();}});return o;};V.prototype._getStringFilter=function(){if(this._fnFilterSearchCallback){return this._fnFilterSearchCallback;}if(!this._oStringFilter||this._oStringFilter.sOperator!==this.getFilterSearchOperator()){this._oStringFilter=new d(this.getFilterSearchOperator());}return this._oStringFilter.filter.bind(this._oStringFilter);};V.prototype._updateListSelections=function(){this._updateListSelection(this._sortList,sap.ui.getCore().byId(this.getSelectedSortItem()));this._updateListSelection(this._sortOrderList,this.getSortDescending());this._updateListSelection(this._groupList,sap.ui.getCore().byId(this.getSelectedGroupItem()));this._updateListSelection(this._groupOrderList,this.getGroupDescending());this._updateListSelection(this._presetFilterList,sap.ui.getCore().byId(this.getSelectedPresetFilterItem()));this._updateFilterCounters();};V.prototype._updateListSelection=function(o,j){var k,i=0;if(!o){return false;}k=o.getItems();o.removeSelections();for(;i<k.length;i++){if(k[i].data("item")===j||k[i].data("item")===null){o.setSelectedItem(k[i],(j&&j.getSelected?j.getSelected():true));return true;}}return false;};V.prototype._updateFilterCounters=function(){var k=(this._filterList?this._filterList.getItems():[]),o,m,F=0,i=0,j;for(;i<k.length;i++){o=k[i].data("item");F=0;if(o){if(o instanceof sap.m.ViewSettingsCustomItem){F=o.getFilterCount();}else if(o instanceof sap.m.ViewSettingsFilterItem){F=0;m=o.getItems();for(j=0;j<m.length;j++){if(m[j].getSelected()){F++;}}}}k[i].setCounter(F);}};V.prototype._clearSelectedFilters=function(){var k=this.getFilterItems(),m,i=0,j;for(;i<k.length;i++){if(k[i]instanceof sap.m.ViewSettingsFilterItem){m=k[i].getItems();for(j=0;j<m.length;j++){m[j].setProperty('selected',false,true);}}k[i].setProperty('selected',false,true);}if(this._vContentPage===2&&this._getDialog().isOpen()){this._updateFilterCounters();}};V.prototype._clearPresetFilter=function(){if(this.getSelectedPresetFilterItem()){this.setSelectedPresetFilterItem(null);}};V.prototype._calculateNumberOfPages=function(){var i=0,j=!!this.getSortItems().length,G=!!this.getGroupItems().length,p=!!this.getPresetFilterItems().length,F=!!this.getFilterItems().length;if(j){i++;}if(p||F){i++;}if(G){i++;}this.getCustomTabs().forEach(function(o){if(!this._isEmptyTab(o)){i++;}},this);return i;};V.prototype._hasSubHeader=function(){return!(this._calculateNumberOfPages()<2);};function r(){this._vContentPage=2;this._oContentItem=null;this._navContainer.to(this._getPage1().getId(),"show");}function g(j,k){var i,o;for(i=0;i<j.length;i++){if(j[i].getKey()===k){o=j[i];break;}}return o;}function f(i,j,E){var o;if(typeof i==="string"){o=g(j,i);if(!o){q.sap.log.error(E);}}else{o=i;}return o;}function v(i){return i&&i instanceof sap.m.ViewSettingsItem;}V.prototype._onConfirm=function(E){var D=this._getDialog(),t=this,i=function(){var o,G,j=t.getSelectedGroupItem();if(!t._oGroupingNoneItem||j!=t._oGroupingNoneItem.getId()){G=sap.ui.getCore().byId(j);}o={sortItem:sap.ui.getCore().byId(t.getSelectedSortItem()),sortDescending:t.getSortDescending(),groupItem:G,groupDescending:t.getGroupDescending(),presetFilterItem:sap.ui.getCore().byId(t.getSelectedPresetFilterItem()),filterItems:t.getSelectedFilterItems(),filterKeys:t.getSelectedFilterKeys(),filterCompoundKeys:t.getSelectedFilterCompoundKeys(),filterString:t.getSelectedFilterString()};t._dialog.detachAfterClose(i);t.fireConfirm(o);};D.attachAfterClose(i);D.close();};V.prototype._onCancel=function(E){var t=this,D=this._getDialog(),i=function(){t.setSelectedSortItem(t._oPreviousState.sortItem);t.setSortDescending(t._oPreviousState.sortDescending);t.setSelectedGroupItem(t._oPreviousState.groupItem);t.setGroupDescending(t._oPreviousState.groupDescending);t.setSelectedPresetFilterItem(t._oPreviousState.presetFilterItem);t._clearSelectedFilters();t.setSelectedFilterCompoundKeys(t._oPreviousState.filterCompoundKeys);if(t._navContainer.getCurrentPage()!==t._oPreviousState.navPage){q.sap.delayedCall(0,t._navContainer,"to",[t._oPreviousState.navPage.getId(),"show"]);}t._switchToPage(t._oPreviousState.contentPage,t._oPreviousState.contentItem);t._dialog.detachAfterClose(i);t.fireCancel();};D.attachAfterClose(i);D.close();};V.prototype._onClearFilters=function(){this._clearSelectedFilters();this._clearPresetFilter();this.fireResetFilters();this._updateFilterCounters();if(this._vContentPage===3){q.sap.delayedCall(0,this._getNavContainer(),'to',[this._getPage1().getId()]);this._switchToPage(2);this._getSegmentedButton().setSelectedButton(this._getFilterButton());}this._updateListSelection(this._presetFilterList,sap.ui.getCore().byId(this.getSelectedPresetFilterItem()));};V.prototype._addResetButtonToPage1=function(){var H=this._getHeader(),o=this._getSubHeader(),R=this._getResetButton();if(this._showSubHeader){if(!this._getPage1().getSubHeader()){this._getPage1().setSubHeader(o);}o.addContentRight(R);}else{if(this._getPage1().getSubHeader()){this._getPage1().setSubHeader();}H.addContentRight(R);}};V.prototype.removeAggregation=function(i,o,j){b.call(this,i,o);return sap.ui.core.Control.prototype.removeAggregation.call(this,i,o,j);};V.prototype.removeAllAggregation=function(i,j){b.call(this);return sap.ui.core.Control.prototype.removeAllAggregation.call(this,i,j);};V.prototype.destroyAggregation=function(i,j){b.call(this);return sap.ui.core.Control.prototype.destroyAggregation.call(this,i,j);};function b(i,o){if(!this._getPage1(true)){return;}if(i==='customTabs'&&o){if(o.getMetadata().getName()===this.getMetadata().getManagedAggregation(i).type&&this._vContentPage===o.getId()){var p=this._getPage1().getContent();p.forEach(function(j){o.addAggregation('content',j,true);});}}else if(!i&&!o){var p=this._getPage1().getContent();this.getCustomTabs().forEach(function(o){if(this._vContentPage===o.getId()){p.forEach(function(j){o.addAggregation('content',j,true);});}},this);}}function c(){var p=[-1,0,1,2,3];return(this._getPage1().getContent().length&&p.indexOf(this._vContentPage)===-1);}V.prototype.setBusy=function(B){this._getDialog().setBusy(B);return this;};var d=function(o){this.sOperator=o||sap.m.StringFilterOperator.StartsWith;switch(this.sOperator){case sap.m.StringFilterOperator.Equals:this.fnOperator=e;break;case sap.m.StringFilterOperator.Contains:this.fnOperator=h;break;case sap.m.StringFilterOperator.StartsWith:this.fnOperator=s;break;case sap.m.StringFilterOperator.AnyWordStartsWith:this.fnOperator=A;break;default:q.sap.log.warning("Unknown string compare operator. Use values from sap.m.StringFilterOperator. Default operator should be used.");this.fnOperator=h;break;}};d.prototype.filter=function(Q,i){if(!Q){return true;}if(!i){return false;}i=i.toLowerCase();Q=Q.toLowerCase();return this.fnOperator(Q,i);};function e(Q,i){return i===Q;}function h(Q,i){return i.indexOf(Q)>-1;}function s(Q,i){return i.indexOf(Q)===0;}function A(Q,i){var j=new RegExp(".*\\b"+Q+".*");return j.test(i);}return V;},true);
