// This file has been generated by the SAPUI5 'AllInOne' Builder
jQuery.sap.declare('sap.tnt.library-all');
if ( !jQuery.sap.isDeclared('sap.tnt.NavigationListRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides the default renderer for control sap.tnt.NavigationList
jQuery.sap.declare('sap.tnt.NavigationListRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained
sap.ui.define("sap/tnt/NavigationListRenderer",['jquery.sap.global', 'sap/ui/core/Renderer'],
	function(jQuery, Renderer) {
		"use strict";

		/**
		 * NavigationListRenderer renderer.
		 *
		 * @author SAP SE
		 * @namespace
		 */
		var NavigationListRenderer = {};

		/**
		 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
		 *
		 * @param {sap.ui.core.RenderManager} rm The RenderManager that can be used for writing to the renderer output buffer
		 * @param {sap.ui.core.Control} control An object representation of the control that should be rendered
		 */
		NavigationListRenderer.render = function (rm, control) {
			var group,
				role,
				groups = control.getItems(),
				expanded = control.getExpanded();

			rm.write("<ul");
			rm.writeControlData(control);

			var width = control.getWidth();
			if (width && expanded) {
				rm.addStyle("width", width);
			}
			rm.writeStyles();

			rm.addClass("sapTntNavLI");

			if (!expanded) {
				rm.addClass("sapTntNavLICollapsed");
			}

			rm.writeClasses();

			// ARIA
			if (control.getHasListBoxRole()) {
				role = 'listbox';
			} else {
				role = expanded ? 'tree' : 'toolbar';
			}

			rm.writeAttribute("role", role);

			rm.write(">");

			for (var i = 0; i < groups.length; i++) {
				group = groups[i];
				group.render(rm, control);
			}

			rm.write("</ul>");
		};

		return NavigationListRenderer;

	}, /* bExport= */ true);

}; // end of sap/tnt/NavigationListRenderer.js
if ( !jQuery.sap.isDeclared('sap.tnt.SideNavigationRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.tnt.SideNavigationRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
sap.ui.define("sap/tnt/SideNavigationRenderer",[],
    function () {
        'use strict';

        /**
         * SideNavigation renderer.
         * @namespace
         */
        var SideNavigationRenderer = {};

        /**
         * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
         *
         * @param {sap.ui.core.RenderManager}
         *          rm the RenderManager that can be used for writing to the render output buffer
         * @param {sap.ui.core.Control}
         *          Control an object representation of the control that should be rendered
         */
        SideNavigationRenderer.render = function (rm, control) {
            this.startSideNavigation(rm, control);

            this.renderArrowUp(rm, control);

            this.renderItem(rm, control);

            this.renderArrowDown(rm, control);

            this.renderFixedItem(rm, control);

            this.renderFooter(rm, control);

            this.endSideNavigation(rm, control);
        };

        SideNavigationRenderer.startSideNavigation = function (rm, control) {
            var itemAggregation = control.getAggregation('item');
            var fixedItemAggregation = control.getAggregation('fixedItem');
            var isExpanded = control.getExpanded();

            rm.write('<div');
            rm.writeControlData(control);

            rm.writeAttribute("role", 'navigation');

            rm.addClass('sapTntSideNavigation');
            rm.addClass("sapContrast sapContrastPlus");

            if (!isExpanded) {
                rm.addClass('sapTntSideNavigationNotExpanded');
                rm.addClass('sapTntSideNavigationNotExpandedWidth');
            }

            if (!isExpanded && itemAggregation) {
                itemAggregation.setExpanded(false);
            }

            if (!isExpanded && fixedItemAggregation) {
                fixedItemAggregation.setExpanded(false);
            }

            rm.writeClasses();
            rm.write('>');
        };

        SideNavigationRenderer.endSideNavigation = function (rm, control) {
            rm.write('</div>');
        };

        SideNavigationRenderer.renderArrowUp = function (rm, control){

                rm.renderControl(control._getTopArrowControl());
        };

        SideNavigationRenderer.renderArrowDown = function (rm, control){

                rm.renderControl(control._getBottomArrowControl());
        };

        SideNavigationRenderer.renderItem = function (rm, control) {
            var itemAggregation = control.getAggregation('item');

            rm.write('<div id="' + control.getId() + '-Flexible" tabindex="-1" class="sapTntSideNavigationFlexible sapTntSideNavigationVerticalScrolling">');
            rm.write('<div id="' + control.getId() + '-Flexible-Content" class="sapTntSideNavigationFlexibleContent">');
            rm.renderControl(itemAggregation);
            rm.write('</div></div>');
        };

        SideNavigationRenderer.renderFixedItem = function (rm, control) {
            var fixedItemAggregation = control.getAggregation('fixedItem');

            if (fixedItemAggregation === null) {
                return;
            }

            if (fixedItemAggregation.getExpanded() === false) {
                fixedItemAggregation.setExpanded(false);
            }

            rm.write('<div class="sapTntSideNavigationSeparator" role="separator" aria-orientation="horizontal"></div>');

            rm.write('<div class="sapTntSideNavigationFixed">');
            rm.renderControl(fixedItemAggregation);
            rm.write('</div>');
        };

        SideNavigationRenderer.renderFooter = function (rm, control) {
            if (control.getAggregation('footer')) {
                rm.write('<footer class="sapTntSideNavigationFooter">');
                rm.renderControl(control.getAggregation('footer'));
                rm.write('</footer>');
            }
        };

        return SideNavigationRenderer;

    }, /* bExport= */ true);

}; // end of sap/tnt/SideNavigationRenderer.js
if ( !jQuery.sap.isDeclared('sap.tnt.ToolHeaderRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.tnt.ToolHeaderRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained
jQuery.sap.require('sap.m.OverflowToolbarRenderer'); // unlisted dependency retained
jQuery.sap.require('sap.m.BarInPageEnabler'); // unlisted dependency retained
sap.ui.define("sap/tnt/ToolHeaderRenderer",['sap/ui/core/Renderer', 'sap/m/OverflowToolbarRenderer', 'sap/m/BarInPageEnabler'],
	function(Renderer, OverflowToolbarRenderer, BarInPageEnabler) {
		"use strict";


		/**
		 * ToolHeaderRenderer renderer.
		 * @namespace
		 */
		var ToolHeaderRenderer = Renderer.extend(OverflowToolbarRenderer);

		ToolHeaderRenderer.renderBarContent = function(rm, toolbar) {

			var overflowToolbarRendered = false;
			var isUtilitySeparator;

			toolbar._getVisibleContent().forEach(function(control) {

				isUtilitySeparator = control.getMetadata().getName() == 'sap.tnt.ToolHeaderUtilitySeparator';

				if (!overflowToolbarRendered && isUtilitySeparator && toolbar._getOverflowButtonNeeded()) {
					ToolHeaderRenderer.renderOverflowButton(rm, toolbar);
					overflowToolbarRendered = true;
				}

				BarInPageEnabler.addChildClassTo(control, toolbar);
				rm.renderControl(control);
			});

			if (!overflowToolbarRendered && toolbar._getOverflowButtonNeeded()) {
				ToolHeaderRenderer.renderOverflowButton(rm, toolbar);
			}
		};

		return ToolHeaderRenderer;

	}, /* bExport= */ true);

}; // end of sap/tnt/ToolHeaderRenderer.js
if ( !jQuery.sap.isDeclared('sap.tnt.ToolPageRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.tnt.ToolPageRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
sap.ui.define("sap/tnt/ToolPageRenderer",[],
	function () {
		'use strict';

		/**
		 * ToolPage renderer
		 * @namespace
		 */
		var ToolPageRenderer = {};

		/**
		 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
		 *
		 * @param {sap.ui.core.RenderManager}
		 *          rm the RenderManager that can be used for writing to the render output buffer
		 * @param {sap.ui.core.Control}
		 *          control an object representation of the control that should be rendered
		 */
		ToolPageRenderer.render = function (rm, control) {
			rm.write('<div');
			rm.writeControlData(control);
			rm.addClass('sapTntToolPage');
			rm.writeClasses();
			rm.write('>');

			this.renderHeader(rm, control);
			this.renderContentWrapper(rm, control);

			rm.write('</div>');
		};

		ToolPageRenderer.renderHeader = function (rm, control) {
			if (control.getAggregation('header')) {
				rm.write('<div id="' + control.getId() + '-header" class="sapTntToolPageHeader">');
				rm.renderControl(control.getAggregation('header'));
				rm.write('</div>');
			}
		};

		ToolPageRenderer.renderContentWrapper = function (rm, control) {
			var isDesktop = sap.ui.Device.system.desktop;

			rm.write('<div class="sapTntToolPageContentWrapper');

			if (!isDesktop || !control.getSideExpanded()) {
				rm.write(' sapTntToolPageAsideCollapsed');
			}

			rm.write('">');
			this.renderAsideContent(rm, control);
			this.renderMainContent(rm, control);
			rm.write('</div>');
		};

		ToolPageRenderer.renderAsideContent = function (rm, control) {
			var isDesktop = sap.ui.Device.system.desktop;
			var sideContentAggregation = control.getAggregation('sideContent');
			var isSideExpanded = control.getSideExpanded();

			rm.write('<aside id="' + control.getId() + '-aside" class="sapTntToolPageAside">');

			rm.write('<div class="sapTntToolPageAsideContent">');

			if (sideContentAggregation && sideContentAggregation.getExpanded() !== isSideExpanded) {
				sideContentAggregation.setExpanded(isSideExpanded);
			}

			if (!isDesktop) {
				control.setSideExpanded(false);
			}

			// The render of the aggregation should be after the above statement,
			// due to class manipulations inside the aggregation.
			rm.renderControl(sideContentAggregation);

			rm.write('</div>');

			rm.write('</aside>');
		};

		ToolPageRenderer.renderMainContent = function (rm, control) {
			var mainContentAggregations = control.getAggregation('mainContents');

			if (mainContentAggregations) {
				rm.write('<div id="' + control.getId() + '-main" class="sapTntToolPageMain">');

				rm.write('<div class="sapTntToolPageMainContent">');
				rm.write('<div class="sapTntToolPageMainContentWrapper">');
				mainContentAggregations.forEach(rm.renderControl);
				rm.renderControl();
				rm.write('</div>');
				rm.write('</div>');

				rm.write('</div>');
			}
		};

		return ToolPageRenderer;

	}, /* bExport= */ true);

}; // end of sap/tnt/ToolPageRenderer.js
if ( !jQuery.sap.isDeclared('sap.tnt.library') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/**
 * Initialization Code and shared classes of library sap.tnt.
 */
jQuery.sap.declare('sap.tnt.library'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.library'); // unlisted dependency retained
jQuery.sap.require('sap.m.library'); // unlisted dependency retained
sap.ui.define("sap/tnt/library",['jquery.sap.global',
	'sap/ui/core/library', 'sap/m/library'], // library dependency
	function(jQuery) {

	'use strict';

	/**
	 * SAPUI5 library with controls specialized for administrative applications.
	 *
	 * @namespace
	 * @name sap.tnt
	 * @author SAP SE
	 * @version 1.42.6
	 * @public
	 */

	// delegate further initialization of this library to the Core
	sap.ui.getCore().initLibrary({
		name : 'sap.tnt',
		version: '1.42.6',
		dependencies : ['sap.ui.core','sap.m'],
		types: [],
		interfaces: [],
		controls: [
			'sap.tnt.NavigationList',
			'sap.tnt.ToolHeaderUtilitySeparator',
			'sap.tnt.ToolHeader',
			'sap.tnt.SideNavigation',
			'sap.tnt.ToolPage'
		],
		elements: [
			"sap.tnt.NavigationListItem"
		]
	});

	return sap.tnt;

});

}; // end of sap/tnt/library.js
if ( !jQuery.sap.isDeclared('sap.tnt.NavigationList') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.tnt.NavigationList
jQuery.sap.declare('sap.tnt.NavigationList'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
jQuery.sap.require('sap.m.Popover'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.delegate.ItemNavigation'); // unlisted dependency retained
sap.ui.define("sap/tnt/NavigationList",['jquery.sap.global', './library', 'sap/ui/core/Control', 'sap/m/Popover', 'sap/ui/core/delegate/ItemNavigation'],
	function(jQuery, library, Control, Popover, ItemNavigation) {
		"use strict";

		/**
		 * Constructor for a new NavigationList.
		 *
		 * @param {string} [sId] ID for the new control, generated automatically if no ID is given
		 * @param {object} [mSettings] Initial settings for the new control
		 *
		 * @class
		 * The NavigationList control is an interactive control, which provides a choice of
		 * different items, ordered as a list.
		 * @extends sap.ui.core.Control
		 *
		 * @author SAP SE
		 * @version 1.42.6
		 *
		 * @constructor
		 * @public
		 * @since 1.34
		 * @alias sap.tnt.NavigationList
		 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
		 */
		var NavigationList = Control.extend("sap.tnt.NavigationList", /** @lends sap.tnt.NavigationList.prototype */ {
			metadata: {
				library: "sap.tnt",
				properties: {
					/**
					 * Specifies the width of the control.
					 */
					width: {type: "sap.ui.core.CSSSize", group: "Dimension"},
					/**
					 * Specifies if the control is in expanded or collapsed mode.
					 */
					expanded: {type: "boolean", group: "Misc", defaultValue: true}
				},
				defaultAggregation: "items",
				aggregations: {

					/**
					 * The items displayed in the list.
					 */
					items: {type: "sap.tnt.NavigationListItem", multiple: true, singularName: "item"}
				},
				associations : {
					/**
					 * Association to controls / IDs, which describe this control (see WAI-ARIA attribute aria-describedby).
					 */
					ariaDescribedBy : { type: "sap.ui.core.Control", multiple: true, singularName: "ariaDescribedBy" },

					/**
					 * Association to controls / IDs, which label this control (see WAI-ARIA attribute aria-labelledby).
					 */
					ariaLabelledBy : { type: "sap.ui.core.Control", multiple: true, singularName: "ariaLabelledBy" }
				},
				events: {
					/**
					 * Fired when an item is selected.
					 */
					itemSelect: {
						parameters: {
							/**
							 * The selected item.
							 */
							item: {type: "sap.ui.core.Item"}
						}
					}
				}
			}
		});

		/**
		 * Initializes the control.
		 * @private
		 * @override
		 */
		NavigationList.prototype.init = function () {
			this._itemNavigation = new ItemNavigation();
			this._itemNavigation.setCycling(false);
			this.addEventDelegate(this._itemNavigation);

			this._itemNavigation.setPageSize(10);

			this._resourceBundle = sap.ui.getCore().getLibraryResourceBundle("sap.ui.core");
		};

		/**
		 * Sets a listbox accessibility role to the control.
		 * @private
		 */
		NavigationList.prototype.setHasListBoxRole = function (hasListBoxRole) {
			this._hasListBoxRole = hasListBoxRole;
		};

		/**
		 * Gets if the control has listbox accessibility role.
		 * @private
		 */
		NavigationList.prototype.getHasListBoxRole = function () {
			return this._hasListBoxRole;
		};

		/**
		 * Called after the control is rendered.
		 */
		NavigationList.prototype.onAfterRendering = function() {
			this._itemNavigation.setRootDomRef(this.getDomRef());
			this._itemNavigation.setItemDomRefs(this._getDomRefs());

			if (this._selectedItem) {
				this._selectedItem._select();
			}
		};

		NavigationList.prototype._updateNavItems = function() {
			this._itemNavigation.setItemDomRefs(this._getDomRefs());
		};

		/**
		 * Gets DOM references of the navigation items.
		 * @private
		 */
		NavigationList.prototype._getDomRefs = function() {
			var domRefs = [];

			var items = this.getItems();

			for (var i = 0; i < items.length; i++) {
				jQuery.merge(domRefs, items[i]._getDomRefs());
			}

			return domRefs;
		};

		/**
		 * Adapts popover position.
		 * @private
		 */
		NavigationList.prototype._adaptPopoverPositionParams = function () {
			if (this.getShowArrow()) {
				this._marginLeft = 10;
				this._marginRight = 10;
				this._marginBottom = 10;

				this._arrowOffset = 18;
				this._offsets = ["0 -18", "18 0", "0 18", "-18 0"];

				this._myPositions = ["center bottom", "begin top", "center top", "end top"];
				this._atPositions = ["center top", "end top", "center bottom", "begin top"];
			} else {
				this._marginTop = 0;
				this._marginLeft = 0;
				this._marginRight = 0;
				this._marginBottom = 0;

				this._arrowOffset = 0;
				this._offsets = ["0 0", "0 0", "0 0", "0 0"];

				this._myPositions = ["begin bottom", "begin top", "begin top", "end top"];
				this._atPositions = ["begin top", "end top", "begin bottom", "begin top"];
			}
		};

		/**
		 * Clears the control dependencies.
		 * @private
		 */
		NavigationList.prototype.exit = function () {
			if (this._itemNavigation) {
				this._itemNavigation.destroy();
			}
		};

		/**
		 * Selects an item.
		 * @private
		 */
		NavigationList.prototype._selectItem = function (params) {
			this.fireItemSelect(params);

			var item = params.item;

			if (this._selectedItem) {
				this._selectedItem._unselect();
			}

			item._select();

			this._selectedItem = item;
		};

		/**
		 * Gets the currently selected item.
		 */
		NavigationList.prototype.getSelectedItem = function() {
			return this._selectedItem;
		};

		/**
		 * Sets the currently selected item. Set <code>null</code> to deselect.
		 */
		NavigationList.prototype.setSelectedItem = function(item) {

			if (this._selectedItem) {
				this._selectedItem._unselect();
			}

			if (item) {
				item._select();
			}

			this._selectedItem = item;
		};

		/**
		 * Opens a popover.
		 * @private
		 */
		NavigationList.prototype._openPopover = function (source, list) {

			var that = this;
			var selectedItem = list.getSelectedItem();
			if (selectedItem && list.isGroupSelected) {
				selectedItem = null;
			}

			var popover = this._popover = new Popover({
				showHeader: false,
				horizontalScrolling: false,
				verticalScrolling: true,
				initialFocus: selectedItem,
				afterClose: function () {
					that._popover = null;
				},
				content: list
			}).addStyleClass('sapContrast sapContrastPlus');

			popover._adaptPositionParams = this._adaptPopoverPositionParams;

			popover.openBy(source);
		};

		NavigationList.prototype._closePopover = function () {
			if (this._popover) {
				this._popover.close();
			}
		};

		return NavigationList;

	}, /* bExport= */ true);

}; // end of sap/tnt/NavigationList.js
if ( !jQuery.sap.isDeclared('sap.tnt.NavigationListItem') ) {
// Provides control sap.tnt.NavigationListItem.
jQuery.sap.declare('sap.tnt.NavigationListItem'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Item'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Icon'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.IconPool'); // unlisted dependency retained
sap.ui.define("sap/tnt/NavigationListItem",["jquery.sap.global", "./library", "sap/ui/core/Item",
		'sap/ui/core/Icon', './NavigationList', 'sap/ui/core/Renderer', 'sap/ui/core/IconPool'],
	function(jQuery, library, Item,
	         Icon, NavigationList, Renderer, IconPool) {
		"use strict";

		/**
		 * Constructor for a new NavigationListItem.
		 *
		 * @param {string} [sId] ID for the new control, generated automatically if no ID is given
		 * @param {object} [mSettings] Initial settings for the new control
		 *
		 * @class
		 * The NavigationListItem control represents an action, which can be selected by the user.
		 * It can provide sub items.
		 * @extends sap.ui.core.Item
		 *
		 * @author SAP SE
		 * @version 1.42.6
		 *
		 * @constructor
		 * @public
		 * @since 1.34
		 * @alias sap.tnt.NavigationListItem
		 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
		 */
		var NavigationListItem = Item.extend("sap.tnt.NavigationListItem", /** @lends sap.tnt.NavigationListItem.prototype */ {
			metadata: {
				library: "sap.tnt",
				properties: {
					/**
					 * Specifies the icon for the item.
					 */
					icon: {type: "sap.ui.core.URI", group: "Misc", defaultValue: ''},
					/**
					 * Specifies if the item is expanded.
					 */
					expanded: {type: "boolean", group: "Misc", defaultValue: true},

					/**
					 * Specifies if the item has an expander.
					 */
					hasExpander : {type : "boolean", group : "Misc", defaultValue : true}
				},
				defaultAggregation: "items",
				aggregations: {

					/**
					 * The sub items.
					 */
					items: {type: "sap.tnt.NavigationListItem", multiple: true, singularName: "item"},

					_expandIconControl : {type : "sap.ui.core.Icon", multiple : false, visibility : "hidden"}
				},
				events: {
					/**
					 * Fired when this item is selected.
					 */
					select: {
						parameters: {
							/**
							 * The selected item.
							 */
							item: {type: "sap.ui.core.Item"}
						}
					}
				}
			}
		});

		NavigationListItem.expandIcon = 'sap-icon://navigation-right-arrow';
		NavigationListItem.collapseIcon = 'sap-icon://navigation-down-arrow';

		/**
		 * Returns the <code>sap.ui.core.Icon</code> control used to display the expand/collapse icon.
		 * @returns {sap.ui.core.Icon}
		 * @private
		 */
		NavigationListItem.prototype._getExpandIconControl = function () {
			var expandIconControl = this.getAggregation('_expandIconControl');
			if (!expandIconControl) {

				var expanded = this.getExpanded();

				expandIconControl = new Icon({
					src: expanded ? NavigationListItem.collapseIcon : NavigationListItem.expandIcon,
					visible: this.getItems().length > 0 && this.getHasExpander(),
					useIconTooltip: false,
					tooltip: this._getExpandIconTooltip(!expanded)
				}).addStyleClass('sapTntNavLIExpandIcon');

				this.setAggregation("_expandIconControl", expandIconControl, true);
			}

			return expandIconControl;
		};

		/**
		 * Gets the expand/collapse icon tooltip.
		 * @private
		 */
		NavigationListItem.prototype._getExpandIconTooltip = function (expand) {

			if (!this.getEnabled()) {
				return '';
			}

			var text = expand ? 'Icon.expand' : 'Icon.collapse';

			return this.getNavigationList()._resourceBundle.getText(text);
		};

		/**
		 * Gets the tree level of this item.
		 * @private
		 */
		NavigationListItem.prototype.getLevel = function () {
			var level = 0;

			var parent = this.getParent();
			if (parent.getMetadata().getName() == 'sap.tnt.NavigationListItem') {
				return parent.getLevel() + 1;
			}

			return level;
		};

		/**
		 * Gets the NavigationList control, which holds this item.
		 */
		NavigationListItem.prototype.getNavigationList = function () {
			var parent = this.getParent();

			while (parent && parent.getMetadata().getName() != 'sap.tnt.NavigationList') {
				parent = parent.getParent();
			}

			return parent;
		};

		/**
		 * Creates a popup list.
		 * @private
		 */
		NavigationListItem.prototype.createPopupList = function () {

			var newSubItems = [],
				list = this.getNavigationList(),
				selectedItem = list.getSelectedItem(),
				popupSelectedItem,
				subItem,
				popupSubItem,
				subItems = this.getItems();

			for (var i = 0; i < subItems.length; i++) {

				subItem = subItems[i];

				popupSubItem = new NavigationListItem({
					key: subItem.getId(),
					text: subItem.getText(),
					textDirection: subItem.getTextDirection(),
					enabled: subItem.getEnabled()
				});

				newSubItems.push(popupSubItem);

				if (selectedItem == subItem) {
					popupSelectedItem = popupSubItem;
				}
			}

			var newGroup = new NavigationListItem({
				expanded: true,
				hasExpander: false,
				key: this.getId(),
				text: this.getText(),
				enabled: this.getEnabled(),
				textDirection: this.getTextDirection(),
				items: newSubItems
			});

			var navList = new NavigationList({
				itemSelect: this.onPopupItemSelect.bind(this),
				items: [
					newGroup
				]
			}).addStyleClass('sapTntNavLIPopup');

			navList.setHasListBoxRole(true);

			if (selectedItem == this) {
				popupSelectedItem = newGroup;
				navList.isGroupSelected = true;
			}

			navList.setSelectedItem(popupSelectedItem);

			return navList;
		};

		/**
		 * Handles popup item selection.
		 * @private
		 */
		NavigationListItem.prototype.onPopupItemSelect = function (event) {

			var item = event.getParameter('item');

			// get the real group item from the cloned one
			item = sap.ui.getCore().byId(item.getKey());

			item._selectItem(event);
		};

		/**
		 * Selects this item.
		 * @private
		 */
		NavigationListItem.prototype._selectItem = function (event) {

			var params = {
				item: this
			};

			this.fireSelect(params);

			var navList = this.getNavigationList();
			navList._selectItem(params);
		};

		/**
		 * Handles key down event.
		 * @private
		 */
		NavigationListItem.prototype.onkeydown = function (event) {

			if (event.isMarked('subItem')) {
				return;
			}

			event.setMarked('subItem');

			if (this.getLevel() > 0) {
				return;
			}

			var isRtl = sap.ui.getCore().getConfiguration().getRTL();

			//  jQuery.sap.KeyCodes.MINUS is not returning 189
			if ((event.shiftKey && event.which == 189) ||
				event.which == jQuery.sap.KeyCodes.NUMPAD_MINUS ||
				(event.which == jQuery.sap.KeyCodes.ARROW_RIGHT && isRtl) ||
				(event.which == jQuery.sap.KeyCodes.ARROW_LEFT && !isRtl)) {
				if (this.collapse()) {
					event.preventDefault();
					event.target = null;
				}
			} else if (event.which == jQuery.sap.KeyCodes.NUMPAD_PLUS ||
				(event.shiftKey && event.which == jQuery.sap.KeyCodes.PLUS) ||
				event.which == jQuery.sap.KeyCodes.ARROW_LEFT && isRtl ||
				event.which == jQuery.sap.KeyCodes.ARROW_RIGHT && !isRtl) {
				if (this.expand()) {
					event.preventDefault();
					event.target = null;
				}
			}
		};

		/**
		 * Expands the child items (works only on first-level items).
		 */
		NavigationListItem.prototype.expand = function (duration) {
			if (this.getExpanded() || !this.getHasExpander() ||
				this.getItems().length == 0 || this.getLevel() > 0) {
				return;
			}

			this.setProperty('expanded', true, true);
			this.$().find('.sapTntNavLIGroup').attr('aria-expanded', true);

			var expandIconControl = this._getExpandIconControl();
			expandIconControl.setSrc(NavigationListItem.collapseIcon);
			expandIconControl.setTooltip(this._getExpandIconTooltip(false));

			var $container = this.$().find('.sapTntNavLIGroupItems');
			$container.stop(true, true).slideDown(duration || 'fast', function () {
				$container.toggleClass('sapTntNavLIHiddenGroupItems');
			});

			this.getNavigationList()._updateNavItems();

			return true;
		};

		/**
		 * Collapses the child items (works only on first-level items).
		 */
		NavigationListItem.prototype.collapse = function (duration) {
			if (!this.getExpanded() || !this.getHasExpander() ||
				this.getItems().length == 0 || this.getLevel() > 0) {
				return;
			}

			this.setProperty('expanded', false, true);
			this.$().find('.sapTntNavLIGroup').attr('aria-expanded', false);

			var expandIconControl = this._getExpandIconControl();
			expandIconControl.setSrc(NavigationListItem.expandIcon);
			expandIconControl.setTooltip(this._getExpandIconTooltip(true));

			var $container = this.$().find('.sapTntNavLIGroupItems');
			$container.stop(true, true).slideUp(duration || 'fast', function () {
				$container.toggleClass('sapTntNavLIHiddenGroupItems');
			});

			this.getNavigationList()._updateNavItems();

			return true;
		};

		/**
		 * Handles tap event.
		 * @private
		 */
		NavigationListItem.prototype.ontap = function (event) {

			if (event.isMarked('subItem') || !this.getEnabled()) {
				return;
			}

			event.setMarked('subItem');
			event.preventDefault();

			var navList = this.getNavigationList();
			var source = sap.ui.getCore().byId(event.target.id);
			var level = this.getLevel();

			// second navigation level
			if (level == 1) {

				var parent = this.getParent();

				if (this.getEnabled() && parent.getEnabled()) {
					this._selectItem(event);
				}

				return;
			}

			// first navigation level
			if (navList.getExpanded() || this.getItems().length == 0) {

				if (!source || source.getMetadata().getName() != 'sap.ui.core.Icon' || !source.$().hasClass('sapTntNavLIExpandIcon')) {
					this._selectItem(event);
					return;
				}

				if (this.getExpanded()) {
					this.collapse();
				} else {
					this.expand();
				}
			} else {
				var list = this.createPopupList();
				navList._openPopover(this, list);
			}
		};

		NavigationListItem.prototype.onsapenter = NavigationListItem.prototype.ontap;
		NavigationListItem.prototype.onsapspace = NavigationListItem.prototype.ontap;

		/**
		 * Renders the item.
		 * @private
		 */
		NavigationListItem.prototype.render = function (rm, control) {

			if (this.getLevel() == 0) {
				this.renderFirstLevelNavItem(rm, control);
			} else {
				this.renderSecondLevelNavItem(rm, control);
			}
		};

		/**
		 * Renders the group item.
		 * @private
		 */
		NavigationListItem.prototype.renderGroupItem = function (rm, control) {

			rm.write('<div');

			rm.addClass("sapTntNavLIItem");
			rm.addClass("sapTntNavLIGroup");

			if (!this.getEnabled()) {
				rm.addClass("sapTntNavLIItemDisabled");
			} else if (control.getExpanded()) {
				rm.write(' tabindex="-1"');
			}

			if (control.getExpanded()) {
				// ARIA
				if (control.getHasListBoxRole()) {
					rm.writeAttribute("role", 'option');
				} else {
					rm.writeAttribute("role", 'treeitem');
					if (this.getItems().length > 0) {
						rm.writeAttribute("aria-expanded", this.getExpanded());
					}
					rm.writeAttribute("aria-level", 1);
				}

				var text = this.getText();

				var sTooltip = this.getTooltip_AsString() || text;
				if (sTooltip) {
					rm.writeAttributeEscaped("title", sTooltip);
				}

				rm.writeAttributeEscaped("aria-label", text);
			}

			rm.writeClasses();

			rm.write(">");

			this._renderIcon(rm);

			if (control.getExpanded()) {

				var expandIconControl = this._getExpandIconControl();
				expandIconControl.setVisible(this.getItems().length > 0 && this.getHasExpander());
				expandIconControl.setSrc(this.getExpanded() ? NavigationListItem.collapseIcon : NavigationListItem.expandIcon);
				expandIconControl.setTooltip(this._getExpandIconTooltip(!this.getExpanded()));

				this._renderText(rm);
				rm.renderControl(expandIconControl);
			}

			rm.write("</div>");
		};

		/**
		 * Renders the first-level navigation item.
		 * @private
		 */
		NavigationListItem.prototype.renderFirstLevelNavItem = function (rm, control) {
			var item,
				items = this.getItems(),
				expanded = this.getExpanded(),
				isListExpanded = control.getExpanded();

			rm.write('<li');
			rm.writeElementData(this);

			if (this.getEnabled() && !isListExpanded) {
				rm.write(' tabindex="-1"');
			}

			var text = this.getText();

			// ARIA
			if (!isListExpanded) {
				var text = this.getText();

				var sTooltip = this.getTooltip_AsString() || text;
				if (sTooltip) {
					rm.writeAttributeEscaped("title", sTooltip);
				}

				rm.writeAttributeEscaped("aria-label", text);

				rm.writeAttribute("role", 'button');
				rm.writeAttribute("aria-haspopup", true);
			} else {
				rm.write(' role="presentation" ');
			}

			rm.write(">");

			this.renderGroupItem(rm, control);

			if (isListExpanded) {

				rm.write("<ul");

				rm.addClass("sapTntNavLIGroupItems");

				if (!expanded) {
					rm.addClass("sapTntNavLIHiddenGroupItems");
				}

				rm.writeClasses();
				rm.write(">");

				for (var i = 0; i < items.length; i++) {
					item = items[i];
					item.render(rm, control, this);
				}

				rm.write("</ul>");
			}

			rm.write("</li>");
		};

		/**
		 * Renders the second-level navigation item.
		 * @private
		 */
		NavigationListItem.prototype.renderSecondLevelNavItem = function (rm, control) {

			var group = this.getParent();

			rm.write('<li');

			rm.writeElementData(this);

			rm.addClass("sapTntNavLIItem");
			rm.addClass("sapTntNavLIGroupItem");

			if (!this.getEnabled() || !group.getEnabled()) {
				rm.addClass("sapTntNavLIItemDisabled");
			} else {
				rm.write(' tabindex="-1"');
			}

			var text = this.getText();

			var sTooltip = this.getTooltip_AsString() || text;
			if (sTooltip) {
				rm.writeAttributeEscaped("title", sTooltip);
			}

			// ARIA
			if (control.getHasListBoxRole()) {
				rm.writeAttribute("role", 'option');
			} else {
				rm.writeAttribute("role", 'treeitem');
				rm.writeAttribute("aria-level", 2);
			}

			rm.writeClasses();

			rm.write(">");

			this._renderText(rm);

			rm.write("</li>");
		};

		/**
		 * Renders an icon.
		 * @private
		 */
		NavigationListItem.prototype._renderIcon =  function(rm) {
			var icon = this.getIcon(),
				iconInfo = IconPool.getIconInfo(icon);

			if (icon) {
				// Manually rendering the icon instead of using RenderManager's writeIcon. In this way title
				// attribute is not rendered and the tooltip of the icon does not override item's tooltip
				rm.write('<span');

				rm.addClass("sapUiIcon");
				rm.addClass("sapTntNavLIGroupIcon");

				rm.writeAttribute("aria-hidden", true);

				if (iconInfo && !iconInfo.suppressMirroring) {
					rm.addClass("sapUiIconMirrorInRTL");
				}

				if (iconInfo) {
					rm.writeAttribute("data-sap-ui-icon-content", iconInfo.content);
					rm.addStyle("font-family", "'" + iconInfo.fontFamily + "'");
				}

				rm.writeClasses();
				rm.writeStyles();

				rm.write("></span>");
			} else {
				rm.write('<span class="sapUiIcon sapTntNavLIGroupIcon" aria-hidden="true"></span>');
			}

		};

		/**
		 * Renders a text.
		 * @private
		 */
		NavigationListItem.prototype._renderText =  function(rm) {
			rm.write('<span');

			rm.addClass("sapMText");
			rm.addClass("sapTntNavLIText");
			rm.addClass("sapMTextNoWrap");

			rm.writeClasses();

			var textDir = this.getTextDirection();
			if (textDir !== sap.ui.core.TextDirection.Inherit){
				rm.writeAttribute("dir", textDir.toLowerCase());
			}

			var textAlign = Renderer.getTextAlign(sap.ui.core.TextAlign.Begin, textDir);
			if (textAlign) {
				rm.addStyle("text-align", textAlign);
				rm.writeStyles();
			}

			rm.write(">");
			rm.writeEscaped(this.getText());
			rm.write("</span>");
		};

		/**
		 * Deselects this item.
		 * @private
		 */
		NavigationListItem.prototype._unselect = function() {

			var $this = this.$(),
				navList = this.getNavigationList();

			if (!navList) {
				return;
			}

			$this.removeClass('sapTntNavLIItemSelected');

			if (navList.getExpanded()) {

				if (this.getLevel() == 0) {
					$this = $this.find('.sapTntNavLIGroup');
				}

				$this.removeAttr('aria-selected');
			} else {
				$this.removeAttr('aria-pressed');
			}
		};

		/**
		 * Selects this item.
		 * @private
		 */
		NavigationListItem.prototype._select = function() {

			var $this = this.$(),
				navList = this.getNavigationList();

			if (!navList) {
				return;
			}

			$this.addClass('sapTntNavLIItemSelected');

			if (navList.getExpanded()) {

				if (this.getLevel() == 0) {
					$this = $this.find('.sapTntNavLIGroup');
				}

				$this.attr('aria-selected', true);
			} else {
				$this.attr('aria-pressed', true);

				navList._closePopover();
			}
		};

		/**
		 * Gets DOM references of the navigation items.
		 * @private
		 */
		NavigationListItem.prototype._getDomRefs = function() {
			var domRefs = [];

			if (!this.getEnabled()) {
				return domRefs;
			}

			var $this = this.$();

			if (this.getParent().getExpanded()) {
				domRefs.push($this.find('.sapTntNavLIGroup')[0]);
			} else {
				domRefs.push($this[0]);
			}

			if (this.getExpanded()) {
				var subItems = $this.find('.sapTntNavLIGroupItem');

				for (var i = 0; i < subItems.length; i++) {
					domRefs.push(subItems[i]);
				}
			}

			return domRefs;
		};

		return NavigationListItem;

	}, /* bExport= */true);

/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

}; // end of sap/tnt/NavigationListItem.js
if ( !jQuery.sap.isDeclared('sap.tnt.SideNavigation') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.t.SideNavigation.
jQuery.sap.declare('sap.tnt.SideNavigation'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.ResizeHandler'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Icon'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.delegate.ScrollEnablement'); // unlisted dependency retained
sap.ui.define("sap/tnt/SideNavigation",['jquery.sap.global', './library', 'sap/ui/core/Control', 'sap/ui/core/ResizeHandler',
        'sap/ui/core/Icon', 'sap/ui/core/delegate/ScrollEnablement'],
    function (jQuery, library, Control, ResizeHandler,
              Icon, ScrollEnablement) {
        'use strict';

        /**
         * Constructor for a new SideNavigation.
         *
         * @param {string} [sId] ID for the new control, generated automatically if no ID is given
         * @param {object} [mSettings] Initial settings for the new control
         *
         * @class
         * The SideNavigation control is a container, which consists of flexible and fixed parts on top of each other. The flexible part adapts its size to the fixed one.
         * The flexible part has a scrollbar when the content is larger than the available space.
         * Whenever the height of the whole control is less than 256 pixels, the scrollbar becomes joint for the two parts.
         *
         * <b>Note:</b> In order for the SideNavigation to stretch properly, its parent layout control should only be the sap.tnt.ToolPage.
         * @extends sap.ui.core.Control
         *
         * @author SAP SE
         * @version 1.42.6
         *
         * @constructor
         * @public
         * @since 1.34
         * @alias sap.tnt.SideNavigation
         * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
         */
        var SideNavigation = Control.extend('sap.tnt.SideNavigation', /** @lends sap.t.SideNavigation.prototype */ {
            metadata: {
                library: 'sap.tnt',
                properties: {
                    /**
                     * Specifies if the control is expanded.
                     */
                    expanded: {type: 'boolean', group: 'Misc', defaultValue: true}
                },
                defaultAggregation: "item",
                aggregations: {
                    /**
                     * Defines the content inside the flexible part.
                     */
                    item: {type: 'sap.tnt.NavigationList', multiple: false, bindable: "bindable"},
                    /**
                     * Defines the content inside the fixed part.
                     */
                    fixedItem: {type: 'sap.tnt.NavigationList', multiple: false},
                    /**
                     * Defines the content inside the footer.
                     */
                    footer: {type: 'sap.tnt.NavigationList', multiple: false},
                    /**
                     * The top arrow, used for scrolling throw items when SideNavigation is collapsed.
                     */
                    _topArrowControl: {type: "sap.ui.core.Icon", multiple: false, visibility: "hidden"},
                    /**
                     * The bottom arrow, used for scrolling throw items when SideNavigation is collapsed.
                     */
                    _bottomArrowControl: {type: "sap.ui.core.Icon", multiple: false, visibility: "hidden"}
                },
                events: {
                    /**
                     * Fired when an item is selected.
                     */
                    itemSelect: {
                        parameters: {
                            /**
                             * The selected item.
                             */
                            item: {type: 'sap.ui.core.Item'}
                        }
                    }
                }
            }
        });

        SideNavigation.prototype.init = function () {

            this._scroller = new ScrollEnablement(this, this.getId() + "-Flexible-Content", {
                horizontal: false,
                vertical: true
            });

            // Define group for F6 handling
            this.data('sap-ui-fastnavgroup', 'true', true);
        };

        SideNavigation.prototype.setAggregation = function (aggregationName, object, suppressInvalidate) {
            if (object && object.attachItemSelect) {
                object.attachItemSelect(this._itemSelectionHandler.bind(this));
            }

            return sap.ui.base.ManagedObject.prototype.setAggregation.apply(this, arguments);
        };

        /**
         * Sets if the control is in expanded or collapsed mode.
         */
        SideNavigation.prototype.setExpanded = function (isExpanded) {

            if (this.getExpanded() === isExpanded) {
                return this;
            }

            this.setProperty('expanded', isExpanded, true);

            if (!this.getDomRef()) {
                return this;
            }

            var that = this,
                $this = this.$(),
                width;

            if (that._hasActiveAnimation) {
                that._finishAnimation(!isExpanded);
                $this.stop();
            }

            if (isExpanded) {
                that.$().toggleClass('sapTntSideNavigationNotExpanded', !isExpanded);

                if (that.getAggregation('item')) {
                    that.getAggregation('item').setExpanded(isExpanded);
                }

                if (that.getAggregation('fixedItem')) {
                    that.getAggregation('fixedItem').setExpanded(isExpanded);
                }
            }

            that._hasActiveAnimation = true;

            var isCompact = $this.parents('.sapUiSizeCompact').length > 0;

            if (isCompact) {
                width = isExpanded ? '15rem' : '2rem';
            } else {
                width = isExpanded ? '15rem' : '3rem';
            }

            $this.animate({
                    width: width
                },
                {
                    duration: 300,
                    complete: function () {
                        var isExpanded = that.getExpanded();
                        that._finishAnimation(isExpanded);
                    }
                });

            return this;
        };

        /**
         * @private
         */
        SideNavigation.prototype._finishAnimation = function (isExpanded) {
            if (!this._hasActiveAnimation || !this.getDomRef()) {
                return;
            }

            this.$().toggleClass('sapTntSideNavigationNotExpandedWidth', !isExpanded);

            if (!isExpanded) {
                this.$().toggleClass('sapTntSideNavigationNotExpanded', !isExpanded);

                if (this.getAggregation('item')) {
                    this.getAggregation('item').setExpanded(isExpanded);
                }

                if (this.getAggregation('fixedItem')) {
                    this.getAggregation('fixedItem').setExpanded(isExpanded);
                }
            }

            this.$().css('width', '');
            this._hasActiveAnimation = false;

            this._toggleArrows();
        };

        /**
         * @private
         */
        SideNavigation.prototype.onBeforeRendering = function () {
            this._deregisterControl();
        };

        /**
         * @private
         */
        SideNavigation.prototype.onAfterRendering = function () {
            this._ResizeHandler = ResizeHandler.register(this.getDomRef(), this._toggleArrows.bind(this));
            this._toggleArrows();
        };

        /**
         * @private
         */
        SideNavigation.prototype.exit = function () {

            if (this._scroller) {
                this._scroller.destroy();
                this._scroller = null;
            }

            this._deregisterControl();
        };

        /**
         *
         * @param event
         * @private
         */
        SideNavigation.prototype._itemSelectionHandler = function (event) {
            var listId = event.getSource().getId();
            var itemAggregation = this.getAggregation('item');
            var fixedItemAggregation = this.getAggregation('fixedItem');

            if (itemAggregation && fixedItemAggregation && listId === itemAggregation.getId()) {
                fixedItemAggregation.setSelectedItem(null);
            }

            if (itemAggregation && fixedItemAggregation && listId === fixedItemAggregation.getId()) {
                itemAggregation.setSelectedItem(null);
            }

            this.fireItemSelect({
                item: event.getParameter('item')
            });
        };

        /**
         * @private
         */
        SideNavigation.prototype._deregisterControl = function () {
            if (this._ResizeHandler) {
                ResizeHandler.deregister(this._ResizeHandler);
                this._ResizeHandler = null;
            }
        };

        /**
         * Returns the sap.ui.core.Icon control used to display the group icon.
         * @returns {sap.ui.core.Icon}
         * @private
         */
        SideNavigation.prototype._getTopArrowControl = function () {
            var iconControl = this.getAggregation('_topArrowControl');
            var that = this;

            if (!iconControl) {
                iconControl = new Icon({
                    src: 'sap-icon://navigation-up-arrow',
                    noTabStop: true,
                    useIconTooltip: false,
                    tooltip: '',
                    press: this._arrowPress.bind(that)
                }).addStyleClass('sapTntSideNavigationScrollIcon sapTntSideNavigationScrollIconUp');
                this.setAggregation("_topArrowControl", iconControl, true);
            }

            return iconControl;
        };

        /**
         * Returns the sap.ui.core.Icon control used to display the group icon.
         * @returns {sap.ui.core.Icon}
         * @private
         */
        SideNavigation.prototype._getBottomArrowControl = function () {
            var iconControl = this.getAggregation('_bottomArrowControl');
            var that = this;

            if (!iconControl) {
                iconControl = new Icon({
                    src: 'sap-icon://navigation-down-arrow',
                    noTabStop: true,
                    useIconTooltip: false,
                    tooltip: '',
                    press: this._arrowPress.bind(that)
                }).addStyleClass('sapTntSideNavigationScrollIcon sapTntSideNavigationScrollIconDown');

                this.setAggregation("_bottomArrowControl", iconControl, true);
            }

            return iconControl;
        };

        SideNavigation.prototype._toggleArrows = function () {
            var domRef = this.getDomRef();

            if (!domRef) {
                return;
            }

            var scrollContainerWrapper = this.$('Flexible')[0];
            var scrollContainerContent = this.$('Flexible-Content')[0];
            var isAsideExpanded = this.getExpanded();

            if (this._hasActiveAnimation) {
                domRef.querySelector('.sapTntSideNavigationScrollIconUp').style.display = 'none';
                domRef.querySelector('.sapTntSideNavigationScrollIconDown').style.display = 'none';
                return;
            }

            if ((scrollContainerContent.offsetHeight > scrollContainerWrapper.offsetHeight) && !isAsideExpanded) {
                domRef.querySelector('.sapTntSideNavigationScrollIconUp').style.display = 'block';
                domRef.querySelector('.sapTntSideNavigationScrollIconDown').style.display = 'block';

                domRef.querySelector('.sapTntSideNavigationScrollIconDown').classList.remove('sapTntSideNavigationScrollIconDisabled');
            } else {
                domRef.querySelector('.sapTntSideNavigationScrollIconUp').style.display = 'none';
                domRef.querySelector('.sapTntSideNavigationScrollIconDown').style.display = 'none';
            }
        };

        SideNavigation.prototype._arrowPress = function (event, step) {
            event.preventDefault();

            var source = document.getElementById(event.oSource.sId);
            var isDirectionForward = source.classList.contains('sapTntSideNavigationScrollIconDown') ? true : false;

            var $container = this.$('Flexible');

            var step = isDirectionForward ? 40 : -40;
            $container[0].scrollTop += step;
        };

        return SideNavigation;

    }, /* bExport= */ true
);

}; // end of sap/tnt/SideNavigation.js
if ( !jQuery.sap.isDeclared('sap.tnt.ToolHeader') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.tnt.ToolHeader
jQuery.sap.declare('sap.tnt.ToolHeader'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
jQuery.sap.require('sap.m.OverflowToolbar'); // unlisted dependency retained
jQuery.sap.require('sap.m.OverflowToolbarAssociativePopover'); // unlisted dependency retained
sap.ui.define("sap/tnt/ToolHeader",['jquery.sap.global', './library', 'sap/ui/core/Control',
		'sap/m/OverflowToolbar', 'sap/m/OverflowToolbarAssociativePopover'],
	function(jQuery, library, Control, OverflowToolbar, OverflowToolbarAssociativePopover) {
		"use strict";


		/**
		 * Constructor for a new ToolHeader.
		 *
		 * @param {string} [sId] ID for the new control, generated automatically if no ID is given
		 * @param {object} [mSettings] Initial settings for the new control
		 *
		 * @class
		 *
		 * The ToolHeader control is a horizontal container that is most
		 * commonly used to display buttons, labels, selects and other various input controls.
		 *
		 * The ToolHeader control is based on sap.m.OverflowToolbar. In addition to the OverflowToolbar,
		 * the user can specify where the overflow button is placed.
		 *
		 * @extends sap.m.OverflowToolbar
		 *
		 * @author SAP SE
		 * @version 1.42.6
		 *
		 * @constructor
		 * @public
		 * @since 1.34
		 * @alias sap.tnt.ToolHeader
		 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
		 */
		var ToolHeader = OverflowToolbar.extend("sap.tnt.ToolHeader", /** @lends sap.tnt.ToolHeader.prototype */ {
			metadata: {
				library: "sap.tnt",
				properties: {

				},
				aggregations: {
				}
			}
		});

		/**
		 * Initializes the control.
		 * @private
		 * @override
		 */
		ToolHeader.prototype.init = function() {

			OverflowToolbar.prototype.init.apply(this, arguments);

			this.addStyleClass('sapTntToolHeader sapContrast sapContrastPlus');

			this.setHTMLTag(sap.m.IBarHTMLTag.Header);
		};

		/**
		 * Lazy loader for the popover.
		 * @returns {sap.m.Popover}
		 * @private
		 */
		ToolHeader.prototype._getPopover = function() {
			var popover;

			if (!this.getAggregation("_popover")) {

				// Create the Popover
				popover = new OverflowToolbarAssociativePopover(this.getId() + "-popover", {
					showHeader: false,
					showArrow: sap.ui.Device.system.phone ? false : true,
					modal: false,
					horizontalScrolling: sap.ui.Device.system.phone ? false : true,
					contentWidth: sap.ui.Device.system.phone ? "100%" : "auto"
				}).addStyleClass('sapTntToolHeaderPopover sapContrast sapContrastPlus');

				popover.oControlsManager._preProcessSapMButton = this._preProcessPopoverControlsSapMButton.bind(popover.oControlsManager);

				if (sap.ui.Device.system.phone) {
					// This will trigger when the toolbar is in the header/footer, because the the position is known in advance (strictly top/bottom)
					popover.attachBeforeOpen(this._shiftPopupShadow, this);

					// This will trigger when the toolbar is not in the header/footer, when the actual calculation is ready (see the overridden _calcPlacement)
					popover.attachAfterOpen(this._shiftPopupShadow, this);
				}

				// This will set the toggle button to "off"
				popover.attachAfterClose(this._popOverClosedHandler, this);

				this.setAggregation("_popover", popover, true);
			}

			return this.getAggregation("_popover");
		};

		/**
		 * Modifies sap.m.Button.
		 * @private
		 */
		ToolHeader.prototype._preProcessPopoverControlsSapMButton = function(oControl) {
			this._mControlsCache[oControl.getId()] = {
				buttonType: oControl.getType()
			};

			// Set some css classes to apply the proper paddings in cases of buttons with/without icons
			if (oControl.getIcon()) {
				oControl.addStyleClass("sapMOTAPButtonWithIcon");
			} else {
				oControl.addStyleClass("sapMOTAPButtonNoIcon");
			}

			oControl.attachEvent("_change", this._onSapMButtonUpdated, this);
		};

		/**
		 * Returns "sap.m.PlacementType.Bottom".
		 * @returns {sap.m.PlacementType}
		 * @private
		 * @override
		 */
		ToolHeader.prototype._getBestActionSheetPlacement = function() {
			return sap.m.PlacementType.Bottom;
		};

		return ToolHeader;

	}, /* bExport= */ true);

}; // end of sap/tnt/ToolHeader.js
if ( !jQuery.sap.isDeclared('sap.tnt.ToolHeaderUtilitySeparator') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.tnt.ToolHeaderUtilitySeparator.
jQuery.sap.declare('sap.tnt.ToolHeaderUtilitySeparator'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
sap.ui.define("sap/tnt/ToolHeaderUtilitySeparator",['jquery.sap.global', './library', 'sap/ui/core/Control'],
	function(jQuery, library, Control) {
		"use strict";


		/**
		 * Constructor for a new ToolHeaderUtilitySeparator.
		 *
		 * @param {string} [sId] ID for the new control, generated automatically if no ID is given
		 * @param {object} [mSettings] Initial settings for the new control
		 *
		 * @class
		 * The ToolHeaderUtilitySeparator control is used in the sap.tnt.ToolHeader control
		 * to specify where the overflow button is placed.
		 * @extends sap.ui.core.Control
		 *
		 * @author SAP SE
		 * @version 1.42.6
		 *
		 * @constructor
		 * @public
		 * @since 1.16
		 * @alias sap.tnt.ToolHeaderUtilitySeparator
		 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
		 */
		var ToolHeaderUtilitySeparator = Control.extend("sap.tnt.ToolHeaderUtilitySeparator", /** @lends sap.tnt.ToolHeaderUtilitySeparator.prototype */ {
			metadata: {
				library: "sap.tnt",
				properties: {
				}
			},
			renderer: {
				render : function() {

				}
			}
		});

		return ToolHeaderUtilitySeparator;

	}, /* bExport= */ true);

}; // end of sap/tnt/ToolHeaderUtilitySeparator.js
if ( !jQuery.sap.isDeclared('sap.tnt.ToolPage') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.t.ToolPage.
jQuery.sap.declare('sap.tnt.ToolPage'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
jQuery.sap.require('sap.ui.Device'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.ResizeHandler'); // unlisted dependency retained
sap.ui.define("sap/tnt/ToolPage",['./library', 'sap/ui/core/Control', 'sap/ui/Device', 'sap/ui/core/ResizeHandler'],
	function (library, Control, Device, ResizeHandler) {
		'use strict';

		/**
		 * Constructor for a new ToolPage.
		 *
		 * @param {string} [sId] ID for the new control, generated automatically if no id is given
		 * @param {object} [mSettings] Initial settings for the new control
		 *
		 * @class
		 * The ToolPage is a layout control, used to put together the parts of a basic tools app - ToolHeader, SideNavigation and contents area.
		 * @extends sap.ui.core.Control
		 *
		 * @author SAP SE
		 * @version 1.42.6
		 *
		 * @constructor
		 * @public
		 * @since 1.34
		 * @alias sap.tnt.ToolPage
		 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
		 */
		var ToolPage = Control.extend('sap.tnt.ToolPage', /** @lends sap.tnt.ToolPage.prototype */ {
			metadata: {
				library: 'sap.tnt',
				properties: {
					/**
					 * Indicates if the side area is expanded. Overrides the expanded property of the sideContent aggregation.
					 */
					sideExpanded: {type: 'boolean', group: 'Misc', defaultValue: true}
				},
				aggregations: {
					/**
					 * The control to appear in the header area.
					 */
					header: {type: 'sap.tnt.ToolHeader', multiple: false},
					/**
					 * The side menu of the layout.
					 */
					sideContent: {type: 'sap.tnt.SideNavigation', multiple: false},
					/**
					 * The content section.
					 */
					mainContents: {type: 'sap.ui.core.Control', multiple: true, singularName: 'mainContent'}
				},
				events: {}
			}
		});

		/**
		 * Toggles the expand/collapse state of the SideContent.
		 * @returns {sap.tnt.ToolPage} Pointer to the control instance for chaining.
		 * @public
		 */
		ToolPage.prototype.toggleSideContentMode = function () {
			return this.setSideExpanded(!this.getSideExpanded());
		};

		/**
		 * Sets the expand/collapse state of the SideContent.
		 * @param {boolean} isSideExpanded defines whether the SideNavigation is expanded.
		 * @returns {sap.tnt.ToolPage} Pointer to the control instance for chaining
		 * @public
		 */
		ToolPage.prototype.setSideExpanded = function(isSideExpanded) {
			var sideContentAggregation = this.getAggregation('sideContent');
			var domRef = this.getDomRef();

			this.setProperty('sideExpanded', isSideExpanded, true);

			if (sideContentAggregation) {
				var newState = Device.system.phone ? true :  isSideExpanded;
				sideContentAggregation.setExpanded(newState);
			}

			if (!domRef) {
				return this;
			}

			if (isSideExpanded) {
				domRef.querySelector('.sapTntToolPageContentWrapper').classList.remove('sapTntToolPageAsideCollapsed');
			} else {
				domRef.querySelector('.sapTntToolPageContentWrapper').classList.add('sapTntToolPageAsideCollapsed');
			}

			return this;
		};

		ToolPage.prototype.onBeforeRendering = function () {
			this._deregisterControl();
		};

		ToolPage.prototype.onAfterRendering = function () {
			this._ResizeHandler = ResizeHandler.register(this.getDomRef(), this._mediaQueryHandler.bind(this));

			this._updateLastMediaQuery();
		};

		ToolPage.prototype.exit = function () {
			this._deregisterControl();
		};

		/**
		 * @private
		 */
		ToolPage.prototype._deregisterControl = function () {
			if (this._ResizeHandler) {
				ResizeHandler.deregister(this._ResizeHandler);
				this._ResizeHandler = null;
			}
		};

		/**
		 * Handles the change of the screen size.
		 * @private
		 */
		ToolPage.prototype._mediaQueryHandler = function () {
			var sideContentAggregation = this.getAggregation('sideContent');

			if (sideContentAggregation === null) {
				return;
			}

			this._currentMediaQuery = this._getDeviceAsString();

			if (this._getLastMediaQuery() === this._currentMediaQuery) {
				return;
			}

			switch (this._currentMediaQuery) {
				case 'Combi':
					this.setSideExpanded(true);
					break;
				case 'Tablet':
					this.setSideExpanded(false);
					break;
				case 'Phone':
					this.setSideExpanded(false);
					sideContentAggregation.setExpanded(true);
					break;
				default:
					this.setSideExpanded(true);
					break;
			}

			this._updateLastMediaQuery();
		};

		/**
		 * Returns the last media query.
		 * @returns {undefined|string}
		 * @private
		 */
		ToolPage.prototype._getLastMediaQuery = function () {
			return this._lastMediaQuery;
		};

		/**
		 * Sets the last media query.
		 * @returns {ToolPage}
		 * @private
		 */
		ToolPage.prototype._updateLastMediaQuery = function () {
			this._lastMediaQuery = this._getDeviceAsString();

			return this;
		};

		/**
		 *
		 */
		ToolPage.prototype._getDeviceAsString = function () {
			if (Device.system.combi) {
				return 'Combi';
			}

			if (Device.system.phone) {
				return 'Phone';
			}

			if (Device.system.tablet) {
				return 'Tablet';
			}

			return 'Desktop';
		};

		return ToolPage;

	}, /* bExport= */ true
);

}; // end of sap/tnt/ToolPage.js
