/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/model/BindingMode','sap/ui/model/Context','sap/ui/model/Model','sap/ui/model/odata/v2/ODataAnnotations','sap/ui/model/odata/ODataUtils','sap/ui/model/odata/CountMode','sap/ui/model/odata/UpdateMethod','sap/ui/model/odata/OperationMode','./ODataContextBinding','./ODataListBinding','sap/ui/model/odata/ODataMetadata','sap/ui/model/odata/ODataPropertyBinding','./ODataTreeBinding','sap/ui/model/odata/ODataMetaModel','sap/ui/core/message/MessageParser','sap/ui/model/odata/ODataMessageParser','sap/ui/thirdparty/datajs'],function(q,B,C,M,O,a,b,U,c,d,e,f,g,h,l,m,o,p){"use strict";var r=M.extend("sap.ui.model.odata.v2.ODataModel",{constructor:function(s,P){M.apply(this,arguments);var u,i,H,t,w,j,k,R,A,L,D,n,v,x,S,y,z,J,E,F,G,I,K,N,Q,T=this;if(typeof(s)==="object"){P=s;s=P.serviceUrl;}if(P){u=P.user;i=P.password;H=P.headers;t=P.tokenHandling;w=P.withCredentials;j=P.maxDataServiceVersion;k=P.useBatch;R=P.refreshAfterChange;A=P.annotationURI;L=P.loadAnnotationsJoined;n=P.defaultBindingMode;D=P.defaultCountMode;v=P.defaultOperationMode;x=P.metadataNamespaces;S=P.serviceUrlParams;y=P.metadataUrlParams;J=P.json;E=P.messageParser;F=P.skipMetadataAnnotationParsing;G=P.defaultUpdateMethod;I=P.disableHeadRequestForToken;K=P.sequentializeRequests;N=P.disableSoftStateHeader;Q=P.bindableResponseHeaders;}this.mSupportedBindingModes={"OneWay":true,"OneTime":true,"TwoWay":true};this.sDefaultBindingMode=n||B.OneWay;this.bJSON=J!==false;this.aPendingRequestHandles=[];this.aCallAfterUpdate=[];this.mRequests={};this.mDeferredRequests={};this.mChangedEntities={};this.mChangeHandles={};this.mDeferredGroups={};this.mLaunderingState={};this.sDefaultUpdateMethod=G||U.Merge;this.bTokenHandling=t!==false;this.bWithCredentials=w===true;this.bUseBatch=k!==false;this.bRefreshAfterChange=R!==false;this.sMaxDataServiceVersion=j;this.bLoadAnnotationsJoined=L!==false;this.sAnnotationURI=A;this.sDefaultCountMode=D||b.Request;this.sDefaultOperationMode=v||c.Server;this.sMetadataLoadEvent=null;this.oMetadataFailedEvent=null;this.sRefreshGroupId=undefined;this.bIncludeInCurrentBatch=false;this.bSkipMetadataAnnotationParsing=!!F;this.bDisableHeadRequestForToken=!!I;this.bSequentializeRequests=!!K;this.bDisableSoftStateHeader=!!N;this.aBindableResponseHeaders=Q?Q:null;if(E){E.setProcessor(this);}this.oMessageParser=E;this.sDefaultChangeGroup="changes";this.setDeferredGroups([this.sDefaultChangeGroup]);this.setChangeGroups({"*":{groupId:this.sDefaultChangeGroup}});this.oData={};this.oMetadata=null;this.oAnnotations=null;this.aUrlParams=[];this.pSequentialRequestCompleted=Promise.resolve();this.pReadyForRequest=Promise.resolve();this.sServiceUrl=s;var V=s.split("?");if(V.length>1){this.sServiceUrl=V[0];if(V[1]){this.aUrlParams.push(V[1]);}}this.sServiceUrl=this.sServiceUrl.replace(/\/$/,"");this.sUser=u;this.sPassword=i;if(sap.ui.getCore().getConfiguration().getStatistics()){this.aUrlParams.push("sap-statistics=true");}this.oHeaders={};this.setHeaders(H);if(!this.bDisableSoftStateHeader){this.oHeaders["sap-contextid-accept"]="header";this.mCustomHeaders["sap-contextid-accept"]="header";}z=a._createUrlParamsArray(y);var W=this._createRequestUrl("/$metadata",undefined,z);this.oServiceData=r.mServiceData[W];if(!this.oServiceData){r.mServiceData[W]={};this.oServiceData=r.mServiceData[W];}if(!this.oServiceData.oMetadata){this.oMetadata=new f(W,{async:true,user:this.sUser,password:this.sPassword,headers:this.mCustomHeaders,namespaces:x,withCredentials:this.bWithCredentials});this.oServiceData.oMetadata=this.oMetadata;}else{this.oMetadata=this.oServiceData.oMetadata;}this.oAnnotations=new O(this.oMetadata,{source:this.sAnnotationURI,skipMetadata:this.bSkipMetadataAnnotationParsing,headers:this.mCustomHeaders,combineEvents:true});if(!this.bDisableSoftStateHeader){delete this.mCustomHeaders["sap-contextid-accept"];}this.oAnnotations.attachAllFailed(this.onAnnotationsFailed,this);this.oAnnotations.attachSomeLoaded(this.onAnnotationsLoaded,this);this.pAnnotationsLoaded=this.oAnnotations.loaded();if(S){this.aUrlParams=this.aUrlParams.concat(a._createUrlParamsArray(S));}this.onMetadataFailed=function(X){T.fireMetadataFailed(X.getParameters());};this.oMetadata.loaded().then(this._initializeMetadata.bind(this));if(!this.oMetadata.isLoaded()){this.oMetadata.attachFailed(this.onMetadataFailed);}else if(this.oMetadata.isFailed()){this.refreshMetadata();}if(this.bJSON){if(this.sMaxDataServiceVersion==="3.0"){this.oHeaders["Accept"]="application/json;odata=fullmetadata";}else{this.oHeaders["Accept"]="application/json";}}else{this.oHeaders["Accept"]="application/atom+xml,application/atomsvc+xml,application/xml";}if(this.bTokenHandling&&this.oServiceData.securityToken){this.oHeaders["x-csrf-token"]=this.oServiceData.securityToken;}this.oHeaders["Accept-Language"]=sap.ui.getCore().getConfiguration().getLanguageTag();this.oHeaders["DataServiceVersion"]="2.0";this.oHeaders["MaxDataServiceVersion"]="2.0";if(this.sMaxDataServiceVersion){this.oHeaders["MaxDataServiceVersion"]=this.sMaxDataServiceVersion;}this.oHeaders["sap-cancel-on-close"]=true;},metadata:{publicMethods:["read","create","update","remove","submitChanges","getServiceMetadata","metadataLoaded","hasPendingChanges","refresh","refreshMetadata","resetChanges","setDefaultCountMode","setDefaultBindingMode","getDefaultBindingMode","getDefaultCountMode","setProperty","getSecurityToken","refreshSecurityToken","setHeaders","getHeaders","setUseBatch","setDeferredBatchGroups","getDeferredBatchGroups","setChangeBatchGroups","getChangeBatchGroups"]}});r.M_EVENTS={MetadataLoaded:"metadataLoaded",MetadataFailed:"metadataFailed",AnnotationsLoaded:"annotationsLoaded",AnnotationsFailed:"annotationsFailed",BatchRequestFailed:"batchRequestFailed",BatchRequestSent:"batchRequestSent",BatchRequestCompleted:"batchRequestCompleted"};r.prototype.attachBatchRequestFailed=function(D,F,L){this.attachEvent("batchRequestFailed",D,F,L);return this;};r.prototype.detachBatchRequestFailed=function(F,L){this.detachEvent("batchRequestFailed",F,L);return this;};r.prototype.fireBatchRequestFailed=function(A){this.fireEvent("batchRequestFailed",A);return this;};r.prototype.attachBatchRequestSent=function(D,F,L){this.attachEvent("batchRequestSent",D,F,L);return this;};r.prototype.detachBatchRequestSent=function(F,L){this.detachEvent("batchRequestSent",F,L);return this;};r.prototype.fireBatchRequestSent=function(A){this.fireEvent("batchRequestSent",A);return this;};r.prototype.attachBatchRequestCompleted=function(D,F,L){this.attachEvent("batchRequestCompleted",D,F,L);return this;};r.prototype.detachBatchRequestCompleted=function(F,L){this.detachEvent("batchRequestCompleted",F,L);return this;};r.prototype.fireBatchRequestCompleted=function(A){this.fireEvent("batchRequestCompleted",A);return this;};r.mServiceData={};r.prototype._initializeMetadata=function(){if(this.bDestroyed){return;}var F=function(){this.fireMetadataLoaded({metadata:this.oMetadata});q.sap.log.debug(this+" - metadataloaded fired");}.bind(this);this.initialize();if(this.bLoadAnnotationsJoined){this.oAnnotations.loaded().then(F,this.fireMetadataFailed.bind(this));}else{F();}};r.prototype.refreshMetadata=function(){if(this.oMetadata&&this.oMetadata.refresh){return this.oMetadata.refresh();}};r.prototype.fireAnnotationsLoaded=function(A){this.fireEvent("annotationsLoaded",A);return this;};r.prototype.attachAnnotationsLoaded=function(D,F,L){this.attachEvent("annotationsLoaded",D,F,L);return this;};r.prototype.detachAnnotationsLoaded=function(F,L){this.detachEvent("annotationsLoaded",F,L);return this;};r.prototype.fireAnnotationsFailed=function(A){this.fireEvent("annotationsFailed",A);q.sap.log.debug(this+" - annotationsfailed fired");return this;};r.prototype.attachAnnotationsFailed=function(D,F,L){this.attachEvent("annotationsFailed",D,F,L);return this;};r.prototype.detachAnnotationsFailed=function(F,L){this.detachEvent("annotationsFailed",F,L);return this;};r.prototype.fireMetadataLoaded=function(A){this.fireEvent("metadataLoaded",A);return this;};r.prototype.attachMetadataLoaded=function(D,F,L){this.attachEvent("metadataLoaded",D,F,L);return this;};r.prototype.detachMetadataLoaded=function(F,L){this.detachEvent("metadataLoaded",F,L);return this;};r.prototype.fireMetadataFailed=function(A){this.fireEvent("metadataFailed",A);return this;};r.prototype.attachMetadataFailed=function(D,F,L){this.attachEvent("metadataFailed",D,F,L);return this;};r.prototype.detachMetadataFailed=function(F,L){this.detachEvent("metadataFailed",F,L);return this;};r.prototype._createEventInfo=function(R,k,n){var E={};E.url=R.requestUri;E.method=R.method;E.async=R.async;E.headers=R.headers;if(n){E.requests=[];for(var i=0;i<n.length;i++){var s={};if(q.isArray(n[i])){var t=n[i];for(var j=0;j<t.length;j++){var R=t[j].request;var I=n[i][j].response;s={};s.url=R.requestUri;s.method=R.method;s.headers=R.headers;if(I){s.response={};if(R._aborted){s.success=false;s.response.statusCode=0;s.response.statusText="abort";}else{s.success=true;if(I.message){s.response.message=I.message;I=I.response;s.response.responseText=I.body;s.success=false;}s.response.headers=I.headers;s.response.statusCode=I.statusCode;s.response.statusText=I.statusText;}}E.requests.push(s);}}else{var R=n[i].request;var I=n[i].response;s.url=R.requestUri;s.method=R.method;s.headers=R.headers;if(I){s.response={};if(R._aborted){s.success=false;s.response.statusCode=0;s.response.statusText="abort";}else{s.success=true;if(I.message){s.response.message=I.message;I=I.response;s.response.responseText=I.body;s.success=false;}s.response.headers=I.headers;s.response.statusCode=I.statusCode;s.response.statusText=I.statusText;}}E.requests.push(s);}}}if(k){E.response={};E.success=true;if(k.message){E.response.message=k.message;E.success=false;}if(k.response){k=k.response;}if(k&&k.statusCode!=undefined){E.response.headers=k.headers;E.response.statusCode=k.statusCode;E.response.statusText=k.statusText;E.response.responseText=k.body!==undefined?k.body:k.responseText;}}E.ID=R.requestID;return E;};r.prototype._createRequestID=function(){var R;R=q.sap.uid();return R;};r.prototype._createRequestUrl=function(P,i,u,j){var n,A=[],s="";n=this._normalizePath(P,i);if(!j){s=this.sServiceUrl+n;}else{s=n.substr(n.indexOf('/')+1);}if(this.aUrlParams){A=A.concat(this.aUrlParams);}if(u){A=A.concat(u);}if(A&&A.length>0){s+="?"+A.join("&");}return s;};r.prototype._importData=function(D,j,R){var t=this,L,k,n,E;if(D.results){L=[];q.each(D.results,function(i,w){var k=t._importData(w,j,R);if(k){L.push(k);}});return L;}else{k=this._getKey(D);if(!k){return k;}E=this.oData[k];if(!E){E=D;this.oData[k]=E;}if(this.aBindableResponseHeaders){var H={};for(var s in R.headers){var u=s.toLowerCase();if(this.aBindableResponseHeaders.indexOf(u)>-1){H[u]=R.headers[s];}}if(!q.isEmptyObject(H)){if(!D.__metadata){D.__metadata={};}D.__metadata.headers=H;}}q.each(D,function(N,P){if(P&&(P.__metadata&&P.__metadata.uri||P.results)&&!P.__deferred){n=t._importData(P,j,R);if(q.isArray(n)){E[N]={__list:n};}else{E[N]={__ref:n};}}else if(!P||!P.__deferred){E[N]=P;}});var v={};v[k]=E;this._updateChangedEntities(v);j[k]=true;return k;}};r.prototype._removeReferences=function(D){var t=this,L;if(!D){return D;}if(D.results){L=[];q.each(D.results,function(i,j){L.push(t._removeReferences(j));});return L;}else{q.each(D,function(P,i){if(i){if(i["__ref"]||i["__list"]){delete D[P];}}});return D;}};r.prototype._restoreReferences=function(D,v){var t=this,k,j,R;function n(k){var j=v[k];if(!j){j=t._getObject("/"+k);if(j){j=q.sap.extend(true,{},j);v[k]=j;t._restoreReferences(j,v);}}return j;}if(!v){v={};}q.each(D,function(P,s){if(s){if(s.__ref){k=s.__ref;j=n(k);if(j){D[P]=j;}delete s.__ref;}else if(s.__list){R=[];q.each(s.__list,function(i,k){j=n(k);if(j){R.push(j);}});delete s.__list;s.results=R;}}});return D;};r.prototype.removeData=function(){this.oData={};};r.prototype.initialize=function(){var i=this.aBindings.slice(0);q.each(i,function(I,j){j.initialize();});};r.prototype.refresh=function(F,R,G){if(typeof F==="string"){G=F;F=false;R=false;}if(R){this.removeData();}this._refresh(F,G);};r.prototype._refresh=function(F,G,i,E){var j=this.aBindings.slice(0);this.sRefreshGroupId=G;q.each(j,function(I,k){k._refresh(F,i,E);});this.sRefreshGroupId=undefined;};r.prototype.checkUpdate=function(F,A,j,k){if(A){if(!this.sUpdateTimer){this.sUpdateTimer=q.sap.delayedCall(0,this,function(){this.checkUpdate(F,false,j);});}return;}if(this.sUpdateTimer){q.sap.clearDelayedCall(this.sUpdateTimer);this.sUpdateTimer=null;}var n=this.aBindings.slice(0);q.each(n,function(I,t){if(!k||this.isMetaModelPath(t.getPath())){t.checkUpdate(F,j);}}.bind(this));var s=this.aCallAfterUpdate;this.aCallAfterUpdate=[];for(var i=0;i<s.length;i++){s[i]();}};r.prototype.checkDataState=function(L){var i=this.aBindings.slice(0);q.each(i,function(I,j){if(j.checkDataState){j.checkDataState(L);}});};r.prototype.bindProperty=function(P,i,j){var k=new g(this,P,i,j);return k;};r.prototype.bindList=function(P,i,s,F,j){var k=new e(this,P,i,s,F,j);return k;};r.prototype.bindTree=function(P,i,F,j,s){var k=new h(this,P,i,F,j,s);return k;};r.prototype.createBindingContext=function(P,i,j,k,R){var s=this.resolve(P,i),n,N,G,t=this;if(typeof i=="function"){R=j;k=i;j=undefined;i=undefined;}if(typeof j=="function"){R=k;k=j;j=undefined;}if(!s){if(k){k(null);}return null;}if(R===undefined){R=this._isReloadNeeded(s,j);}if(!R){n=this.resolve(P,i,true);N=this.getContext(n);if(k){k(N);}return N;}function u(D){var K=D?t._getKey(D):null,y=null,z;N=null;if(K){N=t.getContext('/'+K);y={__ref:K};}if(i&&I){z=i.getPath();z=z.substr(1);if(t.oData[z]){t.oData[z][P]=y;}}k(N);}function v(E){if(E.statusCode=='404'&&i&&I){var y=i.getPath();y=y.substr(1);if(t.oData[y]){t.oData[y][P]={__ref:null};}}k(null);}if(k){var I=!q.sap.startsWith(P,"/");if(s){var w=[],x=this.createCustomParams(j);if(x){w.push(x);}if(j&&(j.batchGroupId||j.groupId)){G=j.groupId||j.batchGroupId;}this.read(s,{groupId:G,urlParameters:w,success:u,error:v});}else{k(null);}}};r.prototype._splitEntries=function(E){return E.replace(/\s/g,"").split(',').map(function(s){return s.split("/");});};r.prototype._filterOwnSelect=function(s,E){var i,j;if(!E){return[];}j=E.map(function(P){return P.name;});i=s.filter(function(S){return S.length===1;}).map(function(S){return S[0];});if(s.length===0||i.indexOf("*")!==-1||i.indexOf("**")!==-1){return j;}else{return i.filter(function(S){return j.indexOf(S)!==-1;});}};r.prototype._filterOwnExpand=function(E,s){return E.map(function(S){return S[0];}).filter(function(v,i,j){return j.indexOf(v)===i;}).filter(function(v){return s.length===0||s.some(function(S){return S.indexOf(v)===0||S.indexOf("**")===0;});});};r.prototype._filterSelectByNavProp=function(E,n){return E.filter(function(s){return s[0]===n;}).map(function(s){return s.length>1?s.slice(1):["**"];});};r.prototype._filterExpandByNavProp=function(E,n){return E.filter(function(s){return s.length>1&&s[0]===n;}).map(function(s){return s.slice(1);});};r.prototype._isReloadNeeded=function(P,k){var t=this,n=this.oMetadata,D=this.oData,E=this.oMetadata._getEntityTypeByPath(P),s=this._getObject(P),u=[],S=[];function v(E,s,S,u){var w,x,N,y,z,A,F,G,H;if(!E){return false;}if(s===null){return false;}if(!s){return true;}w=t._filterOwnSelect(S,E.property);for(var i=0;i<w.length;i++){H=w[i];if(s[H]===undefined){return true;}}x=t._filterOwnExpand(u,S);for(var i=0;i<x.length;i++){G=x[i];N=s[G];if(N===null){continue;}if(N===undefined||N.__deferred){return true;}y=n._getEntityTypeByNavProperty(E,G);A=t._filterSelectByNavProp(S,G);F=t._filterExpandByNavProp(u,G);if(N.__ref){z=D[N.__ref];if(v(y,z,A,F)){return true;}}if(N.__list){for(var j=0;j<N.__list.length;j++){z=D[N.__list[j]];if(v(y,z,A,F)){return true;}}}}return false;}if(k){if(k.select){S=this._splitEntries(k.select);}if(k.expand){u=this._splitEntries(k.expand);}}return v(E,s,S,u);};r.prototype.createCustomParams=function(P){var i=[],j,s={expand:true,select:true};for(var n in P){if(n in s){i.push("$"+n+"="+q.sap.encodeURL(P[n]));}if(n==="custom"){j=P[n];for(n in j){if(n.indexOf("$")===0){q.sap.log.warning(this+" - Trying to set OData parameter '"+n+"' as custom query option!");}else if(j[n]===undefined){i.push(n);}else{i.push(n+"="+q.sap.encodeURL(j[n]));}}}}return i.join("&");};r.prototype.bindContext=function(P,i,j){var k=new d(this,P,i,j);return k;};r.prototype.setDefaultCountMode=function(s){this.sDefaultCountMode=s;};r.prototype.getDefaultCountMode=function(){return this.sDefaultCountMode;};r.prototype._getKey=function(v){var k,u;if(v instanceof C){k=v.getPath().substr(1);}else if(v&&v.__metadata&&v.__metadata.uri){u=v.__metadata.uri;k=u.substr(u.lastIndexOf("/")+1);}else if(typeof v==='string'){k=v.substr(v.lastIndexOf("/")+1);}return k;};r.prototype.getKey=function(v){return this._getKey(v);};r.prototype.createKey=function(s,k){var E=this.oMetadata._getEntityTypeByPath(s),K=s,t=this,n,P;K+="(";if(E.key.propertyRef.length===1){n=E.key.propertyRef[0].name;P=this.oMetadata._getPropertyMetadata(E,n);K+=encodeURIComponent(a.formatValue(k[n],P.type));}else{q.each(E.key.propertyRef,function(i,j){if(i>0){K+=",";}n=j.name;P=t.oMetadata._getPropertyMetadata(E,n);K+=n;K+="=";K+=encodeURIComponent(a.formatValue(k[n],P.type));});}K+=")";return K;};r.prototype.getProperty=function(P,i,I){var v=this._getObject(P,i);if(!I){return v;}if(!q.isPlainObject(v)){return v;}v=q.sap.extend(true,{},v);if(I===true){return this._restoreReferences(v);}else{return this._removeReferences(v);}};r.prototype.getObject=function(P,n,s){if(q.isPlainObject(n)){s=n;n=undefined;}var t=this,R=this.resolve(P,n),v=this._getObject(R),E=this.oMetadata._getEntityTypeByPath(R),u=[],S=[];if(!E||!q.isPlainObject(v)||!v.__metadata||!v.__metadata.uri){return v;}if(!s||!(s.select||s.expand)){return q.sap.extend(true,{},v);}function w(E,v,S,u){var x,y,z,A,N,D,F,G,H,I,J,K,L;if(!v){return undefined;}if(!E){return undefined;}z=t._filterOwnSelect(S,E.property);y={};for(var i=0;i<z.length;i++){K=z[i];if(v[K]!==undefined){y[K]=v[K];}else{q.sap.log.fatal("No data loaded for select property: "+K+" of entry: "+t.getKey(v));return undefined;}}if(v.__metadata){y.__metadata=v.__metadata;}x=t._filterOwnExpand(u,S);for(var i=0;i<x.length;i++){J=x[i];N=v[J];D=t.oMetadata._getEntityTypeByNavProperty(E,J);H=t._filterSelectByNavProp(S,J);I=t._filterExpandByNavProp(u,J);if(N&&N.__ref){G=t._getObject("/"+N.__ref);F=w(D,G,H,I);if(F!==undefined){y[J]=F;}else{q.sap.log.fatal("No data loaded for expand property: "+J+" of entry: "+t.getKey(F));return undefined;}}if(N&&N.__list){L=[];for(var j=0;j<N.__list.length;j++){G=t._getObject("/"+N.__list[j]);F=w(D,G,H,I);if(F!==undefined){L.push(F);}else{q.sap.log.fatal("No data loaded for expand property: "+J+" of entry: "+t.getKey(F));return undefined;}}y[J]=L;}}A=t._filterOwnSelect(S,E.navigationProperty);for(var k=0;k<A.length;k++){J=A[k];if(x.indexOf(J)===-1){var Q=y.__metadata.uri+"/"+J;y[J]={__deferred:{uri:Q}};}}return y;}if(s.select){S=this._splitEntries(s.select);}if(s.expand){u=this._splitEntries(s.expand);}v=w(E,v,S,u);return v;};r.prototype._getObject=function(P,i,j){var n=this.isLegacySyntax()?this.oData:null,k,s,R=this.resolve(P,i),S,D,t,u,K,v;if(this.oMetadata&&this.oMetadata.isLoaded()&&R&&R.indexOf('/#')>-1){if(this.isMetaModelPath(R)){S=R.indexOf('/##');v=this.getMetaModel();if(!this.bMetaModelLoaded){return null;}D=R.substr(0,S);t=R.substr(S+3);u=v.getMetaContext(D);n=v.getProperty(t,u);}else{n=this.oMetadata._getAnnotation(R);}}else{if(!R){return n;}var w=R.split("/"),I=0;K=w[1];w.splice(0,2);k=this.mChangedEntities[K];s=this.oData[K];if(!j){n=!K?this.oData:k||s;}else{n=!K?this.oData:s;}while(n&&w[I]){var H=k&&k.hasOwnProperty(w[I]);k=k&&k[w[I]];s=s&&s[w[I]];n=j||!H?s:k;if(n){if(n.__ref){k=this.mChangedEntities[n.__ref];s=this.oData[n.__ref];n=j?s:k||s;}else if(n.__list){n=n.__list;}else if(n.__deferred){n=undefined;}}I++;}}if(q.isPlainObject(k)){n=j?s:q.sap.extend(true,{},s,k);}return n;};r.prototype.updateSecurityToken=function(){if(this.bTokenHandling){if(!this.oServiceData.securityToken){this.refreshSecurityToken();}if(this.bTokenHandling){this.oHeaders["x-csrf-token"]=this.oServiceData.securityToken;}}};r.prototype.resetSecurityToken=function(){delete this.oServiceData.securityToken;delete this.oHeaders["x-csrf-token"];delete this.pSecurityToken;};r.prototype.getSecurityToken=function(){var t=this.oServiceData.securityToken;if(!t){this.refreshSecurityToken();t=this.oServiceData.securityToken;}return t;};r.prototype.securityTokenAvailable=function(){if(!this.pSecurityToken){if(this.oServiceData.securityToken){this.pSecurityToken=Promise.resolve(this.oServiceData.securityToken);}else{this.pSecurityToken=new Promise(function(i,j){this.refreshSecurityToken(function(){i(this.oServiceData.securityToken);}.bind(this),function(){j();},true);}.bind(this));}}return this.pSecurityToken;};r.prototype.refreshSecurityToken=function(s,E,A){var t;var i=this;var u=this._createRequestUrl("/");var T={abort:function(){this.request.abort();}};function j(D,R){if(R){t=i._getHeader("x-csrf-token",R.headers);i._setSessionContextIdHeader(i._getHeader("sap-contextid",R.headers));if(t){i.oServiceData.securityToken=t;i.pSecurityToken=Promise.resolve(t);i.oHeaders["x-csrf-token"]=t;}else{i.resetSecurityToken();i.bTokenHandling=false;}}if(s){s(D,R);}}function k(w){i.resetSecurityToken();i.bTokenHandling=false;i._handleError(w);if(E){E(w);}}function n(w){T.request=v("GET",k);}function v(R,E){var w=i._createRequest(u,R,i._getHeaders(),null,null,!!A);w.headers["x-csrf-token"]="Fetch";return i._request(w,j,E,undefined,undefined,i.getServiceMetadata());}if(this.bDisableHeadRequestForToken){T.request=v("GET",k);}else{T.request=v("HEAD",n);}return T;};r.prototype._submitRequest=function(R,s,E){var t=this,H,j,A,k,n;k=new Promise(function(i,D){n=i;});function u(D,i){if(s){s(D,i);}n();}function v(i){if(t.bTokenHandling&&i.response){var T=t._getHeader("x-csrf-token",i.response.headers);if(!R.bTokenReset&&i.response.statusCode=='403'&&T&&T.toLowerCase()==="required"){t.resetSecurityToken();R.bTokenReset=true;x();return;}}if(E){E(i);}n();}function w(R){if(t.bTokenHandling&&R.method!=="GET"){t.pReadyForRequest=t.securityTokenAvailable();}return t.pReadyForRequest;}function x(){w(R).then(function(T){if(t.bTokenHandling&&R.method!=="GET"){R.headers["x-csrf-token"]=T;}z();},function(){z();});}function y(T,R,D){var F,G=R.eventInfo.requests;if(G){q.each(G,function(i,R){if(q.isArray(R)){q.each(R,function(i,R){q.each(R.parts,function(i,P){F=t._createEventInfo(R.request,P.fnError);t["fireRequest"+T](F);});});}else{if(R.parts){q.each(R.parts,function(i,P){F=t._createEventInfo(R.request,P.fnError);t["fireRequest"+T](F);});}else{F=t._createEventInfo(R.request,R.fnError);t["fireRequest"+T](F);}}});if(R.eventInfo.batch){F=t._createEventInfo(R,D,G);t["fireBatchRequest"+T](F);}}}function z(){if(t.sSessionContextId){R.headers["sap-contextid"]=t.sSessionContextId;}j=t._request(R,u,v,H,undefined,t.getServiceMetadata());if(R.eventInfo){y("Sent",R,null);delete R.eventInfo;}if(A){j.abort();}}H=t._getODataHandler(R.requestUri);if(this.bSequentializeRequests){this.pSequentialRequestCompleted.then(function(){x();});this.pSequentialRequestCompleted=k;}else{x();}return{abort:function(){if(j){j.abort();}A=true;}};};r.prototype._setSessionContextIdHeader=function(s){if(s){this.sSessionContextId=s;}};r.prototype._submitSingleRequest=function(R){var t=this,j,k={},G={},E={};function n(D,u){if(D===undefined&&u.statusCode===200){s({message:"Response did not contain a valid OData result",response:u});return;}function v(D,u){for(var i=0;i<R.parts.length;i++){if(R.parts[i].request._aborted){t._processAborted(R.parts[i].request,u,R.parts[i].fnError);}else if(R.parts[i].fnSuccess){R.parts[i].fnSuccess(D,u);}}if(R.request.requestUri.indexOf("$count")===-1){t.checkUpdate(false,false,G);if(t.bRefreshAfterChange){t._refresh(false,undefined,k,E);}}}t._processSuccess(R.request,u,v,G,k,E);t._setSessionContextIdHeader(t._getHeader("sap-contextid",u.headers));}function s(u){if(u.message=="Request aborted"){for(var i=0;i<R.parts.length;i++){t._processAborted(R.parts[i].request,u,R.parts[i].fnError);}}else{for(var i=0;i<R.parts.length;i++){t._processError(R.parts[i].request,u,R.parts[i].fnError);}}}R.request.eventInfo={requests:R.parts,batch:false};j=this._submitRequest(R.request,n,s);return j;};r.prototype._submitBatchRequest=function(k,R,s,E){var t=this,n={},G={},u={};function v(j,z,A){for(var i=0;i<j.parts.length;i++){if(A||j.parts[i].request._aborted){t._processAborted(j.parts[i].request,z,j.parts[i].fnError);}else if(z.message){t._processError(j.parts[i].request,z,j.parts[i].fnError);}else{t._processSuccess(j.parts[i].request,z,j.parts[i].fnSuccess,G,n,u);}}}function w(D,z){if(D===undefined&&z.statusCode===200){x({message:"Response did not contain a valid OData batch result",response:z});return;}var A,F,H,I=D.__batchResponses;if(I){var i,j;for(i=0;i<I.length;i++){A=I[i];if(q.isArray(R[i])){if(A.message){for(j=0;j<R[i].length;j++){F=R[i][j];v(F,A);F.response=A;}}else{H=A.__changeResponses;for(j=0;j<H.length;j++){var J=H[j];F=R[i][j];v(F,J);F.response=J;}}}else{F=R[i];v(F,A);F.response=A;}}t.checkUpdate(false,false,G);}t._processSuccess(k,z,s,G,n,u,true,R);t._setSessionContextIdHeader(t._getHeader("sap-contextid",z.headers));}function x(j){var A=j.message=="Request aborted";q.each(R,function(i,z){if(q.isArray(z)){q.each(z,function(i,z){v(z,j,A);});}else{v(z,j,A);}});if(A){t._processAborted(k,j,E,true);}else{t._processError(k,j,E,true,R);}}k.eventInfo={requests:R,batch:true};var y=this._submitRequest(k,w,x);return y;};r.prototype._createBatchRequest=function(i){var u,R,j={},P={};P.__batchRequests=i;u=this.sServiceUrl+"/$batch";if(this.aUrlParams.length>0){u+="?"+this.aUrlParams.join("&");}q.extend(j,this.mCustomHeaders,this.oHeaders);delete j["Content-Type"];R={headers:j,requestUri:u,method:"POST",data:P,user:this.sUser,password:this.sPassword,async:true};R.withCredentials=this.bWithCredentials;return R;};r.prototype.abortInternalRequest=function(k,G){var R=this.mRequests;if(G in this.mDeferredGroups){R=this.mDeferredRequests;}var j=R[G];if(j&&k in j.map){var n=j.map[k];for(var i=0;i<n.parts.length;i++){n.parts[i].requestHandle.abort();}}};r.prototype._pushToRequestQueue=function(R,G,s,i,S,E,j){var k=R[G],n=i.key?i.key:i.method+":"+i.requestUri;if(!k){k={};k.map={};k.requests=[];R[G]=k;}if(n in k.map&&(i.key||i.method==='GET')){var t=k.map[n];var u=t.request;if(!i.key){t.parts.push({request:i,fnSuccess:S,fnError:E,requestHandle:j});}if(i.method==="GET"){delete u.data;}else{u.method=i.method;u.headers=i.headers;u.data=i.data;u.requestUri=i.requestUri;if(i.method==="PUT"){delete u.headers["x-http-method"];}if(u._aborted){delete u._aborted;}}}else{var t={request:i,parts:[{request:i,fnSuccess:S,fnError:E,requestHandle:j}]};if(i.method==="GET"){k.requests.push(t);}else{if(!k.changes){k.changes={};}var v=k.changes[s];if(!v){v=[];k.changes[s]=v;}t.changeSetId=s;v.push(t);}k.map[n]=t;}};r.prototype._collectChangedEntities=function(G,j,E){var t=this;if(G.changes){q.each(G.changes,function(s,k){for(var i=0;i<k.length;i++){var R=k[i].request,K=R.requestUri.split('?')[0];if(R.method==="POST"||R.method==="DELETE"){var n=t.oMetadata._getEntityTypeByPath("/"+K);if(n){E[n.entityType]=true;}}else{j[K]=true;}}});}};r.prototype._processRequestQueue=function(R,G,s,E){var t=this,P,j=[];function k(n,W){for(var i=0;i<n.parts.length;i++){var u=n.parts[i];if(u.request._aborted){t._processAborted(n.request,null,u.fnError);n.parts.splice(i,1);i--;}else if(W){u.request._handle=W;W.iRelevantRequests++;}}}function w(){return{iRelevantRequests:0,oRequestHandle:{},abort:function(){this.iRelevantRequests--;if(this.iRelevantRequests===0&&this.oRequestHandle){this.oRequestHandle.abort();}}};}if(this.bUseBatch){if(t.bRefreshAfterChange){q.each(R,function(i,n){if(i===G||!G){var u={},v={};t._collectChangedEntities(n,u,v);t.bIncludeInCurrentBatch=true;t._refresh(false,i,u,v);t.bIncludeInCurrentBatch=false;}});}q.each(R,function(n,u){if(n===G||!G){var v=[],x=[],y,z;var W=w();if(u.changes){q.each(u.changes,function(F,H){y={__changeRequests:[]};z=[];for(var i=0;i<H.length;i++){P='/'+t.getKey(H[i].request.data);t.increaseLaundering(P,H[i].request.data);k(H[i],W);if(H[i].parts.length>0){if(H[i].request.data&&H[i].request.data.__metadata){delete H[i].request.data.__metadata.created;}y.__changeRequests.push(H[i].request);z.push(H[i]);}}if(y.__changeRequests&&y.__changeRequests.length>0){v.push(y);x.push(z);}});}if(u.requests){var A=u.requests;for(var i=0;i<A.length;i++){k(A[i],W);if(A[i].parts.length>0){v.push(A[i].request);x.push(A[i]);}}}if(v.length>0){var D=t._createBatchRequest(v,true);W.oRequestHandle=t._submitBatchRequest(D,x,s,E);j.push(W.oRequestHandle);}delete R[n];}});}else{q.each(R,function(n,u){if(n===G||!G){if(u.changes){q.each(u.changes,function(x,y){for(var i=0;i<y.length;i++){var W=w();P='/'+t.getKey(y[i].request.data);t.increaseLaundering(P,y[i].request.data);k(y[i],W);if(y[i].parts.length>0){W.oRequestHandle=t._submitSingleRequest(y[i]);j.push(W.oRequestHandle);}}});}if(u.requests){var v=u.requests;for(var i=0;i<v.length;i++){var W=w();k(v[i],W);if(v[i].parts.length>0){W.oRequestHandle=t._submitSingleRequest(v[i]);j.push(W.oRequestHandle);}}}delete R[n];}});}this.checkDataState(this.mLaunderingState);return j.length==1?j[0]:j;};r.prototype._processRequestQueueAsync=function(R){var t=this;if(!this.pCallAsnyc){this.pCallAsnyc=Promise.resolve();this.pCallAsnyc.then(function(){t._processRequestQueue(R);t.pCallAsnyc=undefined;});}};r.prototype._processSuccess=function(R,i,s,G,j,E,k,n){var t=i.data,I,u,v,P,w,x,L={},y={},z=this;if(!k){u=!(i.statusCode===204||i.statusCode==='204');v=R.requestUri;P=v.replace(this.sServiceUrl,"");if(!q.sap.startsWith(P,'/')){P='/'+P;}P=this._normalizePath(P);this.decreaseLaundering(P,R.data);if(u&&t===undefined&&i){this._parseResponse(i,R);q.sap.log.fatal(this+" - No data was retrieved by service: '"+i.requestUri+"'");z.fireRequestCompleted({url:i.requestUri,type:"GET",async:i.async,info:"Accept headers:"+this.oHeaders["Accept"],infoObject:{acceptHeaders:this.oHeaders["Accept"]},success:false});return false;}if(t&&t.results&&!q.isArray(t.results)){t=t.results;}if(!i._imported&&t&&(q.isArray(t)||typeof t=='object')){I=q.sap.extend(true,{},t);z._importData(I,L,i);i._imported=true;}if(L&&this.oData[R.key]&&this.oData[R.key].__metadata.created&&this.oData[R.key].__metadata.created.functionImport){var A=[];var D=this.oData[R.key]["$result"];if(D&&D.__list){q.each(L,function(K){A.push(K);});D.__list=A;}else if(D&&D.__ref){q.each(L,function(K){D.__ref=K;});}}if(!u){w=P.split("/");if(w[1]){y[w[1]]=R;var F={};F[w[1]]=R.data;this._updateChangedEntities(F);}if(R.method==="DELETE"&&w[2]!=="$links"){delete z.oData[w[1]];delete z.mContexts["/"+w[1]];delete z.mChangedEntities[w[1]];}}if(u&&R.method==="POST"){x=this.oMetadata._getEntityTypeByPath(P);if(x){E[x.entityType]=true;}if(R.key){var K=this._getKey(t);delete this.mChangedEntities[R.key];delete this.oData[R.key];var H=this.getContext("/"+R.key);H.sPath='/'+K;H.bCreated=false;if(this.oData[K]){delete this.oData[K].__metadata.created;}}}this._parseResponse(i,R,L,y);q.extend(G,L);q.extend(j,y);this._updateETag(R,i);}if(s){s(t,i);}var J=this._createEventInfo(R,i,n);if(k){this.fireBatchRequestCompleted(J);}else{this.fireRequestCompleted(J);}return true;};r.prototype._processError=function(R,i,E,j,k){var P,n=this._handleError(i,R);if(!j){P='/'+this.getKey(R.data);this.decreaseLaundering(P,R.data);}if(E){E(n);}var s=this._createEventInfo(R,n,k);if(j){this.fireBatchRequestCompleted(s);this.fireBatchRequestFailed(s);}else{this.fireRequestCompleted(s);this.fireRequestFailed(s);}};r.prototype._processAborted=function(R,i,E,j){var P;var k={message:"Request aborted",statusCode:0,statusText:"abort",headers:{},responseText:""};if(!j){P='/'+this.getKey(R.data);this.decreaseLaundering(P,R.data);}if(E){E(k);}if(i){var n=this._createEventInfo(R,k);n.success=false;if(j){this.fireBatchRequestCompleted(n);}else{this.fireRequestCompleted(n);}}};r.prototype._processChange=function(k,D,u){var P,E,i,s,j,t,H,v,R,w,x=this;E=this.oMetadata._getEntityTypeByPath(k);if(!u){u="MERGE";}P=q.sap.extend(true,{},this._getObject('/'+k,true),D);if(D.__metadata&&D.__metadata.created){s=D.__metadata.created.method?D.__metadata.created.method:"POST";k=D.__metadata.created.key;i=D.__metadata.created;if(D.__metadata.created.functionImport){i.urlParameters=this._createFunctionImportParameters(D.__metadata.created.key,s,P);P=undefined;}}else if(u==="MERGE"){s="MERGE";w=this.oData[k];}else{s="PUT";}if(P&&P.__metadata){for(var n in P.__metadata){if(n!=='type'&&n!=='uri'&&n!=='etag'&&n!=='content_type'&&n!=='media_src'){delete P.__metadata[n];}}}if(P&&E){var N=this.oMetadata._getNavigationPropertyNames(E);q.each(N,function(I,A){delete P[A];});}if(s==="MERGE"&&E&&w){q.each(P,function(A,F){if(A!=='__metadata'){if(q.sap.equal(w[A],F)&&!x.isLaundering('/'+k+'/'+A)){delete P[A];}}});var y="/"+k,z;q.each(P,function(A,F){if(A!=='__metadata'){z=x.getProperty(y+"/"+A+"/#@sap:unit");if(z){if(P[z]===undefined){P[z]=w[z];}}}});}P=this._removeReferences(P);v=i&&i.urlParameters?a._createUrlParamsArray(i.urlParameters):undefined;H=i&&i.headers?this._getHeaders(i.headers):this._getHeaders();j=i&&i.eTag?i.eTag:this.getETag(P);t=this._createRequestUrl('/'+k,null,v,this.bUseBatch);R=this._createRequest(t,s,H,P,j);if(this.bUseBatch){R.requestUri=R.requestUri.replace(this.sServiceUrl+'/','');}return R;};r.prototype._resolveGroup=function(k){var i,E,P,G,s,D;E=this.oMetadata._getEntityTypeByPath(k);D=this._getObject('/'+k);P=D.__metadata.created;if(P){return{groupId:P.groupId,changeSetId:P.changeSetId};}if(this.mChangeGroups[E.name]){i=this.mChangeGroups[E.name];G=i.groupId;s=i.single?q.sap.uid():i.changeSetId;}else if(this.mChangeGroups['*']){i=this.mChangeGroups['*'];G=i.groupId;s=i.single?q.sap.uid():i.changeSetId;}return{groupId:G,changeSetId:s};};r.prototype._updateETag=function(R,i){var u,E,s;u=R.requestUri.replace(this.sServiceUrl+'/','');if(!q.sap.startsWith(u,"/")){u="/"+u;}E=this._getObject(u);s=this._getHeader("etag",i.headers);if(E&&E.__metadata&&s){E.__metadata.etag=s;}};r.prototype._handleError=function(E,R){var P={},t;var s="The following problem occurred: "+E.message;P.message=E.message;if(E.response){this._parseResponse(E.response,R);if(this.bTokenHandling){t=this._getHeader("x-csrf-token",E.response.headers);if(E.response.statusCode=='403'&&t&&t.toLowerCase()==="required"){this.resetSecurityToken();}}s+=E.response.statusCode+","+E.response.statusText+","+E.response.body;P.statusCode=E.response.statusCode;P.statusText=E.response.statusText;P.headers=E.response.headers;P.responseText=E.response.body;}q.sap.log.fatal(s);return P;};r.prototype.getData=function(P,i,I){return this.getProperty(P,i,I);};r.prototype._getODataHandler=function(u){if(u.indexOf("$batch")>-1){return p.batchHandler;}else if(u.indexOf("$count")>-1){return undefined;}else if(this.bJSON){return p.jsonHandler;}else{return p.atomHandler;}};r.prototype.getETag=function(P,i,E){if(typeof P=="object"){E=P;P="";}return this._getETag(P,i,E);};r.prototype._getETag=function(P,i,D){if(!D||!D.__metadata){D=this._getObject(P,i);}if(D&&D.__metadata){return D.__metadata.etag;}return null;};r.prototype.forceEntityUpdate=function(k){var D=this.mChangedEntities[k];if(D&&D.__metadata){D.__metadata.etag='*';}else{q.sap.log.error(this+" - Entity with key "+k+" does not exist or has no change");}};r.prototype._createRequest=function(u,s,H,D,E,A){A=A!==false;if(E&&s!=="GET"){H["If-Match"]=E;}if(!H["Content-Type"]&&s!=="DELETE"&&s!=="GET"){if(this.bJSON){H["Content-Type"]="application/json";}else{H["Content-Type"]="application/atom+xml";}}if(u.indexOf("$count")>-1){H["Accept"]="text/plain, */*;q=0.5";}if(s==="MERGE"&&!this.bUseBatch){H["x-http-method"]="MERGE";s="POST";}var R={headers:H,requestUri:u,method:s,user:this.sUser,password:this.sPassword,async:A};if(D){R.data=D;}if(this.bWithCredentials){R.withCredentials=this.bWithCredentials;}R.requestID=this._createRequestID();return R;};r.prototype._processRequest=function(P){var R,i,A=false,t=this;R={abort:function(){A=true;if(i){i._aborted=true;if(i._handle){i._handle.abort();}}}};this.oMetadata.loaded().then(function(){i=P(R);t._processRequestQueueAsync(t.mRequests);if(A){R.abort();}});return R;};r.prototype.update=function(P,D,i){var s,E,R,u,j,k,n,G,t,v,H,w,x,y=this;if(i){G=i.groupId||i.batchGroupId;t=i.changeSetId;j=i.context;s=i.success;E=i.error;k=i.eTag;H=i.headers;v=i.urlParameters;if(i.merge!==undefined){w=i.merge?"MERGE":"PUT";}}n=a._createUrlParamsArray(v);H=this._getHeaders(H);w=w?w:this.sDefaultUpdateMethod;k=k||this._getETag(P,j,D);return this._processRequest(function(){u=y._createRequestUrl(P,j,n,y.bUseBatch);R=y._createRequest(u,w,H,D,k);x=y.mRequests;if(G in y.mDeferredGroups){x=y.mDeferredRequests;}y._pushToRequestQueue(x,G,t,R,s,E);return R;});};r.prototype.create=function(P,D,i){var R,u,E,j,s,k,n,t,H,v,w,G,x,y,z=this;if(i){j=i.context;n=i.urlParameters;s=i.success;k=i.error;G=i.groupId||i.batchGroupId;y=i.changeSetId;w=i.eTag;H=i.headers;}v=a._createUrlParamsArray(n);H=this._getHeaders(H);x="POST";return this._processRequest(function(A){u=z._createRequestUrl(P,j,v,z.bUseBatch);R=z._createRequest(u,x,H,D,w);P=z._normalizePath(P,j);E=z.oMetadata._getEntityTypeByPath(P);R.entityTypes={};if(E){R.entityTypes[E.entityType]=true;}t=z.mRequests;if(G in z.mDeferredGroups){t=z.mDeferredRequests;}z._pushToRequestQueue(t,G,y,R,s,k,A);return R;});};r.prototype.remove=function(P,i){var j,E,s,k,R,u,G,n,t,v,H,w,x,y,z=this;if(i){G=i.groupId||i.batchGroupId;n=i.changeSetId;j=i.context;s=i.success;k=i.error;t=i.eTag;H=i.headers;v=i.urlParameters;}w=a._createUrlParamsArray(v);H=this._getHeaders(H);x="DELETE";t=t||this._getETag(P,j);function A(D,F){E=u.substr(u.lastIndexOf('/')+1);if(E.indexOf('?')!==-1){E=E.substr(0,E.indexOf('?'));}delete z.oData[E];delete z.mContexts["/"+E];if(s){s(D,F);}}return this._processRequest(function(D){u=z._createRequestUrl(P,j,w,z.bUseBatch);R=z._createRequest(u,x,H,undefined,t);y=z.mRequests;if(G in z.mDeferredGroups){y=z.mDeferredRequests;}z._pushToRequestQueue(y,G,n,R,A,k,D);return R;});};r.prototype.callFunction=function(F,P){var R,u,i,j,k,n,s,E,t="GET",n,G,v,H,w,x=this,K,y,z,A,D,I,J={};if(P){G=P.groupId||P.batchGroupId;v=P.changeSetId;t=P.method?P.method:t;k=q.extend({},P.urlParameters);w=P.eTag;s=P.success;E=P.error;H=P.headers;}if(!q.sap.startsWith(F,"/")){q.sap.log.fatal(this+" callFunction: path '"+F+"' must be absolute!");return;}H=this._getHeaders(H);D=new Promise(function(L,N){z=L;A=N;});I=this._processRequest(function(){i=x.oMetadata._getFunctionImportMetadata(F,t);if(!i){A();return;}var L=i.entitySet||i.entitySetPath;if(L){J.$result={__list:[]};if(i.returnType&&i.returnType.indexOf("Collection")==-1){J.$result={__ref:{}};}}if(i.parameter!=null){q.each(i.parameter,function(N,Q){J[Q.name]=x._createPropertyValue(Q.type);if(k&&k[Q.name]!==undefined){J[Q.name]=k[Q.name];k[Q.name]=a.formatValue(k[Q.name],Q.type);}else{q.sap.log.warning(x+" - No value for parameter '"+Q.name+"' found!'");}});}K=F.substring(1)+"('"+q.sap.uid()+"')";J.__metadata={uri:x.sServiceUrl+'/'+K,created:{key:F.substring(1),success:s,error:E,headers:H,method:t,groupId:G,changeSetId:v,eTag:w,functionImport:true}};x.oData[K]=J;y=x.getContext("/"+K);z(y);n=a._createUrlParamsArray(k);u=x._createRequestUrl(F,null,n,x.bUseBatch);R=x._createRequest(u,t,H,undefined,w);R.key=K;j=x.mRequests;if(G in x.mDeferredGroups){j=x.mDeferredRequests;}x._pushToRequestQueue(j,G,v,R,s,E);return R;});I.contextCreated=function(){return D;};return I;};r.prototype._createFunctionImportParameters=function(F,s,P){var u=q.extend(true,{},P);delete u.__metadata;delete u["$result"];var i=this.oMetadata._getFunctionImportMetadata(F,s);if(!i){return;}if(i.parameter!=null){q.each(i.parameter,function(I,j){if(u[j.name]){u[j.name]=a.formatValue(u[j.name],j.type);}});}return u;};r.prototype.read=function(P,i){var R,u,j,k,s,E,F,S,n,t,v,N,w,H,x,G,y,z,A=this;if(i){j=i.context;k=i.urlParameters;s=i.success;E=i.error;F=i.filters;S=i.sorters;G=i.groupId||i.batchGroupId;H=i.headers;}if(this.sRefreshGroupId){G=this.sRefreshGroupId;}w=a._createUrlParamsArray(k);H=this._getHeaders(H);x="GET";y=this._getETag(P,j);var D={abort:function(){if(R){R._aborted=true;}}};function I(J){t=a.createSortParams(S);if(t){w.push(t);}var T=P;var K=P.indexOf("$count");if(K!==-1){T=P.substring(0,K-1);}N=A._normalizePath(T,j);v=A.oMetadata._getEntityTypeByPath(N);n=a.createFilterParams(F,A.oMetadata,v);if(n){w.push(n);}u=A._createRequestUrl(P,j,w,A.bUseBatch);R=A._createRequest(u,x,H,null,y);z=A.mRequests;if(G in A.mDeferredGroups){z=A.mDeferredRequests;}A._pushToRequestQueue(z,G,null,R,s,E,J);return R;}if(this.bUseBatch&&this.bIncludeInCurrentBatch){R=I(D);return D;}else{return this._processRequest(I);}};r.prototype.getServiceMetadata=function(){if(this.oMetadata&&this.oMetadata.isLoaded()){return this.oMetadata.getServiceMetadata();}};r.prototype.metadataLoaded=function(){var i=this.oMetadata.loaded();if(this.bLoadAnnotationsJoined){var j=function(){return i;};return this.pAnnotationsLoaded.then(j,j);}else{return i;}};r.prototype.annotationsLoaded=function(){return this.pAnnotationsLoaded;};r.prototype.isMetadataLoadingFailed=function(){return this.oMetadata.isFailed();};r.prototype.getServiceAnnotations=function(){var A=this.oAnnotations.getData();return q.isEmptyObject(A)?null:A;};r.prototype.onAnnotationsFailed=function(E){this.fireAnnotationsFailed(E.getParameters());};r.prototype.onAnnotationsLoaded=function(E){this.fireAnnotationsLoaded(E.getParameters());};r.prototype.addAnnotationUrl=function(u){var j=[].concat(u),k=[],A=[],E=[],t=this;q.each(j,function(i,s){var I=s.indexOf("$metadata");if(I>=0){if(I==0){s=t.sServiceUrl+'/'+s;}k.push(s);}else{A.push(s);}});return this.oMetadata._addUrl(k).then(function(P){return Promise.all(q.map(P,function(i){E=E.concat(i.entitySets);return t.oAnnotations.addSource({type:"xml",data:i["metadataString"]});}));}).then(function(){return t.oAnnotations.addSource(A);}).then(function(P){return{annotations:t.oAnnotations.getData(),entitySets:E};});};r.prototype.addAnnotationXML=function(x,s){return this.oAnnotations.addSource({type:"xml",data:x});};r.prototype.submitChanges=function(P){var R,G,j,s,E,k,v,A=false,n,t,u,w=this;if(P){G=P.groupId||P.batchGroupId;s=P.success;E=P.error;if(P.merge!==undefined){n=P.merge?"MERGE":"PUT";}}if(G&&!this.mDeferredGroups[G]){q.sap.log.fatal(this+" submitChanges: \""+G+"\" is not a deferred group!");}t=q.sap.extend(true,{},w.mChangedEntities);this.oMetadata.loaded().then(function(){q.each(t,function(K,D){j=w._resolveGroup(K);if(j.groupId===G||!G){R=w._processChange(K,D,n||w.sDefaultUpdateMethod);R.key=K;u=D.__metadata&&D.__metadata.created?D.__metadata.created:{};var k={abort:function(){R._aborted=true;}};if(j.groupId in w.mDeferredGroups){w._pushToRequestQueue(w.mDeferredRequests,j.groupId,j.changeSetId,R,u.success,u.error,k);}}});v=w._processRequestQueue(w.mDeferredRequests,G,s,E);if(A){k.abort();}});k={abort:function(){if(v){if(q.isArray(v)){q.each(v,function(i,k){k.abort();});}else{v.abort();}}else{A=true;}}};return k;};r.prototype._updateChangedEntities=function(i){var t=this,R;function u(j,k){q.each(k,function(K){var A=R+'/'+K;if(q.isPlainObject(k[K])&&q.isPlainObject(j[K])){u(j[K],k[K]);if(q.isEmptyObject(k[K])){delete k[K];}}else if(q.sap.equal(k[K],j[K])&&!t.isLaundering(A)){delete k[K];}});}q.each(i,function(k,D){if(k in t.mChangedEntities){var E=t._getObject('/'+k,null,true);var j=t._getObject('/'+k);q.sap.extend(true,E,D);R='/'+k;u(E,j);if(q.isEmptyObject(j)){delete t.mChangedEntities[k];t.abortInternalRequest(k,t._resolveGroup(k).groupId);}else{t.mChangedEntities[k]=j;j.__metadata={};q.extend(j.__metadata,E.__metadata);}}});};r.prototype.resetChanges=function(P){var t=this,j,E={},k,n;if(P){q.each(P,function(I,s){t.getEntityByPath(s,null,E);j=E.propertyPath.split("/");var K=E.key;k=t.mChangedEntities[K];for(var i=0;i<j.length-1;i++){if(k.hasOwnProperty(j[i])){k=k[j[i]];}else{k=undefined;}}if(k){delete k[j[j.length-1]];}if(t.mChangedEntities[K]){n=t.mChangedEntities[K].__metadata;delete t.mChangedEntities[K].__metadata;if(q.isEmptyObject(t.mChangedEntities[K])||!E.propertyPath){t.oMetadata.loaded().then(function(){t.abortInternalRequest(K,t._resolveGroup(K).groupId);});delete t.mChangedEntities[K];}else{t.mChangedEntities[K].__metadata=n;}}else{q.sap.log.warning(t+" - resetChanges: "+s+" is not changed");}});}else{q.each(this.mChangedEntities,function(K,i){t.oMetadata.loaded().then(function(){t.abortInternalRequest(K,t._resolveGroup(K).groupId);});delete t.mChangedEntities[K];});}this.checkUpdate();};r.prototype.setProperty=function(P,v,j,A){var k,s,R,n,t,E={},u,w,K,G,x,y,z={},D={},F,H=false,I=this;u=this.resolve(P,j,true);var E=this.getEntityByPath(u,null,D);if(!E){return false;}s=u.substring(u.lastIndexOf("/")+1);K=D.key;t=this._getObject('/'+K);k=this._getObject(P,j,true);if(!this.mChangedEntities[K]){y=E.__metadata;E={};E.__metadata=q.extend({},y);this.mChangedEntities[K]=E;}var J=this.mChangedEntities[K];w=D.propertyPath.split("/");for(var i=0;i<w.length-1;i++){if(!J.hasOwnProperty(w[i])){J[w[i]]={};}J=J[w[i]];}H=t.__metadata.created&&t.__metadata.created.functionImport;if(q.sap.equal(v,k)&&!this.isLaundering('/'+K)&&!H){delete J[s];y=this.mChangedEntities[K].__metadata;delete this.mChangedEntities[K].__metadata;if(q.isEmptyObject(this.mChangedEntities[K])){delete this.mChangedEntities[K];z[K]=true;this.checkUpdate(false,A,z);I.oMetadata.loaded().then(function(){I.abortInternalRequest(K,I._resolveGroup(K).groupId);});return true;}this.mChangedEntities[K].__metadata=y;}else{J[s]=v;}G=this._resolveGroup(K);R=this.mRequests;if(G.groupId in this.mDeferredGroups){R=this.mDeferredRequests;n=this._processChange(K,{__metadata:E.__metadata});}else{n=this._processChange(K,this._getObject('/'+K));}n.key=K;F=J.__metadata&&J.__metadata.created?J.__metadata.created:{};this.oMetadata.loaded().then(function(){x={abort:function(){n._aborted=true;}};I._pushToRequestQueue(R,G.groupId,G.changeSetId,n,F.success,F.error,x);I._processRequestQueueAsync(I.mRequests);});z[K]=true;this.checkUpdate(false,A,z);return true;};r.prototype._isHeaderPrivate=function(H){switch(H.toLowerCase()){case"accept":case"accept-language":case"maxdataserviceversion":case"dataserviceversion":return true;case"x-csrf-token":return this.bTokenHandling;case"sap-contextid-accept":case"sap-contextid":return!this.bDisableSoftStateHeader;default:return false;}return false;};r.prototype.setHeaders=function(H){var i={},t=this;this.mCustomHeaders={};if(H){q.each(H,function(s,j){if(t._isHeaderPrivate(s)){q.sap.log.warning(this+" - modifying private header: '"+s+"' not allowed!");}else{i[s]=j;}});this.mCustomHeaders=i;}if(this.oAnnotations){this.oAnnotations.setHeaders(this.mCustomHeaders);}};r.prototype._getHeaders=function(H){var i={},t=this;if(H){q.each(H,function(s,j){if(t._isHeaderPrivate(s)){q.sap.log.warning(this+" - modifying private header: '"+s+"' not allowed!");}else{i[s]=j;}});}return q.extend({},this.mCustomHeaders,i,this.oHeaders);};r.prototype.getHeaders=function(){return q.extend({},this.mCustomHeaders,this.oHeaders);};r.prototype._getHeader=function(H,i){var s;for(s in i){if(s.toLowerCase()===H.toLowerCase()){return i[s];}}return null;};r.prototype.hasPendingChanges=function(){return!q.isEmptyObject(this.mChangedEntities);};r.prototype.hasPendingRequests=function(){return this.aPendingRequestHandles.length>0;};r.prototype.getPendingChanges=function(){return q.sap.extend(true,{},this.mChangedEntities);};r.prototype.updateBindings=function(F){this.checkUpdate(F);};r.prototype.setTokenHandlingEnabled=function(t){this.bTokenHandling=t;};r.prototype.setUseBatch=function(u){this.bUseBatch=u;};r.prototype.formatValue=function(v,t){return a.formatValue(v,t);};r.prototype.deleteCreatedEntry=function(i){var t=this,G;if(i){var P=i.getPath();delete this.mContexts[P];if(q.sap.startsWith(P,"/")){P=P.substr(1);}G=this._resolveGroup(P).groupId;t.oMetadata.loaded().then(function(){t.abortInternalRequest(P,G);});delete this.mChangedEntities[P];delete this.oData[P];}};r.prototype.createEntry=function(P,j){var s,E,R,u,k,n,K,t,G,v,w,H,x,y,z={},A,D="POST",F=this;if(j){y=j.properties;G=j.groupId||j.batchGroupId;v=j.changeSetId;n=j.context;s=j.success;E=j.error;A=j.created;k=j.eTag;H=j.headers;w=j.urlParameters;}G=G?G:this.sDefaultChangeGroup;t=a._createUrlParamsArray(w);H=this._getHeaders(H);var I={abort:function(){if(R){R._aborted=true;}}};function J(){var L;if(!q.sap.startsWith(P,"/")){P="/"+P;}var N=F.oMetadata._getEntityTypeByPath(P);if(!N){return undefined;}if(typeof y==="object"&&!q.isArray(y)){z=y;}else{for(var i=0;i<N.property.length;i++){var Q=N.property[i];var S=q.inArray(Q.name,y)>-1;if(!y||S){z[Q.name]=F._createPropertyValue(Q.type);if(S){y.splice(y.indexOf(Q.name),1);}}}if(y){}}var T=F.oMetadata._getEntitySetByType(N);K=T.name+"('"+q.sap.uid()+"')";z.__metadata={type:""+N.entityType,uri:F.sServiceUrl+'/'+K,created:{key:P.substring(1),success:s,error:E,headers:H,urlParameters:w,groupId:G,changeSetId:v,eTag:k}};F.oData[K]=q.sap.extend(true,{},z);F.mChangedEntities[K]=z;u=F._createRequestUrl(P,n,t,F.bUseBatch);R=F._createRequest(u,D,H,z,k);L=F.getContext("/"+K);L.bCreated=true;R.key=K;x=F.mRequests;if(G in F.mDeferredGroups){x=F.mDeferredRequests;}F.oMetadata.loaded().then(function(){F._pushToRequestQueue(x,G,v,R,s,E,I);F._processRequestQueueAsync(F.mRequests);});return L;}if(A){this.oMetadata.loaded().then(function(){A(J());});}else if(this.oMetadata.isLoaded()){return J();}else{q.sap.log.error("Tried to use createEntry without created-callback, before metadata is available!");}};r.prototype._createPropertyValue=function(t){var T=this.oMetadata._splitName(t);var n=T[1];var s=T[0];if(n.toUpperCase()!=='EDM'){var j={};var k=this.oMetadata._getObjectMetadata("complexType",s,n);for(var i=0;i<k.property.length;i++){var P=k.property[i];j[P.name]=this._createPropertyValue(P.type);}return j;}else{return this._getDefaultPropertyValue(s,n);}};r.prototype._getDefaultPropertyValue=function(t,n){return undefined;};r.prototype._normalizePath=function(P,i){if(P&&P.indexOf('?')!==-1){P=P.substr(0,P.indexOf('?'));}if(!i&&!q.sap.startsWith(P,"/")){q.sap.log.fatal(this+" path "+P+" must be absolute if no Context is set");}return this.resolve(P,i);};r.prototype.setRefreshAfterChange=function(R){this.bRefreshAfterChange=R;};r.prototype.isList=function(P,i){P=this.resolve(P,i);return P&&P.substr(P.lastIndexOf("/")).indexOf("(")===-1;};r.prototype.isMetaModelPath=function(P){return P.indexOf("##")==0||P.indexOf("/##")>-1;};r.prototype._request=function(R,s,E,H,i,j){var k;if(this.bDestroyed){return{abort:function(){}};}var t=this;function w(n){return function(){var I=q.inArray(k,t.aPendingRequestHandles);if(I>-1){t.aPendingRequestHandles.splice(I,1);}if(!(k&&k.bSuppressErrorHandlerCall)){n.apply(this,arguments);}};}k=p.request(R,w(s||p.defaultSuccess),w(E||p.defaultError),H,i,j);if(R.async!==false){this.aPendingRequestHandles.push(k);}return k;};r.prototype.destroy=function(){this.bDestroyed=true;M.prototype.destroy.apply(this,arguments);if(this.aPendingRequestHandles){for(var i=this.aPendingRequestHandles.length-1;i>=0;i--){var R=this.aPendingRequestHandles[i];if(R&&R.abort){R.bSuppressErrorHandlerCall=true;R.abort();}}delete this.aPendingRequestHandles;}if(this.sMetadataLoadEvent){q.sap.clearDelayedCall(this.sMetadataLoadEvent);}if(this.oMetadataFailedEvent){q.sap.clearDelayedCall(this.oMetadataFailedEvent);}if(this.oMetadata){this.oMetadata.detachFailed(this.onMetadataFailed);if(!this.oMetadata.isLoaded()&&!this.oMetadata.hasListeners("loaded")){this.oMetadata.destroy();delete this.oServiceData.oMetadata;}delete this.oMetadata;}if(this.oAnnotations){this.oAnnotations.detachSomeLoaded(this.onAnnotationsLoaded);this.oAnnotations.detachAllFailed(this.onAnnotationsFailed);this.oAnnotations.destroy();delete this.oAnnotations;}};r.prototype.setDeferredBatchGroups=function(G){this.setDeferredGroups(G);};r.prototype.setDeferredGroups=function(G){var t=this;this.mDeferredGroups={};q.each(G,function(i,s){t.mDeferredGroups[s]=s;});};r.prototype.getDeferredBatchGroups=function(){return this.getDeferredGroups();};r.prototype.getDeferredGroups=function(){var G=[],i=0;q.each(this.mDeferredGroups,function(k,s){G[i]=s;i++;});return G;};r.prototype.setChangeBatchGroups=function(G){q.each(G,function(E,i){i.groupId=i.batchGroupId;});this.setChangeGroups(G);};r.prototype.setChangeGroups=function(G){this.mChangeGroups=G;};r.prototype.getChangeBatchGroups=function(){return this.getChangeGroups();};r.prototype.getChangeGroups=function(){return this.mChangeGroups;};r.prototype.setMessageParser=function(P){if(!(P instanceof m)){q.sap.log.error("Given MessageParser is not of type sap.ui.core.message.MessageParser");return;}P.setProcessor(this);this.oMessageParser=P;return this;};r.prototype._parseResponse=function(R,i,G,j){try{if(!this.oMessageParser){this.oMessageParser=new o(this.sServiceUrl,this.oMetadata);this.oMessageParser.setProcessor(this);}return this.oMessageParser.parse(R,i,G,j);}catch(k){q.sap.log.error("Error parsing OData messages: "+k);}};r.prototype.callAfterUpdate=function(F){this.aCallAfterUpdate.push(F);};r.prototype.getMetaModel=function(){var t=this;if(!this.oMetaModel){this.oMetaModel=new l(this.oMetadata,this.oAnnotations,{addAnnotationUrl:this.addAnnotationUrl.bind(this),annotationsLoadedPromise:this.pAnnotationsLoaded});this.oMetaModel.loaded().then(function(){t.bMetaModelLoaded=true;t.checkUpdate(false,false,null,true);},function(E){var s=E.message,D;if(!s&&E.xmlDoc&&E.xmlDoc.parseError){s=E.xmlDoc.parseError.reason;D=E.xmlDoc.parseError.srcText;}q.sap.log.error("error in ODataMetaModel.loaded(): "+s,D,"sap.ui.model.odata.v2.ODataModel");});}return this.oMetaModel;};r.prototype.getOriginalProperty=function(P,i){return this._getObject(P,i,true);};r.prototype.getEntityByPath=function(P,i,E){var R=M.prototype.resolve.call(this,P,i);if(!R){return null;}var j=R.split("/"),k=null,n=[];while(j.length>0){var s=j.join("/"),t=this._getObject(s);if(q.isPlainObject(t)){var K=this._getKey(t);if(K){k=t;break;}}n.unshift(j.pop());}if(k){E.propertyPath=n.join("/");E.key=K;return k;}return null;};r.prototype.resolve=function(P,i,j){var R=M.prototype.resolve.call(this,P,i);if(j){var E={},k=this.getEntityByPath(P,i,E);if(k){if(E.propertyPath){return"/"+E.key+"/"+E.propertyPath;}else{return"/"+E.key;}}else{return undefined;}}return R;};r.prototype.isLaundering=function(P,i){var R=this.resolve(P,i);return(R in this.mLaunderingState)&&this.mLaunderingState[R]>0;};r.prototype.increaseLaundering=function(P,i){if(!i){return;}for(var n in i){if(n==="__metadata"){continue;}var j=i[n];if(q.isPlainObject(j)){this.increaseLaundering(P+"/"+n,j);}else{var t=P+"/"+n;if(!(t in this.mLaunderingState)){this.mLaunderingState[t]=0;}this.mLaunderingState[t]++;}}if(!(P in this.mLaunderingState)){this.mLaunderingState[P]=0;}this.mLaunderingState[P]++;};r.prototype.decreaseLaundering=function(P,i){if(!i){return;}for(var n in i){if(n==="__metadata"){continue;}var j=i[n],t=P+"/"+n;if(q.isPlainObject(j)){this.decreaseLaundering(t,j);}else{if(t in this.mLaunderingState){this.mLaunderingState[t]--;if(this.mLaunderingState[t]===0){delete this.mLaunderingState[t];}}}}this.mLaunderingState[P]--;if(this.mLaunderingState[P]===0){delete this.mLaunderingState[P];}};return r;});
