/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./ComboBoxTextField','./ComboBoxBase','./ComboBoxRenderer','./Popover','./SelectList','./Dialog','./Toolbar','./Button','./library','sap/ui/Device'],function(q,C,a,b,P,S,D,T,B,l,c){"use strict";var d=a.extend("sap.m.ComboBox",{metadata:{library:"sap.m",properties:{selectedKey:{type:"string",group:"Data",defaultValue:""},selectedItemId:{type:"string",group:"Misc",defaultValue:""},showSecondaryValues:{type:"boolean",group:"Misc",defaultValue:false}},associations:{selectedItem:{type:"sap.ui.core.Item",multiple:false}},events:{selectionChange:{parameters:{selectedItem:{type:"sap.ui.core.Item"}}}}}});function h(o,i){if(!i){return;}var e=o.getFocusDomRef(),g=e.selectionStart,j=e.selectionEnd,I=g!==j,t=e.value.substring(0,e.selectionStart),k=this.getSelectedItem();if(i!==k){o.updateDomValue(i.getText());this.setSelection(i);this.fireSelectionChange({selectedItem:i});i=this.getSelectedItem();if(!q.sap.startsWithIgnoreCase(i.getText(),t)||!I){g=0;}o.selectText(g,e.value.length);}this.scrollToItem(i);}function s(i,e){if(document.activeElement===this.getFocusDomRef()){this.selectText(i,e);}}function f(i){var I=this.getSelectedItem(),o=I&&I.getDomRef(),e=I&&o.offsetTop,g=I&&o.offsetHeight,p=this.getPicker(),j=p.getDomRef("cont"),k=j.clientHeight;if(I&&((e+g)>(k))){if(!i){this.getList().$().css("visibility","hidden");}else{j.scrollTop=e-g/2;this.getList().$().css("visibility","visible");}}}d.prototype._handleAriaActiveDescendant=function(i){var o=this.getFocusDomRef(),A="aria-activedescendant";if(o){if(i&&i.getDomRef()&&this.isOpen()){o.setAttribute(A,i.getId());}else{o.removeAttribute(A);}}};d.prototype._getSelectedItemText=function(i){i=i||this.getSelectedItem();if(!i){i=this.getDefaultSelectedItem();}if(i){return i.getText();}return"";};d.prototype._callMethodInControl=function(F,A){var L=this.getList();if(A[0]==="items"){if(L){return S.prototype[F].apply(L,A);}}else{return a.prototype[F].apply(this,A);}};d.prototype._setItemVisibility=function(i,v){var o=i&&i.$(),e="sapMSelectListItemBaseInvisible";if(v){i.bVisible=true;o.length&&o.removeClass(e);}else{i.bVisible=false;o.length&&o.addClass(e);}};d.prototype.setSelectedIndex=function(i,_){var I;_=_||this.getItems();i=(i>_.length-1)?_.length-1:Math.max(0,i);I=_[i];if(I){this.setSelection(I);}};d.prototype.createDropdown=function(){var t=this;var p=new P({showHeader:false,placement:sap.m.PlacementType.VerticalPreferredBottom,offsetX:0,offsetY:0,initialFocus:this,bounce:false,showArrow:false});p.open=function(){return this.openBy(t);};return p;};d.prototype.createPickerTextField=function(){var t=new C({width:"100%",showButton:false}).addEventDelegate({onsapenter:function(){this.updateDomValue(t.getValue());this.onChange();}},this);return t;};d.prototype.init=function(){a.prototype.init.apply(this,arguments);this.bOpenValueStateMessage=true;this._sValueBeforeOpen="";this._oSelectedItemBeforeOpen=null;};d.prototype.onBeforeRendering=function(){a.prototype.onBeforeRendering.apply(this,arguments);this.synchronizeSelection();};d.prototype.exit=function(){a.prototype.exit.apply(this,arguments);this._oSelectedItemBeforeOpen=null;};d.prototype.onBeforeRenderingPicker=function(){var o=this["onBeforeRendering"+this.getPickerType()];o&&o.call(this);};d.prototype.onBeforeRenderingDropdown=function(){var p=this.getPicker(),w=(this.$().outerWidth()/parseFloat(sap.m.BaseFontSize))+"rem";if(p){p.setContentMinWidth(w);}};d.prototype.onBeforeRenderingList=function(){if(this.bProcessingLoadItemsEvent){var L=this.getList(),F=this.getFocusDomRef();if(L){L.setBusy(true);}if(F){F.setAttribute("aria-busy","true");}}};d.prototype.onAfterRenderingPicker=function(){var o=this["onAfterRendering"+this.getPickerType()];o&&o.call(this);f.call(this,false);};d.prototype.onAfterRenderingList=function(){if(this.bProcessingLoadItemsEvent&&(this.getItems().length===0)){return;}var L=this.getList(),F=this.getFocusDomRef();if(L){L.setBusy(false);}if(F){F.removeAttribute("aria-busy");}};d.prototype.onBeforeOpenDialog=function(){var p=this.getPickerTextField();this._oSelectedItemBeforeOpen=this.getSelectedItem();this._sValueBeforeOpen=this.getValue();if(this.getSelectedItem()){this.filterItems({property:"text",value:""});}p.setValue(this._sValueBeforeOpen);};d.prototype.revertSelection=function(){var p,o=this.getPickerTextField();this.setSelectedItem(this._oSelectedItemBeforeOpen);this.setValue(this._sValueBeforeOpen);if(this.getSelectedItem()===null){p=this._sValueBeforeOpen;}else{p=this._oSelectedItemBeforeOpen.getText();}o&&o.setValue(p);};d.prototype.oninput=function(e){a.prototype.oninput.apply(this,arguments);if(e.isMarked("invalid")){return;}var t=(this.getPickerType()==="Dropdown");this.loadItems(function(){var o=this.getSelectedItem(),v=e.target.value,E=v==="",g=e.srcControl,V;if(E&&!this.bOpenedByKeyboardOrButton){V=this.getItems();}else{V=this.filterItems({property:"text",value:v});}var i=!!V.length;var F=V[0];if(!E&&F&&F.getEnabled()){if(g._bDoTypeAhead){g.updateDomValue(F.getText());}this.setSelection(F);if(o!==this.getSelectedItem()){this.fireSelectionChange({selectedItem:this.getSelectedItem()});}if(g._bDoTypeAhead){setTimeout(s.bind(g,v.length,g.getValue().length),0);}}if(E||!i){this.setSelection(null);if(o!==this.getSelectedItem()){this.fireSelectionChange({selectedItem:this.getSelectedItem()});}}if(i){if(E&&!this.bOpenedByKeyboardOrButton){this.close();}else if(t){this.open();this.scrollToItem(this.getSelectedItem());}}else if(this.isOpen()){if(t){this.close();}}else{this.clearFilter();}},{name:"input",busyIndicator:false});if(this.bProcessingLoadItemsEvent&&t){this.open();}};d.prototype.filterItems=function(o,I){var p=o.property,v=o.value,e=v==="",m=false,M="get"+p.charAt(0).toUpperCase()+p.slice(1),F=[],g=null;I=I||this.getItems();for(var i=0;i<I.length;i++){g=I[i];m=q.sap.startsWithIgnoreCase(g[M](),v)||e;if(m){F.push(g);}this._setItemVisibility(g,m);}return F;};d.prototype.onSelectionChange=function(o){var i=o.getParameter("selectedItem"),t=c.system.tablet;this.setSelection(i);this.fireSelectionChange({selectedItem:this.getSelectedItem()});if(this.getPickerType()==="Dialog"||t){this.onChange();}};d.prototype.onItemPress=function(o){var i=o.getParameter("item");this.close();this.updateDomValue(i.getText());this.setProperty("value",i.getText(),true);setTimeout(this.selectText.bind(this,this.getValue().length,this.getValue().length),0);};d.prototype.onkeydown=function(e){var o=e.srcControl;a.prototype.onkeydown.apply(o,arguments);if(!o.getEnabled()||!o.getEditable()){return;}var k=q.sap.KeyCodes;o._bDoTypeAhead=(e.which!==k.BACKSPACE)&&(e.which!==k.DELETE);};d.prototype.oncut=function(e){var o=e.srcControl;a.prototype.oncut.apply(o,arguments);o._bDoTypeAhead=false;};d.prototype.onsapenter=function(e){var o=e.srcControl;a.prototype.onsapenter.apply(o,arguments);if(!o.getEnabled()||!o.getEditable()){return;}if(o.isOpen()){o.close();}};d.prototype.onsapdown=function(e){var o=e.srcControl;if(!o.getEnabled()||!o.getEditable()){return;}e.setMarked();e.preventDefault();this.loadItems(function navigateToNextSelectableItem(){var g=this.getSelectableItems();var n=g[g.indexOf(this.getSelectedItem())+1];h.call(this,o,n);});};d.prototype.onsapup=function(e){var o=e.srcControl;if(!o.getEnabled()||!o.getEditable()){return;}e.setMarked();e.preventDefault();this.loadItems(function navigateToPrevSelectableItem(){var g=this.getSelectableItems();var p=g[g.indexOf(this.getSelectedItem())-1];h.call(this,o,p);});};d.prototype.onsaphome=function(e){var o=e.srcControl;if(!o.getEnabled()||!o.getEditable()){return;}e.setMarked();e.preventDefault();this.loadItems(function navigateToFirstSelectableItem(){var F=this.getSelectableItems()[0];h.call(this,o,F);});};d.prototype.onsapend=function(e){var o=e.srcControl;if(!o.getEnabled()||!o.getEditable()){return;}e.setMarked();e.preventDefault();this.loadItems(function navigateToLastSelectableItem(){var L=this.findLastEnabledItem(this.getSelectableItems());h.call(this,o,L);});};d.prototype.onsappagedown=function(e){var o=e.srcControl;if(!o.getEnabled()||!o.getEditable()){return;}e.setMarked();e.preventDefault();this.loadItems(function(){var g=this.getSelectableItems(),i=g.indexOf(this.getSelectedItem())+10,I;i=(i>g.length-1)?g.length-1:Math.max(0,i);I=g[i];h.call(this,o,I);});};d.prototype.onsappageup=function(e){var o=e.srcControl;if(!o.getEnabled()||!o.getEditable()){return;}e.setMarked();e.preventDefault();this.loadItems(function(){var g=this.getSelectableItems(),i=g.indexOf(this.getSelectedItem())-10,I;i=(i>g.length-1)?g.length-1:Math.max(0,i);I=g[i];h.call(this,o,I);});};d.prototype.onfocusin=function(e){var g=this.getPickerType()==="Dropdown";if(e.target===this.getOpenArea()){this.bOpenValueStateMessage=false;if(g){this.focus();}}else{if(g){setTimeout(function(){if(document.activeElement===this.getFocusDomRef()&&!this.bFocusoutDueRendering&&!this.getSelectedText()){this.selectText(0,this.getValue().length);}}.bind(this),0);}if(!this.isOpen()&&this.bOpenValueStateMessage&&this.shouldValueStateMessageBeOpened()){this.openValueStateMessage();}this.bOpenValueStateMessage=true;}this.$().addClass("sapMFocus");};d.prototype.onsapfocusleave=function(e){var t,p,r,F,n;a.prototype.onsapfocusleave.apply(this,arguments);if(this.getPickerType()==="Dialog"){return;}p=this.getAggregation("picker");if(!e.relatedControlId||!p){return;}n=!c.system.combi;t=c.system.tablet&&n;r=sap.ui.getCore().byId(e.relatedControlId);F=r&&r.getFocusDomRef();if(q.sap.containsOrEquals(p.getFocusDomRef(),F)&&!t){this.focus();}};d.prototype.setSelection=function(i){var L=this.getList(),k;if(L){L.setSelection(i);}this.setAssociation("selectedItem",i,true);this.setProperty("selectedItemId",(i instanceof sap.ui.core.Item)?i.getId():i,true);if(typeof i==="string"){i=sap.ui.getCore().byId(i);}k=i?i.getKey():"";this.setProperty("selectedKey",k,true);this._handleAriaActiveDescendant(i);};d.prototype.isSelectionSynchronized=function(){var i=this.getSelectedItem();return this.getSelectedKey()===(i&&i.getKey());};d.prototype.synchronizeSelection=function(){if(this.isSelectionSynchronized()){return;}var k=this.getSelectedKey(),i=this.getItemByKey(""+k);if(i&&(k!=="")){this.setAssociation("selectedItem",i,true);this.setProperty("selectedItemId",i.getId(),true);if(this._sValue===this.getValue()){this.setValue(i.getText());}}};d.prototype.isFiltered=function(){var L=this.getList();return L&&(L.getVisibleItems().length!==L.getItems().length);};d.prototype.isItemVisible=function(i){return i&&(i.bVisible===undefined||i.bVisible);};d.prototype.createPicker=function(p){var o=this.getAggregation("picker");if(o){return o;}o=this["create"+p]();this.setAggregation("picker",o,true);var e=this.getRenderer().CSS_CLASS_COMBOBOXBASE;o.setHorizontalScrolling(false).addStyleClass(e+"Picker").addStyleClass(e+"Picker-CTX").attachBeforeOpen(this.onBeforeOpen,this).attachAfterOpen(this.onAfterOpen,this).attachBeforeClose(this.onBeforeClose,this).attachAfterClose(this.onAfterClose,this).addEventDelegate({onBeforeRendering:this.onBeforeRenderingPicker,onAfterRendering:this.onAfterRenderingPicker},this).addContent(this.createList());return o;};d.prototype.createList=function(){var r=this.getRenderer();this._oList=new S({width:"100%",busyIndicatorDelay:0}).addStyleClass(r.CSS_CLASS_COMBOBOXBASE+"List").addStyleClass(r.CSS_CLASS_COMBOBOX+"List").addEventDelegate({ontap:function(e){this.close();},onBeforeRendering:this.onBeforeRenderingList,onAfterRendering:this.onAfterRenderingList},this).attachSelectionChange(this.onSelectionChange,this).attachItemPress(this.onItemPress,this);return this._oList;};d.prototype.onBeforeOpen=function(){var p=this["onBeforeOpen"+this.getPickerType()],o=this.getFocusDomRef();if(this.hasLoadItemsEventListeners()&&!this.bProcessingLoadItemsEvent){this.loadItems();}this.addStyleClass(this.getRenderer().CSS_CLASS_COMBOBOXBASE+"Pressed");if(o){o.setAttribute("aria-owns",this.getList().getId());}this.addContent();p&&p.call(this);};d.prototype.onBeforeOpenDropdown=function(){};d.prototype.onAfterOpen=function(){var o=this.getFocusDomRef(),i=this.getSelectedItem();if(o){o.setAttribute("aria-expanded","true");i&&o.setAttribute("aria-activedescendant",i.getId());}f.call(this,true);};d.prototype.onBeforeClose=function(){a.prototype.onBeforeClose.apply(this,arguments);var o=this.getFocusDomRef();if(o){o.removeAttribute("aria-owns");o.removeAttribute("aria-activedescendant");if(this.shouldValueStateMessageBeOpened()&&(document.activeElement===o)){this.openValueStateMessage();}}this.removeStyleClass(this.getRenderer().CSS_CLASS_COMBOBOXBASE+"Pressed");};d.prototype.onAfterClose=function(){var o=this.getFocusDomRef();if(o){o.setAttribute("aria-expanded","false");}this.clearFilter();};d.prototype.isItemSelected=function(i){return i&&(i.getId()===this.getAssociation("selectedItem"));};d.prototype.getDefaultSelectedItem=function(){return null;};d.prototype.clearSelection=function(){this.setSelection(null);};d.prototype.onPropertyChange=function(o,e){var n=o.getParameter("newValue"),p=o.getParameter("name"),m="set"+p.charAt(0).toUpperCase()+p.slice(1),g=(e&&e.srcControl)||this.getPickerTextField();if(/\bvalue\b|\benabled\b|\bname\b|\bplaceholder\b|\beditable\b|\btextAlign\b|\btextDirection\b/.test(p)&&g&&(typeof g[m]==="function")){g[m](n);}};d.prototype.onItemChange=function(o){var e=this.getAssociation("selectedItem"),n=o.getParameter("newValue"),p=o.getParameter("name");if(e===o.getParameter("id")){switch(p){case"text":if(!this.isBound("value")){this.setValue(n);}break;case"key":if(!this.isBound("selectedKey")){this.setSelectedKey(n);}break;}}};d.prototype.selectText=function(i,e){a.prototype.selectText.apply(this,arguments);this.textSelectionStart=i;this.textSelectionEnd=e;return this;};d.prototype.addAggregation=function(A,o,e){this._callMethodInControl("addAggregation",arguments);if(A==="items"&&!e&&!this.isInvalidateSuppressed()){this.invalidate(o);}return this;};d.prototype.getAggregation=function(){return this._callMethodInControl("getAggregation",arguments);};d.prototype.setAssociation=function(A,i,e){var L=this.getList();if(L&&(A==="selectedItem")){S.prototype.setAssociation.apply(L,arguments);}return a.prototype.setAssociation.apply(this,arguments);};d.prototype.indexOfAggregation=function(){return this._callMethodInControl("indexOfAggregation",arguments);};d.prototype.insertAggregation=function(){this._callMethodInControl("insertAggregation",arguments);return this;};d.prototype.removeAggregation=function(){return this._callMethodInControl("removeAggregation",arguments);};d.prototype.removeAllAggregation=function(){return this._callMethodInControl("removeAllAggregation",arguments);};d.prototype.destroyAggregation=function(A,e){this._callMethodInControl("destroyAggregation",arguments);return this;};d.prototype.setProperty=function(p,v,e){var L=this.getList();if(/selectedKey|selectedItemId/.test(p)){L&&S.prototype.setProperty.apply(L,arguments);}return a.prototype.setProperty.apply(this,arguments);};d.prototype.removeAllAssociation=function(A,e){var L=this.getList();if(L&&(A==="selectedItem")){S.prototype.removeAllAssociation.apply(L,arguments);}return a.prototype.removeAllAssociation.apply(this,arguments);};d.prototype.clone=function(I){var o=a.prototype.clone.apply(this,arguments),L=this.getList();if(!this.isBound("items")&&L){for(var i=0,e=L.getItems();i<e.length;i++){o.addItem(e[i].clone());}o.setSelectedIndex(this.indexOfItem(this.getSelectedItem()));}return o;};d.prototype.findAggregatedObjects=function(){var L=this.getList();if(L){return S.prototype.findAggregatedObjects.apply(L,arguments);}return[];};d.prototype.setShowSecondaryValues=function(A){this.setProperty("showSecondaryValues",A,true);var L=this.getList();if(L){L.setShowSecondaryValues(A);}return this;};d.prototype.getItems=function(){var L=this.getList();return L?L.getItems():[];};d.prototype.setSelectedItem=function(i){if(typeof i==="string"){this.setAssociation("selectedItem",i,true);i=sap.ui.getCore().byId(i);}if(!(i instanceof sap.ui.core.Item)&&i!==null){return this;}if(!i){i=this.getDefaultSelectedItem();}this.setSelection(i);this.setValue(this._getSelectedItemText(i));return this;};d.prototype.setSelectedItemId=function(i){i=this.validateProperty("selectedItemId",i);if(!i){i=this.getDefaultSelectedItem();}this.setSelection(i);i=this.getSelectedItem();this.setValue(this._getSelectedItemText(i));return this;};d.prototype.setSelectedKey=function(k){k=this.validateProperty("selectedKey",k);var e=(k==="");if(e){this.setSelection(null);this.setValue("");return this;}var i=this.getItemByKey(k);if(i){this.setSelection(i);this.setValue(this._getSelectedItemText(i));return this;}this._sValue=this.getValue();return this.setProperty("selectedKey",k);};d.prototype.getSelectedItem=function(){var v=this.getAssociation("selectedItem");return(v===null)?null:sap.ui.getCore().byId(v)||null;};d.prototype.removeItem=function(i){i=a.prototype.removeItem.apply(this,arguments);var I;if(this.isBound("items")&&!this.bItemsUpdated){return i;}var v=this.getValue();if(this.getItems().length===0){this.clearSelection();}else if(this.isItemSelected(i)){I=this.getDefaultSelectedItem();this.setSelection(I);this.setValue(v);}return i;};return d;},true);
