/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./Bar','./InputBase','./ComboBoxBase','./Dialog','./MultiInput','./Input','./ToggleButton','./List','./MultiComboBoxRenderer','./Popover','./library','sap/ui/core/EnabledPropagator','sap/ui/core/IconPool','jquery.sap.xml'],function(q,B,I,C,D,M,a,T,L,b,P,l,E,c){"use strict";var d=C.extend("sap.m.MultiComboBox",{metadata:{library:"sap.m",properties:{selectedKeys:{type:"string[]",group:"Data",defaultValue:[]}},associations:{selectedItems:{type:"sap.ui.core.Item",multiple:true,singularName:"selectedItem"}},events:{selectionChange:{parameters:{changedItem:{type:"sap.ui.core.Item"},selected:{type:"boolean"}}},selectionFinish:{parameters:{selectedItems:{type:"sap.ui.core.Item[]"}}}}}});c.insertFontFaceStyle();E.apply(d.prototype,[true]);d.prototype.onsapend=function(e){sap.m.Tokenizer.prototype.onsapend.apply(this._oTokenizer,arguments);};d.prototype.onsaphome=function(e){sap.m.Tokenizer.prototype.onsaphome.apply(this._oTokenizer,arguments);};d.prototype.onsapdown=function(e){if(!this.getEnabled()||!this.getEditable()){return;}e.setMarked();e.preventDefault();var i=this.getSelectableItems();var o=i[0];if(o&&this.isOpen()){this.getListItem(o).focus();return;}if(this._oTokenizer.getSelectedTokens().length){return;}this._oTraversalItem=this._getNextTraversalItem();if(this._oTraversalItem){this.updateDomValue(this._oTraversalItem.getText());this.selectText(0,this.getValue().length);}this._setContainerSizes();};d.prototype.onsapup=function(e){if(!this.getEnabled()||!this.getEditable()){return;}e.setMarked();e.preventDefault();if(this._oTokenizer.getSelectedTokens().length){return;}this._oTraversalItem=this._getPreviousTraversalItem();if(this._oTraversalItem){this.updateDomValue(this._oTraversalItem.getText());this.selectText(0,this.getValue().length);}this._setContainerSizes();};d.prototype._selectItemByKey=function(e){var v,p,o,i,f,g=this.isOpen();if(!this.getEnabled()||!this.getEditable()){return;}if(e){e.setMarked();}v=this._getUnselectedItems(g?"":this.getValue());for(i=0;i<v.length;i++){if(v[i].getText().toUpperCase()===this.getValue().toUpperCase()){o=v[i];f=true;break;}}if(f){p={item:o,id:o.getId(),key:o.getKey(),fireChangeEvent:true,fireFinishEvent:true,suppressInvalidate:true,listItemUpdated:false};this._bPreventValueRemove=false;if(this.getValue()===""||q.sap.startsWithIgnoreCase(o.getText(),this.getValue())){if(this.getListItem(o).isSelected()){this.setValue('');}else{this.setSelection(p);}}}else{this._bPreventValueRemove=true;this._showWrongValueVisualEffect();}if(e){this.close();}};d.prototype.onsapenter=function(e){I.prototype.onsapenter.apply(this,arguments);this._selectItemByKey(e);};d.prototype.onsaptabnext=function(e){var i=this.getValue();if(i){var s=this._getUnselectedItemsStartingText(i);if(s.length===1){this._selectItemByKey(e);}else{this._showWrongValueVisualEffect();this.setValue(null);}}};d.prototype.onsapfocusleave=function(e){var p=this.getAggregation("picker");var o=sap.ui.getCore().byId(e.relatedControlId);var f=o&&o.getFocusDomRef();if(!p||!p.getFocusDomRef()||!f||!q.contains(p.getFocusDomRef(),f)){this.setValue(null);}if(p&&f){if(q.sap.equal(p.getFocusDomRef(),f)){this.focus();}}this._setContainerSizes();};d.prototype.onfocusin=function(e){this.addStyleClass("sapMFocus");if(e.target===this.getOpenArea()){this.focus();}if(!this.isOpen()&&this.shouldValueStateMessageBeOpened()){this.openValueStateMessage();}};d.prototype.onsapescape=function(e){C.prototype.onsapescape.apply(this,arguments);this._setContainerSizes();};d.prototype._handleItemTap=function(e){if(e.target.childElementCount===0||e.target.childElementCount===2){if(this.isOpen()&&!this._isListInSuggestMode()){this.close();}}};d.prototype._handleItemPress=function(e){if(this.isOpen()&&this._isListInSuggestMode()&&this.getPicker().oPopup.getOpenState()!==sap.ui.core.OpenState.CLOSING){this.clearFilter();var i=this._getLastSelectedItem();if(i){this.getListItem(i).focus();}}};d.prototype._handleSelectionLiveChange=function(e){var o=e.getParameter("listItem");var i=e.getParameter("selected");var n=this._getItemByListItem(o);if(o.getType()==="Inactive"){return;}if(!n){return;}var p={item:n,id:n.getId(),key:n.getKey(),fireChangeEvent:true,suppressInvalidate:true,listItemUpdated:true};if(i){this.fireChangeEvent(n.getText());this.setSelection(p);}else{this.fireChangeEvent(n.getText());this.removeSelection(p);}this.setValue(this._sOldValue);if(this.isOpen()&&this.getPicker().oPopup.getOpenState()!==sap.ui.core.OpenState.CLOSING){o.focus();}};d.prototype.onkeydown=function(e){C.prototype.onkeydown.apply(this,arguments);if(!this.getEnabled()||!this.getEditable()){return;}this._bIsPasteEvent=(e.ctrlKey||e.metaKey)&&(e.which===q.sap.KeyCodes.V);if(this.getValue().length===0&&(e.ctrlKey||e.metaKey)&&(e.which===q.sap.KeyCodes.A)&&this._hasTokens()){this._oTokenizer.focus();this._oTokenizer.selectAllTokens(true);e.preventDefault();}if(this.isPickerDialog()){this._sOldValue=this.getPickerTextField().getValue();this._iOldCursorPos=q(this.getFocusDomRef()).cursorPos();}};d.prototype.oninput=function(e){C.prototype.oninput.apply(this,arguments);var v=e.target.value,i,r,f,V,o=e.srcControl;if(!this.getEnabled()||!this.getEditable()){return;}if(this._bIsPasteEvent){o.updateDomValue(this._sOldValue||"");return;}f=this._getItemsStartingText(v);V=!!f.length;if(!V&&v!==""){o.updateDomValue(this._sOldValue||"");if(this._iOldCursorPos){q(o.getFocusDomRef()).cursorPos(this._iOldCursorPos);}this._showWrongValueVisualEffect();return;}i=this.getSelectableItems();r=this._sOldInput&&this._sOldInput.length>v.length;if(r&&(this.isPickerDialog()&&this._getFilterSelectedButton().getPressed())){i=this.getSelectedItems();}else if(r){i=this.getItems();}this.filterItems(i,v);this._setContainerSizes();if((!this.getValue()||!V)&&!this.bOpenedByKeyboardOrButton&&!this.isPickerDialog()){this.close();}else{this.open();}this._sOldInput=v;};d.prototype.filterItems=function(i,v){i.forEach(function(o){var m=q.sap.startsWithIgnoreCase(o.getText(),v);if(v===""){m=true;if(!this.bOpenedByKeyboardOrButton){return;}}var e=this.getListItem(o);if(e){e.setVisible(m);}},this);};d.prototype.onkeyup=function(e){if(!this.getEnabled()||!this.getEditable()){return;}this._sOldValue=this.getValue();this._iOldCursorPos=q(this.getFocusDomRef()).cursorPos();};d.prototype._showWrongValueVisualEffect=function(){var o=this.getValueState();if(o===sap.ui.core.ValueState.Error){return;}if(this.isPickerDialog()){this.getPickerTextField().setValueState(sap.ui.core.ValueState.Error);q.sap.delayedCall(1000,this.getPickerTextField(),"setValueState",[o]);}else{this.setValueState(sap.ui.core.ValueState.Error);q.sap.delayedCall(1000,this,"setValueState",[o]);}};d.prototype.createPicker=function(p){var o=this.getAggregation("picker");if(o){return o;}o=this["create"+p]();this.setAggregation("picker",o,true);var r=this.getRenderer(),e=r.CSS_CLASS_MULTICOMBOBOX;o.setHorizontalScrolling(false).addStyleClass(r.CSS_CLASS_COMBOBOXBASE+"Picker").addStyleClass(e+"Picker").addStyleClass(e+"Picker-CTX").attachBeforeOpen(this.onBeforeOpen,this).attachAfterOpen(this.onAfterOpen,this).attachBeforeClose(this.onBeforeClose,this).attachAfterClose(this.onAfterClose,this).addEventDelegate({onBeforeRendering:this.onBeforeRenderingPicker,onAfterRendering:this.onAfterRenderingPicker},this).addContent(this.getList());return o;};d.prototype.createPickerTextField=function(){return new a();};d.prototype.onBeforeRendering=function(){C.prototype.onBeforeRendering.apply(this,arguments);var i=this.getItems();var o=this.getList();if(o){this._synchronizeSelectedItemAndKey(i);o.destroyItems();this._clearTokenizer();this._fillList(i);if(o.getItemNavigation()){this._iFocusedIndex=o.getItemNavigation().getFocusedIndex();}this.setEditable(this.getEditable());}};d.prototype.onBeforeRenderingPicker=function(){var o=this["_onBeforeRendering"+this.getPickerType()];if(o){o.call(this);}};d.prototype.onAfterRenderingPicker=function(){var o=this["_onAfterRendering"+this.getPickerType()];if(o){o.call(this);}};d.prototype.onBeforeOpen=function(){var p=this["_onBeforeOpen"+this.getPickerType()];this.addStyleClass(this.getRenderer().CSS_CLASS_COMBOBOXBASE+"Pressed");this._resetCurrentItem();this.addContent();this._aInitiallySelectedItems=this.getSelectedItems();if(p){p.call(this);}};d.prototype.onAfterOpen=function(){this.closeValueStateMessage();};d.prototype.onBeforeClose=function(){C.prototype.onBeforeClose.apply(this,arguments);};d.prototype.onAfterClose=function(){this.removeStyleClass(this.getRenderer().CSS_CLASS_COMBOBOXBASE+"Pressed");this.clearFilter();!this._bPreventValueRemove&&this.setValue("");this._sOldValue="";if(this.isPickerDialog()){this.getPickerTextField().setValue("");this._getFilterSelectedButton().setPressed(false);}this.fireSelectionFinish({selectedItems:this.getSelectedItems()});};d.prototype._onBeforeOpenDialog=function(){};d.prototype._onBeforeOpenPopover=function(){var p=this.getPicker(),o=this.getDomRef(),w;if(o&&p){w=(o.offsetWidth/parseFloat(sap.m.BaseFontSize))+"rem";p.setContentMinWidth(w);}};d.prototype._decoratePopover=function(p){var t=this;p.open=function(){return this.openBy(t);};};d.prototype.createPopover=function(){var p=new P({showArrow:false,showHeader:false,placement:sap.m.PlacementType.Vertical,offsetX:0,offsetY:0,initialFocus:this,bounce:false});this._decoratePopover(p);return p;};d.prototype.createDialog=function(){var o=C.prototype.createDialog.apply(this,arguments),s=this._createFilterSelectedButton();o.getSubHeader().addContent(s);return o;};d.prototype._createFilterSelectedButton=function(){var i=c.getIconURI("multiselect-all"),r=this.getRenderer(),t=this;return new T({icon:i,press:t._filterSelectedItems.bind(this)}).addStyleClass(r.CSS_CLASS_MULTICOMBOBOX+"ToggleButton");};d.prototype._getFilterSelectedButton=function(){return this.getPicker().getSubHeader().getContent()[1];};d.prototype._filterSelectedItems=function(e){var o=e.oSource,f,m,v=this.getPickerTextField().getValue(),p=o.getPressed(),V=this.getVisibleItems(),i=this.getItems(),s=this.getSelectedItems();if(p){V.forEach(function(g){m=s.indexOf(g)>-1?true:false;f=this.getListItem(g);if(f){f.setVisible(m);}},this);}else{this.filterItems(i,v);}};d.prototype.revertSelection=function(){this.setSelectedItems(this._aInitiallySelectedItems);};d.prototype.createList=function(){var r=this.getRenderer();this._oList=new L({width:"100%",mode:sap.m.ListMode.MultiSelect,includeItemInSelection:true,rememberSelections:false}).addStyleClass(r.CSS_CLASS_COMBOBOXBASE+"List").addStyleClass(r.CSS_CLASS_MULTICOMBOBOX+"List").attachBrowserEvent("tap",this._handleItemTap,this).attachSelectionChange(this._handleSelectionLiveChange,this).attachItemPress(this._handleItemPress,this);this._oList.addEventDelegate({onAfterRendering:this.onAfterRenderingList},this);};d.prototype.setSelection=function(o){if(o.item&&this.isItemSelected(o.item)){return;}if(!o.item){return;}this.addAssociation("selectedItems",o.item,o.suppressInvalidate);var s=this.getKeys(this.getSelectedItems());this.setProperty("selectedKeys",s,o.suppressInvalidate);if(!o.listItemUpdated&&this.getListItem(o.item)){this.getList().setSelectedItem(this.getListItem(o.item),true);}var t=new sap.m.Token({key:o.key});t.setText(o.item.getText());t.setTooltip(o.item.getText());o.item.data(this.getRenderer().CSS_CLASS_COMBOBOXBASE+"Token",t);this._oTokenizer.addToken(t);this.$().toggleClass("sapMMultiComboBoxHasToken",this._hasTokens());this.setValue('');if(o.fireChangeEvent){this.fireSelectionChange({changedItem:o.item,selected:true});}if(o.fireFinishEvent){if(!this.isOpen()){this.fireSelectionFinish({selectedItems:this.getSelectedItems()});}}};d.prototype.removeSelection=function(o){if(o.item&&!this.isItemSelected(o.item)){return;}if(!o.item){return;}this.removeAssociation("selectedItems",o.item,o.suppressInvalidate);var s=this.getKeys(this.getSelectedItems());this.setProperty("selectedKeys",s,o.suppressInvalidate);if(!o.listItemUpdated&&this.getListItem(o.item)){this.getList().setSelectedItem(this.getListItem(o.item),false);}if(!o.tokenUpdated){var t=this._getTokenByItem(o.item);o.item.data(this.getRenderer().CSS_CLASS_COMBOBOXBASE+"Token",null);this._oTokenizer.removeToken(t);}this.$().toggleClass("sapMMultiComboBoxHasToken",this._hasTokens());if(o.fireChangeEvent){this.fireSelectionChange({changedItem:o.item,selected:false});}if(o.fireFinishEvent){if(!this.isOpen()){this.fireSelectionFinish({selectedItems:this.getSelectedItems()});}}};d.prototype._synchronizeSelectedItemAndKey=function(e){if(!e.length){q.sap.log.info("Info: _synchronizeSelectedItemAndKey() the MultiComboBox control does not contain any item on ",this);return;}var s=this.getSelectedKeys()||this._aCustomerKeys;var k=this.getKeys(this.getSelectedItems());if(s.length){for(var i=0,K=null,o=null,f=null,g=s.length;i<g;i++){K=s[i];if(k.indexOf(K)>-1){if(this._aCustomerKeys.length&&(f=this._aCustomerKeys.indexOf(K))>-1){this._aCustomerKeys.splice(f,1);}continue;}o=this.getItemByKey(""+K);if(o){if(this._aCustomerKeys.length&&(f=this._aCustomerKeys.indexOf(K))>-1){this._aCustomerKeys.splice(f,1);}this.setSelection({item:o,id:o.getId(),key:o.getKey(),fireChangeEvent:false,suppressInvalidate:true,listItemUpdated:false});}}return;}};d.prototype._setContainerSizes=function(){var m=this.$(),h=!!this._oTokenizer.getTokens().length;if(!m.length){return;}var e=this.getRenderer().DOT_CSS_CLASS_MULTICOMBOBOX,i=m.find(e+"InputContainer"),s=m.children(e+"ShadowDiv"),A=this.$().find(".sapMMultiComboBoxBorder").width();s.text(this.getValue());var f=q(this.getOpenArea()).outerWidth(true),g=s.outerWidth()+f,j=A-g,f=q(this.getOpenArea()).outerWidth(true),t=(this._oTokenizer.getScrollWidth()/parseFloat(sap.m.BaseFontSize))+"rem",k=((j>0?g:A)/parseFloat(sap.m.BaseFontSize))+"rem",n=this.isPickerDialog()?"3rem":k;this._oTokenizer.$().css("width","calc(100% - "+n+")");i.css("width","calc(100% - "+(h?t:"0px")+")");i.css("min-width",n);};d.prototype._getTokenByItem=function(i){return i?i.data(this.getRenderer().CSS_CLASS_COMBOBOXBASE+"Token"):null;};d.prototype._getSelectedItemsOf=function(e){for(var i=0,f=e.length,s=[];i<f;i++){if(this.getListItem(e[i]).isSelected()){s.push(e[i]);}}return s;};d.prototype._getLastSelectedItem=function(){var t=this._oTokenizer.getTokens();var o=t.length?t[t.length-1]:null;if(!o){return null;}return this._getItemByToken(o);};d.prototype._getOrderedSelectedItems=function(){var e=[];for(var i=0,t=this._oTokenizer.getTokens(),f=t.length;i<f;i++){e[i]=this._getItemByToken(t[i]);}return e;};d.prototype._getFocusedListItem=function(){if(!document.activeElement){return null;}var f=sap.ui.getCore().byId(document.activeElement.id);if(this.getList()&&q.sap.containsOrEquals(this.getList().getFocusDomRef(),f.getFocusDomRef())){return f;}return null;};d.prototype._getFocusedItem=function(){var o=this._getFocusedListItem();return this._getItemByListItem(o);};d.prototype._isRangeSelectionSet=function(o){var $=o.getDomRef();return $.indexOf(this.getRenderer().CSS_CLASS_MULTICOMBOBOX+"ItemRangeSelection")>-1?true:false;};d.prototype._hasTokens=function(){return this._oTokenizer.getTokens().length>0;};d.prototype._getCurrentItem=function(){if(!this._oCurrentItem){return this._getFocusedItem();}return this._oCurrentItem;};d.prototype._setCurrentItem=function(i){this._oCurrentItem=i;};d.prototype._resetCurrentItem=function(){this._oCurrentItem=null;};d.prototype._decorateListItem=function(o){o.addDelegate({onkeyup:function(e){var i=null;if(e.which==q.sap.KeyCodes.SPACE&&this.isOpen()&&this._isListInSuggestMode()){this.open();i=this._getLastSelectedItem();if(i){this.getListItem(i).focus();}return;}},onkeydown:function(e){var i=null,f=null;if(e.shiftKey&&e.which==q.sap.KeyCodes.ARROW_DOWN){f=this._getCurrentItem();i=this._getNextVisibleItemOf(f);}if(e.shiftKey&&e.which==q.sap.KeyCodes.ARROW_UP){f=this._getCurrentItem();i=this._getPreviousVisibleItemOf(f);}if(e.shiftKey&&e.which===q.sap.KeyCodes.SPACE){f=this._getCurrentItem();this._selectPreviousItemsOf(f);}if(i&&i!==f){if(this.getListItem(f).isSelected()){this.setSelection({item:i,id:i.getId(),key:i.getKey(),fireChangeEvent:true,suppressInvalidate:true});this._setCurrentItem(i);}else{this.removeSelection({item:i,id:i.getId(),key:i.getKey(),fireChangeEvent:true,suppressInvalidate:true});this._setCurrentItem(i);}return;}this._resetCurrentItem();if((e.ctrlKey||e.metaKey)&&e.which==q.sap.KeyCodes.A){e.setMarked();e.preventDefault();var v=this.getSelectableItems();var s=this._getSelectedItemsOf(v);if(s.length!==v.length){v.forEach(function(i){this.setSelection({item:i,id:i.getId(),key:i.getKey(),fireChangeEvent:true,suppressInvalidate:true,listItemUpdated:false});},this);}else{v.forEach(function(i){this.removeSelection({item:i,id:i.getId(),key:i.getKey(),fireChangeEvent:true,suppressInvalidate:true,listItemUpdated:false});},this);}}}},true,this);o.addEventDelegate({onsapbackspace:function(e){e.preventDefault();},onsapshow:function(e){e.setMarked();if(e.keyCode===q.sap.KeyCodes.F4){e.preventDefault();}if(this.isOpen()){this.close();return;}if(this.hasContent()){this.open();}},onsaphide:function(e){this.onsapshow(e);},onsapenter:function(e){e.setMarked();this.close();},onsaphome:function(e){e.setMarked();e.preventDefault();var v=this.getSelectableItems();var i=v[0];this.getListItem(i).focus();},onsapend:function(e){e.setMarked();e.preventDefault();var v=this.getSelectableItems();var i=v[v.length-1];this.getListItem(i).focus();},onsapup:function(e){e.setMarked();e.preventDefault();var v=this.getSelectableItems();var i=v[0];var f=q(document.activeElement).control()[0];if(f===this.getListItem(i)){this.focus();e.stopPropagation(true);}},onfocusin:function(e){this.addStyleClass(this.getRenderer().CSS_CLASS_MULTICOMBOBOX+"Focused");},onfocusout:function(e){this.removeStyleClass(this.getRenderer().CSS_CLASS_MULTICOMBOBOX+"Focused");},onsapfocusleave:function(e){var p=this.getAggregation("picker");var f=sap.ui.getCore().byId(e.relatedControlId);if(p&&f&&q.sap.equal(p.getFocusDomRef(),f.getFocusDomRef())){if(e.srcControl){e.srcControl.focus();}}}},this);if(sap.ui.Device.support.touch){o.addEventDelegate({ontouchstart:function(e){e.setMark("cancelAutoClose");}});}};d.prototype._createTokenizer=function(){var t=new sap.m.Tokenizer({tokens:[]}).attachTokenChange(this._handleTokenChange,this);t.setParent(this);t.addEventDelegate({onAfterRendering:this._onAfterRenderingTokenizer},this);return t;};d.prototype._handleTokenChange=function(e){var t=e.getParameter("type");var o=e.getParameter("token");var i=null;if(t!==sap.m.Tokenizer.TokenChangeType.Removed&&t!==sap.m.Tokenizer.TokenChangeType.Added){return;}if(t===sap.m.Tokenizer.TokenChangeType.Removed){i=(o&&this._getItemByToken(o));if(i&&this.isItemSelected(i)){this.removeSelection({item:i,id:i.getId(),key:i.getKey(),tokenUpdated:true,fireChangeEvent:true,fireFinishEvent:true,suppressInvalidate:true});this.focus();this.fireChangeEvent("");}}};d.prototype._onAfterRenderingTokenizer=function(){this._setContainerSizes();};d.prototype.onAfterRenderingList=function(){var o=this.getList();if(this._iFocusedIndex!=null&&o.getItems().length>this._iFocusedIndex){o.getItems()[this._iFocusedIndex].focus();this._iFocusedIndex=null;}};d.prototype.onAfterRendering=function(){C.prototype.onAfterRendering.apply(this,arguments);var p=this.getPicker();var o=q(this.getDomRef());var e=o.find(this.getRenderer().DOT_CSS_CLASS_MULTICOMBOBOX+"Border");p._oOpenBy=e[0];};d.prototype.onfocusout=function(e){this.removeStyleClass("sapMFocus");C.prototype.onfocusout.apply(this,arguments);};d.prototype.onpaste=function(e){var o;if(window.clipboardData){o=window.clipboardData.getData("Text");}else{o=e.originalEvent.clipboardData.getData('text/plain');}var s=this._oTokenizer._parseString(o);if(s&&s.length>0){this.getSelectableItems().forEach(function(i){if(q.inArray(i.getText(),s)>-1){this.setSelection({item:i,id:i.getId(),key:i.getKey(),fireChangeEvent:true,fireFinishEvent:true,suppressInvalidate:true,listItemUpdated:false});}},this);}};d.prototype.onsapbackspace=function(e){if(!this.getEnabled()||!this.getEditable()){e.preventDefault();return;}if(this.getCursorPosition()>0||this.getValue().length>0){return;}sap.m.Tokenizer.prototype.onsapbackspace.apply(this._oTokenizer,arguments);e.preventDefault();};d.prototype.onsapdelete=function(e){if(!this.getEnabled()||!this.getEditable()){return;}if(this.getValue()&&!this._isCompleteTextSelected()){return;}sap.m.Tokenizer.prototype.onsapdelete.apply(this._oTokenizer,arguments);};d.prototype.onsapnext=function(e){if(e.isMarked()){return;}var f=q(document.activeElement).control()[0];if(!f){return;}if(f===this._oTokenizer||this._oTokenizer.$().find(f.$()).length>0&&this.getEditable()){this.focus();}};d.prototype.onsapprevious=function(e){if(this.getCursorPosition()===0&&!this._isCompleteTextSelected()){if(e.srcControl===this){sap.m.Tokenizer.prototype.onsapprevious.apply(this._oTokenizer,arguments);}}};d.prototype.getOpenArea=function(){if(this.isPickerDialog()){return this.getDomRef();}else{return C.prototype.getOpenArea.apply(this,arguments);}};d.prototype._getItemsStartingText=function(t){var i=[];this.getSelectableItems().forEach(function(o){if(q.sap.startsWithIgnoreCase(o.getText(),t)){i.push(o);}},this);return i;};d.prototype._getUnselectedItemsStartingText=function(t){var i=[];this._getUnselectedItems().forEach(function(o){if(q.sap.startsWithIgnoreCase(o.getText(),t)){i.push(o);}},this);return i;};d.prototype.getCursorPosition=function(){return this._$input.cursorPos();};d.prototype._isCompleteTextSelected=function(){if(!this.getValue().length){return false;}var i=this._$input[0];if(i.selectionStart!==0||i.selectionEnd!==this.getValue().length){return false;}return true;};d.prototype._selectPreviousItemsOf=function(i){var e;do{e=true;var p=this._getPreviousVisibleItemOf(i);if(p){var o=this.getListItem(p);if(o){e=this.getListItem(p).getSelected();}}this.setSelection({item:i,id:i.getId(),key:i.getKey(),fireChangeEvent:true,suppressInvalidate:true});i=p;}while(!e);};d.prototype._getNextVisibleItemOf=function(i){var e=this.getSelectableItems();var f=e.indexOf(i)+1;if(f<=0||f>e.length-1){return null;}return e[f];};d.prototype._getPreviousVisibleItemOf=function(i){var e=this.getSelectableItems();var f=e.indexOf(i)-1;if(f<0){return null;}return e[f];};d.prototype._getNextUnselectedItemOf=function(i){var e=this._getUnselectedItems();var f=e.indexOf(i)+1;if(f<=0||f>e.length-1){return null;}return e[f];};d.prototype._getPreviousUnselectedItemOf=function(i){var e=this._getUnselectedItems();var f=e.indexOf(i)-1;if(f<0){return null;}return e[f];};d.prototype._getNextTraversalItem=function(){var i=this._getItemsStartingText(this.getValue());var s=this._getUnselectedItems();if(i.indexOf(this._oTraversalItem)>-1&&this._oTraversalItem.getText()===this.getValue()){return this._getNextUnselectedItemOf(this._oTraversalItem);}if(i.length&&i[0].getText()===this.getValue()){return this._getNextUnselectedItemOf(i[0]);}return i.length?i[0]:s[0];};d.prototype._getPreviousTraversalItem=function(){var i=this._getItemsStartingText(this.getValue());if(i.indexOf(this._oTraversalItem)>-1&&this._oTraversalItem.getText()===this.getValue()){return this._getPreviousUnselectedItemOf(this._oTraversalItem);}if(i.length&&i[i.length-1].getText()===this.getValue()){return this._getPreviousUnselectedItemOf(i[i.length-1]);}if(i.length){return i[i.length-1];}else{var s=this._getUnselectedItems();if(s.length>0){return s[s.length-1];}else{return null;}}};d.prototype.findFirstEnabledItem=function(e){e=e||this.getItems();for(var i=0;i<e.length;i++){if(e[i].getEnabled()){return e[i];}}return null;};d.prototype.getVisibleItems=function(){for(var i=0,o,e=this.getItems(),v=[];i<e.length;i++){o=this.getListItem(e[i]);if(o&&o.getVisible()){v.push(e[i]);}}return v;};d.prototype.findLastEnabledItem=function(i){i=i||this.getItems();return this.findFirstEnabledItem(i.reverse());};d.prototype.setSelectedItems=function(i){this.removeAllSelectedItems();if(!i||!i.length){return this;}if(!q.isArray(i)){q.sap.log.warning("Warning: setSelectedItems() has to be an array of sap.ui.core.Item instances or of valid sap.ui.core.Item IDs",this);return this;}i.forEach(function(o){if(!(o instanceof sap.ui.core.Item)&&(typeof o!=="string")){q.sap.log.warning("Warning: setSelectedItems() has to be an array of sap.ui.core.Item instances or of valid sap.ui.core.Item IDs",this);return;}if(typeof o==="string"){o=sap.ui.getCore().byId(o);}this.setSelection({item:o?o:null,id:o?o.getId():"",key:o?o.getKey():"",suppressInvalidate:true});},this);return this;};d.prototype.addSelectedItem=function(i){if(!i){return this;}if(typeof i==="string"){i=sap.ui.getCore().byId(i);}this.setSelection({item:i?i:null,id:i?i.getId():"",key:i?i.getKey():"",fireChangeEvent:false,suppressInvalidate:true});return this;};d.prototype.removeSelectedItem=function(i){if(!i){return null;}if(typeof i==="string"){i=sap.ui.getCore().byId(i);}if(!this.isItemSelected(i)){return null;}this.removeSelection({item:i,id:i.getId(),key:i.getKey(),fireChangeEvent:false,suppressInvalidate:true});return i;};d.prototype.removeAllSelectedItems=function(){var i=[];var e=this.getAssociation("selectedItems",[]);e.forEach(function(o){var f=this.removeSelectedItem(o);if(f){i.push(f.getId());}},this);return i;};d.prototype.removeSelectedKeys=function(k){var i=[],e;if(!k||!k.length||!q.isArray(k)){return i;}var o;k.forEach(function(K){o=this.getItemByKey(K);if(o){this.removeSelection({item:o?o:null,id:o?o.getId():"",key:o?o.getKey():"",fireChangeEvent:false,suppressInvalidate:true});i.push(o);}if(this._aCustomerKeys.length&&(e=this._aCustomerKeys.indexOf(K))>-1){this._aCustomerKeys.splice(e,1);}},this);return i;};d.prototype.setSelectedKeys=function(k){this.removeAllSelectedItems();this._aCustomerKeys=[];this.addSelectedKeys(k);return this;};d.prototype.addSelectedKeys=function(k){k=this.validateProperty("selectedKeys",k);k.forEach(function(K){var i=this.getItemByKey(K);if(i){this.addSelectedItem(i);}else if(K!=null){this._aCustomerKeys.push(K);}},this);return this;};d.prototype.getSelectedKeys=function(){var i=this.getSelectedItems()||[],k=[];i.forEach(function(o){k.push(o.getKey());},this);if(this._aCustomerKeys.length){k=k.concat(this._aCustomerKeys);}return k;};d.prototype._getUnselectedItems=function(){return q(this.getSelectableItems()).not(this.getSelectedItems()).get();};d.prototype.getSelectedItems=function(){var i=[],e=this.getAssociation("selectedItems")||[];e.forEach(function(s){var o=sap.ui.getCore().byId(s);if(o){i.push(o);}},this);return i;};d.prototype.getSelectableItems=function(){return this.getEnabledItems(this.getVisibleItems());};d.prototype.getWidth=function(){return this.getProperty("width")||"100%";};d.prototype.setEditable=function(e){C.prototype.setEditable.apply(this,arguments);this._oTokenizer.setEditable(e);return this;};d.prototype.clearFilter=function(){this.getItems().forEach(function(i){this.getListItem(i).setVisible(i.getEnabled()&&this.getSelectable(i));},this);};d.prototype._isListInSuggestMode=function(){return this.getList().getItems().some(function(o){return!o.getVisible()&&this._getItemByListItem(o).getEnabled();},this);};d.prototype._mapItemToListItem=function(i){if(!i){return null;}var s=this.getRenderer().CSS_CLASS_MULTICOMBOBOX+"Item";var e=(this.isItemSelected(i))?s+"Selected":"";var o=new sap.m.StandardListItem({type:sap.m.ListType.Active,visible:i.getEnabled()}).addStyleClass(s+" "+e);o.setTooltip(i.getTooltip());i.data(this.getRenderer().CSS_CLASS_COMBOBOXBASE+"ListItem",o);o.setTitle(i.getText());if(e){var t=new sap.m.Token({key:i.getKey()});t.setText(i.getText());t.setTooltip(i.getText());i.data(this.getRenderer().CSS_CLASS_COMBOBOXBASE+"Token",t);this._oTokenizer.addToken(t);}this.setSelectable(i,i.getEnabled());this._decorateListItem(o);return o;};d.prototype._findMappedItem=function(o,e){for(var i=0,e=e||this.getItems(),f=e.length;i<f;i++){if(this.getListItem(e[i])===o){return e[i];}}return null;};d.prototype.setSelectable=function(i,s){if(this.indexOfItem(i)<0){return;}i._bSelectable=s;var o=this.getListItem(i);if(o){o.setVisible(s);}var t=this._getTokenByItem(i);if(t){t.setVisible(s);}};d.prototype.getSelectable=function(i){return i._bSelectable;};d.prototype._fillList=function(e){if(!e){return null;}if(!this._oListItemEnterEventDelegate){this._oListItemEnterEventDelegate={onsapenter:function(g){if(g.srcControl.isSelected()){g.setMarked();}}};}for(var i=0,o,f=e.length;i<f;i++){o=this._mapItemToListItem(e[i]);o.removeEventDelegate(this._oListItemEnterEventDelegate);o.addDelegate(this._oListItemEnterEventDelegate,true,this,true);this.getList().addAggregation("items",o,true);if(this.isItemSelected(e[i])){this.getList().setSelectedItem(o,true);}}};d.prototype.init=function(){I.prototype.init.apply(this,arguments);this.createList();this.bItemsUpdated=false;this._bPreventValueRemove=false;this.setPickerType(sap.ui.Device.system.phone?"Dialog":"Popover");this._oTokenizer=this._createTokenizer();this._aCustomerKeys=[];this._aInitiallySelectedItems=[];};d.prototype.clearSelection=function(){this.removeAllSelectedItems();};d.prototype.addItem=function(i){this.addAggregation("items",i);if(i){i.attachEvent("_change",this.onItemChange,this);}if(this.getList()){this.getList().addItem(this._mapItemToListItem(i));}return this;};d.prototype.insertItem=function(i,e){this.insertAggregation("items",i,e,true);if(i){i.attachEvent("_change",this.onItemChange,this);}if(this.getList()){this.getList().insertItem(this._mapItemToListItem(i),e);}return this;};d.prototype.getEnabledItems=function(i){i=i||this.getItems();return i.filter(function(o){return o.getEnabled();});};d.prototype.getItemByKey=function(k){return this.findItem("key",k);};d.prototype.removeItem=function(i){i=this.removeAggregation("items",i);if(this.getList()){this.getList().removeItem(i&&this.getListItem(i));}this.removeSelection({item:i,id:i?i.getId():"",key:i?i.getKey():"",fireChangeEvent:false,suppressInvalidate:true,listItemUpdated:true});return i;};d.prototype.isItemSelected=function(i){return this.getSelectedItems().indexOf(i)>-1;};d.prototype.findItem=function(p,v){var m="get"+p.charAt(0).toUpperCase()+p.slice(1);for(var i=0,e=this.getItems();i<e.length;i++){if(e[i][m]()===v){return e[i];}}return null;};d.prototype._clearTokenizer=function(){this._oTokenizer.destroyAggregation("tokens",true);};d.prototype.getList=function(){return this._oList;};d.prototype.exit=function(){C.prototype.exit.apply(this,arguments);if(this.getList()){this.getList().destroy();this._oList=null;}if(this._oTokenizer){this._oTokenizer.destroy();this._oTokenizer=null;}};d.prototype.destroyItems=function(){this.destroyAggregation("items");if(this.getList()){this.getList().destroyItems();}this._oTokenizer.destroyTokens();return this;};d.prototype.removeAllItems=function(){var i=this.removeAllAggregation("items");this.removeAllSelectedItems();if(this.getList()){this.getList().removeAllItems();}return i;};d.prototype._getItemByListItem=function(o){return this._getItemBy(o,"ListItem");};d.prototype._getItemByToken=function(t){return this._getItemBy(t,"Token");};d.prototype._getItemBy=function(o,s){s=this.getRenderer().CSS_CLASS_COMBOBOXBASE+s;for(var i=0,e=this.getItems(),f=e.length;i<f;i++){if(e[i].data(s)===o){return e[i];}}return null;};d.prototype.getListItem=function(i){return i?i.data(this.getRenderer().CSS_CLASS_COMBOBOXBASE+"ListItem"):null;};d.prototype.getAccessibilityInfo=function(){var t=this.getSelectedItems().map(function(o){return o.getText();}).join(" ");var i=C.prototype.getAccessibilityInfo.apply(this,arguments);i.type=sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("ACC_CTR_TYPE_MULTICOMBO");i.description=((i.description||"")+" "+t).trim();return i;};return d;},true);
