/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./Input','./Token','./library'],function(q,I,T,l){"use strict";var M=I.extend("sap.m.MultiInput",{metadata:{library:"sap.m",properties:{enableMultiLineMode:{type:"boolean",group:"Behavior",defaultValue:false},maxTokens:{type:"int",group:"Behavior"}},aggregations:{tokens:{type:"sap.m.Token",multiple:true,singularName:"token"},tokenizer:{type:"sap.m.Tokenizer",multiple:false,visibility:"hidden"}},events:{tokenChange:{parameters:{type:{type:"string"},token:{type:"sap.m.Token"},tokens:{type:"sap.m.Token[]"},addedTokens:{type:"sap.m.Token[]"},removedTokens:{type:"sap.m.Token[]"}}}}}});var r=sap.ui.getCore().getLibraryResourceBundle("sap.m");M.prototype._sAriaMultiInputContainTokenId=new sap.ui.core.InvisibleText({text:r.getText("MULTIINPUT_ARIA_CONTAIN_TOKEN")}).toStatic().getId();M.prototype.init=function(){var t=this,c=sap.ui.getCore();this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.m");I.prototype.init.call(this);c.attachThemeChanged(this._handleThemeChanged,this);this._bIsValidating=false;this._tokenizer=new sap.m.Tokenizer();this.setAggregation("tokenizer",this._tokenizer);this._tokenizer.attachTokenChange(this._onTokenChange,this);this.setShowValueHelp(true);this.setShowSuggestion(true);this.attachSuggestionItemSelected(this._onSuggestionItemSelected,this);this.attachLiveChange(this._onLiveChange,this);sap.ui.Device.orientation.attachHandler(this._onOrientationChange,this);this._sResizeHandlerId=sap.ui.core.ResizeHandler.register(this,function(){t._setContainerSizes();});if(!(this._bUseDialog&&this._oSuggestionPopup)){this.attachSuggestionItemSelected(function(){setTimeout(function(){t._tokenizer.scrollToEnd();},0);});}};M.prototype._onTokenChange=function(a){var t=this.getTokens(),L=t.length;this.fireTokenChange(a.getParameters());this.invalidate();if(this._bUseDialog&&this._tokenizer.getParent()instanceof sap.m.Dialog){this._showAllTokens();return;}var f=q.sap.containsOrEquals(this.getDomRef(),document.activeElement);if(a.getParameter("type")==="tokensChanged"&&a.getParameter("removedTokens").length>0&&f){this.focus();}if(a.getParameter("type")==="added"&&L>1&&this.getEditable()&&this._isMultiLineMode&&!this.$("border").hasClass("sapMMultiInputMultiModeBorder")){this._showIndicator();}if(a.getParameter("type")==="removed"&&this._isMultiLineMode){if(L<2){this._removeIndicator();}}};M.prototype._onSuggestionItemSelected=function(e){var i=null,t=null,a=this,o=this._tokenizer.getTokens().length;if(this.getMaxTokens()&&o>=this.getMaxTokens()){return;}if(this._hasTabularSuggestions()){i=e.getParameter("selectedRow");}else{i=e.getParameter("selectedItem");if(i){t=new T({text:i.getText(),key:i.getKey()});}}if(i){var b=this.getValue();this._tokenizer.addValidateToken({text:b,token:t,suggestionObject:i,validationCallback:function(v){if(v){a.setValue("");}}});}if(this._bUseDialog&&this._tokenizer.getParent()instanceof sap.m.Dialog){var n=this._tokenizer.getTokens().length;if(o<n){this.setValue("");}if(this._tokenizer.getVisible()===false){this._tokenizer.setVisible(true);}if(this._oList instanceof sap.m.Table){this._oList.addStyleClass("sapMInputSuggestionTableHidden");}else{this._oList.destroyItems();}var s=this._oSuggestionPopup.getScrollDelegate();if(s){s.scrollTo(0,0,0);}this._oPopupInput.focus();}};M.prototype._onLiveChange=function(e){this._tokenizer.removeSelectedTokens();if(this._bUseDialog&&this._isMultiLineMode){var v=e.getParameter("newValue");if(this._oSuggestionPopup&&this._oSuggestionPopup.getContent().length>1&&v.length>0){this._tokenizer.setVisible(false);}else{this._tokenizer.setVisible(true);}}};M.prototype._showIndicator=function(){var t=this.getTokens(),i=t.length;this._tokenizer.setVisible(true);if(i>1){if(this.$().find(".sapMMultiInputIndicator").length!==0){this._removeIndicator();}var m=sap.ui.getCore().getLibraryResourceBundle("sap.m");var s="<span class=\"sapMMultiInputIndicator\">"+m.getText("MULTIINPUT_SHOW_MORE_TOKENS",i-1)+"</span>";this.$().find(".sapMTokenizer").after(s);this._setValueInvisible();}this._bShowIndicator=true;};M.prototype._setValueInvisible=function(){this.$("inner").css("opacity","0");};M.prototype._setValueVisible=function(){this.$("inner").css("opacity","1");};M.prototype._showAllTokens=function(){this._tokenizer.setVisible(true);this._removeIndicator();};M.prototype._removeIndicator=function(){this.$().find(".sapMMultiInputIndicator").remove();this._bShowIndicator=false;};M.prototype.setEnableMultiLineMode=function(m){this.setProperty("enableMultiLineMode",m,true);if(m){this.$().addClass("sapMMultiInputMultiLine");}else{this.$().removeClass("sapMMultiInputMultiLine");}this.closeMultiLine();var t=this;if(this._bUseDialog){m=true;}if(m){if(this.getEditable()){this._showIndicator();}this._isMultiLineMode=true;if(this.getDomRef()){setTimeout(function(){t._setContainerSizes();},0);}}else{this._isMultiLineMode=false;this._showAllTokens();this.setValue("");if(this.getDomRef()){setTimeout(function(){t._setContainerSizes();t._scrollAndFocus();},0);}}return this;};M.prototype._openMultiLineOnPhone=function(){var t=this;this._oSuggestionPopup.open();this._oSuggestionPopup.insertContent(this._tokenizer,0);this._tokenizer.setReverseTokens(true);var v=this._oPopupInput.getValue();if(this._oSuggestionPopup&&this._oSuggestionPopup.getContent().length>1&&v.length>0){this._tokenizer.setVisible(false);}else{this._tokenizer.setVisible(true);}this._tokenizer._oScroller.setHorizontal(false);this._tokenizer.addStyleClass("sapMTokenizerMultiLine");if(this._oSuggestionTable.getItems().length===0){this._oPopupInput.onsapenter=function(e){t._validateCurrentText();t._setValueInvisible();};}};M.prototype._openMultiLineOnDesktop=function(){var t=this;this._setValueVisible();this.$("border").addClass("sapMMultiInputMultiModeBorder");if(this._$input){this._$input.parent().addClass("sapMMultiInputMultiModeInputContainer");}this.$().find(".sapMInputValHelp").attr("tabindex","-1");var p=this.getParent();this._originalOverflow=null;if(p&&p.$&&p.$().css("overflow")==="hidden"){this._originalOverflow=p.$().css("overflow");p.$().css("overflow","visible");}var P;if(this.$().closest('.sapUiVlt').length!==0){P=this.$().closest('.sapUiVlt');}else if(this.$().parent('[class*="sapUiRespGridSpan"]').length!==0){P=this.$().parent('[class*="sapUiRespGridSpan"]');}else if(this.$().parents(".sapUiRFLContainer").length!==0){P=this.$().parents(".sapUiRFLContainer");}if(P&&P.length>0&&P.css("overflow")==="hidden"){P.css("overflow","visible");}setTimeout(function(){t._showAllTokens();t._setContainerSizes();t._tokenizer.scrollToStart();},0);};M.prototype.openMultiLine=function(){var t=this.getTokens();if(!this.getEditable()){return;}if(this._bUseDialog){this._openMultiLineOnPhone();return;}if(this.getEnableMultiLineMode()&&t.length>0){this._openMultiLineOnDesktop();}};M.prototype.closeMultiLine=function(){if(!this.getEditable()){return;}if(this._bUseDialog){this._oSuggestionPopup.close();this._tokenizer.setVisible(true);}else{this.$("border").removeClass("sapMMultiInputMultiModeBorder");if(this._$input){this._$input.parent().removeClass("sapMMultiInputMultiModeInputContainer");}this.$().find(".sapMInputValHelp").removeAttr("tabindex");if(this._originalOverflow){var p=this.getParent();p.$().css("overflow",this._originalOverflow);}}};M.prototype._onOrientationChange=function(){this._setContainerSizes();};M.prototype.getScrollDelegate=function(){return this._tokenizer._oScroller;};M.prototype.exit=function(){if(this._sResizeHandlerId){sap.ui.core.ResizeHandler.deregister(this._sResizeHandlerId);delete this._sResizeHandlerId;}var c=sap.ui.getCore();c.detachThemeChanged(this._handleThemeChanged,this);I.prototype.exit.apply(this,arguments);};M.prototype._setContainerSizes=function(){var t=this.getDomRef(),$=this.$(),a=this.$().find(".sapMMultiInputBorder"),b,s,c,d=this.getEditable()?4*16:0,e,f,g,h=this.getTokens(),i;if(!t){return;}if(this.getTokens().length>0){a.addClass("sapMMultiInputNarrowBorder");}else{a.removeClass("sapMMultiInputNarrowBorder");}this.$("inner").css("width","");this._tokenizer.$().css("width","");b=a.width();s=$.children(".sapMMultiInputShadowDiv")[0];c=a.find(".sapMMultiInputIndicator");q(s).text(this.getValue());f=c.width();e=this._tokenizer.getScrollWidth();g=$.find(".sapMInputValHelp").outerWidth(true);if(f&&this._isMultiLineMode&&this._bShowIndicator){d=f;}if(!this._bUseDialog&&this._isMultiLineMode&&!this._bShowIndicator&&a.length>0){e=b-g;if(h.length===0){this._tokenizer.$().css("width",0);}if(this._tokenizer._oScroller){this._tokenizer._oScroller.refresh();}for(i=0;i<h.length;i++){var j=h[i].getDomRef();if(j&&j.offsetWidth>e){j.style.width=e+"px";j.classList.add("sapMTokenTruncate");}}this.$("inner").css("width",e+"px");this._tokenizer.setPixelWidth(e);}else{e=Math.min(e,b-g-d);q($.find(".sapMInputBaseInner")[0]).css("width",(b-e-g)+"px");if(!(this._bUseDialog&&this._oSuggestionPopup&&this._oSuggestionPopup.isOpen())){this._tokenizer.setPixelWidth(e);}}if(this.getPlaceholder()){this._sPlaceholder=this.getPlaceholder();}if(this.getTokens().length>0){this.setPlaceholder("");}else{this.setPlaceholder(this._sPlaceholder);}if(this._bUseDialog&&this._isMultiLineMode&&this._oSuggestionPopup&&this._oSuggestionPopup.isOpen()&&this._tokenizer.getTokens().length>0){var p=this._tokenizer.getTokens().length,L=this._tokenizer.getTokens()[p-1],k=L.$(),m=L.$().outerWidth(),P=this._oSuggestionPopup.$().find(".sapMDialogScrollCont").width(),B=parseFloat(sap.m.BaseFontSize)||16,n=P-2*B;if(n<m){k.outerWidth(n,true);k.css("overflow","hidden");k.css("text-overflow","ellipsis");k.css("white-space","nowrap");}}};M.prototype.onAfterRendering=function(){var c=sap.ui.getCore();I.prototype.onAfterRendering.apply(this,arguments);if(c.isThemeApplied()){this._setContainerSizes();}};M.prototype._handleThemeChanged=function(){this._setContainerSizes();};M.prototype.addValidator=function(v){this._tokenizer.addValidator(v);};M.prototype.removeValidator=function(v){this._tokenizer.removeValidator(v);};M.prototype.removeAllValidators=function(){this._tokenizer.removeAllValidators();};M.prototype.onsapnext=function(e){if(e.isMarked()){return;}var f=q(document.activeElement).control()[0];if(!f){return;}if(this._tokenizer===f||this._tokenizer.$().find(f.$()).length>0){this._scrollAndFocus();}};M.prototype.onsapbackspace=function(e){if(this.getCursorPosition()>0||!this.getEditable()||this.getValue().length>0){return;}sap.m.Tokenizer.prototype.onsapbackspace.apply(this._tokenizer,arguments);e.preventDefault();e.stopPropagation();};M.prototype.onsapdelete=function(e){if(!this.getEditable()){return;}if(this.getValue()&&!this._completeTextIsSelected()){return;}sap.m.Tokenizer.prototype.onsapdelete.apply(this._tokenizer,arguments);};M.prototype.onkeydown=function(e){if(e.ctrlKey||e.metaKey){if(e.which===q.sap.KeyCodes.A){var v=this.getValue();if(document.activeElement===this._$input[0]){if(this._$input.getSelectedText()!==v){this.selectText(0,v.length);}else if(this._tokenizer){if(!v&&this._tokenizer.getTokens().length){this._tokenizer.focus();}this._tokenizer.selectAllTokens(true);}}else if(document.activeElement===this._tokenizer.$()[0]){if(this._tokenizer._iSelectedToken===this._tokenizer.getTokens().length){this.selectText(0,v.length);}}e.preventDefault();}}};M.prototype.onpaste=function(e){var o,i;if(this.getValueHelpOnly()){return;}if(window.clipboardData){o=window.clipboardData.getData("Text");}else{o=e.originalEvent.clipboardData.getData('text/plain');}var s=this._tokenizer._parseString(o);setTimeout(function(){if(s){if(this.fireEvent("_validateOnPaste",{texts:s},true)){for(i=0;i<s.length;i++){if(s[i]){this.updateDomValue(s[i]);this._validateCurrentText();}}}this.cancelPendingSuggest();}}.bind(this),0);};M.prototype.onsapprevious=function(e){if(this._getIsSuggestionPopupOpen()){return;}if(this.getCursorPosition()===0){if(e.srcControl===this){sap.m.Tokenizer.prototype.onsapprevious.apply(this._tokenizer,arguments);e.preventDefault();}}};M.prototype._scrollAndFocus=function(){this._tokenizer.scrollToEnd();this.$().find("input").focus();};M.prototype.onsaphome=function(e){sap.m.Tokenizer.prototype.onsaphome.apply(this._tokenizer,arguments);};M.prototype.onsapend=function(e){sap.m.Tokenizer.prototype.onsapend.apply(this._tokenizer,arguments);e.preventDefault();};M.prototype.onsapenter=function(e){if(!this._oSuggestionPopup||!this._oSuggestionPopup.isOpen()){this._validateCurrentText();}if(I.prototype.onsapenter){I.prototype.onsapenter.apply(this,arguments);}this.focus();};M.prototype._checkFocus=function(){return this.getDomRef()&&q.sap.containsOrEquals(this.getDomRef(),document.activeElement);};M.prototype.onsapfocusleave=function(e){var p=this._oSuggestionPopup,n=false,N=false,b=this._checkFocus(),R;if(p instanceof sap.m.Popover){if(e.relatedControlId){R=sap.ui.getCore().byId(e.relatedControlId).getFocusDomRef();n=q.sap.containsOrEquals(p.getFocusDomRef(),R);N=q.sap.containsOrEquals(this._tokenizer.getFocusDomRef(),R);}}if(!N&&!n&&!this._isMultiLineMode){this._setContainerSizes();this._tokenizer.scrollToEnd();}I.prototype.onsapfocusleave.apply(this,arguments);if(this._bIsValidating){return;}if(!this._bUseDialog&&this._isMultiLineMode&&!this._bShowIndicator&&this.getEditable()){if(b||n){return;}this.closeMultiLine();this._showIndicator();q.sap.delayedCall(0,this,function(){this._setContainerSizes();});}sap.m.Tokenizer.prototype.onsapfocusleave.apply(this._tokenizer,arguments);if(!this._bUseDialog&&this._isMultiLineMode&&this._bShowIndicator){var $=this.$().find(".sapMMultiInputBorder");$.scrollTop(0);}};M.prototype._onDialogClose=function(){this._tokenizer._oScroller.setHorizontal(true);this._tokenizer.removeStyleClass("sapMTokenizerMultiLine");this.setAggregation("tokenizer",this._tokenizer);this._tokenizer.setReverseTokens(false);this._tokenizer.invalidate();};M.prototype.ontap=function(e){if(document.activeElement===this._$input[0]){this._tokenizer.selectAllTokens(false);}I.prototype.ontap.apply(this,arguments);};M.prototype.onfocusin=function(e){if(this.getEditable()&&(this.getEnableMultiLineMode()||this._bUseDialog)){this.openMultiLine();}if(e.target===this.getFocusDomRef()){I.prototype.onfocusin.apply(this,arguments);}};M.prototype.onsapescape=function(e){this._tokenizer.selectAllTokens(false);this.selectText(0,0);I.prototype.onsapescape.apply(this,arguments);};M.prototype._validateCurrentText=function(e){var o=this._tokenizer.getTokens().length;var t=this.getValue();if(!t||!this.getEditable()){return;}t=t.trim();if(!t){return;}var i=null;if(e||this._getIsSuggestionPopupOpen()){if(this._hasTabularSuggestions()){i=this._oSuggestionTable._oSelectedItem;}else{i=this._getSuggestionItem(t,e);}}var a=null;if(i&&i.getText&&i.getKey){a=new T({text:i.getText(),key:i.getKey()});}var b=this;if(!this.getMaxTokens()||this.getTokens().length<this.getMaxTokens()){this._bIsValidating=true;this._tokenizer.addValidateToken({text:t,token:a,suggestionObject:i,validationCallback:function(v){b._bIsValidating=false;if(v){b.setValue("");if(b._bUseDialog&&b._isMultiLineMode&&b._oSuggestionTable.getItems().length===0){var n=b._tokenizer.getTokens().length;if(o<n){b._oPopupInput.setValue("");}if(b._tokenizer.getVisible()===false){b._tokenizer.setVisible(true);}}}}});}};M.prototype.getCursorPosition=function(){return this._$input.cursorPos();};M.prototype._completeTextIsSelected=function(){var i=this._$input[0];if(i.selectionStart!==0){return false;}if(i.selectionEnd!==this.getValue().length){return false;}return true;};M.prototype._selectAllInputText=function(){var i=this._$input[0];i.selectionStart=0;i.selectionEnd=this.getValue().length;return this;};M.prototype._getIsSuggestionPopupOpen=function(){return this._oSuggestionPopup&&this._oSuggestionPopup.isOpen();};M.prototype.setEditable=function(e){e=this.validateProperty("editable",e);if(e===this.getEditable()){return this;}if(e&&(this.getEnableMultiLineMode()||this._bUseDialog)){this._bShowIndicator=true;}else{this._bShowIndicator=false;}if(I.prototype.setEditable){I.prototype.setEditable.apply(this,arguments);}this._tokenizer.setEditable(e);if(e){this.removeStyleClass("sapMMultiInputNotEditable");}else{this.addStyleClass("sapMMultiInputNotEditable");}return this;};M.prototype._findItem=function(t,a,e,g){if(!t){return;}if(!(a&&a.length)){return;}t=t.toLowerCase();var b=a.length;for(var i=0;i<b;i++){var c=a[i];var d=g(c);if(!d){continue;}d=d.toLowerCase();if(d===t){return c;}if(!e&&d.indexOf(t)===0){return c;}}};M.prototype._getSuggestionItem=function(t,e){var a=null;var b=null;if(this._hasTabularSuggestions()){a=this.getSuggestionRows();b=this._findItem(t,a,e,function(R){var c=R.getCells();var f=null;if(c){var i;for(i=0;i<c.length;i++){if(c[i].getText){f=c[i].getText();break;}}}return f;});}else{a=this.getSuggestionItems();b=this._findItem(t,a,e,function(b){return b.getText();});}return b;};M.prototype.addToken=function(t){t.setEditable(this.getEditable()&&t.getEditable());this._tokenizer.addToken(t);return this;};M.prototype.removeToken=function(t){return this._tokenizer.removeToken(t);};M.prototype.removeAllTokens=function(){return this._tokenizer.removeAllTokens();};M.prototype.getTokens=function(){return this._tokenizer.getTokens();};M.prototype.insertToken=function(t,i){this._tokenizer.insertToken(t,i);return this;};M.prototype.indexOfToken=function(t){return this._tokenizer.indexOfToken(t);};M.prototype.destroyTokens=function(){this._tokenizer.destroyTokens();return this;};M.prototype.getAggregation=function(a,d){var t;if(a==="tokens"){t=this.getTokens();if(t.length===0){t=d||null;}return t;}else{return I.prototype.getAggregation.apply(this,arguments);}};M.prototype.clone=function(){var c,t;this._tokenizer.detachTokenChange(this._onTokenChange,this);this.detachSuggestionItemSelected(this._onSuggestionItemSelected,this);this.detachLiveChange(this._onLiveChange,this);c=I.prototype.clone.apply(this,arguments);t=this._tokenizer.clone();c._tokenizer=t;c.setAggregation("tokenizer",t,true);this._tokenizer.attachTokenChange(this._onTokenChange,this);this.attachSuggestionItemSelected(this._onSuggestionItemSelected,this);this.attachLiveChange(this._onLiveChange,this);return c;};M.prototype.getPopupAnchorDomRef=function(){return this.getDomRef("border");};M.prototype.setTokens=function(t){var v,V=[],i;if(Array.isArray(t)){for(i=0;i<t.length;i++){v=this.validateAggregation("tokens",t[i],true);v.setEditable(this.getEditable()&&v.getEditable());V.push(v);}this._tokenizer.setTokens(V);}else{throw new Error("\""+t+"\" is of type "+typeof t+", expected array for aggregation tokens of "+this);}return this;};M.TokenChangeType={Added:"added",Removed:"removed",RemovedAll:"removedAll",TokensChanged:"tokensChanged"};M.WaitForAsyncValidation="sap.m.Tokenizer.WaitForAsyncValidation";M.prototype.getDomRefForValueStateMessage=M.prototype.getPopupAnchorDomRef;M.prototype.getAccessibilityInfo=function(){var t=this.getTokens().map(function(o){return o.getText();}).join(" ");var i=I.prototype.getAccessibilityInfo.apply(this,arguments);i.type=sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("ACC_CTR_TYPE_MULTIINPUT");i.description=((i.description||"")+" "+t).trim();return i;};return M;},true);
