/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["jquery.sap.global","./Button","./Input","sap/ui/core/Control","sap/ui/core/IconPool"],function(q,B,I,C,a){"use strict";var S=C.extend("sap.m.StepInput",{metadata:{library:"sap.m",properties:{min:{type:"Number",group:"Data"},max:{type:"Number",group:"Data"},step:{type:"Number",group:"Data",defaultValue:1},largerStep:{type:"Number",group:"Data",defaultValue:2},value:{type:"Number",group:"Data",defaultValue:0},width:{type:"sap.ui.core.CSSSize",group:"Dimension"},valueState:{type:"sap.ui.core.ValueState",group:"Data",defaultValue:sap.ui.core.ValueState.None},editable:{type:"boolean",group:"Behavior",defaultValue:true},enabled:{type:"boolean",group:"Behavior",defaultValue:true}},aggregations:{_incrementButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_decrementButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_input:{type:"sap.m.Input",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"}}}});S.prototype.init=function(){this._attachPressEvents();this._attachLiveChange();};S.prototype.onBeforeRendering=function(){var m=this._getIntOrFloat(this.getMin()),M=this._getIntOrFloat(this.getMax()),v=this._getIntOrFloat(this.getValue());this._getInput().setValue(v);if(i(m)&&(m>v)){this.setValue(m);}if(i(M)&&(M<v)){this.setValue(M);}this._disableButtons(v,M,m);};S.prototype._getIntOrFloat=function(n){return this.isInteger(n)?parseInt(n,10):parseFloat(n,10);};S.prototype.onAfterRendering=function(){this._writeAccessibilityState();this._getIncrementButton().$().attr('tabindex','-1');this._getDecrementButton().$().attr('tabindex','-1');};S.prototype.setProperty=function(p,v,s){this._writeAccessibilityState(p,v);if(["enabled","editable"].indexOf(p)>-1){this._getInput().setProperty(p,v,s);}return C.prototype.setProperty.apply(this,arguments);};S.prototype.setMin=function(n){return this.setProperty("min",n,true);};S.prototype.setMax=function(n){return this.setProperty("max",n,true);};S.prototype._getIncrementButton=function(){if(!this.getAggregation("_incrementButton")){var b=new B({icon:a.getIconURI("add"),id:this.getId()+"-incrementButton",type:sap.m.ButtonType.Transparent});b._bExcludeFromTabChain=true;this.setAggregation("_incrementButton",b);}return this.getAggregation("_incrementButton");};S.prototype._getDecrementButton=function(){if(!this.getAggregation("_decrementButton")){var b=new B({icon:a.getIconURI("less"),id:this.getId()+"-decrementButton",type:sap.m.ButtonType.Transparent});b._bExcludeFromTabChain=true;this.setAggregation("_decrementButton",b);}return this.getAggregation("_decrementButton");};S.prototype._getInput=function(){if(!this.getAggregation("_input")){this.setAggregation("_input",new I({width:this.getWidth(),id:this.getId()+"-input",textAlign:sap.ui.core.TextAlign.End,type:sap.m.InputType.Number,editable:this.getEditable(),enabled:this.getEnabled()}));}return this.getAggregation("_input");};S.prototype._attachPressEvents=function(){this._getIncrementButton().attachPress(this._handleButtonPress.bind(this,true));this._getDecrementButton().attachPress(this._handleButtonPress.bind(this,false));};S.prototype._handleButtonPress=function(b){var v=this._calculateValue(1,b),m=this._getIntOrFloat(this.getMin()),M=this._getIntOrFloat(this.getMax()),c=this._getInput().getValueState();if(c==sap.ui.core.ValueState.Error&&(v==m||v==M)){this.setValueState(sap.ui.core.ValueState.None);}this._disableButtons(this._getIntOrFloat(v));this.setValue(v);this.$().focus();return this;};S.prototype._disableButtons=function(v,m,b){if(b<v&&v<m){this._getDecrementButton().setEnabled(true);this._getIncrementButton().setEnabled(true);return this;}if(v==b){this._getDecrementButton().setEnabled(false);}if(v==m){this._getIncrementButton().setEnabled(false);}return this;};S.prototype.onfocusout=function(){this._handleIncorrectValues();if(this.getValue()==""){if(i(this.getMin())&&this.getMin()>0){this.setValue(this.getMin());}else if(i(this.getMax())&&this.getMax()<0){this.setValue(this.getMax());}else{this.setValue(0);}}};S.prototype._handleIncorrectValues=function(){var m=this._getIntOrFloat(this.getMin()),b=this._getIntOrFloat(this.getMax()),v=this._getIntOrFloat(this._getInput().getValue()),c=true,d=true;if(v>b||v<m){this.setValueState(sap.ui.core.ValueState.Error);}else{this.setValueState(sap.ui.core.ValueState.None);}if(v>=b){c=false;}if(v<=m){d=false;}this._getIncrementButton().setEnabled(c);this._getDecrementButton().setEnabled(d);};S.prototype.setValue=function(v){this._getInput().setValue(v);return this.setProperty("value",v,true);};S.prototype.onsappageup=function(e){this._applyValue(this._calculateValue(this.getLargerStep(),true));this._handleIncorrectValues();};S.prototype.onsappagedown=function(e){this._applyValue(this._calculateValue(this.getLargerStep(),false));this._handleIncorrectValues();};S.prototype.onsappageupmodifiers=function(e){if(i(this.getMax())&&!(e.ctrlKey||e.metaKey||e.altKey)&&e.shiftKey){this._applyValue(this.getMax());}};function i(n){return!isNaN(n)&&n!==null;}S.prototype.onsappagedownmodifiers=function(e){if(i(this.getMin())&&!(e.ctrlKey||e.metaKey||e.altKey)&&e.shiftKey){this._applyValue(this.getMin());}};S.prototype.onsapup=function(e){e.preventDefault();this._applyValue(this._calculateValue(1,true));this._handleIncorrectValues();};S.prototype.onsapdown=function(e){e.preventDefault();this._applyValue(this._calculateValue(1,false));this._handleIncorrectValues();};S.prototype.onkeydown=function(e){if(e.which===q.sap.KeyCodes.ARROW_UP&&!e.altKey&&e.shiftKey&&(e.ctrlKey||e.metaKey)){this._applyValue(this.getMax());}if(e.which===q.sap.KeyCodes.ARROW_DOWN&&!e.altKey&&e.shiftKey&&(e.ctrlKey||e.metaKey)){this._applyValue(this.getMin());}if(e.which===q.sap.KeyCodes.ARROW_UP&&!(e.ctrlKey||e.metaKey||e.altKey)&&e.shiftKey){e.preventDefault();this._applyValue(this._calculateValue(this.getLargerStep(),true));}if(e.which===q.sap.KeyCodes.ARROW_DOWN&&!(e.ctrlKey||e.metaKey||e.altKey)&&e.shiftKey){e.preventDefault();this._applyValue(this._calculateValue(this.getLargerStep(),false));}this._handleIncorrectValues();};S.prototype.onsapescape=function(e){this.getAggregation("_input").onsapescape(e);};S.prototype._attachLiveChange=function(){this._getInput().attachLiveChange(this._liveChange,this);};S.prototype._liveChange=function(){this._handleIncorrectValues();this.setProperty("value",this._getInput().getValue(),true);};S.prototype._applyValue=function(n){if(!this.getEditable()||!this.getEnabled()){return;}this.setProperty("value",n,true);this.getAggregation("_input")._$input.val(n);};S.prototype._calculateValue=function(s,b){var v,V,c,d=this.isInteger(this.getValue()),e=this.isInteger(this.getStep()),f=this._getIntOrFloat(this._getInput().getValue()),g=this._getIntOrFloat(this.getStep()),m=this._getIntOrFloat(this.getStep()*s),h=b?1:-1;v=f+g>=this.getMax();V=f-g<=this.getMin();c=f+h*m;if(b&&i(this.getMax())&&v){return this.getMax();}if(!b&&i(this.getMin())&&V){return this.getMin();}if(!e||!d){return c.toFixed(1);}else{return c;}return this.getValue();};S.prototype.setValueState=function(v){var e=false,w=false;if(v==sap.ui.core.ValueState.Error){this._getInput().setValueState(sap.ui.core.ValueState.Error);e=true;}if(v==sap.ui.core.ValueState.Warning){this._getInput().setValueState(sap.ui.core.ValueState.Warning);w=true;}if(v==sap.ui.core.ValueState.None){this._getInput().setValueState(sap.ui.core.ValueState.None);e=false;w=false;}q.sap.delayedCall(0,this,function(){this.$().toggleClass("sapMStepInputError",e).toggleClass("sapMStepInputWarning",w);});return this;};S.prototype.isInteger=function(v){return v%1===0;};S.prototype.setEditable=function(e){var b=Array.prototype.slice.call(arguments);e=this.validateProperty('editable',e);if(!e){this._getInput().setTextAlign(sap.ui.core.TextAlign.Begin);this.removeAggregation("_decrementButton",false);this.removeAggregation("_incrementButton");}return S.prototype.setProperty.apply(this,["editable"].concat(b));};S.prototype._writeAccessibilityState=function(p,v){var m,M,l,d,$=this.getDomRef("input-inner"),A=[],n={"min":"aria-valuemin","max":"aria-valuemax","value":"aria-valuenow"};if(!$){return;}if(p&&n[p]){A=[{aria:n[p],value:v}];}else if(!p){m=this.getMin();M=this.getMax();l=this.getAriaLabelledBy().join(" ");d=this.getAriaDescribedBy().join(" ");A=[{aria:"role",value:"spinbutton"},{aria:"aria-valuenow",value:this.getValue()}];if(typeof m=="number"){A.push({aria:"aria-valuemin",value:m});}if(typeof M=="number"){A.push({aria:"aria-valuemax",value:M});}if(l){A.push({aria:"aria-labelledby",value:l});}if(d){A.push({aria:"aria-describedby",value:d});}}A.forEach(function(o){$.setAttribute(o.aria,o.value);});};return S;},true);
