/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./LRUPersistentCache','./CacheManagerNOP','sap/ui/Device'],function(q,L,C,D){"use strict";var a={_instance:null,_getInstance:function(){var p,M=c("_getInstance"),t=this;p=new Promise(function(r,d){var I;q.sap.log.debug("Cache Manager: Initialization...");if(!a._instance){I=t._findImplementation();q.sap.measure.start(b,"CM",S);I.init().then(e,d);q.sap.measure.end(b,"CM");}else{e(a._instance);}function e(f){a._instance=f;M.endAsync();q.sap.log.debug("Cache Manager initialized with implementation ["+a._instance.name+"], resolving _getInstance promise");r(f);}});M.endSync();return p;},_findImplementation:function(){if(i()&&this._isSupportedEnvironment()){return L;}else{q.sap.log.warning("UI5 Cache Manager is switched off");return C;}},set:function(k,v){var p,M=c("set",k);q.sap.log.debug("Cache Manager: Setting value of type["+typeof v+"] with key ["+k+"]");p=this._callInstanceMethod("set",arguments).then(function callInstanceHandler(){q.sap.log.debug("Cache Manager: Setting key ["+k+"] completed successfully");M.endAsync();},function(e){q.sap.log.error("Cache Manager: Setting key ["+k+"] failed. Error:"+e);M.endAsync();throw e;});M.endSync();return p;},get:function(k){var p,M=c("get",k);q.sap.log.debug("Cache Manager: Getting key ["+k+"]");p=this._callInstanceMethod("get",arguments).then(function callInstanceHandler(v){q.sap.log.debug("Cache Manager: Getting key ["+k+"] done");M.endAsync();return v;},function(e){q.sap.log.debug("Cache Manager: Getting key ["+k+"] failed. Error: "+e);M.endAsync();throw e;});M.endSync();return p;},has:function(k){var p,M=c("has",k);q.sap.log.debug("Cache Manager: has key ["+k+"] called");p=this._callInstanceMethod("has",arguments).then(function callInstanceHandler(r){M.endAsync();q.sap.log.debug("Cache Manager: has key ["+k+"] returned "+r);return r;});M.endSync();return p;},del:function(k){var p,M=c("del",k);q.sap.log.debug("Cache Manager: del called.");p=this._callInstanceMethod("del",arguments).then(function callInstanceHandler(){q.sap.log.debug("Cache Manager: del completed successfully.");M.endAsync();},function(e){q.sap.log.debug("Cache Manager: del failed. Error: "+e);M.endAsync();throw e;});M.endSync();return p;},reset:function(){var p,M=c("reset");q.sap.log.debug("Cache Manager: Reset called.");p=this._callInstanceMethod("reset",arguments).then(function callInstanceHandler(){q.sap.log.debug("Cache Manager: Reset completed successfully.");M.endAsync();},function(e){q.sap.log.debug("Cache Manager: Reset failed. Error: "+e);M.endAsync();throw e;});M.endSync();return p;},_switchOff:function(){var t=this;return Promise.resolve().then(function(){s(t);sap.ui.getCore().getConfiguration().setUI5CacheOn(false);});},_switchOn:function(){var t=this;return Promise.resolve().then(function(){var o=sap.ui.getCore().getConfiguration();if(!o.isUI5CacheOn()){s(t);sap.ui.getCore().getConfiguration().setUI5CacheOn(true);}return Promise.resolve();});},_callInstanceMethod:function(M,A){var p,d="[sync ] _callInstanceMethod";q.sap.measure.start(d,"CM",S);if(this._instance){q.sap.log.debug("Cache Manager: calling instance...");return this._instance[M].apply(this._instance,A);}q.sap.log.debug("Cache Manager: getting instance...");p=this._getInstance().then(function instanceResolving(e){return e[M].apply(e,A);});q.sap.measure.end(d);return p;},_isSupportedEnvironment:function(){var d=[];if(this._bSupportedEnvironment==undefined){d.push({system:D.system.SYSTEMTYPE.DESKTOP,browserName:D.browser.BROWSER.CHROME,browserVersion:49});d.push({system:D.system.SYSTEMTYPE.DESKTOP,browserName:D.browser.BROWSER.INTERNET_EXPLORER,browserVersion:11});this._bSupportedEnvironment=d.some(function(o){var e=D.system[o.system],f=o.browserName===D.browser.name,g=D.browser.version>=o.browserVersion;return e&&f&&g;});}return this._bSupportedEnvironment;}};var S="CacheManager",b="[sync ] _initImplementation",m=0;function i(){return sap.ui.getCore().getConfiguration().isUI5CacheOn();}function s(d){if(d._instance){d._instance._destroy();d._instance=null;}}function c(o,k){m++;var M="[async]  "+o+"["+k+"]- #"+(m),d="[sync ]  "+o+"["+k+"]- #"+(m);q.sap.measure.start(M,"CM",[S,o]);q.sap.measure.start(d,"CM",[S,o]);return{sMeasureAsync:M,sMeasureSync:d,endAsync:function(){q.sap.measure.end(this.sMeasureAsync);},endSync:function(){q.sap.measure.end(this.sMeasureSync);}};}return a;},false);
