/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/base/ManagedObject','sap/ui/core/Control','sap/ui/core/mvc/Controller','sap/ui/core/library'],function(q,M,C,a,b){"use strict";var V=b.mvc.ViewType;var c=C.extend("sap.ui.core.mvc.View",{metadata:{library:"sap.ui.core",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'100%'},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},viewName:{type:"string",group:"Misc",defaultValue:null},displayBlock:{type:"boolean",group:"Appearance",defaultValue:false}},aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"}},events:{afterInit:{},beforeExit:{},afterRendering:{},beforeRendering:{}},specialSettings:{controller:'sap.ui.core.mvc.Controller',controllerName:'string',preprocessors:'Object',resourceBundleName:'string',resourceBundleUrl:'sap.ui.core.URI',resourceBundleLocale:'string',resourceBundleAlias:'string',type:'string',viewContent:'any',viewData:'any',async:{type:"boolean",defaultValue:false}}}});c._mPreprocessors={};function d(p){p._settings={};for(var P in p){if(P.indexOf("_")!==0){p._settings[P]=p[P];}}}function r(p){if(typeof p.preprocessor==="string"){q.sap.require(p.preprocessor);p.preprocessor=q.sap.getObject(p.preprocessor);}else if(typeof p.preprocessor==="function"&&!p.preprocessor.process){p.preprocessor={process:p.preprocessor};}}function g(L,G){var i,l,O,p=[];for(i=0,l=G.length;i<l;i++){if(G[i]._onDemand){O=G[i];}else{p.push(G[i]);}}for(i=0,l=L.length;i<l;i++){var I=!L[i].preprocessor;if(I&&O){p.unshift(q.extend(L[i],O));}else if(!I){p.push(L[i]);}}return p;}function e(v,s){var i=v.getMetadata().getClass(),G=c._mPreprocessors[i._sType]||{};v.mPreprocessors=q.extend({},s.preprocessors);for(var _ in i.PreprocessorType){var t=i.PreprocessorType[_];if(v.mPreprocessors[t]&&!Array.isArray(v.mPreprocessors[t])){v.mPreprocessors[t]=[v.mPreprocessors[t]];}else if(!v.mPreprocessors[t]){v.mPreprocessors[t]=[];}v.mPreprocessors[t].forEach(d);v.mPreprocessors[t]=g(v.mPreprocessors[t],G[t]||[]);v.mPreprocessors[t].forEach(r);}}function f(v){v.oAsyncState={};v.oAsyncState.promise=new Promise(function(R,i){v.oAsyncState.complete=function(l){if(!l){R(v);}else{v.destroy();i(l);}};});}c.prototype._initCompositeSupport=function(s){this.oViewData=s.viewData;this.sViewName=s.viewName;var t=this;e(this,s);if(s.async){f(this);}var i=sap.ui.require('sap/ui/core/CustomizingConfiguration');if(i&&i.hasCustomProperties(this.sViewName,this)){this._fnSettingsPreprocessor=function(s){var l=this.getId();if(i&&l){if(t.isPrefixedId(l)){l=l.substring((t.getId()+"--").length);}var m=i.getCustomProperties(t.sViewName,l,t);if(m){s=q.extend(s,m);}}};}var p=function(l){var m=sap.ui.require("sap/ui/core/Component");var O=m&&m.getOwnerComponentFor(t);if(O){return O.runAsOwner(l);}else{return l.call();}};var I=function(){var P=h(t,s);if(P instanceof Promise){return P.then(function(){if(t.onControllerConnected){p(function(){t.onControllerConnected(t.oController);});}});}else{if(t.onControllerConnected){t.onControllerConnected(t.oController);}}};if(this.initViewSettings){if(s.async){this.initViewSettings(s).then(function(){return p(I);}).then(function(){return t.runPreprocessor("controls",t);}).then(function(){p(t.fireAfterInit.bind(t));t.oAsyncState.complete();});}else{this.initViewSettings(s);I();this.runPreprocessor("controls",this,true);this.fireAfterInit();}}else if(s.async){t.oAsyncState.complete();}};c.prototype.getController=function(){return this.oController;};c.prototype.byId=function(i){return sap.ui.getCore().byId(this.createId(i));};c.prototype.createId=function(i){if(!this.isPrefixedId(i)){i=this.getId()+"--"+i;}return i;};c.prototype.getLocalId=function(i){var p=this.getId()+"--";return(i&&i.indexOf(p)===0)?i.slice(p.length):null;};c.prototype.isPrefixedId=function(i){return!!(i&&i.indexOf(this.getId()+"--")===0);};var h=function(t,s){if(!sap.ui.getCore().getConfiguration().getControllerCodeDeactivated()){var i=s.controller,n=i&&typeof i.getMetadata==="function"&&i.getMetadata().getName();if(!i&&t.getControllerName){var l=t.getControllerName();if(l){var m=sap.ui.require('sap/ui/core/CustomizingConfiguration');var p=m&&m.getControllerReplacement(l,M._sOwnerId);if(p){l=typeof p==="string"?p:p.controllerName;}i=sap.ui.controller(l);n=l;}}if(i){i=a.extendIfRequired(i,n,t.oAsyncState);if(i instanceof Promise){if(!t.oAsyncState){throw new Error("The view "+t.sViewName+" runs in sync mode and therefore cannot use async controller extensions!");}return i.then(function(i){t.oController=i;i.connectToView(t);});}else{t.oController=i;i.connectToView(t);}}}else{t.oController={};}};c.prototype.getViewData=function(){return this.oViewData;};function j(){this.oAsyncState=null;}c.prototype.exit=function(){this.fireBeforeExit();delete this.oController;delete this.oPreprocessorInfo;if(this.oAsyncState){var D=j.bind(this);this.oAsyncState.promise.then(D,D);}};c.prototype.onAfterRendering=function(){this.fireAfterRendering();};c.prototype.onBeforeRendering=function(){this.fireBeforeRendering();};c.prototype.clone=function(i,l){var s={},K,m;for(K in this.mProperties&&!(this.isBound&&this.isBound(K))){if(this.mProperties.hasOwnProperty(K)){s[K]=this.mProperties[K];}}m=C.prototype.clone.call(this,i,l,{cloneChildren:false,cloneBindings:true});m.applySettings(s);return m;};c.prototype.getPreprocessorInfo=function(s){if(!this.oPreprocessorInfo){this.oPreprocessorInfo={name:this.sViewName,componentId:this._sOwnerId,id:this.getId(),caller:this+" ("+this.sViewName+")",sync:!!s};}if(c._supportInfo){this.oPreprocessorInfo._supportInfo=c._supportInfo;}return this.oPreprocessorInfo;};c.prototype.runPreprocessor=function(t,s,S){var v=this.getPreprocessorInfo(this,S),p=this.mPreprocessors&&this.mPreprocessors[t]||[],m,P,A,n;if(!S){A=function(u){return P(u,v,m);};n=Promise.resolve(s);}for(var i=0,l=p.length;i<l;i++){P=p[i].preprocessor.process;if(S&&p[i]._syncSupport===true){s=P(s,v,p[i]._settings);}else if(!S){m=p[i]._settings;n=n.then(A);}else{q.sap.log.debug("Async \""+t+"\"-preprocessor was skipped in sync view execution for "+this.getMetadata().getClass()._sType+"View",this.getId());}}return S?s:n;};function k(t,v){if(!c._mPreprocessors[v]){c._mPreprocessors[v]={};}if(!c._mPreprocessors[v][t]){c._mPreprocessors[v][t]=[];}}function o(v,s,t){c._mPreprocessors[s][t].forEach(function(p){if(p._onDemand){q.sap.log.error("Registration for \""+t+"\" failed, only one on-demand-preprocessor allowed",v.getMetadata().getName());return false;}});return true;}c.registerPreprocessor=function(t,p,v,s,O,S){if(typeof O!=="boolean"){S=O;O=false;}if(p){k(t,v);if(O&&!o(this,v,t)){return;}c._mPreprocessors[v][t].push({preprocessor:p,_onDemand:O,_syncSupport:s,_settings:S});q.sap.log.debug("Registered "+(O?"on-demand-":"")+"preprocessor for \""+t+"\""+(s?" with syncSupport":""),this.getMetadata().getName());}else{q.sap.log.error("Registration for \""+t+"\" failed, no preprocessor specified",this.getMetadata().getName());}};c.prototype.hasPreprocessor=function(t){return!!this.mPreprocessors[t].length;};sap.ui.view=function(i,v,t){var l=null,m={};if(typeof i==="object"||typeof i==="string"&&v===undefined){v=i;i=undefined;}if(v){if(typeof v==="string"){m.viewName=v;}else{m=v;}}if(i){m.id=i;}if(t){m.type=t;}var n=sap.ui.require('sap/ui/core/CustomizingConfiguration');if(n){var p=n.getViewReplacement(m.viewName,M._sOwnerId);if(p){q.sap.log.info("Customizing: View replacement for view '"+m.viewName+"' found and applied: "+p.viewName+" (type: "+p.type+")");q.extend(m,p);}else{q.sap.log.debug("Customizing: no View replacement found for view '"+m.viewName+"'.");}}if(!m.type){throw new Error("No view type specified.");}else if(m.type===V.JS){var J=sap.ui.requireSync('sap/ui/core/mvc/JSView');l=new J(m);}else if(m.type===V.JSON){var s=sap.ui.requireSync('sap/ui/core/mvc/JSONView');l=new s(m);}else if(m.type===V.XML){var X=sap.ui.requireSync('sap/ui/core/mvc/XMLView');l=new X(m);}else if(m.type===V.HTML){var H=sap.ui.requireSync('sap/ui/core/mvc/HTMLView');l=new H(m);}else if(m.type===V.Template){var T=sap.ui.requireSync('sap/ui/core/mvc/TemplateView');l=new T(m);}else{throw new Error("Unknown view type "+m.type+" specified.");}return l;};c.prototype.loaded=function(){if(!this.oAsyncState){return Promise.resolve(this);}else{return this.oAsyncState.promise;}};c._resolveEventHandler=function(n,i){var H;if(!sap.ui.getCore().getConfiguration().getControllerCodeDeactivated()){switch(n.indexOf('.')){case 0:H=i&&q.sap.getObject(n.slice(1),undefined,i);break;case-1:H=i&&i[n];if(H!=null){break;}default:H=q.sap.getObject(n);}}else{H=function(){};}if(typeof H==="function"){H._sapui_handlerName=n;return[H,i];}};return c;});
