// This file has been generated by the SAPUI5 'AllInOne' Builder
jQuery.sap.declare('sap.ui.dt.library-all');
if ( !jQuery.sap.isDeclared('sap.ui.dt.DOMUtil') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides object sap.ui.dt.DOMUtil.
jQuery.sap.declare('sap.ui.dt.DOMUtil'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/dt/DOMUtil",[
	'jquery.sap.global'
],
function(jQuery) {
	"use strict";

	/**
	 * Class for DOM Utils.
	 *
	 * @class
	 * Utility functionality for DOM
	 *
	 * @author SAP SE
	 * @version 1.42.6
	 *
	 * @private
	 * @static
	 * @since 1.30
	 * @alias sap.ui.dt.DOMUtil
	 * @experimental Since 1.30. This class is experimental and provides only limited functionality. Also the API might be changed in future.
	 */

	var DOMUtil = {};

	/**
	 *
	 */
	DOMUtil.getSize = function(oDomRef) {
		var oClientRec = oDomRef.getBoundingClientRect();
		return {
			width: oClientRec.width,
			height: oClientRec.height
		};
	};

	/**
	 *
	 */
	DOMUtil.getOffsetFromParent = function(oPosition, mParentOffset, scrollTop, scrollLeft) {
		var mOffset = {
			left : oPosition.left,
			top : oPosition.top
		};

		if (mParentOffset) {
			mOffset.left -= (mParentOffset.left - (scrollLeft ? scrollLeft : 0));
			mOffset.top -= (mParentOffset.top - (scrollTop ? scrollTop : 0));
		}
		return mOffset;
	};

	/**
	 *
	 */
	DOMUtil.getZIndex = function(oDomRef) {
		var zIndex;
		var $ElementDomRef = jQuery(oDomRef);
		if ($ElementDomRef.length) {
			zIndex = $ElementDomRef.zIndex() || $ElementDomRef.css("z-index");
		}
		return zIndex;
	};

	/**
	 *
	 */
	DOMUtil.hasScrollBar = function(oDomRef) {
		var $DomRef = jQuery(oDomRef);

		var bOverflowYScroll = $DomRef.css("overflow-y") === "auto" || $DomRef.css("overflow-y") === "scroll";
		var bOverflowXScroll = $DomRef.css("overflow-x") === "auto" || $DomRef.css("overflow-x") === "scroll";

		var bHasYScroll = bOverflowYScroll && $DomRef.get(0).scrollHeight > $DomRef.height();
		var bHasXScroll = bOverflowXScroll && $DomRef.get(0).scrollWidth > $DomRef.width();

		return bHasYScroll || bHasXScroll;
	};

	/**
	 *
	 */
	DOMUtil.getOverflows = function(oDomRef) {
		var oOverflows;
		var $ElementDomRef = jQuery(oDomRef);
		if ($ElementDomRef.length) {
			oOverflows = {};
			oOverflows.overflowX = $ElementDomRef.css("overflow-x");
			oOverflows.overflowY = $ElementDomRef.css("overflow-y");
		}
		return oOverflows;
	};

	/**
	 *
	 */
	DOMUtil.getGeometry = function(oDomRef, bUseWindowOffset) {
		if (oDomRef) {
			var oOffset = jQuery(oDomRef).offset();
			if (bUseWindowOffset) {
				oOffset.left = oOffset.left - jQuery(window).scrollLeft();
				oOffset.top = oOffset.top - jQuery(window).scrollTop();
			}

			return {
				domRef : oDomRef,
				size : this.getSize(oDomRef),
				position :  oOffset,
				visible : this.isVisible(oDomRef)
			};
		}
	};

	/**
	 *
	 */
	DOMUtil.syncScroll = function(oSourceDom, oTargetDom) {
		var $target = jQuery(oTargetDom);
		var oTargetScrollTop = $target.scrollTop();
		var oTargetScrollLeft = $target.scrollLeft();

		var $source = jQuery(oSourceDom);
		var oSourceScrollTop = $source.scrollTop();
		var oSourceScrollLeft = $source.scrollLeft();

		if (oSourceScrollTop !== oTargetScrollTop) {
			$target.scrollTop(oSourceScrollTop);
		}
		if (oSourceScrollLeft !== oTargetScrollLeft) {
			$target.scrollLeft(oSourceScrollLeft);
		}
	};

	/**
	 * returns jQuery object found in oDomRef for sCSSSelector
	 * @param  {Element|jQuery} oDomRef to search in
	 * @param  {string} sCSSSelector jQuery (CSS-like) selector to look for
	 * @return {jQuery} found domRef
	 */
	DOMUtil.getDomRefForCSSSelector = function(oDomRef, sCSSSelector) {
		if (sCSSSelector && oDomRef) {
			var $domRef = jQuery(oDomRef);

			if (sCSSSelector === ":sap-domref") {
				return $domRef;
			}

			// ":sap-domref > sapMPage" scenario
			if (sCSSSelector.indexOf(":sap-domref") > -1) {
				return $domRef.find(sCSSSelector.replace(/:sap-domref/g, ""));
			}

			// normal selector
			return $domRef.find(sCSSSelector);
		} else {
			// empty jQuery object for typing
			return jQuery();
		}
	};

	/**
	 *
	 */
	DOMUtil.isVisible = function(oDomRef) {
		// mimic the jQuery 1.11.1 impl of the ':visible' selector as the jQuery 2.2.0 selector no longer reports empty SPANs etc. as 'hidden'
		return oDomRef ? oDomRef.offsetWidth > 0 || oDomRef.offsetHeight > 0 : false;
	};

	/**
	 *
	 */
	DOMUtil.getEscapedString = function(sString) {
		return sString.replace(/([;&,\.\+\*\~':"\!\^#$%@\[\]\(\)=>\|])/g, '\\$1');
	};

	/**
	 *
	 */
	DOMUtil.setDraggable = function(oElement, bValue) {
		oElement = jQuery(oElement);

		oElement.attr("draggable", bValue);
	};

	/**
	 * Copy the given styles object to a destination DOM node.
	 *
	 * @param {Object} oStyles A styles object, which is retrieved from window.getComputedStyle
	 * @param {Element} oDest The element to which the styles should be copied.
	 * @private
	 */
	DOMUtil._copyStylesTo = function(oStyles, oDest) {
		var sStyles = "";
		var sStyle = "";
		var iLength = oStyles.length;
		// Styles is an array, but has some special access functions
		for (var i = 0; i < iLength; i++) {
			sStyle = oStyles[i];
			sStyles = sStyles + sStyle + ":" + oStyles.getPropertyValue(sStyle) + ";";
		}

		oDest.style.cssText = sStyles;
	};

	DOMUtil._copyPseudoElement = function(sPseudoElement, oSrc, oDest) {
		var mStyles = window.getComputedStyle(oSrc, sPseudoElement);
		var sContent = mStyles.getPropertyValue("content");
		if (sContent && sContent !== "none") {
			sContent = jQuery.trim(sContent);
			if (sContent.indexOf("attr(") === 0) {
				sContent = sContent.replace("attr(", "");
				if (sContent.length) {
					sContent = sContent.substring(0, sContent.length - 1);
				}
				sContent = oSrc.getAttribute(sContent);
			}

			// pseudo elements can't be inserted via js, so we should create a real elements, which copy pseudo styling
			var oAfterElement = jQuery("<span></span>");
			if (sPseudoElement === ":after") {
				oAfterElement.appendTo(oDest);
			} else {
				oAfterElement.prependTo(oDest);
			}

			oAfterElement.text(sContent.replace(/\"/g, ""));
			DOMUtil._copyStylesTo(mStyles, oAfterElement.get(0));
			oAfterElement.css("display", "inline");
		}
	};

	/**
	 *
	 */
	DOMUtil.copyComputedStyle = function(oSrc, oDest) {
		oSrc = jQuery(oSrc).get(0);
		oDest = jQuery(oDest).get(0);
		var mStyles = window.getComputedStyle(oSrc);

		if (mStyles.getPropertyValue("display") == "none") {
			oDest.style.display = "none";
			return;
		}

		DOMUtil._copyStylesTo(mStyles, oDest);


		mStyles = window.getComputedStyle(oSrc, ":after");
		var sContent = mStyles.getPropertyValue("content");
		if (sContent && sContent !== "none") {
			if (sContent.indexOf("attr(") === 0) {
				sContent = sContent.replace("attr(", "");
				sContent = sContent.replace(")", "");
				sContent = oSrc.getAttribute(sContent);
			}
			var oAfterElement = jQuery("<span></span>").appendTo(oDest);
			oAfterElement.text(sContent.replace(/\"/g, ""));
			DOMUtil._copyStylesTo(mStyles, oAfterElement.get(0));
			oAfterElement.css("display", "inline");
		}

		this._copyPseudoElement(":after", oSrc, oDest);
		this._copyPseudoElement(":before", oSrc, oDest);
	};

	/**
	 *
	 */
	DOMUtil.copyComputedStyles = function(oSrc, oDest) {
		oSrc = jQuery(oSrc).get(0);
		oDest = jQuery(oDest).get(0);

		for (var i = 0; i < oSrc.children.length; i++) {
			this.copyComputedStyles(oSrc.children[i], oDest.children[i]);
		}

		// we shouldn't copy classes because they can affect styling
		jQuery(oDest).removeClass();
		// remove all special attributes, which can affect app behaviour
		jQuery(oDest).attr("id", "");
		jQuery(oDest).attr("role", "");
		jQuery(oDest).attr("data-sap-ui", "");
		jQuery(oDest).attr("for", "");

		jQuery(oDest).attr("tabIndex", -1);
		this.copyComputedStyle(oSrc, oDest);
	};

	/**
	 *
	 */
	DOMUtil.cloneDOMAndStyles = function(oNode, oTarget) {
		oNode = jQuery(oNode).get(0);
		oTarget = jQuery(oTarget).get(0);

		var oCopy = oNode.cloneNode(true);
		this.copyComputedStyles(oNode, oCopy);

		var $copy = jQuery(oCopy);

		jQuery(oTarget).append($copy);
	};

	return DOMUtil;
}, /* bExport= */ true);

}; // end of sap/ui/dt/DOMUtil.js
if ( !jQuery.sap.isDeclared('sap.ui.dt.ElementUtil') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides object sap.ui.dt.ElementUtil.
jQuery.sap.declare('sap.ui.dt.ElementUtil'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/dt/ElementUtil",['jquery.sap.global'],
		function(jQuery) {
			"use strict";

			/**
			 * Class for ElementUtil.
			 *
			 * @class Utility functionality to work with élements, e.g. iterate through aggregations, find parents, ...
			 *
			 * @author SAP SE
			 * @version 1.42.6
			 *
			 * @private
			 * @static
			 * @since 1.30
			 * @alias sap.ui.dt.ElementUtil
			 * @experimental Since 1.30. This class is experimental and provides only limited functionality. Also the API
			 *               might be changed in future.
			 */

			var ElementUtil = {};

			ElementUtil.sACTION_MOVE = 'move';
			ElementUtil.sACTION_CUT = 'cut';
			ElementUtil.sACTION_PASTE = 'paste';
			ElementUtil.sREORDER_AGGREGATION = 'reorder_aggregation';

			/**
			 *
			 */
			ElementUtil.iterateOverElements = function(vElement, fnCallback) {
				if (vElement && vElement.length) {
					for (var i = 0; i < vElement.length; i++) {
						var oElement = vElement[i];
						if (oElement instanceof sap.ui.core.Element) {
							fnCallback(oElement);
						}
					}
				} else if (vElement instanceof sap.ui.core.Element) {
					fnCallback(vElement);
				}
			};

			/**
			 *
			 */
			ElementUtil.iterateOverAllPublicAggregations = function(oElement, fnCallback) {
				var that = this;

				var mAggregations = oElement.getMetadata().getAllAggregations();
				var aAggregationNames = Object.keys(mAggregations);

				aAggregationNames.forEach(function(sAggregationName) {
					var oAggregation = mAggregations[sAggregationName];
					var vAggregationValue = that.getAggregation(oElement, sAggregationName);

					fnCallback(oAggregation, vAggregationValue);
				});
			};

			/**
			 *
			 */
			ElementUtil.getElementInstance = function(vElement) {
				if (typeof vElement === "string") {
					return sap.ui.getCore().byId(vElement);
				} else {
					return vElement;
				}
			};

			/**
			 *
			 */
			ElementUtil.hasAncestor = function(oElement, oAncestor) {
				oAncestor = this.fixComponentContainerElement(oAncestor);

				var oParent = this.fixComponentParent(oElement);
				while (oParent && oParent !== oAncestor) {
					oParent = oParent.getParent();
					oParent = this.fixComponentParent(oParent);
				}

				return !!oParent;
			};

			/**
			 *
			 */
			ElementUtil.getClosestElementForNode = function(oNode) {
				var $ClosestElement = jQuery(oNode).closest("[data-sap-ui]");
				return $ClosestElement.length ? sap.ui.getCore().byId($ClosestElement.data("sap-ui")) : undefined;
			};

			/**
			 * ! Please, use this method only if OverlayUtil.getClosestOverlayForType is not available in your case ! find the
			 * closest element of the given type
			 *
			 * @param {sap.ui.core.Element}
			 *          oSourceElement to start search for
			 * @param {string}
			 *          sType to check instance of
			 * @return {sap.ui.core.Element} element of the given type, if found
			 */
			ElementUtil.getClosestElementOfType = function(oSourceElement, sType) {
				var oElement = oSourceElement;

				while (oElement && !this.isInstanceOf(oElement, sType)) {
					oElement = oElement.getParent();
				}

				return oElement;
			};

			/**
			 *
			 */
			ElementUtil.fixComponentParent = function(oElement) {
				if (this.isInstanceOf(oElement, "sap.ui.core.UIComponent")) {
					var oComponentContainer = oElement.oContainer;
					if (oComponentContainer) {
						return oComponentContainer.getParent();
					}
				} else {
					return oElement;
				}
			};

			/**
			 *
			 */
			ElementUtil.fixComponentContainerElement = function(oElement) {
				if (this.isInstanceOf(oElement, "sap.ui.core.ComponentContainer")) {
					// This happens when the compontentContainer has not been rendered yet
					if (!oElement.getComponentInstance()) {
						return;
					}
					return oElement.getComponentInstance().getAggregation("rootControl");
				} else {
					return oElement;
				}
			};

			/**
			 *
			 */
			ElementUtil.findAllPublicElements = function(oElement) {
				var that = this;
				var aFoundElements = [];

				function internalFind(oElement) {
					oElement = that.fixComponentContainerElement(oElement);
					if (oElement) {
						aFoundElements.push(oElement);
						that.iterateOverAllPublicAggregations(oElement, function(oAggregation, vElements) {
							that.iterateOverElements(vElements, internalFind);
						});
					}
				}
				internalFind(oElement);

				return aFoundElements;
			};

			/**
			 *
			 */
			ElementUtil.getDomRef = function(oElement) {
				if (oElement) {
					var oDomRef;
					if (oElement.getDomRef) {
						oDomRef = oElement.getDomRef();
					}
					if (!oDomRef && oElement.getRenderedDomRef) {
						oDomRef = oElement.getRenderedDomRef();
					}
					return oDomRef;
				}
			};

			/**
			 *
			 */
			ElementUtil.findAllPublicChildren = function(oElement) {
				var aFoundElements = this.findAllPublicElements(oElement);
				var iIndex = aFoundElements.indexOf(oElement);
				if (iIndex > -1) {
					aFoundElements.splice(iIndex, 1);
				}
				return aFoundElements;

			};

			/**
			 *
			 */
			ElementUtil.isElementFiltered = function(oControl, aType) {
				// TODO: Is this method still needed?
				var that = this;

				aType = aType || this.getControlFilter();
				var bFiltered = false;

				aType.forEach(function(sType) {
					bFiltered = that.isInstanceOf(oControl, sType);
					if (bFiltered) {
						return false;
					}
				});

				return bFiltered;
			};

			/**
			 *
			 */
			ElementUtil.findClosestControlInDom = function(oNode) {
				// TODO: Is this method still needed?
				if (oNode && oNode.getAttribute("data-sap-ui")) {
					return sap.ui.getCore().byId(oNode.getAttribute("data-sap-ui"));
				} else {
					if (oNode.parentNode) {
						this.findClosestControlInDom(oNode.parentNode);
					} else {
						return null;
					}
				}
			};

			/**
			 *
			 */
			ElementUtil.getAggregationAccessors = function(oElement, sAggregationName) {
				var oMetadata = oElement.getMetadata();
				oMetadata.getJSONKeys();
				var oAggregationMetadata = oMetadata.getAggregation(sAggregationName);
				if (oAggregationMetadata) {
					var sGetter = oAggregationMetadata._sGetter;

					// altType getter returns not element (TODO: clarify if getAggregationNameControl getter is a convention)
					if (oAggregationMetadata.altTypes && oAggregationMetadata.altTypes.length
							&& oElement[oAggregationMetadata._sGetter + "Control"]) {
						sGetter = oAggregationMetadata._sGetter + "Control";
					}

					return {
						get : sGetter,
						add : oAggregationMetadata._sMutator,
						remove : oAggregationMetadata._sRemoveMutator,
						insert : oAggregationMetadata._sInsertMutator,
						removeAll : oAggregationMetadata._sRemoveAllMutator
					};
				} else {
					return {};
				}
			};

			/**
			 *
			 */
			ElementUtil.getAggregation = function(oElement, sAggregationName) {
				var oValue;

				var sGetter = this.getAggregationAccessors(oElement, sAggregationName).get;
				if (sGetter) {
					oValue = oElement[sGetter]();
				} else {
					oValue = oElement.getAggregation(sAggregationName);
				}
				// ATTENTION:
				// under some unknown circumstances the return oValue looks like an Array but jQuery.isArray() returned
				// undefined => false
				// that is why we use array ducktyping with a null check!
				// reproducible with Windows and Chrome (currently 35), when creating a project and opening WYSIWYG editor
				// afterwards on any file
				// sap.m.Panel.prototype.getHeaderToolbar() returns a single object but an array
				/* eslint-disable no-nested-ternary */
				oValue = oValue && oValue.splice ? oValue : (oValue ? [oValue] : []);
				/* eslint-enable no-nested-ternary */
				return oValue;
			};

			ElementUtil.getIndexInAggregation = function(oElement, oParent, sAggregationName) {
				return this.getAggregation(oParent, sAggregationName).indexOf(oElement);
			};

			/**
			 *
			 */
			ElementUtil.addAggregation = function(oParent, sAggregationName, oElement) {
				if (this.hasAncestor(oParent, oElement)) {
					throw new Error("Trying to add an element to itself or its successors");
				}
				var sAggregationAddMutator = this.getAggregationAccessors(oParent, sAggregationName).add;
				if (sAggregationAddMutator) {
					oParent[sAggregationAddMutator](oElement);
				} else {
					oParent.addAggregation("sAggregationName", oElement);
				}

			};

			/**
			 *
			 */
			ElementUtil.removeAggregation = function(oParent, sAggregationName, oElement) {
				var sAggregationRemoveMutator = this.getAggregationAccessors(oParent, sAggregationName).remove;
				if (sAggregationRemoveMutator) {
					oParent[sAggregationRemoveMutator](oElement);
				} else {
					oParent.removeAggregation(sAggregationName, oElement);
				}
			};

			/**
			 *
			 */
			ElementUtil.insertAggregation = function(oParent, sAggregationName, oElement, iIndex) {
				if (this.hasAncestor(oParent, oElement)) {
					throw new Error("Trying to add an element to itself or its successors");
				}
				if (this.getAggregation(oParent, sAggregationName).indexOf(oElement) !== -1) {
					// ManagedObject.insertAggregation won't reposition element, if it's already inside of same aggregation
					// therefore we need to remove the element and then insert it again. To prevent ManagedObjectObserver from
					// firing
					// setParent event with parent null, private flag is set.
					oElement.__bSapUiDtSupressParentChangeEvent = true;
					try {
						oParent.removeAggregation(sAggregationName, oElement, true);
					} finally {
						delete oElement.__bSapUiDtSupressParentChangeEvent;
					}
				}
				var sAggregationInsertMutator = this.getAggregationAccessors(oParent, sAggregationName).insert;
				if (sAggregationInsertMutator) {
					oParent[sAggregationInsertMutator](oElement, iIndex);
				} else {
					oParent.insertAggregation(sAggregationName, oElement, iIndex);
				}
			};

			/**
			 *
			 */
			ElementUtil.isValidForAggregation = function(oParent, sAggregationName, oElement) {
				var oAggregationMetadata = oParent.getMetadata().getAggregation(sAggregationName);

				// Make sure that the parent is not inside of the element, or is not the element itself,
				// e.g. insert a layout inside it's content aggregation.
				// This check needed as UI5 will have a maximum call stack error otherwise.
				if (this.hasAncestor(oParent, oElement)) {
					return false;
				}

				// only for public aggregations
				if (oAggregationMetadata) {
					// TODO : test altTypes
					var sTypeOrInterface = oAggregationMetadata.type;
					return this.isInstanceOf(oElement, sTypeOrInterface) || this.hasInterface(oElement, sTypeOrInterface);
				}

			};

			/**
			 *
			 */
			ElementUtil.hasInterface = function(oElement, sInterface) {
				var aInterfaces = oElement.getMetadata().getInterfaces();
				return aInterfaces.indexOf(sInterface) !== -1;
			};

			/**
			 *
			 */
			ElementUtil.isInstanceOf = function(oElement, sType) {
				var oInstance = jQuery.sap.getObject(sType);
				if (typeof oInstance === "function") {
					return oElement instanceof oInstance;
				} else {
					return false;
				}
			};

			/**
			 *
			 */
			ElementUtil.getDesignTimeMetadata = function(oElement) {
				var oDTMetadata = oElement ? oElement.getMetadata().getDesignTime() : {};
				return oDTMetadata || {};
			};

			/**
			 *
			 */
			ElementUtil.loadDesignTimeMetadata = function(oElement) {
				return oElement ? oElement.getMetadata().loadDesignTime() : Promise.resolve({});
			};

			/**
			 * .* Executes an array of actions. An action is a JSON object having the following structure: .* .* <action> = { .*
			 * 'element' : <ui5 id of element to be moved>, .* 'source' : { .* 'index': <source index>, .* 'parent' : <ui5 id
			 * of element actual parent>, .* 'aggregation' : <name of aggregation> .* }, .* 'target' : { .* 'index': <target
			 * index>, .* 'parent' : <ui5 id of element future parent>, .* 'aggregation' : <name of aggregation> .* }, .*
			 * 'changeType' : <name of change type e.g "Move" .* })
			 */
			ElementUtil.executeActions = function(aActions) {
				for (var i = 0; i < aActions.length; i++) {
					var oAction = aActions[i];
					switch (oAction.changeType) {
						case ElementUtil.sACTION_MOVE :
							var oTargetParent = sap.ui.getCore().byId(oAction.target.parent);
							var oMovedElement = sap.ui.getCore().byId(oAction.element);
							ElementUtil.insertAggregation(oTargetParent, oAction.target.aggregation, oMovedElement,
									oAction.target.index);
							break;
						case ElementUtil.sACTION_CUT :
							var oTargetParent = sap.ui.getCore().byId(oAction.source.parent);
							var oMovedElement = sap.ui.getCore().byId(oAction.element);
							ElementUtil.removeAggregation(oTargetParent, oAction.source.aggregation, oMovedElement);
							break;
						case ElementUtil.sACTION_PASTE :
							var oTargetParent = sap.ui.getCore().byId(oAction.target.parent);
							var oMovedElement = sap.ui.getCore().byId(oAction.element);
							ElementUtil.insertAggregation(oTargetParent, oAction.target.aggregation, oMovedElement,
									oAction.target.index);
							break;
						case ElementUtil.sREORDER_AGGREGATION :
							var oTargetParent = sap.ui.getCore().byId(oAction.target.parent);
							var sAggregationRemoveAllMutator = this
									.getAggregationAccessors(oTargetParent, oAction.target.aggregation).removeAll;
							oTargetParent[sAggregationRemoveAllMutator]();
							var sAggregationAddMutator = this.getAggregationAccessors(oTargetParent, oAction.target.aggregation).add;
							for (var j = 0; j < oAction.source.elements.length; j++) {
								var oElement = sap.ui.getCore().byId(oAction.source.elements[j]);
								oTargetParent[sAggregationAddMutator](oElement);
							}
							break;
						default :
					}
				}

			};

			return ElementUtil;
		}, /* bExport= */true);

}; // end of sap/ui/dt/ElementUtil.js
if ( !jQuery.sap.isDeclared('sap.ui.dt.ManagedObjectObserver') ) {
/*
 * ! UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides class sap.ui.dt.ManagedObjectObserver.
jQuery.sap.declare('sap.ui.dt.ManagedObjectObserver'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.ui.base.ManagedObject'); // unlisted dependency retained
sap.ui.define("sap/ui/dt/ManagedObjectObserver",[
	'sap/ui/base/ManagedObject', 'sap/ui/dt/ElementUtil'
], function(ManagedObject, ElementUtil) {
	"use strict";

	/**
	 * Constructor for a new ManagedObjectObserver.
	 *
	 * @param {string} [sId] id for the new object, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new object
	 * @class The ManagedObjectObserver observes changes of a ManagedObject and propagates them via events.
	 * @extends sap.ui.base.ManagedObject
	 * @author SAP SE
	 * @version 1.42.6
	 * @constructor
	 * @private
	 * @since 1.30
	 * @alias sap.ui.dt.ManagedObjectObserver
	 * @experimental Since 1.30. This class is experimental and provides only limited functionality. Also the API might be modified in future.
	 */
	var ManagedObjectObserver = ManagedObject.extend("sap.ui.dt.ManagedObjectObserver", /** @lends sap.ui.dt.ManagedObjectObserver.prototype */
	{
		metadata: {
			"abstract": true,
			// ---- object ----

			// ---- control specific ----
			library: "sap.ui.dt",
			properties: {

			},
			associations: {
				/**
				 * target ManagedObject to observe
				 */
				target: {
					type: "sap.ui.base.ManagedObject"
				}
			},
			events: {
				/**
				 * Event fired when the observed object is modified
				 */
				modified: {
					parameters: {
						type : "string",
						name : "string",
						value : "any",
						oldValue : "any",
						target : "sap.ui.core.Element"
					}
				},
				destroyed: {}
			}
		}
	});

	/**
	 * Called when the ManagedObjectObserver is created
	 *
	 * @protected
	 */
	ManagedObjectObserver.prototype.init = function() {
		var that = this;

		this._fnFireModified = function() {
			that.fireModified();
		};
	};

	/**
	 * Called when the ManagedObjectObserver is destroyed
	 *
	 * @protected
	 */
	ManagedObjectObserver.prototype.exit = function() {
		this.unobserve();

		delete this._fnFireModified;
	};

	/**
	 * Sets a target ManagedObject to observe
	 *
	 * @param {string|sap.ui.base.ManagedObject} vTarget id or managed object to set
	 * @return {sap.ui.dt.ManagedObjectObserver} returns this
	 */
	ManagedObjectObserver.prototype.setTarget = function(vTarget) {
		this.unobserve();

		this.setAssociation("target", vTarget);

		var oTarget = this.getTargetInstance();
		if (oTarget) {
			this.observe(oTarget);
		}

		return this;
	};

	/**
	 * Starts observing the target object. Override this method in classes wich extend ManagedObjectObserver.
	 *
	 * @param {sap.ui.base.ManagedObject} oTarget The target to observe
	 * @protected
	 */
	ManagedObjectObserver.prototype.observe = function(oTarget) {
		var that = this;

		oTarget.attachEvent("_change", this._fnFireModified, this);

		// Wrapper for the destroy method to recognize changes
		var fnOriginalDestroy = this._fnOriginalDestroy = oTarget.destroy;
		var bDestroyed = false;
		oTarget.destroy = function() {
			if (bDestroyed) {
				return;
			}
			that.unobserve();
			var vOriginalReturn = fnOriginalDestroy.apply(this, arguments);
			that.fireDestroyed();

			return vOriginalReturn;
		};

		// Wrapper for the bindProperty method to recognize changes
		this._fnOriginalBindProperty = oTarget.bindProperty;
		oTarget.bindProperty = function() {
			var vOriginalReturn = that._fnOriginalBindProperty.apply(this, arguments);
			that.fireModified();

			return vOriginalReturn;
		};

		// Wrapper for the unbindProperty method to recognize changes
		this._fnOriginalUnBindProperty = oTarget.unbindProperty;
		oTarget.unbindProperty = function() {
			var vOriginalReturn = that._fnOriginalUnBindProperty.apply(this, arguments);
			that.fireModified();

			return vOriginalReturn;
		};

		// Wrapper for the bindAggregation method to recognize changes
		this._fnOriginalBindAggregation = oTarget.bindAggregation;
		oTarget.bindAggregation = function(sAggregationName) {
			var vOriginalReturn = that._fnOriginalBindAggregation.apply(this, arguments);
			that.fireModified();

			return vOriginalReturn;
		};

		// Wrapper for the unbindAggregation method to recognize changes
		this._fnOriginalUnBindAggregation = oTarget.unbindAggregation;
		oTarget.unbindAggregation = function(sAggregationName) {
			var vOriginalReturn = that._fnOriginalUnBindAggregation.apply(this, arguments);
			that.fireModified();

			return vOriginalReturn;
		};

		// We wrap the native setParent method of the control with our logic
		this._fnOriginalSetParent = oTarget.setParent;
		oTarget.setParent = function(oParent, sAggregationName, bSuppressInvalidate) {
			var bFireModified = false;
			if (!this._bInSetParent) {
				bFireModified = true;
				this._bInSetParent = true;
			}

			var oCurrentParent = this.getParent();
			var vOriginalReturn = that._fnOriginalSetParent.apply(this, arguments);
			if (bFireModified && !this.__bSapUiDtSupressParentChangeEvent) {
				this._bInSetParent = false;
				if (oCurrentParent !== oParent) {
					that.fireModified({
						type: "setParent",
						value: oParent,
						oldValue: oCurrentParent,
						target: this
					});
				}
			}

			return vOriginalReturn;
		};

		// We wrap the native addAggregation method of the control with our logic
		this._fnOriginalAddAggregation = oTarget.addAggregation;
		oTarget.addAggregation = function(sAggregationName, oObject, bSuppressInvalidate) {
			that._bAddOrSetAggregationCall = true;
			var vOriginalReturn = that._fnOriginalAddAggregation.apply(this, arguments);
			that.fireModified({
				type: "addOrSetAggregation",
				name : sAggregationName,
				value: oObject,
				target: this
			});
			return vOriginalReturn;
		};

		// We wrap the native setAggregation method of the control with our logic
		this._fnOriginalSetAggregation = oTarget.setAggregation;
		oTarget.setAggregation = function(sAggregationName, oObject, bSuppressInvalidate) {
			// same mutator as addAggregation for multiple = false aggregations
			that._bAddOrSetAggregationCall = true;
			var vOriginalReturn = that._fnOriginalSetAggregation.apply(this, arguments);
			that.fireModified({
				type: "addOrSetAggregation",
				name : sAggregationName,
				value: oObject,
				target: this
			});
			return vOriginalReturn;
		};

		// We wrap the native removeAggregation method of the control with our logic
		this._fnOriginalRemoveAggregation = oTarget.removeAggregation;
		oTarget.removeAggregation = function(sAggregationName, vObject, bSuppressInvalidate) {
			that._bRemoveAggregationCall = true;
			var vOriginalReturn = that._fnOriginalRemoveAggregation.apply(this, arguments);
			that.fireModified({
				type: "removeAggregation",
				name : sAggregationName,
				value: vObject,
				target: this
			});
			return vOriginalReturn;
		};

		// We wrap the native insertAggregation method of the control with our logic
		this._fnOriginalInsertAggregation = oTarget.insertAggregation;
		oTarget.insertAggregation = function(sAggregationName, oObject, iIndex, bSuppressInvalidate) {
			that._bInsertAggregationCall = true;
			var vOriginalReturn = that._fnOriginalInsertAggregation.apply(this, arguments);
			that.fireModified({
				type: "insertAggregation",
				name : sAggregationName,
				value: oObject,
				target: this
			});
			return vOriginalReturn;
		};

		// We wrap the native removeAllAggregations method of the control with our logic
		this._fnOriginalRemoveAllAggregation = oTarget.removeAllAggregation;
		oTarget.removeAllAggregation = function(sAggregationName, bSuppressInvalidate) {
			that._bRemoveAllAggregationCall = true;
			var aRemovedObjects = this.getAggregation(sAggregationName);
			var vOriginalReturn = that._fnOriginalRemoveAllAggregation.apply(this, arguments);
			that.fireModified({
				type: "removeAllAggregation",
				name : sAggregationName,
				value: aRemovedObjects,
				target: this
			});
			return vOriginalReturn;
		};

		// We wrap the native destroyAggregation method of the control with our logic
		this._fnOriginalDestroyAggregation = oTarget.destroyAggregation;
		oTarget.destroyAggregation = function(sAggregationName, bSuppressInvalidate) {
			that._bDestroyAggregationCall = true;
			var aRemovedObjects = this.getAggregation(sAggregationName);
			var vOriginalReturn = that._fnOriginalDestroyAggregation.apply(this, arguments);
			that.fireModified({
				type: "destroyAggregation",
				name : sAggregationName,
				value: aRemovedObjects,
				target: this
			});
			return vOriginalReturn;
		};

		that._aOriginalAddMutators = {};
		that._aOriginalInsertMutators = {};
		that._aOriginalRemoveMutators = {};
		that._aOriginalRemoveAllMutators = {};
		that._aOriginalDestructors = {};
		var mAllAggregations = oTarget.getMetadata().getAllAggregations();
		Object.keys(mAllAggregations).forEach(function(sAggregationName) {
			var oAggregation = mAllAggregations[sAggregationName];
			var _fnOriginalAddMutator = oTarget[oAggregation._sMutator];
			that._aOriginalAddMutators[oAggregation.name] = _fnOriginalAddMutator;
			oTarget[oAggregation._sMutator] = function(oObject) {
				that._bAddOrSetAggregationCall = false;
				// if addAggregation or setAggregation method wasn't called directly

				var vOriginalReturn;
				vOriginalReturn = _fnOriginalAddMutator.apply(this, arguments);

				if (!that._bAddOrSetAggregationCall) {
					that.fireModified({
						type: "addOrSetAggregation",
						name : oAggregation.name,
						value: oObject,
						target: this
					});
				}
				return vOriginalReturn;
			};

			var _fnOriginalInsertMutator = oTarget[oAggregation._sInsertMutator];
			that._aOriginalInsertMutators[oAggregation.name] = _fnOriginalInsertMutator;
			oTarget[oAggregation._sInsertMutator] = function(oObject, iIndex) {
				that._bInsertAggregationCall = false;

				var vOriginalReturn;
				vOriginalReturn = _fnOriginalInsertMutator.apply(this, arguments);

				// if insertAggregation method wasn't called directly
				if (!that._bInsertAggregationCall) {
					that.fireModified({
						type: "insertAggregation",
						name : oAggregation.name,
						value: oObject,
						target: this
					});
				}
				return vOriginalReturn;
			};

			var _fnOriginalRemoveMutator = oTarget[oAggregation._sRemoveMutator];
			that._aOriginalRemoveMutators[oAggregation.name] = _fnOriginalRemoveMutator;
			oTarget[oAggregation._sRemoveMutator] = function(vObject, bSuppressInvalidate) {
				that._bRemoveAggregationCall = false;
				var vOriginalReturn = _fnOriginalRemoveMutator.apply(this, arguments);
				// if removeAggregation method wasn't called directly
				if (!that._bRemoveAggregationCall) {
					that.fireModified({
						type: "removeAggregation",
						name : oAggregation.name,
						value: vObject,
						target: this
					});
				}
				return vOriginalReturn;
			};

			var _fnOriginalRemoveAllMutator = oTarget[oAggregation._sRemoveAllMutator];
			that._aOriginalRemoveAllMutators[oAggregation.name] = _fnOriginalRemoveAllMutator;
			oTarget[oAggregation._sRemoveAllMutator] = function(bSuppressInvalidate) {
				that._bRemoveAllAggregationCall = false;
				var aRemovedObjects = this.getAggregation(sAggregationName);
				var vOriginalReturn = _fnOriginalRemoveAllMutator.apply(this, arguments);
				// if removeAllAggregation method wasn't called directly
				if (!that._bRemoveAllAggregationCall) {
					that.fireModified({
						type: "removeAllAggregation",
						name : oAggregation.name,
						value: aRemovedObjects,
						target: this
					});
				}
				return vOriginalReturn;
			};

			var _fnOriginalDestructor = oTarget[oAggregation._sDestructor];
			that._aOriginalDestructors[oAggregation.name] = _fnOriginalDestructor;
			oTarget[oAggregation._sDestructor] = function(bSuppressInvalidate) {
				that._bDestroyAggregationCall = false;
				var aRemovedObjects = this.getAggregation(sAggregationName);
				var vOriginalReturn = _fnOriginalDestructor.apply(this, arguments);
				// if destroyAggregation method wasn't called directly
				if (!that._bDestroyAggregationCall) {
					that.fireModified({
						type: "destroyAggregation",
						name : oAggregation.name,
						value: aRemovedObjects,
						target: this
					});
				}
				return vOriginalReturn;
			};
		});

	};

	/**
	 * Stops observing the target object. Override this method in classes wich extend ManagedObjectObserver.
	 *
	 * @param {sap.ui.base.ManagedObject} oTarget The target to unobserve
	 * @protected
	 */
	ManagedObjectObserver.prototype.unobserve = function() {
		var that = this;

		var oTarget = this.getTargetInstance();

		if (oTarget) {
			oTarget.destroy = this._fnOriginalDestroy;
			oTarget.bindProperty = this._fnOriginalBindProperty;
			oTarget.unbindProperty = this._fnOriginalUnBindProperty;
			oTarget.bindAggregation = this._fnOriginalBindAggregation;
			oTarget.unbindAggregation = this._fnOriginalUnBindAggregation;
			oTarget.setParent = this._fnOriginalSetParent;

			oTarget.addAggregation = this._fnOriginalAddAggregation;
			oTarget.removeAggregation = this._fnOriginalRemoveAggregation;
			oTarget.insertAggregation = this._fnOriginalInsertAggregation;
			oTarget.setAggregation = this._fnOriginalSetAggregation;
			oTarget.removeAllAggregation = this._fnOriginalRemoveAllAggregation;
			oTarget.destroyAggregation = this._fnOriginalDestroyAggregation;

			var mAllAggregations = oTarget.getMetadata().getAllAggregations();
			Object.keys(mAllAggregations).forEach(function(sAggregationName) {
				var oAggregation = mAllAggregations[sAggregationName];
				oTarget[oAggregation._sMutator] = that._aOriginalAddMutators[oAggregation.name];
				oTarget[oAggregation._sInsertMutator] = that._aOriginalInsertMutators[oAggregation.name];
				oTarget[oAggregation._sRemoveMutator] = that._aOriginalRemoveMutators[oAggregation.name];
				oTarget[oAggregation._sRemoveAllMutator] = that._aOriginalRemoveAllMutators[oAggregation.name];
				oTarget[oAggregation._sDestructor] = that._aOriginalDestructors[oAggregation.name];
			});
			oTarget.detachEvent("_change", this._fnFireModified, this);
		}

		delete this._fnOriginalDestroy;
		delete this._fnOriginalBindProperty;
		delete this._fnOriginalUnBindProperty;
		delete this._fnOriginalBindAggregation;
		delete this._fnOriginalUnBindAggregation;
		delete this._fnOriginalSetParent;
		delete this._fnOriginalAddAggregation;
		delete this._fnOriginalRemoveAggregation;
		delete this._fnOriginalInsertAggregation;
		delete this._fnOriginalSetAggregation;
		delete this._fnOriginalRemoveAllAggregations;
		delete this._fnOriginalDestroyAggregation;
		delete this._aOriginalAddMutators;
		delete this._aOriginalInsertMutators;
		delete this._aOriginalRemoveMutators;
		delete this._aOriginalRemoveAllMutators;
		delete this._aOriginalDestructors;

	};

	/**
	 * @protected
	 * @return {sap.ui.base.ManagedObject} The instance of the associated target to observe.
	 */
	ManagedObjectObserver.prototype.getTargetInstance = function() {
		return sap.ui.getCore().byId(this.getTarget());
	};

	return ManagedObjectObserver;
}, /* bExport= */true);

}; // end of sap/ui/dt/ManagedObjectObserver.js
if ( !jQuery.sap.isDeclared('sap.ui.dt.OverlayRegistry') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides object sap.ui.dt.OverlayRegistry.
jQuery.sap.declare('sap.ui.dt.OverlayRegistry'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.ui.core.Element'); // unlisted dependency retained
sap.ui.define("sap/ui/dt/OverlayRegistry",[
	"sap/ui/core/Element",
	"sap/ui/dt/ElementUtil"
],
function(Element, ElementUtil) {
	"use strict";

	/**
	 * Class for OverlayRegistry.
	 *
	 * @class
	 * Static registry for Overlays
	 *
	 * @author SAP SE
	 * @version 1.42.6
	 *
	 * @private
	 * @static
	 * @since 1.30
	 * @alias sap.ui.dt.OverlayRegistry
	 * @experimental Since 1.30. This class is experimental and provides only limited functionality. Also the API might be changed in future.
	 */

	var OverlayRegistry = {};

	var mOverlays = {};

	/**
	 * Returns a registered Overlay by element instance or id
	 * @param {string|sap.ui.core.Element} vElementOrId element instance or id
	 * @return {sap.ui.dt.Overlay} found overlay or undefined
	 * @public
	 */
	OverlayRegistry.getOverlay = function(vElementOrId) {
		var oElement = ElementUtil.getElementInstance(vElementOrId);
		if (oElement) {
			oElement = ElementUtil.fixComponentContainerElement(oElement);
			oElement = ElementUtil.fixComponentParent(oElement);
			if (oElement) {
				var sId = oElement.getId();
				return mOverlays[sId];
			}
		}
	};

	/**
	 * Registers an overlay for the element or element's id
	 * @param {string|sap.ui.core.Element} vElementOrId element instance or id
	 * @param {sap.ui.dt.Overlay} oOverlay overlay to register
	 * @public
	 */
	OverlayRegistry.register = function(vElementOrId, oOverlay) {
		var sId = getElementId(vElementOrId);
		mOverlays[sId] = oOverlay;
	};

	/**
	 * Deregisters an overlay for the given element or element's id
	 * @param {string|sap.ui.core.Element} vElementOrId element instance or id
	 * @public
	 */
	OverlayRegistry.deregister = function(vElementOrId) {
		var sId = getElementId(vElementOrId);
		delete mOverlays[sId];
	};

	/**
	 * Returns whether any overlay is registered in registry
	 * @return {boolean} whether any overlay is registered in registry
	 * @public
	 */
	OverlayRegistry.hasOverlays = function() {
		return !jQuery.isEmptyObject(mOverlays);
	};

	function getElementId (vElementOrId) {
		return (vElementOrId instanceof Element) ? vElementOrId.getId() : vElementOrId;
	}

	return OverlayRegistry;
}, /* bExport= */ true);

}; // end of sap/ui/dt/OverlayRegistry.js
if ( !jQuery.sap.isDeclared('sap.ui.dt.OverlayUtil') ) {
/*
 * ! UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides object sap.ui.dt.OverlayUtil.
jQuery.sap.declare('sap.ui.dt.OverlayUtil'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/dt/OverlayUtil",[
	'jquery.sap.global', 'sap/ui/dt/OverlayRegistry', 'sap/ui/dt/ElementUtil'
], function(jQuery, OverlayRegistry, ElementUtil) {
	"use strict";

	/**
	 * Class for Overlay Util.
	 *
	 * @class Utility functionality to work with overlays
	 * @author SAP SE
	 * @version 1.42.6
	 * @private
	 * @static
	 * @since 1.30
	 * @alias sap.ui.dt.OverlayUtil
	 * @experimental Since 1.30. This class is experimental and provides only limited functionality. Also the API might be changed in future.
	 */

	var OverlayUtil = {};

	/**
	 *
	 */
	OverlayUtil.isInTargetZoneAggregation = function(oElementOverlay) {
		var oAggregationOverlay = oElementOverlay.getParent();
		return oAggregationOverlay && oAggregationOverlay.isTargetZone && oAggregationOverlay.isTargetZone();
	};

	/**
	 * Returns an object with public parent, aggregation in public parent and direct index
	 */
	OverlayUtil.getParentInformation = function(oElementOverlay) {
		var oParentOverlay = oElementOverlay.getParentElementOverlay();
		if (oParentOverlay){
			//calculate index in direct (maybe in hidden tree) parent
			var oParent = oParentOverlay.getElementInstance();
			var sParentAggregationName = oElementOverlay.getParentAggregationOverlay().getAggregationName();
			var aChildren = ElementUtil.getAggregation(oParent, sParentAggregationName);
			var oElement = oElementOverlay.getElementInstance();
			var iIndex = aChildren.indexOf(oElement);

			var oPublicParentOverlay = oElementOverlay.getPublicParentElementOverlay();

			return {
				publicParent : oPublicParentOverlay.getElementInstance(),
				publicAggregation: oElementOverlay.getPublicParentAggregationOverlay().getAggregationName(),
				parent: oParent,
				aggregation : sParentAggregationName,
				index: iIndex
			};
		} else {
			return {
				publicParent : null,
				publicAggregation : "",
				parent: null,
				aggregation: "",
				index: -1
			};
		}

	};

	/**
	 *
	 */
	OverlayUtil.getClosestOverlayFor = function(oElement) {
		if (!oElement) {
			return null;
		}

		var oParent = oElement;
		var oParentOverlay = OverlayRegistry.getOverlay(oParent);
		while (oParent && !oParentOverlay) {
			oParent = oParent.getParent();
			oParentOverlay = OverlayRegistry.getOverlay(oParent);
		}

		return oParentOverlay;
	};

	/**
	 *
	 */
	OverlayUtil.getGeometry = function(aGeometry) {
		var minLeft, maxRight, minTop, maxBottom;
		aGeometry.forEach(function(oElementGeometry) {
			if (oElementGeometry) {
				if (!minLeft || oElementGeometry.position.left < minLeft) {
					minLeft = oElementGeometry.position.left;
				}
				if (!minTop || oElementGeometry.position.top < minTop) {
					minTop = oElementGeometry.position.top;
				}

				var iRight = oElementGeometry.position.left + oElementGeometry.size.width;
				if (!maxRight || iRight > maxRight) {
					maxRight = iRight;
				}
				var iBottom = oElementGeometry.position.top + oElementGeometry.size.height;
				if (!maxBottom || iBottom > maxBottom) {
					maxBottom = iBottom;
				}
			}
		});

		if (typeof minLeft === "number") {
			return {
				size: {
					width: maxRight - minLeft,
					height: maxBottom - minTop
				},
				position: {
					left: minLeft,
					top: minTop
				},
				visible : true
			};
		}
	};

	/**
	 *
	 */
	OverlayUtil.getClosestOverlayForType = function(sType, oOverlay) {
		while (oOverlay && !ElementUtil.isInstanceOf(oOverlay.getElementInstance(), sType)) {
			oOverlay = oOverlay.getParentElementOverlay();
		}

		return oOverlay;
	};

	/**
	 *
	 */
	OverlayUtil.getClosestScrollable = function(oOverlay) {
		if (!oOverlay) {
			return;
		}

		oOverlay = oOverlay.getParent();
		while (oOverlay && oOverlay.isScrollable && !oOverlay.isScrollable()) {
			oOverlay = oOverlay.getParent();
		}

		return oOverlay && oOverlay.isScrollable ? oOverlay : null;
	};

	/**
	 *
	 */
	OverlayUtil.getFirstChildOverlay = function(oOverlay) {
		if (!oOverlay) {
			return;
		}

		var aAggregationOverlays = oOverlay.getAggregationOverlays();
		if (aAggregationOverlays.length > 0) {
			for (var i = 0; i < aAggregationOverlays.length; i++) {
				var oAggregationOverlay = aAggregationOverlays[i];
				var aChildren = oAggregationOverlay.getChildren();
				if (aChildren.length) {
					return aChildren[0];
				}
			}
		}
	};

	/**
	 *
	 */
	OverlayUtil.getLastChildOverlay = function(oOverlay) {
		if (!oOverlay) {
			return;
		}

		var aAggregationOverlays = oOverlay.getAggregationOverlays();
		if (aAggregationOverlays.length > 0) {
			for (var i = aAggregationOverlays.length - 1; i >= 0; i--) {
				var oAggregationOverlay = aAggregationOverlays[i];
				var aChildren = oAggregationOverlay.getChildren();
				if (aChildren.length) {
					return aChildren[aChildren.length - 1];
				}
			}
		}
	};

	/**
	 *
	 */
	OverlayUtil.getNextSiblingOverlay = function(oOverlay) {
		if (!oOverlay) {
			return;
		}

		var oParentAggregationOverlay = oOverlay.getParentAggregationOverlay();
		if (oParentAggregationOverlay) {
			var aAggregationOverlays = oParentAggregationOverlay.getChildren();
			var iIndex = aAggregationOverlays.indexOf(oOverlay);
			// get next sibling in the same aggregation
			if (iIndex !== aAggregationOverlays.length - 1) {
				return aAggregationOverlays[iIndex + 1];
			} else {
				// get next sibling from next aggregation in the same parent
				if (iIndex === aAggregationOverlays.length - 1) {
					var oParent = oOverlay.getParentElementOverlay();
					aAggregationOverlays = oParent.getAggregationOverlays();
					for (iIndex = aAggregationOverlays.indexOf(oParentAggregationOverlay) + 1; iIndex < aAggregationOverlays.length; iIndex++) {
						var aOverlays = aAggregationOverlays[iIndex].getChildren();
						if (aOverlays.length) {
							return aOverlays[0];
						}
					}
				}
			}
		}
	};

	/**
	 *
	 */
	OverlayUtil.getPreviousSiblingOverlay = function(oOverlay) {
		if (!oOverlay) {
			return;
		}

		var oParentAggregationOverlay = oOverlay.getParentAggregationOverlay();
		if (oParentAggregationOverlay) {
			var aAggregationOverlays = oParentAggregationOverlay.getChildren();
			var iIndex = aAggregationOverlays.indexOf(oOverlay);
			// get previous sibling from the same aggregation
			if (iIndex > 0) {
				return aAggregationOverlays[iIndex - 1];
			} else {
				// get previous sibling from previous aggregation in the same parent
				if (iIndex === 0) {
					var oParent = oOverlay.getParentElementOverlay();
					aAggregationOverlays = oParent.getAggregationOverlays();
					for (iIndex = aAggregationOverlays.indexOf(oParentAggregationOverlay) - 1; iIndex >= 0; iIndex--) {
						var aOverlays = aAggregationOverlays[iIndex].getChildren();
						if (aOverlays.length) {
							return aOverlays[aOverlays.length - 1];
						}
					}
				}
			}
		}
	};

	/**
	 *
	 */
	OverlayUtil.getNextOverlay = function(oOverlay) {
		if (!oOverlay) {
			return;
		}

		var oFirstChildOverlay = this.getFirstChildOverlay(oOverlay);
		if (oFirstChildOverlay) {
			return oFirstChildOverlay;
		}

		var oNextSiblingOverlay = this.getNextSiblingOverlay(oOverlay);
		if (oNextSiblingOverlay) {
			return oNextSiblingOverlay;
		}

		do {
			oOverlay = oOverlay.getParentElementOverlay();
			oNextSiblingOverlay = this.getNextSiblingOverlay(oOverlay);
		} while (oOverlay && !oNextSiblingOverlay);

		return oNextSiblingOverlay;
	};

	/**
	 *
	 */
	OverlayUtil.getPreviousOverlay = function(oOverlay) {
		if (!oOverlay) {
			return;
		}

		var oParentAggregationOverlay = oOverlay.getParentAggregationOverlay();
		if (!oParentAggregationOverlay) {
			return;
		}

		var oPreviousSiblingOverlay = this.getPreviousSiblingOverlay(oOverlay);
		if (oPreviousSiblingOverlay) {
			var oLastChildOverlay = oPreviousSiblingOverlay;
			do {
				oPreviousSiblingOverlay = oLastChildOverlay;
				oLastChildOverlay = this.getLastChildOverlay(oPreviousSiblingOverlay);
			} while (oLastChildOverlay);

			return oPreviousSiblingOverlay;
		}

		return oOverlay.getParentElementOverlay();
	};

	/**
	 *
	 */
	OverlayUtil.getRootOverlay = function(oOverlay) {
		var oParentOverlay = oOverlay;
		do {
			oOverlay = oParentOverlay;
			oParentOverlay = oOverlay.getParentElementOverlay();
		} while (oParentOverlay);

		return oOverlay;
	};

	/**
	 *
	 */
	OverlayUtil.iterateOverlayElementTree = function(oElementOverlay, fnCallback) {
		var that = this;

		fnCallback(oElementOverlay);

		oElementOverlay.getAggregationOverlays().forEach(function(oAggregationOverlay) {
			oAggregationOverlay.getChildren().forEach(function(oChildOverlay) {
				that.iterateOverlayElementTree(oChildOverlay, fnCallback);
			});
		});
	};

	/**
	 *
	 */
	OverlayUtil.iterateOverlayTree = function(oOverlay, fnCallback) {
		var that = this;

		fnCallback(oOverlay);

		oOverlay.getChildren().forEach(function(oChildOverlay) {
			that.iterateOverlayTree(oChildOverlay, fnCallback);
		});
	};


	/**
	 *
	 */
	OverlayUtil.isInOverlayContainer = function(oNode) {
		if (oNode && jQuery(oNode).closest(".sapUiDtOverlay, #overlay-container").length) {
			return true;
		}
	};

	/**
	 *
	 */
	OverlayUtil.getClosestOverlayForNode = function(oNode) {
		var oElement = ElementUtil.getClosestElementForNode(oNode);
		return OverlayUtil.getClosestOverlayFor(oElement);
	};

	return OverlayUtil;
}, /* bExport= */true);

}; // end of sap/ui/dt/OverlayUtil.js
if ( !jQuery.sap.isDeclared('sap.ui.dt.Plugin') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides class sap.ui.dt.Plugin.
jQuery.sap.declare('sap.ui.dt.Plugin'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.ui.base.ManagedObject'); // unlisted dependency retained
sap.ui.define("sap/ui/dt/Plugin",[
	'sap/ui/base/ManagedObject'
],
function(ManagedObject) {
	"use strict";

	/**
	 * Constructor for a new Plugin.
	 *
	 * @param {string} [sId] id for the new object, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new object
	 *
	 * @class
	 * The Plugin allows to handle the overlays and aggregation overlays from the DesignTime
	 * The Plugin should be overriden by the real plugin implementations, which define some actions through events attached to an overlays
	 * @extends sap.ui.core.ManagedObject
	 *
	 * @author SAP SE
	 * @version 1.42.6
	 *
	 * @constructor
	 * @private
	 * @since 1.30
	 * @alias sap.ui.dt.Plugin
	 * @experimental Since 1.30. This class is experimental and provides only limited functionality. Also the API might be changed in future.
	 */

	var Plugin = ManagedObject.extend("sap.ui.dt.Plugin", /** @lends sap.ui.dt.Plugin.prototype */ {
		metadata : {
			"abstract" : true,
			// ---- object ----

			// ---- control specific ----
			library : "sap.ui.dt",
			properties : {
				/**
				 * DesignTime where this plugin will be used
				 */
				designTime : { // its defined as a property because spa.ui.dt.designTime is a managed object and UI5 only allows associations for elements
					type : "sap.ui.dt.DesignTime",
					multiple : false
				},

				commandFactory : {
					type : "sap.ui.dt.command.CommandFactory",
					multiple : false
				}
			},
			associations : {
			},
			events : {
				elementModified : {
					command : {
						type : "sap.ui.dt.command.BaseCommand"
					}
				}
			}
		}
	});

	/**
	 * Called when the Plugin is initialized
	 * @protected
	 */
	Plugin.prototype.init = function() {};

	/**
	 * Called when the Plugin is destroyed
	 * @protected
	 */
	Plugin.prototype.exit = function() {
		this.setDesignTime(null);
	};

	/**
	 * Function is called initially for every overlay in the DesignTime and then when any new overlay is created inside of the DesignTime
	 * This function should be overriden by the plugins to handle the overlays (attach events and etc.)
	 * @function
	 * @name sap.ui.dt.Plugin.prototype.registerElementOverlay
	 * @param {sap.ui.dt.ElementOverlay} an oElementOverlay which should be registered
	 * @protected
	 */
	// Plugin.prototype.registerElementOverlay = function(oElementOverlay) {};

	/**
	 * Function is called for every overlay in the DesignTime when the Plugin is deactivated.
	 * This function should be overriden by the plugins to rollback the registration and cleanup attached event etc.
	 * @function
	 * @name sap.ui.dt.Plugin.prototype.deregisterElementOverlay
	 * @param {sap.ui.dt.ElementOverlay} an oElementOverlay which should be deregistered
	 * @protected
	 */
	// Plugin.prototype.deregisterElementOverlay = function(oElementOverlay) {};

	/**
	 * Function is called initially for every aggregation overlay in the DesignTime and then when any new aggregation overlay is created inside of the DesignTime
	 * This function should be overriden by the plugins to handle the aggregation overlays (attach events and etc.)
	 * @function
	 * @name sap.ui.dt.Plugin.prototype.registerAggregationOverlay
	 * @param {sap.ui.dt.AggregationOverlay} oAggregationOverlay which should be registered
	 * @protected
	 */
	// Plugin.prototype.registerAggregationOverlay = function(oAggregationOverlay) {};

	/**
	 * Function is called for every aggregation overlay in the DesignTime when the Plugin is deactivated.
	 * This function should be overriden by the plugins to rollback the registration and cleanup attached event etc.
	 * @function
	 * @name sap.ui.dt.Plugin.prototype.deregisterAggregationOverlay
	 * @param {sap.ui.dt.AggregationOverlay} oAggregationOverlay which should be deregistered
	 * @protected
	 */
	// Plugin.prototype.deregisterAggregationOverlay = function(oAggregationOverlay) {};

	/**
	 * Sets a DesignTime, where the plugin should be used. Automatically called by "addPlugin" into DesignTime
	 * @param {sap.ui.dt.DesignTime} oDesignTime to set
	 * @return {sap.ui.dt.Plugin} returns this
	 * @public
	 */
	Plugin.prototype.setDesignTime = function(oDesignTime) {
		var oOldDesignTime = this.getDesignTime();
		if (oOldDesignTime) {
			this._deregisterOverlays(oOldDesignTime);
			oOldDesignTime.detachEvent("elementOverlayCreated", this._onElementOverlayCreated, this);
		}

		this.setProperty("designTime", oDesignTime);

		if (oDesignTime) {
			this._registerOverlays(oDesignTime);

			oDesignTime.attachEvent("elementOverlayCreated", this._onElementOverlayCreated, this);
		}

		return this;
	};

	/**
	 * @param {sap.ui.dt.DesignTime} oDesignTime to register overlays for
	 * @private
	 */
	Plugin.prototype._registerOverlays = function(oDesignTime) {
		if (this.registerElementOverlay || this.registerAggregationOverlay) {
			var aElementOverlays = oDesignTime.getElementOverlays();
			aElementOverlays.forEach(this._callElementOverlayRegistrationMethods.bind(this));
		}
	};

	/**
	 * @param {sap.ui.dt.DesignTime} oDesignTime to register overlays for
	 * @private
	 */
	Plugin.prototype._deregisterOverlays = function(oDesignTime) {
		if (this.deregisterElementOverlay || this.deregisterAggregationOverlay) {
			var aOverlays = oDesignTime.getElementOverlays();
			aOverlays.forEach(this._callElementOverlayDeregestrationMethods.bind(this));
		}
	};

	/**
	 * @private
	 */
	Plugin.prototype._callAggregationOverlayRegistrationMehods = function(oElementOverlay) {
		if (this.registerAggregationOverlay) {
			var aAggregationOverlays = oElementOverlay.getAggregationOverlays();
			aAggregationOverlays.forEach(this.registerAggregationOverlay.bind(this));
		}
	};

	/**
	 * @param {sap.ui.dt.Overlay} oElementOverlay to call registration methods for
	 * @private
	 */
	Plugin.prototype._callElementOverlayRegistrationMethods = function(oElementOverlay) {
		if (this.registerElementOverlay) {
			this.registerElementOverlay(oElementOverlay);
		}

		this._callAggregationOverlayRegistrationMehods(oElementOverlay);
	};

	/**
	 * @param {sap.ui.dt.Overlay} oOverlay to callde registration methods for
	 * @private
	 */
	Plugin.prototype._callElementOverlayDeregestrationMethods = function(oElementOverlay) {
		if (this.deregisterElementOverlay) {
			this.deregisterElementOverlay(oElementOverlay);
		}

		if (this.deregisterAggregationOverlay) {
			var aAggregationOverlays = oElementOverlay.getAggregationOverlays();
			aAggregationOverlays.forEach(this.deregisterAggregationOverlay.bind(this));
		}
	};

	/**
	 * @param {sap.ui.baseEvent} oEvent event object
	 * @private
	 */
	Plugin.prototype._onElementOverlayCreated = function(oEvent) {
		var oOverlay = oEvent.getParameter("elementOverlay");

		this._callElementOverlayRegistrationMethods(oOverlay);
	};

	return Plugin;
}, /* bExport= */ true);

}; // end of sap/ui/dt/Plugin.js
if ( !jQuery.sap.isDeclared('sap.ui.dt.RenderingUtil') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides object sap.ui.dt.RenderingUtil.
jQuery.sap.declare('sap.ui.dt.RenderingUtil'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/dt/RenderingUtil",[
	'jquery.sap.global'
],
function(jQuery) {
	"use strict";

	/**
	 * Class for RenderingUtil.
	 *
	 * @class
	 * Utility functionality to work with élements, e.g. iterate through aggregations, find parents, ...
	 *
	 * @author SAP SE
	 * @version 1.42.6
	 *
	 * @private
	 * @static
	 * @since 1.30
	 * @alias sap.ui.dt.RenderingUtil
	 * @experimental Since 1.30. This class is experimental and provides only limited functionality. Also the API might be changed in future.
	 */

	var RenderingUtil = {};

	/**
	 *
	 */
	RenderingUtil.renderOverlay = function(oRm, oOverlay, sClassName) {
		var oGeometry = oOverlay.getGeometry();
		var bGeometryVisible = oGeometry && oGeometry.visible;
		var bRenderOverlay = !oOverlay.getLazyRendering() || bGeometryVisible;

		if (oOverlay.isVisible() && bRenderOverlay) {
			if (oOverlay.getDomRef()) {
				this._triggerOnAfterRenderingWithoutRendering(oRm, oOverlay);

				return;
			}

			oRm.addClass("sapUiDtOverlay");
			oRm.addClass(sClassName);
			oRm.write("<div");
			oRm.writeControlData(oOverlay);
			var sAggregationName = oOverlay.getAggregationName && oOverlay.getAggregationName();
			if (sAggregationName) {
				oRm.write("data-sap-ui-dt-aggregation='" + oOverlay.getAggregationName() + "'");
			} else {
				oRm.write("data-sap-ui-dt-for='" + oOverlay.getElementInstance().getId() + "'");
			}
			oRm.writeClasses();

			oRm.writeStyles();
			oRm.write(">");

			oRm.write("<div");
			oRm.addClass("sapUiDtOverlayChildren");
			oRm.writeClasses();
			oRm.write(">");
			this._renderChildren(oRm, oOverlay);

			oRm.write("</div>");
			oRm.write("</div>");
		}

	};

	/**
	 */
	RenderingUtil._renderChildren = function(oRm, oOverlay) {
		var aChildrenOverlays = oOverlay.getChildren();
		aChildrenOverlays.forEach(function(oChildOverlay) {
			oRm.renderControl(oChildOverlay);
		});
	};

	/**
	 */
	RenderingUtil._triggerOnAfterRenderingWithoutRendering = function(oRm, oOverlay) {
		// to trigger after rendering without renfering we need to write something in a renderManager buffer
		oRm.write("");
		this._renderChildren(oRm, oOverlay);
	};

	return RenderingUtil;
}, /* bExport= */ true);

}; // end of sap/ui/dt/RenderingUtil.js
if ( !jQuery.sap.isDeclared('sap.ui.dt.command.BaseCommand') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare('sap.ui.dt.command.BaseCommand'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.ui.base.ManagedObject'); // unlisted dependency retained
sap.ui.define("sap/ui/dt/command/BaseCommand",['sap/ui/base/ManagedObject'], function(ManagedObject) {
	"use strict";

	/**
	 * Basic implementation for the command pattern.
	 *
	 * @class
	 * @extends sap.ui.base.ManagedObject
	 *
	 * @author SAP SE
	 * @version 1.42.6
	 *
	 * @constructor
	 * @private
	 * @since 1.40
	 * @alias sap.ui.dt.command.BaseCommand
	 * @experimental Since 1.40. This class is experimental and provides only limited functionality. Also the API might be
	 *               changed in future.
	 */
	var BaseCommand = ManagedObject.extend("sap.ui.dt.command.BaseCommand", {
		metadata : {
			library : "sap.ui.dt",
			properties : {
				element : {
					type : "sap.ui.core.Element"
				},
				elementId : {
					type : "string"
				},
				name : {
					type : "string"
				}
			},
			associations : {},
			events : {}
		}
	});

	BaseCommand.ERROR_UNKNOWN_ID = "no element for id: ";

	/**
	 * @protected Template Method to implement execute logic, with ensure precondition Element is available
	 */
	BaseCommand.prototype._executeWithElement = function(oElement) {
	};

	BaseCommand.prototype.execute = function() {
		this._withElement(this._executeWithElement.bind(this));
	};

	/**
	 * @protected Template Method to implement undo logic, with ensure precondition Element is available
	 */
	BaseCommand.prototype._undoWithElement = function(oElement) {
	};

	BaseCommand.prototype.undo = function() {
		this._withElement(this._undoWithElement.bind(this));
	};

	BaseCommand.prototype._withElement = function(fn) {
		var oElement = this._getElement();
		if (oElement) {
			fn(oElement);
		} else {
			jQuery.sap.log.error(this.getMetadata().getName(), BaseCommand.ERROR_UNKNOWN_ID + this.getElementId());
		}
	};

	BaseCommand.prototype.serialize = function() {
	};

	BaseCommand.prototype.isEnabled = function() {
		return true;
	};

	BaseCommand.prototype._getElement = function() {
		// Check if Element could be complete virtual property (always created by id)
		var oElement = this.getElement();
		if (!oElement) {
			oElement = sap.ui.getCore().byId(this.getElementId());
			this.setElement(oElement);
		}
		return oElement;
	};

	return BaseCommand;

}, /* bExport= */true);

}; // end of sap/ui/dt/command/BaseCommand.js
if ( !jQuery.sap.isDeclared('sap.ui.dt.command.CommandFactory') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare('sap.ui.dt.command.CommandFactory'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.ui.base.ManagedObject'); // unlisted dependency retained
sap.ui.define("sap/ui/dt/command/CommandFactory",['sap/ui/base/ManagedObject'], function(ManagedObject) {
	"use strict";

	var mCommands = {
		"Move" : {
			findClass : function(oElement, sCommand, mSettings) {
				var oMovedElement = (mSettings && mSettings.movedElements && mSettings.movedElements.length > 0)
						? mSettings.movedElements[0]
						: undefined;
				var oElementToBeAnalyzed = oMovedElement ? oMovedElement.element : oElement;
				var sType = oElementToBeAnalyzed.getMetadata().getName();
				// TODO: this is too unspecific - could also be a 'normal' Form. The context (SImpleFOrm) shall be taken into
				// account
				if (sType === "sap.ui.layout.form.FormContainer" || sType === "sap.ui.layout.form.FormElement") {
					jQuery.sap.require("sap.ui.dt.command.SimpleFormMove");
					return sap.ui.dt.command.SimpleFormMove;
				} else {
					jQuery.sap.require("sap.ui.dt.command.Move");
					return sap.ui.dt.command.Move;
				}
			}
		}
	};

	/**
	 * Factory for commands. Shall handle the control specific command configuration.
	 *
	 * @class
	 * @extends sap.ui.base.ManagedObject
	 *
	 * @author SAP SE
	 * @version 1.42.6
	 *
	 * @constructor
	 * @private
	 * @since 1.40
	 * @alias sap.ui.dt.command.CommandFactory
	 * @experimental Since 1.40. This class is experimental and provides only limited functionality. Also the API might be
	 *               changed in future.
	 */
	var CommandFactory = ManagedObject.extend("sap.ui.dt.command.CommandFactory", {
		metadata : {
			library : "sap.ui.dt",
			properties : {},
			associations : {},
			events : {}
		}
	});

	CommandFactory.getCommandFor = function(oElement, sCommand, mSettings) {
		var mCommand = mCommands[sCommand];
		var Command = mCommand.clazz;
		if (!Command && mCommand.findClass) {
			Command = mCommand.findClass(oElement, sCommand, mSettings);
		}

		mSettings = jQuery.extend(mSettings, {
			element : oElement,
			name : sCommand
		});

		var oCommand = new Command(mSettings);

		return oCommand;
	};

	return CommandFactory;

}, /* bExport= */true);

}; // end of sap/ui/dt/command/CommandFactory.js
if ( !jQuery.sap.isDeclared('sap.ui.dt.command.Move') ) {
/*
 * ! UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare('sap.ui.dt.command.Move'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui
		.define("sap/ui/dt/command/Move",['jquery.sap.global', 'sap/ui/dt/command/BaseCommand', 'sap/ui/dt/ElementUtil'],
				function(jQuery, BaseCommand, ElementUtil) {
					"use strict";

					/**
					 * Move Element from one place to another
					 *
					 * @class
					 * @extends sap.ui.dt.command.BaseCommand
					 * @author SAP SE
					 * @version 1.42.6
					 * @constructor
					 * @private
					 * @since 1.40
					 * @alias sap.ui.dt.command.Move
					 * @experimental Since 1.40. This class is experimental and provides only limited functionality. Also the API
					 *               might be changed in future.
					 */
					var Move = BaseCommand.extend("sap.ui.dt.command.Move", {
						metadata : {
							properties : {
								movedElements : {
									type : "array"
								},
								target : {
									type : "object"
								},
								source : {
									type : "object"
								}
							}
						}
					});

					Move.prototype._executeWithElement = function(oElement) {
						var that = this;
						this.getMovedElements().forEach(function(mMovedElement){
							var mSource = that.getSource();
							var mTarget = that.getTarget();
							ElementUtil.removeAggregation(mSource.parent, mSource.aggregation, mMovedElement.element);
							ElementUtil.insertAggregation(mTarget.parent, mTarget.aggregation, mMovedElement.element, mMovedElement.targetIndex);
						});


					};

					return Move;

				}, /* bExport= */true);

}; // end of sap/ui/dt/command/Move.js
if ( !jQuery.sap.isDeclared('sap.ui.dt.command.SimpleFormMove') ) {
/*
 * ! UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare('sap.ui.dt.command.SimpleFormMove'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui
		.define("sap/ui/dt/command/SimpleFormMove",
				['jquery.sap.global', 'sap/ui/dt/command/BaseCommand', 'sap/ui/dt/ElementUtil'],
				function(jQuery, BaseCommand, ElementUtil) {
					"use strict";

					/**
					 * Move Element from one place to another
					 *
					 * @class
					 * @extends sap.ui.dt.command.BaseCommand
					 * @author SAP SE
					 * @version 1.42.6
					 * @constructor
					 * @private
					 * @since 1.40
					 * @alias sap.ui.dt.command.SimpleFormMove
					 * @experimental Since 1.40. This class is experimental and provides only limited functionality. Also the API
					 *               might be changed in future.
					 */
					var SimpleFormMove = BaseCommand.extend("sap.ui.dt.command.SimpleFormMove", {
						metadata : {
							properties : {
								movedElements : {
									type : "array"
								},
								target : {
									type : "object"
								},
								source : {
									type : "object"
								},
								changeType : {
									type : "string",
									defaultValue : "moveSimpleFormElement"
								},
								action : {
									type : "object"
								}
							}
						}
					});

					SimpleFormMove.prototype._setReverseAction = function(oAction) {
						this._reverseAction = oAction;
					};

					SimpleFormMove.prototype._getReverseAction = function() {
						return (this._reverseAction);
					};

					SimpleFormMove.prototype._executeWithElement = function(oElement) {

						oElement = fnGetSimpleFormContainer(oElement);
						var oAction = this.getAction();

						if (!oAction) {
							var oSimpleForm = oElement;
							var aMovedElements = this.getMovedElements();
							if (aMovedElements.length > 1) {
								jQuery.sap.log.warning("Moving more than 1 Formelement is not yet supported.");
							}
							var oTarget = this.getTarget();

							if (aMovedElements[0].element instanceof sap.ui.layout.form.FormContainer) {
								oAction = fnMoveFormContainer(oSimpleForm, aMovedElements[0], oTarget);
							} else if (aMovedElements[0].element instanceof sap.ui.layout.form.FormElement) {
								oAction = fnMoveFormElement(oSimpleForm, aMovedElements[0], oTarget);
							}
							this.setAction(oAction);
							var oReverseAction = jQuery.extend(true, {}, oAction);
							oReverseAction.source.elements = fnGetAll(sap.ui.getCore().byId(oAction.target.parent), oAction);
							this._setReverseAction(oReverseAction);
						}

						if (oAction) {
							fnExChangeContent(oAction);
						}
					};

					SimpleFormMove.prototype._undoWithElement = function(oElement) {
						fnSwapAction(this);
						this._executeWithElement(oElement);
					};

					var fnGetSimpleFormContainer = function(oElement) {
						if (ElementUtil.isInstanceOf(oElement, "sap.ui.layout.form.SimpleForm")) {
							return oElement;
						} else if (ElementUtil.isInstanceOf(oElement, "sap.ui.layout.form.Form")
								|| ElementUtil.isInstanceOf(oElement, "sap.ui.layout.form.FormContainer")
								|| ElementUtil.isInstanceOf(oElement, "sap.ui.layout.form.FormElement")) {
							return fnGetSimpleFormContainer(oElement.getParent());
						}
					};

					var fnMapFormIndexToContentAggregationIndex = function(oType, aContent, inThInstance) {
						var oResult;
						var iCurrentGroupIndex = -1;
						for (var i = 0; i < aContent.length; i++) {
							if (aContent[i] instanceof oType) {
								iCurrentGroupIndex++;
								if (iCurrentGroupIndex === inThInstance) {
									oResult = aContent[i];
									break;
								}
							}
						}
						return aContent.indexOf(oResult);
					};

					var fnMeasureLengthOfFormContainer = function(oFormContainer) {
						var aFormElements = oFormContainer.getFormElements();
						var iMovedLength = aFormElements.reduce(function(previousValue, currentValue, currentIndex, array) {
							previousValue += currentValue.getFields().length + 1;
							return previousValue;
						}, 1);
						return iMovedLength;
					};

					var fnExtractElementIds = function(aComponents) {
						var aResult = [];
						for (var i = 0; i < aComponents.length; i++) {
							aResult.push(aComponents[i].getId());
						}
						return aResult;
					};

					var fnArrayRangeCopy = function(aSource, iSourceIndex, aTarget, iTargetIndex, iMovedLength) {
						var aResult = aTarget;
						for (var i = 0; i < iMovedLength; i++) {
							aResult.splice(iTargetIndex + i, 0, aSource[iSourceIndex + i]);
						}
						return aResult;
					};

					var fnCreateReorderAction = function(oParent, aElements) {
						return {
							changeType : 'reorder_aggregation',
							source : {
								elements : aElements
							},
							target : {
								parent : oParent,
								aggregation : 'content'
							}
						};
					};

					var fnMoveFormContainer = function(oSimpleForm, mMovedElement, oTarget) {
						var aContent = oSimpleForm.getContent();
						var oMovedGroupTitle = mMovedElement.element.getTitle();
						var iMovedGroupIndex = aContent.indexOf(oMovedGroupTitle);

						var iTargetIndex = fnMapFormIndexToContentAggregationIndex(sap.ui.core.Title, aContent, mMovedElement.targetIndex);
						var iMovedLength = fnMeasureLengthOfFormContainer(mMovedElement.element);

						var aContentClone = aContent.slice();
						// Cut the moved group from the result array...
						aContentClone.splice(iMovedGroupIndex, iMovedLength);
						// and insert it at the target index
						aContentClone = fnArrayRangeCopy(aContent, iMovedGroupIndex, aContentClone, iTargetIndex, iMovedLength);
						return fnCreateReorderAction(oSimpleForm.getId(), fnExtractElementIds(aContentClone));
					};

					var fnMoveFormElement = function(oSimpleForm, mMovedElement, oTarget) {

						var aContent = oSimpleForm.getContent();
						var aFormElementsWithinTargetContainer = oTarget.parent.getFormElements();

						var iSourceIndex = aContent.indexOf(mMovedElement.element.getLabel());
						//use target index as the internal controls have already been modified
						var iSourceLength = aFormElementsWithinTargetContainer[mMovedElement.targetIndex].getFields().length + 1;

						var iTargetIndex = aContent.indexOf(oTarget.parent.getTitle());
						if (iTargetIndex > iSourceIndex) {
							iTargetIndex = iTargetIndex - iSourceLength;
						}
						// measure length of all elements before insert point
						var iOffset = 0;
						for (var k = 0; k < mMovedElement.targetIndex; k++) {
							iOffset = iOffset + aFormElementsWithinTargetContainer[k].getFields().length + 1;
						}
						iTargetIndex = iTargetIndex + iOffset + 1;

						// Copy the content
						var aContentClone = aContent.slice();
						// Cut the moved group from the result array...
						aContentClone.splice(iSourceIndex, iSourceLength);
						// and insert it at the target index
						aContentClone = fnArrayRangeCopy(aContent, iSourceIndex, aContentClone, iTargetIndex, iSourceLength);
						return fnCreateReorderAction(oSimpleForm.getId(), fnExtractElementIds(aContentClone));
					};

					var fnGetAll = function(oTargetParent, oAction) {
						var sAggregationGetAllMutator = ElementUtil.getAggregationAccessors(oTargetParent,
								oAction.target.aggregation).get;
						return fnExtractElementIds(oTargetParent[sAggregationGetAllMutator]());
					};

					var fnRemoveAll = function(oTargetParent, oAction) {
						var sAggregationRemoveAllMutator = ElementUtil.getAggregationAccessors(oTargetParent,
								oAction.target.aggregation).removeAll;
						oTargetParent[sAggregationRemoveAllMutator]();
					};

					var fnAddAll = function(oTargetParent, oAction) {
						var sAggregationAddMutator = ElementUtil.getAggregationAccessors(oTargetParent, oAction.target.aggregation).add;
						var oActElement;
						for (var j = 0; j < oAction.source.elements.length; j++) {
							oActElement = sap.ui.getCore().byId(oAction.source.elements[j]);
							oTargetParent[sAggregationAddMutator](oActElement);
						}
					};

					var fnExChangeContent = function(oAction) {
						var oTargetParent = sap.ui.getCore().byId(oAction.target.parent);
						fnRemoveAll(oTargetParent, oAction);
						fnAddAll(oTargetParent, oAction);
					};

					// swap action with its reverse action, so a client can always get the actual action by calling 'getAction'
					var fnSwapAction = function(oContext) {
						var oTmp = oContext._getReverseAction();
						oContext._setReverseAction(oContext.getAction());
						oContext.setAction(oTmp);
					};

					return SimpleFormMove;

				}, /* bExport= */true);

}; // end of sap/ui/dt/command/SimpleFormMove.js
if ( !jQuery.sap.isDeclared('sap.ui.dt.library') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/**
 * Initialization Code and shared classes of library sap.ui.dt.
 */
jQuery.sap.declare('sap.ui.dt.library'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.library'); // unlisted dependency retained
sap.ui.define("sap/ui/dt/library",[
    'jquery.sap.global',
	'sap/ui/core/library'
], // library dependency
function(jQuery) {

	"use strict";

	/**
	 * DesignTime library.
	 *
	 * @namespace
	 * @name sap.ui.dt
	 * @author SAP SE
	 * @version 1.42.6
	 * @private
	 */

	// delegate further initialization of this library to the Core
	sap.ui.getCore().initLibrary({
		name : "sap.ui.dt",
		version: "1.42.6",
		dependencies : ["sap.ui.core"],
		types: [
			"sap.ui.dt.SelectionMode"
		],
		interfaces: [],
		controls: [],
		elements: []
	});

	/**
	 * Selection mode of the tree
	 *
	 * @enum {string}
	 * @private
	 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
	 */
	sap.ui.dt.SelectionMode = {

		/**
		 * Select multiple overlays at a time.
		 * @public
		 */
		Multi : "Multi",

		/**
		 * Select one overlay at a time.
		 * @public
		 */
		Single : "Single"

	};

	return sap.ui.dt;

}, /* bExport= */ true);

}; // end of sap/ui/dt/library.js
if ( !jQuery.sap.isDeclared('sap.ui.dt.plugin.DragDrop') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides class sap.ui.dt.plugin.DragDrop.
jQuery.sap.declare('sap.ui.dt.plugin.DragDrop'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
sap.ui.define("sap/ui/dt/plugin/DragDrop",[
	'sap/ui/dt/Plugin',
	'sap/ui/dt/DOMUtil',
	'sap/ui/dt/OverlayUtil',
	'sap/ui/dt/ElementUtil'
],
function(Plugin, DOMUtil, OverlayUtil, ElementUtil) {
	"use strict";

	/**
	 * Constructor for a new DragDrop.
	 *
	 * @param {string} [sId] id for the new object, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new object
	 *
	 * @class
	 * The DragDrop plugin is an abstract plugin to enable drag and drop functionality of the Overlays
	 * This Plugin should be overwritten by the D&D plugin implementations, the abstract functions should be used to perform actions
	 * @extends sap.ui.dt.plugin.Plugin
	 *
	 * @author SAP SE
	 * @version 1.42.6
	 *
	 * @constructor
	 * @private
	 * @since 1.30
	 * @alias sap.ui.dt.plugin.DragDrop
	 * @experimental Since 1.30. This class is experimental and provides only limited functionality. Also the API might be changed in future.
	 */
	var DragDrop = Plugin.extend("sap.ui.dt.plugin.DragDrop", /** @lends sap.ui.dt.plugin.DragDrop.prototype */ {
		metadata : {
			"abstract" : true,
			// ---- object ----

			// ---- control specific ----
			library : "sap.ui.dt",
			properties : {
			},
			associations : {
			},
			events : {
			}
		}
	});

	/*
	 * @private
	 */
	DragDrop.prototype.init = function() {
		Plugin.prototype.init.apply(this, arguments);

		this._mElementOverlayDelegate = {
			"onAfterRendering" : this._checkMovable
		};

		this._mAggregationOverlayDelegate = {
			"onAfterRendering" : this._attachDragScrollHandler,
			"onBeforeRendering" : this._removeDragScrollHandler
		};

		this._dragScrollHandler = this._dragScroll.bind(this);
		this._dragLeaveHandler = this._dragLeave.bind(this);
		this._mScrollIntervals = {};
	};


	/*
	 * @private
	 */
	DragDrop.prototype.exit = function() {
		Plugin.prototype.exit.apply(this, arguments);

		delete this._mElementOverlayDelegate;
		delete this._mAggregationOverlayDelegate;
		delete this._dragScrollHandler;
	};

	/**
	 * @override
	 * @param {sap.ui.dt.Overlay} an Overlay which should be registered
	 */
	DragDrop.prototype.registerElementOverlay = function(oOverlay) {
		oOverlay.addEventDelegate(this._mElementOverlayDelegate, this);

		oOverlay.attachEvent("movableChange", this._onMovableChange, this);

		if (oOverlay.isMovable()) {
			this._attachDragEvents(oOverlay);
		}

		oOverlay.attachBrowserEvent("dragover", this._onDragOver, this);
		oOverlay.attachBrowserEvent("dragenter", this._onDragEnter, this);
	};


	/**
	 * @override
	 */
	DragDrop.prototype.registerAggregationOverlay = function(oAggregationOverlay) {
		oAggregationOverlay.attachTargetZoneChange(this._onAggregationTargetZoneChange, this);

		if (!sap.ui.Device.browser.webkit) {
			this._attachDragScrollHandler(oAggregationOverlay);
			oAggregationOverlay.addEventDelegate(this._mAggregationOverlayDelegate, this);
		}
	};

	/**
	 * @override
	 */
	DragDrop.prototype.deregisterElementOverlay = function(oOverlay) {
		oOverlay.removeEventDelegate(this._mElementOverlayDelegate, this);

		oOverlay.detachEvent("movableChange", this._onMovableChange, this);

		this._detachDragEvents(oOverlay);

		oOverlay.detachBrowserEvent("dragover", this._onDragOver, this);
		oOverlay.detachBrowserEvent("dragenter", this._onDragEnter, this);

	};

	/**
	 * @override
	 */
	DragDrop.prototype.deregisterAggregationOverlay = function(oAggregationOverlay) {
		oAggregationOverlay.detachTargetZoneChange(this._onAggregationTargetZoneChange, this);

		if (!sap.ui.Device.browser.webkit) {
			oAggregationOverlay.removeEventDelegate(this._mAggregationOverlayDelegate, this);
			this._removeDragScrollHandler(oAggregationOverlay);
			this._clearScrollIntervalFor(oAggregationOverlay.$().attr("id"));
		}
	};

	/**
	 * @private
	 * @param {sap.ui.dt.Overlay} an Overlay to attach events to
	 */
	DragDrop.prototype._attachDragEvents = function(oOverlay) {
		oOverlay.attachBrowserEvent("dragstart", this._onDragStart, this);
		oOverlay.attachBrowserEvent("drag", this._onDrag, this);
		oOverlay.attachBrowserEvent("dragend", this._onDragEnd, this);
	};

	/**
	 * @private
	 * @param {sap.ui.dt.Overlay} an Overlay to detach events from
	 */
	DragDrop.prototype._detachDragEvents = function(oOverlay) {
		oOverlay.detachBrowserEvent("dragstart", this._onDragStart, this);
		oOverlay.detachBrowserEvent("dragend", this._onDragEnd, this);
		oOverlay.detachBrowserEvent("drag", this._onDrag, this);
	};

	/**
	 * @protected
	 */
	DragDrop.prototype.onMovableChange = function(oEvent) { };

	/**
	 * @protected
	 */
	DragDrop.prototype.onDragStart = function(oDraggedOverlay, oEvent) { };

	/**
	 * @protected
	 */
	DragDrop.prototype.onDragEnd = function(oDraggedOverlay, oEvent) { };

	/**
	 * @protected
	 */
	DragDrop.prototype.onDrag = function(oDraggedOverlay, oEvent) { };

	/**
	 * @return {boolean} return true to omit event.preventDefault
	 * @protected
	 */
	DragDrop.prototype.onDragEnter = function(oOverlay, oEvent) { };

	/**
	 * @return {boolean} return true to omit event.preventDefault
	 * @protected
	 */
	DragDrop.prototype.onDragOver = function(oOverlay, oEvent) { };

	/**
	 * @protected
	 */
	DragDrop.prototype.onAggregationDragEnter = function(oAggregationOverlay, oEvent) { };

	/**
	 * @protected
	 */
	DragDrop.prototype.onAggregationDragOver = function(oAggregationOverlay, oEvent) { };

	/**
	 * @protected
	 */
	DragDrop.prototype.onAggregationDragLeave = function(oAggregationOverlay, oEvent) { };

	/**
	 * @protected
	 */
	DragDrop.prototype.onAggregationDrop = function(oAggregationOverlay, oEvent) { };

	/**
	 * @private
	 */
	DragDrop.prototype._checkMovable = function(oEvent) {
		var oOverlay = oEvent.srcControl;
		if (oOverlay.isMovable()) {
			DOMUtil.setDraggable(oOverlay.$(), true);
		}
	};

	/**
	 * @private
	 */
	DragDrop.prototype._onMovableChange = function(oEvent) {
		var oOverlay = oEvent.getSource();
		if (oOverlay.isMovable()) {
			this._attachDragEvents(oOverlay);
		} else {
			this._detachDragEvents(oOverlay);
		}

		this.onMovableChange(oOverlay, oEvent);
	};

	/**
	 * @private
	 */
	DragDrop.prototype._onDragStart = function(oEvent) {
		var oOverlay = sap.ui.getCore().byId(oEvent.currentTarget.id);

		oEvent.stopPropagation();

		// Fix for Firfox - Firefox only fires drag events when data is set
		if (sap.ui.Device.browser.firefox && oEvent && oEvent.originalEvent && oEvent.originalEvent.dataTransfer && oEvent.originalEvent.dataTransfer.setData) {
			oEvent.originalEvent.dataTransfer.setData('text/plain', '');
		}

		this.showGhost(oOverlay, oEvent);
		this.onDragStart(oOverlay, oEvent);
	};

	/**
	 * @protected
	 */
	DragDrop.prototype.showGhost = function(oOverlay, oEvent) {
		var that = this;

		// IE and Edge do no support dataTransfer.setDragImage on D&D event
		if (!sap.ui.Device.browser.internet_explorer && !sap.ui.Device.browser.edge && !sap.ui.Device.browser.msie &&
			oEvent && oEvent.originalEvent && oEvent.originalEvent.dataTransfer && oEvent.originalEvent.dataTransfer.setDragImage) {
			this._$ghost = this.createGhost(oOverlay, oEvent);

			// ghost should be visible to set it as dragImage
			this._$ghost.appendTo("#overlay-container");
			// if ghost will be removed without timeout, setDragImage won't work
			setTimeout(function() {
				that._removeGhost();
			}, 0);
			oEvent.originalEvent.dataTransfer.setDragImage(
				this._$ghost.get(0),
				oEvent.originalEvent.pageX - oOverlay.$().offset().left,
				oEvent.originalEvent.pageY - oOverlay.$().offset().top
			);
		}
	};

	/**
	 * @private
	 */
	DragDrop.prototype._removeGhost = function() {
		this.removeGhost();
		delete this._$ghost;
	};

	/**
	 * @protected
	 */
	DragDrop.prototype.removeGhost = function() {
		var $ghost = this.getGhost();
		if ($ghost) {
			$ghost.remove();
		}
	};

	/**
	 * @protected
	 */
	DragDrop.prototype.createGhost = function(oOverlay) {
		var oGhostDom = oOverlay.getAssociatedDomRef();
		var $ghost;
		if (!oGhostDom) {
			oGhostDom = this._getAssociatedDomCopy(oOverlay);
			$ghost = jQuery(oGhostDom);
		} else {
			$ghost = jQuery("<div></div>");
			DOMUtil.cloneDOMAndStyles(oGhostDom, $ghost);
		}

		var $ghostWrapper = jQuery("<div></div>").addClass("sapUiDtDragGhostWrapper");
		return $ghostWrapper.append($ghost.addClass("sapUiDtDragGhost"));
	};

	/**
	 * @private
	 */
	DragDrop.prototype._getAssociatedDomCopy = function(oOverlay) {
		var that = this;

		var $DomCopy = jQuery("<div></div>");

		oOverlay.getAggregationOverlays().forEach(function(oAggregationOverlay) {
			oAggregationOverlay.getChildren().forEach(function(oChildOverlay) {
				var oChildDom = oChildOverlay.getAssociatedDomRef();
				if (oChildDom) {
					DOMUtil.cloneDOMAndStyles(oChildDom, $DomCopy);
				} else {
					DOMUtil.cloneDOMAndStyles(that._getAssociatedDomCopy(oChildOverlay), $DomCopy);
				}
			});
		});

		return $DomCopy.get(0);
	};

	/**
	 * @protected
	 * @return {jQuery} jQuery object drag ghost
	 */
	DragDrop.prototype.getGhost = function() {
		return this._$ghost;
	};


	/**
	 * @private
	 */
	DragDrop.prototype._onDragEnd = function(oEvent) {
		var oOverlay = sap.ui.getCore().byId(oEvent.currentTarget.id);
		this._removeGhost();

		this._clearAllScrollIntervals();
		this.onDragEnd(oOverlay, oEvent);

		oEvent.stopPropagation();
	};

	/**
	 * @private
	 */
	DragDrop.prototype._onDrag = function(oEvent) {
		var oOverlay = sap.ui.getCore().byId(oEvent.currentTarget.id);

		this.onDrag(oOverlay, oEvent);

		oEvent.stopPropagation();
	};

	/**
	 * @private
	 */
	DragDrop.prototype._onDragEnter = function(oEvent) {
		var oOverlay = sap.ui.getCore().byId(oEvent.currentTarget.id);
		if (OverlayUtil.isInTargetZoneAggregation(oOverlay)) {
			//if "true" returned, propagation won't be canceled
			if (!this.onDragEnter(oOverlay, oEvent)) {
				oEvent.stopPropagation();
			}
		}

		oEvent.preventDefault();
	};

	/**
	 * @private
	 */
	DragDrop.prototype._onDragOver = function(oEvent) {
		var oOverlay = sap.ui.getCore().byId(oEvent.currentTarget.id);
		if (OverlayUtil.isInTargetZoneAggregation(oOverlay)) {
			//if "true" returned, propagation won't be canceled
			if (!this.onDragOver(oOverlay, oEvent)) {
				oEvent.stopPropagation();
			}
		}

		oEvent.preventDefault();
	};

	/**
	 * @private
	 */
	DragDrop.prototype._onAggregationTargetZoneChange = function(oEvent) {
		var oAggregationOverlay = oEvent.getSource();
		var bTargetZone = oEvent.getParameter("targetZone");

		if (bTargetZone) {
			this._attachAggregationOverlayEvents(oAggregationOverlay);
		} else {
			this._detachAggregationOverlayEvents(oAggregationOverlay);
		}

	};

	/**
	 * @private
	 */
	DragDrop.prototype._attachAggregationOverlayEvents = function(oAggregationOverlay) {

		oAggregationOverlay.attachBrowserEvent("dragenter", this._onAggregationDragEnter, this);
		oAggregationOverlay.attachBrowserEvent("dragover", this._onAggregationDragOver, this);
		oAggregationOverlay.attachBrowserEvent("dragleave", this._onAggregationDragLeave, this);
		oAggregationOverlay.attachBrowserEvent("drop", this._onAggregationDrop, this);
	};

	/**
	 * @private
	 */
	DragDrop.prototype._detachAggregationOverlayEvents = function(oAggregationOverlay) {
		oAggregationOverlay.detachBrowserEvent("dragenter", this._onAggregationDragEnter, this);
		oAggregationOverlay.detachBrowserEvent("dragover", this._onAggregationDragOver, this);
		oAggregationOverlay.detachBrowserEvent("dragleave", this._onAggregationDragLeave, this);
		oAggregationOverlay.detachBrowserEvent("drop", this._onAggregationDrop, this);
	};


	/**
	 * @private
	 */
	DragDrop.prototype._onAggregationDragEnter = function(oEvent) {
		var oAggregationOverlay = sap.ui.getCore().byId(oEvent.currentTarget.id);
		this.onAggregationDragEnter(oAggregationOverlay, oEvent);

		oEvent.preventDefault();
		oEvent.stopPropagation();
	};

	/**
	 * @private
	 */
	DragDrop.prototype._onAggregationDragOver = function(oEvent) {
		var oAggregationOverlay = sap.ui.getCore().byId(oEvent.currentTarget.id);
		this.onAggregationDragOver(oAggregationOverlay, oEvent);

		oEvent.preventDefault();
		oEvent.stopPropagation();
	};

	/**
	 * @private
	 */
	DragDrop.prototype._onAggregationDragLeave = function(oEvent) {
		var oAggregationOverlay = sap.ui.getCore().byId(oEvent.currentTarget.id);
		this.onAggregationDragLeave(oAggregationOverlay, oEvent);

		oEvent.preventDefault();
		oEvent.stopPropagation();
	};

	/**
	 * @private
	 */
	DragDrop.prototype._onAggregationDrop = function(oEvent) {
		var oAggregationOverlay = sap.ui.getCore().byId(oEvent.currentTarget.id);
		this.onAggregationDrop(oAggregationOverlay, oEvent);

		oEvent.stopPropagation();
	};


	/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
	 * Scroll ondrag enablement (only for non-webkit browsers) *
	 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

	var I_SCROLL_TRAP_SIZE = 100;
	var I_SCROLL_STEP = 20;
	var I_SCROLL_INTERVAL = 50;

	/**
	 * @private
	 */
	DragDrop.prototype._clearScrollInterval = function(sElementId, sDirection) {
		if (this._mScrollIntervals[sElementId]) {
			window.clearInterval(this._mScrollIntervals[sElementId][sDirection]);
			delete this._mScrollIntervals[sElementId][sDirection];
		}
	};

	/**
	 * @private
	 */
	DragDrop.prototype._clearScrollIntervalFor = function(sElementId) {
		var that = this;

		if (this._mScrollIntervals[sElementId]) {
			Object.keys(this._mScrollIntervals[sElementId]).forEach(function(sDirection) {
				that._clearScrollInterval(sElementId, sDirection);
			});
		}
	};

	/**
	 * @private
	 */
	DragDrop.prototype._clearAllScrollIntervals = function() {
		Object.keys(this._mScrollIntervals).forEach(this._clearScrollIntervalFor.bind(this));
	};

	/**
	 * @private
	 */
	DragDrop.prototype._checkScroll = function($element, sDirection, iEventOffset) {
		var iSize;
		var fnScrollFunction;
		var iScrollMultiplier = 1;

		if (sDirection === "top" || sDirection === "bottom") {
			iSize = $element.height();
			fnScrollFunction = $element.scrollTop.bind($element);
		} else {
			iSize = $element.width();
			fnScrollFunction = $element.scrollLeft.bind($element);
		}
		if (sDirection === "top" || sDirection === "left") {
			iScrollMultiplier = -1;
		}

		// ensure scroll trap size isn't be bigger then ¼ of the container size
		var iSizeQuarter = Math.floor(iSize / 4);
		var iTrapSize = I_SCROLL_TRAP_SIZE;
		if (iSizeQuarter < I_SCROLL_TRAP_SIZE) {
			iTrapSize = iSizeQuarter;
		}


		if (iEventOffset < iTrapSize) {
			this._mScrollIntervals[$element.attr("id")] = this._mScrollIntervals[$element.attr("id")] || {};
			if (!this._mScrollIntervals[$element.attr("id")][sDirection]) {
				this._mScrollIntervals[$element.attr("id")][sDirection] = window.setInterval(function() {
					var iInitialScrollOffset = fnScrollFunction();
					fnScrollFunction(iInitialScrollOffset + iScrollMultiplier * I_SCROLL_STEP);
				}, I_SCROLL_INTERVAL);
			}
		} else {
			this._clearScrollInterval($element.attr("id"), sDirection);
		}
	};

	/**
	 * @private
	 */
	DragDrop.prototype._dragLeave = function(oEvent) {
		var oAggregationOverlay = sap.ui.getCore().byId(oEvent.currentTarget.id);

		this._clearScrollIntervalFor(oAggregationOverlay.$().attr("id"));
	};

	/**
	 * @private
	 */
	DragDrop.prototype._dragScroll = function(oEvent) {
		var oAggregationOverlay = sap.ui.getCore().byId(oEvent.currentTarget.id);
		var $aggregationOverlay = oAggregationOverlay.$();

		var iDragX = oEvent.clientX;
		var iDragY = oEvent.clientY;

		var oOffset = $aggregationOverlay.offset();
		var iHeight = $aggregationOverlay.height();
		var iWidth = $aggregationOverlay.width();

		var iTop = oOffset.top;
		var iLeft = oOffset.left;
		var iBottom = iTop + iHeight;
		var iRight = iLeft + iWidth;

		this._checkScroll($aggregationOverlay, "bottom", iBottom - iDragY);
		this._checkScroll($aggregationOverlay, "top", iDragY - iTop);
		this._checkScroll($aggregationOverlay, "right", iRight - iDragX);
		this._checkScroll($aggregationOverlay, "left", iDragX - iLeft);
	};

	/**
	 * @private
	 */
	DragDrop.prototype._attachDragScrollHandler = function(oEventOrAggregationOverlay) {
		var oAggregationOverlay;
		if (ElementUtil.isInstanceOf(oEventOrAggregationOverlay, "sap.ui.dt.AggregationOverlay")) {
			oAggregationOverlay = oEventOrAggregationOverlay;
		} else {
			oAggregationOverlay = oEventOrAggregationOverlay.srcControl;
		}

		if (DOMUtil.hasScrollBar(oAggregationOverlay.$())) {
			oAggregationOverlay.getDomRef().addEventListener("dragover", this._dragScrollHandler, true);
			oAggregationOverlay.getDomRef().addEventListener("dragleave", this._dragLeaveHandler, true);
		}
	};

	/**
	 * @private
	 */
	DragDrop.prototype._removeDragScrollHandler = function(oEventOrAggregationOverlay) {
		var oAggregationOverlay;
		if (ElementUtil.isInstanceOf(oEventOrAggregationOverlay, "sap.ui.dt.AggregationOverlay")) {
			oAggregationOverlay = oEventOrAggregationOverlay;
		} else {
			oAggregationOverlay = oEventOrAggregationOverlay.srcControl;
		}

		var oDomRef = oAggregationOverlay.getDomRef();

		if (oDomRef) {
			oDomRef.removeEventListener("dragover", this._dragScrollHandler, true);
		}
	};

	return DragDrop;
}, /* bExport= */ true);

}; // end of sap/ui/dt/plugin/DragDrop.js
if ( !jQuery.sap.isDeclared('sap.ui.dt.plugin.ElementMover') ) {
/*
 * ! UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides class sap.ui.dt.plugin.ElementMover.
jQuery.sap.declare('sap.ui.dt.plugin.ElementMover'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.ui.base.ManagedObject'); // unlisted dependency retained
sap.ui.define("sap/ui/dt/plugin/ElementMover",['sap/ui/base/ManagedObject', 'sap/ui/dt/ElementUtil', 'sap/ui/dt/OverlayUtil',
		'sap/ui/dt/OverlayRegistry', 'sap/ui/dt/command/CommandFactory'], function(ManagedObject, ElementUtil, OverlayUtil,
		OverlayRegistry, CommandFactory) {
	"use strict";

	/**
	 * Constructor for a new ElementMover.
	 *
	 * @param {string}
	 *          [sId] id for the new object, generated automatically if no id is given
	 * @param {object}
	 *          [mSettings] initial settings for the new object
	 * @class The ElementMover enables movement of UI5 elements based on aggregation types, which can be used by drag and
	 *        drop or cut and paste behavior.
	 * @author SAP SE
	 * @version 1.42.6
	 * @constructor
	 * @private
	 * @since 1.34
	 * @alias sap.ui.dt.plugin.ElementMover
	 * @experimental Since 1.34. This class is experimental and provides only limited functionality. Also the API might be
	 *               changed in future.
	 */
	var ElementMover = ManagedObject.extend("sap.ui.dt.plugin.ElementMover", /** @lends sap.ui.dt.plugin.ElementMover.prototype */
	{
		metadata : {
			// ---- object ----

			// ---- control specific ----
			library : "sap.ui.dt",
			properties : {
				commandFactory : {
					type : "object",
					defaultValue : CommandFactory
				},
				movableTypes : {
					type : "string[]",
					defaultValue : ["sap.ui.core.Element"]
				}
			},
			associations : {},
			events : {
				'elementMoved' : {}
			}
		}
	});

	/**
	 * @private
	 */
	ElementMover.prototype._getMovableTypes = function() {
		return this.getProperty("movableTypes") || [];
	};

	/**
	 * Predicate to compute movability of an type
	 * @public
	 * @return true if type is movable, false otherwise
	 */
	ElementMover.prototype.isMovableType = function(oElement) {
		var aMovableTypes = this._getMovableTypes();

		return aMovableTypes.some(function(sType) {
			return ElementUtil.isInstanceOf(oElement, sType);
		});
	};

	/**
	 * @protected
	 */
	ElementMover.prototype.checkMovable = function(oOverlay) {
		return true;
	};

	/**
	 * returns the moved overlay (only during movements)
	 *
	 * @public
	 * @return {sap.ui.dt.Overlay} overlay which is moved
	 */
	ElementMover.prototype.getMovedOverlay = function() {
		return this._oMovedOverlay;
	};

	/**
	 * set the moved overlay (only during movements)
	 *
	 * @param {sap.ui.dt.Overlay}
	 *          [oMovedOverlay] overlay which is moved
	 * @public
	 */
	ElementMover.prototype.setMovedOverlay = function(oMovedOverlay) {
		if (oMovedOverlay) {
			this._source = OverlayUtil.getParentInformation(oMovedOverlay);
		} else {
			delete this._source;
		}
		this._oMovedOverlay = oMovedOverlay;
	};

	ElementMover.prototype._getSource = function() {
		return this._source;
	};

	/**
	 * @private
	 */
	ElementMover.prototype.activateAllValidTargetZones = function(oDesignTime, sAdditionalStyleClass) {
		this._iterateAllAggregations(oDesignTime, this._activateValidTargetZone.bind(this), sAdditionalStyleClass);
	};

	/**
	 * @private
	 */
	ElementMover.prototype._activateValidTargetZone = function(oAggregationOverlay, sAdditionalStyleClass) {
		if (this.checkTargetZone(oAggregationOverlay)) {
			oAggregationOverlay.setTargetZone(true);
			if (sAdditionalStyleClass) {
				oAggregationOverlay.addStyleClass(sAdditionalStyleClass);
			}
		}
	};

	/**
	 * @protected
	 */
	ElementMover.prototype.checkTargetZone = function(oAggregationOverlay) {
		if (!oAggregationOverlay.$().is(":visible")) {
			return false;
		}
		var oParentElement = oAggregationOverlay.getElementInstance();
		var oMovedElement = this.getMovedOverlay().getElementInstance();
		var sAggregationName = oAggregationOverlay.getAggregationName();

		if (ElementUtil.isValidForAggregation(oParentElement, sAggregationName, oMovedElement)) {
			return true;
		}
	};

	/**
	 * @private
	 */
	ElementMover.prototype._deactivateTargetZone = function(oAggregationOverlay, sAdditionalStyleClass) {
		oAggregationOverlay.setTargetZone(false);
		if (sAdditionalStyleClass) {
			oAggregationOverlay.removeStyleClass(sAdditionalStyleClass);
		}
	};

	/**
	 * @private
	 */
	ElementMover.prototype.activateTargetZonesFor = function(oOverlay, sAdditionalStyleClass) {
		this._iterateOverlayAggregations(oOverlay, this._activateValidTargetZone.bind(this), sAdditionalStyleClass);
	};

	/**
	 * @private
	 */
	ElementMover.prototype.deactivateTargetZonesFor = function(oOverlay, sAdditionalStyleClass) {
		this._iterateOverlayAggregations(oOverlay, this._deactivateTargetZone.bind(this), sAdditionalStyleClass);
	};

	/**
	 * @private
	 */
	ElementMover.prototype.deactivateAllTargetZones = function(oDesignTime, sAdditionalStyleClass) {
		this._iterateAllAggregations(oDesignTime, this._deactivateTargetZone.bind(this), sAdditionalStyleClass);
	};

	/**
	 * @private
	 */
	ElementMover.prototype._iterateAllAggregations = function(oDesignTime, fnStep, sAdditionalStyleClass) {
		var that = this;

		var aOverlays = oDesignTime.getElementOverlays();
		aOverlays.forEach(function(oOverlay) {
			that._iterateOverlayAggregations(oOverlay, fnStep, sAdditionalStyleClass);
		});
	};

	/**
	 * @private
	 */
	ElementMover.prototype._iterateOverlayAggregations = function(oOverlay, fnStep, sAdditionalStyleClass) {
		var aAggregationOverlays = oOverlay.getAggregationOverlays();
		aAggregationOverlays.forEach(function(oAggregationOverlay) {
			fnStep(oAggregationOverlay, sAdditionalStyleClass);
		});
	};

	ElementMover.prototype._isInvalidateSimpleFormEnabled = function(bEnabled, oMovedOverlay) {
		var oFirstHiddenAggregationOverlay = oMovedOverlay.getFirstHiddenAggregationOverlay();
		if (oFirstHiddenAggregationOverlay) {
			var oElementInstance = oFirstHiddenAggregationOverlay.getElementInstance();
			if (oElementInstance.getMetadata().getName() === "sap.ui.layout.form.SimpleForm") {
				// activate/deactivate overwrite of the invalidate function
				oElementInstance._bChangedByMe = !bEnabled;
			}
		}
	};

	/**
	 * @private
	 */
	ElementMover.prototype.repositionOn = function(oMovedOverlay, oTargetElementOverlay) {
		var oMovedElement = oMovedOverlay.getElementInstance();

		var oTargetParent = OverlayUtil.getParentInformation(oTargetElementOverlay);

		if (oTargetParent.index !== -1) {
			this._isInvalidateSimpleFormEnabled(false, oMovedOverlay);
			ElementUtil
					.insertAggregation(oTargetParent.parent, oTargetParent.aggregation, oMovedElement, oTargetParent.index);
			this._isInvalidateSimpleFormEnabled(true, oMovedOverlay);
		}
	};

	/**
	 * @private
	 */
	ElementMover.prototype.insertInto = function(oMovedOverlay, oTargetAggregationOverlay) {
		var oMovedElement = oMovedOverlay.getElementInstance();
		var oTargetParentElement = oTargetAggregationOverlay.getElementInstance();

		var oSourceAggregationOverlay = oMovedOverlay.getParent();
		if (oTargetAggregationOverlay !== oSourceAggregationOverlay) {
			var sTargetAggregationName = oTargetAggregationOverlay.getAggregationName();
			this._isInvalidateSimpleFormEnabled(false, oMovedOverlay);
			ElementUtil.addAggregation(oTargetParentElement, sTargetAggregationName, oMovedElement);
			this._isInvalidateSimpleFormEnabled(true, oMovedOverlay);
		}
	};

	ElementMover.prototype.buildMoveEvent = function() {

		var oMovedOverlay = this.getMovedOverlay();
		var oMovedElement = oMovedOverlay.getElementInstance();
		var oSource = this._getSource();
		var oPublicSourceParent = oSource.publicParent;
		var oSourceParentOverlay = OverlayRegistry.getOverlay(oPublicSourceParent);
		var oTarget = OverlayUtil.getParentInformation(oMovedOverlay);
		var iSourceIndex = oSource.index;
		var iTargetIndex = oTarget.index;
		delete oSource.index;
		delete oTarget.index;

		var oMove = this.getCommandFactory().getCommandFor(oPublicSourceParent, "Move", {
			movedElements : [{
				element : oMovedElement,
				sourceIndex : iSourceIndex,
				targetIndex : iTargetIndex
			}],
			source : oSource,
			target : oTarget
		}, oSourceParentOverlay.getDesignTimeMetadata());

		if (oMove) {
			if (oMove.getMetadata().getName() === "sap.ui.dt.command.SimpleFormMove") {
				// in case this is a dt command, perform immediately to show 'livechange'
				oMove.execute();
			}
		} else {
			jQuery.sap.log.error("Invalid move action in design time metadata of " + oSource.parent.getMetadata().getName());
		}
		return oMove;

	};

	/**
	 * TODO: use this algorithm to search beforeHook
	 *
	 * @private
	 */
	ElementMover.prototype._findAfterHook = function(sName, oMovedOverlay, oSource) {
		// TODO : move between two parents
		var oFirstHiddenAggregationOverlay = oMovedOverlay.getFirstHiddenAggregationOverlay();
		var oPublicParentElementOverlay = oMovedOverlay.getPublicParentElementOverlay();
		if (oFirstHiddenAggregationOverlay && oPublicParentElementOverlay) {
			var aggregationName = oFirstHiddenAggregationOverlay.getAggregationName();
			var oAggregation = oPublicParentElementOverlay.getDesignTimeMetadata().getAggregation(aggregationName);
			if (oAggregation) {
				var oAfterHook = oAggregation[sName];
				if (oAfterHook) {
					return {
						method : oAfterHook,
						context : oPublicParentElementOverlay
					};
				}
			}
		}
		return null;
	};

	return ElementMover;
}, /* bExport= */true);

}; // end of sap/ui/dt/plugin/ElementMover.js
if ( !jQuery.sap.isDeclared('sap.ui.dt.plugin.MouseSelection') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides class sap.ui.dt.plugin.MouseSelection.
jQuery.sap.declare('sap.ui.dt.plugin.MouseSelection'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
sap.ui.define("sap/ui/dt/plugin/MouseSelection",[
	'sap/ui/dt/Plugin'
],
function(Plugin) {
	"use strict";

	/**
	 * Constructor for a new MouseSelection.
	 *
	 * @param {string} [sId] id for the new object, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new object
	 *
	 * @class
	 * The MouseSelection allows to select the Overlays with a mouse click
	 * @extends sap.ui.dt.Plugin
	 *
	 * @author SAP SE
	 * @version 1.42.6
	 *
	 * @constructor
	 * @private
	 * @since 1.30
	 * @alias sap.ui.dt.plugin.MouseSelection
	 * @experimental Since 1.30. This class is experimental and provides only limited functionality. Also the API might be changed in future.
	 */
	var MouseSelection = Plugin.extend("sap.ui.dt.plugin.MouseSelection", /** @lends sap.ui.dt.plugin.MouseSelection.prototype */ {
		metadata : {
			// ---- object ----

			// ---- control specific ----
			library : "sap.ui.dt",
			properties : {
			},
			associations : {
			},
			events : {
			}
		}
	});

	/*
	 * @private
	 */
	MouseSelection.prototype.init = function() {
		Plugin.prototype.init.apply(this, arguments);
		this._mEventDelegate = {
			"onclick" : this._onClick
		};
	};

	/*
	 * @override
	 */
	MouseSelection.prototype.registerElementOverlay = function(oOverlay) {
		oOverlay.setSelectable(true);
		oOverlay.addEventDelegate(this._mEventDelegate, oOverlay);
	};


	//  * @override

	MouseSelection.prototype.deregisterElementOverlay = function(oOverlay) {
		oOverlay.removeEventDelegate(this._mEventDelegate, oOverlay);
	};

	/*
	 * @private
	 */
	 MouseSelection.prototype._onClick = function(oEvent) {
		this.setSelected(!this.getSelected());

		oEvent.preventDefault();
		oEvent.stopPropagation();
	};

	return MouseSelection;
}, /* bExport= */ true);
}; // end of sap/ui/dt/plugin/MouseSelection.js
if ( !jQuery.sap.isDeclared('sap.ui.dt.test.Element') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides object sap.ui.dt.test.Element.
jQuery.sap.declare('sap.ui.dt.test.Element'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/dt/test/Element",[
	'jquery.sap.global',
	'sap/ui/dt/ElementUtil',
	'sap/ui/dt/OverlayRegistry'
],
function(jQuery, ElementUtil, OverlayRegistry) {
	"use strict";

	/**
	 * Class for Element tests.
	 *
	 * @class
	 * Utility functionality for Element tests
	 *
	 * @author SAP SE
	 * @version 1.42.6
	 *
	 * @private
	 * @static
	 * @since 1.38
	 * @alias sap.ui.dt.test.Element
	 * @experimental Since 1.38. This class is experimental and provides only limited functionality. Also the API might be changed in future.
	 */

	var MIN_SIZE = 5;
	var ElementTest = {};


	/**
	 * Returns all design time information of the element
	 * @param  {sap.ui.core.Element} oElement the element to test
	 * @return {map} result object
	 */
	ElementTest.getInfo = function(oElement) {
		var oMetadata = oElement.getMetadata();
		var oElementDesignTimeMetadata = oMetadata.getDesignTime();
		var oElementOverlay = OverlayRegistry.getOverlay(oElement);
		var oDesignTimeMetadata = oElementOverlay.getDesignTimeMetadata();

		return {
			metadata : oMetadata,
			designTimeMetadata : oElementDesignTimeMetadata,
			overlay : oElementOverlay,
			overlayDesignTimeMetadata : oDesignTimeMetadata
		};
	};


	/**
	 * Returns all aggregation infos of the element
	 * @param  {sap.ui.core.Element} oElement the element to test
	 * @return {map} result object
	 */
	ElementTest.getAggregationInfo = function(oElement, sAggregationName) {
		var mAggregationTest = {
			ignored : true,
			domRefDeclared : false,
			domRefFound : false,
			domRefVisible : false,
			overlayTooSmall : false,
			overlayGeometryCalculatedByChildren : false,
			overlayVisible : false
		};

		var mElementInfo = this.getInfo(oElement);
		var oAggregationOverlay = mElementInfo.overlay.getAggregationOverlay(sAggregationName);
		var oDesignTimeMetadata = oAggregationOverlay.getDesignTimeMetadata();

		if (!oDesignTimeMetadata.isIgnored()) {
			mAggregationTest.ignored = false;
			mAggregationTest.domRefDeclared = !!oDesignTimeMetadata.getDomRef();
			var oAggregationDomRef = oAggregationOverlay.getAssociatedDomRef();
			if (oAggregationDomRef) {
				mAggregationTest.domRefFound = true;
				mAggregationTest.domRefVisible = jQuery(oAggregationDomRef).is(":visible");
			}

			var mGeometry = oAggregationOverlay.getGeometry();
			if (mGeometry) {
				var mSize = mGeometry.size;
				mAggregationTest.overlayTooSmall = (mSize.width <= MIN_SIZE || mSize.height <= MIN_SIZE);
				mAggregationTest.overlayGeometryCalculatedByChildren = !mGeometry.domRef;
				mAggregationTest.overlayVisible = oAggregationOverlay.$().is(":visible");
			}
		}

		return mAggregationTest;
	};


	/**
	 * Returns all information of all aggregations of the element
	 * @param  {sap.ui.core.Element} oElement the element to test
	 * @return {map} result object
	 */
	ElementTest.getAggregationsInfo = function(oElement) {
		var that = this;

		var mAggregationTests = {};

		ElementUtil.iterateOverAllPublicAggregations(oElement, function(oAggregation) {
			mAggregationTests[oAggregation.name] = that.getAggregationInfo(oElement, oAggregation.name);
		});

		return mAggregationTests;
	};

	return ElementTest;
}, /* bExport= */ true);
}; // end of sap/ui/dt/test/Element.js
if ( !jQuery.sap.isDeclared('sap.ui.dt.test.Test') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides class sap.ui.dt.test.Test.
jQuery.sap.declare('sap.ui.dt.test.Test'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.base.ManagedObject'); // unlisted dependency retained
sap.ui.define("sap/ui/dt/test/Test",[
	'jquery.sap.global',
	'sap/ui/base/ManagedObject'
],
function(jQuery, ManagedObject) {
	"use strict";

	/**
	 * Constructor for an Test.
	 *
	 * @param {string} [sId] id for the new object, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new object
	 *
	 * @class
	 * The Test class allows to create design time tests.
	 * @extends sap.ui.base.ManagedObject
	 *
	 * @author SAP SE
	 * @version 1.42.6
	 *
	 * @constructor
	 * @private
	 * @since 1.38
	 * @alias sap.ui.dt.test.Test
	 * @experimental Since 1.38. This class is experimental and provides only limited functionality. Also the API might be changed in future.
	 */
	var Test = ManagedObject.extend("sap.ui.dt.test.Test", /** @lends sap.ui.dt.test.Test.prototype */ {
		metadata : {
			"abstract" : true
		}
	});

	/**
	 * @type {map} Status Enum. Provides all availabe status.
	 * @static
	 */
	Test.STATUS = {
		"SUPPORTED" : {
			key: "SUPPORTED",
			text: "supported",
			value: 3
		},
		"PARTIAL_SUPPORTED" : {
			key: "PARTIAL_SUPPORTED",
			text: "partial supported",
			value: 2
		},
		"NOT_SUPPORTED" : {
			key: "NOT_SUPPORTED",
			text: "not supported",
			value: 1
		},
		"ERROR" : {
			key: "ERROR",
			text: "error",
			value: 0
		},
		"UNKNOWN" : {
			key: "UNKNOWN",
			text: "unknown",
			value: 0
		}
	};

	/**
	 * @type {map} Type Enum. Provides all availabe types.
	 * @static
	 */
	Test.TYPE = {
		"TEST" : "Test",
		"GROUP" : "Group",
		"SUITE" : "Suite"
	};


	/**
	 * Creates a new suite and returns it.
	 *
	 * @param {string} sName The name of the suite.
	 * @param {string} sMessage A message to display
	 * @return {map} the entry object
	 *
	 * @protected
	 */
	Test.prototype.createSuite = function(sName, sMessage) {
		return this.add(
			null,
			false,
			sName,
			sMessage,
			null,
			Test.TYPE.SUITE
		);
	};


	/**
	 * Adds a new group to an array.
	 *
	 * @param {object[]} aParentChildren the array to insert the group
	 * @param {string} sName The name of the group.
	 * @param {string} sMessage A message to display
	 * @return {map} the entry object
	 *
	 * @protected
	 */
	Test.prototype.addGroup = function(aParentChildren, sName, sMessage, sNamePostfix) {
		return this.add(aParentChildren,
			true,
			sName + (sNamePostfix ? (" (" + sNamePostfix + ")") : ""),
			sMessage,
			null,
			Test.TYPE.GROUP
		);
	};


	/**
	 * Adds a new test to an array.
	 *
	 * @param {object[]} aParentChildren the array to insert the test
	 * @param {boolean} bResult The result of the test.
	 * @param {string} sName The name of the test.
	 * @param {string} sMessage A message to display
	 * @param {map} status The status of the test.
	 * @return {map} the entry object
	 *
	 * @protected
	 */
	Test.prototype.addTest = function(aParentChildren, bResult, sName, sMessage, mStatus) {
		return this.add(aParentChildren,
			bResult,
			sName,
			sMessage,
			mStatus,
			Test.TYPE.TEST
		);
	};


	/**
	 * Adds a new entry to an array.
	 *
	 * @param {object[]} aParentChildren the array to insert the entry
	 * @param {boolean} bResult The result of the entry.
	 * @param {string} sName The name of the entry.
	 * @param {string} sMessage A message to display
	 * @param {map} mStatus The status of the entry.
	 * @param {string} sType The type of the entry.
	 * @return {map} the entry object
	 *
	 * @protected
	 */
	Test.prototype.add = function(aParentChildren, bResult, sName, sMessage, mStatus, sType) {

		if (!mStatus) {
			if (bResult) {
				mStatus = Test.STATUS.SUPPORTED;
			} else {
				mStatus = Test.STATUS.NOT_SUPPORTED;
			}
		}

		var mEntry = {
			name : sName,
			message : sMessage,
			result : bResult,
			status : mStatus,
			type : sType,
			statistic : {},
			children : []
		};

		if (aParentChildren) {
			aParentChildren.push(mEntry);
		}

		return mEntry;
	};


	/**
	 * Runs the tests.
	 *
	 * @public
	 */
	Test.prototype.run = function() {
		throw new Error("Abstract method");
	};


	/**
	 * Aggregates the tests results.
	 * @return {map} the aggregated result
	 *
	 * @protected
	 */
	Test.prototype.aggregate = function(mResult) {
		if (mResult.type != Test.TYPE.TEST && mResult.children.length > 0) {
			var aChildren = mResult.children;

			var that = this;
			var aMappedResult = aChildren.map(function(mEntry) {
				var mChildResult = that.aggregate(mEntry);
				return {
					result : mChildResult.result,
					status : mChildResult.status
				};
			});

			if (aMappedResult.length == 1) {
				aMappedResult.push(aMappedResult[0]);
			}

			var mReducedResult = aMappedResult.reduce(function(mPreviousValue, mCurrentValue) {
				return {
					result : that._getResult(mPreviousValue, mCurrentValue),
					status : that._getStatus(mPreviousValue, mCurrentValue),
					statistic : that._getStatistic(mPreviousValue, mCurrentValue)
				};
			});


			mResult.result = mReducedResult.result;
			mResult.status = mReducedResult.status;
			mResult.statistic = mReducedResult.statistic;
		}

		return mResult;
	};


	/**
	 * @private
	 */
	Test.prototype._getResult = function(mPreviousValue, mCurrentValue) {
		return !mPreviousValue.result ? false : mCurrentValue.result;
	};


	/**
	 * @private
	 */
	Test.prototype._getStatus = function(mPreviousValue, mCurrentValue) {
		return mPreviousValue.status.value < mCurrentValue.status.value ? mPreviousValue.status : mCurrentValue.status;
	};

	/**
	 * @private
	 */
	Test.prototype._getStatistic = function(mPreviousValue, mCurrentValue) {
		var mStatistic = this._getStatisticObjectForEntry(mPreviousValue);
		if (mPreviousValue !== mCurrentValue) {
			mStatistic[mCurrentValue.status.key]++;
		}
		return mStatistic;
	};


	/**
	 * @private
	 */
	Test.prototype._getStatisticObjectForEntry = function(mEntry) {
		var mStatistic = {};

		if (!mEntry.statistic) {
			for (var sStatus in Test.STATUS) {
				mStatistic[sStatus] = 0;
			}
			mStatistic[mEntry.status.key]++;
		} else {
			mStatistic = mEntry.statistic;
		}

		return mStatistic;
	};

	return Test;
}, /* bExport= */ true);
}; // end of sap/ui/dt/test/Test.js
if ( !jQuery.sap.isDeclared('sap.ui.dt.test.report.QUnit') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* global QUnit, assert */

// Provides class sap.ui.dt.test.qunit.QUnit.
jQuery.sap.declare('sap.ui.dt.test.report.QUnit'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.base.ManagedObject'); // unlisted dependency retained
sap.ui.define("sap/ui/dt/test/report/QUnit",[
	'jquery.sap.global',
	'sap/ui/base/ManagedObject'
],
function(jQuery, ManagedObject) {
	"use strict";


	/**
	 * Constructor for an QUnit.
	 *
	 * @param {string} [sId] id for the new object, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new object
	 *
	 * @class
	 * The QUnit report can be used to run qunit tests based on the design time test results.
	 * @extends sap.ui.base.ManagedObject
	 *
	 * @author SAP SE
	 * @version 1.42.6
	 *
	 * @constructor
	 * @private
	 * @since 1.38
	 * @alias sap.ui.dt.test.report.QUnit
	 * @experimental Since 1.38. This class is experimental and provides only limited functionality. Also the API might be changed in future.
	 */
	var QUnitReport = ManagedObject.extend("sap.ui.dt.test.report.QUnit", /** @lends sap.ui.dt.test.report.QUnit.prototype */ {
		metadata : {
			// ---- object ----

			// ---- control specific ----
			library : "sap.ui.dt",
			properties : {
				data : {
					type : "object"
				}
			}
		},



		/**
		 * Called when the QUnit is initialized
		 * @protected
		 */
		init : function() {
			if (!QUnit) {
				throw new Error("QUnit is required for this report.");
			}
		},


		/**
		 * Sets the data to use as a base for the QUnit tests.
		 * @param {object} oData the data to display
		 *
		 * @public
		 */
		setData : function(oData) {
			if (oData) {
				var that = this;
				var aChildren = oData.children;
				aChildren.forEach(function(oGroup) {
					that._createModule(oGroup);
				});
			}
			this.setProperty("data", oData);
		},


		/**
		 * @private
		 */
		_createModule : function(oGroup) {
			var that = this;
			QUnit.module(oGroup.message);
			oGroup.children.forEach(function(oGroup) {
				that._createTest(oGroup);
			});
		},


		/**
		 * @private
		 */
		_createTest : function(oGroup) {
			var that = this;

			QUnit.test(oGroup.name + ": " + oGroup.message, function(assert) {
				oGroup.children.forEach(function(oGroup) {
					that._createAssertion(oGroup);
				});
			});
		},


		/**
		 * @private
		 */
		_createAssertion : function(oGroup) {
			if (oGroup.children.length > 0) {
				oGroup.children.forEach(function(oTest) {
					assert.ok(oTest.result, oGroup.name + ": " + oTest.message);
				});
			} else {
				assert.ok(true, oGroup.name + ": " + oGroup.message);
			}
		}
	});

	return QUnitReport;
}, /* bExport= */ true);
}; // end of sap/ui/dt/test/report/QUnit.js
if ( !jQuery.sap.isDeclared('sap.ui.dt.test.report.Statistic') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.dt.test.report.Statistic.
jQuery.sap.declare('sap.ui.dt.test.report.Statistic'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
jQuery.sap.require('sap.ui.model.json.JSONModel'); // unlisted dependency retained
jQuery.sap.require('sap.ui.layout.form.SimpleForm'); // unlisted dependency retained
jQuery.sap.require('sap.m.Label'); // unlisted dependency retained
jQuery.sap.require('sap.m.Text'); // unlisted dependency retained
sap.ui.define("sap/ui/dt/test/report/Statistic",['jquery.sap.global', 'sap/ui/core/Control', 'sap/ui/model/json/JSONModel', 'sap/ui/layout/form/SimpleForm', "sap/m/Label", "sap/m/Text"],
	function(jQuery, Control, JSONModel, SimpleForm, Label, Text) {
	"use strict";



	/**
	 * Constructor for a new Statistic report.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * The Statistic report can be used to visualize the design time tests.
	 * @extends sap.ui.core.Control
	 *
	 * @author SAP SE
	 * @version 1.42.6
	 *
	 * @constructor
	 * @private
	 * @since 1.38
	 * @alias sap.ui.dt.test.report.Statistic
	 * @experimental Since 1.38. This class is experimental and provides only limited functionality. Also the API might be changed in future.
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var oStatistic = Control.extend("sap.ui.dt.test.report.Statistic", /** @lends sap.ui.dt.test.report.Statistic.prototype */ { metadata : {
		properties : {
			data : {
				type : "object"
			}
		},
		aggregations : {
			"_form" : {
				type : "sap.ui.layout.form.SimpleForm",
				hidden : true,
				multiple : false
			}
		}
	},


	init : function() {
		this._oModel = null;
		this.setAggregation("_form", this._createForm());
	},

	/**
	 * Called when the Statistic is destroyed
	 * @protected
	 */
	exit : function() {
		this.setData(null);
	},

	setData : function(oData) {
		if (this._oModel) {
			this._oModel.destroy();
			delete this._oModel;
		}
		if (oData) {
			this._oModel = new JSONModel(oData);
			this._getForm().setModel(this._oModel);
		} else {
			this._getForm().setModel(null);
		}
		this.setProperty("data", oData);
	},


	_createForm : function() {
		var oForm = new sap.ui.layout.form.SimpleForm(this.getId() + "--form", {
			editable : false,
			title : "Statistics",
			content : [
				new Label(this.getId() + "--form-supported-label", {text: "Supported"}),
				new Text(this.getId() + "--form-supported-value", {text: "{/statistic/SUPPORTED}"}),
				new Label(this.getId() + "--form-partial-supported-label", {text: "Partial Supported"}),
				new Text(this.getId() + "--form-partial-supported-value", {text: "{/statistic/PARTIAL_SUPPORTED}"}),
				new Label(this.getId() + "--form-not-supported-label", {text: "Not Supported"}),
				new Text(this.getId() + "--form-not-supported-value", {text: "{/statistic/NOT_SUPPORTED}"}),
				new Label(this.getId() + "--form-unknown-label", {text: "Unknown"}),
				new Text(this.getId() + "--form-unknown-value", {text: "{/statistic/UNKNOWN}"}),
				new Label(this.getId() + "--form-error-label", {text: "Error"}),
				new Text(this.getId() + "--form-error-value", {text: "{/statistic/ERROR}"})
			]
		});
		return oForm;
	},

	_getForm : function() {
		return this.getAggregation("_form");
	}
});

	return oStatistic;

}, /* bExport= */ true);

}; // end of sap/ui/dt/test/report/Statistic.js
if ( !jQuery.sap.isDeclared('sap.ui.dt.test.report.StatisticRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.dt.test.report.Statistic
jQuery.sap.declare('sap.ui.dt.test.report.StatisticRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/dt/test/report/StatisticRenderer",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	/**
	 * @author SAP SE
	 * @version 1.42.6
	 * @namespace
	 */
	var StatisticRenderer = {
	};

	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} rm The RenderManager that can be used for writing to the render output buffer.
	 * @param {sap.ui.core.Control} oStatistic An object representation of the control that should be rendered.
	 */
	StatisticRenderer.render = function(rm, oStatistic) {
		rm.addClass("sapUiDtStatisticReport");

		rm.write("<div");
		rm.writeControlData(oStatistic);

		rm.writeStyles();

		rm.writeClasses();

		rm.write(">");

		rm.renderControl(oStatistic._getForm());

		rm.write("</div>");
	};

	return StatisticRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/dt/test/report/StatisticRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.dt.test.report.Table') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.dt.test.report.Table.
jQuery.sap.declare('sap.ui.dt.test.report.Table'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
jQuery.sap.require('sap.ui.model.json.JSONModel'); // unlisted dependency retained
jQuery.sap.require('sap.ui.table.TreeTable'); // unlisted dependency retained
jQuery.sap.require('sap.ui.table.Column'); // unlisted dependency retained
jQuery.sap.require('sap.m.Toolbar'); // unlisted dependency retained
jQuery.sap.require('sap.m.Title'); // unlisted dependency retained
jQuery.sap.require('sap.m.ToolbarSpacer'); // unlisted dependency retained
jQuery.sap.require('sap.m.Button'); // unlisted dependency retained
jQuery.sap.require('sap.m.SearchField'); // unlisted dependency retained
jQuery.sap.require('sap.m.Text'); // unlisted dependency retained
jQuery.sap.require('sap.m.RatingIndicator'); // unlisted dependency retained
jQuery.sap.require('sap.ui.model.Filter'); // unlisted dependency retained
jQuery.sap.require('sap.ui.model.FilterOperator'); // unlisted dependency retained
sap.ui.define("sap/ui/dt/test/report/Table",['jquery.sap.global', 'sap/ui/core/Control', 'sap/ui/model/json/JSONModel', 'sap/ui/table/TreeTable', 'sap/ui/table/Column', 'sap/m/Toolbar', 'sap/m/Title', 'sap/m/ToolbarSpacer', 'sap/m/Button', 'sap/m/SearchField', 'sap/m/Text', 'sap/m/RatingIndicator', 'sap/ui/model/Filter', 'sap/ui/model/FilterOperator'],
	function(jQuery, Control, JSONModel, TreeTable, Column, Toolbar, Title, ToolbarSpacer, Button, SearchField, Text, RatingIndicator, Filter, FilterOperator) {
	"use strict";



	/**
	 * Constructor for a new Table report.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * The table report can be used to visualize the design time tests.
	 * @extends sap.ui.core.Control
	 *
	 * @author SAP SE
	 * @version 1.42.6
	 *
	 * @constructor
	 * @private
	 * @since 1.38
	 * @alias sap.ui.dt.test.report.Table
	 * @experimental Since 1.38. This class is experimental and provides only limited functionality. Also the API might be changed in future.
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var oTable = Control.extend("sap.ui.dt.test.report.Table", /** @lends sap.ui.dt.test.report.Table.prototype */ { metadata : {
		properties : {
			data : {
				type : "object"
			}
		},
		aggregations : {
			"_table" : {
				type : "sap.ui.table.TreeTable",
				hidden : true,
				multiple : false
			}
		}
	},


	/**
	 * Called when the Table is initialized
	 * @protected
	 */
	init : function() {
		this.setAggregation("_table", this._createTable());
	},


	/**
	 * Called when the Table is destroyed
	 * @protected
	 */
	exit : function() {
		clearTimeout(this._iFilterTimeout);
		this.setData(null);
	},


	/**
	 * Sets the data to display in the table
	 * @param {object} oData the data to display
	 *
	 * @public
	 */
	setData : function(oData) {
		if (this._oModel) {
			this._oModel.destroy();
			delete this._oModel;
		}
		if (oData) {
			this._oModel = new JSONModel(oData);
			this._getTable().setModel(this._oModel);
		} else {
			this._getTable().setModel(null);
		}
		this.setProperty("data", oData);
	},


	/**
	 * Filters the table.
	 *
	 * @param  {sString} sFilter The filter string.
	 *
	 * @public
	 */
	filter : function(sFilter) {
		var oModel = this._getTable().getModel();
		if (oModel) {
			if (sFilter.length > 0) {
				// As UI5 does not support filtering on first level, we have to do it on our own
				var aData = this.getData();
				var aFilteredData = aData.children.filter(function(oEntry) {

					if (sFilter.indexOf("status=") != -1) {
						return oEntry.status.value == sFilter.substring(sFilter.indexOf("=") + 1);
					} else {
						return oEntry.name.toLowerCase().indexOf(sFilter.toLowerCase()) != -1;
					}
				});
				oModel.setData(aFilteredData);
			} else {
				oModel.setData(this.getData());
			}
		}
	},


	/**
	 * @private
	 */
	_createTable : function() {
		var oTable = new TreeTable(this.getId() + "--table", {
			selectionMode : "MultiToggle",
			visibleRowCount: 20,
			enableSelectAll : false,
			ariaLabelledBy : "title",
			toolbar : this._createToolbar(),
			rows : "{path:'/', parameters: {arrayNames:['children']}}",
			columns : [
				this._createTextColumn("name", "Name", "{name}"),
				this._createRatingIndicatorColumn("value", "Status Values", "{status/value}", "{status/text} ({status/value})"),
				this._createTextColumn("status", "Status", "{status/text}"),
				this._createTextColumn("message", "Message", "{message}")
			]
		});

		return oTable;
	},


	/**
	 * @private
	 */
	_createToolbar : function() {
		return new Toolbar(this.getId() + "--toolbar", {
			content : [
				new ToolbarSpacer(this.getId() + "--toolbar-spacer"),
				new Button(this.getId() + "--toolbar-collapse-button", {
					text : "Collapse all",
					press : this._onCollapseAll.bind(this)
				}),
				new Button(this.getId() + "--toolbar-expand-button", {
					text : "Expand",
					press : this._onExpandSecondLevel.bind(this)
				}),
				new SearchField(this.getId() + "--toolbar-search-field", {
					liveChange:this._onSearch.bind(this)
				})
			]
		});
	},


	/**
	 * @private
	 */
	_onSearch : function(oEvt) {
		var that = this;

		var sFilter = oEvt.getParameter('newValue');
		clearTimeout(this._iFilterTimeout);
		this._iFilterTimeout = setTimeout(function() {
			that.filter(sFilter);
		},100);
	},


	/**
	 * @private
	 */
	_createTextColumn : function(sId, sColumnText, sRowText) {
		return this._createColumn(sId, sColumnText,
			new Text({
				text : sRowText
			})
		);
	},


	/**
	 * @private
	 */
	_createRatingIndicatorColumn : function(sId, sColumnText, sRowText, sTooltip) {
		return this._createColumn(sId, sColumnText,
			new RatingIndicator({
				maxValue : 3,
				value : sRowText,
				enabled : false,
				tooltip : sTooltip
			})
		);
	},


	/**
	 * @private
	 */
	_createColumn : function(sId, sColumnText, oTemplate) {
		return new Column(this.getId() + "--table-column-" + sId, {
			label : sColumnText,
			width : "13em",
			template : oTemplate
		});
	},


	/**
	 * @private
	 */
	_getTable : function() {
		return this.getAggregation("_table");
	},


	/**
	 * @private
	 */
	_onCollapseAll : function(oEvt) {
		var oTable = this._getTable();
		oTable.collapseAll();
	},


	/**
	 * @private
	 */
	_onExpandSecondLevel : function(oEvt) {
		var oTable = this._getTable();
		oTable.expandToLevel(2);
	}
});

	return oTable;

}, /* bExport= */ true);

}; // end of sap/ui/dt/test/report/Table.js
if ( !jQuery.sap.isDeclared('sap.ui.dt.test.report.TableRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.dt.test.report.Table
jQuery.sap.declare('sap.ui.dt.test.report.TableRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/dt/test/report/TableRenderer",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	/**
	 * @author SAP SE
	 * @version 1.42.6
	 * @namespace
	 */
	var TableRenderer = {
	};

	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} rm The RenderManager that can be used for writing to the render output buffer.
	 * @param {sap.ui.core.Control} oTable An object representation of the control that should be rendered.
	 */
	TableRenderer.render = function(rm, oTable) {
		rm.addClass("sapUiDtTableReport");

		rm.write("<div");
		rm.writeControlData(oTable);

		rm.writeStyles();

		rm.writeClasses();

		rm.write(">");

		rm.renderControl(oTable._getTable());

		rm.write("</div>");
	};

	return TableRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/dt/test/report/TableRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.dt.AggregationOverlayRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.dt.AggregationOverlay
jQuery.sap.declare('sap.ui.dt.AggregationOverlayRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
sap.ui.define("sap/ui/dt/AggregationOverlayRenderer",['sap/ui/dt/RenderingUtil'],
	function(RenderingUtil) {
	"use strict";


	/**
	 * @author SAP SE
	 * @version 1.42.6
	 * @namespace
	 */
	var AggregationOverlayRenderer = {
	};

	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 * @param {sap.ui.core.RenderManager} oRm The RenderManager that can be used for writing to the render output buffer.
	 * @param {sap.ui.dt.AggregationOverlay} oAggregationOverlay An object representation of the control that should be rendered.
	 * @protected
	 */
	AggregationOverlayRenderer.render = function(oRm, oAggregationOverlay) {
		RenderingUtil.renderOverlay(oRm, oAggregationOverlay, "sapUiDtAggregationOverlay");
	};

	return AggregationOverlayRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/dt/AggregationOverlayRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.dt.ContextMenuControl') ) {
/*
 * ! UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
/* global Promise */
// Provides control sap.ui.rta.ContextMenuControl.
jQuery.sap.declare('sap.ui.dt.ContextMenuControl'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.unified.Menu'); // unlisted dependency retained
jQuery.sap.require('sap.ui.unified.MenuItem'); // unlisted dependency retained
sap.ui.define("sap/ui/dt/ContextMenuControl",[
	'jquery.sap.global', './library', 'sap/ui/unified/Menu', 'sap/ui/unified/MenuItem'
], function(jQuery, library, Menu, MenuItem) {
	"use strict";

	/**
	 * Constructor for a new sap.ui.dt.ContextMenuControl control.
	 *
	 * @class Context - Menu for Design time
	 * @extends sap.ui.unified.Menu
	 * @author SAP SE
	 * @version 1.42.6
	 * @constructor
	 * @private
	 * @since 1.34
	 * @alias sap.ui.dt.ContextMenuControl
	 * @experimental Since 1.34. This class is experimental and provides only limited functionality. Also the API might be changed in future.
	 */
	var ContextMenuControl = Menu.extend("sap.ui.dt.ContextMenuControl", {
		metadata: {
			library: "sap.ui.dt",
			properties: {},
			associations: {},
			events: {}
		},
		renderer: {}
	// Standard renderer method is not overridden
	});

	/**
	 * Initialize the context menu
	 *
	 * @private
	 */
	ContextMenuControl.prototype.init = function() {
		Menu.prototype.init.apply(this, arguments);
		this._fnOnKeyDown = this._onKeyDown.bind(this);
		jQuery(document).keydown(this._fnOnKeyDown);
		this.attachBrowserEvent("contextmenu", this._onContextMenu, this);
		this._oOverlayDomRef = document.body;
	};

	/**
	 * Exit method. Called when the object gets destroyed
	 */
	ContextMenuControl.prototype.exit = function() {
		Menu.prototype.exit.apply(this, arguments);
		jQuery(document).off("keydown", this._fnOnKeyDown);
		delete this._fnOnKeyDown;
		this.detachBrowserEvent("contextmenu");
	};

	/**
	 * Set overlay which invoked the context menu
	 *
	 * @param {sap.ui.core.Element} oOverlay variable object instance of the overlay
	 */
	ContextMenuControl.prototype.setOverlayDomRef = function(oOverlay) {
		this._oOverlayDomRef = oOverlay.getDomRef();
	};

	/**
	 * Creates the context menu items based on the currently associated element
	 *
	 * @param {array} aMenuItems array with menu item settings
	 * @param {string} aMenuItems.id id, which corresponds to the text key
	 * @param {string} aMenuItems.text menu item text (translated)
	 * @param {function} aMenuItems.handler event handler if menu is selected, the element for which the menu was opened is passed to the handler
	 * @param {boolean|function} aMenuItems.startSection?, default false
	 * @param {function} aMenuItems.available? function to determine if the menu entry should be shown, the element for which the menu should be
	 *        opened is passed, default true
	 * @param {function} aMenuItems.enabled? function to determine if the menu entry should be enabled, the element for which the menu should be
	 *        opened is passed, default true
	 * @param {object} oTargetOverlay overlay for which the menu should be opened
	 * @private
	 */
	ContextMenuControl.prototype.setMenuItems = function(aMenuItems, oTargetOverlay) {
		var that = this;

		this.destroyItems();

		aMenuItems.forEach(function(oItem) {
			if (!oItem.available || oItem.available(oTargetOverlay)) {
				var bEnabled = !oItem.enabled || oItem.enabled(oTargetOverlay);

				var sText = oItem.text;
				if (typeof oItem.text === "function") {
					sText = oItem.text(oTargetOverlay);
				}

				var oMenuItem = new MenuItem({
					text: sText,
					enabled: bEnabled
				});
				oMenuItem.data({
					id: oItem.id
				});
				if ((oItem.startSection && typeof (oItem.startSection) === "boolean" ) || (typeof (oItem.startSection) === "function" && oItem.startSection(oTargetOverlay.getElementInstance()))) {
					oMenuItem.setStartsSection(true);
				}
				that.addItem(oMenuItem);
			}
		});
		return this;
	};

	/**
	 * Method for calculating the x, y-offset for opening the context menu at the current mouse position
	 *
	 * @param {number} iPageX mouse x position
	 * @param {number} iPageY mouse y position
	 */
	ContextMenuControl.prototype._open = function(iPageX, iPageY) {

		// first check if there are some context menu entries
		if (this.getItems().length === 0) {
			return;
		}

		// calculate the offset (depending on context-menu size)
		var mouseX = iPageX;
		var mouseY = iPageY;
		var X = mouseX;
		var Y = mouseY;
		var bodyX = jQuery('body').width();
		var bodyY = jQuery('body').height();

		if (!this.getDomRef()) {
			this.open(false, undefined, undefined, undefined, undefined, -2000 + " " + -2000, "none");
		}

		var ContextMenuControlWidth = this.$().context.clientWidth;
		var ContextMenuControlHeight = this.$().context.clientHeight;
		var xFlipOffset = (bodyX - mouseX < ContextMenuControlWidth) ? ContextMenuControlWidth : 0;
		var yFlipOffset = (bodyY - mouseY < ContextMenuControlHeight) ? ContextMenuControlHeight : 0;

		X = ((bodyX / 2 - mouseX) * -1) + ContextMenuControlWidth / 2 + 2 - xFlipOffset;
		Y = ((bodyY / 2 - mouseY) * -1) + ContextMenuControlHeight / 2 + 2 - yFlipOffset;

		var yOffset = mouseY - ContextMenuControlHeight;
		if (yOffset < 0 && yFlipOffset !== 0) {
			Y = Y - yOffset;
		}

		this.close();
		this.open(true, this._oOverlayDomRef, undefined, undefined, document.body, X + " " + Y, "flip");
	};

	/**
	 * Handler Method for event open menu
	 *
	 * @param {object} oContextInfo Information on the context
	 */
	ContextMenuControl.prototype.openMenu = function(oContextInfo) {
		this._open(oContextInfo.pageX, oContextInfo.pageY);
	};

	/**
	 * Handle keydown event
	 *
	 * @param {sap.ui.base.Event} oEvent event object
	 * @private
	 */
	ContextMenuControl.prototype._onKeyDown = function(oEvent) {
		if (!this.bOpen) {
			jQuery(document).off("keydown", this._fnOnKeyDown);
			delete this._fnOnKeyDown;
			return;
		}
		if ((oEvent.keyCode === jQuery.sap.KeyCodes.F10) && (oEvent.shiftKey === true) && (oEvent.altKey === false) && (oEvent.ctrlKey === false)) {
			oEvent.preventDefault();
		}
	};

	/**
	 * Handle Context Menu
	 *
	 * @param {sap.ui.base.Event} oEvent event object
	 * @private
	 */
	ContextMenuControl.prototype._onContextMenu = function(oEvent) {
		if (!this.bOpen) {
			this.detachBrowserEvent("contextmenu");
			return;
		}
		if (oEvent.preventDefault) {
			oEvent.preventDefault();
		}
	};

	return ContextMenuControl;

}, /* bExport= */true);

}; // end of sap/ui/dt/ContextMenuControl.js
if ( !jQuery.sap.isDeclared('sap.ui.dt.ControlObserver') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides class sap.ui.dt.ControlObserver.
jQuery.sap.declare('sap.ui.dt.ControlObserver'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/dt/ControlObserver",[
	'jquery.sap.global',
	'sap/ui/dt/ManagedObjectObserver'
],
function(jQuery, ManagedObjectObserver) {
	"use strict";


	/**
	 * Constructor for a new ControlObserver.
	 *
	 * @param {string} [sId] id for the new object, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new object
	 *
	 * @class
	 * The ControlObserver observs changes of a control and propagates them via events.
	 * @extends sap.ui.dt.ManagedObjectObserver
	 *
	 * @author SAP SE
	 * @version 1.42.6
	 *
	 * @constructor
	 * @private
	 * @since 1.30
	 * @alias sap.ui.dt.ControlObserver
	 * @experimental Since 1.30. This class is experimental and provides only limited functionality. Also the API might be changed in future.
	 */
	var ControlObserver = ManagedObjectObserver.extend("sap.ui.dt.ControlObserver", /** @lends sap.ui.dt.ControlObserver.prototype */ {
		metadata : {

			// ---- object ----

			// ---- control specific ----
			library : "sap.ui.dt",
			properties : {

			},
			associations : {
				/**
				 * target Control to observe
				 */
				"target" : {
					"type" : "sap.ui.core.Control"
				}
			},
			/**
			 * Fired when the DOM of the observed control is changed
			 */
			events : {
				"afterRendering" : {}
			}
		}
	});

	/**
	 * @protected
	 */
	ControlObserver.prototype.init = function() {
		ManagedObjectObserver.prototype.init.apply(this, arguments);

		this._oControlDelegate = {
			onAfterRendering : this._onAfterRendering
		};
	};

	/**
	 * Starts observing the target control.
	 * @param {sap.ui.core.Control} oControl The target to observe
	 * @override
	 */
	ControlObserver.prototype.observe = function(oControl) {
		ManagedObjectObserver.prototype.observe.apply(this, arguments);

		oControl.addEventDelegate(this._oControlDelegate, this);
	};

	/**
	 * Stops observing the target control.
	 * @param {sap.ui.core.Control} oControl The target to unobserve
	 * @override
	 */
	ControlObserver.prototype.unobserve = function() {
		var oControl = this.getTargetInstance();
		if (oControl) {
			oControl.removeDelegate(this._oControlDelegate, this);
		}

		ManagedObjectObserver.prototype.unobserve.apply(this, arguments);
	};

	/**
	 * @private
	 */
	ControlObserver.prototype._onAfterRendering = function() {
		this.fireAfterRendering();

	};

	return ControlObserver;
}, /* bExport= */ true);
}; // end of sap/ui/dt/ControlObserver.js
if ( !jQuery.sap.isDeclared('sap.ui.dt.DesignTimeMetadata') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides class sap.ui.dt.DesignTimeMetadata.
jQuery.sap.declare('sap.ui.dt.DesignTimeMetadata'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.base.ManagedObject'); // unlisted dependency retained
sap.ui.define("sap/ui/dt/DesignTimeMetadata",[
	'jquery.sap.global',
	'sap/ui/base/ManagedObject',
	'sap/ui/dt/ElementUtil',
	'sap/ui/dt/DOMUtil'
],
function(jQuery, ManagedObject, ElementUtil, DOMUtil) {
	"use strict";


	/**
	 * Constructor for a new DesignTimeMetadata.
	 *
	 * @param {string} [sId] id for the new object, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new object
	 *
	 * @class
	 * The DesignTimeMetadata is a wrapper for the DesignTimeMetadata of the associated element
	 * @extends sap.ui.core.ManagedObject
	 *
	 * @author SAP SE
	 * @version 1.42.6
	 *
	 * @constructor
	 * @private
	 * @since 1.30
	 * @alias sap.ui.dt.DesignTimeMetadata
	 * @experimental Since 1.30. This class is experimental and provides only limited functionality. Also the API might be changed in future.
	 */
	var DesignTimeMetadata = ManagedObject.extend("sap.ui.dt.DesignTimeMetadata", /** @lends sap.ui.dt.DesignTimeMetadata.prototype */ {
		metadata : {
			// ---- object ----

			// ---- control specific ----
			library : "sap.ui.dt",
			properties : {
				/**
				 * Data to be used as DT metadata
				 */
				data : {
					type : "object"
				}
			}
		}
	});

	/**
	 * Sets the data as DT metadata, uses default settings, if some fields are not defined in oData
	 * @param {object} oData to set
	 * @return {sap.ui.dt.DesignTimeMetadata} returns this
	 * @protected
	 */
	DesignTimeMetadata.prototype.setData = function(oData) {

		var oMergedData = jQuery.extend(true, this.getDefaultData(), oData || {});

		this.setProperty("data", oMergedData);
		return this;
	};

	/**
	 * Returns data, if no data is set, creates a default data
	 * @return {object} returns data
	 * @public
	 */
	DesignTimeMetadata.prototype.getData = function() {
		var oData = this.getProperty("data");
		if (!oData) {
			this.setData({});
			oData = this.getProperty("data");
		}

		return oData;
	};

	/**
	 * Returns the default DT metadata
	 * @return {Object} default data
	 * @protected
	 */
	DesignTimeMetadata.prototype.getDefaultData = function() {
		return {
			ignore : false,
			domRef : undefined,
			cloneDomRef : false
		};
	};

	/**
	 * Returns property "ignore" of the DT metadata
	 * @return {boolean} if ignored
	 * @public
	 */
	DesignTimeMetadata.prototype.isIgnored = function() {
		return this.getData().ignore;
	};

	/**
	 * Returns property "copyDom" of the DT metadata
	 * @return {boolean} if overlay should copy the DOM of its associated element
	 * @public
	 */
	DesignTimeMetadata.prototype.getCloneDomRef = function() {
		return this.getData().cloneDomRef;
	};

	/**
	 * Returns property "domRef" of the DT metadata
	 * @return {string|Element} assosicated domRef
	 * @public
	 */
	DesignTimeMetadata.prototype.getDomRef = function() {
		return this.getData().domRef;
	};

	DesignTimeMetadata.prototype.getAssociatedDomRef = function(sAction, oElement) {

		var oElementDomRef = ElementUtil.getDomRef(oElement);
		var vAssociatedDomRef = this.getAction(sAction, oElement).domRef;

		if (oElementDomRef) {
			if (typeof vAssociatedDomRef === "string") {
				return DOMUtil.getDomRefForCSSSelector(oElementDomRef, vAssociatedDomRef).get(0);
			} else if (typeof vAssociatedDomRef === "function") {
				return vAssociatedDomRef.call(this, oElement);
			}
		} else {
			if (typeof vAssociatedDomRef === "function") {
				return vAssociatedDomRef.call(this, oElement);
			}
		}
	};

	/**
	 * Returns action sAction part of designTime metadata (object or changeType string)
	 * @param  {string} sAction action name
	 * @param  {object} oElement element instance
	 * @return {map} part of designTimeMetada, which describes sAction in a map format
	 * @public
	 */
	DesignTimeMetadata.prototype.getAction = function(sAction, oElement) {
		var mData = this.getData();
		if (mData.actions && mData.actions[sAction]) {
			var vAction = mData.actions[sAction];
			if (typeof (vAction) === "function" ) {
				vAction = vAction.call(null, oElement);
			}

			if (typeof (vAction) === "string" ) {
				return { changeType : vAction };
			} else {
				return vAction;
			}
		}
	};

	return DesignTimeMetadata;
}, /* bExport= */ true);
}; // end of sap/ui/dt/DesignTimeMetadata.js
if ( !jQuery.sap.isDeclared('sap.ui.dt.ElementOverlayRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.dt.Overlay
jQuery.sap.declare('sap.ui.dt.ElementOverlayRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
sap.ui.define("sap/ui/dt/ElementOverlayRenderer",['sap/ui/dt/RenderingUtil'],
	function(RenderingUtil) {
	"use strict";


	/**
	 * @author SAP SE
	 * @version 1.42.6
	 * @namespace
	 */
	var OverlayRenderer = {
	};

	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 * @param {sap.ui.core.RenderManager} oRm The RenderManager that can be used for writing to the render output buffer.
	 * @param {sap.ui.dt.Overlay} oOverlay An object representation of the control that should be rendered.
	 * @protected
	 */
	OverlayRenderer.render = function(oRm, oOverlay) {
		RenderingUtil.renderOverlay(oRm, oOverlay, "sapUiDtElementOverlay");
	};

	return OverlayRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/dt/ElementOverlayRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.dt.MutationObserver') ) {
/*
 * ! UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides class sap.ui.dt.MutationObserver.
jQuery.sap.declare('sap.ui.dt.MutationObserver'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.base.ManagedObject'); // unlisted dependency retained
sap.ui.define("sap/ui/dt/MutationObserver",[
	'jquery.sap.global',
	'sap/ui/dt/OverlayUtil',
	'sap/ui/dt/ElementUtil',
	'sap/ui/base/ManagedObject'
], function(jQuery, OverlayUtil, ElementUtil, ManagedObject) {
	"use strict";

	/**
	 * Constructor for a new MutationObserver.
	 *
	 * @param {string} [sId] id for the new object, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new object
	 * @class The MutationObserver observes changes of a ManagedObject and propagates them via events.
	 * @extends sap.ui.base.ManagedObject
	 * @author SAP SE
	 * @version 1.42.6
	 * @constructor
	 * @private
	 * @since 1.30
	 * @alias sap.ui.dt.MutationObserver
	 * @experimental Since 1.30. This class is experimental and provides only limited functionality. Also the API might be modified in future.
	 */
	var MutationObserver = ManagedObject.extend("sap.ui.dt.MutationObserver", /** @lends sap.ui.dt.MutationObserver.prototype */
	{
		metadata: {
			library: "sap.ui.dt",
			events: {
				/**
				 * Event fired when the observed object is modified
				 */
				domChanged: {
					parameters : {
						type : { type : "string" },
						elemenIds : { type : "string[]"},
						targetNodes : { type : "element[]" }
					}
				}
			}
		}
	});

	/**
	 * Called when the MutationObserver is created
	 *
	 * @protected
	 */
	MutationObserver.prototype.init = function() {
		var that = this;

		this._fnFireResizeDomChanged = function() {
			that.fireDomChanged({
				type : "resize"
			});
		};
		this._onScroll = this._fireDomChangeOnScroll.bind(this);

		this._startMutationObserver();
		this._startResizeObserver();
		this._startScrollObserver();
	};

	/**
	 * Called when the MutationObserver is destroyed
	 *
	 * @protected
	 */
	MutationObserver.prototype.exit = function() {
		this._stopMutationObserver();
		this._stopResizeObserver();
		this._stopScrollObserver();
	};

	/**
	 * @private
	 */
	MutationObserver.prototype._startMutationObserver = function() {
		var that = this;

		if (this._oMutationObserver) {
			return;
		}

		var MutationObserver = window.MutationObserver || window.WebKitMutationObserver;
		if (MutationObserver) {
			this._oMutationObserver = new MutationObserver(function(aMutations) {
				var aTargetNodes = [];
				var aElementIds = [];
				aMutations.forEach(function(oMutation) {
					var oTarget = oMutation.target;

					// text mutations have no class list, so we use a parent node as a target
					if (oMutation.type === "characterData") {
						oTarget = oMutation.target.parentNode;
					}

					// filter out all mutation in overlays
					if (!OverlayUtil.isInOverlayContainer(oTarget)) {
						aTargetNodes.push(oTarget);

						// define closest element to notify it's overlay about the dom mutation
						var oOverlay = OverlayUtil.getClosestOverlayForNode(oTarget);
						var sElementId = oOverlay ? oOverlay.getElementInstance().getId() : undefined;
						if (sElementId) {
							aElementIds.push(sElementId);
						}
					}
				});

				if (aTargetNodes.length) {
					that.fireDomChanged({
						type : "mutation",
						elementIds : aElementIds,
						targetNodes : aTargetNodes
					});
				}
			});

			// we should observe whole DOM, otherwise position change of elements can be triggered via outter changes
			// (like change of body size, container insertions etc.)
			this._oMutationObserver.observe(window.document, {
				childList : true,
				subtree : true,
				attributes : true,
				attributeFilter : ["style", "class", "width", "height", "border"],
				characterData : true // also observe text node changes, see https://dom.spec.whatwg.org/#characterdata
			});
		} else {
			jQuery.sap.log.error("Mutation Observer is not available");
		}
	};

	/**
	 * @private
	 */
	MutationObserver.prototype._stopMutationObserver = function() {
		if (this._oMutationObserver) {
			this._oMutationObserver.disconnect();
			delete this._oMutationObserver;
		}
	};

	/**
	 * @private
	 */
	MutationObserver.prototype._startResizeObserver = function() {
		jQuery(window).on("resize", this._fnFireResizeDomChanged);
	};

	/**
	 * @private
	 */
	MutationObserver.prototype._stopResizeObserver = function() {
		jQuery(window).off("resize", this._fnFireResizeDomChanged);
	};

	/**
	 * @private
	 */
	MutationObserver.prototype._fireDomChangeOnScroll = function(oEvent) {
		var oTarget = oEvent.target;
		if (!OverlayUtil.isInOverlayContainer(oTarget) && !OverlayUtil.getClosestOverlayForNode(oTarget)) {
			this.fireDomChanged({
				type : "scroll"
			});
		}
	};

	/**
	 * @private
	 */
	MutationObserver.prototype._startScrollObserver = function() {
		window.addEventListener("scroll", this._onScroll, true);
	};

	/**
	 * @private
	 */
	MutationObserver.prototype._stopScrollObserver = function() {
		window.removeEventListener("scroll", this._onScroll, true);
	};

	return MutationObserver;
}, /* bExport= */true);

}; // end of sap/ui/dt/MutationObserver.js
if ( !jQuery.sap.isDeclared('sap.ui.dt.Overlay') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides class sap.ui.dt.Overlay.
jQuery.sap.declare('sap.ui.dt.Overlay'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
jQuery.sap.require('jquery.sap.dom'); // unlisted dependency retained
sap.ui.define("sap/ui/dt/Overlay",[
	'jquery.sap.global',
	'sap/ui/core/Control',
	'sap/ui/dt/MutationObserver',
	'sap/ui/dt/ElementUtil',
	'sap/ui/dt/OverlayUtil',
	'sap/ui/dt/DOMUtil',
	'jquery.sap.dom'
],
function(jQuery, Control, MutationObserver, ElementUtil, OverlayUtil, DOMUtil) {
	"use strict";

	var sOverlayContainerId = "overlay-container";
	var oOverlayContainer;
	var oMutationObserver;

	/**
	 * Constructor for an Overlay.
	 *
	 * @param {string} [sId] id for the new object, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new object
	 *
	 * @class
	 * The Overlay allows to create an absolute positioned DIV above the associated element.
	 * @extends sap.ui.core.Control
	 *
	 * @author SAP SE
	 * @version 1.42.6
	 *
	 * @constructor
	 * @private
	 * @abstract
	 * @since 1.30
	 * @alias sap.ui.dt.Overlay
	 * @experimental Since 1.30. This class is experimental and provides only limited functionality. Also the API might be changed in future.
	 */
	var Overlay = Control.extend("sap.ui.dt.Overlay", /** @lends sap.ui.dt.Overlay.prototype */ {
		metadata : {
			// ---- object ----

			// ---- control specific ----
			library : "sap.ui.dt",
			properties : {
				/**
				 * Whether the overlay and it's descendants should be visible on a screen
				 * We are overriding Control's property to prevent RenderManager from rendering of an invisible placeholder
				 */
				visible : {
					type : "boolean",
					defaultValue : true
				},
				/**
				 * Render overlay only if associated element is visible
				 */
				lazyRendering : {
					type : "boolean",
					defaultValue : true
				},
				/**
				 * Whether the overlay is created for an element or aggregation, which is not accessible via the public tree
				 */
				inHiddenTree : {
					type : "boolean",
					defaultValue : false
				},
				/**
				 * Whether the Overlay can get the browser focus (has tabindex)
				 */
				focusable : {
					type : "boolean",
					defaultValue : false
				}
			},
			associations : {
				/**
				 * Element associated with an overlay
				 */
				element : {
					type : "sap.ui.core.Element"
				}
			},
			aggregations : {
				/**
				 * DesignTime metadata for the associated Element
				 */
				designTimeMetadata : {
					type : "sap.ui.dt.DesignTimeMetadata",
					multiple : false
				}
			},
			events : {
				/**
				 * Event fired when the property "Focusable" is changed
				 */
				focusableChange : {
					parameters : {
						focusable : { type : "boolean" }
					}
				},
				/**
				 * Event fired when the Overlay is destroyed
				 */
				destroyed : {
					parameters : {}
				},
				/**
				 * Event fired when the Overlay visibility is changed
				 */
				visibleChanged : {
					parameters : {
						visible : "boolean"
					}
				}
			}
		}
	});

	/**
	 * Returns children of this overlay
	 * @return {sap.ui.dt.Overlay[]} overlays that are logical children of this overlay
	 * @protected
	 */
	//Overlay.prototype.getChildren = function() {};

	/**
	 * Creates and/or returns an overlay container element, where all Overlays should be rendered (initially)
	 * @return {Element} overlay container
	 * @static
	 */
	Overlay.getOverlayContainer = function() {
		if (!oOverlayContainer) {
			oOverlayContainer = jQuery.sap.byId(sOverlayContainerId);
			if (!oOverlayContainer.length) {
				oOverlayContainer = jQuery("<div id='" + sOverlayContainerId + "'></div>").css({
					"top" : "0px",
					"left" : "0px",
					"right" : "0px",
					"bottom" : "0px"
				}).appendTo("body");
			}
		}
		return oOverlayContainer.get(0);
	};

	/**
	 * Removes an overlay container element from DOM
	 * @static
	 */
	Overlay.removeOverlayContainer = function() {
		if (oOverlayContainer) {
			oOverlayContainer.remove();
		}

		oOverlayContainer = null;
	};

	/**
	 * @static
	 */
	Overlay.getMutationObserver = function() {
		if (!oMutationObserver) {
			oMutationObserver = new MutationObserver();
		}
		return oMutationObserver;
	};

	/**
	 * @static
	 */
	Overlay.destroyMutationObserver = function() {
		if (oMutationObserver) {
			oMutationObserver.destroy();
			oMutationObserver = null;
		}
	};

	/**
	 * Called when the Overlay is initialized
	 * @protected
	 */
	Overlay.prototype.init = function() {
		this._bVisible = null;

		this._domRefScrollHandler = this._onSyncScrollWithDomRef.bind(this);

		this.attachBrowserEvent("scroll", this._onOverlayScroll, this);
	};

	/**
	 * Called when the Overlay is destroyed
	 * @protected
	 */
	Overlay.prototype.exit = function() {
		this._detachDomRefScrollHandler();

		delete this._oDomRef;
		delete this._bVisible;
		window.clearTimeout(this._iCloneDomTimeout);
		window.clearTimeout(this._iSyncScrollWithDomRef);
		this.fireDestroyed();
	};

	/**
	 * this is needed to prevent UI5 renderManager from removing overlay's node from DOM in a rendering phase
	 * see RenderManager.js "this._fPutIntoDom" function
	 * @private
	 */
	Overlay.prototype._onChildRerenderedEmpty = function() {
		return true;
	};

	/**
	 * Called after Overlay rendering phase
	 * @protected
	 */
	Overlay.prototype.onAfterRendering = function() {
		this._oDomRef = this.getDomRef();

		if (this._oDomRef) {
			this._updateDom();
		}

		var bFocusable = this.isFocusable();
		if (bFocusable) {
			this.$().attr("tabindex", 0);
		} else {
			this.$().attr("tabindex", null);
		}
	};

	/**
	 * @return {Element} The Element's DOM Element sub DOM Element or null
	 * @override
	 */
	Overlay.prototype.getDomRef = function() {
		return this._oDomRef || Control.prototype.getDomRef.apply(this, arguments);
	};


	/**
	 * Returns a DOM reference for the associated Element or null, if it can't be found
	 * @return {Element} DOM element or null
	 * @public
	 */
	Overlay.prototype.getAssociatedDomRef = function() {
		throw new Error("This method is abstract and needs to be implemented");
	};

	/**
	 * Returns an instance of the Element, which is associated with this Overlay
	 * @return {sap.ui.Element} associated Element
	 * @public
	 */
	Overlay.prototype.getElementInstance = function() {
		return sap.ui.getCore().byId(this.getElement());
	};

	/**
	 * @return {boolean} if the Overlay has focus
	 * @private
	 */
	Overlay.prototype.hasFocus = function() {
		return document.activeElement === this.getFocusDomRef();
	};

	/**
	 * Sets whether the Overlay can get the browser focus (tabindex)
	 * @param {boolean} bFocusable if the Overlay is focusable
	 * @returns {sap.ui.dt.Overlay} returns this
	 * @public
	 */
	Overlay.prototype.setFocusable = function(bFocusable) {
		if (this.isFocusable() !== bFocusable) {
			this.setProperty("focusable", bFocusable);
			this.toggleStyleClass("sapUiDtOverlayFocusable", bFocusable);
			this.fireFocusableChange({focusable : bFocusable});
		}

		return this;
	};

	/**
	 * Returns if the Overlay is can get the focus
	 * @public
	 * @return {boolean} if the Overlay is focusable
	 */
	Overlay.prototype.isFocusable = function() {
		return this.getFocusable();
	};

	/**
	 * Calculate and update CSS styles for the Overlay's DOM
	 * The calculation is based on original associated DOM state and parent overlays
	 * This method also calls "applyStyles" method for every child Overlay of this Overlay (cascade)
	 * @public
	 */
	Overlay.prototype.applyStyles = function() {
		// invalidate cached geometry
		delete this._mGeometry;

		if (!this.getDomRef()) {
			return;
		}

		if (!this.isVisible()) {
			this.$().css("display", "none");
			return;
		}

		var oGeometry = this.getGeometry();

		if (oGeometry && oGeometry.visible) {
			var $overlay = this.$();

			// ensure visibility
			$overlay.css("display", "block");

			var oOverlayParent = this.getParent();

			var iParentScrollTop = (oOverlayParent && oOverlayParent instanceof Overlay) ? oOverlayParent.$().scrollTop() : null;
			var iParentScrollLeft = (oOverlayParent && oOverlayParent instanceof Overlay) ? oOverlayParent.$().scrollLeft() : null;
			var mParentOffset = (oOverlayParent && oOverlayParent instanceof Overlay) ? oOverlayParent.$().offset() : null;
			var mPosition = DOMUtil.getOffsetFromParent(oGeometry.position, mParentOffset, iParentScrollTop, iParentScrollLeft);


			var mSize = oGeometry.size;

			// OVERLAY SIZE
			$overlay.css("width", mSize.width + "px");
			$overlay.css("height", mSize.height + "px");
			$overlay.css("top", mPosition.top + "px");
			$overlay.css("left", mPosition.left + "px");

			if (oGeometry.domRef) {
				var iZIndex = DOMUtil.getZIndex(oGeometry.domRef);
				if (iZIndex) {
					$overlay.css("z-index", iZIndex);
				}

				// OVERFLOW & SCROLLING
				var oOverflows = DOMUtil.getOverflows(oGeometry.domRef);
				if (oOverflows) {
					if (oOverflows.overflowX) {
						$overlay.css("overflow-x", oOverflows.overflowX);
					}
					if (oOverflows.overflowY) {
						$overlay.css("overflow-y", oOverflows.overflowY);
					}
					var iScrollHeight = oGeometry.domRef.scrollHeight;
					var iScrollWidth = oGeometry.domRef.scrollWidth;
					if (iScrollHeight > mSize.height || iScrollWidth > mSize.width) {
						if (!this._oDummyScrollContainer) {
							this._oDummyScrollContainer = jQuery("<div class='sapUiDtDummyScrollContainer' style='height: " + iScrollHeight + "px; width: " + iScrollWidth + "px;'></div>");
							this.$().append(this._oDummyScrollContainer);
						} else {
							this._oDummyScrollContainer.css({
								"height": iScrollHeight,
								"width" : iScrollWidth
							});
						}
					} else if (this._oDummyScrollContainer) {
						this._oDummyScrollContainer.remove();
						delete this._oDummyScrollContainer;
					}
					this._attachDomRefScrollHandler();

					this._syncScrollWithDomRef();
				}

				this._cloneDomRef(oGeometry.domRef);
			}

			this.getChildren().forEach(function(oChild) {
				oChild.applyStyles();
			});

		} else {
			this.$().css("display", "none");
		}
	};

	/**
	 * @private
	 */
	Overlay.prototype._attachDomRefScrollHandler = function() {
		this._detachDomRefScrollHandler();

		var oGeometry = this.getGeometry();
		var oDomRef = oGeometry ? oGeometry.domRef : null;
		if (oDomRef) {
			this._oDomRefWithScrollHandler = oDomRef;

			jQuery(this._oDomRefWithScrollHandler).on("scroll", this._domRefScrollHandler);
		}
	};

	/**
	 * @private
	 */
	Overlay.prototype._detachDomRefScrollHandler = function(oDomRef) {
		if (this._oDomRefWithScrollHandler) {
			jQuery(this._oDomRefWithScrollHandler).off("scroll", this._domRefScrollHandler);
			delete this._oDomRefWithScrollHandler;
		}
	};

	/**
	 * @private
	 */
	Overlay.prototype._onSyncScrollWithDomRef = function(oEvt) {
		window.clearTimeout(this._iSyncScrollWithDomRef);
		var that = this;
		// timeout needed so that scroll wheel in chrome windows works fast
		this._iSyncScrollWithDomRef = window.setTimeout(function() {
			that._syncScrollWithDomRef();
			delete that._iSyncScrollWithDomRef;
		}, 0);
	};

	/**
	 * @private
	 */
	Overlay.prototype._syncScrollWithDomRef = function(oEvent) {
		DOMUtil.syncScroll(this._oDomRefWithScrollHandler, this.$());
	};

	/**
	 * Returns an object, which describes the DOM geometry of the element associated with this overlay or null if it can't be found
	 * The geometry is calculated based on the associated element's DOM reference, if it exists or based on it's public children
	 * Object may contain following fields: position - absolute position of Element in DOM; size - absolute size of Element in DOM
	 * Object may contain domRef field, when the associated Element's DOM can be found
	 * @return {object} geometry object describing the DOM of the Element associated with this Overlay
	 * @public
	 */
	Overlay.prototype.getGeometry = function(bForceCalculation) {
		if (bForceCalculation || !this._mGeometry) {
			var oDomRef = this.getAssociatedDomRef();
			var mGeometry = DOMUtil.getGeometry(oDomRef, this.isRoot());

			if (!mGeometry) {
				var aChildrenGeometry = [];
				this.getChildren().forEach(function(oChildOverlay) {
					aChildrenGeometry.push(oChildOverlay.getGeometry(true));
				});
				mGeometry = OverlayUtil.getGeometry(aChildrenGeometry);
			}

			// cache geometry
			this._mGeometry = mGeometry;
		}

		return this._mGeometry;
	};

	/**
	 * @private
	 */
	Overlay.prototype._cloneDomRef = function(oDomRef) {
		var $this = this.$();

		var $clonedDom = $this.find(">.sapUiDtClonedDom");
		var vCloneDomRef = this.getDesignTimeMetadata().getCloneDomRef();
		if (vCloneDomRef) {
			if (oDomRef) {
				var fnCloneDom = function() {
					if (vCloneDomRef !== true) {
						oDomRef = DOMUtil.getDomRefForCSSSelector(oDomRef, vCloneDomRef);
					}

					if (!$clonedDom.length) {
						$clonedDom = jQuery("<div class='sapUiDtClonedDom'></div>").prependTo($this);
					} else {
						$clonedDom.empty();
					}
					DOMUtil.cloneDOMAndStyles(oDomRef, $clonedDom);
				};

				if (!this._bClonedDom) {
					this._bClonedDom = true;
					fnCloneDom();
				} else {
					window.clearTimeout(this._iCloneDomTimeout);
					// cloneDom is expensive, therefore the call is delayed
					this._iCloneDomTimeout = window.setTimeout(fnCloneDom, 250);
				}
			}
		} else {
			$clonedDom.remove();
		}
	};

	/**
	 * @private
	 */
	Overlay.prototype._updateDom = function() {
		if (this.isRoot()) {
			this._ensureIsInOverlayContainer();

			// apply styles propagated from root overlays to all their children
			this.applyStyles();
		} else {
			this._ensureDomOrder();
		}
	};

	/**
	 * @private
	 */
	Overlay.prototype._ensureDomOrder = function() {
		var $this = this.$();

		var oParent = this.getParent();
		var $parentDomRef = oParent.$();
		var $parentContainer = $parentDomRef.find(">.sapUiDtOverlayChildren");

		var bIsDomOrderCorrect;

		var $PreviousChildWithDom;

		var aChildren = oParent.getChildren();
		var iPreviousChildWithDomIndex = aChildren.indexOf(this) - 1;
		while (iPreviousChildWithDomIndex >= 0) {
			$PreviousChildWithDom = aChildren[iPreviousChildWithDomIndex].$();
			if ($PreviousChildWithDom.length) {
				break;
			}
			iPreviousChildWithDomIndex--;
		}

		// if our dom is already after out previous sibling
		if ($PreviousChildWithDom && $PreviousChildWithDom.length) {
			bIsDomOrderCorrect = $this.prev().get(0) === $PreviousChildWithDom.get(0);
		// .. or first in parent container
		} else {
			bIsDomOrderCorrect = $parentContainer.children().index($this) === 0;
		}

		if (!bIsDomOrderCorrect) {
			if ($PreviousChildWithDom && $PreviousChildWithDom.length) {
				$PreviousChildWithDom.after($this);
			} else {
				$parentContainer.prepend($this);
			}
		}
	};

	/**
	 * @private
	 */
	Overlay.prototype._ensureIsInOverlayContainer = function() {
		var $this = this.$();
		var $currentDomParent = $this.parent();
		// instead of adding the created DOM into the UIArea's DOM, we are adding it to overlay-container to avoid clearing of the DOM
		var oOverlayContainer = Overlay.getOverlayContainer();
		var oParentElement = $currentDomParent.length ? $currentDomParent.get(0) : null;
		if (oOverlayContainer !== oParentElement) {
			$this.appendTo(oOverlayContainer);
		}
	};

	/**
	 * @private
	 */
	Overlay.prototype._onOverlayScroll = function() {
		var oGeometry = this.getGeometry();
		var oDomRef = oGeometry ? oGeometry.domRef : null;
		if (oDomRef) {
			DOMUtil.syncScroll(this.$(), oDomRef);
		}
	};


	/**
	 * Sets whether the Overlay is for an element/aggregation in a hidden tree (not accessible via public aggregations)
	 * @param {boolean} bInHiddenTree if the Overlay is inHiddenTree
	 * @returns {sap.ui.dt.Overlay} returns this
	 * @public
	 */
	Overlay.prototype.setInHiddenTree = function(bInHiddenTree) {
		if (bInHiddenTree !== this.isInHiddenTree()) {

			this.toggleStyleClass("sapUiDtOverlayInHiddenTree", bInHiddenTree);
			this.setProperty("inHiddenTree", bInHiddenTree);
		}

		return this;
	};

	/**
	 * Returns if the Overlay is for an element/aggregation in a hidden tree (not accessible via public aggregations)
	 * @public
	 * @return {boolean} if the Overlay is in hidden tree
	 */
	Overlay.prototype.isInHiddenTree = function() {
		return this.getInHiddenTree();
	};


	/**
	 * Sets whether the Overlay is visible
	 * @param {boolean} bVisible if the Overlay is visible
	 * @returns {sap.ui.dt.Overlay} returns this
	 * @public
	 */
	Overlay.prototype.setVisible = function(bVisible) {
		if (this.getVisible() !== bVisible) {
			this.setProperty("visible", bVisible);
			this._bVisible = bVisible;
			this.fireVisibleChanged({visible : bVisible});
		}

		return this;
	};

	/**
	 * Returns whether the Overlay is visible
	 * @return {boolean} if the Overlay is visible
	 * @public
	 */
	Overlay.prototype.getVisible = function() {

		if (this._bVisible === null) {
			if (!this.getLazyRendering()) {
				return true;
			}
			var oDesignTimeMetadata = this.getDesignTimeMetadata();
			return oDesignTimeMetadata ? !oDesignTimeMetadata.isIgnored() : false;
		} else {
			return this.getProperty("visible");
		}
	};


	/**
	 * Returns if the Overlay is visible
	 * @public
	 * @return {boolean} if the Overlay is visible
	 */
	Overlay.prototype.isVisible = function() {
		return this.getVisible();
	};

	/**
	 * Returns if overlay is root
	 * @public
	 */
	Overlay.prototype.isRoot = function() {
		var oParent = this.getParent();
		if (oParent) {
			if (!oParent.getDomRef) {
				return true;
			}
		}
	};

	/**
	 * Returns child of first ancestor overlay not flagged as inHiddenTree
	 *
	 * @return {sap.ui.dt.ElementOverlay} ElementOverlay public parents child
	 * @public
	 */
	Overlay.prototype.getFirstHiddenAggregationOverlay = function() {

		var oPreviousOverlay = this;
		var oParentOverlay = this.getParentElementOverlay();
		while (oParentOverlay && oParentOverlay.isInHiddenTree()
				&& ElementUtil.isInstanceOf(oParentOverlay, "sap.ui.dt.ElementOverlay")) {
			oPreviousOverlay = oParentOverlay;
			oParentOverlay = oParentOverlay.getParentElementOverlay();
		}
		if (ElementUtil.isInstanceOf(oParentOverlay, "sap.ui.dt.ElementOverlay")) {
			return oPreviousOverlay.getParent();
		}
	};

	return Overlay;
}, /* bExport= */ true);

}; // end of sap/ui/dt/Overlay.js
if ( !jQuery.sap.isDeclared('sap.ui.dt.Selection') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides class sap.ui.dt.Selection.
jQuery.sap.declare('sap.ui.dt.Selection'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.ui.base.ManagedObject'); // unlisted dependency retained
sap.ui.define("sap/ui/dt/Selection",[
	'sap/ui/base/ManagedObject',
	'./library'
],
function(ManagedObject) {
	"use strict";

	/**
	 * Constructor for a new Selection.
	 *
	 * @param {string} [sId] id for the new object, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new object
	 *
	 * @class
	 * The Selection allows to create a set of Overlays above the root elements and
	 * theire public children and manage their events.
	 * @extends sap.ui.dt.ManagedObject
	 *
	 * @author SAP SE
	 * @version 1.42.6
	 *
	 * @constructor
	 * @private
	 * @since 1.30
	 * @alias sap.ui.dt.Selection
	 * @experimental Since 1.30. This class is experimental and provides only limited functionality. Also the API might be changed in future.
	 */
	var Selection = ManagedObject.extend("sap.ui.dt.Selection", /** @lends sap.ui.dt.Selection.prototype */ {
		metadata : {
			// ---- object ----

			// ---- control specific ----
			library : "sap.ui.dt",
			properties : {
				"mode" : {
					type : "sap.ui.dt.SelectionMode",
					defaultValue : sap.ui.dt.SelectionMode.Single
				}
			},
			associations : {},
			aggregations : {},
			events : {
				"change" : {
					parameters : {
						selection : { type : "sap.ui.dt.Overlay[]" }
					}
				}
			}
		}
	});

	/**
	 * @override
	 */
	Selection.prototype.init = function() {
		this._aSelection = [];
	};

	/**
	 * @override
	 */
	Selection.prototype.exit = function() {
		delete this._aSelection;
	};

	/**
	 * @public
	 * @return {sap.ui.dt.Overlay[]} selected overlays
	 */
	Selection.prototype.getSelection = function() {
		return this._aSelection;
	};

	/**
	 * @public
	 */
	Selection.prototype.set = function(oOverlay, bSelected) {
		if (bSelected) {
			this.add(oOverlay);
		} else {
			this.remove(oOverlay);
		}
	};

	/**
	 * @public
	 */
	Selection.prototype.add = function(oOverlay) {
		this._syncSelectionWithMode();

		this._aSelection.push(oOverlay);
		this.fireChange({
			selection : this.getSelection()
		});
	};

	/**
	 * @public
	 */
	Selection.prototype.remove = function(oOverlay) {
		this._syncSelectionWithMode();

		var iIndex = this._aSelection.indexOf(oOverlay);
		if (iIndex !== -1) {
			this._aSelection.splice(iIndex, 1);
		}
		this.fireChange({
			selection : this.getSelection()
		});
	};

	/**
	 * @private
	 */
	Selection.prototype._isSingleMode = function() {
		return this.getMode() === sap.ui.dt.SelectionMode.Single;
	};


	Selection.prototype._syncSelectionWithMode = function() {
		if (this._isSingleMode()) {
			this._aSelection.forEach(function(oOverlay) {
				oOverlay.setSelected(false, true);
			});
			this._aSelection = [];
		}
	};

	return Selection;
}, /* bExport= */ true);
}; // end of sap/ui/dt/Selection.js
if ( !jQuery.sap.isDeclared('sap.ui.dt.plugin.ContextMenu') ) {
/*
 * ! UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides class sap.ui.rta.plugin.ContextMenu.
jQuery.sap.declare('sap.ui.dt.plugin.ContextMenu'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/dt/plugin/ContextMenu",[
	'jquery.sap.global', 'sap/ui/dt/Plugin', 'sap/ui/dt/ContextMenuControl'
], function(jQuery, Plugin, ContextMenuControl) {
	"use strict";

	/**
	 * Constructor for a new ContextMenu.
	 *
	 * @param {string} [sId] id for the new object, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new object
	 * @class The ContextMenu registers event handler to open the context menu. Menu entries can dynamically be added
	 * @extends sap.ui.core.ManagedObject
	 * @author SAP SE
	 * @version 1.42.6
	 * @constructor
	 * @private
	 * @since 1.34
	 * @alias sap.ui.dt.plugin.ContextMenu
	 * @experimental Since 1.34. This class is experimental and provides only limited functionality. Also the API might be changed in future.
	 */
	var ContextMenu = Plugin.extend("sap.ui.dt.plugin.ContextMenu", /** @lends sap.ui.rta.plugin.ContextMenu.prototype */
	{
		metadata: {
			// ---- object ----

			// ---- control specific ----
			library: "sap.ui.dt",
			properties: {
				contextElement : {
					type : "object"
				}
			},
			associations: {},
			events: {
				openedContextMenu: {},
				// TODO check if needed and how contextMenuControl handles it...
				closedContextMenu: {}
			}
		}
	});

	/**
	 * Register an overlay
	 *
	 * @param {sap.ui.dt.Overlay} oOverlay overlay object
	 * @override
	 */
	ContextMenu.prototype.registerElementOverlay = function(oOverlay) {
		oOverlay.attachBrowserEvent("contextmenu", this._onContextMenu, this);
		oOverlay.attachBrowserEvent("keydown", this._onKeyDown, this);
	};

	/**
	 * Additionally to super->deregisterOverlay this method detaches the browser events
	 *
	 * @param {sap.ui.dt.Overlay} oOverlay overlay object
	 * @override
	 */
	ContextMenu.prototype.deregisterElementOverlay = function(oOverlay) {
		oOverlay.detachBrowserEvent("contextmenu", this._onContextMenu, this);
		oOverlay.detachBrowserEvent("keydown", this._onKeyDown, this);
	};

	ContextMenu.prototype.init = function() {
		this._aMenuItems = [];
	};

	ContextMenu.prototype.exit = function() {
		delete this._aMenuItems;
		if (this._oContextMenuControl) {
			this._oContextMenuControl.destroy();
			delete this._oContextMenuControl;
		}
	};

	/**
	 * Add menu items in the following format
	 *
	 * @param {object} mMenuItem json object with the menu item settings
	 * @param {string} mMenuItem.id id, which corresponds to the text key
	 * @param {string} aMenuItems.text menu item text (translated)
	 * @param {function} mMenuItem.handler event handler if menu is selected, the element for which the menu was opened is passed to the handler
	 * @param {function} mMenuItem.startSection? function to determine if a new section should be started, the element for which the menu was opened
	 *        is passed to the handler, default false
	 * @param {function} mMenuItem.available? function to determine if the menu entry should be shown, the element for which the menu should be opened
	 *        is passed, default true
	 * @param {function} mMenuItem.enabled? function to determine if the menu entry should be enabled, the element for which the menu should be opened
	 *        is passed, default true
	 */
	ContextMenu.prototype.addMenuItem = function(mMenuItem) {
		this._aMenuItems.push(mMenuItem);
	};

	ContextMenu.prototype.open = function(oOriginalEvent, oTargetOverlay) {
		this.setContextElement(oTargetOverlay.getElementInstance());

		this._oContextMenuControl = new ContextMenuControl();
		this._oContextMenuControl.setMenuItems(this._aMenuItems, oTargetOverlay);
		this._oContextMenuControl.setOverlayDomRef(oTargetOverlay);
		this._oContextMenuControl.attachItemSelect(this._onItemSelected, this);

		this._oContextMenuControl.openMenu({
			pageX: oOriginalEvent.pageX,
			pageY: oOriginalEvent.pageY
		});

		this.fireOpenedContextMenu();
	};

	/**
	 * Called when an context menu item gets selected by user
	 *
	 * @param {sap.ui.base.Event} oEvent event object
	 * @override
	 * @private
	 */
	ContextMenu.prototype._onItemSelected = function(oEvent) {
		var that = this;
		var sId = oEvent.getParameter("item").data("id");
		this._aMenuItems.some(function(oItem) {
			if (sId === oItem.id) {
				var oDesignTime = that.getDesignTime();
				var aSelection = oDesignTime.getSelection();
				oItem.handler(aSelection);
				return true;
			}
		});
	};

	/**
	 * Handle context menu event
	 *
	 * @param {sap.ui.base.Event} oEvent event object
	 * @private
	 */
	ContextMenu.prototype._onContextMenu = function(oEvent) {
		// hide browser-context menu
		oEvent.preventDefault();
		var oOverlay = sap.ui.getCore().byId(oEvent.currentTarget.id);

		if (oOverlay && oOverlay.isSelectable()) {
			if (!oOverlay.isSelected()) {
				oOverlay.setSelected(true);
			}

			this.open(oEvent, oOverlay);
			oEvent.stopPropagation();
		}
	};

	/**
	 * Handle keydown event
	 *
	 * @param {sap.ui.base.Event} oEvent event object
	 * @private
	 */
	ContextMenu.prototype._onKeyDown = function(oEvent) {
		var oOverlay = sap.ui.getCore().byId(oEvent.currentTarget.id);

		if ((oEvent.keyCode === jQuery.sap.KeyCodes.F10) && (oEvent.shiftKey === true) && (oEvent.altKey === false) && (oEvent.ctrlKey === false)) {
			// hide browser-context menu
			oEvent.preventDefault();
			oEvent.stopPropagation();
			if (oOverlay && oOverlay.isSelectable()) {
				if (!oOverlay.isSelected()) {
					oOverlay.setSelected(true);
				}
				var iWidth = oOverlay.$().width() / 2;
				var iHeight = oOverlay.$().height() / 2;
				var iTop = oOverlay.$().offset().top;
				var iLeft = oOverlay.$().offset().left;

				this.open({
					pageX: iLeft + iWidth,
					pageY: iTop + iHeight
				}, oOverlay);
			}
		}
	};

	return ContextMenu;
}, /* bExport= */true);

}; // end of sap/ui/dt/plugin/ContextMenu.js
if ( !jQuery.sap.isDeclared('sap.ui.dt.plugin.ControlDragDrop') ) {
/*
 * ! UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides class sap.ui.dt.plugin.ControlDragDrop.
jQuery.sap.declare('sap.ui.dt.plugin.ControlDragDrop'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
sap.ui.define("sap/ui/dt/plugin/ControlDragDrop",['sap/ui/dt/plugin/DragDrop', 'sap/ui/dt/plugin/ElementMover', 'sap/ui/dt/ElementUtil'], function(
		DragDrop, ElementMover, ElementUtil) {
	"use strict";

	/**
	 * Constructor for a new ControlDragDrop.
	 *
	 * @param {string}
	 *          [sId] id for the new object, generated automatically if no id is given
	 * @param {object}
	 *          [mSettings] initial settings for the new object
	 * @class The ControlDragDrop enables D&D functionality for the overlays based on aggregation types
	 * @extends sap.ui.dt.plugin.DragDrop"
	 * @author SAP SE
	 * @version 1.42.6
	 * @constructor
	 * @private
	 * @since 1.30
	 * @alias sap.ui.dt.plugin.ControlDragDrop
	 * @experimental Since 1.30. This class is experimental and provides only limited functionality. Also the API might be
	 *               changed in future.
	 */
	var ControlDragDrop = DragDrop.extend("sap.ui.dt.plugin.ControlDragDrop", /** @lends sap.ui.dt.plugin.ControlDragDrop.prototype */
	{
		metadata : {
			// ---- object ----

			// ---- control specific ----
			library : "sap.ui.dt",
			properties : {
				draggableTypes : {
					type : "string[]",
					defaultValue : ["sap.ui.core.Element"]
				},
				elementMover : {
					type : "sap.ui.dt.plugin.ElementMover"
				}
			},
			associations : {},
			events : {
				elementMoved : {}
			}
		}
	});

	var sDROP_ZONE_STYLE = "sapUiDtOverlayDropZone";

	ControlDragDrop.prototype.init = function() {
		DragDrop.prototype.init.apply(this, arguments);
		this.setElementMover(new ElementMover());
	};

	/**
	 * @override
	 */
	ControlDragDrop.prototype.setElementMover = function(oNewElementMover) {
		var oOldMover = this.getElementMover();
		if (oOldMover !== oNewElementMover) {
			if (oOldMover) {
				oOldMover.destroy();
			}
			this.setProperty("elementMover", oNewElementMover);
		}
	};

	/**
	 * @override
	 */
	ControlDragDrop.prototype.setDraggableTypes = function(aDraggableTypes) {
		this.getElementMover().setMovableTypes(aDraggableTypes);
		return this.setProperty("draggableTypes", aDraggableTypes);
	};

	/**
	 * @override
	 */
	ControlDragDrop.prototype.registerElementOverlay = function(oOverlay) {
		DragDrop.prototype.registerElementOverlay.apply(this, arguments);
		var oElement = oOverlay.getElementInstance();
		if (this.getElementMover().isMovableType(oElement) && this.getElementMover().checkMovable(oOverlay)) {
			oOverlay.setMovable(true);
		}

		if (this.oDraggedElement) {
			this.getElementMover().activateTargetZonesFor(oOverlay, sDROP_ZONE_STYLE);
		}
	};

	/**
	 * @override
	 */
	ControlDragDrop.prototype.deregisterElementOverlay = function(oOverlay) {
		DragDrop.prototype.deregisterElementOverlay.apply(this, arguments);
		oOverlay.setMovable(false);

		if (this.oDraggedElement) {
			this.getElementMover().deactivateTargetZonesFor(oOverlay, sDROP_ZONE_STYLE);
		}
	};

	/**
	 * returns the dragged overlay (only during drag&drop)
	 *
	 * @public
	 * @return {sap.ui.dt.Overlay} overlays which is dragged
	 */
	ControlDragDrop.prototype.getDraggedOverlay = function() {
		return this._oDraggedOverlay;
	};

	/**
	 * @override
	 */
	ControlDragDrop.prototype.onDragStart = function(oOverlay, oEvent) {
		this._oDraggedOverlay = oOverlay;
		this.getElementMover().setMovedOverlay(oOverlay);

		this.getElementMover().activateAllValidTargetZones(this.getDesignTime(), sDROP_ZONE_STYLE);
	};

	/**
	 * @override
	 */
	ControlDragDrop.prototype.onDragEnd = function(oOverlay) {
		this.fireElementModified({
			"command" : this.getElementMover().buildMoveEvent()
		});
		delete this._oPreviousTarget;
		this.getElementMover().deactivateAllTargetZones(this.getDesignTime(), sDROP_ZONE_STYLE);
		delete this._oDraggedOverlay;
		this.getElementMover().setMovedOverlay(null);
	};

	/**
	 * @override
	 */
	ControlDragDrop.prototype.onDragEnter = function(oTargetOverlay, oEvent) {
		var oDraggedOverlay = this.getDraggedOverlay();
		if (oTargetOverlay.getElementInstance() !== oDraggedOverlay.getElementInstance()
				&& oTargetOverlay !== this._oPreviousTarget) {
			this.getElementMover().repositionOn(oDraggedOverlay, oTargetOverlay);
		}
		this._oPreviousTarget = oTargetOverlay;
	};

	/**
	 * @override
	 */
	ControlDragDrop.prototype.onAggregationDragEnter = function(oAggregationOverlay) {
		delete this._oPreviousTarget;

		var oDraggedOverlay = this.getDraggedOverlay();
		this.getElementMover().insertInto(oDraggedOverlay, oAggregationOverlay);
	};

	return ControlDragDrop;
}, /* bExport= */true);

}; // end of sap/ui/dt/plugin/ControlDragDrop.js
if ( !jQuery.sap.isDeclared('sap.ui.dt.plugin.CutPaste') ) {
/*
 * ! UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides class sap.ui.dt.plugin.CutPaste.
jQuery.sap.declare('sap.ui.dt.plugin.CutPaste'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
sap.ui.define("sap/ui/dt/plugin/CutPaste",[
	'sap/ui/dt/Plugin', 'sap/ui/dt/plugin/ElementMover', 'sap/ui/dt/OverlayUtil'
], function(Plugin, ElementMover, OverlayUtil) {
	"use strict";

	/**
	 * Constructor for a new CutPaste.
	 *
	 * @param {string} [sId] id for the new object, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new object
	 * @class The CutPaste enables Cut & Paste functionality for the overlays based on aggregation types
	 * @extends sap.ui.dt.Plugin"
	 * @author SAP SE
	 * @version 1.42.6
	 * @constructor
	 * @private
	 * @since 1.34
	 * @alias sap.ui.dt.plugin.CutPaste
	 * @experimental Since 1.34. This class is experimental and provides only limited functionality. Also the API might be changed in future.
	 */
	var CutPaste = Plugin.extend("sap.ui.dt.plugin.CutPaste", /** @lends sap.ui.dt.plugin.CutPaste.prototype */
	{
		metadata: {
			// ---- object ----

			// ---- control specific ----
			library: "sap.ui.dt",
			properties: {
				movableTypes: {
					type: "string[]",
					defaultValue: [
						"sap.ui.core.Element"
					]
				},
				elementMover: {
					type: "sap.ui.dt.plugin.ElementMover"
				}
			},
			associations: {},
			events: {
				elementMoved: {}
			}
		}
	});

	CutPaste.prototype.init = function() {
		this.setElementMover(new ElementMover());
	};

	/**
	 * @override
	 */
	CutPaste.prototype.registerElementOverlay = function(oOverlay) {
		var oElement = oOverlay.getElementInstance();
		//Register key down so that ESC is possible on all overlays
		oOverlay.attachBrowserEvent("keydown", this._onKeyDown, this);
		if (this.getElementMover().isMovableType(oElement) && this.getElementMover().checkMovable(oOverlay)) {
			oOverlay.setMovable(true);
		}

		if (this.getElementMover().getMovedOverlay()) {
			this.getElementMover().activateTargetZonesFor(this.getElementMover().getMovedOverlay());
		}
	};

	/**
	 * @override
	 */
	CutPaste.prototype.deregisterElementOverlay = function(oOverlay) {
		oOverlay.setMovable(false);
		oOverlay.detachBrowserEvent("keydown", this._onKeyDown, this);

		if (this.getElementMover().getMovedOverlay()) {
			this.getElementMover().deactivateTargetZonesFor(this.getElementMover().getMovedOverlay());
		}
	};

	CutPaste.prototype.setMovableTypes = function(aMovableTypes) {
		this.getElementMover().setMovableTypes(aMovableTypes);
		return this.setProperty("movableTypes", aMovableTypes);
	};

	CutPaste.prototype.setElementMover = function(oElementMover) {
		oElementMover.setMovableTypes(this.getMovableTypes());
		return this.setProperty("elementMover", oElementMover);
	};

	CutPaste.prototype.getCuttedOverlay = function() {
		return this.getElementMover().getMovedOverlay();
	};

	CutPaste.prototype.isElementPasteable = function(oTargetOverlay) {
		var oTargetZoneAggregation = this._getTargetZoneAggregation(oTargetOverlay);
		if ((oTargetZoneAggregation) || (OverlayUtil.isInTargetZoneAggregation(oTargetOverlay))) {
			return true;
		} else {
			return false;
		}
	};

	CutPaste.prototype._onKeyDown = function(oEvent) {
		var oOverlay = sap.ui.getCore().byId(oEvent.currentTarget.id);

		if ((oEvent.keyCode === jQuery.sap.KeyCodes.X) && (oEvent.shiftKey === false) && (oEvent.altKey === false) && (oEvent.ctrlKey === true)) {
			// CTRL+X
			this.cut(oOverlay);
			oEvent.stopPropagation();
		} else if ((oEvent.keyCode === jQuery.sap.KeyCodes.V) && (oEvent.shiftKey === false) && (oEvent.altKey === false) && (oEvent.ctrlKey === true)) {
			// CTRL+V
			this.paste(oOverlay);
			oEvent.stopPropagation();
		} else if (oEvent.keyCode === jQuery.sap.KeyCodes.ESCAPE) {
			// ESC
			this.stopCutAndPaste();
			oEvent.stopPropagation();
		}
	};

	CutPaste.prototype.cut = function(oOverlay) {
		this.stopCutAndPaste();

		if (oOverlay.isMovable()) {
			this.getElementMover().setMovedOverlay(oOverlay);
			oOverlay.addStyleClass("sapUiDtOverlayCutted");

			this.getElementMover().activateAllValidTargetZones(this.getDesignTime());
		}
	};

	CutPaste.prototype.paste = function(oTargetOverlay) {
		var oCutOverlay = this.getElementMover().getMovedOverlay();
		if (!oCutOverlay) {
			return;
		}
		if (!this._isForSameElement(oCutOverlay, oTargetOverlay)) {

			var oTargetZoneAggregation = this._getTargetZoneAggregation(oTargetOverlay);
			if (oTargetZoneAggregation) {
				this.getElementMover().insertInto(oCutOverlay, oTargetZoneAggregation);
			} else if (OverlayUtil.isInTargetZoneAggregation(oTargetOverlay)) {
					this.getElementMover().repositionOn(oCutOverlay, oTargetOverlay);
			} else {
				return;
			}

			this.fireElementModified({
				"command" : this.getElementMover().buildMoveEvent()
			});
		}

		// focus get invalidated, see https://support.wdf.sap.corp/sap/support/message/1580061207
		setTimeout(function(){
			oCutOverlay.focus();
		},0);

		this.stopCutAndPaste();
	};

	CutPaste.prototype.stopCutAndPaste = function() {
		var oCutOverlay = this.getElementMover().getMovedOverlay();
		if (oCutOverlay) {
			oCutOverlay.removeStyleClass("sapUiDtOverlayCutted");
			this.getElementMover().setMovedOverlay(null);
			this.getElementMover().deactivateAllTargetZones(this.getDesignTime());
		}
	};

	CutPaste.prototype._isForSameElement = function(oCutOverlay, oTargetOverlay) {
		return oTargetOverlay.getElementInstance() === oCutOverlay.getElementInstance();
	};

	CutPaste.prototype._getTargetZoneAggregation = function(oTargetOverlay) {
		var aAggregationOverlays = oTargetOverlay.getAggregationOverlays();
		var aPossibleTargetZones = aAggregationOverlays.filter(function(oAggregationOverlay) {
			return oAggregationOverlay.isTargetZone();
		});
		if (aPossibleTargetZones.length > 0) {
			return aPossibleTargetZones[0];
		} else {
			return null;
		}
	};

	return CutPaste;
}, /* bExport= */true);

}; // end of sap/ui/dt/plugin/CutPaste.js
if ( !jQuery.sap.isDeclared('sap.ui.dt.plugin.TabHandling') ) {
/*
 * ! UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.dt.plugin.TabHandling'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/dt/plugin/TabHandling",[
	'jquery.sap.global', 'sap/ui/dt/Plugin', 'sap/ui/dt/Overlay'
], function(jQuery, Plugin, Overlay) {
	"use strict";

	/**
	 * Constructor for a new TabHandling.
	 *
	 * @param {string} [sId] id for the new object, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new object
	 * @class The TabHandling plugin adjusts the tabindex for the elements.
	 * @extends sap.ui.dt.Plugin
	 * @author SAP SE
	 * @version 1.42.6
	 * @constructor
	 * @private
	 * @since 1.38
	 * @alias sap.ui.dt.plugin.TabHandling
	 * @experimental Since 1.38. This class is experimental and provides only limited functionality. Also the API might be changed in future.
	 */
	var TabHandling = Plugin.extend("sap.ui.dt.plugin.TabHandling", /** @lends sap.ui.dt.plugin.TabHandling.prototype */
	{
		metadata: {
			// ---- object ----

			// ---- control specific ----
			library: "sap.ui.dt",
			properties: {},
			associations: {},
			events: {}
		}
	});


	TabHandling.prototype.registerElementOverlay = function(oOverlay) {
		if (oOverlay.isRoot()) {
			this._removeTabIndex();
		}
	};

	/**
	 * Deregister an overlay
	 *
	 * @param {sap.ui.dt.Overlay} oOverlay overlay object
	 * @override
	 */
	TabHandling.prototype.deregisterElementOverlay = function(oOverlay) {
		if (oOverlay.isRoot()) {
			this._restoreTabIndex();
		}
	};

	TabHandling.prototype.setDesignTime = function(oDesignTime) {
		Plugin.prototype.setDesignTime.apply(this, arguments);
		if (oDesignTime) {
			if (!this._oMutationObserver) {
				this._oMutationObserver = Overlay.getMutationObserver();
				this._oMutationObserver.attachDomChanged(this._onDomChanged, this);
			}
		} else {
			this._oMutationObserver.detachDomChanged(this._onDomChanged, this);
			delete this._oMutationObserver;
			this._restoreTabIndex();
		}
	};

	/**
	 * Traverse the whole DOM tree and set tab indices to -1 for all elements
	 *
	 * @param {sap.ui.core.Element} oRootDom object of the root DOM element
	 * @private
	 */
	TabHandling.prototype._removeTabIndex = function() {
		var oDesignTime = this.getDesignTime();
		var aRootElements = oDesignTime.getRootElements();
		aRootElements.forEach(function(sRootElement) {
			var oRootDom = sap.ui.getCore().byId(sRootElement).getDomRef();
			jQuery(oRootDom).find(":focusable:not([tabIndex=-1], #overlay-container *)").each(function(iIndex, oNode) {
				oNode.setAttribute("data-sap-ui-dt-tabindex", oNode.tabIndex);
				oNode.setAttribute("tabIndex", -1);
			});
		});
	};

	/**
	 * Restore the tab indices of all elements of the DOM tree
	 *
	 * @private
	 */
	TabHandling.prototype._restoreTabIndex = function() {
		jQuery("[data-sap-ui-dt-tabindex]").each(function(iIndex, oNode) {
			oNode.setAttribute("tabIndex", oNode.getAttribute("data-sap-ui-dt-tabindex"));
			oNode.removeAttribute("data-sap-ui-dt-tabindex");
		});
	};

	/**
	 * @private
	 */
	TabHandling.prototype._onDomChanged = function() {
		this._removeTabIndex();
	};

	return TabHandling;
}, /* bExport= */true);

}; // end of sap/ui/dt/plugin/TabHandling.js
if ( !jQuery.sap.isDeclared('sap.ui.dt.AggregationDesignTimeMetadata') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides class sap.ui.dt.AggregationDesignTimeMetadata.
jQuery.sap.declare('sap.ui.dt.AggregationDesignTimeMetadata'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/dt/AggregationDesignTimeMetadata",[
	'jquery.sap.global',
	'sap/ui/dt/DesignTimeMetadata'
],
function(jQuery, DesignTimeMetadata) {
	"use strict";


	/**
	 * Constructor for a new AggregationDesignTimeMetadata.
	 *
	 * @param {string} [sId] id for the new object, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new object
	 *
	 * @class
	 * The AggregationDesignTimeMetadata is a wrapper for the AggregationDesignTimeMetadata of the associated element
	 * @extends sap.ui.core.DesignTimeMetadata
	 *
	 * @author SAP SE
	 * @version 1.42.6
	 *
	 * @constructor
	 * @private
	 * @since 1.30
	 * @alias sap.ui.dt.AggregationDesignTimeMetadata
	 * @experimental Since 1.30. This class is experimental and provides only limited functionality. Also the API might be changed in future.
	 */
	var AggregationDesignTimeMetadata = DesignTimeMetadata.extend("sap.ui.dt.AggregationDesignTimeMetadata", /** @lends sap.ui.dt.AggregationDesignTimeMetadata.prototype */ {
		metadata : {
			// ---- object ----

			// ---- control specific ----
			library : "sap.ui.dt"
		}
	});

	AggregationDesignTimeMetadata.prototype.getMoveAction = function(oMovedElement){
		var mData = this.getData();
		if (mData.actions && mData.actions.move) {
			var vMoveChangeType = mData.actions.move;
			if (typeof (vMoveChangeType) === "function" ){
				return vMoveChangeType.apply(null, arguments);
			} else {
				return vMoveChangeType;
			}
		} else {
			return undefined;
		}

	};

	return AggregationDesignTimeMetadata;
}, /* bExport= */ true);

}; // end of sap/ui/dt/AggregationDesignTimeMetadata.js
if ( !jQuery.sap.isDeclared('sap.ui.dt.AggregationOverlay') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides class sap.ui.dt.AggregationOverlay.
jQuery.sap.declare('sap.ui.dt.AggregationOverlay'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/dt/AggregationOverlay",[
	'jquery.sap.global',
	'sap/ui/dt/Overlay',
	'sap/ui/dt/DOMUtil',
	'sap/ui/dt/ElementUtil',
	'sap/ui/dt/OverlayUtil'
],
function(jQuery, Overlay, DOMUtil, ElementUtil, OverlayUtil) {
	"use strict";


	/**
	 * Constructor for an AggregationOverlay.
	 *
	 * @param {string} [sId] id for the new object, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new object
	 *
	 * @class
	 * The AggregationOverlay allows to create an absolute positioned DIV above the aggregation
	 * of an element.
	 * @extends sap.ui.core.Overlay
	 *
	 * @author SAP SE
	 * @version 1.42.6
	 *
	 * @constructor
	 * @private
	 * @since 1.30
	 * @alias sap.ui.dt.AggregationOverlay
	 * @experimental Since 1.30. This class is experimental and provides only limited functionality. Also the API might be changed in future.
	 */
	var AggregationOverlay = Overlay.extend("sap.ui.dt.AggregationOverlay", /** @lends sap.ui.dt.AggregationOverlay.prototype */ {
		metadata : {
			// ---- object ----

			// ---- control specific ----
			library : "sap.ui.dt",
			properties : {
				/**
				 * Name of aggregation to create the AggregationOverlay for
				 */
				aggregationName : {
					type : "string"
				},
				/**
				 * Whether the AggregationOverlay is e.g. a drop target
				 */
				targetZone : {
					type : "boolean",
					defaultValue : false
				}
			},
			aggregations : {
				/**
				 * Overlays for the elements, which are public children of this aggregation
				 */
				children : {
					type : "sap.ui.dt.Overlay",
					multiple : true
				},
				/**
				 * [designTimeMetadata description]
				 * @type {Object}
				 */
				designTimeMetadata : {
					type : "sap.ui.dt.AggregationDesignTimeMetadata",
					multiple : false
				}
			},
			events : {
				/**
				 * Event fired when the property "targetZone" was changed
				 */
				targetZoneChange : {
					parameters : {
						targetZone : { type : "boolean" }
					}
				}
			}
		}
	});

	/**
	 * Returns a DOM representation for an aggregation, associated with this AggregationOverlay, if it can be found or undefined
	 * Representation is searched in DOM based on DesignTimeMetadata defined for the parent Overlay
	 * @return {Element} Associated with this AggregationOverlay DOM Element or null, if it can't be found
	 * @public
	 */
	AggregationOverlay.prototype.getAssociatedDomRef = function() {
		var oElement = this.getElementInstance();
		var sAggregationName = this.getAggregationName();

		var oElementDomRef = ElementUtil.getDomRef(oElement);
		var oDesignTimeMetadata = this.getDesignTimeMetadata();
		var vAggregationDomRef = oDesignTimeMetadata.getDomRef();
		if (oElementDomRef) {
			if (typeof vAggregationDomRef === "function") {
				return vAggregationDomRef.call(oElement, sAggregationName);
			} else if (typeof vAggregationDomRef === "string") {
				return DOMUtil.getDomRefForCSSSelector(oElementDomRef, vAggregationDomRef).get(0);
			}
		} else {
			if (typeof vAggregationDomRef === "function") {
				return vAggregationDomRef.call(oElement, sAggregationName);
			}
		}
	};

	/**
	 * Sets a property "targetZone", toggles a CSS class for the DomRef based on a property's value and fires "targetZoneChange" event
	 * @param {boolean} bTargetZone state to set
	 * @returns {sap.ui.dt.AggregationOverlay} returns this
	 * @public
	 */
	AggregationOverlay.prototype.setTargetZone = function(bTargetZone) {
		if (this.getTargetZone() !== bTargetZone) {
			this.setProperty("targetZone", bTargetZone);
			this.toggleStyleClass("sapUiDtOverlayTargetZone", bTargetZone);

			this.fireTargetZoneChange({targetZone : bTargetZone});
		}

		return this;
	};

	/**
	 * Returns if the AggregationOverlay is a target zone
	 * @public
	 * @return {boolean} if the AggregationOverlay is a target zone
	 */
	AggregationOverlay.prototype.isTargetZone = function() {
		return this.getTargetZone();
	};

	/**
	 * Returns an array with Overlays for the public children of the aggregation, associated with this AggregationOverlay
	 * @return {sap.ui.dt.Overlay[]} children Overlays
	 * @public
	 */
	AggregationOverlay.prototype.getChildren = function() {
		return this.getAggregation("children") || [];
	};

	return AggregationOverlay;
}, /* bExport= */ true);

}; // end of sap/ui/dt/AggregationOverlay.js
if ( !jQuery.sap.isDeclared('sap.ui.dt.ElementDesignTimeMetadata') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides class sap.ui.dt.ElementDesignTimeMetadata.
jQuery.sap.declare('sap.ui.dt.ElementDesignTimeMetadata'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/dt/ElementDesignTimeMetadata",[
	'jquery.sap.global',
	'sap/ui/dt/DesignTimeMetadata',
	'sap/ui/dt/AggregationDesignTimeMetadata'
],
function(jQuery, DesignTimeMetadata, AggregationDesignTimeMetadata) {
	"use strict";


	/**
	 * Constructor for a new ElementDesignTimeMetadata.
	 *
	 * @param {string} [sId] id for the new object, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new object
	 *
	 * @class
	 * The ElementDesignTimeMetadata is a wrapper for the ElementDesignTimeMetadata of the associated element
	 * @extends sap.ui.core.DesignTimeMetadata
	 *
	 * @author SAP SE
	 * @version 1.42.6
	 *
	 * @constructor
	 * @private
	 * @since 1.30
	 * @alias sap.ui.dt.ElementDesignTimeMetadata
	 * @experimental Since 1.30. This class is experimental and provides only limited functionality. Also the API might be changed in future.
	 */
	var ElementDesignTimeMetadata = DesignTimeMetadata.extend("sap.ui.dt.ElementDesignTimeMetadata", /** @lends sap.ui.dt.ElementDesignTimeMetadata.prototype */ {
		metadata : {
			// ---- object ----

			// ---- control specific ----
			library : "sap.ui.dt"
		}
	});

	/**
	 * Returns the default DT metadata
	 * @return {Object} default data
	 * @override
	 */
	ElementDesignTimeMetadata.prototype.getDefaultData = function(oData) {
		var oDefaultData = DesignTimeMetadata.prototype.getDefaultData.apply(this, arguments);

		oDefaultData.aggregations  = {
			layout : {
				ignore : true
			},
			dependents : {
				ignore : true
			},
			customData : {
				ignore : true
			},
			layoutData : {
				ignore : true
			},
			tooltip: {
				ignore : true
			}
		};

		return oDefaultData;
	};

	/**
	 * Returns if the DT metadata for an aggregation name exists
	 * @param {string} sAggregationName an aggregation name
	 * @return {boolean} returns if the field for an aggregation with a given name exists in DT metadata
	 * @public
	 */
	ElementDesignTimeMetadata.prototype.hasAggregation = function(sAggregationName) {
		return !!this.getAggregations()[sAggregationName];
	};

	/**
	 * Returns the plain DT metadata for an aggregation name
	 * @param {string} sAggregationName an aggregation name
	 * @return {object} returns the DT metadata for an aggregation with a given name
	 * @public
	 */
	ElementDesignTimeMetadata.prototype.getAggregation = function(sAggregationName) {
		return this.getAggregations()[sAggregationName];
	};

	/**
	 * Creates a aggregation DT metadata class for an aggregation,
	 * ensure to destroy it if it is no longer needed, otherwise you get memory leak.
	 * @param {string} sAggregationName an aggregation name
	 * @return {sap.ui.dt.AggregationDesignTimeMetadata} returns the aggregation DT metadata for an aggregation with a given name
	 * @public
	 */
	ElementDesignTimeMetadata.prototype.createAggregationDesignTimeMetadata  = function(sAggregationName) {
		var oData =  this.getAggregation(sAggregationName);
		return new AggregationDesignTimeMetadata({data : oData});
	};

	/**
	 * Returns the DT metadata for all aggregations
	 * @return {map} returns the DT metadata for all aggregations
	 * @public
	 */
	ElementDesignTimeMetadata.prototype.getAggregations = function() {
		return this.getData().aggregations;
	};

	/**
	 * Returns the relevant container of an element
	 * This is usually the getParent or the value from a function in DTMetadata
	 * @param {object} oElement the element for which the relevant container has to be evaluated
	 * @return {object} returns the relevant container
	 * @public
	 */
	ElementDesignTimeMetadata.prototype.getRelevantContainer = function(oElement) {
		var fnGetRelevantContainer = this.getData().getRelevantContainer;
		if (!fnGetRelevantContainer || typeof fnGetRelevantContainer !== "function") {
			return oElement.getParent();
		}
		return fnGetRelevantContainer(oElement);
	};

	return ElementDesignTimeMetadata;
}, /* bExport= */ true);

}; // end of sap/ui/dt/ElementDesignTimeMetadata.js
if ( !jQuery.sap.isDeclared('sap.ui.dt.ElementOverlay') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides class sap.ui.dt.ElementOverlay.
jQuery.sap.declare('sap.ui.dt.ElementOverlay'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
sap.ui.define("sap/ui/dt/ElementOverlay",[
	'sap/ui/dt/Overlay',
	'sap/ui/dt/ControlObserver',
	'sap/ui/dt/ManagedObjectObserver',
	'sap/ui/dt/ElementDesignTimeMetadata',
	'sap/ui/dt/AggregationDesignTimeMetadata',
	'sap/ui/dt/AggregationOverlay',
	'sap/ui/dt/OverlayRegistry',
	'sap/ui/dt/ElementUtil',
	'sap/ui/dt/OverlayUtil',
	'sap/ui/dt/DOMUtil'
],
function(Overlay, ControlObserver, ManagedObjectObserver, ElementDesignTimeMetadata, AggregationDesignTimeMetadata, AggregationOverlay, OverlayRegistry, ElementUtil, OverlayUtil, DOMUtil) {
	"use strict";

	/**
	 * Constructor for an ElementOverlay.
	 *
	 * @param {string} [sId] id for the new object, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new object
	 *
	 * @class
	 * The ElementOverlay allows to create an absolute positioned DIV above the associated element.
	 * It also creates AggregationOverlays for every public aggregation of the associated element.
	 * @extends sap.ui.core.Control
	 *
	 * @author SAP SE
	 * @version 1.42.6
	 *
	 * @constructor
	 * @private
	 * @since 1.30
	 * @alias sap.ui.dt.ElementOverlay
	 * @experimental Since 1.30. This class is experimental and provides only limited functionality. Also the API might be changed in future.
	 */
	var ElementOverlay = Overlay.extend("sap.ui.dt.ElementOverlay", /** @lends sap.ui.dt.ElementOverlay.prototype */ {
		metadata : {

			// ---- object ----

			// ---- control specific ----
			library : "sap.ui.dt",
			properties : {
				/**
				 * Whether the ElementOverlay is selected
				 */
				selected : {
					type : "boolean",
					defaultValue : false
				},
				/**
				 * Whether the ElementOverlay is selectable, per default this implicitly makes the overlay focusable (TODO discuss)
				 */
				selectable : {
					type : "boolean",
					defaultValue : false
				},
				/**
				 * Whether the ElementOverlay is movable
				 */
				movable : {
					type : "boolean",
					defaultValue : false
				},
				/**
				 * Whether the ElementOverlay is editable
				 */
				editable : {
					type : "boolean",
					defaultValue : false
				}
			},
			aggregations : {
				/**
				 * AggregationOverlays for the public aggregations of the associated Element
				 */
				aggregationOverlays : {
					type : "sap.ui.dt.AggregationOverlay",
					multiple : true
				},
				/**
				 * [designTimeMetadata description]
				 * @type {Object}
				 */
				designTimeMetadata : {
					type : "sap.ui.dt.ElementDesignTimeMetadata",
					altTypes : ["object"],
					multiple : false
				}
			},
			events : {
				/**
				 * Event fired when the property "Selection" is changed
				 */
				selectionChange : {
					parameters : {
						selected : { type : "boolean" }
					}
				},
				/**
				 * Event fired when the property "Movable" is changed
				 */
				movableChange : {
					parameters : {
						movable : { type : "boolean" }
					}
				},
				/**
				 * Event fired when the property "Selectable" is changed
				 */
				selectableChange : {
					parameters : {
						selectable : { type : "boolean" }
					}
				},
				/**
				 * Event fired when the property "Editable" is changed
				 */
				editableChange : {
					parameters : {
						editable : { type : "boolean" }
					}
				},
				/**
				 * Event fired when the associated Element is modified
				 */
				elementModified : {
					parameters : {
						type : "string",
						name : "string",
						value : "any",
						oldValue : "any",
						target : "sap.ui.core.Element"
					}
				},
				/**
				 * TODO
				 */
				requestElementOverlaysForAggregation : {
					parameters : {
						name : { type : "string" }
					}
				}
			}
		}
	});

	/**
	 * Called when the ElementOverlay is initialized
	 * @protected
	 */
	ElementOverlay.prototype.init = function() {
		Overlay.prototype.init.apply(this, arguments);

		this._oMutationObserver = Overlay.getMutationObserver();
		this._oMutationObserver.attachDomChanged(this._onDomChanged, this);
	};

	/**
	 * Called when the ElementOverlay is destroyed
	 * @protected
	 */
	ElementOverlay.prototype.exit = function() {
		if (this._oMutationObserver) {
			this._oMutationObserver.detachDomChanged(this._onDomChanged, this);
			delete this._oMutationObserver;
		}

		Overlay.prototype.exit.apply(this, arguments);

		this._unobserve();
		OverlayRegistry.deregister(this._sElementId);

		if (!OverlayRegistry.hasOverlays()) {
			Overlay.destroyMutationObserver();
			Overlay.removeOverlayContainer();
		}

		delete this._sElementId;
	};

	/**
	 * @override
	 */
	ElementOverlay.prototype.setLazyRendering = function(bLazyRendering) {
		Overlay.prototype.setLazyRendering.apply(this, arguments);

		if (!bLazyRendering) {
			this.placeInOverlayContainer();
		}
	};

	/**
	 * Places this ElementOverlay in an overlay container, which causes a rendering only if overlay wasn't rendered before
	 * Overlay won't be visible without a call of this method
	 * @public
	 */
	ElementOverlay.prototype.placeInOverlayContainer = function() {
		if (!this.getParent()) {
			this.placeAt(Overlay.getOverlayContainer());
			// this is needed to prevent UI5 renderManager from removing overlay's node from DOM in a rendering phase
			// see RenderManager.js "this._fPutIntoDom" function
			var oUIArea = this.getUIArea();
			oUIArea._onChildRerenderedEmpty = function() {
				return true;
			};
		}
	};

	/**
	 * Sets an associated Element to create an overlay for
	 * @param {string|sap.ui.core.Element} vElement element or element's id
	 * @returns {sap.ui.dt.ElementOverlay} returns this
	 * @public
	 */
	ElementOverlay.prototype.setElement = function(vElement) {
		var oOldElement = this.getElementInstance();
		if (oOldElement instanceof sap.ui.core.Element) {
			OverlayRegistry.deregister(oOldElement);
			this._unobserve();
		}

		this.setAssociation("element", vElement);
		var oElement = this.getElementInstance();

		this._sElementId = oElement.getId();
		OverlayRegistry.register(oElement, this);
		this._observe(oElement);

		if (this.getDesignTimeMetadata()) {
			this._renderAndCreateAggregation();
		}

		return this;
	};

	/**
	 * @override
	 */
	ElementOverlay.prototype.setDesignTimeMetadata = function(vDesignTimeMetada) {
		var oDesignTimeMetada;
		if (vDesignTimeMetada instanceof ElementDesignTimeMetadata) {
			oDesignTimeMetada = vDesignTimeMetada;
		} else {
			oDesignTimeMetada = new ElementDesignTimeMetadata({
				data : vDesignTimeMetada
			});
		}

		var oReturn = this.setAggregation("designTimeMetadata", oDesignTimeMetada);

		if (this.getElementInstance()) {
			this._renderAndCreateAggregation();
		}

		return oReturn;
	};

	/**
	 * @private
	 */
	ElementOverlay.prototype._renderAndCreateAggregation = function() {
		// detach all children, so then they won't be destroyed
		this.getAggregationOverlays().forEach(function(oAggregationOverlay) {
			oAggregationOverlay.getChildren().forEach(function(oElementOverlay) {
				oElementOverlay.setParent(null);
			});
		});
		this.destroyAggregationOverlays();

		this._createAggregationOverlays();

		var oParentElementOverlay = OverlayUtil.getClosestOverlayFor(this.getElementInstance().getParent());
		if (oParentElementOverlay) {
			oParentElementOverlay.sync();
		}
	};

	/**
	 * Returns a DOM reference for the associated Element or null, if it can't be found
	 * @return {Element} DOM element or null
	 * @public
	 */
	ElementOverlay.prototype.getAssociatedDomRef = function() {
		return ElementUtil.getDomRef(this.getElementInstance());
	};

	/**
	 * Sets whether the ElementOverlay is selectable
	 * @param {boolean} bSelectable if the ElementOverlay is selectable
	 * @returns {sap.ui.dt.ElementOverlay} returns this
	 * @public
	 */
	ElementOverlay.prototype.setSelectable = function(bSelectable) {
		if (bSelectable !== this.isSelectable()) {

			if (!bSelectable) {
				this.setSelected(false);
			}

			this.toggleStyleClass("sapUiDtOverlaySelectable", bSelectable);
			this.setProperty("selectable", bSelectable);
			this.fireSelectableChange({selectable : bSelectable});
		}
		this.setFocusable(bSelectable);
		return this;
	};

	/**
	 * Sets whether the ElementOverlay is selected and toggles corresponding css class
	 * @param {boolean} bSelected if the ElementOverlay is selected
	 * @param {boolean} bSuppressEvent (internal use only) supress firing "selectionChange" event
	 * @returns {sap.ui.dt.ElementOverlay} returns this
	 * @public
	 */
	ElementOverlay.prototype.setSelected = function(bSelected, bSuppressEvent) {
		if (this.isSelectable() && bSelected !== this.isSelected()) {
			this.setProperty("selected", bSelected);
			this.toggleStyleClass("sapUiDtOverlaySelected", bSelected);

			if (!bSuppressEvent) {
				this.fireSelectionChange({
					selected : bSelected
				});
			}
		}

		return this;
	};

	/**
	 * Sets whether the ElementOverlay is movable and toggles corresponding css class
	 * @param {boolean} bMovable if the ElementOverlay is movable
	 * @returns {sap.ui.dt.ElementOverlay} returns this
	 * @public
	 */
	ElementOverlay.prototype.setMovable = function(bMovable) {
		if (this.getMovable() !== bMovable) {
			this.toggleStyleClass("sapUiDtOverlayMovable", bMovable);

			this.setProperty("movable", bMovable);
			this.fireMovableChange({movable : bMovable});
		}

		return this;
	};

	/**
	 * Sets whether the ElementOverlay is editable and toggles corresponding css class
	 * @param {boolean} bEditable if the ElementOverlay is editable
	 * @returns {sap.ui.dt.ElementOverlay} returns this
	 * @public
	 */
	ElementOverlay.prototype.setEditable = function(bEditable) {
		if (this.getEditable() !== bEditable) {
			this.toggleStyleClass("sapUiDtOverlayEditable", bEditable);

			this.setProperty("editable", bEditable);
			this.fireEditableChange({editable : bEditable});
		}

		return this;
	};

	/**
	 * @public
	 */
	ElementOverlay.prototype.sync = function() {
		var that = this;

		if (this.isVisible()) {
			var aAggregationOverlays = this.getAggregationOverlays();
			aAggregationOverlays.forEach(function(oAggregationOverlay) {
				that._syncAggregationOverlay(oAggregationOverlay);
			});
		}
	};

	/**
	 * @private
	 */
	ElementOverlay.prototype._createAggregationOverlay = function(sAggregationName, bInHiddenTree) {
		var oAggregationDesignTimeMetadata = this.getDesignTimeMetadata().createAggregationDesignTimeMetadata(sAggregationName);

		var oAggregationOverlay = new AggregationOverlay({
			aggregationName : sAggregationName,
			element : this.getElementInstance(),
			designTimeMetadata : oAggregationDesignTimeMetadata,
			inHiddenTree : bInHiddenTree
		});
		this._mAggregationOverlays[sAggregationName] = oAggregationOverlay;
		this.addAggregation("aggregationOverlays", oAggregationOverlay);

		this._syncAggregationOverlay(oAggregationOverlay);

		oAggregationOverlay.attachVisibleChanged(this._onAggregationVisibleChanged, this);

		return oAggregationOverlay;
	};

	/**
	 * @private
	 */
	ElementOverlay.prototype._createAggregationOverlays = function() {
		var that = this;
		this._mAggregationOverlays = {};

		var oElement = this.getElementInstance();
		var oDesignTimeMetadata = this.getDesignTimeMetadata();

		var mAggregationsWithOverlay = {};

		ElementUtil.iterateOverAllPublicAggregations(oElement, function(oAggregation, aAggregationElements) {
			var sAggregationName = oAggregation.name;
			mAggregationsWithOverlay[sAggregationName] = true;
			that._createAggregationOverlay(sAggregationName, that.isInHiddenTree());
		});

		// create aggregation overlays also for a hidden aggregations which are not ignored in the DT Metadata
		var mAggregationsMetadata = oDesignTimeMetadata.getAggregations();
		var aAggregationNames = Object.keys(mAggregationsMetadata);
		aAggregationNames.forEach(function (sAggregationName) {
			var oAggregationMetadata = mAggregationsMetadata[sAggregationName];
			if (oAggregationMetadata.ignore === false && !mAggregationsWithOverlay[sAggregationName]) {
				that._createAggregationOverlay(sAggregationName, true);
			}
		});

		this.sync();
	};

	/**
	 * @param {sap.ui.core.Element} oElement The element to observe
	 * @private
	 */
	ElementOverlay.prototype._observe = function(oElement) {
		if (oElement instanceof sap.ui.core.Control) {
			this._oObserver = new ControlObserver({
				target : oElement
			});
			this._oObserver.attachAfterRendering(this._onElementAfterRendering, this);
		} else {
			this._oObserver = new ManagedObjectObserver({
				target : oElement
			});
		}
		this._oObserver.attachModified(this._onElementModified, this);
		this._oObserver.attachDestroyed(this._onElementDestroyed, this);
	};

	/**
	 * @private
	 */
	ElementOverlay.prototype._unobserve = function() {
		if (this._oObserver) {
			this._oObserver.destroy();
		}
	};

	/**
	 * @private
	 */
	ElementOverlay.prototype._onAggregationVisibleChanged = function(oEvent) {
		var oAggregationOverlay = oEvent.getSource();
		this._syncAggregationOverlay(oAggregationOverlay);
	};

	/**
	 * @param {sap.ui.dt.AggregationOverlay} oAggregationOverlay to sync
	 * @private
	 */
	ElementOverlay.prototype._syncAggregationOverlay = function(oAggregationOverlay) {
		var that = this;

		if (oAggregationOverlay.isVisible()) {
			var sAggregationName = oAggregationOverlay.getAggregationName();

			var bIsControl = this.getElementInstance() instanceof sap.ui.core.Control;
			// always create aggregations for Elements, because we can't check if they are visible correctly...
			if (!bIsControl || this._getElementInstanceVisible()) {
				if (!oAggregationOverlay.getChildren().length) {
					this.fireRequestElementOverlaysForAggregation({
						name : sAggregationName
					});
				}
			}

			var aAggregationElements = ElementUtil.getAggregation(this.getElementInstance(), sAggregationName);
			aAggregationElements.forEach(function(oAggregationElement) {
				var oChildElementOverlay = OverlayRegistry.getOverlay(oAggregationElement);
				if (oChildElementOverlay  && oChildElementOverlay.getParent() !== that) {
					oAggregationOverlay.addChild(oChildElementOverlay);
				}
			});
		}
	};

	/**
	 * @protected
	 */
	ElementOverlay.prototype.setVisible = function(bVisible) {
		Overlay.prototype.setVisible.apply(this, arguments);

		this.sync();
	};

	/**
	 * @protected
	 */
	ElementOverlay.prototype.destroyAggregation = function(sAggregationName, bSuppressInvalidate) {
		Overlay.prototype.destroyAggregation.apply(this, arguments);

		if (sAggregationName === "aggregationOverlays") {
			delete this._mAggregationOverlays;
		}
	};

	/**
	 * @param {sap.ui.baseEvent} oEvent event object
	 * @private
	 */
	ElementOverlay.prototype._onElementModified = function(oEvent) {
		var oParams = oEvent.getParameters();

		var sAggregationName = oEvent.getParameters().name;
		if (sAggregationName) {
			this.sync();
			var oAggregationOverlay = this.getAggregationOverlay(sAggregationName);
			// private aggregations are also skipped
			var bAggregationOverlayVisible = oAggregationOverlay && oAggregationOverlay.isVisible();
			if (bAggregationOverlayVisible) {
				this.fireElementModified(oParams);
			}
		} else if (oEvent.getParameters().type === "setParent") {
			this.fireElementModified(oParams);
		}

		this.invalidate();
	};

	/**
	 * @private
	 */
	ElementOverlay.prototype._onDomChanged = function(oEvent) {
		var aIds = oEvent.getParameters().elementIds || [];
		var oElement = this.getElementInstance();
		if (oElement && aIds.indexOf(oElement.getId()) !== -1) {
			// if element's DOM turns visible (via DOM mutations, classes and so on)
			if (this._mGeometry && !this._mGeometry.visible) {
				delete this._mGeometry;
				this.invalidate();
			}
		}

		// update styles (starting from root and update all overlay children)
		if (this.isRoot()) {
			this.applyStyles();
		}
	};

	/**
	 * @private
	 */
	ElementOverlay.prototype._onElementAfterRendering = function() {
		// initial rendering of a UI5 element is not catched with a mutation observer
		if (!this.getDomRef()) {
			this.invalidate();
		}
		// we should sync aggregations onAfterRendering, because elements (or aggregations) might be created invisible
		this.sync();
	};

	/**
	 * @private
	 */
	ElementOverlay.prototype._onElementDestroyed = function() {
		this.destroy();
	};

	/**
	 * Returns AggregationOverlays created for the public aggregations of the associated Element
	 * @return {sap.ui.dt.AggregationOverlay[]} array of the AggregationOverlays
	 * @public
	 */
	ElementOverlay.prototype.getAggregationOverlays = function() {
		return this.getAggregation("aggregationOverlays") || [];
	};

	/**
	 * @override
	 */
	ElementOverlay.prototype.getChildren = function() {
		return this.getAggregationOverlays();
	};

	/**
	 * Returns AggregationOverlay the public aggregations of the associated Element by aggregation name
	 * @param {string} sAggregationName name of the aggregation
	 * @return {sap.ui.dt.AggregationOverlay} AggregationOverlays for the aggregation
	 * @public
	 */
	ElementOverlay.prototype.getAggregationOverlay = function(sAggregationName) {
		if (this._mAggregationOverlays) {
			return this._mAggregationOverlays[sAggregationName];
		}
	};

	/**
	 * Returns closest ElementOverlay ancestor of this ElementOverlay or undefined, if no parent ElementOverlay exists
	 * @return {sap.ui.dt.ElementOverlay} ElementOverlay parent
	 * @public
	 */
	ElementOverlay.prototype.getParentElementOverlay = function() {
		var oParentAggregationOverlay = this.getParentAggregationOverlay();
		if (oParentAggregationOverlay) {
			return oParentAggregationOverlay.getParent();
		}
	};

	/**
	 * Returns closest AggregationOverlay ancestor of this ElementOverlay or null, if no parent AggregationOverlay exists
	 * @return {sap.ui.dt.AggregationOverlay} AggregationOverlay parent, which contains this ElementOverlay
	 * @public
	 */
	ElementOverlay.prototype.getParentAggregationOverlay = function() {
		var oParentAggregationOverlay = this.getParent();
		return oParentAggregationOverlay instanceof sap.ui.dt.AggregationOverlay ? oParentAggregationOverlay : null;
	};

	/**
	 * Returns if the ElementOverlay is selected
	 * @public
	 * @return {boolean} if the ElementOverlay is selected
	 */
	ElementOverlay.prototype.isSelected = function() {
		return this.getSelected();
	};

	/**
	 * Returns if the ElementOverlay is selectable
	 * @public
	 * @return {boolean} if the ElementOverlay is selectable
	 */
	ElementOverlay.prototype.isSelectable = function() {
		return this.getSelectable();
	};

	/**
	 * Returns if the ElementOverlay is movable
	 * @public
	 * @return {boolean} if the ElementOverlay is movable
	 */
	ElementOverlay.prototype.isMovable = function() {
		return this.getMovable();
	};

	/**
	 * Returns if the ElementOverlay is editable
	 * @public
	 * @return {boolean} if the ElementOverlay is editable
	 */
	ElementOverlay.prototype.isEditable = function() {
		return this.getEditable();
	};

	/**
	 * Returns if the overlay's elementInstance is visible in DOM (or is invisible, but consumes screen space, like opacity 0 or visibility hidden)
	 * @private
	 * @return {boolean} if the overlay's elementInstance is editable
	 */
	ElementOverlay.prototype._getElementInstanceVisible = function() {
		var oElement = this.getElementInstance();
		if (oElement) {
			var oGeometry = this.getGeometry();
			return oGeometry && oGeometry.visible;
		} else {
			return false;
		}

	};

	/**
	 * Returns agrregation overlay of public parent, which is an ancestor of this overlay
	 *
	 * @return {sap.ui.dt.Overlay} Overlay public parent
	 * @public
	 */
	ElementOverlay.prototype.getPublicParentAggregationOverlay = function() {
		var oAggregationOverlay = this.getParentAggregationOverlay();
		var oParentElementOverlay = this.getParentElementOverlay();
		while (oParentElementOverlay && ElementUtil.isInstanceOf(oParentElementOverlay, "sap.ui.dt.ElementOverlay") && oParentElementOverlay.isInHiddenTree()) {
			oAggregationOverlay = oParentElementOverlay.getParentAggregationOverlay();
			oParentElementOverlay = oParentElementOverlay.getParentElementOverlay();
		}
		return oAggregationOverlay;
	};

	/**
	 * Returns first ancestor overlay not flagged as inHiddenTree
	 * @return {sap.ui.dt.ElementOverlay} ElementOverlay public parent
	 * @public
	 */
	ElementOverlay.prototype.getPublicParentElementOverlay = function() {
		var oPublicParentAggregationOverlay = this.getPublicParentAggregationOverlay();
		if (oPublicParentAggregationOverlay) {
			return oPublicParentAggregationOverlay.getParent();
		}
	};

	return ElementOverlay;
}, /* bExport= */ true);

}; // end of sap/ui/dt/ElementOverlay.js
if ( !jQuery.sap.isDeclared('sap.ui.dt.DesignTime') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides class sap.ui.dt.DesignTime.
jQuery.sap.declare('sap.ui.dt.DesignTime'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.ui.base.ManagedObject'); // unlisted dependency retained
sap.ui.define("sap/ui/dt/DesignTime",[
	'sap/ui/base/ManagedObject',
	'sap/ui/dt/ElementOverlay',
	'sap/ui/dt/OverlayRegistry',
	'sap/ui/dt/Selection',
	'sap/ui/dt/ElementDesignTimeMetadata',
	'sap/ui/dt/ElementUtil',
	'sap/ui/dt/OverlayUtil',
	'./library'
],
function(ManagedObject, ElementOverlay, OverlayRegistry, Selection, ElementDesignTimeMetadata, ElementUtil, OverlayUtil) {
	"use strict";

	/**
	 * Constructor for a new DesignTime.
	 *
	 * @param {string} [sId] id for the new object, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new object
	 *
	 * @class
	 * The DesignTime allows to create a set of Overlays above the root elements and
	 * their public children and manage theire events.
	 * @extends sap.ui.core.ManagedObject
	 *
	 * @author SAP SE
	 * @version 1.42.6
	 *
	 * @constructor
	 * @private
	 * @since 1.30
	 * @alias sap.ui.dt.DesignTime
	 * @experimental Since 1.30. This class is experimental and provides only limited functionality. Also the API might be changed in future.
	 */
	var DesignTime = ManagedObject.extend("sap.ui.dt.DesignTime", /** @lends sap.ui.dt.DesignTime.prototype */ {
		metadata : {
			// ---- object ----

			// ---- control specific ----
			library : "sap.ui.dt",
			properties : {
				/**
				 * Selection mode which should be used for overlays selection
				 */
				selectionMode : {
					type : "sap.ui.dt.SelectionMode",
					defaultValue : sap.ui.dt.SelectionMode.Single
				},

				/**
				 * DesignTime metadata for classses to use with overlays (will overwrite default DTMetadata fields)
				 * should have a map structure { "sClassName" : oDesignTimeMetadata, ... }
				 */
				 designTimeMetadata : {
					type : "object"
				 }
			},
			associations : {
				/**
				 * Root elements to create overlays for
				 */
				rootElements : {
					type : "sap.ui.core.Element",
					multiple : true
				}
			},
			aggregations : {
				/**
				 * Plugins to use with a design time
				 */
				plugins : {
					type : "sap.ui.dt.Plugin",
					multiple : true
				}
			},
			events : {
				/**
				 * Event fired when an ElementOverlay is created and its designTimeMetadata is loaded
				 */
				elementOverlayCreated : {
					parameters : {
						elementOverlay : { type : "sap.ui.dt.ElementOverlay" }
					}
				},
				/**
				 * Event fired when an ElementOverlay is destroyed
				 */
				elementOverlayDestroyed : {
					parameters : {
						elementOverlay : { type : "sap.ui.dt.ElementOverlay" }
					}
				},
				/**
				 * Event fired when an overlays selection is changed
				 */
				selectionChange : {
					parameters : {
						selection : { type : "sap.ui.dt.Overlay[]" }
					}
				},
				/**
				 * Event fired when DesignTime is syncing overlays with a ControlTree of root elements
				 */
				syncing : {},
				/**
				 * Event fired when DesignTime's overlays are in-sync with ControlTree of root elements
				 */
				synced : {},
				/**
				 * Event fired when DesignTime's overlays failed to sync with ControlTree of root elements
				 */
				syncFailed : {}
			}
		}
	});

	/**
	 * Called when the DesignTime is initialized
	 * @protected
	 */
	DesignTime.prototype.init = function() {
		// number of element overlays waiting for their designTimeMetadata
		this._iOverlaysPending = 0;
		// array of errors while element overlays waiting for their designTimeMetadata
		this._oSelection = this.createSelection();
		this._oSelection.attachEvent("change", function(oEvent) {
			this.fireSelectionChange({selection: oEvent.getParameter("selection")});
		}, this);
	};

	/**
	 * Called when the DesignTime is destroyed
	 * @protected
	 */
	DesignTime.prototype.exit = function() {
		delete this._iOverlaysPending;
		this._destroyAllOverlays();
		this._oSelection.destroy();
	};

	/**
	 * Creates an instance of a Selection to handle the overlays selection inside of the DesignTime
	 * @return {sap.ui.dt.Selection} the instance of the Selection
	 * @protected
	 */
	DesignTime.prototype.createSelection = function() {
		return new Selection();
	};

	/**
	 * Returns array with current selected overlays
	 * @return {sap.ui.dt.Overlay[]} selected overlays
	 * @public
	 */
	DesignTime.prototype.getSelection = function() {
		return this._oSelection.getSelection();
	};

	/**
	 * Sets selection mode to be used in the Selection inside of the DesignTime
	 * @param {sap.ui.dt.SelectionMode} oMode a selection mode to be used with the Selection
	 * @return {sap.ui.dt.DesignTime} this
	 * @public
	 */
	DesignTime.prototype.setSelectionMode = function(oMode) {
		this.setProperty("selectionMode", oMode);
		this._oSelection.setMode(oMode);

		return this;
	};

	/**
	 * Returns all plugins used with the DesignTime
	 * @return {sap.ui.dt.Plugin[]} an array of plugins
	 * @protected
	 */
	DesignTime.prototype.getPlugins = function() {
		return this.getAggregation("plugins") || [];
	};

	/**
	 * Adds new plugin to use with the DesignTime
	 * @param {sap.ui.dt.Plugin} oPlugin to add
	 * @return {sap.ui.dt.DesignTime} this
	 * @protected
	 */
	DesignTime.prototype.addPlugin = function(oPlugin) {
		oPlugin.setDesignTime(this);

		this.addAggregation("plugins", oPlugin);

		return this;
	};

	/**
	 * Inserts new plugin to use with the DesignTime at a defined position
	 * @param {sap.ui.dt.Plugin} oPlugin to insert
	 * @param {int} iIndex a position to insert the plugin at
	 * @return {sap.ui.dt.DesignTime} this
	 * @protected
	 */
	DesignTime.prototype.insertPlugin = function(oPlugin, iIndex) {
		oPlugin.setDesignTime(this);

		this.insertAggregation("plugins", oPlugin, iIndex);

		return this;
	};

	/**
	 * Removes a plugin from the DesignTime
	 * @param {sap.ui.dt.Plugin} oPlugin to remove
	 * @return {sap.ui.dt.DesignTime} this
	 * @protected
	 */
	DesignTime.prototype.removePlugin = function(oPlugin) {
		this.getPlugins().forEach(function(oCurrentPlugin) {
			if (oCurrentPlugin === oPlugin) {
				oPlugin.setDesignTime(null);
				return;
			}
		});

		this.removeAggregation("plugins", oPlugin);

		return this;
	};

	/**
	 * Removes all plugins from the DesignTime
	 * @return {sap.ui.dt.DesignTime} this
	 * @protected
	 */
	DesignTime.prototype.removeAllPlugins = function() {
		this.getPlugins().forEach(function(oPlugin) {
			oPlugin.setDesignTime(null);
		});

		this.removeAllAggregation("plugins");

		return this;
	};

	/**
	 * Returns all root elements from the DesignTime
	 * @return {sap.ui.core.Element[]} rootElements of the DesignTime
	 * @protected
	 */
	DesignTime.prototype.getRootElements = function() {
		return this.getAssociation("rootElements") || [];
	};

	/**
	 * Returns a designTimeMetadata
	 * @return {map} designTimeMetadata
	 * @protected
	 */
	DesignTime.prototype.getDesignTimeMetadata = function() {
		return this.getProperty("designTimeMetadata") || {};
	};

	/**
	 * Returns a designTimeMetadata for the element or className
	 * @param {string|sap.ui.core.Element}
	 * @return {object} designTimeMetadata for a specific element or className
	 * @protected
	 */
	DesignTime.prototype.getDesignTimeMetadataFor = function(vElement) {
		var sClassName = vElement;
		var mDesignTimeMetadata = this.getDesignTimeMetadata();
		if (vElement.getMetadata) {
			sClassName = vElement.getMetadata().getName();
		}
		return mDesignTimeMetadata[sClassName];
	};

	/**
	 * Adds a root element to the DesignTime and creates overlays for it and it's public descendants
	 * @param {string|sap.ui.core.Element} vRootElement element or elemet's id
	 * @return {sap.ui.dt.DesignTime} this
	 * @protected
	 */
	DesignTime.prototype.addRootElement = function(vRootElement) {
		this.addAssociation("rootElements", vRootElement);

		var oRootOverlay = this._createElementOverlay(ElementUtil.getElementInstance(vRootElement));

		// trigger rendering of all overlays only once after DesignTime is synced
		// to prevent rerendering of UIArea during async loading process
		this.attachEventOnce("synced", function() {
			oRootOverlay.placeInOverlayContainer();
		});

		return this;
	};

	/**
	 * Removes a root element from the DesignTime and destroys overlays for it and it's public descendants
	 * @param {string|sap.ui.core.Element} vRootElement element or elemet's id
	 * @return {sap.ui.dt.DesignTime} this
	 * @protected
	 */
	DesignTime.prototype.removeRootElement = function(vRootElement) {
		this.removeAssociation("rootElements", vRootElement);

		this._destroyOverlaysForElement(ElementUtil.getElementInstance(vRootElement));

		return this;
	};

	/**
	 * Removes all root elements from the DesignTime and destroys overlays for them and theire public descendants
	 * @param {string|sap.ui.core.Element} element or elemet's id
	 * @return {sap.ui.dt.DesignTime} this
	 * @protected
	 */
	DesignTime.prototype.removeAllRootElement = function() {
		this.removeAssociation("rootElements");

		this._destroyAllOverlays();

		return this;
	};


	/**
	 * Creates and returns the created instance of ElementOverlay for an element
	 * @param {string|sap.ui.core.Element} oElement to create ElementOverlay for
	 * @param {object} oDesignTimeMetadata to create ElementOverlay with
	 * @return {sap.ui.dt.ElementOverlay} created ElementOverlay
	 * @protected
	 */
	DesignTime.prototype.createElementOverlay = function(oElement, bInHiddenTree) {
		return new ElementOverlay({
			inHiddenTree : bInHiddenTree,
			element : oElement
		});
	};

	/**
	 * Returns an array with all element overlays created, registered and handled by the DesignTime
	 * @return {sap.ui.dt.ElementOverlay[]} all element overlays created and handled by the DesignTime
	 * @public
	 */
	DesignTime.prototype.getElementOverlays = function() {
		var that = this;
		var aElementOverlays = [];

		this._iterateRootElements(function(oRootElement) {
			aElementOverlays = aElementOverlays.concat(that._getAllElementOverlaysIn(oRootElement));
		});

		return aElementOverlays;
	};

	/**
	 * @param {sap.ui.core.Element} oElement element
	 * @return {sap.ui.dt.ElementOverlay} created or already existing instance of ElementOverlay for oElement
	 * @private
	 */
	DesignTime.prototype._createElementOverlay = function(oElement, bInHiddenTree) {
		var that = this;

		oElement = ElementUtil.fixComponentContainerElement(oElement);
		var oElementOverlay = OverlayRegistry.getOverlay(oElement);
		if (oElement && !oElement.bIsDestroyed && !oElementOverlay) {
			if (this._iOverlaysPending === 0) {
				this.fireSyncing();
			}
			this._iOverlaysPending++;

			oElementOverlay = this.createElementOverlay(oElement, bInHiddenTree);
			if (oElementOverlay) {
				oElementOverlay.attachRequestElementOverlaysForAggregation(this._onRequestElementOverlaysForAggregation, this);
				oElementOverlay.attachElementModified(this._onElementModified, this);
				oElementOverlay.attachDestroyed(this._onElementOverlayDestroyed, this);
				oElementOverlay.attachSelectionChange(this._onElementOverlaySelectionChange, this);
			}

			ElementUtil.loadDesignTimeMetadata(oElement).then(function(oDesignTimeMetadata) {
				// if oElement is already destroyed while designtime metadata is loading
				if (!oElement || oElement.bIsDestroyed) {
					return;
				}
				// merge the DTMetadata from the DesignTime and from UI5
				var oMergedDesignTimeMetadata = oDesignTimeMetadata || {};
				jQuery.extend(true, oMergedDesignTimeMetadata, that.getDesignTimeMetadataFor(oElement));
				var oElementDesignTimeMetadata = new ElementDesignTimeMetadata({data : oMergedDesignTimeMetadata});

				oElementOverlay.setDesignTimeMetadata(oElementDesignTimeMetadata);
				that.fireElementOverlayCreated({elementOverlay : oElementOverlay});
			}).catch(function(oError) {
				jQuery.sap.log.error("exception occured in sap.ui.dt.DesignTime._createElementOverlay", oError);
				if (oError instanceof Error) {
					that.fireSyncFailed();
				}
			}).then(function() {
				that._iOverlaysPending--;
				if (that._iOverlaysPending === 0) {
					that.fireSynced();
				}
			});
		}

		return oElementOverlay;
	};

	/**
	 * Create an overlay for an element and register it in the DesignTime
	 * @param {sap.ui.core.Element} oElement element
	 * @return {sap.ui.dt.ElementOverlay} created ElementOverlay
	 * @public
	 */
	DesignTime.prototype.createOverlay = function(oElement) {
		return this._createElementOverlay(oElement);
	};

	/**
	 * @param {sap.ui.core.Element} oElement element
	 * @private
	 */
	DesignTime.prototype._destroyOverlaysForElement = function(oElement) {
		var oOverlay = OverlayRegistry.getOverlay(oElement);
		if (oOverlay) {
			oOverlay.destroy();
		}
	};

	/**
	 * @private
	 */
	DesignTime.prototype._destroyAllOverlays = function() {
		var that = this;

		this._iterateRootElements(function(oRootElement) {
			that._destroyOverlaysForElement(oRootElement);
		});
	};

	/**
	 * @private
	*/
	DesignTime.prototype._createChildOverlaysForAggregation = function(oElementOverlay, sAggregationName) {
		var that = this;

		var oAggregationOverlay = oElementOverlay.getAggregationOverlay(sAggregationName);
		var oElement = oElementOverlay.getElementInstance();
		var vChildren = ElementUtil.getAggregation(oElement, sAggregationName);
		ElementUtil.iterateOverElements(vChildren, function(oChild) {
			that._createElementOverlay(oChild, oAggregationOverlay.isInHiddenTree());
		});
	};

	/**
	 * @private
	*/
	DesignTime.prototype._onRequestElementOverlaysForAggregation = function(oEvent) {
		var oElementOverlay = oEvent.getSource();

		var sAggregationName = oEvent.getParameter("name");
		this._createChildOverlaysForAggregation(oElementOverlay, sAggregationName);
	};

	/**
	 * @param {sap.ui.baseEvent} oEvent event object
	 * @private
	*/
	DesignTime.prototype._onElementOverlayDestroyed = function(oEvent) {
		var oElementOverlay = oEvent.getSource();

		if (oElementOverlay.getSelected()) {
			this._oSelection.remove(oElementOverlay);
		}
		this.fireElementOverlayDestroyed({overlay : oElementOverlay});
	};

	/**
	 * @param {sap.ui.baseEvent} oEvent event object
	 * @private
	 */
	DesignTime.prototype._onElementOverlaySelectionChange = function(oEvent) {
		var oElementOverlay = oEvent.getSource();
		var bSelected = oEvent.getParameter("selected");

		this._oSelection.set(oElementOverlay, bSelected);
	};

	/**
	 * @param {sap.ui.baseEvent} oEvent event object
	 * @private
	 */
	DesignTime.prototype._onElementModified = function(oEvent) {
		var that = this;

		var oParams = oEvent.getParameters();
		if (oParams.type === "addOrSetAggregation" || oParams.type === "insertAggregation") {
			this._onElementOverlayAddAggregation(oParams.value, oParams.target, oParams.name);
		} else if (oParams.type === "setParent") {
			// timeout is needed because UI5 controls & apps can temporary "dettach" controls from control tree
			// and add them again later, so the check if the control is dettached from root element's tree is delayed
			setTimeout(function() {
				if (!that.bIsDestroyed) {
					that._checkIfOverlayShouldBeDestroyed(oParams.target, oParams.value);
				}
			}, 0);
		}
	};

	/**
	 * @param {sap.ui.core.Element} oElement which was added
	 * @private
	 */
	DesignTime.prototype._onElementOverlayAddAggregation = function(oChild, oParent, sAggregationName) {
		// oElement can be of an alternative type (setLabel(sText) for example)
		if (oChild instanceof sap.ui.core.Element) {
			var oChildElementOverlay = OverlayRegistry.getOverlay(oChild);
			if (!oChildElementOverlay) {
				var bIsInHiddenTree = OverlayRegistry.getOverlay(oParent).getAggregationOverlay(sAggregationName).isInHiddenTree();
				this._createElementOverlay(oChild, bIsInHiddenTree);
			}
		}
	};

	/**
	 * @param {sap.ui.core.Element} oElement which parent was changed
	 * @param {sap.ui.core.Element} oParent new parent
	 * @private
	 */
	DesignTime.prototype._checkIfOverlayShouldBeDestroyed = function(oElement, oParent) {
		var oElementOverlay = OverlayRegistry.getOverlay(oElement);
		if (oElementOverlay && !this._isElementInRootElements(oElement)) {
			oElementOverlay.destroy();
		}
	};

	/**
	 * @param {sap.ui.core.Element} oElement to check
	 * @return {boolean} returns if an element is a descendant of any of the root elements
	 * @private
	 */
	DesignTime.prototype._isElementInRootElements = function(oElement) {
		var bFoundAncestor = false;

		this._iterateRootElements(function(oRootElement) {
			if (ElementUtil.hasAncestor(oElement, oRootElement)) {
				bFoundAncestor = true;
				return false;
			}
		});

		return bFoundAncestor;
	};

	/**
	 * @param {function} fnStep function called with every root element
	 * @private
	 */
	DesignTime.prototype._iterateRootElements = function(fnStep) {
		var aRootElements = this.getRootElements();
		aRootElements.forEach(function(sRootElementId) {
			var oRootElement = ElementUtil.getElementInstance(sRootElementId);
			fnStep(oRootElement);
		});
	};

	/**
	 * @param {sap.ui.core.Element} oElement to search overlays for, also all children overlays will be found
	 * @return {sap.ui.dt.ElementOverlay[]} created element overlays for oElement and it's children
	 * @private
	 */
	DesignTime.prototype._getAllElementOverlaysIn = function(oElement) {
		var aElementOverlays = [];

		var oElementOverlay = OverlayRegistry.getOverlay(oElement);
		if (oElementOverlay) {
			OverlayUtil.iterateOverlayElementTree(oElementOverlay, function(oChildOverlay) {
				aElementOverlays.push(oChildOverlay);
			});
		}

		return aElementOverlays;
	};

	return DesignTime;
}, /* bExport= */ true);
}; // end of sap/ui/dt/DesignTime.js
if ( !jQuery.sap.isDeclared('sap.ui.dt.test.ElementEnablementTest') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides class sap.ui.dt.test.ElementEnablementTest.
jQuery.sap.declare('sap.ui.dt.test.ElementEnablementTest'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/dt/test/ElementEnablementTest",[
	'jquery.sap.global',
	'sap/ui/dt/test/Test',
	'sap/ui/dt/DesignTime',
	'sap/ui/dt/test/Element'
],
function(jQuery, Test, DesignTime, ElementTest) {
	"use strict";


	/**
	 * Constructor for an ElementEnablementTest.
	 *
	 * @param {string} [sId] id for the new object, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new object
	 *
	 * @class
	 * The ElementEnablementTest class allows to create a design time test
	 * which tests a given element on compatibility with the sap.ui.dt.DesignTime.
	 * @extends sap.ui.dt.test.Test
	 *
	 * @author SAP SE
	 * @version 1.42.6
	 *
	 * @constructor
	 * @private
	 * @since 1.38
	 * @alias sap.ui.dt.test.ElementEnablementTest
	 * @experimental Since 1.38. This class is experimental and provides only limited functionality. Also the API might be changed in future.
	 */
	var ElementEnablementTest = Test.extend("sap.ui.dt.test.ElementEnablementTest", /** @lends sap.ui.dt.test.ElementEnablementTest.prototype */ {
		metadata : {
			// ---- object ----

			// ---- control specific ----
			library : "sap.ui.dt",
			properties : {
				type : {
					type : "string"
				},
				create : {
					type : "function"
				},
				timeout : {
					type : "integer",
					defaultValue : 0
				},
				groupPostfix : {
					type : "string"
				}
			}
		}
	});


	/**
	 * Called when the ElementEnablementTest is initialized
	 * @protected
	 */
	ElementEnablementTest.prototype.init = function() {
		this._aAggregatedTestResult = null;
		this._aAggregatedInfoResult = null;
		this._sAggregation = null;
		this._$TestAreaDomRef = null;
	};


	/**
	 * Called when the ElementEnablementTest is destroyed
	 * @protected
	 */
	ElementEnablementTest.prototype.exit = function() {
		if (this._oDesignTime) {
			this._oDesignTime.destroy();
		}
		window.clearTimeout(this._iTimeout);
		this._oElement.destroy();
		if (this._$TestAreaDomRef) {
			this._$TestAreaDomRef.remove();
			delete this._$TestAreaDomRef;
		}
	};


	/**
	 * @return {Promise} A promise providing the test results.
	 * @override
	 */
	ElementEnablementTest.prototype.run = function() {

		var that = this;
		return this._setup().then(function() {

			that._mResult = that.createSuite("Element Enablement Test");

			var mElementTest = that.addGroup(that._mResult.children,
				that.getType(),
				"Given that an DesignTime is created for " + that.getType()
			);

			that._testAggregations(mElementTest.children);

			that._mResult = that.aggregate(that._mResult);

			return that._mResult;
		});
	};


	/**
	 * @private
	 */
	ElementEnablementTest.prototype._createElement = function() {
		var sType = this.getType();
		var fnCreate = this.getCreate();
		var Element = jQuery.sap.getObject(sType);

		var oElement;

		if (fnCreate) {
			oElement = fnCreate();
		} else {
			oElement = new Element();
		}

		if (oElement.addStyleClass) {
			oElement.addStyleClass("minSize");
		}

		return oElement;
	};


	/**
	 * @private
	 */
	ElementEnablementTest.prototype._getTestArea = function() {
		if (!this._$TestAreaDomRef) {
			this._$TestAreaDomRef =  jQuery("<div id='" + this.getId() + "--testArea" + "'></div>").css({
				height : "500px",
				width: "1000px"// test area needs a height, so that some controls render correctly
			}).appendTo("body");
		}
		return this._$TestAreaDomRef;
	};


	/**
	 * @private
	 */
	ElementEnablementTest.prototype._setup = function() {
		var that = this;

		window.clearTimeout(this._iTimeout);
		this._bNoRenderer = false;
		this._bErrorDuringRendering = false;

		return new Promise(function(fnResolve, fnReject) {
			that._oElement = that._createElement();

			try {
				that._oElement.getRenderer();
			} catch (oError) {
				that._bNoRenderer = true;
			}

			if (!that._bNoRenderer) {
				try {
					that._oElement.placeAt(that._getTestArea().get(0));
					sap.ui.getCore().applyChanges();
				} catch (oError) {
					that._bErrorDuringRendering = true;
				}

				if (!that._bErrorDuringRendering) {
					that._oDesignTime = new DesignTime({
						rootElements : [that._oElement]
					});
					that._oDesignTime.attachEventOnce("synced", function() {
						sap.ui.getCore().applyChanges();
						if (that.getTimeout()) {
							that._iTimeout = window.setTimeout(function() {
								fnResolve();
							}, that.getTimeout());
						} else {
							fnResolve();
						}

					}, that);
				} else {
					fnResolve();
				}
			} else {
				fnResolve();
			}
		});
	};


	/**
	 * @private
	 */
	ElementEnablementTest.prototype._testAggregations = function(aTests) {

		var mAggregationsTests = this.addGroup(
			aTests,
			"Aggregations",
			"Each aggregation needs to be ignored or has a visible domRef maintained in the metadata",
			this.getGroupPostfix()
		);


		if (this._bNoRenderer) {
			this.addTest(mAggregationsTests.children,
				true,
				"Control has no renderer",
				"Control has no renderer, not supported by the element test (requires a special element test)",
				Test.STATUS.UNKNOWN
			);
		} else if (this._bErrorDuringRendering) {

			this.addTest(mAggregationsTests.children,
				true,
				"Error during rendering",
				 "Element can't be rendered, not supported by the DesignTime (please, provide a create method for this element)",
				Test.STATUS.ERROR
			);
		} else {
			var mAggregationsTestInfo = ElementTest.getAggregationsInfo(this._oElement);

			for (var sAggregationName in mAggregationsTestInfo) {

				var mAggregationTestInfo = mAggregationsTestInfo[sAggregationName];

				var mAggregationTest = this.addGroup(mAggregationsTests.children,
					sAggregationName,
					(mAggregationTestInfo.ignored ? "Aggregation ignored" : "Aggregation tests")
				);

				if (!mAggregationTestInfo.ignored) {

					this.addTest(mAggregationTest.children,
						mAggregationTestInfo.overlayVisible,
						"Overlay Visible",
						"Overlay domRef is visible in DOM"
					);

					if (mAggregationTestInfo.domRefDeclared){
						this.addTest(mAggregationTest.children,
							mAggregationTestInfo.domRefDeclared,
							"Dom Ref Declared",
							"DomRef is declared in design time metadata"
						);

						this.addTest(mAggregationTest.children,
							mAggregationTestInfo.domRefFound,
							"Dom Ref Found",
							"Declared DomRef is found in DOM"
						);

						this.addTest(mAggregationTest.children,
							mAggregationTestInfo.domRefVisible,
							"Dom Ref Visible",
							"Declared DomRef is visible"
						);

					} else {
						if (mAggregationTestInfo.overlayVisible) {

							this.addTest(mAggregationTest.children,
								mAggregationTestInfo.overlayGeometryCalculatedByChildren,
								"Overlay Geometry calculated by children",
								"Control might work based on DT Heuristic, but safer with domRefDeclared",
								Test.STATUS.PARTIAL_SUPPORTED
							);

						} else {

							this.addTest(mAggregationTest.children,
								false,
								"Overlay Dom Ref",
								"Overlay domRef is not declared and aggregation overlay is not visible (please, declare domRef for this aggregation)",
								Test.STATUS.PARTIAL_SUPPORTED
							);
						}
					}
					if (mAggregationTestInfo.overlayTooSmall) {
						this.addTest(mAggregationTest.children,
							false,
							"Overlay too small",
							"Aggregation Overlay is too small to be accessible",
							Test.STATUS.PARTIAL_SUPPORTED
						);
					}
				}
			}
		}
	};


	return ElementEnablementTest;
}, /* bExport= */ true);
}; // end of sap/ui/dt/test/ElementEnablementTest.js
if ( !jQuery.sap.isDeclared('sap.ui.dt.test.LibraryEnablementTest') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides class sap.ui.dt.test.LibraryEnablementTest.
jQuery.sap.declare('sap.ui.dt.test.LibraryEnablementTest'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/dt/test/LibraryEnablementTest",[
	'jquery.sap.global',
	'sap/ui/dt/test/Test',
	'sap/ui/dt/test/ElementEnablementTest'
],
function(jQuery, Test, ElementEnablementTest) {
	"use strict";


	/**
	 * Constructor for an LibraryEnablementTest.
	 *
	 * @param {string} [sId] id for the new object, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new object
	 *
	 * @class
	 * The LibraryEnablementTest class allows to create a design time test
	 * which tests a given library on compatibility with the sap.ui.dt.DesignTime.
	 * @extends sap.ui.dt.test.Test
	 *
	 * @author SAP SE
	 * @version 1.42.6
	 *
	 * @constructor
	 * @private
	 * @since 1.38
	 * @alias sap.ui.dt.test.LibraryEnablementTest
	 * @experimental Since 1.38. This class is experimental and provides only limited functionality. Also the API might be changed in future.
	 */
	var LibraryEnablementTest = Test.extend("sap.ui.dt.test.LibraryEnablementTest", /** @lends sap.ui.dt.test.LibraryEnablementTest.prototype */ {
		metadata : {
			// ---- object ----

			// ---- control specific ----
			library : "sap.ui.dt",
			properties : {
				libraryName : {
					type : "string"
				},
				testData : {
					type : "object"
				}
			}
		}
	});


	/**
	 * @return {Promise} A promise providing the test results.
	 * @override
	 */
	LibraryEnablementTest.prototype.run = function() {
		var that = this;
		this._aResult = [];
		var oTestData = this.getTestData() || {};
		var sLibraryName = this.getLibraryName();
		var aElementEnablementTest = [];
		var oLib = sap.ui.getCore().getLoadedLibraries()[sLibraryName];
		if (oLib) {
			var aLibraryControls = oLib.controls;
			aLibraryControls.forEach(function(sType) {
				var oElementTestData = oTestData[sType];
				if (!oElementTestData && oElementTestData !== false) {
					oElementTestData = {};
				}

				if (oElementTestData !== false) {
					oElementTestData.type = sType;

					var oElementTestDataWithoutCreate = null;
					if (oElementTestData.create) {
						oElementTestDataWithoutCreate = jQuery.extend({}, oElementTestData);
						delete oElementTestDataWithoutCreate.create;
						oElementTestData.groupPostfix = "with create method";
					}

					aElementEnablementTest.push(new ElementEnablementTest(oElementTestData));

					if (oElementTestDataWithoutCreate) {
						aElementEnablementTest.push(new ElementEnablementTest(oElementTestDataWithoutCreate));
					}
				}
			});
		}

		var aResults = [];
		var fnIterate = function(mResult) {
			if (mResult) {
				aResults.push(mResult);
			}
			var oElementEnablementTest = aElementEnablementTest.shift();
			if (oElementEnablementTest) {
				return oElementEnablementTest.run().then(function(mResult) {
					oElementEnablementTest.destroy();
					return fnIterate(mResult);
				});
			} else {
				return Promise.resolve(aResults);
			}
		};


		return fnIterate().then(function(aResults) {
			var mResult = that.createSuite("Library Enablement Test");

			aResults.forEach(function(mElementTestResult) {
				var mChild = mElementTestResult.children[0];
				var mPreviousChild = mResult.children[mResult.children.length - 1];

				if (mPreviousChild && mChild.name == mPreviousChild.name) {
					mPreviousChild.children = mPreviousChild.children.concat(mChild.children);
				} else {
					mResult.children.push(mChild);
				}
			});

			mResult = that.aggregate(mResult);

			return mResult;
		});


	};

	return LibraryEnablementTest;
}, /* bExport= */ true);
}; // end of sap/ui/dt/test/LibraryEnablementTest.js
