jQuery.sap.declare('sap.ui.table.library-all');if(!jQuery.sap.isDeclared('sap.ui.table.AnalyticalTable.designtime')){
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare('sap.ui.table.AnalyticalTable.designtime');sap.ui.define("sap/ui/table/AnalyticalTable.designtime",[],function(){"use strict";return{aggregations:{columns:{domRef:".sapUiTableColHdrScr"},hScroll:{ignore:false,domRef:function(){return this.$("hsb").get(0);}},vScroll:{ignore:false,domRef:function(){return this.$("vsb").get(0);}}}};},false);};if(!jQuery.sap.isDeclared('sap.ui.table.ColumnMenuRenderer')){jQuery.sap.declare('sap.ui.table.ColumnMenuRenderer');jQuery.sap.require('jquery.sap.global');jQuery.sap.require('sap.ui.core.Renderer');jQuery.sap.require('sap.ui.unified.MenuRenderer');sap.ui.define("sap/ui/table/ColumnMenuRenderer",['jquery.sap.global','sap/ui/core/Renderer','sap/ui/unified/MenuRenderer'],function(q,R,M){"use strict";var C=R.extend(M);return C;},true);};if(!jQuery.sap.isDeclared('sap.ui.table.Table.designtime')){jQuery.sap.declare('sap.ui.table.Table.designtime');sap.ui.define("sap/ui/table/Table.designtime",[],function(){"use strict";return{aggregations:{columns:{domRef:".sapUiTableColHdrScr"},hScroll:{ignore:false,domRef:function(){return this.$("hsb").get(0);}},vScroll:{ignore:false,domRef:function(){return this.$("vsb").get(0);}}}};},false);};if(!jQuery.sap.isDeclared('sap.ui.table.TablePersoController')){jQuery.sap.declare('sap.ui.table.TablePersoController');jQuery.sap.require('jquery.sap.global');jQuery.sap.require('sap.ui.base.ManagedObject');sap.ui.define("sap/ui/table/TablePersoController",['jquery.sap.global','sap/ui/base/ManagedObject'],function(q,M){"use strict";var T=M.extend("sap.ui.table.TablePersoController",{constructor:function(i,s){M.apply(this,arguments);},metadata:{properties:{"autoSave":{type:"boolean",defaultValue:true},"persoService":{type:"any"},"customDataKey":{type:"string",defaultValue:"persoKey"}},associations:{"table":{type:"sap.ui.table.Table",multiple:false}},library:"sap.ui.table"}});T.prototype.init=function(){this._schemaProperty="_persoSchemaVersion";this._schemaVersion="1.0";this._oInitialPersoData=null;this._aTableEvents=["columnResize","columnMove","columnVisibility","sort","filter","group"];this._aColumnProperties=["visible","width","sorted","sortOrder","grouped","summed"];this._bSaveFilters=false;if(this._bSaveFilters){this._aTableEvents.push("filter");this._aColumnProperties.push("filtered");this._aColumnProperties.push("filterValue");}};T.prototype.exit=function(){var t=this._getTable();if(t){this._manageTableEventHandlers(t,false);}delete this._schemaProperty;delete this._schemaVersion;delete this._oInitialPersoData;delete this._oDialog;};T.prototype.setPersoService=function(s){s=this.validateProperty("persoService",s);if(s&&(!q.isFunction(s.getPersData)||!q.isFunction(s.setPersData)||!q.isFunction(s.delPersData))){throw new Error("Value of property \"persoService\" needs to be null/undefined or an object that has the methods "+"\"getPersData\", \"setPersData\" and \"delPersData\".");}var o=this.getPersoService();this.setProperty("persoService",s,true);var n=this.getPersoService();if(n&&n!==o&&this._getTable()&&(this.getAutoSave()||!o)){this.refresh();}return this;};T.prototype.setAutoSave=function(a){var o=this.getAutoSave();this.setProperty("autoSave",a,true);var n=this.getAutoSave();if(n&&!o){this.savePersonalizations();}return this;};T.prototype.setTable=function(t){var o=this._getTable();if(o){o._oPersoController=undefined;}this.setAssociation("table",t,true);var n=this._getTable();if(n){n._oPersoController=this;}if(o){this._manageTableEventHandlers(o,false);}if(n&&n!==o){this._oInitialPersoData=this._getCurrentTablePersoData(true);this._manageTableEventHandlers(n,true);if(this.getPersoService()&&(this.getAutoSave()||!o)){this.refresh();}}else if(!n){this._oInitialPersoData=null;}return this;};T.prototype.setCustomDataKey=function(c){var o=this.getCustomDataKey();this.setProperty("customDataKey",c,true);var n=this.getCustomDataKey();if(o!==n&&this.getAutoSave()){this.savePersonalizations();}return this;};T.prototype._manageTableEventHandlers=function(t,a){for(var i=0,l=this._aTableEvents.length;i<l;i++){var f=t[(a?"attachEvent":"detachEvent")];f.apply(t,[this._aTableEvents[i],this._tableEventHandler,this]);}};T.prototype.refresh=function(){var t=this;var s=this.getPersoService();if(s){return s.getPersData().done(function(S){var D=(S&&q.isArray(S.aColumns))?S:t._oInitialPersoData;t._adjustTable(D);}).fail(function(){q.sap.log.error("Problem reading persisted personalization data.");});}else{q.sap.log.error("The Personalization Service is not available!");var d=q.Deferred();d.reject();return d.promise();}};T.prototype.savePersonalizations=function(){var s=this.getPersoService();if(s){var d=this._getCurrentTablePersoData();d[this._schemaProperty]=this._schemaVersion;return s.setPersData(d).fail(function(){q.sap.log.error("Problem persisting personalization data.");});}else{q.sap.log.error("The Personalization Service is not available!");var D=q.Deferred();D.reject();return D.promise();}};T.prototype._adjustTable=function(d){var t=this._getTable();if(!t||!d||!q.isArray(d.aColumns)){return;}var c={},C=t.getColumns();for(var i=0,l=C.length;i<l;i++){c[this._getColumnPersoKey(C[i])]=C[i];}var a=d.aColumns;for(var i=0,l=a.length;i<l;i++){var o=a[i];var b=c[o.id];if(b){if(t.indexOfColumn(b)!==o.order){t.removeColumn(b);t.insertColumn(b,o.order);}var m=b.getMetadata();for(var j=0,e=this._aColumnProperties.length;j<e;j++){var p=this._aColumnProperties[j];if(o[p]!==undefined){try{if(m.hasProperty(p)&&b.getProperty(p)!=o[p]){b.setProperty(p,o[p]);}}catch(f){q.sap.log.error("sap.ui.table.TablePersoController: failed to apply the value \""+b[p]+"\" for the property + \""+p+"\".");}}}}}if(typeof t._onPersoApplied==="function"){t._onPersoApplied();}};T.prototype._tableEventHandler=function(e){if(this.getAutoSave()&&!this._iTriggerSaveTimeout){var t=this;this._iTriggerSaveTimeout=setTimeout(function(){t.savePersonalizations();t._iTriggerSaveTimeout=null;},0);}};T.prototype._getCurrentTablePersoData=function(f){var t=this._getTable(),c=t.getColumns();var d={aColumns:[]};for(var i=0,l=c.length;i<l;i++){var C=c[i];var p=this._getColumnPersoKey(C);var o={id:p,order:i};var m=C.getMetadata();for(var j=0,a=this._aColumnProperties.length;j<a;j++){var P=this._aColumnProperties[j];if(m.hasProperty(P)){o[P]=C.getProperty(P);}}if(f){o.text=C.getLabel()&&C.getLabel().getText()||p;}d.aColumns.push(o);}return d;};T.prototype._getTable=function(){return sap.ui.getCore().byId(this.getTable());};T.prototype._getColumnPersoKey=function(c){return this._getPersoKey(this._getTable())+"-"+this._getPersoKey(c);};T.prototype._getPersoKey=function(c){var p=c.data(this.getCustomDataKey());if(!p){p=c.getId();if(p.indexOf(sap.ui.getCore().getConfiguration().getUIDPrefix())===0){q.sap.log.warning("Generated IDs should not be used as personalization keys! The stability cannot be ensured! (Control: \""+c.getId()+"\")");}}return p;};T.prototype.openDialog=function(s){sap.ui.getCore().loadLibrary("sap.m");var a=sap.ui.requireSync("sap/m/TablePersoDialog");if(!this._oDialog){var t=this;this._oDialog=new a({persoService:this.getPersoService(),showSelectAll:true,showResetAll:true,grouping:false,contentWidth:s&&s.contentWidth,contentHeight:s&&s.contentHeight||"20rem",initialColumnState:this._oInitialPersoData.aColumns,columnInfoCallback:function(o,p,P){return t._getCurrentTablePersoData(true).aColumns;},confirm:function(){t._adjustTable(this.retrievePersonalizations());if(t.getAutoSave()){t.savePersonalizations();}}});this._oDialog._oDialog.removeStyleClass("sapUiPopupWithPadding");q.sap.syncStyleClass("sapUiSizeCompact",this._getTable(),this._oDialog._oDialog);}this._oDialog.open();};return T;});};if(!jQuery.sap.isDeclared('sap.ui.table.TreeAutoExpandMode')){jQuery.sap.declare('sap.ui.table.TreeAutoExpandMode');jQuery.sap.require('jquery.sap.global');sap.ui.define("sap/ui/table/TreeAutoExpandMode",['jquery.sap.global'],function(q){"use strict";var T={Sequential:"Sequential",Bundled:"Bundled"};return T;},true);};if(!jQuery.sap.isDeclared('sap.ui.table.library')){jQuery.sap.declare('sap.ui.table.library');jQuery.sap.require('jquery.sap.global');jQuery.sap.require('sap.ui.core.Core');jQuery.sap.require('sap.ui.core.library');jQuery.sap.require('sap.ui.unified.library');sap.ui.define("sap/ui/table/library",['jquery.sap.global','sap/ui/core/Core','sap/ui/core/library','sap/ui/unified/library'],function(q,C){"use strict";sap.ui.getCore().initLibrary({name:"sap.ui.table",version:"1.42.6",dependencies:["sap.ui.core","sap.ui.unified"],types:["sap.ui.table.NavigationMode","sap.ui.table.SelectionBehavior","sap.ui.table.SelectionMode","sap.ui.table.SortOrder","sap.ui.table.VisibleRowCountMode","sap.ui.table.SharedDomRef"],interfaces:[],controls:["sap.ui.table.AnalyticalColumnMenu","sap.ui.table.AnalyticalTable","sap.ui.table.ColumnMenu","sap.ui.table.Table","sap.ui.table.TreeTable"],elements:["sap.ui.table.AnalyticalColumn","sap.ui.table.Column","sap.ui.table.Row"],extensions:{flChangeHandlers:{"sap.ui.table.Column":{"propertyChange":"default"},"sap.ui.table.Table":{"moveElements":"default"},"sap.ui.table.AnalyticalTable":{"moveElements":"default"}}}});var t=sap.ui.table;t.NavigationMode={Scrollbar:"Scrollbar",Paginator:"Paginator"};t.SelectionBehavior={Row:"Row",RowSelector:"RowSelector",RowOnly:"RowOnly"};t.SelectionMode={MultiToggle:"MultiToggle",Multi:"Multi",Single:"Single",None:"None"};t.SortOrder={Ascending:"Ascending",Descending:"Descending"};t.VisibleRowCountMode={Fixed:"Fixed",Interactive:"Interactive",Auto:"Auto"};t.SharedDomRef={HorizontalScrollBar:"hsb",VerticalScrollBar:"vsb"};t.GroupEventType={group:"group",ungroup:"ungroup",ungroupAll:"ungroupAll",moveUp:"moveUp",moveDown:"moveDown",showGroupedColumn:"showGroupedColumn",hideGroupedColumn:"hideGroupedColumn"};t.ColumnHeader=t.Column;if(!t.TableHelper){t.TableHelper={createLabel:function(c){throw new Error("no Label control available!");},createTextView:function(c){throw new Error("no TextView control available!");},createTextField:function(c){throw new Error("no TextField control available!");},createImage:function(c){throw new Error("no Image control available!");},bFinal:false};}return t;});};if(!jQuery.sap.isDeclared('sap.ui.table.AnalyticalColumnMenuRenderer')){jQuery.sap.declare('sap.ui.table.AnalyticalColumnMenuRenderer');jQuery.sap.require('jquery.sap.global');jQuery.sap.require('sap.ui.core.Renderer');sap.ui.define("sap/ui/table/AnalyticalColumnMenuRenderer",['jquery.sap.global','sap/ui/core/Renderer','./ColumnMenuRenderer'],function(q,R,C){"use strict";var A=R.extend(C);return A;},true);};if(!jQuery.sap.isDeclared('sap.ui.table.Column')){jQuery.sap.declare('sap.ui.table.Column');jQuery.sap.require('jquery.sap.global');jQuery.sap.require('sap.ui.core.Element');jQuery.sap.require('sap.ui.core.library');jQuery.sap.require('sap.ui.core.Popup');jQuery.sap.require('sap.ui.core.RenderManager');jQuery.sap.require('sap.ui.model.Filter');jQuery.sap.require('sap.ui.model.FilterOperator');jQuery.sap.require('sap.ui.model.FilterType');jQuery.sap.require('sap.ui.model.Sorter');jQuery.sap.require('sap.ui.model.Type');jQuery.sap.require('sap.ui.model.type.String');sap.ui.define("sap/ui/table/Column",['jquery.sap.global','sap/ui/core/Element','sap/ui/core/library','sap/ui/core/Popup','sap/ui/core/RenderManager','sap/ui/model/Filter','sap/ui/model/FilterOperator','sap/ui/model/FilterType','sap/ui/model/Sorter','sap/ui/model/Type','sap/ui/model/type/String','./library'],function(q,E,c,P,R,F,a,b,S,T,d,f){"use strict";var H=c.HorizontalAlign,g=f.SortOrder,V=c.ValueState;var C=E.extend("sap.ui.table.Column",{metadata:{library:"sap.ui.table",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},flexible:{type:"boolean",group:"Behavior",defaultValue:true},resizable:{type:"boolean",group:"Behavior",defaultValue:true},hAlign:{type:"sap.ui.core.HorizontalAlign",group:"Appearance",defaultValue:H.Begin},sorted:{type:"boolean",group:"Appearance",defaultValue:false},sortOrder:{type:"sap.ui.table.SortOrder",group:"Appearance",defaultValue:g.Ascending},sortProperty:{type:"string",group:"Behavior",defaultValue:null},filtered:{type:"boolean",group:"Appearance",defaultValue:false},filterProperty:{type:"string",group:"Behavior",defaultValue:null},filterValue:{type:"string",group:"Behavior",defaultValue:null},filterOperator:{type:"string",group:"Behavior",defaultValue:null},defaultFilterOperator:{type:"string",group:"Behavior",defaultValue:null},filterType:{type:"any",group:"Misc",defaultValue:null},grouped:{type:"boolean",group:"Appearance",defaultValue:false},visible:{type:"boolean",group:"Appearance",defaultValue:true},name:{type:"string",group:"Appearance",defaultValue:null},showFilterMenuEntry:{type:"boolean",group:"Appearance",defaultValue:true},showSortMenuEntry:{type:"boolean",group:"Appearance",defaultValue:true},headerSpan:{type:"any",group:"Behavior",defaultValue:1},autoResizable:{type:"boolean",group:"Behavior",defaultValue:false}},defaultAggregation:"label",aggregations:{label:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false},multiLabels:{type:"sap.ui.core.Control",multiple:true,singularName:"multiLabel"},template:{type:"sap.ui.core.Control",multiple:false},menu:{type:"sap.ui.unified.Menu",multiple:false}},events:{columnMenuOpen:{allowPreventDefault:true,parameters:{menu:{type:"sap.ui.unified.Menu"}}}}}});C._DEFAULT_FILTER_TYPE=new d();C.prototype.init=function(){this.oResBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.table");this._oSorter=null;this.mSkipPropagation={template:true};};C.prototype.setParent=function(p,A,s){E.prototype.setParent.apply(this,arguments);var m=this.getAggregation("menu");if(m&&typeof m._updateReferences==="function"){m._updateReferences(this);}};C.prototype.invalidate=function(o){var e=sap.ui.require("sap/ui/table/ColumnMenu");if(o!==this.getTemplate()&&!(e&&o instanceof e)){E.prototype.invalidate.apply(this,arguments);}};C.prototype.setLabel=function(l){var L=l;if(typeof(l)==="string"){L=f.TableHelper.createLabel({text:l});}this.setAggregation("label",L);return this;};C.prototype.setTemplate=function(t){var o=t;if(typeof(t)==="string"){o=f.TableHelper.createTextView().bindProperty("text",t);}this.setAggregation("template",o);this.invalidate();var e=this.getParent();if(e&&e._resetRowTemplate){e._resetRowTemplate();}return this;};C.prototype.getMenu=function(){var m=this.getAggregation("menu");if(!m){m=this._createMenu();this.setMenu(m);}return m;};C.prototype.invalidateMenu=function(){var m=this.getAggregation("menu");if(m&&m._invalidate){m._invalidate();}};C.prototype._menuHasItems=function(){var m=this.getAggregation("menu");var t=this.getParent();var M=function(){return(this.isSortableByMenu()||this.isFilterableByMenu()||this.isGroupableByMenu()||(t&&t.getEnableColumnFreeze())||(t&&t.getShowColumnVisibilityMenu()));}.bind(this);return!!((m&&m.getItems().length>0)||M());};C.prototype.isFilterableByMenu=function(){return!!(this.getFilterProperty()&&this.getShowFilterMenuEntry());};C.prototype.isSortableByMenu=function(){return!!(this.getSortProperty()&&this.getShowSortMenuEntry());};C.prototype.isGroupableByMenu=function(){var t=this.getParent();return!!(t&&t.getEnableGrouping&&t.getEnableGrouping()&&this.getSortProperty());};C.prototype.setMenu=function(m){this.setAggregation("menu",m,true);return this;};C.prototype._createMenu=function(){var e=sap.ui.requireSync("sap/ui/table/ColumnMenu");if(!this._defaultMenu){this._defaultMenu=new e(this.getId()+"-menu",{ariaLabelledBy:this});}return this._defaultMenu;};C.prototype._setAppDefault=function(p,v){if(!this._appDefaults){this._appDefaults={};}if(p=="sorted"){this._appDefaults.sorted=v;}else if(p=="sortOrder"){this._appDefaults.sortOrder=v;}else if(p=="filtered"){this._appDefaults.filtered=v;}else if(p=="filterValue"){this._appDefaults.filterValue=v;}else if(p=="filterOperator"){this._appDefaults.filterOperator=v;}};C.prototype._restoreAppDefaults=function(){if(this._appDefaults){this.setProperty("sorted",this._appDefaults.sorted,true);this.setProperty("sortOrder",this._appDefaults.sortOrder,true);this.setProperty("filtered",this._appDefaults.filtered,true);this.setProperty("filterValue",this._appDefaults.filterValue,true);this.setProperty("filterOperator",this._appDefaults.filterOperator,true);this._updateIcons();}};C.prototype.setSorted=function(e){this.setProperty("sorted",e,true);this._setAppDefault("sorted",e);this._updateIcons();return this;};C.prototype.setSortOrder=function(t){this.setProperty("sortOrder",t,true);this._setAppDefault("sortOrder",t);this._updateIcons();return this;};C.prototype.setFiltered=function(e){this.setProperty("filtered",e,true);this._setAppDefault("filtered",e);this._updateIcons();return this;};C.prototype.setFilterValue=function(v){this.setProperty("filterValue",v,true);this._setAppDefault("filterValue",v);var m=this.getMenu();var e=sap.ui.require("sap/ui/table/ColumnMenu");if(m&&e&&m instanceof e){m._setFilterValue(v);}return this;};C.prototype.setFilterOperator=function(v){this.setProperty("filterOperator",v,true);this._setAppDefault("filterOperator",v);return this;};C.prototype.onmouseout=function(e){if(this._bSkipOpen&&q.sap.checkMouseEnterOrLeave(e,this.getDomRef())){this._bSkipOpen=false;}};C.prototype._openMenu=function(D,w){if(this._bSkipOpen){this._bSkipOpen=false;return;}var m=this.getMenu();var e=this.fireColumnMenuOpen({menu:m});if(e){var h=P.Dock;var o=D;if(!D){D=this.getDomRef();o=this.getFocusDomRef();}m.open(!!w,o,h.BeginTop,h.BeginBottom,D,"none none");}};C.prototype.toggleSort=function(){this.sort(this.getSorted()&&this.getSortOrder()===g.Ascending);};C.prototype.sort=function(D,A){var t=this.getParent();if(t){t.pushSortedColumn(this,A);var n=D?g.Descending:g.Ascending;var e=t.fireSort({column:this,sortOrder:n,columnAdded:A});if(e){var s=t.getSortedColumns();var h=t.getColumns();for(var i=0,l=h.length;i<l;i++){if(q.inArray(h[i],s)<0){h[i].setProperty("sorted",false,true);h[i].setProperty("sortOrder",g.Ascending,true);h[i]._updateIcons();delete h[i]._oSorter;}}this.setProperty("sorted",true,true);this.setProperty("sortOrder",n,true);this._oSorter=new S(this.getSortProperty(),this.getSortOrder()===g.Descending);var j=[];for(var i=0,l=s.length;i<l;i++){s[i]._updateIcons();j.push(s[i]._oSorter);}if(t.isBound("rows")){t.getBinding("rows").sort(j);if(this._afterSort){this._afterSort();}}}}return this;};C.prototype._updateIcons=function(){var t=this.getParent(),s=this.getSorted(),e=this.getFiltered();if(!t||!t.getDomRef()){return;}this.$().find(".sapUiTableColCell").toggleClass("sapUiTableColSF",s||e).toggleClass("sapUiTableColFiltered",e).toggleClass("sapUiTableColSorted",s).toggleClass("sapUiTableColSortedD",s&&this.getSortOrder()===g.Descending);t._getAccExtension().updateAriaStateOfColumn(this);};C.prototype._renderSortIcon=function(){this._updateIcons();};C.prototype._getFilter=function(){var o,p=this.getFilterProperty(),v=this.getFilterValue(),O=this.getFilterOperator(),s,e,t=this.getFilterType()||C._DEFAULT_FILTER_TYPE,i=t instanceof d,B;if(v){if(!O){B=v.match(/(.*)\s*\.\.\s*(.*)/);if(v.indexOf("=")==0){O=a.EQ;s=v.substr(1);}else if(v.indexOf("!=")==0){O=a.NE;s=v.substr(2);}else if(v.indexOf("<=")==0){O=a.LE;s=v.substr(2);}else if(v.indexOf("<")==0){O=a.LT;s=v.substr(1);}else if(v.indexOf(">=")==0){O=a.GE;s=v.substr(2);}else if(v.indexOf(">")==0){O=a.GT;s=v.substr(1);}else if(B){if(B[1]&&B[2]){O=a.BT;s=B[1];e=B[2];}else if(B[1]&&!B[2]){O=a.GE;s=B[1];}else{O=a.LE;s=B[2];}}else if(i&&v.indexOf("*")==0&&v.lastIndexOf("*")==v.length-1){O=a.Contains;s=v.substr(1,v.length-2);}else if(i&&v.indexOf("*")==0){O=a.EndsWith;s=v.substr(1);}else if(i&&v.lastIndexOf("*")==v.length-1){O=a.StartsWith;s=v.substr(0,v.length-1);}else{if(this.getDefaultFilterOperator()){O=this.getDefaultFilterOperator();}else{if(i){O=a.Contains;}else{O=a.EQ;}}s=v.substr(0);}if(!e){o=new F(p,O,this._parseFilterValue(s));}else{o=new F(p,O,this._parseFilterValue(s),this._parseFilterValue(e));}}else{o=new F(p,O,this._parseFilterValue(v));}}return o;};C.prototype.filter=function(v){var t=this.getParent();if(t&&t.isBound("rows")){var h=t.fireFilter({column:this,value:v});if(h){this.setProperty("filtered",!!v,true);this.setProperty("filterValue",v,true);var m=this.getMenu();var j=sap.ui.require("sap/ui/table/ColumnMenu");if(m&&j&&m instanceof j){m._setFilterValue(v);}var k=[];var n=t.getColumns();for(var i=0,l=n.length;i<l;i++){var o=n[i],p;m=o.getMenu();try{p=o._getFilter();if(m&&j&&m instanceof j){m._setFilterState(V.None);}}catch(e){if(m&&j&&m instanceof j){m._setFilterState(V.Error);}continue;}if(p){k.push(p);}}t.getBinding("rows").filter(k,b.Control);this._updateIcons();}}return this;};C.prototype._parseFilterValue=function(v){var o=this.getFilterType();if(o){if(q.isFunction(o)){v=o(v);}else{v=o.parseValue(v,"string");}}return v;};C.prototype._restoreIcons=function(){this._updateIcons();};C.prototype.shouldRender=function(){return this.getVisible()&&!this.getGrouped();};C.PROPERTIES_FOR_ROW_INVALIDATION={visible:true,flexible:true,headerSpan:true};C.prototype.setProperty=function(n,v){var t=this.getParent();if(t&&t._resetRowTemplate&&this.getProperty(n)!=v&&C.PROPERTIES_FOR_ROW_INVALIDATION[n]){t._resetRowTemplate();}return E.prototype.setProperty.apply(this,arguments);};C.prototype.setFilterType=function(t){var o=t;if(typeof(t)==="string"){try{var m=q.sap.parseJS(t);if(typeof(m.type)==="string"){var e=q.sap.getObject(m.type);o=e&&new e(m.formatOptions,m.constraints);}}catch(h){var e=q.sap.getObject(t);o=e&&new e();}if(!(o instanceof T)){q.sap.log.error("The filter type is not an instance of sap.ui.model.Type! Ignoring the filter type!");o=undefined;}}this.setProperty("filterType",o,true);return this;};C.prototype.getIndex=function(){var t=this.getParent();if(t){return t.indexOfColumn(this);}else{return-1;}};return C;});};if(!jQuery.sap.isDeclared('sap.ui.table.Row')){jQuery.sap.declare('sap.ui.table.Row');jQuery.sap.require('jquery.sap.global');jQuery.sap.require('sap.ui.core.Element');jQuery.sap.require('sap.ui.model.Context');sap.ui.define("sap/ui/table/Row",['jquery.sap.global','sap/ui/core/Element','sap/ui/model/Context','./library'],function(q,E,C,l){"use strict";var R=E.extend("sap.ui.table.Row",{metadata:{library:"sap.ui.table",defaultAggregation:"cells",aggregations:{cells:{type:"sap.ui.core.Control",multiple:true,singularName:"cell"}}}});R.prototype.init=function(){this.initDomRefs();};R.prototype.exit=function(){this.initDomRefs();};R.prototype.getFocusInfo=function(){var t=this.getParent();return t?t.getFocusInfo():E.prototype.getFocusInfo.apply(this,arguments);};R.prototype.applyFocusInfo=function(f){var t=this.getParent();if(t){t.applyFocusInfo(f);}else{E.prototype.applyFocusInfo.apply(this,arguments);}return this;};R.prototype.initDomRefs=function(){this._mDomRefs={};};R.prototype.getIndex=function(){var t=this.getParent();if(t){var r=t.indexOfRow(this);var n=t.getFixedRowCount();if(n>0&&r<n){return r;}var N=t.getFixedBottomRowCount();var v=t.getVisibleRowCount();if(N>0&&r>=v-N){var b=t.getBinding("rows");if(b&&b.getLength()>=v){return b.getLength()-(v-r);}else{return r;}}var f=t.getFirstVisibleRow();return f+r;}return-1;};R.prototype.getDomRefs=function(j){var a;var k;if(j===true){a=q.sap.byId;k="jQuery";}else{a=q.sap.domById;k="dom";}if(!this._mDomRefs[k]){this._mDomRefs[k]={};var t=this.getParent();if(t){var r=t.indexOfRow(this);this._mDomRefs[k].rowSelector=a(t.getId()+"-rowsel"+r);}this._mDomRefs[k].rowScrollPart=a(this.getId());this._mDomRefs[k].rowFixedPart=a(this.getId()+"-fixed");this._mDomRefs[k].rowSelectorText=a(this.getId()+"-rowselecttext");if(j===true){this._mDomRefs[k].row=this._mDomRefs[k].rowScrollPart;if(this._mDomRefs[k].rowFixedPart.length>0){this._mDomRefs[k].row=this._mDomRefs[k].row.add(this._mDomRefs[k].rowFixedPart);}else{this._mDomRefs[k].rowFixedPart=undefined;}if(this._mDomRefs[k].rowSelector&&this._mDomRefs[k].rowSelector.length>0){this._mDomRefs[k].row=this._mDomRefs[k].row.add(this._mDomRefs[k].rowSelector);}else{this._mDomRefs[k].rowSelector=undefined;}}}return this._mDomRefs[k];};R.prototype._updateSelection=function(t,T,s){var i=t.isIndexSelected(this.getIndex());var d=this.getDomRefs(true);var S="rowSelect";if(i){S="rowDeselect";}if(d.rowSelector){d.rowSelector.attr("title",T.mouse[S]);}if(d.rowSelectorText){var a="";if(!(this._oNodeState&&this._oNodeState.sum)&&!this._bHasChildren){a=T.keyboard[S];}d.rowSelectorText.text(a);}var r=d.rowScrollPart;if(d.rowFixedPart){r=r.add(d.rowFixedPart);}if(s){r.attr("title",T.mouse[S]);}else{r.removeAttr("title");}if(d.row){d.row.toggleClass("sapUiTableRowSel",i);t._getAccExtension().updateAriaStateOfRow(this,d,i);}};R.prototype.setRowBindingContext=function(c,m,b){var n;if(c&&!(c instanceof C)){n=c;c=c.context;}var $=this.getDomRefs(true).row;this._bHidden=!c;$.toggleClass("sapUiTableRowHidden",this._bHidden);this._collectRenderingInformation(c,n,b);this.setBindingContext(c,m);};R.prototype.setBindingContext=function(c,m){var r=E.prototype.setBindingContext.call(this,c||null,m);this._updateTableCells(c);return r;};R.prototype._updateTableCells=function(c){var a=this.getCells();var A=this.getIndex();for(var i=0;i<a.length;i++){var o=a[i];if(o._updateTableCell){o._updateTableCell(o,c,o.$().closest("td"),A);}}};R.prototype._collectRenderingInformation=function(c,n,b){this._oNodeState=undefined;this._iLevel=0;this._bIsExpanded=false;this._bHasChildren=false;this._sTreeIconClass="";if(n){this._oNodeState=n.nodeState;this._iLevel=n.level;this._bIsExpanded=false;this._bHasChildren=false;this._sTreeIconClass="sapUiTableTreeIconLeaf";this._sGroupIconClass="";if(b){if(b.getLevel){this._bIsExpanded=b.isExpanded(this.getIndex());}else if(b.findNode){this._bIsExpanded=this&&this._oNodeState?this._oNodeState.expanded:false;}if(b.nodeHasChildren){if(this._oNodeState){this._bHasChildren=b.nodeHasChildren(n);}}else if(b.hasChildren){this._bHasChildren=b.hasChildren(c);}if(this._bHasChildren){this._sTreeIconClass=this._bIsExpanded?"sapUiTableTreeIconNodeOpen":"sapUiTableTreeIconNodeClosed";this._sGroupIconClass=this._bIsExpanded?"sapUiTableGroupIconOpen":"sapUiTableGroupIconClosed";}}}};return R;});};if(!jQuery.sap.isDeclared('sap.ui.table.TableGrouping')){jQuery.sap.declare('sap.ui.table.TableGrouping');jQuery.sap.require('jquery.sap.global');jQuery.sap.require('sap.ui.core.Element');jQuery.sap.require('sap.ui.model.Sorter');jQuery.sap.require('sap.ui.Device');sap.ui.define("sap/ui/table/TableGrouping",['jquery.sap.global','sap/ui/core/Element','sap/ui/model/Sorter','sap/ui/Device','./library'],function(q,E,S,D,l){"use strict";var T={TableUtils:null,clearMode:function(t){t._mode=null;},setGroupMode:function(t){t._mode="Group";},isGroupMode:function(t){return t._mode=="Group";},setTreeMode:function(t){t._mode="Tree";},isTreeMode:function(t){return t._mode=="Tree";},getModeCssClass:function(t){if(t._mode){return"sapUiTable"+t._mode+"Mode";}return null;},showGroupMenuButton:function(t){if(t._bShowGroupMenuButton===true||t._bShowGroupMenuButton===false){return t._bShowGroupMenuButton;}if(D.support.touch&&T.TableUtils.isInstanceOf(t,"sap/ui/table/AnalyticalTable")){t._bShowGroupMenuButton=true;}else{t._bShowGroupMenuButton=false;}return t._bShowGroupMenuButton;},toggleGroupHeader:function(t,r,e){var b=t.getBinding("rows");if(b){var i=b.isExpanded(r);if(e===true&&!i){b.expand(r);}else if(e===false&&i){b.collapse(r);}else if(e!==true&&e!==false){b.toggleIndex(r);}else{return null;}return!i;}return null;},_calcGroupIndent:function(t,L,c){if(T.TableUtils.isInstanceOf(t,"sap/ui/table/TreeTable")){var I=0;for(var i=0;i<L;i++){I=I+(i<2?12:8);}return I;}else if(T.TableUtils.isInstanceOf(t,"sap/ui/table/AnalyticalTable")){var I=0;L=L-1;L=!c?L-1:L;L=Math.max(L,0);for(var i=0;i<L;i++){if(I==0){I=12;}I=I+(i<2?12:8);}return I;}else{var I=0;L=!c?L-1:L;L=Math.max(L,0);for(var i=0;i<L;i++){I=I+(i<2?12:8);}return I;}},_setIndent:function(t,r,R,i){var b=t._bRtlMode,f=r.find("td.sapUiTableTdFirst > .sapUiTableCell"),s=R.find(".sapUiTableGroupShield");if(i<=0){R.css(b?"right":"left","");s.css("width","").css(b?"margin-right":"margin-left","");f.css(b?"padding-right":"padding-left","");}else{R.css(b?"right":"left",i+"px");s.css("width",i+"px").css(b?"margin-right":"margin-left",((-1)*i)+"px");f.css(b?"padding-right":"padding-left",(i+8)+"px");}},updateTableRowForGrouping:function(t,r,c,e,h,s,L,g){var d=r.getDomRefs(true),R=d.row,$=d.rowScrollPart,f=d.rowFixedPart,a=d.rowSelector;R.attr({"data-sap-ui-level":L});R.data("sap-ui-level",L);if(T.isGroupMode(t)){R.toggleClass("sapUiAnalyticalTableSum",!c&&s).toggleClass("sapUiAnalyticalTableDummy",false).toggleClass("sapUiTableGroupHeader",c).toggleClass("sapUiTableRowHidden",c&&h||r._bHidden);q.sap.byId(r.getId()+"-groupHeader").toggleClass("sapUiTableGroupIconOpen",c&&e).toggleClass("sapUiTableGroupIconClosed",c&&!e).attr("title",g||null).text(g||"");T._setIndent(t,R,a,T._calcGroupIndent(t,L,c));}var b=null;if(T.isTreeMode(t)){b=R.find(".sapUiTableTreeIcon");b.css(t._bRtlMode?"margin-right":"margin-left",(L*17)+"px").toggleClass("sapUiTableTreeIconLeaf",!c).toggleClass("sapUiTableTreeIconNodeOpen",c&&e).toggleClass("sapUiTableTreeIconNodeClosed",c&&!e);}if(T.showGroupMenuButton(t)){var i=0;var j=t.$();if(j.hasClass("sapUiTableVScr")){i+=j.find('.sapUiTableVSb').width();}var G=a.find(".sapUiTableGroupMenuButton");if(t._bRtlMode){G.css("right",(j.width()-G.width()+a.position().left-i)+"px");}else{G.css("left",(j.width()-G.width()-a.position().left-i)+"px");}}t._getAccExtension().updateAriaExpandAndLevelState(r,$,a,f,c,e,L,b);},cleanupTableRowForGrouping:function(t,r){var d=r.getDomRefs(true);d.row.removeAttr("data-sap-ui-level");d.row.removeData("sap-ui-level");if(T.isGroupMode(t)){d.row.removeClass("sapUiTableGroupHeader sapUiAnalyticalTableSum sapUiAnalyticalTableDummy");T._setIndent(t,d.row,d.rowSelector,0);}var $=null;if(T.isTreeMode(t)){$=d.row.find(".sapUiTableTreeIcon");$.removeClass("sapUiTableTreeIconLeaf").removeClass("sapUiTableTreeIconNodeOpen").removeClass("sapUiTableTreeIconNodeClosed").css(this._bRtlMode?"margin-right":"margin-left","");}t._getAccExtension().updateAriaExpandAndLevelState(r,d.rowScrollPart,d.rowSelector,d.rowFixedPart,false,false,-1,$);},setupExperimentalGrouping:function(t){if(!t.getEnableGrouping()){return;}var b=E.prototype.getBinding.call(t,"rows");var g=sap.ui.getCore().byId(t.getGroupBy());var I=g&&g.getGrouped()&&b&&T.TableUtils.isInstanceOf(b,"sap/ui/model/ClientListBinding");if(!I||b._modified){return;}b._modified=true;T.setGroupMode(t);var p=g.getSortProperty();b.sort(new S(p));var L=b.getLength(),c=b.getContexts(0,L);var k;var C=0;for(var i=L-1;i>=0;i--){var n=c[i].getProperty(p);if(!k){k=n;}if(k!==n){var G=c[i+1].getModel().getContext("/sap.ui.table.GroupInfo"+i);G.__groupInfo={oContext:c[i+1],name:k,count:C,groupHeader:true,expanded:true};c.splice(i+1,0,G);k=n;C=0;}C++;}var G=c[0].getModel().getContext("/sap.ui.table.GroupInfo");G.__groupInfo={oContext:c[0],name:k,count:C,groupHeader:true,expanded:true};c.splice(0,0,G);q.extend(b,{getLength:function(){return c.length;},getContexts:function(s,L){return c.slice(s,s+L);},isGroupHeader:function(a){var o=c[a];return o&&o.__groupInfo&&o.__groupInfo.groupHeader;},getTitle:function(a){var o=c[a];return o&&o.__groupInfo&&o.__groupInfo.name+" - "+o.__groupInfo.count;},isExpanded:function(a){var o=c[a];return this.isGroupHeader(a)&&o.__groupInfo&&o.__groupInfo.expanded;},expand:function(a){if(this.isGroupHeader(a)&&!c[a].__groupInfo.expanded){for(var i=0;i<c[a].__childs.length;i++){c.splice(a+1+i,0,c[a].__childs[i]);}delete c[a].__childs;c[a].__groupInfo.expanded=true;this._fireChange();}},collapse:function(a){if(this.isGroupHeader(a)&&c[a].__groupInfo.expanded){c[a].__childs=c.splice(a+1,c[a].__groupInfo.count);c[a].__groupInfo.expanded=false;this._fireChange();}},toggleIndex:function(a){if(this.isExpanded(a)){this.collapse(a);}else{this.expand(a);}}});t._mTimeouts.groupingFireBindingChange=t._mTimeouts.groupingFireBindingChange||window.setTimeout(function(){b._fireChange();},0);},resetExperimentalGrouping:function(t){var b=t.getBinding("rows");if(b&&b._modified){T.clearMode(t);var B=t.getBindingInfo("rows");t.unbindRows();t.bindRows(B);}}};return T;},true);};if(!jQuery.sap.isDeclared('sap.ui.table.TableUtils')){jQuery.sap.declare('sap.ui.table.TableUtils');jQuery.sap.require('jquery.sap.global');jQuery.sap.require('sap.ui.core.Control');jQuery.sap.require('sap.ui.core.ResizeHandler');sap.ui.define("sap/ui/table/TableUtils",['jquery.sap.global','sap/ui/core/Control','sap/ui/core/ResizeHandler','./TableGrouping','./library'],function(q,C,R,T,l){"use strict";var S=l.SelectionBehavior,N=l.NavigationMode,a=l.SelectionMode;var b={Grouping:T,CELLTYPES:{DATACELL:"DATACELL",COLUMNHEADER:"COLUMNHEADER",ROWHEADER:"ROWHEADER",COLUMNROWHEADER:"COLUMNROWHEADER"},CONTENT_DENSITY_ROW_HEIGHTS:{sapUiSizeCondensed:24,sapUiSizeCompact:32,sapUiSizeCozy:48,undefined:27},hasRowHeader:function(t){return(t.getSelectionMode()!==a.None&&t.getSelectionBehavior()!==S.RowOnly)||T.isGroupMode(t);},isRowSelectionAllowed:function(t){return t.getSelectionMode()!==a.None&&(t.getSelectionBehavior()===S.Row||t.getSelectionBehavior()===S.RowOnly);},isRowSelectorSelectionAllowed:function(t){return t.getSelectionMode()!==a.None&&b.hasRowHeader(t);},isNoDataVisible:function(t){if(!t.getShowNoData()){return false;}var B=t.getBinding("rows"),i=t._getRowCount(),h=B?!!i:false;if(B&&B.providesGrandTotal){var H=B.providesGrandTotal()&&B.hasTotaledMeasures();h=(H&&i<2)||(!H&&i===0)?false:true;}return!h;},isInstanceOf:function(o,t){if(!o||!t){return false;}var c=sap.ui.require(t);return!!(c&&(o instanceof c));},toggleGroupHeader:function(t,r,e){var $=q(r),g;if($.hasClass("sapUiTableTreeIcon")){g=$.closest("tr");}else{g=$.closest(".sapUiTableGroupHeader");}var B=t.getBinding("rows");if(g.length>0&&B){var i=t.getFirstVisibleRow()+parseInt(g.attr("data-sap-ui-rowindex"),10);var I=T.toggleGroupHeader(t,i,e);var c=I===true||I===false;if(c&&t._onGroupHeaderChanged){t._onGroupHeaderChanged(i,I);}return c;}return false;},getNoDataText:function(t){var n=t.getNoData();if(n instanceof C){return null;}else if(typeof n==="string"||t.getNoData()instanceof String){return n;}else{return t._oResBundle.getText("TBL_NO_DATA");}},getVisibleColumnCount:function(t){return t._getVisibleColumns().length;},getHeaderRowCount:function(t){if(!t.getColumnHeaderVisible()){return 0;}var h=0;q.each(t._getVisibleColumns(),function(i,c){h=Math.max(h,c.getMultiLabels().length);});return h>0?h:1;},getRowHeightByIndex:function(t,r){var i=0;if(t){var c=t.getRows();if(c&&c.length&&r>-1&&r<c.length){var d=c[r].getDomRefs();if(d){if(d.rowScrollPart&&d.rowFixedPart){i=Math.max(d.rowScrollPart.clientHeight,d.rowFixedPart.clientHeight);}else if(!d.rowFixedPart){i=d.rowScrollPart.clientHeight;}}}}return i;},isVariableRowHeightEnabled:function(t){return t._bVariableRowHeightEnabled&&t.getNavigationMode()===N.Scrollbar&&t.getFixedRowCount()<=0&&t.getFixedBottomRowCount()<=0;},getTotalRowCount:function(t,i){var r=t._getRowCount();if(i){r=Math.max(r,t.getVisibleRowCount());}return r;},getNonEmptyVisibleRowCount:function(t){return Math.min(t.getVisibleRowCount(),t._getRowCount());},getFocusedItemInfo:function(t){var i=t._getItemNavigation();if(!i){return null;}return{cell:i.getFocusedIndex(),columnCount:i.iColumns,cellInRow:i.getFocusedIndex()%i.iColumns,row:Math.floor(i.getFocusedIndex()/i.iColumns),cellCount:i.getItemDomRefs().length,domRef:i.getFocusedDomRef()};},getColumnIndexOfFocusedCell:function(t){var i=b.getFocusedItemInfo(t);return i.cellInRow-(b.hasRowHeader(t)?1:0);},getRowIndexOfFocusedCell:function(t){var i=b.getFocusedItemInfo(t);return i.row-b.getHeaderRowCount(t);},isInGroupingRow:function(c){var i=b.getCellInfo(c);if(i&&i.type===b.CELLTYPES.DATACELL){return i.cell.parent().hasClass("sapUiTableGroupHeader");}else if(i&&i.type===b.CELLTYPES.ROWHEADER){return i.cell.hasClass("sapUiTableGroupHeader");}return false;},isInSumRow:function(c){var i=b.getCellInfo(c);if(i&&i.type===b.CELLTYPES.DATACELL){return i.cell.parent().hasClass("sapUiAnalyticalTableSum");}else if(i&&i.type===b.CELLTYPES.ROWHEADER){return i.cell.hasClass("sapUiAnalyticalTableSum");}return false;},isFixedColumn:function(t,c){return c<t.getFixedColumnCount();},hasFixedColumns:function(t){return t.getFixedColumnCount()>0;},focusItem:function(t,i,e){var I=t._getItemNavigation();if(I){I.focusItem(i,e);}},getCellInfo:function(c){if(!c){return null;}var $=q(c);if($.hasClass("sapUiTableTd")){return{type:b.CELLTYPES.DATACELL,cell:$};}else if($.hasClass("sapUiTableCol")){return{type:b.CELLTYPES.COLUMNHEADER,cell:$};}else if($.hasClass("sapUiTableRowHdr")){return{type:b.CELLTYPES.ROWHEADER,cell:$};}else if($.hasClass("sapUiTableColRowHdr")){return{type:b.CELLTYPES.COLUMNROWHEADER,cell:$};}return null;},getColumnHeaderCellInfo:function(c){if(c==null){return null;}var $=q(c);var o=this.getCellInfo($);if(o!==null&&o.type===b.CELLTYPES.COLUMNHEADER){return{index:parseInt($.data("sap-ui-colindex"),10),span:parseInt($.data("sap-ui-colspan"),10)};}else{return null;}},getRowColCell:function(t,r,c){var o=t.getRows()[r];var d=t._getVisibleColumns()[c];var e=o&&o.getCells()[c];if(e&&e.data("sap-ui-colid")!=d.getId()){var f=o.getCells();for(var i=0;i<f.length;i++){if(f[i].data("sap-ui-colid")===d.getId()){e=f[i];break;}}}return{row:o,column:d,cell:e};},registerResizeHandler:function(t,i,h,r){var d;if(typeof i=="string"){d=t.getDomRef(i);}else{q.sap.log.error("sIdSuffix must be a string",t);return;}if(typeof h!=="function"){q.sap.log.error("fnHandler must be a function",t);return;}this.deregisterResizeHandler(t,i);if(!t._mResizeHandlerIds){t._mResizeHandlerIds={};}if(r&&d){d=d.parentNode;}if(d){t._mResizeHandlerIds[i]=R.register(d,h);}return t._mResizeHandlerIds[i];},deregisterResizeHandler:function(t,I){var c;if(!t._mResizeHandlerIds){return;}if(typeof I=="string"){c=[I];}else if(I===undefined){c=[];for(var k in t._mResizeHandlerIds){if(typeof k=="string"&&t._mResizeHandlerIds.hasOwnProperty(k)){c.push(k);}}}else if(q.isArray(I)){c=I;}for(var i=0;i<c.length;i++){var s=c[i];if(t._mResizeHandlerIds[s]){R.deregister(t._mResizeHandlerIds[s]);t._mResizeHandlerIds[s]=undefined;}}},scroll:function(t,d,p){var p=t.getNavigationMode()===N.Scrollbar?p:true;var s=false;var r=t._getRowCount();var v=t.getVisibleRowCount();var i=v-t.getFixedRowCount()-t.getFixedBottomRowCount();var f=t._getSanitizedFirstVisibleRow();var c=p?i:1;if(d){if(f+v<r){t.setFirstVisibleRow(Math.min(f+c,r-v));s=true;}}else{if(f>0){t.setFirstVisibleRow(Math.max(f-c,0));s=true;}}t._bIsScrolledByKeyboard=s;return s;},scrollMax:function(t,d){var s=false;var f=t._getSanitizedFirstVisibleRow();if(d){var F=t._getRowCount()-this.getNonEmptyVisibleRowCount(t);if(f<F){t.setFirstVisibleRow(F);s=true;}}else{if(f>0){t.setFirstVisibleRow(0);s=true;}}return s;},isFirstScrollableRow:function(t,r){var $=q(r);var i=parseInt($.add($.parent()).filter("[data-sap-ui-rowindex]").attr("data-sap-ui-rowindex"),10);var f=t.getFixedRowCount()||0;return i==f;},isLastScrollableRow:function(t,r){var $=q(r);var i=parseInt($.add($.parent()).filter("[data-sap-ui-rowindex]").attr("data-sap-ui-rowindex"),10);var f=t.getFixedBottomRowCount()||0;return i==t.getVisibleRowCount()-f-1;},getContentDensity:function(c){var s;var d=["sapUiSizeCompact","sapUiSizeCondensed","sapUiSizeCozy"];var g=function(f,o){if(!o[f]){return;}for(var i=0;i<d.length;i++){if(o[f](d[i])){return d[i];}}};var D=c.$();if(D.length>0){s=g("hasClass",D);}else{s=g("hasStyleClass",c);}if(s){return s;}var p=null;var P=c.getParent();if(P){do{s=g("hasStyleClass",P);if(s){return s;}if(P.getDomRef){p=P.getDomRef();}else if(P.getRootNode){p=P.getRootNode();}if(!p&&P.getParent){P=P.getParent();}else{P=null;}}while(P&&!p)}D=q(p||document.body);s=g("hasClass",D.closest("."+d.join(",.")));return s;},sanitizeSelectionMode:function(t,s){if(s===a.Multi){s=a.MultiToggle;q.sap.log.warning("The selection mode 'Multi' is deprecated and must not be used anymore. Your setting was defaulted to selection mode 'MultiToggle'");}return s;},resizeColumn:function(t,c,w,f,d){if(t==null||c==null||c<0||w==null||w<=0){return;}if(d==null||d<=0){d=1;}if(f==null){f=true;}var e=t.getColumns();if(c>=e.length||!e[c].getVisible()){return;}var v=[];for(var i=c;i<e.length;i++){var o=e[i];if(o.getVisible()){v.push(o);if(v.length===d){break;}}}var r=[];for(var i=0;i<v.length;i++){var V=v[i];if(V.getResizable()){r.push(V);}}if(r.length===0){return;}var s=0;for(var i=0;i<v.length;i++){var V=v[i];s+=this.getColumnWidth(t,V.getIndex());}var p=w-s;var g=Math.round(p/r.length);for(var i=0;i<r.length;i++){var h=r[i];var j=this.getColumnWidth(t,h.getIndex());var n=j+g;if(n<t._iColMinWidth){n=t._iColMinWidth;}var W=n-j;if(Math.abs(W)<Math.abs(g)){var k=r.length-(i+1);p-=W;g=Math.round(p/k);}if(W!==0){var E=true;if(f){E=t.fireColumnResize({column:h,width:n});}if(E){h.setWidth(n+"px");}}}},getColumnWidth:function(t,c){if(t==null||c==null||c<0){return null;}var d=t.getColumns();if(c>=d.length){return null;}var o=d[c];return t._CSSSizeToPixel(o.getWidth());}};T.TableUtils=b;return b;},true);};if(!jQuery.sap.isDeclared('sap.ui.table.AnalyticalColumn')){jQuery.sap.declare('sap.ui.table.AnalyticalColumn');jQuery.sap.require('jquery.sap.global');jQuery.sap.require('sap.ui.core.Element');jQuery.sap.require('sap.ui.model.type.Boolean');jQuery.sap.require('sap.ui.model.type.DateTime');jQuery.sap.require('sap.ui.model.type.Float');jQuery.sap.require('sap.ui.model.type.Integer');jQuery.sap.require('sap.ui.model.type.Time');sap.ui.define("sap/ui/table/AnalyticalColumn",['jquery.sap.global','./Column','./library','sap/ui/core/Element','sap/ui/model/type/Boolean','sap/ui/model/type/DateTime','sap/ui/model/type/Float','sap/ui/model/type/Integer','sap/ui/model/type/Time','./TableUtils'],function(q,C,l,E,B,D,F,I,T,a){"use strict";function i(c){return a.isInstanceOf(c,"sap/ui/table/AnalyticalTable");}var A=C.extend("sap.ui.table.AnalyticalColumn",{metadata:{library:"sap.ui.table",properties:{leadingProperty:{type:"string",group:"Misc",defaultValue:null},summed:{type:"boolean",group:"Misc",defaultValue:false},inResult:{type:"boolean",group:"Misc",defaultValue:false},showIfGrouped:{type:"boolean",group:"Appearance",defaultValue:false},groupHeaderFormatter:{type:"any",group:"Behavior",defaultValue:null}}}});A.prototype.init=function(){C.prototype.init.apply(this,arguments);this._bSkipUpdateAI=false;};A._DEFAULT_FILTERTYPES={"Time":new T({UTC:true}),"DateTime":new D({UTC:true}),"Float":new F(),"Integer":new I(),"Boolean":new Boolean()};A.prototype._createMenu=function(){var b=sap.ui.requireSync("sap/ui/table/AnalyticalColumnMenu");return new b(this.getId()+"-menu");};A.prototype.setGrouped=function(g,s){var p=this.getParent();var t=this;if(i(p)){if(g){p._addGroupedColumn(this.getId());}else{p._aGroupedColumns=q.grep(p._aGroupedColumns,function(v){return v!=t.getId();});}}var r=this.setProperty("grouped",g,s);this._updateColumns(true);return r;};A.prototype.setSummed=function(s){var r=this.setProperty("summed",s,true);this._updateTableAnalyticalInfo();return r;};A.prototype.setVisible=function(v,s){this.setProperty("visible",v,s);this._updateColumns();return this;};A.prototype.getLabel=function(){var L=this.getAggregation("label");if(!L){if(!this._oBindingLabel){var p=this.getParent();if(i(p)){var b=p.getBinding("rows");if(b){this._oBindingLabel=l.TableHelper.createLabel();var m=b.getModel();if(m.oMetadata&&m.oMetadata.isLoaded()){this._oBindingLabel.setText(b.getPropertyLabel(this.getLeadingProperty()));}else{var t=this;m.attachMetadataLoaded(function(){t._oBindingLabel.setText(b.getPropertyLabel(t.getLeadingProperty()));});}}}}L=this._oBindingLabel;}return L;};A.prototype.getFilterProperty=function(){var p=this.getProperty("filterProperty");if(!p){var P=this.getParent();if(i(P)){var b=P.getBinding("rows");var L=this.getLeadingProperty();if(b&&q.inArray(L,b.getFilterablePropertyNames())>-1){p=L;}}}return p;};A.prototype.getSortProperty=function(){var p=this.getProperty("sortProperty");if(!p){var P=this.getParent();if(i(P)){var b=P.getBinding("rows");var L=this.getLeadingProperty();if(b&&q.inArray(L,b.getSortablePropertyNames())>-1){p=L;}}}return p;};A.prototype.getFilterType=function(){var f=this.getProperty("filterType");if(!f){var p=this.getParent();if(i(p)){var b=p.getBinding("rows");var L=this.getLeadingProperty(),P=b&&b.getProperty(L);if(P){switch(P.type){case"Edm.Time":f=A._DEFAULT_FILTERTYPES["Time"];break;case"Edm.DateTime":case"Edm.DateTimeOffset":f=A._DEFAULT_FILTERTYPES["DateTime"];break;case"Edm.Single":case"Edm.Double":case"Edm.Decimal":f=A._DEFAULT_FILTERTYPES["Float"];break;case"Edm.SByte":case"Edm.Int16":case"Edm.Int32":case"Edm.Int64":f=A._DEFAULT_FILTERTYPES["Integer"];break;case"Edm.Boolean":f=A._DEFAULT_FILTERTYPES["Boolean"];break;}}}}return f;};A.prototype._afterSort=function(){this._updateTableAnalyticalInfo();};A.prototype._updateColumns=function(s,f){if(this._bSkipUpdateAI){return;}var p=this.getParent();if(i(p)){p._updateColumns(s,f);}};A.prototype._updateTableAnalyticalInfo=function(s){if(this._bSkipUpdateAI){return;}var p=this.getParent();if(p&&i(p)&&!p._bSuspendUpdateAnalyticalInfo){p.updateAnalyticalInfo(s);}};A.prototype._updateTableColumnDetails=function(){if(this._bSkipUpdateAI){return;}var p=this.getParent();if(p&&i(p)&&!p._bSuspendUpdateAnalyticalInfo){p._updateTableColumnDetails();}};A.prototype.shouldRender=function(){if(!this.getVisible()){return false;}return(!this.getGrouped()||this._bLastGroupAndGrouped||this.getShowIfGrouped())&&(!this._bDependendGrouped||this._bLastGroupAndGrouped);};A.prototype.getTooltip_AsString=function(){var t=E.prototype.getTooltip_AsString.apply(this);var p=this.getParent();if(!t&&i(p)){var b=p.getBinding("rows");if(b&&this.getLeadingProperty()){t=b.getPropertyQuickInfo(this.getLeadingProperty());}}return t;};A.prototype._menuHasItems=function(){var m=function(){var t=this.getParent();var b=t.getBinding("rows");var r=b&&b.getAnalyticalQueryResult();return(t&&r&&r.findMeasureByPropertyName(this.getLeadingProperty()));}.bind(this);return C.prototype._menuHasItems.apply(this)||m();};A.prototype.isFilterableByMenu=function(){var f=this.getFilterProperty();if(!f||!this.getShowFilterMenuEntry()){return false;}var p=this.getParent();if(i(p)){var b=p.getBinding("rows");if(b){if(q.inArray(f,b.getFilterablePropertyNames())>-1&&!b.isMeasure(f)&&b.getProperty(f)){return true;}}}return false;};A.prototype.isGroupableByMenu=function(){var p=this.getParent();if(i(p)){var b=p.getBinding("rows");if(b){var r=b.getAnalyticalQueryResult();if(r&&r.findDimensionByPropertyName(this.getLeadingProperty())&&q.inArray(this.getLeadingProperty(),b.getSortablePropertyNames())>-1&&q.inArray(this.getLeadingProperty(),b.getFilterablePropertyNames())>-1){return true;}}}return false;};return A;});};if(!jQuery.sap.isDeclared('sap.ui.table.ColumnMenu')){jQuery.sap.declare('sap.ui.table.ColumnMenu');jQuery.sap.require('jquery.sap.global');jQuery.sap.require('sap.ui.core.RenderManager');jQuery.sap.require('sap.ui.unified.Menu');jQuery.sap.require('sap.ui.unified.MenuItem');jQuery.sap.require('sap.ui.Device');sap.ui.define("sap/ui/table/ColumnMenu",['jquery.sap.global','sap/ui/core/RenderManager','./library','sap/ui/unified/Menu','sap/ui/unified/MenuItem','sap/ui/Device','./TableUtils'],function(q,R,a,M,b,D,T){"use strict";var C=M.extend("sap.ui.table.ColumnMenu",{metadata:{library:"sap.ui.table"}});C.prototype.init=function(){if(M.prototype.init){M.prototype.init.apply(this,arguments);}this.addStyleClass("sapUiTableColumnMenu");this.oResBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.table");this._bInvalidated=true;this._iPopupClosedTimeoutId=null;this._oColumn=null;this._oTable=null;this._attachPopupClosed();};C.prototype.exit=function(){if(M.prototype.exit){M.prototype.exit.apply(this,arguments);}window.clearTimeout(this._iPopupClosedTimeoutId);this._detachEvents();this._oColumn=this._oTable=null;};C.prototype.onThemeChanged=function(){if(this.getDomRef()){this._invalidate();}};C.prototype.setParent=function(p){this._detachEvents();this._invalidate();this._updateReferences(p);this._attachEvents();return M.prototype.setParent.apply(this,arguments);};C.prototype._updateReferences=function(p){this._oColumn=p;if(p){this._oTable=this._oColumn.getParent();if(this._oTable){}}};C.prototype._attachEvents=function(){if(this._oTable){this._oTable.attachColumnVisibility(this._invalidate,this);this._oTable.attachColumnMove(this._invalidate,this);}};C.prototype._detachEvents=function(){if(this._oTable){this._oTable.detachColumnVisibility(this._invalidate,this);this._oTable.detachColumnMove(this._invalidate,this);}};C.prototype._invalidate=function(){this._bInvalidated=true;};C.prototype._attachPopupClosed=function(){var t=this;if(!D.support.touch){this.getPopup().attachClosed(function(){t._iPopupClosedTimeoutId=window.setTimeout(function(){if(t._oColumn){if(t._lastFocusedDomRef){t._lastFocusedDomRef.focus();}else{t._oColumn.focus();}}},0);});}};C.prototype.open=function(){if(this._bInvalidated){this._bInvalidated=false;this.destroyItems();this._addMenuItems();}if(this.getItems().length>0){this._lastFocusedDomRef=arguments[4];M.prototype.open.apply(this,arguments);}};C.prototype._addMenuItems=function(){if(this._oColumn){this._addSortMenuItem(false);this._addSortMenuItem(true);this._addFilterMenuItem();this._addGroupMenuItem();this._addFreezeMenuItem();this._addColumnVisibilityMenuItem();}};C.prototype._addSortMenuItem=function(d){var o=this._oColumn;if(o.isSortableByMenu()){var s=d?"desc":"asc";var i=d?"sort-descending":"sort-ascending";if(o.getSortProperty()&&o.getShowSortMenuEntry()){this.addItem(this._createMenuItem(s,"TBL_SORT_"+s.toUpperCase(),i,function(e){o.sort(d,e.getParameter("ctrlKey")===true);}));}}};C.prototype._addFilterMenuItem=function(){var o=this._oColumn;var t=o.getParent();var e=false;if(t){e=t.getEnableCustomFilter();}if(o.isFilterableByMenu()){if(e){this.addItem(this._createMenuItem("filter","TBL_FILTER_ITEM","filter",function(){t.fireCustomFilter({column:o});}));}else{this.addItem(this._createMenuTextFieldItem("filter","TBL_FILTER","filter",o.getFilterValue(),function(){o.filter(this.getValue());}));}}};C.prototype._addGroupMenuItem=function(){var o=this._oColumn;var t=this._oTable;if(o.isGroupableByMenu()){if(t&&t.getEnableGrouping()&&o.getSortProperty()){this.addItem(this._createMenuItem("group","TBL_GROUP",null,q.proxy(function(){t.setGroupBy(o);},this)));}}};C.prototype._addFreezeMenuItem=function(){var o=this._oColumn;var t=this._oTable;if(t&&t.getEnableColumnFreeze()){var i=q.inArray(o,t.getColumns());var I=i+1==t.getFixedColumnCount();this.addItem(this._createMenuItem("freeze",I?"TBL_UNFREEZE":"TBL_FREEZE",null,function(){var e=t.fireColumnFreeze({column:o});if(e){if(I){t.setFixedColumnCount(0);}else{t.setFixedColumnCount(i+1);}}}));}};C.prototype._addColumnVisibilityMenuItem=function(){var t=this._oTable;if(t&&t.getShowColumnVisibilityMenu()){var o=this._createMenuItem("column-visibilty","TBL_COLUMNS");this.addItem(o);var d=new M(o.getId()+"-menu");d.addStyleClass("sapUiTableColumnVisibilityMenu");o.setSubmenu(d);var e=t.getColumns();if(t.getColumnVisibilityMenuSorter&&typeof t.getColumnVisibilityMenuSorter==="function"){var s=t.getColumnVisibilityMenuSorter();if(typeof s==="function"){e=e.sort(s);}}var B=t.getBinding();var A=c(B,"sap/ui/model/analytics/AnalyticalBinding");for(var i=0,l=e.length;i<l;i++){var f=e[i];if(A&&c(f,"sap/ui/table/AnalyticalColumn")){var Q=B.getAnalyticalQueryResult();var E=Q.getEntityType();var m=B.getModel().getProperty("/#"+E.getTypeDescription().name+"/"+f.getLeadingProperty()+"/sap:visible");if(m&&(m.value==="false"||m.value===false)){continue;}}var g=this._createColumnVisibilityMenuItem(d.getId()+"-item-"+i,f);d.addItem(g);}}};C.prototype._createColumnVisibilityMenuItem=function(i,o){var t=o.getName()||(o.getLabel()&&o.getLabel().getText?o.getLabel().getText():null);return new b(i,{text:t,icon:o.getVisible()?"sap-icon://accept":null,select:q.proxy(function(e){var m=e.getSource();var v=!o.getVisible();if(v||T.getVisibleColumnCount(this._oTable)>1){var d=o.getParent();var E=true;if(d&&c(d,"sap/ui/table/Table")){E=d.fireColumnVisibility({column:o,newVisible:v});}if(E){o.setVisible(v);}m.setIcon(v?"sap-icon://accept":null);}},this)});};C.prototype._createMenuItem=function(i,t,I,h){return new b(this.getId()+"-"+i,{text:this.oResBundle.getText(t),icon:I?"sap-icon://"+I:null,select:h||function(){}});};C.prototype._createMenuTextFieldItem=function(i,t,I,v,h){var d=sap.ui.requireSync("sap/ui/unified/MenuTextFieldItem");h=h||function(){};return new d(this.getId()+"-"+i,{label:this.oResBundle.getText(t),icon:I?"sap-icon://"+I:null,value:v,select:h||function(){}});};C.prototype._setFilterValue=function(v){var o=this.getParent();var t=(o?o.getParent():undefined);var f=sap.ui.getCore().byId(this.getId()+"-filter");if(f&&(t&&!t.getEnableCustomFilter())){f.setValue(v);}return this;};C.prototype._setFilterState=function(f){var o=this.getParent();var t=(o?o.getParent():undefined);var F=sap.ui.getCore().byId(this.getId()+"-filter");if(F&&(t&&!t.getEnableCustomFilter())){F.setValueState(f);}return this;};function c(o,m){var F=sap.ui.require(m);return typeof F==='function'&&(o instanceof F);}return C;});};if(!jQuery.sap.isDeclared('sap.ui.table.TableExtension')){jQuery.sap.declare('sap.ui.table.TableExtension');jQuery.sap.require('jquery.sap.global');jQuery.sap.require('sap.ui.base.Object');sap.ui.define("sap/ui/table/TableExtension",['jquery.sap.global','sap/ui/base/Object','./TableUtils'],function(q,B,T){"use strict";var a=B.extend("sap.ui.table.TableExtension",{constructor:function(t,s){B.call(this);this._table=t;this._settings=s||{};this._type=a.TABLETYPES.STANDARD;if(T.isInstanceOf(t,"sap/ui/table/TreeTable")){this._type=a.TABLETYPES.TREE;}else if(T.isInstanceOf(t,"sap/ui/table/AnalyticalTable")){this._type=a.TABLETYPES.ANALYTICAL;}var n=this._init(this._table,this._type,this._settings);if(n){var b=this;t["_get"+n]=function(){return b;};}},destroy:function(){this._table=null;this._type=null;B.prototype.destroy.apply(this,arguments);},getInterface:function(){return this;}});a.TABLETYPES={TREE:"TREE",ANALYTICAL:"ANALYTICAL",STANDARD:"STANDARD"};a.prototype.getTable=function(){return this._table;};a.prototype._init=function(t,s,S){return null;};a.prototype._attachEvents=function(){};a.prototype._detachEvents=function(){};a.attachEvents=function(t){if(!t._aExtensions){return;}for(var i=0;i<t._aExtensions.length;i++){t._aExtensions[i]._attachEvents();}};a.detachEvents=function(t){if(!t._aExtensions){return;}for(var i=0;i<t._aExtensions.length;i++){t._aExtensions[i]._detachEvents();}};a.enrich=function(t,e,s){if(!e||!(e.prototype instanceof a)){return null;}var E=new e(t,s);if(!t._aExtensions){t._aExtensions=[];}t._aExtensions.push(E);return E;};a.cleanup=function(t){if(!t._bExtensionsInitialized||!t._aExtensions){return;}for(var i=0;i<t._aExtensions.length;i++){t._aExtensions[i].destroy();}delete t._aExtensions;delete t._bExtensionsInitialized;};return a;});};if(!jQuery.sap.isDeclared('sap.ui.table.TableKeyboardDelegate')){jQuery.sap.declare('sap.ui.table.TableKeyboardDelegate');jQuery.sap.require('jquery.sap.global');jQuery.sap.require('sap.ui.base.Object');sap.ui.define("sap/ui/table/TableKeyboardDelegate",['jquery.sap.global','sap/ui/base/Object','./library','./Row','./TableExtension','./TableUtils'],function(q,B,l,R,T,a){"use strict";var S=l.SelectionBehavior;var b=B.extend("sap.ui.table.TableKeyboardDelegate",{constructor:function(t){B.call(this);if(t===T.TABLETYPES.ANALYTICAL){this.onsapselect=function(e){if(q(e.target).hasClass("sapUiAnalyticalTableSum")){e.preventDefault();return;}else{if(b.prototype.onsapselect){b.prototype.onsapselect.apply(this,arguments);}}};}else if(t===T.TABLETYPES.TREE){this.onkeydown=function(e){b.prototype.onkeydown.apply(this,arguments);var $=q(e.target),c=$.closest('td');if(e.keyCode==q.sap.KeyCodes.TAB&&this._getKeyboardExtension().isInActionMode()&&c.find('.sapUiTableTreeIcon').length>0){if($.hasClass('sapUiTableTreeIcon')){if(!$.hasClass("sapUiTableTreeIconLeaf")){c.find(':sapFocusable:not(.sapUiTableTreeIcon)').first().focus();}}else{c.find('.sapUiTableTreeIcon:not(.sapUiTableTreeIconLeaf)').focus();}e.preventDefault();}};}},destroy:function(){B.prototype.destroy.apply(this,arguments);},getInterface:function(){return this;}});b._restoreFocusOnLastFocusedDataCell=function(t,e){var i=a.getFocusedItemInfo(t);var L=t._getKeyboardExtension()._getLastFocusedCellInfo();a.focusItem(t,i.cellInRow+(i.columnCount*L.row),e);};b._getFocusedRowIndex=function(t){var i=a.getFocusedItemInfo(t);var f=i.cell;var c=i.columnCount;var s=i.cellInRow;var d=t.getFirstVisibleRow()+(f-s)/c;if(!t.getColumnHeaderVisible()){d++;}return d-1;};b._isFocusedRowSelected=function(t){var s=b._getFocusedRowIndex(t);var i=t.isIndexSelected(s);var I=a.getFocusedItemInfo(t).columnCount==0;if(I){return i;}else{if(a.hasRowHeader(t)){return null;}else{return i;}}};b._moveColumn=function(c,n){var t=c.getParent(),v=t._getVisibleColumns(),i=v.indexOf(c),d;if(n&&i<v.length-1){d=t.indexOfColumn(v[i+1]);}else if(!n&&i>0){d=t.indexOfColumn(v[i-1]);}if(d!=undefined){t.removeColumn(c);t.insertColumn(c,d);}};b.prototype.enterActionMode=function(A){var f=A.$Dom;var e=false;if(f.length>0){var t=f.filter(":sapTabbable");var E=this._getKeyboardExtension();if(t.length>0){e=true;var i=this._getItemNavigation();E._suspendItemNavigation();q(i.getFocusedDomRef()).attr("tabindex","-1");t.eq(0).focus();}if(E._getTableType()===T.TABLETYPES.TREE){var $=f.eq(0);if($.hasClass("sapUiTableTreeIcon")&&!$.hasClass("sapUiTableTreeIconLeaf")){e=true;$.attr("tabindex",0).focus();}}}return e;};b.prototype.leaveActionMode=function(A){var e=A.event;var E=this._getKeyboardExtension();var i=this._getItemNavigation();E._resumeItemNavigation();q(i.getFocusedDomRef()).attr("tabindex","0");if(e){if(q(e.target).closest("td[tabindex='-1']").length>0){var I=q(i.aItemDomRefs).index(q(e.target).closest("td[tabindex='-1']").get(0));a.focusItem(this,I,null);}else{if(q.sap.containsOrEquals(this.$().find(".sapUiTableCCnt").get(0),e.target)){a.focusItem(this,i.getFocusedIndex(),null);}}}else{a.focusItem(this,i.getFocusedIndex(),null);}if(E._getTableType()===T.TABLETYPES.TREE){this.$().find(".sapUiTableTreeIcon").attr("tabindex",-1);}};b.prototype.onmouseup=function(e){if(e.isMarked()){return;}var d=this.$().find(".sapUiTableCtrl td :focus");this._getKeyboardExtension().setActionMode(d.length>0,{$Dom:d,event:e});};b.prototype.onfocusin=function(e){if(e.isMarked("sapUiTableIgnoreFocusIn")){return;}var $=q(e.target);if($.hasClass("sapUiTableOuterBefore")||$.hasClass("sapUiTableOuterAfter")||(e.target!=this.getDomRef("overlay")&&this.getShowOverlay())){this._getKeyboardExtension().setActionMode(false);this.$("overlay").focus();return;}else if($.hasClass("sapUiTableCtrlBefore")){this._getKeyboardExtension().setActionMode(false);var n=a.isNoDataVisible(this);if(!n||(n&&e.isMarked("sapUiTableInitItemNavigation")&&this.getColumnHeaderVisible())){var i=a.getFocusedItemInfo(this);a.focusItem(this,i.cellInRow,e);}else if(n){this._getKeyboardExtension()._setSilentFocus(this.$("noDataCnt"));}if(!n){e.preventDefault();}}else if($.hasClass("sapUiTableCtrlAfter")){this._getKeyboardExtension().setActionMode(false);b._restoreFocusOnLastFocusedDataCell(this,e);}};b.prototype.onkeyup=function(e){if(!this._bEventSapSelect===true){return;}this._bEventSapSelect=false;if(e.keyCode!==q.sap.KeyCodes.ENTER&&e.keyCode!==q.sap.KeyCodes.SPACE&&e.keyCode!==q.sap.KeyCodes.F4||e.srcControl!==this&&q.inArray(e.srcControl,this.getRows())===-1&&q.inArray(e.srcControl,this.getColumns())===-1){return;}if(a.toggleGroupHeader(this,e.target)){e.preventDefault();return;}this._bShowMenu=true;this._onSelect(e);this._bShowMenu=false;e.preventDefault();};b.prototype.onsapselect=function(){this._bEventSapSelect=true;};b.prototype.onsapselectmodifiers=function(){this._bEventSapSelect=true;};b.prototype.onsapspace=function(e){var $=q(e.target);if((a.isRowSelectionAllowed(this)&&e.srcControl instanceof R)||$.hasClass("sapUiTableRowHdr")||$.hasClass("sapUiTableColRowHdr")||$.hasClass("sapUiTableCol")){e.preventDefault();}};b.prototype.onkeydown=function(e){var $=this.$();var A=this._getKeyboardExtension().isInActionMode();if(!A&&e.keyCode==q.sap.KeyCodes.F2||e.keyCode==q.sap.KeyCodes.ENTER){if($.find(".sapUiTableCtrl td:focus").length>0){this._getKeyboardExtension().setActionMode(true,{$Dom:$.find(".sapUiTableCtrl td:focus").find(":sapFocusable")});e.preventDefault();e.stopPropagation();}}else if(A&&e.keyCode==q.sap.KeyCodes.F2){this._getKeyboardExtension().setActionMode(false);}else if(e.keyCode==q.sap.KeyCodes.TAB&&A){if(this.getFixedColumnCount()>0){var c=q(e.target);if(c.is("td.sapUiTableTd")==false){c=c.parents("td.sapUiTableTd");}var d=c.parent("tr[data-sap-ui-rowindex]");var f=d.closest(".sapUiTableCtrl");var r=parseInt(d.attr("data-sap-ui-rowindex"),10);var g=d.find("td.sapUiTableTd");var C=g.index(c);var t=g.length;if(C===(t-1)){var h;if(f.hasClass("sapUiTableCtrlFixed")){h=$.find(".sapUiTableCtrl.sapUiTableCtrlScroll");}else{h=$.find(".sapUiTableCtrl.sapUiTableCtrlFixed");r++;if(r==this.getVisibleRowCount()){r=0;}}var i=h.find("tr[data-sap-ui-rowindex='"+r+"']");var j=i.find("td :sapFocusable[tabindex='0']").first();if(j.length>0){j.focus();e.preventDefault();}}}}else if(e.keyCode==q.sap.KeyCodes.A&&(e.metaKey||e.ctrlKey)){var I=a.getFocusedItemInfo(this);this._toggleSelectAll();a.focusItem(this,I.cell,e);e.preventDefault();e.stopImmediatePropagation(true);}else if(e.keyCode===q.sap.KeyCodes.F10&&(e.shiftKey)){this.oncontextmenu(e);}else if(e.keyCode===q.sap.KeyCodes.NUMPAD_PLUS){a.toggleGroupHeader(this,e.target,true);}else if(e.keyCode===q.sap.KeyCodes.NUMPAD_MINUS){a.toggleGroupHeader(this,e.target,false);}};b.prototype.onsapescape=function(e){this._getKeyboardExtension().setActionMode(false,{event:e});};b.prototype.onsaptabprevious=function(e){var $=this.$();if(this._getKeyboardExtension().isInActionMode()){var t=q(e.target);var c=t.hasClass("sapUiTableTreeIcon");var C=t.parent().find(".sapUiTableTreeIcon").length===1;var p=t.prev().hasClass("sapUiTableTreeIconLeaf");if(!C||p||c){this._getKeyboardExtension().setActionMode(false);e.preventDefault();}}else{if(e.target===this.getDomRef("overlay")){this._getKeyboardExtension()._setSilentFocus($.find(".sapUiTableOuterBefore"));return;}var i=a.getFocusedItemInfo(this);var n=a.isNoDataVisible(this);var s=$.find('.sapUiTableCCnt')[0];var f=q.contains(s,e.target);if(f&&this.getColumnHeaderVisible()){a.focusItem(this,i.cellInRow,e);e.preventDefault();}else if(i.domRef===e.target&&q.sap.containsOrEquals(s,e.target)||(!this.getColumnHeaderVisible()&&n&&f)){this._getKeyboardExtension()._setSilentFocus($.find(".sapUiTableCtrlBefore"));}}};b.prototype.onsaptabnext=function(e){var $=this.$();if(this._getKeyboardExtension().isInActionMode()){var t=q(e.target);var c=t.hasClass("sapUiTableTreeIcon");var C=t.parent().find(":visible").length>1;if(!c||!C){this._getKeyboardExtension().setActionMode(false);e.preventDefault();}}else{if(e.target===this.getDomRef("overlay")){this._getKeyboardExtension()._setSilentFocus($.find(".sapUiTableOuterAfter"));return;}var i=a.getFocusedItemInfo(this);var d=q.contains($.find('.sapUiTableColHdrCnt')[0],e.target);var n=a.isNoDataVisible(this);if(d&&!n){b._restoreFocusOnLastFocusedDataCell(this,e);e.preventDefault();}else if(i.domRef===e.target||(n&&d)){this._getKeyboardExtension()._setSilentFocus($.find(".sapUiTableCtrlAfter"));}}};b.prototype.onsapdown=function(e){if(!this._getKeyboardExtension().isInActionMode()&&a.isLastScrollableRow(this,e.target)){if(this.getFirstVisibleRow()!=this._getRowCount()-this.getVisibleRowCount()){e.stopImmediatePropagation(true);a.scroll(this,true,false);}}e.preventDefault();if(a.isNoDataVisible(this)){var i=a.getCellInfo(e.target);if(i&&(i.type===a.CELLTYPES.COLUMNHEADER||i.type===a.CELLTYPES.COLUMNROWHEADER)){i=a.getFocusedItemInfo(this);if(i.row-a.getHeaderRowCount(this)<=1){e.setMarked("sapUiTableSkipItemNavigation");}}}};b.prototype.onsapdownmodifiers=function(e){if(e.shiftKey){if(this.getSelectionMode()===l.SelectionMode.Single||this.getSelectionMode()===l.SelectionMode.None){e.setMarked("sapUiTableSkipItemNavigation");e.preventDefault();}else{var f=b._getFocusedRowIndex(this);var i=b._isFocusedRowSelected(this);if(i===true){this.addSelectionInterval(f+1,f+1);}else if(i===false){this.removeSelectionInterval(f+1,f+1);}if(a.isLastScrollableRow(this,e.target)){a.scroll(this,true,false);}}}else if(e.altKey){if(a.toggleGroupHeader(this,e.target)){e.preventDefault();e.setMarked("sapUiTableSkipItemNavigation");}}};b.prototype.onsapupmodifiers=function(e){if(e.shiftKey){if(this.getSelectionMode()===l.SelectionMode.Single||this.getSelectionMode()===l.SelectionMode.None){e.setMarked("sapUiTableSkipItemNavigation");e.preventDefault();}else{var f=b._getFocusedRowIndex(this);var i=b._isFocusedRowSelected(this);if(i===true){this.addSelectionInterval(f-1,f-1);}else if(i===false){this.removeSelectionInterval(f-1,f-1);}if(a.isFirstScrollableRow(this,e.target)){if(this.getFirstVisibleRow()!=0){e.stopImmediatePropagation(true);}a.scroll(this,false,false);}}}else if(e.altKey){if(a.toggleGroupHeader(this,e.target)){e.preventDefault();e.setMarked("sapUiTableSkipItemNavigation");}}};b.prototype.onsapup=function(e){if(!this._getKeyboardExtension().isInActionMode()&&a.isFirstScrollableRow(this,e.target)){if(this.getFirstVisibleRow()!=0){e.stopImmediatePropagation(true);}a.scroll(this,false,false);}e.preventDefault();};b.prototype.onsappagedown=function(e){if(!this._getKeyboardExtension().isInActionMode()){var $=this.$();var i=a.getFocusedItemInfo(this);var r=(this.getSelectionBehavior()!==S.RowOnly);var h=$.find(".sapUiTableColHdrScr>.sapUiTableColHdr").length;if(this.getColumnHeaderVisible()&&i.cell<(i.columnCount*h)){var c=i.cellInRow;if((i.cell<=(i.columnCount*h)&&i.cell>=(i.columnCount*h)-i.columnCount)||(c===0&&r)){this.setFirstVisibleRow(0);a.focusItem(this,i.columnCount*h+c,e);}else{a.focusItem(this,i.columnCount*h-i.columnCount+c,e);}e.stopImmediatePropagation(true);}else{if(a.isLastScrollableRow(this,e.target)){a.scroll(this,true,true);}var f=this.getFixedBottomRowCount();if(this.getFirstVisibleRow()===this._getRowCount()-this.getVisibleRowCount()){f=0;}var d=(i.cellCount/i.columnCount)-f;var c=i.cell%i.columnCount;var I=(d-1)*i.columnCount+c;a.focusItem(this,I,e);e.stopImmediatePropagation(true);}e.preventDefault();}};b.prototype.onsappagedownmodifiers=function(e){if(!this._getKeyboardExtension().isInActionMode()&&e.altKey){var i=a.getFocusedItemInfo(this);var r=(this.getSelectionBehavior()!==S.RowOnly);var c=i.columnCount;var n;if(c==0&&r){n=1;}else{var m=this._getVisibleColumns().length;if(!r){m--;}n=m;}a.focusItem(this,i.cell-(c-n),e);e.stopImmediatePropagation(true);e.preventDefault();}};b.prototype.onsappageup=function(e){if(!this._getKeyboardExtension().isInActionMode()){var $=this.$();var i=a.getFocusedItemInfo(this);var r=(this.getSelectionBehavior()!==S.RowOnly);var h=$.find(".sapUiTableColHdrScr>.sapUiTableColHdr").length;var c=i.cellInRow;if(this.getColumnHeaderVisible()&&i.cell<(i.columnCount*h)){if(i.cell>i.columnCount){a.focusItem(this,c,e);}e.stopImmediatePropagation(true);}else{if(this.getColumnHeaderVisible()&&this.getFirstVisibleRow()==0&&a.isFirstScrollableRow(this,e.target)){if(r&&c===0){a.focusItem(this,c,e);}else{a.focusItem(this,i.columnCount*h-i.columnCount+c,e);}e.stopImmediatePropagation(true);}else{var I=this.getColumnHeaderVisible()?i.columnCount*h:0;a.focusItem(this,I+c,e);e.stopImmediatePropagation(true);if(a.isFirstScrollableRow(this,e.target)){a.scroll(this,false,true);}}}e.preventDefault();}};b.prototype.onsappageupmodifiers=function(e){if(!this._getKeyboardExtension().isInActionMode()&&e.altKey){var i=a.getFocusedItemInfo(this);var r=(this.getSelectionBehavior()!==S.RowOnly);var c=i.columnCount;if(c>0){var n;if(c==1&&r){n=0;}else{if(r){n=1;}else{n=0;}}a.focusItem(this,i.cell-(c-n),e);}e.stopImmediatePropagation(true);e.preventDefault();}};b.prototype.onsaphome=function(e){var i=(this.getSelectionBehavior()==S.RowOnly);var I=q(e.target).parents(".sapUiTableGroupHeader").length>0;if(I){e.stopImmediatePropagation(true);return;}var o=a.getFocusedItemInfo(this);var f=o.cell;var s=o.cellInRow;var c=0;if(!i){c=1;}if(s>this.getFixedColumnCount()+c){e.stopImmediatePropagation(true);a.focusItem(this,f-s+this.getFixedColumnCount()+c,null);}else if(!i){if(s>1){e.stopImmediatePropagation(true);a.focusItem(this,f-s+1,null);}else if(s==1){e.stopImmediatePropagation(true);a.focusItem(this,f-1,null);}else{e.stopImmediatePropagation(true);}}};b.prototype.onsapend=function(e){var i=q(e.target).parents(".sapUiTableGroupHeader").length>0;if(i){e.stopImmediatePropagation(true);return;}var I=a.getFocusedItemInfo(this);var f=I.cell;var s=I.cellInRow;var c=(this.getSelectionBehavior()!==S.RowOnly);var o=0;if(!c){o=1;}if(s===0&&c){e.stopImmediatePropagation(true);a.focusItem(this,f+1,null);}else if(s<this.getFixedColumnCount()-o){e.stopImmediatePropagation(true);a.focusItem(this,f-s+this.getFixedColumnCount()-o,null);}};b.prototype.onsaphomemodifiers=function(e){if(e.metaKey||e.ctrlKey){var $=this.$();var t=$.find(".sapUiTableColHdrCnt")[0];var i=q.contains(t,e.target);if(i){e.stopImmediatePropagation(true);return;}var I=a.getFocusedItemInfo(this);var f=I.cell;var s=I.cellInRow;var c=I.columnCount;var d=Math.ceil(f/c)-1;if(this.getColumnHeaderVisible()){if(d==1){e.stopImmediatePropagation(true);a.focusItem(this,s,e);}else if(d>1){e.stopImmediatePropagation(true);this.setFirstVisibleRow(0);var g=s+c;a.focusItem(this,g,e);}}else{e.stopImmediatePropagation(true);this.setFirstVisibleRow(0);var g=f-d*c;a.focusItem(this,g,e);}}};b.prototype.onsapendmodifiers=function(e){if(e.metaKey||e.ctrlKey){var $=this.$();var t=$.find(".sapUiTableColHdrCnt")[0];var i=q.contains(t,e.target);var I=a.getFocusedItemInfo(this);var f=I.cell;var c=I.columnCount;var s=I.cellInRow;e.stopImmediatePropagation(true);if(i){a.focusItem(this,f+c,e);}else{this.setFirstVisibleRow(this._getRowCount()-this.getVisibleRowCount());var d=I.cellCount-(c-s);a.focusItem(this,d,e);}}};b.prototype.onsapleftmodifiers=function(e){var t=q(e.target);if(t.hasClass('sapUiTableCol')){var c=parseInt(t.attr('data-sap-ui-colindex'),10),C=this.getColumns()[c];if(e.shiftKey){var n=parseInt(C.getWidth(),10)-16;C.setWidth((n>20?n:20)+"px");e.preventDefault();e.stopImmediatePropagation();}else if(e.ctrlKey||e.metaKey){b._moveColumn(C,this._bRtlMode);e.preventDefault();e.stopImmediatePropagation();}}};b.prototype.onsaprightmodifiers=function(e){var t=q(e.target);if(t.hasClass('sapUiTableCol')){var c=parseInt(t.attr('data-sap-ui-colindex'),10),C=this.getColumns()[c];if(e.shiftKey){C.setWidth(parseInt(C.getWidth(),10)+16+"px");e.preventDefault();e.stopImmediatePropagation();}else if(e.ctrlKey||e.metaKey){b._moveColumn(C,!this._bRtlMode);e.preventDefault();e.stopImmediatePropagation();}}};return b;},true);};if(!jQuery.sap.isDeclared('sap.ui.table.TableKeyboardDelegate2')){jQuery.sap.declare('sap.ui.table.TableKeyboardDelegate2');jQuery.sap.require('jquery.sap.global');jQuery.sap.require('sap.ui.base.Object');sap.ui.define("sap/ui/table/TableKeyboardDelegate2",['jquery.sap.global','sap/ui/base/Object','./library','./TableExtension','./TableUtils'],function(q,B,l,T,a){"use strict";var C=a.CELLTYPES;var H=5;var b=B.extend("sap.ui.table.TableKeyboardDelegate2",{constructor:function(t){B.call(this);},destroy:function(){B.prototype.destroy.apply(this,arguments);},getInterface:function(){return this;}});b._restoreFocusOnLastFocusedDataCell=function(t,e){var i=a.getFocusedItemInfo(t);var L=t._getKeyboardExtension()._getLastFocusedCellInfo();a.focusItem(t,i.cellInRow+(i.columnCount*L.row),e);};b._setFocusOnColumnHeaderOfLastFocusedDataCell=function(t,e){var i=a.getFocusedItemInfo(t);a.focusItem(t,i.cellInRow,e);};b._forwardFocusToTabDummy=function(t,s){t._getKeyboardExtension()._setSilentFocus(t.$().find("."+s));};b.prototype.onfocusin=function(e){if(e.isMarked("sapUiTableIgnoreFocusIn")){return;}var t=q(e.target);if(t.hasClass("sapUiTableOuterBefore")||t.hasClass("sapUiTableOuterAfter")||(e.target!=this.getDomRef("overlay")&&this.getShowOverlay())){this.$("overlay").focus();}else if(t.hasClass("sapUiTableCtrlBefore")){var n=a.isNoDataVisible(this);if(!n||n&&this.getColumnHeaderVisible()){b._setFocusOnColumnHeaderOfLastFocusedDataCell(this,e);}else{this._getKeyboardExtension()._setSilentFocus(this.$("noDataCnt"));}}else if(t.hasClass("sapUiTableCtrlAfter")){if(!a.isNoDataVisible(this)){b._restoreFocusOnLastFocusedDataCell(this,e);}}};b.prototype.onsaptabnext=function(e){var i=a.getCellInfo(e.target)||{};if(i.type===C.COLUMNHEADER||i.type===C.COLUMNROWHEADER){if(a.isNoDataVisible(this)){this.$("noDataCnt").focus();}else{b._restoreFocusOnLastFocusedDataCell(this,e);}e.preventDefault();}else if(i.type===C.DATACELL||i.type===C.ROWHEADER){b._forwardFocusToTabDummy(this,"sapUiTableCtrlAfter");}else if(e.target===this.getDomRef("overlay")){this._getKeyboardExtension()._setSilentFocus(this.$().find(".sapUiTableOuterAfter"));}};b.prototype.onsaptabprevious=function(e){var i=a.getCellInfo(e.target)||{};if(i.type===C.DATACELL||i.type===C.ROWHEADER||e.target===this.getDomRef("noDataCnt")){if(this.getColumnHeaderVisible()){b._setFocusOnColumnHeaderOfLastFocusedDataCell(this,e);e.preventDefault();}else{b._forwardFocusToTabDummy(this,"sapUiTableCtrlBefore");}}else if(e.target===this.getDomRef("overlay")){this._getKeyboardExtension()._setSilentFocus(this.$().find(".sapUiTableOuterBefore"));}};b.prototype.onsapdown=function(e){var i=a.getCellInfo(e.target)||{};if(i.type===C.DATACELL||i.type===C.ROWHEADER){if(a.isLastScrollableRow(this,e.target)){var s=a.scroll(this,true,false);if(s){e.setMarked("sapUiTableSkipItemNavigation");}}}else if(i.type===C.COLUMNHEADER||i.type===C.COLUMNROWHEADER){var h=a.getHeaderRowCount(this);if(a.isNoDataVisible(this)){var f=a.getFocusedItemInfo(this);if(f.row-h<=1){e.setMarked("sapUiTableSkipItemNavigation");}}else if(i.type===C.COLUMNROWHEADER&&h>1){e.setMarked("sapUiTableSkipItemNavigation");a.focusItem(this,h*(a.getVisibleColumnCount(this)+1),e);}}};b.prototype.onsapup=function(e){var i=a.getCellInfo(e.target)||{};if(i.type===C.DATACELL||i.type===C.ROWHEADER){if(a.isFirstScrollableRow(this,e.target)){var s=a.scroll(this,false,false);if(s){e.setMarked("sapUiTableSkipItemNavigation");}}}};b.prototype.onsaphome=function(e){if(a.isInGroupingRow(e.target)){e.setMarked("sapUiTableSkipItemNavigation");return;}var c=a.getCellInfo(e.target)||{};if(c.type===C.DATACELL||c.type===C.COLUMNHEADER){var f=a.getFocusedItemInfo(this);var F=f.cell;var i=f.cellInRow;var h=a.hasRowHeader(this);var r=h?1:0;if(a.hasFixedColumns(this)&&i>this.getFixedColumnCount()+r){e.setMarked("sapUiTableSkipItemNavigation");a.focusItem(this,F-i+this.getFixedColumnCount()+r,null);}else if(h&&i>1){e.setMarked("sapUiTableSkipItemNavigation");a.focusItem(this,F-i+r,null);}}};b.prototype.onsapend=function(e){if(a.isInGroupingRow(e.target)){e.setMarked("sapUiTableSkipItemNavigation");return;}var c=a.getCellInfo(e.target)||{};if(c.type===C.DATACELL||c.type===C.ROWHEADER||c.type===C.COLUMNHEADER||c.type===C.COLUMNROWHEADER){var f=a.getFocusedItemInfo(this);var F=f.cell;var i=f.cellInRow;var h=a.hasRowHeader(this);var r=h?1:0;var I=false;if(c.type===C.COLUMNHEADER&&a.hasFixedColumns(this)){var d=c.cell.data('sap-ui-colspan');if(d>1&&i+d-r===this.getFixedColumnCount()){I=true;}}if(h&&i===0){e.setMarked("sapUiTableSkipItemNavigation");a.focusItem(this,F+1,null);}else if(a.hasFixedColumns(this)&&i<this.getFixedColumnCount()-1+r&&!I){e.setMarked("sapUiTableSkipItemNavigation");a.focusItem(this,F+this.getFixedColumnCount()-i,null);}}};b.prototype.onsaphomemodifiers=function(e){if(e.metaKey||e.ctrlKey){var c=a.getCellInfo(e.target)||{};if(c.type===C.DATACELL||c.type===C.ROWHEADER||c.type===C.COLUMNHEADER){e.setMarked("sapUiTableSkipItemNavigation");var f=a.getFocusedItemInfo(this);var F=f.row;if(F>0){var i=f.cell;var d=f.columnCount;var h=a.getHeaderRowCount(this);if(F<h+this.getFixedRowCount()){a.focusItem(this,i-d*F,e);}else if(F>=h+this.getFixedRowCount()&&F<h+a.getNonEmptyVisibleRowCount(this)-this.getFixedBottomRowCount()){a.scrollMax(this,false);if(this.getFixedRowCount()>0){a.focusItem(this,i-d*(F-h),e);}else{a.focusItem(this,i-d*F,e);}}else{a.scrollMax(this,false);a.focusItem(this,i-d*(F-h-this.getFixedRowCount()),e);}}}}};b.prototype.onsapendmodifiers=function(e){if(e.metaKey||e.ctrlKey){var c=a.getCellInfo(e.target)||{};if(c.type===C.DATACELL||c.type===C.ROWHEADER||c.type===C.COLUMNHEADER||c.type===C.COLUMNROWHEADER){e.setMarked("sapUiTableSkipItemNavigation");var f=a.getFocusedItemInfo(this);var F=f.row;var h=a.getHeaderRowCount(this);var n=a.getNonEmptyVisibleRowCount(this);if(this.getFixedBottomRowCount()===0||F<h+n-1||(a.isNoDataVisible(this)&&F<h-1)){var i=f.cell;var d=f.columnCount;if(a.isNoDataVisible(this)){a.focusItem(this,i+d*(h-F-1),e);}else if(F<h){if(this.getFixedRowCount()>0){a.focusItem(this,i+d*(h+this.getFixedRowCount()-F-1),e);}else{a.scrollMax(this,true);a.focusItem(this,i+d*(h+n-this.getFixedBottomRowCount()-F-1),e);}}else if(F>=h&&F<h+this.getFixedRowCount()){a.scrollMax(this,true);a.focusItem(this,i+d*(h+n-this.getFixedBottomRowCount()-F-1),e);}else if(F>=h+this.getFixedRowCount()&&F<h+n-this.getFixedBottomRowCount()){a.scrollMax(this,true);a.focusItem(this,i+d*(h+n-F-1),e);}else{a.focusItem(this,i+d*(h+n-F-1),e);}}}}};b.prototype.onsappageup=function(e){var c=a.getCellInfo(e.target)||{};if(c.type===C.DATACELL||c.type===C.ROWHEADER||c.type===C.COLUMNHEADER){var f=a.getFocusedItemInfo(this);var F=f.row;var h=a.getHeaderRowCount(this);if(this.getFixedRowCount()===0&&F>=h||this.getFixedRowCount()>0&&F>h){e.setMarked("sapUiTableSkipItemNavigation");var i=f.cell;var d=f.columnCount;if(F<h+this.getFixedRowCount()){a.focusItem(this,i-d*(F-h),e);}else if(F===h+this.getFixedRowCount()){var p=a.getNonEmptyVisibleRowCount(this)-this.getFixedRowCount()-this.getFixedBottomRowCount();var r=this._getSanitizedFirstVisibleRow();a.scroll(this,false,true);if(r<p){if(this.getFixedRowCount()>0){a.focusItem(this,i-d*(F-h),e);}else{a.focusItem(this,i-d*h,e);}}}else if(F>h+this.getFixedRowCount()&&F<h+a.getNonEmptyVisibleRowCount(this)){a.focusItem(this,i-d*(F-h-this.getFixedRowCount()),e);}else{a.focusItem(this,i-d*(F-h-a.getNonEmptyVisibleRowCount(this)+1),e);}}}};b.prototype.onsappagedown=function(e){var c=a.getCellInfo(e.target)||{};if(c.type===C.DATACELL||c.type===C.ROWHEADER||c.type===C.COLUMNHEADER||c.type===C.COLUMNROWHEADER){e.setMarked("sapUiTableSkipItemNavigation");var f=a.getFocusedItemInfo(this);var F=f.row;var h=a.getHeaderRowCount(this);var n=a.getNonEmptyVisibleRowCount(this);if((a.isNoDataVisible(this)&&F<h-1)||this.getFixedBottomRowCount()===0||F<h+n-1){var i=f.cell;var d=f.columnCount;if(F<h-1&&c.type!==C.COLUMNROWHEADER){a.focusItem(this,i+d*(h-F-1),e);}else if(F<h){if(!a.isNoDataVisible(this)){a.focusItem(this,i+d*(h-F),e);}}else if(F>=h&&F<h+n-this.getFixedBottomRowCount()-1){a.focusItem(this,i+d*(h+n-this.getFixedBottomRowCount()-F-1),e);}else if(F===h+n-this.getFixedBottomRowCount()-1){var p=a.getNonEmptyVisibleRowCount(this)-this.getFixedRowCount()-this.getFixedBottomRowCount();var r=this._getRowCount()-this.getFixedBottomRowCount()-this._getSanitizedFirstVisibleRow()-p*2;a.scroll(this,true,true);if(r<p&&this.getFixedBottomRowCount()>0){a.focusItem(this,i+d*(h+n-F-1),e);}}else{a.focusItem(this,i+d*(h+n-F-1),e);}}}};b.prototype.onsappageupmodifiers=function(e){if(e.altKey){var c=a.getCellInfo(e.target)||{};if(c.type===C.DATACELL||c.type===C.COLUMNHEADER){var f=a.getFocusedItemInfo(this);var F=f.cell;var i=f.cellInRow;var h=a.hasRowHeader(this);var r=h?1:0;var p=H;e.setMarked("sapUiTableSkipItemNavigation");if(h&&(a.isInGroupingRow(e.target)||i===1)){a.focusItem(this,F-i,null);}else if(i-r<p){a.focusItem(this,F-i+r,null);}else{a.focusItem(this,F-p,null);}}}};b.prototype.onsappagedownmodifiers=function(e){if(e.altKey){var c=a.getCellInfo(e.target)||{};if(c.type===C.DATACELL||c.type===C.ROWHEADER||c.type===C.COLUMNHEADER||c.type===C.COLUMNROWHEADER){var f=a.getFocusedItemInfo(this);var F=f.cellInRow;var h=a.hasRowHeader(this);var r=h?1:0;var v=a.getVisibleColumnCount(this);var i=c.cell.data('sap-ui-colspan')||1;e.setMarked("sapUiTableSkipItemNavigation");if(F+i-r<v){var d=f.cell;var p=H;if(h&&F===0){a.focusItem(this,d+1,null);}else if(a.isInGroupingRow(e.target)){}else if(i>p){a.focusItem(this,d+i,null);}else if(F+i-r+p>v){a.focusItem(this,d+v-F-1+r,null);}else{a.focusItem(this,d+p,null);}}}}};return b;});};if(!jQuery.sap.isDeclared('sap.ui.table.TableKeyboardExtension')){jQuery.sap.declare('sap.ui.table.TableKeyboardExtension');jQuery.sap.require('jquery.sap.global');jQuery.sap.require('sap.ui.core.delegate.ItemNavigation');sap.ui.define("sap/ui/table/TableKeyboardExtension",['jquery.sap.global','./TableExtension','sap/ui/core/delegate/ItemNavigation','./TableUtils','./TableKeyboardDelegate'],function(q,T,I,a,b){"use strict";var c={_forward:function(t,o){var i=t._getItemNavigation();if(i&&!t._getKeyboardExtension()._itemNavigationSuspended&&!o.isMarked("sapUiTableSkipItemNavigation")){i["on"+o.type](o);}},onfocusin:function(o){c._forward(this,o);},onsapfocusleave:function(o){c._forward(this,o);},onmousedown:function(o){c._forward(this,o);},onsapnext:function(o){c._forward(this,o);},onsapnextmodifiers:function(o){c._forward(this,o);},onsapprevious:function(o){c._forward(this,o);},onsappreviousmodifiers:function(o){c._forward(this,o);},onsappageup:function(o){c._forward(this,o);},onsappagedown:function(o){c._forward(this,o);},onsaphome:function(o){c._forward(this,o);},onsaphomemodifiers:function(o){c._forward(this,o);},onsapend:function(o){c._forward(this,o);},onsapendmodifiers:function(o){c._forward(this,o);},onsapkeyup:function(o){c._forward(this,o);}};var E={onfocusin:function(o){var f=this._getKeyboardExtension();if(!f._bIgnoreFocusIn){f.initItemNavigation();if(d.isItemNavigationInvalid(this)){o.setMarked("sapUiTableInitItemNavigation");}}else{o.setMarked("sapUiTableIgnoreFocusIn");}if(o.target&&o.target.id===this.getId()+"-rsz"){o.preventDefault();o.setMarked("sapUiTableSkipItemNavigation");}}};var d={_initItemNavigation:function(o){var t=o.getTable();var $=t.$();var C=a.getVisibleColumnCount(t);var f=C;var h=a.hasRowHeader(t);var g=[];if(t.getFixedColumnCount()==0){g=$.find(".sapUiTableCtrl td[tabindex]").get();}else{var j=$.find('.sapUiTableCtrlFixed.sapUiTableCtrlRowFixed');var k=$.find('.sapUiTableCtrlScroll.sapUiTableCtrlRowFixed');var l=$.find('.sapUiTableCtrlFixed.sapUiTableCtrlRowScroll');var m=$.find('.sapUiTableCtrlScroll.sapUiTableCtrlRowScroll');var n=$.find('.sapUiTableCtrlFixed.sapUiTableCtrlRowFixedBottom');var p=$.find('.sapUiTableCtrlScroll.sapUiTableCtrlRowFixedBottom');for(var i=0;i<t.getVisibleRowCount();i++){g=g.concat(j.find('tr[data-sap-ui-rowindex="'+i+'"]').find('td[tabindex]').get());g=g.concat(k.find('tr[data-sap-ui-rowindex="'+i+'"]').find('td[tabindex]').get());g=g.concat(l.find('tr[data-sap-ui-rowindex="'+i+'"]').find('td[tabindex]').get());g=g.concat(m.find('tr[data-sap-ui-rowindex="'+i+'"]').find('td[tabindex]').get());g=g.concat(n.find('tr[data-sap-ui-rowindex="'+i+'"]').find('td[tabindex]').get());g=g.concat(p.find('tr[data-sap-ui-rowindex="'+i+'"]').find('td[tabindex]').get());}}var r=g.length;if(h){var R=$.find(".sapUiTableRowHdr").get();for(var i=R.length-1;i>=0;i--){g.splice(i*C,0,R[i]);r++;}r--;f++;}if(t.getColumnHeaderVisible()){var H=[];var F=$.find(".sapUiTableColHdrFixed").children();var s=$.find(".sapUiTableColHdrScr").children();for(var i=0;i<a.getHeaderRowCount(t);i++){if(h){H.push(t.getDomRef("selall"));}if(F.length){H=H.concat(q(F.get(i)).find(".sapUiTableCol").get());}if(s.length){H=H.concat(q(s.get(i)).find(".sapUiTableCol").get());}}g=H.concat(g);}if(!o._itemNavigation){o._itemNavigation=new I();o._itemNavigation.setTableMode(true);o._itemNavigation.attachEvent(I.Events.AfterFocus,function(u){var v=a.getFocusedItemInfo(t);v.header=a.getHeaderRowCount(t);v.domRef=null;if(v.row>=v.header){o._oLastFocusedCellInfo=v;}},t);}o._itemNavigation.setColumns(f);o._itemNavigation.setRootDomRef($.find(".sapUiTableCnt").get(0));o._itemNavigation.setItemDomRefs(g);o._itemNavigation.setFocusedIndex(d.getInitialItemNavigationIndex(o));o._itemNavigationInvalidated=false;},getInitialItemNavigationIndex:function(o){return a.hasRowHeader(o.getTable())?1:0;},isItemNavigationInvalid:function(o){return!o._itemNavigation||o._itemNavigationInvalidated;}};var e=T.extend("sap.ui.table.TableKeyboardExtension",{_init:function(t,s,S){this._itemNavigation=null;this._itemNavigationInvalidated=false;this._itemNavigationSuspended=false;this._type=s;this._delegate=new b(s);this._actionMode=false;t.addEventDelegate(E,t);t.addEventDelegate(this._delegate,t);t.addEventDelegate(c,t);var f=this;t._getItemNavigation=function(){return f._itemNavigation;};return"KeyboardExtension";},_debug:function(){this._ExtensionHelper=d;this._ItemNavigationDelegate=c;this._ExtensionDelegate=E;},destroy:function(){var t=this.getTable();if(t){t.removeEventDelegate(E);t.removeEventDelegate(this._delegate);t.removeEventDelegate(c);}if(this._itemNavigation){this._itemNavigation.destroy();this._itemNavigation=null;}if(this._delegate){this._delegate.destroy();this._delegate=null;}T.prototype.destroy.apply(this,arguments);}});e.prototype.initItemNavigation=function(){if(d.isItemNavigationInvalid(this)){d._initItemNavigation(this);}};e.prototype.invalidateItemNavigation=function(){this._itemNavigationInvalidated=true;};e.prototype.setActionMode=function(A,o){if(A&&!this._actionMode&&this._delegate.enterActionMode){this._actionMode=!!this._delegate.enterActionMode.apply(this.getTable(),[o||{}]);}else if(!A&&this._actionMode&&this._delegate.leaveActionMode){this._actionMode=false;this._delegate.leaveActionMode.apply(this.getTable(),[o||{}]);}};e.prototype.isInActionMode=function(){return this._actionMode;};e.prototype.updateNoDataAndOverlayFocus=function(p){var t=this.getTable();if(!t||!t.getDomRef()){return;}if(t.getShowOverlay()){if(q.sap.containsOrEquals(t.getDomRef(),p)){t.$("overlay").focus();}}else if(a.isNoDataVisible(t)){if(q.sap.containsOrEquals(t.getDomRef("sapUiTableCnt"),p)){t.$("noDataCnt").focus();}}else if(q.sap.containsOrEquals(t.getDomRef("noDataCnt"),p)||q.sap.containsOrEquals(t.getDomRef("overlay"),p)){a.focusItem(t,d.getInitialItemNavigationIndex(this));}};e.prototype._suspendItemNavigation=function(){this._itemNavigationSuspended=true;};e.prototype._resumeItemNavigation=function(){this._itemNavigationSuspended=false;};e.prototype._getLastFocusedCellInfo=function(){var h=a.getHeaderRowCount(this.getTable());if(!this._oLastFocusedCellInfo||this._oLastFocusedCellInfo.header!=h){var i=a.getFocusedItemInfo(this.getTable());var D=d.getInitialItemNavigationIndex(this);return{cellInRow:D,row:h,header:h,cellCount:i.cellCount,columnCount:i.columnCount,cell:i.columnCount*h+D};}return this._oLastFocusedCellInfo;};e.prototype._setSilentFocus=function(r){this._bIgnoreFocusIn=true;r.focus();this._bIgnoreFocusIn=false;};e.prototype._getTableType=function(){return this._type;};return e;},true);};if(!jQuery.sap.isDeclared('sap.ui.table.TablePointerExtension')){jQuery.sap.declare('sap.ui.table.TablePointerExtension');jQuery.sap.require('jquery.sap.global');jQuery.sap.require('sap.ui.Device');sap.ui.define("sap/ui/table/TablePointerExtension",['jquery.sap.global','./TableExtension','./TableUtils','sap/ui/Device'],function(q,T,a,D){"use strict";var E={_getEventPosition:function(e,t){var p;if(t._isTouchMode(e)){p=e.targetTouches?e.targetTouches[0]:e.originalEvent.targetTouches[0];}else{p=e;}return{x:p.pageX,y:p.pageY};}};var C={initColumnResizing:function(t,e){if(t._bIsColumnResizerMoving){return;}t._bIsColumnResizerMoving=true;t.$().toggleClass("sapUiTableResizing",true);var d=q(document),f=t._isTouchMode(e);t._$colResize=t.$("rsz");t._iColumnResizeStart=E._getEventPosition(e,t).x;d.bind((f?"touchend":"mouseup")+".sapUiTableColumnResize",C.exitColumnResizing.bind(t));d.bind((f?"touchmove":"mousemove")+".sapUiTableColumnResize",C.onMouseMoveWhileColumnResizing.bind(t));t._disableTextSelection();},exitColumnResizing:function(e){C._resizeColumn(this,this._iLastHoveredColumnIndex);},onMouseMoveWhileColumnResizing:function(e){var l=E._getEventPosition(e,this).x;if(this._iColumnResizeStart&&l<this._iColumnResizeStart+3&&l>this._iColumnResizeStart-3){return;}if(this._isTouchMode(e)){e.stopPropagation();e.preventDefault();}this._$colResize.toggleClass("sapUiTableColRszActive",true);var o=this._getVisibleColumns()[this._iLastHoveredColumnIndex];var d=l-this._iColumnResizeStart;var w=Math.max(o.$().width()+d*(this._bRtlMode?-1:1),this._iColMinWidth);var r=this.$().find(".sapUiTableCnt").offset().left;var i=Math.floor((l-r)-(this._$colResize.width()/2));this._$colResize.css("left",i+"px");o._iNewWidth=w;},_cleanupColumResizing:function(t){if(t._$colResize){t._$colResize.toggleClass("sapUiTableColRszActive",false);t._$colResize=null;}t._iColumnResizeStart=null;t._bIsColumnResizerMoving=false;t.$().toggleClass("sapUiTableResizing",false);t._enableTextSelection();var d=q(document);d.unbind("touchmove.sapUiTableColumnResize");d.unbind("touchend.sapUiTableColumnResize");d.unbind("mousemove.sapUiTableColumnResize");d.unbind("mouseup.sapUiTableColumnResize");},_resizeColumn:function(t,i){var v=t._getVisibleColumns(),o,r=false;if(i>=0&&i<v.length){o=v[i];if(o._iNewWidth){var w;var A=t.$().find(".sapUiTableCtrl").width();if(!t._checkPercentageColumnWidth()){w=o._iNewWidth+"px";}else{var d=Math.round(100/A*o._iNewWidth);w=d+"%";}if(t._updateColumnWidth(o,w,true)){t._resizeDependentColumns(o,w);}delete o._iNewWidth;r=true;}}C._cleanupColumResizing(t);o.focus();if(r){t.invalidate();}},doAutoResizeColumn:function(t,i){var v=t._getVisibleColumns(),o;if(i>=0&&i<v.length){o=v[i];if(!o.getAutoResizable()||!o.getResizable()){return;}var n=C._calculateAutomaticColumnWidth.apply(t,[o,i]);if(n){o._iNewWidth=n;C._resizeColumn(t,i);}}},_calculateAutomaticColumnWidth:function(o,d){function e(r){var t=["sap/m/Text","sap/m/Label","sap/m/Link","sap/m/Input","sap/ui/commons/TextView","sap/ui/commons/Label","sap/ui/commons/Link","sap/ui/commons/TextField"];var k=false;for(var i=0;i<t.length;i++){k=k||a.isInstanceOf(r,t[i]);}if(!k&&typeof c._fnCheckTextBasedControl==="function"&&c._fnCheckTextBasedControl(r)){k=true;}return k;}var $=this.$();var h=0;var f=$.find('td[headers=\"'+this.getId()+'_col'+d+'\"]').children("div");var H=o.getHeaderSpan();var g=o.getLabel();var j=o.getTemplate();var k=e(j);var l=document.createElement("div");document.body.appendChild(l);q(l).addClass("sapUiTableHiddenSizeDetector");var m=o.getMultiLabels();if(m.length==0&&!!g){m=[g];}if(m.length>0){q.each(m,function(r,L){var s;if(!!L.getText()){q(l).text(L.getText());h=l.scrollWidth;}else{h=L.$().scrollWidth;}h=h+$.find("#"+o.getId()+"-icons").first().width();$.find(".sapUiTableColIcons#"+o.getId()+"_"+r+"-icons").first().width();if(H instanceof Array&&H[r]>1){s=H[r];}else if(H>1){s=H;}if(!!s){var i=s-1;while(i>d){h=h-(this._getVisibleColumns()[d+i].$().width()||0);i-=1;}}});}var n=Math.max.apply(null,f.map(function(){var _=q(this);return parseInt(_.css('padding-left'),10)+parseInt(_.css('padding-right'),10)+parseInt(_.css('margin-left'),10)+parseInt(_.css('margin-right'),10);}).get());var p=Math.max.apply(null,f.children().map(function(){var w=0,W=0;var _=q(this);var s=_.text()||_.val();if(k){q(l).text(s);W=l.scrollWidth;}else{W=this.scrollWidth;}if(h>W){W=h;}w=W+parseInt(_.css('margin-left'),10)+parseInt(_.css('margin-right'),10)+n+1;return w;}).get());q(l).remove();return Math.max(p,this._iColMinWidth);},initColumnTracking:function(t){t.$().find(".sapUiTableCtrlScr, .sapUiTableCtrlScrFixed, .sapUiTableColHdrScr, .sapUiTableColHdrFixed").mousemove(function(e){var d=this.getDomRef();if(!d||this._bIsColumnResizerMoving){return;}var p=e.clientX,f=d.getBoundingClientRect(),l=0,r=this._bRtlMode?10000:-10000;for(var i=0;i<this._aTableHeaders.length;i++){var o=this._aTableHeaders[i].getBoundingClientRect();if(this._bRtlMode){if(p<o.right-5){l=i;r=o.left-f.left;}}else{if(p>o.left+5){l=i;r=o.right-f.left;}}}var g=this._getVisibleColumns()[l];if(g&&g.getResizable()){this.$("rsz").css("left",r+"px");this._iLastHoveredColumnIndex=l;}}.bind(t));}};var I={initInteractiveResizing:function(t,e){var B=q(document.body),s=t.$("sb"),d=q(document),o=s.offset(),h=s.height(),w=s.width(),f=t._isTouchMode(e);B.bind("selectstart",I.onSelectStartWhileInteractiveResizing);B.append("<div id=\""+t.getId()+"-ghost\" class=\"sapUiTableInteractiveResizerGhost\" style =\" height:"+h+"px; width:"+w+"px; left:"+o.left+"px; top:"+o.top+"px\" ></div>");s.append("<div id=\""+t.getId()+"-rzoverlay\" style =\"left: 0px; right: 0px; bottom: 0px; top: 0px; position:absolute\" ></div>");d.bind((f?"touchend":"mouseup")+".sapUiTableInteractiveResize",I.exitInteractiveResizing.bind(t));d.bind((f?"touchmove":"mousemove")+".sapUiTableInteractiveResize",I.onMouseMoveWhileInteractiveResizing.bind(t));t._disableTextSelection();},exitInteractiveResizing:function(e){var B=q(document.body),d=q(document),t=this.$(),g=this.$("ghost"),l=E._getEventPosition(e,this).y;var n=l-t.find(".sapUiTableCCnt").offset().top-g.height()-t.find(".sapUiTableFtr").height();this._setRowContentHeight(n);this._adjustRows(this._calculateRowsToDisplay(n));g.remove();this.$("rzoverlay").remove();B.unbind("selectstart",I.onSelectStartWhileInteractiveResizing);d.unbind("touchend.sapUiTableInteractiveResize");d.unbind("touchmove.sapUiTableInteractiveResize");d.unbind("mouseup.sapUiTableInteractiveResize");d.unbind("mousemove.sapUiTableInteractiveResize");this._enableTextSelection();},onSelectStartWhileInteractiveResizing:function(e){e.preventDefault();e.stopPropagation();return false;},onMouseMoveWhileInteractiveResizing:function(e){var l=E._getEventPosition(e,this).y;var m=this.$().offset().top;if(l>m){this.$("ghost").css("top",l+"px");}}};var R={initReordering:function(t,i,e){var d=t._isTouchMode(e),o=t.getColumns()[i],$=o.$(),f=t.$();t._disableTextSelection();f.addClass("sapUiTableDragDrop");t._$ColGhost=$.clone().removeAttr("id");$.css({"opacity":".25"});t._$ColGhost.addClass("sapUiTableColGhost").css({"left":-10000,"top":-10000,"position":"absolute","z-index":t.$().zIndex()+10});f.find(".sapUiTableCol").each(function(h,j){var _=q(this),p=this.getBoundingClientRect(),w=_.outerWidth();_.css({position:"relative"});_.data("pos",{left:p.left,center:p.left+w/2,right:p.left+w});});t._$ColGhost.appendTo(document.body);var g=q(document);g.bind((d?"touchend":"mouseup")+".sapUiColumnMove",R.exitReordering.bind(t));g.bind((d?"touchmove":"mousemove")+".sapUiColumnMove",R.onMouseMoveWhileReordering.bind(t));},onMouseMoveWhileReordering:function(e){var t=this.$();var l=E._getEventPosition(e,this);var L=l.x;var i=l.y;var r=this._bRtlMode;var d=parseInt(this._$ColGhost.attr("data-sap-ui-colindex"),10);var $=this.getColumns()[d].$();var o=this._iNewColPos;this._iNewColPos=d;var f=this;t.find(".sapUiTableCol").each(function(g,h){var j=q(h);var k=parseInt(j.attr("data-sap-ui-colindex"),10);var s=R.getHeaderSpan(sap.ui.getCore().byId(j.attr("data-sap-ui-colid")));if(j.get(0)!==$.get(0)){var p=j.data("pos");var B=L>=p.left&&L<=p.center;var A=L>=p.center&&L<=p.right;if(!r&&B||r&&A){f._iNewColPos=k;}else if(!r&&A||r&&B){f._iNewColPos=k+s;}else{f._iNewColPos=f._iNewColPos;}if((B||A)&&k>d){f._iNewColPos--;}}});if(!R.isColumnReorderable(this,this._iNewColPos)){this._iNewColPos=o;}R.animateColumnMove(this,d,o,this._iNewColPos);this._$ColGhost.css({"left":L+5,"top":i+5});},exitReordering:function(e){var t=this;this.$().removeClass("sapUiTableDragDrop");var d=parseInt(this._$ColGhost.attr("data-sap-ui-colindex"),10);var o=this.getColumns()[d];var $=q(document);$.unbind("touchmove.sapUiColumnMove");$.unbind("touchend.sapUiColumnMove");$.unbind("mousemove.sapUiColumnMove");$.unbind("mouseup.sapUiColumnMove");this._$ColGhost.remove();this._$ColGhost=undefined;this._enableTextSelection();var f=this.fireColumnMove({column:o,newPos:this._iNewColPos});var m=d<this._iNewColPos;if(f&&this._iNewColPos!==undefined&&this._iNewColPos!==d){this.removeColumn(o);this.insertColumn(o,this._iNewColPos);var s=R.getHeaderSpan(o);if(s>1){if(!m){this._iNewColPos++;}for(var i=1;i<s;i++){var g=this.getColumns()[m?d:d+i];this.removeColumn(g);this.insertColumn(g,this._iNewColPos);this.fireColumnMove({column:g,newPos:this._iNewColPos});if(!m){this._iNewColPos++;}}}}else{R.animateColumnMove(this,d,this._iNewColPos,d);o.$().css({"backgroundColor":"","backgroundImage":"","opacity":""});}if(this._mTimeouts.reApplyFocusTimer){window.clearTimeout(this._mTimeouts.reApplyFocusTimer);}this._mTimeouts.reApplyFocusTimer=window.setTimeout(function(){var O=a.getFocusedItemInfo(t).cell;a.focusItem(t,0,e);a.focusItem(t,O,e);},0);delete this._iNewColPos;if(this.updateAnalyticalInfo){this.updateAnalyticalInfo(true,true);}},animateColumnMove:function(t,d,o,n){var r=t._bRtlMode;var $=t.getColumns()[d].$();if(o!==n){for(var i=Math.min(o,n),l=Math.max(o,n);i<=l;i++){var e=t.getColumns()[i];if(i!==d&&e.getVisible()){e.$().stop(true,true).animate({left:"0px"});}}var O=0;if(n<d){for(var i=n;i<d;i++){var e=t.getColumns()[i];if(e.getVisible()){var f=e.$();O-=f.outerWidth();f.stop(true,true).animate({left:$.outerWidth()*(r?-1:1)+"px"});}}}else{for(var i=d+1,l=n+1;i<l;i++){var e=t.getColumns()[i];if(e.getVisible()){var f=e.$();O+=f.outerWidth();f.stop(true,true).animate({left:$.outerWidth()*(r?1:-1)+"px"});}}}$.stop(true,true).animate({left:O*(r?-1:1)+"px"});}},getHeaderSpan:function(o){var h=o.getHeaderSpan(),s=1;if(h){s=q.isArray(h)?h[0]:h;}return s;},isColumnReorderable:function(t,i){if(i<t.getFixedColumnCount()||i<t._iFirstReorderableIndex){return false;}return true;}};var b={onmousedown:function(e){this._getKeyboardExtension().initItemNavigation();if(e.button===0){var t=q(e.target);if(e.target===this.getDomRef("sb")){I.initInteractiveResizing(this,e);}else if(e.target===this.getDomRef("rsz")){C.initColumnResizing(this,e);}else if(t.hasClass("sapUiTableColResizer")){var i=t.closest(".sapUiTableCol").attr("data-sap-ui-colindex");this._iLastHoveredColumnIndex=parseInt(i,10);C.initColumnResizing(this,e);}else{var $=t.closest(".sapUiTableCol",this.getDomRef());if($.length===1){var d=parseInt($.attr("data-sap-ui-colindex"),10),o=this.getColumns()[d];var m=o.getAggregation("menu");o._bSkipOpen=m&&m.bOpen;this._bShowMenu=true;this._mTimeouts.delayedMenuTimer=q.sap.delayedCall(200,this,function(){this._bShowMenu=false;});if(this.getEnableColumnReordering()&&!(this._isTouchMode(e)&&t.hasClass("sapUiTableColDropDown"))){this._getPointerExtension().doReorderColumn(d,e);}}}if((D.browser.firefox&&!!(e.metaKey||e.ctrlKey))||t.closest(".sapUiTableHSb",this.getDomRef()).length===1||t.closest(".sapUiTableVSb",this.getDomRef()).length===1){e.preventDefault();}}},onmouseup:function(e){q.sap.clearDelayedCall(this._mTimeouts.delayedColumnReorderTimer);},ondblclick:function(e){if(D.system.desktop&&e.target===this.getDomRef("rsz")){e.preventDefault();C.doAutoResizeColumn(this,this._iLastHoveredColumnIndex);}},onclick:function(e){q.sap.clearDelayedCall(this._mTimeouts.delayedColumnReorderTimer);if(e.isMarked()){return;}var t=q(e.target);if(t.hasClass("sapUiAnalyticalTableSum")){e.preventDefault();return;}else if(t.hasClass("sapUiTableGroupMenuButton")){this._onContextMenu(e);e.preventDefault();return;}else if(t.hasClass("sapUiTableGroupIcon")||t.hasClass("sapUiTableTreeIcon")){if(a.toggleGroupHeader(this,e.target)){return;}}if(!this._findAndfireCellEvent(this.fireCellClick,e)){this._onSelect(e);}else{e.preventDefault();}}};var c=T.extend("sap.ui.table.TablePointerExtension",{_init:function(t,s,S){this._type=s;this._delegate=b;t.addEventDelegate(this._delegate,t);t._iLastHoveredColumnIndex=0;t._bIsColumnResizerMoving=false;t._iFirstReorderableIndex=s==T.TABLETYPES.TREE?1:0;return"PointerExtension";},_attachEvents:function(){var t=this.getTable();if(t){C.initColumnTracking(t);}},_detachEvents:function(){var t=this.getTable();if(t){t.$().find(".sapUiTableCtrlScr, .sapUiTableCtrlScrFixed, .sapUiTableColHdrScr, .sapUiTableColHdrFixed").unbind();}},_debug:function(){this._ExtensionHelper=E;this._ColumnResizeHelper=C;this._InteractiveResizeHelper=I;this._ReorderHelper=R;this._ExtensionDelegate=b;},doAutoResizeColumn:function(i){var t=this.getTable();if(t){C.doAutoResizeColumn(t,i);}},doReorderColumn:function(i,e){var t=this.getTable();if(t&&t.getEnableColumnReordering()&&R.isColumnReorderable(t,i)){t._mTimeouts.delayedColumnReorderTimer=q.sap.delayedCall(200,t,function(){R.initReordering(t,i,e);});}},destroy:function(){var t=this.getTable();if(t){t.removeEventDelegate(this._delegate);}this._delegate=null;T.prototype.destroy.apply(this,arguments);}});return c;},true);};if(!jQuery.sap.isDeclared('sap.ui.table.TableRenderer')){jQuery.sap.declare('sap.ui.table.TableRenderer');jQuery.sap.require('jquery.sap.global');jQuery.sap.require('sap.ui.core.Control');jQuery.sap.require('sap.ui.core.library');jQuery.sap.require('sap.ui.core.theming.Parameters');jQuery.sap.require('sap.ui.Device');jQuery.sap.require('sap.ui.core.Renderer');jQuery.sap.require('sap.ui.core.IconPool');sap.ui.define("sap/ui/table/TableRenderer",['jquery.sap.global','sap/ui/core/Control','sap/ui/core/library','sap/ui/core/theming/Parameters','sap/ui/Device','./library','./TableUtils','sap/ui/core/Renderer','sap/ui/core/IconPool'],function(q,C,c,P,D,a,T,R,I){"use strict";var N=a.NavigationMode,S=a.SelectionMode,V=a.VisibleRowCountMode;var b={};b.render=function(r,t){r.write("<div");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"ROOT");r.writeControlData(t);r.addClass("sapUiTable");if('ontouchstart'in document){r.addClass("sapUiTableTouch");}r.addClass("sapUiTableSelMode"+t.getSelectionMode());if(t.getColumnHeaderVisible()){r.addClass("sapUiTableCHdr");}if(T.hasRowHeader(t)){r.addClass("sapUiTableRSel");}var s=a.TableHelper.addTableClass();if(s){r.addClass(s);}if(t._isVSbRequired()){r.addClass("sapUiTableVScr");}if(t.getEditable()){r.addClass("sapUiTableEdt");}if(T.isNoDataVisible(t)){r.addClass("sapUiTableEmpty");}if(t.getShowOverlay()){r.addClass("sapUiTableOverlay");}var m=T.Grouping.getModeCssClass(t);if(m){r.addClass(m);}if(t.getWidth()){r.addStyle("width",t.getWidth());}if(t.getVisibleRowCountMode()==V.Auto){r.addStyle("height","0px");if(t._bFirstRendering){r.addClass("sapUiTableNoOpacity");}}r.writeClasses();r.writeStyles();r.write(">");this.renderTabElement(r,"sapUiTableOuterBefore");if(t.getTitle()){this.renderHeader(r,t,t.getTitle());}if(t.getToolbar()){this.renderToolbar(r,t,t.getToolbar());}if(t.getExtension()&&t.getExtension().length>0){this.renderExtensions(r,t,t.getExtension());}r.write("<div");r.writeAttribute("id",t.getId()+"-sapUiTableCnt");r.addClass("sapUiTableCnt");r.writeClasses();t._getAccRenderExtension().writeAriaAttributesFor(r,t,"CONTENT");r.writeAttribute("data-sap-ui-fastnavgroup","true");r.write(">");this.renderColRsz(r,t);this.renderColHdr(r,t);this.renderTable(r,t);t._getAccRenderExtension().writeHiddenAccTexts(r,t);r.write("<div");r.addClass("sapUiTableOverlayArea");r.writeClasses();r.writeAttribute("tabindex","0");r.writeAttribute("id",t.getId()+"-overlay");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"OVERLAY");r.write("></div>");r.write("</div>");if(t.getNavigationMode()===N.Paginator){r.write("<div");r.addClass("sapUiTablePaginator");r.writeClasses();r.write(">");if(!t._oPaginator){var d=sap.ui.requireSync("sap/ui/commons/Paginator");t._oPaginator=new d(t.getId()+"-paginator");t._oPaginator.attachPage(q.proxy(t.onpscroll,t));}r.renderControl(t._oPaginator);r.write("</div>");}if(t.getFooter()){this.renderFooter(r,t,t.getFooter());}if(t.getVisibleRowCountMode()==V.Interactive){this.renderVariableHeight(r,t);}this.renderTabElement(r,"sapUiTableOuterAfter");r.write("</div>");};b.renderHeader=function(r,t,o){r.write("<div");r.addClass("sapUiTableHdr");r.writeClasses();t._getAccRenderExtension().writeAriaAttributesFor(r,t,"TABLEHEADER");r.write(">");r.renderControl(o);r.write("</div>");};b.renderToolbar=function(r,t,o){r.write("<div");r.addClass("sapUiTableTbr");if(typeof o.getStandalone!=="function"){r.addClass("sapUiTableMTbr");}r.writeClasses();t._getAccRenderExtension().writeAriaAttributesFor(r,t,"TABLESUBHEADER");r.write(">");if(typeof o.getStandalone==="function"&&o.getStandalone()){o.setStandalone(false);}var d=sap.ui.require("sap/m/Toolbar");if(d&&o instanceof d){o.setDesign(P.get("sapUiTableToolbarDesign"),true);}r.renderControl(o);r.write("</div>");};b.renderExtensions=function(r,t,e){for(var i=0,l=e.length;i<l;i++){this.renderExtension(r,t,e[i]);}};b.renderExtension=function(r,t,e){r.write("<div");r.addClass("sapUiTableExt");r.writeClasses();t._getAccRenderExtension().writeAriaAttributesFor(r,t,"TABLESUBHEADER");r.write(">");r.renderControl(e);r.write("</div>");};b.renderTable=function(r,t){r.write("<div");r.writeAttribute("id",t.getId()+"-tableCCnt");r.addClass("sapUiTableCCnt");r.writeClasses();r.write(">");this.renderTableCCnt(r,t);r.write("</div>");this.renderVSb(r,t);this.renderHSb(r,t);};b.renderTableCCnt=function(r,t){this.renderTabElement(r,"sapUiTableCtrlBefore");this.renderTableCtrl(r,t);this.renderRowHdr(r,t);this.renderTabElement(r,"sapUiTableCtrlAfter");r.write("<div");r.addClass("sapUiTableCtrlEmpty");r.writeClasses();r.writeAttribute("tabindex","0");r.writeAttribute("id",t.getId()+"-noDataCnt");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"NODATA");r.write(">");if(t.getNoData()instanceof C){r.renderControl(t.getNoData());}else{r.write("<span");r.writeAttribute("id",t.getId()+"-noDataMsg");r.addClass("sapUiTableCtrlEmptyMsg");r.writeClasses();r.write(">");r.writeEscaped(T.getNoDataText(t));r.write("</span>");}r.write("</div>");};b.renderFooter=function(r,t,f){r.write("<div");r.addClass("sapUiTableFtr");r.writeClasses();t._getAccRenderExtension().writeAriaAttributesFor(r,t,"TABLEFOOTER");r.write(">");r.renderControl(f);r.write("</div>");};b.renderVariableHeight=function(r,t){r.write('<div id="'+t.getId()+'-sb" tabIndex="-1"');r.addClass("sapUiTableHeightResizer");r.addStyle("height","5px");r.writeClasses();r.writeStyles();r.write(">");r.write("</div>");};b.renderColHdr=function(r,t){r.write("<div");r.addClass("sapUiTableColHdrCnt");r.writeClasses();if(t.getColumnHeaderHeight()>0){r.addStyle("height",(t.getColumnHeaderHeight()*T.getHeaderRowCount(t))+"px");}t._getAccRenderExtension().writeAriaAttributesFor(r,t,"COLUMNHEADER_ROW");r.writeStyles();r.write(">");this.renderColRowHdr(r,t);var d=t.getColumns();var f=t.getFixedColumnCount();var F=t._getColumnsWidth(0,f);if(f>0){r.write("<div");r.addClass("sapUiTableColHdrFixed");r.addClass("sapUiTableNoOpacity");r.writeClasses();r.write(">");for(var h=0;h<T.getHeaderRowCount(t);h++){r.write("<div");r.addClass("sapUiTableColHdr");r.addClass("sapUiTableNoOpacity");r.writeClasses();r.addStyle("min-width",F+"px");r.writeStyles();r.write(">");var s=1;for(var i=0,l=t.getFixedColumnCount();i<l;i++){if(d[i]&&d[i].shouldRender()){if(s<=1){this.renderCol(r,t,d[i],i,h);var H=d[i].getHeaderSpan();if(q.isArray(H)){s=d[i].getHeaderSpan()[h]+1;}else{s=parseInt(d[i].getHeaderSpan(),10)+1;}}else{this.renderCol(r,t,d[i],i,h,true);}s--;}}r.write("</div>");}r.write("</div>");}r.write("<div");r.writeAttribute("id",t.getId()+"-sapUiTableColHdrScr");r.addClass("sapUiTableColHdrScr");if(d.length==0){r.addClass("sapUiTableHasNoColumns");}r.writeClasses();if(t.getFixedColumnCount()>0){if(t._bRtlMode){r.addStyle("margin-right","0");}else{r.addStyle("margin-left","0");}r.writeStyles();}r.write(">");for(var h=0;h<T.getHeaderRowCount(t);h++){r.write("<div");r.addClass("sapUiTableColHdr");r.addClass("sapUiTableNoOpacity");r.writeClasses();r.write(">");var s=1;for(var i=f,l=d.length;i<l;i++){if(d[i].shouldRender()){if(s<=1){this.renderCol(r,t,d[i],i,h);var H=d[i].getHeaderSpan();if(q.isArray(H)){s=d[i].getHeaderSpan()[h]+1;}else{s=parseInt(d[i].getHeaderSpan(),10)+1;}}else{this.renderCol(r,t,d[i],i,h,true);}s--;}}r.write("</div>");}r.write("</div>");r.write("</div>");};b.renderColRowHdr=function(r,t){r.write("<div");r.writeAttribute("id",t.getId()+"-selall");var s=t.getSelectionMode();var e=false;if((s=="Multi"||s=="MultiToggle")&&t.getEnableSelectAll()){r.writeAttributeEscaped("title",t._oResBundle.getText("TBL_SELECT_ALL"));if(t._getSelectableRowCount()==0||t._getSelectableRowCount()!==t.getSelectedIndices().length){r.addClass("sapUiTableSelAll");}r.addClass("sapUiTableSelAllEnabled");e=true;}else{r.addClass("sapUiTableSelAllDisabled");}r.addClass("sapUiTableColRowHdr");r.writeClasses();r.writeAttribute("tabindex","-1");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"COLUMNROWHEADER",{enabled:e});r.write(">");if(t.getSelectionMode()!==S.Single){r.write("<div");r.addClass("sapUiTableColRowHdrIco");r.writeClasses();if(t.getColumnHeaderHeight()>0){r.addStyle("height",t.getColumnHeaderHeight()+"px");}r.write(">");r.write("</div>");}r.write("</div>");};b.renderCol=function(r,t,o,i,h,d){var l;if(o.getMultiLabels().length>0){l=o.getMultiLabels()[h];}else if(h==0){l=o.getLabel();}r.write("<div");var H=o.getId();if(h===0){r.writeElementData(o);}else{H=H+"_"+h;r.writeAttribute('id',H);}r.writeAttribute('data-sap-ui-colid',o.getId());r.writeAttribute("data-sap-ui-colindex",i);r.writeAttribute("tabindex","-1");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"COLUMNHEADER",{column:o,headerId:H,index:i});r.addClass("sapUiTableCol");if(t.getFixedColumnCount()===i+1){r.addClass("sapUiTableColLastFixed");}r.writeClasses();if(t.getColumnHeaderHeight()>0){r.addStyle("height",t.getColumnHeaderHeight()+"px");}if(d){r.addStyle("display","none");}r.writeStyles();var s=o.getTooltip_AsString();if(s){r.writeAttributeEscaped("title",s);}r.write("><div");r.addClass("sapUiTableColCell");r.writeClasses();var e=R.getTextAlign(o.getHAlign(),l&&l.getTextDirection&&l.getTextDirection());if(e){r.addStyle("text-align",e);}r.writeStyles();r.write(">");if(l){r.renderControl(l);}r.write("</div></div>");};b.renderColRsz=function(r,t){r.write("<div");r.writeAttribute("id",t.getId()+"-rsz");r.writeAttribute("tabindex","-1");r.addClass("sapUiTableColRsz");r.writeClasses();r.write("></div>");};b.renderRowHdr=function(r,t){r.write("<div");r.writeAttribute("id",t.getId()+"-sapUiTableRowHdrScr");r.addClass("sapUiTableRowHdrScr");r.addClass("sapUiTableNoOpacity");r.writeClasses();t._getAccRenderExtension().writeAriaAttributesFor(r,t,"ROWHEADER_COL");r.write(">");for(var d=0,e=t.getRows().length;d<e;d++){this.renderRowHdrRow(r,t,t.getRows()[d],d);}r.write("</div>");};b._addFixedRowCSSClasses=function(r,t,i){var f=t.getFixedRowCount();var F=t.getFixedBottomRowCount();var v=t.getVisibleRowCount();var d=t.getFirstVisibleRow();if(f>0){if(i<f){r.addClass("sapUiTableFixedTopRow");}if(i==f-1){r.addClass("sapUiTableFixedLastTopRow");}}if(F>0){var e=false;var B=t.getBinding("rows");if(B){if(t._iBindingLength>=v){e=(i==v-F-1);}else{e=(d+i)==(t._iBindingLength-F-1)&&(t.getFirstVisibleRow()+i)<t._iBindingLength;}}if(e){r.addClass("sapUiTableFixedPreBottomRow");}}};b.renderRowHdrRow=function(r,t,o,i){r.write("<div");r.writeAttribute("id",t.getId()+"-rowsel"+i);r.writeAttribute("data-sap-ui-rowindex",i);r.addClass("sapUiTableRowHdr");this._addFixedRowCSSClasses(r,t,i);var d=false;if(o._bHidden){r.addClass("sapUiTableRowHidden");}else{if(t.isIndexSelected(t._getAbsoluteRowIndex(i))){r.addClass("sapUiTableRowSel");d=true;}}r.writeClasses();if(t.getRowHeight()>0){r.addStyle("height",t.getRowHeight()+"px");}r.writeAttribute("tabindex","-1");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"ROWHEADER",{rowSelected:d});var e=[];q.each(o.getCells(),function(f,g){e.push(o.getId()+"-col"+f);});r.writeStyles();r.write(">");this.writeRowSelectorContent(r,t,o,i);r.write("</div>");};b.renderTableCtrl=function(r,t){if(t.getFixedColumnCount()>0){r.write("<div");r.writeAttribute("id",t.getId()+"-sapUiTableCtrlScrFixed");r.addClass("sapUiTableCtrlScrFixed");r.writeClasses();r.write(">");this.renderTableControl(r,t,true);r.write("</div>");}r.write("<div");r.writeAttribute("id",t.getId()+"-sapUiTableCtrlScr");r.addClass("sapUiTableCtrlScr");r.writeClasses();if(t.getFixedColumnCount()>0){if(t._bRtlMode){r.addStyle("margin-right","0");}else{r.addStyle("margin-left","0");}r.writeStyles();}r.write(">");r.write("<div");r.writeAttribute("id",t.getId()+"-tableCtrlCnt");r.addClass("sapUiTableCtrlCnt");r.writeClasses();var v=t.getVisibleRowCountMode();if(t._iTableRowContentHeight&&(v==V.Fixed||v==V.Interactive)){var s="height";if(t.getVisibleRowCountMode()==V.Fixed){s="min-height";}r.addStyle(s,t._iTableRowContentHeight+"px");r.writeStyles();}r.write(">");this.renderTableControl(r,t,false);r.write("</div></div>");};b.renderTableControl=function(r,t,f){var s,e;if(f){s=0;e=t.getFixedColumnCount();}else{s=t.getFixedColumnCount();e=t.getColumns().length;}var F=t.getFixedRowCount();var i=t.getFixedBottomRowCount();var d=t.getRows();if(F>0){this.renderTableControlCnt(r,t,f,s,e,true,false,0,F);}this.renderTableControlCnt(r,t,f,s,e,false,false,F,d.length-i);if(i>0&&d.length>0){this.renderTableControlCnt(r,t,f,s,e,false,true,d.length-i,d.length);}};b.renderTableControlCnt=function(r,t,f,s,e,F,d,i,E){r.write("<table");var g=t.getId()+"-table";if(f){g+="-fixed";r.addClass("sapUiTableCtrlFixed");}else{r.addClass("sapUiTableCtrlScroll");}if(F){g+="-fixrow";r.addClass("sapUiTableCtrlRowFixed");}else if(d){g+="-fixrow-bottom";r.addClass("sapUiTableCtrlRowFixedBottom");}else{r.addClass("sapUiTableCtrlRowScroll");}r.writeAttribute("id",g);t._getAccRenderExtension().writeAriaAttributesFor(r,t,"TABLE");r.addClass("sapUiTableCtrl");r.writeClasses();r.addStyle("min-width",t._getColumnsWidth(s,e)+"px");if(f&&(!!D.browser.firefox||!!D.browser.chrome||!!D.browser.safari)){r.addStyle("width",t._getColumnsWidth(s,e)+"px");}r.writeStyles();r.write(">");r.write("<thead>");r.write("<tr");r.addClass("sapUiTableCtrlCol");if(i==0){r.addClass("sapUiTableCtrlFirstCol");}r.writeClasses();r.write(">");var h=t.getColumns();if(T.hasRowHeader(t)){r.write("<th");r.addStyle("width","0px");r.writeStyles();if(i==0){t._getAccRenderExtension().writeAriaAttributesFor(r,t,"TH");r.writeAttribute("id",t.getId()+"-colsel");r.addClass("sapUiTableColSel");r.writeClasses();}r.write("></th>");}else{if(h.length===0){r.write("<th></th>");}}for(var j=s,k=e;j<k;j++){var o=h[j];if(o&&o.shouldRender()){r.write("<th");r.addStyle("width",o.getWidth());r.writeStyles();if(i==0){t._getAccRenderExtension().writeAriaAttributesFor(r,t,"TH",{column:o});r.writeAttribute("id",t.getId()+"_col"+j);}r.writeAttribute("data-sap-ui-headcolindex",j);r.writeAttribute("data-sap-ui-colid",o.getId());r.write(">");if(i==0&&T.getHeaderRowCount(t)==0){if(o.getMultiLabels().length>0){r.renderControl(o.getMultiLabels()[0]);}else{r.renderControl(o.getLabel());}}r.write("</th>");}}if(!f&&t._hasOnlyFixColumnWidths()&&h.length>0){r.write("<th></th>");}r.write("</tr>");r.write("</thead>");r.write("<tbody>");var v=t._getVisibleColumns();var H=t._hasOnlyFixColumnWidths();var l=t.getRows();if(l.length==0){l=[t._getDummyRow()];E=1;}var m=t._getAccExtension().getAriaTextsForSelectionMode(true);var n=T.isRowSelectionAllowed(t);for(var p=i,k=E;p<k;p++){this.renderTableRow(r,t,l[p],p,f,s,e,false,v,H,m,n);}r.write("</tbody>");r.write("</table>");};b.addTrClasses=function(r,t,o,i){return;};b.writeRowSelectorContent=function(r,t,o,i){t._getAccRenderExtension().writeAccRowSelectorText(r,t,o,i);if(T.Grouping.isGroupMode(t)){r.write("<div");r.writeAttribute("class","sapUiTableGroupShield");r.write("></div>");r.write("<div");r.writeAttribute("id",o.getId()+"-groupHeader");r.writeAttribute("class","sapUiTableGroupIcon");r.write("></div>");if(T.Grouping.showGroupMenuButton(t)){var d=I.getIconInfo("sap-icon://drop-down-list");r.write("<div class='sapUiTableGroupMenuButton'>");r.writeEscaped(d.content);r.write("</div>");}}};b.renderTableRow=function(r,t,o,i,f,s,e,F,v,h,m,d){r.write("<tr");if(o._bDummyRow){r.addStyle("opacity","0");}r.addClass("sapUiTableTr");if(f){r.writeAttribute("id",o.getId()+"-fixed");}else{r.writeElementData(o);}if(o._bHidden){r.addClass("sapUiTableRowHidden");}else{if(t.isIndexSelected(t._getAbsoluteRowIndex(i))){r.addClass("sapUiTableRowSel");}this.addTrClasses(r,t,o,i);}if(i%2===0){r.addClass("sapUiTableRowEven");}else{r.addClass("sapUiTableRowOdd");}this._addFixedRowCSSClasses(r,t,i);r.writeClasses();r.writeAttribute("data-sap-ui-rowindex",i);var g=t.getRowHeight();if(g>0){r.addStyle("height",g+"px");}r.writeStyles();t._getAccRenderExtension().writeAriaAttributesFor(r,t,"TR",{index:i});r.write(">");var j=o.getCells();if(T.hasRowHeader(t)||j.length===0){r.write("<td");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"ROWHEADER_TD",{rowSelected:!o._bHidden&&t.isIndexSelected(t._getAbsoluteRowIndex(i)),index:i});r.write("></td>");}for(var k=0,l=j.length;k<l;k++){this.renderTableCell(r,t,o,j[k],k,f,s,e,v);}if(!f&&h&&j.length>0){r.write("<td");r.addClass("sapUiTableTDDummy");r.writeClasses();r.write(">");r.write("</td>");}r.write("</tr>");};b.renderTableCell=function(r,t,o,d,i,f,s,e,v){var g=d.data("sap-ui-colindex");var h=t.getColumns()[g];if(h.shouldRender()&&s<=g&&e>g){r.write("<td");var j=o.getId()+"-col"+i;r.writeAttribute("id",j);r.writeAttribute("tabindex","-1");var k=v.length>0&&v[0]===h;t._getAccRenderExtension().writeAriaAttributesFor(r,t,"DATACELL",{index:g,column:h,row:o,fixed:f,firstCol:k});var H=R.getTextAlign(h.getHAlign(),d&&d.getTextDirection&&d.getTextDirection());if(H){r.addStyle("text-align",H);}r.writeStyles();r.addClass("sapUiTableTd");if(k){r.addClass("sapUiTableTdFirst");}if(h.getGrouped()){r.addClass("sapUiTableTdGroup");}var B=t.getBinding("rows");if(B&&h.getLeadingProperty&&B.isMeasure(h.getLeadingProperty())){r.addClass("sapUiTableMeasureCell");}r.writeClasses();r.write("><div");r.addClass("sapUiTableCell");if(k&&T.Grouping.isTreeMode(t)){r.addClass("sapUiTableCellFlex");}r.writeClasses();if(t.getRowHeight()&&t.getVisibleRowCountMode()==V.Auto){r.addStyle("max-height",t.getRowHeight()+"px");}r.writeStyles();r.write(">");this.renderTableCellControl(r,t,d,k);r.write("</div></td>");}};b.renderTableCellControl=function(r,t,o,i){if(T.Grouping.isTreeMode(t)&&i){var d=o.getParent();r.write("<span class='sapUiTableTreeIcon' tabindex='-1' id='"+d.getId()+"-treeicon'");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"TREEICON",{row:d});r.write(">&nbsp;</span>");}r.renderControl(o);};b.renderVSb=function(r,t){r.write("<div");r.addClass("sapUiTableVSb");r.writeClasses();r.writeAttribute("id",t.getId()+"-vsb");r.writeAttribute("tabindex","-1");r.addStyle("max-height",t._getVSbHeight()+"px");if(t.getFixedRowCount()>0){t._iVsbTop=(t.getFixedRowCount()*t._getDefaultRowHeight())-1;r.addStyle("top",t._iVsbTop+'px');}r.writeStyles();r.write(">");r.write("<div");r.writeAttribute("id",t.getId()+"-vsb-content");r.addClass("sapUiTableVSbContent");r.writeClasses();r.addStyle("height",t._getTotalScrollRange()+"px");r.writeStyles();r.write(">");r.write("</div>");r.write("</div>");};b.renderHSb=function(r,t){r.write("<div");r.addClass("sapUiTableHSb");r.writeClasses();r.writeAttribute("id",t.getId()+"-hsb");r.writeAttribute("tabindex","-1");r.write(">");r.write("<div");r.writeAttribute("id",t.getId()+"-hsb-content");r.addClass("sapUiTableHSbContent");r.writeClasses();r.write(">");r.write("</div>");r.write("</div>");};b.renderTabElement=function(r,s){r.write("<div");if(s){r.addClass(s);r.writeClasses();}r.writeAttribute("tabindex","0");r.write("></div>");};return b;},true);};if(!jQuery.sap.isDeclared('sap.ui.table.TableScrollExtension')){jQuery.sap.declare('sap.ui.table.TableScrollExtension');jQuery.sap.require('jquery.sap.global');sap.ui.define("sap/ui/table/TableScrollExtension",['jquery.sap.global','./TableExtension','./TableUtils'],function(q,T,a){"use strict";var E={};var b=T.extend("sap.ui.table.TableScrollExtension",{_init:function(t,s,S){this._type=s;this._delegate=E;t.addEventDelegate(this._delegate,t);return"ScrollExtension";},_attachEvents:function(){},_detachEvents:function(){},_debug:function(){this._ExtensionDelegate=E;},destroy:function(){var t=this.getTable();if(t){t.removeEventDelegate(this._delegate);}this._delegate=null;T.prototype.destroy.apply(this,arguments);}});return b;},true);};if(!jQuery.sap.isDeclared('sap.ui.table.AnalyticalColumnMenu')){jQuery.sap.declare('sap.ui.table.AnalyticalColumnMenu');jQuery.sap.require('jquery.sap.global');sap.ui.define("sap/ui/table/AnalyticalColumnMenu",['jquery.sap.global','./ColumnMenu','./library'],function(q,C,l){"use strict";var G=l.GroupEventType;var A=C.extend("sap.ui.table.AnalyticalColumnMenu",{metadata:{library:"sap.ui.table"}});A.prototype.init=function(){C.prototype.init.apply(this);};A.prototype._addMenuItems=function(){C.prototype._addMenuItems.apply(this);if(this._oColumn){this._addSumMenuItem();}};A.prototype._addGroupMenuItem=function(){var c=this._oColumn,t=this._oTable;if(c.isGroupableByMenu()){this._oGroupIcon=this._createMenuItem("group","TBL_GROUP",c.getGrouped()?"accept":null,q.proxy(function(e){var m=e.getSource(),g=c.getGrouped();c.setGrouped(!g);t.fireGroup({column:c,groupedColumns:t._aGroupedColumns,type:G.group});m.setIcon(!g?"sap-icon://accept":null);t._getRowContexts();},this));this.addItem(this._oGroupIcon);}};A.prototype._addSumMenuItem=function(){var c=this._oColumn,t=this._oTable,b=t.getBinding("rows"),r=b&&b.getAnalyticalQueryResult();if(t&&r&&r.findMeasureByPropertyName(c.getLeadingProperty())){this._oSumItem=this._createMenuItem("total","TBL_TOTAL",c.getSummed()?"accept":null,q.proxy(function(e){var m=e.getSource(),s=c.getSummed();c.setSummed(!s);m.setIcon(!s?"sap-icon://accept":null);t._getRowContexts();},this));this.addItem(this._oSumItem);}};A.prototype.open=function(){C.prototype.open.apply(this,arguments);var c=this._oColumn;this._oSumItem&&this._oSumItem.setIcon(c.getSummed()?"sap-icon://accept":null);this._oGroupIcon&&this._oGroupIcon.setIcon(c.getGrouped()?"sap-icon://accept":null);};return A;});};if(!jQuery.sap.isDeclared('sap.ui.table.TableAccRenderExtension')){jQuery.sap.declare('sap.ui.table.TableAccRenderExtension');jQuery.sap.require('jquery.sap.global');sap.ui.define("sap/ui/table/TableAccRenderExtension",['jquery.sap.global','./TableExtension'],function(q,T){"use strict";var _=function(r,p,i,t,c){c=c||[];c.push("sapUiInvisibleText");r.write("<span");r.writeAttribute("id",p+"-"+i);r.writeAttribute("class",c.join(" "));r.writeAttribute("aria-hidden","true");r.write(">");if(t){r.writeEscaped(t);}r.write("</span>");};var A=T.extend("sap.ui.table.TableAccRenderExtension",{_init:function(t,s,S){return"AccRenderExtension";},writeHiddenAccTexts:function(r,t){if(!t._getAccExtension().getAccMode()){return;}var b=t._oResBundle,s=t.getId();r.write("<div class='sapUiTableHiddenTexts' style='display:none;' aria-hidden='true'>");var d=t.getTitle()&&t.getTitle().getText&&t.getTitle().getText()!=""?t.getTitle().getText():"";_(r,s,"ariadesc",d);_(r,s,"ariacount");_(r,s,"toggleedit",b.getText("TBL_TOGGLE_EDIT_KEY"));_(r,s,"ariaselectall",b.getText("TBL_SELECT_ALL_KEY"));_(r,s,"ariarowheaderlabel",b.getText("TBL_ROW_HEADER_LABEL"));_(r,s,"ariarowgrouplabel",b.getText("TBL_ROW_GROUP_LABEL"));_(r,s,"ariagrandtotallabel",b.getText("TBL_GRAND_TOTAL_ROW"));_(r,s,"ariagrouptotallabel",b.getText("TBL_GROUP_TOTAL_ROW"));_(r,s,"ariacolrowheaderlabel",b.getText("TBL_ROW_COL_HEADER_LABEL"));_(r,s,"rownumberofrows");_(r,s,"colnumberofcols");_(r,s,"cellacc");_(r,s,"ariarowselected",b.getText("TBL_ROW_DESC_SELECTED"));_(r,s,"ariacolmenu",b.getText("TBL_COL_DESC_MENU"));_(r,s,"ariacolfiltered",b.getText("TBL_COL_DESC_FILTERED"));_(r,s,"ariacolsortedasc",b.getText("TBL_COL_DESC_SORTED_ASC"));_(r,s,"ariacolsorteddes",b.getText("TBL_COL_DESC_SORTED_DES"));_(r,s,"ariainvalid",b.getText("TBL_TABLE_INVALID"));if(t.getFixedColumnCount()>0){_(r,s,"ariafixedcolumn",b.getText("TBL_FIXED_COLUMN"));}r.write("</div>");},writeAriaAttributesFor:function(r,t,s,p){var e=t._getAccExtension();if(!e.getAccMode()){return;}var a=e._getAriaAttributesFor(s,p);var v,k;for(k in a){v=a[k];if(q.isArray(v)){v=v.join(" ");}if(v){r.writeAttributeEscaped(k,v);}}},writeAccRowSelectorText:function(r,t,R,i){if(!t._getAccExtension().getAccMode()){return"";}var I=t.isIndexSelected(i);var m=t._getAccExtension().getAriaTextsForSelectionMode(true);var s=m.keyboard[I?"rowDeselect":"rowSelect"];_(r,R.getId(),"rowselecttext",s,["sapUiTableAriaRowSel"]);}});return A;});};if(!jQuery.sap.isDeclared('sap.ui.table.TableAccExtension')){jQuery.sap.declare('sap.ui.table.TableAccExtension');jQuery.sap.require('jquery.sap.global');jQuery.sap.require('sap.ui.core.Control');sap.ui.define("sap/ui/table/TableAccExtension",['jquery.sap.global','sap/ui/core/Control','./library','./TableExtension','./TableAccRenderExtension','./TableUtils'],function(q,C,l,T,a,b){"use strict";var S=l.SelectionMode;var A={getAccInfoOfControl:function(o,B){if(o&&typeof o.getAccessibilityInfo==="function"){if(typeof o.getVisible==="function"&&!o.getVisible()){return A._normalize({});}var s=o.getAccessibilityInfo();if(s){var t={};A._flatten(s,t,B);return t;}}return null;},_normalize:function(i){if(!i){return null;}if(i._normalized){return i;}i.role=i.role||"";i.type=i.type||"";i.description=i.description||"";i.focusable=!!i.focusable;i.enabled=(i.enabled===true||i.enabled===false)?i.enabled:null;i.editable=(i.editable===true||i.editable===false)?i.editable:null;i.children=i.children||[];i._normalized=true;return i;},_flatten:function(s,t,B,L){L=L?L:0;A._normalize(s);if(L==0){A._normalize(t);t._descriptions=[];}t.focusable=t.focusable||s.focusable;t._descriptions.push(A._getFullDescription(s,B));for(var i=0;i<s.children.length;i++){if(s.children[i]){A._flatten(s.children[i],t,B,L+1);}}if(L==0){t.description=t._descriptions.join(" ").trim();t._descriptions=undefined;}},_getFullDescription:function(i,B){var d=i.type+" "+i.description;if(i.enabled!=null&&!i.enabled){d=d+" "+B.getText("TBL_CTRL_STATE_DISABLED");}else if(i.editable!=null&&!i.editable){d=d+" "+B.getText("TBL_CTRL_STATE_READONLY");}return d.trim();}};var E={getInfoOfFocusedCell:function(e){var t=e.getTable();var i=t._getItemNavigation();var o=t.getDomRef();if(!e.getAccMode()||!o||!i){return null;}var d=i.getFocusedDomRef();if(!d||d!==document.activeElement){return null;}return b.getCellInfo(d);},isHiddenCell:function($,o){var g=b.isInGroupingRow($);var s=b.isInSumRow($);var d=!!o&&!!o.hasStyleClass;var i=$.parent().hasClass("sapUiTableRowHidden");var I=$.hasClass("sapUiTableCellHidden");var n=g&&$.hasClass("sapUiTableTdFirst")&&!$.hasClass("sapUiTableMeasureCell");var G=g&&d&&o.hasStyleClass("sapUiAnalyticalTableGroupCellHidden");var e=s&&d&&o.hasStyleClass("sapUiAnalyticalTableSumCellHidden");return i||I||n||G||e;},isTreeColumnCell:function(e,$){return b.Grouping.isTreeMode(e.getTable())&&$.hasClass("sapUiTableTdFirst");},getColumnTooltip:function(o){if(!o){return null;}var t=o.getTooltip_AsString();if(t){return t;}var L=o.getLabel();if(L instanceof C){t=L.getTooltip_AsString();}if(t){return t;}return null;},updateRowColCount:function(e){var t=e.getTable(),i=t._getItemNavigation(),I=false,d=false,f=false;if(i){var g=b.getColumnIndexOfFocusedCell(t)+1;var r=b.getRowIndexOfFocusedCell(t)+t.getFirstVisibleRow()+1;var h=b.getVisibleColumnCount(t);var R=b.isNoDataVisible(t)?0:b.getTotalRowCount(t,true);I=e._iLastRowNumber!=r||(e._iLastRowNumber==r&&e._iLastColumnNumber==g);d=e._iLastColumnNumber!=g;f=!e._iLastRowNumber&&!e._iLastColumnNumber;t.$("rownumberofrows").text(I?t._oResBundle.getText("TBL_ROW_ROWCOUNT",[r,R]):" ");t.$("colnumberofcols").text(d?t._oResBundle.getText("TBL_COL_COLCOUNT",[g,h]):" ");t.$("ariacount").text(f?t._oResBundle.getText("TBL_DATA_ROWS_COLS",[R,h]):" ");e._iLastRowNumber=r;e._iLastColumnNumber=g;}return{rowChange:I,colChange:d,initial:f};},cleanupCellModifications:function(e){if(e._cleanupInfo){e._cleanupInfo.cell.attr(e._cleanupInfo.attr);e._cleanupInfo=null;}},storeDefaultsBeforeCellModifications:function(e,$,d,D){e._cleanupInfo={cell:$,attr:{"aria-labelledby":d&&d.length?d.join(" "):null,"aria-describedby":D&&D.length?D.join(" "):null}};},performCellModifications:function(e,$,d,D,L,f,t,g){E.storeDefaultsBeforeCellModifications(e,$,d,D);var o=E.updateRowColCount(e);e.getTable().$("cellacc").text(t||" ");if(g){g(L,f,o.rowChange,o.colChange,o.initial);}var s="";if(o.initial){var h=e.getTable();s=h.getAriaLabelledBy().join(" ")+" "+h.getId()+"-ariadesc "+h.getId()+"-ariacount";}if(L&&L.length){s=s+" "+L.join(" ");}$.attr({"aria-labelledby":s?s:null,"aria-describedby":f&&f.length?f.join(" "):null});},modifyAccOfDATACELL:function($,o){var t=this.getTable(),s=t.getId(),i=t._getItemNavigation();if(!i){return;}var r=b.getRowIndexOfFocusedCell(t),d=b.getColumnIndexOfFocusedCell(t),e=b.getRowColCell(t,r,d),I=null,h=E.isHiddenCell($,e.cell),f=E.isTreeColumnCell(this,$),D=E.getAriaAttributesFor(this,c.ELEMENTTYPES.DATACELL,{index:d,column:e.column,fixed:b.isFixedColumn(t,d)})["aria-labelledby"]||[],g=[],L=[s+"-rownumberofrows",s+"-colnumberofcols"];if(b.isInGroupingRow($)){L.push(s+"-ariarowgrouplabel");L.push(s+"-rows-row"+r+"-groupHeader");}if(b.isInSumRow($)){var j=$.parent().data("sap-ui-level");if(j==0){L.push(s+"-ariagrandtotallabel");}else if(j>0){L.push(s+"-ariagrouptotallabel");L.push(s+"-rows-row"+r+"-groupHeader");}}L=L.concat(D);if(!h){I=A.getAccInfoOfControl(e.cell,t._oResBundle);L.push(I?(s+"-cellacc"):e.cell.getId());if(((!I||I.focusable)&&!this._readonly)||(f&&e.row&&e.row._bHasChildren)){g.push(s+"-toggleedit");}}var k=I?I.description:" ";if(f&&!h){var m=E.getAriaAttributesFor(this,c.ELEMENTTYPES.TREEICON,{row:e.row});if(m&&m["aria-label"]){k=m["aria-label"]+" "+k;}}E.performCellModifications(this,$,D,null,L,g,k,function(L,g,R,n,p){if(!h&&b.isRowSelectionAllowed(t)&&R){g.push(e.row.getId()+"-rowselecttext");}});},modifyAccOfROWHEADER:function($,o){var t=this.getTable(),s=t.getId(),g=b.isInGroupingRow($),d=b.isInSumRow($),r=t.getRows()[$.attr("data-sap-ui-rowindex")],D=E.getAriaAttributesFor(this,c.ELEMENTTYPES.ROWHEADER)["aria-labelledby"]||[],L=D.concat([s+"-rownumberofrows"]);if(!d&&!g){if($.attr("aria-selected")=="true"){L.push(s+"-ariarowselected");}if(!$.hasClass("sapUiTableRowHidden")){L.push(r.getId()+"-rowselecttext");}}if(g){L.push(s+"-ariarowgrouplabel");}if(d){var i=$.data("sap-ui-level");if(i==0){L.push(s+"-ariagrandtotallabel");}else if(i>0){L.push(s+"-ariagrouptotallabel");}}E.performCellModifications(this,$,D,null,L,null,null);},modifyAccOfCOLUMNHEADER:function($,o){var t=this.getTable(),d=sap.ui.getCore().byId($.attr("data-sap-ui-colid")),m=E.getAriaAttributesFor(this,c.ELEMENTTYPES.COLUMNHEADER,{headerId:$.attr("id"),column:d,index:$.attr("data-sap-ui-colindex")}),s=E.getColumnTooltip(d),L=[t.getId()+"-colnumberofcols"].concat(m["aria-labelledby"]);if(s){L.push(t.getId()+"-cellacc");}E.performCellModifications(this,$,m["aria-labelledby"],m["aria-describedby"],L,m["aria-describedby"],s);},modifyAccOfCOLUMNROWHEADER:function($,o){var m=E.getAriaAttributesFor(this,c.ELEMENTTYPES.COLUMNROWHEADER,{enabled:$.hasClass("sapUiTableSelAllEnabled")});E.performCellModifications(this,$,m["aria-labelledby"],m["aria-describedby"],m["aria-labelledby"],m["aria-describedby"],null);},getAriaAttributesFor:function(e,t,p){var m={},o=e.getTable(),s=o.getId();function d(o,r,O,u){var v="";if(O&&u){v="overlay,nodata";}else if(O&&!u){v="overlay";}else if(!O&&u){v="nodata";}var w=false;if(O&&o.getShowOverlay()||u&&b.isNoDataVisible(o)){w=true;}if(w){m["aria-hidden"]="true";}if(v){m["data-sap-ui-table-acc-covered"]=v;}}switch(t){case c.ELEMENTTYPES.COLUMNROWHEADER:m["aria-labelledby"]=[s+"-ariacolrowheaderlabel"];m["role"]=["columnheader"];if(p&&p.enabled){m["aria-labelledby"].push(s+"-ariaselectall");}break;case c.ELEMENTTYPES.ROWHEADER:m["aria-labelledby"]=[s+"-ariarowheaderlabel"];if(!b.Grouping.isTreeMode(o)){m["role"]=["rowheader"];}if(o.getSelectionMode()!==S.None){var f=p&&p.rowSelected;m["aria-selected"]=""+f;var g=e.getAriaTextsForSelectionMode(true);m["title"]=g.mouse[f?"rowDeselect":"rowSelect"];}break;case c.ELEMENTTYPES.COLUMNHEADER:var h=p&&p.column;var I=h&&h.getId()===p.headerId;m["role"]="columnheader";m["aria-labelledby"]=p&&p.headerId?[p.headerId]:[];if(h&&h._menuHasItems()){m["aria-haspopup"]="true";m["aria-describedby"]=[s+"-ariacolmenu"];}if(p&&(p.index<o.getFixedColumnCount())){m["aria-labelledby"].push(s+"-ariafixedcolumn");}if(I&&h.getSorted()){m["aria-sort"]=h.getSortOrder()==="Ascending"?"ascending":"descending";m["aria-labelledby"].push(s+(h.getSortOrder()==="Ascending"?"-ariacolsortedasc":"-ariacolsorteddes"));}if(I&&h.getFiltered()){m["aria-labelledby"].push(s+"-ariacolfiltered");}break;case c.ELEMENTTYPES.DATACELL:m["role"]="gridcell";if(p&&typeof p.index==="number"){m["headers"]=s+"_col"+p.index;}var L=[],h=p&&p.column?p.column:null;if(h){var M=h.getMultiLabels();var j=M.length;if(o.getColumnHeaderVisible()){var k=h.getId();L.push(k);if(j>1){for(var i=1;i<j;i++){L.push(k+"_"+i);}}}else{var n;if(j==0){n=h.getLabel();if(n){L.push(n.getId());}}else{for(var i=0;i<j;i++){n=M[i];if(n){L.push(n.getId());}}}}if(p&&p.fixed){L.push(s+"-ariafixedcolumn");}}m["aria-labelledby"]=L;if(b.Grouping.isTreeMode(o)&&p&&p.firstCol&&p.row){var B=o.mBindingInfos["rows"];if(p.row.getBindingContext(B&&B.model)){m["aria-level"]=p.row._iLevel+1;m["aria-expanded"]=""+p.row._bIsExpanded;}}break;case c.ELEMENTTYPES.ROOT:break;case c.ELEMENTTYPES.TABLE:m["role"]="presentation";d(o,m,true,true);break;case c.ELEMENTTYPES.CONTENT:m["role"]=b.Grouping.isGroupMode(o)||b.Grouping.isTreeMode(o)?"treegrid":"grid";m["aria-labelledby"]=[].concat(o.getAriaLabelledBy());if(o.getTitle()){m["aria-labelledby"].push(o.getTitle().getId());}if(o.getSelectionMode()===S.Multi||o.getSelectionMode()===S.MultiToggle){m["aria-multiselectable"]="true";}break;case c.ELEMENTTYPES.TABLEHEADER:m["role"]="heading";d(o,m,true,false);break;case c.ELEMENTTYPES.COLUMNHEADER_ROW:if(!b.hasRowHeader(o)){m["role"]="row";}d(o,m,true,false);break;case c.ELEMENTTYPES.ROWHEADER_COL:d(o,m,true,true);break;case c.ELEMENTTYPES.TH:var H=o.getFixedColumnCount()>0;m["role"]=H?"columnheader":"presentation";m["scope"]="col";if(H){if(p&&p.column){m["aria-owns"]=p.column.getId();m["aria-labelledby"]=[p.column.getId()];}}else{m["aria-hidden"]="true";}break;case c.ELEMENTTYPES.ROWHEADER_TD:m["role"]="rowheader";m["aria-labelledby"]=[s+"-ariarowheaderlabel"];m["headers"]=s+"-colsel";if(p&&typeof p.index==="number"){m["aria-owns"]=s+"-rowsel"+p.index;}if(o.getSelectionMode()!==S.None){var f=p&&p.rowSelected;m["aria-selected"]=""+f;}break;case c.ELEMENTTYPES.TR:m["role"]="row";var f=false;if(p&&typeof p.index==="number"&&o.getSelectionMode()!==S.None&&o.isIndexSelected(p.index)){m["aria-selected"]="true";f=true;}if(b.isRowSelectionAllowed(o)){var g=e.getAriaTextsForSelectionMode(true);m["title"]=g.mouse[f?"rowDeselect":"rowSelect"];}break;case c.ELEMENTTYPES.TREEICON:if(b.Grouping.isTreeMode(o)){m={"aria-label":"","title":"","role":""};if(o.getBinding("rows")){m["role"]="button";if(p&&p.row){if(p.row._bHasChildren){m["title"]=o._oResBundle.getText(p.row._bIsExpanded?"TBL_COLLAPSE":"TBL_EXPAND");m["aria-expanded"]=""+(!!p.row._bIsExpanded);}else{m["aria-label"]=o._oResBundle.getText("TBL_LEAF");}}}}break;case c.ELEMENTTYPES.NODATA:m["role"]="gridcell";var N=o.getNoData();m["aria-labelledby"]=[N instanceof C?N.getId():(s+"-noDataMsg")];d(o,m,true,false);break;case c.ELEMENTTYPES.OVERLAY:m["role"]="region";m["aria-labelledby"]=[].concat(o.getAriaLabelledBy());if(o.getTitle()){m["aria-labelledby"].push(o.getTitle().getId());}m["aria-labelledby"].push(s+"-ariainvalid");break;case c.ELEMENTTYPES.TABLEFOOTER:case c.ELEMENTTYPES.TABLESUBHEADER:d(o,m,true,false);break;}return m;}};var c=T.extend("sap.ui.table.TableAccExtension",{_init:function(t,s,m){this._accMode=sap.ui.getCore().getConfiguration().getAccessibility();this._readonly=s==T.TABLETYPES.ANALYTICAL?true:false;t.addEventDelegate(this);T.enrich(t,a);return"AccExtension";},destroy:function(){this.getTable().removeEventDelegate(this);this._readonly=false;T.prototype.destroy.apply(this,arguments);},_debug:function(){this._ExtensionHelper=E;this._ACCInfoHelper=A;},_getAriaAttributesFor:function(t,p){return E.getAriaAttributesFor(this,t,p);},onfocusin:function(e){var t=this.getTable();if(!t||!b.getCellInfo(e.target)){return;}if(t._mTimeouts._cleanupACCExtension){q.sap.clearDelayedCall(t._mTimeouts._cleanupACCExtension);t._mTimeouts._cleanupACCExtension=null;}this.updateAccForCurrentCell(true);},onfocusout:function(e){var t=this.getTable();if(!t){return;}t._mTimeouts._cleanupACCExtension=q.sap.delayedCall(100,this,function(){var t=this.getTable();if(!t){return;}this._iLastRowNumber=null;this._iLastColumnNumber=null;E.cleanupCellModifications(this);t._mTimeouts._cleanupACCExtension=null;});}});c.ELEMENTTYPES={DATACELL:b.CELLTYPES.DATACELL,COLUMNHEADER:b.CELLTYPES.COLUMNHEADER,ROWHEADER:b.CELLTYPES.ROWHEADER,COLUMNROWHEADER:b.CELLTYPES.COLUMNROWHEADER,ROOT:"ROOT",CONTENT:"CONTENT",TABLE:"TABLE",TABLEHEADER:"TABLEHEADER",TABLEFOOTER:"TABLEFOOTER",TABLESUBHEADER:"TABLESUBHEADER",COLUMNHEADER_ROW:"COLUMNHEADER_ROW",ROWHEADER_COL:"ROWHEADER_COL",TH:"TH",ROWHEADER_TD:"ROWHEADER_TD",TR:"TR",TREEICON:"TREEICON",NODATA:"NODATA",OVERLAY:"OVERLAY"};c.prototype.getAccMode=function(){return this._accMode;};c.prototype.updateAccForCurrentCell=function(o){if(!this._accMode||!this.getTable()._getItemNavigation()){return;}var t=this.getTable();if(t._mTimeouts._cleanupACCFocusRefresh){q.sap.clearDelayedCall(t._mTimeouts._cleanupACCFocusRefresh);t._mTimeouts._cleanupACCFocusRefresh=null;}if(o){E.cleanupCellModifications(this);}var i=E.getInfoOfFocusedCell(this);if(!i||!i.cell||!i.type||!E["modifyAccOf"+i.type]){return;}if(!o){if(i.type===b.CELLTYPES.DATACELL||b.CELLTYPES.ROWHEADER){t._mTimeouts._cleanupACCFocusRefresh=q.sap.delayedCall(100,this,function($){var t=this.getTable();if(!t){return;}var i=E.getInfoOfFocusedCell(this);if(i&&i.cell&&i.type&&i.cell.get(0)&&$.get(0)===i.cell.get(0)){i.cell.blur().focus();}t._mTimeouts._cleanupACCFocusRefresh=null;},[i.cell]);}return;}E["modifyAccOf"+i.type].apply(this,[i.cell,o]);};c.prototype.updateAriaStateOfColumn=function(o,r){if(!this._accMode){return;}var m=E.getAriaAttributesFor(this,c.ELEMENTTYPES.COLUMNHEADER,{headerId:o.getId(),column:o,index:this.getTable().indexOfColumn(o)});r=r?r:o.$();r.attr({"aria-sort":m["aria-sort"]||null,"aria-labelledby":m["aria-labelledby"]?m["aria-labelledby"].join(" "):null});};c.prototype.updateAriaStateOfRow=function(r,R,i){if(!this._accMode){return;}if(!R){R=r.getDomRefs(true);}if(R.row){R.row.children("td").add(R.row).attr("aria-selected",i?"true":null);}};c.prototype.updateAriaExpandAndLevelState=function(r,s,R,f,g,e,L,t){if(!this._accMode){return;}var d=null,o=this.getTable(),h=[s,s.children(),R,f,f?f.children():null],j=!!t,B=o.getBinding("rows");if(!g&&R&&!j){var I=R.attr("data-sap-ui-rowindex");var m=E.getAriaAttributesFor(this,c.ELEMENTTYPES.ROWHEADER,{rowSelected:!r._bHidden&&o.isIndexSelected(I)});d=m["title"]||null;}if(R&&!j){R.attr({"aria-haspopup":g?"true":null,"title":d});}if(B&&B.hasTotaledMeasures&&L>0&&(!B.bProvideGrandTotals||!B.hasTotaledMeasures())){L=L-1;}for(var i=0;i<h.length;i++){if(h[i]){h[i].attr({"aria-expanded":g?e+"":null,"aria-level":L<0?null:(L+1)});}}if(j){t.attr(E.getAriaAttributesFor(this,c.ELEMENTTYPES.TREEICON,{row:r}));}};c.prototype.updateAriaStateForOverlayAndNoData=function(){var t=this.getTable();if(!t||!t.getDomRef()||!this._accMode){return;}if(t.getShowOverlay()){t.$().find("[data-sap-ui-table-acc-covered*='overlay']").attr("aria-hidden","true");}else{t.$().find("[data-sap-ui-table-acc-covered*='overlay']").removeAttr("aria-hidden");if(b.isNoDataVisible(t)){t.$().find("[data-sap-ui-table-acc-covered*='nodata']").attr("aria-hidden","true");}else{t.$().find("[data-sap-ui-table-acc-covered*='nodata']").removeAttr("aria-hidden");}}};c.prototype.getAriaTextsForSelectionMode=function(d,s){var t=this.getTable();if(!s){s=t.getSelectionMode();}var r=t._oResBundle;var m={mouse:{rowSelect:"",rowDeselect:""},keyboard:{rowSelect:"",rowDeselect:""}};var i=t._getSelectedIndicesCount();if(s===S.Single){m.mouse.rowSelect=r.getText("TBL_ROW_SELECT");m.mouse.rowDeselect=r.getText("TBL_ROW_DESELECT");m.keyboard.rowSelect=r.getText("TBL_ROW_SELECT_KEY");m.keyboard.rowDeselect=r.getText("TBL_ROW_DESELECT_KEY");}else if(s===S.Multi){m.mouse.rowSelect=r.getText("TBL_ROW_SELECT_MULTI");m.mouse.rowDeselect=r.getText("TBL_ROW_DESELECT_MULTI");m.keyboard.rowSelect=r.getText("TBL_ROW_SELECT_MULTI_KEY");m.keyboard.rowDeselect=r.getText("TBL_ROW_DESELECT_MULTI_KEY");if(d===true){if(i===1){m.mouse.rowDeselect=r.getText("TBL_ROW_DESELECT");m.keyboard.rowDeselect=r.getText("TBL_ROW_DESELECT_KEY");}else if(i===0){m.mouse.rowSelect=r.getText("TBL_ROW_SELECT");m.keyboard.rowSelect=r.getText("TBL_ROW_SELECT_KEY");}}}else if(s===S.MultiToggle){m.mouse.rowSelect=r.getText("TBL_ROW_SELECT_MULTI_TOGGLE");m.mouse.rowDeselect=r.getText("TBL_ROW_DESELECT");m.keyboard.rowSelect=r.getText("TBL_ROW_SELECT_MULTI_TOGGLE_KEY");m.keyboard.rowDeselect=r.getText("TBL_ROW_DESELECT_KEY");if(d===true&&i===0){m.mouse.rowSelect=r.getText("TBL_ROW_SELECT");m.keyboard.rowSelect=r.getText("TBL_ROW_SELECT_KEY");}}return m;};return c;});};if(!jQuery.sap.isDeclared('sap.ui.table.Table')){jQuery.sap.declare('sap.ui.table.Table');jQuery.sap.require('jquery.sap.global');jQuery.sap.require('sap.ui.Device');jQuery.sap.require('sap.ui.core.Control');jQuery.sap.require('sap.ui.core.Element');jQuery.sap.require('sap.ui.core.IconPool');jQuery.sap.require('sap.ui.core.IntervalTrigger');jQuery.sap.require('sap.ui.core.library');jQuery.sap.require('sap.ui.core.Popup');jQuery.sap.require('sap.ui.core.ResizeHandler');jQuery.sap.require('sap.ui.core.ScrollBar');jQuery.sap.require('sap.ui.core.delegate.ItemNavigation');jQuery.sap.require('sap.ui.core.theming.Parameters');jQuery.sap.require('sap.ui.model.ChangeReason');jQuery.sap.require('sap.ui.model.Context');jQuery.sap.require('sap.ui.model.Filter');jQuery.sap.require('sap.ui.model.SelectionModel');jQuery.sap.require('sap.ui.model.Sorter');jQuery.sap.require('jquery.sap.dom');jQuery.sap.require('jquery.sap.trace');sap.ui.define("sap/ui/table/Table",['jquery.sap.global','sap/ui/Device','sap/ui/core/Control','sap/ui/core/Element','sap/ui/core/IconPool','sap/ui/core/IntervalTrigger','sap/ui/core/library','sap/ui/core/Popup','sap/ui/core/ResizeHandler','sap/ui/core/ScrollBar','sap/ui/core/delegate/ItemNavigation','sap/ui/core/theming/Parameters','sap/ui/model/ChangeReason','sap/ui/model/Context','sap/ui/model/Filter','sap/ui/model/SelectionModel','sap/ui/model/Sorter','./Column','./Row','./library','./TableUtils','./TableExtension','./TableAccExtension','./TableKeyboardExtension','./TablePointerExtension','./TableScrollExtension','jquery.sap.dom','jquery.sap.trace'],function(q,D,C,E,I,c,d,P,R,S,e,f,g,h,F,k,m,n,o,p,T,r,s,t,u,v){"use strict";var G=p.GroupEventType,N=p.NavigationMode,w=p.SelectionMode,x=p.SelectionBehavior,y=p.SharedDomRef,z=p.SortOrder,V=p.VisibleRowCountMode;var M,A;var B=C.extend("sap.ui.table.Table",{metadata:{library:"sap.ui.table",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'auto'},rowHeight:{type:"int",group:"Appearance",defaultValue:null},columnHeaderHeight:{type:"int",group:"Appearance",defaultValue:null},columnHeaderVisible:{type:"boolean",group:"Appearance",defaultValue:true},visibleRowCount:{type:"int",group:"Appearance",defaultValue:10},firstVisibleRow:{type:"int",group:"Appearance",defaultValue:0},selectionMode:{type:"sap.ui.table.SelectionMode",group:"Behavior",defaultValue:w.MultiToggle},selectionBehavior:{type:"sap.ui.table.SelectionBehavior",group:"Behavior",defaultValue:x.RowSelector},selectedIndex:{type:"int",group:"Appearance",defaultValue:-1},editable:{type:"boolean",group:"Behavior",defaultValue:true},navigationMode:{type:"sap.ui.table.NavigationMode",group:"Behavior",defaultValue:N.Scrollbar},threshold:{type:"int",group:"Appearance",defaultValue:100},enableColumnReordering:{type:"boolean",group:"Behavior",defaultValue:true},enableGrouping:{type:"boolean",group:"Behavior",defaultValue:false},showColumnVisibilityMenu:{type:"boolean",group:"Appearance",defaultValue:false},showNoData:{type:"boolean",group:"Appearance",defaultValue:true},visibleRowCountMode:{type:"sap.ui.table.VisibleRowCountMode",group:"Appearance",defaultValue:V.Fixed},minAutoRowCount:{type:"int",group:"Appearance",defaultValue:5},fixedColumnCount:{type:"int",group:"Appearance",defaultValue:0},fixedRowCount:{type:"int",group:"Appearance",defaultValue:0},fixedBottomRowCount:{type:"int",group:"Appearance",defaultValue:0},enableColumnFreeze:{type:"boolean",group:"Behavior",defaultValue:false},enableCellFilter:{type:"boolean",group:"Behavior",defaultValue:false},showOverlay:{type:"boolean",group:"Appearance",defaultValue:false},enableSelectAll:{type:"boolean",group:"Behavior",defaultValue:true},enableCustomFilter:{type:"boolean",group:"Behavior",defaultValue:false},enableBusyIndicator:{type:"boolean",group:"Behavior",defaultValue:false}},defaultAggregation:"columns",aggregations:{title:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false},footer:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false},toolbar:{type:"sap.ui.core.Toolbar",multiple:false,deprecated:true},extension:{type:"sap.ui.core.Control",multiple:true,singularName:"extension"},columns:{type:"sap.ui.table.Column",multiple:true,singularName:"column",bindable:"bindable"},rows:{type:"sap.ui.table.Row",multiple:true,singularName:"row",bindable:"bindable"},noData:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false}},associations:{groupBy:{type:"sap.ui.table.Column",multiple:false},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{rowSelectionChange:{parameters:{rowIndex:{type:"int"},rowContext:{type:"object"},rowIndices:{type:"int[]"},selectAll:{type:"boolean"},userInteraction:{type:"boolean"}}},columnSelect:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"}}},columnResize:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},width:{type:"sap.ui.core.CSSSize"}}},columnMove:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},newPos:{type:"int"}}},sort:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},sortOrder:{type:"sap.ui.table.SortOrder"},columnAdded:{type:"boolean"}}},filter:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},value:{type:"string"}}},group:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"}}},columnVisibility:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},visible:{type:"boolean"}}},cellClick:{allowPreventDefault:true,parameters:{cellControl:{type:"sap.ui.core.Control"},cellDomRef:{type:"Object"},rowIndex:{type:"int"},columnIndex:{type:"int"},columnId:{type:"string"},rowBindingContext:{type:"sap.ui.model.Context"}}},cellContextmenu:{allowPreventDefault:true,parameters:{cellControl:{type:"sap.ui.core.Control"},cellDomRef:{type:"Object"},rowIndex:{type:"int"},columnIndex:{type:"int"},columnId:{type:"string"},rowBindingContext:{type:"sap.ui.model.Context"}}},columnFreeze:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"}}},customFilter:{column:{type:"sap.ui.table.Column"},value:{type:"string"}},firstVisibleRowChanged:{firstVisibleRow:{type:"int"}},busyStateChanged:{busy:{type:"boolean"}}},designTime:true}});I.insertFontFaceStyle();B.prototype.init=function(){this._iBaseFontSize=parseFloat(q("body").css("font-size"))||16;this._oResBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.table");this._bRtlMode=sap.ui.getCore().getConfiguration().getRTL();this._attachExtensions();this._bBindingLengthChanged=false;this._mTimeouts={};this._lastCalledUpdateRows=0;this._iBindingTimerDelay=50;this._iMaxScrollbarHeight=1000000;this._iRowHeightsDelta=0;this._iRenderedFirstVisibleRow=0;var a=this;this._performUpdateRows=function(b){if(!a.bIsDestroyed){a._lastCalledUpdateRows=Date.now();a._updateBindingContexts(undefined,undefined,b);if(!a._bInvalid){a._updateTableContent();a._getAccExtension().updateAccForCurrentCell(false);a._updateSelection();var i=a._collectTableSizes();a._updateRowHeader(i.tableRowHeights);a._syncColumnHeaders(i);if(T.isVariableRowHeightEnabled(a)){a._iRowHeightsDelta=this._getRowHeightsDelta(i.tableRowHeights);a._iRenderedFirstVisibleRow=this.getFirstVisibleRow();}if(a._bBindingLengthChanged){a._updateVSb();}a._toggleVSb();if(T.isVariableRowHeightEnabled(a)){var j=0;var l=this.getDomRef(y.VerticalScrollBar);if(l){j=l.scrollTop;}a._adjustTablePosition(j,i.tableRowHeights);}}a._mTimeouts.bindingTimer=undefined;a.fireEvent("_rowsUpdated");}a._bBindingLengthChanged=false;};this._initSelectionModel(k.MULTI_SELECTION);this._iColMinWidth=20;if('ontouchstart'in document){this._iColMinWidth=88;}this._aTableHeaders=[];this._aIdxCols2Cells=[];this._bInheritEditableToControls=false;this._bAllowColumnHeaderTextSelection=false;this._bjQueryLess18=q.sap.Version(q.fn.jquery).compareTo("1.8")<0;this._iDataRequestedCounter=0;this._iBindingLength=0;this._iTableRowContentHeight=0;this._bFirstRendering=true;this._bInvalid=true;this._bIsScrollVertical=null;};B.prototype._attachExtensions=function(){if(this._bExtensionsInitialized){return;}r.enrich(this,u);r.enrich(this,v);r.enrich(this,t);r.enrich(this,s);this._bExtensionsInitialized=true;};B.prototype.exit=function(){this._bExitCalled=true;if(this._oPaginator){this._oPaginator.destroy();}this._resetRowTemplate();this._detachExtensions();this._cleanUpTimers();this._detachEvents();if(this._oSelection){this._oSelection.destroy();}};B.prototype._detachExtensions=function(){r.cleanup(this);};B.prototype.onThemeChanged=function(){if(this.getDomRef()){this.invalidate();}};B.prototype._collectRowHeights=function(){var a=this.getDomRef();if(!a){return[];}var b=this._getDefaultRowHeight();var j=a.querySelectorAll(".sapUiTableCtrlFixed > tbody > tr");var l=a.querySelectorAll(".sapUiTableCtrlScroll > tbody > tr");var H=[];for(var i=0;i<l.length;i++){var J=0;if(j[i]){J=j[i].getBoundingClientRect().height;}var K=l[i].getBoundingClientRect().height;H.push(Math.max(J,K,b));}return H;};B.prototype._resetRowHeights=function(){var a=this.getRowHeight();var b="";if(a){b=a+"px";}var j=this.getDomRef();if(j){var l=j.querySelectorAll(".sapUiTableCtrlFixed > tbody > tr, .sapUiTableCtrlScroll > tbody > tr");for(var i=0;i<l.length;i++){l[i].style.height=b;}}};B.prototype._determineAvailableSpace=function(){var a=this.getDomRef();if(a&&a.parentNode){var b=a.querySelector(".sapUiTableCCnt");if(b){var U=a.scrollHeight-b.clientHeight;return q(a.parentNode).height()-U;}}return 0;};B.prototype._collectTableSizes=function(a){var b={tableCtrlScrollWidth:0,tableRowHdrScrWidth:0,tableCtrlScrWidth:0,tableHSbScrollLeft:0,tableCtrlFixedWidth:0,tableCntHeight:0,tableCntWidth:0,invisibleColWidth:0};var j=this.getDomRef();if(!j){return b;}var l=j.querySelector(".sapUiTableCnt");if(l){b.tableCntHeight=l.clientHeight;b.tableCntWidth=l.clientWidth;}var H=j.querySelector(".sapUiTableCtrlScroll");if(H){b.tableCtrlScrollWidth=H.clientWidth;}var J=j.querySelector(".sapUiTableRowHdrScr");if(J){b.tableRowHdrScrWidth=J.clientWidth;}var K=j.querySelector(".sapUiTableCtrlScr");if(K){b.tableCtrlScrWidth=K.clientWidth;}var L=this.getDomRef(y.HorizontalScrollBar);if(L){b.tableHSbScrollLeft=L.scrollLeft;}var O=j.querySelector(".sapUiTableCtrlFixed");if(O){b.tableCtrlFixedWidth=O.clientWidth;}var Q=this.getProperty("fixedColumnCount");var U=[];var W=0;var X=j.querySelectorAll(".sapUiTableCtrlFirstCol > th:not(.sapUiTableColSel)");if(X){var Y=this.getColumns();for(var i=0;i<X.length;i++){var Z=X[i].getBoundingClientRect().width;U.push(Z);if(i<Y.length&&Y[i]&&!Y[i].getVisible()){Q--;}if(i<Q){W+=Z;}}}if(Q>0){var $=0;var _=this.getDomRef("sapUiTableRowHdrScr");if(_){$+=_.clientWidth;}var a1=this.getDomRef("vsb");if(a1){$+=a1.offsetWidth;}var b1=(j.clientWidth-$<W);if(this._bIgnoreFixedColumnCount!=b1){this._bIgnoreFixedColumnCount=b1;this.invalidate();}}b.headerWidths=U;if(T.hasRowHeader(this)){var c1=j.querySelector(".sapUiTableCtrlFirstCol > th:first-child");if(c1){b.invisibleColWidth=c1.clientWidth;}}if(!a){b.tableRowHeights=this._collectRowHeights();}else{b.tableRowHeights=a;}return b;};B.prototype._updateRowHeader=function(a){var b=this.getDomRef();if(!b){return;}var j=b.querySelectorAll(".sapUiTableRowHdr");var l=b.querySelectorAll(".sapUiTableCtrlFixed > tbody > tr");var H=b.querySelectorAll(".sapUiTableCtrlScroll > tbody > tr");var L=Math.max(j.length,H.length,0);for(var i=0;i<L;i++){var J=a[i];if(J){if(j[i]){j[i].style.height=J+"px";}if(l[i]){l[i].style.height=J+"px";}if(H[i]){H[i].style.height=J+"px";}}}};B.prototype.onBeforeRendering=function(a){if(a&&a.isMarked("insertTableRows")){return;}if(this._mTimeouts.bindingTimer){this._updateBindingContexts();}this._cleanUpTimers();this._detachEvents();var b=this.getVisibleRowCountMode();var i=this.getRows();if(b==V.Interactive||b==V.Fixed||(b==V.Auto&&this._iTableRowContentHeight&&i.length==0)){if(this.getBinding("rows")){this._adjustRows(this._calculateRowsToDisplay());}else{var j=this;this._mTimeouts.onBeforeRenderingAdjustRows=this._mTimeouts.onBeforeRenderingAdjustRows||window.setTimeout(function(){j._adjustRows(j._calculateRowsToDisplay());j._mTimeouts.onBeforeRenderingAdjustRows=undefined;},0);}}else if(!this._oRowTemplate&&i.length>0){this._adjustRows(i.length);}};B.prototype.onAfterRendering=function(a){if(a&&a.isMarked("insertTableRows")){this.getDomRef(y.VerticalScrollBar).style.maxHeight=this._getVSbHeight()+"px";this._updateVSbRange();return;}this._bInvalid=false;this._bOnAfterRendering=true;var $=this.$();this._attachEvents();this._initRowDomRefs();var b=this.getColumns();for(var i=0,l=b.length;i<l;i++){if(b[i].getVisible()){b[i]._restoreIcons();}}if(!this._bAllowColumnHeaderTextSelection){this._disableTextSelection($.find(".sapUiTableColHdrCnt"));}this._bOnAfterRendering=false;this._getKeyboardExtension().invalidateItemNavigation();this._updateTableContent();if(this._bFirstRendering&&this.getVisibleRowCountMode()==V.Auto){this._bFirstRendering=false;Promise.resolve().then(this._updateTableSizes.bind(this,true));}else if(!this._mTimeouts.onAfterRenderingUpdateTableSizes){this._updateTableSizes();}this._updateVSb(this._iScrollTop);if(this._iScrollLeft){this.getDomRef(y.HorizontalScrollBar).scrollLeft=this._iScrollLeft;}if(this.getBinding("rows")){this.fireEvent("_rowsUpdated");}};B.prototype.invalidate=function(){if(!this._ignoreInvalidateOfChildControls){this._bInvalid=true;var a=C.prototype.invalidate.call(this);}return a;};B.prototype._initRowDomRefs=function(){var a=this.getRows();for(var i=0;i<a.length;i++){a[i].initDomRefs();}};B.prototype._updateTableSizes=function(b,a){this._mTimeouts.onAfterRenderingUpdateTableSizes=undefined;var i=this.getDomRef();if(this._bInvalid||!i){return;}this._resetRowHeights();var j=this._collectRowHeights();if(T.isVariableRowHeightEnabled(this)){this._iRowHeightsDelta=this._getRowHeightsDelta(j);}var l=0;if(!a&&this.getVisibleRowCountMode()==V.Auto){l=this._determineAvailableSpace();if(this._handleRowCountModeAuto(l)&&!b){return;}}T.deregisterResizeHandler(this,"");this._toggleVSb();var H=this._collectTableSizes(j);if(this._mTimeouts.afterUpdateTableSizes){window.clearTimeout(this._mTimeouts.afterUpdateTableSizes);}if(H.tableCntHeight==0&&H.tableCntWidth==0){T.registerResizeHandler(this,"",this._onTableResize.bind(this),true);return;}this._updateRowHeader(H.tableRowHeights);this._syncColumnHeaders(H);this._determineVisibleCols(H);if(!a){this._setRowContentHeight(l);}this._updateHSb(H);var J=this;var $=this.$();$.find(".sapUiTableNoOpacity").addBack().removeClass("sapUiTableNoOpacity");function K(){T.registerResizeHandler(J,"",J._onTableResize.bind(J),true);}if($.closest(".sapUiLoSplitter").length){K();}else{this._mTimeouts.afterUpdateTableSizes=window.setTimeout(K,0);}};B.prototype.setShowOverlay=function(b){b=!!b;this.setProperty("showOverlay",b,true);if(this.getDomRef()){var a=document.activeElement;this.$().toggleClass("sapUiTableOverlay",b);this._getAccExtension().updateAriaStateForOverlayAndNoData();this._getKeyboardExtension().updateNoDataAndOverlayFocus(a);}return this;};B.prototype._updateFixedBottomRows=function(){var a=this.getFixedBottomRowCount();var b=this.getDomRef();if(b&&a>0){var $=q(b).find(".sapUiTableFixedPreBottomRow");$.removeClass("sapUiTableFixedPreBottomRow");var j=this.getBinding("rows");if(j){var l=this.getVisibleRowCount();var H=false;var J=this.getRows();var K=this._getSanitizedFirstVisibleRow();for(var i=0;i<J.length;i++){var L=J[i].getDomRefs(true);if(this._iBindingLength>=l){H=(i==l-a-1);}else{H=(K+i)==(this._iBindingLength-a-1)&&(K+i)<this._iBindingLength;}L.row.toggleClass("sapUiTableFixedPreBottomRow",H);}}}};B.prototype.getFocusInfo=function(){var i=this.$().find(":focus").attr("id");if(i){return{customId:i};}else{return E.prototype.getFocusInfo.apply(this,arguments);}};B.prototype.applyFocusInfo=function(a){if(a&&a.customId){this.$().find("#"+a.customId).focus();}else{E.prototype.getFocusInfo.apply(this,arguments);}return this;};B.prototype.setTitle=function(a){var b=a;if(typeof(a)==="string"||a instanceof String){b=p.TableHelper.createTextView({text:a,width:"100%"});b.addStyleClass("sapUiTableHdrTitle");}this.setAggregation("title",b);return this;};B.prototype.setFooter=function(a){var b=a;if(typeof(a)==="string"||a instanceof String){b=p.TableHelper.createTextView({text:a,width:"100%"});}this.setAggregation("footer",b);return this;};B.prototype.setSelectionMode=function(a){this.clearSelection();if(a===w.Single){this._oSelection.setSelectionMode(k.SINGLE_SELECTION);}else{this._oSelection.setSelectionMode(k.MULTI_SELECTION);}a=T.sanitizeSelectionMode(this,a);this.setProperty("selectionMode",a);return this;};B.prototype._adjustTablePosition=function(i,a){var b=i<this._getVirtualScrollRange();var j=this._getRowCount()>this.getVisibleRowCount();if(b&&this.getFirstVisibleRow()!=this._iRenderedFirstVisibleRow){return;}var l=null;if(b&&j){var H=a[0];var J=this._getScrollingPixelsForRow();var K=i-(this.getFirstVisibleRow()*J);var L=K/J;l=Math.ceil(L*H);if(l>H){l=null;}}else if(this._iRowHeightsDelta>=0){var O=j?i-this._getVirtualScrollRange():i;l=(this._iRowHeightsDelta/this._getRowCorrectionScrollRange())*O;}if(l!=null&&l>-1){this.$().find(".sapUiTableCCnt").scrollTop(l);}};B.prototype.setFirstVisibleRow=function(i,O,b){if(this.getNavigationMode()==sap.ui.table.NavigationMode.Paginator){var a=this.getVisibleRowCount();var j=this._paginatorCalculateTargetPage(i,a);var l=(j-1)*a;if(i!=l){i=l;j=this._paginatorCalculateTargetPage(i,a);}this._paginatorUpdate(j);}var H=this.getFirstVisibleRow()!=i;this.setProperty("firstVisibleRow",i,true);if(H&&this.getBinding("rows")&&!this._bRefreshing){this.updateRows();if(!O){this._updateVSb();}}if(H&&!b){this.fireFirstVisibleRowChanged({firstVisibleRow:i});}return this;};B.getMetadata().getAggregation("rows")._doesNotRequireFactory=true;B.prototype.bindRows=function(b,a,i,j){if(typeof b==="string"&&(a instanceof m||q.isArray(i)&&i[0]instanceof F)){j=i;i=a;a=undefined;}return this.bindAggregation("rows",b,a,i,j);};B.prototype._bindAggregation=function(a,b,i,j,l){E.prototype._bindAggregation.apply(this,arguments);var H=this.getBinding("rows");if(a==="rows"&&H){H.attachChange(this._onBindingChange,this);}this._initSelectionModel(k.MULTI_SELECTION);if(H&&this.isTreeBinding("rows")&&!H.hasListeners("selectionChanged")){H.attachSelectionChanged(this._onSelectionChanged,this);}return this;};B.prototype._initSelectionModel=function(a){if(this._oSelection){this._oSelection.detachSelectionChanged(this._onSelectionChanged,this);}this._oSelection=new k(a);this._oSelection.attachSelectionChanged(this._onSelectionChanged,this);return this;};B.prototype._onBindingChange=function(a){var b=typeof(a)==="object"?a.getParameter("reason"):a;if(b==="sort"||b==="filter"){this.clearSelection();this.setFirstVisibleRow(0);}};B.prototype.unbindAggregation=function(a,b){var i=this.getBinding("rows");if(a==="rows"&&this.isBound("rows")){b=true;}var j=E.prototype.unbindAggregation.apply(this,[a,b]);if(a==="rows"&&i){this._restoreAppDefaultsColumnHeaderSortFilter();this._invalidateColumnMenus();this._updateBindingLength();this.updateRows("unbindAggregation");}return j;};B.prototype.setVisibleRowCount=function(i){if(i!=null&&!isFinite(i)){return this;}var a=this.getVisibleRowCountMode();if(a==V.Auto){q.sap.log.error("VisibleRowCount will be ignored since VisibleRowCountMode is set to Auto",this);return this;}var b=this.getFixedRowCount()+this.getFixedBottomRowCount();if(i<=b&&b>0){q.sap.log.error("Table: "+this.getId()+" visibleRowCount('"+i+"') must be bigger than number of fixed rows('"+(this.getFixedRowCount()+this.getFixedBottomRowCount())+"')",this);return this;}i=this.validateProperty("visibleRowCount",i);if(this.getBinding("rows")&&this.getBinding("rows").getLength()<=i){this.setProperty("firstVisibleRow",0);}this.setProperty("visibleRowCount",i);this._setRowContentHeight(i*this._getDefaultRowHeight());return this;};B.prototype.setTooltip=function(a){q.sap.log.warning("The aggregation tooltip is not supported for sap.ui.table.Table");return this.setAggregation("tooltip",a,true);};B.prototype.setNavigationMode=function(){this.setProperty("navigationMode",N.Scrollbar,true);q.sap.log.error("The navigationMode property is deprecated and must not be used anymore. Your setting was defaulted to 'Scrollbar'",this);};B.prototype._getFixedBottomRowContexts=function(i,b){var a=this.getBinding("rows");var j=[];if(!a){return j;}i=i||this.getFixedBottomRowCount();b=b||a.getLength();var l=this.getVisibleRowCount();if(i>0&&(l-i)<b){j=this._getContexts(b-i,i,1);}return j;};B.prototype._getFixedRowContexts=function(i){i=i||this.getFixedRowCount();if(i>0){return this._getContexts(0,i);}else{return[];}};B.prototype._getContexts=function(i,l,a){var b=this.getBinding("rows");if(b){return b.getContexts(i,l,a);}else{return[];}};B.prototype._getRowContexts=function(a,b,j){var l=false;var H=[];var J=this.getBinding("rows");var K=a||this.getRows().length;if(!J||K<=0){return[];}var L=this.getFirstVisibleRow();var O=this.getFixedRowCount();var Q=this.getFixedBottomRowCount();var U=0;var W;var X=K-Q;var Y=0;var Z=X;var $=this.getThreshold();$=$?Math.max(K,$):0;var _=L;var a1=function(f1,g1,_){for(var i=0;i<g1.length;i++){f1[_+i]=g1[i];}};if(O>0&&L>0){_=L+O;X-=O;Y=O;W=this._getFixedRowContexts(O);U+=W.length;H=H.concat(W);}W=this._getContexts(_,X,$);var b1=this._updateBindingLength(j);l=W.length<Math.min(X,b1-Q);if(this.getNavigationMode===N.Paginator){var c1=Math.min(X,(Math.max(b1-L-Q,0)));if(c1<X){X=c1;W=W.slice(0,X);}}U+=W.length;a1(H,W,Y);Z=Math.min(Z,Math.max(b1-Q,0));if(Q>0){W=this._getFixedBottomRowContexts(Q,b1);U+=W.length;a1(H,W,Z);}if(l&&!b){var d1=this._getSanitizedFirstVisibleRow(true);if(L!=d1){H=this._getRowContexts(K,true);U=H.length;}}if(!b){var e1=this;if(this._mTimeouts.getContextsSetBusy){window.clearTimeout(this._mTimeouts.getContextsSetBusy);}this._mTimeouts.getContextsSetBusy=window.setTimeout(function(){e1._setBusy({requestedLength:O+X+Q,receivedLength:U,contexts:H,reason:j});},0);}return H;};B.prototype._getSanitizedFirstVisibleRow=function(U){var a=this.getNavigationMode();var i=this.getVisibleRowCount();var b=this.getFirstVisibleRow();b=Math.max(b,0);if(a===N.Scrollbar&&this._iBindingLength>0&&!T.isVariableRowHeightEnabled(this)){b=Math.min(b,Math.max(this._iBindingLength-i,0));}else if(a===N.Paginator&&this._oPaginator){var j=this._paginatorCalculateTargetPage(b,i);b=(j-1)*i;if(U){this._paginatorUpdate(j);}}if(U){this.setProperty("firstVisibleRow",b,true);}return b;};B.prototype._paginatorCalculateTargetPage=function(i,a){var b=1;if(this._oPaginator){if(i<this._iBindingLength){b=Math.ceil((i+1)/a);}}return b;};B.prototype._paginatorUpdate=function(i){if(this._oPaginator&&i!==this._oPaginator.getCurrentPage()){this._oPaginator.setCurrentPage(i);if(this._oPaginator.getDomRef()){this._oPaginator.rerender();}}};B.prototype._updateBindingLength=function(a){var b=this.getBinding("rows");var i=0;if(b){i=b.getLength();}if(i!=this._iBindingLength){this._iBindingLength=i;this._onBindingLengthChange(a);}return i;};B.prototype._onBindingLengthChange=function(a){this._updateFixedBottomRows();this._toggleVSb();this._updateVSbRange();this._bBindingLengthChanged=true;if(a!="skipNoDataUpdate"){this._updateNoData();}};B.prototype.refreshRows=function(a){var b=this.getBinding("rows");if(!b){q.sap.log.error("RefreshRows must not be called without a binding",this);return;}var i=this;var j=typeof(a)==="object"?a.getParameter("reason"):a;if(j==g.Refresh){this._attachBindingListener();}this._bBusyIndicatorAllowed=true;var l=this.getVisibleRowCountMode();if((this.bOutput&&l===V.Auto)||l!==V.Auto){var H=this._calculateRowsToDisplay();if(this.bOutput){b.attachEventOnce("dataRequested",function(){if(i._mTimeouts.refreshRowsAdjustRows){window.clearTimeout(i._mTimeouts.refreshRowsAdjustRows);}i._mTimeouts.refreshRowsAdjustRows=window.setTimeout(function(){i._adjustRows(H,true);},0);});}var U;if(j==g.Filter||j==g.Sort){U="skipNoDataUpdate";this.setFirstVisibleRow(0);}this._updateBindingContexts(true,H,U);}};B.prototype.updateRows=function(a){if(this._bExitCalled){return;}this._setBusy(a?{changeReason:a}:false);if(this._bBindingLengthChanged){this._updateNoData();}var b=this.getVisibleRowCountMode();if((this.getRows().length<=0||!this._oRowTemplate)&&((b==V.Auto&&this.bOutput)||b!=V.Auto)){if(this._iTableRowContentHeight){this._adjustRows(this._calculateRowsToDisplay());}}if(!this.bIsDestroyed){var i=(a==g.Change||(!this._mTimeouts.bindingTimer&&Date.now()-this._lastCalledUpdateRows>this._iBindingTimerDelay)||a=="unbindAggregation"?0:this._iBindingTimerDelay);var j=this;if(i==0&&a){Promise.resolve().then(function(){j._performUpdateRows(a);});}else{this._mTimeouts.bindingTimer=this._mTimeouts.bindingTimer||window.setTimeout(function(){j._performUpdateRows(a);},i);}}};B.prototype.insertRow=function(){q.sap.log.error("The control manages the rows aggregation. The method \"insertRow\" cannot be used programmatically!",this);};B.prototype.addRow=function(){q.sap.log.error("The control manages the rows aggregation. The method \"addRow\" cannot be used programmatically!",this);};B.prototype.removeRow=function(){q.sap.log.error("The control manages the rows aggregation. The method \"removeRow\" cannot be used programmatically!",this);};B.prototype.removeAllRows=function(){q.sap.log.error("The control manages the rows aggregation. The method \"removeAllRows\" cannot be used programmatically!",this);};B.prototype.destroyRows=function(){q.sap.log.error("The control manages the rows aggregation. The method \"destroyRows\" cannot be used programmatically!",this);};B.prototype.autoResizeColumn=function(i){this._getPointerExtension().doAutoResizeColumn(i);};B.prototype._attachEvents=function(){var $=this.$();$.find(".sapUiTableColHdrScr").scroll(q.proxy(this._oncolscroll,this));$.find(".sapUiTableCtrlScr").scroll(q.proxy(this._oncntscroll,this));$.find(".sapUiTableCtrlScrFixed").scroll(q.proxy(this._oncntscroll,this));$.find(".sapUiTableCtrlScrFixed, .sapUiTableColHdrFixed").on("scroll.sapUiTablePreventFixedAreaScroll",function(j){j.target.scrollLeft=0;});if(T.isVariableRowHeightEnabled(this)){var i=$.find(".sapUiTableCtrlScr, .sapUiTableCtrlScrFixed, .sapUiTableRowHdrScr");i.on("scroll.sapUiTableSyncScrollPosition",function(j){i.scrollTop(j.target.scrollTop);});}$.find(".sapUiTableRowHdr").hover(function(){q(this).addClass("sapUiTableRowHvr");var j=$.find(".sapUiTableRowHdr").index(this);$.find(".sapUiTableCtrlFixed > tbody > tr").filter(":eq("+j+")").addClass("sapUiTableRowHvr");$.find(".sapUiTableCtrlScroll > tbody > tr").filter(":eq("+j+")").addClass("sapUiTableRowHvr");},function(){q(this).removeClass("sapUiTableRowHvr");$.find(".sapUiTableCtrlFixed > tbody > tr").removeClass("sapUiTableRowHvr");$.find(".sapUiTableCtrlScroll > tbody > tr").removeClass("sapUiTableRowHvr");});$.find(".sapUiTableCtrlFixed > tbody > tr").hover(function(){q(this).addClass("sapUiTableRowHvr");var j=$.find(".sapUiTableCtrlFixed > tbody > tr").index(this);$.find(".sapUiTableRowHdr").filter(":eq("+(j)+")").addClass("sapUiTableRowHvr");$.find(".sapUiTableCtrlScroll > tbody > tr").filter(":eq("+j+")").addClass("sapUiTableRowHvr");},function(){q(this).removeClass("sapUiTableRowHvr");$.find(".sapUiTableRowHdr").removeClass("sapUiTableRowHvr");$.find(".sapUiTableCtrlScroll > tbody > tr").removeClass("sapUiTableRowHvr");});$.find(".sapUiTableCtrlScroll > tbody > tr").hover(function(){q(this).addClass("sapUiTableRowHvr");var j=$.find(".sapUiTableCtrlScroll > tbody > tr").index(this);$.find(".sapUiTableRowHdr").filter(":eq("+j+")").addClass("sapUiTableRowHvr");$.find(".sapUiTableCtrlFixed > tbody > tr").filter(":eq("+j+")").addClass("sapUiTableRowHvr");},function(){q(this).removeClass("sapUiTableRowHvr");$.find(".sapUiTableRowHdr").removeClass("sapUiTableRowHvr");$.find(".sapUiTableCtrlFixed > tbody > tr").removeClass("sapUiTableRowHvr");});var a=q(this.getDomRef(y.VerticalScrollBar));var b=q(this.getDomRef(y.HorizontalScrollBar));a.bind("scroll.sapUiTableVScroll",this.onvscroll.bind(this));b.bind("scroll.sapUiTableHScroll",this.onhscroll.bind(this));a.on("mousedown.sapUiTableVScrollClick",this.onVerticalScrollbarMouseDown.bind(this));if(D.browser.firefox){this._getScrollTargets().bind("MozMousePixelScroll.sapUiTableMouseWheel",this._onMouseWheel.bind(this));}else{this._getScrollTargets().bind("wheel.sapUiTableMouseWheel",this._onMouseWheel.bind(this));}if(sap.ui.getCore().getConfiguration().getAnimation()){q("body").bind('webkitTransitionEnd transitionend',q.proxy(function(j){if(q(j.target).has($).length>0){this._iDefaultRowHeight=undefined;this._updateTableSizes();}},this));}r.attachEvents(this);};B.prototype._detachEvents=function(){var $=this.$();$.find(".sapUiTableRowHdrScr").unbind();$.find(".sapUiTableCtrl > tbody > tr").unbind();$.find(".sapUiTableRowHdr").unbind();$.find(".sapUiTableCtrlScrFixed, .sapUiTableColHdrFixed").unbind("scroll.sapUiTablePreventFixedAreaScroll");if(T.isVariableRowHeightEnabled(this)){$.find(".sapUiTableCtrlScr, .sapUiTableCtrlScrFixed, .sapUiTableRowHdrScr").unbind("scroll.sapUiTableSyncScrollPosition");}var a=q(this.getDomRef(y.VerticalScrollBar));a.unbind("scroll.sapUiTableVScroll");a.off("mousedown.sapUiTableVScrollClick");var b=q(this.getDomRef(y.HorizontalScrollBar));b.unbind("scroll.sapUiTableHScroll");var i=this._getScrollTargets();i.unbind("MozMousePixelScroll.sapUiTableMouseWheel");i.unbind("wheel.sapUiTableMouseWheel");var j=q(document.body);j.unbind('webkitTransitionEnd transitionend');T.deregisterResizeHandler(this);r.detachEvents(this);};B.prototype._getScrollTargets=function(){var $=q(this.getDomRef("sapUiTableCtrlScr"));var a=q(this.getDomRef("rsz"));var b=q(this.getDomRef("sapUiTableCtrlScrFixed"));var i=q(this.getDomRef("sapUiTableRowHdrScr"));return $.add(b).add(i).add(a);};B.prototype._cleanUpTimers=function(){for(var K in this._mTimeouts){if(this._mTimeouts[K]){clearTimeout(this._mTimeouts[K]);this._mTimeouts[K]=undefined;}}};B.prototype._updateHSb=function(a){var $=this.$();var i=a.tableCtrlScrollWidth;if(!!D.browser.safari){i=Math.max(i,this._getColumnsWidth(this.getFixedColumnCount()));}if(i>a.tableCtrlScrWidth){if(!$.hasClass("sapUiTableHScr")){$.addClass("sapUiTableHScr");if(!!D.browser.safari){var b=$.find(".sapUiTableCtrlScroll, .sapUiTableColHdrScr > .sapUiTableColHdr");if(this._bjQueryLess18){b.width(i);}else{b.outerWidth(i);}}}var j=a.tableCtrlFixedWidth;if($.find(".sapUiTableRowHdrScr").length>0){j+=a.tableRowHdrScrWidth;}if(this.getRows().length>0){var l=$.find(".sapUiTableHSb");if(this._bRtlMode){l.css('margin-right',j+'px');}else{l.css('margin-left',j+'px');}}var H=this.getDomRef("hsb-content");if(H){H.style.width=i+"px";}}else{if($.hasClass("sapUiTableHScr")){$.removeClass("sapUiTableHScr");if(!!D.browser.safari){$.find(".sapUiTableCtrlScroll, .sapUiTableColHdr").css("width","");}}}};B.prototype._updateVSb=function(i){var a=this.getDomRef(y.VerticalScrollBar);if(!a){return;}if(i===undefined){i=Math.ceil(this.getFirstVisibleRow()*this._getScrollingPixelsForRow());}var b=this.getDomRef("tableCCnt");if(b){var j=b.offsetTop;var l=this.getFixedRowCount();if(l>0){j+=this._iVsbTop;}a.style.top=j+"px";}a.scrollTop=i;};B.prototype._updateVSbRange=function(){var a=this.getDomRef(y.VerticalScrollBar);if(!a){return;}q(this.getDomRef("vsb-content")).height(this._getTotalScrollRange());};B.prototype._toggleVSb=function(){var $=this.$();var b=this.getBinding("rows");if(this._oPaginator&&this.getNavigationMode()===N.Paginator){var i=0;var a=0;if(b){var j=this.getVisibleRowCount();i=Math.ceil((this._iBindingLength||0)/j);var l=Math.min(i,Math.ceil((this.getFirstVisibleRow()+1)/j));this.setProperty("firstVisibleRow",(Math.max(l,1)-1)*j,true);a=l;}this._oPaginator.setNumberOfPages(i);this._oPaginator.setCurrentPage(a);if(this._oPaginator.getDomRef()){this._oPaginator.rerender();}if(this.getDomRef()){$.removeClass("sapUiTableVScr");}}else if(this.getDomRef()){var H=this._isVSbRequired();if(!H){this._updateVSb(0);}$.toggleClass("sapUiTableVScr",H);}};B.prototype._isVSbRequired=function(){if(this.getNavigationMode()===N.Scrollbar){if(this._iRowHeightsDelta>0||(this.getBinding("rows")&&this._iBindingLength>this.getVisibleRowCount())){return true;}}return false;};B.prototype._updateBindingContexts=function(b,i,a){var j=this.getRows(),l=this.getBinding("rows"),H=this.mBindingInfos["rows"],J;if(l){J=this._getRowContexts(i,false,a);}if(!b){var K=this.getFirstVisibleRow();var L=typeof this._updateTableCell==="function";this._resetRowHeights();for(var O=j.length-1;O>=0;O--){var Q=J?J[O]:undefined;var U=j[O];if(U){var W=K+O;this._updateRowBindingContext(U,Q,H&&H.model,W,L,l);}}}};B.prototype._updateRowBindingContext=function(a,b,j,H,J,K){a.setRowBindingContext(b,j,K);if(J){var L=a.getCells();for(var i=0,l=L.length;i<l;i++){if(L[i]){this._updateTableCell(L[i],b,L[i].$().closest("td"),H);}}}};B.prototype._updateNoData=function(){if(!this.getDomRef()){return;}var a=document.activeElement;this.$().toggleClass("sapUiTableEmpty",T.isNoDataVisible(this));this._getAccExtension().updateAriaStateForOverlayAndNoData();this._getKeyboardExtension().updateNoDataAndOverlayFocus(a);};B.prototype._determineVisibleCols=function(a){var b=[];this.getColumns().forEach(function(j,i){if(j.shouldRender()){b.push(i);}});};B.prototype.removeColumn=function(a,b){var i=this.removeAggregation('columns',a,b);if(typeof a==="number"&&a>-1){a=this.getColumns()[a];}var j=q.inArray(a,this._aSortedColumns);if(this._iNewColPos===undefined&&j>=0){this._aSortedColumns.splice(j,1);}this._resetRowTemplate();return i;};B.prototype.removeAllColumns=function(){var a=this.removeAllAggregation('columns');this._aSortedColumns=[];this._resetRowTemplate();return a;};B.prototype.destroyColumns=function(){var a=this.destroyAggregation('columns');this._aSortedColumns=[];this._resetRowTemplate();return a;};B.prototype.addColumn=function(a,b){this.addAggregation('columns',a,b);this._resetRowTemplate();return this;};B.prototype.insertColumn=function(a,i,b){this.insertAggregation('columns',a,i,b);this._resetRowTemplate();return this;};B.prototype._getRowCount=function(){return this._iBindingLength;};B.prototype._getSelectableRowCount=function(){return this._iBindingLength;};B.prototype._getFirstVisibleRowByScrollTop=function(i){if(T.isVariableRowHeightEnabled(this)&&this._getRowCount()<this.getVisibleRowCount()){return 0;}else{var a=Math.floor(i/this._getScrollingPixelsForRow());return Math.min(this._getMaxRowIndex(),a);}return 0;};B.prototype._getScrollingPixelsForRow=function(){return this._getVirtualScrollRange()/Math.max(1,this._getMaxRowIndex());};B.prototype._getVSbHeight=function(){return this._getScrollableRowCount()*this._getDefaultRowHeight();};B.prototype._getScrollableRowCount=function(){return Math.max(1,this.getVisibleRowCount()-this.getFixedRowCount()-this.getFixedBottomRowCount());};B.prototype._getRowHeightsDelta=function(i){var j=this._getDefaultRowHeight()*this.getVisibleRowCount();if(this.getVisibleRowCount()>this._getRowCount()){i=i.slice(0,this._getRowCount());}var l=i.reduce(function(a,b){return a+b;},0)-j;if(l>0){l=Math.ceil(l);}return Math.max(0,l);};B.prototype._getTotalScrollRange=function(){var i=Math.max(this._getRowCount(),this.getVisibleRowCount()+1);var a=this._getDefaultRowHeight()*i;return Math.min(this._iMaxScrollbarHeight,a);};B.prototype._getVirtualScrollRange=function(){var i=this._getTotalScrollRange()-this._getVSbHeight();if(T.isVariableRowHeightEnabled(this)){i=i-this._iRowHeightsDelta;}return Math.max(1,i);};B.prototype._getRowCorrectionScrollRange=function(){var i=this._getTotalScrollRange()-this._getVSbHeight();if(this._getRowCount()>this.getVisibleRowCount()){i-=this._getVirtualScrollRange();}return Math.max(1,i);};B.prototype._getMaxRowIndex=function(){if(T.isVariableRowHeightEnabled(this)){if(this.getVisibleRowCount()>this._getRowCount()){return this._getRowCount();}else{return Math.max(0,this._getRowCount()-this.getVisibleRowCount()-1);}}else{return Math.max(0,this._getRowCount()-this.getVisibleRowCount());}};B.prototype._getVisibleColumns=function(){var a=[];var b=this.getColumns();for(var i=0,l=b.length;i<l;i++){if(b[i].shouldRender()){a.push(b[i]);}}return a;};B.prototype._getColumnsWidth=function(a,b){var j=this.getColumns();var H=0;if(a!==0&&!a){a=0;}if(b!==0&&!b){b=j.length;}for(var i=a,l=b;i<l;i++){if(j[i]&&j[i].shouldRender()){H+=this._CSSSizeToPixel(j[i].getWidth());}}return H;};B.prototype._CSSSizeToPixel=function(a,b){var i=this._iColMinWidth;if(a){if(q.sap.endsWith(a,"px")){i=parseInt(a,10);}else if(q.sap.endsWith(a,"em")||q.sap.endsWith(a,"rem")){i=Math.ceil(parseFloat(a)*this._getBaseFontSize());}}if(b){return i+"px";}else{return parseInt(i,10);}};B.prototype._getBaseFontSize=function(){return this._iBaseFontSize;};B.prototype._onTableResize=function(){if(this._bInvalid||!this.getDomRef()){return;}this._updateTableSizes();};B.prototype._handleRowCountModeAuto=function(i){var b=this.getBinding("rows");if(b&&this.getRows().length>0){return this._executeAdjustRows(i);}else{var a=this;var j=!this._mTimeouts.handleRowCountModeAutoAdjustRows;var l=a.getBusyIndicatorDelay();var H=this.getEnableBusyIndicator();if(b&&H){a.setBusyIndicatorDelay(0);a.setBusy(true);}if(i){this._setRowContentHeight(i);}this._mTimeouts.handleRowCountModeAutoAdjustRows=this._mTimeouts.handleRowCountModeAutoAdjustRows||window.setTimeout(function(){if(!a._executeAdjustRows()){a._updateTableSizes(false,true);}a._mTimeouts.handleRowCountModeAutoAdjustRows=undefined;if(H){a.setBusy(false);a.setBusyIndicatorDelay(l);}},0);return j;}};B.prototype._executeAdjustRows=function(i){i=i||this._determineAvailableSpace();var a=this._calculateRowsToDisplay(i);if(a==this._determineMinAutoRowCount()){this.$().height("auto");}else{this.$().height("0px");}return this._adjustRows(a);};B.prototype._syncColumnHeaders=function(a){var b=this.getDomRef();if(!b){return;}var $=this.$();var H=a.headerWidths;var J=this.getFixedColumnCount();var K=this._getVisibleColumns();if(K.length==0){return;}var L=$.find(".sapUiTableColHdr");var O=$.find(".sapUiTableColHdrScr");var Q=L.find(".sapUiTableCol");var U=$.find(".sapUiTableCtrlFirstCol > th:not(.sapUiTableColSel)");this._aTableHeaders=U;var W={};U.each(function(l,b1){var c1=b1.getAttribute("data-sap-ui-headcolindex");var d1=H[l];var e1;var f1=K[l];if(f1){e1=d1;}if(l==0||l==J){e1+=Math.max(0,a.invisibleColWidth);}var g1=K[l]?K[l].getHeaderSpan():1,h1=[],i1;if(g1){if(!q.isArray(g1)){g1=[g1];}q.each(g1,function(k1,l1){g1[k1]=Math.max(l1,1);});i1=g1;}else{i1=[1];}for(var i=0;i<i1.length;i++){h1[i]={width:e1,span:1};for(var j=1;j<i1[i];j++){var j1=U[l+j];if(j1){h1[i].width+=H[l+j];h1[i].span=i1[i];}}}if(f1){W[c1]={domRefColumnTh:b1,domRefColumnDivs:[],aHeaderData:h1};}});var X=this;Q.each(function(i,j){var l=parseInt(j.getAttribute("data-sap-ui-colindex"),10);var b1=W[l];if(b1){b1.domRefColumnDivs.push(j);}else{q.sap.log.error("Inconsistent DOM / Control Tree combination",X);}});q.each(W,function(j,l){for(var i=0;i<l.domRefColumnDivs.length;i++){var b1=l.aHeaderData[0];if(l.aHeaderData[i]){b1=l.aHeaderData[i];}if(l.domRefColumnDivs[i]){l.domRefColumnDivs[i].style.width=b1.width+"px";l.domRefColumnDivs[i].setAttribute("data-sap-ui-colspan",b1.span);}else{q.sap.log.error("Inconsistent DOM / Control Tree combination",X);}}});O.each(function(i,j){j.style.width=a.tableCtrlScrWidth+"px";});var Y;var Z=[];function _(i,j){var l=[].slice.call(j.getElementsByClassName("sapUiTableCol"));Z[i]=(Z[i]||[]).concat(l);}function a1(j,b1){var c1=0,d1,e1=false,l=b1.length,i;for(i=0;i<l;i++){b1[i].style.height=null;}for(i=0;i<l;i++){d1=b1[i].offsetHeight;if(c1>0&&d1>0&&d1!=c1){e1=true;}c1=Math.max(d1,c1);}if(e1){for(i=0;i<l;i++){b1[i].style.height=c1+"px";}}return j+c1;}if(!(this.getColumnHeaderHeight()>0)){$.find(".sapUiTableColHdrFixed").find(".sapUiTableColHdr").each(_);$.find(".sapUiTableColHdrScr").find(".sapUiTableColHdr").each(_);Y=Z.reduce(a1,0);$.find(".sapUiTableColHdrCnt").height(Y);}};B.prototype._disableTextSelection=function(a){q(a||document.body).attr("unselectable","on").css({"-moz-user-select":"none","-webkit-user-select":"none","user-select":"none"}).bind("selectstart",function(b){b.preventDefault();return false;});};B.prototype._enableTextSelection=function(a){q(a||document.body).attr("unselectable","off").css({"-moz-user-select":"","-webkit-user-select":"","user-select":""}).unbind("selectstart");};B.prototype._clearTextSelection=function(){if(window.getSelection){if(window.getSelection().empty){window.getSelection().empty();}else if(window.getSelection().removeAllRanges){window.getSelection().removeAllRanges();}}else if(document.selection&&document.selection.empty){try{document.selection.empty();}catch(a){}}};B.prototype.onvscroll=function(a){var b=this;q.sap.interaction.notifyScrollEvent&&q.sap.interaction.notifyScrollEvent(a);if(this._bIsScrolledByKeyboard){return;}this._getKeyboardExtension().setActionMode(false);function i(j){var l=j.getDomRef(y.VerticalScrollBar);if(!l){return;}var H=l.scrollTop;if(T.isVariableRowHeightEnabled(j)){j._iScrollTop=H;j._adjustTablePosition(H,j._collectRowHeights());}j.setFirstVisibleRow(j._getFirstVisibleRowByScrollTop(H),true);}if(this._bLargeDataScrolling&&!this._bIsScrolledByWheel){window.clearTimeout(this._mTimeouts.scrollUpdateTimerId);this._mTimeouts.scrollUpdateTimerId=window.setTimeout(function(){i(this);b._mTimeouts._sScrollUpdateTimerId=null;},300);}else{i(this);}this._bIsScrolledByWheel=false;};B.prototype.onpscroll=function(a){q.sap.interaction.notifyScrollEvent&&q.sap.interaction.notifyScrollEvent(a);this._getKeyboardExtension().setActionMode(false);var i=0;if(this.getNavigationMode()===N.Paginator){i=(((this._oPaginator.getCurrentPage()||1)-1)*this.getVisibleRowCount());}this.setFirstVisibleRow(i,true);};B.prototype._onMouseWheel=function(a){var O=a.originalEvent;var i=O.shiftKey;var b=0;if(D.browser.firefox){b=O.detail;}else{if(i){b=O.deltaX;}else{b=O.deltaY;}}if(i){var H=this.getDomRef(y.HorizontalScrollBar);if(H){H.scrollLeft=H.scrollLeft+b;}}else{var j=this.getDomRef(y.VerticalScrollBar);if(j){this._bIsScrolledByWheel=true;this._bIsScrolledByKeyboard=false;j.scrollTop=j.scrollTop+b;}}a.preventDefault();a.stopPropagation();};B.prototype.onVerticalScrollbarMouseDown=function(a){this._bIsScrolledByWheel=false;this._bIsScrolledByKeyboard=false;};B.prototype._syncHeaderAndContent=function(a){if(!this._bSyncScrollLeft){this._bSyncScrollLeft=true;var $=this.$();var H=a.tableHSbScrollLeft;$.find(".sapUiTableColHdrScr").scrollLeft(H);$.find(".sapUiTableCtrlScr").scrollLeft(H);this._bSyncScrollLeft=false;}};B.prototype.onhscroll=function(a){q.sap.interaction.notifyScrollEvent&&q.sap.interaction.notifyScrollEvent(a);if(!this._bOnAfterRendering){if(this._mTimeouts.hScrollUpdateTimer){window.clearTimeout(this._mTimeouts.hScrollUpdateTimer);}this._mTimeouts.hScrollUpdateTimer=window.setTimeout(function(){this._iScrollLeft=this.getDomRef(y.HorizontalScrollBar).scrollLeft;var b=this._collectTableSizes();this._syncHeaderAndContent(b);this._determineVisibleCols(b);}.bind(this),50);}};B.prototype._oncolscroll=function(){if(!this._bSyncScrollLeft){var H=this.getDomRef(y.HorizontalScrollBar);if(H){var a=this.getDomRef().querySelector(".sapUiTableColHdrScr");var i=0;if(a){i=a.scrollLeft;}H.scrollLeft=i;}}};B.prototype._oncntscroll=function(){if(!this._bSyncScrollLeft){var H=this.getDomRef(y.HorizontalScrollBar);if(H){var a=this.getDomRef().querySelector(".sapUiTableCtrlScr");H.scrollLeft=a.scrollLeft;}}};B.prototype.oncontextmenu=function(a){var $=q(a.target);var H=$.closest('.sapUiTableCol');if(H.length>0){var b=sap.ui.getCore().byId(H.attr("data-sap-ui-colid"));if(b){b._openMenu(H[0],false);}a.preventDefault();}else{if(this._findAndfireCellEvent(this.fireCellContextmenu,a,this._oncellcontextmenu)){a.preventDefault();}}};B.prototype._oncellcontextmenu=function(a){if(this.getEnableCellFilter()){if(!this._oContextMenu){if(!M){M=sap.ui.requireSync("sap/ui/unified/Menu");A=sap.ui.requireSync("sap/ui/unified/MenuItem");}this._oContextMenu=new M(this.getId()+"-contextmenu");this.addDependent(this._oContextMenu);}var b=sap.ui.getCore().byId(a.columnId);var i=b.getFilterProperty();if(b&&b.isFilterableByMenu()&&a.rowBindingContext){this._oContextMenu.destroyItems();this._oContextMenu.addItem(new A({text:this._oResBundle.getText("TBL_FILTER"),select:[function(){var l=this.getContextByIndex(a.rowIndex);var H=l.getProperty(i);if(this.getEnableCustomFilter()){this.fireCustomFilter({column:b,value:H});}else{this.filter(b,H);}},this]}));var j=P.Dock;this._oContextMenu.open(false,a.cellDomRef,j.BeginTop,j.BeginBottom,a.cellDomRef,"none none");return true;}}};B.prototype._findAndfireCellEvent=function(a,b,i){var $=q(b.target);var j=$.closest("td.sapUiTableTd");var l=j.attr("id");var H=/.*-row(\d*)-col(\d*)/i.exec(l);var J=false;if(H){var K=H[1];var L=H[2];var O=this.getRows()[K];var Q=O&&O.getCells()[L];var U=O&&O.getIndex();var W=Q.data("sap-ui-colid");var X;if(this.getBindingInfo("rows")){X=O.getBindingContext(this.getBindingInfo("rows").model);}var Y={rowIndex:U,columnIndex:L,columnId:W,cellControl:Q,rowBindingContext:X,cellDomRef:j.get(0)};J=!a.call(this,Y);if(!J&&typeof i==="function"){Y.cellDomRef=j[0];J=i.call(this,Y);}}return J;};B.prototype.getFocusDomRef=function(){this._getKeyboardExtension().initItemNavigation();return T.getFocusedItemInfo(this).domRef||C.prototype.getFocusDomRef.apply(this,arguments);};B.prototype.onfocusin=function(a){var $;var b=q(a.target);if(b.parent('.sapUiTableTr').length>0){$=q(this.getDomRef("sapUiTableCtrlScr"));}else if(b.parent('.sapUiTableColHdr').length>0){$=q(this.getDomRef("sapUiTableColHdrScr"));}if((D.browser.firefox||D.browser.chrome)&&$&&$.length>0){var i=$.scrollLeft();var j=$.width();var l=b.position().left;var H=l+b.width();var O=l-i;var J=H-j-i;var K=this.getDomRef(y.HorizontalScrollBar);if(J>0){K.scrollLeft=K.scrollLeft+J+2;}else if(O<0){K.scrollLeft=K.scrollLeft+O-1;}}};B.prototype._getAbsoluteRowIndex=function(i){var a=0;var b=this.getFirstVisibleRow();var j=this.getFixedBottomRowCount();var l=this.getVisibleRowCount();var H=l-j;if(j>0&&i>=H){a=this.getBinding().getLength()-l+i;}else{a=b+i;}return a;};B.prototype._onSelect=function(a){var $=q(a.target);var b=a.shiftKey;var i=!!(a.metaKey||a.ctrlKey);var j=$.closest(".sapUiTableCol");if(this._bShowMenu&&j.length===1){var l=parseInt(j.attr("data-sap-ui-colindex"),10);var H=this.getColumns()[l];if($.hasClass("sapUiTableColDropDown")){var J=this.fireColumnSelect({column:H});if(J){H._openMenu(j[0],a.type=="keyup");}}else{this._onColumnSelect(H,j[0],this._isTouchMode(a),a.type=="keyup");}return;}var K=$.closest(".sapUiTableRowHdr");if(K.length===1){var l=parseInt(K.attr("data-sap-ui-rowindex"),10);this._onRowSelect(this._getAbsoluteRowIndex(l),b,i);return;}var L,O;if(a.target){O=q(a.target).closest(".sapUiTableCtrl > tbody > tr > td");if(O.length>0){L=O[0];}}if(L&&(O.hasClass("sapUiTableTd")||O.hasClass("sapUiTableTDDummy"))&&T.isRowSelectionAllowed(this)){var K=$.closest(".sapUiTableCtrl > tbody > tr");if(K.length===1){var l=parseInt(K.attr("data-sap-ui-rowindex"),10);this._onRowSelect(this._getAbsoluteRowIndex(l),b,i);return;}}if(q.sap.containsOrEquals(this.getDomRef("selall"),a.target)){this._toggleSelectAll();return;}};B.prototype._isRowSelectable=function(i){return true;};B.prototype._onRowSelect=function(i,b,a){if(!!D.browser.internet_explorer&&b){this._clearTextSelection();}var j=this.getBinding("rows");if(!j){return;}if(i<0||i>=(j.getLength()||0)){return;}if(!this._isRowSelectable(i)){return;}this._iSourceRowIndex=i;var l=this.getSelectionMode();if(l!==w.None){if(l===w.Single){if(!this.isIndexSelected(i)){this.setSelectedIndex(i);}else{this.clearSelection();}}else{if(l===w.MultiToggle){a=true;}if(b){var H=this.getSelectedIndex();if(H>=0){this.addSelectionInterval(H,i);}else{this.setSelectedIndex(i);}}else{if(!this.isIndexSelected(i)){if(a){this.addSelectionInterval(i,i);}else{this.setSelectedIndex(i);}}else{if(a){this.removeSelectionInterval(i,i);}else{if(this._getSelectedIndicesCount()===1){this.clearSelection();}else{this.setSelectedIndex(i);}}}}}}this._iSourceRowIndex=undefined;};B.prototype._onColumnSelect=function(a,b,i,W){if(i&&(a.getResizable()||a._menuHasItems())){var $=q(b);var j=$.find(".sapUiTableColCell");if($.find(".sapUiTableColCellMenu").length<1){j.hide();var l="";if(a._menuHasItems()){l="<div class='sapUiTableColDropDown'></div>";}var H="";if(a.getResizable()){H="<div class='sapUiTableColResizer''></div>";}var J=q("<div class='sapUiTableColCellMenu'>"+l+H+"</div>");$.append(J);$.bind("focusout",function(){this.cell.show();this.menu.remove();this.self.unbind("focusout");}.bind({cell:j,menu:J,self:$}));}return;}var K=this.fireColumnSelect({column:a});if(K){a._openMenu(b,W);}};B.prototype.ontouchstart=function(a){if(this._isTouchMode(a)){this._aTouchStartPosition=null;this._bIsScrollVertical=null;var $=this._getScrollTargets();var b=q(a.target).closest($).length>0;if(b){var i=a.targetTouches[0];this._aTouchStartPosition=[i.pageX,i.pageY];var j=this.getDomRef(y.VerticalScrollBar);if(j){this._iTouchScrollTop=j.scrollTop;}var H=this.getDomRef(y.HorizontalScrollBar);if(H){this._iTouchScrollLeft=H.scrollLeft;}}}};B.prototype.ontouchmove=function(a){if(this._isTouchMode(a)&&this._aTouchStartPosition){var b=a.targetTouches[0];var i=(b.pageX-this._aTouchStartPosition[0]);var j=(b.pageY-this._aTouchStartPosition[1]);if(this._bIsScrollVertical==null){this._bIsScrollVertical=Math.abs(j)>Math.abs(i);}if(this._bIsScrollVertical){var l=this.getDomRef(y.VerticalScrollBar);if(l){var H=this._iTouchScrollTop-j;if(H>0&&H<(this.getDomRef("vsb-content").clientHeight-l.clientHeight)-1){a.preventDefault();a.stopPropagation();}l.scrollTop=H;}}else{var J=this.getDomRef(y.HorizontalScrollBar);if(J){var K=this._iTouchScrollLeft-i;if(K>0&&K<(this.getDomRef("hsb-content").clientWidth-J.clientWidth)-1){a.preventDefault();a.stopPropagation();}J.scrollLeft=K;}}}};B.prototype._resizeDependentColumns=function(a,W){var b=this;if(this._checkPercentageColumnWidth()){var j=this._getVisibleColumns();var l;q.each(j,function(d1,e1){if(a===e1){l=d1;}});var O=0;var L=j.length-1;var H;if(l===undefined){H=0;}else{H=parseInt(W,10);}var J=0;var K=[];q.each(j,function(d1,e1){var f1=b._getColumnPercentageWidth(e1);if((((l===L&&d1<l)||((l!==L)&&d1>l))&&e1.getFlexible())||l===undefined){O+=e1.$().outerWidth();J+=f1;K.push(e1);}else if(d1!==l){H+=f1;}});var Q=H;q.each(K,function(d1,e1){var f1=b._getColumnPercentageWidth(e1);var c1=Math.round((100-Q)/J*f1);if(d1===K.length-1){c1=100-H;}else{H+=c1;}if(!isFinite(c1)||c1<=0){c1=1;}b._updateColumnWidth(e1,c1+"%");});}else if(!this._hasOnlyFixColumnWidths()){var j=this._getVisibleColumns(),U=this.$().find(".sapUiTableCtrlScr").width(),l,X=0,Y=0,Z=0,$=this.getFixedColumnCount(),_=0;if(a.getIndex()<$){return;}q.each(j,function(d1,e1){if(d1<$){return;}if(!q.sap.endsWith(e1.getWidth(),"px")&&!q.sap.endsWith(e1.getWidth(),"em")&&!q.sap.endsWith(e1.getWidth(),"rem")){_++;return false;}if(l!=undefined){Z+=b._CSSSizeToPixel(e1.getWidth());X++;}else if(a!==e1){Y+=b._CSSSizeToPixel(e1.getWidth());}if(a===e1){l=d1;Y+=b._CSSSizeToPixel(W);}});if(_>0||(Y+Z>U)){return;}U-=Y;for(var i=l+1;i<j.length;i++){var a=j[i],a1=this._CSSSizeToPixel(a.getWidth()),b1=a1/Z*100,c1=U/100*b1;this._updateColumnWidth(a,Math.round(c1)+'px');}}};B.prototype._getColumnPercentageWidth=function(a){var b=a.getWidth();var i=parseInt(a.getWidth(),10);var j=this.$().find(".sapUiTableCtrl").width();if(q.sap.endsWith(b,"px")||q.sap.endsWith(b,"em")||q.sap.endsWith(b,"rem")){i=Math.round(100/j*i);}else if(!q.sap.endsWith(b,"%")){i=Math.round(100/j*a.$().width());}return i;};B.prototype._updateColumnWidth=function(a,W,b){var i=true;if(b){i=this.fireColumnResize({column:a,width:W});}if(i){a.setProperty("width",W,true);this.$().find('th[data-sap-ui-colid="'+a.getId()+'"]').css('width',W);}return i;};B.prototype._checkPercentageColumnWidth=function(){var a=this.getColumns();var H=false;q.each(a,function(i,b){if(q.sap.endsWith(b.getWidth(),"%")){H=true;return false;}});return H;};B.prototype._hasOnlyFixColumnWidths=function(){var O=true;q.each(this.getColumns(),function(i,a){var W=a.getWidth();if(a.getFlexible()||!W||W.substr(-2)!=="px"){O=false;return false;}});return O;};B.prototype.pushSortedColumn=function(a,b){if(!b){this._aSortedColumns=[];}this._aSortedColumns.push(a);};B.prototype.getSortedColumns=function(){return this._aSortedColumns;};B.prototype.sort=function(a,b,i){if(q.inArray(a,this.getColumns())>=0){a.sort(b===z.Descending,i);}};B.prototype.filter=function(a,b){if(q.inArray(a,this.getColumns())>=0){a.filter(b);}};B.prototype._updateSelection=function(){var a=this.getSelectionMode();if(a===w.None){return;}var b=this._getAccExtension().getAriaTextsForSelectionMode(true);var j=T.isRowSelectionAllowed(this);var l=this.getRows();for(var i=0;i<l.length;i++){var H=l[i];H._updateSelection(this,b,j);}this.setProperty("selectedIndex",this.getSelectedIndex(),true);var $=this.$("selall");if((a==w.Multi||a==w.MultiToggle)&&this.getEnableSelectAll()&&!$.hasClass("sapUiTableSelAll")){var J=this._getSelectedIndicesCount();var K=J==0;if(!K){var L=this._getSelectableRowCount();K=L==0||L!==J;}if(K){$.addClass("sapUiTableSelAll");}}};B.prototype._onSelectionChanged=function(a){var b=a.getParameter("rowIndices");var i=a.getParameter("selectAll");var j=this._iSourceRowIndex!==undefined?this._iSourceRowIndex:this.getSelectedIndex();this._updateSelection();this.fireRowSelectionChange({rowIndex:j,rowContext:this.getContextByIndex(j),rowIndices:b,selectAll:i,userInteraction:this._iSourceRowIndex!==undefined});};B.prototype.getContextByIndex=function(i){var b=this.getBinding("rows");return i>=0&&b?b.getContexts(i,1)[0]:null;};B.prototype.getSelectedIndex=function(){return this._oSelection.getLeadSelectedIndex();};B.prototype.setSelectedIndex=function(i){if(i===-1){this.clearSelection();}else{this._oSelection.setSelectionInterval(i,i);}return this;};B.prototype.clearSelection=function(){this._oSelection.clearSelection();return this;};B.prototype.selectAll=function(){var a=this.getSelectionMode();if(!this.getEnableSelectAll()||(a!="Multi"&&a!="MultiToggle")){return this;}var b=this.getBinding("rows");if(b){this.$("selall").attr('title',this._oResBundle.getText("TBL_DESELECT_ALL")).removeClass("sapUiTableSelAll");this._oSelection.selectAll((b.getLength()||0)-1);}return this;};B.prototype.getSelectedIndices=function(){return this._oSelection.getSelectedIndices();};B.prototype.addSelectionInterval=function(i,a){if(this.getSelectionMode()===p.SelectionMode.None){return this;}this._oSelection.addSelectionInterval(i,a);return this;};B.prototype.setSelectionInterval=function(i,a){if(this.getSelectionMode()===p.SelectionMode.None){return this;}this._oSelection.setSelectionInterval(i,a);return this;};B.prototype.removeSelectionInterval=function(i,a){this._oSelection.removeSelectionInterval(i,a);return this;};B.prototype.isIndexSelected=function(i){return this._oSelection.isSelectedIndex(i);};B.prototype.setGroupBy=function(a){var b=a;if(typeof b==="string"){b=sap.ui.getCore().byId(b);}var i=false;if(b&&b instanceof n){if(q.inArray(b,this.getColumns())===-1){throw new Error("Column has to be part of the columns aggregation!");}var j=this.fireGroup({column:b,groupedColumns:[b.getId()],type:G.group});var O=sap.ui.getCore().byId(this.getGroupBy());if(O){O.setGrouped(false);i=true;}if(j&&b instanceof n){b.setGrouped(true);}}if(!b||i){var l=this.getBindingInfo("rows");delete l.binding;this._bindAggregation("rows",l);}return this.setAssociation("groupBy",b);};B.prototype.getBinding=function(a){T.Grouping.setupExperimentalGrouping(this);return E.prototype.getBinding.call(this,[a||"rows"]);};B.prototype.setEnableGrouping=function(b){this.setProperty("enableGrouping",b);if(!b){T.Grouping.resetExperimentalGrouping(this);}this._invalidateColumnMenus();return this;};B.prototype.setEnableCustomFilter=function(b){this.setProperty("enableCustomFilter",b);this._invalidateColumnMenus();return this;};B.prototype.setEnableColumnFreeze=function(b){this.setProperty("enableColumnFreeze",b);this._invalidateColumnMenus();return this;};B.prototype.setShowColumnVisibilityMenu=function(b){this.setProperty("showColumnVisibilityMenu",b);this._invalidateColumnMenus();return this;};B.prototype.getFixedColumnCount=function(){if(this._bIgnoreFixedColumnCount){return 0;}else{return this.getProperty("fixedColumnCount");}};B.prototype.setFixedColumnCount=function(a,b){var j=this._getVisibleColumns();var H=j[a-1]&&j[a-1].getHeaderSpan();if(H){var l;if(q.isArray(H)){l=parseInt(H[0],10);}else{l=parseInt(H,10);}a+=l-1;}var $=this.$().find(".sapUiTableCtrlFirstCol > th");for(var i=0;i<a;i++){var J=j[i];if(J){var K=q.inArray(J,this.getColumns());if(!J.getWidth()){J.setWidth($.filter("[data-sap-ui-headcolindex='"+K+"']").width()+"px");}}}this.setProperty("fixedColumnCount",a,b);this._collectTableSizes();this._invalidateColumnMenus();return this;};B.prototype.setFixedRowCount=function(i){if(!(parseInt(i,10)>=0)){q.sap.log.error("Number of fixed rows must be greater or equal 0",this);return this;}if((i+this.getFixedBottomRowCount())<this.getVisibleRowCount()){this.setProperty("fixedRowCount",i);this._updateBindingContexts();}else{q.sap.log.error("Table '"+this.getId()+"' fixed rows('"+(i+this.getFixedBottomRowCount())+"') must be smaller than numberOfVisibleRows('"+this.getVisibleRowCount()+"')",this);}return this;};B.prototype.setFixedBottomRowCount=function(i){if(!(parseInt(i,10)>=0)){q.sap.log.error("Number of fixed bottom rows must be greater or equal 0",this);return this;}if((i+this.getFixedRowCount())<this.getVisibleRowCount()){this.setProperty("fixedBottomRowCount",i);this._updateBindingContexts();}else{q.sap.log.error("Table '"+this.getId()+"' fixed rows('"+(i+this.getFixedRowCount())+"') must be smaller than numberOfVisibleRows('"+this.getVisibleRowCount()+"')",this);}return this;};B.prototype.setThreshold=function(i){this.setProperty("threshold",i,true);};B.prototype._invalidateColumnMenus=function(){var a=this.getColumns();for(var i=0,l=a.length;i<l;i++){a[i].invalidateMenu();}};B.prototype._isTouchMode=function(a){return!!a.originalEvent["touches"];};B.prototype._determineParent=function(){var a=this.getParent();if(a){var b;if(a.getDomRef){b=a.getDomRef();}else if(a.getRootNode){b=a.getRootNode();}if(b){return q(b);}}return q();};B.prototype._getRowTemplate=function(){if(!this._oRowTemplate){this._oRowTemplate=new o(this.getId()+"-rows");var a=this.getColumns();for(var i=0,l=a.length;i<l;i++){if(a[i].getVisible()){var b=a[i].getTemplate();if(b){var j=b.clone("col"+i);j.data("sap-ui-colindex",i);j.data("sap-ui-colid",a[i].getId());this._oRowTemplate.addCell(j);}}}}return this._oRowTemplate;};B.prototype._getDummyRow=function(){if(!this._oDummyRow){this._oDummyRow=this._getRowTemplate().clone("dummy");this._oDummyRow._bDummyRow=true;this._oDummyRow._bHidden=true;}return this._oDummyRow;};B.prototype._resetRowTemplate=function(){if(this._oRowTemplate){this._oRowTemplate.destroy();this._oRowTemplate=undefined;}if(this._oDummyRow){this._oDummyRow.destroy();this._oDummyRow=undefined;}};B.prototype._adjustRows=function(a,b){if(isNaN(a)){return false;}if(T.isVariableRowHeightEnabled(this)){a=a+1;}var i;var j=this.getRows();if(!this._oRowTemplate&&j.length>0){this.destroyAggregation("rows",true);j=[];}if(a==j.length){return false;}for(i=j.length-1;i>=a;i--){this.removeAggregation("rows",i,true).destroy();}if(T.isVariableRowHeightEnabled(this)){this.setProperty("visibleRowCount",a-1,true);}else{this.setProperty("visibleRowCount",a,true);}this._ignoreInvalidateOfChildControls=true;var l;var H=this.getFirstVisibleRow();var J=0;var K=false;var L;var O=this.getBinding("rows");if(!b){L=this.getBindingInfo("rows");K=typeof this._updateTableCell==="function";l=this._getRowContexts(a);for(i=0;i<j.length;i++){J=H+i;this._updateRowBindingContext(j[i],l[i],L&&L.model,J,K,O);}}if(j.length<a){var Q=this._getRowTemplate();for(i=j.length;i<a;i++){var U=Q.clone("row"+i);if(!b){J=H+i;this._updateRowBindingContext(U,l[i],L&&L.model,J,K,O);}this.addAggregation("rows",U,true);}}this._ignoreInvalidateOfChildControls=false;j=this.getRows();b=b||l.length==0;return this._insertTableRows(j,b);};B.prototype._insertTableRows=function(a,b){var j=false;if(!this._bInvalid){this._detachEvents();var H=this.getDomRef("tableCCnt");a=a||this.getRows();if(!a.length||!H){return;}if(this.getVisibleRowCountMode()==V.Auto){var J=this.getDomRef();if(J){J.style.height="0px";}}var K=q.Event("BeforeRendering");K.setMarked("insertTableRows");K.srcControl=this;this._handleEvent(K);var L=new sap.ui.getCore().createRenderManager(),O=this.getRenderer();O.renderTableCCnt(L,this);L.flush(H,false,false);L.destroy();K=q.Event("AfterRendering");K.setMarked("insertTableRows");K.srcControl=this;this._handleEvent(K);this._initRowDomRefs();this._getKeyboardExtension().invalidateItemNavigation();var Q=this.getColumns();for(var i=0,l=Q.length;i<l;i++){if(Q[i].getVisible()){Q[i]._restoreIcons();}}this._updateTableContent();this._updateTableSizes();j=true;this._attachEvents();}if(!b&&!this._bInvalid&&this.getBinding("rows")){var U=this;if(this._mTimeouts._rowsUpdated){window.clearTimeout(this._mTimeouts._rowsUpdated);}this._mTimeouts._rowsUpdated=window.setTimeout(function(){U.fireEvent("_rowsUpdated");},0);}return j;};B.prototype._getDefaultRowHeight=function(){var a=T.getContentDensity(this);return this.getRowHeight()||T.CONTENT_DENSITY_ROW_HEIGHTS[a]+1;};B.prototype._setRowContentHeight=function(H){H=H||0;var a=this.getVisibleRowCountMode();var i=this.getVisibleRowCount();var b=this._getDefaultRowHeight();var j=this.getMinAutoRowCount();var l;if(a==V.Interactive||a==V.Fixed){if(this._iTableRowContentHeight&&a==V.Interactive){l=j*b;if(!H){H=this._iTableRowContentHeight;}}else{l=i*b;H=l;}}else if(a==V.Auto){l=j*b;}var J=Math.max(H,l);if((a==V.Fixed&&this.getRows().length==0)||a!=V.Fixed){this._iTableRowContentHeight=Math.floor(J/b)*b;}else{this._iTableRowContentHeight=undefined;}if(T.isVariableRowHeightEnabled(this)){q(this.getDomRef("tableCCnt")).css("height",b*this.getVisibleRowCount()+"px");}else{if((a==V.Fixed||a==V.Interactive)&&this.getRows().length>0){q(this.getDomRef("tableCtrlCnt")).css("height","auto");}else{q(this.getDomRef("tableCtrlCnt")).css("height",this._iTableRowContentHeight+"px");}}this._toggleVSb();};B.prototype._determineMinAutoRowCount=function(){var i=this.getVisibleRowCount();var a=this.getMinAutoRowCount();var b=a||i||5;if(this.getVisibleRowCountMode()==V.Interactive&&!this.bOutput){b=i||a||5;}return b;};B.prototype._calculateRowsToDisplay=function(i){i=i||this._iTableRowContentHeight;var a=this.getVisibleRowCountMode();var b=0;if(a==V.Fixed){b=this.getVisibleRowCount()||0;}else if(a==V.Interactive||a==V.Auto){var j=this._determineMinAutoRowCount();var l=this._getDefaultRowHeight();if(!l||!i){b=j;}else{var H=Math.min(i,50000);var J=Math.floor(H/l);b=Math.max((this.getFixedRowCount()+this.getFixedBottomRowCount()+1),Math.max(j,J));}}return Math.max(b,0);};B.prototype.setShowNoData=function(b){this.setProperty('showNoData',b,true);this._updateNoData();return this;};B.prototype.exportData=function(a){var b=sap.ui.requireSync("sap/ui/core/util/Export");a=a||{};if(!a.rows){var j=this.getBinding("rows"),H=this.getBindingInfo("rows");var J=j.aFilters.concat(j.aApplicationFilters);a.rows={path:H.path,model:H.model,sorter:j.aSorters,filters:J,parameters:H.parameters};}if(!a.exportType){var K=sap.ui.requireSync("sap/ui/core/util/ExportTypeCSV");a.exportType=new K();}var L=a.rows.model;if(!L){var O=a.rows.path;var Q=O.indexOf(">");if(Q>0){L=O.substr(0,Q);}}if(!a.columns){a.columns=[];var U=this.getColumns();for(var i=0,l=U.length;i<l;i++){var W=U[i];if(W.getSortProperty()){a.columns.push({name:W.getLabel().getText(),template:{content:{path:W.getSortProperty(),model:L}}});}}}var X=new b(a);this.addDependent(X);return X;};B.prototype._onPersoApplied=function(){var a=this.getColumns();var b=[];for(var i=0,l=a.length;i<l;i++){var j=a[i];if(j.getSorted()){b.push(new m(j.getSortProperty(),j.getSortOrder()===z.Descending));}}var H=this.getBinding("rows");if(H){if(b.length>0){H.sort(b);}this.refreshRows();}};B.prototype._toggleSelectAll=function(){if(!this.$("selall").hasClass("sapUiTableSelAll")){this._iSourceRowIndex=-1;this.clearSelection();}else{this._iSourceRowIndex=0;this.selectAll();}if(!!D.browser.internet_explorer){this.$("selall").focus();}this._iSourceRowIndex=undefined;};B.prototype._restoreAppDefaultsColumnHeaderSortFilter=function(){var a=this.getColumns();q.each(a,function(i,b){b._restoreAppDefaults();});};B.prototype._setBusy=function(a){var b,i,j;if(!this.getEnableBusyIndicator()||!this._bBusyIndicatorAllowed){return;}b=this.getBinding("rows");if(!b){return;}this.setBusy(false);if(a&&this._iDataRequestedCounter>0){var l=a.reason;if(a.contexts&&a.contexts.length!==undefined){j=false;for(i=0;i<a.contexts.length;i++){if(a.contexts[i]===undefined){j=true;break;}}}else if(a.changeReason===g.Expand){this.setBusy(true);}var L=b.getLength();if((l==g.Expand&&this._iDataRequestedCounter!==0)||j||(b.isInitial())||(a.receivedLength===0&&this._iDataRequestedCounter!==0)||(a.receivedLength<a.requestedLength&&a.receivedLength!==L&&a.receivedLength!==L-this.getFirstVisibleRow())){this.setBusy(true);}}};B.prototype.setBusy=function(b,a){var i=this.getBusy()!=b;a="sapUiTableCnt";var j=C.prototype.setBusy.call(this,b,a);if(i){this.fireBusyStateChanged({busy:b});}return j;};B.prototype.setEnableBusyIndicator=function(b){this.setProperty("enableBusyIndicator",b,true);};B.prototype._attachDataRequestedListeners=function(){var b=this.getBinding("rows");if(b){b.detachDataRequested(this._onBindingDataRequestedListener,this);b.detachDataReceived(this._onBindingDataReceivedListener,this);this._iDataRequestedCounter=0;b.attachDataRequested(this._onBindingDataRequestedListener,this);b.attachDataReceived(this._onBindingDataReceivedListener,this);}};B.prototype._onBindingDataRequestedListener=function(a){if(a.getSource()==this.getBinding("rows")&&!a.getParameter("__simulateAsyncAnalyticalBinding")){this._iDataRequestedCounter++;}};B.prototype._onBindingDataReceivedListener=function(a){if(a.getSource()==this.getBinding("rows")&&!a.getParameter("__simulateAsyncAnalyticalBinding")){this._iDataRequestedCounter--;}};B.prototype._attachBindingListener=function(){this._attachDataRequestedListeners();};B.prototype._setLargeDataScrolling=function(l){this._bLargeDataScrolling=!!l;};B.prototype._getSelectedIndicesCount=function(){return this.getSelectedIndices().length;};B.prototype._updateTableContent=function(){if(T.Grouping.isGroupMode(this)){var b=this.getBinding("rows"),a=this.getRows(),i=a.length;if(b){var j,l,H,J;for(var K=0;K<i;K++){j=a[K];H=K+this.getFirstVisibleRow();J=!!b.isGroupHeader(H);l=J?b.getTitle(H):"";T.Grouping.updateTableRowForGrouping(this,j,J,J?!!b.isExpanded(H):false,J,false,J?0:1,l);}}else{for(var K=0;K<i;K++){T.Grouping.cleanupTableRowForGrouping(this,a[K]);}}}};return B;});};if(!jQuery.sap.isDeclared('sap.ui.table.TreeTable')){jQuery.sap.declare('sap.ui.table.TreeTable');jQuery.sap.require('jquery.sap.global');jQuery.sap.require('sap.ui.model.odata.ODataTreeBindingAdapter');jQuery.sap.require('sap.ui.model.ClientTreeBindingAdapter');jQuery.sap.require('sap.ui.model.TreeBindingCompatibilityAdapter');jQuery.sap.require('sap.ui.core.Element');sap.ui.define("sap/ui/table/TreeTable",['jquery.sap.global','./Table','sap/ui/model/odata/ODataTreeBindingAdapter','sap/ui/model/ClientTreeBindingAdapter','sap/ui/model/TreeBindingCompatibilityAdapter','./library','sap/ui/core/Element','./TableUtils'],function(q,T,O,C,a,l,E,b){"use strict";var c=T.extend("sap.ui.table.TreeTable",{metadata:{library:"sap.ui.table",properties:{expandFirstLevel:{type:"boolean",defaultValue:false},useGroupMode:{type:"boolean",group:"Appearance",defaultValue:false},groupHeaderProperty:{type:"string",group:"Data",defaultValue:null},collapseRecursive:{type:"boolean",defaultValue:true},rootLevel:{type:"int",group:"Data",defaultValue:0}},events:{toggleOpenState:{parameters:{rowIndex:{type:"int"},rowContext:{type:"object"},expanded:{type:"boolean"}}}}},renderer:"sap.ui.table.TableRenderer"});c.prototype.init=function(){T.prototype.init.apply(this,arguments);b.Grouping.setTreeMode(this);};c.prototype.bindRows=function(B,t,s,f){var p,o,s,f;if(typeof B=="string"){p=arguments[0];o=arguments[1];s=arguments[2];f=arguments[3];B={path:p,sorter:s,filters:f,template:o};}if(typeof B==="object"){B.parameters=B.parameters||{};B.parameters.rootLevel=this.getRootLevel();B.parameters.collapseRecursive=this.getCollapseRecursive();B.parameters.numberOfExpandedLevels=B.parameters.numberOfExpandedLevels||(this.getExpandFirstLevel()?1:0);B.parameters.rootNodeID=B.parameters.rootNodeID;}return this.bindAggregation("rows",B);};c.prototype.setSelectionMode=function(s){var B=this.getBinding("rows");if(B&&B.clearSelection){B.clearSelection();s=b.sanitizeSelectionMode(this,s);this.setProperty("selectionMode",s);}else{T.prototype.setSelectionMode.call(this,s);}return this;};c.prototype.refreshRows=function(r){T.prototype.refreshRows.apply(this,arguments);var B=this.getBinding("rows");if(B&&this.isTreeBinding("rows")&&!B.hasListeners("selectionChanged")){B.attachSelectionChanged(this._onSelectionChanged,this);}};c.prototype.setFixedRowCount=function(r){q.sap.log.warning("TreeTable: the property \"fixedRowCount\" is not supported and will be ignored!");return this;};c.prototype.isTreeBinding=function(n){n=n||"rows";if(n==="rows"){return true;}return E.prototype.isTreeBinding.apply(this,arguments);};c.prototype.getBinding=function(n){n=n||"rows";var B=E.prototype.getBinding.call(this,n);if(B&&n==="rows"&&!B.getLength){var d=sap.ui.require("sap/ui/model/odata/ODataTreeBinding");var V=sap.ui.require("sap/ui/model/odata/v2/ODataTreeBinding");var e=sap.ui.require("sap/ui/model/ClientTreeBinding");if(d&&B instanceof d){a(B,this);}else if(V&&B instanceof V){B.applyAdapterInterface();}else if(e&&B instanceof e){C.apply(B);}else{q.sap.log.error("Binding not supported by sap.ui.table.TreeTable");}}return B;};c.prototype._updateTableContent=function(){var B=this.getBinding("rows"),r=this.getRows(),i=r.length;if(B){var R=this.getBindingInfo("rows"),m=R&&R.model,o,g;for(var d=0;d<i;d++){o=r[d];g=b.Grouping.isGroupMode(this)&&this.getGroupHeaderProperty()?this.getModel(m).getProperty(this.getGroupHeaderProperty(),o.getBindingContext(m)):"";b.Grouping.updateTableRowForGrouping(this,o,o._bHasChildren,o._bIsExpanded,o._bHasChildren,false,o._iLevel,g);}}else{for(var d=0;d<i;d++){b.Grouping.cleanupTableRowForGrouping(this,r[d]);}}};c.prototype._updateTableCell=function(){return true;};c.prototype._getContexts=function(s,L,t){var B=this.getBinding("rows");if(B){return B.getNodes(s,L,t);}else{return[];}};c.prototype._onGroupHeaderChanged=function(r,e){this.fireToggleOpenState({rowIndex:r,rowContext:this.getContextByIndex(r),expanded:e});};c.prototype.expand=function(r){var B=this.getBinding("rows");if(B&&r>=0){B.expand(r);}return this;};c.prototype.collapse=function(r){var B=this.getBinding("rows");if(B&&r>=0){B.collapse(r);}return this;};c.prototype.collapseAll=function(){var B=this.getBinding("rows");if(B){B.collapseToLevel(0);this.setFirstVisibleRow(0);}return this;};c.prototype.expandToLevel=function(L){var B=this.getBinding("rows");if(B&&B.expandToLevel){B.expandToLevel(L);}return this;};c.prototype.isExpanded=function(r){var B=this.getBinding("rows");if(B){return B.isExpanded(r);}return false;};c.prototype.isIndexSelected=function(r){var B=this.getBinding("rows");if(B&&B.isIndexSelected){return B.isIndexSelected(r);}else{return T.prototype.isIndexSelected.call(this,r);}};c.prototype.setSelectedIndex=function(r){if(r===-1){this.clearSelection();}var B=this.getBinding("rows");if(B&&B.findNode&&B.setNodeSelection){B.setSelectedIndex(r);}else{T.prototype.setSelectedIndex.call(this,r);}return this;};c.prototype.getSelectedIndices=function(){var B=this.getBinding("rows");if(B&&B.findNode&&B.getSelectedIndices){return B.getSelectedIndices();}else{return T.prototype.getSelectedIndices.call(this);}};c.prototype.setSelectionInterval=function(f,t){var s=this.getSelectionMode();if(s===l.SelectionMode.None){return this;}var B=this.getBinding("rows");if(B&&B.findNode&&B.setSelectionInterval){if(s===l.SelectionMode.Single){B.setSelectionInterval(f,f);}else{B.setSelectionInterval(f,t);}}else{T.prototype.setSelectionInterval.call(this,f,t);}return this;};c.prototype.addSelectionInterval=function(f,t){var s=this.getSelectionMode();if(s===l.SelectionMode.None){return this;}var B=this.getBinding("rows");if(B&&B.findNode&&B.addSelectionInterval){if(s===l.SelectionMode.Single){B.setSelectionInterval(f,f);}else{B.addSelectionInterval(f,t);}}else{T.prototype.addSelectionInterval.call(this,f,t);}return this;};c.prototype.removeSelectionInterval=function(f,t){var B=this.getBinding("rows");if(B&&B.findNode&&B.removeSelectionInterval){B.removeSelectionInterval(f,t);}else{T.prototype.removeSelectionInterval.call(this,f,t);}return this;};c.prototype.selectAll=function(){var s=this.getSelectionMode();if(!this.getEnableSelectAll()||(s!="Multi"&&s!="MultiToggle")||!this._getSelectableRowCount()){return this;}var B=this.getBinding("rows");if(B.selectAll){this.$("selall").attr('title',this._oResBundle.getText("TBL_DESELECT_ALL")).removeClass("sapUiTableSelAll");B.selectAll();}else{T.prototype.selectAll.call(this);}return this;};c.prototype.getSelectedIndex=function(){var B=this.getBinding("rows");if(B&&B.findNode){return B.getSelectedIndex();}else{return T.prototype.getSelectedIndex.call(this);}};c.prototype.clearSelection=function(){var B=this.getBinding("rows");if(B&&B.clearSelection){B.clearSelection();}else{T.prototype.clearSelection.call(this);}return this;};c.prototype.getContextByIndex=function(r){var B=this.getBinding("rows");if(B){return B.getContextByIndex(r);}};c.prototype.setRootLevel=function(r){this.setFirstVisibleRow(0);var B=this.getBinding("rows");if(B){if(B.setRootLevel){B.setRootLevel(r);}}this.setProperty("rootLevel",r,true);return this;};c.prototype.setCollapseRecursive=function(d){var B=this.getBinding("rows");if(B){if(B.setCollapseRecursive){B.setCollapseRecursive(d);}}this.setProperty("collapseRecursive",!!d,true);return this;};c.prototype._getSelectedIndicesCount=function(){var s;var B=this.getBinding("rows");if(B&&B.findNode&&B.getSelectedNodesCount){return B.getSelectedNodesCount();}else{return T.prototype.getSelectedIndices.call(this);}return s;};c.prototype.setUseGroupMode=function(g){this.setProperty("useGroupMode",!!g);if(!!g){b.Grouping.setGroupMode(this);}else{b.Grouping.setTreeMode(this);}return this;};c.prototype.setEnableGrouping=function(e){q.sap.log.warning("The property enableGrouping is not supported by control sap.ui.table.TreeTable");return this;};return c;});};if(!jQuery.sap.isDeclared('sap.ui.table.TreeTableRenderer')){jQuery.sap.declare('sap.ui.table.TreeTableRenderer');sap.ui.define("sap/ui/table/TreeTableRenderer",['sap/ui/table/TreeTable'],function(T){"use strict";return T.getMetadata().getRenderer();},true);};if(!jQuery.sap.isDeclared('sap.ui.table.AnalyticalTable')){jQuery.sap.declare('sap.ui.table.AnalyticalTable');jQuery.sap.require('jquery.sap.global');jQuery.sap.require('sap.ui.model.analytics.ODataModelAdapter');jQuery.sap.require('sap.ui.model.SelectionModel');jQuery.sap.require('sap.ui.model.Sorter');jQuery.sap.require('sap.ui.base.ManagedObject');jQuery.sap.require('sap.ui.core.Popup');jQuery.sap.require('sap.ui.unified.Menu');jQuery.sap.require('sap.ui.unified.MenuItem');sap.ui.define("sap/ui/table/AnalyticalTable",['jquery.sap.global','./AnalyticalColumn','./Table','./TreeTable','./library','sap/ui/model/analytics/ODataModelAdapter','sap/ui/model/SelectionModel','sap/ui/model/Sorter','sap/ui/base/ManagedObject','sap/ui/core/Popup','sap/ui/unified/Menu','sap/ui/unified/MenuItem','./TableUtils'],function(q,A,T,a,b,O,S,c,M,P,d,e,f){"use strict";var G=b.GroupEventType,g=b.SelectionBehavior,h=b.SelectionMode,k=b.SortOrder;var m=T.extend("sap.ui.table.AnalyticalTable",{metadata:{library:"sap.ui.table",properties:{sumOnTop:{type:"boolean",group:"Appearance",defaultValue:false},numberOfExpandedLevels:{type:"int",group:"Misc",defaultValue:0},autoExpandMode:{type:"string",group:"Misc",defaultValue:"Bundled"},columnVisibilityMenuSorter:{type:"any",group:"Appearance",defaultValue:null},collapseRecursive:{type:"boolean",defaultValue:true},dirty:{type:"boolean",group:"Appearance",defaultValue:null,deprecated:true}},designTime:true},renderer:"sap.ui.table.TableRenderer"});m.prototype._getFixedBottomRowContexts=function(){var B=this.getBinding("rows");if(B){return[B.getGrandTotalNode()];}};m.prototype._getContexts=a.prototype._getContexts;m.prototype.init=function(){T.prototype.init.apply(this,arguments);this.addStyleClass("sapUiAnalyticalTable");this.attachBrowserEvent("contextmenu",this._onContextMenu);this.setSelectionMode(h.MultiToggle);this.setShowColumnVisibilityMenu(true);this.setEnableColumnFreeze(true);this.setEnableCellFilter(true);this._aGroupedColumns=[];this._bSuspendUpdateAnalyticalInfo=false;f.Grouping.setGroupMode(this);};m.prototype.setFixedRowCount=function(){q.sap.log.error("The property fixedRowCount is not supported by the AnalyticalTable and must not be set!");return this;};m.prototype.setFixedBottomRowCount=function(){q.sap.log.error("The property fixedBottomRowCount is managed by the AnalyticalTable and must not be set!");return this;};m.prototype.setDirty=function(D){q.sap.log.error("The property \"dirty\" is deprecated. Please use \"showOverlay\".");this.setProperty("dirty",D,true);this.setShowOverlay(this.getDirty());return this;};m.prototype.getModel=function(n){var o=T.prototype.getModel.apply(this,arguments);var r=this.getBindingInfo("rows");if(o&&r&&r.model==n){O.apply(o);}return o;};m.prototype._onBindingChange=function(E){T.prototype._onBindingChange.apply(this,arguments);var r=typeof(E)==="object"?E.getParameter("reason"):E;if(r!=="sort"){this._invalidateColumnMenus();}};m.prototype.bindRows=function(B){var o=this._sanitizeBindingInfo.apply(this,arguments);var r=this.bindAggregation("rows",o);this._updateTotalRow(true);return r;};m.prototype._bindAggregation=function(n,p,t,s,F){if(n==="rows"){this.setProperty("firstVisibleRow",0,true);this._sanitizeBindingInfo.call(this,p,t,s,F);}return T.prototype._bindAggregation.apply(this,arguments);};m.prototype._initSelectionModel=function(s){this._oSelection=new S(s);return this;};m.prototype.setSelectionMode=function(s){if(s===h.None){q.sap.log.fatal("SelectionMode 'None' is not supported by the AnalyticalTable.");return this;}var B=this.getBinding("rows");if(B&&B.clearSelection){B.clearSelection();}s=f.sanitizeSelectionMode(this,s);this.setProperty("selectionMode",s);return this;};m.prototype.setSelectionBehavior=function(B){if(B===g.RowOnly){q.sap.log.fatal("SelectionBehavior 'RowOnly' is not supported by the AnalyticalTable.");return this;}else{return T.prototype.setSelectionBehavior.apply(this,arguments);}};m.prototype._sanitizeBindingInfo=function(B){var p,t,s,F;if(typeof B=="string"){p=arguments[0];t=arguments[1];s=arguments[2];F=arguments[3];B={path:p,sorter:s,filters:F};if(t instanceof M){B.template=t;}else if(typeof t==="function"){B.factory=t;}}var C=this.getColumns();for(var i=0,l=C.length;i<l;i++){if(C[i].getSorted()){B.sorter=B.sorter||[];B.sorter.push(new c(C[i].getSortProperty()||C[i].getLeadingProperty(),C[i].getSortOrder()===k.Descending));}}B.parameters=B.parameters||{};B.parameters.analyticalInfo=this._getColumnInformation();B.parameters.sumOnTop=this.getSumOnTop();B.parameters.numberOfExpandedLevels=this.getNumberOfExpandedLevels();B.parameters.autoExpandMode=this.getAutoExpandMode();var o=this.getModel(B.model);if(o){O.apply(o);}return B;};m.prototype._setSuppressRefresh=function(s){this._bSupressRefresh=s;return this;};m.prototype._attachBindingListener=function(){var B=this.getBinding("rows");if(B&&!B.hasListeners("selectionChanged")){B.attachSelectionChanged(this._onSelectionChanged,this);}T.prototype._attachDataRequestedListeners.apply(this);};m.prototype._getColumnInformation=function(){var C=[],t=this.getColumns();for(var i=0;i<this._aGroupedColumns.length;i++){var o=sap.ui.getCore().byId(this._aGroupedColumns[i]);if(!o){continue;}C.push({name:o.getLeadingProperty(),visible:o.getVisible(),grouped:o.getGrouped(),total:o.getSummed(),sorted:o.getSorted(),sortOrder:o.getSortOrder(),inResult:o.getInResult(),formatter:o.getGroupHeaderFormatter()});}for(var i=0;i<t.length;i++){var o=t[i];if(q.inArray(o.getId(),this._aGroupedColumns)>-1){continue;}if(!o instanceof A){q.sap.log.error("You have to use AnalyticalColumns for the Analytical table");}C.push({name:o.getLeadingProperty(),visible:o.getVisible(),grouped:o.getGrouped(),total:o.getSummed(),sorted:o.getSorted(),sortOrder:o.getSortOrder(),inResult:o.getInResult(),formatter:o.getGroupHeaderFormatter()});}return C;};m.prototype._updateTableContent=function(){var B=this.getBinding("rows"),F=this.getFirstVisibleRow(),j=this.getFixedBottomRowCount(),C=this.getVisibleRowCount(),n=this.getColumns();var r=this.getRows();if(!B){for(var i=0;i<r.length;i++){f.Grouping.cleanupTableRowForGrouping(this,r[i]);}return;}for(var R=0,l=Math.min(C,r.length);R<l;R++){var I=R>(C-j-1)&&B.getLength()>C,o=I?(B.getLength()-1-(C-1-R)):F+R,p=r[R],$=p.$(),s=this.$().find("div[data-sap-ui-rowindex="+$.attr("data-sap-ui-rowindex")+"]");var t;if(I&&B.bProvideGrandTotals){t=B.getGrandTotalContextInfo();}else{t=this.getContextInfoByIndex(o);}var L=t?t.level:0;if(!t||!t.context){f.Grouping.cleanupTableRowForGrouping(this,p);if(t&&!t.context){$.addClass("sapUiAnalyticalTableDummy");s.addClass("sapUiAnalyticalTableDummy");}continue;}if(B.nodeHasChildren&&B.nodeHasChildren(t)){f.Grouping.updateTableRowForGrouping(this,p,true,t.nodeState.expanded,t.nodeState.expanded&&!this.getSumOnTop(),false,L,B.getGroupName(t.context,t.level));}else{f.Grouping.updateTableRowForGrouping(this,p,false,false,false,t.nodeState.sum,L,t.nodeState.sum&&t.level>0?B.getGroupName(t.context,t.level):null);}var u=p.getCells();for(var i=0,v=u.length;i<v;i++){var w=u[i].data("sap-ui-colindex");var x=n[w];var y=q(u[i].$().closest("td"));if(B.isMeasure(x.getLeadingProperty())){y.addClass("sapUiTableMeasureCell");y.toggleClass("sapUiTableCellHidden",t.nodeState.sum&&!x.getSummed());}else{y.removeClass("sapUiTableMeasureCell");}}}};m.prototype._onContextMenu=function(E){if(q(E.target).closest('tr').hasClass('sapUiTableGroupHeader')||q(E.target).closest('.sapUiTableRowHdr.sapUiTableGroupHeader').length>0){this._iGroupedLevel=q(E.target).closest('[data-sap-ui-level]').data('sap-ui-level');var o=this._getGroupHeaderMenu();var i=P.Dock;var l=E.pageX||E.clientX;var L=E.pageY||E.clientY;o.open(false,E.target,i.LeftTop,i.LeftTop,document,(l-2)+" "+(L-2));E.preventDefault();E.stopPropagation();return;}return true;};m.prototype._getGroupHeaderMenu=function(){var t=this;function j(){var i=t._iGroupedLevel-1;if(t._aGroupedColumns[i]){var l=t.getColumns().filter(function(C){if(t._aGroupedColumns[i]==C.getId()){return true;}})[0];return{column:l,index:i};}else{return undefined;}}if(!this._oGroupHeaderMenu){this._oGroupHeaderMenu=new d();this._oGroupHeaderMenuVisibilityItem=new e({text:this._oResBundle.getText("TBL_SHOW_COLUMN"),select:function(){var o=j();if(o){var C=o.column,s=C.getShowIfGrouped();C.setShowIfGrouped(!s);t.fireGroup({column:C,groupedColumns:C.getParent()._aGroupedColumns,type:(!s?G.showGroupedColumn:G.hideGroupedColumn)});}}});this._oGroupHeaderMenu.addItem(this._oGroupHeaderMenuVisibilityItem);this._oGroupHeaderMenu.addItem(new e({text:this._oResBundle.getText("TBL_UNGROUP"),select:function(){var l=t.getColumns(),F=0,L=-1,u=-1,C;for(var i=0;i<l.length;i++){C=l[i];if(C.getGrouped()){F++;if(F==t._iGroupedLevel){C._bSkipUpdateAI=true;var B=t.getBinding("rows");B.setNumberOfExpandedLevels(0);C.setGrouped(false);C._bSkipUpdateAI=false;u=i;t.fireGroup({column:C,groupedColumns:C.getParent()._aGroupedColumns,type:G.ungroup});}else{L=i;}}}if(L>-1&&u>-1&&u<L){var U=l[u];var H=U.getHeaderSpan();if(q.isArray(H)){H=H[0];}var r=[];for(var i=u;i<u+H;i++){r.push(l[i]);}q.each(r,function(I,C){t.removeColumn(C);t.insertColumn(C,L);});}t._updateColumns();t._getRowContexts();}}));this._oGroupHeaderMenu.addItem(new e({text:this._oResBundle.getText("TBL_UNGROUP_ALL"),select:function(){var l=t.getColumns();for(var i=0;i<l.length;i++){l[i]._bSkipUpdateAI=true;var B=t.getBinding("rows");B.setNumberOfExpandedLevels(0);l[i].setGrouped(false);l[i]._bSkipUpdateAI=false;}t._bSupressRefresh=true;t._updateColumns();t._getRowContexts();t._bSupressRefresh=false;t.fireGroup({column:undefined,groupedColumns:[],type:G.ungroupAll});}}));this._oGroupHeaderMoveUpItem=new e({text:this._oResBundle.getText("TBL_MOVE_UP"),select:function(){var o=j();if(o){var C=o.column;var i=q.inArray(C.getId(),t._aGroupedColumns);if(i>0){t._aGroupedColumns[i]=t._aGroupedColumns.splice(i-1,1,t._aGroupedColumns[i])[0];t.updateAnalyticalInfo();t.fireGroup({column:C,groupedColumns:C.getParent()._aGroupedColumns,type:G.moveUp});}}},icon:"sap-icon://arrow-top"});this._oGroupHeaderMenu.addItem(this._oGroupHeaderMoveUpItem);this._oGroupHeaderMoveDownItem=new e({text:this._oResBundle.getText("TBL_MOVE_DOWN"),select:function(){var o=j();if(o){var C=o.column;var i=q.inArray(C.getId(),t._aGroupedColumns);if(i<t._aGroupedColumns.length){t._aGroupedColumns[i]=t._aGroupedColumns.splice(i+1,1,t._aGroupedColumns[i])[0];t.updateAnalyticalInfo();t.fireGroup({column:C,groupedColumns:C.getParent()._aGroupedColumns,type:G.moveDown});}}},icon:"sap-icon://arrow-bottom"});this._oGroupHeaderMenu.addItem(this._oGroupHeaderMoveDownItem);this._oGroupHeaderMenu.addItem(new e({text:this._oResBundle.getText("TBL_SORT_ASC"),select:function(){var o=j();if(o){var C=o.column;C.sort(false);}},icon:"sap-icon://up"}));this._oGroupHeaderMenu.addItem(new e({text:this._oResBundle.getText("TBL_SORT_DESC"),select:function(){var o=j();if(o){var C=o.column;C.sort(true);}},icon:"sap-icon://down"}));this._oGroupHeaderMenu.addItem(new e({text:this._oResBundle.getText("TBL_COLLAPSE_LEVEL"),select:function(){t.getBinding("rows").collapseToLevel(t._iGroupedLevel-1);t.setFirstVisibleRow(0);t.clearSelection();}}));this._oGroupHeaderMenu.addItem(new e({text:this._oResBundle.getText("TBL_COLLAPSE_ALL"),select:function(){t.getBinding("rows").collapseToLevel(0);t.setFirstVisibleRow(0);t.clearSelection();}}));}var o=j();if(o){var C=o.column;if(C.getShowIfGrouped()){this._oGroupHeaderMenuVisibilityItem.setText(this._oResBundle.getText("TBL_HIDE_COLUMN"));}else{this._oGroupHeaderMenuVisibilityItem.setText(this._oResBundle.getText("TBL_SHOW_COLUMN"));}this._oGroupHeaderMoveUpItem.setEnabled(o.index>0);this._oGroupHeaderMoveDownItem.setEnabled(o.index<this._aGroupedColumns.length-1);}else{this._oGroupHeaderMoveUpItem.setEnabled(true);this._oGroupHeaderMoveDownItem.setEnabled(true);}return this._oGroupHeaderMenu;};m.prototype.expand=function(r){var B=this.getBinding("rows");if(B){B.expand(r);}};m.prototype.collapse=function(r){var B=this.getBinding("rows");if(B){B.collapse(r);}};m.prototype.collapseAll=function(){var B=this.getBinding("rows");if(B){B.collapseToLevel(0);this.setFirstVisibleRow(0);}return this;};m.prototype.isExpanded=function(r){var B=this.getBinding("rows");if(B){return B.isExpanded(r);}return false;};m.prototype.getContextByIndex=function(i){var B=this.getBinding("rows");return i>=0&&B?B.getContextByIndex(i):null;};m.prototype.getContextInfoByIndex=function(i){var B=this.getBinding("rows");return i>=0&&B?B.getNodeByIndex(i):null;};m.prototype.suspendUpdateAnalyticalInfo=function(){this._bSuspendUpdateAnalyticalInfo=true;};m.prototype.resumeUpdateAnalyticalInfo=function(s,F){this._bSuspendUpdateAnalyticalInfo=false;this._updateColumns(s,(F===false?false:true));};m.prototype.addColumn=function(C,s){var o=this._getColumn(C);if(o.getGrouped()){this._addGroupedColumn(o.getId());}T.prototype.addColumn.call(this,o,s);this._updateColumns(s);return this;};m.prototype.insertColumn=function(C,i,s){var o=this._getColumn(C);if(o.getGrouped()){this._addGroupedColumn(o.getId());}T.prototype.insertColumn.call(this,o,i,s);this._updateColumns(s);return this;};m.prototype.removeColumn=function(C,s){var r=T.prototype.removeColumn.apply(this,arguments);if(!this._iNewColPos){this._aGroupedColumns=q.grep(this._aGroupedColumns,function(v){if(C.getId){return v!=C.getId();}else{return v==C;}});}this.updateAnalyticalInfo(s);return r;};m.prototype.removeAllColumns=function(s){this._aGroupedColumns=[];var r=T.prototype.removeAllColumns.apply(this,arguments);this._updateColumns(s);return r;};m.prototype._getColumn=function(C){if(typeof C==="string"){var o=new A({leadingProperty:C,template:C,managed:true});return o;}else if(C instanceof A){return C;}else{throw new Error("Wrong column type. You need to define a string (property) or pass an AnalyticalColumnObject");}};m.prototype._updateColumns=function(s,F){if(!this._bSuspendUpdateAnalyticalInfo){this._updateTableColumnDetails();this.updateAnalyticalInfo(s,F);}};m.prototype.updateAnalyticalInfo=function(s,F){if(this._bSuspendUpdateAnalyticalInfo){return;}var B=this.getBinding("rows");if(B){var C=this._getColumnInformation();B.updateAnalyticalInfo(C,F);this._updateTotalRow(s);if(F&&this._bBusyIndicatorAllowed&&this.getEnableBusyIndicator()==true){this.setBusy(true);}}};m.prototype.refreshRows=function(){sap.ui.table.Table.prototype.refreshRows.apply(this,arguments);this._updateTotalRow();};m.prototype._updateTotalRow=function(s){var B=this.getBinding("rows");var F=this.getFixedBottomRowCount();if(B&&(B.providesGrandTotal()&&B.hasTotaledMeasures())){if(F!==1){this.setProperty("fixedBottomRowCount",1,s);}}else{if(F!==0){this.setProperty("fixedBottomRowCount",0,s);}}};m.prototype._updateTableColumnDetails=function(){if(this._bSuspendUpdateAnalyticalInfo){return;}var B=this.getBinding("rows"),r=B&&B.getAnalyticalQueryResult();if(r){var C=this.getColumns(),l=[],u=[],D=[],n={},p,t;for(var i=0;i<C.length;i++){p=C[i];p._isLastGroupableLeft=false;p._bLastGroupAndGrouped=false;p._bDependendGrouped=false;if(!p.getVisible()){continue;}var L=p.getLeadingProperty();t=r.findDimensionByPropertyName(L);if(t){var v=t.getName();if(!n[v]){n[v]={dimension:t,columns:[p]};}else{n[v].columns.push(p);}if(p.getGrouped()&&q.inArray(v,l)==-1){l.push(v);}if(q.inArray(v,D)==-1){D.push(v);}}}u=q.grep(D,function(s){return(q.inArray(s,l)==-1);});if(l.length>0){q.each(l,function(i,s){q.each(n[s].columns,function(j,o){if(!o.getGrouped()){o._bDependendGrouped=true;}});});if(l.length==D.length){t=r.findDimensionByPropertyName(sap.ui.getCore().byId(this._aGroupedColumns[this._aGroupedColumns.length-1]).getLeadingProperty());var w=n[t.getName()].columns;q.each(w,function(i,o){o._bLastGroupAndGrouped=true;});}}if(u.length==1){q.each(n[u[0]].columns,function(j,o){o._isLastGroupableLeft=true;});}}};m.prototype._getFirstMeasureColumnIndex=function(){var B=this.getBinding("rows"),r=B&&B.getAnalyticalQueryResult(),C=this._getVisibleColumns();if(!r){return-1;}for(var i=0;i<C.length;i++){var o=C[i],l=o.getLeadingProperty();if(r.findMeasureByName(l)||r.findMeasureByPropertyName(l)){return i;}}};m.prototype.getTotalSize=function(){var B=this.getBinding("rows");if(B){return B.getTotalSize();}return 0;};m.prototype._onPersoApplied=function(){T.prototype._onPersoApplied.apply(this,arguments);this._aGroupedColumns=[];var C=this.getColumns();for(var i=0,l=C.length;i<l;i++){if(C[i].getGrouped()){this._addGroupedColumn(C[i].getId());}}this._updateColumns();};m.prototype._addGroupedColumn=function(C){if(q.inArray(C,this._aGroupedColumns)<0){this._aGroupedColumns.push(C);}};m.prototype.getGroupedColumns=function(){return this._aGroupedColumns;};m.prototype.setCollapseRecursive=function(C){var B=this.getBinding("rows");if(B){if(B.setCollapseRecursive){B.setCollapseRecursive(C);}}this.setProperty("collapseRecursive",!!C,true);return this;};m.prototype._getSelectableRowCount=function(){var B=this.getBinding("rows");if(B){var r=B.getGrandTotalContextInfo();return r?r.numberOfLeafs:0;}};m.prototype.isIndexSelected=function(r){return a.prototype.isIndexSelected.call(this,r);};m.prototype.setSelectedIndex=function(r){return a.prototype.setSelectedIndex.call(this,r);};m.prototype.getSelectedIndices=function(){return a.prototype.getSelectedIndices.call(this);};m.prototype.setSelectionInterval=function(F,t){return a.prototype.setSelectionInterval.call(this,F,t);};m.prototype.addSelectionInterval=function(F,t){return a.prototype.addSelectionInterval.call(this,F,t);};m.prototype.removeSelectionInterval=function(F,t){return a.prototype.removeSelectionInterval.call(this,F,t);};m.prototype.selectAll=function(){return a.prototype.selectAll.call(this);};m.prototype.getSelectedIndex=function(){return a.prototype.getSelectedIndex.call(this);};m.prototype.clearSelection=function(){return a.prototype.clearSelection.call(this);};m.prototype._isRowSelectable=function(r){var B=this.getBinding("rows");if(B){return B.isIndexSelectable(r);}else{return false;}};m.prototype._getSelectedIndicesCount=a.prototype._getSelectedIndicesCount;m.prototype.setEnableGrouping=function(E){q.sap.log.warning("The property enableGrouping is not supported by control sap.ui.table.AnalyticalTable");return this;};return m;});};if(!jQuery.sap.isDeclared('sap.ui.table.AnalyticalTableRenderer')){jQuery.sap.declare('sap.ui.table.AnalyticalTableRenderer');sap.ui.define("sap/ui/table/AnalyticalTableRenderer",['sap/ui/table/AnalyticalTable'],function(T){"use strict";return T.getMetadata().getRenderer();},true);};
