/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.require("sap.ui.thirdparty.qunit");sap.ui.define(["jquery.sap.global","sap/ui/base/Object","sap/ui/test/opaQunit","sap/ui/test/Opa5","sap/ui/test/gherkin/GherkinTestGenerator","sap/ui/test/gherkin/dataTableUtils","sap/ui/test/gherkin/StepDefinitions","sap/ui/qunit/qunit-css","sap/ui/qunit/qunit-junit","sap/ui/qunit/qunit-coverage"],function($,UI5Object,opaTest,Opa5,GherkinTestGenerator,dataTableUtils,StepDefinitions){"use strict";var opa5TestHarness={test:function(args){if($.type(args)!=="object"){throw new Error("opa5TestHarness.test: input all arguments via a single object");}if($.type(args.featurePath)!=="string"){throw new Error("opa5TestHarness.test: parameter 'featurePath' must be a valid string");}if(args.steps&&($.type(args.steps)!=="function")){throw new Error("opa5TestHarness.test: if specified, parameter 'steps' must be a valid StepDefinitions constructor");}if(!args.steps&&(args.generateMissingSteps!==true)){throw new Error("opa5TestHarness.test: if parameter 'generateMissingSteps' is not true then parameter 'steps' must be a valid StepDefinitions constructor");}if(args.generateMissingSteps&&($.type(args.generateMissingSteps)!=="boolean")){throw new Error("opa5TestHarness.test: if specified, parameter 'generateMissingSteps' must be a valid boolean");}var fnAlternateTestStepGenerator=function(oStep){var sToEval=oStep.keyword+".";var sFinalFunction=oStep.text;var aMatch=oStep.text.match(/(.*?)\s*:\s*(.*)/);if(aMatch){sToEval+=dataTableUtils.normalization.camelCase(aMatch[1])+".";sFinalFunction=aMatch[2];}sToEval+=dataTableUtils.normalization.camelCase(sFinalFunction)+"();";return{isMatch:true,text:oStep.text,regex:/Generated Step/,parameters:[],func:function(Given,When,Then){$.sap.log.info("[GHERKIN] Generated Step: "+sToEval);eval(sToEval);}};};if(!args.steps){args.steps=StepDefinitions;}var fnTestStepGenerator=(args.generateMissingSteps)?fnAlternateTestStepGenerator:null;var oTestGenerator=new GherkinTestGenerator(args.featurePath,args.steps,fnTestStepGenerator);var oFeatureTest=oTestGenerator.generate();var oOpa5=new Opa5();QUnit.module(oFeatureTest.name,{setup:function(){oTestGenerator.setUp();},teardown:function(){oOpa5.iTeardownMyApp();if($("#frame-close-link").length===0){$("#qunit-header").append('<input id="frame-close-link" type="button"'+'onclick="sap.ui.test.Opa5.emptyQueue(); $(\'#frame-close-link\').remove();" style="float: right; '+'margin-right: 0.5em; margin-top: -0.4em;" value="Close &#13;&#10;Frame"></input>');}oTestGenerator.tearDown();}});$.sap.log.info("[GHERKIN] Running feature: '"+oFeatureTest.name+"'");oFeatureTest.testScenarios.forEach(function(t){var T=(!t.wip)?opaTest:QUnit.skip;T(t.name,function(G,W,a){$.sap.log.info("[GHERKIN] Running scenario: '"+t.name+"'");t.testSteps.forEach(function(o){oOpa5.waitFor({viewName:"",success:function(){$.sap.log.info("[GHERKIN] Running step: text='"+o.text+"' regex='"+o.regex+"'");Opa5.assert.ok(o.isMatch,o.text);if(o.isMatch){QUnit.config.current.assertions.pop();}o.parameters=(o.parameters||[]).concat([G,W,a]);oTestGenerator.execute(o);}});});});});}};return opa5TestHarness;},true);
