/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/commons/MenuButton','sap/ui/core/Control','sap/ui/core/theming/Parameters','./Feeder','./library'],function(q,M,C,P,F,l){"use strict";var a=C.extend("sap.ui.ux3.FeedChunk",{metadata:{library:"sap.ui.ux3",properties:{thumbnailSrc:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},text:{type:"string",group:"Data",defaultValue:null},sender:{type:"string",group:"Data",defaultValue:null},timestamp:{type:"string",group:"Data",defaultValue:null},deletionAllowed:{type:"boolean",group:"Behavior",defaultValue:false},commentChunk:{type:"boolean",group:"Appearance",defaultValue:false,deprecated:true},feederThumbnailSrc:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},feederSender:{type:"string",group:"Data",defaultValue:null},flagged:{type:"boolean",group:"Data",defaultValue:false},favorite:{type:"boolean",group:"Data",defaultValue:null},shared:{type:"boolean",group:"Data",defaultValue:false},enableFlag:{type:"boolean",group:"Appearance",defaultValue:true},enableShare:{type:"boolean",group:"Appearance",defaultValue:true},enableComment:{type:"boolean",group:"Appearance",defaultValue:true},enableInspect:{type:"boolean",group:"Appearance",defaultValue:true},enableFavorite:{type:"boolean",group:"Appearance",defaultValue:true}},aggregations:{comments:{type:"sap.ui.ux3.FeedChunk",multiple:true,singularName:"comment",bindable:"bindable"},actionMenuItems:{type:"sap.ui.commons.MenuItem",multiple:true,singularName:"actionMenuItem",bindable:"bindable"}},events:{deleted:{},commentAdded:{parameters:{comment:{type:"sap.ui.ux3.FeedChunk"}}},toggleFlagged:{parameters:{flagged:{type:"boolean"}}},senderClicked:{},referenceClicked:{parameters:{text:{type:"string"}}},toggleFavorite:{parameters:{favorite:{type:"boolean"}}},inspect:{},toggleShared:{parameters:{shareed:{type:"boolean"}}},actionItemSelected:{parameters:{itemId:{type:"string"},item:{type:"sap.ui.unified.MenuItemBase"}}}}}});a.prototype.init=function(){this.maxComments=2;this.allComments=false;this.rb=sap.ui.getCore().getLibraryResourceBundle("sap.ui.ux3");this.expanded=false;};a.prototype.initCommentFeeder=function(){if(!this.oCommentFeeder){this.oCommentFeeder=new F(this.getId()+'-CommentFeeder',{type:sap.ui.ux3.FeederType.Comment}).setParent(this);this.oCommentFeeder.attachEvent('submit',this.handleCommentFeederSubmit,this);this.showCommentFeeder=true;}};a.prototype.initToolsButton=function(){if(!this.oToolsButton){this.oToolsButton=new M(this.getId()+'-toolsButton',{tooltip:this.rb.getText('FEED_TOOLS'),lite:true,menu:new sap.ui.commons.Menu(this.getId()+'-toolsMenu')}).setParent(this);this.oToolsButton.attachEvent('itemSelected',this.handleToolsButtonSelected,this);var i=P._getThemeImage('ssapUiFeedToolsIconUrl');var I=P._getThemeImage('sapUiFeedToolsIconHoverUrl');if(i){this.oToolsButton.setProperty('icon',i,true);}if(I){this.oToolsButton.setProperty('iconHovered',I,true);}}};a.prototype.exit=function(){if(this.oCommentFeeder){this.oCommentFeeder.destroy();delete this.oCommentFeeder;}if(this.oToolsButton){this.oToolsButton.destroy();delete this.oToolsButton;}this.rb=undefined;this.showCommentFeeder=undefined;this.expanded=undefined;this.oText=undefined;if(this.oHCMMenuButton){this.oHCMMenuButton.destroy();delete this.oHCMMenuButton;}};a.prototype.onAfterRendering=function(){this.oText=this.$().children(".sapUiFeedChunkText").get(0);if(this.oText.clientHeight<this.oText.scrollHeight){var f=this.$().children(".sapUiFeedChunkByline").get(0);q(f).append(sap.ui.ux3.FeedChunkRenderer.renderExpander(this));if(this.expanded){q(this.oText).css('height','auto');}}};a.prototype.onclick=function(e){var t=e.target.getAttribute('ID');if(t){switch(t){case(this.getId()+'-delete'):this.fireDeleted();break;case(this.getId()+'-sender'):this.fireSenderClicked();break;case(this.getId()+'-thumb'):this.fireSenderClicked();break;case(this.getId()+'-exp'):var n='';if(this.expanded){q(this.oText).css('height','');n=this.rb.getText("FEED_EXPAND");this.expanded=false;}else{q(this.oText).css('height','auto');n=this.rb.getText("FEED_COLLAPSE");this.expanded=true;}q.sap.byId(t).attr('title',n).toggleClass('sapUiFeedChunkExpand sapUiFeedChunkCollapse');break;case(this.getId()+'-all'):this.showAllComments();break;case(this.getId()+'-ActComment'):if(!this.showCommentFeeder){this.initCommentFeeder();this.rerender();}break;case(this.getId()+'-ActFlag'):this.setFlagged(!this.getFlagged());this.fireToggleFlagged({flagged:this.getFlagged()});break;case(this.getId()+'-ActFavorite'):this.setFavorite(!this.getFavorite());this.fireToggleFavorite({favorite:this.getFavorite()});break;case(this.getId()+'-ActInspect'):this.fireInspect();break;case(this.getId()+'-ActShare'):this.setShared(!this.getShared());this.fireToggleShared({shared:this.getShared()});break;default:if(t.search(this.getId()+'-Ref')!=-1){this.fireReferenceClicked({text:q(e.target).text()});}break;}}e.stopPropagation();};a.prototype.showAllComments=function(){this.allComments=!this.allComments;var $=q.sap.byId(this.getId()+" > section");if($.length>0){var r=sap.ui.getCore().createRenderManager();this.getRenderer().renderComments(r,this);r.flush($[0]);r.destroy();}};a.prototype.handleCommentFeederSubmit=function(e){var d=new Date();var D=String(d);var n=new a(this.getId()+'-new-'+this.getComments().length,{text:e.getParameter('text'),commentChunk:true,deletionAllowed:true,timestamp:D,sender:this.getFeederSender(),thumbnailSrc:this.getFeederThumbnailSrc()});this.addComment(n);this.fireCommentAdded({comment:n});};a.prototype.handleToolsButtonSelected=function(e){if(e.getParameter('itemId')==this.getId()+'-actDelete'){this.fireDeleted();}else{this.fireActionItemSelected(e.mParameters);}};a.prototype.insertComment=function(c,i){this.insertAggregation("comments",c,i);this.initCommentFeeder();return this;};a.prototype.addComment=function(c){this.addAggregation("comments",c);this.initCommentFeeder();return this;};a.prototype.setDeletionAllowed=function(d){if(d==this.getDeletionAllowed()){return this;}this.setProperty("deletionAllowed",d);if(d){this.initToolsButton();this.oToolsButton.getMenu().insertItem(new sap.ui.commons.MenuItem(this.getId()+'-actDelete',{text:this.rb.getText('FEED_DELETE')}),0);}else{if(this.oToolsButton){this.oToolsButton.getMenu().removeItem(this.getId()+'-actDelete');}}return this;};a.prototype.getActionMenuItems=function(){if(this.oToolsButton){var i=this.oToolsButton.getMenu().getItems();if(i.length>0&&i[0].getId()==(this.getId()+'-actDelete')){i.shift();}return i;}};a.prototype.insertActionMenuItem=function(A,i){this.initToolsButton();var I=this.oToolsButton.getMenu().getItems();if(I.length>0&&I[0].getId()==(this.getId()+'-actDelete')){i++;}this.oToolsButton.getMenu().insertItem(A,i);return this;};a.prototype.addActionMenuItem=function(A){this.initToolsButton();this.oToolsButton.getMenu().addItem(A);return this;};a.prototype.removeActionMenuItem=function(A){if(this.oToolsButton){return this.oToolsButton.getMenu().removeItem(A);}};a.prototype.removeAllActionMenuItems=function(){if(this.oToolsButton){var I=this.oToolsButton.getMenu().getItems();if(I.length>0&&I[0].getId()==(this.getId()+'-actDelete')){I.shift();for(var i=0;i<I.length;i++){this.oToolsButton.getMenu().removeItem(I[i]);}return I;}else{return this.oToolsButton.getMenu().removeAllItems();}}};a.prototype.indexOfActionMenuItem=function(A){if(this.oToolsButton){var i=this.oToolsButton.getMenu().indexOfItem(A);var I=this.oToolsButton.getMenu().getItems();if(I.length>0&&I[0].getId()==(this.getId()+'-actDelete')){i--;}return i;}};a.prototype.destroyActionMenuItems=function(){if(this.oToolsButton){var i=this.oToolsButton.getMenu().getItems();if(i.length>0&&i[0].getId()==(this.getId()+'-actDelete')){this.removeAllActionMenuItems();}else{this.oToolsButton.getMenu().destroyItems();}}return this;};a.prototype.bindActionMenuItems=function(p,t,s,f){this.initToolsButton();this.oToolsButton.getMenu().bindItems(p,t,s,f);return this;};a.prototype.unbindActionMenuItems=function(){if(this.oToolsButton){this.oToolsButton.getMenu().unbindItems();}return this;};a.prototype.getFeederThumbnailSrc=function(){var t=this.getProperty("feederThumbnailSrc");if(!t||t==""){var p=this.getParent();if(p&&(p instanceof sap.ui.ux3.Feed||p instanceof a)){t=p.getFeederThumbnailSrc();}}return t;};a.prototype.getFeederSender=function(){var s=this.getProperty("feederSender");if(!s||s==""){var p=this.getParent();if(p&&(p instanceof sap.ui.ux3.Feed||p instanceof a)){s=p.getFeederSender();}}return s;};a.prototype.initHCMMenuButton=function(){if(!this.oHCMMenuButton){this.oHCMMenuButton=new M(this.getId()+"-HCMMenu",{lite:true}).setParent(this);this.oHCMMenuButton.attachEvent('itemSelected',this.handleHCMMenuButtonSelected,this);}};a.prototype.setHCMMenu=function(m){this.initHCMMenuButton();this.oHCMMenuButton.setMenu(m);return this;};a.prototype.handleHCMMenuButtonSelected=function(e){this.fireEvent("HCMMenuItemSelected",e.mParameters);};return a;},true);
