/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine('sap/f/DynamicPage',["jquery.sap.global","./library","sap/ui/core/Control","sap/ui/core/ScrollBar","sap/ui/core/ResizeHandler","sap/ui/core/delegate/ScrollEnablement","sap/ui/Device"],function(q,l,C,S,R,a,D){"use strict";
var b=C.extend("sap.f.DynamicPage",{metadata:{library:"sap.f",properties:{preserveHeaderStateOnScroll:{type:"boolean",group:"Behaviour",defaultValue:false},headerExpanded:{type:"boolean",group:"Behaviour",defaultValue:true},showFooter:{type:"boolean",group:"Behaviour",defaultValue:false}},aggregations:{title:{type:"sap.f.DynamicPageTitle",multiple:false},header:{type:"sap.f.DynamicPageHeader",multiple:false},content:{type:"sap.ui.core.Control",multiple:false},footer:{type:"sap.m.IBar",multiple:false},_scrollBar:{type:"sap.ui.core.ScrollBar",multiple:false,visibility:"hidden"}}}});
function e(o){if(arguments.length===1){return Array.isArray(o)?o.length>0:!!o;}return Array.prototype.slice.call(arguments).every(function(O){return e(O);});}
var u=sap.ui.getCore().getConfiguration().getAnimation();b.HEADER_MAX_ALLOWED_PINNED_PERCENTAGE=0.6;b.HEADER_MAX_ALLOWED_NON_SROLLABLE_PERCENTAGE=0.6;b.FOOTER_ANIMATION_DURATION=350;b.BREAK_POINTS={TABLET:1024,PHONE:600};b.EVENTS={TITLE_PRESS:"_titlePress",PIN_UNPIN_PRESS:"_pinUnpinPress"};b.MEDIA={INVISIBLE:"sapUiHidden",PHONE:"sapFDynamicPage-Std-Phone",TABLET:"sapFDynamicPage-Std-Tablet",DESKTOP:"sapFDynamicPage-Std-Desktop"};b.RESIZE_HANDLER_ID={PAGE:"_sResizeHandlerId",TITLE:"_sTitleResizeHandlerId",CONTENT:"_sContentResizeHandlerId"};
b.prototype.init=function(){this._bPinned=false;this._bHeaderInTitleArea=false;this._bExpandingWithAClick=false;this._headerBiggerThanAllowedHeight=false;this._oScrollHelper=new a(this,this.getId()+"-content",{horizontal:false,vertical:true});};
b.prototype.onBeforeRendering=function(){if(!this._preserveHeaderStateOnScroll()){this._attachPinPressHandler();}this._attachTitlePressHandler();this._detachScrollHandler();};
b.prototype.onAfterRendering=function(){if(this._preserveHeaderStateOnScroll()){q.sap.delayedCall(0,this,this._overridePreserveHeaderStateOnScroll);}this._bPinned=false;this._cacheDomElements();this._detachResizeHandlers();this._attachResizeHandlers();this._updateMedia(this._getWidth(this));this._attachScrollHandler();this._updateScrollBar();this._attachPageChildrenAfterRenderingDelegates();this._resetPinButtonState();};
b.prototype.exit=function(){this._detachResizeHandlers();if(this._oScrollHelper){this._oScrollHelper.destroy();}};
b.prototype.setShowFooter=function(s){var r=this.setProperty("showFooter",s,true);this._toggleFooter(s);return r;};
b.prototype.setHeaderExpanded=function(h){if(this.getHeaderExpanded()===h){return this;}this._titleExpandCollapseWhenAllowed();return this;};
b.prototype.setPreserveHeaderStateOnScroll=function(p){var r=this.setProperty("preserveHeaderStateOnScroll",p,false);if(p){this.setProperty("headerExpanded",true,true);}return r;};
b.prototype.getScrollDelegate=function(){return this._oScrollHelper;};
b.prototype._overridePreserveHeaderStateOnScroll=function(){if(!this._shouldOverridePreserveHeaderStateOnScroll()){this._headerBiggerThanAllowedHeight=false;return;}this._headerBiggerThanAllowedHeight=true;this._moveHeaderToContentArea();this._updateScrollBar();};
b.prototype._shouldOverridePreserveHeaderStateOnScroll=function(){return!D.system.desktop&&this._headerBiggerThanAllowedToBeFixed()&&this._preserveHeaderStateOnScroll();};
b.prototype._toggleFooter=function(s){var f=this.getFooter();if(!e(this.$())){return;}if(!e(f)){return;}f.toggleStyleClass("sapFDynamicPageActualFooterControlShow",s);f.toggleStyleClass("sapFDynamicPageActualFooterControlHide",!s);this._toggleFooterSpacer(s);if(u){if(!s){q.sap.delayedCall(b.FOOTER_ANIMATION_DURATION,this,function(){this.$footerWrapper.toggleClass("sapUiHidden",!this.getShowFooter());});}else{this.$footerWrapper.toggleClass("sapUiHidden",!this.getShowFooter());}q.sap.delayedCall(b.FOOTER_ANIMATION_DURATION,this,function(){f.removeStyleClass("sapFDynamicPageActualFooterControlShow");});}this._updateScrollBar();};
b.prototype._toggleFooterSpacer=function(t){var $=this.$("spacer");if(e($)){$.toggleClass("sapFDynamicPageContentWrapperSpacer",t);}if(e(this.$contentFitContainer)){this.$contentFitContainer.toggleClass("sapFDynamicPageContentFitContainerFooterVisible",t);}};
b.prototype._toggleHeader=function(){if(this._preserveHeaderStateOnScroll()){return;}if(this._shouldSnap()){this._snapHeader(true);this._updateHeaderARIAState(false);}else if(this._shouldExpand()){this._expandHeader();this._updateHeaderARIAState(true);}else if(!this._bPinned&&this._bHeaderInTitleArea){this._moveHeaderToContentArea();}};
b.prototype._snapHeader=function(A){var d=this.getTitle();if(this._bPinned){q.sap.log.debug("DynamicPage :: aborted snapping, header is pinned",this);return;}q.sap.log.debug("DynamicPage :: snapped header",this);if(e(d)){if(e(d.getExpandedContent())){d._setShowExpandContent(false);}if(e(d.getSnappedContent())){d._setShowSnapContent(true);}if(A){this._moveHeaderToContentArea();}}if(!e(this.$titleArea)){q.sap.log.warning("DynamicPage :: couldn't snap header. There's no title.",this);return;}this.setProperty("headerExpanded",false,true);this.$titleArea.addClass("sapFDynamicPageTitleSnapped");};
b.prototype._expandHeader=function(A){var d=this.getTitle();q.sap.log.debug("DynamicPage :: expand header",this);if(e(d)){if(e(d.getExpandedContent())){d._setShowExpandContent(true);}if(e(d.getSnappedContent())){d._setShowSnapContent(false);}if(A){this._moveHeaderToTitleArea();}}if(!e(this.$titleArea)){q.sap.log.warning("DynamicPage :: couldn't expand header. There's no title.",this);return;}this.setProperty("headerExpanded",true,true);this.$titleArea.removeClass("sapFDynamicPageTitleSnapped");};
b.prototype._toggleHeaderVisibility=function(s){var E=this.getHeaderExpanded(),d=this.getTitle(),o=this.getHeader();if(this._bPinned){q.sap.log.debug("DynamicPage :: header toggle aborted, header is pinned",this);return;}if(e(d)){d._setShowExpandContent(E);d._setShowSnapContent(!E);}if(e(o)){o.$().toggleClass("sapFDynamicPageHeaderHidden",!s);this._updateScrollBar();}};
b.prototype._moveHeaderToContentArea=function(){var d=this.getHeader();if(e(d)){d.$().prependTo(this.$wrapper);this._bHeaderInTitleArea=false;}};
b.prototype._moveHeaderToTitleArea=function(){var d=this.getHeader();if(e(d)){d.$().appendTo(this.$titleArea);this._bHeaderInTitleArea=true;}};
b.prototype._scrollToSnapHeader=function(){this._setScrollPosition(this._getSnappingHeight()+1);};
b.prototype._pin=function(){if(!this._bPinned){this._bPinned=true;this._moveHeaderToTitleArea();this._updateScrollBar();this._togglePinButtonARIAState(this._bPinned);}};
b.prototype._unPin=function(){if(this._bPinned){this._bPinned=false;this._togglePinButtonARIAState(this._bPinned);}};
b.prototype._togglePinButtonVisibility=function(t){var d=this.getHeader();if(e(d)){d._setShowPinBtn(t);}};
b.prototype._togglePinButtonPressedState=function(p){var d=this.getHeader();if(e(d)){d._togglePinButton(p);}};
b.prototype._togglePinButtonARIAState=function(p){var d=this.getHeader();if(e(d)){d._updateARIAPinButtonState(p);}};
b.prototype._resetPinButtonState=function(){if(this._preserveHeaderStateOnScroll()){this._togglePinButtonVisibility(false);}else{this._togglePinButtonPressedState(false);this._togglePinButtonARIAState(false);}};
b.prototype._restorePinButtonFocus=function(){this.getHeader()._focusPinButton();};
b.prototype._getScrollPosition=function(){if(D.system.desktop){return this._getScrollBar().getScrollPosition();}else{return this.$wrapper.scrollTop();}};
b.prototype._setScrollPosition=function(n){if(e(this.$wrapper)){this.$wrapper.scrollTop(n);D.system.desktop&&this._getScrollBar().setScrollPosition(n);}};
b.prototype._shouldSnap=function(){return!this._preserveHeaderStateOnScroll()&&this._getScrollPosition()>this._getSnappingHeight()&&this.getHeaderExpanded()&&!this._bPinned;};
b.prototype._shouldExpand=function(){return!this._preserveHeaderStateOnScroll()&&this._getScrollPosition()<this._getSnappingHeight()&&!this.getHeaderExpanded()&&!this._bPinned;};
b.prototype._headerScrolledOut=function(){return this._getScrollPosition()>this._getSnappingHeight();};
b.prototype._headerSnapAllowed=function(){return!this._preserveHeaderStateOnScroll()&&this.getHeaderExpanded()&&!this._bPinned;};
b.prototype._canSnapHeaderOnScroll=function(){return this._getMaxScrollPosition()>(this._getSnappingHeight()+1);};
b.prototype._getSnappingHeight=function(){return this._getHeaderHeight()||this._getTitleHeight();};
b.prototype._getMaxScrollPosition=function(){var $;if(e(this.$wrapper)){$=this.$wrapper[0];return $.scrollHeight-Math.ceil($.getBoundingClientRect().height);}return 0;};
b.prototype._needsVerticalScrollBar=function(){return this._getMaxScrollPosition()>0;};
b.prototype._getOwnHeight=function(){return this._getHeight(this);};
b.prototype._getEntireHeaderHeight=function(){var t=0,h=0,d=this.getTitle(),o=this.getHeader();if(e(d)){t=d.$().outerHeight();}if(e(o)){h=o.$().outerHeight();}return t+h;};
b.prototype._headerBiggerThanAllowedToExpandWithACommand=function(){return this._getEntireHeaderHeight()>this._getOwnHeight();};
b.prototype._headerBiggerThanAllowedToPin=function(c){if(!(typeof c==="number"&&!isNaN(parseInt(c,10)))){c=this._getOwnHeight();}return this._getEntireHeaderHeight()>b.HEADER_MAX_ALLOWED_PINNED_PERCENTAGE*c;};
b.prototype._headerBiggerThanAllowedToBeFixed=function(){var c=this._getOwnHeight();return this._getEntireHeaderHeight()>b.HEADER_MAX_ALLOWED_NON_SROLLABLE_PERCENTAGE*c;};
b.prototype._measureScrollBarOffsetHeight=function(){var h=0,s=!this.getHeaderExpanded();if(this._preserveHeaderStateOnScroll()||this._bPinned){h=this._getTitleAreaHeight();q.sap.log.debug("DynamicPage :: preserveHeaderState is enabled or header pinned :: title area height"+h,this);return h;}if(s||!e(this.getTitle())||!this._canSnapHeaderOnScroll()){h=this._getTitleHeight();q.sap.log.debug("DynamicPage :: header snapped :: title height "+h,this);return h;}this._snapHeader(true);h=this._getTitleHeight();if(this._shouldExpand()&&!s){this._expandHeader();}q.sap.log.debug("DynamicPage :: snapped mode :: title height "+h,this);return h;};
b.prototype._updateScrollBar=function(){var s,c;if(!D.system.desktop||!e(this.$wrapper)){return;}c=this._needsVerticalScrollBar();s=this._getScrollBar();s.setContentSize(this._measureScrollBarOffsetHeight()+this.$wrapper[0].scrollHeight+"px");s.toggleStyleClass("sapUiHidden",!c);this.toggleStyleClass("sapFDynamicPageWithScroll",c);q.sap.delayedCall(0,this,this._updateScrollBarOffset);q.sap.delayedCall(0,this,this._updateFitContainer);};
b.prototype._updateFitContainer=function(n){var t=typeof n!=='undefined'?!n:!this._needsVerticalScrollBar();this.$contentFitContainer.toggleClass("sapFDynamicPageContentFitContainer",t);};
b.prototype._updateScrollBarOffset=function(){var s=sap.ui.getCore().getConfiguration().getRTL()?"left":"right",o=this._needsVerticalScrollBar()?q.position.scrollbarWidth()+"px":0,f=this.getFooter();this.$titleArea.css("padding-"+s,o);if(e(f)){f.$().css(s,o);}};
b.prototype._updateHeaderARIAState=function(E){var d=this.getHeader();if(e(d)){d._updateARIAState(E);}};
b.prototype._updateMedia=function(w){if(w===0){this._updateMediaStyle(b.MEDIA.INVISIBLE);}else if(w<=b.BREAK_POINTS.PHONE){this._updateMediaStyle(b.MEDIA.PHONE);}else if(w<=b.BREAK_POINTS.TABLET){this._updateMediaStyle(b.MEDIA.TABLET);}else{this._updateMediaStyle(b.MEDIA.DESKTOP);}};
b.prototype._updateMediaStyle=function(c){Object.keys(b.MEDIA).forEach(function(m){var E=c===b.MEDIA[m];this.toggleStyleClass(b.MEDIA[m],E);},this);};
b.prototype._getHeight=function(c){return!(c instanceof C)?0:c.$().outerHeight()||0;};
b.prototype._getWidth=function(c){return!(c instanceof C)?0:c.$().outerWidth()||0;};
b.prototype._getTitleAreaHeight=function(){return e(this.$titleArea)?this.$titleArea.outerHeight()||0:0;};
b.prototype._getTitleHeight=function(){return this._getHeight(this.getTitle());};
b.prototype._getHeaderHeight=function(){return this._getHeight(this.getHeader());};
b.prototype._preserveHeaderStateOnScroll=function(){return this.getPreserveHeaderStateOnScroll()&&!this._headerBiggerThanAllowedHeight;};
b.prototype._getScrollBar=function(){if(!e(this.getAggregation("_scrollBar"))){var v=new S(this.getId()+"-vertSB",{vertical:true,size:"100%",scrollPosition:0,scroll:this._onScrollBarScroll.bind(this)});this.setAggregation("_scrollBar",v,true);}return this.getAggregation("_scrollBar");};
b.prototype._cacheDomElements=function(){var f=this.getFooter();if(e(f)){this.$footer=f.$();this.$footerWrapper=this.$("footerWrapper");}this.$wrapper=this.$("contentWrapper");this.$contentFitContainer=this.$("contentFitContainer");this.$titleArea=this.$("header");this._cacheTitleDom();};
b.prototype._cacheTitleDom=function(){var t=this.getTitle();if(e(t)){this.$title=t.$();}};
b.prototype.ontouchmove=function(E){E.setMarked();};
b.prototype._onChildControlAfterRendering=function(E){if(E.srcControl instanceof sap.f.DynamicPageTitle){this._cacheTitleDom();this._deRegisterResizeHandler(b.RESIZE_HANDLER_ID.TITLE);this._registerResizeHandler(b.RESIZE_HANDLER_ID.TITLE,this.$title[0],this._onChildControlsHeightChange.bind(this));}q.sap.delayedCall(0,this,this._updateScrollBar);};
b.prototype._onChildControlsHeightChange=function(E){var n=this._needsVerticalScrollBar();if(n){this._updateFitContainer(n);}if(E.size.height!==E.oldSize.height&&!this._bExpandingWithAClick){this._updateScrollBar();}this._bExpandingWithAClick=false;};
b.prototype._onResize=function(E){var d=this.getHeader();if(!this._preserveHeaderStateOnScroll()&&d){if(this._headerBiggerThanAllowedToPin(E.size.height)||D.system.phone){this._unPin();this._togglePinButtonVisibility(false);this._togglePinButtonPressedState(false);}else{this._togglePinButtonVisibility(true);}}this._updateScrollBar();this._updateMedia(E.size.width);};
b.prototype._onWrapperScroll=function(E){if(!D.system.desktop||!this._bExpandingWithAClick){this._toggleHeader();}if(D.system.desktop){if(this.allowCustomScroll===true&&E.target.scrollTop>0){this.allowCustomScroll=false;return;}this.allowInnerDiv=true;this._getScrollBar().setScrollPosition(E.target.scrollTop);this.toggleStyleClass("sapFDynamicPageWithScroll",this._needsVerticalScrollBar());}};
b.prototype._onScrollBarScroll=function(){this._toggleHeader();if(this.allowInnerDiv===true){this.allowInnerDiv=false;return;}this.allowCustomScroll=true;this.$wrapper.scrollTop(this._getScrollBar().getScrollPosition());};
b.prototype._titleExpandCollapseWhenAllowed=function(){if(this._headerBiggerThanAllowedToExpandWithACommand()){q.sap.log.warning("DynamicPage :: couldn't expand header. There isn't enough space for it to fit on the screen",this);return;}if(this._preserveHeaderStateOnScroll()||!this._needsVerticalScrollBar()){if(!this.getHeaderExpanded()){this._expandHeader(false);this._toggleHeaderVisibility(true);}else{this._snapHeader(false);this._toggleHeaderVisibility(false);}}else if(!this.getHeaderExpanded()){this._bExpandingWithAClick=true;this._expandHeader(true);}else if(this._headerSnapAllowed()){if(this._headerScrolledOut()){this._snapHeader(true);}else if(this._canSnapHeaderOnScroll()){this._scrollToSnapHeader();}else{q.sap.log.warning("DynamicPage :: couldn't snap header. There isn't enough content to be scrolled",this);}}};
b.prototype._onPinUnpinButtonPress=function(E){if(this._bPinned){this._unPin(E);}else{this._pin(E);this._restorePinButtonFocus();}};
b.prototype._attachResizeHandlers=function(){var c=this._onChildControlsHeightChange.bind(this);this._registerResizeHandler(b.RESIZE_HANDLER_ID.PAGE,this,this._onResize.bind(this));if(e(this.$title)){this._registerResizeHandler(b.RESIZE_HANDLER_ID.TITLE,this.$title[0],c);}if(e(this.$contentFitContainer)){this._registerResizeHandler(b.RESIZE_HANDLER_ID.CONTENT,this.$contentFitContainer[0],c);}};
b.prototype._registerResizeHandler=function(h,o,H){if(!this[h]){this[h]=R.register(o,H);}};
b.prototype._detachResizeHandlers=function(){this._deRegisterResizeHandler(b.RESIZE_HANDLER_ID.PAGE);this._deRegisterResizeHandler(b.RESIZE_HANDLER_ID.TITLE);this._deRegisterResizeHandler(b.RESIZE_HANDLER_ID.CONTENT);};
b.prototype._deRegisterResizeHandler=function(h){if(this[h]){R.deregister(this[h]);this[h]=null;}};
b.prototype._attachPageChildrenAfterRenderingDelegates=function(){var t=this.getTitle(),c=this.getContent(),p={onAfterRendering:this._onChildControlAfterRendering.bind(this)};if(e(t)){t.addEventDelegate(p);}if(e(c)){c.addEventDelegate(p);}};
b.prototype._attachTitlePressHandler=function(){var t=this.getTitle();if(e(t)&&!this._bAlreadyAttachedTitlePressHandler){t.attachEvent(b.EVENTS.TITLE_PRESS,this._titleExpandCollapseWhenAllowed,this);this._bAlreadyAttachedTitlePressHandler=true;}};
b.prototype._attachPinPressHandler=function(){var h=this.getHeader();if(e(h)&&!this._bAlreadyAttachedPinPressHandler){h.attachEvent(b.EVENTS.PIN_UNPIN_PRESS,this._onPinUnpinButtonPress,this);this._bAlreadyAttachedPinPressHandler=true;}};
b.prototype._attachScrollHandler=function(){this.$wrapper.on("scroll",this._onWrapperScroll.bind(this));};
b.prototype._detachScrollHandler=function(){if(this.$wrapper){this.$wrapper.unbind("scroll");}};
return b;},true);
sap.ui.predefine('sap/f/DynamicPageHeader',["jquery.sap.global","./library","sap/ui/core/Control","sap/ui/core/InvisibleText","sap/m/ButtonType","sap/m/ToggleButton"],function(q,l,C,I,B,T){"use strict";
var D=C.extend("sap.f.DynamicPageHeader",{metadata:{library:"sap.f",properties:{pinnable:{type:"boolean",group:"Appearance",defaultValue:true}},aggregations:{content:{type:"sap.ui.core.Control",multiple:true},_pinButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"}}}});
D._LIBRARY="sap.m";
D._getResourceBundle=function(){return sap.ui.getCore().getLibraryResourceBundle(D._LIBRARY);};
D.ARIA={ARIA_CONTROLS:"aria-controls",ARIA_EXPANDED:"aria-expanded",ARIA_LABEL:"aria-label",LABEL_EXPANDED:D._getResourceBundle().getText("EXPANDED_HEADER"),LABEL_SNAPPED:D._getResourceBundle().getText("SNAPPED_HEADER"),LABEL_PINNED:D._getResourceBundle().getText("PIN_HEADER"),LABEL_UNPINNED:D._getResourceBundle().getText("UNPIN_HEADER"),STATE_TRUE:"true",STATE_FALSE:"false"};
D.prototype.onAfterRendering=function(){this._initARIAState();this._initPinButtonARIAState();};
D.prototype._togglePinButton=function(v){this._getPinButton().setPressed(v);};
D.prototype._setShowPinBtn=function(v){this._getPinButton().$().toggleClass("sapUiHidden",!v);};
D.prototype._pinUnpinFireEvent=function(){this.fireEvent("_pinUnpinPress");};
D.prototype._initARIAState=function(){var $=this.$();$.attr(D.ARIA.ARIA_EXPANDED,D.ARIA.STATE_TRUE);$.attr(D.ARIA.ARIA_LABEL,D.ARIA.LABEL_EXPANDED);};
D.prototype._initPinButtonARIAState=function(){var $;if(this.getPinnable()){$=this._getPinButtonJQueryRef();$.attr(D.ARIA.ARIA_CONTROLS,this.getId());}};
D.prototype._updateARIAState=function(e){var $=this.$();if(e){$.attr(D.ARIA.ARIA_EXPANDED,D.ARIA.STATE_TRUE);$.attr(D.ARIA.ARIA_LABEL,D.ARIA.LABEL_EXPANDED);}else{$.attr(D.ARIA.ARIA_EXPANDED,D.ARIA.STATE_FALSE);$.attr(D.ARIA.ARIA_LABEL,D.ARIA.LABEL_SNAPPED);}};
D.prototype._updateARIAPinButtonState=function(p){var P=this._getPinButton();if(p){P.setTooltip(D.ARIA.LABEL_UNPINNED);}else{P.setTooltip(D.ARIA.LABEL_PINNED);}};
D.prototype._getPinButton=function(){if(!this.getAggregation("_pinButton")){var p=new T({id:this.getId()+"-pinBtn",icon:"sap-icon://pushpin-off",tooltip:D.ARIA.LABEL_PINNED,type:B.Transparent,press:this._pinUnpinFireEvent.bind(this)});this.setAggregation("_pinButton",p,true);}return this.getAggregation("_pinButton");};
D.prototype._focusPinButton=function(){this._getPinButtonJQueryRef().focus();};
D.prototype._getPinButtonJQueryRef=function(){return this._getPinButton().$();};
return D;},false);
sap.ui.predefine('sap/f/DynamicPageHeaderRenderer',[],function(){"use strict";var D={};
D.render=function(r,d){var c=d.getContent();r.write("<header");r.writeControlData(d);r.writeAccessibilityState({role:"region"});r.addClass("sapContrastPlus");r.addClass("sapFDynamicPageHeader");r.writeClasses();r.write(">");if(c.length>0){r.write("<div");r.addClass("sapFDynamicPageHeaderContent");r.writeClasses();r.write(">");c.forEach(r.renderControl);r.write("</div>");if(d.getPinnable()&&!sap.ui.Device.system.phone){D._renderPinUnpinArea(d,r);}}r.write("</header>");};
D._renderPinUnpinArea=function(d,r){r.write("<div");r.addClass("sapFDynamicPageHeaderPinButtonArea");r.writeClasses();r.write(">");r.renderControl(d._getPinButton());r.write("</div>");};
return D;},true);
sap.ui.predefine('sap/f/DynamicPageRenderer',["sap/ui/Device"],function(D){"use strict";var a={};
a.render=function(r,d){var o=d.getTitle(),b=d.getHeader(),c=d.getFooter(),e=d.getContent(),s=d.getShowFooter(),p=d._preserveHeaderStateOnScroll();r.write("<article");r.writeControlData(d);r.addClass("sapFDynamicPage");r.writeClasses();r.write(">");if(D.system.desktop){r.renderControl(d._getScrollBar().addStyleClass("sapFDynamicPageScrollBar"));}r.write("<header");r.writeAttributeEscaped("id",d.getId()+'-header');r.addClass("sapContrastPlus");r.addClass("sapFDynamicPageTitleWrapper");r.writeClasses();r.write(">");r.renderControl(o);if(p){r.renderControl(b);}r.write("</header>");r.write("<div");r.writeAttributeEscaped("id",d.getId()+'-contentWrapper');r.addClass("sapFDynamicPageContentWrapper");r.writeClasses();r.write(">");if(!p){r.renderControl(b);}r.write("<div");r.writeAttributeEscaped("id",d.getId()+'-content');r.addClass("sapFDynamicPageContent");r.writeClasses();r.write(">");r.write('<div');r.writeAttributeEscaped("id",d.getId()+'-contentFitContainer');r.addClass("sapFDynamicPageContentFitContainer");if(c&&s){r.addClass("sapFDynamicPageContentFitContainerFooterVisible");}r.writeClasses();r.write(">");r.renderControl(e);a.renderFooterSpacer(r,d,c,s);r.write("</div>");r.write("</div>");r.write("</div>");a.renderFooter(r,d,c,s);r.write("</article>");};
a.renderFooter=function(r,d,o,s){if(o){r.write("<footer");r.writeAttributeEscaped("id",d.getId()+'-footerWrapper');r.addClass("sapContrast sapContrastPlus sapFDynamicPageFooter sapFFooter-CTX");if(!s){r.addClass("sapUiHidden");}r.writeClasses();r.write(">");o.addStyleClass("sapFDynamicPageActualFooterControl");r.renderControl(o);r.write("</footer>");}};
a.renderFooterSpacer=function(r,d,o,s){if(o){r.write("<div");r.writeAttributeEscaped("id",d.getId()+'-spacer');if(s){r.addClass("sapFDynamicPageContentWrapperSpacer");}r.writeClasses();r.write(">");r.write("</div>");}};
return a;},true);
sap.ui.predefine('sap/f/DynamicPageTitle',["jquery.sap.global","./library","sap/ui/core/Control","sap/m/OverflowToolbar"],function(q,l,C,O){"use strict";
var D=C.extend("sap.f.DynamicPageTitle",{metadata:{library:"sap.f",aggregations:{heading:{type:"sap.ui.core.Control",multiple:false,defaultValue:null},actions:{type:"sap.ui.core.Control",multiple:true,singularName:"action"},snappedContent:{type:"sap.ui.core.Control",multiple:true},expandedContent:{type:"sap.ui.core.Control",multiple:true},_overflowToolbar:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}}}});
function i(o){return typeof o==="function";}
D.prototype.init=function(){this._bShowAdditionalContent=false;this._fnActionSubstituteParentFunction=function(){return this;}.bind(this);};
D.prototype.onBeforeRendering=function(){this._getOverflowToolbar();};
D.prototype.onAfterRendering=function(){this._cacheDomElements();this._setShowSnapContent(this._getShowSnapContent());this._setShowExpandContent(this._getShowExpandContent());};
D.prototype.ontap=function(e){if(e.srcControl===this||this.getAggregation("_overflowToolbar")===e.srcControl){this.fireEvent("_titlePress");}};
D.prototype._cacheDomElements=function(){this.$snappedWrapper=this.$("snapped-wrapper");this.$expandWrapper=this.$("expand-wrapper");};
D.prototype._getOverflowToolbar=function(){if(!this.getAggregation("_overflowToolbar")){this.setAggregation("_overflowToolbar",new O({id:this.getId()+"-overflowToolbar"}).addStyleClass("sapFDynamicPageTitleOverflowToolbar"));}return this.getAggregation("_overflowToolbar");};
D.prototype._preProcessAction=function(a){if(i(a._fnOriginalGetParent)){return;}a._fnOriginalGetParent=a.getParent;a.getParent=this._fnActionSubstituteParentFunction;};
D.prototype._postProcessAction=function(a){if(!i(a._fnOriginalGetParent)){return;}a.getParent=a._fnOriginalGetParent;};
["addAction","insertAction","removeAction","indexOfAction","removeAllActions","destroyActions","getActions"].forEach(function(m){D.prototype[m]=function(c){var t=this._getOverflowToolbar(),T=m.replace(/Actions?/,"Content"),r;if(m==="addAction"||m==="insertAction"){r=t[T].apply(t,arguments);this._preProcessAction(c);return r;}else if(m==="removeAction"){this._postProcessAction(c);}else if(m==="removeAllActions"||m==="destroyActions"){this.getActions().forEach(this._postProcessAction,this);}return t[T].apply(t,arguments);};});
D.prototype._setShowSnapContent=function(v){this._bShowAdditionalContent=v;this.$snappedWrapper.toggleClass("sapUiHidden",!v);this.$snappedWrapper.parent().toggleClass("sapFDynamicPageSnapContentVisible",v);};
D.prototype._getShowSnapContent=function(){return this._bShowAdditionalContent;};
D.prototype._setShowExpandContent=function(v){this._bShowExpandContent=v;this.$expandWrapper.toggleClass("sapUiHidden",!v);this.$snappedWrapper.parent().toggleClass("sapFDynamicPageExpandContentVisible",v);};
D.prototype._getShowExpandContent=function(){return this._bShowExpandContent;};
return D;},false);
sap.ui.predefine('sap/f/DynamicPageTitleRenderer',[],function(){"use strict";var D={};
D.render=function(r,d){var a=d._getOverflowToolbar(),l=d.getHeading(),s=d.getSnappedContent(),e=d.getExpandedContent();r.write("<div");r.writeControlData(d);r.writeAccessibilityState({role:"heading",level:2});r.addClass("sapFDynamicPageTitle");r.writeClasses();r.write(">");r.write("<div");r.addClass("sapFDynamicPageTitleLeft");r.writeClasses();r.write(">");r.write("<div");r.addClass("sapFDynamicPageTitleLeftInner");r.writeClasses();r.write(">");r.write("<div");r.addClass("sapFDynamicPageTitleLeftHeading");r.writeClasses();r.write(">");r.renderControl(l);r.write("</div>");if(s.length>0||e.length>0){r.write("<div");r.addClass("sapFDynamicPageTitleLeftSnappedExpandContent");r.writeClasses();r.write(">");D._renderSnappedContent(r,d,s);D._renderExpandContent(r,d,e);r.write("</div>");}r.write("</div>");r.write("</div>");r.write("<div");r.addClass("sapFDynamicPageTitleRight");r.writeClasses();r.write(">");r.write("<div");r.addClass("sapFDynamicPageTitleRightActions");r.writeClasses();r.write(">");if(a.getContent().length>0){r.renderControl(a);}r.write("</div>");r.write("</div>");r.write("</div>");};
D._renderExpandContent=function(r,d,e){if(e.length>0){r.write("<div");r.writeAttributeEscaped("id",d.getId()+'-expand-wrapper');r.writeClasses();r.write(">");e.forEach(r.renderControl);r.write("</div>");}};
D._renderSnappedContent=function(r,d,s){if(s.length>0){r.write("<div");r.writeAttributeEscaped("id",d.getId()+'-snapped-wrapper');if(!d._getShowSnapContent()){r.addClass("sapUiHidden");}r.addClass("sapFDynamicPageTitleSnapped");r.writeClasses();r.write(">");s.forEach(r.renderControl);r.write("</div>");}};
return D;},true);
sap.ui.predefine('sap/f/FlexibleColumnLayout',["jquery.sap.global","./library","sap/ui/core/ResizeHandler","sap/ui/core/Control","sap/m/Button"],function(q,l,R,C,B){"use strict";
var F=C.extend("sap.f.FlexibleColumnLayout",{metadata:{properties:{twoColumnLayoutOnDesktop:{type:"boolean",group:"Behavior",defaultValue:false},threeColumnLayoutType:{type:"sap.f.ThreeColumnLayoutType",group:"Behavior",defaultValue:sap.f.ThreeColumnLayoutType.MidColumnEmphasized},threeColumnLayoutTypeFixed:{type:"boolean",group:"Behavior",defaultValue:true}},aggregations:{beginColumn:{type:"sap.ui.core.Control",multiple:false},midColumn:{type:"sap.ui.core.Control",multiple:false},endColumn:{type:"sap.ui.core.Control",multiple:false},_beginColumnBackArrow:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_midColumnForwardArrow:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_midColumnBackArrow:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_endColumnForwardArrow:{type:"sap.m.Button",multiple:false,visibility:"hidden"}},associations:{fullScreenColumn:{type:"sap.ui.core.Control",multiple:false}},events:{layoutChange:{parameters:{beginColumnWidth:{type:"int"},midColumnWidth:{type:"int"},endColumnWidth:{type:"int"}}}}}});
F.prototype.init=function(){this._initButtons();this._oRm=sap.ui.getCore().createRenderManager();this._iControlWidth=null;this._sLayout=null;};
F.prototype.onAfterRendering=function(){this._deregisterResizeHandler();this._registerResizeHandler();this._cacheDOMElements();this._iControlWidth=this.$().width();this._adjustLayout(null,true);};
F.prototype.exit=function(){this._deregisterResizeHandler();this._oRm.destroy();};
F.prototype._registerResizeHandler=function(){this._iResizeHandlerId=R.register(this,this._onResize.bind(this));};
F.prototype._deregisterResizeHandler=function(){if(this._iResizeHandlerId){R.deregister(this._iResizeHandlerId);}};
F.prototype._initButtons=function(){var b=new B(this.getId()+"-beginBack",{icon:"sap-icon://slim-arrow-left",press:this._adjustLayout.bind(this,"left",false)}).addStyleClass("sapFFCLNavigationButton").addStyleClass("sapFFCLNavigationButtonRight");this.setAggregation("_beginColumnBackArrow",b,true);var m=new B(this.getId()+"-midForward",{icon:"sap-icon://slim-arrow-right",press:this._adjustLayout.bind(this,"right",false)}).addStyleClass("sapFFCLNavigationButton").addStyleClass("sapFFCLNavigationButtonLeft");this.setAggregation("_midColumnForwardArrow",m,true);var M=new B(this.getId()+"-midBack",{icon:"sap-icon://slim-arrow-left",press:this._adjustLayout.bind(this,"left",false)}).addStyleClass("sapFFCLNavigationButton").addStyleClass("sapFFCLNavigationButtonRight");this.setAggregation("_midColumnBackArrow",M,true);var e=new B(this.getId()+"-endForward",{icon:"sap-icon://slim-arrow-right",press:this._adjustLayout.bind(this,"right",false)}).addStyleClass("sapFFCLNavigationButton").addStyleClass("sapFFCLNavigationButtonLeft");this.setAggregation("_endColumnForwardArrow",e,true);};
F.prototype._cacheDOMElements=function(){this._$columns={begin:this.$("beginColumn"),mid:this.$("midColumn"),end:this.$("endColumn")};this._$columnContainers={begin:this.$("beginColumn-container"),mid:this.$("midColumn-container"),end:this.$("endColumn-container")};this._$columnButtons={beginBack:this.$("beginBack"),midForward:this.$("midForward"),midBack:this.$("midBack"),endForward:this.$("endForward")};};
F.prototype._flushColumnContent=function(c,o){if(this.getDomRef()){this._oRm.renderControl(o);this._oRm.flush(this._$columnContainers[c][0]);}};
F.prototype.setBeginColumn=function(c){if(this.getBeginColumn()===c){return this;}var r=this.setAggregation("beginColumn",c,true);if(typeof this._$columns==="undefined"){return r;}this._flushColumnContent("begin",c);this._adjustLayout(null,false);return r;};
F.prototype.setMidColumn=function(c){if(this.getMidColumn()===c){return this;}var r=this.setAggregation("midColumn",c,true);if(typeof this._$columns==="undefined"){return r;}this._flushColumnContent("mid",c);this._adjustLayout(null,false);return r;};
F.prototype.setEndColumn=function(c){if(this.getEndColumn()===c){return this;}var r=this.setAggregation("endColumn",c,true);if(typeof this._$columns==="undefined"){return r;}this._flushColumnContent("end",c);this._adjustLayout(null,false);return r;};
F.prototype.setFullScreenColumn=function(i){if(this.getFullScreenColumn()===i){return this;}var r=this.setAssociation("fullScreenColumn",i,true);if(typeof this._$columns==="undefined"){return r;}this._adjustLayout(null,false);return r;};
F.prototype.setTwoColumnLayoutOnDesktop=function(v){var r=this.setProperty("twoColumnLayoutOnDesktop",v,true);if(typeof this._$columns==="undefined"){return r;}this._adjustLayout(null,false);return r;};
F.prototype._getVisibleColumnsCount=function(){return["begin","mid","end"].filter(function(c){return this._getColumnSize(c)>0;},this).length;};
F.prototype._resizeColumns=function(){var p,n,t,a,N=false,c=["begin","mid","end"],r=sap.ui.getCore().getConfiguration().getRTL(),A;if(typeof this._$columns==="undefined"){return;}t=(this._getVisibleColumnsCount()-1)*F.COLUMN_MARGIN;a=this._iControlWidth-t;c.forEach(function(s){p=this._getColumnSize(s);this._$columns[s].toggleClass("sapFFCLColumnMargin",N&&p>0);this._$columns[s].toggleClass("sapFFCLColumnActive",p>0);this._$columns[s].removeClass("sapFFCLColumnOnlyActive");this._$columns[s].removeClass("sapFFCLColumnLastActive");this._$columns[s].removeClass("sapFFCLColumnFirstActive");if([100,0].indexOf(p)!==-1){n=p+"%";}else{n=Math.round(a*(p/100))+"px";}this._$columns[s].width(n);if(p>0){N=true;}},this);A=c.filter(function(s){return this._getColumnSize(s)>0;},this);if(r){c.reverse();}if(A.length===1){this._$columns[A[0]].addClass("sapFFCLColumnOnlyActive");}if(A.length>1){this._$columns[A[0]].addClass("sapFFCLColumnFirstActive");this._$columns[A[A.length-1]].addClass("sapFFCLColumnLastActive");}};
F.prototype._getColumnSize=function(c){var s=this._sLayout.split("/"),m={begin:0,mid:1,end:2},S=s[m[c]];return S;};
F.prototype._onResize=function(e){var n=e.size.width;if(n===0||n===this._iControlWidth){return;}this._iControlWidth=e.size.width;if(!this.getFullScreenColumn()){this._adjustLayout(null,true);}};
F.prototype._adjustLayout=function(s,r){var n=this._sLayout,b=this.getBeginColumn()?true:false,m=this.getMidColumn()?true:false,e=this.getEndColumn()?true:false,f=this.getFullScreenColumn(),M=this._getMaxColumns(),t=this.getThreeColumnLayoutType()===l.ThreeColumnLayoutType.EndColumnEmphasized?"25/25/50":"25/50/25",p,d,c;if(f){if(this.getBeginColumn()&&this.getBeginColumn().getId()===f){n="100/0/0";}else if(this.getMidColumn()&&this.getMidColumn().getId()===f){n="0/100/0";}else if(this.getEndColumn()&&this.getEndColumn().getId()===f){n="0/0/100";}else{}}else{if(M===3){if(!b||!m){p=["100/0/0"];d="100/0/0";}else if(!e){p=["33/67/0","67/33/0"];d="67/33/0";}else{if(this.getThreeColumnLayoutTypeFixed()){p=[t,"33/67/0","67/33/0"];}else{p=["25/25/50","25/50/25","33/67/0","67/33/0"];}d=t;}}else if(M===2){if(!b||!m){p=["100/0/0"];d="100/0/0";}else if(!e){p=["33/67/0","67/33/0"];d="67/33/0";}else{p=["0/67/33","33/67/0","67/33/0"];d="0/67/33";}}else{if(!b||!m){p=["100/0/0"];d="100/0/0";}else if(!e){p=["0/100/0","100/0/0"];d="0/100/0";}else{p=["0/0/100","0/100/0","100/0/0"];d="0/0/100";}}if(s){c=p.indexOf(n);if(s==="left"&&c>0){n=p[c-1];}else if(s==="right"&&c<p.length-1){n=p[c+1];}}else{if(!r||p.indexOf(n)===-1){n=d;}}}if(this._sLayout===n){this._resizeColumns();this._hideShowArrows();return;}this._sLayout=n;this._resizeColumns();this._hideShowArrows();if(!f){this.fireLayoutChange({beginColumnWidth:this._getColumnSize("begin"),midColumnWidth:this._getColumnSize("mid"),endColumnWidth:this._getColumnSize("end")});}};
F.prototype._hideShowArrows=function(){var b=this.getBeginColumn()?true:false,m=this.getMidColumn()?true:false,e=this.getEndColumn()?true:false,M=this._getMaxColumns(),n=[];if(typeof this._$columns==="undefined"){return;}if(M===3){if(!b||!m){n=[];}else if(!e){if(this._sLayout==="33/67/0"){n=["midForward"];}else{n=["beginBack"];}}else{if(this._sLayout==="25/50/25"){if(this.getThreeColumnLayoutTypeFixed()){n=["midForward"];}else{n=["midForward","midBack"];}}else if(this._sLayout==="25/25/50"){n=["endForward"];}else if(this._sLayout==="33/67/0"){n=["midForward","midBack"];}else{n=["beginBack"];}}}else if(M===2){if(!b||!m){n=[];}else if(!e){if(this._sLayout==="33/67/0"){n=["midForward"];}else{n=["midBack"];}}else{if(this._sLayout==="0/67/33"){n=["midForward"];}else if(this._sLayout==="33/67/0"){n=["midForward","midBack"];}else{n=["beginBack"];}}}this._toggleButton("beginBack",n.indexOf("beginBack")!==-1);this._toggleButton("midForward",n.indexOf("midForward")!==-1);this._toggleButton("midBack",n.indexOf("midBack")!==-1);this._toggleButton("endForward",n.indexOf("endForward")!==-1);};
F.prototype._toggleButton=function(b,s){this._$columnButtons[b].toggle(s);};
F.prototype._getMaxColumns=function(){if(this._iControlWidth>=F.DESKTOP_BREAKPOINT){if(this.getTwoColumnLayoutOnDesktop()){return 2;}return 3;}if(this._iControlWidth>=F.TABLET_BREAKPOINT&&this._iControlWidth<F.DESKTOP_BREAKPOINT){return 2;}return 1;};
F.COLUMN_MARGIN=8;F.DESKTOP_BREAKPOINT=1280;F.TABLET_BREAKPOINT=960;return F;},false);
sap.ui.predefine('sap/f/FlexibleColumnLayoutRenderer',[],function(){"use strict";var F={};
F.render=function(r,c){r.write("<div");r.writeControlData(c);r.addClass("sapFFCL");r.writeClasses();r.write(">");this.renderBeginColumn(r,c);this.renderMidColumn(r,c);this.renderEndColumn(r,c);r.write("</div>");};
F.renderBeginColumn=function(r,c){var b=c.getAggregation("_beginColumnBackArrow");r.write("<div");r.writeAttribute("id",c.getId()+"-beginColumn");r.addClass("sapFFCLColumn").addClass("sapFFCLColumnBegin").addClass("sapFFCLColumnActive");r.writeClasses();r.writeStyles();r.write(">");r.write("<div");r.writeAttribute("id",c.getId()+"-beginColumn-container");r.addClass("sapFFCLContainer");r.writeClasses();r.write(">");if(c.getBeginColumn()){r.renderControl(c.getBeginColumn());}r.write("</div>");r.renderControl(b);r.write("</div>");};
F.renderMidColumn=function(r,c){var m=c.getAggregation("_midColumnForwardArrow"),M=c.getAggregation("_midColumnBackArrow");r.write("<div");r.writeAttribute("id",c.getId()+"-midColumn");r.addClass("sapFFCLColumn").addClass("sapFFCLColumnMid");r.writeClasses();r.writeStyles();r.write(">");r.write("<div");r.writeAttribute("id",c.getId()+"-midColumn-container");r.addClass("sapFFCLContainer");r.writeClasses();r.write(">");if(c.getMidColumn()){r.renderControl(c.getMidColumn());}r.write("</div>");r.renderControl(m);r.renderControl(M);r.write("</div>");};
F.renderEndColumn=function(r,c){var e=c.getAggregation("_endColumnForwardArrow");r.write("<div");r.writeAttribute("id",c.getId()+"-endColumn");r.addClass("sapFFCLColumn").addClass("sapFFCLColumnEnd");r.writeClasses();r.writeStyles();r.write(">");r.write("<div");r.writeAttribute("id",c.getId()+"-endColumn-container");r.addClass("sapFFCLContainer");r.writeClasses();r.write(">");if(c.getEndColumn()){r.renderControl(c.getEndColumn());}r.write("</div>");r.renderControl(e);r.write("</div>");};
return F;},true);
sap.ui.predefine('sap/f/library',['jquery.sap.global','sap/ui/core/library','sap/m/library'],function(){'use strict';sap.ui.getCore().initLibrary({name:'sap.f',version:'1.42.8',dependencies:['sap.ui.core','sap.m'],types:["sap.f.ThreeColumnLayoutType"],controls:["sap.f.DynamicPage","sap.f.DynamicPageHeader","sap.f.DynamicPageTitle","sap.f.FlexibleColumnLayout"],elements:[]});sap.f.ThreeColumnLayoutType={EndColumnEmphasized:"EndColumnEmphasized",MidColumnEmphasized:"MidColumnEmphasized"};return sap.f;});
jQuery.sap.registerPreloadedModules({
"name":"sap/f/library-preload",
"version":"2.0",
"modules":{
	"sap/f/manifest.json":'{\n  "_version": "1.2.0",\n  "sap.app": {\n    "_version": "1.2.0",\n    "id": "sap.f",\n    "type": "library",\n    "embeds": [],\n    "applicationVersion": {\n      "version": "1.42.8"\n    },\n    "title": "SAPUI5 library with Fiori controls.",\n    "description": "SAPUI5 library with Fiori controls.",\n    "ach": "CA-UI5-CTR",\n    "resources": "resources.json",\n    "offline": true\n  },\n  "sap.ui": {\n    "_version": "1.1.0",\n    "technology": "UI5",\n    "supportedThemes": [\n      "base",\n      "sap_hcb"\n    ]\n  },\n  "sap.ui5": {\n    "_version": "1.1.0",\n    "dependencies": {\n      "minUI5Version": "1.42",\n      "libs": {\n        "sap.ui.core": {\n          "minVersion": "1.42.8"\n        },\n        "sap.m": {\n          "minVersion": "1.42.8"\n        }\n      }\n    }\n  }\n}'
}});
