/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./library','sap/ui/core/Control','./Button','./SplitButton','./Dialog','sap/ui/Device','sap/ui/core/EnabledPropagator'],function(q,l,C,B,S,D,a,E){"use strict";var M=C.extend("sap.m.MenuButton",{metadata:{library:"sap.m",properties:{text:{type:"string",group:"Misc",defaultValue:null},type:{type:"sap.m.ButtonType",group:"Appearance",defaultValue:sap.m.ButtonType.Default},width:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:null},enabled:{type:"boolean",group:"Behavior",defaultValue:true},icon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null},activeIcon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},iconDensityAware:{type:"boolean",group:"Misc",defaultValue:true},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:sap.ui.core.TextDirection.Inherit},buttonMode:{type:"sap.m.MenuButtonMode",group:"Misc",defaultValue:sap.m.MenuButtonMode.Regular},useDefaultActionOnly:{type:"Boolean",group:"Behavior",defaultValue:false}},aggregations:{menu:{type:"sap.m.Menu",multiple:false,singularName:"menu",bindable:"bindable"},_button:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},events:{defaultAction:{}},defaultAggregation:"menu"}});E.call(M.prototype);M.prototype.init=function(){this._initButtonControl();};M.prototype.exit=function(){if(this._sDefaultText){this._sDefaultText=null;}if(this._sDefaultIcon){this._sDefaultIcon=null;}if(this._iInitialWidth){this._iInitialWidth=null;}if(this._lastActionItemId){this._lastActionItemId=null;}if(this.getMenu()){this.getMenu().detachClosed(this._menuClosed,this);}};M.prototype.onBeforeRendering=function(){if(!this._sDefaultText){this._sDefaultText=this.getText();}if(!this._sDefaultIcon){this._sDefaultIcon=this.getIcon();}this._updateButtonControl();this._attachMenuEvents();};M.prototype.onAfterRendering=function(){q.sap.delayedCall(0,this,"_setInitialBtnWidth");this._setAriaHasPopup();};M.prototype._setInitialBtnWidth=function(){if(this._isSplitButton()&&!this._iInitialWidth){this._iInitialWidth=this.$().outerWidth()+1;}};M.prototype._setAriaHasPopup=function(){if(this._isSplitButton()){this._getButtonControl()._getArrowButton().$().attr("aria-haspopup","true");}else{this._getButtonControl().$().attr("aria-haspopup","true");}};M.prototype.setButtonMode=function(m){var t=this.getTooltip();C.prototype.setProperty.call(this,"buttonMode",m,true);this._getButtonControl().destroy();this._initButtonControl();for(var k in this.mProperties){if(this.mProperties.hasOwnProperty(k)&&k!=="buttonMode"&&k!=="useDefaultActionOnly"&&k!=="width"){this._getButtonControl().setProperty(k,this.mProperties[k],true);}}if(t){this._getButtonControl().setTooltip(t);}if(!this._isSplitButton()&&this._sDefaultText){this.setText(this._sDefaultText);}else if(!this.getUseDefaultActionOnly()&&this._getLastSelectedItem()){this.setText(sap.ui.getCore().byId(this._getLastSelectedItem()).getText());}if(!this._isSplitButton()&&this._sDefaultIcon){this.setIcon(this._sDefaultIcon);}else if(!this.getUseDefaultActionOnly()&&this._getLastSelectedItem()){this.setIcon(sap.ui.getCore().byId(this._getLastSelectedItem()).getIcon());}this.invalidate();return this;};M.prototype._initButton=function(){var b=new B({width:"100%"});b.attachPress(this._handleButtonPress,this);return b;};M.prototype._initSplitButton=function(){var b=new S({width:"100%"});b.attachPress(this._handleActionPress,this);b.attachArrowPress(this._handleButtonPress,this);return b;};M.prototype._initButtonControl=function(){var b;if(this._isSplitButton()){b=this._initSplitButton();}else{b=this._initButton();}this.setAggregation("_button",b,true);};M.prototype._updateButtonControl=function(){this._getButtonControl().setText(this.getText());};M.prototype._getButtonControl=function(){return this.getAggregation("_button");};M.prototype._handleButtonPress=function(w){var m=this.getMenu();if(!m){return;}if(!m.getTitle()){m.setTitle(this.getText());}m.openBy(this,w);this._writeAriaAttributes();if(this._isSplitButton()&&!a.system.phone){this._getButtonControl().setArrowState(true);}};M.prototype._handleActionPress=function(){var L=this._getLastSelectedItem(),o;if(!this.getUseDefaultActionOnly()&&L){o=sap.ui.getCore().byId(L);this.getMenu().fireItemSelected({item:o});}else{this.fireDefaultAction();}};M.prototype._menuClosed=function(){if(this._isSplitButton()){this._getButtonControl().setArrowState(false);}};M.prototype._menuItemSelected=function(e){var m=e.getParameter("item");if(!this._isSplitButton()||this.getUseDefaultActionOnly()||!m){return;}this._lastActionItemId=m.getId();!!this._sDefaultText&&this.setText(m.getText());!!this._sDefaultIcon&&this.setIcon(m.getIcon());};M.prototype._getLastSelectedItem=function(){return this._lastActionItemId;};M.prototype._attachMenuEvents=function(){if(this.getMenu()){this.getMenu().attachClosed(this._menuClosed,this);this.getMenu().attachItemSelected(this._menuItemSelected,this);}};M.prototype._isSplitButton=function(){return this.getButtonMode()===sap.m.MenuButtonMode.Split;};M.prototype.setProperty=function(p,v,s){function i(t){var T=[sap.m.ButtonType.Up,sap.m.ButtonType.Back,sap.m.ButtonType.Unstyled];return T.indexOf(t)!==-1;}if(p==="type"&&i(v)){return this;}if(p==='text'){this._sDefaultText=v;}switch(p){case'activeIcon':case'iconDensityAware':case'textDirection':this._getButtonControl().setProperty(p,v);break;}return C.prototype.setProperty.apply(this,arguments);};M.prototype.setTooltip=function(t){this._getButtonControl().setTooltip(t);return C.prototype.setTooltip.apply(this,arguments);};M.prototype.setText=function(v){B.prototype.setProperty.call(this,'text',v);this._getButtonControl().setText(v);return this;};M.prototype.setType=function(v){B.prototype.setProperty.call(this,'type',v);this._getButtonControl().setType(v);return this;};M.prototype.setIcon=function(v){B.prototype.setProperty.call(this,'icon',v);this._getButtonControl().setIcon(v);return this;};M.prototype.getFocusDomRef=function(){return this._getButtonControl().getDomRef();};M.prototype.onsapup=function(e){this.openMenuByKeyboard();};M.prototype.onsapdown=function(e){this.openMenuByKeyboard();};M.prototype.onsapupmodifiers=function(e){this.openMenuByKeyboard();};M.prototype.onsapdownmodifiers=function(e){this.openMenuByKeyboard();};M.prototype.onsapshow=function(e){this.openMenuByKeyboard();!!e&&e.preventDefault();};M.prototype.openMenuByKeyboard=function(){if(!this._isSplitButton()){this._handleButtonPress(true);}};M.prototype._writeAriaAttributes=function(){if(this.getMenu()){this.$().attr("aria-controls",this.getMenu().getDomRefId());}};return M;},true);
