/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./library','sap/ui/core/Control','./Tokenizer'],function(q,l,C,T){"use strict";var a=C.extend("sap.m.Token",{metadata:{library:"sap.m",properties:{selected:{type:"boolean",group:"Misc",defaultValue:false},key:{type:"string",group:"Misc",defaultValue:""},text:{type:"string",group:"Misc",defaultValue:""},editable:{type:"boolean",group:"Misc",defaultValue:true},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:sap.ui.core.TextDirection.Inherit}},aggregations:{deleteIcon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{"delete":{},press:{},select:{},deselect:{}}}});var r=sap.ui.getCore().getLibraryResourceBundle("sap.m");a.prototype._sAriaTokenLabelId=new sap.ui.core.InvisibleText({text:r.getText("TOKEN_ARIA_LABEL")}).toStatic().getId();a.prototype._sAriaTokenDeletableId=new sap.ui.core.InvisibleText({text:r.getText("TOKEN_ARIA_DELETABLE")}).toStatic().getId();a.prototype.init=function(){var t=this;this._deleteIcon=new sap.ui.core.Icon({id:t.getId()+"-icon",src:"sap-icon://sys-cancel",noTabStop:true,press:function(e){var p=t.getParent();t.fireDelete();if(p instanceof T){p._onTokenDelete(t);}e.preventDefault();}});this._deleteIcon.addStyleClass("sapMTokenIcon");this.setAggregation("deleteIcon",this._deleteIcon);this._deleteIcon.setUseIconTooltip(false);};a.prototype.ontouchstart=function(e){e.preventDefault();};a.prototype.setSelected=function(s){if(this.getSelected()===s){return this;}var $=this.$();if($){$.toggleClass("sapMTokenSelected",s);$.attr('aria-selected',s);}this.setProperty("selected",s,true);return this;};a.prototype.setEditable=function(e){var p=this.getParent();this.setProperty("editable",e,true);this.$().toggleClass("sapMTokenReadOnly",!e);if(p instanceof T){p.invalidate();}return this;};a.prototype._onTokenPress=function(e){var s=this.getSelected(),c=e.ctrlKey||e.metaKey,S=e.shiftKey,n=true,p;if(c){n=!s;}this.setSelected(n);this.firePress();if(s!=n){if(n){this.fireSelect();}else{this.fireDeselect();}}p=this.getParent();if(p instanceof T){p._onTokenSelect(this,c,S);}if(this.getSelected()){this.focus();}};a.prototype._changeSelection=function(s){if(this.getSelected()==s){return;}this.setSelected(s);if(s){this.fireSelect();}else{this.fireDeselect();}};a.prototype.ontap=function(e){this._onTokenPress(e);};a.prototype.onsapfocusleave=function(e){if(this.getParent()instanceof T){return;}this.setSelected(false);};a.prototype.onsapbackspace=function(e){this._deleteToken(e);};a.prototype.onsapdelete=function(e){this._deleteToken(e);};a.prototype._deleteToken=function(e){if(this.getParent()instanceof T){return;}if(this.getEditable()){this.fireDelete();}e.preventDefault();};a.prototype.onsapspace=function(e){this._onTokenPress(e);if(e){e.preventDefault();e.stopPropagation();}};a.prototype.onkeydown=function(e){if((e.ctrlKey||e.metaKey)&&e.which===q.sap.KeyCodes.SPACE){this.onsapspace(e);e.preventDefault();}};return a;},true);
