/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./MessageBox','./Dialog','./library','sap/ui/core/Control','sap/ui/unified/FileUploaderParameter',"sap/ui/unified/FileUploader",'sap/ui/core/format/FileSizeFormat','sap/m/Link','sap/m/OverflowToolbar','./ObjectAttribute','./ObjectStatus',"./UploadCollectionItem","sap/ui/core/HTML","./BusyIndicator","./CustomListItem","sap/ui/core/ResizeHandler","sap/ui/Device","./CustomListItemRenderer","sap/ui/core/HTMLRenderer","./LinkRenderer","./ObjectAttributeRenderer","./ObjectStatusRenderer","./ObjectMarkerRenderer","./TextRenderer","./DialogRenderer"],function(q,M,D,L,C,F,a,b,c,O,d,f,U,H,B,g,R,h){"use strict";var k=C.extend("sap.m.UploadCollection",{constructor:function(i,s){var I;if(s&&s.instantUpload===false){I=s.instantUpload;delete s.instantUpload;}else if(i&&i.instantUpload===false){I=i.instantUpload;delete i.instantUpload;}if(s&&s.mode===sap.m.ListMode.MultiSelect&&I===false){s.mode=sap.m.ListMode.None;q.sap.log.info("sap.m.ListMode.MultiSelect is not supported by UploadCollection for Upload Pending scenario. Value has been resetted to 'None'");}else if(i&&i.mode===sap.m.ListMode.MultiSelect&&I===false){i.mode=sap.m.ListMode.None;q.sap.log.info("sap.m.ListMode.MultiSelect is not supported by UploadCollection for Upload Pending scenario. Value has been resetted to 'None'");}try{C.apply(this,arguments);if(I===false){this.bInstantUpload=I;this._oFormatDecimal=b.getInstance({binaryFilesize:false,maxFractionDigits:1,maxIntegerDigits:3});}}catch(e){this.destroy();throw e;}},metadata:{library:"sap.m",properties:{fileType:{type:"string[]",group:"Data",defaultValue:null},maximumFilenameLength:{type:"int",group:"Data",defaultValue:null},maximumFileSize:{type:"float",group:"Data",defaultValue:null},mimeType:{type:"string[]",group:"Data",defaultValue:null},multiple:{type:"boolean",group:"Behavior",defaultValue:false},noDataText:{type:"string",group:"Behavior",defaultValue:null},sameFilenameAllowed:{type:"boolean",group:"Behavior",defaultValue:false},showSeparators:{type:"sap.m.ListSeparators",group:"Appearance",defaultValue:sap.m.ListSeparators.All},uploadEnabled:{type:"boolean",group:"Behavior",defaultValue:true},uploadUrl:{type:"string",group:"Data",defaultValue:"../../../upload"},instantUpload:{type:"boolean",group:"Behavior",defaultValue:true},numberOfAttachmentsText:{type:"string",group:"Appearance",defaultValue:null},mode:{type:"sap.m.ListMode",group:"Behavior",defaultValue:"None"},uploadButtonInvisible:{type:"boolean",group:"Appearance",defaultValue:false},terminationEnabled:{type:"boolean",group:"Behavior",defaultValue:true}},defaultAggregation:"items",aggregations:{items:{type:"sap.m.UploadCollectionItem",multiple:true,singularName:"item",bindable:"bindable"},headerParameters:{type:"sap.m.UploadCollectionParameter",multiple:true,singularName:"headerParameter"},parameters:{type:"sap.m.UploadCollectionParameter",multiple:true,singularName:"parameter"},toolbar:{type:"sap.m.OverflowToolbar",multiple:false},_list:{type:"sap.m.List",multiple:false,visibility:"hidden"}},events:{change:{parameters:{documentId:{type:"string"},files:{type:"object[]"}}},fileDeleted:{parameters:{documentId:{type:"string"},item:{type:"sap.m.UploadCollectionItem"}}},filenameLengthExceed:{parameters:{documentId:{type:"string"},files:{type:"object[]"}}},fileRenamed:{parameters:{documentId:{type:"string"},fileName:{type:"string"},item:{type:"sap.m.UploadCollectionItem"}}},fileSizeExceed:{parameters:{documentId:{type:"string"},fileSize:{type:"string"},files:{type:"object[]"}}},typeMissmatch:{parameters:{documentId:{type:"string"},fileType:{type:"string"},mimeType:{type:"string"},files:{type:"object[]"}}},uploadComplete:{parameters:{readyStateXHR:{type:"string"},response:{type:"string"},status:{type:"string"},files:{type:"object[]"}}},uploadTerminated:{parameters:{fileName:{type:"string"},getHeaderParameter:{type:"function",parameters:{headerParameterName:{type:"string"}}}}},beforeUploadStarts:{parameters:{fileName:{type:"string"},addHeaderParameter:{type:"function",parameters:{headerParameter:{type:"sap.m.UploadCollectionParameter"}}},getHeaderParameter:{type:"function",parameters:{headerParameterName:{type:"string"}}}}},selectionChange:{parameters:{selectedItem:{type:"sap.m.UploadCollectionItem"},selectedItems:{type:"sap.m.UploadCollectionItem[]"},selected:{type:"boolean"}}}}}});k._uploadingStatus="uploading";k._displayStatus="display";k._toBeDeletedStatus="toBeDeleted";k._pendingUploadStatus="pendingUploadStatus";k._placeholderCamera='sap-icon://camera';k._markerMargin=8;if(h.system.phone){k._resizeTimeoutInterval=500;}else{k._resizeTimeoutInterval=100;}k.prototype.init=function(){k.prototype._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._headerParamConst={requestIdName:"requestId"+q.now(),fileNameRequestIdName:"fileNameRequestId"+q.now()};this._requestIdValue=0;this._iFUCounter=0;this._oList=new sap.m.List(this.getId()+"-list");this.setAggregation("_list",this._oList,true);this._oList.addStyleClass("sapMUCList");this._iUploadStartCallCounter=0;this.aItems=[];this._aDeletedItemForPendingUpload=[];this._aFileUploadersForPendingUpload=[];this._iFileUploaderPH=null;this._oListEventDelegate=null;this._oItemToUpdate=null;this._sReziseHandlerId=null;};k.prototype.setFileType=function(e){if(!e){return this;}if(!this.getInstantUpload()){q.sap.log.info("As property instantUpload is false it is not allowed to change fileType at runtime.");}else{var j=e.length;for(var i=0;i<j;i++){e[i]=e[i].toLowerCase();}this.setProperty("fileType",e);if(this._getFileUploader().getFileType()!==e){this._getFileUploader().setFileType(e);}}return this;};k.prototype.setMaximumFilenameLength=function(m){if(!this.getInstantUpload()){q.sap.log.info("As property instantUpload is false it is not allowed to change maximumFilenameLength at runtime.");}else{this.setProperty("maximumFilenameLength",m,true);if(this._getFileUploader().getMaximumFilenameLength()!==m){this._getFileUploader().setMaximumFilenameLength(m);}}return this;};k.prototype.setMaximumFileSize=function(m){if(!this.getInstantUpload()){q.sap.log.info("As property instantUpload is false it is not allowed to change maximumFileSize at runtime.");}else{this.setProperty("maximumFileSize",m,true);if(this._getFileUploader().getMaximumFileSize()!==m){this._getFileUploader().setMaximumFileSize(m);}}return this;};k.prototype.setMimeType=function(m){if(!this.getInstantUpload()){q.sap.log.info("As property instantUpload is false it is not allowed to change mimeType at runtime.");}else{this.setProperty("mimeType",m);if(this._getFileUploader().getMimeType()!==m){this._getFileUploader().setMimeType(m);}return this;}};k.prototype.setMultiple=function(m){if(!this.getInstantUpload()){q.sap.log.info("As property instantUpload is false it is not allowed to change multiple at runtime.");}else{this.setProperty("multiple",m);if(this._getFileUploader().getMultiple()!==m){this._getFileUploader().setMultiple(m);}return this;}};k.prototype.setNoDataText=function(n){this.setProperty("noDataText",n);if(this._oList.getNoDataText()!==n){this._oList.setNoDataText(n);}return this;};k.prototype.setShowSeparators=function(s){this.setProperty("showSeparators",s);if(this._oList.getShowSeparators()!==s){this._oList.setShowSeparators(s);}return this;};k.prototype.setUploadEnabled=function(u){if(!this.getInstantUpload()){q.sap.log.info("As property instantUpload is false it is not allowed to change uploadEnabled at runtime.");}else{this.setProperty("uploadEnabled",u);if(this._getFileUploader().getEnabled()!==u){this._getFileUploader().setEnabled(u);}}return this;};k.prototype.setUploadUrl=function(u){if(!this.getInstantUpload()){q.sap.log.info("As property instantUpload is false it is not allowed to change uploadUrl at runtime.");}else{this.setProperty("uploadUrl",u);if(this._getFileUploader().getUploadUrl()!==u){this._getFileUploader().setUploadUrl(u);}}return this;};k.prototype.setInstantUpload=function(){q.sap.log.error("It is not supported to change the behavior at runtime.");return this;};k.prototype.setMode=function(m){if(m===sap.m.ListMode.Delete){this._oList.setMode(sap.m.ListMode.None);q.sap.log.info("sap.m.ListMode.Delete is not supported by UploadCollection. Value has been resetted to 'None'");}else if(m===sap.m.ListMode.MultiSelect&&!this.getInstantUpload()){this._oList.setMode(sap.m.ListMode.None);q.sap.log.info("sap.m.ListMode.MultiSelect is not supported by UploadCollection for Pending Upload. Value has been resetted to 'None'");}else{this._oList.setMode(m);}return this;};k.prototype.getMode=function(){return this._oList.getMode();};k.prototype.getToolbar=function(){return this._oHeaderToolbar;};k.prototype.setUploadButtonInvisible=function(u){if(this.getUploadButtonInvisible()===u){return this;}this.setProperty("uploadButtonInvisible",u,true);if(this.getInstantUpload()){this._getFileUploader().setVisible(!u);}else{this._setFileUploaderVisibility(u);}return this;};k.prototype.upload=function(){if(this.getInstantUpload()){q.sap.log.error("Not a valid API call. 'instantUpload' should be set to 'false'.");}var e=this._aFileUploadersForPendingUpload.length;for(var i=0;i<e;i++){this._iUploadStartCallCounter=0;this._aFileUploadersForPendingUpload[i].upload();}};k.prototype.getSelectedItems=function(){var s=this._oList.getSelectedItems();return this._getUploadCollectionItemsByListItems(s);};k.prototype.getSelectedItem=function(){var s=this._oList.getSelectedItem();if(s){return this._getUploadCollectionItemByListItem(s);}};k.prototype.setSelectedItemById=function(i,s){this._oList.setSelectedItemById(i+"-cli",s);this._setSelectedForItems([this._getUploadCollectionItemById(i)],s);return this;};k.prototype.setSelectedItem=function(u,s){this.setSelectedItemById(u.getId(),s);return this;};k.prototype.selectAll=function(){var s=this._oList.selectAll();if(s.getItems().length!==this.getItems().length){q.sap.log.info("Internal 'List' and external 'UploadCollection' are not in sync.");}this._setSelectedForItems(this.getItems(),true);return this;};k.prototype.downloadItem=function(u,e){if(!this.getInstantUpload()){q.sap.log.info("Download is not possible on Pending Upload mode");return false;}else{return u.download(e);}};k.prototype.openFileDialog=function(i){if(this._oFileUploader){if(i){if(!this._oFileUploader.getMultiple()){this._oItemToUpdate=i;this._oFileUploader.$().find("input[type=file]").trigger("click");}else{q.sap.log.warning("Version Upload cannot be used in multiple upload mode");}}else{this._oFileUploader.$().find("input[type=file]").trigger("click");}}return this;};k.prototype.removeAggregation=function(A,o,s){if(!this.getInstantUpload()&&A==="items"&&o){this._aDeletedItemForPendingUpload.push(o);}if(C.prototype.removeAggregation){return C.prototype.removeAggregation.apply(this,arguments);}};k.prototype.removeAllAggregation=function(A,s){if(!this.getInstantUpload()&&A==="items"){if(this._aFileUploadersForPendingUpload){for(var i=0;i<this._aFileUploadersForPendingUpload.length;i++){this._aFileUploadersForPendingUpload[i].destroy();this._aFileUploadersForPendingUpload[i]=null;}this._aFileUploadersForPendingUpload=[];}}if(C.prototype.removeAllAggregation){return C.prototype.removeAllAggregation.apply(this,arguments);}};k.prototype.onBeforeRendering=function(){this._RenderManager=this._RenderManager||sap.ui.getCore().createRenderManager();var i,e;if(this._oListEventDelegate){this._oList.removeEventDelegate(this._oListEventDelegate);this._oListEventDelegate=null;}this._deregisterSizeHandler();j.bind(this)();if(!this.getInstantUpload()){this.aItems=this.getItems();this._getListHeader(this.aItems.length);this._clearList();this._fillList(this.aItems);this._oList.setHeaderToolbar(this._oHeaderToolbar);return;}if(this.aItems.length>0){e=this.aItems.length;var u=[];for(i=0;i<e;i++){if(this.aItems[i]&&this.aItems[i]._status===k._uploadingStatus){u.push(this.aItems[i]);}else if(this.aItems[i]&&this.aItems[i]._status!==k._uploadingStatus&&this.aItems[i]._percentUploaded===100&&this.getItems().length===0){u.push(this.aItems[i]);}}if(u.length!==0){this.aItems=[];this.aItems=this.getItems();this.aItems=u.concat(this.aItems);}else{this.aItems=this.getItems();}}else{this.aItems=this.getItems();}this._getListHeader(this.aItems.length);this._clearList();this._fillList(this.aItems);this._oList.setAggregation("headerToolbar",this._oHeaderToolbar,true);if((h.browser.msie&&h.browser.version<=9)&&this.aItems.length>0&&this.aItems[0]._status===k._uploadingStatus){this._oFileUploader.setEnabled(false);}else{if(this.sErrorState!=="Error"){if(this.getUploadEnabled()!==this._oFileUploader.getEnabled()){this._oFileUploader.setEnabled(this.getUploadEnabled());}}else{this._oFileUploader.setEnabled(false);}}if(this.sDeletedItemId){q(document.activeElement).blur();}function j(){if(this.bInstantUpload===false){this.setProperty("instantUpload",this.bInstantUpload,true);delete this.bInstantUpload;}}};k.prototype.onAfterRendering=function(){var t=this;if(this.getInstantUpload()){if(this.aItems||(this.aItems===this.getItems())){if(this.editModeItem){var $=q.sap.byId(this.editModeItem+"-ta_editFileName-inner");if($){var i=this.editModeItem;if(!h.os.ios){$.focus(function(){$.selectText(0,$.val().length);});}$.focus();this._oListEventDelegate={onclick:function(e){sap.m.UploadCollection.prototype._handleClick(e,t,i);}};this._oList.addDelegate(this._oListEventDelegate);}}else if(this.sFocusId){sap.m.UploadCollection.prototype._setFocus2LineItem(this.sFocusId);this.sFocusId=null;}else if(this.sDeletedItemId){sap.m.UploadCollection.prototype._setFocusAfterDeletion(this.sDeletedItemId,t);}}}else{if(this.sFocusId){sap.m.UploadCollection.prototype._setFocus2LineItem(this.sFocusId);this.sFocusId=null;}}};k.prototype.exit=function(){var i,p;if(this._oFileUploader){this._oFileUploader.destroy();this._oFileUploader=null;}if(this._oHeaderToolbar){this._oHeaderToolbar.destroy();this._oHeaderToolbar=null;}if(this._oNumberOfAttachmentsTitle){this._oNumberOfAttachmentsTitle.destroy();this._oNumberOfAttachmentsTitle=null;}if(this._RenderManager){this._RenderManager.destroy();}if(this._aFileUploadersForPendingUpload){p=this._aFileUploadersForPendingUpload.length;for(i=0;i<p;i++){this._aFileUploadersForPendingUpload[i].destroy();this._aFileUploadersForPendingUpload[i]=null;}this._aFileUploadersForPendingUpload=null;}this._deregisterSizeHandler();};k.prototype._deregisterSizeHandler=function(){h.orientation.detachHandler(this._onResize,this);R.deregister(this._sReziseHandlerId);};k.prototype._hideFileUploaders=function(){var t,i;if(!this.getInstantUpload()){t=this._oHeaderToolbar.getContent().length;if(this._aFileUploadersForPendingUpload.length){for(i=0;i<t;i++){if(this._oHeaderToolbar.getContent()[i]instanceof sap.ui.unified.FileUploader){if(i===this._iFileUploaderPH&&this._bFocusFileUploader){this._oHeaderToolbar.getContent()[i].$().find("button").focus();}else{this._oHeaderToolbar.getContent()[i].$().hide();}}}}return;}};k.prototype._truncateFileName=function(I){if(I._status==="Edit"){var s=I.getId()+"-cli";this.$().find("#"+s).find(".sapMUCObjectMarkerContainer").attr("style","display: none");return;}var m=0;var e=I.getMarkers();var S;for(var i=0;i<e.length;i++){m=m+e[i].$().width()+k._markerMargin;}if(m>0){var $=this.$().find("#"+I.getId()+"-ta_filenameHL");if($){S="max-width: calc(100% - "+m+"px)";if($.attr("style")!==S){$.attr("style",S);}}}};k.prototype._getListHeader=function(I){var o,i;this._setNumberOfAttachmentsTitle(I);if(!this._oHeaderToolbar){if(!!this._oFileUploader&&!this.getInstantUpload()){this._oFileUploader.destroy();}o=this._getFileUploader();this._oHeaderToolbar=this.getAggregation("toolbar");if(!this._oHeaderToolbar){this._oHeaderToolbar=new sap.m.OverflowToolbar(this.getId()+"-toolbar",{content:[this._oNumberOfAttachmentsTitle,new sap.m.ToolbarSpacer(),o]}).addEventDelegate({onAfterRendering:this._hideFileUploaders},this);this._iFileUploaderPH=2;}else{this._oHeaderToolbar.addEventDelegate({onAfterRendering:this._hideFileUploaders},this);this._iFileUploaderPH=this._getFileUploaderPlaceHolderPosition(this._oHeaderToolbar);if(this._oHeaderToolbar&&this._iFileUploaderPH>-1){this._setFileUploaderInToolbar(o);}else{q.sap.log.info("A place holder of type 'sap.m.UploadCollectionPlaceholder' needs to be provided.");}}}else if(!this.getInstantUpload()){var p=this._aFileUploadersForPendingUpload.length;for(i=p-1;i>=0;i--){if(this._aFileUploadersForPendingUpload[i].getId()==this._oFileUploader.getId()){o=this._getFileUploader();this._oHeaderToolbar.insertAggregation("content",o,this._iFileUploaderPH,true);break;}}}};k.prototype._getFileUploaderPlaceHolderPosition=function(t){for(var i=0;i<t.getContent().length;i++){if(t.getContent()[i]instanceof sap.m.UploadCollectionToolbarPlaceholder){return i;}}return-1;};k.prototype._setFileUploaderInToolbar=function(o){this._oHeaderToolbar.getContent()[this._iFileUploaderPH].setVisible(false);this._oHeaderToolbar.insertContent(o,this._iFileUploaderPH);};k.prototype._mapItemToListItem=function(i){if(!i||(this._oItemToUpdate&&i.getId()===this._oItemToUpdate.getId())){return null;}var I,s,e,o,l,j,$,m,n,t=this;I=i.getId();s=i._status;e=i.getFileName();if(s===k._uploadingStatus){o=new sap.m.BusyIndicator(I+"-ia_indicator",{visible:true}).addStyleClass("sapMUCloadingIcon");}else{n=this._createIcon(i,I,e,t);}j=I+"-container";$=q.sap.byId(j);if(!!$){$.remove();$=null;}m=new sap.ui.core.HTML({content:"<span id="+j+" class= sapMUCTextButtonContainer> </span>",afterRendering:function(){t._renderContent(i,j,t);}});l=new sap.m.CustomListItem(I+"-cli",{content:[o,n,m],selected:i.getSelected()});l._oUploadCollectionItem=i;l._status=s;l.addStyleClass("sapMUCItem");return l;};k.prototype._renderContent=function(I,s,t){var e,i,A,S,m,p,j,l,r,n,o;p=I._percentUploaded;j=I.getAllAttributes();l=I.getStatuses();o=I.getMarkers();e=I.getId();A=j.length;S=l.length;m=o.length;n=I._status;r=t._RenderManager;r.write('<div class="sapMUCTextContainer ');if(n==="Edit"){r.write('sapMUCEditMode ');}r.write('" >');r.renderControl(this._getFileNameControl(I,t));if(n===k._uploadingStatus&&!(h.browser.msie&&h.browser.version<=9)){r.renderControl(this._createProgressLabel(e,p));}else{if(m>0){r.write('<div class="sapMUCObjectMarkerContainer">');for(i=0;i<m;i++){r.renderControl(o[i].addStyleClass("sapMUCObjectMarker"));}r.write('</div>');}if(A>0){r.write('<div class="sapMUCAttrContainer">');for(i=0;i<A;i++){j[i].addStyleClass("sapMUCAttr");r.renderControl(j[i]);if((i+1)<A){r.write('<div class="sapMUCSeparator">&nbsp&#x00B7&#160</div>');}}r.write('</div>');}if(S>0){r.write('<div class="sapMUCStatusContainer">');for(i=0;i<S;i++){l[i].detachBrowserEvent("hover");r.renderControl(l[i]);if((i+1)<S){r.write('<div class="sapMUCSeparator">&nbsp&#x00B7&#160</div>');}}r.write('</div>');}}r.write('</div>');this._renderButtons(r,I,n,e,t);r.flush(q.sap.byId(s)[0],true);this._truncateFileName(I);this._sReziseHandlerId=R.register(this,this._onResize.bind(this));h.orientation.attachHandler(this._onResize,this);};k.prototype._renderButtons=function(r,I,s,e,t){var j,l;j=this._getButtons(I,s,e,t);if(!!j){l=j.length;}if(l>0){r.write('<div class="sapMUCButtonContainer">');for(var i=0;i<l;i++){if((i+1)<l){j[i].addStyleClass("sapMUCFirstButton");}r.renderControl(j[i]);}r.write('</div>');}};k.prototype._getFileNameControl=function(i,t){var e,o,j,s,l,I,S,m,v,n,p,V;l=i.getFileName();I=i.getId();S=i._status;if(S!=="Edit"){e=true;if(this.sErrorState==="Error"||!q.trim(i.getUrl())){e=false;}o=sap.ui.getCore().byId(I+"-ta_filenameHL");if(!o){o=new sap.m.Link(I+"-ta_filenameHL",{enabled:e,press:function(E){this._triggerLink(E,t);}.bind(this)}).addStyleClass("sapMUCFileName");o.setModel(i.getModel());o.setText(l);}else{o.setModel(i.getModel());o.setText(l);o.setEnabled(e);}return o;}else{j=t._splitFilename(l);m=t.getMaximumFilenameLength();v="None";n=false;s=j.name;if(i.errorState==="Error"){n=true;v="Error";s=i.changedFileName;if(s.length===0){V=this._oRb.getText("UPLOADCOLLECTION_TYPE_FILENAME");}else{V=this._oRb.getText("UPLOADCOLLECTION_EXISTS");}}p=sap.ui.getCore().byId(I+"-ta_editFileName");if(!p){p=new sap.m.Input(I+"-ta_editFileName",{type:sap.m.InputType.Text,fieldWidth:"75%",valueState:v,valueStateText:V,showValueStateMessage:n,description:j.extension}).addStyleClass("sapMUCEditBox");p.setModel(i.getModel());p.setValue(s);}else{p.setModel(i.getModel());p.setValueState(v);p.setFieldWidth("75%");p.setValueStateText(V);p.setValue(s);p.setDescription(j.extension);p.setShowValueStateMessage(n);}if((m-j.extension.length)>0){p.setProperty("maxLength",m-j.extension.length,true);}return p;}};k.prototype._createProgressLabel=function(i,p){var P;P=sap.ui.getCore().byId(i+"-ta_progress");if(!P){P=new sap.m.Label(i+"-ta_progress",{text:this._oRb.getText("UPLOADCOLLECTION_UPLOADING",[p])}).addStyleClass("sapMUCProgress");}else{P.setText(this._oRb.getText("UPLOADCOLLECTION_UPLOADING",[p]));}return P;};k.prototype._createIcon=function(i,I,s,t){var T,e,o;T=i.getThumbnailUrl();if(T){o=new sap.m.Image(I+"-ia_imageHL",{src:sap.m.UploadCollection.prototype._getThumbnail(T,s),decorative:false,alt:this._getAriaLabelForPicture(i)}).addStyleClass("sapMUCItemImage");}else{e=sap.m.UploadCollection.prototype._getThumbnail(undefined,s);var S;o=new sap.ui.core.Icon(I+"-ia_iconHL",{src:e,decorative:false,useIconTooltip:false,alt:this._getAriaLabelForPicture(i)});if(this.sErrorState!=="Error"&&q.trim(i.getProperty("url"))){S="sapMUCItemIcon";}else{S="sapMUCItemIconInactive";}if(e===k._placeholderCamera){if(this.sErrorState!=="Error"&&q.trim(i.getProperty("url"))){S=S+" sapMUCItemPlaceholder";}else{S=S+" sapMUCItemPlaceholderInactive";}}o.addStyleClass(S);}if(this.sErrorState!=="Error"&&q.trim(i.getProperty("url"))){o.attachPress(function(E){sap.m.UploadCollection.prototype._triggerLink(E,t);});}return o;};k.prototype._getButtons=function(i,s,I,t){var e,o,j,l,m,E,n;e=[];if(!this.getInstantUpload()){l="deleteButton";m=this._createDeleteButton(I,l,i,this.sErrorState,t);e.push(m);return e;}if(s==="Edit"){o=sap.ui.getCore().byId(I+"-okButton");if(!o){o=new sap.m.Button({id:I+"-okButton",text:this._oRb.getText("UPLOADCOLLECTION_OKBUTTON_TEXT"),type:sap.m.ButtonType.Transparent}).addStyleClass("sapMUCOkBtn");}j=sap.ui.getCore().byId(I+"-cancelButton");if(!j){j=new sap.m.Button({id:I+"-cancelButton",text:this._oRb.getText("UPLOADCOLLECTION_CANCELBUTTON_TEXT"),type:sap.m.ButtonType.Transparent}).addStyleClass("sapMUCCancelBtn");}e.push(o);e.push(j);return e;}else if(s===k._uploadingStatus&&!(h.browser.msie&&h.browser.version<=9)){l="terminateButton";m=this._createDeleteButton(I,l,i,this.sErrorState,t);e.push(m);return e;}else{E=i.getEnableEdit();if(this.sErrorState==="Error"){E=false;}n=sap.ui.getCore().byId(I+"-editButton");if(!n){if(i.getVisibleEdit()){n=new sap.m.Button({id:I+"-editButton",icon:"sap-icon://edit",type:sap.m.ButtonType.Standard,enabled:E,visible:i.getVisibleEdit(),tooltip:this._oRb.getText("UPLOADCOLLECTION_EDITBUTTON_TEXT"),press:[i,this._handleEdit,this]}).addStyleClass("sapMUCEditBtn");e.push(n);}}else if(!i.getVisibleEdit()){n.destroy();n=null;}else{n.setEnabled(E);n.setVisible(i.getVisibleEdit());e.push(n);}l="deleteButton";if(i.getVisibleDelete()){m=this._createDeleteButton(I,l,i,this.sErrorState,t);e.push(m);}else{m=sap.ui.getCore().byId(I+"-"+l);if(!!m){m.destroy();m=null;}}return e;}};k.prototype._createDeleteButton=function(i,s,I,e,t){var E,o,j;E=I.getEnableDelete();if(e==="Error"){E=false;}o=sap.ui.getCore().byId(i+"-"+s);if(!o){o=new sap.m.Button({id:i+"-"+s,icon:"sap-icon://sys-cancel",type:sap.m.ButtonType.Standard,enabled:E,tooltip:this._oRb.getText("UPLOADCOLLECTION_TERMINATEBUTTON_TEXT"),visible:I.getVisibleDelete()}).addStyleClass("sapMUCDeleteBtn");if(s==="deleteButton"){o.setTooltip(this._oRb.getText("UPLOADCOLLECTION_DELETEBUTTON_TEXT"));o.attachPress(function(l){this._handleDelete(l,t);}.bind(t));}else if(s==="terminateButton"){if(!this.getTerminationEnabled()){o.setVisible(false);}o.attachPress(function(l){this._handleTerminate.bind(this)(l,I);}.bind(t));}}else{o.setEnabled(E);j=I.getVisibleDelete();if(s==="terminateButton"){j=j&&this.getTerminationEnabled();}o.setVisible(j);}return o;};k.prototype._fillList=function(i){var t=this;var m=i.length-1;q.each(i,function(I,o){if(!o._status){o._status=k._displayStatus;}else if(t.getInstantUpload()&&t._oItemForDelete&&t._oItemForDelete._status===k._toBeDeletedStatus&&o.getDocumentId()===t._oItemForDelete.documentId){return false;}if(!o._percentUploaded&&o._status===k._uploadingStatus){o._percentUploaded=0;}var l=t._mapItemToListItem(o);if(l){if(I===0&&m===0){l.addStyleClass("sapMUCListSingleItem");}else if(I===0){l.addStyleClass("sapMUCListFirstItem");}else if(I===m){l.addStyleClass("sapMUCListLastItem");}else{l.addStyleClass("sapMUCListItem");}t._oList.addAggregation("items",l,true);o.attachEvent("selected",t._handleItemSetSelected,t);}});t._oList.attachSelectionChange(t._handleSelectionChange,t);};k.prototype._clearList=function(){if(this._oList){this._oList.destroyAggregation("items",true);}};k.prototype._setNumberOfAttachmentsTitle=function(i){var n=i||0;var t;if(this._oItemToUpdate){n--;}if(this.getNumberOfAttachmentsText()){t=this.getNumberOfAttachmentsText();}else{t=this._oRb.getText("UPLOADCOLLECTION_ATTACHMENTS",[n]);}if(!this._oNumberOfAttachmentsTitle){this._oNumberOfAttachmentsTitle=new sap.m.Title(this.getId()+"-numberOfAttachmentsTitle",{text:t});}else{this._oNumberOfAttachmentsTitle.setText(t);}};k.prototype._setFileUploaderVisibility=function(u){var t=this._oHeaderToolbar.getContent();if(t){var p=t[this._iFileUploaderPH];if(p instanceof sap.ui.unified.FileUploader){p.setVisible(!u);}}};k.prototype._handleDelete=function(e,o){var p=e.getParameters();var I=o.getItems();var s=p.id.split("-deleteButton")[0];var j;var l;var m="";var n;var r;o.sDeletedItemId=s;for(var i=0;i<I.length;i++){if(I[i].sId===s){l=i;j={documentId:I[i].getDocumentId(),_iLineNumber:l};break;}}if(q.sap.byId(o.sId).hasClass("sapUiSizeCompact")){m="sapUiSizeCompact";}if(o.editModeItem){sap.m.UploadCollection.prototype._handleOk(e,o,o.editModeItem,true);if(o.sErrorState==="Error"){return this;}}if(I[l]&&I[l].getEnableDelete()){n=I[l].getFileName();if(!n){r=this._oRb.getText("UPLOADCOLLECTION_DELETE_WITHOUT_FILENAME_TEXT");}else{r=this._oRb.getText("UPLOADCOLLECTION_DELETE_TEXT",n);}o._oItemForDelete=j;sap.m.MessageBox.show(r,{title:this._oRb.getText("UPLOADCOLLECTION_DELETE_TITLE"),actions:[sap.m.MessageBox.Action.OK,sap.m.MessageBox.Action.CANCEL],onClose:o._onCloseMessageBoxDeleteItem.bind(o),dialogId:"messageBoxDeleteFile",styleClass:m});}};k.prototype._onCloseMessageBoxDeleteItem=function(A){var I=this.getItems();var o;if(this.getInstantUpload()){for(var i=0;i<I.length;i++){if(I[i].getDocumentId()===this._oItemForDelete.documentId){o=I[i];}}}else{o=I[this._oItemForDelete._iLineNumber];}if(A===sap.m.MessageBox.Action.OK){this._oItemForDelete._status=k._toBeDeletedStatus;if(this.getInstantUpload()){this.fireFileDeleted({documentId:this._oItemForDelete.documentId,item:o});}else{if(this.aItems.length===1){this.sFocusId=this._oFileUploader.$().find(":button")[0].id;}else{if(this._oItemForDelete._iLineNumber<this.aItems.length-1){this.sFocusId=this.aItems[this._oItemForDelete._iLineNumber+1].getId()+"-cli";}else{this.sFocusId=this.aItems[0].getId()+"-cli";}}this._aDeletedItemForPendingUpload.push(o);this.aItems.splice(this._oItemForDelete._iLineNumber,1);this.removeAggregation("items",o,false);}}};k.prototype._handleTerminate=function(e,I){var o,j;o=new sap.m.List({items:[new sap.m.StandardListItem({title:I.getFileName(),icon:this._getIconFromFilename(I.getFileName())})]});j=new sap.m.Dialog({id:this.getId()+"deleteDialog",title:this._oRb.getText("UPLOADCOLLECTION_TERMINATE_TITLE"),content:[new sap.m.Text({text:this._oRb.getText("UPLOADCOLLECTION_TERMINATE_TEXT")}),o],buttons:[new sap.m.Button({text:this._oRb.getText("UPLOADCOLLECTION_OKBUTTON_TEXT"),press:[l,this]}),new sap.m.Button({text:this._oRb.getText("UPLOADCOLLECTION_CANCELBUTTON_TEXT"),press:function(){j.close();}})],afterClose:function(){j.destroy();}}).open();function l(){var A=false;for(var i=0;i<this.aItems.length;i++){if(this.aItems[i]._status===k._uploadingStatus&&this.aItems[i]._requestIdName===I._requestIdName){A=true;break;}else if(I.getFileName()===this.aItems[i].getFileName()&&this.aItems[i]._status===k._displayStatus){this.aItems[i]._status=k._toBeDeletedStatus;this.fireFileDeleted({documentId:this.aItems[i].getDocumentId(),item:this.aItems[i]});break;}}if(A){this._getFileUploader().abort(this._headerParamConst.fileNameRequestIdName,this._encodeToAscii(I.getFileName())+this.aItems[i]._requestIdName);}j.close();this.invalidate();}};k.prototype._handleEdit=function(e,I){var i,s=I.getId(),j=this.aItems.length;if(this.editModeItem){sap.m.UploadCollection.prototype._handleOk(e,this,this.editModeItem,false);}if(this.sErrorState!=="Error"){for(i=0;i<j;i++){if(this.aItems[i].getId()===s){this.aItems[i]._status="Edit";break;}}I._status="Edit";this.editModeItem=e.getSource().getId().split("-editButton")[0];this.invalidate();}};k.prototype._handleClick=function(e,o,s){if(e.target.id.lastIndexOf("editButton")<0){if(e.target.id.lastIndexOf("cancelButton")>0){sap.m.UploadCollection.prototype._handleCancel(e,o,s);}else if(e.target.id.lastIndexOf("ia_imageHL")<0&&e.target.id.lastIndexOf("ia_iconHL")<0&&e.target.id.lastIndexOf("deleteButton")<0&&e.target.id.lastIndexOf("ta_editFileName-inner")<0){if(e.target.id.lastIndexOf("cli")>0){o.sFocusId=e.target.id;}sap.m.UploadCollection.prototype._handleOk(e,o,s,true);}}};k.prototype._handleOk=function(e,o,s,t){var E=document.getElementById(s+"-ta_editFileName-inner");var n;var S=k._findById(s,o.aItems);var i=S.getProperty("fileName");var j=k.prototype._splitFilename(i);var I=sap.ui.getCore().byId(s+"-ta_editFileName");var l=S.errorState;var m=S.changedFileName;if(E!==null){n=E.value.replace(/^\s+/,"");}var p=e.srcControl?e.srcControl.getId().split("-"):e.oSource.getId().split("-");p=p.slice(0,5);o.sFocusId=p.join("-")+"-cli";if(!n||n.length===0){if(E!==null){this._setErrorStateOnItem(o,S,n,m,l);}return;}S._status=k._displayStatus;if(j.name===n){this._removeErrorStateFromItem(o,S);if(t){o.invalidate();}return;}if(o.getSameFilenameAllowed()){this._removeErrorStateFromItem(o,S);o._oItemForRename=S;o._onEditItemOk.bind(o)(n+j.extension);return;}if(sap.m.UploadCollection.prototype._checkDoubleFileName(n+j.extension,o.aItems)){I.setProperty("valueState","Error",true);this._setErrorStateOnItem(o,S,n,m,l);}else{I.setProperty("valueState","None",true);S.changedFileName=null;this._removeErrorStateFromItem(o,S);if(t){o.invalidate();}o._oItemForRename=S;o._onEditItemOk.bind(o)(n+j.extension);}};k.prototype._setErrorStateOnItem=function(o,s,n,e,E){s._status="Edit";s.errorState="Error";o.sErrorState="Error";s.changedFileName=n;if(E!=="Error"||e!==n){o.invalidate();}};k.prototype._removeErrorStateFromItem=function(o,s){s.errorState=null;o.sErrorState=null;o.editModeItem=null;};k.prototype._onEditItemOk=function(n){if(this._oItemForRename){this._oItemForRename.setFileName(n);this.fireFileRenamed({documentId:this._oItemForRename.getProperty("documentId"),fileName:n,item:this._oItemForRename});}delete this._oItemForRename;};k.prototype._handleCancel=function(e,o,s){var S=k._findById(s,o.aItems);S._status=k._displayStatus;S.errorState=null;S.changedFileName=sap.ui.getCore().byId(s+"-ta_editFileName").getProperty("value");o.sFocusId=o.editModeItem+"-cli";o.sErrorState=null;o.editModeItem=null;o.invalidate();};k.prototype._onChange=function(e){if(e){var t=this;var r,j,i,s,I,S,l,A;if(h.browser.msie&&h.browser.version<=9){var n=e.getParameter("newValue");if(!n){return;}s=n.split(/\" "/)[0];if(s.length===0){return;}}else{j=e.getParameter("files").length;if(j===0){return;}this._oFileUploader.removeAllAggregation("headerParameters",true);this.removeAllAggregation("headerParameters",true);}this._oFileUploader.removeAllAggregation("parameters",true);this.removeAllAggregation("parameters",true);if(h.browser.msie&&h.browser.version<=9){var o={name:e.getParameter("newValue")};var p={files:[o]};this.fireChange({getParameter:function(u){if(u==="files"){return[o];}},getParameters:function(){return p;},mParameters:p,files:[o]});}else{this.fireChange({getParameter:function(u){if(u){return e.getParameter(u);}},getParameters:function(){return e.getParameters();},mParameters:e.getParameters(),files:e.getParameter("files")});}var P=this.getAggregation("parameters");if(P){q.each(P,function(u,v){var w=new sap.ui.unified.FileUploaderParameter({name:v.getProperty("name"),value:v.getProperty("value")});t._oFileUploader.addParameter(w);});}if(!this.getInstantUpload()){this._bFocusFileUploader=true;S=k._pendingUploadStatus;}else{S=k._uploadingStatus;}if(h.browser.msie&&h.browser.version<=9){I=new sap.m.UploadCollectionItem({fileName:s});I._status=S;I._internalFileIndexWithinFileUploader=1;if(!this.getInstantUpload()){I.setAssociation("fileUploader",this._oFileUploader,true);this.insertItem(I);this._aFileUploadersForPendingUpload.push(this._oFileUploader);}else{I._percentUploaded=0;}this.aItems.unshift(I);}else{this._requestIdValue=this._requestIdValue+1;r=this._requestIdValue.toString();var m=this.getAggregation("headerParameters");if(!this.getInstantUpload()){this._aFileUploadersForPendingUpload.push(this._oFileUploader);}for(i=0;i<j;i++){I=new L.UploadCollectionItem({fileName:e.getParameter("files")[i].name});I._status=S;I._internalFileIndexWithinFileUploader=i+1;I._requestIdName=r;if(!this.getInstantUpload()){I.setAssociation("fileUploader",this._oFileUploader,true);l=this._oFormatDecimal.format(e.getParameter("files")[i].size);A=new d({text:l});I.insertAggregation("attributes",A,true);this.insertItem(I);}else{I._percentUploaded=0;}this.aItems.unshift(I);}if(m){q.each(m,function(u,v){t._oFileUploader.addHeaderParameter(new sap.ui.unified.FileUploaderParameter({name:v.getProperty("name"),value:v.getProperty("value")}));});}t._oFileUploader.addHeaderParameter(new sap.ui.unified.FileUploaderParameter({name:this._headerParamConst.requestIdName,value:r}));}}};k.prototype._onFilenameLengthExceed=function(e){var o={name:e.getParameter("fileName")};var i=[o];this.fireFilenameLengthExceed({getParameter:function(p){if(p){return e.getParameter(p);}},getParameters:function(){return e.getParameters();},mParameters:e.getParameters(),files:i});};k.prototype._onFileSizeExceed=function(e){var o;if(h.browser.msie&&h.browser.version<=9){var s=e.getParameter("newValue");o={name:s};var p={newValue:s,files:[o]};this.fireFileSizeExceed({getParameter:function(P){if(P==="files"){return[o];}else if(P==="newValue"){return s;}},getParameters:function(){return p;},mParameters:p,files:[o]});}else{o={name:e.getParameter("fileName"),fileSize:e.getParameter("fileSize")};this.fireFileSizeExceed({getParameter:function(P){if(P){return e.getParameter(P);}},getParameters:function(){return e.getParameters();},mParameters:e.getParameters(),files:[o]});}};k.prototype._onTypeMissmatch=function(e){var o={name:e.getParameter("fileName"),fileType:e.getParameter("fileType"),mimeType:e.getParameter("mimeType")};var i=[o];this.fireTypeMissmatch({getParameter:function(p){if(p){return e.getParameter(p);}},getParameters:function(){return e.getParameters();},mParameters:e.getParameters(),files:i});};k.prototype._onUploadTerminated=function(e){var i;var r=this._getRequestId(e);var s=e.getParameter("fileName");var j=this.aItems.length;for(i=0;i<j;i++){if(this.aItems[i]&&this.aItems[i].getFileName()===s&&this.aItems[i]._requestIdName===r&&this.aItems[i]._status===k._uploadingStatus){this.aItems.splice(i,1);this.removeItem(i);break;}}this.fireUploadTerminated({fileName:s,getHeaderParameter:this._getHeaderParameterWithinEvent.bind(e)});};k.prototype._onUploadComplete=function(e){if(e){var i,r,u,j,l=n();r=this._getRequestId(e);u=e.getParameter("fileName");if(!u){var m=(e.getSource().getProperty("value")).split(/\" "/);u=m[0];}j=this.aItems.length;for(i=0;i<j;i++){if(!r){if(this.aItems[i].getProperty("fileName")===u&&this.aItems[i]._status===k._uploadingStatus&&l){this.aItems[i]._percentUploaded=100;this.aItems[i]._status=k._displayStatus;this._oItemToUpdate=null;break;}else if(this.aItems[i].getProperty("fileName")===u&&this.aItems[i]._status===k._uploadingStatus){this.aItems.splice(i,1);this._oItemToUpdate=null;break;}}else if(this.aItems[i].getProperty("fileName")===u&&this.aItems[i]._requestIdName===r&&this.aItems[i]._status===k._uploadingStatus&&l){this.aItems[i]._percentUploaded=100;this.aItems[i]._status=k._displayStatus;this._oItemToUpdate=null;break;}else if(this.aItems[i].getProperty("fileName")===u&&this.aItems[i]._requestIdName===r&&this.aItems[i]._status===k._uploadingStatus||this.aItems[i]._status===k._pendingUploadStatus){this.aItems.splice(i,1);this._oItemToUpdate=null;break;}}this.fireUploadComplete({getParameter:e.getParameter,getParameters:e.getParameters,mParameters:e.getParameters(),files:[{fileName:e.getParameter("fileName")||u,responseRaw:e.getParameter("responseRaw"),reponse:e.getParameter("response"),status:e.getParameter("status"),headers:e.getParameter("headers")}]});}this.invalidate();function n(){var s=e.getParameter("status").toString()||"200";if(s[0]==="2"||s[0]==="3"){return true;}else{return false;}}};k.prototype._onUploadProgress=function(e){if(e){var i,u,p,P,r,j,o,I,$;u=e.getParameter("fileName");r=this._getRequestId(e);P=Math.round(e.getParameter("loaded")/e.getParameter("total")*100);if(P===100){p=this._oRb.getText("UPLOADCOLLECTION_UPLOAD_COMPLETED");}else{p=this._oRb.getText("UPLOADCOLLECTION_UPLOADING",[P]);}j=this.aItems.length;for(i=0;i<j;i++){if(this.aItems[i].getProperty("fileName")===u&&this.aItems[i]._requestIdName==r&&this.aItems[i]._status===k._uploadingStatus){o=sap.ui.getCore().byId(this.aItems[i].getId()+"-ta_progress");if(!!o){o.setText(p);this.aItems[i]._percentUploaded=P;I=this.aItems[i].getId();$=q.sap.byId(I+"-ia_indicator");if(P===100){$.attr("aria-label",p);}else{$.attr("aria-valuenow",P);}break;}}}}};k.prototype._getRequestId=function(e){var o;o=e.getParameter("requestHeaders");if(!o){return null;}for(var j=0;j<o.length;j++){if(o[j].name===this._headerParamConst.requestIdName){return o[j].value;}}};k.prototype._getFileUploader=function(){var t=this,u=this.getInstantUpload();if(!u||!this._oFileUploader){var s=(h.browser.msie&&h.browser.version<=9)?false:true;this._iFUCounter=this._iFUCounter+1;this._oFileUploader=new sap.ui.unified.FileUploader(this.getId()+"-"+this._iFUCounter+"-uploader",{buttonOnly:true,buttonText:" ",tooltip:this.getInstantUpload()?this._oRb.getText("UPLOADCOLLECTION_UPLOAD"):this._oRb.getText("UPLOADCOLLECTION_ADD"),iconOnly:true,enabled:this.getUploadEnabled(),fileType:this.getFileType(),icon:"sap-icon://add",iconFirst:false,style:"Transparent",maximumFilenameLength:this.getMaximumFilenameLength(),maximumFileSize:this.getMaximumFileSize(),mimeType:this.getMimeType(),multiple:this.getMultiple(),name:"uploadCollection",uploadOnChange:u,sameFilenameAllowed:true,uploadUrl:this.getUploadUrl(),useMultipart:false,sendXHR:s,change:function(e){t._onChange(e);},filenameLengthExceed:function(e){t._onFilenameLengthExceed(e);},fileSizeExceed:function(e){t._onFileSizeExceed(e);},typeMissmatch:function(e){t._onTypeMissmatch(e);},uploadAborted:function(e){t._onUploadTerminated(e);},uploadComplete:function(e){t._onUploadComplete(e);},uploadProgress:function(e){if(t.getInstantUpload()){t._onUploadProgress(e);}},uploadStart:function(e){t._onUploadStart(e);},visible:!this.getUploadButtonInvisible()});}return this._oFileUploader;};k.prototype._onUploadStart=function(e){var r={},i,s,p,j,G;this._iUploadStartCallCounter++;p=e.getParameter("requestHeaders").length;for(i=0;i<p;i++){if(e.getParameter("requestHeaders")[i].name===this._headerParamConst.requestIdName){s=e.getParameter("requestHeaders")[i].value;break;}}j=e.getParameter("fileName");r={name:this._headerParamConst.fileNameRequestIdName,value:this._encodeToAscii(j)+s};e.getParameter("requestHeaders").push(r);for(i=0;i<this._aDeletedItemForPendingUpload.length;i++){if(this._aDeletedItemForPendingUpload[i].getAssociation("fileUploader")===e.oSource.sId&&this._aDeletedItemForPendingUpload[i].getFileName()===j&&this._aDeletedItemForPendingUpload[i]._internalFileIndexWithinFileUploader===this._iUploadStartCallCounter){e.getSource().abort(this._headerParamConst.fileNameRequestIdName,this._encodeToAscii(j)+s);return;}}this.fireBeforeUploadStarts({fileName:j,addHeaderParameter:l,getHeaderParameter:m.bind(this)});if(q.isArray(G)){for(i=0;i<G.length;i++){if(e.getParameter("requestHeaders")[i].name===G[i].getName()){e.getParameter("requestHeaders")[i].value=G[i].getValue();}}}else if(G instanceof sap.m.UploadCollectionParameter){for(i=0;i<e.getParameter("requestHeaders").length;i++){if(e.getParameter("requestHeaders")[i].name===G.getName()){e.getParameter("requestHeaders")[i].value=G.getValue();break;}}}function l(u){var r={name:u.getName(),value:u.getValue()};e.getParameter("requestHeaders").push(r);}function m(n){G=this._getHeaderParameterWithinEvent.bind(e)(n);return G;}};k.prototype._getIconFromFilename=function(s){var e=this._splitFilename(s).extension;if(q.type(e)==="string"){e=e.toLowerCase();}switch(e){case'.bmp':case'.jpg':case'.jpeg':case'.png':return k._placeholderCamera;case'.csv':case'.xls':case'.xlsx':return'sap-icon://excel-attachment';case'.doc':case'.docx':case'.odt':return'sap-icon://doc-attachment';case'.pdf':return'sap-icon://pdf-attachment';case'.ppt':case'.pptx':return'sap-icon://ppt-attachment';case'.txt':return'sap-icon://document-text';default:return'sap-icon://document';}};k.prototype._getThumbnail=function(t,s){if(t){return t;}else{return this._getIconFromFilename(s);}};k.prototype._triggerLink=function(e,o){var l=null;var i;if(o.editModeItem){sap.m.UploadCollection.prototype._handleOk(e,o,o.editModeItem,true);if(o.sErrorState==="Error"){return this;}o.sFocusId=e.getParameter("id");}i=e.oSource.getId().split("-");l=i[i.length-2];sap.m.URLHelper.redirect(o.aItems[l].getProperty("url"),true);};k.prototype.onkeydown=function(e){switch(e.keyCode){case q.sap.KeyCodes.F2:sap.m.UploadCollection.prototype._handleF2(e,this);break;case q.sap.KeyCodes.ESCAPE:sap.m.UploadCollection.prototype._handleESC(e,this);break;case q.sap.KeyCodes.DELETE:sap.m.UploadCollection.prototype._handleDEL(e,this);break;case q.sap.KeyCodes.ENTER:sap.m.UploadCollection.prototype._handleENTER(e,this);break;default:return;}e.setMarked();};k.prototype._setFocusAfterDeletion=function(e,o){if(!e){return;}var l=o.aItems.length;var s=null;if(l===0){var i=q.sap.byId(o._oFileUploader.sId);var j=i.find(":button");q.sap.focus(j);}else{var m=e.split("-").pop();if((l-1)>=m){s=e+"-cli";}else{s=o.aItems.pop().sId+"-cli";}sap.m.UploadCollection.prototype._setFocus2LineItem(s);this.sDeletedItemId=null;}};k.prototype._setFocus2LineItem=function(s){q.sap.byId(s).focus();};k.prototype._handleENTER=function(e,o){var t;var l;var i;if(o.editModeItem){t=e.target.id.split(o.editModeItem).pop();}else{t=e.target.id.split("-").pop();}switch(t){case"-ta_editFileName-inner":case"-okButton":sap.m.UploadCollection.prototype._handleOk(e,o,o.editModeItem,true);break;case"-cancelButton":e.preventDefault();sap.m.UploadCollection.prototype._handleCancel(e,o,o.editModeItem);break;case"-ia_iconHL":case"-ia_imageHL":var j=o.editModeItem.split("-").pop();sap.m.URLHelper.redirect(o.aItems[j].getProperty("url"),true);break;case"ia_iconHL":case"ia_imageHL":case"cli":l=e.target.id.split(t)[0]+"ta_filenameHL";i=sap.ui.getCore().byId(l);if(i.getEnabled()){j=e.target.id.split("-")[2];sap.m.URLHelper.redirect(o.aItems[j].getProperty("url"),true);}break;default:return;}};k.prototype._handleDEL=function(e,o){if(!o.editModeItem){var i=q.sap.byId(e.target.id);var j=i.find("[id$='-deleteButton']");var l=sap.ui.getCore().byId(j[0].id);l.firePress();}};k.prototype._handleESC=function(e,o){if(o.editModeItem){o.sFocusId=o.editModeItem+"-cli";o.aItems[o.editModeItem.split("-").pop()]._status=k._displayStatus;sap.m.UploadCollection.prototype._handleCancel(e,o,o.editModeItem);}};k.prototype._handleF2=function(e,o){var i=sap.ui.getCore().byId(e.target.id);if(i!==undefined){if(i._status===k._displayStatus){var j=q.sap.byId(e.target.id);var l=j.find("[id$='-editButton']");var E=sap.ui.getCore().byId(l[0].id);if(E.getEnabled()){if(o.editModeItem){sap.m.UploadCollection.prototype._handleClick(e,o,o.editModeItem);}if(o.sErrorState!=="Error"){E.firePress();}}}else{sap.m.UploadCollection.prototype._handleClick(e,o,o.editModeItem);}}else if(e.target.id.search(o.editModeItem)===0){sap.m.UploadCollection.prototype._handleOk(e,o,o.editModeItem,true);}};k.prototype._getFileNames=function(s){if(this.getMultiple()&&!(h.browser.msie&&h.browser.version<=9)){return s.substring(1,s.length-2).split(/\" "/);}else{return s.split(/\" "/);}};k.prototype._checkDoubleFileName=function(s,I){if(I.length===0||!s){return false;}var l=I.length;s=s.replace(/^\s+/,"");for(var i=0;i<l;i++){if(s===I[i].getProperty("fileName")){return true;}}return false;};k.prototype._splitFilename=function(s){var r={};var n=s.split(".");if(n.length==1){r.extension="";r.name=n.pop();return r;}r.extension="."+n.pop();r.name=n.join(".");return r;};k.prototype._getAriaLabelForPicture=function(i){var t;t=(i.getAriaLabelForPicture()||i.getFileName());return t;};k.prototype._getHeaderParameterWithinEvent=function(s){var u=[];var r=this.getParameter("requestHeaders");var p=r.length;var i;if(r&&s){for(i=0;i<p;i++){if(r[i].name===s){return new sap.m.UploadCollectionParameter({name:r[i].name,value:r[i].value});}}}else{if(r){for(i=0;i<p;i++){u.push(new sap.m.UploadCollectionParameter({name:r[i].name,value:r[i].value}));}}return u;}};k.prototype._encodeToAscii=function(v){var e="";for(var i=0;i<v.length;i++){e=e+v.charCodeAt(i);}return e;};k.prototype._onResize=function(){var l=this._oList.getItems();for(var i=0;i<l.length;i++){q.sap.delayedCall(k._resizeTimeoutInterval,this,this._truncateFileName.bind(this),[l[i]._oUploadCollectionItem]);}};k.prototype._getUploadCollectionItemByListItem=function(l){var A=this.getItems();for(var i=0;i<A.length;i++){if(A[i].getId()===l.getId().replace("-cli","")){return A[i];}}return null;};k.prototype._getUploadCollectionItemById=function(u){var A=this.getItems();for(var i=0;i<A.length;i++){if(A[i].getId()===u){return A[i];}}return null;};k.prototype._getUploadCollectionItemsByListItems=function(l){var u=[];var e=this.getItems();if(l){for(var i=0;i<l.length;i++){for(var j=0;j<e.length;j++){if(l[i].getId().replace("-cli","")===e[j].getId()){u.push(e[j]);break;}}}return u;}return null;};k.prototype._setSelectedForItems=function(u,s){if(this.getMode()!==sap.m.ListMode.MultiSelect&&s){var e=this.getItems();for(var j=0;j<e.length;j++){e[j].setSelected(false);}}for(var i=0;i<u.length;i++){u[i].setSelected(s);}};k.prototype._handleItemSetSelected=function(e){var i=e.getSource();if(i instanceof sap.m.UploadCollectionItem){var l=this._getListItemById(i.getId()+"-cli");if(l){l.setSelected(i.getSelected());}}};k.prototype._handleSelectionChange=function(e){var l=e.getParameter("listItem");var s=e.getParameter("selected");var u=this._getUploadCollectionItemsByListItems(e.getParameter("listItems"));var o=this._getUploadCollectionItemByListItem(l);if(o&&l&&u){this.fireSelectionChange({selectedItem:o,selectedItems:u,selected:s});o.setSelected(l.getSelected());}};k.prototype._getListItemById=function(l){var e=this._oList.getItems();return k._findById(l,e);};k._findById=function(l,e){for(var i=0;i<e.length;i++){if(e[i].getId()===l){return e[i];}}return null;};return k;},true);
