/*
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/base/ManagedObject','./Manifest','./ComponentMetadata','./Core','sap/ui/thirdparty/URI','jquery.sap.trace'],function(q,M,a,C,b,U){"use strict";function c(u,o){['sap-client','sap-server'].forEach(function(n){var v=u.get(n);if(v&&!o.hasSearch(n)){o.addSearch(n,v);}});}function d(D,m,s,S){if(s){for(var n in D){if(!m[n]&&s[n]&&s[n].uri){m[n]=S;}}}}function g(m,o,k,e){var D=o.getEntry(k);if(D!==undefined&&!q.isPlainObject(D)){return D;}var p,P;if(e&&(p=m.getParent())instanceof C){P=p.getManifestEntry(k,e);}if(P||D){D=q.extend(true,{},P,D);}return D;}function f(o,e){var i=Object.create(Object.getPrototypeOf(o));i._oMetadata=o;i._oManifest=e;for(var m in o){if(!/^(getManifest|getManifestEntry|getMetadataVersion)$/.test(m)&&typeof o[m]==="function"){i[m]=o[m].bind(o);}}i.getManifest=function(){return e&&e.getJson();};i.getManifestEntry=function(k,j){return g(o,e,k,j);};i.getMetadataVersion=function(){return 2;};return i;}function r(e,o){var i=M._sOwnerId;try{M._sOwnerId=o;return e.call();}finally{M._sOwnerId=i;}}var h=M.extend("sap.ui.core.Component",{constructor:function(i,s){var e=Array.prototype.slice.call(arguments);if(typeof i!=="string"){s=i;i=undefined;}if(s&&typeof s._metadataProxy==="object"){this._oMetadataProxy=s._metadataProxy;this._oManifest=s._metadataProxy._oManifest;delete s._metadataProxy;this.getMetadata=function(){return this._oMetadataProxy;};}if(s&&typeof s._manifestModels==="object"){this._mManifestModels=s._manifestModels;delete s._manifestModels;}else{this._mManifestModels={};}this._mServices={};M.apply(this,e);},metadata:{stereotype:"component","abstract":true,specialSettings:{componentData:'any'},version:"0.0",includes:[],dependencies:{libs:[],components:[],ui5version:""},config:{},customizing:{},library:"sap.ui.core"}},C);h.prototype.getManifest=function(){if(!this._oManifest){return this.getMetadata().getManifest();}else{return this._oManifest.getJson();}};h.prototype.getManifestEntry=function(k){return this._getManifestEntry(k);};h.prototype._getManifestEntry=function(k,m){if(!this._oManifest){return this.getMetadata().getManifestEntry(k,m);}else{return g(this.getMetadata(),this._oManifest,k,m);}};h.prototype.getManifestObject=function(){if(!this._oManifest){return this.getMetadata().getManifestObject();}else{return this._oManifest;}};h.activateCustomizing=function(s){};h.deactivateCustomizing=function(s){};h.getOwnerIdFor=function(o){var O=(o instanceof M)&&o._sOwnerId;return O||undefined;};h.getOwnerComponentFor=function(o){var O=h.getOwnerIdFor(o);return O&&sap.ui.component(O);};h.prototype.runAsOwner=function(e){return r(e,this.getId());};h.prototype.getInterface=function(){return this;};h.prototype._initCompositeSupport=function(s){if(this._oManifest){var m=this.getManifest();var u=m&&m["sap.ui5"];var e=u&&u["extends"];var E=e&&e["extensions"];if(E){var i=sap.ui.requireSync('sap/ui/core/CustomizingConfiguration');i.activateForComponentInstance(this);}}this.getMetadata().onInitComponent();this.oComponentData=s&&s.componentData;this.getMetadata().init();this.initComponentModels();if(this.onWindowError){this._fnWindowErrorHandler=q.proxy(function(o){var j=o.originalEvent;this.onWindowError(j.message,j.filename,j.lineno);},this);q(window).bind("error",this._fnWindowErrorHandler);}if(this.onWindowBeforeUnload){this._fnWindowBeforeUnloadHandler=q.proxy(this.onWindowBeforeUnload,this);q(window).bind("beforeunload",this._fnWindowBeforeUnloadHandler);}if(this.onWindowUnload){this._fnWindowUnloadHandler=q.proxy(this.onWindowUnload,this);q(window).bind("unload",this._fnWindowUnloadHandler);}};h.prototype.destroy=function(){if(typeof this._mServices==="object"){for(var L in this._mServices){this._mServices[L].instance.destroy();delete this._mServices[L];}this._mServices=null;}if(typeof this._mManifestModels==='object'){for(var m in this._mManifestModels){this._mManifestModels[m].destroy();}this._mManifestModels=null;}if(this._fnWindowErrorHandler){q(window).unbind("error",this._fnWindowErrorHandler);delete this._fnWindowErrorHandler;}if(this._fnWindowBeforeUnloadHandler){q(window).unbind("beforeunload",this._fnWindowBeforeUnloadHandler);delete this._fnWindowBeforeUnloadHandler;}if(this._fnWindowUnloadHandler){q(window).unbind("unload",this._fnWindowUnloadHandler);delete this._fnWindowUnloadHandler;}if(this._oEventBus){this._oEventBus.destroy();delete this._oEventBus;}M.prototype.destroy.apply(this,arguments);sap.ui.getCore().getMessageManager().unregisterObject(this);if(this._oManifest){var e=sap.ui.require('sap/ui/core/CustomizingConfiguration');if(e){e.deactivateForComponentInstance(this);}}this.getMetadata().onExitComponent();};h.prototype.getComponentData=function(){return this.oComponentData;};h.prototype.getEventBus=function(){if(!this._oEventBus){var E=sap.ui.requireSync("sap/ui/core/EventBus");this._oEventBus=new E();}return this._oEventBus;};h.prototype.initComponentModels=function(){var m=this.getMetadata();if(m.isBaseClass()){return;}var o=this._getManifestEntry("/sap.app/dataSources",true)||{};var e=this._getManifestEntry("/sap.ui5/models",true)||{};this._initComponentModels(e,o);};h.prototype._initComponentModels=function(m,D){var A=h._createManifestModelConfigurations({models:m,dataSources:D,component:this,mergeParent:true});if(!A){return;}var e={};for(var s in A){if(!this._mManifestModels[s]){e[s]=A[s];}}var i=h._createManifestModels(e,this.toString());for(var s in i){this._mManifestModels[s]=i[s];}for(var s in this._mManifestModels){var o=this._mManifestModels[s];this.setModel(o,s||undefined);}};h.prototype.getService=function(L){var S=sap.ui.requireSync("sap/ui/core/service/ServiceFactoryRegistry");return new Promise(function(R,e){var s=this._mServices&&this._mServices[L];if(!s){var i=this.getManifestEntry("/sap.ui5/services/"+L+"/factoryName");if(!i){e(new Error("Service "+L+" not declared!"));return;}var o=S.get(i);if(o){o.createInstance({scopeObject:this,scopeType:"component"}).then(function(j){s=this._mServices[L]={"instance":j,"interface":j.getInterface()};R(s.interface);}.bind(this)).catch(e);}else{var E="The ServiceFactory "+i+" for Service "+L+" not found in ServiceFactoryRegistry!";var O=this.getManifestEntry("/sap.ui5/services/"+L+"/optional");if(!O){q.sap.log.error(E);}e(new Error(E));}}else{R(s.interface);}}.bind(this));};h._createManifestModelConfigurations=function(o){var e=o.component;var m=o.manifest||e.getManifestObject();var j=o.mergeParent;var L=e?e.toString():m.getComponentName();if(!o.models){return null;}var k={models:o.models,dataSources:o.dataSources||{},origin:{dataSources:{},models:{}}};if(e&&j){var n=e.getMetadata();while(n&&n instanceof C){var p=n.getManifestObject();var s=n.getManifestEntry("/sap.app/dataSources");d(k.dataSources,k.origin.dataSources,s,p);var t=n.getManifestEntry("/sap.ui5/models");d(k.models,k.origin.models,t,p);n=n.getParent();}}var u=q.sap.getUriParameters();var v={};for(var w in k.models){var x=k.models[w];var I=false;if(typeof x==='string'){x={dataSource:x};}if(x.dataSource){var D=k.dataSources&&k.dataSources[x.dataSource];if(typeof D==='object'){if(D.type===undefined){D.type='OData';}if(!x.type){switch(D.type){case'OData':if(D.settings&&D.settings.odataVersion==="4.0"){x.type='sap.ui.model.odata.v4.ODataModel';}else{x.type='sap.ui.model.odata.v2.ODataModel';}break;case'JSON':x.type='sap.ui.model.json.JSONModel';break;case'XML':x.type='sap.ui.model.xml.XMLModel';break;default:}}if(!x.uri){x.uri=D.uri;I=true;}if(D.type==='OData'&&D.settings&&typeof D.settings.maxAge==="number"){x.settings=x.settings||{};x.settings.headers=x.settings.headers||{};x.settings.headers["Cache-Control"]="max-age="+D.settings.maxAge;}if(D.type==='OData'&&D.settings&&D.settings.annotations){var A=D.settings.annotations;for(var i=0;i<A.length;i++){var y=k.dataSources[A[i]];if(!y){q.sap.log.error("Component Manifest: ODataAnnotation \""+A[i]+"\" for dataSource \""+x.dataSource+"\" could not be found in manifest","[\"sap.app\"][\"dataSources\"][\""+A[i]+"\"]",L);continue;}if(y.type!=='ODataAnnotation'){q.sap.log.error("Component Manifest: dataSource \""+A[i]+"\" was expected to have type \"ODataAnnotation\" but was \""+y.type+"\"","[\"sap.app\"][\"dataSources\"][\""+A[i]+"\"]",L);continue;}if(!y.uri){q.sap.log.error("Component Manifest: Missing \"uri\" for ODataAnnotation \""+A[i]+"\"","[\"sap.app\"][\"dataSources\"][\""+A[i]+"\"]",L);continue;}var z=k.origin.dataSources[A[i]]||m;var B=z.resolveUri(new U(y.uri)).toString();x.settings=x.settings||{};x.settings.annotationURI=x.settings.annotationURI||[];x.settings.annotationURI.push(B);}}}else{q.sap.log.error("Component Manifest: dataSource \""+x.dataSource+"\" for model \""+w+"\" not found or invalid","[\"sap.app\"][\"dataSources\"][\""+x.dataSource+"\"]",L);}}if(!x.type){q.sap.log.error("Component Manifest: Missing \"type\" for model \""+w+"\"","[\"sap.ui5\"][\"models\"][\""+w+"\"]",L);continue;}if(x.type==='sap.ui.model.odata.ODataModel'&&(!x.settings||x.settings.json===undefined)){x.settings=x.settings||{};x.settings.json=true;}if(x.uri){var E=new U(x.uri);var F=(I?k.origin.dataSources[x.dataSource]:k.origin.models[w])||m;E=F.resolveUri(E);if(x.dataSource){c(u,E);}x.uri=E.toString();}if(x.uriSettingName===undefined){switch(x.type){case'sap.ui.model.odata.ODataModel':case'sap.ui.model.odata.v2.ODataModel':case'sap.ui.model.odata.v4.ODataModel':x.uriSettingName='serviceUrl';break;case'sap.ui.model.resource.ResourceModel':x.uriSettingName='bundleUrl';break;default:}}var S;var G;if(e){G=e.getComponentData();}else{G=o.componentData;}S=G&&G.startupParameters&&G.startupParameters["sap-system"];if(!S){S=u.get("sap-system");}var H=false;var O;if(S&&["sap.ui.model.odata.ODataModel","sap.ui.model.odata.v2.ODataModel"].indexOf(x.type)!=-1){H=true;O=sap.ui.requireSync("sap/ui/model/odata/ODataUtils");}if(x.uri){if(H){x.preOriginBaseUri=x.uri.split("?")[0];x.uri=O.setOrigin(x.uri,{alias:S});x.postOriginBaseUri=x.uri.split("?")[0];}if(x.uriSettingName!==undefined){x.settings=x.settings||{};if(!x.settings[x.uriSettingName]){x.settings[x.uriSettingName]=x.uri;}}else if(x.settings){x.settings=[x.uri,x.settings];}else{x.settings=[x.uri];}}else{if(H&&x.uriSettingName!==undefined&&x.settings&&x.settings[x.uriSettingName]){x.preOriginBaseUri=x.settings[x.uriSettingName].split("?")[0];x.settings[x.uriSettingName]=O.setOrigin(x.settings[x.uriSettingName],{alias:S});x.postOriginUri=x.settings[x.uriSettingName].split("?")[0];}}if(H&&x.settings&&x.settings.annotationURI){var J=[].concat(x.settings.annotationURI);var K=[];for(var i=0;i<J.length;i++){K.push(J[i].replace(x.preOriginBaseUri,x.postOriginBaseUri.split("?")[0]));}x.settings.annotationURI=K;}if(x.settings&&!q.isArray(x.settings)){x.settings=[x.settings];}v[w]=x;}return v;};h._createManifestModels=function(m,L){var e={};for(var s in m){var o=m[s];try{q.sap.require(o.type);}catch(E){q.sap.log.error("Component Manifest: Class \""+o.type+"\" for model \""+s+"\" could not be loaded. "+E,"[\"sap.ui5\"][\"models\"][\""+s+"\"]",L);continue;}var i=q.sap.getObject(o.type);if(!i){q.sap.log.error("Component Manifest: Class \""+o.type+"\" for model \""+s+"\" could not be found","[\"sap.ui5\"][\"models\"][\""+s+"\"]",L);continue;}var A=[null].concat(o.settings||[]);var F=i.bind.apply(i,A);var j=new F();e[s]=j;}return e;};h._fnLoadComponentCallback=null;sap.ui.component=function(v){if(!v){throw new Error("sap.ui.component cannot be called without parameter!");}if(typeof v==='string'){return sap.ui.getCore().getComponent(v);}function e(o){var n=v.name,I=v.id,j=v.componentData,k=n+'.Component',S=v.settings;var m=new o(q.extend({},S,{id:I,componentData:j}));q.sap.log.info("Component instance Id = "+m.getId());var H=m.getMetadata().handleValidation()!==undefined||v.handleValidation;if(H){if(m.getMetadata().handleValidation()!==undefined){H=m.getMetadata().handleValidation();}else{H=v.handleValidation;}sap.ui.getCore().getMessageManager().registerObject(m,H);}return m;}var i=l(v,{failOnError:true,createModels:true,waitFor:v.asyncHints&&v.asyncHints.waitFor});if(v.async){var s=M._sOwnerId;return i.then(function(o){return r(function(){return e(o);},s);});}else{return e(i);}};sap.ui.component.load=function(o,F){return l(o,{failOnError:F,preloadOnly:o.asyncHints&&o.asyncHints.preloadOnly});};function l(o,O){var n=o.name,u=o.url,j=sap.ui.getCore().getConfiguration(),k=/^(sync|async)$/.test(j.getComponentPreload()),m=typeof o.manifestFirst!=="undefined"?o.manifestFirst:j.getManifestFirst(),p,s,t;q.sap.interaction.setStepComponent(n);if(o.manifestUrl){p=a.load({manifestUrl:o.manifestUrl,componentName:n,async:o.async});}if(p&&!o.async){n=p.getComponentName();}if(!(p&&o.async)){if(!n){throw new Error("The name of the component is undefined.");}}if(n&&u){q.sap.registerModulePath(n,u);}if(m&&!p){p=a.load({manifestUrl:q.sap.getModulePath(n)+"/manifest.json",componentName:n,async:o.async,failOnError:false});}function w(){var e=n+'.Component';q.sap.require(e);var i=q.sap.getObject(e);if(!i){var v="The specified component controller '"+e+"' could not be found!";if(O.failOnError){throw new Error(v);}else{q.sap.log.warning(v);}}if(p){var G=f(i.getMetadata(),p);var H=function(){var I=Array.prototype.slice.call(arguments);var S;if(I.length===0||typeof I[0]==="object"){S=I[0]=I[0]||{};}else if(typeof I[0]==="string"){S=I[1]=I[1]||{};}S._metadataProxy=G;if(s){S._manifestModels=s;}var J=Object.create(i.prototype);i.apply(J,I);return J;};H.getMetadata=function(){return G;};H.extend=function(){throw new Error("Extending Components created by Manifest is not supported!");};return H;}else{return i;}}function x(v,i){if(typeof v==='object'){if(v.url){q.sap.registerModulePath(v.name,v.url);}return(v.lazy&&i!==true)?undefined:v.name;}return v;}function y(i,v){var G=i+'.Component',P;if(k&&i!=null&&!q.sap.isDeclared(G,true)){if(v){P=q.sap.getResourceName(G,'-preload.js');return q.sap._loadJSResourceAsync(P,true);}try{P=G+'-preload';q.sap.require(P);}catch(e){q.sap.log.warning("couldn't preload component from "+P+": "+((e&&e.message)||e));}}}function z(e,p,i){var P=[];var v=i?function(K){P.push(K);}:q.noop;p.defineResourceRoots();var L=p.getEntry("/sap.ui5/dependencies/libs");if(L){var G=[];for(var H in L){if(!L[H].lazy){G.push(H);}}if(G.length>0){q.sap.log.info("Component \""+e+"\" is loading libraries: \""+G.join(", ")+"\"");v(sap.ui.getCore().loadLibraries(G,{async:i}));}}var I=p.getEntry("/sap.ui5/extends/component");if(I){v(y(I,i));}var J=p.getEntry("/sap.ui5/dependencies/components");if(J){for(var e in J){if(!J[e].lazy){v(y(e,i));}}}return i?Promise.all(P):undefined;}if(o.async){var A=o.asyncHints||{},B=[],D=function(P){if(P){B.push(P);}},E=function(e){if(p&&O.createModels&&q.sap.getUriParameters().get("sap-ui-xx-preload-component-models-first")==="true"){D(p.then(e));}else{D(e());}},F=function($){return $;};if(p&&O.createModels){D(p.then(function(p){var e=q.extend(true,{},p.getEntry("/sap.app/dataSources"));var i=q.extend(true,{},p.getEntry("/sap.ui5/models"));var v=h._createManifestModelConfigurations({models:i,dataSources:e,manifest:p,componentData:o.componentData});if(v){var P=q.sap.getUriParameters().get("sap-ui-xx-preload-component-models-"+p.getComponentName());var G=P&&P.split(",");var H={};for(var I in v){var J=v[I];if(!J.preload&&G&&G.indexOf(I)>-1){J.preload=true;q.sap.log.warning("FOR TESTING ONLY!!! Activating preload for model \""+I+"\" ("+J.type+")",p.getComponentName(),"sap.ui.core.Component");}if(J.preload){if(q.sap.isDeclared(J.type,true)){H[I]=J;}else{q.sap.log.warning("Can not preload model \""+I+"\" as required class has not been loaded: \""+J.type+"\"",p.getComponentName(),"sap.ui.core.Component");}}}if(Object.keys(H).length>0){s=h._createManifestModels(H,p.getComponentName());}}return p;}));}if(A.preloadBundles){q.each(A.preloadBundles,function(i,v){E(function(){return q.sap._loadJSResourceAsync(x(v,true),true);});});}if(A.libs){E(function(){return sap.ui.getCore().loadLibraries(A.libs.map(x).filter(F));});}if(!p){D(y(n,true));}else{D(p.then(function(p){var e=p.getComponentName();if(u){q.sap.registerModulePath(e,u);}return y(e,true);}));t=function(L){if(typeof h._fnLoadComponentCallback==="function"){var e=q.extend(true,{},o);var i=q.extend(true,{},L);try{h._fnLoadComponentCallback(e,i);}catch(v){q.sap.log.error("Callback for loading the component \""+p.getComponentName()+"\" run into an error. The callback was skipped and the component loading resumed.",v,"sap.ui.core.Component");}}};}if(A.components){q.each(A.components,function(i,v){E(function(){return y(x(v),true);});});}return Promise.all(B).then(function(v){if(p&&t){p.then(t);}return v;}).then(function(v){q.sap.log.debug("Component.load: all promises fulfilled, then "+v);if(p){return p.then(function(L){p=L;n=p.getComponentName();return z(n,p,true);});}else{return v;}}).then(function(){return O.preloadOnly?true:w();}).then(function(e){var i=O.waitFor;if(i){var P=Array.isArray(i)?i:[i];return Promise.all(P).then(function(){return e;});}return e;}).catch(function(e){if(s){for(var n in s){var i=s[n];if(i&&typeof i.destroy==="function"){i.destroy();}}}throw e;});}if(p){z(n,p);}y(n);return w();}return h;});
