/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/core/library','sap/ui/base/EventProvider','./HashChanger','./Route','./Views','./Targets','./History','sap/ui/thirdparty/crossroads'],function(q,l,E,H,R,V,T,a,c){"use strict";var r={};var b=E.extend("sap.ui.core.routing.Router",{constructor:function(o,C,O,t){E.apply(this);this._oConfig=C||{};this._oRouter=c.create();this._oRouter.ignoreState=true;this._oRoutes={};this._oOwner=O;function d(){if(q.sap.getUriParameters().get("sap-ui-xx-asyncRouting")==="true"){q.sap.log.warning("Activation of async view loading in routing via url parameter is only temporarily supported and may be removed soon","Router");return true;}return false;}this._oConfig._async=this._oConfig.async;if(this._oConfig._async===undefined){this._oConfig._async=d();}this._oViews=new V({component:O,async:this._oConfig._async});if(t){this._oTargets=this._createTargets(this._oConfig,t);}var e=this,f;if(!o){o={};}if(q.isArray(o)){f=o;o={};q.each(f,function(i,g){o[g.name]=g;});}q.each(o,function(s,g){if(g.name===undefined){g.name=s;}e.addRoute(g);});this._oRouter.bypassed.add(q.proxy(this._onBypassed,this));},addRoute:function(C,p){if(!C.name){q.sap.log.error("A name has to be specified for every route",this);}if(this._oRoutes[C.name]){q.sap.log.error("Route with name "+C.name+" already exists",this);}this._oRoutes[C.name]=new R(this,C,p);},parse:function(n){if(this._oRouter){this._oRouter.parse(n);}else{q.sap.log.warning("This router has been destroyed while the hash changed. No routing events where fired by the destroyed instance.",this);}},initialize:function(){var t=this,h=this.oHashChanger=H.getInstance();if(this._bIsInitialized){q.sap.log.warning("Router is already initialized.",this);return this;}this._bIsInitialized=true;this.fnHashChanged=function(e){t.parse(e.getParameter("newHash"),e.getParameter("oldHash"));};if(!h){q.sap.log.error("navTo of the router is called before the router is initialized. If you want to replace the current hash before you initialize the router you may use getUrl and use replaceHash of the Hashchanger.",this);return;}h.attachEvent("hashChanged",this.fnHashChanged);if(this._oTargets){this._oTargets.attachTitleChanged(function(e){this.fireTitleChanged(e.getParameters());}.bind(this));this._aHistory=[];}if(!h.init()){this.parse(h.getHash());}return this;},stop:function(){if(!this._bIsInitialized){q.sap.log.warning("Router is not initialized. But it got stopped",this);}if(this.fnHashChanged){this.oHashChanger.detachEvent("hashChanged",this.fnHashChanged);}this._bIsInitialized=false;return this;},destroy:function(){E.prototype.destroy.apply(this);if(!this._bIsInitialized){q.sap.log.info("Router is not initialized, but got destroyed.",this);}if(this.fnHashChanged){this.oHashChanger.detachEvent("hashChanged",this.fnHashChanged);}this._oRouter.removeAllRoutes();this._oRouter=null;q.each(this._oRoutes,function(i,o){o.destroy();});this._oRoutes=null;this._oConfig=null;if(this._oTargets){this._oTargets.destroy();this._oTargets=null;}this.bIsDestroyed=true;return this;},getURL:function(n,p){if(p===undefined){p={};}var o=this.getRoute(n);if(!o){q.sap.log.warning("Route with name "+n+" does not exist",this);return;}return o.getURL(p);},getRoute:function(n){return this._oRoutes[n];},getViews:function(){return this._oViews;},_createTargets:function(C,t){return new T({views:this._oViews,config:C,targets:t});},getView:function(v,s,d){var o=this._oViews._getViewWithGlobalId({viewName:v,type:s,id:d});this.fireViewCreated({view:o,viewName:v,type:s});return o;},setView:function(v,o){this._oViews.setView(v,o);return this;},navTo:function(n,p,d){var u=this.getURL(n,p);if(u===undefined){q.sap.log.error("Can not navigate to route with name "+n+" because the route does not exist");}if(d){this.oHashChanger.replaceHash(u);}else{this.oHashChanger.setHash(u);}return this;},getTargets:function(){return this._oTargets;},getTarget:function(n){return this._oTargets.getTarget(n);},attachRouteMatched:function(d,f,L){this.attachEvent("routeMatched",d,f,L);return this;},detachRouteMatched:function(f,L){this.detachEvent("routeMatched",f,L);return this;},fireRouteMatched:function(A){this.fireEvent("routeMatched",A);return this;},attachViewCreated:function(d,f,L){this.attachEvent("viewCreated",d,f,L);return this;},detachViewCreated:function(f,L){this.detachEvent("viewCreated",f,L);return this;},fireViewCreated:function(A){this.fireEvent("viewCreated",A);return this;},attachRoutePatternMatched:function(d,f,L){this.attachEvent("routePatternMatched",d,f,L);return this;},detachRoutePatternMatched:function(f,L){this.detachEvent("routePatternMatched",f,L);return this;},fireRoutePatternMatched:function(A){this.fireEvent("routePatternMatched",A);return this;},attachBypassed:function(d,f,L){return this.attachEvent(b.M_EVENTS.BYPASSED,d,f,L);},detachBypassed:function(f,L){return this.detachEvent(b.M_EVENTS.BYPASSED,f,L);},fireBypassed:function(A){return this.fireEvent(b.M_EVENTS.BYPASSED,A);},attachTitleChanged:function(d,f,L){this.attachEvent(b.M_EVENTS.TITLE_CHANGED,d,f,L);return this;},detachTitleChanged:function(f,L){return this.detachEvent(b.M_EVENTS.TITLE_CHANGED,f,L);},fireTitleChanged:function(A){var d,o,t,s,C,h=this.oHashChanger.getHash(),S=true,e=l.routing.HistoryDirection,L=this._aHistory[this._aHistory.length-1];if(this._sActiveRouteName&&this._oTargets){o=this.getRoute(this._sActiveRouteName);t=o._oConfig.target;s=o._oConfig.titleTarget;C=this._oTargets._getTitleTargetName(t,s);S=(A.name===C);}if(S){d=a.getInstance().getDirection();if(d===e.Backwards){this._aHistory.pop();}else if(L&&L.hash==h){L.title=A.title;}else{this._aHistory.push({hash:h,title:A.title});}A.history=this._aHistory.slice(0,-1);this.fireEvent(b.M_EVENTS.TITLE_CHANGED,A);}return this;},register:function(n){r[n]=this;return this;},_onBypassed:function(h){var f=function(){this.fireBypassed({hash:h});}.bind(this);if(this._oConfig.bypassed){var o=this._oTargets.display(this._oConfig.bypassed.target,{hash:h});if(o instanceof Promise){o.then(f);return;}}f();},_isAsync:function(){return this._oConfig._async;},metadata:{publicMethods:["initialize","getURL","register","getRoute"]}});b.M_EVENTS={ROUTE_MATCHED:"routeMatched",ROUTE_PATTERN_MATCHED:"routePatternMatched",VIEW_CREATED:"viewCreated",BYPASSED:"bypassed",TITLE_CHANGED:"titleChanged"};b.getRouter=function(n){return r[n];};return b;});
