/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/core/Control','sap/ui/core/ResizeHandler','./TableGrouping','./library'],function(q,C,R,T,l){"use strict";var S=l.SelectionBehavior,N=l.NavigationMode,a=l.SelectionMode;var b={Grouping:T,CELLTYPES:{DATACELL:"DATACELL",COLUMNHEADER:"COLUMNHEADER",ROWHEADER:"ROWHEADER",COLUMNROWHEADER:"COLUMNROWHEADER"},CONTENT_DENSITY_ROW_HEIGHTS:{sapUiSizeCondensed:24,sapUiSizeCompact:32,sapUiSizeCozy:48,undefined:27},hasRowHeader:function(t){return(t.getSelectionMode()!==a.None&&t.getSelectionBehavior()!==S.RowOnly)||T.isGroupMode(t);},isRowSelectionAllowed:function(t){return t.getSelectionMode()!==a.None&&(t.getSelectionBehavior()===S.Row||t.getSelectionBehavior()===S.RowOnly);},isRowSelectorSelectionAllowed:function(t){return t.getSelectionMode()!==a.None&&b.hasRowHeader(t);},isNoDataVisible:function(t){if(!t.getShowNoData()){return false;}var B=t.getBinding("rows"),i=t._getRowCount(),h=B?!!i:false;if(B&&B.providesGrandTotal){var H=B.providesGrandTotal()&&B.hasTotaledMeasures();h=(H&&i<2)||(!H&&i===0)?false:true;}return!h;},isInstanceOf:function(o,t){if(!o||!t){return false;}var c=sap.ui.require(t);return!!(c&&(o instanceof c));},toggleGroupHeader:function(t,r,e){var $=q(r),g;if($.hasClass("sapUiTableTreeIcon")){g=$.closest("tr");}else{g=$.closest(".sapUiTableGroupHeader");}var B=t.getBinding("rows");if(g.length>0&&B){var i=t.getFirstVisibleRow()+parseInt(g.attr("data-sap-ui-rowindex"),10);var I=T.toggleGroupHeader(t,i,e);var c=I===true||I===false;if(c&&t._onGroupHeaderChanged){t._onGroupHeaderChanged(i,I);}return c;}return false;},getNoDataText:function(t){var n=t.getNoData();if(n instanceof C){return null;}else if(typeof n==="string"||t.getNoData()instanceof String){return n;}else{return t._oResBundle.getText("TBL_NO_DATA");}},getVisibleColumnCount:function(t){return t._getVisibleColumns().length;},getHeaderRowCount:function(t){if(!t.getColumnHeaderVisible()){return 0;}var h=0;q.each(t._getVisibleColumns(),function(i,c){h=Math.max(h,c.getMultiLabels().length);});return h>0?h:1;},getRowHeightByIndex:function(t,r){var i=0;if(t){var c=t.getRows();if(c&&c.length&&r>-1&&r<c.length){var d=c[r].getDomRefs();if(d){if(d.rowScrollPart&&d.rowFixedPart){i=Math.max(d.rowScrollPart.clientHeight,d.rowFixedPart.clientHeight);}else if(!d.rowFixedPart){i=d.rowScrollPart.clientHeight;}}}}return i;},isVariableRowHeightEnabled:function(t){return t._bVariableRowHeightEnabled&&t.getNavigationMode()===N.Scrollbar&&t.getFixedRowCount()<=0&&t.getFixedBottomRowCount()<=0;},getTotalRowCount:function(t,i){var r=t._getRowCount();if(i){r=Math.max(r,t.getVisibleRowCount());}return r;},getNonEmptyVisibleRowCount:function(t){return Math.min(t.getVisibleRowCount(),t._getRowCount());},getFocusedItemInfo:function(t){var i=t._getItemNavigation();if(!i){return null;}return{cell:i.getFocusedIndex(),columnCount:i.iColumns,cellInRow:i.getFocusedIndex()%i.iColumns,row:Math.floor(i.getFocusedIndex()/i.iColumns),cellCount:i.getItemDomRefs().length,domRef:i.getFocusedDomRef()};},getColumnIndexOfFocusedCell:function(t){var i=b.getFocusedItemInfo(t);return i.cellInRow-(b.hasRowHeader(t)?1:0);},getRowIndexOfFocusedCell:function(t){var i=b.getFocusedItemInfo(t);return i.row-b.getHeaderRowCount(t);},isInGroupingRow:function(c){var i=b.getCellInfo(c);if(i&&i.type===b.CELLTYPES.DATACELL){return i.cell.parent().hasClass("sapUiTableGroupHeader");}else if(i&&i.type===b.CELLTYPES.ROWHEADER){return i.cell.hasClass("sapUiTableGroupHeader");}return false;},isInSumRow:function(c){var i=b.getCellInfo(c);if(i&&i.type===b.CELLTYPES.DATACELL){return i.cell.parent().hasClass("sapUiAnalyticalTableSum");}else if(i&&i.type===b.CELLTYPES.ROWHEADER){return i.cell.hasClass("sapUiAnalyticalTableSum");}return false;},isFixedColumn:function(t,c){return c<t.getFixedColumnCount();},hasFixedColumns:function(t){return t.getFixedColumnCount()>0;},focusItem:function(t,i,e){var I=t._getItemNavigation();if(I){I.focusItem(i,e);}},getCellInfo:function(c){if(!c){return null;}var $=q(c);if($.hasClass("sapUiTableTd")){return{type:b.CELLTYPES.DATACELL,cell:$};}else if($.hasClass("sapUiTableCol")){return{type:b.CELLTYPES.COLUMNHEADER,cell:$};}else if($.hasClass("sapUiTableRowHdr")){return{type:b.CELLTYPES.ROWHEADER,cell:$};}else if($.hasClass("sapUiTableColRowHdr")){return{type:b.CELLTYPES.COLUMNROWHEADER,cell:$};}return null;},getColumnHeaderCellInfo:function(c){if(c==null){return null;}var $=q(c);var o=this.getCellInfo($);if(o!==null&&o.type===b.CELLTYPES.COLUMNHEADER){return{index:parseInt($.data("sap-ui-colindex"),10),span:parseInt($.data("sap-ui-colspan"),10)};}else{return null;}},getRowColCell:function(t,r,c){var o=t.getRows()[r];var d=t._getVisibleColumns()[c];var e=o&&o.getCells()[c];if(e&&e.data("sap-ui-colid")!=d.getId()){var f=o.getCells();for(var i=0;i<f.length;i++){if(f[i].data("sap-ui-colid")===d.getId()){e=f[i];break;}}}return{row:o,column:d,cell:e};},registerResizeHandler:function(t,i,h,r){var d;if(typeof i=="string"){d=t.getDomRef(i);}else{q.sap.log.error("sIdSuffix must be a string",t);return;}if(typeof h!=="function"){q.sap.log.error("fnHandler must be a function",t);return;}this.deregisterResizeHandler(t,i);if(!t._mResizeHandlerIds){t._mResizeHandlerIds={};}if(r&&d){d=d.parentNode;}if(d){t._mResizeHandlerIds[i]=R.register(d,h);}return t._mResizeHandlerIds[i];},deregisterResizeHandler:function(t,I){var c;if(!t._mResizeHandlerIds){return;}if(typeof I=="string"){c=[I];}else if(I===undefined){c=[];for(var k in t._mResizeHandlerIds){if(typeof k=="string"&&t._mResizeHandlerIds.hasOwnProperty(k)){c.push(k);}}}else if(q.isArray(I)){c=I;}for(var i=0;i<c.length;i++){var s=c[i];if(t._mResizeHandlerIds[s]){R.deregister(t._mResizeHandlerIds[s]);t._mResizeHandlerIds[s]=undefined;}}},scroll:function(t,d,p){var p=t.getNavigationMode()===N.Scrollbar?p:true;var s=false;var r=t._getRowCount();var v=t.getVisibleRowCount();var i=v-t.getFixedRowCount()-t.getFixedBottomRowCount();var f=t._getSanitizedFirstVisibleRow();var c=p?i:1;if(d){if(f+v<r){t.setFirstVisibleRow(Math.min(f+c,r-v));s=true;}}else{if(f>0){t.setFirstVisibleRow(Math.max(f-c,0));s=true;}}t._bIsScrolledByKeyboard=s;return s;},scrollMax:function(t,d){var s=false;var f=t._getSanitizedFirstVisibleRow();if(d){var F=t._getRowCount()-this.getNonEmptyVisibleRowCount(t);if(f<F){t.setFirstVisibleRow(F);s=true;}}else{if(f>0){t.setFirstVisibleRow(0);s=true;}}return s;},isFirstScrollableRow:function(t,r){var $=q(r);var i=parseInt($.add($.parent()).filter("[data-sap-ui-rowindex]").attr("data-sap-ui-rowindex"),10);var f=t.getFixedRowCount()||0;return i==f;},isLastScrollableRow:function(t,r){var $=q(r);var i=parseInt($.add($.parent()).filter("[data-sap-ui-rowindex]").attr("data-sap-ui-rowindex"),10);var f=t.getFixedBottomRowCount()||0;return i==t.getVisibleRowCount()-f-1;},getContentDensity:function(c){var s;var d=["sapUiSizeCompact","sapUiSizeCondensed","sapUiSizeCozy"];var g=function(f,o){if(!o[f]){return;}for(var i=0;i<d.length;i++){if(o[f](d[i])){return d[i];}}};var D=c.$();if(D.length>0){s=g("hasClass",D);}else{s=g("hasStyleClass",c);}if(s){return s;}var p=null;var P=c.getParent();if(P){do{s=g("hasStyleClass",P);if(s){return s;}if(P.getDomRef){p=P.getDomRef();}else if(P.getRootNode){p=P.getRootNode();}if(!p&&P.getParent){P=P.getParent();}else{P=null;}}while(P&&!p);}D=q(p||document.body);s=g("hasClass",D.closest("."+d.join(",.")));return s;},sanitizeSelectionMode:function(t,s){if(s===a.Multi){s=a.MultiToggle;q.sap.log.warning("The selection mode 'Multi' is deprecated and must not be used anymore. Your setting was defaulted to selection mode 'MultiToggle'");}return s;},resizeColumn:function(t,c,w,f,d){if(t==null||c==null||c<0||w==null||w<=0){return;}if(d==null||d<=0){d=1;}if(f==null){f=true;}var e=t.getColumns();if(c>=e.length||!e[c].getVisible()){return;}var v=[];for(var i=c;i<e.length;i++){var o=e[i];if(o.getVisible()){v.push(o);if(v.length===d){break;}}}var r=[];for(var i=0;i<v.length;i++){var V=v[i];if(V.getResizable()){r.push(V);}}if(r.length===0){return;}var s=0;for(var i=0;i<v.length;i++){var V=v[i];s+=this.getColumnWidth(t,V.getIndex());}var p=w-s;var g=Math.round(p/r.length);for(var i=0;i<r.length;i++){var h=r[i];var j=this.getColumnWidth(t,h.getIndex());var n=j+g;if(n<t._iColMinWidth){n=t._iColMinWidth;}var W=n-j;if(Math.abs(W)<Math.abs(g)){var k=r.length-(i+1);p-=W;g=Math.round(p/k);}if(W!==0){var E=true;if(f){E=t.fireColumnResize({column:h,width:n});}if(E){h.setWidth(n+"px");}}}},getColumnWidth:function(t,c){if(t==null||c==null||c<0){return null;}var d=t.getColumns();if(c>=d.length){return null;}var o=d[c];return t._CSSSizeToPixel(o.getWidth());}};T.TableUtils=b;return b;},true);
