/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./Bar','./Dialog','./InputBase','./List','./Popover','sap/ui/core/Item','./ColumnListItem','./StandardListItem','./DisplayListItem','sap/ui/core/ListItem','./Table','./Toolbar','./ToolbarSpacer','./library','sap/ui/core/IconPool','jquery.sap.strings'],function(q,B,D,I,L,P,a,C,S,b,c,T,d,e,l,f){"use strict";var g=I.extend("sap.m.Input",{metadata:{library:"sap.m",properties:{type:{type:"sap.m.InputType",group:"Data",defaultValue:sap.m.InputType.Text},maxLength:{type:"int",group:"Behavior",defaultValue:0},dateFormat:{type:"string",group:"Misc",defaultValue:'YYYY-MM-dd',deprecated:true},showValueHelp:{type:"boolean",group:"Behavior",defaultValue:false},showSuggestion:{type:"boolean",group:"Behavior",defaultValue:false},valueHelpOnly:{type:"boolean",group:"Behavior",defaultValue:false},filterSuggests:{type:"boolean",group:"Behavior",defaultValue:true},maxSuggestionWidth:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:null},startSuggestion:{type:"int",group:"Behavior",defaultValue:1},showTableSuggestionValueHelp:{type:"boolean",group:"Behavior",defaultValue:true},description:{type:"string",group:"Misc",defaultValue:null},fieldWidth:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:'50%'},valueLiveUpdate:{type:"boolean",group:"Behavior",defaultValue:false}},defaultAggregation:"suggestionItems",aggregations:{suggestionItems:{type:"sap.ui.core.Item",multiple:true,singularName:"suggestionItem"},suggestionColumns:{type:"sap.m.Column",multiple:true,singularName:"suggestionColumn",bindable:"bindable"},suggestionRows:{type:"sap.m.ColumnListItem",multiple:true,singularName:"suggestionRow",bindable:"bindable"}},events:{liveChange:{parameters:{value:{type:"string"}}},valueHelpRequest:{parameters:{fromSuggestions:{type:"boolean"}}},suggest:{parameters:{suggestValue:{type:"string"},suggestionColumns:{type:"sap.m.ListBase"}}},suggestionItemSelected:{parameters:{selectedItem:{type:"sap.ui.core.Item"},selectedRow:{type:"sap.m.ColumnListItem"}}},submit:{parameters:{value:{type:"string"}}}}}});f.insertFontFaceStyle();g._DEFAULTFILTER=function(v,i){return q.sap.startsWithIgnoreCase(i.getText(),v);};g._DEFAULTFILTER_TABULAR=function(v,o){var h=o.getCells(),i=0;for(;i<h.length;i++){if(h[i].getText){return q.sap.startsWithIgnoreCase(h[i].getText(),v);}}return false;};g._DEFAULTRESULT_TABULAR=function(o){var h=o.getCells(),i=0;for(;i<h.length;i++){if(h[i].getText){return h[i].getText();}}return"";};g.prototype.init=function(){I.prototype.init.call(this);this._fnFilter=g._DEFAULTFILTER;this._bUseDialog=sap.ui.Device.system.phone;this._bFullScreen=sap.ui.Device.system.phone;this._iSetCount=0;};g.prototype.exit=function(){this._deregisterEvents();this.cancelPendingSuggest();if(this._iRefreshListTimeout){q.sap.clearDelayedCall(this._iRefreshListTimeout);this._iRefreshListTimeout=null;}if(this._oSuggestionPopup){this._oSuggestionPopup.destroy();this._oSuggestionPopup=null;}if(this._oList){this._oList.destroy();this._oList=null;}if(this._oValueHelpIcon){this._oValueHelpIcon.destroy();this._oValueHelpIcon=null;}if(this._oSuggestionTable){this._oSuggestionTable.destroy();this._oSuggestionTable=null;}if(this._oButtonToolbar){this._oButtonToolbar.destroy();this._oButtonToolbar=null;}if(this._oShowMoreButton){this._oShowMoreButton.destroy();this._oShowMoreButton=null;}};g.prototype._resizePopup=function(){var t=this;if(this._oList&&this._oSuggestionPopup){if(this.getMaxSuggestionWidth()){this._oSuggestionPopup.setContentWidth(this.getMaxSuggestionWidth());}else{this._oSuggestionPopup.setContentWidth((this.$().outerWidth())+"px");}setTimeout(function(){if(t._oSuggestionPopup&&t._oSuggestionPopup.isOpen()&&t._oSuggestionPopup.$().outerWidth()<t.$().outerWidth()){t._oSuggestionPopup.setContentWidth((t.$().outerWidth())+"px");}},0);}};g.prototype.onBeforeRendering=function(){I.prototype.onBeforeRendering.call(this);this._deregisterEvents();};g.prototype.onAfterRendering=function(){var t=this;I.prototype.onAfterRendering.call(this);if(!this._bFullScreen){this._resizePopup();this._sPopupResizeHandler=sap.ui.core.ResizeHandler.register(this.getDomRef(),function(){t._resizePopup();});}if(this._bUseDialog&&this.getEditable()){this.$().on("click",q.proxy(function(E){if(this.getShowSuggestion()&&this._oSuggestionPopup&&E.target.id!=this.getId()+"__vhi"){this._oSuggestionPopup.open();}},this));}};g.prototype.setSelectionItem=function(i){var h=this._iSetCount,n;this.fireSuggestionItemSelected({selectedItem:i});if(h!==this._iSetCount){n=this.getValue();}else{n=i.getText();}if(this._bUseDialog){this._oPopupInput.setValue(n);this._oPopupInput._doSelect();}else{this._$input.val(this._getInputValue(n));this.onChange();}this._iPopupListSelectedIndex=-1;if(!(this._bUseDialog&&this instanceof sap.m.MultiInput&&this._isMultiLineMode)){this._closeSuggestionPopup();}if(!sap.ui.Device.support.touch){this._doSelect();}};g.prototype.setSelectionRow=function(o){var i=this._iSetCount,n;this.fireSuggestionItemSelected({selectedRow:o});if(i!==this._iSetCount){n=this.getValue();}else{n=this._fnRowResultFilter(o);}if(this._bUseDialog){this._oPopupInput.setValue(n);this._oPopupInput._doSelect();}else{this._$input.val(this._getInputValue(n));this.onChange();}this._iPopupListSelectedIndex=-1;if(!(this._bUseDialog&&this instanceof sap.m.MultiInput&&this._isMultiLineMode)){this._closeSuggestionPopup();}if(!sap.ui.Device.support.touch){this._doSelect();}};g.prototype._getValueHelpIcon=function(){var t=this;if(!this._oValueHelpIcon){var u=f.getIconURI("value-help");this._oValueHelpIcon=f.createControlByURI({id:this.getId()+"__vhi",src:u,useIconTooltip:false,noTabStop:true});this._oValueHelpIcon.addStyleClass("sapMInputValHelpInner");this._oValueHelpIcon.attachPress(function(h){if(!t.getValueHelpOnly()){t.fireValueHelpRequest({fromSuggestions:false});}});}return this._oValueHelpIcon;};g.prototype._fireValueHelpRequestForValueHelpOnly=function(){if(this.getEnabled()&&this.getEditable()&&this.getShowValueHelp()&&this.getValueHelpOnly()){this.fireValueHelpRequest({fromSuggestions:false});}};g.prototype.ontap=function(E){I.prototype.ontap.call(this,E);this._fireValueHelpRequestForValueHelpOnly();};g.prototype.setWidth=function(w){return I.prototype.setWidth.call(this,w||"100%");};g.prototype.getWidth=function(){return this.getProperty("width")||"100%";};g.prototype.setFilterFunction=function(F){if(F===null||F===undefined){this._fnFilter=g._DEFAULTFILTER;return this;}this._fnFilter=F;return this;};g.prototype.setRowResultFunction=function(F){if(F===null||F===undefined){this._fnRowResultFilter=g._DEFAULTRESULT_TABULAR;return this;}this._fnRowResultFilter=F;return this;};g.prototype.setShowValueHelp=function(s){this.setProperty("showValueHelp",s);if(s&&!g.prototype._sAriaValueHelpLabelId){g.prototype._sAriaValueHelpLabelId=new sap.ui.core.InvisibleText({text:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("INPUT_VALUEHELP")}).toStatic().getId();}return this;};g.prototype.setValueHelpOnly=function(v){this.setProperty("valueHelpOnly",v);if(v&&!g.prototype._sAriaInputDisabledLabelId){g.prototype._sAriaInputDisabledLabelId=new sap.ui.core.InvisibleText({text:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("INPUT_DISABLED")}).toStatic().getId();}return this;};g.prototype._doSelect=function(s,E){if(sap.ui.Device.support.touch){return;}var o=this._$input[0];if(o){var r=this._$input;o.focus();r.selectText(s?s:0,E?E:r.val().length);}return this;};g.prototype._scrollToItem=function(i){var p=this._oSuggestionPopup,o=this._oList,s,h,j,t,k;if(!(p instanceof P)||!o){return;}s=p.getScrollDelegate();if(!s){return;}var m=o.getItems()[i],n=m&&m.getDomRef();if(!n){return;}h=p.getDomRef("cont").getBoundingClientRect();j=n.getBoundingClientRect();t=h.top-j.top;k=j.bottom-h.bottom;if(t>0){s.scrollTo(s._scrollX,Math.max(s._scrollY-t,0));}else if(k>0){s.scrollTo(s._scrollX,s._scrollY+k);}};g.prototype._isSuggestionItemSelectable=function(i){return i.getVisible()&&(this._hasTabularSuggestions()||i.getType()!==sap.m.ListType.Inactive);};g.prototype._onsaparrowkey=function(E,s,i){if(!this.getEnabled()||!this.getEditable()){return;}if(!this._oSuggestionPopup||!this._oSuggestionPopup.isOpen()){return;}if(s!=="up"&&s!=="down"){return;}E.preventDefault();E.stopPropagation();var F=false,o=this._oList,h=this.getSuggestionItems(),j=o.getItems(),k=this._iPopupListSelectedIndex,n,O=k;if(s==="up"&&k===0){return;}if(s=="down"&&k===j.length-1){return;}var m;if(i>1){if(s=="down"&&k+i>=j.length){s="up";i=1;j[k].setSelected(false);m=k;k=j.length-1;F=true;}else if(s=="up"&&k-i<0){s="down";i=1;j[k].setSelected(false);m=k;k=0;F=true;}}if(k===-1){k=0;if(this._isSuggestionItemSelectable(j[k])){O=k;F=true;}else{s="down";}}if(s==="down"){while(k<j.length-1&&(!F||!this._isSuggestionItemSelectable(j[k]))){j[k].setSelected(false);k=k+i;F=true;i=1;if(m===k){break;}}}else{while(k>0&&(!F||!j[k].getVisible()||!this._isSuggestionItemSelectable(j[k]))){j[k].setSelected(false);k=k-i;F=true;i=1;if(m===k){break;}}}if(!this._isSuggestionItemSelectable(j[k])){if(O>=0){j[O].setSelected(true).updateAccessibilityState();this.$("inner").attr("aria-activedescendant",j[O].getId());}return;}else{j[k].setSelected(true).updateAccessibilityState();this.$("inner").attr("aria-activedescendant",j[k].getId());}if(sap.ui.Device.system.desktop){this._scrollToItem(k);}if(sap.m.ColumnListItem&&j[k]instanceof sap.m.ColumnListItem){n=this._getInputValue(this._fnRowResultFilter(j[k]));}else{var p=(h[0]instanceof c?true:false);if(p){n=this._getInputValue(j[k].getLabel());}else{n=this._getInputValue(j[k].getTitle());}}this._$input.val(n);this._sSelectedSuggViaKeyboard=n;this._doSelect();this._iPopupListSelectedIndex=k;};g.prototype.onsapup=function(E){this._onsaparrowkey(E,"up",1);};g.prototype.onsapdown=function(E){this._onsaparrowkey(E,"down",1);};g.prototype.onsappageup=function(E){this._onsaparrowkey(E,"up",5);};g.prototype.onsappagedown=function(E){this._onsaparrowkey(E,"down",5);};g.prototype.onsaphome=function(E){if(this._oList){this._onsaparrowkey(E,"up",this._oList.getItems().length);}};g.prototype.onsapend=function(E){if(this._oList){this._onsaparrowkey(E,"down",this._oList.getItems().length);}};g.prototype.onsapescape=function(E){var h;if(this._oSuggestionPopup&&this._oSuggestionPopup.isOpen()){E.originalEvent._sapui_handledByControl=true;this._iPopupListSelectedIndex=-1;this._closeSuggestionPopup();if(this._sBeforeSuggest!==undefined){if(this._sBeforeSuggest!==this.getValue()){h=this._lastValue;this.setValue(this._sBeforeSuggest);this._lastValue=h;}this._sBeforeSuggest=undefined;}return;}if(I.prototype.onsapescape){I.prototype.onsapescape.apply(this,arguments);}};g.prototype.onsapenter=function(E){if(I.prototype.onsapenter){I.prototype.onsapenter.apply(this,arguments);}this.cancelPendingSuggest();if(this._oSuggestionPopup&&this._oSuggestionPopup.isOpen()){var s=this._oList.getSelectedItem();if(s){if(this._hasTabularSuggestions()){this.setSelectionRow(s,true);}else{this.setSelectionItem(s._oItem,true);}}else{if(this._iPopupListSelectedIndex>=0){this._fireSuggestionItemSelectedEvent();this._doSelect();this._iPopupListSelectedIndex=-1;}this._closeSuggestionPopup();}}if(this.getEnabled()&&this.getEditable()&&!(this.getValueHelpOnly()&&this.getShowValueHelp())){this.fireSubmit({value:this.getValue()});}};g.prototype.onsapfocusleave=function(E){var p=this._oSuggestionPopup;if(p instanceof P){if(E.relatedControlId&&q.sap.containsOrEquals(p.getDomRef(),sap.ui.getCore().byId(E.relatedControlId).getFocusDomRef())){this._bPopupHasFocus=true;this.focus();}else{if(this._$input.val()===this._sSelectedSuggViaKeyboard){this._sSelectedSuggViaKeyboard=null;}}}var F=sap.ui.getCore().byId(E.relatedControlId);if(!(p&&F&&q.sap.containsOrEquals(p.getDomRef(),F.getFocusDomRef()))){I.prototype.onsapfocusleave.apply(this,arguments);}};g.prototype.onmousedown=function(E){var p=this._oSuggestionPopup;if((p instanceof P)&&p.isOpen()){E.stopPropagation();}};g.prototype._deregisterEvents=function(){if(this._sPopupResizeHandler){sap.ui.core.ResizeHandler.deregister(this._sPopupResizeHandler);this._sPopupResizeHandler=null;}if(this._bUseDialog&&this._oSuggestionPopup){this.$().off("click");}};g.prototype.updateSuggestionItems=function(){this.updateAggregation("suggestionItems");this._bShouldRefreshListItems=true;this._refreshItemsDelayed();return this;};g.prototype.cancelPendingSuggest=function(){if(this._iSuggestDelay){q.sap.clearDelayedCall(this._iSuggestDelay);this._iSuggestDelay=null;}};g.prototype._triggerSuggest=function(v){this.cancelPendingSuggest();this._bShouldRefreshListItems=true;if(!v){v="";}if(v.length>=this.getStartSuggestion()){this._iSuggestDelay=q.sap.delayedCall(300,this,function(){this._bBindingUpdated=false;this.fireSuggest({suggestValue:v});if(!this._bBindingUpdated){this._refreshItemsDelayed();}});}else if(this._bUseDialog){if(this._oList instanceof T){this._oList.addStyleClass("sapMInputSuggestionTableHidden");}else if(this._oList&&this._oList.destroyItems){this._oList.destroyItems();}}else if(this._oSuggestionPopup&&this._oSuggestionPopup.isOpen()){this._iPopupListSelectedIndex=-1;this._closeSuggestionPopup();}};(function(){g.prototype.setShowSuggestion=function(v){this.setProperty("showSuggestion",v,true);this._iPopupListSelectedIndex=-1;if(v){this._lazyInitializeSuggestionPopup(this);}else{k(this);}return this;};g.prototype.setShowTableSuggestionValueHelp=function(v){this.setProperty("showTableSuggestionValueHelp",v,true);if(!this._oSuggestionPopup){return this;}if(v){this._addShowMoreButton();}else{this._removeShowMoreButton();}return this;};g.prototype._getShowMoreButton=function(){var t=this,m=sap.ui.getCore().getLibraryResourceBundle("sap.m");return this._oShowMoreButton||(this._oShowMoreButton=new sap.m.Button({text:m.getText("INPUT_SUGGESTIONS_SHOW_ALL"),press:function(){if(t.getShowTableSuggestionValueHelp()){t.fireValueHelpRequest({fromSuggestions:true});t._iPopupListSelectedIndex=-1;t._closeSuggestionPopup();}}}));};g.prototype._getButtonToolbar=function(){var s=this._getShowMoreButton();return this._oButtonToolbar||(this._oButtonToolbar=new d({content:[new e(),s]}));};g.prototype._addShowMoreButton=function(t){if(!this._oSuggestionPopup||!t&&!this._hasTabularSuggestions()){return;}if(this._oSuggestionPopup instanceof D){var s=this._getShowMoreButton();this._oSuggestionPopup.setEndButton(s);}else{var i=this._getButtonToolbar();this._oSuggestionPopup.setFooter(i);}};g.prototype._removeShowMoreButton=function(){if(!this._oSuggestionPopup||!this._hasTabularSuggestions()){return;}if(this._oSuggestionPopup instanceof D){this._oSuggestionPopup.setEndButton(null);}else{this._oSuggestionPopup.setFooter(null);}};g.prototype.oninput=function(E){I.prototype.oninput.call(this,E);if(E.isMarked("invalid")){return;}var v=this._$input.val();if(this.getValueLiveUpdate()){this.setProperty("value",v,true);}this.fireLiveChange({value:v,newValue:v});if(this.getShowSuggestion()&&!this._bUseDialog){this._triggerSuggest(v);}};g.prototype.getValue=function(){return this.getDomRef("inner")&&this._$input?this._$input.val():this.getProperty("value");};g.prototype._refreshItemsDelayed=function(){q.sap.clearDelayedCall(this._iRefreshListTimeout);this._iRefreshListTimeout=q.sap.delayedCall(0,this,r,[this]);};g.prototype.addSuggestionItem=function(i){this.addAggregation("suggestionItems",i,true);this._bShouldRefreshListItems=true;this._refreshItemsDelayed();j(this);return this;};g.prototype.insertSuggestionItem=function(i,m){this.insertAggregation("suggestionItems",m,i,true);this._bShouldRefreshListItems=true;this._refreshItemsDelayed();j(this);return this;};g.prototype.removeSuggestionItem=function(i){var m=this.removeAggregation("suggestionItems",i,true);this._bShouldRefreshListItems=true;this._refreshItemsDelayed();return m;};g.prototype.removeAllSuggestionItems=function(){var i=this.removeAllAggregation("suggestionItems",true);this._bShouldRefreshListItems=true;this._refreshItemsDelayed();return i;};g.prototype.destroySuggestionItems=function(){this.destroyAggregation("suggestionItems",true);this._bShouldRefreshListItems=true;this._refreshItemsDelayed();return this;};g.prototype.addSuggestionRow=function(i){i.setType(sap.m.ListType.Active);this.addAggregation("suggestionRows",i);this._bShouldRefreshListItems=true;this._refreshItemsDelayed();j(this);return this;};g.prototype.insertSuggestionRow=function(i,m){i.setType(sap.m.ListType.Active);this.insertAggregation("suggestionRows",m,i);this._bShouldRefreshListItems=true;this._refreshItemsDelayed();j(this);return this;};g.prototype.removeSuggestionRow=function(i){var m=this.removeAggregation("suggestionRows",i);this._bShouldRefreshListItems=true;this._refreshItemsDelayed();return m;};g.prototype.removeAllSuggestionRows=function(){var i=this.removeAllAggregation("suggestionRows");this._bShouldRefreshListItems=true;this._refreshItemsDelayed();return i;};g.prototype.destroySuggestionRows=function(){this.destroyAggregation("suggestionRows");this._bShouldRefreshListItems=true;this._refreshItemsDelayed();return this;};g.prototype.bindAggregation=function(){var i=Array.prototype.slice.call(arguments);if(i[0]==="suggestionRows"||i[0]==="suggestionColumns"||i[0]==="suggestionItems"){j(this,i[0]==="suggestionRows"||i[0]==="suggestionColumns");this._bBindingUpdated=true;}this._callMethodInManagedObject.apply(this,["bindAggregation"].concat(i));return this;};g.prototype._lazyInitializeSuggestionPopup=function(){if(!this._oSuggestionPopup){h(this);}};g.prototype._closeSuggestionPopup=function(){if(this._oSuggestionPopup){this._bShouldRefreshListItems=false;this.cancelPendingSuggest();this._oSuggestionPopup.close();this.$("SuggDescr").text("");this.$("inner").removeAttr("aria-haspopup");this.$("inner").removeAttr("aria-activedescendant");}};function h(i){var m=sap.ui.getCore().getLibraryResourceBundle("sap.m");if(i._bUseDialog){i._oPopupInput=new g(i.getId()+"-popup-input",{width:"100%",valueLiveUpdate:true,showValueHelp:i.getShowValueHelp(),valueHelpRequest:function(E){i.fireValueHelpRequest({fromSuggestions:true});i._iPopupListSelectedIndex=-1;i._closeSuggestionPopup();},liveChange:function(E){var v=E.getParameter("newValue");i._$input.val(i._getInputValue(i._oPopupInput.getValue()));i._triggerSuggest(v);i.fireLiveChange({value:v,newValue:v});}}).addStyleClass("sapMInputSuggInDialog");}i._oSuggestionPopup=!i._bUseDialog?(new P(i.getId()+"-popup",{showArrow:false,showHeader:false,placement:sap.m.PlacementType.Vertical,initialFocus:i}).attachAfterClose(function(){if(i._iPopupListSelectedIndex>=0){i._fireSuggestionItemSelectedEvent();}if(i._oList instanceof T){i._oList.removeSelections(true);}else{i._oList.destroyItems();}}).attachBeforeOpen(function(){i._sBeforeSuggest=i.getValue();})):(new D(i.getId()+"-popup",{beginButton:new sap.m.Button(i.getId()+"-popup-closeButton",{text:m.getText("MSGBOX_CLOSE"),press:function(){i._closeSuggestionPopup();}}),stretch:i._bFullScreen,contentHeight:i._bFullScreen?undefined:"20rem",customHeader:new B(i.getId()+"-popup-header",{contentMiddle:i._oPopupInput.addEventDelegate({onsapenter:function(){if(!(sap.m.MultiInput&&i instanceof sap.m.MultiInput)){i._closeSuggestionPopup();}}},this)}),horizontalScrolling:false,initialFocus:i._oPopupInput}).attachBeforeOpen(function(){i._oPopupInput.setPlaceholder(i.getPlaceholder());i._oPopupInput.setMaxLength(i.getMaxLength());}).attachBeforeClose(function(){i._$input.val(i._getInputValue(i._oPopupInput.getValue()));i.onChange();if(i instanceof sap.m.MultiInput&&i._bUseDialog){i._onDialogClose();}}).attachAfterClose(function(){if(i instanceof sap.m.MultiInput&&i._isMultiLineMode){i._showIndicator();}if(i._oList){if(T&&!(i._oList instanceof T)){i._oList.destroyItems();}else{i._oList.removeSelections(true);}}}).attachAfterOpen(function(){var v=i.getValue();i._oPopupInput.setValue(v);i._triggerSuggest(v);r(i);}));i._oSuggestionPopup.addStyleClass("sapMInputSuggestionPopup");i.addDependent(i._oSuggestionPopup);if(!i._bUseDialog){o(i._oSuggestionPopup,i);}if(i._oList){i._oSuggestionPopup.addContent(i._oList);}if(i.getShowTableSuggestionValueHelp()){i._addShowMoreButton();}}function j(i,t){if(i._oList){return;}if(!i._hasTabularSuggestions()&&!t){i._oList=new L(i.getId()+"-popup-list",{width:"100%",showNoData:false,mode:sap.m.ListMode.SingleSelectMaster,rememberSelections:false,itemPress:function(E){var n=E.getParameter("listItem");i.setSelectionItem(n._oItem);}});}else{if(i._fnFilter===g._DEFAULTFILTER){i._fnFilter=g._DEFAULTFILTER_TABULAR;}if(!i._fnRowResultFilter){i._fnRowResultFilter=g._DEFAULTRESULT_TABULAR;}i._oList=i._getSuggestionsTable();if(i.getShowTableSuggestionValueHelp()){i._addShowMoreButton(t);}}if(i._oSuggestionPopup){if(i._bUseDialog){i._oSuggestionPopup.addAggregation("content",i._oList,true);var R=i._oSuggestionPopup.$("scrollCont")[0];if(R){var m=sap.ui.getCore().createRenderManager();m.renderControl(i._oList);m.flush(R);m.destroy();}}else{i._oSuggestionPopup.addContent(i._oList);}}}function k(i){if(i._oSuggestionPopup){if(i._oList instanceof T){i._oSuggestionPopup.removeAllContent();i._removeShowMoreButton();}i._oSuggestionPopup.destroy();i._oSuggestionPopup=null;}if(i._oList instanceof L){i._oList.destroy();i._oList=null;}}function o(p,i){p.open=function(){this.openBy(i,false,true);};p.oPopup.setAnimations(function(R,m,O){O();},function(R,m,n){n();});}function r(m){var s=m.getShowSuggestion();m._iPopupListSelectedIndex=-1;if(!s||!m._bShouldRefreshListItems||!m.getDomRef()||(!m._bUseDialog&&!m.$().hasClass("sapMInputFocused"))){return false;}var n,p=m.getSuggestionItems(),t=m.getSuggestionRows(),u=m._$input.val()||"",v=m._oList,F=m.getFilterSuggests(),H=[],w=0,x=m._oSuggestionPopup,y={ontouchstart:function(G){(G.originalEvent||G)._sapui_cancelAutoClose=true;}},z,i;if(m._oList){if(m._oList instanceof T){v.removeSelections(true);}else{v.destroyItems();}}if(u.length<m.getStartSuggestion()){if(!m._bUseDialog){m._iPopupListSelectedIndex=-1;this.cancelPendingSuggest();x.close();}else{if(m._hasTabularSuggestions()&&m._oList){m._oList.addStyleClass("sapMInputSuggestionTableHidden");}}m.$("SuggDescr").text("");m.$("inner").removeAttr("aria-haspopup");m.$("inner").removeAttr("aria-activedescendant");return false;}if(m._hasTabularSuggestions()){if(m._bUseDialog&&m._oList){m._oList.removeStyleClass("sapMInputSuggestionTableHidden");}for(i=0;i<t.length;i++){if(!F||m._fnFilter(u,t[i])){t[i].setVisible(true);H.push(t[i]);}else{t[i].setVisible(false);}}}else{var A=(p[0]instanceof c?true:false);for(i=0;i<p.length;i++){n=p[i];if(!F||m._fnFilter(u,n)){if(A){z=new b(n.getId()+"-dli");z.setLabel(n.getText());z.setValue(n.getAdditionalText());}else{z=new S(n.getId()+"-sli");z.setTitle(n.getText());}z.setType(n.getEnabled()?sap.m.ListType.Active:sap.m.ListType.Inactive);z._oItem=n;z.addEventDelegate(y);H.push(z);}}}w=H.length;var E="";if(w>0){if(w==1){E=sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("INPUT_SUGGESTIONS_ONE_HIT");}else{E=sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("INPUT_SUGGESTIONS_MORE_HITS",w);}m.$("inner").attr("aria-haspopup","true");if(!m._hasTabularSuggestions()){for(i=0;i<w;i++){v.addItem(H[i]);}}if(!m._bUseDialog){if(m._sCloseTimer){clearTimeout(m._sCloseTimer);m._sCloseTimer=null;}if(!x.isOpen()&&!m._sOpenTimer&&(this.getValue().length>=this.getStartSuggestion())){m._sOpenTimer=setTimeout(function(){m._resizePopup();m._sOpenTimer=null;x.open();},0);}}}else{E=sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("INPUT_SUGGESTIONS_NO_HIT");m.$("inner").removeAttr("aria-haspopup");m.$("inner").removeAttr("aria-activedescendant");if(!m._bUseDialog){if(x.isOpen()){m._sCloseTimer=setTimeout(function(){m._iPopupListSelectedIndex=-1;m.cancelPendingSuggest();x.close();},0);}}else{if(m._hasTabularSuggestions()&&m._oList){m._oList.addStyleClass("sapMInputSuggestionTableHidden");}}}m.$("SuggDescr").text(E);}})();g.prototype.onfocusin=function(E){I.prototype.onfocusin.apply(this,arguments);this.$().addClass("sapMInputFocused");if(!this._bPopupHasFocus&&!this.getStartSuggestion()&&!this.getValue()){this._triggerSuggest(this.getValue());}this._bPopupHasFocus=undefined;};g.prototype.onsapshow=function(E){if(!this.getEnabled()||!this.getEditable()||!this.getShowValueHelp()){return;}this.fireValueHelpRequest({fromSuggestions:false});E.preventDefault();E.stopPropagation();};g.prototype.onsaphide=g.prototype.onsapshow;g.prototype.onsapselect=function(E){this._fireValueHelpRequestForValueHelpOnly();};g.prototype.onfocusout=function(E){I.prototype.onfocusout.apply(this,arguments);this.$().removeClass("sapMInputFocused");this.closeValueStateMessage(this);};g.prototype._hasTabularSuggestions=function(){return!!(this.getAggregation("suggestionColumns")&&this.getAggregation("suggestionColumns").length);};g.prototype._getSuggestionsTable=function(){var t=this;if(!this._oSuggestionTable){this._oSuggestionTable=new T(this.getId()+"-popup-table",{mode:sap.m.ListMode.SingleSelectMaster,showNoData:false,showSeparators:"All",width:"100%",enableBusyIndicator:false,rememberSelections:false,selectionChange:function(E){var s=E.getParameter("listItem");t.setSelectionRow(s);}});if(this._bUseDialog){this._oSuggestionTable.addStyleClass("sapMInputSuggestionTableHidden");}this._oSuggestionTable.updateItems=function(){T.prototype.updateItems.apply(this,arguments);t._refreshItemsDelayed();return this;};}return this._oSuggestionTable;};g.prototype._fireSuggestionItemSelectedEvent=function(){if(this._iPopupListSelectedIndex>=0){var s=this._oList.getItems()[this._iPopupListSelectedIndex];if(s){if(sap.m.ColumnListItem&&s instanceof sap.m.ColumnListItem){this.fireSuggestionItemSelected({selectedRow:s});}else{this.fireSuggestionItemSelected({selectedItem:s._oItem});}}this._iPopupListSelectedIndex=-1;}};g.prototype._callMethodInManagedObject=function(F,A){var h=Array.prototype.slice.call(arguments),s;if(A==="suggestionColumns"){s=this._getSuggestionsTable();return s[F].apply(s,["columns"].concat(h.slice(2)));}else if(A==="suggestionRows"){s=this._getSuggestionsTable();return s[F].apply(s,["items"].concat(h.slice(2)));}else{return sap.ui.core.Control.prototype[F].apply(this,h.slice(1));}};g.prototype.validateAggregation=function(A,o,m){return this._callMethodInManagedObject("validateAggregation",A,o,m);};g.prototype.setAggregation=function(A,o,s){this._callMethodInManagedObject("setAggregation",A,o,s);return this;};g.prototype.getAggregation=function(A,o){return this._callMethodInManagedObject("getAggregation",A,o);};g.prototype.indexOfAggregation=function(A,o){return this._callMethodInManagedObject("indexOfAggregation",A,o);};g.prototype.insertAggregation=function(A,o,i,s){this._callMethodInManagedObject("insertAggregation",A,o,i,s);return this;};g.prototype.addAggregation=function(A,o,s){this._callMethodInManagedObject("addAggregation",A,o,s);return this;};g.prototype.removeAggregation=function(A,o,s){return this._callMethodInManagedObject("removeAggregation",A,o,s);};g.prototype.removeAllAggregation=function(A,s){return this._callMethodInManagedObject("removeAllAggregation",A,s);};g.prototype.destroyAggregation=function(A,s){this._callMethodInManagedObject("destroyAggregation",A,s);return this;};g.prototype.getBinding=function(A){return this._callMethodInManagedObject("getBinding",A);};g.prototype.getBindingInfo=function(A){return this._callMethodInManagedObject("getBindingInfo",A);};g.prototype.getBindingPath=function(A){return this._callMethodInManagedObject("getBindingPath",A);};g.prototype.clone=function(){var i=sap.ui.core.Control.prototype.clone.apply(this,arguments),h;h=this.getBindingInfo("suggestionColumns");if(h){i.bindAggregation("suggestionColumns",q.extend({},h));}else{this.getSuggestionColumns().forEach(function(o){i.addSuggestionColumn(o.clone(),true);});}h=this.getBindingInfo("suggestionRows");if(h){i.bindAggregation("suggestionRows",q.extend({},h));}else{this.getSuggestionRows().forEach(function(r){i.addSuggestionRow(r.clone(),true);});}return i;};g.prototype.setValue=function(v){this._iSetCount++;I.prototype.setValue.call(this,v);return this;};g.prototype.getAccessibilityInfo=function(){var i=I.prototype.getAccessibilityInfo.apply(this,arguments);i.description=((i.description||"")+" "+this.getDescription()).trim();return i;};return g;},true);
