/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["jquery.sap.global","sap/ui/model/Binding","sap/ui/model/ChangeReason","sap/ui/model/FilterType","sap/ui/model/ListBinding","sap/ui/model/odata/OperationMode","./_ODataHelper","./Context","./lib/_Cache","./lib/_Helper","./lib/_SyncPromise"],function(q,B,C,F,L,O,_,a,b,c,d){"use strict";var s="sap.ui.model.odata.v4.ODataListBinding",S={change:true,dataReceived:true,dataRequested:true,refresh:true};var e=L.extend("sap.ui.model.odata.v4.ODataListBinding",{constructor:function(m,p,o,v,f,P){var g,h;L.call(this,m,p);if(!p||p.slice(-1)==="/"){throw new Error("Invalid path: "+p);}g=_.buildBindingParameters(P,["$$groupId","$$operationMode","$$updateGroupId"]);this.sGroupId=g.$$groupId;this.sOperationMode=g.$$operationMode||m.sOperationMode;this.sUpdateGroupId=g.$$updateGroupId;if(!this.sOperationMode&&(v||f)){throw new Error("Unsupported operation mode: "+this.sOperationMode);}this.aApplicationFilters=_.toArray(f);this.oCache=undefined;this.sChangeReason=undefined;this.aDiff=[];this.aFilters=[];this.aPreviousData=[];this.mQueryOptions=undefined;this.sRefreshGroupId=undefined;this.aSorters=_.toArray(v);if(!this.bRelative||P){this.mQueryOptions=_.buildQueryOptions(m.mUriParameters,P,_.aAllowedSystemQueryOptions);}if(!this.bRelative){if(this.aApplicationFilters.length>0){this.oCache=_.createListCacheProxy(this);}else{h=_.buildOrderbyOption(this.aSorters,this.mQueryOptions&&this.mQueryOptions.$orderby);this.oCache=b.create(m.oRequestor,p.slice(1),_.mergeQueryOptions(this.mQueryOptions,h));}}this.reset();this.setContext(o);m.bindingCreated(this);}});e.prototype._delete=function(g,E,o){var t=this;if(this.hasPendingChanges()){throw new Error("Cannot delete due to pending changes");}return this.deleteFromCache(g,E,String(o.getIndex()),function(I){var i,n;for(i=I;i<t.aContexts.length;i+=1){o=t.aContexts[i];n=t.aContexts[i+1];if(o&&!n){o.destroy();delete t.aContexts[i];}else if(!o&&n){t.aContexts[i]=a.create(t.oModel,t,t.sPath+"/"+i,i);}else if(!t.bUseExtendedChangeDetection){t.oModel.getDependentBindings(o).forEach(function(f){f.checkUpdate();});}}t.aContexts.pop();t.iMaxLength-=1;if(t.bUseExtendedChangeDetection){t.aDiff=[{index:I,type:"delete"}];}t._fireChange({reason:C.Remove});});};e.prototype.attachEvent=function(E){if(!(E in S)){throw new Error("Unsupported event '"+E+"': v4.ODataListBinding#attachEvent");}return L.prototype.attachEvent.apply(this,arguments);};e.prototype.createContexts=function(r,R,f,D){var g=false,o=this.oContext,i,n,m=this.oModel,h=m.resolve(this.sPath,o);for(i=r.start;i<r.start+R;i+=1){if(this.aContexts[i]===undefined){g=true;this.aContexts[i]=a.create(m,this,h+"/"+i,i);}}if(this.aContexts.length>this.iMaxLength){this.iMaxLength=Infinity;}if(R<r.length){this.iMaxLength=r.start+R;if(this.aContexts.length>this.iMaxLength){this.aContexts.length=this.iMaxLength;}}n=this.aContexts.length===this.iMaxLength;if(this.bLengthFinal!==n){this.bLengthFinal=n;g=true;}if(g){this._fireChange({reason:f});}if(D){this.fireDataReceived();}};e.prototype.deleteFromCache=function(g,E,p,f){var P;if(this.oCache){g=g||this.getUpdateGroupId();if(g!=="$auto"&&g!=="$direct"){throw new Error("Illegal update group ID: "+g);}P=this.oCache._delete(g,E,p,f);this.oModel.addedRequestToGroup(g);return P;}return this.oContext.getBinding().deleteFromCache(g,E,c.buildPath(this.oContext.getIndex(),this.sPath,p),f);};e.prototype.deregisterChange=function(p,l,i){if(this.oCache){this.oCache.deregisterChange(i,p,l);}else if(this.oContext){this.oContext.deregisterChange(c.buildPath(this.sPath,i,p),l);}};e.prototype.destroy=function(){this.oModel.bindingDestroyed(this);L.prototype.destroy.apply(this);};e.prototype.enableExtendedChangeDetection=function(D,k){if(k!==undefined){throw new Error("Unsupported property 'key' with value '"+k+"' in binding info for "+this);}return L.prototype.enableExtendedChangeDetection.apply(this,arguments);};e.prototype.fetchAbsoluteValue=function(p){var i,P,r;if(this.oCache){r=this.oModel.resolve(this.sPath,this.oContext)+"/";if(p.lastIndexOf(r)===0){p=p.slice(r.length);i=parseInt(p,10);P=p.indexOf("/");p=P>0?p.slice(P+1):"";return this.fetchValue(p,undefined,i);}}if(this.oContext){return this.oContext.fetchAbsoluteValue(p);}return d.resolve();};e.prototype.fetchValue=function(p,l,i){if(this.oCache){return this.oCache.read(i,1,undefined,p,undefined,l);}if(this.oContext){return this.oContext.fetchValue(c.buildPath(this.sPath,i,p),l);}return d.resolve();};e.prototype.filter=function(f,g){if(this.sOperationMode!==O.Server){throw new Error("Operation mode has to be sap.ui.model.odata.OperationMode.Server");}if(this.hasPendingChanges()){throw new Error("Cannot filter due to pending changes");}if(g===F.Control){this.aFilters=_.toArray(f);}else{this.aApplicationFilters=_.toArray(f);}this.mCacheByContext=undefined;this.oCache=_.createListCacheProxy(this,this.oContext);this.sChangeReason=C.Filter;this.reset();this._fireRefresh({reason:C.Filter});return this;};e.prototype.getContexts=function(i,l,m){var f,o=this.oContext,g,D=false,G,p,r,t=this;if(m!==undefined&&this.bUseExtendedChangeDetection){throw new Error("Unsupported operation: v4.ODataListBinding#getContexts,"+" third parameter must not be set if extended change detection is enabled");}if(this.bRelative&&!o){return[];}f=this.sChangeReason||C.Change;this.sChangeReason=undefined;i=i||0;l=l||this.oModel.iSizeLimit;if(!m||m<0){m=0;}r=_.getReadRange(this.aContexts,i,l,m,this.iMaxLength);if(r){if(this.oCache){G=this.sRefreshGroupId||this.getGroupId();this.sRefreshGroupId=undefined;p=this.oCache.read(r.start,r.length,G,undefined,function(){D=true;t.oModel.addedRequestToGroup(G,t.fireDataRequested.bind(t));});}else{p=o.fetchValue(this.sPath);}p.then(function(R){var h,j;if(!t.bRelative||t.oContext===o){h=R&&(Array.isArray(R)?R:R.value);j=h?h.length:0;if(t.bUseExtendedChangeDetection){return _.requestDiff(t,h,i,l).then(function(k){t.aDiff=k;t.createContexts(r,j,f,D);});}else{t.createContexts(r,j,f,D);}}else if(D){t.fireDataReceived();}},function(E){if(D){if(E.canceled){t.fireDataReceived();}else{t.oModel.reportError("Failed to get contexts for "+t.oModel.sServiceUrl+t.oModel.resolve(t.sPath,t.oContext).slice(1)+" with start index "+i+" and length "+l,s,E);t.fireDataReceived({error:E});}}})["catch"](function(E){q.sap.log.error(E.message,E.stack,s);});}this.iCurrentBegin=i;this.iCurrentEnd=i+l;g=this.aContexts.slice(i,i+l);if(this.bUseExtendedChangeDetection){g.dataRequested=!!r;g.diff=g.dataRequested?[]:this.aDiff;this.aDiff=[];}if(f===C.Refresh){this.oModel.getDependentBindings(this).forEach(function(h){h.checkUpdate();});}return g;};e.prototype.getCurrentContexts=function(){var f=this.aContexts.slice(this.iCurrentBegin,this.iCurrentEnd),l=Math.min(this.iCurrentEnd,this.iMaxLength)-this.iCurrentBegin;while(f.length<l){f.push(undefined);}return f;};e.prototype.getDistinctValues=function(){throw new Error("Unsupported operation: v4.ODataListBinding#getDistinctValues");};e.prototype.getGroupId=function(){return this.sGroupId||(this.bRelative&&this.oContext&&this.oContext.getGroupId())||this.oModel.getGroupId();};e.prototype.getLength=function(){return this.bLengthFinal?this.aContexts.length:this.aContexts.length+10;};e.prototype.getUpdateGroupId=function(){return this.sUpdateGroupId||(this.bRelative&&this.oContext&&this.oContext.getUpdateGroupId())||this.oModel.getUpdateGroupId();};e.prototype.hasPendingChanges=function(){return _.hasPendingChanges(this,true);};e.prototype.initialize=function(){if(!this.bRelative||this.oContext){this._fireChange({reason:C.Change});}};e.prototype.isInitial=function(){throw new Error("Unsupported operation: v4.ODataListBinding#isInitial");};e.prototype.isLengthFinal=function(){return this.bLengthFinal;};e.prototype.refresh=function(g){if(this.bRelative){throw new Error("Refresh on this binding is not supported");}if(this.hasPendingChanges()){throw new Error("Cannot refresh due to pending changes");}_.checkGroupId(g);this.refreshInternal(g);};e.prototype.refreshInternal=function(g){this.sRefreshGroupId=g;if(this.oCache){if(this.bRelative){this.oCache.deregisterChange();this.oCache=_.createListCacheProxy(this,this.oContext);this.mCacheByContext=undefined;}else{this.oCache.refresh();}}this.reset();this.sChangeReason=C.Refresh;this._fireRefresh({reason:C.Refresh});this.oModel.getDependentBindings(this).forEach(function(D){if(D.refreshInternal){D.refreshInternal(g);}});};e.prototype.reset=function(){this.aContexts=[];this.iCurrentBegin=this.iCurrentEnd=0;this.iMaxLength=Infinity;this.bLengthFinal=false;};e.prototype.resetChanges=function(){_.resetChanges(this,true);};e.prototype.resume=function(){throw new Error("Unsupported operation: v4.ODataListBinding#resume");};e.prototype.setContext=function(o){if(this.oContext!==o){if(this.bRelative){this.reset();if(this.oCache){this.oCache.deregisterChange();this.oCache=undefined;}if(o){this.oCache=_.createListCacheProxy(this,o);}B.prototype.setContext.call(this,o);}else{this.oContext=o;}}};e.prototype.sort=function(v){var o;if(this.sOperationMode!==O.Server){throw new Error("Operation mode has to be sap.ui.model.odata.OperationMode.Server");}if(this.hasPendingChanges()){throw new Error("Cannot sort due to pending changes");}this.aSorters=_.toArray(v);if(this.bRelative){this.mCacheByContext=undefined;this.oCache=_.createListCacheProxy(this,this.oContext);}else{o=_.buildOrderbyOption(this.aSorters,this.mQueryOptions&&this.mQueryOptions.$orderby);this.oCache=b.create(this.oModel.oRequestor,this.sPath.slice(1),_.mergeQueryOptions(this.mQueryOptions,o));}this.reset();this.sChangeReason=C.Sort;this._fireRefresh({reason:C.Sort});return this;};e.prototype.suspend=function(){throw new Error("Unsupported operation: v4.ODataListBinding#suspend");};e.prototype.toString=function(){return s+": "+(this.bRelative?this.oContext+"|":"")+this.sPath;};e.prototype.updateValue=function(g,p,v,E,P){var o;if(this.oCache){g=g||this.getUpdateGroupId();o=this.oCache.update(g,p,v,E,P);this.oModel.addedRequestToGroup(g);return o;}return this.oContext.updateValue(g,p,v,E,c.buildPath(this.sPath,P));};return e;},true);
