/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/Device','sap/ui/core/Control','sap/ui/core/Element','sap/ui/core/IconPool','sap/ui/core/IntervalTrigger','sap/ui/core/library','sap/ui/core/Popup','sap/ui/core/ResizeHandler','sap/ui/core/ScrollBar','sap/ui/core/delegate/ItemNavigation','sap/ui/core/theming/Parameters','sap/ui/model/ChangeReason','sap/ui/model/Context','sap/ui/model/Filter','sap/ui/model/SelectionModel','sap/ui/model/Sorter','./Column','./Row','./library','./TableUtils','./TableExtension','./TableAccExtension','./TableKeyboardExtension','./TablePointerExtension','./TableScrollExtension','jquery.sap.dom','jquery.sap.trace'],function(q,D,C,E,I,c,d,P,R,S,e,f,g,h,F,k,m,n,o,p,T,r,s,t,u,v){"use strict";var G=p.GroupEventType,N=p.NavigationMode,w=p.SelectionMode,x=p.SelectionBehavior,y=p.SharedDomRef,z=p.SortOrder,V=p.VisibleRowCountMode;var M,A;var B=C.extend("sap.ui.table.Table",{metadata:{library:"sap.ui.table",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'auto'},rowHeight:{type:"int",group:"Appearance",defaultValue:null},columnHeaderHeight:{type:"int",group:"Appearance",defaultValue:null},columnHeaderVisible:{type:"boolean",group:"Appearance",defaultValue:true},visibleRowCount:{type:"int",group:"Appearance",defaultValue:10},firstVisibleRow:{type:"int",group:"Appearance",defaultValue:0},selectionMode:{type:"sap.ui.table.SelectionMode",group:"Behavior",defaultValue:w.MultiToggle},selectionBehavior:{type:"sap.ui.table.SelectionBehavior",group:"Behavior",defaultValue:x.RowSelector},selectedIndex:{type:"int",group:"Appearance",defaultValue:-1},editable:{type:"boolean",group:"Behavior",defaultValue:true},navigationMode:{type:"sap.ui.table.NavigationMode",group:"Behavior",defaultValue:N.Scrollbar},threshold:{type:"int",group:"Appearance",defaultValue:100},enableColumnReordering:{type:"boolean",group:"Behavior",defaultValue:true},enableGrouping:{type:"boolean",group:"Behavior",defaultValue:false},showColumnVisibilityMenu:{type:"boolean",group:"Appearance",defaultValue:false},showNoData:{type:"boolean",group:"Appearance",defaultValue:true},visibleRowCountMode:{type:"sap.ui.table.VisibleRowCountMode",group:"Appearance",defaultValue:V.Fixed},minAutoRowCount:{type:"int",group:"Appearance",defaultValue:5},fixedColumnCount:{type:"int",group:"Appearance",defaultValue:0},fixedRowCount:{type:"int",group:"Appearance",defaultValue:0},fixedBottomRowCount:{type:"int",group:"Appearance",defaultValue:0},enableColumnFreeze:{type:"boolean",group:"Behavior",defaultValue:false},enableCellFilter:{type:"boolean",group:"Behavior",defaultValue:false},showOverlay:{type:"boolean",group:"Appearance",defaultValue:false},enableSelectAll:{type:"boolean",group:"Behavior",defaultValue:true},enableCustomFilter:{type:"boolean",group:"Behavior",defaultValue:false},enableBusyIndicator:{type:"boolean",group:"Behavior",defaultValue:false}},defaultAggregation:"columns",aggregations:{title:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false},footer:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false},toolbar:{type:"sap.ui.core.Toolbar",multiple:false,deprecated:true},extension:{type:"sap.ui.core.Control",multiple:true,singularName:"extension"},columns:{type:"sap.ui.table.Column",multiple:true,singularName:"column",bindable:"bindable"},rows:{type:"sap.ui.table.Row",multiple:true,singularName:"row",bindable:"bindable"},noData:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false}},associations:{groupBy:{type:"sap.ui.table.Column",multiple:false},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{rowSelectionChange:{parameters:{rowIndex:{type:"int"},rowContext:{type:"object"},rowIndices:{type:"int[]"},selectAll:{type:"boolean"},userInteraction:{type:"boolean"}}},columnSelect:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"}}},columnResize:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},width:{type:"sap.ui.core.CSSSize"}}},columnMove:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},newPos:{type:"int"}}},sort:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},sortOrder:{type:"sap.ui.table.SortOrder"},columnAdded:{type:"boolean"}}},filter:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},value:{type:"string"}}},group:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"}}},columnVisibility:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},visible:{type:"boolean"}}},cellClick:{allowPreventDefault:true,parameters:{cellControl:{type:"sap.ui.core.Control"},cellDomRef:{type:"Object"},rowIndex:{type:"int"},columnIndex:{type:"int"},columnId:{type:"string"},rowBindingContext:{type:"sap.ui.model.Context"}}},cellContextmenu:{allowPreventDefault:true,parameters:{cellControl:{type:"sap.ui.core.Control"},cellDomRef:{type:"Object"},rowIndex:{type:"int"},columnIndex:{type:"int"},columnId:{type:"string"},rowBindingContext:{type:"sap.ui.model.Context"}}},columnFreeze:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"}}},customFilter:{column:{type:"sap.ui.table.Column"},value:{type:"string"}},firstVisibleRowChanged:{firstVisibleRow:{type:"int"}},busyStateChanged:{busy:{type:"boolean"}}},designTime:true}});I.insertFontFaceStyle();B.prototype.init=function(){this._iBaseFontSize=parseFloat(q("body").css("font-size"))||16;this._oResBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.table");this._bRtlMode=sap.ui.getCore().getConfiguration().getRTL();this._attachExtensions();this._bBindingLengthChanged=false;this._mTimeouts={};this._lastCalledUpdateRows=0;this._iBindingTimerDelay=50;this._iMaxScrollbarHeight=1000000;this._iRowHeightsDelta=0;this._iRenderedFirstVisibleRow=0;var a=this;this._performUpdateRows=function(b){if(!a.bIsDestroyed){a._lastCalledUpdateRows=Date.now();a._updateBindingContexts(undefined,undefined,b);if(!a._bInvalid){a._updateTableContent();a._getAccExtension().updateAccForCurrentCell(false);a._updateSelection();var i=a._collectTableSizes();a._updateRowHeader(i.tableRowHeights);a._syncColumnHeaders(i);if(T.isVariableRowHeightEnabled(a)){a._iRowHeightsDelta=this._getRowHeightsDelta(i.tableRowHeights);a._iRenderedFirstVisibleRow=this.getFirstVisibleRow();}if(a._bBindingLengthChanged){a._updateVSb();}a._toggleVSb();if(T.isVariableRowHeightEnabled(a)){var j=0;var l=this.getDomRef(y.VerticalScrollBar);if(l){j=l.scrollTop;}a._adjustTablePosition(j,i.tableRowHeights);}}a._mTimeouts.bindingTimer=undefined;a.fireEvent("_rowsUpdated");}a._bBindingLengthChanged=false;};this._initSelectionModel(k.MULTI_SELECTION);this._iColMinWidth=20;if('ontouchstart'in document){this._iColMinWidth=88;}this._aTableHeaders=[];this._aIdxCols2Cells=[];this._bInheritEditableToControls=false;this._bAllowColumnHeaderTextSelection=false;this._bjQueryLess18=q.sap.Version(q.fn.jquery).compareTo("1.8")<0;this._iDataRequestedCounter=0;this._iBindingLength=0;this._iTableRowContentHeight=0;this._bFirstRendering=true;this._bInvalid=true;this._bIsScrollVertical=null;};B.prototype._attachExtensions=function(){if(this._bExtensionsInitialized){return;}r.enrich(this,u);r.enrich(this,v);r.enrich(this,t);r.enrich(this,s);this._bExtensionsInitialized=true;};B.prototype.exit=function(){this._bExitCalled=true;if(this._oPaginator){this._oPaginator.destroy();}this._resetRowTemplate();this._detachExtensions();this._cleanUpTimers();this._detachEvents();if(this._oSelection){this._oSelection.destroy();}};B.prototype._detachExtensions=function(){r.cleanup(this);};B.prototype.onThemeChanged=function(){if(this.getDomRef()){this.invalidate();}};B.prototype._collectRowHeights=function(){var a=this.getDomRef();if(!a){return[];}var b=this._getDefaultRowHeight();var j=a.querySelectorAll(".sapUiTableCtrlFixed > tbody > tr");var l=a.querySelectorAll(".sapUiTableCtrlScroll > tbody > tr");var H=[];for(var i=0;i<l.length;i++){var J=0;if(j[i]){J=j[i].getBoundingClientRect().height;}var K=l[i].getBoundingClientRect().height;H.push(Math.max(J,K,b));}return H;};B.prototype._resetRowHeights=function(){var a=this.getRowHeight();var b="";if(a){b=a+"px";}var j=this.getDomRef();if(j){var l=j.querySelectorAll(".sapUiTableCtrlFixed > tbody > tr, .sapUiTableCtrlScroll > tbody > tr");for(var i=0;i<l.length;i++){l[i].style.height=b;}}};B.prototype._determineAvailableSpace=function(){var a=this.getDomRef();if(a&&a.parentNode){var b=a.querySelector(".sapUiTableCCnt");if(b){var U=a.scrollHeight-b.clientHeight;return q(a.parentNode).height()-U;}}return 0;};B.prototype._collectTableSizes=function(a){var b={tableCtrlScrollWidth:0,tableRowHdrScrWidth:0,tableCtrlScrWidth:0,tableHSbScrollLeft:0,tableCtrlFixedWidth:0,tableCntHeight:0,tableCntWidth:0,invisibleColWidth:0};var j=this.getDomRef();if(!j){return b;}var l=j.querySelector(".sapUiTableCnt");if(l){b.tableCntHeight=l.clientHeight;b.tableCntWidth=l.clientWidth;}var H=j.querySelector(".sapUiTableCtrlScroll");if(H){b.tableCtrlScrollWidth=H.clientWidth;}var J=j.querySelector(".sapUiTableRowHdrScr");if(J){b.tableRowHdrScrWidth=J.clientWidth;}var K=j.querySelector(".sapUiTableCtrlScr");if(K){b.tableCtrlScrWidth=K.clientWidth;}var L=this.getDomRef(y.HorizontalScrollBar);if(L){b.tableHSbScrollLeft=L.scrollLeft;}var O=j.querySelector(".sapUiTableCtrlFixed");if(O){b.tableCtrlFixedWidth=O.clientWidth;}var Q=this.getProperty("fixedColumnCount");var U=[];var W=0;var X=j.querySelectorAll(".sapUiTableCtrlFirstCol > th:not(.sapUiTableColSel)");if(X){var Y=this.getColumns();for(var i=0;i<X.length;i++){var Z=X[i].getBoundingClientRect().width;U.push(Z);if(i<Y.length&&Y[i]&&!Y[i].getVisible()){Q--;}if(i<Q){W+=Z;}}}if(Q>0){var $=0;var _=this.getDomRef("sapUiTableRowHdrScr");if(_){$+=_.clientWidth;}var a1=this.getDomRef("vsb");if(a1){$+=a1.offsetWidth;}var b1=(j.clientWidth-$<W);if(this._bIgnoreFixedColumnCount!=b1){this._bIgnoreFixedColumnCount=b1;this.invalidate();}}b.headerWidths=U;if(T.hasRowHeader(this)){var c1=j.querySelector(".sapUiTableCtrlFirstCol > th:first-child");if(c1){b.invisibleColWidth=c1.clientWidth;}}if(!a){b.tableRowHeights=this._collectRowHeights();}else{b.tableRowHeights=a;}return b;};B.prototype._updateRowHeader=function(a){var b=this.getDomRef();if(!b){return;}var j=b.querySelectorAll(".sapUiTableRowHdr");var l=b.querySelectorAll(".sapUiTableCtrlFixed > tbody > tr");var H=b.querySelectorAll(".sapUiTableCtrlScroll > tbody > tr");var L=Math.max(j.length,H.length,0);for(var i=0;i<L;i++){var J=a[i];if(J){if(j[i]){j[i].style.height=J+"px";}if(l[i]){l[i].style.height=J+"px";}if(H[i]){H[i].style.height=J+"px";}}}};B.prototype.onBeforeRendering=function(a){if(a&&a.isMarked("insertTableRows")){return;}if(this._mTimeouts.bindingTimer){this._updateBindingContexts();}this._cleanUpTimers();this._detachEvents();var b=this.getVisibleRowCountMode();var i=this.getRows();if(b==V.Interactive||b==V.Fixed||(b==V.Auto&&this._iTableRowContentHeight&&i.length==0)){if(this.getBinding("rows")){this._adjustRows(this._calculateRowsToDisplay());}else{var j=this;this._mTimeouts.onBeforeRenderingAdjustRows=this._mTimeouts.onBeforeRenderingAdjustRows||window.setTimeout(function(){j._adjustRows(j._calculateRowsToDisplay());j._mTimeouts.onBeforeRenderingAdjustRows=undefined;},0);}}else if(!this._oRowTemplate&&i.length>0){this._adjustRows(i.length);}};B.prototype.onAfterRendering=function(a){if(a&&a.isMarked("insertTableRows")){this.getDomRef(y.VerticalScrollBar).style.maxHeight=this._getVSbHeight()+"px";this._updateVSbRange();return;}this._bInvalid=false;this._bOnAfterRendering=true;var $=this.$();this._attachEvents();this._initRowDomRefs();var b=this.getColumns();for(var i=0,l=b.length;i<l;i++){if(b[i].getVisible()){b[i]._restoreIcons();}}if(!this._bAllowColumnHeaderTextSelection){this._disableTextSelection($.find(".sapUiTableColHdrCnt"));}this._bOnAfterRendering=false;this._getKeyboardExtension().invalidateItemNavigation();this._updateTableContent();if(this._bFirstRendering&&this.getVisibleRowCountMode()==V.Auto){this._bFirstRendering=false;Promise.resolve().then(this._updateTableSizes.bind(this,true));}else if(!this._mTimeouts.onAfterRenderingUpdateTableSizes){this._updateTableSizes();}this._updateVSb(this._iScrollTop);if(this._iScrollLeft){this.getDomRef(y.HorizontalScrollBar).scrollLeft=this._iScrollLeft;}if(this.getBinding("rows")){this.fireEvent("_rowsUpdated");}};B.prototype.invalidate=function(){if(!this._ignoreInvalidateOfChildControls){this._bInvalid=true;var a=C.prototype.invalidate.call(this);}return a;};B.prototype._initRowDomRefs=function(){var a=this.getRows();for(var i=0;i<a.length;i++){a[i].initDomRefs();}};B.prototype._updateTableSizes=function(b,a){this._mTimeouts.onAfterRenderingUpdateTableSizes=undefined;var i=this.getDomRef();if(this._bInvalid||!i){return;}this._resetRowHeights();var j=this._collectRowHeights();if(T.isVariableRowHeightEnabled(this)){this._iRowHeightsDelta=this._getRowHeightsDelta(j);}var l=0;if(!a&&this.getVisibleRowCountMode()==V.Auto){l=this._determineAvailableSpace();if(this._handleRowCountModeAuto(l)&&!b){return;}}T.deregisterResizeHandler(this,"");this._toggleVSb();var H=this._collectTableSizes(j);if(this._mTimeouts.afterUpdateTableSizes){window.clearTimeout(this._mTimeouts.afterUpdateTableSizes);}if(H.tableCntHeight==0&&H.tableCntWidth==0){T.registerResizeHandler(this,"",this._onTableResize.bind(this),true);return;}this._updateRowHeader(H.tableRowHeights);this._syncColumnHeaders(H);this._determineVisibleCols(H);if(!a){this._setRowContentHeight(l);}this._updateHSb(H);var J=this;var $=this.$();$.find(".sapUiTableNoOpacity").addBack().removeClass("sapUiTableNoOpacity");function K(){T.registerResizeHandler(J,"",J._onTableResize.bind(J),true);}if($.closest(".sapUiLoSplitter").length){K();}else{this._mTimeouts.afterUpdateTableSizes=window.setTimeout(K,0);}};B.prototype.setShowOverlay=function(b){b=!!b;this.setProperty("showOverlay",b,true);if(this.getDomRef()){var a=document.activeElement;this.$().toggleClass("sapUiTableOverlay",b);this._getAccExtension().updateAriaStateForOverlayAndNoData();this._getKeyboardExtension().updateNoDataAndOverlayFocus(a);}return this;};B.prototype._updateFixedBottomRows=function(){var a=this.getFixedBottomRowCount();var b=this.getDomRef();if(b&&a>0){var $=q(b).find(".sapUiTableFixedPreBottomRow");$.removeClass("sapUiTableFixedPreBottomRow");var j=this.getBinding("rows");if(j){var l=this.getVisibleRowCount();var H=false;var J=this.getRows();var K=this._getSanitizedFirstVisibleRow();for(var i=0;i<J.length;i++){var L=J[i].getDomRefs(true);if(this._iBindingLength>=l){H=(i==l-a-1);}else{H=(K+i)==(this._iBindingLength-a-1)&&(K+i)<this._iBindingLength;}L.row.toggleClass("sapUiTableFixedPreBottomRow",H);}}}};B.prototype.getFocusInfo=function(){var i=this.$().find(":focus").attr("id");if(i){return{customId:i};}else{return E.prototype.getFocusInfo.apply(this,arguments);}};B.prototype.applyFocusInfo=function(a){if(a&&a.customId){this.$().find("#"+a.customId).focus();}else{E.prototype.getFocusInfo.apply(this,arguments);}return this;};B.prototype.setTitle=function(a){var b=a;if(typeof(a)==="string"||a instanceof String){b=p.TableHelper.createTextView({text:a,width:"100%"});b.addStyleClass("sapUiTableHdrTitle");}this.setAggregation("title",b);return this;};B.prototype.setFooter=function(a){var b=a;if(typeof(a)==="string"||a instanceof String){b=p.TableHelper.createTextView({text:a,width:"100%"});}this.setAggregation("footer",b);return this;};B.prototype.setSelectionMode=function(a){this.clearSelection();if(a===w.Single){this._oSelection.setSelectionMode(k.SINGLE_SELECTION);}else{this._oSelection.setSelectionMode(k.MULTI_SELECTION);}a=T.sanitizeSelectionMode(this,a);this.setProperty("selectionMode",a);return this;};B.prototype._adjustTablePosition=function(i,a){var b=i<this._getVirtualScrollRange();var j=this._getRowCount()>this.getVisibleRowCount();if(b&&this.getFirstVisibleRow()!=this._iRenderedFirstVisibleRow){return;}var l=null;if(b&&j){var H=a[0];var J=this._getScrollingPixelsForRow();var K=i-(this.getFirstVisibleRow()*J);var L=K/J;l=Math.ceil(L*H);if(l>H){l=null;}}else if(this._iRowHeightsDelta>=0){var O=j?i-this._getVirtualScrollRange():i;l=(this._iRowHeightsDelta/this._getRowCorrectionScrollRange())*O;}if(l!=null&&l>-1){this.$().find(".sapUiTableCCnt").scrollTop(l);}};B.prototype.setFirstVisibleRow=function(i,O,b){if(this.getNavigationMode()==sap.ui.table.NavigationMode.Paginator){var a=this.getVisibleRowCount();var j=this._paginatorCalculateTargetPage(i,a);var l=(j-1)*a;if(i!=l){i=l;j=this._paginatorCalculateTargetPage(i,a);}this._paginatorUpdate(j);}var H=this.getFirstVisibleRow()!=i;this.setProperty("firstVisibleRow",i,true);if(H&&this.getBinding("rows")&&!this._bRefreshing){this.updateRows();if(!O){this._updateVSb();}}if(H&&!b){this.fireFirstVisibleRowChanged({firstVisibleRow:i});}return this;};B.getMetadata().getAggregation("rows")._doesNotRequireFactory=true;B.prototype.bindRows=function(b,a,i,j){if(typeof b==="string"&&(a instanceof m||q.isArray(i)&&i[0]instanceof F)){j=i;i=a;a=undefined;}return this.bindAggregation("rows",b,a,i,j);};B.prototype._bindAggregation=function(a,b,i,j,l){E.prototype._bindAggregation.apply(this,arguments);var H=this.getBinding("rows");if(a==="rows"&&H){H.attachChange(this._onBindingChange,this);}this._initSelectionModel(k.MULTI_SELECTION);if(H&&this.isTreeBinding("rows")&&!H.hasListeners("selectionChanged")){H.attachSelectionChanged(this._onSelectionChanged,this);}return this;};B.prototype._initSelectionModel=function(a){if(this._oSelection){this._oSelection.detachSelectionChanged(this._onSelectionChanged,this);}this._oSelection=new k(a);this._oSelection.attachSelectionChanged(this._onSelectionChanged,this);return this;};B.prototype._onBindingChange=function(a){var b=typeof(a)==="object"?a.getParameter("reason"):a;if(b==="sort"||b==="filter"){this.clearSelection();this.setFirstVisibleRow(0);}};B.prototype.unbindAggregation=function(a,b){var i=this.getBinding("rows");if(a==="rows"&&this.isBound("rows")){b=true;}var j=E.prototype.unbindAggregation.apply(this,[a,b]);if(a==="rows"&&i){this._restoreAppDefaultsColumnHeaderSortFilter();this._invalidateColumnMenus();this._updateBindingLength();this.updateRows("unbindAggregation");}return j;};B.prototype.setVisibleRowCount=function(i){if(i!=null&&!isFinite(i)){return this;}var a=this.getVisibleRowCountMode();if(a==V.Auto){q.sap.log.error("VisibleRowCount will be ignored since VisibleRowCountMode is set to Auto",this);return this;}var b=this.getFixedRowCount()+this.getFixedBottomRowCount();if(i<=b&&b>0){q.sap.log.error("Table: "+this.getId()+" visibleRowCount('"+i+"') must be bigger than number of fixed rows('"+(this.getFixedRowCount()+this.getFixedBottomRowCount())+"')",this);return this;}i=this.validateProperty("visibleRowCount",i);if(this.getBinding("rows")&&this.getBinding("rows").getLength()<=i){this.setProperty("firstVisibleRow",0);}this.setProperty("visibleRowCount",i);this._setRowContentHeight(i*this._getDefaultRowHeight());return this;};B.prototype.setRowHeight=function(i){this.setProperty("rowHeight",i);this._iTableRowContentHeight=undefined;return this;};B.prototype.setTooltip=function(a){q.sap.log.warning("The aggregation tooltip is not supported for sap.ui.table.Table");return this.setAggregation("tooltip",a,true);};B.prototype.setNavigationMode=function(){this.setProperty("navigationMode",N.Scrollbar,true);q.sap.log.error("The navigationMode property is deprecated and must not be used anymore. Your setting was defaulted to 'Scrollbar'",this);};B.prototype._getFixedBottomRowContexts=function(i,b){var a=this.getBinding("rows");var j=[];if(!a){return j;}i=i||this.getFixedBottomRowCount();b=b||a.getLength();var l=this.getVisibleRowCount();if(i>0&&(l-i)<b){j=this._getContexts(b-i,i,1);}return j;};B.prototype._getFixedRowContexts=function(i){i=i||this.getFixedRowCount();if(i>0){return this._getContexts(0,i);}else{return[];}};B.prototype._getContexts=function(i,l,a){var b=this.getBinding("rows");if(b){return b.getContexts(i,l,a);}else{return[];}};B.prototype._getRowContexts=function(a,b,j){var l=false;var H=[];var J=this.getBinding("rows");var K=a||this.getRows().length;if(!J||K<=0){return[];}var L=this.getFirstVisibleRow();var O=this.getFixedRowCount();var Q=this.getFixedBottomRowCount();var U=0;var W;var X=K-Q;var Y=0;var Z=X;var $=this.getThreshold();$=$?Math.max(K,$):0;var _=L;var a1=function(f1,g1,_){for(var i=0;i<g1.length;i++){f1[_+i]=g1[i];}};if(O>0&&L>0){_=L+O;X-=O;Y=O;W=this._getFixedRowContexts(O);U+=W.length;H=H.concat(W);}W=this._getContexts(_,X,$);var b1=this._updateBindingLength(j);l=W.length<Math.min(X,b1-Q);if(this.getNavigationMode===N.Paginator){var c1=Math.min(X,(Math.max(b1-L-Q,0)));if(c1<X){X=c1;W=W.slice(0,X);}}U+=W.length;a1(H,W,Y);Z=Math.min(Z,Math.max(b1-Q,0));if(Q>0){W=this._getFixedBottomRowContexts(Q,b1);U+=W.length;a1(H,W,Z);}if(l&&!b){var d1=this._getSanitizedFirstVisibleRow(true);if(L!=d1){H=this._getRowContexts(K,true);U=H.length;}}if(!b){var e1=this;if(this._mTimeouts.getContextsSetBusy){window.clearTimeout(this._mTimeouts.getContextsSetBusy);}this._mTimeouts.getContextsSetBusy=window.setTimeout(function(){e1._setBusy({requestedLength:O+X+Q,receivedLength:U,contexts:H,reason:j});},0);}return H;};B.prototype._getSanitizedFirstVisibleRow=function(U){var a=this.getNavigationMode();var i=this.getVisibleRowCount();var b=this.getFirstVisibleRow();b=Math.max(b,0);if(a===N.Scrollbar&&this._iBindingLength>0&&!T.isVariableRowHeightEnabled(this)){b=Math.min(b,Math.max(this._iBindingLength-i,0));}else if(a===N.Paginator&&this._oPaginator){var j=this._paginatorCalculateTargetPage(b,i);b=(j-1)*i;if(U){this._paginatorUpdate(j);}}if(U){this.setProperty("firstVisibleRow",b,true);}return b;};B.prototype._paginatorCalculateTargetPage=function(i,a){var b=1;if(this._oPaginator){if(i<this._iBindingLength){b=Math.ceil((i+1)/a);}}return b;};B.prototype._paginatorUpdate=function(i){if(this._oPaginator&&i!==this._oPaginator.getCurrentPage()){this._oPaginator.setCurrentPage(i);if(this._oPaginator.getDomRef()){this._oPaginator.rerender();}}};B.prototype._updateBindingLength=function(a){var b=this.getBinding("rows");var i=0;if(b){i=b.getLength();}if(i!=this._iBindingLength){this._iBindingLength=i;this._onBindingLengthChange(a);}return i;};B.prototype._onBindingLengthChange=function(a){this._updateFixedBottomRows();this._toggleVSb();this._updateVSbRange();this._bBindingLengthChanged=true;if(a!="skipNoDataUpdate"){this._updateNoData();}};B.prototype.refreshRows=function(a){var b=this.getBinding("rows");if(!b){q.sap.log.error("RefreshRows must not be called without a binding",this);return;}var i=this;var j=typeof(a)==="object"?a.getParameter("reason"):a;if(j==g.Refresh){this._attachBindingListener();}this._bBusyIndicatorAllowed=true;var l=this.getVisibleRowCountMode();if((this.bOutput&&l===V.Auto)||l!==V.Auto){var H=this._calculateRowsToDisplay();if(this.bOutput){b.attachEventOnce("dataRequested",function(){if(i._mTimeouts.refreshRowsAdjustRows){window.clearTimeout(i._mTimeouts.refreshRowsAdjustRows);}i._mTimeouts.refreshRowsAdjustRows=window.setTimeout(function(){i._adjustRows(H,true);},0);});}var U;if(j==g.Filter||j==g.Sort){U="skipNoDataUpdate";this.setFirstVisibleRow(0);}this._updateBindingContexts(true,H,U);}};B.prototype.updateRows=function(a){if(this._bExitCalled){return;}this._setBusy(a?{changeReason:a}:false);if(this._bBindingLengthChanged){this._updateNoData();}var b=this.getVisibleRowCountMode();if((this.getRows().length<=0||!this._oRowTemplate)&&((b==V.Auto&&this.bOutput)||b!=V.Auto)){if(this._iTableRowContentHeight){this._adjustRows(this._calculateRowsToDisplay());}}if(!this.bIsDestroyed){var i=(a==g.Change||(!this._mTimeouts.bindingTimer&&Date.now()-this._lastCalledUpdateRows>this._iBindingTimerDelay)||a=="unbindAggregation"?0:this._iBindingTimerDelay);var j=this;if(i==0&&a){Promise.resolve().then(function(){j._performUpdateRows(a);});}else{this._mTimeouts.bindingTimer=this._mTimeouts.bindingTimer||window.setTimeout(function(){j._performUpdateRows(a);},i);}}};B.prototype.insertRow=function(){q.sap.log.error("The control manages the rows aggregation. The method \"insertRow\" cannot be used programmatically!",this);};B.prototype.addRow=function(){q.sap.log.error("The control manages the rows aggregation. The method \"addRow\" cannot be used programmatically!",this);};B.prototype.removeRow=function(){q.sap.log.error("The control manages the rows aggregation. The method \"removeRow\" cannot be used programmatically!",this);};B.prototype.removeAllRows=function(){q.sap.log.error("The control manages the rows aggregation. The method \"removeAllRows\" cannot be used programmatically!",this);};B.prototype.destroyRows=function(){q.sap.log.error("The control manages the rows aggregation. The method \"destroyRows\" cannot be used programmatically!",this);};B.prototype.autoResizeColumn=function(i){this._getPointerExtension().doAutoResizeColumn(i);};B.prototype._attachEvents=function(){var $=this.$();$.find(".sapUiTableColHdrScr").scroll(q.proxy(this._oncolscroll,this));$.find(".sapUiTableCtrlScr").scroll(q.proxy(this._oncntscroll,this));$.find(".sapUiTableCtrlScrFixed").scroll(q.proxy(this._oncntscroll,this));$.find(".sapUiTableCtrlScrFixed, .sapUiTableColHdrFixed").on("scroll.sapUiTablePreventFixedAreaScroll",function(j){j.target.scrollLeft=0;});if(T.isVariableRowHeightEnabled(this)){var i=$.find(".sapUiTableCtrlScr, .sapUiTableCtrlScrFixed, .sapUiTableRowHdrScr");i.on("scroll.sapUiTableSyncScrollPosition",function(j){i.scrollTop(j.target.scrollTop);});}$.find(".sapUiTableRowHdr").hover(function(){q(this).addClass("sapUiTableRowHvr");var j=$.find(".sapUiTableRowHdr").index(this);$.find(".sapUiTableCtrlFixed > tbody > tr").filter(":eq("+j+")").addClass("sapUiTableRowHvr");$.find(".sapUiTableCtrlScroll > tbody > tr").filter(":eq("+j+")").addClass("sapUiTableRowHvr");},function(){q(this).removeClass("sapUiTableRowHvr");$.find(".sapUiTableCtrlFixed > tbody > tr").removeClass("sapUiTableRowHvr");$.find(".sapUiTableCtrlScroll > tbody > tr").removeClass("sapUiTableRowHvr");});$.find(".sapUiTableCtrlFixed > tbody > tr").hover(function(){q(this).addClass("sapUiTableRowHvr");var j=$.find(".sapUiTableCtrlFixed > tbody > tr").index(this);$.find(".sapUiTableRowHdr").filter(":eq("+(j)+")").addClass("sapUiTableRowHvr");$.find(".sapUiTableCtrlScroll > tbody > tr").filter(":eq("+j+")").addClass("sapUiTableRowHvr");},function(){q(this).removeClass("sapUiTableRowHvr");$.find(".sapUiTableRowHdr").removeClass("sapUiTableRowHvr");$.find(".sapUiTableCtrlScroll > tbody > tr").removeClass("sapUiTableRowHvr");});$.find(".sapUiTableCtrlScroll > tbody > tr").hover(function(){q(this).addClass("sapUiTableRowHvr");var j=$.find(".sapUiTableCtrlScroll > tbody > tr").index(this);$.find(".sapUiTableRowHdr").filter(":eq("+j+")").addClass("sapUiTableRowHvr");$.find(".sapUiTableCtrlFixed > tbody > tr").filter(":eq("+j+")").addClass("sapUiTableRowHvr");},function(){q(this).removeClass("sapUiTableRowHvr");$.find(".sapUiTableRowHdr").removeClass("sapUiTableRowHvr");$.find(".sapUiTableCtrlFixed > tbody > tr").removeClass("sapUiTableRowHvr");});var a=q(this.getDomRef(y.VerticalScrollBar));var b=q(this.getDomRef(y.HorizontalScrollBar));a.bind("scroll.sapUiTableVScroll",this.onvscroll.bind(this));b.bind("scroll.sapUiTableHScroll",this.onhscroll.bind(this));a.on("mousedown.sapUiTableVScrollClick",this.onVerticalScrollbarMouseDown.bind(this));if(D.browser.firefox){this._getScrollTargets().bind("MozMousePixelScroll.sapUiTableMouseWheel",this._onMouseWheel.bind(this));}else{this._getScrollTargets().bind("wheel.sapUiTableMouseWheel",this._onMouseWheel.bind(this));}if(sap.ui.getCore().getConfiguration().getAnimation()){q("body").bind('webkitTransitionEnd transitionend',q.proxy(function(j){if(q(j.target).has($).length>0){this._iDefaultRowHeight=undefined;this._updateTableSizes();}},this));}r.attachEvents(this);};B.prototype._detachEvents=function(){var $=this.$();$.find(".sapUiTableRowHdrScr").unbind();$.find(".sapUiTableCtrl > tbody > tr").unbind();$.find(".sapUiTableRowHdr").unbind();$.find(".sapUiTableCtrlScrFixed, .sapUiTableColHdrFixed").unbind("scroll.sapUiTablePreventFixedAreaScroll");if(T.isVariableRowHeightEnabled(this)){$.find(".sapUiTableCtrlScr, .sapUiTableCtrlScrFixed, .sapUiTableRowHdrScr").unbind("scroll.sapUiTableSyncScrollPosition");}var a=q(this.getDomRef(y.VerticalScrollBar));a.unbind("scroll.sapUiTableVScroll");a.off("mousedown.sapUiTableVScrollClick");var b=q(this.getDomRef(y.HorizontalScrollBar));b.unbind("scroll.sapUiTableHScroll");var i=this._getScrollTargets();i.unbind("MozMousePixelScroll.sapUiTableMouseWheel");i.unbind("wheel.sapUiTableMouseWheel");var j=q(document.body);j.unbind('webkitTransitionEnd transitionend');T.deregisterResizeHandler(this);r.detachEvents(this);};B.prototype._getScrollTargets=function(){var $=q(this.getDomRef("sapUiTableCtrlScr"));var a=q(this.getDomRef("rsz"));var b=q(this.getDomRef("sapUiTableCtrlScrFixed"));var i=q(this.getDomRef("sapUiTableRowHdrScr"));return $.add(b).add(i).add(a);};B.prototype._cleanUpTimers=function(){for(var K in this._mTimeouts){if(this._mTimeouts[K]){clearTimeout(this._mTimeouts[K]);this._mTimeouts[K]=undefined;}}};B.prototype._updateHSb=function(a){var $=this.$();var i=a.tableCtrlScrollWidth;if(!!D.browser.safari){i=Math.max(i,this._getColumnsWidth(this.getFixedColumnCount()));}if(i>a.tableCtrlScrWidth){if(!$.hasClass("sapUiTableHScr")){$.addClass("sapUiTableHScr");if(!!D.browser.safari){var b=$.find(".sapUiTableCtrlScroll, .sapUiTableColHdrScr > .sapUiTableColHdr");if(this._bjQueryLess18){b.width(i);}else{b.outerWidth(i);}}}var j=a.tableCtrlFixedWidth;if($.find(".sapUiTableRowHdrScr").length>0){j+=a.tableRowHdrScrWidth;}if(this.getRows().length>0){var l=$.find(".sapUiTableHSb");if(this._bRtlMode){l.css('margin-right',j+'px');}else{l.css('margin-left',j+'px');}}var H=this.getDomRef("hsb-content");if(H){H.style.width=i+"px";}}else{if($.hasClass("sapUiTableHScr")){$.removeClass("sapUiTableHScr");if(!!D.browser.safari){$.find(".sapUiTableCtrlScroll, .sapUiTableColHdr").css("width","");}}}};B.prototype._updateVSb=function(i){var a=this.getDomRef(y.VerticalScrollBar);if(!a){return;}if(i===undefined){i=Math.ceil(this.getFirstVisibleRow()*this._getScrollingPixelsForRow());}var b=this.getDomRef("tableCCnt");if(b){var j=b.offsetTop;var l=this.getFixedRowCount();if(l>0){j+=this._iVsbTop;}a.style.top=j+"px";}a.scrollTop=i;};B.prototype._updateVSbRange=function(){var a=this.getDomRef(y.VerticalScrollBar);if(!a){return;}q(this.getDomRef("vsb-content")).height(this._getTotalScrollRange());};B.prototype._toggleVSb=function(){var $=this.$();var b=this.getBinding("rows");if(this._oPaginator&&this.getNavigationMode()===N.Paginator){var i=0;var a=0;if(b){var j=this.getVisibleRowCount();i=Math.ceil((this._iBindingLength||0)/j);var l=Math.min(i,Math.ceil((this.getFirstVisibleRow()+1)/j));this.setProperty("firstVisibleRow",(Math.max(l,1)-1)*j,true);a=l;}this._oPaginator.setNumberOfPages(i);this._oPaginator.setCurrentPage(a);if(this._oPaginator.getDomRef()){this._oPaginator.rerender();}if(this.getDomRef()){$.removeClass("sapUiTableVScr");}}else if(this.getDomRef()){var H=this._isVSbRequired();if(!H){this._updateVSb(0);}$.toggleClass("sapUiTableVScr",H);}};B.prototype._isVSbRequired=function(){if(this.getNavigationMode()===N.Scrollbar){if(this._iRowHeightsDelta>0||(this.getBinding("rows")&&this._iBindingLength>this.getVisibleRowCount())){return true;}}return false;};B.prototype._updateBindingContexts=function(b,i,a){var j=this.getRows(),l=this.getBinding("rows"),H=this.mBindingInfos["rows"],J;if(l){J=this._getRowContexts(i,false,a);}if(!b){var K=this.getFirstVisibleRow();var L=typeof this._updateTableCell==="function";this._resetRowHeights();for(var O=j.length-1;O>=0;O--){var Q=J?J[O]:undefined;var U=j[O];if(U){var W=K+O;this._updateRowBindingContext(U,Q,H&&H.model,W,L,l);}}}};B.prototype._updateRowBindingContext=function(a,b,j,H,J,K){a.setRowBindingContext(b,j,K);if(J){var L=a.getCells();for(var i=0,l=L.length;i<l;i++){if(L[i]){this._updateTableCell(L[i],b,L[i].$().closest("td"),H);}}}};B.prototype._updateNoData=function(){if(!this.getDomRef()){return;}var a=document.activeElement;this.$().toggleClass("sapUiTableEmpty",T.isNoDataVisible(this));this._getAccExtension().updateAriaStateForOverlayAndNoData();this._getKeyboardExtension().updateNoDataAndOverlayFocus(a);};B.prototype._determineVisibleCols=function(a){var b=[];this.getColumns().forEach(function(j,i){if(j.shouldRender()){b.push(i);}});};B.prototype.removeColumn=function(a,b){var i=this.removeAggregation('columns',a,b);if(typeof a==="number"&&a>-1){a=this.getColumns()[a];}var j=q.inArray(a,this._aSortedColumns);if(this._iNewColPos===undefined&&j>=0){this._aSortedColumns.splice(j,1);}this._resetRowTemplate();return i;};B.prototype.removeAllColumns=function(){var a=this.removeAllAggregation('columns');this._aSortedColumns=[];this._resetRowTemplate();return a;};B.prototype.destroyColumns=function(){var a=this.destroyAggregation('columns');this._aSortedColumns=[];this._resetRowTemplate();return a;};B.prototype.addColumn=function(a,b){this.addAggregation('columns',a,b);this._resetRowTemplate();return this;};B.prototype.insertColumn=function(a,i,b){this.insertAggregation('columns',a,i,b);this._resetRowTemplate();return this;};B.prototype._getRowCount=function(){return this._iBindingLength;};B.prototype._getSelectableRowCount=function(){return this._iBindingLength;};B.prototype._getFirstVisibleRowByScrollTop=function(i){if(T.isVariableRowHeightEnabled(this)&&this._getRowCount()<this.getVisibleRowCount()){return 0;}else{var a=Math.floor(i/this._getScrollingPixelsForRow());return Math.min(this._getMaxRowIndex(),a);}return 0;};B.prototype._getScrollingPixelsForRow=function(){return this._getVirtualScrollRange()/Math.max(1,this._getMaxRowIndex());};B.prototype._getVSbHeight=function(){return this._getScrollableRowCount()*this._getDefaultRowHeight();};B.prototype._getScrollableRowCount=function(){return Math.max(1,this.getVisibleRowCount()-this.getFixedRowCount()-this.getFixedBottomRowCount());};B.prototype._getRowHeightsDelta=function(i){var j=this._getDefaultRowHeight()*this.getVisibleRowCount();if(this.getVisibleRowCount()>=this._getRowCount()){i=i.slice(0,this._getRowCount());}var l=i.reduce(function(a,b){return a+b;},0)-j;if(l>0){l=Math.ceil(l);}return Math.max(0,l);};B.prototype._getTotalScrollRange=function(){var i=Math.max(this._getRowCount(),this.getVisibleRowCount()+1);var a=this._getDefaultRowHeight()*i;return Math.min(this._iMaxScrollbarHeight,a);};B.prototype._getVirtualScrollRange=function(){var i=this._getTotalScrollRange()-this._getVSbHeight();if(T.isVariableRowHeightEnabled(this)){i=i-this._iRowHeightsDelta;}return Math.max(1,i);};B.prototype._getRowCorrectionScrollRange=function(){var i=this._getTotalScrollRange()-this._getVSbHeight();if(this._getRowCount()>this.getVisibleRowCount()){i-=this._getVirtualScrollRange();}return Math.max(1,i);};B.prototype._getMaxRowIndex=function(){if(T.isVariableRowHeightEnabled(this)){if(this.getVisibleRowCount()>this._getRowCount()){return this._getRowCount();}else{return Math.max(0,this._getRowCount()-this.getVisibleRowCount()-1);}}else{return Math.max(0,this._getRowCount()-this.getVisibleRowCount());}};B.prototype._getVisibleColumns=function(){var a=[];var b=this.getColumns();for(var i=0,l=b.length;i<l;i++){if(b[i].shouldRender()){a.push(b[i]);}}return a;};B.prototype._getColumnsWidth=function(a,b){var j=this.getColumns();var H=0;if(a!==0&&!a){a=0;}if(b!==0&&!b){b=j.length;}for(var i=a,l=b;i<l;i++){if(j[i]&&j[i].shouldRender()){H+=this._CSSSizeToPixel(j[i].getWidth());}}return H;};B.prototype._CSSSizeToPixel=function(a,b){var i=this._iColMinWidth;if(a){if(q.sap.endsWith(a,"px")){i=parseInt(a,10);}else if(q.sap.endsWith(a,"em")||q.sap.endsWith(a,"rem")){i=Math.ceil(parseFloat(a)*this._getBaseFontSize());}}if(b){return i+"px";}else{return parseInt(i,10);}};B.prototype._getBaseFontSize=function(){return this._iBaseFontSize;};B.prototype._onTableResize=function(){if(this._bInvalid||!this.getDomRef()){return;}this._updateTableSizes();};B.prototype._handleRowCountModeAuto=function(i){var b=this.getBinding("rows");if(b&&this.getRows().length>0){return this._executeAdjustRows(i);}else{var a=this;var j=!this._mTimeouts.handleRowCountModeAutoAdjustRows;var l=a.getBusyIndicatorDelay();var H=this.getEnableBusyIndicator();if(b&&H){a.setBusyIndicatorDelay(0);a.setBusy(true);}if(i){this._setRowContentHeight(i);}this._mTimeouts.handleRowCountModeAutoAdjustRows=this._mTimeouts.handleRowCountModeAutoAdjustRows||window.setTimeout(function(){if(!a._executeAdjustRows()){a._updateTableSizes(false,true);}a._mTimeouts.handleRowCountModeAutoAdjustRows=undefined;if(H){a.setBusy(false);a.setBusyIndicatorDelay(l);}},0);return j;}};B.prototype._executeAdjustRows=function(i){i=i||this._determineAvailableSpace();var a=this._calculateRowsToDisplay(i);if(a==this._determineMinAutoRowCount()){this.$().height("auto");}else{this.$().height("0px");}return this._adjustRows(a);};B.prototype._syncColumnHeaders=function(a){var b=this.getDomRef();if(!b){return;}var $=this.$();var H=a.headerWidths;var J=this.getFixedColumnCount();var K=this._getVisibleColumns();if(K.length==0){return;}var L=$.find(".sapUiTableColHdr");var O=$.find(".sapUiTableColHdrScr");var Q=L.find(".sapUiTableCol");var U=$.find(".sapUiTableCtrlFirstCol > th:not(.sapUiTableColSel)");this._aTableHeaders=U;var W={};U.each(function(l,b1){var c1=b1.getAttribute("data-sap-ui-headcolindex");var d1=H[l];var e1;var f1=K[l];if(f1){e1=d1;}if(l==0||l==J){e1+=Math.max(0,a.invisibleColWidth);}var g1=K[l]?K[l].getHeaderSpan():1,h1=[],i1;if(g1){if(!q.isArray(g1)){g1=[g1];}q.each(g1,function(k1,l1){g1[k1]=Math.max(l1,1);});i1=g1;}else{i1=[1];}for(var i=0;i<i1.length;i++){h1[i]={width:e1,span:1};for(var j=1;j<i1[i];j++){var j1=U[l+j];if(j1){h1[i].width+=H[l+j];h1[i].span=i1[i];}}}if(f1){W[c1]={domRefColumnTh:b1,domRefColumnDivs:[],aHeaderData:h1};}});var X=this;Q.each(function(i,j){var l=parseInt(j.getAttribute("data-sap-ui-colindex"),10);var b1=W[l];if(b1){b1.domRefColumnDivs.push(j);}else{q.sap.log.error("Inconsistent DOM / Control Tree combination",X);}});q.each(W,function(j,l){for(var i=0;i<l.domRefColumnDivs.length;i++){var b1=l.aHeaderData[0];if(l.aHeaderData[i]){b1=l.aHeaderData[i];}if(l.domRefColumnDivs[i]){l.domRefColumnDivs[i].style.width=b1.width+"px";l.domRefColumnDivs[i].setAttribute("data-sap-ui-colspan",b1.span);}else{q.sap.log.error("Inconsistent DOM / Control Tree combination",X);}}});O.each(function(i,j){j.style.width=a.tableCtrlScrWidth+"px";});var Y;var Z=[];function _(i,j){var l=[].slice.call(j.getElementsByClassName("sapUiTableCol"));Z[i]=(Z[i]||[]).concat(l);}function a1(j,b1){var c1=0,d1,e1=false,l=b1.length,i;for(i=0;i<l;i++){b1[i].style.height=null;}for(i=0;i<l;i++){d1=b1[i].offsetHeight;if(c1>0&&d1>0&&d1!=c1){e1=true;}c1=Math.max(d1,c1);}if(e1){for(i=0;i<l;i++){b1[i].style.height=c1+"px";}}return j+c1;}if(!(this.getColumnHeaderHeight()>0)){$.find(".sapUiTableColHdrFixed").find(".sapUiTableColHdr").each(_);$.find(".sapUiTableColHdrScr").find(".sapUiTableColHdr").each(_);Y=Z.reduce(a1,0);$.find(".sapUiTableColHdrCnt").height(Y);}};B.prototype._disableTextSelection=function(a){q(a||document.body).attr("unselectable","on").css({"-moz-user-select":"none","-webkit-user-select":"none","user-select":"none"}).bind("selectstart",function(b){b.preventDefault();return false;});};B.prototype._enableTextSelection=function(a){q(a||document.body).attr("unselectable","off").css({"-moz-user-select":"","-webkit-user-select":"","user-select":""}).unbind("selectstart");};B.prototype._clearTextSelection=function(){if(window.getSelection){if(window.getSelection().empty){window.getSelection().empty();}else if(window.getSelection().removeAllRanges){window.getSelection().removeAllRanges();}}else if(document.selection&&document.selection.empty){try{document.selection.empty();}catch(a){}}};B.prototype.onvscroll=function(a){var b=this;q.sap.interaction.notifyScrollEvent&&q.sap.interaction.notifyScrollEvent(a);if(this._bIsScrolledByKeyboard){return;}this._getKeyboardExtension().setActionMode(false);function i(j){var l=j.getDomRef(y.VerticalScrollBar);if(!l){return;}var H=l.scrollTop;if(T.isVariableRowHeightEnabled(j)){j._iScrollTop=H;j._adjustTablePosition(H,j._collectRowHeights());}j.setFirstVisibleRow(j._getFirstVisibleRowByScrollTop(H),true);}if(this._bLargeDataScrolling&&!this._bIsScrolledByWheel){window.clearTimeout(this._mTimeouts.scrollUpdateTimerId);this._mTimeouts.scrollUpdateTimerId=window.setTimeout(function(){i(b);b._mTimeouts._sScrollUpdateTimerId=null;},300);}else{i(this);}this._bIsScrolledByWheel=false;};B.prototype.onpscroll=function(a){q.sap.interaction.notifyScrollEvent&&q.sap.interaction.notifyScrollEvent(a);this._getKeyboardExtension().setActionMode(false);var i=0;if(this.getNavigationMode()===N.Paginator){i=(((this._oPaginator.getCurrentPage()||1)-1)*this.getVisibleRowCount());}this.setFirstVisibleRow(i,true);};B.prototype._onMouseWheel=function(a){var O=a.originalEvent;var i=O.shiftKey;var b=0;if(D.browser.firefox){b=O.detail;}else{if(i){b=O.deltaX;}else{b=O.deltaY;}}if(i){var H=this.getDomRef(y.HorizontalScrollBar);if(H){H.scrollLeft=H.scrollLeft+b;}}else{var j=this.getDomRef(y.VerticalScrollBar);if(j){this._bIsScrolledByWheel=true;this._bIsScrolledByKeyboard=false;j.scrollTop=j.scrollTop+b;}}a.preventDefault();a.stopPropagation();};B.prototype.onVerticalScrollbarMouseDown=function(a){this._bIsScrolledByWheel=false;this._bIsScrolledByKeyboard=false;};B.prototype._syncHeaderAndContent=function(a){if(!this._bSyncScrollLeft){this._bSyncScrollLeft=true;var $=this.$();var H=a.tableHSbScrollLeft;$.find(".sapUiTableColHdrScr").scrollLeft(H);$.find(".sapUiTableCtrlScr").scrollLeft(H);this._bSyncScrollLeft=false;}};B.prototype.onhscroll=function(a){q.sap.interaction.notifyScrollEvent&&q.sap.interaction.notifyScrollEvent(a);if(!this._bOnAfterRendering){if(this._mTimeouts.hScrollUpdateTimer){window.clearTimeout(this._mTimeouts.hScrollUpdateTimer);}this._mTimeouts.hScrollUpdateTimer=window.setTimeout(function(){this._iScrollLeft=this.getDomRef(y.HorizontalScrollBar).scrollLeft;var b=this._collectTableSizes();this._syncHeaderAndContent(b);this._determineVisibleCols(b);}.bind(this),50);}};B.prototype._oncolscroll=function(){if(!this._bSyncScrollLeft){var H=this.getDomRef(y.HorizontalScrollBar);if(H){var a=this.getDomRef().querySelector(".sapUiTableColHdrScr");var i=0;if(a){i=a.scrollLeft;}H.scrollLeft=i;}}};B.prototype._oncntscroll=function(){if(!this._bSyncScrollLeft){var H=this.getDomRef(y.HorizontalScrollBar);if(H){var a=this.getDomRef().querySelector(".sapUiTableCtrlScr");H.scrollLeft=a.scrollLeft;}}};B.prototype.oncontextmenu=function(a){var $=q(a.target);var H=$.closest('.sapUiTableCol');if(H.length>0){var b=sap.ui.getCore().byId(H.attr("data-sap-ui-colid"));if(b){b._openMenu(H[0],false);}a.preventDefault();}else{if(this._findAndfireCellEvent(this.fireCellContextmenu,a,this._oncellcontextmenu)){a.preventDefault();}}};B.prototype._oncellcontextmenu=function(a){if(this.getEnableCellFilter()){if(!this._oContextMenu){if(!M){M=sap.ui.requireSync("sap/ui/unified/Menu");A=sap.ui.requireSync("sap/ui/unified/MenuItem");}this._oContextMenu=new M(this.getId()+"-contextmenu");this.addDependent(this._oContextMenu);}var b=sap.ui.getCore().byId(a.columnId);var i=b.getFilterProperty();if(b&&b.isFilterableByMenu()&&a.rowBindingContext){this._oContextMenu.destroyItems();this._oContextMenu.addItem(new A({text:this._oResBundle.getText("TBL_FILTER"),select:[function(){var l=this.getContextByIndex(a.rowIndex);var H=l.getProperty(i);if(this.getEnableCustomFilter()){this.fireCustomFilter({column:b,value:H});}else{this.filter(b,H);}},this]}));var j=P.Dock;this._oContextMenu.open(false,a.cellDomRef,j.BeginTop,j.BeginBottom,a.cellDomRef,"none none");return true;}}};B.prototype._findAndfireCellEvent=function(a,b,i){var $=q(b.target);var j=$.closest("td.sapUiTableTd");var l=j.attr("id");var H=/.*-row(\d*)-col(\d*)/i.exec(l);var J=false;if(H){var K=H[1];var L=H[2];var O=this.getRows()[K];var Q=O&&O.getCells()[L];var U=O&&O.getIndex();var W=Q.data("sap-ui-colid");var X;if(this.getBindingInfo("rows")){X=O.getBindingContext(this.getBindingInfo("rows").model);}var Y={rowIndex:U,columnIndex:L,columnId:W,cellControl:Q,rowBindingContext:X,cellDomRef:j.get(0)};J=!a.call(this,Y);if(!J&&typeof i==="function"){Y.cellDomRef=j[0];J=i.call(this,Y);}}return J;};B.prototype.getFocusDomRef=function(){this._getKeyboardExtension().initItemNavigation();return T.getFocusedItemInfo(this).domRef||C.prototype.getFocusDomRef.apply(this,arguments);};B.prototype.onfocusin=function(a){var $;var b=q(a.target);if(b.parent('.sapUiTableTr').length>0){$=q(this.getDomRef("sapUiTableCtrlScr"));}else if(b.parent('.sapUiTableColHdr').length>0){$=q(this.getDomRef("sapUiTableColHdrScr"));}if((D.browser.firefox||D.browser.chrome)&&$&&$.length>0){var i=$.scrollLeft();var j=$.width();var l=b.position().left;var H=l+b.width();var O=l-i;var J=H-j-i;var K=this.getDomRef(y.HorizontalScrollBar);if(J>0){K.scrollLeft=K.scrollLeft+J+2;}else if(O<0){K.scrollLeft=K.scrollLeft+O-1;}}};B.prototype._onSelect=function(a){var $=q(a.target);var b=a.shiftKey;var i=!!(a.metaKey||a.ctrlKey);var j=$.closest(".sapUiTableCol");if(this._bShowMenu&&j.length===1){var l=parseInt(j.attr("data-sap-ui-colindex"),10);var H=this.getColumns()[l];if($.hasClass("sapUiTableColDropDown")){var J=this.fireColumnSelect({column:H});if(J){H._openMenu(j[0],a.type=="keyup");}}else{this._onColumnSelect(H,j[0],this._isTouchMode(a),a.type=="keyup");}return;}var K=$.closest(".sapUiTableRowHdr");if(K.length===1){var l=parseInt(K.attr("data-sap-ui-rowindex"),10);this._onRowSelect(this.getRows()[l].getIndex(),b,i);return;}var L,O;if(a.target){O=q(a.target).closest(".sapUiTableCtrl > tbody > tr > td");if(O.length>0){L=O[0];}}if(L&&(O.hasClass("sapUiTableTd")||O.hasClass("sapUiTableTDDummy"))&&T.isRowSelectionAllowed(this)){var K=$.closest(".sapUiTableCtrl > tbody > tr");if(K.length===1){var l=parseInt(K.attr("data-sap-ui-rowindex"),10);this._onRowSelect(this.getRows()[l].getIndex(),b,i);return;}}if(q.sap.containsOrEquals(this.getDomRef("selall"),a.target)){this._toggleSelectAll();return;}};B.prototype._isRowSelectable=function(i){return true;};B.prototype._onRowSelect=function(i,b,a){if(!!D.browser.internet_explorer&&b){this._clearTextSelection();}var j=this.getBinding("rows");if(!j){return;}if(i<0||i>=(j.getLength()||0)){return;}if(!this._isRowSelectable(i)){return;}this._iSourceRowIndex=i;var l=this.getSelectionMode();if(l!==w.None){if(l===w.Single){if(!this.isIndexSelected(i)){this.setSelectedIndex(i);}else{this.clearSelection();}}else{if(l===w.MultiToggle){a=true;}if(b){var H=this.getSelectedIndex();if(H>=0){this.addSelectionInterval(H,i);}else{this.setSelectedIndex(i);}}else{if(!this.isIndexSelected(i)){if(a){this.addSelectionInterval(i,i);}else{this.setSelectedIndex(i);}}else{if(a){this.removeSelectionInterval(i,i);}else{if(this._getSelectedIndicesCount()===1){this.clearSelection();}else{this.setSelectedIndex(i);}}}}}}this._iSourceRowIndex=undefined;};B.prototype._onColumnSelect=function(a,b,i,W){if(i&&(a.getResizable()||a._menuHasItems())){var $=q(b);var j=$.find(".sapUiTableColCell");if($.find(".sapUiTableColCellMenu").length<1){j.hide();var l="";if(a._menuHasItems()){l="<div class='sapUiTableColDropDown'></div>";}var H="";if(a.getResizable()){H="<div class='sapUiTableColResizer''></div>";}var J=q("<div class='sapUiTableColCellMenu'>"+l+H+"</div>");$.append(J);$.bind("focusout",function(){this.cell.show();this.menu.remove();this.self.unbind("focusout");}.bind({cell:j,menu:J,self:$}));}return;}var K=this.fireColumnSelect({column:a});if(K){a._openMenu(b,W);}};B.prototype.ontouchstart=function(a){if(this._isTouchMode(a)){this._aTouchStartPosition=null;this._bIsScrollVertical=null;var $=this._getScrollTargets();var b=q(a.target).closest($).length>0;if(b){var i=a.targetTouches[0];this._aTouchStartPosition=[i.pageX,i.pageY];var j=this.getDomRef(y.VerticalScrollBar);if(j){this._iTouchScrollTop=j.scrollTop;}var H=this.getDomRef(y.HorizontalScrollBar);if(H){this._iTouchScrollLeft=H.scrollLeft;}}}};B.prototype.ontouchmove=function(a){if(this._isTouchMode(a)&&this._aTouchStartPosition){var b=a.targetTouches[0];var i=(b.pageX-this._aTouchStartPosition[0]);var j=(b.pageY-this._aTouchStartPosition[1]);if(this._bIsScrollVertical==null){this._bIsScrollVertical=Math.abs(j)>Math.abs(i);}if(this._bIsScrollVertical){var l=this.getDomRef(y.VerticalScrollBar);if(l){var H=this._iTouchScrollTop-j;if(H>0&&H<(this.getDomRef("vsb-content").clientHeight-l.clientHeight)-1){a.preventDefault();a.stopPropagation();}l.scrollTop=H;}}else{var J=this.getDomRef(y.HorizontalScrollBar);if(J){var K=this._iTouchScrollLeft-i;if(K>0&&K<(this.getDomRef("hsb-content").clientWidth-J.clientWidth)-1){a.preventDefault();a.stopPropagation();}J.scrollLeft=K;}}}};B.prototype._resizeDependentColumns=function(a,W){var b=this;if(this._checkPercentageColumnWidth()){var j=this._getVisibleColumns();var l;q.each(j,function(d1,e1){if(a===e1){l=d1;}});var O=0;var L=j.length-1;var H;if(l===undefined){H=0;}else{H=parseInt(W,10);}var J=0;var K=[];q.each(j,function(d1,e1){var f1=b._getColumnPercentageWidth(e1);if((((l===L&&d1<l)||((l!==L)&&d1>l))&&e1.getFlexible())||l===undefined){O+=e1.$().outerWidth();J+=f1;K.push(e1);}else if(d1!==l){H+=f1;}});var Q=H;q.each(K,function(d1,e1){var f1=b._getColumnPercentageWidth(e1);var c1=Math.round((100-Q)/J*f1);if(d1===K.length-1){c1=100-H;}else{H+=c1;}if(!isFinite(c1)||c1<=0){c1=1;}b._updateColumnWidth(e1,c1+"%");});}else if(!this._hasOnlyFixColumnWidths()){var j=this._getVisibleColumns(),U=this.$().find(".sapUiTableCtrlScr").width(),l,X=0,Y=0,Z=0,$=this.getFixedColumnCount(),_=0;if(a.getIndex()<$){return;}q.each(j,function(d1,e1){if(d1<$){return;}if(!q.sap.endsWith(e1.getWidth(),"px")&&!q.sap.endsWith(e1.getWidth(),"em")&&!q.sap.endsWith(e1.getWidth(),"rem")){_++;return false;}if(l!=undefined){Z+=b._CSSSizeToPixel(e1.getWidth());X++;}else if(a!==e1){Y+=b._CSSSizeToPixel(e1.getWidth());}if(a===e1){l=d1;Y+=b._CSSSizeToPixel(W);}});if(_>0||(Y+Z>U)){return;}U-=Y;for(var i=l+1;i<j.length;i++){var a=j[i],a1=this._CSSSizeToPixel(a.getWidth()),b1=a1/Z*100,c1=U/100*b1;this._updateColumnWidth(a,Math.round(c1)+'px');}}};B.prototype._getColumnPercentageWidth=function(a){var b=a.getWidth();var i=parseInt(a.getWidth(),10);var j=this.$().find(".sapUiTableCtrl").width();if(q.sap.endsWith(b,"px")||q.sap.endsWith(b,"em")||q.sap.endsWith(b,"rem")){i=Math.round(100/j*i);}else if(!q.sap.endsWith(b,"%")){i=Math.round(100/j*a.$().width());}return i;};B.prototype._updateColumnWidth=function(a,W,b){var i=true;if(b){i=this.fireColumnResize({column:a,width:W});}if(i){a.setProperty("width",W,true);this.$().find('th[data-sap-ui-colid="'+a.getId()+'"]').css('width',W);}return i;};B.prototype._checkPercentageColumnWidth=function(){var a=this.getColumns();var H=false;q.each(a,function(i,b){if(q.sap.endsWith(b.getWidth(),"%")){H=true;return false;}});return H;};B.prototype._hasOnlyFixColumnWidths=function(){var O=true;q.each(this.getColumns(),function(i,a){var W=a.getWidth();if(a.getFlexible()||!W||W.substr(-2)!=="px"){O=false;return false;}});return O;};B.prototype.pushSortedColumn=function(a,b){if(!b){this._aSortedColumns=[];}this._aSortedColumns.push(a);};B.prototype.getSortedColumns=function(){return this._aSortedColumns;};B.prototype.sort=function(a,b,i){if(q.inArray(a,this.getColumns())>=0){a.sort(b===z.Descending,i);}};B.prototype.filter=function(a,b){if(q.inArray(a,this.getColumns())>=0){a.filter(b);}};B.prototype._updateSelection=function(){var a=this.getSelectionMode();if(a===w.None){return;}var b=this._getAccExtension().getAriaTextsForSelectionMode(true);var j=T.isRowSelectionAllowed(this);var l=this.getRows();for(var i=0;i<l.length;i++){var H=l[i];H._updateSelection(this,b,j);}this.setProperty("selectedIndex",this.getSelectedIndex(),true);var $=this.$("selall");if((a==w.Multi||a==w.MultiToggle)&&this.getEnableSelectAll()&&!$.hasClass("sapUiTableSelAll")){var J=this._getSelectedIndicesCount();var K=J==0;if(!K){var L=this._getSelectableRowCount();K=L==0||L!==J;}if(K){$.addClass("sapUiTableSelAll");}}};B.prototype._onSelectionChanged=function(a){var b=a.getParameter("rowIndices");var i=a.getParameter("selectAll");var j=this._iSourceRowIndex!==undefined?this._iSourceRowIndex:this.getSelectedIndex();this._updateSelection();this.fireRowSelectionChange({rowIndex:j,rowContext:this.getContextByIndex(j),rowIndices:b,selectAll:i,userInteraction:this._iSourceRowIndex!==undefined});};B.prototype.getContextByIndex=function(i){var b=this.getBinding("rows");return i>=0&&b?b.getContexts(i,1)[0]:null;};B.prototype.getSelectedIndex=function(){return this._oSelection.getLeadSelectedIndex();};B.prototype.setSelectedIndex=function(i){if(i===-1){this.clearSelection();}else{this._oSelection.setSelectionInterval(i,i);}return this;};B.prototype.clearSelection=function(){this._oSelection.clearSelection();return this;};B.prototype.selectAll=function(){var a=this.getSelectionMode();if(!this.getEnableSelectAll()||(a!="Multi"&&a!="MultiToggle")){return this;}var b=this.getBinding("rows");if(b){this.$("selall").attr('title',this._oResBundle.getText("TBL_DESELECT_ALL")).removeClass("sapUiTableSelAll");this._oSelection.selectAll((b.getLength()||0)-1);}return this;};B.prototype.getSelectedIndices=function(){return this._oSelection.getSelectedIndices();};B.prototype.addSelectionInterval=function(i,a){if(this.getSelectionMode()===p.SelectionMode.None){return this;}this._oSelection.addSelectionInterval(i,a);return this;};B.prototype.setSelectionInterval=function(i,a){if(this.getSelectionMode()===p.SelectionMode.None){return this;}this._oSelection.setSelectionInterval(i,a);return this;};B.prototype.removeSelectionInterval=function(i,a){this._oSelection.removeSelectionInterval(i,a);return this;};B.prototype.isIndexSelected=function(i){return this._oSelection.isSelectedIndex(i);};B.prototype.setGroupBy=function(a){var b=a;if(typeof b==="string"){b=sap.ui.getCore().byId(b);}var i=false;if(b&&b instanceof n){if(q.inArray(b,this.getColumns())===-1){throw new Error("Column has to be part of the columns aggregation!");}var j=this.fireGroup({column:b,groupedColumns:[b.getId()],type:G.group});var O=sap.ui.getCore().byId(this.getGroupBy());if(O){O.setGrouped(false);i=true;}if(j&&b instanceof n){b.setGrouped(true);}}if(!b||i){var l=this.getBindingInfo("rows");delete l.binding;this._bindAggregation("rows",l);}return this.setAssociation("groupBy",b);};B.prototype.getBinding=function(a){T.Grouping.setupExperimentalGrouping(this);return E.prototype.getBinding.call(this,[a||"rows"]);};B.prototype.setEnableGrouping=function(b){this.setProperty("enableGrouping",b);if(!b){T.Grouping.resetExperimentalGrouping(this);}this._invalidateColumnMenus();return this;};B.prototype.setEnableCustomFilter=function(b){this.setProperty("enableCustomFilter",b);this._invalidateColumnMenus();return this;};B.prototype.setEnableColumnFreeze=function(b){this.setProperty("enableColumnFreeze",b);this._invalidateColumnMenus();return this;};B.prototype.setShowColumnVisibilityMenu=function(b){this.setProperty("showColumnVisibilityMenu",b);this._invalidateColumnMenus();return this;};B.prototype.getFixedColumnCount=function(){if(this._bIgnoreFixedColumnCount){return 0;}else{return this.getProperty("fixedColumnCount");}};B.prototype.setFixedColumnCount=function(a,b){var j=this._getVisibleColumns();var H=j[a-1]&&j[a-1].getHeaderSpan();if(H){var l;if(q.isArray(H)){l=parseInt(H[0],10);}else{l=parseInt(H,10);}a+=l-1;}var $=this.$().find(".sapUiTableCtrlFirstCol > th");for(var i=0;i<a;i++){var J=j[i];if(J){var K=q.inArray(J,this.getColumns());if(!J.getWidth()){J.setWidth($.filter("[data-sap-ui-headcolindex='"+K+"']").width()+"px");}}}this.setProperty("fixedColumnCount",a,b);this._collectTableSizes();this._invalidateColumnMenus();return this;};B.prototype.setFixedRowCount=function(i){if(!(parseInt(i,10)>=0)){q.sap.log.error("Number of fixed rows must be greater or equal 0",this);return this;}if((i+this.getFixedBottomRowCount())<this.getVisibleRowCount()){this.setProperty("fixedRowCount",i);this._updateBindingContexts();}else{q.sap.log.error("Table '"+this.getId()+"' fixed rows('"+(i+this.getFixedBottomRowCount())+"') must be smaller than numberOfVisibleRows('"+this.getVisibleRowCount()+"')",this);}return this;};B.prototype.setFixedBottomRowCount=function(i){if(!(parseInt(i,10)>=0)){q.sap.log.error("Number of fixed bottom rows must be greater or equal 0",this);return this;}if((i+this.getFixedRowCount())<this.getVisibleRowCount()){this.setProperty("fixedBottomRowCount",i);this._updateBindingContexts();}else{q.sap.log.error("Table '"+this.getId()+"' fixed rows('"+(i+this.getFixedRowCount())+"') must be smaller than numberOfVisibleRows('"+this.getVisibleRowCount()+"')",this);}return this;};B.prototype.setThreshold=function(i){this.setProperty("threshold",i,true);};B.prototype._invalidateColumnMenus=function(){var a=this.getColumns();for(var i=0,l=a.length;i<l;i++){a[i].invalidateMenu();}};B.prototype._isTouchMode=function(a){return!!a.originalEvent["touches"];};B.prototype._determineParent=function(){var a=this.getParent();if(a){var b;if(a.getDomRef){b=a.getDomRef();}else if(a.getRootNode){b=a.getRootNode();}if(b){return q(b);}}return q();};B.prototype._getRowTemplate=function(){if(!this._oRowTemplate){this._oRowTemplate=new o(this.getId()+"-rows");var a=this.getColumns();for(var i=0,l=a.length;i<l;i++){if(a[i].getVisible()){var b=a[i].getTemplate();if(b){var j=b.clone("col"+i);j.data("sap-ui-colindex",i);j.data("sap-ui-colid",a[i].getId());this._oRowTemplate.addCell(j);}}}}return this._oRowTemplate;};B.prototype._getDummyRow=function(){if(!this._oDummyRow){this._oDummyRow=this._getRowTemplate().clone("dummy");this._oDummyRow._bDummyRow=true;this._oDummyRow._bHidden=true;}return this._oDummyRow;};B.prototype._resetRowTemplate=function(){if(this._oRowTemplate){this._oRowTemplate.destroy();this._oRowTemplate=undefined;}if(this._oDummyRow){this._oDummyRow.destroy();this._oDummyRow=undefined;}};B.prototype._adjustRows=function(a,b){if(isNaN(a)){return false;}if(T.isVariableRowHeightEnabled(this)){a=a+1;}var i;var j=this.getRows();if(!this._oRowTemplate&&j.length>0){this.destroyAggregation("rows",true);j=[];}if(a==j.length){return false;}for(i=j.length-1;i>=a;i--){this.removeAggregation("rows",i,true).destroy();}if(T.isVariableRowHeightEnabled(this)){this.setProperty("visibleRowCount",a-1,true);}else{this.setProperty("visibleRowCount",a,true);}this._ignoreInvalidateOfChildControls=true;var l;var H=this.getFirstVisibleRow();var J=0;var K=false;var L;var O=this.getBinding("rows");if(!b){L=this.getBindingInfo("rows");K=typeof this._updateTableCell==="function";l=this._getRowContexts(a);for(i=0;i<j.length;i++){J=H+i;this._updateRowBindingContext(j[i],l[i],L&&L.model,J,K,O);}}if(j.length<a){var Q=this._getRowTemplate();for(i=j.length;i<a;i++){var U=Q.clone("row"+i);if(!b){J=H+i;this._updateRowBindingContext(U,l[i],L&&L.model,J,K,O);}this.addAggregation("rows",U,true);}}this._ignoreInvalidateOfChildControls=false;j=this.getRows();b=b||l.length==0;return this._insertTableRows(j,b);};B.prototype._insertTableRows=function(a,b){var j=false;if(!this._bInvalid){this._detachEvents();var H=this.getDomRef("tableCCnt");a=a||this.getRows();if(!a.length||!H){return;}if(this.getVisibleRowCountMode()==V.Auto){var J=this.getDomRef();if(J){J.style.height="0px";}}var K=q.Event("BeforeRendering");K.setMarked("insertTableRows");K.srcControl=this;this._handleEvent(K);var L=new sap.ui.getCore().createRenderManager(),O=this.getRenderer();O.renderTableCCnt(L,this);L.flush(H,false,false);L.destroy();K=q.Event("AfterRendering");K.setMarked("insertTableRows");K.srcControl=this;this._handleEvent(K);this._initRowDomRefs();this._getKeyboardExtension().invalidateItemNavigation();var Q=this.getColumns();for(var i=0,l=Q.length;i<l;i++){if(Q[i].getVisible()){Q[i]._restoreIcons();}}this._updateTableContent();this._updateTableSizes();j=true;this._attachEvents();}if(!b&&!this._bInvalid&&this.getBinding("rows")){var U=this;if(this._mTimeouts._rowsUpdated){window.clearTimeout(this._mTimeouts._rowsUpdated);}this._mTimeouts._rowsUpdated=window.setTimeout(function(){U.fireEvent("_rowsUpdated");},0);}return j;};B.prototype._getDefaultRowHeight=function(){var a=T.getContentDensity(this);return this.getRowHeight()||T.CONTENT_DENSITY_ROW_HEIGHTS[a]+1;};B.prototype._setRowContentHeight=function(H){H=H||0;var a=this.getVisibleRowCountMode();var i=this.getVisibleRowCount();var b=this._getDefaultRowHeight();var j=this.getMinAutoRowCount();var l;if(a==V.Interactive||a==V.Fixed){if(this._iTableRowContentHeight&&a==V.Interactive){l=j*b;if(!H){H=this._iTableRowContentHeight;}}else{l=i*b;H=l;}}else if(a==V.Auto){l=j*b;}var J=Math.max(H,l);if((a==V.Fixed&&this.getRows().length==0)||a!=V.Fixed){this._iTableRowContentHeight=Math.floor(J/b)*b;}else{this._iTableRowContentHeight=undefined;}if(T.isVariableRowHeightEnabled(this)){q(this.getDomRef("tableCCnt")).css("height",b*this.getVisibleRowCount()+"px");}else{if((a==V.Fixed||a==V.Interactive)&&this.getRows().length>0){q(this.getDomRef("tableCtrlCnt")).css("height","auto");}else{q(this.getDomRef("tableCtrlCnt")).css("height",this._iTableRowContentHeight+"px");}}this._toggleVSb();};B.prototype._determineMinAutoRowCount=function(){var i=this.getVisibleRowCount();var a=this.getMinAutoRowCount();var b=a||i||5;if(this.getVisibleRowCountMode()==V.Interactive&&!this.bOutput){b=i||a||5;}return b;};B.prototype._calculateRowsToDisplay=function(i){i=i||this._iTableRowContentHeight;var a=this.getVisibleRowCountMode();var b=0;if(a==V.Fixed){b=this.getVisibleRowCount()||0;}else if(a==V.Interactive||a==V.Auto){var j=this._determineMinAutoRowCount();var l=this._getDefaultRowHeight();if(!l||!i){b=j;}else{var H=Math.min(i,50000);var J=Math.floor(H/l);b=Math.max((this.getFixedRowCount()+this.getFixedBottomRowCount()+1),Math.max(j,J));}}return Math.max(b,0);};B.prototype.setShowNoData=function(b){this.setProperty('showNoData',b,true);this._updateNoData();return this;};B.prototype.exportData=function(a){var b=sap.ui.requireSync("sap/ui/core/util/Export");a=a||{};if(!a.rows){var j=this.getBinding("rows"),H=this.getBindingInfo("rows");var J=j.aFilters.concat(j.aApplicationFilters);a.rows={path:H.path,model:H.model,sorter:j.aSorters,filters:J,parameters:H.parameters};}if(!a.exportType){var K=sap.ui.requireSync("sap/ui/core/util/ExportTypeCSV");a.exportType=new K();}var L=a.rows.model;if(!L){var O=a.rows.path;var Q=O.indexOf(">");if(Q>0){L=O.substr(0,Q);}}if(!a.columns){a.columns=[];var U=this.getColumns();for(var i=0,l=U.length;i<l;i++){var W=U[i];if(W.getSortProperty()){a.columns.push({name:W.getLabel().getText(),template:{content:{path:W.getSortProperty(),model:L}}});}}}var X=new b(a);this.addDependent(X);return X;};B.prototype._onPersoApplied=function(){var a=this.getColumns();var b=[];for(var i=0,l=a.length;i<l;i++){var j=a[i];if(j.getSorted()){b.push(new m(j.getSortProperty(),j.getSortOrder()===z.Descending));}}var H=this.getBinding("rows");if(H){if(b.length>0){H.sort(b);}this.refreshRows();}};B.prototype._toggleSelectAll=function(){if(!this.$("selall").hasClass("sapUiTableSelAll")){this._iSourceRowIndex=-1;this.clearSelection();}else{this._iSourceRowIndex=0;this.selectAll();}if(!!D.browser.internet_explorer){this.$("selall").focus();}this._iSourceRowIndex=undefined;};B.prototype._restoreAppDefaultsColumnHeaderSortFilter=function(){var a=this.getColumns();q.each(a,function(i,b){b._restoreAppDefaults();});};B.prototype._setBusy=function(a){var b,i,j;if(!this.getEnableBusyIndicator()||!this._bBusyIndicatorAllowed){return;}b=this.getBinding("rows");if(!b){return;}this.setBusy(false);if(a&&this._iDataRequestedCounter>0){var l=a.reason;if(a.contexts&&a.contexts.length!==undefined){j=false;for(i=0;i<a.contexts.length;i++){if(a.contexts[i]===undefined){j=true;break;}}}else if(a.changeReason===g.Expand){this.setBusy(true);}var L=b.getLength();if((l==g.Expand&&this._iDataRequestedCounter!==0)||j||(b.isInitial())||(a.receivedLength===0&&this._iDataRequestedCounter!==0)||(a.receivedLength<a.requestedLength&&a.receivedLength!==L&&a.receivedLength!==L-this.getFirstVisibleRow())){this.setBusy(true);}}};B.prototype.setBusy=function(b,a){var i=this.getBusy()!=b;a="sapUiTableCnt";var j=C.prototype.setBusy.call(this,b,a);if(i){this.fireBusyStateChanged({busy:b});}return j;};B.prototype.setEnableBusyIndicator=function(b){this.setProperty("enableBusyIndicator",b,true);};B.prototype._attachDataRequestedListeners=function(){var b=this.getBinding("rows");if(b){b.detachDataRequested(this._onBindingDataRequestedListener,this);b.detachDataReceived(this._onBindingDataReceivedListener,this);this._iDataRequestedCounter=0;b.attachDataRequested(this._onBindingDataRequestedListener,this);b.attachDataReceived(this._onBindingDataReceivedListener,this);}};B.prototype._onBindingDataRequestedListener=function(a){if(a.getSource()==this.getBinding("rows")&&!a.getParameter("__simulateAsyncAnalyticalBinding")){this._iDataRequestedCounter++;}};B.prototype._onBindingDataReceivedListener=function(a){if(a.getSource()==this.getBinding("rows")&&!a.getParameter("__simulateAsyncAnalyticalBinding")){this._iDataRequestedCounter--;}};B.prototype._attachBindingListener=function(){this._attachDataRequestedListeners();};B.prototype._setLargeDataScrolling=function(l){this._bLargeDataScrolling=!!l;};B.prototype._getSelectedIndicesCount=function(){return this.getSelectedIndices().length;};B.prototype._updateTableContent=function(){if(T.Grouping.isGroupMode(this)){var b=this.getBinding("rows"),a=this.getRows(),i=a.length;if(b){var j,l,H,J;for(var K=0;K<i;K++){j=a[K];H=K+this.getFirstVisibleRow();J=!!b.isGroupHeader(H);l=J?b.getTitle(H):"";T.Grouping.updateTableRowForGrouping(this,j,J,J?!!b.isExpanded(H):false,J,false,J?0:1,l);}}else{for(var K=0;K<i;K++){T.Grouping.cleanupTableRowForGrouping(this,a[K]);}}}};return B;});
