/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./FlexBoxStylingHelper','./FlexItemData','./FlexDirection','./FlexRendertype','./library','sap/ui/core/Control'],function(q,F,a,b,c,l,C){"use strict";var d=C.extend("sap.m.FlexBox",{metadata:{library:"sap.m",properties:{height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:''},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:''},displayInline:{type:"boolean",group:"Appearance",defaultValue:false},direction:{type:"sap.m.FlexDirection",group:"Appearance",defaultValue:sap.m.FlexDirection.Row},fitContainer:{type:"boolean",group:"Appearance",defaultValue:false},renderType:{type:"sap.m.FlexRendertype",group:"Misc",defaultValue:sap.m.FlexRendertype.Div},justifyContent:{type:"sap.m.FlexJustifyContent",group:"Appearance",defaultValue:sap.m.FlexJustifyContent.Start},alignItems:{type:"sap.m.FlexAlignItems",group:"Appearance",defaultValue:sap.m.FlexAlignItems.Stretch},wrap:{type:"sap.m.FlexWrap",group:"Appearance",defaultValue:sap.m.FlexWrap.NoWrap},alignContent:{type:"sap.m.FlexAlignContent",group:"Appearance",defaultValue:sap.m.FlexAlignContent.Stretch},backgroundDesign:{type:"sap.m.BackgroundDesign",group:"Appearance",defaultValue:sap.m.BackgroundDesign.Transparent}},defaultAggregation:"items",aggregations:{items:{type:"sap.ui.core.Control",multiple:true,singularName:"item"}}}});d.prototype.init=function(){if(this instanceof sap.m.HBox&&(this.getDirection()!==sap.m.FlexDirection.Row||this.getDirection()!==b.RowReverse)){this.setDirection('Row');}if(this instanceof sap.m.VBox&&(this.getDirection()!==sap.m.FlexDirection.Column||this.getDirection()!==b.ColumnReverse)){this.setDirection('Column');}this._oItemDelegate={onAfterRendering:this._onAfterItemRendering};};d.prototype.addItem=function(i){this.addAggregation("items",i);this._onItemInserted(i);return this;};d.prototype.insertItem=function(i,I){this.insertAggregation("items",i,I);this._onItemInserted(i);return this;};d.prototype.removeItem=function(i){var I=this.removeAggregation("items",i);this._onItemRemoved(I);return I;};d.prototype.removeAllItems=function(){var I=this.getItems();for(var i=0;i<I.length;i++){this._onItemRemoved(I[i]);}return this.removeAllAggregation("items");};d.prototype._onItemInserted=function(i){if(i&&!(i instanceof sap.m.FlexBox)){i.attachEvent("_change",this._onItemChange,this);if(this.getRenderType()===c.Bare){i.addEventDelegate(this._oItemDelegate,i);}}};d.prototype._onItemRemoved=function(i){if(i&&!(i instanceof sap.m.FlexBox)){i.detachEvent("_change",this._onItemChange,this);if(this.getRenderType()===c.Bare){i.removeEventDelegate(this._oItemDelegate,i);}}};d.prototype._onItemChange=function(o){if(o.getParameter("name")!=="visible"||(this.getRenderType()!==c.List&&this.getRenderType()!==c.Div)){return;}var i=sap.ui.getCore().byId(o.getParameter("id")),w=null;if(i.getLayoutData()){w=q.sap.byId(i.getLayoutData().getId());}else{w=q.sap.byId(sap.ui.core.RenderManager.createInvisiblePlaceholderId(i)).parent();}if(o.getParameter("newValue")){w.removeClass("sapUiHiddenPlaceholder").removeAttr("aria-hidden");}else{w.addClass("sapUiHiddenPlaceholder").attr("aria-hidden","true");}};d.prototype._onAfterItemRendering=function(){var L=this.getLayoutData();if(L instanceof a){F.setFlexItemStyles(null,L);}};d.prototype.setRenderType=function(v){var o=this.getRenderType(),i=this.getItems();if(v===o){return this;}this.setProperty("renderType",v);if(o==="Bare"){i.forEach(this._onItemRemoved,this);}if(v==="Bare"){i.forEach(this._onItemInserted,this);}return this;};d.prototype.setDisplayInline=function(i){this.setProperty("displayInline",i,true);this.$().toggleClass("sapMFlexBoxInline",this.getDisplayInline());return this;};d.prototype.setDirection=function(v){this.setProperty("direction",v,true);if(this.getDirection()===b.Column||this.getDirection()===b.ColumnReverse){this.$().removeClass("sapMHBox").addClass("sapMVBox");}else{this.$().removeClass("sapMVBox").addClass("sapMHBox");}if(this.getDirection()===b.RowReverse||this.getDirection()===b.ColumnReverse){this.$().addClass("sapMFlexBoxReverse");}else{this.$().removeClass("sapMFlexBoxReverse");}return this;};d.prototype.setFitContainer=function(v){this.setProperty("fitContainer",v,true);this.$().toggleClass("sapMFlexBoxFit",this.getFitContainer());return this;};d.prototype.setWrap=function(v){var o=this.getWrap();this.setProperty("wrap",v,true);this.$().removeClass("sapMFlexBoxWrap"+o).addClass("sapMFlexBoxWrap"+this.getWrap());return this;};d.prototype.setJustifyContent=function(v){var o=this.getJustifyContent();this.setProperty("justifyContent",v,true);this.$().removeClass("sapMFlexBoxJustify"+o).addClass("sapMFlexBoxJustify"+this.getJustifyContent());return this;};d.prototype.setAlignItems=function(v){var o=this.getAlignItems();this.setProperty("alignItems",v,true);this.$().removeClass("sapMFlexBoxAlignItems"+o).addClass("sapMFlexBoxAlignItems"+this.getAlignItems());return this;};d.prototype.setAlignContent=function(v){var o=this.getAlignContent();this.setProperty("alignContent",v,true);this.$().removeClass("sapMFlexBoxAlignContent"+o).addClass("sapMFlexBoxAlignContent"+this.getAlignContent());return this;};d.prototype.setHeight=function(v){this.setProperty("height",v,true);this.$().css("height",this.getHeight());return this;};d.prototype.setWidth=function(v){this.setProperty("width",v,true);this.$().css("width",this.getWidth());return this;};d.prototype.setBackgroundDesign=function(v){var o=this.getBackgroundDesign();this.setProperty("backgroundDesign",v,true);this.$().removeClass("sapMFlexBoxBG"+o).addClass("sapMFlexBoxBG"+this.getBackgroundDesign());return this;};d.prototype.getAccessibilityInfo=function(){return{children:this.getItems()};};return d;},true);
