/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./library','sap/ui/core/Control','sap/ui/core/Popup','sap/m/Text','sap/m/Button','sap/m/Image','sap/ui/core/ResizeHandler','sap/ui/Device','sap/m/MessagePage','sap/ui/core/Icon','sap/ui/layout/VerticalLayout'],function(q,l,C,P,T,B,I,R,D,M,a,V){'use strict';var L=C.extend('sap.m.LightBox',{metadata:{interfaces:['sap.ui.core.PopupInterface'],library:'sap.m',aggregations:{imageContent:{type:'sap.m.LightBoxItem',multiple:true,bindable:"bindable"},_closeButton:{type:'sap.m.Button',multiple:false,visibility:'hidden'},_errorIcon:{type:'sap.ui.core.Icon',multiple:false,visibility:'hidden'},_errorTitle:{type:'sap.m.Text',multiple:false,visibility:'hidden'},_errorSubtitle:{type:'sap.m.Text',multiple:false,visibility:'hidden'},_verticalLayout:{type:'sap.ui.layout.VerticalLayout',multiple:false,visibility:'hidden'}},events:{},defaultAggregation:'imageContent'}});L.prototype.init=function(){this._createPopup();this._width=0;this._height=0;this._isRendering=true;this._resizeListenerId=null;this._$lightBox=null;this._closeButtonText=sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("LIGHTBOX_CLOSE_BUTTON");};L.prototype.onBeforeRendering=function(){var i=this._getImageContent(),n=i._getNativeImage(),s=i._getImageState();this._createErrorControls();n.src=i.getImageSrc();if(this._resizeListenerId){D.resize.detachHandler(this._onResize);R.deregister(this._resizeListenerId);this._resizeListenerId=null;}switch(s){case sap.m.LightBoxLoadingStates.Loading:this._timeoutId=setTimeout(function(){i._setImageState(sap.m.LightBoxLoadingStates.TimeOutError);},10000);break;case sap.m.LightBoxLoadingStates.Loaded:clearTimeout(this._timeoutId);this._calculateSizes(n);break;case sap.m.LightBoxLoadingStates.Error:clearTimeout(this._timeoutId);break;default:break;}this._isRendering=true;};L.prototype.onAfterRendering=function(){this._isRendering=false;this._$lightBox=this.$();if(!this._resizeListenerId){D.resize.attachHandler(this._onResize.bind(this));this._resizeListenerId=R.register(this,this._onResize.bind(this));}};L.prototype.forceInvalidate=C.prototype.invalidate;L.prototype.invalidate=function(o){var i=this._getImageContent();if(this.isOpen()){if(i&&i.getImageSrc()){this.forceInvalidate(o);}else{this.close();}}return this;};L.prototype.exit=function(){if(this._oPopup){this._oPopup.detachOpened(this._fnOpened,this);this._oPopup.detachClosed(this._fnClosed,this);this._oPopup.destroy();this._oPopup=null;}if(this._resizeListenerId){D.resize.detachHandler(this._onResize);R.deregister(this._resizeListenerId);this._resizeListenerId=null;}};L.prototype.open=function(){var i=this._getImageContent();this._oPopup.setContent(this);if(i&&i.getImageSrc()){this._oPopup.open(300,'center center','center center',document.body,null);}return this;};L.prototype.isOpen=function(){if(this._oPopup&&this._oPopup.isOpen()){return true;}return false;};L.prototype.close=function(){if(this._resizeListenerId){D.resize.detachHandler(this._onResize);R.deregister(this._resizeListenerId);this._resizeListenerId=null;}this._oPopup.close();return this;};L.prototype._getCloseButton=function(){var b=this.getAggregation('_closeButton');if(!b){b=new B({id:this.getId()+'-closeButton',text:this._closeButtonText,type:sap.m.ButtonType.Transparent,press:function(){this.close();}.bind(this)});this.setAggregation('_closeButton',b,true);}return b;};L.prototype._imageStateChanged=function(n){if((n===sap.m.LightBoxLoadingStates.Loaded||n===sap.m.LightBoxLoadingStates.Error)&&!this._isRendering){this.rerender();}};L.prototype._createPopup=function(){this._oPopup=new P(this,true,true);this._oPopup.attachOpened(this._fnOpened,this);this._oPopup.attachClosed(this._fnClosed,this);};L.prototype._fnOpened=function(){var t=this;q('#sap-ui-blocklayer-popup').on("click",function(){t.close();});};L.prototype._fnClosed=function(){q('#sap-ui-blocklayer-popup').off("click");};L.prototype._createErrorControls=function(){var r=sap.ui.getCore().getLibraryResourceBundle("sap.m");var e;var b;if(this._getImageContent()._getImageState()===sap.m.LightBoxLoadingStates.TimeOutError){e=r.getText('LIGHTBOX_IMAGE_TIMED_OUT');b=r.getText('LIGHTBOX_IMAGE_TIMED_OUT_DETAILS');}else{e=r.getText('LIGHTBOX_IMAGE_ERROR');b=r.getText('LIGHTBOX_IMAGE_ERROR_DETAILS');}var d=new T({text:e,textAlign:sap.ui.core.TextAlign.Center}).addStyleClass("sapMLightBoxErrorTitle"),f=new T({text:b,textAlign:sap.ui.core.TextAlign.Center}).addStyleClass("sapMLightBoxErrorSubtitle"),g=new a({src:"sap-icon://picture"}).addStyleClass("sapMLightBoxErrorIcon");this.setAggregation('_errorIcon',g);this.setAggregation('_verticalLayout',new V({content:[g,d,f]}).addStyleClass('sapMLightBoxVerticalLayout'));};L.prototype._onResize=function(){var m=c()/2+'px',t=m,b=m,d='',e='',i=this._getImageContent(),f=this.getDomRef(),g,h,j=c(),k=2;if(i._getImageState()===sap.m.LightBoxLoadingStates.Loaded){this._calculateSizes(i._getNativeImage());g=this._width;h=this._height;this._$lightBox.width(g);this._$lightBox.height(h);}else{g=f.clientWidth;h=f.clientHeight;}if(window.innerWidth>g+j){b='50%';e=Math.round(-g/2);}if(window.innerHeight>h+j){t='50%';d=Math.round(-h/2);}if(sap.ui.getCore().getConfiguration().getTheme()==='sap_hcb'){d-=k;e-=k;}this._$lightBox.css({'top':t,'margin-top':d,'left':b,'margin-left':e});};L.prototype._calculateSizes=function(i){var f=this._calculateFooterHeightInPx(),b=288-f,d=this._getImageContent().getAggregation("_image"),h;this._setImageSize(d,i.naturalWidth,i.naturalHeight);this._calculateAndSetLightBoxSize(d);h=this._pxToNumber(d.getHeight());this.toggleStyleClass('sapMLightBoxMinSize',(h<b));this._isBusy=false;};L.prototype._calculateFooterHeightInPx=function(i){var b=this.$().parents().hasClass('sapUiSizeCompact');var s=this._getImageContent().getSubtitle();var f=2.5;if(!b){f+=0.5;}if(s){f+=1.5;}return f*16;};L.prototype._calculateAndSetLightBoxSize=function(i){var b,d=(20*16),e=(18*16),f=this._calculateFooterHeightInPx();b=this._pxToNumber(i.getHeight());this._width=Math.max(d,this._pxToNumber(i.getWidth()));this._height=Math.max(e,b+f);};L.prototype._setImageSize=function(i,b,d){var f=this._calculateFooterHeightInPx(),e=this._getDimensions(b,d,f);i.setWidth(e.width+'px');i.setHeight(e.height+'px');};L.prototype._getDimensions=function(i,b,f){var d=20*16,e=18*16,$=q(window),w=$.height(),g=$.width(),m=c(),h=Math.max(g-m,d),j=Math.max(w-m,e),s;j-=f;if(b<=j){if(i<=h){}else{b*=h/i;i=h;}}else{if(i<=h){i*=j/b;b=j;}else{s=Math.max(i/h,b/j);i/=s;b/=s;}}return{width:Math.round(i),height:Math.round(b)};};L.prototype._pxToNumber=function(s){return(s.substring(0,(s.length-2)))*1;};L.prototype._getImageContent=function(){var r=this.getAggregation('imageContent');return r&&r[0];};function c(){var s=sap.ui.Device.system;if(s.desktop){return 4*16;}if(s.tablet){return 2*16;}return 0;}return L;},true);
