/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./library','sap/ui/core/Control','sap/ui/core/delegate/ItemNavigation'],function(q,l,C,I){"use strict";var R=C.extend("sap.m.RadioButtonGroup",{metadata:{library:"sap.m",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},columns:{type:"int",group:"Appearance",defaultValue:1},editable:{type:"boolean",group:"Behavior",defaultValue:true},valueState:{type:"sap.ui.core.ValueState",group:"Data",defaultValue:sap.ui.core.ValueState.None},selectedIndex:{type:"int",group:"Data",defaultValue:0},enabled:{type:"boolean",group:"Behavior",defaultValue:true},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:sap.ui.core.TextDirection.Inherit}},defaultAggregation:"buttons",aggregations:{buttons:{type:"sap.m.RadioButton",multiple:true,singularName:"button",bindable:"bindable"}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{select:{parameters:{selectedIndex:{type:"int"}}}}}});R.prototype.exit=function(){this.destroyButtons();if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation;}};R.prototype.onBeforeRendering=function(){if(this.getSelectedIndex()>this.getButtons().length){q.sap.log.warning("Invalid index, set to 0");this.setSelectedIndex(0);}};R.prototype.onAfterRendering=function(){this._initItemNavigation();var v;if(this.getVisible()){v=this.aRBs.filter(function(b){return b.getVisible();});}else{v=[];}for(var i=0;i<v.length;i++){var r=v[i].getDomRef();r.setAttribute("aria-posinset",i+1);r.setAttribute("aria-setsize",v.length);}};R.prototype._initItemNavigation=function(){var d=[];var h=false;var r=this.getEnabled();for(var i=0;i<this.aRBs.length;i++){d.push(this.aRBs[i].getDomRef());h=h||this.aRBs[i].getEnabled();}if(!h||!r){if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation;}return;}if(!this._oItemNavigation){this._oItemNavigation=new I();this._oItemNavigation.attachEvent(I.Events.AfterFocus,this._handleAfterFocus,this);this.addDelegate(this._oItemNavigation);}this._oItemNavigation.setRootDomRef(this.getDomRef());this._oItemNavigation.setItemDomRefs(d);this._oItemNavigation.setCycling(true);this._oItemNavigation.setColumns(this.getColumns());this._oItemNavigation.setSelectedIndex(this.getSelectedIndex());this._oItemNavigation.setFocusedIndex(this.getSelectedIndex());};R.prototype.setSelectedIndex=function(s){var i=this.getSelectedIndex();var h=document.activeElement&&document.activeElement.parentNode&&document.activeElement.parentNode.parentNode===this.getDomRef();var a=!!(this.aRBs&&this.aRBs[s]);if(s<-1){q.sap.log.warning("Invalid index, will not be changed");return this;}this.setProperty("selectedIndex",s,true);if(!isNaN(i)&&this.aRBs&&this.aRBs[i]){this.aRBs[i].setSelected(false);}if(this.aRBs&&this.aRBs[s]){this.aRBs[s].setSelected(true);}if(this._oItemNavigation){this._oItemNavigation.setSelectedIndex(s);this._oItemNavigation.setFocusedIndex(s);}if(a&&h){this.aRBs[s].getDomRef().focus();}return this;};R.prototype.setSelectedButton=function(s){var b=this.getButtons();if(s){if(b){for(var i=0;i<b.length;i++){if(s.getId()==b[i].getId()){this.setSelectedIndex(i);break;}}}}else{this.setSelectedIndex(-1);}return this;};R.prototype.getSelectedButton=function(){return this.getButtons()[this.getSelectedIndex()];};R.prototype.addButton=function(b){if(!this._bUpdateButtons&&this.getSelectedIndex()===undefined){this.setSelectedIndex(0);}if(!this.aRBs){this.aRBs=[];}var i=this.aRBs.length;this.aRBs[i]=this._createRadioButton(b,i);this.addAggregation("buttons",this.aRBs[i]);return this;};R.prototype.insertButton=function(b,a){if(!this.aRBs){this.aRBs=[];}var L=this.aRBs.length;if(!this._bUpdateButtons){if(this.getSelectedIndex()===undefined||L==0){this.setSelectedIndex(0);}else if(this.getSelectedIndex()>=a){this.setProperty("selectedIndex",this.getSelectedIndex()+1,true);}}if(a>=L){this.aRBs[a]=this._createRadioButton(b,a);}else{for(var i=(L);i>a;i--){this.aRBs[i]=this.aRBs[i-1];if((i-1)==a){this.aRBs[i-1]=this._createRadioButton(b,a);}}}this.insertAggregation("buttons",b,a);return this;};R.prototype._createRadioButton=function(b,i){if(this.iIDCount==undefined){this.iIDCount=0;}else{this.iIDCount++;}b.setValueState(this.getValueState());b.setGroupName(this.getId());if(i==this.getSelectedIndex()){b.setSelected(true);}b.attachEvent("select",this._handleRBSelect,this);return b;};R.prototype.removeButton=function(e){var i=e;if(typeof(e)=="string"){e=sap.ui.getCore().byId(e);}if(typeof(e)=="object"){i=this.indexOfButton(e);}var b=this.removeAggregation("buttons",i);if(!this.aRBs){this.aRBs=[];}if(!this.aRBs[i]){return null;}this.aRBs[i].destroy();this.aRBs.splice(i,1);if(!this._bUpdateButtons){if(this.aRBs.length==0){this.setSelectedIndex(-1);}else if(this.getSelectedIndex()==i){this.setSelectedIndex(0);}else{if(this.getSelectedIndex()>i){this.setProperty("selectedIndex",this.getSelectedIndex()-1,true);}}}return b;};R.prototype.removeAllButtons=function(){var b=this.removeAllAggregation("buttons");if(!this._bUpdateButtons){this.setSelectedIndex(-1);}if(this.aRBs){while(this.aRBs.length>0){this.aRBs[0].destroy();this.aRBs.splice(0,1);}return b;}else{return null;}};R.prototype.destroyButtons=function(){this.destroyAggregation("buttons");if(!this._bUpdateButtons){this.setSelectedIndex(-1);}if(this.aRBs){while(this.aRBs.length>0){this.aRBs[0].destroy();this.aRBs.splice(0,1);}}return this;};R.prototype.updateButtons=function(){this._bUpdateButtons=true;this.updateAggregation("buttons");this._bUpdateButtons=undefined;};R.prototype.clone=function(){var b=this.getButtons();var i=0;for(i=0;i<b.length;i++){b[i].detachEvent("select",this._handleRBSelect,this);}var c=C.prototype.clone.apply(this,arguments);for(i=0;i<b.length;i++){b[i].attachEvent("select",this._handleRBSelect,this);}return c;};R.prototype._handleRBSelect=function(c){for(var i=0;i<this.aRBs.length;i++){if(this.aRBs[i].getId()==c.getParameter("id")&&c.getParameter("selected")){this.setSelectedIndex(i);this.fireSelect({selectedIndex:i});break;}}};R.prototype.setValueState=function(v){this.setProperty("valueState",v,false);if(this.aRBs){for(var i=0;i<this.aRBs.length;i++){this.aRBs[i].setValueState(v);}}return this;};R.prototype._handleAfterFocus=function(c){var i=c.getParameter("index");var e=c.getParameter("event");if(e.keyCode===undefined){return;}if(i!=this.getSelectedIndex()&&!(e.ctrlKey||e.metaKey)&&this.aRBs[i].getEditable()&&this.aRBs[i].getEnabled()&&this.getEditable()&&this.getEnabled()){this.setSelectedIndex(i);this.fireSelect({selectedIndex:i});}};return R;},true);
