/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/base/Object','./Configuration','./Locale'],function(q,B,C,L){"use strict";var a=B.extend("sap.ui.core.LocaleData",{constructor:function(o){this.oLocale=o;B.apply(this);this.mData=e(o);},_get:function(){return this._getDeep(this.mData,arguments);},_getDeep:function(o,p){var r=o;for(var i=0;i<p.length;i++){r=r[p[i]];if(r===undefined){break;}}return r;},getOrientation:function(){return this._get("orientation");},getLanguages:function(){return this._get("languages");},getScripts:function(){return this._get("scripts");},getTerritories:function(){return this._get("territories");},getMonths:function(w,s){return this._get(g(s),"months","format",w);},getMonthsStandAlone:function(w,s){return this._get(g(s),"months","stand-alone",w);},getDays:function(w,s){return this._get(g(s),"days","format",w);},getDaysStandAlone:function(w,s){return this._get(g(s),"days","stand-alone",w);},getQuarters:function(w,s){return this._get(g(s),"quarters","format",w);},getQuartersStandAlone:function(w,s){return this._get(g(s),"quarters","stand-alone",w);},getDayPeriods:function(w,s){return this._get(g(s),"dayPeriods","format",w);},getDayPeriodsStandAlone:function(w,s){return this._get(g(s),"dayPeriods","stand-alone",w);},getDatePattern:function(s,h){return this._get(g(h),"dateFormats",s);},getTimePattern:function(s,h){return this._get(g(h),"timeFormats",s);},getDateTimePattern:function(s,h){return this._get(g(h),"dateTimeFormats",s);},getCombinedDateTimePattern:function(D,t,s){var h=this.getDateTimePattern(D,s),i=this.getDatePattern(D,s),T=this.getTimePattern(t,s);return h.replace("{0}",T).replace("{1}",i);},getCustomDateTimePattern:function(s,h){var A=this._get(g(h),"dateTimeFormats","availableFormats");return this._getFormatPattern(s,A,h);},_parseSkeletonFormat:function(s){var t=[],T={index:-1},S,o,G;for(var i=0;i<s.length;i++){S=s.charAt(i);if(S=="j"||S=="J"){S=this.getPreferredHourSymbol();}if(S==T.symbol){T.length++;continue;}o=m[S];G=c[o.group];if(o.group=="Other"){throw new Error("Symbol '"+S+"' is not allowed in skeleton format '"+s+"'");}if(G.index<=T.index){throw new Error("Symbol '"+S+"' at wrong position or duplicate in skeleton format '"+s+"'");}T={symbol:S,group:o.group,match:o.match,index:G.index,field:G.field,length:1};t.push(T);}return t;},_getFormatPattern:function(s,A,h){var p=A[s];if(!p){p=this._createFormatPattern(s,A,h);}return p;},_createFormatPattern:function(s,A,h){var t=this._parseSkeletonFormat(s),T,j,o,k,n,D,p,r,u,v,w=10000,P,x=/^([GyYqQMLwWEecdD]+)([hHkKjJmszZvVOXx]+)$/,y,z,F,E=-1;for(var G in A){T=this._parseSkeletonFormat(G);D=0;j=[];p=true;if(t.length<T.length){continue;}n=0;F=t.length;for(var i=0;i<t.length;i++){o=t[i];k=T[n];if(F===t.length){F=i;}if(k){y=m[o.symbol];z=m[k.symbol];if(o.symbol===k.symbol){if(o.length===k.length){if(F===i){F=t.length;}}else{if(o.length<y.numericCeiling?k.length<z.numericCeiling:k.length>=z.numericCeiling){D+=Math.abs(o.length-k.length);}else{D+=5;}}n++;continue;}else{if(o.match==k.match){D+=Math.abs(o.length-k.length)+10;n++;continue;}}}j.push(o);D+=50-i;}if(n<T.length){p=false;}if(p&&(D<w||(D===w&&F>E))){w=D;E=F;v=j;r=A[G];u=T;}}if(w==0){P=r;}else{if(!r){P=s;}else if(v.length>0){if(x.test(s)){P=this._getMixedFormatPattern(s,A,h);}else{P=this._expandFields(r,u,t);P=this._appendItems(P,v,h);}}else{P=this._expandFields(r,u,t);}}if(s.indexOf("J")>=0){P=P.replace(/ ?[abB](?=([^']*'[^']*')*[^']*)$/,"");}return P;},_expandFields:function(p,P,t){var G={},h={},r="",Q=false,i=0,s,k,o,n,S,u,v,w,x,y;t.forEach(function(T){G[T.group]=T;});P.forEach(function(T){h[T.group]=T;});while(i<p.length){y=p.charAt(i);if(Q){r+=y;if(y=="'"){Q=false;}}else{v=m[y];if(v&&G[v.group]&&h[v.group]){S=G[v.group];u=h[v.group];w=m[S.symbol];x=m[u.symbol];s=S.length;k=u.length;o=1;while(p.charAt(i+1)==y){i++;o++;}if(s===k||((s<w.numericCeiling)?(k>=x.numericCeiling):(k<x.numericCeiling))){n=o;}else{n=Math.max(o,s);}for(var j=0;j<n;j++){r+=y;}}else{r+=y;if(y=="'"){Q=true;}}}i++;}return r;},_appendItems:function(p,h,s){var A=this._get(g(s),"dateTimeFormats","appendItems"),D,j,k;h.forEach(function(t){j=A[t.group];D="'"+this.getDisplayName(t.field)+"'";k="";for(var i=0;i<t.length;i++){k+=t.symbol;}p=j.replace(/\{0\}/,p).replace(/\{1\}/,k).replace(/\{2\}/,D);}.bind(this));return p;},_getMixedFormatPattern:function(s,A,h){var r=/^([GyYqQMLwWEecdD]+)([hHkKjJmszZvVOXx]+)$/,i=/MMMM|LLLL/,j=/MMM|LLL/,k=/E|e|c/,R,D,t,S,n,T,o,p;R=r.exec(s);D=R[1];t=R[2];n=this._getFormatPattern(D,A,h);T=this._getFormatPattern(t,A,h);if(i.test(D)){S=k.test(D)?"full":"long";}else if(j.test(D)){S="medium";}else{S="short";}o=this.getDateTimePattern(S,h);p=o.replace(/\{1\}/,n).replace(/\{0\}/,T);return p;},getIntervalPattern:function(i,s){var I=this._get(g(s),"dateTimeFormats","intervalFormats"),h,j,D,o,p;if(i){h=i.split("-");j=h[0];D=h[1];o=I[j];if(o){p=o[D];if(p){return p;}}}return I.intervalFormatFallback;},getNumberSymbol:function(t){return this._get("symbols-latn-"+t);},getDecimalPattern:function(){return this._get("decimalFormat").standard;},getCurrencyPattern:function(s){return this._get("currencyFormat")[s]||this._get("currencyFormat").standard;},getCurrencySpacing:function(p){return this._get("currencyFormat","currencySpacing",p==="after"?"afterCurrency":"beforeCurrency");},getPercentPattern:function(){return this._get("percentFormat").standard;},getMinimalDaysInFirstWeek:function(){return this._get("weekData-minDays");},getFirstDayOfWeek:function(){return this._get("weekData-firstDay");},getWeekendStart:function(){return this._get("weekData-weekendStart");},getWeekendEnd:function(){return this._get("weekData-weekendEnd");},getCurrencyDigits:function(s){var o=this._get("currencyDigits");var D=2;if(o){if(o[s]!=undefined){D=o[s];}else{D=o["DEFAULT"];}}return D;},getCurrencySymbol:function(s){var o=this._get("currencySymbols");return(o&&o[s])||s;},getCurrencyCodeBySymbol:function(s){var o=this._get("currencySymbols"),h;for(h in o){if(o[h]===s){return h;}}return s;},getRelativePatterns:function(s,S){if(S===undefined){S="wide";}var p=[],o,t,v,i;if(!s){s=["year","month","week","day","hour","minute","second"];}s.forEach(function(h){o=this._get("dateFields",h+"-"+S);for(var E in o){if(E.indexOf("relative-type-")===0){v=parseInt(E.substr(14),10);p.push({scale:h,value:v,pattern:o[E]});}else if(E.indexOf("relativeTime-type-")==0){t=o[E];i=E.substr(18)==="past"?-1:1;if(t["relativeTimePattern-count-one"]){p.push({scale:h,sign:i,pattern:t["relativeTimePattern-count-one"]});}p.push({scale:h,sign:i,pattern:t["relativeTimePattern-count-other"]});}}}.bind(this));return p;},getRelativePattern:function(s,D,F,S){var p,t,k;if(typeof F==="string"){S=F;F=undefined;}if(F===undefined){F=D>0;}if(S===undefined){S="wide";}k=s+"-"+S;p=this._get("dateFields",k,"relative-type-"+D);if(!p){t=this._get("dateFields",k,"relativeTime-type-"+(F?"future":"past"));if(Math.abs(D)===1){p=t["relativeTimePattern-count-one"];}if(!p){p=t["relativeTimePattern-count-other"];}}return p;},getRelativeSecond:function(D,s){return this.getRelativePattern("second",D,s);},getRelativeMinute:function(D,s){if(D==0){return null;}return this.getRelativePattern("minute",D,s);},getRelativeHour:function(D,s){if(D==0){return null;}return this.getRelativePattern("hour",D,s);},getRelativeDay:function(D,s){return this.getRelativePattern("day",D,s);},getRelativeWeek:function(D,s){return this.getRelativePattern("week",D,s);},getRelativeMonth:function(D,s){return this.getRelativePattern("month",D,s);},getDisplayName:function(t,s){if(s===undefined){s="wide";}var S=["era","weekday","zone"],k=S.indexOf(t)===-1?t+"-"+s:t;return this._get("dateFields",k,"displayName");},getRelativeYear:function(D,s){return this.getRelativePattern("year",D,s);},getDecimalFormat:function(s,n,p){var F;var o;switch(s){case"long":o=this._get("decimalFormat-long");break;default:o=this._get("decimalFormat-short");break;}if(o){var N=n+"-"+p;F=o[N];if(!F){N=n+"-other";F=o[N];}}return F;},getEras:function(w,s){var E=this._get(g(s),"era-"+w),h=[];for(var i in E){h[parseInt(i,10)]=E[i];}return h;},getEraDates:function(s){var E=this._get("eras-"+s.toLowerCase()),h=[];for(var i in E){h[parseInt(i,10)]=E[i];}return h;},getCalendarWeek:function(s,w){var o=sap.ui.getCore().getLibraryResourceBundle("sap.ui.core",this.oLocale.toString()),k="date.week.calendarweek."+s;return o.getText(k,w);},getPreferredCalendarType:function(){var s=this._get("calendarPreference"),h=s?s.split(" "):[],j,t,i;sap.ui.getCore().loadLibrary('sap.ui.core');var k=sap.ui.require("sap/ui/core/library").CalendarType;for(i=0;i<h.length;i++){j=h[i];for(t in k){if(j===g(t).substring(3)){return t;}}}return k.Gregorian;},getPreferredHourSymbol:function(){return this._get("timeData","_preferred");}});var c={"Era":{field:"era",index:0},"Year":{field:"year",index:1},"Quarter":{field:"quarter",index:2},"Month":{field:"month",index:3},"Week":{field:"week",index:4},"Day-Of-Week":{field:"weekday",index:5},"Day":{field:"day",index:6},"Hour":{field:"hour",index:7},"Minute":{field:"minute",index:8},"Second":{field:"second",index:9},"Timezone":{field:"zone",index:10}};var m={"G":{group:"Era",match:"Era",numericCeiling:1},"y":{group:"Year",match:"Year",numericCeiling:100},"Y":{group:"Year",match:"Year",numericCeiling:100},"Q":{group:"Quarter",match:"Quarter",numericCeiling:3},"q":{group:"Quarter",match:"Quarter",numericCeiling:3},"M":{group:"Month",match:"Month",numericCeiling:3},"L":{group:"Month",match:"Month",numericCeiling:3},"w":{group:"Week",match:"Week",numericCeiling:100},"W":{group:"Week",match:"Week",numericCeiling:100},"d":{group:"Day",match:"Day",numericCeiling:100},"D":{group:"Day",match:"Day",numericCeiling:100},"E":{group:"Day-Of-Week",match:"Day-Of-Week",numericCeiling:1},"e":{group:"Day-Of-Week",match:"Day-Of-Week",numericCeiling:3},"c":{group:"Day-Of-Week",match:"Day-Of-Week",numericCeiling:2},"h":{group:"Hour",match:"Hour12",numericCeiling:100},"H":{group:"Hour",match:"Hour24",numericCeiling:100},"k":{group:"Hour",match:"Hour24",numericCeiling:100},"K":{group:"Hour",match:"Hour12",numericCeiling:100},"m":{group:"Minute",match:"Minute",numericCeiling:100},"s":{group:"Second",match:"Second",numericCeiling:100},"z":{group:"Timezone",match:"Timezone",numericCeiling:1},"Z":{group:"Timezone",match:"Timezone",numericCeiling:1},"O":{group:"Timezone",match:"Timezone",numericCeiling:1},"v":{group:"Timezone",match:"Timezone",numericCeiling:1},"V":{group:"Timezone",match:"Timezone",numericCeiling:1},"X":{group:"Timezone",match:"Timezone",numericCeiling:1},"x":{group:"Timezone",match:"Timezone",numericCeiling:1},"S":{group:"Other",numericCeiling:100},"u":{group:"Other",numericCeiling:100},"U":{group:"Other",numericCeiling:1},"r":{group:"Other",numericCeiling:100},"F":{group:"Other",numericCeiling:100},"g":{group:"Other",numericCeiling:100},"a":{group:"Other",numericCeiling:1},"b":{group:"Other",numericCeiling:1},"B":{group:"Other",numericCeiling:1},"A":{group:"Other",numericCeiling:100}};var M={"orientation":"left-to-right","languages":{},"scripts":{},"territories":{},"ca-gregorian":{"dateFormats":{"full":"EEEE, MMMM d, y","long":"MMMM d, y","medium":"MMM d, y","short":"M/d/yy"},"timeFormats":{"full":"h:mm:ss a zzzz","long":"h:mm:ss a z","medium":"h:mm:ss a","short":"h:mm a"},"dateTimeFormats":{"full":"{1} 'at' {0}","long":"{1} 'at' {0}","medium":"{1}, {0}","short":"{1}, {0}","availableFormats":{"d":"d","E":"ccc","Ed":"d E","Ehm":"E h:mm a","EHm":"E HH:mm","Ehms":"E h:mm:ss a","EHms":"E HH:mm:ss","Gy":"y G","GyMMM":"MMM y G","GyMMMd":"MMM d, y G","GyMMMEd":"E, MMM d, y G","h":"h a","H":"HH","hm":"h:mm a","Hm":"HH:mm","hms":"h:mm:ss a","Hms":"HH:mm:ss","hmsv":"h:mm:ss a v","Hmsv":"HH:mm:ss v","hmv":"h:mm a v","Hmv":"HH:mm v","M":"L","Md":"M/d","MEd":"E, M/d","MMM":"LLL","MMMd":"MMM d","MMMEd":"E, MMM d","MMMMd":"MMMM d","ms":"mm:ss","y":"y","yM":"M/y","yMd":"M/d/y","yMEd":"E, M/d/y","yMMM":"MMM y","yMMMd":"MMM d, y","yMMMEd":"E, MMM d, y","yMMMM":"MMMM y","yQQQ":"QQQ y","yQQQQ":"QQQQ y"},"appendItems":{"Day":"{0} ({2}: {1})","Day-Of-Week":"{0} {1}","Era":"{0} {1}","Hour":"{0} ({2}: {1})","Minute":"{0} ({2}: {1})","Month":"{0} ({2}: {1})","Quarter":"{0} ({2}: {1})","Second":"{0} ({2}: {1})","Timezone":"{0} {1}","Week":"{0} ({2}: {1})","Year":"{0} {1}"},"intervalFormats":{"intervalFormatFallback":"{0} – {1}"}},"months":{"format":{"abbreviated":["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"],"narrow":["J","F","M","A","M","J","J","A","S","O","N","D"],"wide":["January","February","March","April","May","June","July","August","September","October","November","December"]},"stand-alone":{"abbreviated":["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"],"narrow":["J","F","M","A","M","J","J","A","S","O","N","D"],"wide":["January","February","March","April","May","June","July","August","September","October","November","December"]}},"days":{"format":{"abbreviated":["Sun","Mon","Tue","Wed","Thu","Fri","Sat"],"narrow":["S","M","T","W","T","F","S"],"short":["Su","Mo","Tu","We","Th","Fr","Sa"],"wide":["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"]},"stand-alone":{"abbreviated":["Sun","Mon","Tue","Wed","Thu","Fri","Sat"],"narrow":["S","M","T","W","T","F","S"],"short":["Su","Mo","Tu","We","Th","Fr","Sa"],"wide":["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"]}},"quarters":{"format":{"abbreviated":["Q1","Q2","Q3","Q4"],"narrow":["1","2","3","4"],"wide":["1st quarter","2nd quarter","3rd quarter","4th quarter"]},"stand-alone":{"abbreviated":["Q1","Q2","Q3","Q4"],"narrow":["1","2","3","4"],"wide":["1st quarter","2nd quarter","3rd quarter","4th quarter"]}},"dayPeriods":{"format":{"abbreviated":["AM","PM"],"narrow":["a","p"],"wide":["AM","PM"]},"stand-alone":{"abbreviated":["AM","PM"],"narrow":["AM","PM"],"wide":["AM","PM"]}},"era-wide":{"0":"Before Christ","1":"Anno Domini"},"era-abbreviated":{"0":"BC","1":"AD"},"era-narrow":{"0":"B","1":"A"}},"eras-gregorian":{"0":{"_end":"0-12-31"},"1":{"_start":"1-01-01"}},"dateFields":{"era":{"displayName":"era"},"year-wide":{"displayName":"year","relative-type--1":"last year","relative-type-0":"this year","relative-type-1":"next year","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} year","relativeTimePattern-count-other":"in {0} years"},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} year ago","relativeTimePattern-count-other":"{0} years ago"}},"quarter-wide":{"displayName":"quarter","relative-type--1":"last quarter","relative-type-0":"this quarter","relative-type-1":"next quarter","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} quarter","relativeTimePattern-count-other":"in {0} quarters"},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} quarter ago","relativeTimePattern-count-other":"{0} quarters ago"}},"month-wide":{"displayName":"month","relative-type--1":"last month","relative-type-0":"this month","relative-type-1":"next month","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} month","relativeTimePattern-count-other":"in {0} months"},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} month ago","relativeTimePattern-count-other":"{0} months ago"}},"week-wide":{"displayName":"week","relative-type--1":"last week","relative-type-0":"this week","relative-type-1":"next week","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} week","relativeTimePattern-count-other":"in {0} weeks"},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} week ago","relativeTimePattern-count-other":"{0} weeks ago"}},"day-wide":{"displayName":"day","relative-type--1":"yesterday","relative-type-0":"today","relative-type-1":"tomorrow","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} day","relativeTimePattern-count-other":"in {0} days"},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} day ago","relativeTimePattern-count-other":"{0} days ago"}},"weekday":{"displayName":"day of the week"},"hour-wide":{"displayName":"hour","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} hour","relativeTimePattern-count-other":"in {0} hours"},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} hour ago","relativeTimePattern-count-other":"{0} hours ago"}},"minute-wide":{"displayName":"minute","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} minute","relativeTimePattern-count-other":"in {0} minutes"},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} minute ago","relativeTimePattern-count-other":"{0} minutes ago"}},"second-wide":{"displayName":"second","relative-type-0":"now","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} second","relativeTimePattern-count-other":"in {0} seconds"},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} second ago","relativeTimePattern-count-other":"{0} seconds ago"}},"zone":{"displayName":"time zone"}},"decimalFormat":{"standard":"#,##0.###"},"currencyFormat":{"standard":"¤#,##0.00"},"percentFormat":{"standard":"#,##0%"},"symbols-latn-decimal":".","symbols-latn-group":",","symbols-latn-plusSign":"+","symbols-latn-minusSign":"-","symbols-latn-percentSign":"%","weekData-minDays":4,"weekData-firstDay":1,"weekData-weekendStart":6,"weekData-weekendEnd":0,"timeData":{_allowed:"H h",_preferred:"H"}};var b={"iw":"he","ji":"yi","in":"id","sh":"sr"};var d=(function(){var h=L._cldrLocales,r={},i;if(h){for(i=0;i<h.length;i++){r[h[i]]=true;}}return r;}());var l={};function g(s){if(!s){s=sap.ui.getCore().getConfiguration().getCalendarType();}return"ca-"+s.toLowerCase();}function e(o){var s=o.getLanguage()||"",S=o.getScript()||"",r=o.getRegion()||"",D;function h(j,k){var n,v,p;if(!k){return;}for(n in k){if(k.hasOwnProperty(n)){v=j[n];p=k[n];if(v===undefined){j[n]=p;}else if(v===null){delete j[n];}else if(typeof v==='object'&&typeof p==='object'){h(v,p);}}}}function i(I){if(!l[I]&&(!d||d[I]===true)){var j=l[I]=q.sap.loadResource("sap/ui/core/cldr/"+I+".json",{dataType:"json",failOnError:false});if(j&&j.__fallbackLocale){h(j,i(j.__fallbackLocale));delete j.__fallbackLocale;}}return l[I];}s=(s&&b[s])||s;if(s==="no"){s="nb";}if(s==="zh"&&!r){if(S==="Hans"){r="CN";}else if(S==="Hant"){r="TW";}}var I=s+"_"+r;if(s&&r){D=i(I);}if(!D&&s){D=i(s);}l[I]=D||M;return l[I];}var f=a.extend("sap.ui.core.CustomLocaleData",{constructor:function(o){a.apply(this,arguments);this.mCustomData=sap.ui.getCore().getConfiguration().getFormatSettings().getCustomLocaleData();},_get:function(){var A=Array.prototype.slice.call(arguments),s,k;if(A[0].indexOf("ca-")==0){s=A[0];if(s==g()){A=A.slice(1);}}k=A.join("-");return this.mCustomData[k]||this._getDeep(this.mData,arguments);}});a.getInstance=function(o){return o.hasPrivateUseSubtag("sapufmt")?new f(o):new a(o);};return a;});
