/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/core/library','sap/ui/core/Locale','sap/ui/core/LocaleData','sap/ui/core/date/UniversalDate','jquery.sap.strings'],function(q,l,L,a,U){"use strict";var C=l.CalendarType;var D=function(){throw new Error();};D.oDateInfo={oDefaultFormatOptions:{style:"medium",relativeScale:"day",relativeStyle:"wide"},aFallbackFormatOptions:[{style:"short"},{style:"medium"},{pattern:"yyyy-MM-dd"},{pattern:"yyyyMMdd",strictParsing:true}],bShortFallbackFormatOptions:true,bPatternFallbackWithoutDelimiter:true,getPattern:function(o,s,c){return o.getDatePattern(s,c);},oRequiredParts:{"text":true,"year":true,"weekYear":true,"month":true,"day":true},aRelativeScales:["year","month","week","day"],aRelativeParseScales:["year","quarter","month","week","day","hour","minute","second"]};D.oDateTimeInfo={oDefaultFormatOptions:{style:"medium",relativeScale:"auto",relativeStyle:"wide"},aFallbackFormatOptions:[{style:"short"},{style:"medium"},{pattern:"yyyy-MM-dd'T'HH:mm:ss"},{pattern:"yyyyMMdd HHmmss"}],getPattern:function(o,s,c){var S=s.indexOf("/");if(S>0){return o.getCombinedDateTimePattern(s.substr(0,S),s.substr(S+1),c);}else{return o.getCombinedDateTimePattern(s,s,c);}},oRequiredParts:{"text":true,"year":true,"weekYear":true,"month":true,"day":true,"hour0_23":true,"hour1_24":true,"hour0_11":true,"hour1_12":true},aRelativeScales:["year","month","week","day","hour","minute","second"],aRelativeParseScales:["year","quarter","month","week","day","hour","minute","second"]};D.oTimeInfo={oDefaultFormatOptions:{style:"medium",relativeScale:"auto",relativeStyle:"wide"},aFallbackFormatOptions:[{style:"short"},{style:"medium"},{pattern:"HH:mm:ss"},{pattern:"HHmmss"}],getPattern:function(o,s,c){return o.getTimePattern(s,c);},oRequiredParts:{"text":true,"hour0_23":true,"hour1_24":true,"hour0_11":true,"hour1_12":true},aRelativeScales:["hour","minute","second"],aRelativeParseScales:["year","quarter","month","week","day","hour","minute","second"]};D.getInstance=function(f,o){return this.getDateInstance(f,o);};D.getDateInstance=function(f,o){return this.createInstance(f,o,this.oDateInfo);};D.getDateTimeInstance=function(f,o){return this.createInstance(f,o,this.oDateTimeInfo);};D.getTimeInstance=function(f,o){return this.createInstance(f,o,this.oTimeInfo);};D.createInstance=function(f,o,i){var F=q.sap.newObject(this.prototype);if(f instanceof L){o=f;f=undefined;}if(!o){o=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale();}F.oLocale=o;F.oLocaleData=a.getInstance(o);F.oFormatOptions=q.extend(false,{},i.oDefaultFormatOptions,f);if(!F.oFormatOptions.calendarType){F.oFormatOptions.calendarType=sap.ui.getCore().getConfiguration().getCalendarType();}if(!F.oFormatOptions.pattern){if(F.oFormatOptions.format){F.oFormatOptions.pattern=F.oLocaleData.getCustomDateTimePattern(F.oFormatOptions.format,F.oFormatOptions.calendarType);}else{F.oFormatOptions.pattern=i.getPattern(F.oLocaleData,F.oFormatOptions.style,F.oFormatOptions.calendarType);}}if(!F.oFormatOptions.fallback){if(!i.oFallbackFormats){i.oFallbackFormats={};}var s=o.toString(),c=F.oFormatOptions.calendarType,k=s+"-"+c,p,b;if(F.oFormatOptions.pattern&&i.bPatternFallbackWithoutDelimiter){k=k+"-"+F.oFormatOptions.pattern;}if(!i.oFallbackFormats[k]){b=i.aFallbackFormatOptions;if(i.bShortFallbackFormatOptions){p=i.getPattern(F.oLocaleData,"short");b=b.concat(D._createFallbackOptionsWithoutDelimiter(p));}if(F.oFormatOptions.pattern&&i.bPatternFallbackWithoutDelimiter){b=D._createFallbackOptionsWithoutDelimiter(F.oFormatOptions.pattern).concat(b);}i.oFallbackFormats[k]=D._createFallbackFormat(b,c,o,i);}F.aFallbackFormats=i.oFallbackFormats[k];}F.oRequiredParts=i.oRequiredParts;F.aRelativeScales=i.aRelativeScales;F.aRelativeParseScales=i.aRelativeParseScales;F.init();return F;};D.prototype.init=function(){var c=this.oFormatOptions.calendarType;this.aMonthsAbbrev=this.oLocaleData.getMonths("abbreviated",c);this.aMonthsWide=this.oLocaleData.getMonths("wide",c);this.aMonthsNarrow=this.oLocaleData.getMonths("narrow",c);this.aMonthsAbbrevSt=this.oLocaleData.getMonthsStandAlone("abbreviated",c);this.aMonthsWideSt=this.oLocaleData.getMonthsStandAlone("wide",c);this.aMonthsNarrowSt=this.oLocaleData.getMonthsStandAlone("narrow",c);this.aDaysAbbrev=this.oLocaleData.getDays("abbreviated",c);this.aDaysWide=this.oLocaleData.getDays("wide",c);this.aDaysNarrow=this.oLocaleData.getDays("narrow",c);this.aDaysShort=this.oLocaleData.getDays("short",c);this.aDaysAbbrevSt=this.oLocaleData.getDaysStandAlone("abbreviated",c);this.aDaysWideSt=this.oLocaleData.getDaysStandAlone("wide",c);this.aDaysNarrowSt=this.oLocaleData.getDaysStandAlone("narrow",c);this.aDaysShortSt=this.oLocaleData.getDaysStandAlone("short",c);this.aQuartersAbbrev=this.oLocaleData.getQuarters("abbreviated",c);this.aQuartersWide=this.oLocaleData.getQuarters("wide",c);this.aQuartersNarrow=this.oLocaleData.getQuarters("narrow",c);this.aQuartersAbbrevSt=this.oLocaleData.getQuartersStandAlone("abbreviated",c);this.aQuartersWideSt=this.oLocaleData.getQuartersStandAlone("wide",c);this.aQuartersNarrowSt=this.oLocaleData.getQuartersStandAlone("narrow",c);this.aErasNarrow=this.oLocaleData.getEras("narrow",c);this.aErasAbbrev=this.oLocaleData.getEras("abbreviated",c);this.aErasWide=this.oLocaleData.getEras("wide",c);this.aDayPeriods=this.oLocaleData.getDayPeriods("abbreviated",c);this.aFormatArray=this.parseCldrDatePattern(this.oFormatOptions.pattern);this.sAllowedCharacters=this.getAllowedCharacters(this.aFormatArray);};D._createFallbackFormat=function(f,c,o,i){return f.map(function(F){F.calendarType=c;F.fallback=true;var b=D.createInstance(F,o,i);b.bIsFallback=true;return b;});};D._createFallbackOptionsWithoutDelimiter=function(b){var r=/[^dMyGU]/g,d={regex:/d+/g,replace:"dd"},m={regex:/M+/g,replace:"MM"},y={regex:/[yU]+/g,replace:["yyyy","yy"]};b=b.replace(r,"");b=b.replace(d.regex,d.replace);b=b.replace(m.regex,m.replace);return y.replace.map(function(R){return{pattern:b.replace(y.regex,R),strictParsing:true};});};D.prototype.oSymbols={"G":"era","y":"year","Y":"weekYear","M":"month","L":"monthStandalone","w":"weekInYear","W":"weekInMonth","D":"dayInYear","d":"day","Q":"quarter","q":"quarterStandalone","F":"dayOfWeekInMonth","E":"dayNameInWeek","c":"dayNameInWeekStandalone","u":"dayNumberOfWeek","a":"amPmMarker","H":"hour0_23","k":"hour1_24","K":"hour0_11","h":"hour1_12","m":"minute","s":"second","S":"fractionalsecond","z":"timezoneGeneral","Z":"timezoneRFC822","X":"timezoneISO8601"};D.prototype.format=function(j,u){if(u===undefined){u=this.oFormatOptions.UTC;}if(!j||isNaN(j.getTime())){return"";}if(this.oFormatOptions.relative){var r=this.formatRelative(j,u,this.oFormatOptions.relativeRange);if(r){return r;}}var c=this.oFormatOptions.calendarType;var d=U.getInstance(j,c);var b=[],p,c=this.oFormatOptions.calendarType,e=u?d.getUTCDay():d.getDay(),f=u?d.getUTCDate():d.getDate(),m=u?d.getUTCMonth():d.getMonth(),y=u?d.getUTCFullYear():d.getFullYear(),E=u?d.getUTCEra():d.getEra(),w=u?d.getUTCWeek():d.getWeek(),W=w.week,g=w.year,M=u?d.getUTCMilliseconds():d.getMilliseconds(),s=u?d.getUTCSeconds():d.getSeconds(),h=u?d.getUTCMinutes():d.getMinutes(),H=u?d.getUTCHours():d.getHours(),t=Math.abs(d.getTimezoneOffset()),P=d.getTimezoneOffset()>0,k=Math.floor(t/60),n=t%60,Q=Math.floor(m/3),Y,o,v,x,R,F=this.oLocaleData.getFirstDayOfWeek(),z;for(var i=0;i<this.aFormatArray.length;i++){p=this.aFormatArray[i];switch(p.type){case"text":b.push(p.value);break;case"day":b.push(q.sap.padLeft(String(f),"0",p.digits));break;case"dayNameInWeek":if(p.digits<4){b.push(this.aDaysAbbrev[e]);}else if(p.digits==4){b.push(this.aDaysWide[e]);}else if(p.digits==5){b.push(this.aDaysNarrow[e]);}else{b.push(this.aDaysShort[e]);}break;case"dayNameInWeekStandalone":if(p.digits<4){b.push(this.aDaysAbbrevSt[e]);}else if(p.digits==4){b.push(this.aDaysWideSt[e]);}else if(p.digits==5){b.push(this.aDaysNarrowSt[e]);}else{b.push(this.aDaysShortSt[e]);}break;case"dayNumberOfWeek":z=e-(F-1);if(z<=0){z+=7;}b.push(z);break;case"month":if(p.digits==3){b.push(this.aMonthsAbbrev[m]);}else if(p.digits==4){b.push(this.aMonthsWide[m]);}else if(p.digits>4){b.push(this.aMonthsNarrow[m]);}else{b.push(q.sap.padLeft(String(m+1),"0",p.digits));}break;case"monthStandalone":if(p.digits==3){b.push(this.aMonthsAbbrevSt[m]);}else if(p.digits==4){b.push(this.aMonthsWideSt[m]);}else if(p.digits>4){b.push(this.aMonthsNarrowSt[m]);}else{b.push(q.sap.padLeft(String(m+1),"0",p.digits));}break;case"quarter":if(p.digits==3){b.push(this.aQuartersAbbrev[Q]);}else if(p.digits==4){b.push(this.aQuartersWide[Q]);}else if(p.digits>4){b.push(this.aQuartersNarrow[Q]);}else{b.push(q.sap.padLeft(String(Q+1),"0",p.digits));}break;case"quarterStandalone":if(p.digits==3){b.push(this.aQuartersAbbrevSt[Q]);}else if(p.digits==4){b.push(this.aQuartersWideSt[Q]);}else if(p.digits>4){b.push(this.aQuartersNarrowSt[Q]);}else{b.push(q.sap.padLeft(String(Q+1),"0",p.digits));}break;case"era":if(p.digits<=3){b.push(this.aErasAbbrev[E]);}else if(p.digits===4){b.push(this.aErasWide[E]);}else{b.push(this.aErasNarrow[E]);}break;case"year":Y=""+y;if(p.digits==2&&Y.length>2){Y=Y.substr(Y.length-2);}if(c!=C.Japanese&&p.digits==1&&y<100){Y=q.sap.padLeft(Y,"0",4);}b.push(q.sap.padLeft(Y,"0",p.digits));break;case"weekYear":o=""+g;if(p.digits==2&&o.length>2){o=o.substr(o.length-2);}if(c!=C.Japanese&&p.digits==1&&g<100){o=q.sap.padLeft(o,"0",4);}b.push(q.sap.padLeft(o,"0",p.digits));break;case"weekInYear":v=String(W+1);if(p.digits<3){v=q.sap.padLeft(v,"0",p.digits);}else{v=this.oLocaleData.getCalendarWeek(p.digits===3?"narrow":"wide",q.sap.padLeft(v,"0",2));}b.push(v);break;case"hour0_23":b.push(q.sap.padLeft(String(H),"0",p.digits));break;case"hour1_24":if(H==0){x="24";}else{x=String(H);}b.push(q.sap.padLeft(x,"0",p.digits));break;case"hour0_11":if(H>11){x=String(H-12);}else{x=String(H);}b.push(q.sap.padLeft(x,"0",p.digits));break;case"hour1_12":if(H>12){x=String(H-12);}else if(H==0){x="12";}else{x=String(H);}b.push(q.sap.padLeft(x,"0",p.digits));break;case"minute":b.push(q.sap.padLeft(String(h),"0",p.digits));break;case"second":b.push(q.sap.padLeft(String(s),"0",p.digits));break;case"fractionalsecond":var A=String(M),B=q.sap.padLeft(A,"0",3);B=B.substr(0,p.digits);B=q.sap.padRight(B,"0",p.digits);b.push(B);break;case"amPmMarker":var G=H<12?0:1;b.push(this.aDayPeriods[G]);break;case"timezoneGeneral":if(p.digits>3&&d.getTimezoneLong()){b.push(d.getTimezoneLong());break;}else if(d.getTimezoneShort()){b.push(d.getTimezoneShort());break;}b.push("GMT");case"timezoneISO8601":if(!u&&t!=0){b.push(P?"-":"+");b.push(q.sap.padLeft(String(k),"0",2));b.push(":");b.push(q.sap.padLeft(String(n),"0",2));}else{b.push("Z");}break;case"timezoneRFC822":if(!u&&t!=0){b.push(P?"-":"+");b.push(q.sap.padLeft(String(k),"0",2));b.push(q.sap.padLeft(String(n),"0",2));}break;}}R=b.join("");if(sap.ui.getCore().getConfiguration().getOriginInfo()){R=new String(R);R.originInfo={source:"Common Locale Data Repository",locale:this.oLocale.toString(),style:this.oFormatOptions.style,pattern:this.oFormatOptions.pattern};}return R;};D.prototype.parse=function(v,u,s){if(u===undefined){u=this.oFormatOptions.UTC;}if(s===undefined){s=this.oFormatOptions.strictParsing;}var d,I=0,b=null,m=null,y=null,w=null,W=null,c=null,e=null,h=null,M=null,S=null,f=null,Q=null,p,P,g,t=null,V=true,F,k,n=this.aErasWide.length-1,r=this.oRequiredParts,o=this.oFormatOptions.calendarType,x=[this.aDaysWide,this.aDaysWideSt,this.aDaysAbbrev,this.aDaysAbbrevSt,this.aDaysShort,this.aDaysShortSt,this.aDaysNarrow,this.aDaysNarrowSt],z=[this.aMonthsWide,this.aMonthsWideSt,this.aMonthsAbbrev,this.aMonthsAbbrevSt,this.aMonthsNarrow,this.aMonthsNarrowSt],A=[this.aQuartersWide,this.aQuartersWideSt,this.aQuartersAbbrev,this.aQuartersAbbrevSt,this.aQuartersNarrow,this.aQuartersNarrowSt],E=[this.aErasWide,this.aErasAbbrev,this.aErasNarrow];function B(j){return j>=48&&j<=57;}function G(j){var g1=0;while(g1<j&&B(v.charCodeAt(I+g1))){g1++;}return v.substr(I,g1);}function H(g1){var h1=-1,i1=0;for(var j=0;j<g1.length;j++){if(g1[j]&&g1[j].length>i1&&v.indexOf(g1[j],I)==I){h1=j;i1=g1[j].length;}}return{index:h1,value:h1===-1?null:g1[h1]};}function J(j){var g1=v.charAt(I)=="+"?-1:1;I++;g=G(2);var h1=parseInt(g,10);I=I+2;if(j){I++;}g=G(2);I=I+2;t=parseInt(g,10);t=(t+60*h1)*g1;}function K(j,g1){if(j in r&&g1){V=false;}}function N(j){F=H(j);if(F.index!==-1){I+=F.value.length;return true;}}v=q.trim(v);var O=this.parseRelative(v,u);if(O){return O;}for(var i=0;i<this.aFormatArray.length;i++){P=this.aFormatArray[i];switch(P.type){case"text":if(v.indexOf(P.value,I)==I){I+=P.value.length;}else{K(P.type,this.aFormatArray[i+1].type in r);}break;case"day":g=G(Math.max(P.digits,2));K(P.type,g==="");I+=g.length;b=parseInt(g,10);if(s&&(b>31||b<1)){V=false;}break;case"dayNameInWeek":case"dayNameInWeekStandalone":x.some(N);break;case"dayNumberOfWeek":g=G(P.digits);I+=g.length;c=parseInt(g,10);break;case"month":case"monthStandalone":if(P.digits<3){g=G(Math.max(P.digits,2));K(P.type,g==="");m=parseInt(g,10)-1;I+=g.length;if(s&&(m>11||m<0)){V=false;}}else{k=z.some(N);if(k){m=F.index;}else{K(P.type,true);}}break;case"quarter":case"quarterStandalone":if(P.digits<3){g=G(Math.max(P.digits,2));K(P.type,g==="");Q=parseInt(g,10)-1;I+=g.length;if(s&&Q>3){V=false;}}else{k=A.some(N);if(k){Q=F.index;}else{K(P.type,true);}}break;case"era":k=E.some(N);if(k){e=F.index;}else{K(P.type,true);e=n;}break;case"year":if(P.digits==1){g=G(4);}else if(P.digits==2){g=G(2);}else{g=G(P.digits);}I+=g.length;K(P.type,g==="");y=parseInt(g,10);if(o!=C.Japanese&&g.length<=2){var R=U.getInstance(new Date(),o),T=R.getFullYear(),X=Math.floor(T/100),Y=X*100+y-T;if(Y<-70){y+=(X+1)*100;}else if(Y<30){y+=X*100;}else{y+=(X-1)*100;}}break;case"weekYear":if(P.digits==1){g=G(4);}else if(P.digits==2){g=G(2);}else{g=G(P.digits);}I+=g.length;K(P.type,g==="");y=parseInt(g,10);if(o!=C.Japanese&&g.length<=2){var R=U.getInstance(new Date(),o),T=R.getFullYear(),X=Math.floor(T/100),Y=X*100+w-T;if(Y<-70){w+=(X+1)*100;}else if(Y<30){w+=X*100;}else{w+=(X-1)*100;}}break;case"weekInYear":if(P.digits<3){g=G(2);W=parseInt(g,10)-1;I+=g.length;K(P.type,!g);}else{g=this.oLocaleData.getCalendarWeek(P.digits===3?"narrow":"wide");g=g.replace("{0}","[0-9]+");var Z=new RegExp(g),$=Z.exec(v.substring(I));if($){I+=$[0].length;W=parseInt($[0],10)-1;}else{K(P.type,true);}}break;case"hour0_23":g=G(Math.max(P.digits,2));K(P.type,g==="");I+=g.length;h=parseInt(g,10);if(s&&h>23){V=false;}break;case"hour1_24":g=G(Math.max(P.digits,2));K(P.type,g==="");I+=g.length;h=parseInt(g,10);if(h==24){h=0;}if(s&&h>23){V=false;}break;case"hour0_11":g=G(Math.max(P.digits,2));K(P.type,g==="");I+=g.length;h=parseInt(g,10);if(s&&h>11){V=false;}break;case"hour1_12":g=G(Math.max(P.digits,2));K(P.type,g==="");I+=g.length;h=parseInt(g,10);if(h==12){h=0;p=(p===undefined)?true:p;}if(s&&h>11){V=false;}break;case"minute":g=G(Math.max(P.digits,2));K(P.type,g==="");I+=g.length;M=parseInt(g,10);if(s&&M>59){V=false;}break;case"second":g=G(Math.max(P.digits,2));K(P.type,g==="");I+=g.length;S=parseInt(g,10);if(s&&S>59){V=false;}break;case"fractionalsecond":g=G(P.digits);I+=g.length;g=g.substr(0,3);g=q.sap.padRight(g,"0",3);f=parseInt(g,10);break;case"amPmMarker":var _=this.aDayPeriods[0],a1=this.aDayPeriods[1];var b1=/[aApP](?:\.)?[mM](?:\.)?/;var c1=v.substring(I);var d1=c1.match(b1);var e1=(d1&&d1.index===0);if(e1){c1=d1[0].replace(/\./g,"").toLowerCase()+c1.substring(d1[0].length);_=_.toLowerCase();a1=a1.toLowerCase();}if(c1.indexOf(_)==0){p=false;I+=(e1?d1[0].length:_.length);}else if(c1.indexOf(a1)==0){p=true;I+=(e1?d1[0].length:a1.length);}break;case"timezoneGeneral":var f1=v.substring(I,I+3);if(f1==="GMT"||f1==="UTC"){I=I+3;}else if(v.substring(I,I+2)==="UT"){I=I+2;}else if(v.charAt(I)=="Z"){I=I+1;t=0;break;}else{q.sap.log.error(v+" cannot be parsed correcly by sap.ui.core.format.DateFormat: The given timezone is not supported!");break;}case"timezoneISO8601":if(v.charAt(I)=="Z"){I=I+1;t=0;break;}J(true);break;case"timezoneRFC822":J(false);break;}if(!V){break;}}if(I<v.length){V=false;}if(p){h+=12;}if(Q!==null&&m===null&&b===null){m=3*Q;b=1;}if(V){if(u||t!=null){d=U.getInstance(new Date(0),o);d.setUTCEra(e||U.getCurrentEra(o));d.setUTCFullYear(y||1970);d.setUTCMonth(m||0);d.setUTCDate(b||1);d.setUTCHours(h||0);d.setUTCMinutes(M||0);d.setUTCSeconds(S||0);d.setUTCMilliseconds(f||0);if(s&&(b||1)!==d.getUTCDate()){V=false;d=undefined;}else{if(t){d.setUTCMinutes((M||0)+t);}if(W!==null){d.setUTCWeek({year:w||y,week:W});if(c!==null){d.setUTCDate(d.getUTCDate()+c-1);}}}}else{d=U.getInstance(new Date(1970,0,1,0,0,0),o);d.setEra(e||U.getCurrentEra(o));d.setFullYear(y||1970);d.setMonth(m||0);d.setDate(b||1);d.setHours(h||0);d.setMinutes(M||0);d.setSeconds(S||0);d.setMilliseconds(f||0);if(s&&(b||1)!==d.getDate()){V=false;d=undefined;}else if(W!==null){d.setWeek({year:w||y,week:W});if(c!==null){d.setDate(d.getDate()+c-1);}}}if(V){d=d.getJSDate();return d;}}if(!this.bIsFallback){q.each(this.aFallbackFormats,function(i,j){d=j.parse(v,u,s);if(d){return false;}});return d;}return null;};D.prototype.parseCldrDatePattern=function(p){var f=[],i,Q=false,c=null,s="",n="";for(i=0;i<p.length;i++){var b=p.charAt(i),N,P,d;if(Q){if(b=="'"){P=p.charAt(i-1);d=p.charAt(i-2);N=p.charAt(i+1);if(P=="'"&&d!="'"){Q=false;}else if(N=="'"){i+=1;}else{Q=false;continue;}}if(s=="text"){c.value+=b;}else{c={type:"text",value:b};f.push(c);s="text";}}else{if(b=="'"){Q=true;}else if(this.oSymbols[b]){n=this.oSymbols[b];if(s==n){c.digits++;}else{c={type:n,digits:1};f.push(c);s=n;}}else{if(s=="text"){c.value+=b;}else{c={type:"text",value:b};f.push(c);s="text";}}}}return f;};D.prototype.parseRelative=function(v,u){var p,e,r,R,V;if(!v){return null;}p=this.oLocaleData.getRelativePatterns(this.aRelativeParseScales,this.oFormatOptions.relativeStyle);for(var i=0;i<p.length;i++){e=p[i];r=new RegExp("^\\s*"+e.pattern.replace(/\{0\}/,"(\\d+)")+"\\s*$","i");R=r.exec(v);if(R){if(e.value!==undefined){return c(e.value,e.scale);}else{V=parseInt(R[1],10);return c(V*e.sign,e.scale);}}}function c(d,s){var t,T=new Date(),j;if(u){t=T.getTime();}else{t=Date.UTC(T.getFullYear(),T.getMonth(),T.getDate(),T.getHours(),T.getMinutes(),T.getSeconds(),T.getMilliseconds());}j=new Date(t);switch(s){case"second":j.setUTCSeconds(j.getUTCSeconds()+d);break;case"minute":j.setUTCMinutes(j.getUTCMinutes()+d);break;case"hour":j.setUTCHours(j.getUTCHours()+d);break;case"day":j.setUTCDate(j.getUTCDate()+d);break;case"week":j.setUTCDate(j.getUTCDate()+d*7);break;case"month":j.setUTCMonth(j.getUTCMonth()+d);break;case"quarter":j.setUTCMonth(j.getUTCMonth()+d*3);break;case"year":j.setUTCFullYear(j.getUTCFullYear()+d);break;}if(u){return j;}else{return new Date(j.getUTCFullYear(),j.getUTCMonth(),j.getUTCDate(),j.getUTCHours(),j.getUTCMinutes(),j.getUTCSeconds(),j.getUTCMilliseconds());}}};D.prototype.formatRelative=function(j,u,r){var t=new Date(),s=this.oFormatOptions.relativeScale||"day",T,d,i,p,b;b=(j.getTime()-t.getTime())/1000;if(this.oFormatOptions.relativeScale=="auto"){s=this._getScale(b,this.aRelativeScales);}if(!r){r=this._mRanges[s];}if(s=="year"||s=="month"||s=="day"){T=Date.UTC(t.getFullYear(),t.getMonth(),t.getDate());if(u){d=Date.UTC(j.getUTCFullYear(),j.getUTCMonth(),j.getUTCDate());}else{d=Date.UTC(j.getFullYear(),j.getMonth(),j.getDate());}b=(d-T)/1000;}i=this._getDifference(s,b);if(this.oFormatOptions.relativeScale!="auto"&&(i<r[0]||i>r[1])){return null;}p=this.oLocaleData.getRelativePattern(s,i,b>0,this.oFormatOptions.relativeStyle);return q.sap.formatMessage(p,[Math.abs(i)]);};D.prototype._mRanges={second:[-60,60],minute:[-60,60],hour:[-24,24],day:[-6,6],week:[-4,4],month:[-12,12],year:[-10,10]};D.prototype._mScales={second:1,minute:60,hour:3600,day:86400,week:604800,month:2592000,quarter:7776000,year:31536000};D.prototype._getScale=function(d,s){var S,t;d=Math.abs(d);for(var i=0;i<s.length;i++){t=s[i];if(d>=this._mScales[t]){S=t;break;}}if(!S){S=s[s.length-1];}return S;};D.prototype._getDifference=function(s,d){var S=this._mScales[s],i=d/S;if(d>0){i=Math.floor(i);}else{i=Math.ceil(i);}return i;};D.prototype.getAllowedCharacters=function(f){if(this.oFormatOptions.relative){return"";}var A="";var n=false;var b=false;var p;for(var i=0;i<this.aFormatArray.length;i++){p=this.aFormatArray[i];switch(p.type){case"text":if(A.indexOf(p.value)<0){A+=p.value;}break;case"day":case"year":case"weekYear":case"dayNumberOfWeek":case"weekInYear":case"hour0_23":case"hour1_24":case"hour0_11":case"hour1_12":case"minute":case"second":case"fractionalsecond":if(!n){A+="0123456789";n=true;}break;case"month":case"monthStandalone":if(p.digits<3){if(!n){A+="0123456789";n=true;}}else{b=true;}break;default:b=true;break;}}if(b){A="";}return A;};return D;},true);
