/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["jquery.sap.global","sap/ui/model/Binding","sap/ui/model/ChangeReason","sap/ui/model/FilterType","sap/ui/model/ListBinding","sap/ui/model/odata/OperationMode","./_ODataHelper","./Context","./lib/_Cache","./lib/_Helper","./lib/_SyncPromise"],function(q,B,C,F,L,O,_,a,b,c,d){"use strict";var s="sap.ui.model.odata.v4.ODataListBinding",S={change:true,dataReceived:true,dataRequested:true,refresh:true},U={};var e=L.extend("sap.ui.model.odata.v4.ODataListBinding",{constructor:function(m,p,o,v,f,P){var g,h;L.call(this,m,p);if(!p||p.slice(-1)==="/"){throw new Error("Invalid path: "+p);}g=_.buildBindingParameters(P,["$$groupId","$$operationMode","$$updateGroupId"]);this.sGroupId=g.$$groupId;this.sOperationMode=g.$$operationMode||m.sOperationMode;this.sUpdateGroupId=g.$$updateGroupId;if(!this.sOperationMode&&(v||f)){throw new Error("Unsupported operation mode: "+this.sOperationMode);}this.aApplicationFilters=_.toArray(f);this.oCache=undefined;this.sChangeReason=undefined;this.oDiff=U;this.aFilters=[];this.mPreviousContextsByPath={};this.aPreviousData=[];this.mQueryOptions=undefined;this.sRefreshGroupId=undefined;this.aSorters=_.toArray(v);if(!this.bRelative||o&&!o.getBinding||P){this.mQueryOptions=_.buildQueryOptions(m.mUriParameters,P,_.aAllowedSystemQueryOptions);}if(!this.bRelative){if(this.aApplicationFilters.length>0){this.oCache=_.createListCacheProxy(this);}else{h=_.buildOrderbyOption(this.aSorters,this.mQueryOptions&&this.mQueryOptions.$orderby);this.oCache=b.create(m.oRequestor,p.slice(1),_.mergeQueryOptions(this.mQueryOptions,h));}}this.reset();this.setContext(o);m.bindingCreated(this);}});e.prototype._delete=function(g,E,o){var t=this;if(!o.isTransient()&&this.hasPendingChanges()){throw new Error("Cannot delete due to pending changes");}return this.deleteFromCache(g,E,String(o.iIndex),function(I){var i,n;if(I===-1){o.destroy();delete t.aContexts[-1];}else{for(i=I;i<t.aContexts.length;i+=1){o=t.aContexts[i];n=t.aContexts[i+1];if(o&&!n){o.destroy();delete t.aContexts[i];}else if(!o&&n){t.aContexts[i]=a.create(t.oModel,t,t.sPath+"/"+i,i);}else if(!t.bUseExtendedChangeDetection){o.checkUpdate();}}t.aContexts.pop();t.iMaxLength-=1;}t._fireChange({reason:C.Remove});});};e.prototype.attachEvent=function(E){if(!(E in S)){throw new Error("Unsupported event '"+E+"': v4.ODataListBinding#attachEvent");}return L.prototype.attachEvent.apply(this,arguments);};e.prototype.checkUpdate=function(){var t=this;function u(){t._fireChange({reason:C.Change});t.oModel.getDependentBindings(t).forEach(function(D){D.checkUpdate();});}if(arguments.length>0){throw new Error("Unsupported operation: v4.ODataListBinding#checkUpdate "+"must not be called with parameters");}if(this.oCache&&this.bRelative&&this.oContext.fetchCanonicalPath){this.oContext.fetchCanonicalPath().then(function(f){if(t.oCache.$canonicalPath!==f){t.refreshInternal();}else{u();}})["catch"](function(E){t.oModel.reportError("Failed to update "+t,s,E);});}else{u();}};e.prototype.create=function(i){var o,f,r,t=this;if(this.aContexts[-1]){throw new Error("Must not create twice");}if(!this.oCache){throw new Error("Create on this binding is not supported");}r=this.oModel.resolve(this.sPath,this.oContext);f=r.slice(1);o=a.create(this.oModel,this,r+"/-1",-1,this.oCache.create(this.getUpdateGroupId(),f,"",i,function(){o.destroy();delete t.aContexts[-1];t._fireChange({reason:C.Remove});},function(E){t.oModel.reportError("POST on '"+f+"' failed; will be repeated automatically",s,E);}));this.aContexts[-1]=o;this._fireChange({reason:C.Add});return o;};e.prototype.createContexts=function(r,R){var f=false,o=this.oContext,i,n,m=this.oModel,p=m.resolve(this.sPath,o),P,t=this;for(i=r.start;i<r.start+R;i+=1){if(this.aContexts[i]===undefined){f=true;P=p+"/"+i;if(P in this.mPreviousContextsByPath){this.aContexts[i]=this.mPreviousContextsByPath[P];delete this.mPreviousContextsByPath[P];this.aContexts[i].checkUpdate();}else{this.aContexts[i]=a.create(m,this,P,i);}}}if(Object.keys(this.mPreviousContextsByPath).length){sap.ui.getCore().addPrerenderingTask(function(){Object.keys(t.mPreviousContextsByPath).forEach(function(p){t.mPreviousContextsByPath[p].destroy();delete t.mPreviousContextsByPath[p];});});}if(this.aContexts.length>this.iMaxLength){this.iMaxLength=Infinity;}if(R<r.length){this.iMaxLength=r.start+R;if(this.aContexts.length>this.iMaxLength){this.aContexts.length=this.iMaxLength;}}n=this.aContexts.length===this.iMaxLength;if(this.bLengthFinal!==n){this.bLengthFinal=n;f=true;}return f;};e.prototype.deleteFromCache=function(g,E,p,f){var P;if(this.oCache){g=g||this.getUpdateGroupId();if(g!=="$auto"&&g!=="$direct"){throw new Error("Illegal update group ID: "+g);}P=this.oCache._delete(g,E,p,f);return P;}return this.oContext.getBinding().deleteFromCache(g,E,c.buildPath(this.oContext.iIndex,this.sPath,p),f);};e.prototype.deregisterChange=function(p,l,i){if(this.oCache){this.oCache.deregisterChange(i,p,l);}else if(this.oContext){this.oContext.deregisterChange(c.buildPath(this.sPath,i,p),l);}};e.prototype.destroy=function(){this.aContexts.forEach(function(o){o.destroy();});if(this.aContexts[-1]){this.aContexts[-1].destroy();}this.oModel.bindingDestroyed(this);L.prototype.destroy.apply(this);};e.prototype.enableExtendedChangeDetection=function(D,k){if(k!==undefined){throw new Error("Unsupported property 'key' with value '"+k+"' in binding info for "+this);}return L.prototype.enableExtendedChangeDetection.apply(this,arguments);};e.prototype.fetchAbsoluteValue=function(p){var i,P,r;if(this.oCache){r=this.oModel.resolve(this.sPath,this.oContext)+"/";if(p.lastIndexOf(r)===0){p=p.slice(r.length);i=parseInt(p,10);P=p.indexOf("/");p=P>0?p.slice(P+1):"";return this.fetchValue(p,undefined,i);}}if(this.oContext&&this.oContext.fetchAbsoluteValue){return this.oContext.fetchAbsoluteValue(p);}return d.resolve();};e.prototype.fetchValue=function(p,l,i){if(this.oCache){return this.oCache.read(i,1,undefined,p,undefined,l);}if(this.oContext){return this.oContext.fetchValue(c.buildPath(this.sPath,i,p),l);}return d.resolve();};e.prototype.filter=function(f,g){if(this.sOperationMode!==O.Server){throw new Error("Operation mode has to be sap.ui.model.odata.OperationMode.Server");}if(this.hasPendingChanges()){throw new Error("Cannot filter due to pending changes");}if(g===F.Control){this.aFilters=_.toArray(f);}else{this.aApplicationFilters=_.toArray(f);}this.mCacheByContext=undefined;this.oCache=_.createListCacheProxy(this,this.oContext);this.reset(C.Filter);return this;};e.prototype.getContexts=function(i,l,m){var f,o=this.oContext,g,D=false,h=false,G,p,r,R=!!this.sChangeReason,j,t=this;q.sap.log.debug(this+"#getContexts("+i+", "+l+", "+m+")",undefined,s);if(i!==0&&this.bUseExtendedChangeDetection){throw new Error("Unsupported operation: v4.ODataListBinding#getContexts,"+" first parameter must be 0 if extended change detection is enabled, but is "+i);}if(m!==undefined&&this.bUseExtendedChangeDetection){throw new Error("Unsupported operation: v4.ODataListBinding#getContexts,"+" third parameter must not be set if extended change detection is enabled");}if(this.bRelative&&!o){return[];}f=this.sChangeReason||C.Change;this.sChangeReason=undefined;i=i||0;l=l||this.oModel.iSizeLimit;if(!m||m<0){m=0;}j=this.aContexts[-1]?i-1:i;if(!this.bUseExtendedChangeDetection||this.oDiff===U){r=_.getReadRange(this.aContexts,j,l,m);if(this.oCache){G=this.sRefreshGroupId||this.getGroupId();this.sRefreshGroupId=undefined;p=this.oCache.read(r.start,r.length,G,undefined,function(){D=true;t.fireDataRequested();});}else{p=o.fetchValue(this.sPath).then(function(k){return k.slice(r.start,r.start+r.length);});}p.then(function(v){var k,n;if(!t.bRelative||t.oContext===o){k=v&&(Array.isArray(v)?v:v.value);n=k?k.length:0;return _.fetchDiff(t,k,i,l).then(function(u){return R&&!h?Promise.resolve(u):u;}).then(function(u){t.oDiff=u;if(t.createContexts(r,n)&&h){t._fireChange({reason:f});}if(D){t.fireDataReceived();}});}else if(D){t.fireDataReceived();}},function(E){if(D){t.oModel.reportError("Failed to get contexts for "+t.oModel.sServiceUrl+t.oModel.resolve(t.sPath,t.oContext).slice(1)+" with start index "+i+" and length "+l,s,E);t.fireDataReceived(E.canceled?undefined:{error:E});}})["catch"](function(E){q.sap.log.error(E.message,E.stack,s);});h=true;}this.iCurrentBegin=j;this.iCurrentEnd=j+l;if(j===-1){g=this.aContexts.slice(0,j+l);g.unshift(this.aContexts[-1]);}else{g=this.aContexts.slice(j,j+l);}if(this.bUseExtendedChangeDetection&&this.oDiff){if(this.oDiff!==U&&l!==this.oDiff.iLength){throw new Error("Extended change detection protocol violation: Expected "+"getContexts(0,"+this.oDiff.iLength+"), but got getContexts(0,"+l+")");}g.dataRequested=this.oDiff===U;g.diff=this.oDiff!==U?this.oDiff.aDiff:[];}this.oDiff=U;return g;};e.prototype.getCurrentContexts=function(){var f,l=Math.min(this.iCurrentEnd,this.iMaxLength)-this.iCurrentBegin;if(this.iCurrentBegin===-1){f=this.aContexts.slice(0,this.iCurrentBegin+l);f.unshift(this.aContexts[-1]);}else{f=this.aContexts.slice(this.iCurrentBegin,this.iCurrentBegin+l);}while(f.length<l){f.push(undefined);}return f;};e.prototype.getDistinctValues=function(){throw new Error("Unsupported operation: v4.ODataListBinding#getDistinctValues");};e.prototype.getGroupId=function(){return this.sGroupId||(this.bRelative&&this.oContext&&this.oContext.getGroupId&&this.oContext.getGroupId())||this.oModel.getGroupId();};e.prototype.getLength=function(){var l=this.aContexts.length;if(this.aContexts[-1]){l+=1;}if(!this.bLengthFinal){l+=10;}return l;};e.prototype.getUpdateGroupId=function(){return this.sUpdateGroupId||(this.bRelative&&this.oContext&&this.oContext.getUpdateGroupId&&this.oContext.getUpdateGroupId())||this.oModel.getUpdateGroupId();};e.prototype.hasPendingChanges=function(){return _.hasPendingChanges(this,true);};e.prototype.initialize=function(){if(!this.bRelative||this.oContext){this._fireChange({reason:C.Change});}};e.prototype.isInitial=function(){throw new Error("Unsupported operation: v4.ODataListBinding#isInitial");};e.prototype.isLengthFinal=function(){return this.bLengthFinal;};e.prototype.refresh=function(g){if(!_.isRefreshable(this)){throw new Error("Refresh on this binding is not supported");}if(this.hasPendingChanges()){throw new Error("Cannot refresh due to pending changes");}_.checkGroupId(g);this.refreshInternal(g);};e.prototype.refreshInternal=function(g){this.sRefreshGroupId=g;if(this.oCache){if(this.bRelative&&this.oContext.getBinding){this.oCache=_.createListCacheProxy(this,this.oContext);this.mCacheByContext=undefined;}else{this.oCache.refresh();}}this.reset(C.Refresh);this.oModel.getDependentBindings(this).forEach(function(D){if(!D.getContext().created()){D.refreshInternal(g);}});};e.prototype.reset=function(f){var t=this;if(this.aContexts){this.aContexts.forEach(function(o){t.mPreviousContextsByPath[o.getPath()]=o;});}this.aContexts=[];this.iCurrentBegin=this.iCurrentEnd=0;this.iMaxLength=Infinity;this.bLengthFinal=false;if(f){this.sChangeReason=f;this._fireRefresh({reason:f});}};e.prototype.resetChanges=function(){_.resetChanges(this,true);};e.prototype.resume=function(){throw new Error("Unsupported operation: v4.ODataListBinding#resume");};e.prototype.setContext=function(o){if(this.oContext!==o){if(this.bRelative){this.reset();if(this.oCache){this.oCache.deregisterChange();this.oCache=undefined;}if(o){this.oCache=_.createListCacheProxy(this,o);}B.prototype.setContext.call(this,o);}else{this.oContext=o;}}};e.prototype.sort=function(v){if(this.sOperationMode!==O.Server){throw new Error("Operation mode has to be sap.ui.model.odata.OperationMode.Server");}if(this.hasPendingChanges()){throw new Error("Cannot sort due to pending changes");}this.aSorters=_.toArray(v);this.mCacheByContext=undefined;this.oCache=_.createListCacheProxy(this,this.oContext);this.reset(C.Sort);return this;};e.prototype.suspend=function(){throw new Error("Unsupported operation: v4.ODataListBinding#suspend");};e.prototype.toString=function(){return s+": "+(this.bRelative?this.oContext+"|":"")+this.sPath;};e.prototype.updateValue=function(g,p,v,E,P){var o;if(this.oCache){g=g||this.getUpdateGroupId();o=this.oCache.update(g,p,v,E,P);return o;}return this.oContext.updateValue(g,p,v,E,c.buildPath(this.sPath,P));};return e;},true);
