/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["jquery.sap.global","sap/ui/core/message/Message","sap/ui/model/BindingMode","sap/ui/model/Context","sap/ui/model/Model","sap/ui/model/odata/OperationMode","sap/ui/thirdparty/URI","./_ODataHelper","./lib/_MetadataRequestor","./lib/_Requestor","./ODataContextBinding","./ODataListBinding","./ODataMetaModel","./ODataPropertyBinding"],function(q,M,B,a,b,O,U,_,c,d,e,f,g,h){"use strict";var C="sap.ui.model.odata.v4.ODataModel",s={messageChange:true},S={annotationURI:true,groupId:true,operationMode:true,serviceUrl:true,synchronizationMode:true,updateGroupId:true};var i=b.extend("sap.ui.model.odata.v4.ODataModel",{constructor:function(p){var H={"Accept-Language":sap.ui.getCore().getConfiguration().getLanguageTag()},P,j,u,t=this;b.apply(this);if(!p||p.synchronizationMode!=="None"){throw new Error("Synchronization mode must be 'None'");}for(P in p){if(!(P in S)){throw new Error("Unsupported parameter: "+P);}}j=p.serviceUrl;if(!j){throw new Error("Missing service root URL");}u=new U(j);if(u.path()[u.path().length-1]!=="/"){throw new Error("Service root URL must end with '/'");}if(p.operationMode&&p.operationMode!==O.Server){throw new Error("Unsupported operation mode: "+p.operationMode);}this.sOperationMode=p.operationMode;this.mUriParameters=_.buildQueryOptions(null,u.query(true),null,true);this.sServiceUrl=u.query("").toString();this.sGroupId=p.groupId;if(this.sGroupId===undefined){this.sGroupId="$auto";}if(this.sGroupId!=="$auto"&&this.sGroupId!=="$direct"){throw new Error("Group ID must be '$auto' or '$direct'");}_.checkGroupId(p.updateGroupId,false,"Invalid update group ID: ");this.sUpdateGroupId=p.updateGroupId||this.getGroupId();this.oMetaModel=new g(c.create(H,this.mUriParameters),this.sServiceUrl+"$metadata",p.annotationURI);this.oRequestor=d.create(this.sServiceUrl,H,this.mUriParameters,function(G){if(G==="$auto"){sap.ui.getCore().addPrerenderingTask(t._submitBatch.bind(t,G));}});this.aAllBindings=[];this.sDefaultBindingMode=B.TwoWay;this.mSupportedBindingModes={OneTime:true,OneWay:true,TwoWay:true};}});i.prototype._submitBatch=function(G){return this.oRequestor.submitBatch(G)["catch"](function(E){q.sap.log.error("$batch failed",E.message,C);throw E;});};i.prototype.attachEvent=function(E){if(!(E in s)){throw new Error("Unsupported event '"+E+"': v4.ODataModel#attachEvent");}return b.prototype.attachEvent.apply(this,arguments);};i.prototype.bindContext=function(p,o,P){return new e(this,p,o,P);};i.prototype.bindingCreated=function(o){this.aAllBindings.push(o);};i.prototype.bindingDestroyed=function(o){var I=this.aAllBindings.indexOf(o);if(I<0){throw new Error("Unknown "+o);}this.aAllBindings.splice(I,1);};i.prototype.bindList=function(p,o,v,F,P){return new f(this,p,o,v,F,P);};i.prototype.bindProperty=function(p,o,P){return new h(this,p,o,P);};i.prototype.bindTree=function(){throw new Error("Unsupported operation: v4.ODataModel#bindTree");};i.prototype.createBindingContext=function(p,o){var r;if(arguments.length>2){throw new Error("Only the parameters sPath and oContext are supported");}if(o&&o.getBinding){throw new Error("Unsupported type: oContext must be of type sap.ui.model.Context, "+"but was sap.ui.model.odata.v4.Context");}r=this.resolve(p,o);if(r===undefined){throw new Error("Cannot create binding context from relative path '"+p+"' without context");}return new a(this,r);};i.prototype.destroy=function(){this.oMetaModel.destroy();return b.prototype.destroy.apply(this,arguments);};i.prototype.destroyBindingContext=function(){throw new Error("Unsupported operation: v4.ODataModel#destroyBindingContext");};i.prototype.getContext=function(){throw new Error("Unsupported operation: v4.ODataModel#getContext");};i.prototype.getDependentBindings=function(p){return this.aAllBindings.filter(function(o){return o.isRelative()&&(o.getContext()===p||o.getContext()&&o.getContext().getBinding&&o.getContext().getBinding()===p);});};i.prototype.getGroupId=function(){return this.sGroupId;};i.prototype.getMetaModel=function(){return this.oMetaModel;};i.prototype.getObject=function(){throw new Error("Unsupported operation: v4.ODataModel#getObject");};i.prototype.getOriginalProperty=function(){throw new Error("Unsupported operation: v4.ODataModel#getOriginalProperty");};i.prototype.getProperty=function(){throw new Error("Unsupported operation: v4.ODataModel#getProperty");};i.prototype.getUpdateGroupId=function(){return this.sUpdateGroupId;};i.prototype.hasPendingChanges=function(){return this.oRequestor.hasPendingChanges();};i.prototype.isList=function(){throw new Error("Unsupported operation: v4.ODataModel#isList");};i.prototype.refresh=function(G){_.checkGroupId(G);this.aBindings.slice().forEach(function(o){if(_.isRefreshable(o)){o.refresh(G);}});};i.prototype.reportError=function(l,r,E){var D=E.stack||E.message;if(D.indexOf(E.message)<0){D=E.message+"\n"+E.stack;}if(E.canceled){q.sap.log.debug(l,D,r);return;}q.sap.log.error(l,D,r);if(E.$reported){return;}E.$reported=true;sap.ui.getCore().getMessageManager().addMessages(new M({message:E.message,processor:this,technical:true,type:"Error"}));};i.prototype.requestCanonicalPath=function(E){return E.requestCanonicalPath();};i.prototype.resetChanges=function(G){G=G||this.sUpdateGroupId;_.checkGroupId(G,true);this.oRequestor.cancelChanges(G);};i.prototype.setLegacySyntax=function(){throw new Error("Unsupported operation: v4.ODataModel#setLegacySyntax");};i.prototype.submitBatch=function(G){_.checkGroupId(G,true);return this._submitBatch(G);};i.prototype.toString=function(){return C+": "+this.sServiceUrl;};return i;},true);
