/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/Device','sap/ui/core/Control','sap/ui/core/Element','sap/ui/core/IconPool','sap/ui/core/ResizeHandler','sap/ui/core/ScrollBar','sap/ui/core/delegate/ItemNavigation','sap/ui/core/theming/Parameters','sap/ui/model/ChangeReason','sap/ui/model/Context','sap/ui/model/Filter','sap/ui/model/SelectionModel','sap/ui/model/Sorter','./Column','./Row','./library','./TableUtils','./TableExtension','./TableAccExtension','./TableKeyboardExtension','./TablePointerExtension','./TableScrollExtension','jquery.sap.dom','jquery.sap.trace'],function(q,D,C,E,I,R,S,c,P,d,e,F,f,g,h,j,k,T,m,n,o,p,r){"use strict";var G=k.GroupEventType,N=k.NavigationMode,s=k.SelectionMode,t=k.SelectionBehavior,u=k.SortOrder,V=k.VisibleRowCountMode;var v=C.extend("sap.ui.table.Table",{metadata:{library:"sap.ui.table",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'auto'},rowHeight:{type:"int",group:"Appearance",defaultValue:null},columnHeaderHeight:{type:"int",group:"Appearance",defaultValue:null},columnHeaderVisible:{type:"boolean",group:"Appearance",defaultValue:true},visibleRowCount:{type:"int",group:"Appearance",defaultValue:10},firstVisibleRow:{type:"int",group:"Appearance",defaultValue:0},selectionMode:{type:"sap.ui.table.SelectionMode",group:"Behavior",defaultValue:s.MultiToggle},selectionBehavior:{type:"sap.ui.table.SelectionBehavior",group:"Behavior",defaultValue:t.RowSelector},selectedIndex:{type:"int",group:"Appearance",defaultValue:-1},editable:{type:"boolean",group:"Behavior",defaultValue:true},navigationMode:{type:"sap.ui.table.NavigationMode",group:"Behavior",defaultValue:N.Scrollbar},threshold:{type:"int",group:"Appearance",defaultValue:100},enableColumnReordering:{type:"boolean",group:"Behavior",defaultValue:true},enableGrouping:{type:"boolean",group:"Behavior",defaultValue:false},showColumnVisibilityMenu:{type:"boolean",group:"Appearance",defaultValue:false},showNoData:{type:"boolean",group:"Appearance",defaultValue:true},visibleRowCountMode:{type:"sap.ui.table.VisibleRowCountMode",group:"Appearance",defaultValue:V.Fixed},minAutoRowCount:{type:"int",group:"Appearance",defaultValue:5},fixedColumnCount:{type:"int",group:"Appearance",defaultValue:0},fixedRowCount:{type:"int",group:"Appearance",defaultValue:0},fixedBottomRowCount:{type:"int",group:"Appearance",defaultValue:0},enableColumnFreeze:{type:"boolean",group:"Behavior",defaultValue:false},enableCellFilter:{type:"boolean",group:"Behavior",defaultValue:false},showOverlay:{type:"boolean",group:"Appearance",defaultValue:false},enableSelectAll:{type:"boolean",group:"Behavior",defaultValue:true},enableCustomFilter:{type:"boolean",group:"Behavior",defaultValue:false},enableBusyIndicator:{type:"boolean",group:"Behavior",defaultValue:false}},defaultAggregation:"columns",aggregations:{title:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false},footer:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false},toolbar:{type:"sap.ui.core.Toolbar",multiple:false,deprecated:true},extension:{type:"sap.ui.core.Control",multiple:true,singularName:"extension"},columns:{type:"sap.ui.table.Column",multiple:true,singularName:"column",bindable:"bindable"},rows:{type:"sap.ui.table.Row",multiple:true,singularName:"row",bindable:"bindable"},noData:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false}},associations:{groupBy:{type:"sap.ui.table.Column",multiple:false},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{rowSelectionChange:{parameters:{rowIndex:{type:"int"},rowContext:{type:"object"},rowIndices:{type:"int[]"},selectAll:{type:"boolean"},userInteraction:{type:"boolean"}}},columnSelect:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"}}},columnResize:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},width:{type:"sap.ui.core.CSSSize"}}},columnMove:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},newPos:{type:"int"}}},sort:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},sortOrder:{type:"sap.ui.table.SortOrder"},columnAdded:{type:"boolean"}}},filter:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},value:{type:"string"}}},group:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"}}},columnVisibility:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},visible:{type:"boolean"}}},cellClick:{allowPreventDefault:true,parameters:{cellControl:{type:"sap.ui.core.Control"},cellDomRef:{type:"Object"},rowIndex:{type:"int"},columnIndex:{type:"int"},columnId:{type:"string"},rowBindingContext:{type:"sap.ui.model.Context"}}},cellContextmenu:{allowPreventDefault:true,parameters:{cellControl:{type:"sap.ui.core.Control"},cellDomRef:{type:"Object"},rowIndex:{type:"int"},columnIndex:{type:"int"},columnId:{type:"string"},rowBindingContext:{type:"sap.ui.model.Context"}}},columnFreeze:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"}}},customFilter:{column:{type:"sap.ui.table.Column"},value:{type:"string"}},firstVisibleRowChanged:{firstVisibleRow:{type:"int"}},busyStateChanged:{busy:{type:"boolean"}}},designTime:true}});I.insertFontFaceStyle();v.prototype.init=function(){this._iBaseFontSize=parseFloat(q("body").css("font-size"))||16;this._oResBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.table");this._bRtlMode=sap.ui.getCore().getConfiguration().getRTL();this._attachExtensions();this._bBindingLengthChanged=false;this._bRowAggregationInvalid=true;this._mTimeouts={};this._lastCalledUpdateRows=0;this._iBindingTimerDelay=50;this._iMaxScrollbarHeight=1000000;this._aRowHeights=[];this._iRowHeightsDelta=0;this._iRenderedFirstVisibleRow=0;var a=this;this._performUpdateRows=function(b){if(!a.bIsDestroyed){a._lastCalledUpdateRows=Date.now();a._updateBindingContexts(undefined,undefined,b);if(!a._bInvalid){a._updateTableContent();a._getAccExtension().updateAccForCurrentCell(false);a._updateSelection();a._collectTableSizes();a._aRowHeights=a._collectRowHeights(false);a._updateRowHeights(a._collectRowHeights(true),true);a._updateRowHeights(a._aRowHeights,false);if(T.isVariableRowHeightEnabled(a)){a._iRowHeightsDelta=this._getRowHeightsDelta(a._aRowHeights);a._iRenderedFirstVisibleRow=this.getFirstVisibleRow();}if(a._bBindingLengthChanged){a._updateVSbScrollTop();}a._toggleVSb();if(T.isVariableRowHeightEnabled(a)){var i=0;var l=a._getScrollExtension().getVerticalScrollbar();if(l){i=l.scrollTop;}a._adjustTablePosition(i,a._aRowHeights);}}a._mTimeouts.bindingTimer=undefined;a.fireEvent("_rowsUpdated");}a._bBindingLengthChanged=false;};this._initSelectionModel(f.MULTI_SELECTION);this._aTableHeaders=[];this._aIdxCols2Cells=[];this._bInheritEditableToControls=false;this._bAllowColumnHeaderTextSelection=false;this._iDataRequestedCounter=0;this._iBindingLength=0;this._iTableRowContentHeight=0;this._bFirstRendering=true;this._bInvalid=true;this._bIsScrollVertical=null;};v.prototype._attachExtensions=function(){if(this._bExtensionsInitialized){return;}m.enrich(this,p);m.enrich(this,r);m.enrich(this,o);m.enrich(this,n);this._bExtensionsInitialized=true;};v.prototype.exit=function(){this._bExitCalled=true;this.invalidateRowsAggregation();this._detachExtensions();this._cleanUpTimers();this._detachEvents();if(this._oSelection){this._oSelection.destroy();}delete this._aTableHeaders;};v.prototype._detachExtensions=function(){m.cleanup(this);};v.prototype.onThemeChanged=function(){if(this.getDomRef()){this.invalidate();}};v.prototype._collectRowHeights=function(H){var a=this.getDomRef();if(!a){return[];}if(H&&this.getColumnHeaderHeight()){return[];}var b=this._getDefaultRowHeight();var l=H?".sapUiTableColHdrTr":".sapUiTableTr";var w=a.querySelectorAll(".sapUiTableCtrlFixed > tbody > tr"+l);var x=a.querySelectorAll(".sapUiTableCtrlScroll > tbody > tr"+l);var y=this.getRows().length;var z=[];var A=D.browser.chrome&&window.devicePixelRatio!=1;for(var i=0;i<y;i++){var B=w[i]==null?0:w[i].getBoundingClientRect().height;var J=x[i]==null?0:x[i].getBoundingClientRect().height;var K=Math.max(B,J);if(A){var L=b-K;if(L>0&&L<1){z.push(Math.max(K,b-1));continue;}}z.push(Math.max(K,b));}return z;};v.prototype._resetRowHeights=function(){var a=this.getRowHeight();var b="";if(a){b=a+"px";}var l=this.getDomRef();if(l){var w=l.querySelectorAll(".sapUiTableTr");for(var i=0;i<w.length;i++){w[i].style.height=b;}}};v.prototype._resetColumnHeaderHeights=function(){if(this.getColumnHeaderHeight()){return;}var a=this.getDomRef();if(a){var b=a.querySelectorAll(".sapUiTableColHdrTr");for(var i=0;i<b.length;i++){b[i].style.height=null;}}};v.prototype._determineAvailableSpace=function(){var a=this.getDomRef();if(a&&a.parentNode){var b=a.querySelector(".sapUiTableCCnt");if(b){var U=a.scrollHeight-b.clientHeight;var i=0;if(a.parentNode.firstChild!==a){var l=parseFloat(window.getComputedStyle(a.parentNode).paddingTop);if(isNaN(l)){l=0;}i=a.offsetTop-l;}U+=18;return q(a.parentNode).height()-U-i;}}return 0;};v.prototype._collectTableSizes=function(){var a={tableCtrlScrollWidth:0,tableRowHdrScrWidth:0,tableCtrlScrWidth:0,tableHSbScrollLeft:0,tableCtrlFixedWidth:0,tableCntHeight:0,tableCntWidth:0};var b=this.getDomRef();if(!b){return a;}var l=b.querySelector(".sapUiTableCnt");if(l){a.tableCntHeight=l.clientHeight;a.tableCntWidth=l.clientWidth;}var w=b.querySelector(".sapUiTableCtrlScroll:not(.sapUiTableCHT)");if(w){a.tableCtrlScrollWidth=w.clientWidth;}var x=b.querySelector(".sapUiTableRowHdrScr");if(x){a.tableRowHdrScrWidth=x.clientWidth;}var y=b.querySelector(".sapUiTableCtrlScr:not(.sapUiTableCHA)");if(y){a.tableCtrlScrWidth=y.clientWidth;}var H=this._getScrollExtension().getHorizontalScrollbar();if(H){a.tableHSbScrollLeft=H.scrollLeft;}var z=b.querySelector(".sapUiTableCtrlScrFixed:not(.sapUiTableCHA) > .sapUiTableCtrlFixed");if(z){a.tableCtrlFixedWidth=z.clientWidth;}var A=this.getProperty("fixedColumnCount");var B=0;var J=b.querySelectorAll(".sapUiTableCtrlFirstCol:not(.sapUiTableCHTHR) > th:not(.sapUiTableColSel)");if(J){var K=this.getColumns();for(var i=0;i<J.length;i++){var L=J[i].getBoundingClientRect().width;if(i<K.length&&K[i]&&!K[i].getVisible()){A--;}if(i<A){B+=L;}}}if(A>0){var U=a.tableRowHdrScrWidth;var M=this.getDomRef("vsb");if(M){U+=M.offsetWidth;}var O=a.tableCtrlScrollWidth===a.tableCtrlScrWidth;var Q=a.tableCtrlFixedWidth+U<=a.tableCntWidth;var W=false;if(!O||!Q){W=(a.tableCntWidth-U<B);}if(this._bIgnoreFixedColumnCount!==W){this._bIgnoreFixedColumnCount=W;this.invalidate();}}return a;};v.prototype._updateRowHeights=function(b,H){var i=this.getDomRef();if(!i){return;}if(H&&this.getColumnHeaderHeight()){return;}function l(A,B){var J=b[B];if(J){A.style.height=J+"px";}}var w=H?".sapUiTableColHdrTr":".sapUiTableTr";var x=H?[]:i.querySelectorAll(".sapUiTableRowHdr");var y=i.querySelectorAll(".sapUiTableCtrlFixed > tbody > tr"+w);var z=i.querySelectorAll(".sapUiTableCtrlScroll > tbody > tr"+w);var a=[];a.forEach.call(x,l);a.forEach.call(y,l);a.forEach.call(z,l);};v.prototype.onBeforeRendering=function(a){if(a&&a.isMarked("insertTableRows")){return;}if(this._mTimeouts.bindingTimer){this._updateBindingContexts();}this._cleanUpTimers();this._detachEvents();var b=this.getVisibleRowCountMode();var i=this.getRows();if(b==V.Interactive||b==V.Fixed||(b==V.Auto&&this._iTableRowContentHeight&&i.length==0)){if(this.getBinding("rows")){this._adjustRows(this._calculateRowsToDisplay());}else{var l=this;this._mTimeouts.onBeforeRenderingAdjustRows=this._mTimeouts.onBeforeRenderingAdjustRows||window.setTimeout(function(){l._adjustRows(l._calculateRowsToDisplay());l._mTimeouts.onBeforeRenderingAdjustRows=undefined;},0);}}else if(this._bRowAggregationInvalid&&i.length>0){this._adjustRows(i.length);}this._aTableHeaders=[];};v.prototype.onAfterRendering=function(a){var b=a&&a.isMarked("insertTableRows");if(b){this._getScrollExtension().updateVerticalScrollbarHeight();this._updateVSbRange();}this._bInvalid=false;this._bOnAfterRendering=true;var $=this.$();this._attachEvents();this._initRowDomRefs();var w=this.getColumns();for(var i=0,l=w.length;i<l;i++){if(w[i].getVisible()){w[i]._restoreIcons();}}if(!this._bAllowColumnHeaderTextSelection&&!b){this._disableTextSelection($.find(".sapUiTableColHdrCnt"));}this._bOnAfterRendering=false;this._getKeyboardExtension().invalidateItemNavigation();this._updateTableContent();if(this._bFirstRendering&&this.getVisibleRowCountMode()==V.Auto){this._bFirstRendering=false;Promise.resolve().then(this._updateTableSizes.bind(this,true));}else{this._updateTableSizes();}if(!b){this._aTableHeaders=this.$().find(".sapUiTableColHdrCnt th");if(this.getBinding("rows")){this.fireEvent("_rowsUpdated");}}};v.prototype.invalidate=function(){if(!this._ignoreInvalidateOfChildControls){this._bInvalid=true;var a=C.prototype.invalidate.call(this);T.Column.invalidateColumnUtils(this);}return a;};v.prototype._initRowDomRefs=function(){var a=this.getRows();for(var i=0;i<a.length;i++){a[i].initDomRefs();}};v.prototype._updateTableSizes=function(b,a){var l=this.getDomRef();var w=this;if(this._bInvalid||!l){return;}if(!l.offsetWidth){T.deregisterResizeHandler(this,"");B();return;}this._resetRowHeights();this._resetColumnHeaderHeights();this._aRowHeights=this._collectRowHeights(false);var x=this._collectRowHeights(true);if(T.isVariableRowHeightEnabled(this)){this._iRowHeightsDelta=this._getRowHeightsDelta(this._aRowHeights);}var y=0;if(!a&&this.getVisibleRowCountMode()==V.Auto){y=this._determineAvailableSpace();if(this._handleRowCountModeAuto(y)&&!b){return;}}T.deregisterResizeHandler(this,"");function z(H){var J=H.getDomRef();var K=T.Column.getMinColumnWidth();var L=[];var M=H.getColumnHeaderVisible();function O(W,X){if(W<=X){return Math.max(W,X-5,K)+"px";}return-1;}function Q(X){var Y=Math.max(X._minWidth||0,K,X.getMinWidth());var Z=X.getWidth();var _;var a1;var b1;if(T.isVariableWidth(Z)&&!T.isFixedColumn(H,X.getIndex())){_=J.querySelectorAll('th[data-sap-ui-colid="'+X.getId()+'"]');a1=_[M?0:1];b1=a1&&a1.offsetWidth;if(b1){if(b1<=Y){return{headers:_,newWidth:O(b1,Y)};}else if(a1&&a1.style.width!=Z){L.push({col:X,header:a1,minWidth:Y,headers:_});return{headers:_,newWidth:Z};}L.push({col:X,header:a1,minWidth:Y,headers:_});}}return null;}function U(X){if(X){Array.prototype.forEach.call(X.headers,function(Y){Y.style.width=X.newWidth;});}}H._getVisibleColumns().map(Q).forEach(U);if(L.length){var W;for(var i=0;i<L.length;i++){W=L[i].header&&L[i].header.offsetWidth;L[i].newWidth=O(W,L[i].minWidth);if(parseInt(L[i].newWidth,10)>=0){U(L[i]);}}}}z(this);var A=this._collectTableSizes();if(A.tableCntHeight==0&&A.tableCntWidth==0){T.registerResizeHandler(this,"",this._onTableResize.bind(this),true);return;}this._updateRowHeights(this._aRowHeights,false);this._updateRowHeights(x,true);this._determineVisibleCols(A);if(!a){this._setRowContentHeight(y);}this._updateHSb(A);this._updateVSbTop();var $=this.$();$.find(".sapUiTableNoOpacity").addBack().removeClass("sapUiTableNoOpacity");function B(){T.registerResizeHandler(w,"",w._onTableResize.bind(w),true);}if($.closest(".sapUiLoSplitter").length){B();}else{Promise.resolve().then(B);}};v.prototype.setShowOverlay=function(b){b=!!b;this.setProperty("showOverlay",b,true);if(this.getDomRef()){var a=document.activeElement;this.$().toggleClass("sapUiTableOverlay",b);this._getAccExtension().updateAriaStateForOverlayAndNoData();this._getKeyboardExtension().updateNoDataAndOverlayFocus(a);}return this;};v.prototype._updateFixedBottomRows=function(){var i=this.getFixedBottomRowCount();var a=this.getDomRef();if(a&&i>0){var $=q(a).find(".sapUiTableFixedPreBottomRow");$.removeClass("sapUiTableFixedPreBottomRow");var b=q(a).find(".sapUiTableFixedFirstBottomRow");b.removeClass("sapUiTableFixedFirstBottomRow");var l=T.getFirstFixedButtomRowIndex(this);var w=this.getRows();var x;if(l>=0&&l<w.length){x=w[l].getDomRefs(true);x.row.addClass("sapUiTableFixedFirstBottomRow",true);}if(l>=1&&l<w.length){x=w[l-1].getDomRefs(true);x.row.addClass("sapUiTableFixedPreBottomRow",true);}}};v.prototype.getFocusInfo=function(){var i=this.$().find(":focus").attr("id");if(i){return{customId:i};}else{return E.prototype.getFocusInfo.apply(this,arguments);}};v.prototype.applyFocusInfo=function(a){if(a&&a.customId){this.$().find("#"+a.customId).focus();}else{E.prototype.getFocusInfo.apply(this,arguments);}return this;};v.prototype.setTitle=function(a){var b=a;if(typeof(a)==="string"||a instanceof String){b=k.TableHelper.createTextView({text:a,width:"100%"});b.addStyleClass("sapUiTableHdrTitle");}this.setAggregation("title",b);return this;};v.prototype.setFooter=function(a){var b=a;if(typeof(a)==="string"||a instanceof String){b=k.TableHelper.createTextView({text:a,width:"100%"});}this.setAggregation("footer",b);return this;};v.prototype.setSelectionMode=function(a){this.clearSelection();if(a===s.Single){this._oSelection.setSelectionMode(f.SINGLE_SELECTION);}else{this._oSelection.setSelectionMode(f.MULTI_SELECTION);}a=T.sanitizeSelectionMode(this,a);this.setProperty("selectionMode",a);return this;};v.prototype._adjustTablePosition=function(i,a){var b=i<this._getVirtualScrollRange();var l=this._getRowCount()>this.getVisibleRowCount();if(b&&this.getFirstVisibleRow()!=this._iRenderedFirstVisibleRow){return;}var w=null;if(b&&l){var x=a[0];var y=this._getScrollingPixelsForRow();var z=i-(this.getFirstVisibleRow()*y);var A=z/y;w=Math.ceil(A*x);if(w>x){w=null;}}else if(this._iRowHeightsDelta>=0){var B=l?i-this._getVirtualScrollRange():i;w=(this._iRowHeightsDelta/this._getRowCorrectionScrollRange())*B;}if(w!=null&&w>-1){this.$().find(".sapUiTableCCnt").scrollTop(w);}};v.prototype.setFirstVisibleRow=function(i,O,b){if(parseInt(i,10)<0){q.sap.log.error("The index of the first visible row must be greater than or equal to 0."+" The value has been set to 0.",this);i=0;}var a=this.getFirstVisibleRow()!=i;this.setProperty("firstVisibleRow",i,true);if(a&&this.getBinding("rows")){this.updateRows();if(!O){this._updateVSbScrollTop();}}if(a&&!b){this.fireFirstVisibleRowChanged({firstVisibleRow:i});}return this;};v.getMetadata().getAggregation("rows")._doesNotRequireFactory=true;v.prototype.bindAggregation=function(a){if(a=="rows"){return this.bindRows.apply(this,[].slice.call(arguments,1));}return C.prototype.bindAggregation.apply(this,arguments);};v.prototype.bindRows=function(b,a,i,l){if(typeof b==="string"&&(a instanceof g||q.isArray(i)&&i[0]instanceof F)){l=i;i=a;a=undefined;}return C.prototype.bindAggregation.call(this,"rows",b,a,i,l);};v.prototype._bindAggregation=function(a,b,i,l,w){E.prototype._bindAggregation.apply(this,arguments);var B=this.getBinding("rows");if(a==="rows"&&B){B.attachChange(this._onBindingChange,this);}this._initSelectionModel(f.MULTI_SELECTION);if(B&&this.isTreeBinding("rows")&&!B.hasListeners("selectionChanged")){B.attachSelectionChanged(this._onSelectionChanged,this);}return this;};v.prototype._initSelectionModel=function(a){if(this._oSelection){this._oSelection.detachSelectionChanged(this._onSelectionChanged,this);}this._oSelection=new f(a);this._oSelection.attachSelectionChanged(this._onSelectionChanged,this);return this;};v.prototype._onBindingChange=function(a){var b=typeof(a)==="object"?a.getParameter("reason"):a;if(b==="sort"||b==="filter"){this.clearSelection();this.setFirstVisibleRow(0);}};v.prototype.unbindAggregation=function(a,b){var B=this.getBinding("rows");if(a==="rows"&&this.isBound("rows")){b=true;}var i=E.prototype.unbindAggregation.apply(this,[a,b]);if(a==="rows"&&B){this._restoreAppDefaultsColumnHeaderSortFilter();this._invalidateColumnMenus();this._updateBindingLength();this.updateRows("unbindAggregation");}return i;};v.prototype.setVisibleRowCount=function(i){if(i!=null&&!isFinite(i)){return this;}var a=this.getVisibleRowCountMode();if(a==V.Auto){q.sap.log.error("VisibleRowCount will be ignored since VisibleRowCountMode is set to Auto",this);return this;}var b=this.getFixedRowCount()+this.getFixedBottomRowCount();if(i<=b&&b>0){q.sap.log.error("Table: "+this.getId()+" visibleRowCount('"+i+"') must be bigger than number of fixed rows('"+(this.getFixedRowCount()+this.getFixedBottomRowCount())+"')",this);return this;}i=this.validateProperty("visibleRowCount",i);if(this.getBinding("rows")&&this.getBinding("rows").getLength()<=i){this.setProperty("firstVisibleRow",0);}this.setProperty("visibleRowCount",i);this._setRowContentHeight(i*this._getDefaultRowHeight());return this;};v.prototype.setRowHeight=function(i){this.setProperty("rowHeight",i);this._iTableRowContentHeight=undefined;return this;};v.prototype.setTooltip=function(a){q.sap.log.warning("The aggregation tooltip is not supported for sap.ui.table.Table");return this.setAggregation("tooltip",a,true);};v.prototype.setNavigationMode=function(){this.setProperty("navigationMode",N.Scrollbar,true);q.sap.log.error("The navigationMode property is deprecated and must not be used anymore. Your setting was defaulted to 'Scrollbar'",this);};v.prototype._getFixedBottomRowContexts=function(i,b){var B=this.getBinding("rows");var a=[];if(!B){return a;}i=i||this.getFixedBottomRowCount();b=b||B.getLength();var l=this.getVisibleRowCount();if(i>0&&(l-i)<b){a=this._getContexts(b-i,i,1);}return a;};v.prototype._getFixedRowContexts=function(i){i=i||this.getFixedRowCount();if(i>0){return this._getContexts(0,i);}else{return[];}};v.prototype._getContexts=function(i,l,a){var b=this.getBinding("rows");if(b){return b.getContexts(i,l,a);}else{return[];}};v.prototype._getRowContexts=function(a,b,l){var w=false;var x=[];var B=this.getBinding("rows");var y=a||this.getRows().length;if(!B||y<=0){return[];}var z=this.getFirstVisibleRow();var A=this.getFixedRowCount();var H=this.getFixedBottomRowCount();var J=0;var K;var L=y-H;var M=0;var O=L;var Q=this.getThreshold();Q=Q?Math.max(y,Q):0;var U=z;var W=function($,_,U){for(var i=0;i<_.length;i++){$[U+i]=_[i];}};if(A>0&&z>0){U=z+A;L-=A;M=A;K=this._getFixedRowContexts(A);J+=K.length;x=x.concat(K);}K=this._getContexts(U,L,Q);var X=this._updateBindingLength(l);w=K.length<Math.min(L,X-H);J+=K.length;W(x,K,M);O=Math.min(O,Math.max(X-H,0));if(H>0){K=this._getFixedBottomRowContexts(H,X);J+=K.length;W(x,K,O);}if(w&&!b){var Y=this._getSanitizedFirstVisibleRow(true);if(z!=Y){x=this._getRowContexts(y,true);J=x.length;}}if(!b){var Z=this;if(this._mTimeouts.getContextsSetBusy){window.clearTimeout(this._mTimeouts.getContextsSetBusy);}this._mTimeouts.getContextsSetBusy=window.setTimeout(function(){Z._setBusy({requestedLength:A+L+H,receivedLength:J,contexts:x,reason:l});},0);}return x;};v.prototype._getSanitizedFirstVisibleRow=function(U){var i=this.getVisibleRowCount();var a=this.getFirstVisibleRow();a=Math.max(a,0);if(this._iBindingLength>0&&!T.isVariableRowHeightEnabled(this)){a=Math.min(a,Math.max(this._iBindingLength-i,0));}if(U){this.setProperty("firstVisibleRow",a,true);}return a;};v.prototype._updateBindingLength=function(a){var b=this.getBinding("rows");var B=0;if(b){B=b.getLength();}if(B!=this._iBindingLength){this._iBindingLength=B;this._onBindingLengthChange(a);}return B;};v.prototype._onBindingLengthChange=function(a){if(a===d.Refresh){return;}this._updateFixedBottomRows();this._toggleVSb();this._updateVSbRange();this._bBindingLengthChanged=true;if(a!="skipNoDataUpdate"){this._updateNoData();}};v.prototype.refreshRows=function(a){var b=this.getBinding("rows");if(!b){q.sap.log.error("RefreshRows must not be called without a binding",this);return;}var i=this;var l=typeof(a)==="object"?a.getParameter("reason"):a;if(l==d.Refresh){this._attachBindingListener();}this._bBusyIndicatorAllowed=true;var w=this.getVisibleRowCountMode();if((this.bOutput&&w===V.Auto)||w!==V.Auto){var x=this._calculateRowsToDisplay();if(this.bOutput){b.attachEventOnce("dataRequested",function(){if(i._mTimeouts.refreshRowsAdjustRows){window.clearTimeout(i._mTimeouts.refreshRowsAdjustRows);}i._mTimeouts.refreshRowsAdjustRows=window.setTimeout(function(){i._adjustRows(x,true);},0);});}if(l==d.Filter||l==d.Sort){l="skipNoDataUpdate";this.setFirstVisibleRow(0);}this._updateBindingContexts(true,x,l);}};v.prototype.updateRows=function(a){if(this._bExitCalled){return;}this._setBusy(a?{changeReason:a}:false);if(this._bBindingLengthChanged){this._updateNoData();}var b=this.getVisibleRowCountMode();if((this.getRows().length<=0||this._bRowAggregationInvalid)&&((b==V.Auto&&this.bOutput)||b!=V.Auto)){if(this._iTableRowContentHeight){this._adjustRows(this._calculateRowsToDisplay());}}if(!this.bIsDestroyed){var B=(a==d.Change||(!this._mTimeouts.bindingTimer&&Date.now()-this._lastCalledUpdateRows>this._iBindingTimerDelay)||a=="unbindAggregation"?0:this._iBindingTimerDelay);var i=this;if(B==0&&a){Promise.resolve().then(function(){i._performUpdateRows(a);});}else{this._mTimeouts.bindingTimer=this._mTimeouts.bindingTimer||window.setTimeout(function(){i._performUpdateRows(a);},B);}}};v.prototype.insertRow=function(){q.sap.log.error("The control manages the rows aggregation. The method \"insertRow\" cannot be used programmatically!",this);};v.prototype.addRow=function(){q.sap.log.error("The control manages the rows aggregation. The method \"addRow\" cannot be used programmatically!",this);};v.prototype.removeRow=function(){q.sap.log.error("The control manages the rows aggregation. The method \"removeRow\" cannot be used programmatically!",this);};v.prototype.removeAllRows=function(){q.sap.log.error("The control manages the rows aggregation. The method \"removeAllRows\" cannot be used programmatically!",this);};v.prototype.destroyRows=function(){q.sap.log.error("The control manages the rows aggregation. The method \"destroyRows\" cannot be used programmatically!",this);};v.prototype.autoResizeColumn=function(i){this._getPointerExtension().doAutoResizeColumn(i);};v.prototype._attachEvents=function(){var $=this.$();$.find(".sapUiTableColHdrScr").scroll(q.proxy(this._oncolscroll,this));$.find(".sapUiTableCtrlScr").scroll(q.proxy(this._oncntscroll,this));$.find(".sapUiTableCtrlScrFixed").scroll(q.proxy(this._oncntscroll,this));$.find(".sapUiTableCtrlScrFixed, .sapUiTableColHdrFixed").on("scroll.sapUiTablePreventFixedAreaScroll",function(a){a.target.scrollLeft=0;});if(T.isVariableRowHeightEnabled(this)){var i=$.find(".sapUiTableCtrlScr, .sapUiTableCtrlScrFixed, .sapUiTableRowHdrScr");i.on("scroll.sapUiTableSyncScrollPosition",function(a){i.scrollTop(a.target.scrollTop);});}if(sap.ui.getCore().getConfiguration().getAnimation()){q("body").bind('webkitTransitionEnd transitionend',q.proxy(function(a){if(q(a.target).has($).length>0){this._iDefaultRowHeight=undefined;this._updateTableSizes();}},this));}m.attachEvents(this);};v.prototype._detachEvents=function(){q(document.body).unbind('webkitTransitionEnd transitionend');T.deregisterResizeHandler(this);m.detachEvents(this);};v.prototype._getScrollTargets=function(){var $=q(this.getDomRef("sapUiTableCtrlScr"));var a=q(this.getDomRef("rsz"));var b=q(this.getDomRef("sapUiTableCtrlScrFixed"));var i=q(this.getDomRef("sapUiTableRowHdrScr"));return $.add(b).add(i).add(a);};v.prototype._cleanUpTimers=function(){for(var K in this._mTimeouts){if(this._mTimeouts[K]){clearTimeout(this._mTimeouts[K]);this._mTimeouts[K]=undefined;}}};v.prototype._updateHSb=function(a){var $=this.$();var i=a.tableCtrlScrollWidth;if(!!D.browser.safari){i=Math.max(i,this._getColumnsWidth(this.getFixedColumnCount()));}if(i>a.tableCtrlScrWidth){if(!this._getScrollExtension().isHorizontalScrollbarVisible()){$.addClass("sapUiTableHScr");if(!!D.browser.safari){var b=$.find(".sapUiTableCtrlScroll, .sapUiTableColHdrScr > .sapUiTableColHdr");b.outerWidth(i);}}var l=a.tableCtrlFixedWidth;if($.find(".sapUiTableRowHdrScr").length>0){l+=a.tableRowHdrScrWidth;}if(this.getRows().length>0){var w=$.find(".sapUiTableHSb");if(this._bRtlMode){w.css('margin-right',l+'px');}else{w.css('margin-left',l+'px');}}var H=this.getDomRef("hsb-content");if(H){H.style.width=i+"px";}}else{if(this._getScrollExtension().isHorizontalScrollbarVisible()){$.removeClass("sapUiTableHScr");if(!!D.browser.safari){$.find(".sapUiTableCtrlScroll, .sapUiTableColHdr").css("width","");}}}};v.prototype._updateVSbTop=function(){var a=this._getScrollExtension().getVerticalScrollbar();if(!a){return;}var b=this.getDomRef("tableCCnt");if(b){var i=b.offsetTop;var l=this.getFixedRowCount();if(l>0){i+=this._iVsbTop;}a.style.top=i+"px";}};v.prototype._updateVSbScrollTop=function(i){var a=this._getScrollExtension().getVerticalScrollbar();if(!a){return;}if(i===undefined){i=Math.ceil(this.getFirstVisibleRow()*this._getScrollingPixelsForRow());}a.scrollTop=i;};v.prototype._updateVSbRange=function(){var a=this._getScrollExtension().getVerticalScrollbar();if(!a){return;}q(this.getDomRef("vsb-content")).height(this._getTotalScrollRange());};v.prototype._toggleVSb=function(){var $=this.$();if(this.getDomRef()){var i=this._isVSbRequired();if(!i){this._updateVSbScrollTop(0);}$.toggleClass("sapUiTableVScr",i);}};v.prototype._isVSbRequired=function(){if(this._iRowHeightsDelta>0||(this.getBinding("rows")&&this._iBindingLength>this.getVisibleRowCount())){return true;}return false;};v.prototype._updateBindingContexts=function(b,i,a){var B=this.getBinding("rows"),l;if(B){l=this._getRowContexts(i,false,a);}if(!b){this._resetRowHeights();var w=this.getRows(),x=this.mBindingInfos["rows"],M=x&&x.model;for(var y=w.length-1;y>=0;y--){var z=l?l[y]:undefined;var A=w[y];if(A){A.setRowBindingContext(z,M,B);}}}};v.prototype._updateNoData=function(){if(!this.getDomRef()){return;}var a=document.activeElement;this.$().toggleClass("sapUiTableEmpty",T.isNoDataVisible(this));this._getAccExtension().updateAriaStateForOverlayAndNoData();this._getKeyboardExtension().updateNoDataAndOverlayFocus(a);};v.prototype._determineVisibleCols=function(a){var b=[];this.getColumns().forEach(function(l,i){if(l.shouldRender()){b.push(i);}});};v.prototype.removeColumn=function(a,b){var i=this.removeAggregation('columns',a,b);if(typeof a==="number"&&a>-1){a=this.getColumns()[a];}var l=q.inArray(a,this._aSortedColumns);if(!this._bReorderInProcess&&l>=0){this._aSortedColumns.splice(l,1);}this.invalidateRowsAggregation();return i;};v.prototype.removeAllColumns=function(){var a=this.removeAllAggregation('columns');this._aSortedColumns=[];this.invalidateRowsAggregation();return a;};v.prototype.destroyColumns=function(){var a=this.destroyAggregation('columns');this._aSortedColumns=[];this.invalidateRowsAggregation();return a;};v.prototype.addColumn=function(a,b){this.addAggregation('columns',a,b);this.invalidateRowsAggregation();return this;};v.prototype.insertColumn=function(a,i,b){this.insertAggregation('columns',a,i,b);this.invalidateRowsAggregation();return this;};v.prototype._getRowCount=function(){return this._iBindingLength;};v.prototype._getSelectableRowCount=function(){return this._iBindingLength;};v.prototype._getFirstVisibleRowByScrollTop=function(i){if(T.isVariableRowHeightEnabled(this)&&this._getRowCount()<this.getVisibleRowCount()){return 0;}else{if(D.browser.chrome&&window.devicePixelRatio!=1){var a=this._getScrollExtension().getVerticalScrollbar();if(a!=null){var b=this._getVirtualScrollRange()-a.scrollTop;if(b<1){return this._getMaxRowIndex();}}}var l=Math.floor(i/this._getScrollingPixelsForRow());return Math.min(this._getMaxRowIndex(),l);}};v.prototype._getScrollingPixelsForRow=function(){return this._getVirtualScrollRange()/Math.max(1,this._getMaxRowIndex());};v.prototype._getVSbHeight=function(){return this._getScrollableRowCount()*this._getDefaultRowHeight();};v.prototype._getScrollableRowCount=function(){return Math.max(1,this.getVisibleRowCount()-this.getFixedRowCount()-this.getFixedBottomRowCount());};v.prototype._getRowHeightsDelta=function(i){var l=this._getDefaultRowHeight()*this.getVisibleRowCount();if(this.getVisibleRowCount()>=this._getRowCount()){i=i.slice(0,this._getRowCount());}var w=i.reduce(function(a,b){return a+b;},0)-l;if(w>0){w=Math.ceil(w);}return Math.max(0,w);};v.prototype._getTotalScrollRange=function(){var i=Math.max(this._getRowCount(),this.getVisibleRowCount()+1);var a=this._getDefaultRowHeight()*i;return Math.min(this._iMaxScrollbarHeight,a);};v.prototype._getVirtualScrollRange=function(){var M=this._getTotalScrollRange()-this._getVSbHeight();if(T.isVariableRowHeightEnabled(this)){M=M-this._iRowHeightsDelta;}return Math.max(1,M);};v.prototype._getRowCorrectionScrollRange=function(){var i=this._getTotalScrollRange()-this._getVSbHeight();if(this._getRowCount()>this.getVisibleRowCount()){i-=this._getVirtualScrollRange();}return Math.max(1,i);};v.prototype._getMaxRowIndex=function(){if(T.isVariableRowHeightEnabled(this)){if(this.getVisibleRowCount()>this._getRowCount()){return this._getRowCount();}else{return Math.max(0,this._getRowCount()-this.getVisibleRowCount()-1);}}else{return Math.max(0,this._getRowCount()-this.getVisibleRowCount());}};v.prototype._getVisibleColumns=function(){var a=[];var b=this.getColumns();for(var i=0,l=b.length;i<l;i++){if(b[i].shouldRender()){a.push(b[i]);}}return a;};v.prototype._getColumnsWidth=function(a,b){var w=this.getColumns();var x=0;if(a!==0&&!a){a=0;}if(b!==0&&!b){b=w.length;}for(var i=a,l=b;i<l;i++){if(w[i]&&w[i].shouldRender()){x+=this._CSSSizeToPixel(w[i].getWidth());}}return x;};v.prototype._CSSSizeToPixel=function(a,b){var i=T.Column.getMinColumnWidth();if(a){if(q.sap.endsWith(a,"px")){i=parseInt(a,10);}else if(q.sap.endsWith(a,"em")||q.sap.endsWith(a,"rem")){i=Math.ceil(parseFloat(a)*this._getBaseFontSize());}}if(b){return i+"px";}else{return parseInt(i,10);}};v.prototype._getBaseFontSize=function(){return this._iBaseFontSize;};v.prototype._onTableResize=function(){if(this._bInvalid||!this.getDomRef()){return;}this._updateTableSizes();};v.prototype._handleRowCountModeAuto=function(i){var b=this.getBinding("rows");if(b&&this.getRows().length>0){return this._executeAdjustRows(i);}else{var a=this;var l=!this._mTimeouts.handleRowCountModeAutoAdjustRows;var B=a.getBusyIndicatorDelay();var w=this.getEnableBusyIndicator();if(b&&w){a.setBusyIndicatorDelay(0);a.setBusy(true);}if(i){this._setRowContentHeight(i);}this._mTimeouts.handleRowCountModeAutoAdjustRows=this._mTimeouts.handleRowCountModeAutoAdjustRows||window.setTimeout(function(){if(!a._executeAdjustRows()){a._updateTableSizes(false,true);}a._mTimeouts.handleRowCountModeAutoAdjustRows=undefined;if(w){a.setBusy(false);a.setBusyIndicatorDelay(B);}},0);return l;}};v.prototype._executeAdjustRows=function(i){i=i||this._determineAvailableSpace();var a=this._calculateRowsToDisplay(i);if(a==this._determineMinAutoRowCount()){this.$().height("auto");}else{this.$().height("0px");}return this._adjustRows(a);};v.prototype._disableTextSelection=function(a){q(a||document.body).attr("unselectable","on").css({"-moz-user-select":"none","-webkit-user-select":"none","user-select":"none"}).bind("selectstart",function(b){b.preventDefault();return false;});};v.prototype._enableTextSelection=function(a){q(a||document.body).attr("unselectable","off").css({"-moz-user-select":"","-webkit-user-select":"","user-select":""}).unbind("selectstart");};v.prototype._clearTextSelection=function(){if(window.getSelection){if(window.getSelection().empty){window.getSelection().empty();}else if(window.getSelection().removeAllRanges){window.getSelection().removeAllRanges();}}else if(document.selection&&document.selection.empty){try{document.selection.empty();}catch(a){}}};v.prototype._findAndfireCellEvent=function(a,b,i){var $=q(b.target);var l=$.closest("td.sapUiTableTd");var w=l.attr("id");var M=/.*-row(\d*)-col(\d*)/i.exec(w);var x=false;if(M){var y=M[1];var z=M[2];var A=this.getRows()[y];var B=A&&A.getCells()[z];var H=A&&A.getIndex();var J=B.data("sap-ui-colid");var K;if(this.getBindingInfo("rows")){K=A.getBindingContext(this.getBindingInfo("rows").model);}var L={rowIndex:H,columnIndex:z,columnId:J,cellControl:B,rowBindingContext:K,cellDomRef:l.get(0)};x=!a.call(this,L);if(!x&&typeof i==="function"){L.cellDomRef=l[0];x=i.call(this,L);}}return x;};v.prototype.getFocusDomRef=function(){this._getKeyboardExtension().initItemNavigation();var a=T.getFocusedItemInfo(this);if(a!==null){return a.domRef||C.prototype.getFocusDomRef.apply(this,arguments);}return null;};v.prototype._onSelect=function(a){var $=q(a.target);var b=a.shiftKey;var i=!!(a.metaKey||a.ctrlKey);var l=$.closest(".sapUiTableRowHdr");if(l.length===1){var w=parseInt(l.attr("data-sap-ui-rowindex"),10);this._onRowSelect(this.getRows()[w].getIndex(),b,i);return;}var x,y;if(a.target){y=q(a.target).closest(".sapUiTableCtrl > tbody > tr > td");if(y.length>0){x=y[0];}}if(x&&(y.hasClass("sapUiTableTd")||y.hasClass("sapUiTableTDDummy"))&&T.isRowSelectionAllowed(this)){var l=$.closest(".sapUiTableCtrl > tbody > tr");if(l.length===1&&!l.hasClass("sapUiTableColHdrTr")){var w=parseInt(l.attr("data-sap-ui-rowindex"),10);this._onRowSelect(this.getRows()[w].getIndex(),b,i);return;}}if(q.sap.containsOrEquals(this.getDomRef("selall"),a.target)){this._toggleSelectAll();return;}};v.prototype._isRowSelectable=function(i){return i>=0&&i<this._getRowCount();};v.prototype._onRowSelect=function(i,b,a){if(!!D.browser.internet_explorer&&b){this._clearTextSelection();}var B=this.getBinding("rows");if(!B){return;}if(i<0||i>=(B.getLength()||0)){return;}if(!this._isRowSelectable(i)){return;}this._iSourceRowIndex=i;var l=this.getSelectionMode();if(l!==s.None){if(l===s.Single){if(!this.isIndexSelected(i)){this.setSelectedIndex(i);}else{this.clearSelection();}}else{if(l===s.MultiToggle){a=true;}if(b){var w=this.getSelectedIndex();if(w>=0){this.addSelectionInterval(w,i);}else{this.setSelectedIndex(i);}}else{if(!this.isIndexSelected(i)){if(a){this.addSelectionInterval(i,i);}else{this.setSelectedIndex(i);}}else{if(a){this.removeSelectionInterval(i,i);}else{if(this._getSelectedIndicesCount()===1){this.clearSelection();}else{this.setSelectedIndex(i);}}}}}}this._iSourceRowIndex=undefined;};v.prototype.pushSortedColumn=function(a,A){if(!A){this._aSortedColumns=[];}this._aSortedColumns.push(a);};v.prototype.getSortedColumns=function(){return this._aSortedColumns;};v.prototype.sort=function(a,b,A){if(q.inArray(a,this.getColumns())>=0){a.sort(b===u.Descending,A);}};v.prototype.filter=function(a,b){if(q.inArray(a,this.getColumns())>=0){a.filter(b);}};v.prototype._updateSelection=function(){var a=this.getSelectionMode();if(a===s.None){return;}var b=this._getAccExtension().getAriaTextsForSelectionMode(true);var l=T.isRowSelectionAllowed(this);var w=this.getRows();for(var i=0;i<w.length;i++){var x=w[i];x._updateSelection(this,b,l);}this.setProperty("selectedIndex",this.getSelectedIndex(),true);var $=this.$("selall");if((a==s.Multi||a==s.MultiToggle)&&this.getEnableSelectAll()){var y=this._getSelectedIndicesCount();var z=y==0;if(!z){var A=this._getSelectableRowCount();z=A==0||A!==y;}$.toggleClass("sapUiTableSelAll",z);this._getAccExtension().setSelectAllState(!z);if(z){this.$("selall").attr('title',this._oResBundle.getText("TBL_SELECT_ALL"));}}};v.prototype._onSelectionChanged=function(a){var b=a.getParameter("rowIndices");var i=a.getParameter("selectAll");var l=this._iSourceRowIndex!==undefined?this._iSourceRowIndex:this.getSelectedIndex();this._updateSelection();this.fireRowSelectionChange({rowIndex:l,rowContext:this.getContextByIndex(l),rowIndices:b,selectAll:i,userInteraction:this._iSourceRowIndex!==undefined});};v.prototype.getContextByIndex=function(i){var b=this.getBinding("rows");return i>=0&&b?b.getContexts(i,1)[0]:null;};v.prototype.getSelectedIndex=function(){return this._oSelection.getLeadSelectedIndex();};v.prototype.setSelectedIndex=function(i){if(i===-1){this.clearSelection();}else{this._oSelection.setSelectionInterval(i,i);}return this;};v.prototype.clearSelection=function(){this._oSelection.clearSelection();return this;};v.prototype.selectAll=function(){var a=this.getSelectionMode();if(!this.getEnableSelectAll()||(a!="Multi"&&a!="MultiToggle")){return this;}var b=this.getBinding("rows");if(b){this.$("selall").attr('title',this._oResBundle.getText("TBL_DESELECT_ALL")).removeClass("sapUiTableSelAll");this._getAccExtension().setSelectAllState(true);this._oSelection.selectAll((b.getLength()||0)-1);}return this;};v.prototype.getSelectedIndices=function(){return this._oSelection.getSelectedIndices();};v.prototype.addSelectionInterval=function(i,a){if(this.getSelectionMode()===k.SelectionMode.None){return this;}this._oSelection.addSelectionInterval(i,a);return this;};v.prototype.setSelectionInterval=function(i,a){if(this.getSelectionMode()===k.SelectionMode.None){return this;}this._oSelection.setSelectionInterval(i,a);return this;};v.prototype.removeSelectionInterval=function(i,a){this._oSelection.removeSelectionInterval(i,a);return this;};v.prototype.isIndexSelected=function(i){return this._oSelection.isSelectedIndex(i);};v.prototype.setGroupBy=function(a){var b=a;if(typeof b==="string"){b=sap.ui.getCore().byId(b);}var i=false;if(b&&b instanceof h){if(q.inArray(b,this.getColumns())===-1){throw new Error("Column has to be part of the columns aggregation!");}var l=this.fireGroup({column:b,groupedColumns:[b.getId()],type:G.group});var O=sap.ui.getCore().byId(this.getGroupBy());if(O){O.setGrouped(false);i=true;}if(l&&b instanceof h){b.setGrouped(true);}}if(!b||i){var B=this.getBindingInfo("rows");delete B.binding;this._bindAggregation("rows",B);}return this.setAssociation("groupBy",b);};v.prototype.getBinding=function(a){T.Grouping.setupExperimentalGrouping(this);return E.prototype.getBinding.call(this,[a||"rows"]);};v.prototype.setEnableGrouping=function(b){this.setProperty("enableGrouping",b);if(!b){T.Grouping.resetExperimentalGrouping(this);}this._invalidateColumnMenus();return this;};v.prototype.setEnableCustomFilter=function(b){this.setProperty("enableCustomFilter",b);this._invalidateColumnMenus();return this;};v.prototype.setEnableColumnFreeze=function(b){this.setProperty("enableColumnFreeze",b);this._invalidateColumnMenus();return this;};v.prototype.setShowColumnVisibilityMenu=function(b){this.setProperty("showColumnVisibilityMenu",b);this._invalidateColumnMenus();return this;};v.prototype.getFixedColumnCount=function(){if(this._bIgnoreFixedColumnCount){return 0;}else{return this.getProperty("fixedColumnCount");}};v.prototype.setFixedColumnCount=function(a,b){var l=this._getVisibleColumns();var H=l[a-1]&&l[a-1].getHeaderSpan();if(H){var w;if(q.isArray(H)){w=parseInt(H[0],10);}else{w=parseInt(H,10);}a+=w-1;}var $=this.$().find(".sapUiTableCtrlFirstCol > th");for(var i=0;i<a;i++){var x=l[i];if(x){var y=q.inArray(x,this.getColumns());if(T.isVariableWidth(x.getWidth())){x._iFixWidth=$.filter("[data-sap-ui-headcolindex='"+y+"']").width();}}}this.setProperty("fixedColumnCount",a,b);this._collectTableSizes();this._invalidateColumnMenus();return this;};v.prototype.setFixedRowCount=function(i){if(!(parseInt(i,10)>=0)){q.sap.log.error("Number of fixed rows must be greater or equal 0",this);return this;}if((i+this.getFixedBottomRowCount())<this.getVisibleRowCount()){this.setProperty("fixedRowCount",i);this._updateBindingContexts();}else{q.sap.log.error("Table '"+this.getId()+"' fixed rows('"+(i+this.getFixedBottomRowCount())+"') must be smaller than numberOfVisibleRows('"+this.getVisibleRowCount()+"')",this);}return this;};v.prototype.setFixedBottomRowCount=function(i){if(!(parseInt(i,10)>=0)){q.sap.log.error("Number of fixed bottom rows must be greater or equal 0",this);return this;}if((i+this.getFixedRowCount())<this.getVisibleRowCount()){this.setProperty("fixedBottomRowCount",i);this._updateBindingContexts();}else{q.sap.log.error("Table '"+this.getId()+"' fixed rows('"+(i+this.getFixedRowCount())+"') must be smaller than numberOfVisibleRows('"+this.getVisibleRowCount()+"')",this);}return this;};v.prototype.setThreshold=function(i){this.setProperty("threshold",i,true);};v.prototype._invalidateColumnMenus=function(){var a=this.getColumns();for(var i=0,l=a.length;i<l;i++){a[i].invalidateMenu();}};v.prototype._isTouchEvent=function(a){return a!=null&&a.originalEvent!=null&&a.originalEvent.touches!=null;};v.prototype._getRowClone=function(a){var b=new j(this.getId()+"-rows"+"-row"+a);var w=this.getColumns();for(var i=0,l=w.length;i<l;i++){if(w[i].getVisible()){var x=w[i].getTemplateClone(i,a);if(x){b.addCell(x);}}}return b;};v.prototype.invalidateRowsAggregation=function(){this._bRowAggregationInvalid=true;};v.prototype._adjustRows=function(a,b){if(isNaN(a)){return false;}if(T.isVariableRowHeightEnabled(this)){a=a+1;}var i;var l=this.getRows();if(this._bRowAggregationInvalid&&l.length>0){this.destroyAggregation("rows",true);l=[];}if(a==l.length){return false;}for(i=l.length-1;i>=a;i--){this.removeAggregation("rows",i,true).destroy();}if(T.isVariableRowHeightEnabled(this)){this.setProperty("visibleRowCount",a-1,true);}else{this.setProperty("visibleRowCount",a,true);}this._ignoreInvalidateOfChildControls=true;var w;var B;var M;var x=this.getBinding("rows");if(!b){B=this.getBindingInfo("rows");M=B&&B.model;w=this._getRowContexts(a);for(i=0;i<l.length;i++){l[i].setRowBindingContext(w[i],M,x);}}if(l.length<a){for(i=l.length;i<a;i++){var y=this._getRowClone(i);if(!b){y.setRowBindingContext(w[i],M,x);}this.addAggregation("rows",y,true);this._bRowAggregationInvalid=false;if(!b){y._updateTableCells(w[i]);}}}this._ignoreInvalidateOfChildControls=false;l=this.getRows();b=b||w.length==0;return this._insertTableRows(l,b);};v.prototype._insertTableRows=function(a,b){var i=false;if(!this._bInvalid){this._detachEvents();var l=this.getDomRef("tableCCnt");a=a||this.getRows();if(!a.length||!l){return;}if(this.getVisibleRowCountMode()==V.Auto){var w=this.getDomRef();if(w){w.style.height="0px";}}var x=q.Event("BeforeRendering");x.setMarked("insertTableRows");x.srcControl=this;this._handleEvent(x);var y=new sap.ui.getCore().createRenderManager(),z=this.getRenderer();z.renderTableCCnt(y,this);y.flush(l,false,false);y.destroy();x=q.Event("AfterRendering");x.setMarked("insertTableRows");x.srcControl=this;this._handleEvent(x);i=true;}if(!b&&!this._bInvalid&&this.getBinding("rows")){var A=this;if(this._mTimeouts._rowsUpdated){window.clearTimeout(this._mTimeouts._rowsUpdated);}this._mTimeouts._rowsUpdated=window.setTimeout(function(){A.fireEvent("_rowsUpdated");},0);}return i;};v.prototype._getDefaultRowHeight=function(){var i=this.getRowHeight();if(i>0){return i;}else{var a=T.getContentDensity(this);return T.DEFAULT_ROW_HEIGHT[a];}};v.prototype._setRowContentHeight=function(H){H=H||0;var a=this.getVisibleRowCountMode();var i=this.getVisibleRowCount();var b=this._getDefaultRowHeight();var M=this.getMinAutoRowCount();var l;if(a==V.Interactive||a==V.Fixed){if(this._iTableRowContentHeight&&a==V.Interactive){l=M*b;if(!H){H=this._iTableRowContentHeight;}}else{l=i*b;H=l;}}else if(a==V.Auto){l=M*b;}var w=Math.max(H,l);if((a==V.Fixed&&this.getRows().length==0)||a!=V.Fixed){this._iTableRowContentHeight=Math.floor(w/b)*b;}else{this._iTableRowContentHeight=undefined;}if(T.isVariableRowHeightEnabled(this)){q(this.getDomRef("tableCCnt")).css("height",b*this.getVisibleRowCount()+"px");}else{if((a==V.Fixed||a==V.Interactive)&&this.getRows().length>0){q(this.getDomRef("tableCtrlCnt")).css("height","auto");}else{q(this.getDomRef("tableCtrlCnt")).css("height",this._iTableRowContentHeight+"px");}}this._toggleVSb();};v.prototype._determineMinAutoRowCount=function(){var i=this.getVisibleRowCount();var M=this.getMinAutoRowCount();var a=M||i||5;if(this.getVisibleRowCountMode()==V.Interactive&&!this.bOutput){a=i||M||5;}return a;};v.prototype._calculateRowsToDisplay=function(i){i=i||this._iTableRowContentHeight;var a=this.getVisibleRowCountMode();var b=0;if(a==V.Fixed){b=this.getVisibleRowCount()||0;}else if(a==V.Interactive||a==V.Auto){var M=this._determineMinAutoRowCount();var l=this._getDefaultRowHeight();if(!l||!i){b=M;}else{var A=Math.min(i,50000);var w=Math.floor(A/l);b=Math.max((this.getFixedRowCount()+this.getFixedBottomRowCount()+1),Math.max(M,w));}}return Math.max(b,0);};v.prototype.setShowNoData=function(b){this.setProperty('showNoData',b,true);this._updateNoData();return this;};v.prototype.exportData=function(a){var b=sap.ui.requireSync("sap/ui/core/util/Export");a=a||{};if(!a.rows){var B=this.getBinding("rows"),w=this.getBindingInfo("rows");var x=B.aFilters.concat(B.aApplicationFilters);a.rows={path:w.path,model:w.model,sorter:B.aSorters,filters:x,parameters:w.parameters};}if(!a.exportType){var y=sap.ui.requireSync("sap/ui/core/util/ExportTypeCSV");a.exportType=new y();}var M=a.rows.model;if(!M){var z=a.rows.path;var A=z.indexOf(">");if(A>0){M=z.substr(0,A);}}if(!a.columns){a.columns=[];var H=this.getColumns();for(var i=0,l=H.length;i<l;i++){var J=H[i];if(J.getSortProperty()){a.columns.push({name:J.getLabel().getText(),template:{content:{path:J.getSortProperty(),model:M}}});}}}var K=new b(a);this.addDependent(K);return K;};v.prototype._onPersoApplied=function(){var a=this.getColumns();var b=[];for(var i=0,l=a.length;i<l;i++){var w=a[i];if(w.getSorted()){b.push(new g(w.getSortProperty(),w.getSortOrder()===u.Descending));}}var B=this.getBinding("rows");if(B){if(b.length>0){B.sort(b);}this.refreshRows();}};v.prototype._toggleSelectAll=function(){if(!T.hasData(this)){return;}if(T.areAllRowsSelected(this)){this._iSourceRowIndex=-1;this.clearSelection();}else{this._iSourceRowIndex=0;this.selectAll();}this._iSourceRowIndex=undefined;};v.prototype._restoreAppDefaultsColumnHeaderSortFilter=function(){var a=this.getColumns();q.each(a,function(i,b){b._restoreAppDefaults();});};v.prototype._setBusy=function(a){var b,i,l;if(!this.getEnableBusyIndicator()||!this._bBusyIndicatorAllowed){return;}b=this.getBinding("rows");if(!b){return;}this.setBusy(false);if(a&&this._iDataRequestedCounter>0){var w=a.reason;if(a.contexts&&a.contexts.length!==undefined){l=false;for(i=0;i<a.contexts.length;i++){if(a.contexts[i]===undefined){l=true;break;}}}else if(a.changeReason===d.Expand){this.setBusy(true);}var L=b.getLength();if((w==d.Expand&&this._iDataRequestedCounter!==0)||l||(b.isInitial())||(a.receivedLength===0&&this._iDataRequestedCounter!==0)||(a.receivedLength<a.requestedLength&&a.receivedLength!==L&&a.receivedLength!==L-this.getFirstVisibleRow())){this.setBusy(true);}}};v.prototype.setBusy=function(b,B){var a=this.getBusy()!=b;B="sapUiTableCnt";var i=C.prototype.setBusy.call(this,b,B);if(a){this.fireBusyStateChanged({busy:b});}return i;};v.prototype.setEnableBusyIndicator=function(b){this.setProperty("enableBusyIndicator",b,true);};v.prototype._attachDataRequestedListeners=function(){var b=this.getBinding("rows");if(b){b.detachDataRequested(this._onBindingDataRequestedListener,this);b.detachDataReceived(this._onBindingDataReceivedListener,this);this._iDataRequestedCounter=0;b.attachDataRequested(this._onBindingDataRequestedListener,this);b.attachDataReceived(this._onBindingDataReceivedListener,this);}};v.prototype._onBindingDataRequestedListener=function(a){if(a.getSource()==this.getBinding("rows")&&!a.getParameter("__simulateAsyncAnalyticalBinding")){this._iDataRequestedCounter++;}};v.prototype._onBindingDataReceivedListener=function(a){if(a.getSource()==this.getBinding("rows")&&!a.getParameter("__simulateAsyncAnalyticalBinding")){this._iDataRequestedCounter--;}};v.prototype._attachBindingListener=function(){this._attachDataRequestedListeners();};v.prototype._setLargeDataScrolling=function(l){this._bLargeDataScrolling=!!l;};v.prototype._getSelectedIndicesCount=function(){return this.getSelectedIndices().length;};v.prototype._updateTableContent=function(){T.Grouping.updateGroups(this);};v.prototype.getCellControl=function(i,a,b){var l=T.getRowColCell(this,i,a,!b);return l.cell;};return v;});
