/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["jquery.sap.global","./library","sap/ui/core/ResizeHandler","sap/ui/core/Control","sap/m/Button"],function(q,l,R,C,B){"use strict";var F=C.extend("sap.f.FlexibleColumnLayout",{metadata:{properties:{twoColumnLayoutOnDesktop:{type:"boolean",group:"Behavior",defaultValue:false},threeColumnLayoutType:{type:"sap.f.ThreeColumnLayoutType",group:"Behavior",defaultValue:sap.f.ThreeColumnLayoutType.MidColumnEmphasized},threeColumnLayoutTypeFixed:{type:"boolean",group:"Behavior",defaultValue:true}},aggregations:{beginColumn:{type:"sap.ui.core.Control",multiple:false},midColumn:{type:"sap.ui.core.Control",multiple:false},endColumn:{type:"sap.ui.core.Control",multiple:false},_beginColumnBackArrow:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_midColumnForwardArrow:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_midColumnBackArrow:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_endColumnForwardArrow:{type:"sap.m.Button",multiple:false,visibility:"hidden"}},associations:{fullScreenColumn:{type:"sap.ui.core.Control",multiple:false}},events:{layoutChange:{parameters:{beginColumnWidth:{type:"int"},midColumnWidth:{type:"int"},endColumnWidth:{type:"int"}}}}}});F.prototype.init=function(){this._initButtons();this._oRm=sap.ui.getCore().createRenderManager();this._iControlWidth=null;this._sLayout=null;};F.prototype.onAfterRendering=function(){this._deregisterResizeHandler();this._registerResizeHandler();this._cacheDOMElements();this._iControlWidth=this.$().width();this._adjustLayout(null,true);};F.prototype.exit=function(){this._deregisterResizeHandler();this._oRm.destroy();};F.prototype.setLayout=function(c){var L;if(!c){return;}L=[c.beginColumnWidth||0,c.midColumnWidth||0,c.endColumnWidth||0];this._sLayout=L.join("/");this._adjustLayout(null,true,true);};F.prototype._registerResizeHandler=function(){this._iResizeHandlerId=R.register(this,this._onResize.bind(this));};F.prototype._deregisterResizeHandler=function(){if(this._iResizeHandlerId){R.deregister(this._iResizeHandlerId);}};F.prototype._initButtons=function(){var b=new B(this.getId()+"-beginBack",{icon:"sap-icon://slim-arrow-left",press:this._adjustLayout.bind(this,"left",false)}).addStyleClass("sapFFCLNavigationButton").addStyleClass("sapFFCLNavigationButtonRight");this.setAggregation("_beginColumnBackArrow",b,true);var m=new B(this.getId()+"-midForward",{icon:"sap-icon://slim-arrow-right",press:this._adjustLayout.bind(this,"right",false)}).addStyleClass("sapFFCLNavigationButton").addStyleClass("sapFFCLNavigationButtonLeft");this.setAggregation("_midColumnForwardArrow",m,true);var M=new B(this.getId()+"-midBack",{icon:"sap-icon://slim-arrow-left",press:this._adjustLayout.bind(this,"left",false)}).addStyleClass("sapFFCLNavigationButton").addStyleClass("sapFFCLNavigationButtonRight");this.setAggregation("_midColumnBackArrow",M,true);var e=new B(this.getId()+"-endForward",{icon:"sap-icon://slim-arrow-right",press:this._adjustLayout.bind(this,"right",false)}).addStyleClass("sapFFCLNavigationButton").addStyleClass("sapFFCLNavigationButtonLeft");this.setAggregation("_endColumnForwardArrow",e,true);};F.prototype._cacheDOMElements=function(){this._$columns={begin:this.$("beginColumn"),mid:this.$("midColumn"),end:this.$("endColumn")};this._$columnContainers={begin:this.$("beginColumn-container"),mid:this.$("midColumn-container"),end:this.$("endColumn-container")};this._$columnButtons={beginBack:this.$("beginBack"),midForward:this.$("midForward"),midBack:this.$("midBack"),endForward:this.$("endForward")};};F.prototype._flushColumnContent=function(c,o){if(this.getDomRef()){this._oRm.renderControl(o);this._oRm.flush(this._$columnContainers[c][0]);}};F.prototype.setBeginColumn=function(c){if(this.getBeginColumn()===c){return this;}var r=this.setAggregation("beginColumn",c,true);if(typeof this._$columns==="undefined"){return r;}this._flushColumnContent("begin",c);this._adjustLayout(null,false);return r;};F.prototype.setMidColumn=function(c){if(this.getMidColumn()===c){return this;}var r=this.setAggregation("midColumn",c,true);if(typeof this._$columns==="undefined"){return r;}this._flushColumnContent("mid",c);this._adjustLayout(null,false);return r;};F.prototype.setEndColumn=function(c){if(this.getEndColumn()===c){return this;}var r=this.setAggregation("endColumn",c,true);if(typeof this._$columns==="undefined"){return r;}this._flushColumnContent("end",c);this._adjustLayout(null,false);return r;};F.prototype.setFullScreenColumn=function(i){if(this.getFullScreenColumn()===i){return this;}var r=this.setAssociation("fullScreenColumn",i,true);if(typeof this._$columns==="undefined"){return r;}this._adjustLayout(null,false);return r;};F.prototype.setTwoColumnLayoutOnDesktop=function(v){var r=this.setProperty("twoColumnLayoutOnDesktop",v,true);if(typeof this._$columns==="undefined"){return r;}this._adjustLayout(null,false);return r;};F.prototype._getVisibleColumnsCount=function(){return["begin","mid","end"].filter(function(c){return this._getColumnSize(c)>0;},this).length;};F.prototype._resizeColumns=function(){var p,n,t,a,N=false,c=["begin","mid","end"],r=sap.ui.getCore().getConfiguration().getRTL(),A;if(typeof this._$columns==="undefined"){return;}t=(this._getVisibleColumnsCount()-1)*F.COLUMN_MARGIN;a=this._iControlWidth-t;c.forEach(function(s){p=this._getColumnSize(s);this._$columns[s].toggleClass("sapFFCLColumnMargin",N&&p>0);this._$columns[s].toggleClass("sapFFCLColumnActive",p>0);this._$columns[s].removeClass("sapFFCLColumnOnlyActive");this._$columns[s].removeClass("sapFFCLColumnLastActive");this._$columns[s].removeClass("sapFFCLColumnFirstActive");if([100,0].indexOf(p)!==-1){n=p+"%";}else{n=Math.round(a*(p/100))+"px";}this._$columns[s].width(n);if(p>0){N=true;}},this);A=c.filter(function(s){return this._getColumnSize(s)>0;},this);if(r){c.reverse();}if(A.length===1){this._$columns[A[0]].addClass("sapFFCLColumnOnlyActive");}if(A.length>1){this._$columns[A[0]].addClass("sapFFCLColumnFirstActive");this._$columns[A[A.length-1]].addClass("sapFFCLColumnLastActive");}};F.prototype._getColumnSize=function(c){var s=this._sLayout.split("/"),m={begin:0,mid:1,end:2},S=s[m[c]];return S;};F.prototype._onResize=function(e){var n=e.size.width;if(n===0||n===this._iControlWidth){return;}this._iControlWidth=e.size.width;if(!this.getFullScreenColumn()){this._adjustLayout(null,true);}};F.prototype._adjustLayout=function(s,r,S){var n=this._sLayout,b=this.getBeginColumn()?true:false,m=this.getMidColumn()?true:false,e=this.getEndColumn()?true:false,f=this.getFullScreenColumn(),M=this._getMaxColumns(),t=this.getThreeColumnLayoutType()===l.ThreeColumnLayoutType.EndColumnEmphasized?"25/25/50":"25/50/25",p,d,c;if(f){if(this.getBeginColumn()&&this.getBeginColumn().getId()===f){n="100/0/0";}else if(this.getMidColumn()&&this.getMidColumn().getId()===f){n="0/100/0";}else if(this.getEndColumn()&&this.getEndColumn().getId()===f){n="0/0/100";}else{}}else{if(M===3){if(!b||!m){p=["100/0/0"];d="100/0/0";}else if(!e){p=["33/67/0","67/33/0"];d="67/33/0";}else{if(this.getThreeColumnLayoutTypeFixed()){p=[t,"33/67/0","67/33/0"];}else{p=["25/25/50","25/50/25","33/67/0","67/33/0"];}d=t;}}else if(M===2){if(!b||!m){p=["100/0/0"];d="100/0/0";}else if(!e){p=["33/67/0","67/33/0"];d="67/33/0";}else{p=["0/67/33","33/67/0","67/33/0"];d="0/67/33";}}else{if(!b||!m){p=["100/0/0"];d="100/0/0";}else if(!e){p=["0/100/0","100/0/0"];d="0/100/0";}else{p=["0/0/100","0/100/0","100/0/0"];d="0/0/100";}}if(s){c=p.indexOf(n);if(s==="left"&&c>0){n=p[c-1];}else if(s==="right"&&c<p.length-1){n=p[c+1];}}else{if(!r||p.indexOf(n)===-1){n=d;}}}if(this._sLayout===n){this._resizeColumns();this._hideShowArrows();return;}this._sLayout=n;this._resizeColumns();this._hideShowArrows();if(!f&&!S){this.fireLayoutChange({beginColumnWidth:this._getColumnSize("begin"),midColumnWidth:this._getColumnSize("mid"),endColumnWidth:this._getColumnSize("end")});}};F.prototype._hideShowArrows=function(){var b=this.getBeginColumn()?true:false,m=this.getMidColumn()?true:false,e=this.getEndColumn()?true:false,M=this._getMaxColumns(),n=[];if(typeof this._$columns==="undefined"){return;}if(M===3){if(!b||!m){n=[];}else if(!e){if(this._sLayout==="33/67/0"){n=["midForward"];}else{n=["beginBack"];}}else{if(this._sLayout==="25/50/25"){if(this.getThreeColumnLayoutTypeFixed()){n=["midForward"];}else{n=["midForward","midBack"];}}else if(this._sLayout==="25/25/50"){n=["endForward"];}else if(this._sLayout==="33/67/0"){n=["midForward","midBack"];}else{n=["beginBack"];}}}else if(M===2){if(!b||!m){n=[];}else if(!e){if(this._sLayout==="33/67/0"){n=["midForward"];}else{n=["midBack"];}}else{if(this._sLayout==="0/67/33"){n=["midForward"];}else if(this._sLayout==="33/67/0"){n=["midForward","midBack"];}else{n=["beginBack"];}}}this._toggleButton("beginBack",n.indexOf("beginBack")!==-1);this._toggleButton("midForward",n.indexOf("midForward")!==-1);this._toggleButton("midBack",n.indexOf("midBack")!==-1);this._toggleButton("endForward",n.indexOf("endForward")!==-1);};F.prototype._toggleButton=function(b,s){this._$columnButtons[b].toggle(s);};F.prototype._getMaxColumns=function(){if(this._iControlWidth>=F.DESKTOP_BREAKPOINT){if(this.getTwoColumnLayoutOnDesktop()){return 2;}return 3;}if(this._iControlWidth>=F.TABLET_BREAKPOINT&&this._iControlWidth<F.DESKTOP_BREAKPOINT){return 2;}return 1;};F.COLUMN_MARGIN=8;F.DESKTOP_BREAKPOINT=1280;F.TABLET_BREAKPOINT=960;return F;},false);
