/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./Dialog','./ComboBoxTextField','./Toolbar','./Button','./Bar','./Text','./Title','sap/ui/core/IconPool','./library','sap/ui/Device'],function(q,D,C,T,B,a,b,c,I,l,d){"use strict";var e=C.extend("sap.m.ComboBoxBase",{metadata:{library:"sap.m",defaultAggregation:"items",aggregations:{items:{type:"sap.ui.core.Item",multiple:true,singularName:"item",bindable:"bindable"},picker:{type:"sap.ui.core.PopupInterface",multiple:false,visibility:"hidden"}},events:{loadItems:{}}}});e.prototype.updateItems=function(r){this.bItemsUpdated=false;this.destroyItems();this.updateAggregation("items");this.bItemsUpdated=true;if(this.hasLoadItemsEventListeners()){this.onItemsLoaded();}};e.prototype.refreshItems=function(){this.bItemsUpdated=false;this.refreshAggregation("items");};e.prototype.getList=function(){if(this.bIsDestroyed){return null;}return this._oList;};e.prototype.loadItems=function(f,o){var g=typeof f==="function";if(this.hasLoadItemsEventListeners()&&(this.getItems().length===0)){this._bOnItemsLoadedScheduled=false;if(g){o=q.extend({action:f,busyIndicator:true,busyIndicatorDelay:300},o);this.aMessageQueue.push(o);if((this.iLoadItemsEventInitialProcessingTimeoutID===-1)&&(o.busyIndicator)){this.iLoadItemsEventInitialProcessingTimeoutID=setTimeout(function onItemsNotLoadedAfterDelay(){this.setInternalBusyIndicatorDelay(0);this.setInternalBusyIndicator(true);}.bind(this),o.busyIndicatorDelay);}}if(!this.bProcessingLoadItemsEvent){this.bProcessingLoadItemsEvent=true;this.fireLoadItems();}}else if(g){f.call(this);}};e.prototype.onItemsLoaded=function(){this.bProcessingLoadItemsEvent=false;clearTimeout(this.iLoadItemsEventInitialProcessingTimeoutID);if(this.bInitialBusyIndicatorState!==this.getBusy()){this.setInternalBusyIndicator(this.bInitialBusyIndicatorState);}if(this.iInitialBusyIndicatorDelay!==this.getBusyIndicatorDelay()){this.setInternalBusyIndicatorDelay(this.iInitialBusyIndicatorDelay);}for(var i=0,m,n,f;i<this.aMessageQueue.length;i++){m=this.aMessageQueue.shift();i--;f=(i+1)===this.aMessageQueue.length;n=f?null:this.aMessageQueue[i+1];if(typeof m.action==="function"){if((m.name==="input")&&!f&&(n.name==="input")){continue;}m.action.call(this);}}};e.prototype.hasLoadItemsEventListeners=function(){return this.hasListeners("loadItems");};e.prototype._scheduleOnItemsLoadedOnce=function(){if(!this._bOnItemsLoadedScheduled&&!this.isBound("items")&&this.hasLoadItemsEventListeners()&&this.bProcessingLoadItemsEvent){this._bOnItemsLoadedScheduled=true;setTimeout(this.onItemsLoaded.bind(this),0);}};e.prototype.init=function(){C.prototype.init.apply(this,arguments);this.setPickerType(d.system.phone?"Dialog":"Dropdown");if(d.system.phone){this.attachEvent("_change",this.onPropertyChange,this);}this.createPicker(this.getPickerType());this.bItemsUpdated=false;this.bOpenedByKeyboardOrButton=false;this.bProcessingLoadItemsEvent=false;this.iLoadItemsEventInitialProcessingTimeoutID=-1;this.aMessageQueue=[];this.bInitialBusyIndicatorState=this.getBusy();this.iInitialBusyIndicatorDelay=this.getBusyIndicatorDelay();this._bOnItemsLoadedScheduled=false;this._bDoTypeAhead=true;};e.prototype.exit=function(){C.prototype.exit.apply(this,arguments);if(this.getList()){this.getList().destroy();this._oList=null;}clearTimeout(this.iLoadItemsEventInitialProcessingTimeoutID);this.aMessageQueue=null;};e.prototype.ontouchstart=function(E){if(!this.getEnabled()||!this.getEditable()){return;}E.setMarked();if(this.isOpenArea(E.target)){this.addStyleClass(this.getRenderer().CSS_CLASS_COMBOBOXBASE+"Pressed");}};e.prototype.ontouchend=function(E){if(!this.getEnabled()||!this.getEditable()){return;}E.setMarked();if(!this.isOpen()&&this.isOpenArea(E.target)){this.removeStyleClass(this.getRenderer().CSS_CLASS_COMBOBOXBASE+"Pressed");}};e.prototype.ontap=function(E){C.prototype.ontap.apply(this,arguments);var f=this.getRenderer().CSS_CLASS_COMBOBOXBASE,o=E.srcControl;if(!this.getEnabled()||!this.getEditable()){return;}E.setMarked();if(o.isOpenArea&&o.isOpenArea(E.target)){if(this.isOpen()){this.close();this.removeStyleClass(f+"Pressed");return;}this.bOpenedByKeyboardOrButton=true;this.loadItems();this.open();}if(this.isOpen()){this.addStyleClass(f+"Pressed");}};e.prototype.onsapshow=function(E){if(!this.getEnabled()||!this.getEditable()){return;}E.setMarked();if(E.keyCode===q.sap.KeyCodes.F4){E.preventDefault();}if(this.isOpen()){this.close();return;}this.selectText(0,this.getValue().length);this.loadItems();this.bOpenedByKeyboardOrButton=true;this.open();};e.prototype.onsapescape=function(E){if(this.getEnabled()&&this.getEditable()&&this.isOpen()){E.setMarked();E.preventDefault();this.close();}else{C.prototype.onsapescape.apply(this,arguments);}};e.prototype.onsaphide=e.prototype.onsapshow;e.prototype.onsapfocusleave=function(E){if(!E.relatedControlId){C.prototype.onsapfocusleave.apply(this,arguments);return;}var r=sap.ui.getCore().byId(E.relatedControlId);if(r===this){return;}var p=this.getAggregation("picker"),f=r&&r.getFocusDomRef();if(p&&q.sap.containsOrEquals(p.getFocusDomRef(),f)){return;}C.prototype.onsapfocusleave.apply(this,arguments);};e.prototype.getPopupAnchorDomRef=function(){return this.getDomRef();};e.prototype.addContent=function(p){};e.prototype.setPickerType=function(p){this._sPickerType=p;};e.prototype.getPickerType=function(){return this._sPickerType;};e.prototype.isPickerDialog=function(){return this.getPickerType()==="Dialog";};e.prototype.isPlatformTablet=function(){var n=!d.system.combi,t=d.system.tablet&&n;return t;};e.prototype.createPicker=function(p){};e.prototype.onBeforeClose=function(){this.bOpenedByKeyboardOrButton=false;};e.prototype.getPicker=function(){if(this.bIsDestroyed){return null;}return this.createPicker(this.getPickerType());};e.prototype.getPickerTextField=function(){var p=this.getPicker(),s=p.getSubHeader();return s&&s.getContent()[0]||null;};e.prototype.getPickerTitle=function(){var p=this.getPicker(),h=p&&p.getCustomHeader();if(this.isPickerDialog()&&h){return h.getContentMiddle()[0];}return null;};e.prototype.createDialog=function(){var t=this,o=this.createPickerTextField(),f=o._handleEvent;o._handleEvent=function(E){f.apply(this,arguments);if(/keydown|sapdown|sapup|saphome|sapend|sappagedown|sappageup|input/.test(E.type)){t._handleEvent(E);}};return new D({stretch:true,customHeader:t.createPickerHeader(),buttons:this.createPickerCloseButton(),subHeader:new T({content:o}),beforeOpen:function(){t.updatePickerHeaderTitle();}});};e.prototype.createPickerHeader=function(){var t=this,i=I.getIconURI("decline");return new a({contentMiddle:new c(),contentRight:new B({icon:i,press:function(){t.close();t.revertSelection();}})});};e.prototype.revertSelection=function(){};e.prototype.updatePickerHeaderTitle=function(){var p=this.getPicker(),r=sap.ui.getCore().getLibraryResourceBundle("sap.m"),L,f;if(!p){return;}f=this.getLabels();if(f.length){L=f[0];if(L&&(typeof L.getText==="function")){this.getPickerTitle().setText(L.getText());}}else{this.getPickerTitle().setText(r.getText("COMBOBOX_PICKER_TITLE"));}};e.prototype.createPickerCloseButton=function(){var t=this,o,r=sap.ui.getCore().getLibraryResourceBundle("sap.m");return new B({text:r.getText("COMBOBOX_CLOSE_BUTTON"),press:function(){o=t.getPickerTextField();t.updateDomValue(o.getValue());t.onChange();t.close();}});};e.prototype.hasContent=function(){return this.getItems().length>0;};e.prototype.findFirstEnabledItem=function(i){var L=this.getList();return L?L.findFirstEnabledItem(i):null;};e.prototype.findLastEnabledItem=function(i){var L=this.getList();return L?L.findLastEnabledItem(i):null;};e.prototype.open=function(){var p=this.getPicker();if(p){p.open();}return this;};e.prototype.getVisibleItems=function(){var L=this.getList();return L?L.getVisibleItems():[];};e.prototype.isItemSelected=function(){};e.prototype.getKeys=function(f){f=f||this.getItems();for(var i=0,k=[];i<f.length;i++){k[i]=f[i].getKey();}return k;};e.prototype.getSelectableItems=function(){var L=this.getList();return L?L.getSelectableItems():[];};e.prototype.findItem=function(p,v){var L=this.getList();return L?L.findItem(p,v):null;};e.prototype.getItemByText=function(t){return this.findItem("text",t);};e.prototype.scrollToItem=function(i){var p=this.getPicker(),P=p.getDomRef("cont"),o=i&&i.getDomRef();if(!p||!P||!o){return;}var f=P.scrollTop,g=o.offsetTop,h=P.clientHeight,j=o.offsetHeight;if(f>g){P.scrollTop=g;}else if((g+j)>(f+h)){P.scrollTop=Math.ceil(g+j-h);}};e.prototype.clearFilter=function(){for(var i=0,f=this.getItems();i<f.length;i++){f[i].bVisible=true;}};e.prototype.onItemChange=function(o){};e.prototype.clearSelection=function(){};e.prototype.setInternalBusyIndicator=function(f){this.bInitialBusyIndicatorState=this.getBusy();return this.setBusy.apply(this,arguments);};e.prototype.setInternalBusyIndicatorDelay=function(i){this.iInitialBusyIndicatorDelay=this.getBusyIndicatorDelay();return this.setBusyIndicatorDelay.apply(this,arguments);};e.prototype.addItem=function(i){this.addAggregation("items",i);if(i){i.attachEvent("_change",this.onItemChange,this);}this._scheduleOnItemsLoadedOnce();return this;};e.prototype.insertItem=function(i,f){this.insertAggregation("items",i,f,true);if(i){i.attachEvent("_change",this.onItemChange,this);}this._scheduleOnItemsLoadedOnce();return this;};e.prototype.getItemAt=function(i){return this.getItems()[+i]||null;};e.prototype.getFirstItem=function(){return this.getItems()[0]||null;};e.prototype.getLastItem=function(){var i=this.getItems();return i[i.length-1]||null;};e.prototype.getEnabledItems=function(i){var L=this.getList();return L?L.getEnabledItems(i):[];};e.prototype.getItemByKey=function(k){var L=this.getList();return L?L.getItemByKey(k):null;};e.prototype.isOpen=function(){var p=this.getAggregation("picker");return!!(p&&p.isOpen());};e.prototype.close=function(){var p=this.getAggregation("picker");if(p){p.close();}return this;};e.prototype.removeItem=function(i){var L=this.getList();i=L?L.removeItem(i):null;if(i){i.detachEvent("_change",this.onItemChange,this);}return i;};e.prototype.removeAllItems=function(){var L=this.getList(),f=L?L.removeAllItems():[];this.clearSelection();for(var i=0;i<f.length;i++){f[i].detachEvent("_change",this.onItemChange,this);}return f;};e.prototype.destroyItems=function(){var L=this.getList();if(L){L.destroyItems();}return this;};return e;},true);
