/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./library','sap/ui/core/Control','sap/m/Text','sap/ui/core/HTML','sap/ui/core/Icon','sap/ui/core/IconPool','sap/m/GenericTileRenderer','sap/m/GenericTileLineModeRenderer','sap/ui/Device','sap/ui/core/ResizeHandler'],function(q,l,C,T,H,I,a,G,L,D,R){"use strict";var b=C.extend("sap.m.GenericTile",{metadata:{library:"sap.m",properties:{"mode":{type:"sap.m.GenericTileMode",group:"Appearance",defaultValue:sap.m.GenericTileMode.ContentMode},"header":{type:"string",group:"Appearance",defaultValue:null},"subheader":{type:"string",group:"Appearance",defaultValue:null},"failedText":{type:"string",group:"Appearance",defaultValue:null},"size":{type:"sap.m.Size",group:"Misc",defaultValue:sap.m.Size.Auto},"frameType":{type:"sap.m.FrameType",group:"Misc",defaultValue:sap.m.FrameType.OneByOne},"backgroundImage":{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},"headerImage":{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},"state":{type:"sap.m.LoadState",group:"Misc",defaultValue:sap.m.LoadState.Loaded},"imageDescription":{type:"string",group:"Misc",defaultValue:null}},aggregations:{"tileContent":{type:"sap.m.TileContent",multiple:true,bindable:"bindable"},"icon":{type:"sap.ui.core.Control",multiple:false},"_titleText":{type:"sap.m.Text",multiple:false,visibility:"hidden"},"_failedMessageText":{type:"sap.m.Text",multiple:false,visibility:"hidden"}},events:{"press":{}}},renderer:function(r,c){if(c.getMode()===l.GenericTileMode.LineMode){L.render(r,c);}else{G.render(r,c);}}});b.prototype.init=function(){this._rb=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._oTitle=new T(this.getId()+"-title");this._oTitle.addStyleClass("sapMGTTitle");this._oTitle.cacheLineHeight=false;this.setAggregation("_titleText",this._oTitle,true);this._sFailedToLoad=this._rb.getText("INFOTILE_CANNOT_LOAD_TILE");this._sLoading=this._rb.getText("INFOTILE_LOADING");this._oFailedText=new T(this.getId()+"-failed-txt",{maxLines:2});this._oFailedText.cacheLineHeight=false;this._oFailedText.addStyleClass("sapMGTFailed");this.setAggregation("_failedMessageText",this._oFailedText,true);this._oWarningIcon=new I(this.getId()+"-warn-icon",{src:"sap-icon://notification",size:"1.375rem"});this._oWarningIcon.addStyleClass("sapMGTFtrFldIcnMrk");this._oBusy=new H(this.getId()+"-overlay");this._oBusy.setBusyIndicatorDelay(0);this._bThemeApplied=true;if(!sap.ui.getCore().isInitialized()){this._bThemeApplied=false;sap.ui.getCore().attachInit(this._handleCoreInitialized.bind(this));}else{this._handleCoreInitialized();}};b.prototype._handleCoreInitialized=function(){this._bThemeApplied=sap.ui.getCore().isThemeApplied();if(!this._bThemeApplied){sap.ui.getCore().attachThemeChanged(this._handleThemeApplied,this);}};b.prototype._handleThemeApplied=function(){this._bThemeApplied=true;this._oTitle.clampHeight();sap.ui.getCore().detachThemeChanged(this._handleThemeApplied,this);};b.prototype.onBeforeRendering=function(){var s=this.getSubheader()?true:false;if(this.getMode()===l.GenericTileMode.HeaderMode){this._applyHeaderMode(s);}else{this._applyContentMode(s);}var t=this.getTileContent().length;for(var i=0;i<t;i++){this.getTileContent()[i].setDisabled(this.getState()==sap.m.LoadState.Disabled);}this._generateFailedText();this.$().unbind("mouseenter",this._updateAriaAndTitle);this.$().unbind("mouseleave",this._removeTooltipFromControl);if(this._sParentResizeListenerId){R.deregister(this._sResizeListenerId);this._sParentResizeListenerId=null;}if(this._$RootNode){this._$RootNode.off(this._getAnimationEvents());}sap.ui.getCore().detachIntervalTimer(this._checkContentDensity,this);};b.prototype.onAfterRendering=function(){this.$().bind("mouseenter",this._updateAriaAndTitle.bind(this));this.$().bind("mouseleave",this._removeTooltipFromControl.bind(this));this._bCompact=this._isCompact();var m=this.getMode();if(m===l.GenericTileMode.LineMode&&this._bCompact){this.$().parent().addClass("sapMGTLineModeContainer");this._updateHoverStyle(true);if(this.getParent()instanceof C){this._sParentResizeListenerId=R.register(this.getParent(),this._handleResize.bind(this));}else{this._sParentResizeListenerId=R.register(this.$().parent(),this._handleResize.bind(this));}}if(m===l.GenericTileMode.LineMode&&this._bUpdateLineTileSiblings){this._updateLineTileSiblings();this._bUpdateLineTileSiblings=false;}if(m===l.GenericTileMode.LineMode){sap.ui.getCore().attachIntervalTimer(this._checkContentDensity,this);}};b.prototype._handleResize=function(){if(this.getMode()===l.GenericTileMode.LineMode&&this._isCompact()&&this.getParent()){this._queueAnimationEnd();}};b.prototype._checkContentDensity=function(){if(this.$().length>0){var c=this.$().is(".sapUiSizeCompact")||this.$().closest(".sapUiSizeCompact").length>0;if(c!==this._bCompact){this._bCompact=c;sap.ui.getCore().detachIntervalTimer(this._checkContentDensity);this.invalidate();}}};b.prototype._calculateStyleData=function(){this.$("lineBreak").remove();if(!this._isCompact()||!this.getDomRef()||this.$().is(":hidden")){return null;}var $=this.$(),e=this.$("endMarker"),s=this.$("startMarker");if(e.length===0||s.length===0){return null;}var c=this._getLineCount(),B,d,f=Math.ceil(L._getCSSPixelValue(this,"margin-top")),g,A=this.$().parent().innerWidth(),h=Math.ceil(L._getCSSPixelValue(this,"min-height")),j=L._getCSSPixelValue(this,"line-height"),k=this.$().is(":not(:first-child)")&&c>1,m=q("<span><br /></span>"),i=0,r=sap.ui.getCore().getConfiguration().getRTL(),E=e.position();if(k){m.attr("id",this.getId()+"-lineBreak");$.prepend(m);c=this._getLineCount();E=e.position();}var S={rtl:r,lineBreak:k,startOffset:s.offset(),endOffset:e.offset(),availableWidth:A,lines:[]};var o;if(D.browser.msie||D.browser.edge){o=m.find("br").position();}else{o=m.position();}var n=o;if(!(D.browser.mozilla||D.browser.msie||D.browser.edge)&&o.left<E.left){n=E;}S.positionLeft=k?o.left:$.position().left;S.positionRight=k?$.width()-n.left:S.availableWidth-$.position().left;if(!k&&c>1){S.positionRight=s.parent().innerWidth()-(s.position().left+s.width());}for(i;i<c;i++){if(k&&i===0){continue;}if(c===1){B=r?S.availableWidth-S.positionLeft:S.positionLeft;g=$.width();}else if(i===c-1){B=0;g=r?$.width()-E.left:E.left;}else if(k&&i===1){B=0;g=A;}else{B=0;g=A;}d=i*j+f;S.lines.push({offset:{x:B,y:d},width:g,height:h});}return S;};b.prototype._getStyleData=function(){var s=this._calculateStyleData();if(!q.sap.equal(this._oStyleData,s)){delete this._oStyleData;this._oStyleData=s;return true;}return false;};b.prototype._getAnimationEvents=function(){return"transitionend.sapMGT$id animationend.sapMGT$id".replace(/\$id/g,q.sap.camelCase(this.getId()));};b.prototype._updateHoverStyle=function(f){if(!this._getStyleData()&&!f){return;}this._clearAnimationUpdateQueue();this._cHoverStyleUpdates=-1;this._oAnimationEndCallIds={};if(this._oStyleData&&this._oStyleData.lineBreak&&this.getUIArea()){this._$RootNode=q(this.getUIArea().getRootNode());this._$RootNode.on(this._getAnimationEvents(),this._queueAnimationEnd.bind(this));}this._queueAnimationEnd();};b.prototype._queueAnimationEnd=function(e){if(e){var t=q(e.target);if(t.is(".sapMGT, .sapMGT *")){return false;}}if(typeof this._cHoverStyleUpdates!=="number"){this._cHoverStyleUpdates=-1;}if(!this._oAnimationEndCallIds){this._oAnimationEndCallIds={};}this._cHoverStyleUpdates++;var c=q.sap.delayedCall(10,this,this._handleAnimationEnd,[this._cHoverStyleUpdates]);this._oAnimationEndCallIds[this._cHoverStyleUpdates]=c;};b.prototype._handleAnimationEnd=function(h){delete this._oAnimationEndCallIds[h];if(this._cHoverStyleUpdates===h){this._getStyleData();L._updateHoverStyle.call(this);}};b.prototype._clearAnimationUpdateQueue=function(){for(var k in this._oAnimationEndCallIds){q.sap.clearDelayedCall(this._oAnimationEndCallIds[k]);delete this._oAnimationEndCallIds[k];}};b.prototype._getLineCount=function(){var c=this.getDomRef().getBoundingClientRect(),d=L._getCSSPixelValue(this,"line-height");return Math.round(c.height/d);};b.prototype.getBoundingRects=function(){var p=this.$().position();if(this.getMode()===l.GenericTileMode.LineMode&&this._isCompact()){this._getStyleData();var r=[];for(var i=0;i<this._oStyleData.lines.length;i++){r[i]=this._oStyleData.lines[i];if(this._oStyleData.rtl){r[i].offset.x=this._oStyleData.availableWidth-r[i].width;}r[i].offset.y+=p.top;}return r;}else{return[{offset:{x:p.left,y:p.top},width:this.$().width(),height:this.$().height()}];}};b.prototype._updateLineTileSiblings=function(){var p=this.getParent();if(this.getMode()===l.GenericTileMode.LineMode&&this._isCompact()&&p){var i=p.indexOfAggregation(this.sParentAggregationName,this);var s=p.getAggregation(this.sParentAggregationName).splice(i+1);for(i=0;i<s.length;i++){var S=s[i];if(S instanceof sap.m.GenericTile&&S.getMode()===l.GenericTileMode.LineMode){S._updateHoverStyle();}}}};b.prototype.exit=function(){if(this._sParentResizeListenerId){R.deregister(this._sResizeListenerId);this._sParentResizeListenerId=null;}sap.ui.getCore().detachIntervalTimer(this._checkContentDensity,this);if(this._$RootNode){this._$RootNode.off(this._getAnimationEvents());this._$RootNode=null;}this._clearAnimationUpdateQueue();this._oWarningIcon.destroy();if(this._oImage){this._oImage.destroy();}this._oBusy.destroy();};b.prototype.ontouchstart=function(){if(this.$("hover-overlay").length>0){this.$("hover-overlay").addClass("sapMGTPressActive");}if(this.getMode()===l.GenericTileMode.LineMode){this.addStyleClass("sapMGTLineModePress");}if(D.browser.internet_explorer&&this.getState()!==sap.m.LoadState.Disabled){this.$().focus();}};b.prototype.ontouchcancel=function(){if(this.$("hover-overlay").length>0){this.$("hover-overlay").removeClass("sapMGTPressActive");}};b.prototype.ontouchend=function(){if(this.$("hover-overlay").length>0){this.$("hover-overlay").removeClass("sapMGTPressActive");}if(this.getMode()===l.GenericTileMode.LineMode){this.removeStyleClass("sapMGTLineModePress");}if(D.browser.internet_explorer&&this.getState()!==sap.m.LoadState.Disabled){this.$().focus();}};b.prototype.ontap=function(e){if(this.getState()!==sap.m.LoadState.Disabled){if(D.browser.internet_explorer){this.$().focus();}this.firePress();e.preventDefault();}};b.prototype.onkeydown=function(e){if(q.sap.PseudoEvents.sapselect.fnCheck(e)&&this.getState()!==sap.m.LoadState.Disabled){if(this.$("hover-overlay").length>0){this.$("hover-overlay").addClass("sapMGTPressActive");}e.preventDefault();}};b.prototype.onkeyup=function(e){if(q.sap.PseudoEvents.sapselect.fnCheck(e)&&this.getState()!==sap.m.LoadState.Disabled){if(this.$("hover-overlay").length>0){this.$("hover-overlay").removeClass("sapMGTPressActive");}this.firePress();e.preventDefault();}};b.prototype.setProperty=function(p){sap.ui.core.Control.prototype.setProperty.apply(this,arguments);var c=["state","subheader","header"];if(this.getMode()===l.GenericTileMode.LineMode&&c.indexOf(p)!==-1){this._bUpdateLineTileSiblings=true;}return this;};b.prototype.getHeader=function(){return this._oTitle.getText();};b.prototype.setHeader=function(t){this._oTitle.setText(t);return this;};b.prototype.setHeaderImage=function(u){var v=!q.sap.equal(this.getHeaderImage(),u);if(v){if(this._oImage){this._oImage.destroy();this._oImage=undefined;}if(u){this._oImage=a.createControlByURI({id:this.getId()+"-icon-image",src:u},sap.m.Image);this._oImage.addStyleClass("sapMGTHdrIconImage");}}return this.setProperty("headerImage",u);};b.prototype._applyHeaderMode=function(s){if(s){this._oTitle.setMaxLines(4);}else{this._oTitle.setMaxLines(5);}this._changeTileContentContentVisibility(false);};b.prototype._applyContentMode=function(s){if(s){this._oTitle.setMaxLines(2);}else{this._oTitle.setMaxLines(3);}this._changeTileContentContentVisibility(true);};b.prototype._changeTileContentContentVisibility=function(v){var t;t=this.getTileContent();for(var i=0;i<t.length;i++){t[i].setRenderContent(v);}};b.prototype._getHeaderAriaAndTooltipText=function(){var t="";var i=true;if(this.getHeader()){t+=this.getHeader();i=false;}if(this.getSubheader()){t+=(i?"":"\n")+this.getSubheader();i=false;}if(this.getImageDescription()){t+=(i?"":"\n")+this.getImageDescription();}return t;};b.prototype._getContentAriaAndTooltipText=function(){var t="";var c=true;var d=this.getTileContent();for(var i=0;i<d.length;i++){if(q.isFunction(d[i]._getAriaAndTooltipText)){t+=(c?"":"\n")+d[i]._getAriaAndTooltipText();}else if(d[i].getTooltip_AsString()){t+=(c?"":"\n")+d[i].getTooltip_AsString();}c=false;}return t;};b.prototype._getAriaAndTooltipText=function(){var A=(this.getTooltip_AsString()&&!this._isTooltipSuppressed())?this.getTooltip_AsString():(this._getHeaderAriaAndTooltipText()+"\n"+this._getContentAriaAndTooltipText());switch(this.getState()){case sap.m.LoadState.Disabled:return"";case sap.m.LoadState.Loading:return A+"\n"+this._sLoading;case sap.m.LoadState.Failed:return A+"\n"+this._oFailedText.getText();default:if(q.trim(A).length===0){return"";}else{return A;}}};b.prototype._getAriaText=function(){var A=this.getTooltip_Text();if(!A||this._isTooltipSuppressed()){A=this._getAriaAndTooltipText();}return A;};b.prototype._getTooltipText=function(){var t=this.getTooltip_Text();if(this._isTooltipSuppressed()===true){t=null;}return t;};b.prototype._checkFooter=function(t,c){if(c.getProperty("state")===sap.m.LoadState.Failed){t.setRenderFooter(false);}else{t.setRenderFooter(true);}};b.prototype._generateFailedText=function(){var c=this.getFailedText();var f=c?c:this._sFailedToLoad;this._oFailedText.setText(f);this._oFailedText.setTooltip(f);};b.prototype._isTooltipSuppressed=function(){var t=this.getTooltip_Text();if(t&&t.length>0&&q.trim(t).length===0){return true;}else{return false;}};b.prototype._isHeaderTextTruncated=function(){var d,m;d=this.getAggregation("_titleText").getDomRef("inner");m=this.getAggregation("_titleText").getClampHeight(d);if(d&&m<d.scrollHeight){return true;}else{return false;}};b.prototype._isSubheaderTextTruncated=function(){var s=this.$("subHdr-text");if(s&&s.length&&s[0].offsetWidth<s[0].scrollWidth){return true;}else{return false;}};b.prototype._setTooltipFromControl=function(){var c,t="";var d=true;var e=this.getTileContent();if(this._isHeaderTextTruncated()){t=this._oTitle.getText();d=false;}if(this._isSubheaderTextTruncated()){t+=(d?"":"\n")+this.getSubheader();d=false;}for(var i=0;i<e.length;i++){c=e[i].getContent();if(c&&c.getMetadata().getLibraryName()==="sap.suite.ui.microchart"){t+=(d?"":"\n")+c.getTooltip_AsString();}d=false;}if(t&&!this._getTooltipText()&&!this._isTooltipSuppressed()){this.$().attr("title",t);this._bTooltipFromControl=true;}};b.prototype._updateAriaAndTitle=function(){var A=this._getAriaAndTooltipText();var s=this._getAriaText();var t=this.$();if(t.attr("title")!==A){t.attr("aria-label",s);}t.find('*').removeAttr("aria-label").removeAttr("title").unbind("mouseenter");this._setTooltipFromControl();};b.prototype._removeTooltipFromControl=function(){if(this._bTooltipFromControl){this.$().removeAttr("title");this._bTooltipFromControl=false;}};b.prototype._isCompact=function(){return b.__getContentDensity(this)==="sapUiSizeCompact";};b.__getContentDensity=function(c){var s;var d=["sapUiSizeCompact","sapUiSizeCondensed","sapUiSizeCozy"];var g=function(f,o){if(!o[f]){return;}for(var i=0;i<d.length;i++){if(o[f](d[i])){return d[i];}}};var $=c.$();if($.length>0){s=g("hasClass",$);}else{s=g("hasStyleClass",c);}if(s){return s;}var p=null;var P=c.getParent();if(P){do{s=g("hasStyleClass",P);if(s){return s;}if(P.getDomRef){p=P.getDomRef();}else if(P.getRootNode){p=P.getRootNode();}if(!p&&P.getParent){P=P.getParent();}else{P=null;}}while(P&&!p);}$=q(p||document.body);s=g("hasClass",$.closest("."+d.join(",.")));return s;};return b;},true);
