/*
 * ! UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./ColumnListItem','./P13nPanel','./P13nColumnsItem','./SearchField','./Table','./library','sap/ui/core/Control','sap/ui/model/json/JSONModel'],function(q,C,P,a,S,T,l,b,J){"use strict";var c=P.extend("sap.m.P13nSelectionPanel",{metadata:{library:"sap.m",aggregations:{columnsItems:{type:"sap.m.P13nColumnsItem",multiple:true,singularName:"columnsItem",bindable:"bindable"},content:{type:"sap.ui.core.Control",multiple:true,singularName:"content",visibility:"hidden"}}},renderer:function(r,o){r.write("<div");r.writeControlData(o);r.addClass("sapMP13nColumnsPanel");r.writeClasses();r.write(">");var d=o.getAggregation("content");if(d){d.forEach(function(e){r.renderControl(e);});}r.write("</div>");}});c.prototype.getOkPayload=function(){this._syncModel2Panel();return{columnsItems:this.getColumnsItems()};};c.prototype.init=function(){this.setType(sap.m.P13nPanelType.selection);var t=this;this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._bOnAfterRenderingFirstTimeExecuted=false;var m=new J({items:[],indexOfMarkedTableItem:-1,markedTableItem:null,showOnlySelectedItems:false,countOfSelectedItems:0,countOfItems:0});m.setDefaultBindingMode(sap.ui.model.BindingMode.TwoWay);m.setSizeLimit(1000);this.setModel(m,"$sapmP13nSelectionPanel");this._createTable();this._createToolbar();this.setVerticalScrolling(false);var s=new sap.m.ScrollContainer({horizontal:false,vertical:true,content:[this._oTable],width:'100%',height:'100%'});this._fnHandleResize=function(){var d=false,i,e;if(t.getParent){var $=null,f,h;var p=t.getParent();var o=t._getToolbar();if(p){$=q("#"+p.getId()+"-cont");if($.children().length>0&&o.$().length>0){i=s.$()[0].clientHeight;f=$.children()[0].clientHeight;h=o?o.$()[0].clientHeight:0;e=f-h;if(i!==e){s.setHeight(e+'px');d=true;}}}}return d;};this.addAggregation("content",s);this._sContainerResizeListener=sap.ui.core.ResizeHandler.register(s,this._fnHandleResize);};c.prototype.onBeforeRendering=function(){var m=this.getModel("$sapmP13nSelectionPanel");var d=m.getData();this.getColumnsItems().forEach(function(o){var M=this._getModelItemByColumnKey(o.getColumnKey());if(!M||this._isColumnsItemEqualToModelItem(o,M)){return;}M.persistentIndex=o.getIndex();M.persistentSelected=o.getVisible();this._sortModelItemsByPersistentIndex(d.items);this._updateModelItemsTableIndex(d);this._updateCounts(d);},this);m.refresh();if(!d.markedTableItem){var v=this._getVisibleTableItems();this._switchMarkedTableItemTo(v[0]);}};c.prototype.onAfterRendering=function(){var t=this,L=0;if(!this._bOnAfterRenderingFirstTimeExecuted){this._bOnAfterRenderingFirstTimeExecuted=true;window.clearTimeout(L);L=window.setTimeout(function(){t._fnHandleResize();},0);}};c.prototype.addItem=function(i){var m=this.getModel("$sapmP13nSelectionPanel");var d=m.getData();this.addAggregation("items",i);this._includeModelItem(i,-1);this._sortModelItemsByPersistentIndex(d.items);this._updateModelItemsTableIndex(d);this._updateCounts(d);return this;};c.prototype.insertItem=function(i,I){var m=this.getModel("$sapmP13nSelectionPanel");var d=m.getData();this.insertAggregation("items",i,I);this._includeModelItem(i,I);this._sortModelItemsByPersistentIndex(d.items);this._updateModelItemsTableIndex(d);this._updateCounts(d);return this;};c.prototype.removeItem=function(i){var I=this.indexOfItem(i);if(I>-1){var m=this.getModel("$sapmP13nSelectionPanel");var d=m.getData();m.getData().items.splice(I,1);this._sortModelItemsByPersistentIndex(d.items);this._updateModelItemsTableIndex(d);this._updateCounts(d);}i=this.removeAggregation("items",i);return i;};c.prototype.removeAllItems=function(){var m=this.getModel("$sapmP13nSelectionPanel");var i=this.removeAllAggregation("items");m.getData().items=[];return i;};c.prototype.destroyItems=function(){var m=this.getModel("$sapmP13nSelectionPanel");this.destroyAggregation("items");m.getData().items=[];return this;};c.prototype.addColumnsItem=function(o){var m=this.getModel("$sapmP13nSelectionPanel");var d=m.getData();this.addAggregation("columnsItems",o);var M=this._getModelItemByColumnKey(o.getColumnKey());if(!M){return;}M.persistentIndex=o.getIndex();M.persistentSelected=o.getVisible();M.persistentWidth=o.getWidth();this._sortModelItemsByPersistentIndex(d.items);this._updateModelItemsTableIndex(d);this._updateCounts(d);return this;};c.prototype.insertColumnsItem=function(o,i){var m=this.getModel("$sapmP13nSelectionPanel");var d=m.getData();this.insertAggregation("columnsItems",o,i);var M=this._getModelItemByColumnKey(o.getColumnKey());if(!M){return;}M.persistentIndex=o.getIndex();M.persistentSelected=o.getVisible();M.persistentWidth=o.getWidth();this._sortModelItemsByPersistentIndex(d.items);this._updateModelItemsTableIndex(d);this._updateCounts(d);return this;};c.prototype.removeColumnsItem=function(o){var m=this.getModel("$sapmP13nSelectionPanel");var d=m.getData();o=this.removeAggregation("columnsItems",o);var M=this._getModelItemByColumnKey(o.getColumnKey());if(!M){return;}M.persistentIndex=-1;M.persistentSelected=undefined;M.persistentWidth=undefined;this._sortModelItemsByPersistentIndex(d.items);this._updateModelItemsTableIndex(d);this._updateCounts(d);return o;};c.prototype.removeAllColumnsItems=function(){var m=this.getModel("$sapmP13nSelectionPanel");var d=m.getData();this.getColumnsItems().forEach(function(o){var M=this._getModelItemByColumnKey(o.getColumnKey());if(!M){return;}M.persistentIndex=-1;M.persistentSelected=undefined;M.persistentWidth=undefined;},this);this._sortModelItemsByPersistentIndex(d.items);this._updateModelItemsTableIndex(d);this._updateCounts(d);var e=this.removeAllAggregation("columnsItems");return e;};c.prototype.destroyColumnsItems=function(){var m=this.getModel("$sapmP13nSelectionPanel");var d=m.getData();this.getColumnsItems().forEach(function(o){var M=this._getModelItemByColumnKey(o.getColumnKey());if(!M){return;}M.persistentIndex=-1;M.persistentSelected=undefined;M.persistentWidth=undefined;},this);this._sortModelItemsByPersistentIndex(d.items);this._updateModelItemsTableIndex(d);this._updateCounts(d);this.destroyAggregation("columnsItems");return this;};c.prototype.onBeforeNavigationFrom=function(){this._syncModel2Panel();return P.prototype.onBeforeNavigationFrom.apply(this,arguments);};c.prototype.exit=function(){sap.ui.core.ResizeHandler.deregister(this._sContainerResizeListener);this._sContainerResizeListener=null;this._getToolbar().destroy();this._oTable.destroy();this._oTable=null;if(this.getModel("$sapmP13nSelectionPanel")){this.getModel("$sapmP13nSelectionPanel").destroy();}};c.prototype._syncModel2Panel=function(){var d=this.getModel("$sapmP13nSelectionPanel").getData();d.items.forEach(function(m){var o=this._getColumnsItemByColumnKey(m.columnKey);if(o){if(!this._isColumnsItemEqualToModelItem(o,m)){o.setProperty("visible",m.persistentSelected,true);o.setProperty("index",m.persistentIndex,true);}return;}if(!m.persistentSelected){return;}o=new sap.m.P13nColumnsItem({columnKey:m.columnKey,visible:m.persistentSelected,index:m.persistentIndex,width:m.persistentWidth});this.addAggregation("columnsItems",o,true);},this);};c.prototype._moveMarkedTableItem=function(d){var D=this.getModel("$sapmP13nSelectionPanel").getData();if(!D.markedTableItem||D.indexOfMarkedTableItem<0){return;}var v=this._getVisibleTableItems();if(v.indexOf(D.markedTableItem)<0){return;}var f=function(){switch(d){case"Down":return D.indexOfMarkedTableItem+1;case"Bottom":return V.length-1;case"Up":return D.indexOfMarkedTableItem-1;case"Top":return 0;}};var V=this._getVisibleModelItems();var m=V[D.indexOfMarkedTableItem];var M=V[f()];if(this._moveModelItems(this._getModelItemIndexByColumnKey(m.columnKey),this._getModelItemIndexByColumnKey(M.columnKey))){this._switchMarkedTableItemTo(v[f()]);}};c.prototype._filterModelItemsBySearchText=function(){var m=this.getModel("$sapmP13nSelectionPanel");var s=this._getSearchText();s=s.replace(/(^\s+)|(\s+$)/g,'');s=s.replace(/[-\/\\^$*+?.()|[\]{}]/g,'\\$&');var r=new RegExp(s,'igm');if(!r){return;}this._getVisibleModelItems().forEach(function(M){M.visible=false;if(M.text&&M.text.match(r)){M.visible=true;}if(M.tooltip&&M.tooltip.match(r)){M.visible=true;}});m.refresh();};c.prototype._scrollToSelectedItem=function(i){var f=null;if(i){sap.ui.getCore().applyChanges();if(!!i.getDomRef()){f=document.activeElement;i.focus();if(f&&f.focus){f.focus();}}}};c.prototype._includeModelItem=function(i,I){var m=this.getModel("$sapmP13nSelectionPanel");var d=m.getData();if(I<0){I=d.items.length;}var M={columnKey:i.getColumnKey(),visible:true,text:i.getText(),tooltip:i.getTooltip(),originalIndex:I,persistentIndex:-1,persistentSelected:undefined,persistentWidth:undefined,tableIndex:undefined};m.getData().items.splice(I,0,M);};c.prototype._onItemPressed=function(e){this._switchMarkedTableItemTo(e.getParameter('listItem'));};c.prototype._onSelectionChange=function(e){var m=this.getModel("$sapmP13nSelectionPanel");var d=m.getData();var t=e.getParameter("listItem");this._switchMarkedTableItemTo(t);this._updateModelItemsPersistentIndex(d);this._updateCounts(d);m.refresh();this._notifyChange();};c.prototype._onSwitchButtonShowSelected=function(){var d=this.getModel("$sapmP13nSelectionPanel").getData();d.showOnlySelectedItems=!d.showOnlySelectedItems;this._switchVisibilityOfUnselectedModelItems();this._filterModelItemsBySearchText();this._scrollToSelectedItem(d.markedTableItem);this._updateControlLogic();this._fnHandleResize();};c.prototype._onExecuteSearch=function(){var d=this.getModel("$sapmP13nSelectionPanel").getData();this._switchVisibilityOfUnselectedModelItems();this._filterModelItemsBySearchText();this._scrollToSelectedItem(d.markedTableItem);this._updateControlLogic();};c.prototype._getColumnsItemByColumnKey=function(s){for(var i=0,d=this.getColumnsItems(),e=d.length;i<e;i++){if(d[i].getColumnKey()===s){return d[i];}}return null;};c.prototype._getModelItemIndexByColumnKey=function(s){var i=-1;this.getModel("$sapmP13nSelectionPanel").getData().items.some(function(m,I){if(m.columnKey===s){i=I;return true;}});return i;};c.prototype._getModelItemByColumnKey=function(s){var m=null;this.getModel("$sapmP13nSelectionPanel").getData().items.some(function(M){if(M.columnKey===s){m=M;return true;}});return m;};c.prototype._getModelItemByTableItem=function(t){var m=null;var i=this._getVisibleTableItems().indexOf(t);this.getModel("$sapmP13nSelectionPanel").getData().items.some(function(M,I){if(i===I){m=M;return true;}});return m;};c.prototype._moveModelItems=function(i,I){var m=this.getModel("$sapmP13nSelectionPanel");var d=m.getData();if(i<0||I<0||i>d.items.length-1||I>d.items.length-1){return false;}var M=d.items.splice(i,1);d.items.splice(I,0,M[0]);this._updateModelItemsPersistentIndex(d);this._updateModelItemsTableIndex(d);this._updateCounts(d);m.refresh();return true;};c.prototype._switchVisibilityOfUnselectedModelItems=function(){var m=this.getModel("$sapmP13nSelectionPanel");var s=this._isFilteredByShowSelected();m.getData().items.forEach(function(M){if(M.persistentSelected){M.visible=true;return;}M.visible=!s;});m.refresh();};c.prototype._getVisibleTableItems=function(){var v=[];this._oTable.getItems().forEach(function(t){if(t.getVisible()){v.push(t);}});return v;};c.prototype._getVisibleModelItems=function(){var v=[];this.getModel("$sapmP13nSelectionPanel").getData().items.forEach(function(m){if(m.visible){v.push(m);}});return v;};c.prototype._getSelectedModelItems=function(){var s=[];this.getModel("$sapmP13nSelectionPanel").getData().items.forEach(function(m){if(m.persistentSelected){s.push(m);}});return s;};c.prototype._updateModelItemsTableIndex=function(d){d.items.forEach(function(m,t){m.tableIndex=t;});};c.prototype._updateModelItemsPersistentIndex=function(d){var p=-1;d.items.forEach(function(m){m.persistentIndex=-1;if(m.persistentSelected){p++;m.persistentIndex=p;}});};c.prototype._updateCounts=function(d){d.countOfSelectedItems=0;d.countOfItems=0;d.items.forEach(function(m){d.countOfItems++;if(m.persistentSelected){d.countOfSelectedItems++;}});};c.prototype._sortModelItemsByPersistentIndex=function(m){};c.prototype._switchMarkedTableItemTo=function(t){var d=this.getModel("$sapmP13nSelectionPanel").getData();if(d.markedTableItem===t){return;}if(d.markedTableItem){d.markedTableItem.removeStyleClass("sapMP13nColumnsPanelItemSelected");}d.indexOfMarkedTableItem=this._getVisibleTableItems().indexOf(t);d.markedTableItem=t;if(d.markedTableItem){d.markedTableItem.addStyleClass("sapMP13nColumnsPanelItemSelected");}this._scrollToSelectedItem(d.markedTableItem);this._updateControlLogic();};c.prototype._createTable=function(){var t=this;this._oTable=new T({mode:sap.m.ListMode.MultiSelect,rememberSelections:false,itemPress:q.proxy(this._onItemPressed,this),selectionChange:q.proxy(this._onSelectionChange,this),columns:[new sap.m.Column({header:new sap.m.Text({text:{parts:[{path:'/countOfSelectedItems'},{path:'/countOfItems'}],formatter:function(i,d){return t._oRb.getText('COLUMNSPANEL_SELECT_ALL_WITH_COUNTER',[i,d]);}}})})],items:{path:"/items",templateShareable:false,template:new sap.m.ColumnListItem({cells:[new sap.m.Text({text:"{text}"})],visible:"{visible}",selected:"{persistentSelected}",tooltip:"{tooltip}",type:sap.m.ListType.Active})}});this._oTable.setModel(this.getModel("$sapmP13nSelectionPanel"));};c.prototype._createToolbar=function(){var t=this;var L=0;var s=new S(this.getId()+"-searchField",{liveChange:function(e){var v=e.getSource().getValue(),d=(v?300:0);window.clearTimeout(L);if(d){L=window.setTimeout(function(){t._onExecuteSearch();},d);}else{t._onExecuteSearch();}},search:q.proxy(this._onExecuteSearch,this),layoutData:new sap.m.OverflowToolbarLayoutData({minWidth:"12.5rem",maxWidth:"23.077rem",shrinkable:true,moveToOverflow:true,priority:sap.m.OverflowToolbarPriority.High})});var o=new sap.m.OverflowToolbar(this.getId()+"-toolbar",{active:true,design:sap.m.ToolbarDesign.Solid,content:[new sap.m.ToolbarSpacer(),s]});this.addAggregation("content",o);};c.prototype._getToolbar=function(){return sap.ui.getCore().byId(this.getId()+"-toolbar")||null;};c.prototype._getSearchField=function(){return sap.ui.getCore().byId(this.getId()+"-searchField")||null;};c.prototype._getSearchText=function(){var s=this._getSearchField();return s?s.getValue():"";};c.prototype._isFilteredBySearchText=function(){return!!this._getSearchText().length;};c.prototype._isFilteredByShowSelected=function(){return this.getModel("$sapmP13nSelectionPanel").getData().showOnlySelectedItems;};c.prototype._isColumnsItemEqualToModelItem=function(o,m){return m.persistentIndex===o.getIndex()&&m.persistentSelected===o.getVisible()&&m.persistentWidth===o.getWidth();};c.prototype._updateControlLogic=function(){var m=this.getModel("$sapmP13nSelectionPanel");var d=m.getData();var i=this._isFilteredBySearchText();var s=this._isFilteredByShowSelected();var v=this._getVisibleTableItems();d.isMoveUpButtonEnabled=v.indexOf(d.markedTableItem)>-1&&d.indexOfMarkedTableItem>0;d.isMoveDownButtonEnabled=v.indexOf(d.markedTableItem)>-1&&d.indexOfMarkedTableItem<v.length-1&&d.indexOfMarkedTableItem>-1;var t=sap.ui.getCore().byId(this._oTable.getId()+'-sa');if(t){t.setEnabled(!i&&!s);}m.refresh();};c.prototype._notifyChange=function(){var L=this.getChangeNotifier();if(L){L(this);}};c.prototype._showAll=function(){q.sap.log.info("ModelItems: columnKey originalIndex  tableIndex_isVisible  persistentIndex_isPersistent        TableItems: current");q.sap.log.info("--------------------------------------------------------------");var d=this.getModel("$sapmP13nSelectionPanel").getData();var t=this._oTable.getItems();var L=Math.max(d.items.length,this._oTable.getItems().length);for(var i=0;i<L;i++){var m=d.items[i];var o=t[i];q.sap.log.info(m.columnKey+": "+m.originalIndex+" "+m.tableIndex+"_"+m.visible+" "+m.persistentIndex+"_"+m.persistentSelected+";  "+o.getCells()[0].getText()+": "+o.getSelected());}};return c;},true);
