/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./library','sap/ui/core/Control','sap/m/GenericTile'],function(q,l,C,G){"use strict";var S=C.extend("sap.m.SlideTile",{metadata:{library:"sap.m",properties:{"displayTime":{type:"int",group:"Appearance",defaultValue:5000},"transitionTime":{type:"int",group:"Appearance",defaultValue:500}},defaultAggregation:"tiles",aggregations:{"tiles":{type:"sap.m.GenericTile",multiple:true,singularName:"tile",bindable:"bindable"},"_pausePlayIcon":{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"}}}});S.prototype.init=function(){this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.m");this.setAggregation("_pausePlayIcon",new sap.ui.core.Icon({id:this.getId()+"-pause-play-icon",src:"sap-icon://media-pause",color:"#ffffff",size:"0.95rem",noTabStop:true}),true);};S.prototype.onBeforeRendering=function(){this._stopAnimation();this._sWidth=this._sHeight=undefined;this._iCurrentTile=this._iPreviousTile=undefined;};S.prototype.onAfterRendering=function(){var c=this.getTiles().length;this._removeGTFocus();this._iCurrAnimationTime=0;this._bAnimationPause=false;this._scrollToNextTile();if(c>1){this._startAnimation();}};S.prototype.exit=function(){this._stopAnimation();};S.prototype.ontap=function(e){if(sap.ui.Device.browser.internet_explorer){this.$().focus();}};S.prototype.ontouchstart=function(e){if(q(e.target).hasClass("sapMSTIconClickTapArea")){this.addStyleClass("sapMSTIconPressed");}else{this.addStyleClass("sapMSTHvr");}};S.prototype.ontouchend=function(e){this.removeStyleClass("sapMSTHvr");};S.prototype.ontouchcancel=function(e){if(this.hasStyleClass("sapMSTIconPressed")){this.removeStyleClass("sapMSTIconPressed");}else{this.removeStyleClass("sapMSTHvr");}};S.prototype.onkeydown=function(e){if(q.sap.PseudoEvents.sapenter.fnCheck(e)){var g=this.getTiles()[this._iCurrentTile];g.onkeydown(e);}};S.prototype.onkeyup=function(e){if(q.sap.PseudoEvents.sapenter.fnCheck(e)){var g=this.getTiles()[this._iCurrentTile];g.onkeyup(e);return;}if(q.sap.PseudoEvents.sapspace.fnCheck(e)){this._toggleAnimation();}if(e.which===q.sap.KeyCodes.B&&this._bAnimationPause){this._scrollToNextTile(true,true);}if(e.which===q.sap.KeyCodes.F&&this._bAnimationPause){this._scrollToNextTile(true,false);}};S.prototype.onmouseup=function(e){if(this.hasStyleClass("sapMSTIconPressed")){this._toggleAnimation();this.removeStyleClass("sapMSTIconPressed");}else if(sap.ui.Device.system.desktop){e.preventDefault();this.getTiles()[this._iCurrentTile].firePress();}};S.prototype.onmousedown=function(e){if(q(e.target).hasClass("sapMSTIconClickTapArea")){this.addStyleClass("sapMSTIconPressed");}};S.prototype.onfocusout=function(e){if(this.getTiles().length>1&&!this._isFocusInsideST()&&this._bAnimationPause){this._startAnimation();this._updatePausePlayIcon();}};S.prototype._isFocusInsideST=function(){return this.$()[0]===document.activeElement||this.$().find(document.activeElement).length;};S.prototype._removeGTFocus=function(){for(var i=0;i<this.getTiles().length;i++){this.getTiles()[i].$().removeAttr("tabindex");}};S.prototype._toggleAnimation=function(){if(this.getTiles().length>1){if(this._bAnimationPause){this._startAnimation();}else{this._stopAnimation();}}this._updatePausePlayIcon();};S.prototype._stopAnimation=function(){this._iCurrAnimationTime+=Date.now()-this._iStartTime;clearTimeout(this._sTimerId);if(this._iCurrentTile!=undefined){var w=this.$("wrapper-"+this._iCurrentTile);w.stop();}if(this._iPreviousTile!=undefined){var W=this.$("wrapper-"+this._iPreviousTile);W.stop();}if(this._iCurrAnimationTime>this.getDisplayTime()){this._scrollToNextTile(true);}this._bAnimationPause=true;};S.prototype._startAnimation=function(){var d=this.getDisplayTime()-this._iCurrAnimationTime;clearTimeout(this._sTimerId);this._sTimerId=setTimeout(function(){this._scrollToNextTile();}.bind(this),d);this._iStartTime=Date.now();this._bAnimationPause=false;};S.prototype._scrollToNextTile=function(p,b){var t=this._iCurrAnimationTime-this.getDisplayTime(),f,n,w,W,s,a,c,d,D,o;t=this.getTransitionTime()-(t>0?t:0);f=t===this.getTransitionTime();if(f){if(b){n=this._getPreviousTileIndex(this._iCurrentTile);}else{n=this._getNextTileIndex(this._iCurrentTile);}this._iPreviousTile=this._iCurrentTile;this._iCurrentTile=n;}W=this.$("wrapper-"+this._iCurrentTile);D=sap.ui.getCore().getConfiguration().getRTL()?"right":"left";if(q.isNumeric(this._iPreviousTile)){w=this.$("wrapper-"+this._iPreviousTile);s=w.css("width");a=parseFloat(W.css("width"));c=parseFloat(s);d=c<a;if(d){this._changeSizeTo(this._iCurrentTile);}if(f){W.css(D,s);}o={};if(b){o[D]=s;}else{o[D]="-"+s;}w.animate(o,{duration:t,done:function(){if(!d){this._changeSizeTo(this._iCurrentTile);}w.css(D,"");}.bind(this)});if(b){o[D]="-"+s;W.animate(o,0);}o[D]="0rem";W.animate(o,{duration:t,done:function(){this._iCurrAnimationTime=0;if(!p){this._startAnimation();}}.bind(this)});}else{this._changeSizeTo(this._iCurrentTile);W.css(D,"0rem");}if(this.getTiles()[this._iCurrentTile]){this._setAriaDescriptor();}this._updateTilesIndicator();};S.prototype._setAriaDescriptor=function(){var t=this._oRb.getText("SLIDETILE_TOGGLE_SLIDING"),T=this.getTiles()[this._iCurrentTile]._getAriaText().replace(/\s/g," ");if(this.getTiles().length>1){T=T+"\n"+t;}this.$().attr("aria-label",T);};S.prototype._changeSizeTo=function(t){var T=this.getTiles()[t];if(!T){return;}if(this._sFrameType){this.$().removeClass(this._sFrameType);}if(this._sSize){this.$().removeClass(this._sSize);}this.$().addClass(T.getFrameType()).addClass(T.getSize());this._sFrameType=T.getFrameType();this._sSize=T.getSize();};S.prototype._getPreviousTileIndex=function(t){if(t>0){return t-1;}else{return this.getTiles().length-1;}};S.prototype._getNextTileIndex=function(t){if(t+1<this.getTiles().length){return t+1;}else{return 0;}};S.prototype._updateTilesIndicator=function(){var $;for(var i=0;i<this.getTiles().length;i++){$=this.$("tileIndicator-"+i);if(i===this._iCurrentTile){$.addClass("sapMSTActive");}else{$.removeClass("sapMSTActive");}}};S.prototype._updatePausePlayIcon=function(){if(this._bAnimationPause){this.getAggregation("_pausePlayIcon").setSrc("sap-icon://media-play");this.$().removeClass("sapMSTPauseIcon");}else{this.getAggregation("_pausePlayIcon").setSrc("sap-icon://media-pause");this.$().addClass("sapMSTPauseIcon");}};return S;},true);
