/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/core/Control','./TimePickerSlidersRenderer','./TimePickerSlider','./VisibleItem'],function(q,C,S,T,V){"use strict";var a=C.extend("sap.m.TimePickerSliders",{metadata:{library:"sap.m",properties:{format:{name:"format",type:"string"},labelText:{name:"labelText",type:"string"},minutesStep:{type:"int",group:"Misc",defaultValue:1},secondsStep:{type:"int",group:"Misc",defaultValue:1}},aggregations:{_columns:{type:"sap.m.TimePickerSlider",multiple:true,visibility:"hidden"}},associations:{invokedBy:{type:"sap.m.TimePicker",multiple:false}}},renderer:S.render});a.prototype.init=function(){var l=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale(),p=sap.ui.core.LocaleData.getInstance(l).getDayPeriods("abbreviated");this._fnLayoutChanged=q.proxy(this._onOrientationChanged,this);sap.ui.Device.resize.attachHandler(this._fnLayoutChanged);this._sAM=p[0];this._sPM=p[1];};a.prototype.exit=function(){this.$().off(!!sap.ui.Device.browser.firefox?"DOMMouseScroll":"mousewheel",this._onmousewheel);sap.ui.Device.resize.detachHandler(this._fnOrientationChanged);};a.prototype.onAfterRendering=function(){this.$().off(!!sap.ui.Device.browser.firefox?"DOMMouseScroll":"mousewheel",this._onmousewheel);this.$().on(!!sap.ui.Device.browser.firefox?"DOMMouseScroll":"mousewheel",q.proxy(this._onmousewheel,this));if(!sap.ui.Device.browser.msie){this._initFocus(true);}};a.prototype.setInvokedBy=function(i){var l,p,c;this.setAssociation("invokedBy",i);if(sap.ui.getCore().byId(i)){l=new sap.ui.core.Locale(sap.ui.getCore().byId(i).getLocaleId());p=sap.ui.core.LocaleData.getInstance(l).getDayPeriods("abbreviated");this._sAM=p[0];this._sPM=p[1];c=this.getAggregation("_columns");if(c){this.destroyAggregation("_columns");}this._setupLists(this.getFormat());}return this;};a.prototype.setLabelText=function(l){var c;this.setProperty("labelText",l,true);if(!sap.ui.Device.system.desktop){c=q(this.getDomRef("label"));if(c){c.html(l);}}return this;};a.prototype.setFormat=function(f){this.setProperty("format",f,true);var c=this.getAggregation("_columns");if(c){this.destroyAggregation("_columns");}this._setupLists(f);return this;};a.prototype.setMinutesStep=function(v){this.setProperty("minutesStep",v,true);var c=this.getAggregation("_columns");if(c){this.destroyAggregation("_columns");}this._setupLists(this.getFormat());return this;};a.prototype.setSecondsStep=function(v){this.setProperty("secondsStep",v,true);var c=this.getAggregation("_columns");if(c){this.destroyAggregation("_columns");}this._setupLists(this.getFormat());return this;};a.prototype.getTimeValues=function(){var c=sap.ui.getCore(),l=c.byId(this.getId()+"-listHours"),L=c.byId(this.getId()+"-listMins"),o=c.byId(this.getId()+"-listSecs"),b=c.byId(this.getId()+"-listFormat"),h=null,A=null,d=new Date();if(l){h=parseInt(l.getSelectedValue(),10);}if(b){A=b.getSelectedValue();}if(A==="am"&&h===12){h=0;}else if(A==="pm"&&h!==12){h+=12;}if(h!==null){d.setHours(h.toString());}if(L){d.setMinutes(L.getSelectedValue());}if(o){d.setSeconds(o.getSelectedValue());}return d;};a.prototype.setTimeValues=function(d){var c=sap.ui.getCore(),l=c.byId(this.getId()+"-listHours"),L=c.byId(this.getId()+"-listMins"),o=c.byId(this.getId()+"-listSecs"),b=c.byId(this.getId()+"-listFormat"),h,A=null;d=d||new Date();h=d.getHours();if(b){A=h>=12?"pm":"am";h=(h>12)?h-12:h;h=(h===0?12:h);}l&&l.setSelectedValue(h.toString());L&&L._updateStepAndValue(d.getMinutes(),this.getMinutesStep());o&&o._updateStepAndValue(d.getSeconds(),this.getSecondsStep());b&&b.setSelectedValue(A);};a.prototype.collapseAll=function(){var s=this.getAggregation("_columns");if(s){for(var i=0;i<s.length;i++){if(s[i].getIsExpanded()){s[i].setIsExpanded(false);}}}};a.prototype.updateSlidersValues=function(){var s=this.getAggregation("_columns");if(s){for(var i=0;i<s.length;i++){s[i]._updateScroll();}}};a.prototype.onsaphome=function(e){var c=this._getCurrentSlider();if(c&&document.activeElement===c.getDomRef()){this.getAggregation("_columns")[0].focus();}};a.prototype.onsapend=function(e){var c=this._getCurrentSlider();if(c&&document.activeElement===c.getDomRef()){var s=this.getAggregation("_columns");s[s.length-1].focus();}};a.prototype.onsapleft=function(e){var c=this._getCurrentSlider(),i=-1,n=-1,s=this.getAggregation("_columns");if(c&&document.activeElement===c.getDomRef()){i=s.indexOf(c);n=i>0?i-1:s.length-1;s[n].focus();}};a.prototype.onsapright=function(e){var c=this._getCurrentSlider(),i=-1,n=-1,s=this.getAggregation("_columns");if(c&&document.activeElement===c.getDomRef()){i=s.indexOf(c);n=i<s.length-1?i+1:0;s[n].focus();}};a.prototype._onmousewheel=function(e){var c=this._getCurrentSlider();if(c){c._onmousewheel(e);}};a.prototype._onOrientationChanged=function(){var s=this.getAggregation("_columns");if(!s){return;}for(var i=0;i<s.length;i++){if(s[i].getIsExpanded()){s[i]._updateSelectionFrameLayout();}}};a.prototype._initFocus=function(s){if(sap.ui.Device.system.desktop&&!s){this.getAggregation("_columns")[0].focus();}else{this.getAggregation("_columns")[0].setIsExpanded(true);}};a.prototype._generatePickerListValues=function(f,t,s,l){var v=[],b;for(var i=f;i<=t;i+=1){if(i<10&&l){b="0"+i.toString();}else{b=i.toString();}var I=new V({key:i.toString(),text:b});if(i%s!==0){I.setVisible(false);}v.push(I);}return v;};a.prototype._setupLists=function(f){var r=sap.ui.getCore().getLibraryResourceBundle("sap.m"),l=r.getText("TIMEPICKER_LBL_HOURS"),L=r.getText("TIMEPICKER_LBL_MINUTES"),s=r.getText("TIMEPICKER_LBL_SECONDS"),b=r.getText("TIMEPICKER_LBL_AMPM"),m=this.getMinutesStep(),c=this.getSecondsStep();if(f===undefined){return;}var h=false,H=false,F,t;if(f.indexOf("HH")!==-1){h=true;F=0;t=23;H=true;}else if(f.indexOf("H")!==-1){h=true;F=0;t=23;}else if(f.indexOf("hh")!==-1){h=true;F=1;t=12;H=true;}else if(f.indexOf("h")!==-1){h=true;F=1;t=12;}if(h){this.addAggregation("_columns",new T(this.getId()+"-listHours",{items:this._generatePickerListValues(F,t,1,H),expanded:q.proxy(o,this),label:l}));}if(f.indexOf("m")!==-1){var v=this._generatePickerListValues(0,59,m,true);this.addAggregation("_columns",new T(this.getId()+"-listMins",{items:v,expanded:q.proxy(o,this),label:L}));}if(f.indexOf("s")!==-1){var v=this._generatePickerListValues(0,59,c,true);this.addAggregation("_columns",new T(this.getId()+"-listSecs",{items:v,expanded:q.proxy(o,this),label:s}));}if(f.indexOf("a")!==-1){this.addAggregation("_columns",new T(this.getId()+"-listFormat",{items:[{key:"am",text:this._sAM},{key:"pm",text:this._sPM}],expanded:q.proxy(o,this),label:b,isCyclic:false}).addStyleClass("sapMTimePickerSliderShort"));}this.getAggregation("_columns")[0].setIsExpanded(true);function o(e){var d=this.getAggregation("_columns");for(var i=0;i<d.length;i++){if(d[i]!==e.oSource&&d[i].getIsExpanded()){d[i].setIsExpanded(false);}}}};a.prototype._getCurrentSlider=function(){var s=this.getAggregation("_columns");if(s){for(var i=0;i<s.length;i++){if(s[i].getIsExpanded()){return s[i];}}}return null;};return a;},false);
