/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/base/EventProvider","sap/ui/fl/Utils","sap/ui/fl/registry/Settings"],function(E,U,S){"use strict";var C=function(f){E.apply(this);if(typeof(f)!=="object"){U.log.error("Constructor : sap.ui.fl.Change : oFile is not defined");}this._oDefinition=f;this._oOriginDefinition=JSON.parse(JSON.stringify(f));this._sRequest='';this._bIsDeleted=false;this._bUserDependent=(f.layer==="USER");};C.events={markForDeletion:"markForDeletion"};C.prototype=jQuery.sap.newObject(E.prototype);C.prototype.isValid=function(){var i=true;if(typeof(this._oDefinition)!=="object"){i=false;}if(!this._oDefinition.fileType){i=false;}if(!this._oDefinition.fileName){i=false;}if(!this._oDefinition.changeType){i=false;}if(!this._oDefinition.layer){i=false;}if(!this._oDefinition.originalLanguage){i=false;}return i;};C.prototype.isVariant=function(){return this._oDefinition.fileType==="variant";};C.prototype.getChangeType=function(){if(this._oDefinition){return this._oDefinition.changeType;}};C.prototype.getOriginalLanguage=function(){if(this._oDefinition&&this._oDefinition.originalLanguage){return this._oDefinition.originalLanguage;}return"";};C.prototype.getContext=function(){if(this._oDefinition&&this._oDefinition.context){return this._oDefinition.context;}return"";};C.prototype.getPackage=function(){return this._oDefinition.packageName;};C.prototype.getNamespace=function(){return this._oDefinition.namespace;};C.prototype.getId=function(){return this._oDefinition.fileName;};C.prototype.getContent=function(){return this._oDefinition.content;};C.prototype.setContent=function(c){this._oDefinition.content=c;};C.prototype.getSelector=function(){return this._oDefinition.selector;};C.prototype.getText=function(t){if(typeof(t)!=="string"){U.log.error("sap.ui.fl.Change.getTexts : sTextId is not defined");}if(this._oDefinition.texts){if(this._oDefinition.texts[t]){return this._oDefinition.texts[t].value;}}return"";};C.prototype.setText=function(t,n){if(typeof(t)!=="string"){U.log.error("sap.ui.fl.Change.setTexts : sTextId is not defined");return;}if(this._oDefinition.texts){if(this._oDefinition.texts[t]){this._oDefinition.texts[t].value=n;}}};C.prototype.isReadOnly=function(){var i=this._isReadOnlyDueToLayer();if(!i){i=this._isReadOnlyWhenNotKeyUser();}return i;};C.prototype._isReadOnlyWhenNotKeyUser=function(){var i=false;if(!this.isUserDependent()){var r=this.getDefinition().reference;if(r){var s=S.getInstanceOrUndef(r);if(s){var I=s.isKeyUser();if(I===false){i=true;}}}}return i;};C.prototype.isLabelReadOnly=function(){if(this._isReadOnlyDueToLayer()){return true;}return this._isReadOnlyDueToOriginalLanguage();};C.prototype._isReadOnlyDueToLayer=function(){var c;c=U.getCurrentLayer(this._bUserDependent);return(this._oDefinition.layer!==c);};C.prototype._isReadOnlyDueToOriginalLanguage=function(){var c,o;o=this.getOriginalLanguage();if(!o){return false;}c=U.getCurrentLanguage();return(c!==o);};C.prototype.markForDeletion=function(){this._bIsDeleted=true;};C.prototype._isDirty=function(){var c=JSON.stringify(this._oDefinition);var o=JSON.stringify(this._oOriginDefinition);return(c!==o);};C.prototype.setRequest=function(r){if(typeof(r)!=="string"){U.log.error("sap.ui.fl.Change.setRequest : sRequest is not defined");}this._sRequest=r;};C.prototype.getRequest=function(){return this._sRequest;};C.prototype.getLayer=function(){return this._oDefinition.layer;};C.prototype.getComponent=function(){return this._oDefinition.reference;};C.prototype.getCreation=function(){return this._oDefinition.creation;};C.prototype.isUserDependent=function(){return(this._bUserDependent);};C.prototype.getPendingAction=function(){if(this._bIsDeleted){return"DELETE";}else if(!this._oDefinition.creation){return"NEW";}else if(this._isDirty()===true){return"UPDATE";}return"NONE";};C.prototype.getDefinition=function(){return this._oDefinition;};C.prototype.setResponse=function(r){var R=JSON.stringify(r);if(R){this._oDefinition=JSON.parse(R);this._oOriginDefinition=JSON.parse(R);}};C.prototype.getFullFileIdentifier=function(){var l=this.getLayer();var n=this.getNamespace();var f=this.getDefinition().fileName;var F=this.getDefinition().fileType;return l+"/"+n+"/"+f+"."+F;};C.prototype.addDependentControl=function(c,a,p,A){if(!c){throw new Error("Parameter vControl is mandatory");}if(!a){throw new Error("Parameter sAlias is mandatory");}if(!p){throw new Error("Parameter mPropertyBag is mandatory");}if(!this._oDefinition.dependentSelector){this._oDefinition.dependentSelector={};}if(this._oDefinition.dependentSelector[a]){throw new Error("Alias '"+a+"' already exists in the change.");}var m=p.modifier;var o=p.appComponent;if(Array.isArray(c)){var s=[];c.forEach(function(b){s.push(m.getSelector(b,o,A));});this._oDefinition.dependentSelector[a]=s;}else{this._oDefinition.dependentSelector[a]=m.getSelector(c,o,A);}delete this._aDependentIdList;};C.prototype.getDependentControl=function(a,p){var d=[];var D;if(!a){throw new Error("Parameter sAlias is mandatory");}if(!p){throw new Error("Parameter mPropertyBag is mandatory");}var m=p.modifier;var A=p.appComponent;if(!this._oDefinition.dependentSelector){return undefined;}D=this._oDefinition.dependentSelector[a];if(Array.isArray(D)){D.forEach(function(s){d.push(m.bySelector(s,A));});return d;}else{return m.bySelector(D,A);}};C.prototype.getDependentIdList=function(a){var t=this;var i;var d=[];var D=[];if(!this._aDependentIdList){if(!this._oDefinition.dependentSelector){this._aDependentIdList=[];}else{Object.keys(this._oDefinition.dependentSelector).forEach(function(p){d.push(t._oDefinition.dependentSelector[p]);});d=[].concat.apply([],d);d.forEach(function(o){i=o.id;if(o.idIsLocal){i=a.createId(o.id);}D.push(i);});this._aDependentIdList=D;}}return this._aDependentIdList;};C.prototype.getKey=function(){return this._oDefinition.fileName+this._oDefinition.layer+this._oDefinition.namespace;};C.createInitialFileContent=function(p){if(!p){p={};}var n={fileName:p.id||U.createDefaultFileName(p.changeType),fileType:(p.isVariant)?"variant":"change",changeType:p.changeType||"",reference:p.reference||"",packageName:p.packageName||"",content:p.content||{},selector:p.selector||{},layer:p.layer||U.getCurrentLayer(p.isUserDependent),texts:p.texts||{},namespace:U.createNamespace(p,"changes"),creation:"",originalLanguage:U.getCurrentLanguage(),conditions:{},context:p.context||"",support:{generator:"Change.createInitialFileContent",service:p.service||"",user:"",sapui5Version:sap.ui.version},dependentSelector:p.dependentSelector||{}};return n;};return C;},true);
