/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/fl/Utils","jquery.sap.global","sap/ui/fl/registry/ChangeRegistryItem","sap/ui/fl/registry/ChangeTypeMetadata","sap/ui/fl/registry/Settings","sap/ui/fl/changeHandler/HideControl","sap/ui/fl/changeHandler/MoveElements","sap/ui/fl/changeHandler/MoveControls","sap/ui/fl/changeHandler/PropertyChange","sap/ui/fl/changeHandler/PropertyBindingChange","sap/ui/fl/changeHandler/UnhideControl","sap/ui/fl/changeHandler/StashControl","sap/ui/fl/changeHandler/UnstashControl"],function(U,q,C,a,S,H,M,b,P,c,d,e,f){"use strict";var g=function(){this._registeredItems={};this.initSettings();this.initDefaultActiveHandlers();};g._instance=undefined;g.prototype._oDefaultActiveChangeHandlers={};g.prototype._oDefaultChangeHandlers={"hideControl":H,"moveElements":M,"moveControls":b,"propertyChange":P,"propertyBindingChange":c,"unhideControl":d,"stashControl":e,"unstashControl":f};g.prototype.initDefaultHandler=function(s,o){var h={changeType:s,changeHandler:o};var i=this._createChangeRegistryItemForSimpleChange("defaultActiveForAllControls",h);this._oDefaultActiveChangeHandlers[s]=i;};g.prototype.initDefaultActiveHandlers=function(){this.initDefaultHandler("propertyChange",P);this.initDefaultHandler("propertyBindingChange",c);};g.getInstance=function(){if(!g._instance){g._instance=new g();}return g._instance;};g.prototype.hasRegisteredChangeHandlersForControl=function(s){var h=Object.keys(this._registeredItems);return h.indexOf(s)!==-1;};g.prototype.hasChangeHandlerForControlAndChange=function(s,h){if(!this.hasRegisteredChangeHandlersForControl(s)){return false;}var r=this._registeredItems[s];var i=Object.keys(r);return i.indexOf(h)!==-1;};g.prototype.registerControlsForChanges=function(m){var t=this;q.each(m,function(s,h){if(Array.isArray(h)){var o={};h.forEach(function(i){o[i.changeType]=i.changeHandler;});t._registerChangeHandlersForControl(s,o);}else{t._registerChangeHandlersForControl(s,h);}});};g.prototype._registerChangeHandlersForControl=function(s,o){var t=this;q.each(o,function(h,i){var j=t._getChangeHandler(h,i);var k={"changeType":h,"changeHandler":j};t.registerControlForSimpleChange(s,k);});};g.prototype._getChangeHandler=function(s,h){if(h==="default"){return this._oDefaultChangeHandlers[s];}else{return h;}};g.prototype.registerControlForSimpleChange=function(s,o){var h;if(!s){return;}if(!o||!o.changeType||!o.changeHandler){return;}h=this._createChangeRegistryItemForSimpleChange(s,o);if(h){this.addRegistryItem(h);}};g.prototype._createChangeRegistryItemForSimpleChange=function(s,o){var p,h,i;p={name:o.changeType,changeHandler:o.changeHandler};h=new a(p);p={changeTypeMetadata:h,controlType:s};i=new C(p);return i;};g.prototype.addRegistryItem=function(r){var s,h;if(!r){return;}s=r.getChangeTypeName();h=r.getControlType();this._registeredItems[h]=this._registeredItems[h]||{};this._registeredItems[h][s]=r;};g.prototype.removeRegistryItem=function(p){if(!p.changeTypeName&&!p.controlType){U.log.error("sap.ui.fl.registry.ChangeRegistry: ChangeType and/or ControlType required");return;}if(p.controlType&&p.changeTypeName){if(this._registeredItems[p.controlType]){if(Object.keys(this._registeredItems[p.controlType]).length===1){delete this._registeredItems[p.controlType];}else{delete this._registeredItems[p.controlType][p.changeTypeName];}}}else if(p.controlType){if(this._registeredItems[p.controlType]){delete this._registeredItems[p.controlType];}}else if(p.changeTypeName){for(var h in this._registeredItems){var i=this._registeredItems[h];delete i[p.changeTypeName];}}};g.prototype.getRegistryItems=function(p){var t=this;if(!p){U.log.error("sap.ui.fl.registry.ChangeRegistry: no parameters passed for getRegistryItems");}var s=p.changeTypeName;var h=p.controlType;if(!s&&!h){U.log.error("sap.ui.fl.registry.ChangeRegistry: Change Type Name and/or Control Type required");}var r=null;if(h&&s){var o=this._getOrLoadChangeHandler(h,s);if(o){r={};r[h]={};r[h][s]=o;}}else if(h){if(this._registeredItems[h]){r={};r[h]={};var i=Object.keys(this._registeredItems[h]);i.forEach(function(s){r[h][s]=t._getOrLoadChangeHandler(h,s);});}}else if(s){r={};for(h in this._registeredItems){if(this._registeredItems[h][s]){r[h]={};r[h][s]=t._getOrLoadChangeHandler(h,s);}}}this._filterChangeTypes(r,p.layer);return r;};g.prototype._getOrLoadChangeHandler=function(s,h){var o=this._registeredItems[s];if(o){var i=o[h];if(i){var j=i.getChangeTypeMetadata();var k=j.getChangeHandler();if(typeof k==="string"){q.sap.require(k);k=sap.ui.require(k);j._changeHandler=k;}return i;}}var D=this._oDefaultActiveChangeHandlers[h];if(D){return D;}return null;};g.prototype.initSettings=function(s){this._oSettings=S.getInstanceOrUndef(s);if(!this._oSettings){this._oSettings=new S({});}};g.prototype._filterChangeTypes=function(r,l){if(this._oSettings&&l&&r){var t=this;q.each(r,function(s,o){q.each(o,function(h,R){var i=t._oSettings.isChangeTypeEnabled(h,l);if(!i){U.log.warning("Change type "+h+" not enabled for layer "+l);delete o[h];}});});}};g.prototype.getDragInfo=function(s){var h=this._registeredItems[s];if(h){return h.getDragInfo();}return null;};return g;},true);
